# coding: utf-8

"""
    HubDB endpoints

    HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `published` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the published version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.cms.hubdb.configuration import Configuration


class HubDbTableV3Request(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "label": "str",
        "use_for_pages": "bool",
        "allow_public_api_access": "bool",
        "allow_child_tables": "bool",
        "enable_child_table_pages": "bool",
        "columns": "list[ColumnRequest]",
        "dynamic_meta_tags": "dict(str, int)",
    }

    attribute_map = {
        "name": "name",
        "label": "label",
        "use_for_pages": "useForPages",
        "allow_public_api_access": "allowPublicApiAccess",
        "allow_child_tables": "allowChildTables",
        "enable_child_table_pages": "enableChildTablePages",
        "columns": "columns",
        "dynamic_meta_tags": "dynamicMetaTags",
    }

    def __init__(
        self,
        name=None,
        label=None,
        use_for_pages=None,
        allow_public_api_access=None,
        allow_child_tables=None,
        enable_child_table_pages=None,
        columns=None,
        dynamic_meta_tags=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """HubDbTableV3Request - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._label = None
        self._use_for_pages = None
        self._allow_public_api_access = None
        self._allow_child_tables = None
        self._enable_child_table_pages = None
        self._columns = None
        self._dynamic_meta_tags = None
        self.discriminator = None

        self.name = name
        self.label = label
        if use_for_pages is not None:
            self.use_for_pages = use_for_pages
        if allow_public_api_access is not None:
            self.allow_public_api_access = allow_public_api_access
        if allow_child_tables is not None:
            self.allow_child_tables = allow_child_tables
        if enable_child_table_pages is not None:
            self.enable_child_table_pages = enable_child_table_pages
        if columns is not None:
            self.columns = columns
        if dynamic_meta_tags is not None:
            self.dynamic_meta_tags = dynamic_meta_tags

    @property
    def name(self):
        """Gets the name of this HubDbTableV3Request.  # noqa: E501

        Name of the table  # noqa: E501

        :return: The name of this HubDbTableV3Request.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this HubDbTableV3Request.

        Name of the table  # noqa: E501

        :param name: The name of this HubDbTableV3Request.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def label(self):
        """Gets the label of this HubDbTableV3Request.  # noqa: E501

        Label of the table  # noqa: E501

        :return: The label of this HubDbTableV3Request.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this HubDbTableV3Request.

        Label of the table  # noqa: E501

        :param label: The label of this HubDbTableV3Request.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and label is None:  # noqa: E501
            raise ValueError("Invalid value for `label`, must not be `None`")  # noqa: E501

        self._label = label

    @property
    def use_for_pages(self):
        """Gets the use_for_pages of this HubDbTableV3Request.  # noqa: E501

        Specifies whether the table can be used for creation of dynamic pages  # noqa: E501

        :return: The use_for_pages of this HubDbTableV3Request.  # noqa: E501
        :rtype: bool
        """
        return self._use_for_pages

    @use_for_pages.setter
    def use_for_pages(self, use_for_pages):
        """Sets the use_for_pages of this HubDbTableV3Request.

        Specifies whether the table can be used for creation of dynamic pages  # noqa: E501

        :param use_for_pages: The use_for_pages of this HubDbTableV3Request.  # noqa: E501
        :type: bool
        """

        self._use_for_pages = use_for_pages

    @property
    def allow_public_api_access(self):
        """Gets the allow_public_api_access of this HubDbTableV3Request.  # noqa: E501

        Specifies whether the table can be read by public without authorization  # noqa: E501

        :return: The allow_public_api_access of this HubDbTableV3Request.  # noqa: E501
        :rtype: bool
        """
        return self._allow_public_api_access

    @allow_public_api_access.setter
    def allow_public_api_access(self, allow_public_api_access):
        """Sets the allow_public_api_access of this HubDbTableV3Request.

        Specifies whether the table can be read by public without authorization  # noqa: E501

        :param allow_public_api_access: The allow_public_api_access of this HubDbTableV3Request.  # noqa: E501
        :type: bool
        """

        self._allow_public_api_access = allow_public_api_access

    @property
    def allow_child_tables(self):
        """Gets the allow_child_tables of this HubDbTableV3Request.  # noqa: E501

        Specifies whether child tables can be created  # noqa: E501

        :return: The allow_child_tables of this HubDbTableV3Request.  # noqa: E501
        :rtype: bool
        """
        return self._allow_child_tables

    @allow_child_tables.setter
    def allow_child_tables(self, allow_child_tables):
        """Sets the allow_child_tables of this HubDbTableV3Request.

        Specifies whether child tables can be created  # noqa: E501

        :param allow_child_tables: The allow_child_tables of this HubDbTableV3Request.  # noqa: E501
        :type: bool
        """

        self._allow_child_tables = allow_child_tables

    @property
    def enable_child_table_pages(self):
        """Gets the enable_child_table_pages of this HubDbTableV3Request.  # noqa: E501

        Specifies creation of multi-level dynamic pages using child tables  # noqa: E501

        :return: The enable_child_table_pages of this HubDbTableV3Request.  # noqa: E501
        :rtype: bool
        """
        return self._enable_child_table_pages

    @enable_child_table_pages.setter
    def enable_child_table_pages(self, enable_child_table_pages):
        """Sets the enable_child_table_pages of this HubDbTableV3Request.

        Specifies creation of multi-level dynamic pages using child tables  # noqa: E501

        :param enable_child_table_pages: The enable_child_table_pages of this HubDbTableV3Request.  # noqa: E501
        :type: bool
        """

        self._enable_child_table_pages = enable_child_table_pages

    @property
    def columns(self):
        """Gets the columns of this HubDbTableV3Request.  # noqa: E501

        List of columns in the table  # noqa: E501

        :return: The columns of this HubDbTableV3Request.  # noqa: E501
        :rtype: list[ColumnRequest]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Sets the columns of this HubDbTableV3Request.

        List of columns in the table  # noqa: E501

        :param columns: The columns of this HubDbTableV3Request.  # noqa: E501
        :type: list[ColumnRequest]
        """

        self._columns = columns

    @property
    def dynamic_meta_tags(self):
        """Gets the dynamic_meta_tags of this HubDbTableV3Request.  # noqa: E501

        Specifies the key value pairs of the metadata fields with the associated column ids  # noqa: E501

        :return: The dynamic_meta_tags of this HubDbTableV3Request.  # noqa: E501
        :rtype: dict(str, int)
        """
        return self._dynamic_meta_tags

    @dynamic_meta_tags.setter
    def dynamic_meta_tags(self, dynamic_meta_tags):
        """Sets the dynamic_meta_tags of this HubDbTableV3Request.

        Specifies the key value pairs of the metadata fields with the associated column ids  # noqa: E501

        :param dynamic_meta_tags: The dynamic_meta_tags of this HubDbTableV3Request.  # noqa: E501
        :type: dict(str, int)
        """

        self._dynamic_meta_tags = dynamic_meta_tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item, value.items()))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HubDbTableV3Request):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HubDbTableV3Request):
            return True

        return self.to_dict() != other.to_dict()
