# coding: utf-8

"""
    Custom Workflow Actions

    Create custom workflow actions  # noqa: E501

    The version of the OpenAPI document: v4
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.automation.actions.api_client import ApiClient
from hubspot.automation.actions.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class FunctionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive(self, definition_id, function_type, function_id, app_id, **kwargs):  # noqa: E501
        """Delete a custom action function  # noqa: E501

        Delete a function for a custom workflow action. This will remove the function itself as well as removing the association between the function and the custom action. This can't be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive(definition_id, function_type, function_id, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param str function_id: The ID qualifier for the function. This is used to specify which input field a function is associated with for `PRE_FETCH_OPTIONS` and `POST_FETCH_OPTIONS` function types. (required)
        :param int app_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_with_http_info(definition_id, function_type, function_id, app_id, **kwargs)  # noqa: E501

    def archive_with_http_info(self, definition_id, function_type, function_id, app_id, **kwargs):  # noqa: E501
        """Delete a custom action function  # noqa: E501

        Delete a function for a custom workflow action. This will remove the function itself as well as removing the association between the function and the custom action. This can't be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_with_http_info(definition_id, function_type, function_id, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param str function_id: The ID qualifier for the function. This is used to specify which input field a function is associated with for `PRE_FETCH_OPTIONS` and `POST_FETCH_OPTIONS` function types. (required)
        :param int app_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["definition_id", "function_type", "function_id", "app_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method archive" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'definition_id' is set
        if self.api_client.client_side_validation and ("definition_id" not in local_var_params or local_var_params["definition_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `definition_id` when calling `archive`")  # noqa: E501
        # verify the required parameter 'function_type' is set
        if self.api_client.client_side_validation and ("function_type" not in local_var_params or local_var_params["function_type"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_type` when calling `archive`")  # noqa: E501
        # verify the required parameter 'function_id' is set
        if self.api_client.client_side_validation and ("function_id" not in local_var_params or local_var_params["function_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_id` when calling `archive`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ("app_id" not in local_var_params or local_var_params["app_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `archive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "definition_id" in local_var_params:
            path_params["definitionId"] = local_var_params["definition_id"]  # noqa: E501
        if "function_type" in local_var_params:
            path_params["functionType"] = local_var_params["function_type"]  # noqa: E501
        if "function_id" in local_var_params:
            path_params["functionId"] = local_var_params["function_id"]  # noqa: E501
        if "app_id" in local_var_params:
            path_params["appId"] = local_var_params["app_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["developer_hapikey"]  # noqa: E501

        return self.api_client.call_api(
            "/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}/{functionId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def archive_by_function_type(self, definition_id, function_type, app_id, **kwargs):  # noqa: E501
        """Delete a custom action function  # noqa: E501

        Delete a function for a custom workflow action. This will remove the function itself as well as removing the association between the function and the custom action. This can't be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_by_function_type(definition_id, function_type, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param int app_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_by_function_type_with_http_info(definition_id, function_type, app_id, **kwargs)  # noqa: E501

    def archive_by_function_type_with_http_info(self, definition_id, function_type, app_id, **kwargs):  # noqa: E501
        """Delete a custom action function  # noqa: E501

        Delete a function for a custom workflow action. This will remove the function itself as well as removing the association between the function and the custom action. This can't be undone.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_by_function_type_with_http_info(definition_id, function_type, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param int app_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["definition_id", "function_type", "app_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method archive_by_function_type" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'definition_id' is set
        if self.api_client.client_side_validation and ("definition_id" not in local_var_params or local_var_params["definition_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `definition_id` when calling `archive_by_function_type`")  # noqa: E501
        # verify the required parameter 'function_type' is set
        if self.api_client.client_side_validation and ("function_type" not in local_var_params or local_var_params["function_type"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_type` when calling `archive_by_function_type`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ("app_id" not in local_var_params or local_var_params["app_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `archive_by_function_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "definition_id" in local_var_params:
            path_params["definitionId"] = local_var_params["definition_id"]  # noqa: E501
        if "function_type" in local_var_params:
            path_params["functionType"] = local_var_params["function_type"]  # noqa: E501
        if "app_id" in local_var_params:
            path_params["appId"] = local_var_params["app_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["developer_hapikey"]  # noqa: E501

        return self.api_client.call_api(
            "/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_or_replace(self, definition_id, function_type, function_id, app_id, body, **kwargs):  # noqa: E501
        """Create or replace a custom action function  # noqa: E501

        Creates or replaces a function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_replace(definition_id, function_type, function_id, app_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param str function_id: The ID qualifier for the function. This is used to specify which input field a function is associated with for `PRE_FETCH_OPTIONS` and `POST_FETCH_OPTIONS` function types. (required)
        :param int app_id: (required)
        :param str body: The function source code. Must be valid JavaScript code. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActionFunctionIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_or_replace_with_http_info(definition_id, function_type, function_id, app_id, body, **kwargs)  # noqa: E501

    def create_or_replace_with_http_info(self, definition_id, function_type, function_id, app_id, body, **kwargs):  # noqa: E501
        """Create or replace a custom action function  # noqa: E501

        Creates or replaces a function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_replace_with_http_info(definition_id, function_type, function_id, app_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param str function_id: The ID qualifier for the function. This is used to specify which input field a function is associated with for `PRE_FETCH_OPTIONS` and `POST_FETCH_OPTIONS` function types. (required)
        :param int app_id: (required)
        :param str body: The function source code. Must be valid JavaScript code. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActionFunctionIdentifier, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["definition_id", "function_type", "function_id", "app_id", "body"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method create_or_replace" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'definition_id' is set
        if self.api_client.client_side_validation and ("definition_id" not in local_var_params or local_var_params["definition_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `definition_id` when calling `create_or_replace`")  # noqa: E501
        # verify the required parameter 'function_type' is set
        if self.api_client.client_side_validation and ("function_type" not in local_var_params or local_var_params["function_type"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_type` when calling `create_or_replace`")  # noqa: E501
        # verify the required parameter 'function_id' is set
        if self.api_client.client_side_validation and ("function_id" not in local_var_params or local_var_params["function_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_id` when calling `create_or_replace`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ("app_id" not in local_var_params or local_var_params["app_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `create_or_replace`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ("body" not in local_var_params or local_var_params["body"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_or_replace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "definition_id" in local_var_params:
            path_params["definitionId"] = local_var_params["definition_id"]  # noqa: E501
        if "function_type" in local_var_params:
            path_params["functionType"] = local_var_params["function_type"]  # noqa: E501
        if "function_id" in local_var_params:
            path_params["functionId"] = local_var_params["function_id"]  # noqa: E501
        if "app_id" in local_var_params:
            path_params["appId"] = local_var_params["app_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["text/plain"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["developer_hapikey"]  # noqa: E501

        return self.api_client.call_api(
            "/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}/{functionId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ActionFunctionIdentifier",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_or_replace_by_function_type(self, definition_id, function_type, app_id, body, **kwargs):  # noqa: E501
        """Create or replace a custom action function  # noqa: E501

        Creates or replaces a function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_replace_by_function_type(definition_id, function_type, app_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param int app_id: (required)
        :param str body: The function source code. Must be valid JavaScript code. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActionFunctionIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_or_replace_by_function_type_with_http_info(definition_id, function_type, app_id, body, **kwargs)  # noqa: E501

    def create_or_replace_by_function_type_with_http_info(self, definition_id, function_type, app_id, body, **kwargs):  # noqa: E501
        """Create or replace a custom action function  # noqa: E501

        Creates or replaces a function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_replace_by_function_type_with_http_info(definition_id, function_type, app_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param int app_id: (required)
        :param str body: The function source code. Must be valid JavaScript code. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActionFunctionIdentifier, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["definition_id", "function_type", "app_id", "body"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method create_or_replace_by_function_type" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'definition_id' is set
        if self.api_client.client_side_validation and ("definition_id" not in local_var_params or local_var_params["definition_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `definition_id` when calling `create_or_replace_by_function_type`")  # noqa: E501
        # verify the required parameter 'function_type' is set
        if self.api_client.client_side_validation and ("function_type" not in local_var_params or local_var_params["function_type"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_type` when calling `create_or_replace_by_function_type`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ("app_id" not in local_var_params or local_var_params["app_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `create_or_replace_by_function_type`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ("body" not in local_var_params or local_var_params["body"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_or_replace_by_function_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "definition_id" in local_var_params:
            path_params["definitionId"] = local_var_params["definition_id"]  # noqa: E501
        if "function_type" in local_var_params:
            path_params["functionType"] = local_var_params["function_type"]  # noqa: E501
        if "app_id" in local_var_params:
            path_params["appId"] = local_var_params["app_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["text/plain"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["developer_hapikey"]  # noqa: E501

        return self.api_client.call_api(
            "/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ActionFunctionIdentifier",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_function_type(self, definition_id, function_type, app_id, **kwargs):  # noqa: E501
        """Get a custom action function  # noqa: E501

        Returns the given function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_function_type(definition_id, function_type, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param int app_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActionFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_function_type_with_http_info(definition_id, function_type, app_id, **kwargs)  # noqa: E501

    def get_by_function_type_with_http_info(self, definition_id, function_type, app_id, **kwargs):  # noqa: E501
        """Get a custom action function  # noqa: E501

        Returns the given function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_function_type_with_http_info(definition_id, function_type, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param int app_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActionFunction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["definition_id", "function_type", "app_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_by_function_type" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'definition_id' is set
        if self.api_client.client_side_validation and ("definition_id" not in local_var_params or local_var_params["definition_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `definition_id` when calling `get_by_function_type`")  # noqa: E501
        # verify the required parameter 'function_type' is set
        if self.api_client.client_side_validation and ("function_type" not in local_var_params or local_var_params["function_type"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_type` when calling `get_by_function_type`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ("app_id" not in local_var_params or local_var_params["app_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_by_function_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "definition_id" in local_var_params:
            path_params["definitionId"] = local_var_params["definition_id"]  # noqa: E501
        if "function_type" in local_var_params:
            path_params["functionType"] = local_var_params["function_type"]  # noqa: E501
        if "app_id" in local_var_params:
            path_params["appId"] = local_var_params["app_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["developer_hapikey"]  # noqa: E501

        return self.api_client.call_api(
            "/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ActionFunction",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_id(self, definition_id, function_type, function_id, app_id, **kwargs):  # noqa: E501
        """Get a custom action function  # noqa: E501

        Returns the given function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id(definition_id, function_type, function_id, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param str function_id: The ID qualifier for the function. This is used to specify which input field a function is associated with for `PRE_FETCH_OPTIONS` and `POST_FETCH_OPTIONS` function types. (required)
        :param int app_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActionFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_id_with_http_info(definition_id, function_type, function_id, app_id, **kwargs)  # noqa: E501

    def get_by_id_with_http_info(self, definition_id, function_type, function_id, app_id, **kwargs):  # noqa: E501
        """Get a custom action function  # noqa: E501

        Returns the given function for a custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id_with_http_info(definition_id, function_type, function_id, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param str function_type: The type of function. This determines when the function will be called. (required)
        :param str function_id: The ID qualifier for the function. This is used to specify which input field a function is associated with for `PRE_FETCH_OPTIONS` and `POST_FETCH_OPTIONS` function types. (required)
        :param int app_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActionFunction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["definition_id", "function_type", "function_id", "app_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_by_id" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'definition_id' is set
        if self.api_client.client_side_validation and ("definition_id" not in local_var_params or local_var_params["definition_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `definition_id` when calling `get_by_id`")  # noqa: E501
        # verify the required parameter 'function_type' is set
        if self.api_client.client_side_validation and ("function_type" not in local_var_params or local_var_params["function_type"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_type` when calling `get_by_id`")  # noqa: E501
        # verify the required parameter 'function_id' is set
        if self.api_client.client_side_validation and ("function_id" not in local_var_params or local_var_params["function_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `function_id` when calling `get_by_id`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ("app_id" not in local_var_params or local_var_params["app_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "definition_id" in local_var_params:
            path_params["definitionId"] = local_var_params["definition_id"]  # noqa: E501
        if "function_type" in local_var_params:
            path_params["functionType"] = local_var_params["function_type"]  # noqa: E501
        if "function_id" in local_var_params:
            path_params["functionId"] = local_var_params["function_id"]  # noqa: E501
        if "app_id" in local_var_params:
            path_params["appId"] = local_var_params["app_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["developer_hapikey"]  # noqa: E501

        return self.api_client.call_api(
            "/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}/{functionId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ActionFunction",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_page(self, definition_id, app_id, **kwargs):  # noqa: E501
        """Get all custom action functions  # noqa: E501

        Returns a list of all functions that are associated with the given custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page(definition_id, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param int app_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseActionFunctionIdentifierNoPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_page_with_http_info(definition_id, app_id, **kwargs)  # noqa: E501

    def get_page_with_http_info(self, definition_id, app_id, **kwargs):  # noqa: E501
        """Get all custom action functions  # noqa: E501

        Returns a list of all functions that are associated with the given custom workflow action.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_page_with_http_info(definition_id, app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str definition_id: The ID of the custom workflow action. (required)
        :param int app_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseActionFunctionIdentifierNoPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["definition_id", "app_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_page" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'definition_id' is set
        if self.api_client.client_side_validation and ("definition_id" not in local_var_params or local_var_params["definition_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `definition_id` when calling `get_page`")  # noqa: E501
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ("app_id" not in local_var_params or local_var_params["app_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_page`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "definition_id" in local_var_params:
            path_params["definitionId"] = local_var_params["definition_id"]  # noqa: E501
        if "app_id" in local_var_params:
            path_params["appId"] = local_var_params["app_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["developer_hapikey"]  # noqa: E501

        return self.api_client.call_api(
            "/automation/v4/actions/{appId}/{definitionId}/functions",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseActionFunctionIdentifierNoPaging",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
