# coding: utf-8

"""
    SatNOGS Network

    SatNOGS Network is a web application, implementing a global scheduling and monitoring network for ground station operations.  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsnetworkapiclient.api_client import ApiClient, Endpoint
from satnogsnetworkapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsnetworkapiclient.model.inline_response200 import InlineResponse200
from satnogsnetworkapiclient.model.inline_response2001 import InlineResponse2001
from satnogsnetworkapiclient.model.inline_response2002 import InlineResponse2002
from satnogsnetworkapiclient.model.unknownbasetype import UNKNOWNBASETYPE


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_observation(
            self,
            **kwargs
        ):
            """create_observation  # noqa: E501

            Creates observations from a list of observation data  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_observation(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                unknown_base_type (UNKNOWN_BASE_TYPE): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_observation = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/observations/',
                'operation_id': 'create_observation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'unknown_base_type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'unknown_base_type':
                        (UNKNOWN_BASE_TYPE,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'unknown_base_type': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__create_observation
        )

        def __list_jobs(
            self,
            **kwargs
        ):
            """list_jobs  # noqa: E501

            SatNOGS Network Job API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_jobs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                id (str): id. [optional]
                status (str): status. [optional]
                ground_station (str): ground_station. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                transmitter_uuid (str): transmitter_uuid. [optional]
                transmitter_mode (str): transmitter_mode. [optional]
                transmitter_type (str): transmitter_type. [optional]
                waterfall_status (str): waterfall_status. [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (str): Vetted user (deprecated: will be removed in next version). [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [object]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_jobs = Endpoint(
            settings={
                'response_type': ([object],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/jobs/',
                'operation_id': 'list_jobs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'status',
                    'ground_station',
                    'start',
                    'end',
                    'satellite__norad_cat_id',
                    'transmitter_uuid',
                    'transmitter_mode',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                    'vetted_user',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "FUTURE": "future",
                        "GOOD": "good"
                    },
                    ('transmitter_type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('waterfall_status',): {

                        "1": "1",
                        "0": "0"
                    },
                    ('vetted_status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "GOOD": "good"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'status':
                        (str,),
                    'ground_station':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'transmitter_mode':
                        (str,),
                    'transmitter_type':
                        (str,),
                    'waterfall_status':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'status': 'status',
                    'ground_station': 'ground_station',
                    'start': 'start',
                    'end': 'end',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'transmitter_uuid': 'transmitter_uuid',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'waterfall_status': 'waterfall_status',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                },
                'location_map': {
                    'id': 'query',
                    'status': 'query',
                    'ground_station': 'query',
                    'start': 'query',
                    'end': 'query',
                    'satellite__norad_cat_id': 'query',
                    'transmitter_uuid': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'waterfall_status': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_jobs
        )

        def __list_observations(
            self,
            **kwargs
        ):
            """list_observations  # noqa: E501

            SatNOGS Network Observation API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_observations(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page (int): A page number within the paginated result set.. [optional]
                id (str): id. [optional]
                status (str): status. [optional]
                ground_station (str): ground_station. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                transmitter_uuid (str): transmitter_uuid. [optional]
                transmitter_mode (str): transmitter_mode. [optional]
                transmitter_type (str): transmitter_type. [optional]
                waterfall_status (str): waterfall_status. [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (str): Vetted user (deprecated: will be removed in next version). [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse200
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_observations = Endpoint(
            settings={
                'response_type': (InlineResponse200,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/observations/',
                'operation_id': 'list_observations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'id',
                    'status',
                    'ground_station',
                    'start',
                    'end',
                    'satellite__norad_cat_id',
                    'transmitter_uuid',
                    'transmitter_mode',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                    'vetted_user',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "FUTURE": "future",
                        "GOOD": "good"
                    },
                    ('transmitter_type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('waterfall_status',): {

                        "1": "1",
                        "0": "0"
                    },
                    ('vetted_status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "GOOD": "good"
                    },
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'id':
                        (str,),
                    'status':
                        (str,),
                    'ground_station':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'transmitter_mode':
                        (str,),
                    'transmitter_type':
                        (str,),
                    'waterfall_status':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'id': 'id',
                    'status': 'status',
                    'ground_station': 'ground_station',
                    'start': 'start',
                    'end': 'end',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'transmitter_uuid': 'transmitter_uuid',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'waterfall_status': 'waterfall_status',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                },
                'location_map': {
                    'page': 'query',
                    'id': 'query',
                    'status': 'query',
                    'ground_station': 'query',
                    'start': 'query',
                    'end': 'query',
                    'satellite__norad_cat_id': 'query',
                    'transmitter_uuid': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'waterfall_status': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_observations
        )

        def __list_stations(
            self,
            **kwargs
        ):
            """list_stations  # noqa: E501

            SatNOGS Network Station API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_stations(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page (int): A page number within the paginated result set.. [optional]
                id (str): id. [optional]
                name (str): name. [optional]
                status (str): status. [optional]
                client_version (str): client_version. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse2001
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_stations = Endpoint(
            settings={
                'response_type': (InlineResponse2001,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/stations/',
                'operation_id': 'list_stations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'id',
                    'name',
                    'status',
                    'client_version',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "2": "2",
                        "1": "1",
                        "0": "0"
                    },
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'id':
                        (str,),
                    'name':
                        (str,),
                    'status':
                        (str,),
                    'client_version':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'id': 'id',
                    'name': 'name',
                    'status': 'status',
                    'client_version': 'client_version',
                },
                'location_map': {
                    'page': 'query',
                    'id': 'query',
                    'name': 'query',
                    'status': 'query',
                    'client_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_stations
        )

        def __list_transmitters(
            self,
            **kwargs
        ):
            """list_transmitters  # noqa: E501

            SatNOGS Network Transmitter API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_transmitters(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page (int): A page number within the paginated result set.. [optional]
                uuid (str): uuid. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse2002
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_transmitters = Endpoint(
            settings={
                'response_type': (InlineResponse2002,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/transmitters/',
                'operation_id': 'list_transmitters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'uuid',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'uuid':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'uuid': 'uuid',
                },
                'location_map': {
                    'page': 'query',
                    'uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_transmitters
        )

        def __partial_update_observation(
            self,
            id,
            **kwargs
        ):
            """partial_update_observation  # noqa: E501

            SatNOGS Network Observation API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.partial_update_observation(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this observation.

            Keyword Args:
                id2 (str): id. [optional]
                status (str): status. [optional]
                ground_station (str): ground_station. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                transmitter_uuid (str): transmitter_uuid. [optional]
                transmitter_mode (str): transmitter_mode. [optional]
                transmitter_type (str): transmitter_type. [optional]
                waterfall_status (str): waterfall_status. [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (str): Vetted user (deprecated: will be removed in next version). [optional]
                unknown_base_type (UNKNOWN_BASE_TYPE): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.partial_update_observation = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'partial_update_observation',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'id2',
                    'status',
                    'ground_station',
                    'start',
                    'end',
                    'satellite__norad_cat_id',
                    'transmitter_uuid',
                    'transmitter_mode',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                    'vetted_user',
                    'unknown_base_type',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "FUTURE": "future",
                        "GOOD": "good"
                    },
                    ('transmitter_type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('waterfall_status',): {

                        "1": "1",
                        "0": "0"
                    },
                    ('vetted_status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "GOOD": "good"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'id2':
                        (str,),
                    'status':
                        (str,),
                    'ground_station':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'transmitter_mode':
                        (str,),
                    'transmitter_type':
                        (str,),
                    'waterfall_status':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (str,),
                    'unknown_base_type':
                        (UNKNOWN_BASE_TYPE,),
                },
                'attribute_map': {
                    'id': 'id',
                    'id2': 'id',
                    'status': 'status',
                    'ground_station': 'ground_station',
                    'start': 'start',
                    'end': 'end',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'transmitter_uuid': 'transmitter_uuid',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'waterfall_status': 'waterfall_status',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                },
                'location_map': {
                    'id': 'path',
                    'id2': 'query',
                    'status': 'query',
                    'ground_station': 'query',
                    'start': 'query',
                    'end': 'query',
                    'satellite__norad_cat_id': 'query',
                    'transmitter_uuid': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'waterfall_status': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                    'unknown_base_type': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__partial_update_observation
        )

        def __retrieve_job(
            self,
            id,
            **kwargs
        ):
            """retrieve_job  # noqa: E501

            SatNOGS Network Job API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_job(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this observation.

            Keyword Args:
                id2 (str): id. [optional]
                status (str): status. [optional]
                ground_station (str): ground_station. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                transmitter_uuid (str): transmitter_uuid. [optional]
                transmitter_mode (str): transmitter_mode. [optional]
                transmitter_type (str): transmitter_type. [optional]
                waterfall_status (str): waterfall_status. [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (str): Vetted user (deprecated: will be removed in next version). [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.retrieve_job = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/',
                'operation_id': 'retrieve_job',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'id2',
                    'status',
                    'ground_station',
                    'start',
                    'end',
                    'satellite__norad_cat_id',
                    'transmitter_uuid',
                    'transmitter_mode',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                    'vetted_user',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "FUTURE": "future",
                        "GOOD": "good"
                    },
                    ('transmitter_type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('waterfall_status',): {

                        "1": "1",
                        "0": "0"
                    },
                    ('vetted_status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "GOOD": "good"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'id2':
                        (str,),
                    'status':
                        (str,),
                    'ground_station':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'transmitter_mode':
                        (str,),
                    'transmitter_type':
                        (str,),
                    'waterfall_status':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'id2': 'id',
                    'status': 'status',
                    'ground_station': 'ground_station',
                    'start': 'start',
                    'end': 'end',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'transmitter_uuid': 'transmitter_uuid',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'waterfall_status': 'waterfall_status',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                },
                'location_map': {
                    'id': 'path',
                    'id2': 'query',
                    'status': 'query',
                    'ground_station': 'query',
                    'start': 'query',
                    'end': 'query',
                    'satellite__norad_cat_id': 'query',
                    'transmitter_uuid': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'waterfall_status': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_job
        )

        def __retrieve_observation(
            self,
            id,
            **kwargs
        ):
            """retrieve_observation  # noqa: E501

            SatNOGS Network Observation API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_observation(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this observation.

            Keyword Args:
                id2 (str): id. [optional]
                status (str): status. [optional]
                ground_station (str): ground_station. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                transmitter_uuid (str): transmitter_uuid. [optional]
                transmitter_mode (str): transmitter_mode. [optional]
                transmitter_type (str): transmitter_type. [optional]
                waterfall_status (str): waterfall_status. [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (str): Vetted user (deprecated: will be removed in next version). [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.retrieve_observation = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'retrieve_observation',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'id2',
                    'status',
                    'ground_station',
                    'start',
                    'end',
                    'satellite__norad_cat_id',
                    'transmitter_uuid',
                    'transmitter_mode',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                    'vetted_user',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "FUTURE": "future",
                        "GOOD": "good"
                    },
                    ('transmitter_type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('waterfall_status',): {

                        "1": "1",
                        "0": "0"
                    },
                    ('vetted_status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "GOOD": "good"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'id2':
                        (str,),
                    'status':
                        (str,),
                    'ground_station':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'transmitter_mode':
                        (str,),
                    'transmitter_type':
                        (str,),
                    'waterfall_status':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'id2': 'id',
                    'status': 'status',
                    'ground_station': 'ground_station',
                    'start': 'start',
                    'end': 'end',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'transmitter_uuid': 'transmitter_uuid',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'waterfall_status': 'waterfall_status',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                },
                'location_map': {
                    'id': 'path',
                    'id2': 'query',
                    'status': 'query',
                    'ground_station': 'query',
                    'start': 'query',
                    'end': 'query',
                    'satellite__norad_cat_id': 'query',
                    'transmitter_uuid': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'waterfall_status': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_observation
        )

        def __retrieve_station(
            self,
            id,
            **kwargs
        ):
            """retrieve_station  # noqa: E501

            SatNOGS Network Station API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_station(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this station.

            Keyword Args:
                id2 (str): id. [optional]
                name (str): name. [optional]
                status (str): status. [optional]
                client_version (str): client_version. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.retrieve_station = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/stations/{id}/',
                'operation_id': 'retrieve_station',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'id2',
                    'name',
                    'status',
                    'client_version',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "2": "2",
                        "1": "1",
                        "0": "0"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'id2':
                        (str,),
                    'name':
                        (str,),
                    'status':
                        (str,),
                    'client_version':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'id2': 'id',
                    'name': 'name',
                    'status': 'status',
                    'client_version': 'client_version',
                },
                'location_map': {
                    'id': 'path',
                    'id2': 'query',
                    'name': 'query',
                    'status': 'query',
                    'client_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_station
        )

        def __retrieve_transmitter(
            self,
            transmitter_uuid,
            **kwargs
        ):
            """retrieve_transmitter  # noqa: E501

            SatNOGS Network Transmitter API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_transmitter(transmitter_uuid, async_req=True)
            >>> result = thread.get()

            Args:
                transmitter_uuid (str):

            Keyword Args:
                uuid (str): uuid. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['transmitter_uuid'] = \
                transmitter_uuid
            return self.call_with_http_info(**kwargs)

        self.retrieve_transmitter = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/transmitters/{transmitter_uuid}/',
                'operation_id': 'retrieve_transmitter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transmitter_uuid',
                    'uuid',
                ],
                'required': [
                    'transmitter_uuid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transmitter_uuid':
                        (str,),
                    'uuid':
                        (str,),
                },
                'attribute_map': {
                    'transmitter_uuid': 'transmitter_uuid',
                    'uuid': 'uuid',
                },
                'location_map': {
                    'transmitter_uuid': 'path',
                    'uuid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_transmitter
        )

        def __update_observation(
            self,
            id,
            **kwargs
        ):
            """update_observation  # noqa: E501

            Updates observation with audio, waterfall or demoded data  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_observation(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this observation.

            Keyword Args:
                id2 (str): id. [optional]
                status (str): status. [optional]
                ground_station (str): ground_station. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                transmitter_uuid (str): transmitter_uuid. [optional]
                transmitter_mode (str): transmitter_mode. [optional]
                transmitter_type (str): transmitter_type. [optional]
                waterfall_status (str): waterfall_status. [optional]
                vetted_status (str): Vetted status (deprecated: please use Status). [optional]
                vetted_user (str): Vetted user (deprecated: will be removed in next version). [optional]
                unknown_base_type (UNKNOWN_BASE_TYPE): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.update_observation = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'update_observation',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'id2',
                    'status',
                    'ground_station',
                    'start',
                    'end',
                    'satellite__norad_cat_id',
                    'transmitter_uuid',
                    'transmitter_mode',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                    'vetted_user',
                    'unknown_base_type',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'waterfall_status',
                    'vetted_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "FUTURE": "future",
                        "GOOD": "good"
                    },
                    ('transmitter_type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('waterfall_status',): {

                        "1": "1",
                        "0": "0"
                    },
                    ('vetted_status',): {

                        "FAILED": "failed",
                        "BAD": "bad",
                        "UNKNOWN": "unknown",
                        "GOOD": "good"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'id2':
                        (str,),
                    'status':
                        (str,),
                    'ground_station':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'transmitter_mode':
                        (str,),
                    'transmitter_type':
                        (str,),
                    'waterfall_status':
                        (str,),
                    'vetted_status':
                        (str,),
                    'vetted_user':
                        (str,),
                    'unknown_base_type':
                        (UNKNOWN_BASE_TYPE,),
                },
                'attribute_map': {
                    'id': 'id',
                    'id2': 'id',
                    'status': 'status',
                    'ground_station': 'ground_station',
                    'start': 'start',
                    'end': 'end',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'transmitter_uuid': 'transmitter_uuid',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'waterfall_status': 'waterfall_status',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                },
                'location_map': {
                    'id': 'path',
                    'id2': 'query',
                    'status': 'query',
                    'ground_station': 'query',
                    'start': 'query',
                    'end': 'query',
                    'satellite__norad_cat_id': 'query',
                    'transmitter_uuid': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'waterfall_status': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                    'unknown_base_type': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__update_observation
        )
