import sys
import os
import time

from requests.exceptions import RequestException
import requests as request

sys.path.insert(0, os.path.abspath(os.path.join(__file__, "../api", "..")))
sys.path.insert(0, os.path.abspath(os.path.join(__file__, "../api", "..", "..", "..")))
from netskope_api.iterator.operation import Operation
from requests.auth import AuthBase
from netskope_api.iterator.const import Const

import logging


logger = logging.getLogger()


class AuthToken(AuthBase):
    """Netskope-API-Token Auth for header token."""

    def __init__(self, token):
        """Initialize the object."""
        self.token = token

    def __call__(self, req):
        """Set Netskope-Api-Token in request"""
        req.headers["Netskope-Api-Token"] = "{}".format(self.token)
        return req


class NetskopeIteratorClient:
    """Iterator client for netskope event downloads"""

    def __init__(self,params):
        """

        :param params:
        """

        configs = {
            "base_url": "https://{}".format(params.get(Const.NSKP_TENANT_HOSTNAME)),
            "iterator_name": params.get(Const.NSKP_ITERATOR_NAME),
            "eventtype" : params.get(Const.NSKP_EVENT_TYPE),
            "alerttype": params.get(Const.NSKP_ALERT_TYPE)
        }
        self.token = params.get(Const.NSKP_TOKEN)
        self.user_agent = params.get(Const.NSKP_USER_AGENT)

        if not self.user_agent:
            self.user_agent = "DataExport-Iterator-{}".format(params.get(Const.NSKP_TENANT_HOSTNAME))

        headers = {
            "User-Agent": self.user_agent
        }

        self.configs = configs
        self.session = request.Session()
        self.session.headers.update(headers)
        self.session.proxies = params.get(Const.NSKP_PROXIES)
        self.session.auth = AuthToken(self.token)
        self.session.hooks['response'].append(self.response_hook)

    def response_hook(self, res, *args, **kwargs):
        """
        :param res:
        :param args:
        :param kwargs:
        :return:
        """
        try:
            data = res.json()
        except Exception:
            if "429 Too Many Requests" in res.text:
                raise RequestException(res.text)
            return res

        #TODO Based on the response value the client side sleep will be introduced.

        return res

    # Construct the url as per the operation.
    def build_url(self, op):
        """

        :param op : Operation to be invoked:
        :return The Iterator API to be called:
        """
        base_url = self.configs.get("base_url")
        event_type = self.configs.get("eventtype")
        alert_type = self.configs.get("alerttype")
        iterator_name = self.configs.get("iterator_name")

        if alert_type and event_type == Const.EVENT_TYPE_ALERT:
            # If the query is to download the alerts specific to the alert_type
            url = "{}/api/v2/events/dataexport/alerts/{}?index={}&operation={}".format(base_url,alert_type,iterator_name,op)
        else:
            url = "{}/api/v2/events/dataexport/events/{}?index={}&operation={}".format(base_url,event_type,iterator_name,op)
        return url


    # Download the response based on the operation.
    def get(self, operation):
        """
        :param operation: Operation to be invoked
        :return Response objects for the operation.
        """

        op = self.validate_and_return_operation(operation)
        url = self.build_url(op)
        res = self.session.get(url=url, timeout=120)
        self.honor_rate_limiting(res.headers)
        return res

    def honor_rate_limiting(self, headers):
        """
        Identify the response headers carrying the rate limiting value.
        If the rate limit remaining for this endpoint is 0 then wait for the rate limit reset time before sending the response to the client.
        """
        try:
            if Const.RATELIMIT_REMAINING in headers:
                remaining = headers[Const.RATELIMIT_REMAINING]
                if int(remaining) <= 0:
                    logging.warning("Rate limiting reached for the endpoint config {} ".format(self.configs))
                    if Const.RATELIMIT_RESET in headers:
                        time.sleep(int(headers[Const.RATELIMIT_RESET]))
                    else:
                        # if the RESET value does not exist in the header then
                        # sleep for default 1 second as the rate limit remaining is 0
                        time.sleep(1)
        except ValueError as ve:
            logging.error("Value error when honoring the rate limiting wait time {} {}".format(headers,str(ve)))


    def validate_and_return_operation(self, op):
        """
        Raise an exception if the iterator operation is not valid.
        The operation can be: next, head, tail, resend, or a timestamp value.
        """
        if op in (Operation.OP_HEAD, Operation.OP_TAIL, Operation.OP_NEXT, Operation.OP_RESEND):
            return op.value

        try:
            return int(op)
        except Exception as e:
            raise ValueError("Invalid iterator operation: {}".format(op))

        if ts < 0:
            raise ValueError("Invalid iterator operation as timestamp: {}".format(op))
