# Table of Contents

* [toc4github Intro](#toc4github-Intro)
* [Install](#Install)
* [Command Line](#Command-Line)
* [Interface](#Interface)
* [Screenshot](#Screenshot)

# toc4github Intro

A tiny tool to automatically generate Table of Contents (TOC) for
markdown file, like README.md of Github.com. It might also be used
for other markdown rendering system, but I never tested!:)

# Install

``` shell
$ pip3 install toc4github
```

# Command Line

Insert a placeholder `{toc}` in a proper line of README.md. The
placeholder itself should be single line, and it most likely be
at the beginning of markdown file. This is the start position
of TOC section, then run:

``` shell
$ python3 -m toc4github [--dryrun|-d] [--title|-t] <path/to/README.md>
```

Now, the placeholder line is replaced and expanded by TOC,
your markdown file is updated.

You can use `--dryrun(-d)` to check the generated TOC first, this option
would only print out TOC, file is intact and nothing is changed.

`--title(-t)` option is used if you need a title for TOC section.
The title is always `Table of Contents`, just like this README.md file.

Here is an example:

``` shell
$ python3 -m toc4github -dt text.txt
# Table of Contents

* [Hello](#Hello)
    * [Past 过去](#Past-过去)
    * [Present 现在](#Present-现在)
        * [Item-1](#Item-1)
        * [Item-2](#Item-2)
        * [Item-3](#Item-3)
        * [Item-4](#Item-4)
    * [Future 未来](#Future-未来)
    * [中英文can mix哦](#中英文can-mix哦)
```

# Interface

Or, you can call `make_toc` interface in your python code like:

``` python
>>> with open('text.txt') as f:
...     lines = f.read()
...
>>> print(lines)
{toc}

# Hello

Hi, here is a test.

## Past 过去

Past is full of bloody experiences and cheerful memories.

## Present 现在

Present is the only thing you have.

### Item-1

TODO

### Item-2

### Item-3

### Item-4

## Future 未来

Future is created by your imagination.

## 中英文can mix哦

>>> from toc4github import make_toc
>>> print(make_toc(lines))
* [Hello](#Hello)
    * [Past 过去](#Past-过去)
    * [Present 现在](#Present-现在)
        * [Item-1](#Item-1)
        * [Item-2](#Item-2)
        * [Item-3](#Item-3)
        * [Item-4](#Item-4)
    * [Future 未来](#Future-未来)
    * [中英文can mix哦](#中英文can-mix哦)
>>>
```

Interface `make_toc` only return the generated TOC, and you should
insert it to your file anywhere you like by yourself. And this
is the only interface toc4github provides, and no other parameters.

# Screenshot

![toc4github](/screenshot.png)

In addition, All my repos' TOC are generated by toc4github.
Have fun ... ^___^

