# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from clusterfuzz._internal.protos import untrusted_runner_pb2 as clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2


class UntrustedRunnerStub(object):
    """UntrusterRunner service.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetStatus = channel.unary_unary(
                '/UntrustedRunner/GetStatus',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetStatusRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetStatusResponse.FromString,
                )
        self.SetupRegularBuild = channel.unary_unary(
                '/UntrustedRunner/SetupRegularBuild',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SetupRegularBuildRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SetupBuildResponse.FromString,
                )
        self.RunProcess = channel.unary_unary(
                '/UntrustedRunner/RunProcess',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunProcessRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunProcessResponse.FromString,
                )
        self.RunAndWait = channel.unary_unary(
                '/UntrustedRunner/RunAndWait',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunAndWaitRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunAndWaitResponse.FromString,
                )
        self.CreateDirectory = channel.unary_unary(
                '/UntrustedRunner/CreateDirectory',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CreateDirectoryRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CreateDirectoryResponse.FromString,
                )
        self.RemoveDirectory = channel.unary_unary(
                '/UntrustedRunner/RemoveDirectory',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RemoveDirectoryRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RemoveDirectoryResponse.FromString,
                )
        self.ListFiles = channel.unary_unary(
                '/UntrustedRunner/ListFiles',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ListFilesRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ListFilesResponse.FromString,
                )
        self.CopyFileTo = channel.stream_unary(
                '/UntrustedRunner/CopyFileTo',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.FileChunk.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CopyFileToResponse.FromString,
                )
        self.CopyFileFrom = channel.unary_stream(
                '/UntrustedRunner/CopyFileFrom',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CopyFileFromRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.FileChunk.FromString,
                )
        self.Stat = channel.unary_unary(
                '/UntrustedRunner/Stat',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.StatRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.StatResponse.FromString,
                )
        self.UpdateEnvironment = channel.unary_unary(
                '/UntrustedRunner/UpdateEnvironment',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateEnvironmentRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateEnvironmentResponse.FromString,
                )
        self.ResetEnvironment = channel.unary_unary(
                '/UntrustedRunner/ResetEnvironment',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ResetEnvironmentRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ResetEnvironmentResponse.FromString,
                )
        self.UpdateSource = channel.unary_unary(
                '/UntrustedRunner/UpdateSource',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateSourceRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateSourceResponse.FromString,
                )
        self.SymbolizeStacktrace = channel.unary_unary(
                '/UntrustedRunner/SymbolizeStacktrace',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SymbolizeStacktraceRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SymbolizeStacktraceResponse.FromString,
                )
        self.TerminateStaleApplicationInstances = channel.unary_unary(
                '/UntrustedRunner/TerminateStaleApplicationInstances',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.TerminateStaleApplicationInstancesRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.TerminateStaleApplicationInstancesResponse.FromString,
                )
        self.GetFuzzTargets = channel.unary_unary(
                '/UntrustedRunner/GetFuzzTargets',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetFuzzTargetsRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetFuzzTargetsResponse.FromString,
                )
        self.PruneCorpus = channel.unary_unary(
                '/UntrustedRunner/PruneCorpus',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.PruneCorpusRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.PruneCorpusResponse.FromString,
                )
        self.ProcessTestcase = channel.unary_unary(
                '/UntrustedRunner/ProcessTestcase',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ProcessTestcaseRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceResult.FromString,
                )
        self.EngineFuzz = channel.unary_unary(
                '/UntrustedRunner/EngineFuzz',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineFuzzRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineFuzzResponse.FromString,
                )
        self.EngineReproduce = channel.unary_unary(
                '/UntrustedRunner/EngineReproduce',
                request_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceRequest.SerializeToString,
                response_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceResult.FromString,
                )


class UntrustedRunnerServicer(object):
    """UntrusterRunner service.
    """

    def GetStatus(self, request, context):
        """Get information about the worker.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetupRegularBuild(self, request, context):
        """Set up regular build.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RunProcess(self, request, context):
        """Run command using process_handler.runProcess
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RunAndWait(self, request, context):
        """Run command using new_process.ProcessRunner
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateDirectory(self, request, context):
        """Create a directory.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveDirectory(self, request, context):
        """Remove a directory.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListFiles(self, request, context):
        """List files in a directory.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CopyFileTo(self, request_iterator, context):
        """Copy file from host to worker.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CopyFileFrom(self, request, context):
        """Copy file from worker to host.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Stat(self, request, context):
        """Call stat() on a path.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateEnvironment(self, request, context):
        """Environment variable changes.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ResetEnvironment(self, request, context):
        """Reset environment variables.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateSource(self, request, context):
        """Update source.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SymbolizeStacktrace(self, request, context):
        """Symbolize a stacktrace.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def TerminateStaleApplicationInstances(self, request, context):
        """Terminate stale application instances.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFuzzTargets(self, request, context):
        """libFuzzer/AFL specific: get list of fuzz targets.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PruneCorpus(self, request, context):
        """libFuzzer specific: corpus pruning
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ProcessTestcase(self, request, context):
        """Engine specific: Do testcase minimization or cleanse.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EngineFuzz(self, request, context):
        """Engine specific: Do fuzzing.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EngineReproduce(self, request, context):
        """Engine specific: Do reproduction.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_UntrustedRunnerServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.GetStatus,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetStatusRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetStatusResponse.SerializeToString,
            ),
            'SetupRegularBuild': grpc.unary_unary_rpc_method_handler(
                    servicer.SetupRegularBuild,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SetupRegularBuildRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SetupBuildResponse.SerializeToString,
            ),
            'RunProcess': grpc.unary_unary_rpc_method_handler(
                    servicer.RunProcess,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunProcessRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunProcessResponse.SerializeToString,
            ),
            'RunAndWait': grpc.unary_unary_rpc_method_handler(
                    servicer.RunAndWait,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunAndWaitRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunAndWaitResponse.SerializeToString,
            ),
            'CreateDirectory': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateDirectory,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CreateDirectoryRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CreateDirectoryResponse.SerializeToString,
            ),
            'RemoveDirectory': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveDirectory,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RemoveDirectoryRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RemoveDirectoryResponse.SerializeToString,
            ),
            'ListFiles': grpc.unary_unary_rpc_method_handler(
                    servicer.ListFiles,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ListFilesRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ListFilesResponse.SerializeToString,
            ),
            'CopyFileTo': grpc.stream_unary_rpc_method_handler(
                    servicer.CopyFileTo,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.FileChunk.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CopyFileToResponse.SerializeToString,
            ),
            'CopyFileFrom': grpc.unary_stream_rpc_method_handler(
                    servicer.CopyFileFrom,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CopyFileFromRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.FileChunk.SerializeToString,
            ),
            'Stat': grpc.unary_unary_rpc_method_handler(
                    servicer.Stat,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.StatRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.StatResponse.SerializeToString,
            ),
            'UpdateEnvironment': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateEnvironment,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateEnvironmentRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateEnvironmentResponse.SerializeToString,
            ),
            'ResetEnvironment': grpc.unary_unary_rpc_method_handler(
                    servicer.ResetEnvironment,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ResetEnvironmentRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ResetEnvironmentResponse.SerializeToString,
            ),
            'UpdateSource': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateSource,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateSourceRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateSourceResponse.SerializeToString,
            ),
            'SymbolizeStacktrace': grpc.unary_unary_rpc_method_handler(
                    servicer.SymbolizeStacktrace,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SymbolizeStacktraceRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SymbolizeStacktraceResponse.SerializeToString,
            ),
            'TerminateStaleApplicationInstances': grpc.unary_unary_rpc_method_handler(
                    servicer.TerminateStaleApplicationInstances,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.TerminateStaleApplicationInstancesRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.TerminateStaleApplicationInstancesResponse.SerializeToString,
            ),
            'GetFuzzTargets': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFuzzTargets,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetFuzzTargetsRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetFuzzTargetsResponse.SerializeToString,
            ),
            'PruneCorpus': grpc.unary_unary_rpc_method_handler(
                    servicer.PruneCorpus,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.PruneCorpusRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.PruneCorpusResponse.SerializeToString,
            ),
            'ProcessTestcase': grpc.unary_unary_rpc_method_handler(
                    servicer.ProcessTestcase,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ProcessTestcaseRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceResult.SerializeToString,
            ),
            'EngineFuzz': grpc.unary_unary_rpc_method_handler(
                    servicer.EngineFuzz,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineFuzzRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineFuzzResponse.SerializeToString,
            ),
            'EngineReproduce': grpc.unary_unary_rpc_method_handler(
                    servicer.EngineReproduce,
                    request_deserializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceRequest.FromString,
                    response_serializer=clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceResult.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'UntrustedRunner', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class UntrustedRunner(object):
    """UntrusterRunner service.
    """

    @staticmethod
    def GetStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/GetStatus',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetStatusRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetupRegularBuild(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/SetupRegularBuild',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SetupRegularBuildRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SetupBuildResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RunProcess(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/RunProcess',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunProcessRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunProcessResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RunAndWait(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/RunAndWait',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunAndWaitRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RunAndWaitResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CreateDirectory(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/CreateDirectory',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CreateDirectoryRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CreateDirectoryResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RemoveDirectory(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/RemoveDirectory',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RemoveDirectoryRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.RemoveDirectoryResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListFiles(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/ListFiles',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ListFilesRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ListFilesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CopyFileTo(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(request_iterator, target, '/UntrustedRunner/CopyFileTo',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.FileChunk.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CopyFileToResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CopyFileFrom(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/UntrustedRunner/CopyFileFrom',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.CopyFileFromRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.FileChunk.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Stat(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/Stat',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.StatRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.StatResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateEnvironment(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/UpdateEnvironment',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateEnvironmentRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateEnvironmentResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ResetEnvironment(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/ResetEnvironment',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ResetEnvironmentRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ResetEnvironmentResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateSource(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/UpdateSource',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateSourceRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.UpdateSourceResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SymbolizeStacktrace(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/SymbolizeStacktrace',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SymbolizeStacktraceRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.SymbolizeStacktraceResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def TerminateStaleApplicationInstances(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/TerminateStaleApplicationInstances',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.TerminateStaleApplicationInstancesRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.TerminateStaleApplicationInstancesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetFuzzTargets(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/GetFuzzTargets',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetFuzzTargetsRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.GetFuzzTargetsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def PruneCorpus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/PruneCorpus',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.PruneCorpusRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.PruneCorpusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ProcessTestcase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/ProcessTestcase',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.ProcessTestcaseRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceResult.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EngineFuzz(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/EngineFuzz',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineFuzzRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineFuzzResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EngineReproduce(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/UntrustedRunner/EngineReproduce',
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceRequest.SerializeToString,
            clusterfuzz_dot___internal_dot_protos_dot_untrusted__runner__pb2.EngineReproduceResult.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
