"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesCluster = exports.KubernetesClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "KubernetesClusterProperty", { enumerable: true, get: function () { return cs_generated_1.RosKubernetesCluster; } });
/**
 * A ROS resource type:  `ALIYUN::CS::KubernetesCluster`
 */
class KubernetesCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::KubernetesCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosKubernetesCluster = new cs_generated_1.RosKubernetesCluster(this, id, {
            endpointPublicAccess: props.endpointPublicAccess === undefined || props.endpointPublicAccess === null ? false : props.endpointPublicAccess,
            socEnabled: props.socEnabled,
            platform: props.platform,
            resourceGroupId: props.resourceGroupId,
            masterSystemDiskCategory: props.masterSystemDiskCategory === undefined || props.masterSystemDiskCategory === null ? 'cloud_ssd' : props.masterSystemDiskCategory,
            masterCount: props.masterCount === undefined || props.masterCount === null ? 3 : props.masterCount,
            sshFlags: props.sshFlags,
            loadBalancerSpec: props.loadBalancerSpec,
            name: props.name,
            taint: props.taint,
            masterDataDisks: props.masterDataDisks,
            isEnterpriseSecurityGroup: props.isEnterpriseSecurityGroup,
            runtime: props.runtime,
            masterZoneIds: props.masterZoneIds,
            osType: props.osType,
            workerZoneIds: props.workerZoneIds,
            proxyMode: props.proxyMode === undefined || props.proxyMode === null ? 'iptables' : props.proxyMode,
            disableRollback: props.disableRollback === undefined || props.disableRollback === null ? true : props.disableRollback,
            tags: props.tags,
            containerCidr: props.containerCidr === undefined || props.containerCidr === null ? '172.16.0.0/16' : props.containerCidr,
            cpuPolicy: props.cpuPolicy,
            keyPair: props.keyPair,
            nodeCidrMask: props.nodeCidrMask,
            period: props.period,
            deletionProtection: props.deletionProtection,
            timeZone: props.timeZone,
            vpcId: props.vpcId,
            userCa: props.userCa,
            snatEntry: props.snatEntry === undefined || props.snatEntry === null ? true : props.snatEntry,
            masterDataDisk: props.masterDataDisk === undefined || props.masterDataDisk === null ? false : props.masterDataDisk,
            masterSystemDiskSnapshotPolicyId: props.masterSystemDiskSnapshotPolicyId,
            periodUnit: props.periodUnit,
            formatDisk: props.formatDisk,
            userData: props.userData,
            autoRenew: props.autoRenew,
            addons: props.addons,
            masterSystemDiskSize: props.masterSystemDiskSize === undefined || props.masterSystemDiskSize === null ? 120 : props.masterSystemDiskSize,
            workerSystemDiskCategory: props.workerSystemDiskCategory === undefined || props.workerSystemDiskCategory === null ? 'cloud_efficiency' : props.workerSystemDiskCategory,
            nodePortRange: props.nodePortRange === undefined || props.nodePortRange === null ? '30000-65535' : props.nodePortRange,
            workerSystemDiskSize: props.workerSystemDiskSize === undefined || props.workerSystemDiskSize === null ? 120 : props.workerSystemDiskSize,
            masterVSwitchIds: props.masterVSwitchIds,
            cloudMonitorFlags: props.cloudMonitorFlags === undefined || props.cloudMonitorFlags === null ? false : props.cloudMonitorFlags,
            serviceCidr: props.serviceCidr === undefined || props.serviceCidr === null ? '172.19.0.0/20' : props.serviceCidr,
            podVswitchIds: props.podVswitchIds,
            workerInstanceTypes: props.workerInstanceTypes,
            loginPassword: props.loginPassword,
            autoRenewPeriod: props.autoRenewPeriod,
            kubernetesVersion: props.kubernetesVersion,
            masterInstanceTypes: props.masterInstanceTypes,
            masterSystemDiskPerformanceLevel: props.masterSystemDiskPerformanceLevel,
            workerDataDisks: props.workerDataDisks,
            securityGroupId: props.securityGroupId,
            timeoutMins: props.timeoutMins === undefined || props.timeoutMins === null ? 60 : props.timeoutMins,
            cisEnabled: props.cisEnabled,
            workerDataDisk: props.workerDataDisk === undefined || props.workerDataDisk === null ? false : props.workerDataDisk,
            numOfNodes: props.numOfNodes === undefined || props.numOfNodes === null ? 3 : props.numOfNodes,
            keepInstanceName: props.keepInstanceName,
            chargeType: props.chargeType,
            workerSystemDiskSnapshotPolicyId: props.workerSystemDiskSnapshotPolicyId,
            workerVSwitchIds: props.workerVSwitchIds,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosKubernetesCluster;
        this.attrApiServerSlbId = rosKubernetesCluster.attrApiServerSlbId;
        this.attrClusterId = rosKubernetesCluster.attrClusterId;
        this.attrDefaultUserKubeConfig = rosKubernetesCluster.attrDefaultUserKubeConfig;
        this.attrNodes = rosKubernetesCluster.attrNodes;
        this.attrPrivateUserKubConfig = rosKubernetesCluster.attrPrivateUserKubConfig;
        this.attrScalingConfigurationId = rosKubernetesCluster.attrScalingConfigurationId;
        this.attrScalingGroupId = rosKubernetesCluster.attrScalingGroupId;
        this.attrScalingRuleId = rosKubernetesCluster.attrScalingRuleId;
        this.attrTaskId = rosKubernetesCluster.attrTaskId;
        this.attrWorkerRamRoleName = rosKubernetesCluster.attrWorkerRamRoleName;
    }
}
exports.KubernetesCluster = KubernetesCluster;
//# sourceMappingURL=data:application/json;base64,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