"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stack = exports.BaseStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tfe = require("@cdktf/provider-tfe");
const provider_tfe_1 = require("@cdktf/provider-tfe");
const cdktf_1 = require("cdktf");
const MULTI_STACK_BASE_SYMBOL = Symbol(`multi-stack-tfe-base`);
const MULTI_STACK_STACK_SYMBOL = Symbol(`multi-stack-tfe-stack`);
class BaseStack extends cdktf_1.TerraformStack {
    constructor(scope, organizationName, prefix, options = {}) {
        super(scope, "base");
        this.organizationName = organizationName;
        this.prefix = prefix;
        this.options = options;
        Object.defineProperty(this, MULTI_STACK_BASE_SYMBOL, { value: true });
        this.tfeProvider = new provider_tfe_1.TfeProvider(this, "tfe", {
            hostname: options.hostname,
            token: options.token,
            sslSkipVerify: options.sslSkipVerify,
        });
        new cdktf_1.RemoteBackend(this, this.getRemoteBackendOptions("base"));
        this.organization = new provider_tfe_1.DataTfeOrganization(this, "organization", {
            name: organizationName,
        });
    }
    static isBaseStack(x) {
        return x !== null && typeof x === "object" && MULTI_STACK_BASE_SYMBOL in x;
    }
    static baseStackOf(construct) {
        const app = cdktf_1.App.of(construct);
        const base = app.node.children.find(BaseStack.isBaseStack);
        if (!base) {
            throw new Error(`No BaseStack for multi-stack app could be identified for the construct at path '${construct.node.path}'. The base stack needs to have the same app as the scope as this construct.`);
        }
        return base;
    }
    getRemoteBackendOptions(stackName) {
        return {
            workspaces: {
                name: this.getWorkspaceName(stackName),
            },
            organization: this.organizationName,
            // optional
            hostname: this.options.hostname,
            token: this.options.token,
        };
    }
    /**
     * If you want to have more control over the workspace name, you can override this method.
     */
    getWorkspaceName(stackName) {
        return `${this.prefix}-${stackName}`;
    }
    bootstrapWorkspace(stackName) {
        return new tfe.Workspace(this, `tfe-multi-stack-workspace-${stackName}`, {
            name: this.getWorkspaceName(stackName),
            organization: this.organization.name,
            tagNames: [this.prefix],
            remoteStateConsumerIds: [],
        });
    }
}
exports.BaseStack = BaseStack;
_a = JSII_RTTI_SYMBOL_1;
BaseStack[_a] = { fqn: "cdktf-multi-stack-tfe.BaseStack", version: "0.0.6" };
class Stack extends cdktf_1.TerraformStack {
    constructor(scope, stackName) {
        super(scope, stackName);
        Object.defineProperty(this, MULTI_STACK_STACK_SYMBOL, { value: true });
        const baseStack = BaseStack.baseStackOf(this);
        this.workspace = baseStack.bootstrapWorkspace(stackName);
        new cdktf_1.RemoteBackend(this, baseStack.getRemoteBackendOptions(stackName));
    }
    static isMultiStackStack(x) {
        return x !== null && typeof x === "object" && MULTI_STACK_STACK_SYMBOL in x;
    }
    addDependency(dependency) {
        var _c, _d;
        if (!this.dependencies.includes(dependency) &&
            Stack.isMultiStackStack(dependency)) {
            (_c = dependency.workspace.remoteStateConsumerIdsInput) === null || _c === void 0 ? void 0 : _c.push(this.workspace.id);
            const currentDependencies = (_d = dependency.workspace.dependsOn) !== null && _d !== void 0 ? _d : [];
            currentDependencies.push(cdktf_1.insideTfExpression(this.workspace.fqn));
            // This is not working as the result is wrapped in a terraform expression where it's not allowed to
            dependency.workspace.dependsOn = currentDependencies;
        }
        super.addDependency(dependency);
    }
}
exports.Stack = Stack;
_b = JSII_RTTI_SYMBOL_1;
Stack[_b] = { fqn: "cdktf-multi-stack-tfe.Stack", version: "0.0.6" };
//# sourceMappingURL=data:application/json;base64,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