# Generated by Django 4.1.7 on 2023-03-16 18:43

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("onto", "0002_remove_domain_entity_remove_membership_domain_and_more"),
        ("onto_authz", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Domain",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.SlugField(
                        help_text="Fully-qualified Domain Name. Must be unique.",
                        max_length=255,
                        unique=True,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Membership",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "xattrs",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Arbitrary JSON attributes, e.g. tags, to attach to this object.",
                        verbose_name="extended attributes",
                    ),
                ),
                (
                    "domain",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="memberships",
                        to="onto_authz.domain",
                    ),
                ),
                (
                    "entity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="memberships",
                        to="onto.entity",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="domain",
            name="entities",
            field=models.ManyToManyField(
                blank=True,
                help_text="Entities contained in this domain.",
                related_name="domains",
                through="onto_authz.Membership",
                to="onto.entity",
            ),
        ),
        migrations.AlterField(
            model_name="entitlement",
            name="domain",
            field=models.ForeignKey(
                editable=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="entitlements",
                to="onto_authz.domain",
            ),
        ),
        migrations.AlterField(
            model_name="policy",
            name="domain",
            field=models.ForeignKey(
                editable=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="policies",
                to="onto_authz.domain",
            ),
        ),
        migrations.AddConstraint(
            model_name="membership",
            constraint=models.UniqueConstraint(
                fields=("entity", "domain"), name="onto_authz_membership_unique"
            ),
        ),
    ]
