from typing import Any, Dict, Optional, Type, TypeVar

from .asset import Asset

class _EmojiTag: ...

_PE = TypeVar('_PE', bound=PartialEmoji)

class PartialEmoji(_EmojiTag):
    animated: bool
    name: Optional[str]
    id: Optional[int]
    @classmethod
    def from_dict(cls: Type[_PE], data: Dict[str, Any]) -> _PE: ...
    def to_dict(self) -> Dict[str, Any]: ...
    @classmethod
    def with_state(
        cls: Type[_PE],
        state: Any,
        *,
        name: Optional[str],
        animated: bool,
        id: Optional[int] = ...,
    ) -> _PE: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
    def is_custom_emoji(self) -> bool: ...
    def is_unicode_emoji(self) -> bool: ...
    @property
    def url(self) -> Asset: ...
