# coding: utf-8

"""
    ARLAS Subscriptions Manager API

    Manage ARLAS subscriptions on ARLAS collections' events.  # noqa: E501

    OpenAPI spec version: 23.0.0
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from arlas_subscriptions_manager_api_python.api_client import ApiClient


class EndUserApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete1(self, id, **kwargs):  # noqa: E501
        """Delete a subscription  # noqa: E501

        Mark a subscription as deleted. Only creator can delete their own subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete1(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Subscription ID to delete (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete1_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete1_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete1_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a subscription  # noqa: E501

        Mark a subscription as deleted. Only creator can delete their own subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete1_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Subscription ID to delete (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get1(self, id, **kwargs):  # noqa: E501
        """Find subscription by ID  # noqa: E501

        Return a single subscription. Only creator can access their subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get1(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get1_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get1_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get1_with_http_info(self, id, **kwargs):  # noqa: E501
        """Find subscription by ID  # noqa: E501

        Return a single subscription. Only creator can access their subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get1_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all1(self, **kwargs):  # noqa: E501
        """List all available subscriptions  # noqa: E501

        Return the list of all registered subscriptions that are available for current user from the latest created to the earliest. Only current user's subscriptions that are not deleted are listed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all1(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int before: Retrieve subscriptions created before given timestamp.
        :param bool active: Filter subscriptions whether they are active or not (returns all if missing, 'active' if 'true', 'inactive' if 'false').
        :param bool expired: Filter subscriptions whether they are expired or not (returns all if missing, 'expired' if 'true', 'not expired' if 'false').
        :param bool pretty: Pretty print
        :param int size: Page Size
        :param int page: Page ID
        :return: SubscriptionListResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all1_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all1_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all1_with_http_info(self, **kwargs):  # noqa: E501
        """List all available subscriptions  # noqa: E501

        Return the list of all registered subscriptions that are available for current user from the latest created to the earliest. Only current user's subscriptions that are not deleted are listed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all1_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int before: Retrieve subscriptions created before given timestamp.
        :param bool active: Filter subscriptions whether they are active or not (returns all if missing, 'active' if 'true', 'inactive' if 'false').
        :param bool expired: Filter subscriptions whether they are expired or not (returns all if missing, 'expired' if 'true', 'not expired' if 'false').
        :param bool pretty: Pretty print
        :param int size: Page Size
        :param int page: Page ID
        :return: SubscriptionListResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'active', 'expired', 'pretty', 'size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all1" % key
                )
            params[key] = val
        del params['kwargs']

        if 'size' in params and params['size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `size` when calling `get_all1`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'page' in params and params['page'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `get_all1`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'before' in params:
            query_params.append(('before', params['before']))  # noqa: E501
        if 'active' in params:
            query_params.append(('active', params['active']))  # noqa: E501
        if 'expired' in params:
            query_params.append(('expired', params['expired']))  # noqa: E501
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionListResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post1(self, subscription, **kwargs):  # noqa: E501
        """Register a new subscription  # noqa: E501

        Register a subscription for further notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post1(subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post1_with_http_info(subscription, **kwargs)  # noqa: E501
        else:
            (data) = self.post1_with_http_info(subscription, **kwargs)  # noqa: E501
            return data

    def post1_with_http_info(self, subscription, **kwargs):  # noqa: E501
        """Register a new subscription  # noqa: E501

        Register a subscription for further notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post1_with_http_info(subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params or
                params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `post1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subscription' in params:
            body_params = params['subscription']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put1(self, id, subscription, **kwargs):  # noqa: E501
        """Update an existing subscription  # noqa: E501

        Update an existing subscription. Only creator can update their own subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put1(id, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put1_with_http_info(id, subscription, **kwargs)  # noqa: E501
        else:
            (data) = self.put1_with_http_info(id, subscription, **kwargs)  # noqa: E501
            return data

    def put1_with_http_info(self, id, subscription, **kwargs):  # noqa: E501
        """Update an existing subscription  # noqa: E501

        Update an existing subscription. Only creator can update their own subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put1_with_http_info(id, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'subscription', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `put1`")  # noqa: E501
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params or
                params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `put1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subscription' in params:
            body_params = params['subscription']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
