# coding: utf-8

"""
    ARLAS Subscriptions Manager API

    Manage ARLAS subscriptions on ARLAS collections' events.  # noqa: E501

    OpenAPI spec version: 23.0.0
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from arlas_subscriptions_manager_api_python.api_client import ApiClient


class AdminApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete(self, id, **kwargs):  # noqa: E501
        """Delete a subscription  # noqa: E501

        Mark a subscription as deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Subscription ID to delete (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a subscription  # noqa: E501

        Mark a subscription as deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Subscription ID to delete (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/admin/subscriptions/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get(self, id, **kwargs):  # noqa: E501
        """Find subscription by ID  # noqa: E501

        Return a single subscription. Only creator can access their subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Find subscription by ID  # noqa: E501

        Return a single subscription. Only creator can access their subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'deleted', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'deleted' in params:
            query_params.append(('deleted', params['deleted']))  # noqa: E501
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/admin/subscriptions/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all(self, **kwargs):  # noqa: E501
        """List all available subscriptions  # noqa: E501

        Return the list of all registered subscriptions from the latest created to the earliest.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int before: Retrieve subscriptions created before given timestamp.
        :param int after: Retrieve subscriptions created after given timestamp.
        :param bool active: Filter subscriptions whether they are active or not (returns all if missing, 'active' if 'true', 'not active' if 'false').
        :param bool started: Filter subscriptions whether they are started or not (returns all if missing, 'started' if 'true', 'not started' if 'false').
        :param bool expired: Filter subscriptions whether they are expired or not (returns all if missing, 'expired' if 'true', 'not expired' if 'false').
        :param str created_by: Filter subscriptions by creator's identifier
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool created_by_admin: Filter subscriptions whether they have been created by admin or not (returns all if missing, 'created_by_admin' if 'true', 'not created_by_admin' if 'false').
        :param bool pretty: Pretty print
        :param int page: Page ID
        :param int size: Page Size
        :return: SubscriptionListResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_with_http_info(self, **kwargs):  # noqa: E501
        """List all available subscriptions  # noqa: E501

        Return the list of all registered subscriptions from the latest created to the earliest.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int before: Retrieve subscriptions created before given timestamp.
        :param int after: Retrieve subscriptions created after given timestamp.
        :param bool active: Filter subscriptions whether they are active or not (returns all if missing, 'active' if 'true', 'not active' if 'false').
        :param bool started: Filter subscriptions whether they are started or not (returns all if missing, 'started' if 'true', 'not started' if 'false').
        :param bool expired: Filter subscriptions whether they are expired or not (returns all if missing, 'expired' if 'true', 'not expired' if 'false').
        :param str created_by: Filter subscriptions by creator's identifier
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool created_by_admin: Filter subscriptions whether they have been created by admin or not (returns all if missing, 'created_by_admin' if 'true', 'not created_by_admin' if 'false').
        :param bool pretty: Pretty print
        :param int page: Page ID
        :param int size: Page Size
        :return: SubscriptionListResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'active', 'started', 'expired', 'created_by', 'deleted', 'created_by_admin', 'pretty', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page' in params and params['page'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `get_all`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'size' in params and params['size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `size` when calling `get_all`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'before' in params:
            query_params.append(('before', params['before']))  # noqa: E501
        if 'after' in params:
            query_params.append(('after', params['after']))  # noqa: E501
        if 'active' in params:
            query_params.append(('active', params['active']))  # noqa: E501
        if 'started' in params:
            query_params.append(('started', params['started']))  # noqa: E501
        if 'expired' in params:
            query_params.append(('expired', params['expired']))  # noqa: E501
        if 'created_by' in params:
            query_params.append(('created-by', params['created_by']))  # noqa: E501
        if 'deleted' in params:
            query_params.append(('deleted', params['deleted']))  # noqa: E501
        if 'created_by_admin' in params:
            query_params.append(('created-by-admin', params['created_by_admin']))  # noqa: E501
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/admin/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubscriptionListResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post(self, subscription, **kwargs):  # noqa: E501
        """Register a new subscription  # noqa: E501

        Register a subscription for further notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post(subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_with_http_info(subscription, **kwargs)  # noqa: E501
        else:
            (data) = self.post_with_http_info(subscription, **kwargs)  # noqa: E501
            return data

    def post_with_http_info(self, subscription, **kwargs):  # noqa: E501
        """Register a new subscription  # noqa: E501

        Register a subscription for further notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_with_http_info(subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params or
                params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subscription' in params:
            body_params = params['subscription']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/admin/subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put(self, id, subscription, **kwargs):  # noqa: E501
        """Update an existing subscription  # noqa: E501

        Update an existing subscription.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put(id, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_with_http_info(id, subscription, **kwargs)  # noqa: E501
        else:
            (data) = self.put_with_http_info(id, subscription, **kwargs)  # noqa: E501
            return data

    def put_with_http_info(self, id, subscription, **kwargs):  # noqa: E501
        """Update an existing subscription  # noqa: E501

        Update an existing subscription.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_with_http_info(id, subscription, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of subscription to return (required)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'subscription', 'pretty']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `put`")  # noqa: E501
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params or
                params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subscription' in params:
            body_params = params['subscription']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/admin/subscriptions/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserSubscriptionWithLinks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
