import * as cdk from '@aws-cdk/core';
/**
 * Properties of the StackOutputs.
 */
export interface StackOutputsProps {
    /**
     * The remote CDK stack to get the outputs from.
     */
    readonly stack: cdk.Stack;
    /**
     * Indicate whether always update the custom resource to get the new stack output.
     *
     * @default true
     */
    readonly alwaysUpdate?: boolean;
}
/**
 * Represents the StackOutputs of the remote CDK stack.
 */
export declare class StackOutputs extends cdk.Construct {
    /**
     * The outputs from the remote stack.
     */
    readonly outputs: cdk.CustomResource;
    /**
     *
     */
    constructor(scope: cdk.Construct, id: string, props: StackOutputsProps);
    /**
     * Get the attribute value from the outputs.
     *
     * @param key output key.
     */
    getAttString(key: string): string;
}
