import copy

from rest_framework import status


class FhirApiUpdateTestMixin(object):

    @property
    def base_url(self):
        raise NotImplementedError()

    @property
    def _test_request_data(self):
        raise NotImplementedError()

    def get_id_for_created_resource(self, response):
        raise NotImplementedError()

    def get_fhir_obj_from_json_response(self, response):
        raise NotImplementedError()

    def update_resource(self, data):
        raise NotImplementedError()

    def verify_updated_obj(self, obj):
        raise NotImplementedError()

    def login(self):
        raise NotImplementedError()

    def test_put_should_update_correctly(self):
        self.login()
        # create
        self.create_dependencies()
        response = self.client.post(self.base_url, data=self._test_request_data, format='json')
        self.assertEqual(response.status_code, status.HTTP_201_CREATED)
        resource_id = self.get_id_for_created_resource(response)
        # update
        updated_data = copy.deepcopy(self._test_request_data)
        self.update_resource(updated_data)
        response = self.client.put(self.base_url + resource_id + "/", data=updated_data, format='json')
        self.assertEqual(response.status_code, status.HTTP_200_OK)
        # verify
        updated_obj = self.get_fhir_obj_from_json_response(response)
        self.verify_updated_obj(updated_obj)

    def create_dependencies(self):
        pass
