"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogsAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * The action to send data to Amazon CloudWatch Logs
 */
class CloudWatchLogsAction {
    /**
     * @param logGroup The CloudWatch log group to which the action sends data
     * @param props Optional properties to not use default
     */
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_CloudWatchLogsActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchLogsAction);
            }
            throw error;
        }
        this.role = props.role;
    }
    bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        this.logGroup.grantWrite(role);
        this.logGroup.grant(role, 'logs:DescribeLogStreams');
        return {
            configuration: {
                cloudwatchLogs: {
                    logGroupName: this.logGroup.logGroupName,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.CloudWatchLogsAction = CloudWatchLogsAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogsAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.CloudWatchLogsAction", version: "1.182.0" };
//# sourceMappingURL=data:application/json;base64,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