"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 *
 * @stability stable
 */
class FargateCluster extends cluster_1.Cluster {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            coreDnsComputeType: (_b = props.coreDnsComputeType) !== null && _b !== void 0 ? _b : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        this.addFargateProfile((_d = (_c = props.defaultProfile) === null || _c === void 0 ? void 0 : _c.fargateProfileName) !== null && _d !== void 0 ? _d : (props.defaultProfile ? 'custom' : 'default'), (_e = props.defaultProfile) !== null && _e !== void 0 ? _e : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
_a = JSII_RTTI_SYMBOL_1;
FargateCluster[_a] = { fqn: "@aws-cdk/aws-eks.FargateCluster", version: "1.106.0" };
//# sourceMappingURL=data:application/json;base64,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