#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# project documentation build configuration file, created by
# sphinx-quickstart on Sat Feb 22 09:35:49 2014.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os.path as op
import sys

import odtbrain

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

# include parent directory
pdir = op.dirname(op.dirname(op.abspath(__file__)))
sys.path.insert(0, pdir)

sys.path.append(op.abspath('extensions'))

# http://www.sphinx-doc.org/en/stable/ext/autodoc.html#confval-autodoc_member_order
# Order class attributes and functions in separate blocks
autodoc_member_order = 'bysource'

# Display link to GitHub repo instead of doc on rtfd
rst_prolog = """
:github_url: https://github.com/RI-imaging/ODTbrain
"""

# -- General configuration ------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.intersphinx',
              'sphinx.ext.autodoc',
              'sphinx.ext.mathjax',
              'sphinx.ext.autosummary',
              'sphinx.ext.napoleon',
              'sphinxcontrib.bibtex',
              'fancy_include',
              'github_changelog',
              ]

# specify bibtex files (required for sphinxcontrib.bibtex>=2.0)
bibtex_bibfiles = ['odtbrain.bib']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
year = "2015"
name = "odtbrain"
author = "Paul Müller"
authors = [author]
projectname = name

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
#
# The full version, including alpha/beta/rc tags.
# This gets 'version'
version = odtbrain.__version__
release = version

project = projectname
copyright = year + ", " + author  # @ReservedAssignment
github_project = 'RI-imaging/' + project

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build']

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
# pygments_style = 'default'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'sphinx_rtd_theme'

# Output file base name for HTML help builder.
htmlhelp_basename = projectname+'doc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    # 'preamble': '',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    ('index', projectname+'.tex', projectname+' Documentation',
     author, 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('index', projectname, projectname+' Documentation',
     authors, 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    ('index', projectname, 'ODTbrain Documentation',
     author, projectname,
     "Algorithms for optical diffraction tomography",
     'Numeric'),
]


# -----------------------------------------------------------------------------
# intersphinx
# -----------------------------------------------------------------------------
intersphinx_mapping = {
    "python": ('https://docs.python.org/', None),
    "nrefocus": ('http://nrefocus.readthedocs.io/en/stable', None),
    "numpy": ('http://docs.scipy.org/doc/numpy', None),
    "cellsino": ('http://cellsino.readthedocs.io/en/stable', None),
    "qpimage": ('http://qpimage.readthedocs.io/en/stable', None),
    "radontea": ('http://radontea.readthedocs.io/en/stable', None),
    "scipy": ('https://docs.scipy.org/doc/scipy/reference/', None),
    "skimage": ('http://scikit-image.org/docs/stable/', None),
    }
