"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitConditionHandle = exports.WaitConditionHandleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ros_generated_1 = require("./ros.generated");
Object.defineProperty(exports, "WaitConditionHandleProperty", { enumerable: true, get: function () { return ros_generated_1.RosWaitConditionHandle; } });
/**
 * A ROS resource type:  `ALIYUN::ROS::WaitConditionHandle`
 */
class WaitConditionHandle extends ros.Resource {
    /**
     * Create a new `ALIYUN::ROS::WaitConditionHandle`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosWaitConditionHandle = new ros_generated_1.RosWaitConditionHandle(this, id, {
            mode: props.mode ? props.mode : 'Full',
            count: props.count ? props.count : -1,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWaitConditionHandle;
        this.attrCurlCli = rosWaitConditionHandle.attrCurlCli;
        this.attrHeaders = rosWaitConditionHandle.attrHeaders;
        this.attrPowerShellCurlCli = rosWaitConditionHandle.attrPowerShellCurlCli;
        this.attrUrl = rosWaitConditionHandle.attrUrl;
        this.attrWindowsCurlCli = rosWaitConditionHandle.attrWindowsCurlCli;
    }
}
exports.WaitConditionHandle = WaitConditionHandle;
//# sourceMappingURL=data:application/json;base64,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