"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stack = exports.StackProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ros_generated_1 = require("./ros.generated");
Object.defineProperty(exports, "StackProperty", { enumerable: true, get: function () { return ros_generated_1.RosStack; } });
/**
 * A ROS resource type:  `ALIYUN::ROS::Stack`
 */
class Stack extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::ROS::Stack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosStack = new ros_generated_1.RosStack(this, id, {
            templateUrl: props.templateUrl,
            parameters: props.parameters,
            timeoutMins: props.timeoutMins ? props.timeoutMins : 60,
            templateVersion: props.templateVersion,
            templateBody: props.templateBody,
            templateId: props.templateId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosStack;
    }
}
exports.Stack = Stack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQTJDO0FBRXRCLDhGQUZaLHdCQUFRLE9BRWlCO0FBeUNsQzs7R0FFRztBQUNILE1BQWEsS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBRW5DOzs7T0FHRztJQUVIOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsUUFBb0IsRUFBRSxFQUFFLG1DQUEyQyxJQUFJO1FBQ2pILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxRQUFRLEdBQUcsSUFBSSx3QkFBUSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDckMsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUN2RCxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtTQUMvQixFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztJQUM3QixDQUFDO0NBQ0o7QUEzQkQsc0JBMkJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xyXG5pbXBvcnQgeyBSb3NTdGFjayB9IGZyb20gJy4vcm9zLmdlbmVyYXRlZCc7XHJcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxyXG5leHBvcnQgeyBSb3NTdGFjayBhcyBTdGFja1Byb3BlcnR5IH07XHJcblxyXG4vKipcclxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpST1M6OlN0YWNrYFxyXG4gKi9cclxuZXhwb3J0IGludGVyZmFjZSBTdGFja1Byb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBwYXJhbWV0ZXJzOiBUaGUgc2V0IG9mIHBhcmFtZXRlcnMgcGFzc2VkIHRvIHRoaXMgbmVzdGVkIHN0YWNrLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBwYXJhbWV0ZXJzPzogeyBba2V5OiBzdHJpbmddOiAoYW55IHwgcm9zLklSZXNvbHZhYmxlKSB9IHwgcm9zLklSZXNvbHZhYmxlO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHRlbXBsYXRlQm9keTogU3RydWN0dXJlIGNvbnRhaW5pbmcgdGhlIHRlbXBsYXRlIGJvZHkuXHJcbiAgICAgKiBJdCBpcyBqdXN0IHRvIGZhY2lsaXRhdGUgdGhlIHBhc3Npbmcgb2YgdGVtcGxhdGUuIEl0IGlzIHJhdyBjb250ZW50LkZ1bmN0aW9ucyBpbiBUZW1wbGF0ZUJvZHkgd2lsbCBub3QgYmUgcmVzb2x2ZWQgaW4gcGFyZW50IHN0YWNrLlxyXG4gICAgICogWW91IG11c3Qgc3BlY2lmeSBlaXRoZXIgdGhlIFRlbXBsYXRlQm9keSBvciB0aGUgVGVtcGxhdGVVUkwgcHJvcGVydHkuIElmIGJvdGggYXJlIHNwZWNpZmllZCwgVGVtcGxhdGVCb2R5IHdpbGwgYmUgdXNlZC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgdGVtcGxhdGVCb2R5PzogeyBba2V5OiBzdHJpbmddOiAoYW55IHwgcm9zLklSZXNvbHZhYmxlKSB9IHwgcm9zLklSZXNvbHZhYmxlO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHRlbXBsYXRlSWQ6IFRlbXBsYXRlIElEIG9mIHRlbXBsYXRlIGNvbnRhaW5pbmcgdGhlIHRlbXBsYXRlIGJvZHkuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHRlbXBsYXRlSWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdGVtcGxhdGVVcmw6IExvY2F0aW9uIG9mIGZpbGUgY29udGFpbmluZyB0aGUgdGVtcGxhdGUgYm9keS4gVGhlIFVSTCBtdXN0IHBvaW50IHRvIGEgdGVtcGxhdGUgKG1heCBzaXplOiA1MjQyODggYnl0ZXMpIHRoYXQgaXMgbG9jYXRlZCBpbiBhIGh0dHAgd2ViIHNlcnZlcihodHRwLCBodHRwcyksIG9yIGFuIEFsaXl1biBPU1MgYnVja2V0KFN1Y2ggYXMgb3NzOi8vcm9zLXRlbXBsYXRlL2RlbW8/UmVnaW9uSWQ9Y24taGFuZ3pob3UsIG9zczovL3Jvcy10ZW1wbGF0ZS9kZW1vLiBSZWdpb25JZCBpcyBkZWZhdWx0IHRvIHRoZSB2YWx1ZSBvZiBSZWdpb25JZCBQYXJhbWV0ZXIgb2YgdGhlIHJlcXVlc3QuKS5cclxuICAgICAqIFlvdSBtdXN0IHNwZWNpZnkgZWl0aGVyIHRoZSBUZW1wbGF0ZUJvZHkgb3IgdGhlIFRlbXBsYXRlVVJMIHByb3BlcnR5LiBJZiBib3RoIGFyZSBzcGVjaWZpZWQsIFRlbXBsYXRlQm9keSB3aWxsIGJlIHVzZWQuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHRlbXBsYXRlVXJsPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHRlbXBsYXRlVmVyc2lvbjogVGVtcGxhdGUgdmVyc2lvbiBvZiB0ZW1wbGF0ZSBjb250YWluaW5nIHRoZSB0ZW1wbGF0ZSBib2R5LlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB0ZW1wbGF0ZVZlcnNpb24/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdGltZW91dE1pbnM6IFRoZSBsZW5ndGggb2YgdGltZSwgaW4gbWludXRlcywgdG8gd2FpdCBmb3IgdGhlIG5lc3RlZCBzdGFjayBjcmVhdGlvbiBvciB1cGRhdGUuIERlZmF1bHQgdG8gNjAgbWludXRlcy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgdGltZW91dE1pbnM/OiBudW1iZXI7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6Uk9TOjpTdGFja2BcclxuICovXHJcbmV4cG9ydCBjbGFzcyBTdGFjayBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XHJcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cclxuICAgICAqL1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBTElZVU46OlJPUzo6U3RhY2tgLlxyXG4gICAgICpcclxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxyXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxyXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xyXG4gICAgICovXHJcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFN0YWNrUHJvcHMgPSB7fSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcclxuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xyXG5cclxuICAgICAgICBjb25zdCByb3NTdGFjayA9IG5ldyBSb3NTdGFjayh0aGlzLCBpZCwgIHtcclxuICAgICAgICAgICAgdGVtcGxhdGVVcmw6IHByb3BzLnRlbXBsYXRlVXJsLFxyXG4gICAgICAgICAgICBwYXJhbWV0ZXJzOiBwcm9wcy5wYXJhbWV0ZXJzLFxyXG4gICAgICAgICAgICB0aW1lb3V0TWluczogcHJvcHMudGltZW91dE1pbnMgPyBwcm9wcy50aW1lb3V0TWlucyA6IDYwLFxyXG4gICAgICAgICAgICB0ZW1wbGF0ZVZlcnNpb246IHByb3BzLnRlbXBsYXRlVmVyc2lvbixcclxuICAgICAgICAgICAgdGVtcGxhdGVCb2R5OiBwcm9wcy50ZW1wbGF0ZUJvZHksXHJcbiAgICAgICAgICAgIHRlbXBsYXRlSWQ6IHByb3BzLnRlbXBsYXRlSWQsXHJcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XHJcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc1N0YWNrO1xyXG4gICAgfVxyXG59XHJcbiJdfQ==