DROP TABLE IF EXISTS portuguese_lemma;
CREATE TABLE portuguese_lemma (id varchar(10) NOT NULL, pos CHECK(pos in ('n','v','a','s','r')) DEFAULT 'n', lemma varchar(200) NOT NULL, is_phrase CHECK(is_phrase in ('Y','N')) DEFAULT 'N', PRIMARY KEY (id,lemma,is_phrase));

INSERT INTO portuguese_lemma VALUES ("a#00001740","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00053037","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00053327","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00138021","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00301090","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00301385","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00301854","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00302615","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00476218","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00812035","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00968256","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01077975","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01316335","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01317331","a","capaz","N");
INSERT INTO portuguese_lemma VALUES ("n#00001740","n","ente","N");
INSERT INTO portuguese_lemma VALUES ("n#00001740","n","entidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00001740","n","ser","N");
INSERT INTO portuguese_lemma VALUES ("n#00004258","n","ser","N");
INSERT INTO portuguese_lemma VALUES ("n#00002086","n","ser","N");
INSERT INTO portuguese_lemma VALUES ("n#00008019","n","ser","N");
INSERT INTO portuguese_lemma VALUES ("v#01717851","v","ser","N");
INSERT INTO portuguese_lemma VALUES ("v#01775163","v","ser","N");
INSERT INTO portuguese_lemma VALUES ("v#01775973","v","ser","N");
INSERT INTO portuguese_lemma VALUES ("n#07192170","n","ser","N");
INSERT INTO portuguese_lemma VALUES ("n#10054265","n","ser","N");
INSERT INTO portuguese_lemma VALUES ("r#00001740","r","a_capela","Y");
INSERT INTO portuguese_lemma VALUES ("v#00001740","v","espirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00529549","v","espirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00001740","v","respirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00529549","v","respirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01784886","v","respirar","N");
INSERT INTO portuguese_lemma VALUES ("n#00001930","n","entidade_física","Y");
INSERT INTO portuguese_lemma VALUES ("a#00002062","a","incapaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00054157","a","incapaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00477567","a","incapaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00302770","a","incapaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00477390","a","incapaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01754281","a","incapaz","N");
INSERT INTO portuguese_lemma VALUES ("n#00013018","n","entidade_abstrata","Y");
INSERT INTO portuguese_lemma VALUES ("n#00013018","n","abstração","N");
INSERT INTO portuguese_lemma VALUES ("n#00013018","n","idéia_abstrata","Y");
INSERT INTO portuguese_lemma VALUES ("a#00002312","a","dorsal","N");
INSERT INTO portuguese_lemma VALUES ("a#00132127","a","dorsal","N");
INSERT INTO portuguese_lemma VALUES ("n#05557500","n","dorsal","N");
INSERT INTO portuguese_lemma VALUES ("n#00002452","n","coisa","N");
INSERT INTO portuguese_lemma VALUES ("n#00020709","n","coisa","N");
INSERT INTO portuguese_lemma VALUES ("n#02586441","n","coisa","N");
INSERT INTO portuguese_lemma VALUES ("n#03495843","n","coisa","N");
INSERT INTO portuguese_lemma VALUES ("r#00002621","r","dificilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00003093","r","dificilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00002621","r","quasenão","N");
INSERT INTO portuguese_lemma VALUES ("r#00002621","r","quase_não","Y");
INSERT INTO portuguese_lemma VALUES ("r#00002621","r","logoque","N");
INSERT INTO portuguese_lemma VALUES ("n#00009457","n","objeto_físico","Y");
INSERT INTO portuguese_lemma VALUES ("n#00009457","n","objeto","N");
INSERT INTO portuguese_lemma VALUES ("n#05810948","n","objeto","N");
INSERT INTO portuguese_lemma VALUES ("n#06132724","n","objeto","N");
INSERT INTO portuguese_lemma VALUES ("n#04761832","n","objeto","N");
INSERT INTO portuguese_lemma VALUES ("v#00002942","v","hiperventilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00003133","v","hiperventilar","N");
INSERT INTO portuguese_lemma VALUES ("r#00003093","r","apenas","N");
INSERT INTO portuguese_lemma VALUES ("r#00004722","r","apenas","N");
INSERT INTO portuguese_lemma VALUES ("r#00008600","r","apenas","N");
INSERT INTO portuguese_lemma VALUES ("r#00011011","r","apenas","N");
INSERT INTO portuguese_lemma VALUES ("v#00003431","v","arrotar","N");
INSERT INTO portuguese_lemma VALUES ("r#00003483","r","em_essência","Y");
INSERT INTO portuguese_lemma VALUES ("r#00003483","r","basicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00003483","r","fundamentalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00003483","r","essencialmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00003469","a","emergente","N");
INSERT INTO portuguese_lemma VALUES ("a#01733082","a","emergente","N");
INSERT INTO portuguese_lemma VALUES ("n#03614902","n","unidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03727089","n","unidade","N");
INSERT INTO portuguese_lemma VALUES ("n#06683928","n","unidade","N");
INSERT INTO portuguese_lemma VALUES ("n#09760609","n","unidade","N");
INSERT INTO portuguese_lemma VALUES ("n#09946775","n","unidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03614902","n","todo","N");
INSERT INTO portuguese_lemma VALUES ("a#02269635","a","todo","N");
INSERT INTO portuguese_lemma VALUES ("v#00003826","v","soluçar","N");
INSERT INTO portuguese_lemma VALUES ("a#00003829","a","parturiente","N");
INSERT INTO portuguese_lemma VALUES ("a#00003829","a","parturienta","N");
INSERT INTO portuguese_lemma VALUES ("n#00003993","n","congênere","N");
INSERT INTO portuguese_lemma VALUES ("a#02989167","a","congênere","N");
INSERT INTO portuguese_lemma VALUES ("v#00003011","v","suspirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00667147","v","suspirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01247460","v","suspirar","N");
INSERT INTO portuguese_lemma VALUES ("a#00004171","a","moribundo","N");
INSERT INTO portuguese_lemma VALUES ("r#00004184","r","negativamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00004288","r","negativamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00004227","v","axalar","N");
INSERT INTO portuguese_lemma VALUES ("v#00004227","v","expirar","N");
INSERT INTO portuguese_lemma VALUES ("n#00004258","n","ser_vivo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00002086","n","ser_vivo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00004258","n","organismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00002086","n","organismo","N");
INSERT INTO portuguese_lemma VALUES ("n#06239959","n","organismo","N");
INSERT INTO portuguese_lemma VALUES ("r#00004394","r","amavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00165561","r","amavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00187028","r","amavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00004394","r","naturalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00038625","r","naturalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00140403","r","naturalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00488773","r","naturalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00505352","r","naturalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00004413","a","abreviado","N");
INSERT INTO portuguese_lemma VALUES ("a#01436432","a","abreviado","N");
INSERT INTO portuguese_lemma VALUES ("a#01436791","a","abreviado","N");
INSERT INTO portuguese_lemma VALUES ("a#01442597","a","abreviado","N");
INSERT INTO portuguese_lemma VALUES ("n#00002086","n","criatura","N");
INSERT INTO portuguese_lemma VALUES ("n#00008019","n","criatura","N");
INSERT INTO portuguese_lemma VALUES ("n#07192170","n","criatura","N");
INSERT INTO portuguese_lemma VALUES ("v#00004605","v","emanar","N");
INSERT INTO portuguese_lemma VALUES ("v#00381814","v","emanar","N");
INSERT INTO portuguese_lemma VALUES ("v#00546192","v","emanar","N");
INSERT INTO portuguese_lemma VALUES ("r#00004722","r","todavia","N");
INSERT INTO portuguese_lemma VALUES ("r#00004722","r","simplesmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00005055","r","simplesmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00004722","r","meramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00004722","r","somente","N");
INSERT INTO portuguese_lemma VALUES ("r#00008600","r","somente","N");
INSERT INTO portuguese_lemma VALUES ("r#00011011","r","somente","N");
INSERT INTO portuguese_lemma VALUES ("r#00004722","r","só","N");
INSERT INTO portuguese_lemma VALUES ("a#02143677","a","só","N");
INSERT INTO portuguese_lemma VALUES ("v#00004819","v","espirrar","N");
INSERT INTO portuguese_lemma VALUES ("r#00004967","r","singelamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00246296","r","singelamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00003763","v","inalar","N");
INSERT INTO portuguese_lemma VALUES ("v#00003763","v","inspirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00582621","v","inspirar","N");
INSERT INTO portuguese_lemma VALUES ("a#00005515","a","perfeito","N");
INSERT INTO portuguese_lemma VALUES ("a#00595724","a","perfeito","N");
INSERT INTO portuguese_lemma VALUES ("a#01686285","a","perfeito","N");
INSERT INTO portuguese_lemma VALUES ("a#01687891","a","perfeito","N");
INSERT INTO portuguese_lemma VALUES ("n#13804889","n","perfeito","N");
INSERT INTO portuguese_lemma VALUES ("a#00005515","a","absoluto","N");
INSERT INTO portuguese_lemma VALUES ("a#00684153","a","absoluto","N");
INSERT INTO portuguese_lemma VALUES ("r#00005343","r","possivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00300247","r","possivelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00005526","v","bufar","N");
INSERT INTO portuguese_lemma VALUES ("v#01045073","v","bufar","N");
INSERT INTO portuguese_lemma VALUES ("r#00005567","r","automaticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00114029","r","automaticamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00005599","a","implícito","N");
INSERT INTO portuguese_lemma VALUES ("a#00941485","a","implícito","N");
INSERT INTO portuguese_lemma VALUES ("a#00894544","a","implícito","N");
INSERT INTO portuguese_lemma VALUES ("a#00006265","a","infinito","N");
INSERT INTO portuguese_lemma VALUES ("n#00028651","n","infinito","N");
INSERT INTO portuguese_lemma VALUES ("a#00297667","a","infinito","N");
INSERT INTO portuguese_lemma VALUES ("a#00955713","a","infinito","N");
INSERT INTO portuguese_lemma VALUES ("a#00956714","a","infinito","N");
INSERT INTO portuguese_lemma VALUES ("a#01382215","a","infinito","N");
INSERT INTO portuguese_lemma VALUES ("r#00005779","r","imensamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00005779","r","enormemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00196540","r","enormemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00461617","r","enormemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00005787","n","bentos","N");
INSERT INTO portuguese_lemma VALUES ("v#00005815","v","tossir","N");
INSERT INTO portuguese_lemma VALUES ("v#00121607","v","tossir","N");
INSERT INTO portuguese_lemma VALUES ("n#00005930","n","anão","N");
INSERT INTO portuguese_lemma VALUES ("a#01393024","a","anão","N");
INSERT INTO portuguese_lemma VALUES ("n#09541125","n","anão","N");
INSERT INTO portuguese_lemma VALUES ("n#10040344","n","anão","N");
INSERT INTO portuguese_lemma VALUES ("n#00006024","n","Heterotrofismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00007066","a","relativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00450284","a","relativo","N");
INSERT INTO portuguese_lemma VALUES ("r#00006034","r","grosseiramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00006034","r","indelicadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00006105","r","em_grande_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00065359","r","em_grande_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00006105","r","em_maior_número_das_ocasiões","Y");
INSERT INTO portuguese_lemma VALUES ("r#00006105","r","maioritariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00006105","r","pela_maior_parte","Y");
INSERT INTO portuguese_lemma VALUES ("n#00006150","n","pais","N");
INSERT INTO portuguese_lemma VALUES ("n#00006150","n","progenitor","N");
INSERT INTO portuguese_lemma VALUES ("n#10399491","n","progenitor","N");
INSERT INTO portuguese_lemma VALUES ("v#00006238","v","expectorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00006238","v","cuspir","N");
INSERT INTO portuguese_lemma VALUES ("v#00069271","v","cuspir","N");
INSERT INTO portuguese_lemma VALUES ("v#00069431","v","cuspir","N");
INSERT INTO portuguese_lemma VALUES ("v#02757182","v","cuspir","N");
INSERT INTO portuguese_lemma VALUES ("a#00006245","a","relacional","N");
INSERT INTO portuguese_lemma VALUES ("r#00006259","r","notavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00139266","r","notavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00328378","r","notavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00006259","r","significativamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00367868","r","significativamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00509970","r","significativamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00002880","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#03653606","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#03654105","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#04477455","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#06659588","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#07373813","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#07810857","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#10059340","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#13961642","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#10060845","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#10865688","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#10866015","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#10866163","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("n#15141059","n","vida","N");
INSERT INTO portuguese_lemma VALUES ("a#00006336","a","hidrófilo","N");
INSERT INTO portuguese_lemma VALUES ("a#00006336","a","absorvente","N");
INSERT INTO portuguese_lemma VALUES ("a#01290570","a","absorvente","N");
INSERT INTO portuguese_lemma VALUES ("n#00006400","n","bionte","N");
INSERT INTO portuguese_lemma VALUES ("n#00006400","n","protobionte","N");
INSERT INTO portuguese_lemma VALUES ("n#00003095","n","célula","N");
INSERT INTO portuguese_lemma VALUES ("n#02410439","n","célula","N");
INSERT INTO portuguese_lemma VALUES ("n#06189358","n","célula","N");
INSERT INTO portuguese_lemma VALUES ("v#00006697","v","respirar_ruidosamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00005052","v","assoprar","N");
INSERT INTO portuguese_lemma VALUES ("v#00005052","v","soprar","N");
INSERT INTO portuguese_lemma VALUES ("v#01892072","v","soprar","N");
INSERT INTO portuguese_lemma VALUES ("v#02769642","v","soprar","N");
INSERT INTO portuguese_lemma VALUES ("r#00007015","r","mais_ou_menos","Y");
INSERT INTO portuguese_lemma VALUES ("a#01615410","a","mais_ou_menos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00007015","r","cerca_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00071456","r","cerca_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00007015","r","aproximadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00007015","r","cerca","N");
INSERT INTO portuguese_lemma VALUES ("n#02670460","n","cerca","N");
INSERT INTO portuguese_lemma VALUES ("n#14859100","n","cerca","N");
INSERT INTO portuguese_lemma VALUES ("v#00007328","v","abrir_a_boca","Y");
INSERT INTO portuguese_lemma VALUES ("v#00007328","v","bocejar","N");
INSERT INTO portuguese_lemma VALUES ("v#02718750","v","bocejar","N");
INSERT INTO portuguese_lemma VALUES ("n#00003731","n","agente_causador","Y");
INSERT INTO portuguese_lemma VALUES ("n#00003731","n","causador","N");
INSERT INTO portuguese_lemma VALUES ("n#00003731","n","causa","N");
INSERT INTO portuguese_lemma VALUES ("n#00509919","n","causa","N");
INSERT INTO portuguese_lemma VALUES ("n#00765298","n","causa","N");
INSERT INTO portuguese_lemma VALUES ("n#01182654","n","causa","N");
INSERT INTO portuguese_lemma VALUES ("n#05460141","n","causa","N");
INSERT INTO portuguese_lemma VALUES ("n#06659860","n","causa","N");
INSERT INTO portuguese_lemma VALUES ("r#00007488","r","deveras","N");
INSERT INTO portuguese_lemma VALUES ("a#00007516","a","esponjoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01154964","a","esponjoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00007703","r","em_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00007703","r","parcialmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00007739","v","pestanejar","N");
INSERT INTO portuguese_lemma VALUES ("v#02160177","v","pestanejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00007739","v","piscar","N");
INSERT INTO portuguese_lemma VALUES ("v#02160177","v","piscar","N");
INSERT INTO portuguese_lemma VALUES ("n#00004123","n","alguém","N");
INSERT INTO portuguese_lemma VALUES ("n#06831177","n","alguém","N");
INSERT INTO portuguese_lemma VALUES ("n#00004123","n","ser_humano","Y");
INSERT INTO portuguese_lemma VALUES ("n#01967203","n","ser_humano","Y");
INSERT INTO portuguese_lemma VALUES ("n#00004123","n","pessoa","N");
INSERT INTO portuguese_lemma VALUES ("n#03643456","n","pessoa","N");
INSERT INTO portuguese_lemma VALUES ("n#04056183","n","pessoa","N");
INSERT INTO portuguese_lemma VALUES ("n#04774665","n","pessoa","N");
INSERT INTO portuguese_lemma VALUES ("n#07337458","n","pessoa","N");
INSERT INTO portuguese_lemma VALUES ("n#07392506","n","pessoa","N");
INSERT INTO portuguese_lemma VALUES ("n#07426815","n","pessoa","N");
INSERT INTO portuguese_lemma VALUES ("n#00004123","n","indivíduo","N");
INSERT INTO portuguese_lemma VALUES ("n#07337458","n","indivíduo","N");
INSERT INTO portuguese_lemma VALUES ("a#00008724","a","resistente","N");
INSERT INTO portuguese_lemma VALUES ("a#00661296","a","resistente","N");
INSERT INTO portuguese_lemma VALUES ("a#00673790","a","resistente","N");
INSERT INTO portuguese_lemma VALUES ("a#01709288","a","resistente","N");
INSERT INTO portuguese_lemma VALUES ("r#00008007","r","ao_todo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00008007","r","totalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00008007","r","cem_por_cento","Y");
INSERT INTO portuguese_lemma VALUES ("r#00008997","r","cem_por_cento","Y");
INSERT INTO portuguese_lemma VALUES ("r#00008007","r","cabalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00008007","r","completamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00010466","r","completamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00008007","r","inteiramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00008997","r","inteiramente","N");
INSERT INTO portuguese_lemma VALUES ("v#00008299","v","piscar_o_olho","Y");
INSERT INTO portuguese_lemma VALUES ("v#00005779","v","piscar_de_olhos","Y");
INSERT INTO portuguese_lemma VALUES ("v#00005779","v","piscar_os_olhos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00008600","r","exclusive","N");
INSERT INTO portuguese_lemma VALUES ("r#00008600","r","unicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00175490","r","unicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00008600","r","não_mais_que","Y");
INSERT INTO portuguese_lemma VALUES ("r#00008600","r","exclusivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00175490","r","exclusivamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00008602","v","ser_vesgo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00008602","v","olhar_de_soslaio","Y");
INSERT INTO portuguese_lemma VALUES ("v#00008602","v","vesguear","N");
INSERT INTO portuguese_lemma VALUES ("r#00008997","r","100_por_cento","Y");
INSERT INTO portuguese_lemma VALUES ("r#00008997","r","de_cabo_a_rabo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00008997","r","absolutamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00006226","v","desplumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00006226","v","depenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00006226","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00081068","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00081221","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00111031","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00161987","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00169458","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00384218","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00551065","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00584410","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01544679","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01545057","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#02259005","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#02259241","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01630321","v","trocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00006226","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00074063","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00077276","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00079689","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00082064","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00083639","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00083947","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00140123","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00111031","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00169458","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00201342","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00266041","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00385513","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00551210","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00389126","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00389297","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00584410","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#01855606","v","mudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00009492","v","descamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00009492","v","descamar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00009618","a","ascético","N");
INSERT INTO portuguese_lemma VALUES ("a#02644177","a","ascético","N");
INSERT INTO portuguese_lemma VALUES ("v#00006497","v","saculejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00006497","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("v#00009323","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("v#00009431","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("v#01289419","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("v#01888784","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("v#01289759","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("v#01289878","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("v#01289996","v","tremer","N");
INSERT INTO portuguese_lemma VALUES ("r#00009650","r","perfeitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230996","r","perfeitamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00009884","v","fibrilar","N");
INSERT INTO portuguese_lemma VALUES ("r#00009966","r","por_favor","Y");
INSERT INTO portuguese_lemma VALUES ("r#00009966","r","faça_favor","Y");
INSERT INTO portuguese_lemma VALUES ("a#00009978","a","guloso","N");
INSERT INTO portuguese_lemma VALUES ("n#10132988","n","guloso","N");
INSERT INTO portuguese_lemma VALUES ("a#00009978","a","comilão","N");
INSERT INTO portuguese_lemma VALUES ("r#00010047","r","imperfeitamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00010054","v","mover_reflexivamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00010054","v","mover_involuntariamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00010241","v","agir_involuntariamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00010241","v","agir_reflexivamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00007023","v","agir","N");
INSERT INTO portuguese_lemma VALUES ("v#02376631","v","agir","N");
INSERT INTO portuguese_lemma VALUES ("v#00007023","v","parecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00023357","v","parecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01461214","v","parecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01461433","v","parecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00007023","v","fazer_papel","Y");
INSERT INTO portuguese_lemma VALUES ("v#00007023","v","atuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00741672","v","atuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01177668","v","atuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00007023","v","comportar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#02518161","v","comportar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#02519666","v","comportar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00010466","r","cheiamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00010466","r","em_cheio","Y");
INSERT INTO portuguese_lemma VALUES ("r#00010466","r","plenamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00010726","a","voraz","N");
INSERT INTO portuguese_lemma VALUES ("a#00031138","a","voraz","N");
INSERT INTO portuguese_lemma VALUES ("r#00011516","r","pobremente","N");
INSERT INTO portuguese_lemma VALUES ("r#00011516","r","fracamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036291","r","fracamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00012300","a","abstrato","N");
INSERT INTO portuguese_lemma VALUES ("a#00899226","a","abstrato","N");
INSERT INTO portuguese_lemma VALUES ("v#00012267","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00079910","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00665476","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00698256","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00986409","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01113245","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01114991","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01118767","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01119363","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01119839","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01126333","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01128460","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01130277","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01132676","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01156631","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01173875","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01174962","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01177668","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01188481","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01189395","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01197357","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01799148","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01755504","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01612822","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01617687","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01722366","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01746300","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#02599636","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01788243","v","fazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00012267","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#00063646","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#00403772","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#01511279","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#02208265","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#01513874","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#02212103","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#02238770","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#01532512","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#02288295","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#01564908","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#02359340","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#01722366","v","adquirir","N");
INSERT INTO portuguese_lemma VALUES ("v#00012267","v","conquistar","N");
INSERT INTO portuguese_lemma VALUES ("v#00755606","v","conquistar","N");
INSERT INTO portuguese_lemma VALUES ("v#01575110","v","conquistar","N");
INSERT INTO portuguese_lemma VALUES ("a#00012800","a","concetual","N");
INSERT INTO portuguese_lemma VALUES ("a#00012800","a","conceptual","N");
INSERT INTO portuguese_lemma VALUES ("a#00012800","a","conceitual","N");
INSERT INTO portuguese_lemma VALUES ("v#00012613","v","esfriar","N");
INSERT INTO portuguese_lemma VALUES ("v#00258213","v","esfriar","N");
INSERT INTO portuguese_lemma VALUES ("v#00258652","v","esfriar","N");
INSERT INTO portuguese_lemma VALUES ("v#00012613","v","endurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00302875","v","endurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00303309","v","endurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00417596","v","endurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00290685","v","endurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00309461","v","endurecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00013009","a","ideal","N");
INSERT INTO portuguese_lemma VALUES ("a#01687994","a","ideal","N");
INSERT INTO portuguese_lemma VALUES ("a#02577177","a","ideal","N");
INSERT INTO portuguese_lemma VALUES ("r#00012779","r","bem","N");
INSERT INTO portuguese_lemma VALUES ("r#00013429","r","bem","N");
INSERT INTO portuguese_lemma VALUES ("r#00015471","r","bem","N");
INSERT INTO portuguese_lemma VALUES ("r#00018302","r","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#00018376","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("r#00053004","r","bem","N");
INSERT INTO portuguese_lemma VALUES ("r#00053152","r","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#02476046","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#04005893","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#04006260","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#04015246","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#04017901","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#09533920","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("n#09534283","n","bem","N");
INSERT INTO portuguese_lemma VALUES ("a#02456935","a","ideológico","N");
INSERT INTO portuguese_lemma VALUES ("a#02745555","a","ideológico","N");
INSERT INTO portuguese_lemma VALUES ("a#00013216","a","concreto","N");
INSERT INTO portuguese_lemma VALUES ("a#02151830","a","concreto","N");
INSERT INTO portuguese_lemma VALUES ("n#14820180","n","concreto","N");
INSERT INTO portuguese_lemma VALUES ("v#00008958","v","simular","N");
INSERT INTO portuguese_lemma VALUES ("v#00568049","v","simular","N");
INSERT INTO portuguese_lemma VALUES ("v#00849332","v","simular","N");
INSERT INTO portuguese_lemma VALUES ("v#01178910","v","simular","N");
INSERT INTO portuguese_lemma VALUES ("v#01179881","v","simular","N");
INSERT INTO portuguese_lemma VALUES ("v#01191194","v","simular","N");
INSERT INTO portuguese_lemma VALUES ("a#00013825","a","tangível","N");
INSERT INTO portuguese_lemma VALUES ("a#00592078","a","tangível","N");
INSERT INTO portuguese_lemma VALUES ("a#01717117","a","tangível","N");
INSERT INTO portuguese_lemma VALUES ("a#02391455","a","tangível","N");
INSERT INTO portuguese_lemma VALUES ("a#00014012","a","basto","N");
INSERT INTO portuguese_lemma VALUES ("a#00014012","a","bastante","N");
INSERT INTO portuguese_lemma VALUES ("a#00014561","a","bastante","N");
INSERT INTO portuguese_lemma VALUES ("r#00018302","r","bastante","N");
INSERT INTO portuguese_lemma VALUES ("r#00056539","r","bastante","N");
INSERT INTO portuguese_lemma VALUES ("r#00059171","r","bastante","N");
INSERT INTO portuguese_lemma VALUES ("r#00145571","r","bastante","N");
INSERT INTO portuguese_lemma VALUES ("a#02224478","a","bastante","N");
INSERT INTO portuguese_lemma VALUES ("a#00014012","a","farto","N");
INSERT INTO portuguese_lemma VALUES ("a#01028190","a","farto","N");
INSERT INTO portuguese_lemma VALUES ("a#01734691","a","farto","N");
INSERT INTO portuguese_lemma VALUES ("a#00014012","a","copioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00014561","a","copioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00014012","a","abundante","N");
INSERT INTO portuguese_lemma VALUES ("a#00014561","a","abundante","N");
INSERT INTO portuguese_lemma VALUES ("a#00014897","a","abundante","N");
INSERT INTO portuguese_lemma VALUES ("a#00015183","a","abundante","N");
INSERT INTO portuguese_lemma VALUES ("a#00015684","a","abundante","N");
INSERT INTO portuguese_lemma VALUES ("a#00014012","a","lauto","N");
INSERT INTO portuguese_lemma VALUES ("a#00014561","a","lauto","N");
INSERT INTO portuguese_lemma VALUES ("v#00009323","v","estremecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01289419","v","estremecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01289759","v","estremecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00009323","v","sacudir","N");
INSERT INTO portuguese_lemma VALUES ("v#01281178","v","sacudir","N");
INSERT INTO portuguese_lemma VALUES ("v#01876028","v","sacudir","N");
INSERT INTO portuguese_lemma VALUES ("v#01289996","v","sacudir","N");
INSERT INTO portuguese_lemma VALUES ("v#01890351","v","sacudir","N");
INSERT INTO portuguese_lemma VALUES ("v#01292413","v","sacudir","N");
INSERT INTO portuguese_lemma VALUES ("v#01295618","v","sacudir","N");
INSERT INTO portuguese_lemma VALUES ("v#00009431","v","tiritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01289419","v","tiritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01289759","v","tiritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01289878","v","tiritar","N");
INSERT INTO portuguese_lemma VALUES ("v#00009431","v","bater_queixo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00014285","r","consideravelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00014285","r","substancialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00379432","r","substancialmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00009549","v","descansar","N");
INSERT INTO portuguese_lemma VALUES ("v#00009549","v","cochilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00009805","v","cochilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00015303","v","cochilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00015498","v","cochilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00009549","v","repousar","N");
INSERT INTO portuguese_lemma VALUES ("v#01065785","v","repousar","N");
INSERT INTO portuguese_lemma VALUES ("v#00009549","v","dormir","N");
INSERT INTO portuguese_lemma VALUES ("v#00009805","v","dormir","N");
INSERT INTO portuguese_lemma VALUES ("v#00017282","v","dormir","N");
INSERT INTO portuguese_lemma VALUES ("v#00014549","v","em_atividade","Y");
INSERT INTO portuguese_lemma VALUES ("v#00014549","v","se_movimentando","Y");
INSERT INTO portuguese_lemma VALUES ("v#00009805","v","tirar_uma_soneca","Y");
INSERT INTO portuguese_lemma VALUES ("v#00015303","v","tirar_uma_soneca","Y");
INSERT INTO portuguese_lemma VALUES ("r#00015007","r","intimamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00160659","r","intimamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00015044","a","fácil","N");
INSERT INTO portuguese_lemma VALUES ("a#00714553","a","fácil","N");
INSERT INTO portuguese_lemma VALUES ("a#01803149","a","fácil","N");
INSERT INTO portuguese_lemma VALUES ("v#00015303","v","Power_nap","Y");
INSERT INTO portuguese_lemma VALUES ("v#00015303","v","dormitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00015498","v","dormitar","N");
INSERT INTO portuguese_lemma VALUES ("r#00015368","r","satisfatoriamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00008019","n","bicho","N");
INSERT INTO portuguese_lemma VALUES ("n#02236355","n","bicho","N");
INSERT INTO portuguese_lemma VALUES ("n#10508379","n","bicho","N");
INSERT INTO portuguese_lemma VALUES ("n#00008019","n","besta","N");
INSERT INTO portuguese_lemma VALUES ("n#03136369","n","besta","N");
INSERT INTO portuguese_lemma VALUES ("n#07105886","n","besta","N");
INSERT INTO portuguese_lemma VALUES ("n#00008019","n","animal","N");
INSERT INTO portuguese_lemma VALUES ("a#01212141","a","animal","N");
INSERT INTO portuguese_lemma VALUES ("a#01802774","a","animal","N");
INSERT INTO portuguese_lemma VALUES ("a#00015684","a","abudante","N");
INSERT INTO portuguese_lemma VALUES ("a#01028190","a","abudante","N");
INSERT INTO portuguese_lemma VALUES ("v#00015946","v","hibernar","N");
INSERT INTO portuguese_lemma VALUES ("v#02596004","v","hibernar","N");
INSERT INTO portuguese_lemma VALUES ("r#00015953","r","gravemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00183823","r","gravemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00016532","a","torrencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00601250","a","torrencial","N");
INSERT INTO portuguese_lemma VALUES ("v#00016573","v","cabecear","N");
INSERT INTO portuguese_lemma VALUES ("a#01029155","a","verde","N");
INSERT INTO portuguese_lemma VALUES ("a#00360195","a","verde","N");
INSERT INTO portuguese_lemma VALUES ("a#00395177","a","verde","N");
INSERT INTO portuguese_lemma VALUES ("a#00407480","a","verde","N");
INSERT INTO portuguese_lemma VALUES ("a#01431944","a","verde","N");
INSERT INTO portuguese_lemma VALUES ("a#01864865","a","verde","N");
INSERT INTO portuguese_lemma VALUES ("a#02523929","a","verde","N");
INSERT INTO portuguese_lemma VALUES ("n#03882559","n","verde","N");
INSERT INTO portuguese_lemma VALUES ("a#02226257","a","insuficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#00053941","a","insuficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#00109552","a","insuficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#02225138","a","insuficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#02225593","a","insuficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#02226257","a","escasso","N");
INSERT INTO portuguese_lemma VALUES ("a#00109260","a","escasso","N");
INSERT INTO portuguese_lemma VALUES ("a#00109552","a","escasso","N");
INSERT INTO portuguese_lemma VALUES ("a#01801006","a","escasso","N");
INSERT INTO portuguese_lemma VALUES ("a#02225593","a","escasso","N");
INSERT INTO portuguese_lemma VALUES ("v#00017031","v","ressonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00017031","v","roncar","N");
INSERT INTO portuguese_lemma VALUES ("v#00619854","v","roncar","N");
INSERT INTO portuguese_lemma VALUES ("n#00008864","n","vida_vegetal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00008864","n","vegetal","N");
INSERT INTO portuguese_lemma VALUES ("a#00111046","a","vegetal","N");
INSERT INTO portuguese_lemma VALUES ("n#07707451","n","vegetal","N");
INSERT INTO portuguese_lemma VALUES ("n#07708798","n","vegetal","N");
INSERT INTO portuguese_lemma VALUES ("n#07709333","n","vegetal","N");
INSERT INTO portuguese_lemma VALUES ("n#07713895","n","vegetal","N");
INSERT INTO portuguese_lemma VALUES ("n#12212361","n","vegetal","N");
INSERT INTO portuguese_lemma VALUES ("n#00008864","n","flora","N");
INSERT INTO portuguese_lemma VALUES ("n#06240750","n","flora","N");
INSERT INTO portuguese_lemma VALUES ("n#00008864","n","planta","N");
INSERT INTO portuguese_lemma VALUES ("n#02856109","n","planta","N");
INSERT INTO portuguese_lemma VALUES ("n#02563119","n","planta","N");
INSERT INTO portuguese_lemma VALUES ("r#00017241","r","pior","N");
INSERT INTO portuguese_lemma VALUES ("a#00227300","a","pior","N");
INSERT INTO portuguese_lemma VALUES ("a#00229218","a","pior","N");
INSERT INTO portuguese_lemma VALUES ("a#00232068","a","pior","N");
INSERT INTO portuguese_lemma VALUES ("v#00017282","v","adormecer","N");
INSERT INTO portuguese_lemma VALUES ("r#00017639","r","ainda","N");
INSERT INTO portuguese_lemma VALUES ("r#00027795","r","ainda","N");
INSERT INTO portuguese_lemma VALUES ("r#00027918","r","ainda","N");
INSERT INTO portuguese_lemma VALUES ("r#00031304","r","ainda","N");
INSERT INTO portuguese_lemma VALUES ("r#00047534","r","ainda","N");
INSERT INTO portuguese_lemma VALUES ("a#00018244","a","aceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#00968443","a","aceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#01077729","a","aceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#01761871","a","aceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#02187477","a","aceitável","N");
INSERT INTO portuguese_lemma VALUES ("v#00017865","v","deitar-se_na_cama","Y");
INSERT INTO portuguese_lemma VALUES ("v#00017865","v","cair_no_sono_aos_poucos","Y");
INSERT INTO portuguese_lemma VALUES ("v#00012725","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#00693379","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#00998639","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#00999117","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01546768","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01079137","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01086949","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01611359","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01969601","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01343923","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01975587","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01351052","v","levantar","N");
INSERT INTO portuguese_lemma VALUES ("v#00012725","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#00998639","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#00999117","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#01546768","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#01611359","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#01343923","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#01345256","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#01351052","v","erguer","N");
INSERT INTO portuguese_lemma VALUES ("v#00012846","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00013061","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00020133","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00016821","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00208055","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00541962","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00547364","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#01894164","v","acordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00012846","v","levantar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01969216","v","levantar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00012846","v","despertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00013061","v","despertar","N");
INSERT INTO portuguese_lemma VALUES ("n#01259773","n","despertar","N");
INSERT INTO portuguese_lemma VALUES ("a#00018584","a","inadmissível","N");
INSERT INTO portuguese_lemma VALUES ("a#01762582","a","inadmissível","N");
INSERT INTO portuguese_lemma VALUES ("a#00018584","a","inaceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#00018850","a","inaceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#02083053","a","inaceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#02298766","a","inaceitável","N");
INSERT INTO portuguese_lemma VALUES ("a#02317021","a","inaceitável","N");
INSERT INTO portuguese_lemma VALUES ("n#00019046","n","nativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01037148","a","nativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00019128","n","natureza","N");
INSERT INTO portuguese_lemma VALUES ("n#03647591","n","natureza","N");
INSERT INTO portuguese_lemma VALUES ("n#03716446","n","natureza","N");
INSERT INTO portuguese_lemma VALUES ("n#06691078","n","natureza","N");
INSERT INTO portuguese_lemma VALUES ("n#06860237","n","natureza","N");
INSERT INTO portuguese_lemma VALUES ("n#00019128","n","objeto_natural","Y");
INSERT INTO portuguese_lemma VALUES ("r#00019339","r","sempre","N");
INSERT INTO portuguese_lemma VALUES ("r#00020280","r","sempre","N");
INSERT INTO portuguese_lemma VALUES ("r#00020476","r","sempre","N");
INSERT INTO portuguese_lemma VALUES ("r#00088931","r","sempre","N");
INSERT INTO portuguese_lemma VALUES ("r#00227968","r","sempre","N");
INSERT INTO portuguese_lemma VALUES ("v#00013620","v","afetar","N");
INSERT INTO portuguese_lemma VALUES ("v#00091848","v","afetar","N");
INSERT INTO portuguese_lemma VALUES ("v#00822999","v","afetar","N");
INSERT INTO portuguese_lemma VALUES ("v#01206630","v","afetar","N");
INSERT INTO portuguese_lemma VALUES ("n#09947198","n","substância","N");
INSERT INTO portuguese_lemma VALUES ("n#00020090","n","substância","N");
INSERT INTO portuguese_lemma VALUES ("n#00020827","n","substância","N");
INSERT INTO portuguese_lemma VALUES ("n#04546812","n","substância","N");
INSERT INTO portuguese_lemma VALUES ("n#14806838","n","substância","N");
INSERT INTO portuguese_lemma VALUES ("a#00020860","a","cômodo","N");
INSERT INTO portuguese_lemma VALUES ("a#00020860","a","prático","N");
INSERT INTO portuguese_lemma VALUES ("a#00572128","a","prático","N");
INSERT INTO portuguese_lemma VALUES ("a#01762874","a","prático","N");
INSERT INTO portuguese_lemma VALUES ("a#01871755","a","prático","N");
INSERT INTO portuguese_lemma VALUES ("a#00020860","a","útil","N");
INSERT INTO portuguese_lemma VALUES ("a#00527630","a","útil","N");
INSERT INTO portuguese_lemma VALUES ("a#00572128","a","útil","N");
INSERT INTO portuguese_lemma VALUES ("a#01039045","a","útil","N");
INSERT INTO portuguese_lemma VALUES ("v#00013890","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00585325","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00758805","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00759367","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00760028","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00762743","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00764752","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01750864","v","atacar","N");
INSERT INTO portuguese_lemma VALUES ("a#00019874","a","que_não_pode_ser_acessado","Y");
INSERT INTO portuguese_lemma VALUES ("a#00019874","a","inacessível","N");
INSERT INTO portuguese_lemma VALUES ("a#00021389","a","inacessível","N");
INSERT INTO portuguese_lemma VALUES ("a#00185921","a","inacessível","N");
INSERT INTO portuguese_lemma VALUES ("a#00186193","a","inacessível","N");
INSERT INTO portuguese_lemma VALUES ("v#00019982","v","ulcerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00537153","v","ulcerar","N");
INSERT INTO portuguese_lemma VALUES ("a#00021389","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("r#00166318","r","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#00410709","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#00411239","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#00411449","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#00411646","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#00414420","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#00419892","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#01377805","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#01915914","a","distante","N");
INSERT INTO portuguese_lemma VALUES ("a#00021389","a","isolado","N");
INSERT INTO portuguese_lemma VALUES ("a#00535306","a","isolado","N");
INSERT INTO portuguese_lemma VALUES ("a#01788497","a","isolado","N");
INSERT INTO portuguese_lemma VALUES ("a#02036124","a","isolado","N");
INSERT INTO portuguese_lemma VALUES ("a#02036731","a","isolado","N");
INSERT INTO portuguese_lemma VALUES ("a#02143903","a","isolado","N");
INSERT INTO portuguese_lemma VALUES ("r#00020142","r","sucessivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00020142","r","consecutivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00020280","r","constantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00050186","r","constantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00174491","r","constantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00282858","r","constantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00020280","r","continuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00088931","r","continuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00282858","r","continuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00020280","r","eternamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00087542","r","eternamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00087916","r","eternamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00089076","r","eternamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00332596","r","eternamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00332596","r","eternamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00020280","r","perpetuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00227968","r","perpetuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00332596","r","perpetuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00020280","r","incessantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00282858","r","incessantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00020476","r","de_forma_contínua","Y");
INSERT INTO portuguese_lemma VALUES ("r#00020476","r","de_forma_constante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00020476","r","invariavelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00020671","v","mesmerizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00020671","v","hipnotizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00020759","r","jamais","N");
INSERT INTO portuguese_lemma VALUES ("r#00020759","r","em_tempo_algum","Y");
INSERT INTO portuguese_lemma VALUES ("r#00020759","r","nunca","N");
INSERT INTO portuguese_lemma VALUES ("a#00022378","a","prestável","N");
INSERT INTO portuguese_lemma VALUES ("a#01145952","a","prestável","N");
INSERT INTO portuguese_lemma VALUES ("a#01146379","a","prestável","N");
INSERT INTO portuguese_lemma VALUES ("n#00020827","n","matéria","N");
INSERT INTO portuguese_lemma VALUES ("n#04479710","n","matéria","N");
INSERT INTO portuguese_lemma VALUES ("n#04950638","n","matéria","N");
INSERT INTO portuguese_lemma VALUES ("n#05005867","n","matéria","N");
INSERT INTO portuguese_lemma VALUES ("v#00021065","v","anestesiar","N");
INSERT INTO portuguese_lemma VALUES ("a#00022683","a","obsequioso","N");
INSERT INTO portuguese_lemma VALUES ("r#00021212","r","ocasionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00021212","r","vez_por_outra","Y");
INSERT INTO portuguese_lemma VALUES ("r#00021212","r","de_quando_em_quando","Y");
INSERT INTO portuguese_lemma VALUES ("r#00021212","r","de_vez_em_quando","Y");
INSERT INTO portuguese_lemma VALUES ("r#00021212","r","uma_vez","Y");
INSERT INTO portuguese_lemma VALUES ("r#00021878","r","uma_vez","Y");
INSERT INTO portuguese_lemma VALUES ("r#00118869","r","uma_vez","Y");
INSERT INTO portuguese_lemma VALUES ("r#00021212","r","outrora","N");
INSERT INTO portuguese_lemma VALUES ("r#00021878","r","outrora","N");
INSERT INTO portuguese_lemma VALUES ("n#00011575","n","alimento","N");
INSERT INTO portuguese_lemma VALUES ("n#07556637","n","alimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05617748","n","alimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05622219","n","alimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05625967","n","alimento","N");
INSERT INTO portuguese_lemma VALUES ("n#09626009","n","alimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05834217","n","alimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00011575","n","comida","N");
INSERT INTO portuguese_lemma VALUES ("n#05625967","n","comida","N");
INSERT INTO portuguese_lemma VALUES ("n#09626009","n","comida","N");
INSERT INTO portuguese_lemma VALUES ("n#00011575","n","nutriente","N");
INSERT INTO portuguese_lemma VALUES ("n#00021734","n","nutriente","N");
INSERT INTO portuguese_lemma VALUES ("n#00021734","n","Nutrientes","N");
INSERT INTO portuguese_lemma VALUES ("a#00023303","a","exacto","N");
INSERT INTO portuguese_lemma VALUES ("a#00595724","a","exacto","N");
INSERT INTO portuguese_lemma VALUES ("a#00023303","a","acurado","N");
INSERT INTO portuguese_lemma VALUES ("a#00023303","a","justo","N");
INSERT INTO portuguese_lemma VALUES ("a#00595353","a","justo","N");
INSERT INTO portuguese_lemma VALUES ("a#00958151","a","justo","N");
INSERT INTO portuguese_lemma VALUES ("a#01447937","a","justo","N");
INSERT INTO portuguese_lemma VALUES ("a#01963374","a","justo","N");
INSERT INTO portuguese_lemma VALUES ("a#02526441","a","justo","N");
INSERT INTO portuguese_lemma VALUES ("a#00023303","a","exato","N");
INSERT INTO portuguese_lemma VALUES ("a#00595724","a","exato","N");
INSERT INTO portuguese_lemma VALUES ("a#00867566","a","exato","N");
INSERT INTO portuguese_lemma VALUES ("a#00023303","a","preciso","N");
INSERT INTO portuguese_lemma VALUES ("a#00595724","a","preciso","N");
INSERT INTO portuguese_lemma VALUES ("a#00867566","a","preciso","N");
INSERT INTO portuguese_lemma VALUES ("a#01765920","a","preciso","N");
INSERT INTO portuguese_lemma VALUES ("r#00021878","r","às_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00021878","r","por_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00021878","r","as_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("n#00021939","n","artefato","N");
INSERT INTO portuguese_lemma VALUES ("n#00021939","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#02749953","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#02476046","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#02987655","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#03175725","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#03640400","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#04510165","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#11415842","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#10763715","n","produto","N");
INSERT INTO portuguese_lemma VALUES ("n#00021939","n","utensílio","N");
INSERT INTO portuguese_lemma VALUES ("n#04516672","n","utensílio","N");
INSERT INTO portuguese_lemma VALUES ("r#00022131","r","da_mesma_maneira_que","Y");
INSERT INTO portuguese_lemma VALUES ("r#00022131","r","tanto_quanto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00023738","a","fiel","N");
INSERT INTO portuguese_lemma VALUES ("a#00911761","a","fiel","N");
INSERT INTO portuguese_lemma VALUES ("a#00961392","a","fiel","N");
INSERT INTO portuguese_lemma VALUES ("r#00022401","r","a_muito_tempo_atrás","Y");
INSERT INTO portuguese_lemma VALUES ("v#00015782","v","energizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00015782","v","excitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00558963","v","excitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00559102","v","excitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01202849","v","excitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01202989","v","excitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01225706","v","excitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01448459","v","excitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00015782","v","estimular","N");
INSERT INTO portuguese_lemma VALUES ("v#00350457","v","estimular","N");
INSERT INTO portuguese_lemma VALUES ("v#00539509","v","estimular","N");
INSERT INTO portuguese_lemma VALUES ("v#01133437","v","estimular","N");
INSERT INTO portuguese_lemma VALUES ("v#01200852","v","estimular","N");
INSERT INTO portuguese_lemma VALUES ("v#01448459","v","estimular","N");
INSERT INTO portuguese_lemma VALUES ("v#01741432","v","estimular","N");
INSERT INTO portuguese_lemma VALUES ("v#00015782","v","animar","N");
INSERT INTO portuguese_lemma VALUES ("v#00260180","v","animar","N");
INSERT INTO portuguese_lemma VALUES ("v#00582994","v","animar","N");
INSERT INTO portuguese_lemma VALUES ("v#01202849","v","animar","N");
INSERT INTO portuguese_lemma VALUES ("v#01210207","v","animar","N");
INSERT INTO portuguese_lemma VALUES ("r#00022829","r","praticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00053512","r","praticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00053744","r","praticamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00022852","a","cirúrgico","N");
INSERT INTO portuguese_lemma VALUES ("a#02670911","a","cirúrgico","N");
INSERT INTO portuguese_lemma VALUES ("a#02888968","a","cirúrgico","N");
INSERT INTO portuguese_lemma VALUES ("n#00012704","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#02214249","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#02476046","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#02987655","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#04550840","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#04739220","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#06269956","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#04771731","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#04819775","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#06681177","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#05009327","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("n#05010999","n","artigo","N");
INSERT INTO portuguese_lemma VALUES ("r#00023074","r","em_tal_quantidade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00023074","r","tanto","N");
INSERT INTO portuguese_lemma VALUES ("a#01491308","a","tanto","N");
INSERT INTO portuguese_lemma VALUES ("n#00023100","n","característica_psicológica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00023263","r","paradoxalmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00013243","n","cognição","N");
INSERT INTO portuguese_lemma VALUES ("n#00013243","n","compreensão","N");
INSERT INTO portuguese_lemma VALUES ("n#04044520","n","compreensão","N");
INSERT INTO portuguese_lemma VALUES ("n#04473075","n","compreensão","N");
INSERT INTO portuguese_lemma VALUES ("n#04473430","n","compreensão","N");
INSERT INTO portuguese_lemma VALUES ("n#04474097","n","compreensão","N");
INSERT INTO portuguese_lemma VALUES ("n#04474949","n","compreensão","N");
INSERT INTO portuguese_lemma VALUES ("n#04699267","n","compreensão","N");
INSERT INTO portuguese_lemma VALUES ("n#00013243","n","conhecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05640729","n","conhecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#04387608","n","conhecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05677952","n","conhecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05999266","n","conhecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00013243","n","noção","N");
INSERT INTO portuguese_lemma VALUES ("n#04494358","n","noção","N");
INSERT INTO portuguese_lemma VALUES ("n#04545843","n","noção","N");
INSERT INTO portuguese_lemma VALUES ("v#00023646","v","desfalecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00023646","v","esvanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00293522","v","esvanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00023646","v","desmaiar","N");
INSERT INTO portuguese_lemma VALUES ("n#00013700","n","motivação","N");
INSERT INTO portuguese_lemma VALUES ("n#00013700","n","motivo","N");
INSERT INTO portuguese_lemma VALUES ("n#04546376","n","motivo","N");
INSERT INTO portuguese_lemma VALUES ("n#05270769","n","motivo","N");
INSERT INTO portuguese_lemma VALUES ("n#05271609","n","motivo","N");
INSERT INTO portuguese_lemma VALUES ("n#06659860","n","motivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00013700","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04533598","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04546018","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04586952","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04587307","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04588033","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#05982720","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04588594","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04588994","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04951584","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#04955260","n","intenção","N");
INSERT INTO portuguese_lemma VALUES ("n#00013700","n","necessidade","N");
INSERT INTO portuguese_lemma VALUES ("n#06846327","n","necessidade","N");
INSERT INTO portuguese_lemma VALUES ("n#09367991","n","necessidade","N");
INSERT INTO portuguese_lemma VALUES ("n#10367157","n","necessidade","N");
INSERT INTO portuguese_lemma VALUES ("n#14450691","n","necessidade","N");
INSERT INTO portuguese_lemma VALUES ("a#00023854","a","errado","N");
INSERT INTO portuguese_lemma VALUES ("a#00596241","a","errado","N");
INSERT INTO portuguese_lemma VALUES ("a#01694081","a","errado","N");
INSERT INTO portuguese_lemma VALUES ("a#02036397","a","errado","N");
INSERT INTO portuguese_lemma VALUES ("a#02234253","a","errado","N");
INSERT INTO portuguese_lemma VALUES ("a#02343098","a","errado","N");
INSERT INTO portuguese_lemma VALUES ("a#00023854","a","equivocado","N");
INSERT INTO portuguese_lemma VALUES ("a#01224253","a","equivocado","N");
INSERT INTO portuguese_lemma VALUES ("r#00024073","r","não","N");
INSERT INTO portuguese_lemma VALUES ("n#05383289","n","não","N");
INSERT INTO portuguese_lemma VALUES ("a#00024139","a","infiel","N");
INSERT INTO portuguese_lemma VALUES ("a#00959731","a","infiel","N");
INSERT INTO portuguese_lemma VALUES ("a#00960971","a","infiel","N");
INSERT INTO portuguese_lemma VALUES ("a#00962939","a","infiel","N");
INSERT INTO portuguese_lemma VALUES ("n#00024264","n","atributo","N");
INSERT INTO portuguese_lemma VALUES ("n#00024264","n","predicado","N");
INSERT INTO portuguese_lemma VALUES ("n#00024264","n","propriedade","N");
INSERT INTO portuguese_lemma VALUES ("n#00018376","n","propriedade","N");
INSERT INTO portuguese_lemma VALUES ("n#00517391","n","propriedade","N");
INSERT INTO portuguese_lemma VALUES ("n#04015246","n","propriedade","N");
INSERT INTO portuguese_lemma VALUES ("n#09525525","n","propriedade","N");
INSERT INTO portuguese_lemma VALUES ("n#09528888","n","propriedade","N");
INSERT INTO portuguese_lemma VALUES ("n#09534283","n","propriedade","N");
INSERT INTO portuguese_lemma VALUES ("n#00024264","n","característica","N");
INSERT INTO portuguese_lemma VALUES ("n#03719538","n","característica","N");
INSERT INTO portuguese_lemma VALUES ("n#04504455","n","característica","N");
INSERT INTO portuguese_lemma VALUES ("n#05102576","n","característica","N");
INSERT INTO portuguese_lemma VALUES ("v#00024279","v","dar_ação","Y");
INSERT INTO portuguese_lemma VALUES ("a#00025588","a","costumado","N");
INSERT INTO portuguese_lemma VALUES ("a#00025588","a","habitual","N");
INSERT INTO portuguese_lemma VALUES ("a#00456499","a","habitual","N");
INSERT INTO portuguese_lemma VALUES ("a#01576838","a","habitual","N");
INSERT INTO portuguese_lemma VALUES ("a#00457087","a","habitual","N");
INSERT INTO portuguese_lemma VALUES ("a#00573324","a","habitual","N");
INSERT INTO portuguese_lemma VALUES ("a#01014088","a","habitual","N");
INSERT INTO portuguese_lemma VALUES ("a#00025588","a","habituado","N");
INSERT INTO portuguese_lemma VALUES ("a#00025790","a","habituado","N");
INSERT INTO portuguese_lemma VALUES ("a#01576838","a","habituado","N");
INSERT INTO portuguese_lemma VALUES ("a#00025790","a","usual","N");
INSERT INTO portuguese_lemma VALUES ("a#00456499","a","usual","N");
INSERT INTO portuguese_lemma VALUES ("a#01576838","a","usual","N");
INSERT INTO portuguese_lemma VALUES ("a#00970610","a","usual","N");
INSERT INTO portuguese_lemma VALUES ("v#00024649","v","refrescar","N");
INSERT INTO portuguese_lemma VALUES ("v#00024814","v","refrescar","N");
INSERT INTO portuguese_lemma VALUES ("v#00164444","v","refrescar","N");
INSERT INTO portuguese_lemma VALUES ("v#00258213","v","refrescar","N");
INSERT INTO portuguese_lemma VALUES ("v#00370126","v","refrescar","N");
INSERT INTO portuguese_lemma VALUES ("v#00258652","v","refrescar","N");
INSERT INTO portuguese_lemma VALUES ("n#00016185","n","estado","N");
INSERT INTO portuguese_lemma VALUES ("n#06374245","n","estado","N");
INSERT INTO portuguese_lemma VALUES ("n#10031939","n","estado","N");
INSERT INTO portuguese_lemma VALUES ("n#10032130","n","estado","N");
INSERT INTO portuguese_lemma VALUES ("n#10048803","n","estado","N");
INSERT INTO portuguese_lemma VALUES ("n#10345365","n","estado","N");
INSERT INTO portuguese_lemma VALUES ("n#00016185","n","situação","N");
INSERT INTO portuguese_lemma VALUES ("n#03960878","n","situação","N");
INSERT INTO portuguese_lemma VALUES ("n#06353805","n","situação","N");
INSERT INTO portuguese_lemma VALUES ("n#10032130","n","situação","N");
INSERT INTO portuguese_lemma VALUES ("n#10034299","n","situação","N");
INSERT INTO portuguese_lemma VALUES ("n#10035141","n","situação","N");
INSERT INTO portuguese_lemma VALUES ("n#00016185","n","condição","N");
INSERT INTO portuguese_lemma VALUES ("n#10032130","n","condição","N");
INSERT INTO portuguese_lemma VALUES ("n#13923030","n","condição","N");
INSERT INTO portuguese_lemma VALUES ("n#10035141","n","condição","N");
INSERT INTO portuguese_lemma VALUES ("n#10048803","n","condição","N");
INSERT INTO portuguese_lemma VALUES ("r#00024893","r","um_ou_outro","Y");
INSERT INTO portuguese_lemma VALUES ("r#00024893","r","também_não","Y");
INSERT INTO portuguese_lemma VALUES ("a#00026167","a","novo","N");
INSERT INTO portuguese_lemma VALUES ("a#00778835","a","novo","N");
INSERT INTO portuguese_lemma VALUES ("a#01581807","a","novo","N");
INSERT INTO portuguese_lemma VALUES ("a#01582587","a","novo","N");
INSERT INTO portuguese_lemma VALUES ("a#01583415","a","novo","N");
INSERT INTO portuguese_lemma VALUES ("a#01627275","a","novo","N");
INSERT INTO portuguese_lemma VALUES ("a#01666848","a","novo","N");
INSERT INTO portuguese_lemma VALUES ("v#00017738","v","estressar","N");
INSERT INTO portuguese_lemma VALUES ("a#00026478","a","ácida","N");
INSERT INTO portuguese_lemma VALUES ("r#00025290","r","para_qualquer_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00025290","r","em_qualquer_lugar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00025290","r","algures","N");
INSERT INTO portuguese_lemma VALUES ("r#00025290","r","nenhures","N");
INSERT INTO portuguese_lemma VALUES ("r#00025290","r","em_qualquer_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00025464","r","em_nenhum_lugar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00025464","r","em_nenhuma_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00025464","r","em_parte_alguma","Y");
INSERT INTO portuguese_lemma VALUES ("a#00026658","a","azeda","N");
INSERT INTO portuguese_lemma VALUES ("a#00026658","a","ácido","N");
INSERT INTO portuguese_lemma VALUES ("a#02369179","a","ácido","N");
INSERT INTO portuguese_lemma VALUES ("n#10463819","n","ácido","N");
INSERT INTO portuguese_lemma VALUES ("r#00025559","r","algum_lugar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00025728","a","alcalino","N");
INSERT INTO portuguese_lemma VALUES ("r#00025728","r","em_toda_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00025728","r","em_todo_o_lugar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00025728","r","em_toda_a_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00026137","r","de_alguma_forma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00026137","r","por_algum_meio","Y");
INSERT INTO portuguese_lemma VALUES ("n#00014045","n","emoção","N");
INSERT INTO portuguese_lemma VALUES ("n#05560772","n","emoção","N");
INSERT INTO portuguese_lemma VALUES ("n#05560878","n","emoção","N");
INSERT INTO portuguese_lemma VALUES ("n#05596946","n","emoção","N");
INSERT INTO portuguese_lemma VALUES ("n#00014045","n","sentimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05560878","n","sentimento","N");
INSERT INTO portuguese_lemma VALUES ("n#07481951","n","sentimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00014045","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#02852588","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#03172719","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#03684009","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#04439113","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#04544110","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#04944510","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#05006313","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#05129243","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("n#10013828","n","impressão","N");
INSERT INTO portuguese_lemma VALUES ("v#00018644","v","descontrair","N");
INSERT INTO portuguese_lemma VALUES ("v#00018644","v","pegar_leve","Y");
INSERT INTO portuguese_lemma VALUES ("v#00018644","v","relaxar","N");
INSERT INTO portuguese_lemma VALUES ("a#00197151","a","relaxar","N");
INSERT INTO portuguese_lemma VALUES ("a#00026515","a","anfotérico","N");
INSERT INTO portuguese_lemma VALUES ("r#00026571","r","de_qualquer_forma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00026571","r","em_todo_o_caso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00026571","r","de_qualquer_maneira","Y");
INSERT INTO portuguese_lemma VALUES ("r#00026571","r","de_qualquer_jeito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","de_qualquer_jeito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00026571","r","além_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00029037","r","além_de","Y");
INSERT INTO portuguese_lemma VALUES ("n#00014887","n","localização","N");
INSERT INTO portuguese_lemma VALUES ("n#00101111","n","localização","N");
INSERT INTO portuguese_lemma VALUES ("n#03682189","n","localização","N");
INSERT INTO portuguese_lemma VALUES ("n#03960878","n","localização","N");
INSERT INTO portuguese_lemma VALUES ("n#00014887","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#05542893","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#04514257","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#05096549","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#05101450","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#05106558","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#05126526","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#10025218","n","ponto","N");
INSERT INTO portuguese_lemma VALUES ("n#00014887","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#06483454","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#08490039","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#08500433","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#06351684","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#06352837","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#06353805","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#06354148","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#06368526","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#08653706","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#06391607","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("n#13947415","n","lugar","N");
INSERT INTO portuguese_lemma VALUES ("r#00027258","r","de_qualquer_modo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00019111","v","estender","N");
INSERT INTO portuguese_lemma VALUES ("v#00105798","v","estender","N");
INSERT INTO portuguese_lemma VALUES ("v#00209671","v","estender","N");
INSERT INTO portuguese_lemma VALUES ("v#00377885","v","estender","N");
INSERT INTO portuguese_lemma VALUES ("v#00019111","v","esticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00028167","v","esticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00240810","v","esticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00221402","v","esticar","N");
INSERT INTO portuguese_lemma VALUES ("v#01449591","v","esticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00019111","v","alongar","N");
INSERT INTO portuguese_lemma VALUES ("v#00219507","v","alongar","N");
INSERT INTO portuguese_lemma VALUES ("v#00220504","v","alongar","N");
INSERT INTO portuguese_lemma VALUES ("v#00221402","v","alongar","N");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","no_entanto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","contudo","N");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","por_mais_que","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","apesar_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","porém","N");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","apesar_disso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","não_obstante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","ainda_assim","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027384","r","se_bobear","Y");
INSERT INTO portuguese_lemma VALUES ("a#00028460","a","aceitado","N");
INSERT INTO portuguese_lemma VALUES ("a#00028460","a","aceito","N");
INSERT INTO portuguese_lemma VALUES ("a#00028460","a","reconhecido","N");
INSERT INTO portuguese_lemma VALUES ("a#01146493","a","reconhecido","N");
INSERT INTO portuguese_lemma VALUES ("a#01636507","a","reconhecido","N");
INSERT INTO portuguese_lemma VALUES ("n#00015185","n","forma_geométrica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00015185","n","forma","N");
INSERT INTO portuguese_lemma VALUES ("n#03858557","n","forma","N");
INSERT INTO portuguese_lemma VALUES ("n#00015185","n","formato","N");
INSERT INTO portuguese_lemma VALUES ("n#04677385","n","formato","N");
INSERT INTO portuguese_lemma VALUES ("n#06636806","n","formato","N");
INSERT INTO portuguese_lemma VALUES ("r#00027918","r","até_agora","Y");
INSERT INTO portuguese_lemma VALUES ("r#00172151","r","até_agora","Y");
INSERT INTO portuguese_lemma VALUES ("r#00027918","r","até","N");
INSERT INTO portuguese_lemma VALUES ("r#00027918","r","até_então","Y");
INSERT INTO portuguese_lemma VALUES ("a#00028181","a","declarável","N");
INSERT INTO portuguese_lemma VALUES ("n#00015594","n","espaço_temporal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00015594","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#05302217","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#11456462","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#07847974","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10843624","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10850147","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10945309","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10947554","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10947841","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10953446","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10955141","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#15269513","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("n#10969191","n","tempo","N");
INSERT INTO portuguese_lemma VALUES ("a#00029357","a","suposto","N");
INSERT INTO portuguese_lemma VALUES ("a#00608628","a","suposto","N");
INSERT INTO portuguese_lemma VALUES ("a#01357137","a","suposto","N");
INSERT INTO portuguese_lemma VALUES ("a#01357609","a","suposto","N");
INSERT INTO portuguese_lemma VALUES ("a#01559282","a","suposto","N");
INSERT INTO portuguese_lemma VALUES ("a#01846462","a","suposto","N");
INSERT INTO portuguese_lemma VALUES ("a#00029512","a","putativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00019944","v","sorrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00020314","v","sorrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00020449","v","sorrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00020571","v","sorrir","N");
INSERT INTO portuguese_lemma VALUES ("n#00028651","n","espaço","N");
INSERT INTO portuguese_lemma VALUES ("n#00029007","n","espaço","N");
INSERT INTO portuguese_lemma VALUES ("n#06862202","n","espaço","N");
INSERT INTO portuguese_lemma VALUES ("n#09922737","n","espaço","N");
INSERT INTO portuguese_lemma VALUES ("n#10024194","n","espaço","N");
INSERT INTO portuguese_lemma VALUES ("r#00029037","r","fora","N");
INSERT INTO portuguese_lemma VALUES ("r#00110919","r","fora","N");
INSERT INTO portuguese_lemma VALUES ("n#00029114","n","espaço_fásico","Y");
INSERT INTO portuguese_lemma VALUES ("a#00029343","a","sequioso","N");
INSERT INTO portuguese_lemma VALUES ("a#01270004","a","sequioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00029343","a","cobiçoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00029367","r","além_disso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00029367","r","em_continuação","Y");
INSERT INTO portuguese_lemma VALUES ("r#00029367","r","mais_adiante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00029367","r","aliás","N");
INSERT INTO portuguese_lemma VALUES ("r#00156222","r","aliás","N");
INSERT INTO portuguese_lemma VALUES ("r#00029367","r","demais","N");
INSERT INTO portuguese_lemma VALUES ("r#00047392","r","demais","N");
INSERT INTO portuguese_lemma VALUES ("r#00029367","r","ademais","N");
INSERT INTO portuguese_lemma VALUES ("r#00046167","r","ademais","N");
INSERT INTO portuguese_lemma VALUES ("r#00080304","r","ademais","N");
INSERT INTO portuguese_lemma VALUES ("r#00029367","r","mais","N");
INSERT INTO portuguese_lemma VALUES ("r#00099712","r","mais","N");
INSERT INTO portuguese_lemma VALUES ("n#00017297","n","acontecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05432762","n","acontecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05437656","n","acontecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05538537","n","acontecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00017297","n","evento","N");
INSERT INTO portuguese_lemma VALUES ("n#05432762","n","evento","N");
INSERT INTO portuguese_lemma VALUES ("n#05437656","n","evento","N");
INSERT INTO portuguese_lemma VALUES ("n#05447746","n","evento","N");
INSERT INTO portuguese_lemma VALUES ("n#00017297","n","fato","N");
INSERT INTO portuguese_lemma VALUES ("n#03438739","n","fato","N");
INSERT INTO portuguese_lemma VALUES ("n#04482936","n","fato","N");
INSERT INTO portuguese_lemma VALUES ("v#00029630","v","zurrar","N");
INSERT INTO portuguese_lemma VALUES ("r#00029639","r","mais_longe","Y");
INSERT INTO portuguese_lemma VALUES ("n#09669871","n","processos_físicos","Y");
INSERT INTO portuguese_lemma VALUES ("a#00029769","a","acumulativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00029769","a","cumulativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00048460","a","cumulativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00029933","a","ganancioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00029933","a","avaro","N");
INSERT INTO portuguese_lemma VALUES ("a#00029933","a","ávido","N");
INSERT INTO portuguese_lemma VALUES ("a#00771844","a","ávido","N");
INSERT INTO portuguese_lemma VALUES ("a#00843026","a","ávido","N");
INSERT INTO portuguese_lemma VALUES ("a#00844949","a","ávido","N");
INSERT INTO portuguese_lemma VALUES ("a#01063943","a","ávido","N");
INSERT INTO portuguese_lemma VALUES ("r#00029985","r","mais_afastado","Y");
INSERT INTO portuguese_lemma VALUES ("v#00020971","v","casquinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00017487","n","ato","N");
INSERT INTO portuguese_lemma VALUES ("n#00022246","n","ato","N");
INSERT INTO portuguese_lemma VALUES ("n#00550341","n","ato","N");
INSERT INTO portuguese_lemma VALUES ("n#04904391","n","ato","N");
INSERT INTO portuguese_lemma VALUES ("n#04913178","n","ato","N");
INSERT INTO portuguese_lemma VALUES ("n#05258426","n","ato","N");
INSERT INTO portuguese_lemma VALUES ("n#00017487","n","ação","N");
INSERT INTO portuguese_lemma VALUES ("n#00022246","n","ação","N");
INSERT INTO portuguese_lemma VALUES ("n#13333833","n","ação","N");
INSERT INTO portuguese_lemma VALUES ("n#09606854","n","ação","N");
INSERT INTO portuguese_lemma VALUES ("n#13417071","n","ação","N");
INSERT INTO portuguese_lemma VALUES ("n#10090167","n","ação","N");
INSERT INTO portuguese_lemma VALUES ("n#00017487","n","feito","N");
INSERT INTO portuguese_lemma VALUES ("n#00020977","n","feito","N");
INSERT INTO portuguese_lemma VALUES ("n#00021392","n","feito","N");
INSERT INTO portuguese_lemma VALUES ("a#00030508","a","possessivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00030798","a","predatório","N");
INSERT INTO portuguese_lemma VALUES ("a#00084022","a","predatório","N");
INSERT INTO portuguese_lemma VALUES ("a#00030798","a","predador","N");
INSERT INTO portuguese_lemma VALUES ("a#00084022","a","predador","N");
INSERT INTO portuguese_lemma VALUES ("n#00017954","n","agrupação","N");
INSERT INTO portuguese_lemma VALUES ("n#00017954","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#04606861","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#05963394","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#07954014","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#05965972","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#05969508","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#05969773","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#05972379","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#05990251","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#05991008","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#06117068","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#06123389","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#08400452","n","grupo","N");
INSERT INTO portuguese_lemma VALUES ("n#00017954","n","conjunto","N");
INSERT INTO portuguese_lemma VALUES ("n#07954014","n","conjunto","N");
INSERT INTO portuguese_lemma VALUES ("n#07985135","n","conjunto","N");
INSERT INTO portuguese_lemma VALUES ("n#05992373","n","conjunto","N");
INSERT INTO portuguese_lemma VALUES ("v#00031418","v","cacarejar","N");
INSERT INTO portuguese_lemma VALUES ("r#00031515","r","não_mas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00031515","r","já_não","Y");
INSERT INTO portuguese_lemma VALUES ("r#00031515","r","não_mais","Y");
INSERT INTO portuguese_lemma VALUES ("r#00031606","r","daqui_para_frente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00021890","v","gracejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00578703","v","gracejar","N");
INSERT INTO portuguese_lemma VALUES ("r#00031798","r","já","N");
INSERT INTO portuguese_lemma VALUES ("r#00033922","r","já","N");
INSERT INTO portuguese_lemma VALUES ("v#00022011","v","rir","N");
INSERT INTO portuguese_lemma VALUES ("v#00022011","v","gargalhar","N");
INSERT INTO portuguese_lemma VALUES ("r#00031899","r","muito","N");
INSERT INTO portuguese_lemma VALUES ("r#00046299","r","muito","N");
INSERT INTO portuguese_lemma VALUES ("r#00056539","r","muito","N");
INSERT INTO portuguese_lemma VALUES ("r#00059171","r","muito","N");
INSERT INTO portuguese_lemma VALUES ("n#00018916","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#09924828","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#09925062","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#09931077","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#13794417","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#09934446","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#13795695","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#09947717","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#13812607","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#10036039","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#10036283","n","relação","N");
INSERT INTO portuguese_lemma VALUES ("n#00018916","n","conexão","N");
INSERT INTO portuguese_lemma VALUES ("n#07177545","n","conexão","N");
INSERT INTO portuguese_lemma VALUES ("n#13792842","n","conexão","N");
INSERT INTO portuguese_lemma VALUES ("n#10345982","n","conexão","N");
INSERT INTO portuguese_lemma VALUES ("r#00032180","r","fabulosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00032180","r","fantasticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00213301","r","fantasticamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00032297","v","convulsionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01388813","v","convulsionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00032497","a","atlético","N");
INSERT INTO portuguese_lemma VALUES ("a#00828661","a","atlético","N");
INSERT INTO portuguese_lemma VALUES ("a#02907656","a","atlético","N");
INSERT INTO portuguese_lemma VALUES ("a#00032497","a","acrobático","N");
INSERT INTO portuguese_lemma VALUES ("n#00018376","n","posse","N");
INSERT INTO portuguese_lemma VALUES ("n#00239910","n","posse","N");
INSERT INTO portuguese_lemma VALUES ("n#00809702","n","posse","N");
INSERT INTO portuguese_lemma VALUES ("a#00033527","a","serelepe","N");
INSERT INTO portuguese_lemma VALUES ("n#02355227","n","serelepe","N");
INSERT INTO portuguese_lemma VALUES ("a#00033527","a","lépido","N");
INSERT INTO portuguese_lemma VALUES ("a#00033527","a","lesto","N");
INSERT INTO portuguese_lemma VALUES ("a#00033527","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("r#00085811","r","rápido","N");
INSERT INTO portuguese_lemma VALUES ("r#00105603","r","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#00800735","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#00925538","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#00926833","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#00928268","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#00928545","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#00979862","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#01863475","a","rápido","N");
INSERT INTO portuguese_lemma VALUES ("a#00033527","a","ativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00039581","a","ativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00033527","a","ligeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00928268","a","ligeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00928545","a","ligeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#01281477","a","ligeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00033527","a","ágil","N");
INSERT INTO portuguese_lemma VALUES ("a#00149236","a","ágil","N");
INSERT INTO portuguese_lemma VALUES ("a#01281477","a","ágil","N");
INSERT INTO portuguese_lemma VALUES ("n#00032823","n","relação_social","Y");
INSERT INTO portuguese_lemma VALUES ("r#00032863","r","doravante","N");
INSERT INTO portuguese_lemma VALUES ("r#00103859","r","doravante","N");
INSERT INTO portuguese_lemma VALUES ("r#00032863","r","de_agora_em_diante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00103859","r","de_agora_em_diante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00032863","r","a_partir_de_agora","Y");
INSERT INTO portuguese_lemma VALUES ("r#00067265","r","a_partir_de_agora","Y");
INSERT INTO portuguese_lemma VALUES ("r#00103859","r","a_partir_de_agora","Y");
INSERT INTO portuguese_lemma VALUES ("v#00022810","v","franzir_o_cenho","Y");
INSERT INTO portuguese_lemma VALUES ("v#00022810","v","fazer_cara_feia","Y");
INSERT INTO portuguese_lemma VALUES ("n#00019671","n","mensagem","N");
INSERT INTO portuguese_lemma VALUES ("n#04729537","n","mensagem","N");
INSERT INTO portuguese_lemma VALUES ("n#04950638","n","mensagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00019671","n","comunicação","N");
INSERT INTO portuguese_lemma VALUES ("n#04728675","n","comunicação","N");
INSERT INTO portuguese_lemma VALUES ("n#04968827","n","comunicação","N");
INSERT INTO portuguese_lemma VALUES ("n#05056012","n","comunicação","N");
INSERT INTO portuguese_lemma VALUES ("n#07212612","n","comunicação","N");
INSERT INTO portuguese_lemma VALUES ("v#00022963","v","fulminar","N");
INSERT INTO portuguese_lemma VALUES ("a#00033206","a","hiperativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00033206","a","ativo_em_excesso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00033308","r","agora_mesmo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00033308","r","neste_instante","Y");
INSERT INTO portuguese_lemma VALUES ("v#00033406","v","olhar","N");
INSERT INTO portuguese_lemma VALUES ("n#00563114","n","olhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01456984","v","olhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01457770","v","olhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01459903","v","olhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01482231","v","olhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01483772","v","olhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01673353","v","olhar","N");
INSERT INTO portuguese_lemma VALUES ("r#00033421","r","instantaneamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048739","r","instantaneamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00033421","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00035320","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048739","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00051848","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00105162","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00105467","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00170715","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00504281","r","imediatamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00033574","a","inativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00023357","v","aparentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00568049","v","aparentar","N");
INSERT INTO portuguese_lemma VALUES ("n#03972490","n","quantia","N");
INSERT INTO portuguese_lemma VALUES ("n#03972490","n","medida","N");
INSERT INTO portuguese_lemma VALUES ("n#00643864","n","medida","N");
INSERT INTO portuguese_lemma VALUES ("n#03976830","n","medida","N");
INSERT INTO portuguese_lemma VALUES ("n#03977358","n","medida","N");
INSERT INTO portuguese_lemma VALUES ("n#03972490","n","quantidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03977751","n","quantidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03983517","n","quantidade","N");
INSERT INTO portuguese_lemma VALUES ("n#05108740","n","quantidade","N");
INSERT INTO portuguese_lemma VALUES ("n#04507519","n","quantidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03972490","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#03971772","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#03972175","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#03973414","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#03977358","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#04025511","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#04025970","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#04028728","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#09956529","n","magnitude","N");
INSERT INTO portuguese_lemma VALUES ("n#03972490","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#03971772","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#03983517","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#03990394","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#04507519","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#04511080","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#04774380","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#04841846","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#04842744","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#04948541","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#05097671","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#05156818","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#09598019","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#09765658","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#13741022","n","número","N");
INSERT INTO portuguese_lemma VALUES ("n#09894639","n","número","N");
INSERT INTO portuguese_lemma VALUES ("r#00033663","r","um_tanto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00033663","r","um","N");
INSERT INTO portuguese_lemma VALUES ("n#13742573","n","um","N");
INSERT INTO portuguese_lemma VALUES ("r#00033663","r","pouco","N");
INSERT INTO portuguese_lemma VALUES ("r#00100002","r","pouco","N");
INSERT INTO portuguese_lemma VALUES ("n#09909906","n","pouco","N");
INSERT INTO portuguese_lemma VALUES ("n#13773725","n","pouco","N");
INSERT INTO portuguese_lemma VALUES ("r#00033922","r","pronto","N");
INSERT INTO portuguese_lemma VALUES ("a#01862436","a","pronto","N");
INSERT INTO portuguese_lemma VALUES ("r#00033922","r","cedo","N");
INSERT INTO portuguese_lemma VALUES ("r#00100082","r","cedo","N");
INSERT INTO portuguese_lemma VALUES ("a#00773513","a","cedo","N");
INSERT INTO portuguese_lemma VALUES ("a#00778288","a","cedo","N");
INSERT INTO portuguese_lemma VALUES ("a#01588864","a","cedo","N");
INSERT INTO portuguese_lemma VALUES ("r#00033922","r","logo","N");
INSERT INTO portuguese_lemma VALUES ("n#07272084","n","logo","N");
INSERT INTO portuguese_lemma VALUES ("r#00033922","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00034189","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00034308","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048268","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00085811","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00092682","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00289860","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00297319","r","brevemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00023765","v","aplaudir","N");
INSERT INTO portuguese_lemma VALUES ("v#00583639","v","aplaudir","N");
INSERT INTO portuguese_lemma VALUES ("v#00584625","v","aplaudir","N");
INSERT INTO portuguese_lemma VALUES ("v#00584733","v","aplaudir","N");
INSERT INTO portuguese_lemma VALUES ("v#00023765","v","bater_palmas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00584733","v","bater_palmas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00034137","r","o_mais_rápido_possível","Y");
INSERT INTO portuguese_lemma VALUES ("r#00034137","r","o_mais_breve_possível","Y");
INSERT INTO portuguese_lemma VALUES ("n#00020461","n","fenómeno","N");
INSERT INTO portuguese_lemma VALUES ("n#05524610","n","fenómeno","N");
INSERT INTO portuguese_lemma VALUES ("n#00020461","n","fenômeno","N");
INSERT INTO portuguese_lemma VALUES ("n#05524610","n","fenômeno","N");
INSERT INTO portuguese_lemma VALUES ("a#00034881","a","inerte","N");
INSERT INTO portuguese_lemma VALUES ("a#01565038","a","inerte","N");
INSERT INTO portuguese_lemma VALUES ("r#00034403","r","momentaneamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00092814","r","momentaneamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00020804","n","gentileza","N");
INSERT INTO portuguese_lemma VALUES ("n#00795713","n","gentileza","N");
INSERT INTO portuguese_lemma VALUES ("n#00020804","n","bondade","N");
INSERT INTO portuguese_lemma VALUES ("n#03800378","n","bondade","N");
INSERT INTO portuguese_lemma VALUES ("n#05696348","n","bondade","N");
INSERT INTO portuguese_lemma VALUES ("n#00020804","n","delicadeza","N");
INSERT INTO portuguese_lemma VALUES ("n#03775320","n","delicadeza","N");
INSERT INTO portuguese_lemma VALUES ("n#00020804","n","amabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#04654652","n","amabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#04840011","n","amabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#05696348","n","amabilidade","N");
INSERT INTO portuguese_lemma VALUES ("r#00034641","r","o_mais_precoce","Y");
INSERT INTO portuguese_lemma VALUES ("n#00034777","n","Abdominoplastia","N");
INSERT INTO portuguese_lemma VALUES ("n#00034939","n","aborto","N");
INSERT INTO portuguese_lemma VALUES ("n#00149581","n","aborto","N");
INSERT INTO portuguese_lemma VALUES ("n#00149696","n","aborto","N");
INSERT INTO portuguese_lemma VALUES ("n#05456093","n","aborto","N");
INSERT INTO portuguese_lemma VALUES ("r#00035058","r","com_freqüência","Y");
INSERT INTO portuguese_lemma VALUES ("r#00035058","r","amiúde","N");
INSERT INTO portuguese_lemma VALUES ("r#00035058","r","freqüentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00035058","r","vira_e_mexe","Y");
INSERT INTO portuguese_lemma VALUES ("r#00035058","r","muitas_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00035058","r","frequentemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00035089","v","pigarrear","N");
INSERT INTO portuguese_lemma VALUES ("v#00121607","v","pigarrear","N");
INSERT INTO portuguese_lemma VALUES ("n#00020977","n","façanha","N");
INSERT INTO portuguese_lemma VALUES ("n#00021392","n","façanha","N");
INSERT INTO portuguese_lemma VALUES ("n#00046344","n","façanha","N");
INSERT INTO portuguese_lemma VALUES ("n#00024789","n","façanha","N");
INSERT INTO portuguese_lemma VALUES ("n#00020977","n","consumação","N");
INSERT INTO portuguese_lemma VALUES ("n#00061598","n","consumação","N");
INSERT INTO portuguese_lemma VALUES ("n#00020977","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00021392","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00061322","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00035534","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00035970","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00036271","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00061811","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00931847","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00729882","n","realização","N");
INSERT INTO portuguese_lemma VALUES ("n#00020977","n","conquista","N");
INSERT INTO portuguese_lemma VALUES ("n#00037624","n","conquista","N");
INSERT INTO portuguese_lemma VALUES ("n#00054499","n","conquista","N");
INSERT INTO portuguese_lemma VALUES ("n#00104245","n","conquista","N");
INSERT INTO portuguese_lemma VALUES ("a#00035368","a","jubilado","N");
INSERT INTO portuguese_lemma VALUES ("n#10525617","n","jubilado","N");
INSERT INTO portuguese_lemma VALUES ("a#00035368","a","aposentado","N");
INSERT INTO portuguese_lemma VALUES ("n#10525617","n","aposentado","N");
INSERT INTO portuguese_lemma VALUES ("r#00035385","r","raramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00374520","r","raramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00035491","r","curiosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00081881","r","curiosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00214761","r","curiosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00035697","n","agon","N");
INSERT INTO portuguese_lemma VALUES ("r#00035718","r","com_justiça","Y");
INSERT INTO portuguese_lemma VALUES ("r#00035718","r","razoavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00215811","r","razoavelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00035758","v","lavar","N");
INSERT INTO portuguese_lemma VALUES ("v#00557686","v","lavar","N");
INSERT INTO portuguese_lemma VALUES ("v#01054290","v","lavar","N");
INSERT INTO portuguese_lemma VALUES ("v#01056327","v","lavar","N");
INSERT INTO portuguese_lemma VALUES ("v#00035758","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#00025612","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#00040766","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#00120982","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#00123998","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#00124634","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01311896","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#00955030","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01392918","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01054290","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01054427","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01108327","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01360709","v","limpar","N");
INSERT INTO portuguese_lemma VALUES ("a#00037427","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01592532","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01593054","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01653135","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01594537","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01654582","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01642540","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01790966","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01814114","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#01931860","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("a#02008784","a","aberto","N");
INSERT INTO portuguese_lemma VALUES ("r#00036291","r","lestamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036291","r","levemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036291","r","ligeiramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036291","r","meio","N");
INSERT INTO portuguese_lemma VALUES ("n#00111872","n","meio","N");
INSERT INTO portuguese_lemma VALUES ("a#00483994","a","meio","N");
INSERT INTO portuguese_lemma VALUES ("n#06315687","n","meio","N");
INSERT INTO portuguese_lemma VALUES ("n#09891093","n","meio","N");
INSERT INTO portuguese_lemma VALUES ("n#10410402","n","meio","N");
INSERT INTO portuguese_lemma VALUES ("v#00025612","v","lavar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00036609","r","extensivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036609","r","amplamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00495524","r","amplamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00495663","r","amplamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036609","r","largamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00495663","r","largamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00021392","n","proeza","N");
INSERT INTO portuguese_lemma VALUES ("n#00046344","n","proeza","N");
INSERT INTO portuguese_lemma VALUES ("r#00036762","r","intrinsecamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00025940","v","esfregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01249724","v","esfregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00853039","v","esfregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01251228","v","esfregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00853429","v","esfregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00955030","v","esfregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00036932","v","ensaboar","N");
INSERT INTO portuguese_lemma VALUES ("r#00036935","r","infalivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036935","r","sem_falta","Y");
INSERT INTO portuguese_lemma VALUES ("r#00036935","r","impreterivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00036935","r","definitivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00087916","r","definitivamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00036998","a","lento","N");
INSERT INTO portuguese_lemma VALUES ("a#00929061","a","lento","N");
INSERT INTO portuguese_lemma VALUES ("a#00931158","a","lento","N");
INSERT INTO portuguese_lemma VALUES ("n#00037006","n","obra-prima","N");
INSERT INTO portuguese_lemma VALUES ("n#03727605","n","obra-prima","N");
INSERT INTO portuguese_lemma VALUES ("v#00037138","v","enxaguar","N");
INSERT INTO portuguese_lemma VALUES ("v#01270199","v","enxaguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00037138","v","gargarejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00037138","v","bochechar","N");
INSERT INTO portuguese_lemma VALUES ("r#00037226","r","sinceramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00160086","r","sinceramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00165018","r","sinceramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00378365","r","sinceramente","N");
INSERT INTO portuguese_lemma VALUES ("v#00037298","v","barbear-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00037298","v","barbear","N");
INSERT INTO portuguese_lemma VALUES ("v#00042792","v","barbear","N");
INSERT INTO portuguese_lemma VALUES ("v#00851394","v","barbear","N");
INSERT INTO portuguese_lemma VALUES ("v#00037298","v","raspar","N");
INSERT INTO portuguese_lemma VALUES ("v#00845525","v","raspar","N");
INSERT INTO portuguese_lemma VALUES ("v#00894368","v","raspar","N");
INSERT INTO portuguese_lemma VALUES ("v#01141322","v","raspar","N");
INSERT INTO portuguese_lemma VALUES ("n#00022246","n","atividade","N");
INSERT INTO portuguese_lemma VALUES ("n#00261466","n","atividade","N");
INSERT INTO portuguese_lemma VALUES ("n#10090167","n","atividade","N");
INSERT INTO portuguese_lemma VALUES ("r#00037470","r","realmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00148869","r","realmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00037470","r","de_fato","Y");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","de_fato","Y");
INSERT INTO portuguese_lemma VALUES ("r#00148869","r","de_fato","Y");
INSERT INTO portuguese_lemma VALUES ("v#00037514","v","depilar","N");
INSERT INTO portuguese_lemma VALUES ("a#00038771","a","progressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01804417","a","progressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01805641","a","progressivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00026695","v","tomar_banho","Y");
INSERT INTO portuguese_lemma VALUES ("v#00026695","v","banhar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00038013","r","verdadeiramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00400192","r","verdadeiramente","N");
INSERT INTO portuguese_lemma VALUES ("v#00038199","v","duchar","N");
INSERT INTO portuguese_lemma VALUES ("a#00038260","a","indolente","N");
INSERT INTO portuguese_lemma VALUES ("n#00022737","n","conduta","N");
INSERT INTO portuguese_lemma VALUES ("n#00792210","n","conduta","N");
INSERT INTO portuguese_lemma VALUES ("n#03835766","n","conduta","N");
INSERT INTO portuguese_lemma VALUES ("n#00022737","n","corrente","N");
INSERT INTO portuguese_lemma VALUES ("n#02416750","n","corrente","N");
INSERT INTO portuguese_lemma VALUES ("n#05513139","n","corrente","N");
INSERT INTO portuguese_lemma VALUES ("n#06793150","n","corrente","N");
INSERT INTO portuguese_lemma VALUES ("n#11443532","n","corrente","N");
INSERT INTO portuguese_lemma VALUES ("n#11514559","n","corrente","N");
INSERT INTO portuguese_lemma VALUES ("n#13652994","n","corrente","N");
INSERT INTO portuguese_lemma VALUES ("n#00022737","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#00568196","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06115327","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06115587","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06249735","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06250108","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06389665","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06390208","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06390488","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#06709272","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#09959689","n","curso","N");
INSERT INTO portuguese_lemma VALUES ("n#00022737","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#00111872","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#00266805","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#02159544","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03244388","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03640589","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03640660","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03096023","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03096228","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03243979","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03525842","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03527842","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#03600463","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#06348591","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("n#06709272","n","caminho","N");
INSERT INTO portuguese_lemma VALUES ("v#00026985","v","pentear","N");
INSERT INTO portuguese_lemma VALUES ("r#00038625","r","compreensivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00038625","r","decerto","N");
INSERT INTO portuguese_lemma VALUES ("r#00038625","r","de_acordo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00038625","r","claro","N");
INSERT INTO portuguese_lemma VALUES ("r#00181901","r","claro","N");
INSERT INTO portuguese_lemma VALUES ("a#00273770","a","claro","N");
INSERT INTO portuguese_lemma VALUES ("a#00405879","a","claro","N");
INSERT INTO portuguese_lemma VALUES ("a#02009688","a","claro","N");
INSERT INTO portuguese_lemma VALUES ("a#00039581","a","agencioso","N");
INSERT INTO portuguese_lemma VALUES ("n#00022878","n","interação","N");
INSERT INTO portuguese_lemma VALUES ("n#00023032","n","interação","N");
INSERT INTO portuguese_lemma VALUES ("a#00039122","a","activista","N");
INSERT INTO portuguese_lemma VALUES ("n#07409291","n","activista","N");
INSERT INTO portuguese_lemma VALUES ("a#00039122","a","ativista","N");
INSERT INTO portuguese_lemma VALUES ("n#00023032","n","interacção","N");
INSERT INTO portuguese_lemma VALUES ("n#00023118","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#00094409","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#00147454","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#00095872","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#02222271","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#02488140","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#02882380","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#02929916","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#04742189","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#06586471","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#11436283","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#09925062","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#09931077","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#13792183","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#09931775","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#09993288","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#10024799","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#10036283","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#10345365","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#10345982","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#10346799","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#10347124","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#10347254","n","ligação","N");
INSERT INTO portuguese_lemma VALUES ("n#00023118","n","contato","N");
INSERT INTO portuguese_lemma VALUES ("n#00079716","n","contato","N");
INSERT INTO portuguese_lemma VALUES ("n#00125629","n","contato","N");
INSERT INTO portuguese_lemma VALUES ("n#07279285","n","contato","N");
INSERT INTO portuguese_lemma VALUES ("n#10346256","n","contato","N");
INSERT INTO portuguese_lemma VALUES ("r#00039318","r","evidentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00039318","r","obviamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00039318","r","abertamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00053394","r","abertamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00078558","r","abertamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00314835","r","abertamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00039318","r","de_forma_evidente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00039318","r","claramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00078558","r","claramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00180057","r","claramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00307479","r","claramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00307639","r","claramente","N");
INSERT INTO portuguese_lemma VALUES ("n#00039740","n","contato_visual","Y");
INSERT INTO portuguese_lemma VALUES ("n#00039916","n","busque","N");
INSERT INTO portuguese_lemma VALUES ("r#00039941","r","aparentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00023668","n","intercâmbio","N");
INSERT INTO portuguese_lemma VALUES ("v#00040353","v","cuidar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00040365","r","de_novo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00112843","r","de_novo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00226550","r","de_novo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040365","r","uma_vez_mais","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040365","r","outra_vez","Y");
INSERT INTO portuguese_lemma VALUES ("r#00112843","r","outra_vez","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040365","r","novamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00112601","r","novamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00112843","r","novamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00023860","n","intercambio","N");
INSERT INTO portuguese_lemma VALUES ("n#00023860","n","reciprocidade","N");
INSERT INTO portuguese_lemma VALUES ("n#09971796","n","reciprocidade","N");
INSERT INTO portuguese_lemma VALUES ("r#00040547","r","Casualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00040547","r","por_acaso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040547","r","à_toa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040547","r","acidentalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00062650","r","acidentalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00263893","r","acidentalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00040719","r","inesperadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00040719","r","de_repente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00061528","r","de_repente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00061677","r","de_repente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00151957","r","de_repente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040719","r","sem_mais_nem_menos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040719","r","da_cartola","Y");
INSERT INTO portuguese_lemma VALUES ("r#00040719","r","inopinadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00040719","r","repentinamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061528","r","repentinamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061677","r","repentinamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00040719","r","do_nada","Y");
INSERT INTO portuguese_lemma VALUES ("r#00159889","r","do_nada","Y");
INSERT INTO portuguese_lemma VALUES ("v#00040928","v","maquiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00040928","v","maquilar","N");
INSERT INTO portuguese_lemma VALUES ("a#00041051","a","extinto","N");
INSERT INTO portuguese_lemma VALUES ("a#00100213","a","extinto","N");
INSERT INTO portuguese_lemma VALUES ("a#00041051","a","liquidado","N");
INSERT INTO portuguese_lemma VALUES ("a#00041051","a","apagado","N");
INSERT INTO portuguese_lemma VALUES ("a#00041051","a","revogado","N");
INSERT INTO portuguese_lemma VALUES ("a#00041051","a","extincto","N");
INSERT INTO portuguese_lemma VALUES ("a#00100213","a","extincto","N");
INSERT INTO portuguese_lemma VALUES ("v#00041206","v","enfatizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00197117","v","enfatizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00685448","v","enfatizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00686083","v","enfatizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00041206","v","realçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00358208","v","realçar","N");
INSERT INTO portuguese_lemma VALUES ("n#00041468","n","luta_de_espadas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00029095","v","pintar","N");
INSERT INTO portuguese_lemma VALUES ("v#00932708","v","pintar","N");
INSERT INTO portuguese_lemma VALUES ("v#01156145","v","pintar","N");
INSERT INTO portuguese_lemma VALUES ("v#01156290","v","pintar","N");
INSERT INTO portuguese_lemma VALUES ("n#00041740","n","boliche","N");
INSERT INTO portuguese_lemma VALUES ("n#00461782","n","boliche","N");
INSERT INTO portuguese_lemma VALUES ("r#00041758","r","especificamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00041758","r","concretamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00046246","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#00077419","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#00047517","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#00049855","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#00051225","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#04438179","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#09536731","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#00047131","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("n#13253612","n","aquisição","N");
INSERT INTO portuguese_lemma VALUES ("r#00041954","r","em_geral","Y");
INSERT INTO portuguese_lemma VALUES ("r#00155621","r","em_geral","Y");
INSERT INTO portuguese_lemma VALUES ("r#00221583","r","em_geral","Y");
INSERT INTO portuguese_lemma VALUES ("r#00221795","r","em_geral","Y");
INSERT INTO portuguese_lemma VALUES ("r#00041954","r","generalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00155621","r","generalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00042173","v","empoar","N");
INSERT INTO portuguese_lemma VALUES ("r#00042254","r","por_sorte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00042254","r","afortunadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00042254","r","felizmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00050297","r","felizmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00199882","r","felizmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00199986","r","felizmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00042311","n","causalidade","N");
INSERT INTO portuguese_lemma VALUES ("n#13780606","n","causalidade","N");
INSERT INTO portuguese_lemma VALUES ("r#00042614","r","tristemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00050556","r","tristemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00404501","r","tristemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00042614","r","descontentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00050556","r","descontentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00029100","n","partida","N");
INSERT INTO portuguese_lemma VALUES ("n#00029442","n","partida","N");
INSERT INTO portuguese_lemma VALUES ("n#00031963","n","partida","N");
INSERT INTO portuguese_lemma VALUES ("n#03560567","n","partida","N");
INSERT INTO portuguese_lemma VALUES ("n#05542799","n","partida","N");
INSERT INTO portuguese_lemma VALUES ("n#05554348","n","partida","N");
INSERT INTO portuguese_lemma VALUES ("n#06118344","n","partida","N");
INSERT INTO portuguese_lemma VALUES ("r#00042769","r","infelizmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00042769","r","desgraçadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00042769","r","lamentavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00093270","r","lamentavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","em_vista_disso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","por_este_motivo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","consequentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","dessa_forma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","por_isto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","de_tal_modo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","desse_jeito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","portanto","N");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","assim_sendo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","assim","N");
INSERT INTO portuguese_lemma VALUES ("r#00118363","r","assim","N");
INSERT INTO portuguese_lemma VALUES ("r#00121002","r","assim","N");
INSERT INTO portuguese_lemma VALUES ("a#01491308","a","assim","N");
INSERT INTO portuguese_lemma VALUES ("r#00043003","r","daqui","N");
INSERT INTO portuguese_lemma VALUES ("r#00043521","r","daqui","N");
INSERT INTO portuguese_lemma VALUES ("v#00043078","v","ataviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00043078","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("v#00044149","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("v#00031591","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("v#00033917","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("v#00034046","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("v#00036087","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("v#00037183","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("v#00293528","v","vestir","N");
INSERT INTO portuguese_lemma VALUES ("n#00098007","n","descobrimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00098007","n","descoberta","N");
INSERT INTO portuguese_lemma VALUES ("n#04475449","n","descoberta","N");
INSERT INTO portuguese_lemma VALUES ("v#00043480","v","perfumar","N");
INSERT INTO portuguese_lemma VALUES ("r#00043608","r","daí","N");
INSERT INTO portuguese_lemma VALUES ("r#00043608","r","desde_aí","Y");
INSERT INTO portuguese_lemma VALUES ("r#00043608","r","por_isso","Y");
INSERT INTO portuguese_lemma VALUES ("n#00043609","n","eliminação","N");
INSERT INTO portuguese_lemma VALUES ("n#00251311","n","eliminação","N");
INSERT INTO portuguese_lemma VALUES ("n#00253361","n","eliminação","N");
INSERT INTO portuguese_lemma VALUES ("n#13473392","n","eliminação","N");
INSERT INTO portuguese_lemma VALUES ("a#00044309","a","efetivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01753746","a","efetivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00044309","a","efectivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00044309","a","verdadeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#01351228","a","verdadeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#02044571","a","verdadeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#02095155","a","verdadeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#02341880","a","verdadeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#02350264","a","verdadeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00044309","a","real","N");
INSERT INTO portuguese_lemma VALUES ("a#00629037","a","real","N");
INSERT INTO portuguese_lemma VALUES ("a#01534893","a","real","N");
INSERT INTO portuguese_lemma VALUES ("a#02044571","a","real","N");
INSERT INTO portuguese_lemma VALUES ("a#02598692","a","real","N");
INSERT INTO portuguese_lemma VALUES ("n#13667908","n","real","N");
INSERT INTO portuguese_lemma VALUES ("n#00043902","n","jogada","N");
INSERT INTO portuguese_lemma VALUES ("n#00108013","n","jogada","N");
INSERT INTO portuguese_lemma VALUES ("n#00043902","n","rebatida","N");
INSERT INTO portuguese_lemma VALUES ("n#00043902","n","batida","N");
INSERT INTO portuguese_lemma VALUES ("n#00125629","n","batida","N");
INSERT INTO portuguese_lemma VALUES ("n#00086415","n","batida","N");
INSERT INTO portuguese_lemma VALUES ("n#05499044","n","batida","N");
INSERT INTO portuguese_lemma VALUES ("n#07410745","n","batida","N");
INSERT INTO portuguese_lemma VALUES ("n#07923297","n","batida","N");
INSERT INTO portuguese_lemma VALUES ("v#00044149","v","roupa_formal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00061322","n","implementação","N");
INSERT INTO portuguese_lemma VALUES ("n#00061322","n","execução","N");
INSERT INTO portuguese_lemma VALUES ("n#00061811","n","execução","N");
INSERT INTO portuguese_lemma VALUES ("n#00729616","n","execução","N");
INSERT INTO portuguese_lemma VALUES ("n#00729882","n","execução","N");
INSERT INTO portuguese_lemma VALUES ("n#01163779","n","execução","N");
INSERT INTO portuguese_lemma VALUES ("n#09750253","n","execução","N");
INSERT INTO portuguese_lemma VALUES ("r#00044262","r","vocacionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00045137","a","potencial","N");
INSERT INTO portuguese_lemma VALUES ("a#01811604","a","potencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00045137","a","possível","N");
INSERT INTO portuguese_lemma VALUES ("a#01750551","a","possível","N");
INSERT INTO portuguese_lemma VALUES ("a#01752028","a","possível","N");
INSERT INTO portuguese_lemma VALUES ("r#00044394","r","cara_a_cara","Y");
INSERT INTO portuguese_lemma VALUES ("n#00044455","n","emergência","N");
INSERT INTO portuguese_lemma VALUES ("n#00027592","n","emergência","N");
INSERT INTO portuguese_lemma VALUES ("n#05458815","n","emergência","N");
INSERT INTO portuguese_lemma VALUES ("n#07417405","n","emergência","N");
INSERT INTO portuguese_lemma VALUES ("a#00045320","a","latente","N");
INSERT INTO portuguese_lemma VALUES ("n#00121287","n","equalizador","N");
INSERT INTO portuguese_lemma VALUES ("n#00121287","n","equalização","N");
INSERT INTO portuguese_lemma VALUES ("a#00045472","a","pontiagudo","N");
INSERT INTO portuguese_lemma VALUES ("n#00044900","n","exumação","N");
INSERT INTO portuguese_lemma VALUES ("a#00044987","a","subagudo","N");
INSERT INTO portuguese_lemma VALUES ("n#00045114","n","mitzvá","N");
INSERT INTO portuguese_lemma VALUES ("a#00045826","a","crónico","N");
INSERT INTO portuguese_lemma VALUES ("a#00489768","a","crónico","N");
INSERT INTO portuguese_lemma VALUES ("a#00045826","a","crônico","N");
INSERT INTO portuguese_lemma VALUES ("a#00489768","a","crônico","N");
INSERT INTO portuguese_lemma VALUES ("n#00045250","n","impulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#00065545","n","impulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#00112312","n","impulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#11447851","n","impulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#00045250","n","propulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#11497777","n","propulsão","N");
INSERT INTO portuguese_lemma VALUES ("a#00046069","a","degenerativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00045561","a","virulento","N");
INSERT INTO portuguese_lemma VALUES ("a#01730738","a","virulento","N");
INSERT INTO portuguese_lemma VALUES ("a#02449952","a","virulento","N");
INSERT INTO portuguese_lemma VALUES ("n#00058089","n","melhora","N");
INSERT INTO portuguese_lemma VALUES ("n#00058089","n","restabelecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00058089","n","reabilitação","N");
INSERT INTO portuguese_lemma VALUES ("r#00045704","r","para_além","Y");
INSERT INTO portuguese_lemma VALUES ("v#00045817","v","perder_peso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00045817","v","perder_peso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00045817","v","reduzir_peso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00045817","v","emagrecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00430999","v","emagrecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00046646","a","mortal","N");
INSERT INTO portuguese_lemma VALUES ("a#00941009","a","mortal","N");
INSERT INTO portuguese_lemma VALUES ("a#00941191","a","mortal","N");
INSERT INTO portuguese_lemma VALUES ("a#01446038","a","mortal","N");
INSERT INTO portuguese_lemma VALUES ("a#01495166","a","mortal","N");
INSERT INTO portuguese_lemma VALUES ("a#01658677","a","mortal","N");
INSERT INTO portuguese_lemma VALUES ("n#00058314","n","recuperação","N");
INSERT INTO portuguese_lemma VALUES ("n#00060414","n","recuperação","N");
INSERT INTO portuguese_lemma VALUES ("n#04444540","n","recuperação","N");
INSERT INTO portuguese_lemma VALUES ("n#05521978","n","recuperação","N");
INSERT INTO portuguese_lemma VALUES ("n#09718984","n","recuperação","N");
INSERT INTO portuguese_lemma VALUES ("r#00046002","r","caso_contrário","Y");
INSERT INTO portuguese_lemma VALUES ("a#00046109","a","adaptável","N");
INSERT INTO portuguese_lemma VALUES ("a#01027263","a","adaptável","N");
INSERT INTO portuguese_lemma VALUES ("v#00046151","v","ganhar_peso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00046151","v","engordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00812836","v","engordar","N");
INSERT INTO portuguese_lemma VALUES ("r#00046167","r","adicionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00212411","r","adicionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00046167","r","de_lambuja","Y");
INSERT INTO portuguese_lemma VALUES ("n#00046177","n","fuga","N");
INSERT INTO portuguese_lemma VALUES ("n#00032687","n","fuga","N");
INSERT INTO portuguese_lemma VALUES ("n#00034082","n","fuga","N");
INSERT INTO portuguese_lemma VALUES ("n#05281448","n","fuga","N");
INSERT INTO portuguese_lemma VALUES ("n#00046177","n","escapatória","N");
INSERT INTO portuguese_lemma VALUES ("n#02651996","n","escapatória","N");
INSERT INTO portuguese_lemma VALUES ("n#00046177","n","escape","N");
INSERT INTO portuguese_lemma VALUES ("n#00032687","n","escape","N");
INSERT INTO portuguese_lemma VALUES ("r#00046299","r","demasiado","N");
INSERT INTO portuguese_lemma VALUES ("a#01470633","a","demasiado","N");
INSERT INTO portuguese_lemma VALUES ("r#00046299","r","extremamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00196540","r","extremamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00046299","r","excessivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00549826","a","excessivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01470633","a","excessivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01524894","a","excessivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01929728","a","excessivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00046471","a","adaptativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00079716","n","toque","N");
INSERT INTO portuguese_lemma VALUES ("n#04373543","n","toque","N");
INSERT INTO portuguese_lemma VALUES ("n#05468490","n","toque","N");
INSERT INTO portuguese_lemma VALUES ("n#05514913","n","toque","N");
INSERT INTO portuguese_lemma VALUES ("v#00032951","v","arrumar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00032951","v","vestir-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00046639","r","loucamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00080890","r","loucamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00503370","r","loucamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00046792","a","disfuncional","N");
INSERT INTO portuguese_lemma VALUES ("a#01275057","a","disfuncional","N");
INSERT INTO portuguese_lemma VALUES ("r#00046863","r","extraordinària","N");
INSERT INTO portuguese_lemma VALUES ("r#00046863","r","extraordinariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00454512","r","extraordinariamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00047029","a","viciado","N");
INSERT INTO portuguese_lemma VALUES ("n#09768830","n","viciado","N");
INSERT INTO portuguese_lemma VALUES ("n#09769076","n","viciado","N");
INSERT INTO portuguese_lemma VALUES ("a#00050590","a","alcoólico","N");
INSERT INTO portuguese_lemma VALUES ("a#01111705","a","alcoólico","N");
INSERT INTO portuguese_lemma VALUES ("v#00047317","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00080645","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00402992","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00597061","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00813161","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01209074","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01443215","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#02108377","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01444597","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01726604","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#02532886","v","experimentar","N");
INSERT INTO portuguese_lemma VALUES ("r#00047392","r","excessivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00487759","r","excessivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00047392","r","medos","N");
INSERT INTO portuguese_lemma VALUES ("r#00047392","r","de_forma_excessiva","Y");
INSERT INTO portuguese_lemma VALUES ("a#00047406","a","dependente","N");
INSERT INTO portuguese_lemma VALUES ("a#00523065","a","dependente","N");
INSERT INTO portuguese_lemma VALUES ("a#00690180","a","dependente","N");
INSERT INTO portuguese_lemma VALUES ("a#00727113","a","dependente","N");
INSERT INTO portuguese_lemma VALUES ("r#00047534","r","também","N");
INSERT INTO portuguese_lemma VALUES ("r#00047534","r","assim_mesmo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00047534","r","idem","N");
INSERT INTO portuguese_lemma VALUES ("r#00047534","r","outrossim","N");
INSERT INTO portuguese_lemma VALUES ("r#00047641","r","a_propósito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00156222","r","a_propósito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00167816","r","a_propósito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00047641","r","a_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00167816","r","a_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00025398","n","expediente","N");
INSERT INTO portuguese_lemma VALUES ("a#00047786","a","viciante","N");
INSERT INTO portuguese_lemma VALUES ("r#00047903","r","finalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048138","r","finalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00065822","r","finalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00047903","r","afinal_de_contas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00047903","r","por_fim","Y");
INSERT INTO portuguese_lemma VALUES ("r#00048138","r","por_fim","Y");
INSERT INTO portuguese_lemma VALUES ("r#00065822","r","por_fim","Y");
INSERT INTO portuguese_lemma VALUES ("r#00047903","r","ultimamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00107416","r","ultimamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00047903","r","até_que_enfim","Y");
INSERT INTO portuguese_lemma VALUES ("r#00048138","r","até_que_enfim","Y");
INSERT INTO portuguese_lemma VALUES ("r#00047903","r","enfim","N");
INSERT INTO portuguese_lemma VALUES ("r#00048138","r","enfim","N");
INSERT INTO portuguese_lemma VALUES ("a#00048129","a","aditivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00048219","a","aditivo","N");
INSERT INTO portuguese_lemma VALUES ("r#00048138","r","mais_cedo_ou_mais_tarde","Y");
INSERT INTO portuguese_lemma VALUES ("r#00048138","r","emfim","N");
INSERT INTO portuguese_lemma VALUES ("n#00025788","n","chegar_la-metaforicamente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00048268","r","atualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048475","r","atualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00049220","r","atualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048268","r","presentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048475","r","presentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048268","r","actualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00048475","r","actualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00049220","r","actualmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00025919","n","chegada","N");
INSERT INTO portuguese_lemma VALUES ("n#00026283","n","chegada","N");
INSERT INTO portuguese_lemma VALUES ("n#05438121","n","chegada","N");
INSERT INTO portuguese_lemma VALUES ("n#00025919","n","vinda","N");
INSERT INTO portuguese_lemma VALUES ("n#00026283","n","vinda","N");
INSERT INTO portuguese_lemma VALUES ("n#00027910","n","vinda","N");
INSERT INTO portuguese_lemma VALUES ("r#00048475","r","hoje","N");
INSERT INTO portuguese_lemma VALUES ("r#00207366","r","hoje","N");
INSERT INTO portuguese_lemma VALUES ("n#10848167","n","hoje","N");
INSERT INTO portuguese_lemma VALUES ("n#15156001","n","hoje","N");
INSERT INTO portuguese_lemma VALUES ("r#00048475","r","hoje_em_dia","Y");
INSERT INTO portuguese_lemma VALUES ("n#15262921","n","hoje_em_dia","Y");
INSERT INTO portuguese_lemma VALUES ("n#00026147","n","conseguimento","N");
INSERT INTO portuguese_lemma VALUES ("r#00048739","r","sem_delonga","Y");
INSERT INTO portuguese_lemma VALUES ("r#00048739","r","em_seguida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00117620","r","em_seguida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00048739","r","directamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00026283","n","advento","N");
INSERT INTO portuguese_lemma VALUES ("a#00048219","a","extra","N");
INSERT INTO portuguese_lemma VALUES ("a#01524894","a","extra","N");
INSERT INTO portuguese_lemma VALUES ("a#00048219","a","adicional","N");
INSERT INTO portuguese_lemma VALUES ("a#00049554","a","adicional","N");
INSERT INTO portuguese_lemma VALUES ("a#01782889","a","adicional","N");
INSERT INTO portuguese_lemma VALUES ("n#00026402","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#00290685","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#02591205","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03244388","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#02641840","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03985684","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#07582277","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#09611330","n","entrada","N");
INSERT INTO portuguese_lemma VALUES ("n#00026402","n","ingresso","N");
INSERT INTO portuguese_lemma VALUES ("n#09538207","n","ingresso","N");
INSERT INTO portuguese_lemma VALUES ("a#00858284","a","complementar","N");
INSERT INTO portuguese_lemma VALUES ("a#00049554","a","complementar","N");
INSERT INTO portuguese_lemma VALUES ("v#00455919","v","complementar","N");
INSERT INTO portuguese_lemma VALUES ("a#02269499","a","complementar","N");
INSERT INTO portuguese_lemma VALUES ("r#00049220","r","agora","N");
INSERT INTO portuguese_lemma VALUES ("n#15119919","n","agora","N");
INSERT INTO portuguese_lemma VALUES ("r#00049220","r","ora","N");
INSERT INTO portuguese_lemma VALUES ("r#00049220","r","no_presente","Y");
INSERT INTO portuguese_lemma VALUES ("a#01804974","a","incremental","N");
INSERT INTO portuguese_lemma VALUES ("n#00049530","n","intrusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00472484","n","intrusão","N");
INSERT INTO portuguese_lemma VALUES ("v#00049770","v","calçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00301544","v","calçar","N");
INSERT INTO portuguese_lemma VALUES ("n#00027115","n","acesso","N");
INSERT INTO portuguese_lemma VALUES ("n#00181619","n","acesso","N");
INSERT INTO portuguese_lemma VALUES ("n#02159544","n","acesso","N");
INSERT INTO portuguese_lemma VALUES ("n#02591205","n","acesso","N");
INSERT INTO portuguese_lemma VALUES ("n#04031707","n","acesso","N");
INSERT INTO portuguese_lemma VALUES ("a#00049554","a","suplementar","N");
INSERT INTO portuguese_lemma VALUES ("a#01782889","a","suplementar","N");
INSERT INTO portuguese_lemma VALUES ("v#00035494","v","despojar","N");
INSERT INTO portuguese_lemma VALUES ("v#00035494","v","despir","N");
INSERT INTO portuguese_lemma VALUES ("v#00035494","v","desnudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00133822","v","desnudar","N");
INSERT INTO portuguese_lemma VALUES ("r#00049947","r","agresivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00049947","r","brilhantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00211651","r","brilhantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00429534","r","brilhantemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00027235","n","matricula","N");
INSERT INTO portuguese_lemma VALUES ("n#00027235","n","matrícula","N");
INSERT INTO portuguese_lemma VALUES ("n#01248608","n","matrícula","N");
INSERT INTO portuguese_lemma VALUES ("n#00027235","n","inscrição","N");
INSERT INTO portuguese_lemma VALUES ("n#04828090","n","inscrição","N");
INSERT INTO portuguese_lemma VALUES ("n#00027235","n","registro","N");
INSERT INTO portuguese_lemma VALUES ("n#04071876","n","registro","N");
INSERT INTO portuguese_lemma VALUES ("n#04881717","n","registro","N");
INSERT INTO portuguese_lemma VALUES ("n#04883282","n","registro","N");
INSERT INTO portuguese_lemma VALUES ("n#04984758","n","registro","N");
INSERT INTO portuguese_lemma VALUES ("r#00050186","r","sem_parar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00050186","r","firmemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00050817","r","firmemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00092569","r","firmemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00224700","r","firmemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00300137","r","firmemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00050260","a","ablativo","N");
INSERT INTO portuguese_lemma VALUES ("a#03041636","a","ablativo","N");
INSERT INTO portuguese_lemma VALUES ("n#06312418","n","ablativo","N");
INSERT INTO portuguese_lemma VALUES ("r#00050297","r","contentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00050297","r","alegremente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230749","r","alegremente","N");
INSERT INTO portuguese_lemma VALUES ("r#00280168","r","alegremente","N");
INSERT INTO portuguese_lemma VALUES ("r#00348247","r","alegremente","N");
INSERT INTO portuguese_lemma VALUES ("a#00050446","a","redutor","N");
INSERT INTO portuguese_lemma VALUES ("n#00050484","n","aparição","N");
INSERT INTO portuguese_lemma VALUES ("n#04532842","n","aparição","N");
INSERT INTO portuguese_lemma VALUES ("n#05458256","n","aparição","N");
INSERT INTO portuguese_lemma VALUES ("n#06896270","n","aparição","N");
INSERT INTO portuguese_lemma VALUES ("v#00036087","v","caber","N");
INSERT INTO portuguese_lemma VALUES ("v#00036087","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00207305","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00665476","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01026409","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01496497","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01030210","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01528821","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01063016","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01079342","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01613239","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01354457","v","colocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00036087","v","trazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01433674","v","trazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00996361","v","trazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01328437","v","trazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01422262","v","trazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01424107","v","trazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01527254","v","trazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00036087","v","usar","N");
INSERT INTO portuguese_lemma VALUES ("v#00788109","v","usar","N");
INSERT INTO portuguese_lemma VALUES ("v#00792261","v","usar","N");
INSERT INTO portuguese_lemma VALUES ("v#01752442","v","usar","N");
INSERT INTO portuguese_lemma VALUES ("v#00036087","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#00207305","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#00665476","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01026409","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01030210","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01062571","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01063016","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01079342","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01085355","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01613239","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01970646","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("v#01354457","v","pôr","N");
INSERT INTO portuguese_lemma VALUES ("r#00050817","r","sem_hesitação","Y");
INSERT INTO portuguese_lemma VALUES ("r#00241550","r","sem_hesitação","Y");
INSERT INTO portuguese_lemma VALUES ("r#00298765","r","sem_hesitação","Y");
INSERT INTO portuguese_lemma VALUES ("r#00050817","r","com_firmeza","Y");
INSERT INTO portuguese_lemma VALUES ("r#00051017","r","com_firmeza","Y");
INSERT INTO portuguese_lemma VALUES ("r#00051017","r","diretamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00051017","r","com_convicção","Y");
INSERT INTO portuguese_lemma VALUES ("a#00053037","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("a#00053327","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("a#00812035","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("a#00968256","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("a#01077975","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("a#01316335","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("a#01878870","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("a#01879667","a","adequado","N");
INSERT INTO portuguese_lemma VALUES ("n#00027910","n","volta","N");
INSERT INTO portuguese_lemma VALUES ("n#05538316","n","volta","N");
INSERT INTO portuguese_lemma VALUES ("n#13869547","n","volta","N");
INSERT INTO portuguese_lemma VALUES ("n#00027910","n","regresso","N");
INSERT INTO portuguese_lemma VALUES ("n#00211639","n","regresso","N");
INSERT INTO portuguese_lemma VALUES ("n#05538316","n","regresso","N");
INSERT INTO portuguese_lemma VALUES ("n#00027910","n","retorno","N");
INSERT INTO portuguese_lemma VALUES ("n#00089351","n","retorno","N");
INSERT INTO portuguese_lemma VALUES ("n#00211639","n","retorno","N");
INSERT INTO portuguese_lemma VALUES ("n#13256691","n","retorno","N");
INSERT INTO portuguese_lemma VALUES ("n#13479380","n","retorno","N");
INSERT INTO portuguese_lemma VALUES ("n#00051897","n","penetração_de_mercado","Y");
INSERT INTO portuguese_lemma VALUES ("v#00037183","v","vestido","N");
INSERT INTO portuguese_lemma VALUES ("v#00106592","v","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#02456798","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#02222774","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#03051540","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#03113657","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#02600401","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#02764599","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#03450516","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#03450734","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#04097866","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#03346396","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("n#03438739","n","vestido","N");
INSERT INTO portuguese_lemma VALUES ("r#00052152","r","exatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00158309","r","exatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00204523","r","exatamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00054157","a","incompetente","N");
INSERT INTO portuguese_lemma VALUES ("a#00511214","a","incompetente","N");
INSERT INTO portuguese_lemma VALUES ("a#01128103","a","incompetente","N");
INSERT INTO portuguese_lemma VALUES ("a#02229324","a","incompetente","N");
INSERT INTO portuguese_lemma VALUES ("n#00052500","n","pouso","N");
INSERT INTO portuguese_lemma VALUES ("n#00052500","n","aterrissagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00188766","n","aterrissagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00052500","n","aterragem","N");
INSERT INTO portuguese_lemma VALUES ("n#00305005","n","aterragem","N");
INSERT INTO portuguese_lemma VALUES ("v#00052548","v","fecundar","N");
INSERT INTO portuguese_lemma VALUES ("v#00504270","v","fecundar","N");
INSERT INTO portuguese_lemma VALUES ("v#00052548","v","inseminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00052548","v","fertilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00504270","v","fertilizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00052672","a","adesivo","N");
INSERT INTO portuguese_lemma VALUES ("r#00052882","r","amargamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00053032","a","aderente","N");
INSERT INTO portuguese_lemma VALUES ("n#00029442","n","despedida","N");
INSERT INTO portuguese_lemma VALUES ("n#04973475","n","despedida","N");
INSERT INTO portuguese_lemma VALUES ("v#00037785","v","engravidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00037785","v","emprenhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00053341","v","emprenhar","N");
INSERT INTO portuguese_lemma VALUES ("r#00053274","r","depressa","N");
INSERT INTO portuguese_lemma VALUES ("a#00055097","a","coerente","N");
INSERT INTO portuguese_lemma VALUES ("a#00433594","a","coerente","N");
INSERT INTO portuguese_lemma VALUES ("a#00802172","a","coerente","N");
INSERT INTO portuguese_lemma VALUES ("a#01857552","a","coerente","N");
INSERT INTO portuguese_lemma VALUES ("a#00055097","a","tenaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01934939","a","tenaz","N");
INSERT INTO portuguese_lemma VALUES ("a#02216747","a","tenaz","N");
INSERT INTO portuguese_lemma VALUES ("n#04450749","n","tenaz","N");
INSERT INTO portuguese_lemma VALUES ("r#00053394","r","semrodeios","N");
INSERT INTO portuguese_lemma VALUES ("n#00053405","n","saída_à_francesa","Y");
INSERT INTO portuguese_lemma VALUES ("a#00053564","a","coesivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00053564","a","coeso","N");
INSERT INTO portuguese_lemma VALUES ("n#00029712","n","desaparição","N");
INSERT INTO portuguese_lemma VALUES ("a#00053691","a","viscoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00054109","a","viscoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02417028","a","viscoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00053744","r","de_forma_prática","Y");
INSERT INTO portuguese_lemma VALUES ("r#00053744","r","quase","N");
INSERT INTO portuguese_lemma VALUES ("r#00073033","r","quase","N");
INSERT INTO portuguese_lemma VALUES ("n#00029961","n","retirada","N");
INSERT INTO portuguese_lemma VALUES ("n#00031519","n","retirada","N");
INSERT INTO portuguese_lemma VALUES ("n#00031741","n","retirada","N");
INSERT INTO portuguese_lemma VALUES ("r#00053952","r","provavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00138611","r","provavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00054212","r","depois","N");
INSERT INTO portuguese_lemma VALUES ("r#00117620","r","depois","N");
INSERT INTO portuguese_lemma VALUES ("r#00146281","r","depois","N");
INSERT INTO portuguese_lemma VALUES ("r#00054212","r","a_seguir","Y");
INSERT INTO portuguese_lemma VALUES ("r#00054212","r","próximo","N");
INSERT INTO portuguese_lemma VALUES ("a#00130334","a","próximo","N");
INSERT INTO portuguese_lemma VALUES ("r#00160440","r","próximo","N");
INSERT INTO portuguese_lemma VALUES ("a#00412848","a","próximo","N");
INSERT INTO portuguese_lemma VALUES ("a#00413658","a","próximo","N");
INSERT INTO portuguese_lemma VALUES ("a#00415743","a","próximo","N");
INSERT INTO portuguese_lemma VALUES ("a#00417100","a","próximo","N");
INSERT INTO portuguese_lemma VALUES ("a#00419102","a","próximo","N");
INSERT INTO portuguese_lemma VALUES ("a#01668941","a","próximo","N");
INSERT INTO portuguese_lemma VALUES ("r#00054212","r","seguinte","N");
INSERT INTO portuguese_lemma VALUES ("a#00130202","a","seguinte","N");
INSERT INTO portuguese_lemma VALUES ("a#00130334","a","seguinte","N");
INSERT INTO portuguese_lemma VALUES ("v#00054285","v","conceber","N");
INSERT INTO portuguese_lemma VALUES ("v#00038574","v","conceber","N");
INSERT INTO portuguese_lemma VALUES ("v#00711550","v","conceber","N");
INSERT INTO portuguese_lemma VALUES ("v#01122689","v","conceber","N");
INSERT INTO portuguese_lemma VALUES ("r#00054327","r","temporiamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00088303","r","temporiamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00054327","r","provisoriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00064946","r","provisoriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00088303","r","provisoriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00480195","r","provisoriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00054327","r","por_enquanto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00064946","r","por_enquanto","Y");
INSERT INTO portuguese_lemma VALUES ("n#00054328","n","esfacelamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00038574","v","gerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00038872","v","gerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00056683","v","gerar","N");
INSERT INTO portuguese_lemma VALUES ("v#01118767","v","gerar","N");
INSERT INTO portuguese_lemma VALUES ("v#01119839","v","gerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00038574","v","ter_filho","Y");
INSERT INTO portuguese_lemma VALUES ("v#00038574","v","procriar","N");
INSERT INTO portuguese_lemma VALUES ("v#00038872","v","procriar","N");
INSERT INTO portuguese_lemma VALUES ("v#00056683","v","procriar","N");
INSERT INTO portuguese_lemma VALUES ("v#01118767","v","procriar","N");
INSERT INTO portuguese_lemma VALUES ("r#00054636","r","à_máquina","Y");
INSERT INTO portuguese_lemma VALUES ("n#00054821","n","evacuação","N");
INSERT INTO portuguese_lemma VALUES ("n#00395797","n","evacuação","N");
INSERT INTO portuguese_lemma VALUES ("n#13473097","n","evacuação","N");
INSERT INTO portuguese_lemma VALUES ("r#00054950","r","terrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00055101","r","terrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00056340","r","terrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00199565","r","terrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00316486","r","terrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00505744","r","terrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00055010","v","ejacular","N");
INSERT INTO portuguese_lemma VALUES ("v#00981944","v","ejacular","N");
INSERT INTO portuguese_lemma VALUES ("r#00055101","r","abissalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00038872","v","reproduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00649220","v","reproduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00979715","v","reproduzir","N");
INSERT INTO portuguese_lemma VALUES ("n#00030682","n","deserção","N");
INSERT INTO portuguese_lemma VALUES ("a#00055340","a","processual","N");
INSERT INTO portuguese_lemma VALUES ("r#00055518","r","de_forma_intolerável","Y");
INSERT INTO portuguese_lemma VALUES ("r#00055518","r","inaceitavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00055518","r","intoleravelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00056407","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00807895","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00808287","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00886008","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00858627","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#02865172","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#01523975","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#01524177","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#01524557","a","essencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00056407","a","substancial","N");
INSERT INTO portuguese_lemma VALUES ("a#00590782","a","substancial","N");
INSERT INTO portuguese_lemma VALUES ("a#00592078","a","substancial","N");
INSERT INTO portuguese_lemma VALUES ("a#00857259","a","substancial","N");
INSERT INTO portuguese_lemma VALUES ("a#02165307","a","substancial","N");
INSERT INTO portuguese_lemma VALUES ("a#00056407","a","substantivo","N");
INSERT INTO portuguese_lemma VALUES ("n#06303540","n","substantivo","N");
INSERT INTO portuguese_lemma VALUES ("n#04766930","n","substantivo","N");
INSERT INTO portuguese_lemma VALUES ("n#04768298","n","substantivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00039057","v","propagar","N");
INSERT INTO portuguese_lemma VALUES ("v#00039309","v","propagar","N");
INSERT INTO portuguese_lemma VALUES ("r#00055739","r","abusivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00055739","r","de_forma_abusiva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00055859","r","admiradamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00056778","a","adornado","N");
INSERT INTO portuguese_lemma VALUES ("n#00031327","n","expatriação","N");
INSERT INTO portuguese_lemma VALUES ("n#00031327","n","emigração","N");
INSERT INTO portuguese_lemma VALUES ("v#00056093","v","inocular","N");
INSERT INTO portuguese_lemma VALUES ("n#00031422","n","imigração","N");
INSERT INTO portuguese_lemma VALUES ("n#08413834","n","imigração","N");
INSERT INTO portuguese_lemma VALUES ("n#07334599","n","imigração","N");
INSERT INTO portuguese_lemma VALUES ("r#00056340","r","horrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00056652","r","de_forma_drástica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00056652","r","drasticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00056729","r","quer_que","Y");
INSERT INTO portuguese_lemma VALUES ("r#00056729","r","nada","N");
INSERT INTO portuguese_lemma VALUES ("n#09893278","n","nada","N");
INSERT INTO portuguese_lemma VALUES ("v#00039991","v","pôr_no_mundo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00039991","v","dar_à_luz","Y");
INSERT INTO portuguese_lemma VALUES ("v#00039991","v","dar_à_luz","Y");
INSERT INTO portuguese_lemma VALUES ("v#00039991","v","dar_a_luz","Y");
INSERT INTO portuguese_lemma VALUES ("v#00039991","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00040631","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00040829","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00040922","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00041013","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00041201","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00041285","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00041370","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00041451","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#01197357","v","parir","N");
INSERT INTO portuguese_lemma VALUES ("v#00039991","v","ter","N");
INSERT INTO portuguese_lemma VALUES ("v#00045715","v","ter","N");
INSERT INTO portuguese_lemma VALUES ("v#00045966","v","ter","N");
INSERT INTO portuguese_lemma VALUES ("v#01443215","v","ter","N");
INSERT INTO portuguese_lemma VALUES ("v#01509295","v","ter","N");
INSERT INTO portuguese_lemma VALUES ("v#01795751","v","ter","N");
INSERT INTO portuguese_lemma VALUES ("v#01842330","v","ter","N");
INSERT INTO portuguese_lemma VALUES ("r#00057042","r","de_nenhuma_maneira","Y");
INSERT INTO portuguese_lemma VALUES ("r#00057042","r","nem_a_pau","Y");
INSERT INTO portuguese_lemma VALUES ("r#00057042","r","de_modo_nenhum","Y");
INSERT INTO portuguese_lemma VALUES ("r#00057042","r","porra_nenhuma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00057042","r","nem_que_a_vaca_tussa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00057042","r","de_forma_nenhuma","Y");
INSERT INTO portuguese_lemma VALUES ("a#02267686","a","de_forma_nenhuma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00057257","r","exaustivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00057388","r","minuciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00057892","r","minuciosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#01460594","v","minuciosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00031866","n","recessão","N");
INSERT INTO portuguese_lemma VALUES ("n#00811593","n","recessão","N");
INSERT INTO portuguese_lemma VALUES ("n#10092910","n","recessão","N");
INSERT INTO portuguese_lemma VALUES ("n#10394468","n","recessão","N");
INSERT INTO portuguese_lemma VALUES ("n#00058002","n","desembarque","N");
INSERT INTO portuguese_lemma VALUES ("n#00058247","n","desembarque","N");
INSERT INTO portuguese_lemma VALUES ("r#00058128","r","direto","N");
INSERT INTO portuguese_lemma VALUES ("a#00729544","a","direto","N");
INSERT INTO portuguese_lemma VALUES ("n#00058337","n","embarque","N");
INSERT INTO portuguese_lemma VALUES ("r#00058359","r","indiretamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00058359","r","indirectamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00032499","n","saída","N");
INSERT INTO portuguese_lemma VALUES ("n#02651996","n","saída","N");
INSERT INTO portuguese_lemma VALUES ("n#00032687","n","escapada","N");
INSERT INTO portuguese_lemma VALUES ("v#00041553","v","aguardar","N");
INSERT INTO portuguese_lemma VALUES ("v#00059376","v","aguardar","N");
INSERT INTO portuguese_lemma VALUES ("v#00487408","v","aguardar","N");
INSERT INTO portuguese_lemma VALUES ("v#01811441","v","aguardar","N");
INSERT INTO portuguese_lemma VALUES ("v#01800838","v","aguardar","N");
INSERT INTO portuguese_lemma VALUES ("v#01803556","v","aguardar","N");
INSERT INTO portuguese_lemma VALUES ("v#00041553","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00059376","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00706047","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00487408","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01804961","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01811441","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01244897","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01245981","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01246466","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01800838","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01803556","v","esperar","N");
INSERT INTO portuguese_lemma VALUES ("n#00059127","n","evasão","N");
INSERT INTO portuguese_lemma VALUES ("n#00033906","n","evasão","N");
INSERT INTO portuguese_lemma VALUES ("n#00173283","n","evasão","N");
INSERT INTO portuguese_lemma VALUES ("n#06761099","n","evasão","N");
INSERT INTO portuguese_lemma VALUES ("r#00059171","r","um_monte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00059171","r","muita","N");
INSERT INTO portuguese_lemma VALUES ("r#00059171","r","mui","N");
INSERT INTO portuguese_lemma VALUES ("n#00033506","n","manobra","N");
INSERT INTO portuguese_lemma VALUES ("n#00109256","n","manobra","N");
INSERT INTO portuguese_lemma VALUES ("n#00363237","n","manobra","N");
INSERT INTO portuguese_lemma VALUES ("n#00611703","n","manobra","N");
INSERT INTO portuguese_lemma VALUES ("n#00615775","n","manobra","N");
INSERT INTO portuguese_lemma VALUES ("n#04538754","n","manobra","N");
INSERT INTO portuguese_lemma VALUES ("v#00042125","v","abortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00059899","v","abortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00246783","v","abortar","N");
INSERT INTO portuguese_lemma VALUES ("a#00059782","a","guarnecido","N");
INSERT INTO portuguese_lemma VALUES ("r#00059854","r","mais_e_mais","Y");
INSERT INTO portuguese_lemma VALUES ("r#00059854","r","progressivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00059854","r","cada_vez_mais","Y");
INSERT INTO portuguese_lemma VALUES ("r#00059854","r","crescentemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00059965","a","estofado","N");
INSERT INTO portuguese_lemma VALUES ("v#00060185","v","eclodir","N");
INSERT INTO portuguese_lemma VALUES ("v#00063095","v","eclodir","N");
INSERT INTO portuguese_lemma VALUES ("n#00060548","n","hégira","N");
INSERT INTO portuguese_lemma VALUES ("r#00060632","r","anteriormente","N");
INSERT INTO portuguese_lemma VALUES ("r#00074095","r","anteriormente","N");
INSERT INTO portuguese_lemma VALUES ("r#00265579","r","anteriormente","N");
INSERT INTO portuguese_lemma VALUES ("r#00060632","r","diante","N");
INSERT INTO portuguese_lemma VALUES ("r#00060632","r","previamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00060632","r","em_lugar_anterior","Y");
INSERT INTO portuguese_lemma VALUES ("r#00118965","r","em_lugar_anterior","Y");
INSERT INTO portuguese_lemma VALUES ("r#00060632","r","antes","N");
INSERT INTO portuguese_lemma VALUES ("r#00060939","r","antes","N");
INSERT INTO portuguese_lemma VALUES ("n#00060817","n","Underground_railroad","Y");
INSERT INTO portuguese_lemma VALUES ("v#00060833","v","capar","N");
INSERT INTO portuguese_lemma VALUES ("v#00061079","v","capar","N");
INSERT INTO portuguese_lemma VALUES ("v#00060833","v","castrar","N");
INSERT INTO portuguese_lemma VALUES ("r#00060939","r","dantes","N");
INSERT INTO portuguese_lemma VALUES ("a#00060969","a","colinérgico","N");
INSERT INTO portuguese_lemma VALUES ("a#00061088","a","anticolinérgico","N");
INSERT INTO portuguese_lemma VALUES ("a#00061088","a","Anti-colinérgico","N");
INSERT INTO portuguese_lemma VALUES ("n#00061171","n","Surfacing","N");
INSERT INTO portuguese_lemma VALUES ("r#00061203","r","subsequentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061203","r","posteriormente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061203","r","após","N");
INSERT INTO portuguese_lemma VALUES ("r#00061203","r","subseqüentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061203","r","mais_tarde","Y");
INSERT INTO portuguese_lemma VALUES ("r#00117620","r","mais_tarde","Y");
INSERT INTO portuguese_lemma VALUES ("r#00146281","r","mais_tarde","Y");
INSERT INTO portuguese_lemma VALUES ("r#00155488","r","mais_tarde","Y");
INSERT INTO portuguese_lemma VALUES ("a#00149236","a","alerta","N");
INSERT INTO portuguese_lemma VALUES ("a#00149236","a","bem_disposto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00149236","a","hábil","N");
INSERT INTO portuguese_lemma VALUES ("a#00061885","a","hábil","N");
INSERT INTO portuguese_lemma VALUES ("a#01090656","a","hábil","N");
INSERT INTO portuguese_lemma VALUES ("a#02120998","a","hábil","N");
INSERT INTO portuguese_lemma VALUES ("a#00149236","a","animado","N");
INSERT INTO portuguese_lemma VALUES ("a#00120252","a","animado","N");
INSERT INTO portuguese_lemma VALUES ("a#00353226","a","animado","N");
INSERT INTO portuguese_lemma VALUES ("n#00034968","n","expedição","N");
INSERT INTO portuguese_lemma VALUES ("n#00200777","n","expedição","N");
INSERT INTO portuguese_lemma VALUES ("n#00621864","n","expedição","N");
INSERT INTO portuguese_lemma VALUES ("n#00716041","n","expedição","N");
INSERT INTO portuguese_lemma VALUES ("n#06218497","n","expedição","N");
INSERT INTO portuguese_lemma VALUES ("n#00034968","n","envio","N");
INSERT INTO portuguese_lemma VALUES ("n#01060234","n","envio","N");
INSERT INTO portuguese_lemma VALUES ("r#00061528","r","precipitadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00206479","r","precipitadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00429390","r","precipitadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061528","r","abruptamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00429390","r","abruptamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061528","r","subitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00061677","r","subitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00151957","r","subitamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00061595","v","esterilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00062582","v","esterilizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00061885","a","genial","N");
INSERT INTO portuguese_lemma VALUES ("a#00061885","a","engenhoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00301854","a","engenhoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00061885","a","astuto","N");
INSERT INTO portuguese_lemma VALUES ("a#00148874","a","astuto","N");
INSERT INTO portuguese_lemma VALUES ("a#00149802","a","astuto","N");
INSERT INTO portuguese_lemma VALUES ("a#00407935","a","astuto","N");
INSERT INTO portuguese_lemma VALUES ("a#01253976","a","astuto","N");
INSERT INTO portuguese_lemma VALUES ("a#01256495","a","astuto","N");
INSERT INTO portuguese_lemma VALUES ("a#02347493","a","astuto","N");
INSERT INTO portuguese_lemma VALUES ("n#00035701","n","orgasmo","N");
INSERT INTO portuguese_lemma VALUES ("v#00062203","v","menstruar","N");
INSERT INTO portuguese_lemma VALUES ("r#00062330","r","intencionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00062330","r","deliberadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00062330","r","de_propósito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00507323","r","de_propósito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00062330","r","de_forma_intencional","Y");
INSERT INTO portuguese_lemma VALUES ("r#00062330","r","por_escolha","Y");
INSERT INTO portuguese_lemma VALUES ("r#00062330","r","nomeadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00062330","r","expressamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00085512","r","expressamente","N");
INSERT INTO portuguese_lemma VALUES ("a#01090656","a","jeitoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00062650","r","sem_querer","Y");
INSERT INTO portuguese_lemma VALUES ("r#00062650","r","involuntariamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00036271","n","obtenção","N");
INSERT INTO portuguese_lemma VALUES ("n#00051225","n","obtenção","N");
INSERT INTO portuguese_lemma VALUES ("r#00062857","r","conformemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00062857","r","correspondentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00036443","n","récorde","N");
INSERT INTO portuguese_lemma VALUES ("r#00063172","r","ao_invés_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00063172","r","em_vez_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00063172","r","alternativamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00065067","a","desajeitado","N");
INSERT INTO portuguese_lemma VALUES ("a#01091940","a","desajeitado","N");
INSERT INTO portuguese_lemma VALUES ("v#00044261","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#00503715","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01771194","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01220279","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01221002","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01221478","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01221816","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01221988","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01222491","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("v#01795333","v","irritar","N");
INSERT INTO portuguese_lemma VALUES ("n#00063559","n","recorde_mundial","Y");
INSERT INTO portuguese_lemma VALUES ("n#00063559","n","Recorde_Mundial","Y");
INSERT INTO portuguese_lemma VALUES ("n#00063559","n","Recordes_mundiais","Y");
INSERT INTO portuguese_lemma VALUES ("a#00065335","a","desengoçado","N");
INSERT INTO portuguese_lemma VALUES ("n#00036683","n","sucesso","N");
INSERT INTO portuguese_lemma VALUES ("n#00037139","n","sucesso","N");
INSERT INTO portuguese_lemma VALUES ("n#14474052","n","sucesso","N");
INSERT INTO portuguese_lemma VALUES ("n#00036683","n","triunfo","N");
INSERT INTO portuguese_lemma VALUES ("n#05596663","n","triunfo","N");
INSERT INTO portuguese_lemma VALUES ("n#00036683","n","êxito","N");
INSERT INTO portuguese_lemma VALUES ("n#10383516","n","êxito","N");
INSERT INTO portuguese_lemma VALUES ("v#00063724","v","inflamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00044675","v","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("a#00197151","a","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00519450","v","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00812117","v","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("v#01204371","v","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("v#01204852","v","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238399","v","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238553","v","acalmar","N");
INSERT INTO portuguese_lemma VALUES ("r#00064083","r","anatomicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00044854","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00062604","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00140363","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00140682","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00140937","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00142397","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00157745","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184775","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00385378","v","melhorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00044854","v","atenuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00613501","v","atenuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00044854","v","amenizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00116292","v","amenizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167516","v","amenizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00044854","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00056311","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("a#00477896","a","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00361385","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00819436","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("v#01204852","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238399","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238553","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238726","v","aliviar","N");
INSERT INTO portuguese_lemma VALUES ("n#00064151","n","arrasa-quarteirão","N");
INSERT INTO portuguese_lemma VALUES ("r#00064189","r","cegamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00173992","r","cegamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00064189","r","às_cegas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00173992","r","às_cegas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00064464","r","cronologicamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00064479","a","propício","N");
INSERT INTO portuguese_lemma VALUES ("a#00176908","a","propício","N");
INSERT INTO portuguese_lemma VALUES ("a#00177964","a","propício","N");
INSERT INTO portuguese_lemma VALUES ("a#00178165","a","propício","N");
INSERT INTO portuguese_lemma VALUES ("a#01602210","a","propício","N");
INSERT INTO portuguese_lemma VALUES ("a#00064479","a","vantajoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00067152","a","vantajoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00178165","a","vantajoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01747057","a","vantajoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00064479","a","profícuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00883926","a","profícuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00064479","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00178165","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00315634","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00572209","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00942944","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00943564","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00944158","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("a#01023795","a","favorável","N");
INSERT INTO portuguese_lemma VALUES ("v#00064487","v","massagear","N");
INSERT INTO portuguese_lemma VALUES ("n#00037139","n","sensação","N");
INSERT INTO portuguese_lemma VALUES ("n#04413760","n","sensação","N");
INSERT INTO portuguese_lemma VALUES ("n#04419902","n","sensação","N");
INSERT INTO portuguese_lemma VALUES ("n#05586720","n","sensação","N");
INSERT INTO portuguese_lemma VALUES ("n#00037139","n","estrondo","N");
INSERT INTO portuguese_lemma VALUES ("n#07430211","n","estrondo","N");
INSERT INTO portuguese_lemma VALUES ("r#00064583","r","clinicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00045186","v","machucar","N");
INSERT INTO portuguese_lemma VALUES ("v#00048850","v","machucar","N");
INSERT INTO portuguese_lemma VALUES ("v#00069684","v","machucar","N");
INSERT INTO portuguese_lemma VALUES ("v#00177802","v","machucar","N");
INSERT INTO portuguese_lemma VALUES ("v#00045186","v","aleijar","N");
INSERT INTO portuguese_lemma VALUES ("v#00045186","v","ferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00048850","v","ferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00069684","v","ferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00045186","v","doer","N");
INSERT INTO portuguese_lemma VALUES ("v#00054373","v","doer","N");
INSERT INTO portuguese_lemma VALUES ("v#01451659","v","doer","N");
INSERT INTO portuguese_lemma VALUES ("v#01452083","v","doer","N");
INSERT INTO portuguese_lemma VALUES ("a#00067152","a","benéfico","N");
INSERT INTO portuguese_lemma VALUES ("a#00067152","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#00597129","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#00998470","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#01076114","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#01082452","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#01280193","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#01529605","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#01602469","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#01807436","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#01921348","a","bom","N");
INSERT INTO portuguese_lemma VALUES ("a#00067152","a","boa","N");
INSERT INTO portuguese_lemma VALUES ("a#00998470","a","boa","N");
INSERT INTO portuguese_lemma VALUES ("a#01076114","a","boa","N");
INSERT INTO portuguese_lemma VALUES ("a#01082452","a","boa","N");
INSERT INTO portuguese_lemma VALUES ("a#01529605","a","boa","N");
INSERT INTO portuguese_lemma VALUES ("n#03325584","n","boa","N");
INSERT INTO portuguese_lemma VALUES ("v#00064889","v","indispor","N");
INSERT INTO portuguese_lemma VALUES ("r#00064946","r","ao_mesmo_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00120095","r","ao_mesmo_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00120223","r","ao_mesmo_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00153261","r","ao_mesmo_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00064946","r","entretanto","N");
INSERT INTO portuguese_lemma VALUES ("a#00065064","a","positiva","N");
INSERT INTO portuguese_lemma VALUES ("a#00065064","a","positivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01747057","a","positivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00054373","v","sofrer","N");
INSERT INTO portuguese_lemma VALUES ("v#00045966","v","sofrer","N");
INSERT INTO portuguese_lemma VALUES ("v#00054559","v","sofrer","N");
INSERT INTO portuguese_lemma VALUES ("v#01224912","v","sofrer","N");
INSERT INTO portuguese_lemma VALUES ("v#02108377","v","sofrer","N");
INSERT INTO portuguese_lemma VALUES ("v#02719807","v","sofrer","N");
INSERT INTO portuguese_lemma VALUES ("r#00065184","r","enquanto_isso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00065294","r","duas_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00065294","r","duas","N");
INSERT INTO portuguese_lemma VALUES ("n#13743269","n","duas","N");
INSERT INTO portuguese_lemma VALUES ("v#00045715","v","padecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00054559","v","padecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00067911","a","desfavorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00943257","a","desfavorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00944348","a","desfavorável","N");
INSERT INTO portuguese_lemma VALUES ("a#01082026","a","desfavorável","N");
INSERT INTO portuguese_lemma VALUES ("a#00067911","a","desvantajoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00065495","v","estar_bem","Y");
INSERT INTO portuguese_lemma VALUES ("v#00065495","v","sentir-se_bem","Y");
INSERT INTO portuguese_lemma VALUES ("r#00065575","r","extensamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00495663","r","extensamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00045966","v","contrair","N");
INSERT INTO portuguese_lemma VALUES ("v#00059435","v","contrair","N");
INSERT INTO portuguese_lemma VALUES ("v#00164388","v","contrair","N");
INSERT INTO portuguese_lemma VALUES ("v#00873632","v","contrair","N");
INSERT INTO portuguese_lemma VALUES ("v#00951804","v","contrair","N");
INSERT INTO portuguese_lemma VALUES ("a#00065667","a","negativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01750220","a","negativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00554376","a","negativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00202234","a","negativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00068206","a","aventureiro","N");
INSERT INTO portuguese_lemma VALUES ("r#00065822","r","por_último","Y");
INSERT INTO portuguese_lemma VALUES ("n#00038052","n","crédito","N");
INSERT INTO portuguese_lemma VALUES ("n#09631860","n","crédito","N");
INSERT INTO portuguese_lemma VALUES ("n#09634656","n","crédito","N");
INSERT INTO portuguese_lemma VALUES ("n#09651550","n","crédito","N");
INSERT INTO portuguese_lemma VALUES ("n#09655443","n","crédito","N");
INSERT INTO portuguese_lemma VALUES ("r#00065963","r","mas_não_menos_importante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00065963","r","último","N");
INSERT INTO portuguese_lemma VALUES ("r#00167575","r","último","N");
INSERT INTO portuguese_lemma VALUES ("a#00668366","a","último","N");
INSERT INTO portuguese_lemma VALUES ("a#00958252","a","último","N");
INSERT INTO portuguese_lemma VALUES ("v#00046267","v","choramingar","N");
INSERT INTO portuguese_lemma VALUES ("v#00046397","v","choramingar","N");
INSERT INTO portuguese_lemma VALUES ("v#00046267","v","gemer","N");
INSERT INTO portuguese_lemma VALUES ("v#00667147","v","gemer","N");
INSERT INTO portuguese_lemma VALUES ("v#00708262","v","gemer","N");
INSERT INTO portuguese_lemma VALUES ("a#00841837","a","arriscado","N");
INSERT INTO portuguese_lemma VALUES ("a#00196122","a","arriscado","N");
INSERT INTO portuguese_lemma VALUES ("a#01983358","a","arriscado","N");
INSERT INTO portuguese_lemma VALUES ("a#00841837","a","destemido","N");
INSERT INTO portuguese_lemma VALUES ("a#00081671","a","destemido","N");
INSERT INTO portuguese_lemma VALUES ("a#00246332","a","destemido","N");
INSERT INTO portuguese_lemma VALUES ("a#01415513","a","destemido","N");
INSERT INTO portuguese_lemma VALUES ("a#00264459","a","destemido","N");
INSERT INTO portuguese_lemma VALUES ("a#00841837","a","arriscador","N");
INSERT INTO portuguese_lemma VALUES ("a#00841837","a","audaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00246332","a","audaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01415513","a","audaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00841837","a","audacioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00246332","a","audacioso","N");
INSERT INTO portuguese_lemma VALUES ("a#01415513","a","audacioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00841837","a","ousado","N");
INSERT INTO portuguese_lemma VALUES ("a#01415513","a","ousado","N");
INSERT INTO portuguese_lemma VALUES ("v#00046397","v","derramar_lágrimas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00046397","v","chorar","N");
INSERT INTO portuguese_lemma VALUES ("n#00066216","n","insucesso","N");
INSERT INTO portuguese_lemma VALUES ("n#00066216","n","falha","N");
INSERT INTO portuguese_lemma VALUES ("n#00038702","n","falha","N");
INSERT INTO portuguese_lemma VALUES ("n#00042411","n","falha","N");
INSERT INTO portuguese_lemma VALUES ("n#09278537","n","falha","N");
INSERT INTO portuguese_lemma VALUES ("n#14417551","n","falha","N");
INSERT INTO portuguese_lemma VALUES ("n#10377620","n","falha","N");
INSERT INTO portuguese_lemma VALUES ("r#00066418","r","acusadoramente","N");
INSERT INTO portuguese_lemma VALUES ("n#00038702","n","fracasso","N");
INSERT INTO portuguese_lemma VALUES ("n#05484555","n","fracasso","N");
INSERT INTO portuguese_lemma VALUES ("n#00038702","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#00042411","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#00042960","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#00043865","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#00043956","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#03768006","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#03768117","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#04853765","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#04529867","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#04531221","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#04531479","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#05071571","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("n#10377620","n","erro","N");
INSERT INTO portuguese_lemma VALUES ("r#00066781","r","adiante","N");
INSERT INTO portuguese_lemma VALUES ("r#00066781","r","diante_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00066781","r","em_presença_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00066781","r","defronte","N");
INSERT INTO portuguese_lemma VALUES ("r#00066781","r","ante","N");
INSERT INTO portuguese_lemma VALUES ("r#00066781","r","em_frente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00170412","r","em_frente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00066781","r","frente","N");
INSERT INTO portuguese_lemma VALUES ("n#03398467","n","frente","N");
INSERT INTO portuguese_lemma VALUES ("n#06320385","n","frente","N");
INSERT INTO portuguese_lemma VALUES ("n#06320533","n","frente","N");
INSERT INTO portuguese_lemma VALUES ("v#00046943","v","lacrimejar","N");
INSERT INTO portuguese_lemma VALUES ("a#00069386","a","aconselhável","N");
INSERT INTO portuguese_lemma VALUES ("r#00067045","r","antecipadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00067265","r","para_diante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00103859","r","para_diante","Y");
INSERT INTO portuguese_lemma VALUES ("n#00067397","n","falta","N");
INSERT INTO portuguese_lemma VALUES ("n#00770997","n","falta","N");
INSERT INTO portuguese_lemma VALUES ("n#01234090","n","falta","N");
INSERT INTO portuguese_lemma VALUES ("n#10058951","n","falta","N");
INSERT INTO portuguese_lemma VALUES ("n#10367399","n","falta","N");
INSERT INTO portuguese_lemma VALUES ("n#10367751","n","falta","N");
INSERT INTO portuguese_lemma VALUES ("n#00067397","n","omissão","N");
INSERT INTO portuguese_lemma VALUES ("n#05706954","n","omissão","N");
INSERT INTO portuguese_lemma VALUES ("n#00067397","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#00043956","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#00738966","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#00476598","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#00478127","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#03677496","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#03677676","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#03677991","n","negligência","N");
INSERT INTO portuguese_lemma VALUES ("n#00067397","n","descuido","N");
INSERT INTO portuguese_lemma VALUES ("n#00043956","n","descuido","N");
INSERT INTO portuguese_lemma VALUES ("n#04661926","n","descuido","N");
INSERT INTO portuguese_lemma VALUES ("n#00039700","n","derrota","N");
INSERT INTO portuguese_lemma VALUES ("n#05558471","n","derrota","N");
INSERT INTO portuguese_lemma VALUES ("n#05605777","n","derrota","N");
INSERT INTO portuguese_lemma VALUES ("n#00039700","n","perda","N");
INSERT INTO portuguese_lemma VALUES ("n#00135125","n","perda","N");
INSERT INTO portuguese_lemma VALUES ("n#04022310","n","perda","N");
INSERT INTO portuguese_lemma VALUES ("n#05455763","n","perda","N");
INSERT INTO portuguese_lemma VALUES ("n#09595129","n","perda","N");
INSERT INTO portuguese_lemma VALUES ("n#13328273","n","perda","N");
INSERT INTO portuguese_lemma VALUES ("v#00047342","v","transpirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00047530","v","transpirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00047342","v","suar","N");
INSERT INTO portuguese_lemma VALUES ("n#00067707","n","rendição","N");
INSERT INTO portuguese_lemma VALUES ("v#01117812","v","rendição","N");
INSERT INTO portuguese_lemma VALUES ("n#00067707","n","capitulação","N");
INSERT INTO portuguese_lemma VALUES ("v#01117812","v","capitulação","N");
INSERT INTO portuguese_lemma VALUES ("a#00067767","a","desaconselhável","N");
INSERT INTO portuguese_lemma VALUES ("a#00932565","a","desaconselhável","N");
INSERT INTO portuguese_lemma VALUES ("n#00040027","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#02254968","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#02299904","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#02300099","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#02819465","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#03549589","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#03051325","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#03839993","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04345915","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04022756","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04394770","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04395081","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#05688990","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04395690","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#05690269","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04396568","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04396796","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#04396893","n","obstáculo","N");
INSERT INTO portuguese_lemma VALUES ("n#00040027","n","frustração","N");
INSERT INTO portuguese_lemma VALUES ("n#05589778","n","frustração","N");
INSERT INTO portuguese_lemma VALUES ("n#05605777","n","frustração","N");
INSERT INTO portuguese_lemma VALUES ("v#00047530","v","exsudar","N");
INSERT INTO portuguese_lemma VALUES ("r#00068070","r","para_frente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00068215","r","o_tempo_todo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00068215","r","desde_o_começo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00040312","n","Recidiva","N");
INSERT INTO portuguese_lemma VALUES ("n#00040312","n","quebra","N");
INSERT INTO portuguese_lemma VALUES ("n#00068617","n","reincidência","N");
INSERT INTO portuguese_lemma VALUES ("n#00040483","n","decepção","N");
INSERT INTO portuguese_lemma VALUES ("n#05605549","n","decepção","N");
INSERT INTO portuguese_lemma VALUES ("n#00068901","n","inadimplência","N");
INSERT INTO portuguese_lemma VALUES ("n#13300411","n","inadimplência","N");
INSERT INTO portuguese_lemma VALUES ("n#00068901","n","não_cumprimento","Y");
INSERT INTO portuguese_lemma VALUES ("n#00068901","n","parada","N");
INSERT INTO portuguese_lemma VALUES ("n#00198945","n","parada","N");
INSERT INTO portuguese_lemma VALUES ("n#08428485","n","parada","N");
INSERT INTO portuguese_lemma VALUES ("a#00069060","a","anaeróbico","N");
INSERT INTO portuguese_lemma VALUES ("a#00069217","a","aeróbico","N");
INSERT INTO portuguese_lemma VALUES ("v#00069295","v","excretar","N");
INSERT INTO portuguese_lemma VALUES ("a#00071970","a","estético","N");
INSERT INTO portuguese_lemma VALUES ("a#02280052","a","estético","N");
INSERT INTO portuguese_lemma VALUES ("a#02753417","a","estético","N");
INSERT INTO portuguese_lemma VALUES ("r#00069672","r","igual","N");
INSERT INTO portuguese_lemma VALUES ("a#00845976","a","igual","N");
INSERT INTO portuguese_lemma VALUES ("n#06953318","n","igual","N");
INSERT INTO portuguese_lemma VALUES ("r#00069771","r","em_voz_alta","Y");
INSERT INTO portuguese_lemma VALUES ("r#00069901","r","em_voz_alta","Y");
INSERT INTO portuguese_lemma VALUES ("v#00048850","v","vulnerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00048850","v","lesar","N");
INSERT INTO portuguese_lemma VALUES ("v#00069684","v","lesar","N");
INSERT INTO portuguese_lemma VALUES ("r#00069901","r","emvozalta","N");
INSERT INTO portuguese_lemma VALUES ("r#00069901","r","ruidosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00072351","a","artístico","N");
INSERT INTO portuguese_lemma VALUES ("a#02280052","a","artístico","N");
INSERT INTO portuguese_lemma VALUES ("a#02753288","a","artístico","N");
INSERT INTO portuguese_lemma VALUES ("a#00070111","a","cosmético","N");
INSERT INTO portuguese_lemma VALUES ("a#01039405","a","cosmético","N");
INSERT INTO portuguese_lemma VALUES ("n#03113152","n","cosmético","N");
INSERT INTO portuguese_lemma VALUES ("n#03714235","n","cosmético","N");
INSERT INTO portuguese_lemma VALUES ("v#00049302","v","calcar","N");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","randomicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","arbitrariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","aleatóriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","ao_acaso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","atabalhoadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","a_torto_e_a_direito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00433363","r","a_torto_e_a_direito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","a_esmo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00070765","r","aleatoriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00244578","r","aleatoriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00433363","r","aleatoriamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00073543","a","afetado","N");
INSERT INTO portuguese_lemma VALUES ("a#00075417","a","afetado","N");
INSERT INTO portuguese_lemma VALUES ("a#01559903","a","afetado","N");
INSERT INTO portuguese_lemma VALUES ("a#01570470","a","afetado","N");
INSERT INTO portuguese_lemma VALUES ("n#00042411","n","equívoco","N");
INSERT INTO portuguese_lemma VALUES ("n#00042411","n","engano","N");
INSERT INTO portuguese_lemma VALUES ("n#05064035","n","engano","N");
INSERT INTO portuguese_lemma VALUES ("a#00071142","a","impressionado","N");
INSERT INTO portuguese_lemma VALUES ("r#00071165","r","por_perto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00071321","r","por_perto","Y");
INSERT INTO portuguese_lemma VALUES ("v#00071178","v","tortuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00071178","v","torturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01794523","v","torturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01802689","v","torturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00071178","v","atormentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01794523","v","atormentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01802689","v","atormentar","N");
INSERT INTO portuguese_lemma VALUES ("r#00071321","r","ao_pé_de","Y");
INSERT INTO portuguese_lemma VALUES ("a#00071559","a","sujeito","N");
INSERT INTO portuguese_lemma VALUES ("a#01924743","a","sujeito","N");
INSERT INTO portuguese_lemma VALUES ("n#04761687","n","sujeito","N");
INSERT INTO portuguese_lemma VALUES ("v#00050353","v","puxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00993032","v","puxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00997005","v","puxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00998398","v","puxar","N");
INSERT INTO portuguese_lemma VALUES ("v#01233464","v","puxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00050353","v","estirar","N");
INSERT INTO portuguese_lemma VALUES ("r#00071840","r","por_aí","Y");
INSERT INTO portuguese_lemma VALUES ("v#00072012","v","fazer_xixi","Y");
INSERT INTO portuguese_lemma VALUES ("v#00072012","v","urinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00072012","v","mijar","N");
INSERT INTO portuguese_lemma VALUES ("n#00043135","n","mácula","N");
INSERT INTO portuguese_lemma VALUES ("n#00043135","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("n#04682319","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("n#03689246","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("n#04693804","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("n#03696524","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("n#04694809","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("n#05088890","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("n#07837298","n","mancha","N");
INSERT INTO portuguese_lemma VALUES ("a#00072281","a","imune","N");
INSERT INTO portuguese_lemma VALUES ("a#02252092","a","imune","N");
INSERT INTO portuguese_lemma VALUES ("a#02365900","a","imune","N");
INSERT INTO portuguese_lemma VALUES ("a#02745862","a","imune","N");
INSERT INTO portuguese_lemma VALUES ("a#00072281","a","isento","N");
INSERT INTO portuguese_lemma VALUES ("a#02254137","a","isento","N");
INSERT INTO portuguese_lemma VALUES ("n#00043311","n","confusão","N");
INSERT INTO portuguese_lemma VALUES ("n#04531479","n","confusão","N");
INSERT INTO portuguese_lemma VALUES ("n#05581054","n","confusão","N");
INSERT INTO portuguese_lemma VALUES ("n#07508092","n","confusão","N");
INSERT INTO portuguese_lemma VALUES ("n#10068579","n","confusão","N");
INSERT INTO portuguese_lemma VALUES ("r#00072849","r","desesperadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00200614","r","desesperadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00301840","r","desesperadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00506807","r","desesperadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00072849","r","urgentemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00051051","v","expelir","N");
INSERT INTO portuguese_lemma VALUES ("v#00071198","v","expelir","N");
INSERT INTO portuguese_lemma VALUES ("v#01891307","v","expelir","N");
INSERT INTO portuguese_lemma VALUES ("n#00073032","n","bumerangue","N");
INSERT INTO portuguese_lemma VALUES ("r#00073033","r","perto_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00073033","r","por_pouco","Y");
INSERT INTO portuguese_lemma VALUES ("r#00073033","r","virtualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00111451","r","virtualmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00075417","a","artificial","N");
INSERT INTO portuguese_lemma VALUES ("a#00075798","a","artificial","N");
INSERT INTO portuguese_lemma VALUES ("a#00114728","a","artificial","N");
INSERT INTO portuguese_lemma VALUES ("a#00551365","a","artificial","N");
INSERT INTO portuguese_lemma VALUES ("a#01516193","a","artificial","N");
INSERT INTO portuguese_lemma VALUES ("a#01517836","a","artificial","N");
INSERT INTO portuguese_lemma VALUES ("a#01620591","a","artificial","N");
INSERT INTO portuguese_lemma VALUES ("n#00073177","n","arredondamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00073713","n","distorção","N");
INSERT INTO portuguese_lemma VALUES ("a#00076086","a","forçado","N");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","em_especial","Y");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","principalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","maiormente","N");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","primariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","precipuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","antes_de_mais_nada","Y");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","notadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","especialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00084223","r","especialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00139266","r","especialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00502710","r","especialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00073897","r","sobretudo","N");
INSERT INTO portuguese_lemma VALUES ("n#03057021","n","sobretudo","N");
INSERT INTO portuguese_lemma VALUES ("n#03456665","n","sobretudo","N");
INSERT INTO portuguese_lemma VALUES ("v#00074038","v","cagar","N");
INSERT INTO portuguese_lemma VALUES ("v#00074038","v","defecar","N");
INSERT INTO portuguese_lemma VALUES ("n#00074092","n","ato_falho","Y");
INSERT INTO portuguese_lemma VALUES ("n#00074092","n","Acto_falho","Y");
INSERT INTO portuguese_lemma VALUES ("a#00074094","a","artificioso","N");
INSERT INTO portuguese_lemma VALUES ("r#00074095","r","atrás","N");
INSERT INTO portuguese_lemma VALUES ("r#00074095","r","há","N");
INSERT INTO portuguese_lemma VALUES ("r#00074095","r","há_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00074095","r","faz","N");
INSERT INTO portuguese_lemma VALUES ("r#00074407","r","às_avessas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00074407","r","para_trás","Y");
INSERT INTO portuguese_lemma VALUES ("r#00075966","r","para_trás","Y");
INSERT INTO portuguese_lemma VALUES ("r#00074407","r","de_costas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00075966","r","de_costas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00074558","v","constipar","N");
INSERT INTO portuguese_lemma VALUES ("a#00076892","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("a#01349983","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("a#01513557","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("a#01515628","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("a#01518608","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("a#01521837","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("a#01538156","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("a#01884502","a","natural","N");
INSERT INTO portuguese_lemma VALUES ("n#00044168","n","fiasco","N");
INSERT INTO portuguese_lemma VALUES ("n#05484900","n","fiasco","N");
INSERT INTO portuguese_lemma VALUES ("n#00044168","n","bobagem","N");
INSERT INTO portuguese_lemma VALUES ("n#06612266","n","bobagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00044168","n","gafe","N");
INSERT INTO portuguese_lemma VALUES ("n#00076196","n","gafe","N");
INSERT INTO portuguese_lemma VALUES ("n#00045336","n","gafe","N");
INSERT INTO portuguese_lemma VALUES ("v#00074834","v","sangrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00052062","v","exaurir-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00052062","v","exaurir","N");
INSERT INTO portuguese_lemma VALUES ("v#00052062","v","cansar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00075135","a","afirmativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01747447","a","afirmativo","N");
INSERT INTO portuguese_lemma VALUES ("r#00075161","r","de_volta","Y");
INSERT INTO portuguese_lemma VALUES ("r#00075442","r","avante","N");
INSERT INTO portuguese_lemma VALUES ("r#00075656","r","pelo_contrario","Y");
INSERT INTO portuguese_lemma VALUES ("r#00075739","r","pelo_contrario","Y");
INSERT INTO portuguese_lemma VALUES ("r#00075656","r","por_detraz_ás_avessas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00075739","r","por_detraz_ás_avessas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00075656","r","surpreso","N");
INSERT INTO portuguese_lemma VALUES ("a#02357479","a","surpreso","N");
INSERT INTO portuguese_lemma VALUES ("r#00075656","r","atraz","N");
INSERT INTO portuguese_lemma VALUES ("r#00075739","r","atraz","N");
INSERT INTO portuguese_lemma VALUES ("r#00075739","r","detrás","N");
INSERT INTO portuguese_lemma VALUES ("n#00075912","n","fumble","N");
INSERT INTO portuguese_lemma VALUES ("v#00052840","v","fatigar","N");
INSERT INTO portuguese_lemma VALUES ("v#01243090","v","fatigar","N");
INSERT INTO portuguese_lemma VALUES ("r#00076193","r","para_lá_e_para_cá","Y");
INSERT INTO portuguese_lemma VALUES ("r#00076193","r","vai_e_vem","Y");
INSERT INTO portuguese_lemma VALUES ("r#00076193","r","vaivém","N");
INSERT INTO portuguese_lemma VALUES ("n#00076196","n","solecismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00053004","v","regurgitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01178335","v","regurgitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00053004","v","vomitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00077071","v","vomitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00118733","n","vomitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00076563","n","tropeço","N");
INSERT INTO portuguese_lemma VALUES ("n#00045686","n","tombo","N");
INSERT INTO portuguese_lemma VALUES ("a#00076921","a","flutuante","N");
INSERT INTO portuguese_lemma VALUES ("a#00076921","a","à_tona","Y");
INSERT INTO portuguese_lemma VALUES ("a#00077059","a","à_deriva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00267558","r","à_deriva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00267704","r","à_deriva","Y");
INSERT INTO portuguese_lemma VALUES ("a#01910652","a","à_deriva","Y");
INSERT INTO portuguese_lemma VALUES ("n#00077419","n","compra","N");
INSERT INTO portuguese_lemma VALUES ("n#00047517","n","compra","N");
INSERT INTO portuguese_lemma VALUES ("n#00049855","n","compra","N");
INSERT INTO portuguese_lemma VALUES ("n#00050836","n","compra","N");
INSERT INTO portuguese_lemma VALUES ("n#13253612","n","compra","N");
INSERT INTO portuguese_lemma VALUES ("r#00077497","r","comercialmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00080744","a","receoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00053673","v","sufocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00053673","v","asfixiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00053789","v","asfixiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00359511","v","asfixiar","N");
INSERT INTO portuguese_lemma VALUES ("v#01476180","v","asfixiar","N");
INSERT INTO portuguese_lemma VALUES ("v#01569181","v","asfixiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00053673","v","afogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00329171","v","afogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00333886","v","afogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00053789","v","estrangular","N");
INSERT INTO portuguese_lemma VALUES ("v#00359511","v","estrangular","N");
INSERT INTO portuguese_lemma VALUES ("r#00078050","r","conversamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00078138","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00183882","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00254265","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00374135","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00261966","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00262285","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00311143","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#02758581","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("v#02758826","v","congelar","N");
INSERT INTO portuguese_lemma VALUES ("a#00078463","a","amedrontado","N");
INSERT INTO portuguese_lemma VALUES ("n#00078536","n","anexação","N");
INSERT INTO portuguese_lemma VALUES ("n#00373418","n","anexação","N");
INSERT INTO portuguese_lemma VALUES ("n#00078536","n","incorporação","N");
INSERT INTO portuguese_lemma VALUES ("n#00239807","n","incorporação","N");
INSERT INTO portuguese_lemma VALUES ("r#00078558","r","explicitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00085512","r","explicitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00367418","r","explicitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00078558","r","declaradamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","aterrorizado","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","pasmo","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","espantado","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","horrorizado","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","pasmado","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","apavorado","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","chocado","N");
INSERT INTO portuguese_lemma VALUES ("a#00078576","a","chocada","N");
INSERT INTO portuguese_lemma VALUES ("v#00078578","v","ranger","N");
INSERT INTO portuguese_lemma VALUES ("v#01394464","v","ranger","N");
INSERT INTO portuguese_lemma VALUES ("n#07169157","n","ranger","N");
INSERT INTO portuguese_lemma VALUES ("a#00078705","a","agoráfobo","N");
INSERT INTO portuguese_lemma VALUES ("a#00078705","a","agorafóbico","N");
INSERT INTO portuguese_lemma VALUES ("a#00078705","a","agoráfoba","N");
INSERT INTO portuguese_lemma VALUES ("v#00054862","v","tratar","N");
INSERT INTO portuguese_lemma VALUES ("v#00699711","v","tratar","N");
INSERT INTO portuguese_lemma VALUES ("v#01659890","v","tratar","N");
INSERT INTO portuguese_lemma VALUES ("v#01660593","v","tratar","N");
INSERT INTO portuguese_lemma VALUES ("n#00047517","n","coisacomprada","N");
INSERT INTO portuguese_lemma VALUES ("a#00079069","a","apreensivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00783553","a","apreensivo","N");
INSERT INTO portuguese_lemma VALUES ("r#00079107","r","sem_dúvidas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00079107","r","indubitavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00079107","r","indubitável","N");
INSERT INTO portuguese_lemma VALUES ("r#00079107","r","indubitàvelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00079107","r","sem_dúvida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","sem_dúvida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00150134","r","sem_dúvida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00079107","r","sem_dúvida_alguma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00150134","r","sem_dúvida_alguma","Y");
INSERT INTO portuguese_lemma VALUES ("a#00079356","a","claustrofóbico","N");
INSERT INTO portuguese_lemma VALUES ("n#00047814","n","compra_e_venda","Y");
INSERT INTO portuguese_lemma VALUES ("n#00047814","n","comércio","N");
INSERT INTO portuguese_lemma VALUES ("n#00706993","n","comércio","N");
INSERT INTO portuguese_lemma VALUES ("n#01091905","n","comércio","N");
INSERT INTO portuguese_lemma VALUES ("n#01094725","n","comércio","N");
INSERT INTO portuguese_lemma VALUES ("n#00720146","n","comércio","N");
INSERT INTO portuguese_lemma VALUES ("n#08065093","n","comércio","N");
INSERT INTO portuguese_lemma VALUES ("r#00079499","r","hoje_à_noite","Y");
INSERT INTO portuguese_lemma VALUES ("r#00079499","r","esta_tarde","Y");
INSERT INTO portuguese_lemma VALUES ("r#00079499","r","esta_noite","Y");
INSERT INTO portuguese_lemma VALUES ("r#00079617","r","activamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00079617","r","ativamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00280283","r","ativamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00082641","a","assustado","N");
INSERT INTO portuguese_lemma VALUES ("r#00079748","r","de_forma_passiva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00079748","r","passivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00079866","r","embaixo","N");
INSERT INTO portuguese_lemma VALUES ("r#00079947","r","a_mais","Y");
INSERT INTO portuguese_lemma VALUES ("r#00080039","r","porbaixode","N");
INSERT INTO portuguese_lemma VALUES ("r#00080039","r","abaixode","N");
INSERT INTO portuguese_lemma VALUES ("r#00080039","r","debaixode","N");
INSERT INTO portuguese_lemma VALUES ("r#00080169","r","acima","N");
INSERT INTO portuguese_lemma VALUES ("r#00096636","r","acima","N");
INSERT INTO portuguese_lemma VALUES ("a#01155248","a","acima","N");
INSERT INTO portuguese_lemma VALUES ("n#00080242","n","Insider_trading","Y");
INSERT INTO portuguese_lemma VALUES ("r#00080534","r","desdenhosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00282700","r","desdenhosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00080768","r","contratualmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00055748","v","manipular","N");
INSERT INTO portuguese_lemma VALUES ("v#00824623","v","manipular","N");
INSERT INTO portuguese_lemma VALUES ("v#01230482","v","manipular","N");
INSERT INTO portuguese_lemma VALUES ("v#00055849","v","dispensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00055849","v","administrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01656373","v","administrar","N");
INSERT INTO portuguese_lemma VALUES ("r#00081486","r","diáriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00081486","r","diariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00177818","r","diariamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00081509","v","digitalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00563824","v","digitalizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00081513","a","xenófobo","N");
INSERT INTO portuguese_lemma VALUES ("n#00049855","n","gestão_de_compras","Y");
INSERT INTO portuguese_lemma VALUES ("r#00081591","r","semanalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00081671","a","sem_medo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00056004","v","curar","N");
INSERT INTO portuguese_lemma VALUES ("v#00056406","v","curar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184775","v","curar","N");
INSERT INTO portuguese_lemma VALUES ("v#00056004","v","sanar","N");
INSERT INTO portuguese_lemma VALUES ("v#00056004","v","sarar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184775","v","sarar","N");
INSERT INTO portuguese_lemma VALUES ("r#00081737","r","anualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00250570","r","anualmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00050044","n","procura","N");
INSERT INTO portuguese_lemma VALUES ("n#00946650","n","procura","N");
INSERT INTO portuguese_lemma VALUES ("n#00686428","n","procura","N");
INSERT INTO portuguese_lemma VALUES ("n#05770391","n","procura","N");
INSERT INTO portuguese_lemma VALUES ("n#00082081","n","marketing","N");
INSERT INTO portuguese_lemma VALUES ("n#01112420","n","marketing","N");
INSERT INTO portuguese_lemma VALUES ("n#01115162","n","marketing","N");
INSERT INTO portuguese_lemma VALUES ("v#00056138","v","socorrer","N");
INSERT INTO portuguese_lemma VALUES ("v#01737017","v","socorrer","N");
INSERT INTO portuguese_lemma VALUES ("v#01739424","v","socorrer","N");
INSERT INTO portuguese_lemma VALUES ("v#00056138","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00206998","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00803166","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#02000133","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#01643863","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#01732330","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#01737017","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#01739424","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#01742587","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("v#01872462","v","ajudar","N");
INSERT INTO portuguese_lemma VALUES ("a#00085200","a","agressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00107565","a","agressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00085707","a","agressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01193636","a","agressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01301600","a","agressivo","N");
INSERT INTO portuguese_lemma VALUES ("r#00082308","r","aí","N");
INSERT INTO portuguese_lemma VALUES ("r#00082308","r","ali","N");
INSERT INTO portuguese_lemma VALUES ("r#00109151","r","ali","N");
INSERT INTO portuguese_lemma VALUES ("r#00082308","r","lá","N");
INSERT INTO portuguese_lemma VALUES ("n#05139941","n","lá","N");
INSERT INTO portuguese_lemma VALUES ("r#00082308","r","acolá","N");
INSERT INTO portuguese_lemma VALUES ("r#00109151","r","acolá","N");
INSERT INTO portuguese_lemma VALUES ("r#00082308","r","além","N");
INSERT INTO portuguese_lemma VALUES ("n#15143864","n","além","N");
INSERT INTO portuguese_lemma VALUES ("n#00050643","n","aceitação","N");
INSERT INTO portuguese_lemma VALUES ("n#00117820","n","aceitação","N");
INSERT INTO portuguese_lemma VALUES ("n#04696956","n","aceitação","N");
INSERT INTO portuguese_lemma VALUES ("n#10039397","n","aceitação","N");
INSERT INTO portuguese_lemma VALUES ("n#10341904","n","aceitação","N");
INSERT INTO portuguese_lemma VALUES ("v#00056406","v","remediar","N");
INSERT INTO portuguese_lemma VALUES ("v#00613501","v","remediar","N");
INSERT INTO portuguese_lemma VALUES ("n#00050836","n","sucessão","N");
INSERT INTO portuguese_lemma VALUES ("n#00651987","n","sucessão","N");
INSERT INTO portuguese_lemma VALUES ("n#03938674","n","sucessão","N");
INSERT INTO portuguese_lemma VALUES ("n#06248029","n","sucessão","N");
INSERT INTO portuguese_lemma VALUES ("n#09755313","n","sucessão","N");
INSERT INTO portuguese_lemma VALUES ("a#00085894","a","belicoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01518860","a","belicoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01680772","a","belicoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00050952","n","assunção","N");
INSERT INTO portuguese_lemma VALUES ("a#00083003","a","competitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00297755","a","competitivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00083124","v","enfaixar","N");
INSERT INTO portuguese_lemma VALUES ("r#00083541","r","única","N");
INSERT INTO portuguese_lemma VALUES ("a#02112131","a","única","N");
INSERT INTO portuguese_lemma VALUES ("r#00083541","r","umaum","N");
INSERT INTO portuguese_lemma VALUES ("n#00051119","n","espólio","N");
INSERT INTO portuguese_lemma VALUES ("n#09543577","n","espólio","N");
INSERT INTO portuguese_lemma VALUES ("n#00051119","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("v#02315525","v","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#03850874","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#04921011","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#03852131","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#09534283","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#09543723","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#13263779","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#09698925","n","herança","N");
INSERT INTO portuguese_lemma VALUES ("n#00051225","n","aprovisionamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00051225","n","compras","N");
INSERT INTO portuguese_lemma VALUES ("n#00051225","n","suprimentos","N");
INSERT INTO portuguese_lemma VALUES ("v#00057137","v","operar","N");
INSERT INTO portuguese_lemma VALUES ("v#00834531","v","operar","N");
INSERT INTO portuguese_lemma VALUES ("v#01048914","v","operar","N");
INSERT INTO portuguese_lemma VALUES ("v#01664787","v","operar","N");
INSERT INTO portuguese_lemma VALUES ("n#00083975","n","apropriação","N");
INSERT INTO portuguese_lemma VALUES ("n#00084895","n","apropriação","N");
INSERT INTO portuguese_lemma VALUES ("n#00776732","n","apropriação","N");
INSERT INTO portuguese_lemma VALUES ("r#00084223","r","particularmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00084230","v","medicar","N");
INSERT INTO portuguese_lemma VALUES ("n#00051562","n","adopção","N");
INSERT INTO portuguese_lemma VALUES ("n#00117820","n","adopção","N");
INSERT INTO portuguese_lemma VALUES ("n#00051562","n","adoção","N");
INSERT INTO portuguese_lemma VALUES ("n#00117820","n","adoção","N");
INSERT INTO portuguese_lemma VALUES ("n#01185292","n","adoção","N");
INSERT INTO portuguese_lemma VALUES ("n#00084642","n","naturalização","N");
INSERT INTO portuguese_lemma VALUES ("v#00057616","v","estupefazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00057616","v","narcotizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00084795","a","truculento","N");
INSERT INTO portuguese_lemma VALUES ("a#00084795","a","batalhador","N");
INSERT INTO portuguese_lemma VALUES ("a#00084795","a","lutador","N");
INSERT INTO portuguese_lemma VALUES ("n#07167829","n","lutador","N");
INSERT INTO portuguese_lemma VALUES ("n#10793168","n","lutador","N");
INSERT INTO portuguese_lemma VALUES ("r#00085002","r","alhures","N");
INSERT INTO portuguese_lemma VALUES ("r#00235438","r","alhures","N");
INSERT INTO portuguese_lemma VALUES ("r#00085002","r","em_outro_lugar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00085002","r","em_outra_parte","Y");
INSERT INTO portuguese_lemma VALUES ("n#00085041","n","Preemptividade","N");
INSERT INTO portuguese_lemma VALUES ("n#00085041","n","preempção","N");
INSERT INTO portuguese_lemma VALUES ("n#05178394","n","preempção","N");
INSERT INTO portuguese_lemma VALUES ("n#05178571","n","preempção","N");
INSERT INTO portuguese_lemma VALUES ("n#05957238","n","preempção","N");
INSERT INTO portuguese_lemma VALUES ("n#00051907","n","confiscação","N");
INSERT INTO portuguese_lemma VALUES ("n#00088481","n","confiscação","N");
INSERT INTO portuguese_lemma VALUES ("a#00087965","a","inquieto","N");
INSERT INTO portuguese_lemma VALUES ("a#01855798","a","inquieto","N");
INSERT INTO portuguese_lemma VALUES ("a#02337269","a","inquieto","N");
INSERT INTO portuguese_lemma VALUES ("r#00085339","r","de_forma_experimental","Y");
INSERT INTO portuguese_lemma VALUES ("v#00085626","v","ungir","N");
INSERT INTO portuguese_lemma VALUES ("v#00085626","v","untar","N");
INSERT INTO portuguese_lemma VALUES ("v#01269379","v","untar","N");
INSERT INTO portuguese_lemma VALUES ("a#00085630","a","emocional","N");
INSERT INTO portuguese_lemma VALUES ("a#00853776","a","emocional","N");
INSERT INTO portuguese_lemma VALUES ("a#01927279","a","emocional","N");
INSERT INTO portuguese_lemma VALUES ("a#02747446","a","emocional","N");
INSERT INTO portuguese_lemma VALUES ("a#00085630","a","excitado","N");
INSERT INTO portuguese_lemma VALUES ("a#00919542","a","excitado","N");
INSERT INTO portuguese_lemma VALUES ("a#02056997","a","excitado","N");
INSERT INTO portuguese_lemma VALUES ("n#00085678","n","Confiscação","N");
INSERT INTO portuguese_lemma VALUES ("r#00085811","r","rapidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00085811","r","rápidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00085811","r","vapt_vupt","Y");
INSERT INTO portuguese_lemma VALUES ("a#00085870","a","transtornado","N");
INSERT INTO portuguese_lemma VALUES ("a#00085870","a","perturbado","N");
INSERT INTO portuguese_lemma VALUES ("a#02458262","a","perturbado","N");
INSERT INTO portuguese_lemma VALUES ("n#00086140","n","expropriação","N");
INSERT INTO portuguese_lemma VALUES ("a#00086210","a","agitado","N");
INSERT INTO portuguese_lemma VALUES ("a#00086210","a","frenético","N");
INSERT INTO portuguese_lemma VALUES ("a#00086341","a","frenético","N");
INSERT INTO portuguese_lemma VALUES ("a#02390724","a","frenético","N");
INSERT INTO portuguese_lemma VALUES ("a#02544892","a","frenético","N");
INSERT INTO portuguese_lemma VALUES ("a#00086210","a","febril","N");
INSERT INTO portuguese_lemma VALUES ("a#02726715","a","febril","N");
INSERT INTO portuguese_lemma VALUES ("v#00058757","v","injectar","N");
INSERT INTO portuguese_lemma VALUES ("v#00058757","v","injetar","N");
INSERT INTO portuguese_lemma VALUES ("v#01195201","v","injetar","N");
INSERT INTO portuguese_lemma VALUES ("v#01199213","v","injetar","N");
INSERT INTO portuguese_lemma VALUES ("r#00086528","r","mais_rápido","Y");
INSERT INTO portuguese_lemma VALUES ("r#00086528","r","mais_depressa","Y");
INSERT INTO portuguese_lemma VALUES ("a#00086606","a","histérico","N");
INSERT INTO portuguese_lemma VALUES ("a#01584287","a","histérico","N");
INSERT INTO portuguese_lemma VALUES ("r#00086621","r","mais_devagar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00086621","r","mais_lento","Y");
INSERT INTO portuguese_lemma VALUES ("n#00086654","n","imprima","N");
INSERT INTO portuguese_lemma VALUES ("n#00086654","n","requisação","N");
INSERT INTO portuguese_lemma VALUES ("r#00086685","r","o_mais_veloz","Y");
INSERT INTO portuguese_lemma VALUES ("r#00086685","r","o_mais_rápido","Y");
INSERT INTO portuguese_lemma VALUES ("a#00089566","a","psicadélico","N");
INSERT INTO portuguese_lemma VALUES ("a#00376227","a","psicadélico","N");
INSERT INTO portuguese_lemma VALUES ("a#01777822","a","psicadélico","N");
INSERT INTO portuguese_lemma VALUES ("v#00086835","v","vacinar","N");
INSERT INTO portuguese_lemma VALUES ("r#00087188","r","categoricamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00087188","r","rotundamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00181901","r","rotundamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00228815","r","rotundamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00087218","n","Sequestro_de_bens","Y");
INSERT INTO portuguese_lemma VALUES ("n#00087218","n","sequestro","N");
INSERT INTO portuguese_lemma VALUES ("n#00775702","n","sequestro","N");
INSERT INTO portuguese_lemma VALUES ("n#00087218","n","Seqüestro_de_bens","Y");
INSERT INTO portuguese_lemma VALUES ("v#00087454","v","adoentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00087454","v","adoecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00059435","v","contagiar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00087777","r","sem_fim","Y");
INSERT INTO portuguese_lemma VALUES ("r#00087777","r","ad_infinitum","Y");
INSERT INTO portuguese_lemma VALUES ("n#00087849","n","dependência_psicológica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00087916","r","permanentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00087916","r","em_definitivo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00087916","r","para_sempre","Y");
INSERT INTO portuguese_lemma VALUES ("r#00332596","r","para_sempre","Y");
INSERT INTO portuguese_lemma VALUES ("r#00087916","r","de_uma_vez_por_todas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00092985","r","de_uma_vez_por_todas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00088303","r","temporariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179212","r","temporariamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00088339","v","envenenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00151672","v","envenenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00532429","v","envenenar","N");
INSERT INTO portuguese_lemma VALUES ("v#01323338","v","envenenar","N");
INSERT INTO portuguese_lemma VALUES ("v#01323793","v","envenenar","N");
INSERT INTO portuguese_lemma VALUES ("v#01210676","v","envenenar","N");
INSERT INTO portuguese_lemma VALUES ("v#02580678","v","envenenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00088532","v","embriagar","N");
INSERT INTO portuguese_lemma VALUES ("v#00088532","v","intoxicar","N");
INSERT INTO portuguese_lemma VALUES ("v#01323338","v","intoxicar","N");
INSERT INTO portuguese_lemma VALUES ("v#01236227","v","intoxicar","N");
INSERT INTO portuguese_lemma VALUES ("r#00088655","r","a_vontade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00088655","r","de_improviso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00088655","r","à_vontade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00153372","r","à_vontade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00088655","r","espontaneamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00191889","r","espontaneamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00060266","v","infetar","N");
INSERT INTO portuguese_lemma VALUES ("v#00060266","v","infectar","N");
INSERT INTO portuguese_lemma VALUES ("v#00060850","v","infectar","N");
INSERT INTO portuguese_lemma VALUES ("v#00605498","v","infectar","N");
INSERT INTO portuguese_lemma VALUES ("v#00060266","v","contaminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00343123","v","contaminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00343478","v","contaminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01055474","v","contaminar","N");
INSERT INTO portuguese_lemma VALUES ("n#00054269","n","arresto","N");
INSERT INTO portuguese_lemma VALUES ("r#00088777","r","provisionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#01735813","a","agradável","N");
INSERT INTO portuguese_lemma VALUES ("a#01728957","a","agradável","N");
INSERT INTO portuguese_lemma VALUES ("a#01944086","a","agradável","N");
INSERT INTO portuguese_lemma VALUES ("r#00089267","r","altamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00089408","r","altamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00089643","r","altamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00089324","v","desinfectar","N");
INSERT INTO portuguese_lemma VALUES ("n#00089351","n","restituição","N");
INSERT INTO portuguese_lemma VALUES ("n#00270275","n","restituição","N");
INSERT INTO portuguese_lemma VALUES ("n#00401459","n","restituição","N");
INSERT INTO portuguese_lemma VALUES ("r#00089408","r","muitíssimo","N");
INSERT INTO portuguese_lemma VALUES ("r#00196540","r","muitíssimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00092842","a","chateante","N");
INSERT INTO portuguese_lemma VALUES ("a#00092842","a","molestante","N");
INSERT INTO portuguese_lemma VALUES ("a#00092842","a","irritativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00092842","a","aborrecedor","N");
INSERT INTO portuguese_lemma VALUES ("a#00092842","a","irritante","N");
INSERT INTO portuguese_lemma VALUES ("a#00446347","a","irritante","N");
INSERT INTO portuguese_lemma VALUES ("a#02310185","a","irritante","N");
INSERT INTO portuguese_lemma VALUES ("v#00060850","v","encomendar","N");
INSERT INTO portuguese_lemma VALUES ("v#00505537","v","encomendar","N");
INSERT INTO portuguese_lemma VALUES ("v#00060850","v","contagiar","N");
INSERT INTO portuguese_lemma VALUES ("n#00090076","n","execução_hipotecária","Y");
INSERT INTO portuguese_lemma VALUES ("r#00090228","r","perigosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00090228","r","arriscadamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00055481","n","recebimento","N");
INSERT INTO portuguese_lemma VALUES ("n#06630852","n","recebimento","N");
INSERT INTO portuguese_lemma VALUES ("r#00090651","r","de_forma_enérgica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00090651","r","energicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00090888","v","mutilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00201342","v","mutilar","N");
INSERT INTO portuguese_lemma VALUES ("r#00091259","r","de_má_vontade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00091259","r","relutantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00092047","r","duramente","N");
INSERT INTO portuguese_lemma VALUES ("v#00062377","v","degradar","N");
INSERT INTO portuguese_lemma VALUES ("v#00207728","v","degradar","N");
INSERT INTO portuguese_lemma VALUES ("v#00062377","v","degenerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00062377","v","piorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00139555","v","piorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00139972","v","piorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00140259","v","piorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00142648","v","piorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00182841","v","piorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00062377","v","deteriorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00208497","v","deteriorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00176836","v","deteriorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00179295","v","deteriorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00332972","v","deteriorar","N");
INSERT INTO portuguese_lemma VALUES ("n#00092366","n","arrematação","N");
INSERT INTO portuguese_lemma VALUES ("n#00092366","n","leilão","N");
INSERT INTO portuguese_lemma VALUES ("n#00092366","n","almoeda","N");
INSERT INTO portuguese_lemma VALUES ("n#00092366","n","hasta","N");
INSERT INTO portuguese_lemma VALUES ("a#00092391","a","insone","N");
INSERT INTO portuguese_lemma VALUES ("a#00187176","a","insone","N");
INSERT INTO portuguese_lemma VALUES ("r#00092569","r","estreitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00300137","r","estreitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00092682","r","resumidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00289860","r","resumidamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00062604","v","convalescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00062604","v","recuperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00369166","v","recuperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01538351","v","recuperar","N");
INSERT INTO portuguese_lemma VALUES ("v#01539506","v","recuperar","N");
INSERT INTO portuguese_lemma VALUES ("a#00092848","a","recursivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00092933","a","heurístico","N");
INSERT INTO portuguese_lemma VALUES ("r#00092985","r","conclusivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00092985","r","de_forma_conclusiva","Y");
INSERT INTO portuguese_lemma VALUES ("n#00093006","n","capitalização","N");
INSERT INTO portuguese_lemma VALUES ("n#00951626","n","capitalização","N");
INSERT INTO portuguese_lemma VALUES ("n#00952214","n","capitalização","N");
INSERT INTO portuguese_lemma VALUES ("r#00093270","r","deploravelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00093275","a","alienável","N");
INSERT INTO portuguese_lemma VALUES ("n#00058512","n","salvamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00058512","n","salvação","N");
INSERT INTO portuguese_lemma VALUES ("n#00058978","n","salvação","N");
INSERT INTO portuguese_lemma VALUES ("n#00096513","n","salvação","N");
INSERT INTO portuguese_lemma VALUES ("n#14539165","n","salvação","N");
INSERT INTO portuguese_lemma VALUES ("v#00093593","v","enlanguescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00389992","v","enlanguescer","N");
INSERT INTO portuguese_lemma VALUES ("r#00093731","r","focalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00093810","a","inalienável","N");
INSERT INTO portuguese_lemma VALUES ("a#00694483","a","inalienável","N");
INSERT INTO portuguese_lemma VALUES ("v#00093979","v","atrofiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00093979","v","causar_atrofia","Y");
INSERT INTO portuguese_lemma VALUES ("v#00093979","v","atrofiar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00058978","n","redenção","N");
INSERT INTO portuguese_lemma VALUES ("v#00094153","v","hipertrofiar","N");
INSERT INTO portuguese_lemma VALUES ("n#00094240","n","absolvição","N");
INSERT INTO portuguese_lemma VALUES ("n#00095121","n","absolvição","N");
INSERT INTO portuguese_lemma VALUES ("a#00094324","a","intransmissível","N");
INSERT INTO portuguese_lemma VALUES ("a#00102211","a","vivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00121842","a","vivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00190653","a","vivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00804371","a","vivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00805115","a","vivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01872306","a","vivo","N");
INSERT INTO portuguese_lemma VALUES ("a#02106366","a","vivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00063646","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00077064","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00083639","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00250539","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00234840","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00235191","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00236065","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00238795","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00239152","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00379987","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00723349","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01520476","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01768893","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01791776","v","acontecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00094500","n","indulgência","N");
INSERT INTO portuguese_lemma VALUES ("n#01073241","n","indulgência","N");
INSERT INTO portuguese_lemma VALUES ("n#04638585","n","indulgência","N");
INSERT INTO portuguese_lemma VALUES ("n#04884627","n","indulgência","N");
INSERT INTO portuguese_lemma VALUES ("a#00098270","a","viável","N");
INSERT INTO portuguese_lemma VALUES ("a#01752028","a","viável","N");
INSERT INTO portuguese_lemma VALUES ("a#00098405","a","vital","N");
INSERT INTO portuguese_lemma VALUES ("a#00122245","a","vital","N");
INSERT INTO portuguese_lemma VALUES ("a#00098580","a","morto","N");
INSERT INTO portuguese_lemma VALUES ("a#00099137","a","morto","N");
INSERT INTO portuguese_lemma VALUES ("n#04056323","n","morto","N");
INSERT INTO portuguese_lemma VALUES ("a#00098580","a","semvida","N");
INSERT INTO portuguese_lemma VALUES ("r#00095320","r","para_baixo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00095320","r","juso","N");
INSERT INTO portuguese_lemma VALUES ("r#00095320","r","de_forma_descendente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00095320","r","abaixo","N");
INSERT INTO portuguese_lemma VALUES ("r#00486067","r","abaixo","N");
INSERT INTO portuguese_lemma VALUES ("r#00487408","r","abaixo","N");
INSERT INTO portuguese_lemma VALUES ("a#02491961","a","abaixo","N");
INSERT INTO portuguese_lemma VALUES ("n#00060117","n","emancipação","N");
INSERT INTO portuguese_lemma VALUES ("n#01247413","n","emancipação","N");
INSERT INTO portuguese_lemma VALUES ("v#00095747","v","folhear","N");
INSERT INTO portuguese_lemma VALUES ("v#01269224","v","folhear","N");
INSERT INTO portuguese_lemma VALUES ("a#00099137","a","falecido","N");
INSERT INTO portuguese_lemma VALUES ("n#07203851","n","falecido","N");
INSERT INTO portuguese_lemma VALUES ("a#00096072","a","assassinado","N");
INSERT INTO portuguese_lemma VALUES ("n#00060540","n","resgate","N");
INSERT INTO portuguese_lemma VALUES ("n#00061001","n","resgate","N");
INSERT INTO portuguese_lemma VALUES ("n#09560583","n","resgate","N");
INSERT INTO portuguese_lemma VALUES ("r#00096333","r","de_forma_ascendente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00096636","r","para_cima","Y");
INSERT INTO portuguese_lemma VALUES ("r#00490410","r","para_cima","Y");
INSERT INTO portuguese_lemma VALUES ("r#00490498","r","para_cima","Y");
INSERT INTO portuguese_lemma VALUES ("v#00065214","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("r#00097011","r","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00104604","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00105400","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00105798","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00154966","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01421708","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00106728","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00107371","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00108242","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00108348","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00108725","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00108988","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00227165","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00158081","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00164255","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00263904","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00180494","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00290302","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00214843","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00219109","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00301091","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00301246","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00434077","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00346551","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00540946","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00388763","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00574735","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00569024","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01345133","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01351334","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01421865","v","aumentar","N");
INSERT INTO portuguese_lemma VALUES ("n#00061101","n","reconquista","N");
INSERT INTO portuguese_lemma VALUES ("r#00097011","r","elevar","N");
INSERT INTO portuguese_lemma VALUES ("v#00108988","v","elevar","N");
INSERT INTO portuguese_lemma VALUES ("v#00380903","v","elevar","N");
INSERT INTO portuguese_lemma VALUES ("v#00641929","v","elevar","N");
INSERT INTO portuguese_lemma VALUES ("v#01343923","v","elevar","N");
INSERT INTO portuguese_lemma VALUES ("v#00097179","v","supurar","N");
INSERT INTO portuguese_lemma VALUES ("n#00097244","n","invocação","N");
INSERT INTO portuguese_lemma VALUES ("n#00061811","n","desempenho","N");
INSERT INTO portuguese_lemma VALUES ("r#00097522","r","francamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00097620","r","francamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00314835","r","francamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00097621","v","regenerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00097941","v","regenerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00114858","v","regenerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167824","v","regenerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00168393","v","regenerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00168588","v","regenerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00385189","v","regenerar","N");
INSERT INTO portuguese_lemma VALUES ("a#00097768","a","sem_vida","Y");
INSERT INTO portuguese_lemma VALUES ("a#00100373","a","sem_vida","Y");
INSERT INTO portuguese_lemma VALUES ("a#00122649","a","sem_vida","Y");
INSERT INTO portuguese_lemma VALUES ("a#01087557","a","sem_vida","Y");
INSERT INTO portuguese_lemma VALUES ("a#00098043","a","inviável","N");
INSERT INTO portuguese_lemma VALUES ("a#01836350","a","inviável","N");
INSERT INTO portuguese_lemma VALUES ("r#00098166","r","em_casa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00098267","r","em_casa","Y");
INSERT INTO portuguese_lemma VALUES ("a#00098307","a","natimorto","N");
INSERT INTO portuguese_lemma VALUES ("v#00098346","v","iniciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00239960","v","iniciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00242403","v","iniciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00964911","v","iniciar","N");
INSERT INTO portuguese_lemma VALUES ("v#01133757","v","iniciar","N");
INSERT INTO portuguese_lemma VALUES ("v#01778989","v","iniciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00098346","v","inicializar","N");
INSERT INTO portuguese_lemma VALUES ("v#00700896","v","inicializar","N");
INSERT INTO portuguese_lemma VALUES ("n#00062253","n","mecanica","N");
INSERT INTO portuguese_lemma VALUES ("n#00062253","n","mecanismo","N");
INSERT INTO portuguese_lemma VALUES ("n#02560468","n","mecanismo","N");
INSERT INTO portuguese_lemma VALUES ("n#02979815","n","mecanismo","N");
INSERT INTO portuguese_lemma VALUES ("n#06757099","n","mecanismo","N");
INSERT INTO portuguese_lemma VALUES ("n#09682313","n","mecanismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00098450","a","pedra-inoperante","N");
INSERT INTO portuguese_lemma VALUES ("v#00066831","v","ressuscitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00098770","v","ressuscitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00062420","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00371920","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00379388","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00384296","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00461778","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00666638","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#01032368","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00784280","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#02661119","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#03303697","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#06084772","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#09593730","n","serviço","N");
INSERT INTO portuguese_lemma VALUES ("a#00098933","a","artesiano","N");
INSERT INTO portuguese_lemma VALUES ("n#00099439","n","bis","N");
INSERT INTO portuguese_lemma VALUES ("n#00099588","n","Improvisação","N");
INSERT INTO portuguese_lemma VALUES ("v#00067743","v","exercitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01180029","v","exercitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00067743","v","malhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00068375","v","malhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00820086","v","malhar","N");
INSERT INTO portuguese_lemma VALUES ("n#00099799","n","malabarismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00338994","n","malabarismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00063210","n","ilusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00486766","n","ilusão","N");
INSERT INTO portuguese_lemma VALUES ("n#04531761","n","ilusão","N");
INSERT INTO portuguese_lemma VALUES ("n#04561043","n","ilusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00063210","n","truque","N");
INSERT INTO portuguese_lemma VALUES ("n#00111216","n","truque","N");
INSERT INTO portuguese_lemma VALUES ("n#00172598","n","truque","N");
INSERT INTO portuguese_lemma VALUES ("n#00063210","n","magia","N");
INSERT INTO portuguese_lemma VALUES ("n#04578926","n","magia","N");
INSERT INTO portuguese_lemma VALUES ("v#00067976","v","treinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00068375","v","treinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00602805","v","treinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00407541","v","treinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00565367","v","treinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01804414","v","treinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00063574","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("n#00358063","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("n#00359430","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("n#04447241","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("n#04551850","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("n#04787112","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("n#05157992","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("n#05361340","n","interpretação","N");
INSERT INTO portuguese_lemma VALUES ("v#00068375","v","exercitar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01180029","v","exercitar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00100634","a","alfabético","N");
INSERT INTO portuguese_lemma VALUES ("a#02614194","a","alfabético","N");
INSERT INTO portuguese_lemma VALUES ("a#00100634","a","alfabeto","N");
INSERT INTO portuguese_lemma VALUES ("a#02614194","a","alfabeto","N");
INSERT INTO portuguese_lemma VALUES ("n#04876596","n","alfabeto","N");
INSERT INTO portuguese_lemma VALUES ("r#00100883","r","longe","N");
INSERT INTO portuguese_lemma VALUES ("a#00410709","a","longe","N");
INSERT INTO portuguese_lemma VALUES ("a#00450915","a","longe","N");
INSERT INTO portuguese_lemma VALUES ("r#00100883","r","de_longe","Y");
INSERT INTO portuguese_lemma VALUES ("r#00440745","r","de_longe","Y");
INSERT INTO portuguese_lemma VALUES ("r#00440845","r","de_longe","Y");
INSERT INTO portuguese_lemma VALUES ("a#00101609","a","altruísta","N");
INSERT INTO portuguese_lemma VALUES ("n#10421956","n","altruísta","N");
INSERT INTO portuguese_lemma VALUES ("a#00101609","a","humanitário","N");
INSERT INTO portuguese_lemma VALUES ("a#01210344","a","humanitário","N");
INSERT INTO portuguese_lemma VALUES ("a#01211005","a","humanitário","N");
INSERT INTO portuguese_lemma VALUES ("a#02755563","a","humanitário","N");
INSERT INTO portuguese_lemma VALUES ("v#00101629","v","peidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00101779","v","fungar","N");
INSERT INTO portuguese_lemma VALUES ("a#00101800","a","egocêntrico","N");
INSERT INTO portuguese_lemma VALUES ("n#00102162","n","Transposição","N");
INSERT INTO portuguese_lemma VALUES ("a#00105604","a","impreciso","N");
INSERT INTO portuguese_lemma VALUES ("a#01767638","a","impreciso","N");
INSERT INTO portuguese_lemma VALUES ("a#00105604","a","ambíguo","N");
INSERT INTO portuguese_lemma VALUES ("a#00851170","a","ambíguo","N");
INSERT INTO portuguese_lemma VALUES ("a#00105604","a","vago","N");
INSERT INTO portuguese_lemma VALUES ("a#00400770","a","vago","N");
INSERT INTO portuguese_lemma VALUES ("a#01036561","a","vago","N");
INSERT INTO portuguese_lemma VALUES ("a#00105604","a","dúbio","N");
INSERT INTO portuguese_lemma VALUES ("a#00851170","a","dúbio","N");
INSERT INTO portuguese_lemma VALUES ("a#00105604","a","indefinido","N");
INSERT INTO portuguese_lemma VALUES ("a#00328009","a","indefinido","N");
INSERT INTO portuguese_lemma VALUES ("n#00102374","n","jam","N");
INSERT INTO portuguese_lemma VALUES ("n#00064182","n","automatização","N");
INSERT INTO portuguese_lemma VALUES ("n#00064182","n","automação","N");
INSERT INTO portuguese_lemma VALUES ("n#00064182","n","Automaçao","N");
INSERT INTO portuguese_lemma VALUES ("v#00069684","v","danificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00176836","v","danificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00259755","v","danificar","N");
INSERT INTO portuguese_lemma VALUES ("r#00102736","r","em_primeiro_lugar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00102736","r","antes_de_tudo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00102736","r","ao_princípio","Y");
INSERT INTO portuguese_lemma VALUES ("r#00102736","r","primeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00958735","a","primeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00960836","a","primeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#09770029","n","primeiro","N");
INSERT INTO portuguese_lemma VALUES ("v#00102791","v","salivar","N");
INSERT INTO portuguese_lemma VALUES ("a#00102930","a","enigmático","N");
INSERT INTO portuguese_lemma VALUES ("a#00499987","a","enigmático","N");
INSERT INTO portuguese_lemma VALUES ("a#00855484","a","enigmático","N");
INSERT INTO portuguese_lemma VALUES ("v#00102974","v","babar","N");
INSERT INTO portuguese_lemma VALUES ("v#01827425","v","babar","N");
INSERT INTO portuguese_lemma VALUES ("r#00103087","r","durante","N");
INSERT INTO portuguese_lemma VALUES ("n#00064905","n","lancha","N");
INSERT INTO portuguese_lemma VALUES ("n#00064905","n","lançamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00066170","n","lançamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00155548","n","lançamento","N");
INSERT INTO portuguese_lemma VALUES ("r#00103194","r","de_início","Y");
INSERT INTO portuguese_lemma VALUES ("r#00103194","r","primeiramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00103194","r","inicialmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00070161","v","avermelhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00198875","v","avermelhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00373451","v","avermelhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00070161","v","corar","N");
INSERT INTO portuguese_lemma VALUES ("v#00280301","v","corar","N");
INSERT INTO portuguese_lemma VALUES ("v#00070161","v","enrubescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00070161","v","ruborizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00103447","a","ter_muitos_significados","Y");
INSERT INTO portuguese_lemma VALUES ("r#00103554","r","pela_primeira_vez","Y");
INSERT INTO portuguese_lemma VALUES ("v#00103619","v","empalidecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00103619","v","clarear","N");
INSERT INTO portuguese_lemma VALUES ("v#00216484","v","clarear","N");
INSERT INTO portuguese_lemma VALUES ("v#00384451","v","clarear","N");
INSERT INTO portuguese_lemma VALUES ("v#02764122","v","clarear","N");
INSERT INTO portuguese_lemma VALUES ("v#01893399","v","clarear","N");
INSERT INTO portuguese_lemma VALUES ("r#00103664","r","etc","N");
INSERT INTO portuguese_lemma VALUES ("r#00103664","r","etc.","N");
INSERT INTO portuguese_lemma VALUES ("r#00103664","r","etcetera","N");
INSERT INTO portuguese_lemma VALUES ("r#00103664","r","etcétera","N");
INSERT INTO portuguese_lemma VALUES ("a#00103696","a","não_ambíguo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00065545","n","empurrão","N");
INSERT INTO portuguese_lemma VALUES ("n#00112312","n","empurrão","N");
INSERT INTO portuguese_lemma VALUES ("n#00182673","n","empurrão","N");
INSERT INTO portuguese_lemma VALUES ("n#00065545","n","forca","N");
INSERT INTO portuguese_lemma VALUES ("n#01164874","n","forca","N");
INSERT INTO portuguese_lemma VALUES ("n#03412906","n","forca","N");
INSERT INTO portuguese_lemma VALUES ("n#03044012","n","forca","N");
INSERT INTO portuguese_lemma VALUES ("n#00065545","n","impulso","N");
INSERT INTO portuguese_lemma VALUES ("n#00065905","n","impulso","N");
INSERT INTO portuguese_lemma VALUES ("n#00112312","n","impulso","N");
INSERT INTO portuguese_lemma VALUES ("n#01174251","n","impulso","N");
INSERT INTO portuguese_lemma VALUES ("n#03932233","n","impulso","N");
INSERT INTO portuguese_lemma VALUES ("v#00070485","v","bronzear","N");
INSERT INTO portuguese_lemma VALUES ("v#00222387","v","bronzear","N");
INSERT INTO portuguese_lemma VALUES ("r#00104003","r","de_fora","Y");
INSERT INTO portuguese_lemma VALUES ("r#00104003","r","além-mar","N");
INSERT INTO portuguese_lemma VALUES ("r#00104003","r","ao","N");
INSERT INTO portuguese_lemma VALUES ("r#00104003","r","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00983540","a","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00984080","a","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00986373","a","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#08168367","n","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#07273101","n","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#07273655","n","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#07614356","n","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#10661216","n","estrangeiro","N");
INSERT INTO portuguese_lemma VALUES ("r#00104003","r","exterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00900690","a","exterior","N");
INSERT INTO portuguese_lemma VALUES ("r#00104003","r","no","N");
INSERT INTO portuguese_lemma VALUES ("r#00167575","r","no","N");
INSERT INTO portuguese_lemma VALUES ("r#00104003","r","ultramar","N");
INSERT INTO portuguese_lemma VALUES ("a#01381473","a","ultramar","N");
INSERT INTO portuguese_lemma VALUES ("a#00107334","a","ambicioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00711113","a","ambicioso","N");
INSERT INTO portuguese_lemma VALUES ("n#00104088","n","firewall","N");
INSERT INTO portuguese_lemma VALUES ("n#03348142","n","firewall","N");
INSERT INTO portuguese_lemma VALUES ("n#00104088","n","parede_à_prova_de_fogo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00104147","v","expor_ao_sol","Y");
INSERT INTO portuguese_lemma VALUES ("n#00065905","n","ímpeto","N");
INSERT INTO portuguese_lemma VALUES ("n#00065905","n","arranco","N");
INSERT INTO portuguese_lemma VALUES ("r#00104345","r","ao_menos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00104345","r","no_mínimo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00104345","r","pelo_menos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00104409","n","rolamento","N");
INSERT INTO portuguese_lemma VALUES ("n#02780315","n","rolamento","N");
INSERT INTO portuguese_lemma VALUES ("r#00104528","r","no_máximo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00105775","r","no_máximo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00066170","n","arremesso","N");
INSERT INTO portuguese_lemma VALUES ("n#00106272","n","arremesso","N");
INSERT INTO portuguese_lemma VALUES ("a#00107954","a","compulsivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01583659","a","compulsivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01585022","a","compulsivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00071198","v","liberar","N");
INSERT INTO portuguese_lemma VALUES ("v#01011620","v","liberar","N");
INSERT INTO portuguese_lemma VALUES ("v#01648022","v","liberar","N");
INSERT INTO portuguese_lemma VALUES ("v#01648347","v","liberar","N");
INSERT INTO portuguese_lemma VALUES ("v#02467399","v","liberar","N");
INSERT INTO portuguese_lemma VALUES ("v#01701277","v","liberar","N");
INSERT INTO portuguese_lemma VALUES ("v#00071198","v","ejetar","N");
INSERT INTO portuguese_lemma VALUES ("v#01007120","v","ejetar","N");
INSERT INTO portuguese_lemma VALUES ("v#00071198","v","expulsar","N");
INSERT INTO portuguese_lemma VALUES ("v#01636409","v","expulsar","N");
INSERT INTO portuguese_lemma VALUES ("v#02499312","v","expulsar","N");
INSERT INTO portuguese_lemma VALUES ("v#01704959","v","expulsar","N");
INSERT INTO portuguese_lemma VALUES ("v#02503803","v","expulsar","N");
INSERT INTO portuguese_lemma VALUES ("v#02504280","v","expulsar","N");
INSERT INTO portuguese_lemma VALUES ("r#00104990","r","Calmamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00105341","r","prontamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00105467","r","prontamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00105603","r","prontamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00161193","r","prontamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00105467","r","sem_demora","Y");
INSERT INTO portuguese_lemma VALUES ("a#01900630","a","sem_demora","Y");
INSERT INTO portuguese_lemma VALUES ("v#00071715","v","caçoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00578703","v","caçoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00580082","v","caçoar","N");
INSERT INTO portuguese_lemma VALUES ("n#00105624","n","mais_fino","Y");
INSERT INTO portuguese_lemma VALUES ("n#00105624","n","mais_magro","Y");
INSERT INTO portuguese_lemma VALUES ("r#00105775","r","no_seu_melhor","Y");
INSERT INTO portuguese_lemma VALUES ("n#00066813","n","lance","N");
INSERT INTO portuguese_lemma VALUES ("a#00109022","a","desapegado","N");
INSERT INTO portuguese_lemma VALUES ("a#00109022","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#00281123","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#00542311","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#00869389","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#01062627","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#01062993","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#01065548","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#01958902","a","liberal","N");
INSERT INTO portuguese_lemma VALUES ("n#10257084","n","liberal","N");
INSERT INTO portuguese_lemma VALUES ("a#00109022","a","generoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01028190","a","generoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01062993","a","generoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01114658","a","generoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00106316","r","unanimemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106316","r","unanimimente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106316","r","de_forma_unânime","Y");
INSERT INTO portuguese_lemma VALUES ("r#00106921","r","ordinariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106921","r","geralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00155621","r","geralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106921","r","usualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106921","r","habitualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00211061","r","habitualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106921","r","normalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106921","r","popularmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00106921","r","comumente","N");
INSERT INTO portuguese_lemma VALUES ("v#00072443","v","passar_por_cima","Y");
INSERT INTO portuguese_lemma VALUES ("v#00072443","v","atropelar","N");
INSERT INTO portuguese_lemma VALUES ("a#00107017","a","exíguo","N");
INSERT INTO portuguese_lemma VALUES ("a#00107017","a","exígua","N");
INSERT INTO portuguese_lemma VALUES ("r#00107416","r","recentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00112601","r","recentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00107416","r","há_pouco_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00107648","a","anabólico","N");
INSERT INTO portuguese_lemma VALUES ("a#02619404","a","anabólico","N");
INSERT INTO portuguese_lemma VALUES ("r#00107722","r","impredizivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00107722","r","imprevisivelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00107943","v","fraturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01621084","v","fraturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00107943","v","quebrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00263044","v","quebrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00333594","v","quebrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00333907","v","quebrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00231588","v","quebrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00858865","v","quebrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01298931","v","quebrar","N");
INSERT INTO portuguese_lemma VALUES ("a#00107984","a","catabólico","N");
INSERT INTO portuguese_lemma VALUES ("r#00107987","r","pouco_a_pouco","Y");
INSERT INTO portuguese_lemma VALUES ("r#00422281","r","pouco_a_pouco","Y");
INSERT INTO portuguese_lemma VALUES ("r#00107987","r","gradualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00108647","r","aqui","N");
INSERT INTO portuguese_lemma VALUES ("n#08489497","n","aqui","N");
INSERT INTO portuguese_lemma VALUES ("a#00109133","a","sinclinal","N");
INSERT INTO portuguese_lemma VALUES ("r#00109151","r","eis_aqui","Y");
INSERT INTO portuguese_lemma VALUES ("r#00109151","r","eis_ali","Y");
INSERT INTO portuguese_lemma VALUES ("r#00109151","r","eis","N");
INSERT INTO portuguese_lemma VALUES ("r#00109151","r","eis_aí","Y");
INSERT INTO portuguese_lemma VALUES ("a#00109504","a","diádromo","N");
INSERT INTO portuguese_lemma VALUES ("r#00109569","r","historicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00109687","r","historicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00074063","v","alterar","N");
INSERT INTO portuguese_lemma VALUES ("v#00082064","v","alterar","N");
INSERT INTO portuguese_lemma VALUES ("v#00083947","v","alterar","N");
INSERT INTO portuguese_lemma VALUES ("v#01144692","v","alterar","N");
INSERT INTO portuguese_lemma VALUES ("r#00109817","r","pacificamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00186756","r","pacificamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00109817","r","calmamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00109817","r","tranquilamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00186756","r","tranquilamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00109949","r","cientificamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00113640","a","relativo_ao_ânus","Y");
INSERT INTO portuguese_lemma VALUES ("a#00113640","a","anal","N");
INSERT INTO portuguese_lemma VALUES ("a#02620436","a","anal","N");
INSERT INTO portuguese_lemma VALUES ("r#00110286","r","humildemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00397466","r","humildemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00110497","a","analógico","N");
INSERT INTO portuguese_lemma VALUES ("a#01419462","a","analógico","N");
INSERT INTO portuguese_lemma VALUES ("r#00110659","r","a_céu_aberto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00110659","r","ao_ar_livre","Y");
INSERT INTO portuguese_lemma VALUES ("a#00110701","a","digital","N");
INSERT INTO portuguese_lemma VALUES ("a#02713096","a","digital","N");
INSERT INTO portuguese_lemma VALUES ("a#02713232","a","digital","N");
INSERT INTO portuguese_lemma VALUES ("n#12882779","n","digital","N");
INSERT INTO portuguese_lemma VALUES ("n#00110745","n","enterrada","N");
INSERT INTO portuguese_lemma VALUES ("r#00110815","r","no_interior","Y");
INSERT INTO portuguese_lemma VALUES ("r#00110815","r","em","N");
INSERT INTO portuguese_lemma VALUES ("r#00110815","r","dentro","N");
INSERT INTO portuguese_lemma VALUES ("r#00110815","r","adentro","N");
INSERT INTO portuguese_lemma VALUES ("a#00110853","a","analítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00111415","a","analítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00112231","a","analítico","N");
INSERT INTO portuguese_lemma VALUES ("a#02620550","a","analítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00114728","a","sintético","N");
INSERT INTO portuguese_lemma VALUES ("a#00115396","a","sintético","N");
INSERT INTO portuguese_lemma VALUES ("a#00116264","a","sintético","N");
INSERT INTO portuguese_lemma VALUES ("a#01069737","a","sintético","N");
INSERT INTO portuguese_lemma VALUES ("a#01517060","a","sintético","N");
INSERT INTO portuguese_lemma VALUES ("a#01518147","a","sintético","N");
INSERT INTO portuguese_lemma VALUES ("r#00111269","r","literalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00257864","r","literalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00340133","r","literalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00112018","a","polisintético","N");
INSERT INTO portuguese_lemma VALUES ("r#00112090","r","silenciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00112279","r","internacionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00112393","r","forçosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00342351","r","forçosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00342624","r","forçosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00112393","r","necessariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00408375","r","necessariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00112393","r","inevitavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00208557","r","inevitavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00218369","r","inevitavelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00112828","n","clique","N");
INSERT INTO portuguese_lemma VALUES ("n#07118210","n","clique","N");
INSERT INTO portuguese_lemma VALUES ("n#00112828","n","clicar","N");
INSERT INTO portuguese_lemma VALUES ("v#02185664","v","clicar","N");
INSERT INTO portuguese_lemma VALUES ("n#00112997","n","cutucão","N");
INSERT INTO portuguese_lemma VALUES ("r#00113082","r","diferentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00113082","r","de_forma_diferente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00113082","r","excepcionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00178793","r","excepcionalmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00072419","n","imprensa","N");
INSERT INTO portuguese_lemma VALUES ("n#03170199","n","imprensa","N");
INSERT INTO portuguese_lemma VALUES ("n#03170463","n","imprensa","N");
INSERT INTO portuguese_lemma VALUES ("n#04736003","n","imprensa","N");
INSERT INTO portuguese_lemma VALUES ("n#00072419","n","pressão","N");
INSERT INTO portuguese_lemma VALUES ("n#00356790","n","pressão","N");
INSERT INTO portuguese_lemma VALUES ("n#04044869","n","pressão","N");
INSERT INTO portuguese_lemma VALUES ("n#04422106","n","pressão","N");
INSERT INTO portuguese_lemma VALUES ("n#11429458","n","pressão","N");
INSERT INTO portuguese_lemma VALUES ("n#07825463","n","pressão","N");
INSERT INTO portuguese_lemma VALUES ("n#10368592","n","pressão","N");
INSERT INTO portuguese_lemma VALUES ("a#00113818","a","raivosa","N");
INSERT INTO portuguese_lemma VALUES ("a#00113818","a","irado","N");
INSERT INTO portuguese_lemma VALUES ("a#00115193","a","irado","N");
INSERT INTO portuguese_lemma VALUES ("a#00113818","a","irritado","N");
INSERT INTO portuguese_lemma VALUES ("a#00113818","a","bravo","N");
INSERT INTO portuguese_lemma VALUES ("a#00246332","a","bravo","N");
INSERT INTO portuguese_lemma VALUES ("a#00258473","a","bravo","N");
INSERT INTO portuguese_lemma VALUES ("a#02391401","a","bravo","N");
INSERT INTO portuguese_lemma VALUES ("a#00113818","a","zangado","N");
INSERT INTO portuguese_lemma VALUES ("a#00115193","a","zangado","N");
INSERT INTO portuguese_lemma VALUES ("r#00114310","r","de_forma_oficial","Y");
INSERT INTO portuguese_lemma VALUES ("r#00114310","r","oficialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00186491","r","oficialmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00073144","n","puxão","N");
INSERT INTO portuguese_lemma VALUES ("n#00073144","n","tração","N");
INSERT INTO portuguese_lemma VALUES ("a#00117872","a","raivoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00299475","a","raivoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02786473","a","raivoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00117872","a","furibundo","N");
INSERT INTO portuguese_lemma VALUES ("a#00117872","a","furioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00299475","a","furioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00117872","a","feroz","N");
INSERT INTO portuguese_lemma VALUES ("a#00299475","a","feroz","N");
INSERT INTO portuguese_lemma VALUES ("a#01212393","a","feroz","N");
INSERT INTO portuguese_lemma VALUES ("a#01445872","a","feroz","N");
INSERT INTO portuguese_lemma VALUES ("a#01449500","a","feroz","N");
INSERT INTO portuguese_lemma VALUES ("a#02276991","a","feroz","N");
INSERT INTO portuguese_lemma VALUES ("a#02391401","a","feroz","N");
INSERT INTO portuguese_lemma VALUES ("r#00114750","r","centralmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00077064","v","tornar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00083639","v","tornar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00250539","v","tornar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01791776","v","tornar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00114921","a","colérico","N");
INSERT INTO portuguese_lemma VALUES ("a#01135914","a","colérico","N");
INSERT INTO portuguese_lemma VALUES ("a#01726613","a","colérico","N");
INSERT INTO portuguese_lemma VALUES ("v#00077276","v","transmudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00077276","v","converter","N");
INSERT INTO portuguese_lemma VALUES ("v#00111031","v","converter","N");
INSERT INTO portuguese_lemma VALUES ("n#00199130","n","converter","N");
INSERT INTO portuguese_lemma VALUES ("v#00268049","v","converter","N");
INSERT INTO portuguese_lemma VALUES ("v#00077276","v","transformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00266041","v","transformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00266431","v","transformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00266920","v","transformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00380419","v","transformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00390255","v","transformar","N");
INSERT INTO portuguese_lemma VALUES ("v#01791776","v","transformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00077276","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00082064","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00083947","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00117331","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00266431","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00266920","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00389126","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01144692","v","modificar","N");
INSERT INTO portuguese_lemma VALUES ("r#00115254","r","fisicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00115292","n","reboque","N");
INSERT INTO portuguese_lemma VALUES ("n#00115292","n","rebocador","N");
INSERT INTO portuguese_lemma VALUES ("n#04495843","n","rebocador","N");
INSERT INTO portuguese_lemma VALUES ("a#00115494","a","indignado","N");
INSERT INTO portuguese_lemma VALUES ("r#00115554","r","de_preferência","Y");
INSERT INTO portuguese_lemma VALUES ("r#00115554","r","preferivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00115554","r","preferencialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00115745","r","politicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00115859","r","politicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00115803","n","extirpação","N");
INSERT INTO portuguese_lemma VALUES ("n#00393369","n","extirpação","N");
INSERT INTO portuguese_lemma VALUES ("a#00115906","a","lívido","N");
INSERT INTO portuguese_lemma VALUES ("a#00267889","a","lívido","N");
INSERT INTO portuguese_lemma VALUES ("r#00116280","r","simbolicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00126733","r","simbolicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00074216","n","alcar","N");
INSERT INTO portuguese_lemma VALUES ("n#00074216","n","elevação","N");
INSERT INTO portuguese_lemma VALUES ("n#00209440","n","elevação","N");
INSERT INTO portuguese_lemma VALUES ("n#06692424","n","elevação","N");
INSERT INTO portuguese_lemma VALUES ("n#00074216","n","levantamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00618461","n","levantamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00074431","n","ejeção","N");
INSERT INTO portuguese_lemma VALUES ("n#00074431","n","expulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#00135765","n","expulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#00230520","n","expulsão","N");
INSERT INTO portuguese_lemma VALUES ("n#09715904","n","expulsão","N");
INSERT INTO portuguese_lemma VALUES ("a#00116744","a","acrimonioso","N");
INSERT INTO portuguese_lemma VALUES ("a#01320002","a","acrimonioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00116940","a","rancoroso","N");
INSERT INTO portuguese_lemma VALUES ("n#00116989","n","defenestração","N");
INSERT INTO portuguese_lemma VALUES ("r#00117082","r","junto_com","Y");
INSERT INTO portuguese_lemma VALUES ("r#00117082","r","bem_como","Y");
INSERT INTO portuguese_lemma VALUES ("r#00117082","r","coletivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00117082","r","em_companhia_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00117082","r","juntamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00197710","r","juntamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00117498","v","reconverter","N");
INSERT INTO portuguese_lemma VALUES ("n#00117578","n","arroto","N");
INSERT INTO portuguese_lemma VALUES ("r#00117903","r","então","N");
INSERT INTO portuguese_lemma VALUES ("n#00117959","n","piscamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00078446","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#00101662","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#01268426","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#01371015","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#02229828","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#01800547","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#01801598","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#01865371","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#01868387","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#02731242","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#02744820","v","ficar","N");
INSERT INTO portuguese_lemma VALUES ("v#00078446","v","permanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01064160","v","permanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01268426","v","permanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01801598","v","permanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01865371","v","permanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01868387","v","permanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#02731242","v","permanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00078446","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00118523","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00243167","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00530824","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00781491","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01360914","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01618013","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01828422","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01831586","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01832078","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#02747709","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#02747922","v","continuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00078446","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#00607000","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#00732552","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#00687441","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#00687837","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#01151753","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#00805632","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#01508080","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#01522764","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("v#01828422","v","manter","N");
INSERT INTO portuguese_lemma VALUES ("r#00118253","r","volumetricamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00118531","r","desconsiderando","N");
INSERT INTO portuguese_lemma VALUES ("r#00118531","r","independente","N");
INSERT INTO portuguese_lemma VALUES ("a#00691708","a","independente","N");
INSERT INTO portuguese_lemma VALUES ("a#00696017","a","independente","N");
INSERT INTO portuguese_lemma VALUES ("a#01009075","a","independente","N");
INSERT INTO portuguese_lemma VALUES ("a#02401440","a","independente","N");
INSERT INTO portuguese_lemma VALUES ("n#00118552","n","Cuspir","N");
INSERT INTO portuguese_lemma VALUES ("n#00118733","n","Emese","N");
INSERT INTO portuguese_lemma VALUES ("n#00118733","n","êmese","N");
INSERT INTO portuguese_lemma VALUES ("n#00118733","n","vômito","N");
INSERT INTO portuguese_lemma VALUES ("n#14855992","n","vômito","N");
INSERT INTO portuguese_lemma VALUES ("r#00118869","r","uma","N");
INSERT INTO portuguese_lemma VALUES ("r#00118965","r","antigamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00119139","r","conquanto","N");
INSERT INTO portuguese_lemma VALUES ("r#00119139","r","embora","N");
INSERT INTO portuguese_lemma VALUES ("r#00232936","r","embora","N");
INSERT INTO portuguese_lemma VALUES ("r#00119139","r","ainda_que","Y");
INSERT INTO portuguese_lemma VALUES ("r#00119139","r","posto_que","Y");
INSERT INTO portuguese_lemma VALUES ("n#00119402","n","Hiperêmese_gravídica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00119402","n","Hiperemese_gravídica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00076072","n","salto","N");
INSERT INTO portuguese_lemma VALUES ("n#00076442","n","salto","N");
INSERT INTO portuguese_lemma VALUES ("n#00076563","n","salto","N");
INSERT INTO portuguese_lemma VALUES ("n#00076714","n","salto","N");
INSERT INTO portuguese_lemma VALUES ("n#02813812","n","salto","N");
INSERT INTO portuguese_lemma VALUES ("n#03969685","n","salto","N");
INSERT INTO portuguese_lemma VALUES ("n#05481281","n","salto","N");
INSERT INTO portuguese_lemma VALUES ("n#00076072","n","pulo","N");
INSERT INTO portuguese_lemma VALUES ("n#00076442","n","pulo","N");
INSERT INTO portuguese_lemma VALUES ("n#00076563","n","pulo","N");
INSERT INTO portuguese_lemma VALUES ("n#05481281","n","pulo","N");
INSERT INTO portuguese_lemma VALUES ("r#00119578","r","por_outro_lado","Y");
INSERT INTO portuguese_lemma VALUES ("r#00119798","r","por_um_lado","Y");
INSERT INTO portuguese_lemma VALUES ("r#00119940","r","com_sucesso","Y");
INSERT INTO portuguese_lemma VALUES ("r#00119940","r","com","N");
INSERT INTO portuguese_lemma VALUES ("r#00250056","r","com","N");
INSERT INTO portuguese_lemma VALUES ("v#00301544","v","com","N");
INSERT INTO portuguese_lemma VALUES ("n#00076442","n","lúpulo","N");
INSERT INTO portuguese_lemma VALUES ("n#12397864","n","lúpulo","N");
INSERT INTO portuguese_lemma VALUES ("n#12398174","n","lúpulo","N");
INSERT INTO portuguese_lemma VALUES ("r#00120095","r","concomitantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00120095","r","de_forma_concomitante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00120095","r","de_forma_simultânea","Y");
INSERT INTO portuguese_lemma VALUES ("r#00120095","r","simultaneamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00120223","r","simultaneamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00120223","r","concorrentemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00079910","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01609431","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("v#00771490","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("v#00545347","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01860795","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01579009","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01649126","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01829006","v","deixar","N");
INSERT INTO portuguese_lemma VALUES ("r#00120474","r","sistematicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00120474","r","consistentemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00123651","a","anónimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00123835","a","anónimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00234227","a","anónimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00123651","a","anônimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00123835","a","anônimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00234227","a","anônimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00123835","a","incógnito","N");
INSERT INTO portuguese_lemma VALUES ("a#02089724","a","incógnito","N");
INSERT INTO portuguese_lemma VALUES ("v#00080395","v","tornar","N");
INSERT INTO portuguese_lemma VALUES ("v#00146138","v","tornar","N");
INSERT INTO portuguese_lemma VALUES ("v#00101662","v","tornar","N");
INSERT INTO portuguese_lemma VALUES ("r#00121002","r","deste_modo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00121183","a","binominal","N");
INSERT INTO portuguese_lemma VALUES ("a#00121183","a","binária","N");
INSERT INTO portuguese_lemma VALUES ("a#00121183","a","binomial","N");
INSERT INTO portuguese_lemma VALUES ("v#00080777","v","alternar","N");
INSERT INTO portuguese_lemma VALUES ("a#00124764","a","antecedente","N");
INSERT INTO portuguese_lemma VALUES ("n#04953355","n","antecedente","N");
INSERT INTO portuguese_lemma VALUES ("r#00121894","r","fotograficamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00122124","r","constitucionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00125081","a","anterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00814611","a","anterior","N");
INSERT INTO portuguese_lemma VALUES ("a#01666340","a","anterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00125081","a","prévio","N");
INSERT INTO portuguese_lemma VALUES ("a#00129370","a","prévio","N");
INSERT INTO portuguese_lemma VALUES ("a#01666340","a","prévio","N");
INSERT INTO portuguese_lemma VALUES ("r#00122273","r","anticonstitucionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00125249","a","preexistente","N");
INSERT INTO portuguese_lemma VALUES ("r#00122427","r","democraticamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00125346","a","subsequente","N");
INSERT INTO portuguese_lemma VALUES ("a#00130048","a","subsequente","N");
INSERT INTO portuguese_lemma VALUES ("a#00125346","a","subseqüente","N");
INSERT INTO portuguese_lemma VALUES ("a#00125346","a","ulterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00125852","a","ulterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00420174","a","ulterior","N");
INSERT INTO portuguese_lemma VALUES ("a#01645393","a","ulterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00125346","a","posterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00125852","a","posterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00134163","a","posterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00134388","a","posterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00197253","a","posterior","N");
INSERT INTO portuguese_lemma VALUES ("a#00197568","a","posterior","N");
INSERT INTO portuguese_lemma VALUES ("n#00077986","n","pontaria","N");
INSERT INTO portuguese_lemma VALUES ("n#00077986","n","tiro","N");
INSERT INTO portuguese_lemma VALUES ("n#00635718","n","tiro","N");
INSERT INTO portuguese_lemma VALUES ("r#00122816","r","à_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00180756","r","à_parte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00207668","r","à_parte","Y");
INSERT INTO portuguese_lemma VALUES ("a#01902400","a","resultante","N");
INSERT INTO portuguese_lemma VALUES ("a#01902400","a","conseqüente","N");
INSERT INTO portuguese_lemma VALUES ("a#00433594","a","conseqüente","N");
INSERT INTO portuguese_lemma VALUES ("a#01902400","a","decorrente","N");
INSERT INTO portuguese_lemma VALUES ("a#01902400","a","concomitante","N");
INSERT INTO portuguese_lemma VALUES ("a#01902400","a","anexado","N");
INSERT INTO portuguese_lemma VALUES ("r#00123000","r","digitalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00123112","r","digitalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00082064","v","variar","N");
INSERT INTO portuguese_lemma VALUES ("v#00304906","v","variar","N");
INSERT INTO portuguese_lemma VALUES ("v#00982514","v","variar","N");
INSERT INTO portuguese_lemma VALUES ("v#01816363","v","variar","N");
INSERT INTO portuguese_lemma VALUES ("v#01816538","v","variar","N");
INSERT INTO portuguese_lemma VALUES ("r#00123229","r","economicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00123365","r","economicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00123500","r","economicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00123582","r","eletronicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00123695","r","de_forma_étnica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00123695","r","etnicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00078903","n","tiro_de_arma_de_fogo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00123924","r","geneticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00124038","r","graficamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00132797","r","graficamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00310847","r","graficamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00124077","a","aquática","N");
INSERT INTO portuguese_lemma VALUES ("a#00124077","a","aquático","N");
INSERT INTO portuguese_lemma VALUES ("a#02636582","a","aquático","N");
INSERT INTO portuguese_lemma VALUES ("v#00124226","v","otimizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00172505","v","otimizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00126777","a","marinho","N");
INSERT INTO portuguese_lemma VALUES ("a#02670038","a","marinho","N");
INSERT INTO portuguese_lemma VALUES ("a#02671223","a","marinho","N");
INSERT INTO portuguese_lemma VALUES ("v#00124442","v","mover","N");
INSERT INTO portuguese_lemma VALUES ("v#01249365","v","mover","N");
INSERT INTO portuguese_lemma VALUES ("v#01374681","v","mover","N");
INSERT INTO portuguese_lemma VALUES ("a#00124493","a","subaquático","N");
INSERT INTO portuguese_lemma VALUES ("a#00124685","a","subaquático","N");
INSERT INTO portuguese_lemma VALUES ("a#02472252","a","subaquático","N");
INSERT INTO portuguese_lemma VALUES ("r#00124611","r","pela_lei","Y");
INSERT INTO portuguese_lemma VALUES ("r#00124611","r","legalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00251820","r","legalmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00124617","n","tiroteio","N");
INSERT INTO portuguese_lemma VALUES ("r#00124702","r","manualmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00127354","a","terrestre","N");
INSERT INTO portuguese_lemma VALUES ("a#01131511","a","terrestre","N");
INSERT INTO portuguese_lemma VALUES ("a#02454611","a","terrestre","N");
INSERT INTO portuguese_lemma VALUES ("a#02594240","a","terrestre","N");
INSERT INTO portuguese_lemma VALUES ("a#02810102","a","terrestre","N");
INSERT INTO portuguese_lemma VALUES ("n#10699262","n","terrestre","N");
INSERT INTO portuguese_lemma VALUES ("a#00125319","a","anfíbio","N");
INSERT INTO portuguese_lemma VALUES ("n#01627424","n","anfíbio","N");
INSERT INTO portuguese_lemma VALUES ("n#02704792","n","anfíbio","N");
INSERT INTO portuguese_lemma VALUES ("a#02831979","a","anfíbio","N");
INSERT INTO portuguese_lemma VALUES ("n#00125436","n","baterdeleve","N");
INSERT INTO portuguese_lemma VALUES ("r#00125481","r","realisticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00215517","r","realisticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00125602","r","em_flagrante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00125602","r","com_a_boca_na_butija","Y");
INSERT INTO portuguese_lemma VALUES ("v#00125633","v","revolucionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00605310","v","revolucionar","N");
INSERT INTO portuguese_lemma VALUES ("v#02402695","v","revolucionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00128303","a","acima_mencionado","Y");
INSERT INTO portuguese_lemma VALUES ("a#00128422","a","precedente","N");
INSERT INTO portuguese_lemma VALUES ("a#00128526","a","introdutório","N");
INSERT INTO portuguese_lemma VALUES ("a#01009709","a","introdutório","N");
INSERT INTO portuguese_lemma VALUES ("r#00126527","r","socialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00126638","r","socialmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00126830","a","preparatório","N");
INSERT INTO portuguese_lemma VALUES ("r#00126837","r","técnicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00126972","r","técnicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00126837","r","na_realidade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00126837","r","tecnicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00126972","r","tecnicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00127130","r","tecnicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00127286","n","andar_até_a_primeira_base","Y");
INSERT INTO portuguese_lemma VALUES ("n#00127286","n","andada","N");
INSERT INTO portuguese_lemma VALUES ("n#00184167","n","andada","N");
INSERT INTO portuguese_lemma VALUES ("n#13894154","n","andada","N");
INSERT INTO portuguese_lemma VALUES ("n#10111948","n","andada","N");
INSERT INTO portuguese_lemma VALUES ("r#00127339","r","temporalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00129930","a","consecutivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00563963","a","consecutivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00127866","n","bola_válida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00127866","r","terapeuticamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00082548","n","bola_de_falta","Y");
INSERT INTO portuguese_lemma VALUES ("r#00128168","r","tipicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00128456","r","verbalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00128554","r","verbalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00128572","a","sem_precedentes","Y");
INSERT INTO portuguese_lemma VALUES ("a#01377933","a","sem_precedentes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00128882","r","globalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00128989","r","eletricamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00129089","r","quimicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00129228","r","quimicamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00129103","a","pré-natal","N");
INSERT INTO portuguese_lemma VALUES ("a#01733661","a","pré-natal","N");
INSERT INTO portuguese_lemma VALUES ("a#00129276","a","perinatal","N");
INSERT INTO portuguese_lemma VALUES ("r#00129675","r","longitudinalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00129788","r","de_forma_mágica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00130093","n","putout","N");
INSERT INTO portuguese_lemma VALUES ("n#00130347","n","Strike_out","Y");
INSERT INTO portuguese_lemma VALUES ("n#00130347","n","strikeout","N");
INSERT INTO portuguese_lemma VALUES ("r#00130432","r","profissionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00130518","a","demanhã","N");
INSERT INTO portuguese_lemma VALUES ("r#00130549","r","espacialmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00130673","n","escolha_do_defensor","Y");
INSERT INTO portuguese_lemma VALUES ("n#00130987","n","fly_de_sacrifício","Y");
INSERT INTO portuguese_lemma VALUES ("a#00131018","a","frontal","N");
INSERT INTO portuguese_lemma VALUES ("a#00131176","a","frontal","N");
INSERT INTO portuguese_lemma VALUES ("a#00198757","a","frontal","N");
INSERT INTO portuguese_lemma VALUES ("n#05541231","n","frontal","N");
INSERT INTO portuguese_lemma VALUES ("r#00131018","r","sociolinguisticamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00131297","a","pré-frontal","N");
INSERT INTO portuguese_lemma VALUES ("a#00134163","a","rabo","N");
INSERT INTO portuguese_lemma VALUES ("a#00197253","a","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#01665222","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#02463611","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#02359063","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#04316646","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#03465129","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#05306476","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#05514410","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#04289965","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#04306560","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#08625846","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#08629508","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("n#10967384","n","rabo","N");
INSERT INTO portuguese_lemma VALUES ("a#00134163","a","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00197253","a","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00197568","a","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#01665222","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#02463611","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#02359063","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#02359166","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#04162599","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#04316646","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#03465129","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#05306476","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#05514410","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#04306560","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#04306912","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#04515461","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#08511970","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#06314878","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#08625846","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#08629508","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#10967384","n","traseiro","N");
INSERT INTO portuguese_lemma VALUES ("r#00132060","r","pessoalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00132158","r","pessoalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00132322","r","pessoalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00366266","r","pessoalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00366393","r","pessoalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00132127","a","crista","N");
INSERT INTO portuguese_lemma VALUES ("n#00869601","n","crista","N");
INSERT INTO portuguese_lemma VALUES ("n#01792255","n","crista","N");
INSERT INTO portuguese_lemma VALUES ("n#06301604","n","crista","N");
INSERT INTO portuguese_lemma VALUES ("n#11825211","n","crista","N");
INSERT INTO portuguese_lemma VALUES ("r#00132158","r","na_pessoa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00132355","n","home_run","Y");
INSERT INTO portuguese_lemma VALUES ("n#00132355","n","Homerun","N");
INSERT INTO portuguese_lemma VALUES ("a#00132385","a","ventral","N");
INSERT INTO portuguese_lemma VALUES ("a#02934594","a","ventral","N");
INSERT INTO portuguese_lemma VALUES ("n#00132601","n","Rebatida_simples","Y");
INSERT INTO portuguese_lemma VALUES ("r#00132673","r","patologicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00132673","r","de_forma_patológica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00132756","n","Rebatida_dupla","Y");
INSERT INTO portuguese_lemma VALUES ("n#00086151","n","Rebatida_tripla","Y");
INSERT INTO portuguese_lemma VALUES ("n#00086151","n","triplo","N");
INSERT INTO portuguese_lemma VALUES ("a#02115749","a","triplo","N");
INSERT INTO portuguese_lemma VALUES ("a#02116036","a","triplo","N");
INSERT INTO portuguese_lemma VALUES ("n#04510642","n","triplo","N");
INSERT INTO portuguese_lemma VALUES ("a#00133065","a","inapelável","N");
INSERT INTO portuguese_lemma VALUES ("r#00133140","r","visualmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00086415","n","golpe","N");
INSERT INTO portuguese_lemma VALUES ("n#00224275","n","golpe","N");
INSERT INTO portuguese_lemma VALUES ("n#00754280","n","golpe","N");
INSERT INTO portuguese_lemma VALUES ("a#00133417","a","apetitoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02282891","a","apetitoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00133613","r","biologicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00086637","n","bofetada","N");
INSERT INTO portuguese_lemma VALUES ("n#00087184","n","bofetada","N");
INSERT INTO portuguese_lemma VALUES ("n#07410745","n","bofetada","N");
INSERT INTO portuguese_lemma VALUES ("r#00133987","r","bioquimicamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00134060","a","acessível","N");
INSERT INTO portuguese_lemma VALUES ("a#00134251","a","acessível","N");
INSERT INTO portuguese_lemma VALUES ("a#00533221","a","acessível","N");
INSERT INTO portuguese_lemma VALUES ("n#00134099","n","nocaute","N");
INSERT INTO portuguese_lemma VALUES ("r#00134203","r","moralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00364477","r","moralmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00134780","n","perfurador","N");
INSERT INTO portuguese_lemma VALUES ("n#00134780","n","ponche","N");
INSERT INTO portuguese_lemma VALUES ("n#00134780","n","darbofetadas","N");
INSERT INTO portuguese_lemma VALUES ("n#00134780","n","murro","N");
INSERT INTO portuguese_lemma VALUES ("n#00134780","n","soco","N");
INSERT INTO portuguese_lemma VALUES ("n#07336999","n","soco","N");
INSERT INTO portuguese_lemma VALUES ("r#00134843","r","de_forma_acústica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00134843","r","acusticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00135198","r","alegoricamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00135314","r","localmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00135418","r","localmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00137926","a","atempado","N");
INSERT INTO portuguese_lemma VALUES ("r#00135567","r","regionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00135667","r","nacionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00135718","a","inapropriado","N");
INSERT INTO portuguese_lemma VALUES ("a#00529913","a","inapropriado","N");
INSERT INTO portuguese_lemma VALUES ("a#01017738","a","inapropriado","N");
INSERT INTO portuguese_lemma VALUES ("a#01129823","a","inapropriado","N");
INSERT INTO portuguese_lemma VALUES ("n#00136329","n","chute","N");
INSERT INTO portuguese_lemma VALUES ("n#00788473","n","chute","N");
INSERT INTO portuguese_lemma VALUES ("a#00138848","a","vencido","N");
INSERT INTO portuguese_lemma VALUES ("r#00136469","r","sexualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00136561","r","sexualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00136663","r","lexicamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00139589","a","que_não_foi_pago_na_data_certa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00137142","r","de_forma_cirúrgica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00137142","r","através_de_cirurgia","Y");
INSERT INTO portuguese_lemma VALUES ("r#00137142","r","cirurgicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00137459","r","cromatograficamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00137459","r","de_forma_cromatográfica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00137562","r","alternadamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00137641","a","indevido","N");
INSERT INTO portuguese_lemma VALUES ("a#00137943","a","indevido","N");
INSERT INTO portuguese_lemma VALUES ("a#01945350","a","indevido","N");
INSERT INTO portuguese_lemma VALUES ("n#00137709","n","escanteio","N");
INSERT INTO portuguese_lemma VALUES ("r#00137915","r","respectivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00138060","r","similarmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00138060","r","igualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00332069","r","igualmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00092182","v","repercutir","N");
INSERT INTO portuguese_lemma VALUES ("n#00090133","n","ósculo","N");
INSERT INTO portuguese_lemma VALUES ("n#00090133","n","beijo","N");
INSERT INTO portuguese_lemma VALUES ("r#00138291","r","secundariamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00140892","a","procedente","N");
INSERT INTO portuguese_lemma VALUES ("a#01906028","a","procedente","N");
INSERT INTO portuguese_lemma VALUES ("a#00140892","a","pertinente","N");
INSERT INTO portuguese_lemma VALUES ("a#01905215","a","pertinente","N");
INSERT INTO portuguese_lemma VALUES ("a#01906028","a","pertinente","N");
INSERT INTO portuguese_lemma VALUES ("a#00140892","a","apto","N");
INSERT INTO portuguese_lemma VALUES ("a#01077975","a","apto","N");
INSERT INTO portuguese_lemma VALUES ("a#00140892","a","apropriado","N");
INSERT INTO portuguese_lemma VALUES ("a#00812035","a","apropriado","N");
INSERT INTO portuguese_lemma VALUES ("a#01077975","a","apropriado","N");
INSERT INTO portuguese_lemma VALUES ("a#01316335","a","apropriado","N");
INSERT INTO portuguese_lemma VALUES ("a#01879667","a","apropriado","N");
INSERT INTO portuguese_lemma VALUES ("v#00092585","v","virar_do_avesso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00092585","v","inverter","N");
INSERT INTO portuguese_lemma VALUES ("v#00268521","v","inverter","N");
INSERT INTO portuguese_lemma VALUES ("v#00092585","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01274944","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01301287","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01302894","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01303191","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#02033295","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01390339","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01431957","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01436577","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#01791776","v","virar","N");
INSERT INTO portuguese_lemma VALUES ("v#00092585","v","reverter","N");
INSERT INTO portuguese_lemma VALUES ("v#00268771","v","reverter","N");
INSERT INTO portuguese_lemma VALUES ("n#00138799","n","linguado","N");
INSERT INTO portuguese_lemma VALUES ("n#00138799","n","beijo_de_língua","Y");
INSERT INTO portuguese_lemma VALUES ("r#00138945","r","de_forma_dramática","Y");
INSERT INTO portuguese_lemma VALUES ("r#00138945","r","dramaticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00188353","r","dramaticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00246802","r","dramaticamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00138956","n","agarrão","N");
INSERT INTO portuguese_lemma VALUES ("n#00138956","n","pegada","N");
INSERT INTO portuguese_lemma VALUES ("n#04984123","n","pegada","N");
INSERT INTO portuguese_lemma VALUES ("n#00138956","n","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00379587","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00589904","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00825349","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00826212","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00826635","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00827658","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00982468","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#01442761","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#01576416","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#02486534","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("v#02761134","v","pegar","N");
INSERT INTO portuguese_lemma VALUES ("r#00139173","r","em_terra","Y");
INSERT INTO portuguese_lemma VALUES ("r#00139266","r","de_forma_notável","Y");
INSERT INTO portuguese_lemma VALUES ("r#00139266","r","memorávelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00139508","r","apropiadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00139508","r","convenientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00197395","r","convenientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230444","r","convenientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00139508","r","apropriadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00185172","r","apropriadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00139508","r","adequadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00369718","r","adequadamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00139758","n","interceptação","N");
INSERT INTO portuguese_lemma VALUES ("n#00091354","n","recepção","N");
INSERT INTO portuguese_lemma VALUES ("n#04747092","n","recepção","N");
INSERT INTO portuguese_lemma VALUES ("n#04894307","n","recepção","N");
INSERT INTO portuguese_lemma VALUES ("n#06630852","n","recepção","N");
INSERT INTO portuguese_lemma VALUES ("n#06128644","n","recepção","N");
INSERT INTO portuguese_lemma VALUES ("r#00140566","r","artificialmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00091972","n","manipulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00102995","n","manipulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00091972","n","manejo","N");
INSERT INTO portuguese_lemma VALUES ("v#00094296","v","alterar_para","Y");
INSERT INTO portuguese_lemma VALUES ("r#00140759","r","agudamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00140884","r","cronicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00141033","r","cronicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00140967","v","deformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00476744","v","deformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00477665","v","deformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00924489","v","deformar","N");
INSERT INTO portuguese_lemma VALUES ("v#01584875","v","deformar","N");
INSERT INTO portuguese_lemma VALUES ("r#00141146","r","contraditoriamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00141176","n","exame","N");
INSERT INTO portuguese_lemma VALUES ("n#00417674","n","exame","N");
INSERT INTO portuguese_lemma VALUES ("n#00644702","n","exame","N");
INSERT INTO portuguese_lemma VALUES ("n#05378329","n","exame","N");
INSERT INTO portuguese_lemma VALUES ("v#00141362","v","individualizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00141396","n","autópsia","N");
INSERT INTO portuguese_lemma VALUES ("n#00141396","n","necropse","N");
INSERT INTO portuguese_lemma VALUES ("n#00141396","n","necrópsia","N");
INSERT INTO portuguese_lemma VALUES ("r#00141405","r","episodicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00141669","n","check-in","N");
INSERT INTO portuguese_lemma VALUES ("n#00141669","n","Check_in","Y");
INSERT INTO portuguese_lemma VALUES ("n#00092615","n","verificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00153961","n","verificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00154233","n","verificação","N");
INSERT INTO portuguese_lemma VALUES ("n#04486906","n","verificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00092615","n","controle","N");
INSERT INTO portuguese_lemma VALUES ("n#00513665","n","controle","N");
INSERT INTO portuguese_lemma VALUES ("n#04074963","n","controle","N");
INSERT INTO portuguese_lemma VALUES ("n#05193781","n","controle","N");
INSERT INTO portuguese_lemma VALUES ("n#04046475","n","controle","N");
INSERT INTO portuguese_lemma VALUES ("n#00092615","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#02621671","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#03992325","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#03992719","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#08501114","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#06279059","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#06279444","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#06314081","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#06336706","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#13871452","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#10018921","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#10019175","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#10019310","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#10019436","n","limite","N");
INSERT INTO portuguese_lemma VALUES ("n#00092615","n","inspeção","N");
INSERT INTO portuguese_lemma VALUES ("n#00564770","n","inspeção","N");
INSERT INTO portuguese_lemma VALUES ("a#00144204","a","arbóreo","N");
INSERT INTO portuguese_lemma VALUES ("a#02638121","a","arbóreo","N");
INSERT INTO portuguese_lemma VALUES ("a#00144426","a","arenoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01097044","a","arenoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00095506","v","formar","N");
INSERT INTO portuguese_lemma VALUES ("v#01139594","v","formar","N");
INSERT INTO portuguese_lemma VALUES ("a#00144604","a","argiloso","N");
INSERT INTO portuguese_lemma VALUES ("a#02905050","a","argiloso","N");
INSERT INTO portuguese_lemma VALUES ("a#00142622","a","equipado","N");
INSERT INTO portuguese_lemma VALUES ("a#01096990","a","equipado","N");
INSERT INTO portuguese_lemma VALUES ("a#01844002","a","equipado","N");
INSERT INTO portuguese_lemma VALUES ("r#00142662","r","humanamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00359302","r","humanamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00093090","n","comparação","N");
INSERT INTO portuguese_lemma VALUES ("n#03729864","n","comparação","N");
INSERT INTO portuguese_lemma VALUES ("n#07108282","n","comparação","N");
INSERT INTO portuguese_lemma VALUES ("n#09980356","n","comparação","N");
INSERT INTO portuguese_lemma VALUES ("a#00142917","a","desarmado","N");
INSERT INTO portuguese_lemma VALUES ("a#00145995","a","desarmado","N");
INSERT INTO portuguese_lemma VALUES ("a#00142917","a","inerme","N");
INSERT INTO portuguese_lemma VALUES ("a#00145995","a","inerme","N");
INSERT INTO portuguese_lemma VALUES ("a#02524032","a","inerme","N");
INSERT INTO portuguese_lemma VALUES ("n#00093268","n","acompanhamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00455348","n","acompanhamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00530280","n","acompanhamento","N");
INSERT INTO portuguese_lemma VALUES ("n#03377582","n","acompanhamento","N");
INSERT INTO portuguese_lemma VALUES ("n#07031752","n","acompanhamento","N");
INSERT INTO portuguese_lemma VALUES ("n#07580053","n","acompanhamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00093268","n","revisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00897811","n","revisão","N");
INSERT INTO portuguese_lemma VALUES ("n#06428976","n","revisão","N");
INSERT INTO portuguese_lemma VALUES ("r#00143257","r","judicialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00514272","r","judicialmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00143338","v","moldar","N");
INSERT INTO portuguese_lemma VALUES ("v#01139594","v","moldar","N");
INSERT INTO portuguese_lemma VALUES ("a#00143376","a","indefeso","N");
INSERT INTO portuguese_lemma VALUES ("a#01179759","a","indefeso","N");
INSERT INTO portuguese_lemma VALUES ("a#01886783","a","indefeso","N");
INSERT INTO portuguese_lemma VALUES ("a#02524032","a","indefeso","N");
INSERT INTO portuguese_lemma VALUES ("a#00143589","a","blindado","N");
INSERT INTO portuguese_lemma VALUES ("a#00146883","a","blindado","N");
INSERT INTO portuguese_lemma VALUES ("n#02739889","n","blindado","N");
INSERT INTO portuguese_lemma VALUES ("n#02740061","n","blindado","N");
INSERT INTO portuguese_lemma VALUES ("v#00096666","v","cristalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00309849","v","cristalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00311317","v","cristalizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00143722","r","superficialmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00143914","v","torcer","N");
INSERT INTO portuguese_lemma VALUES ("v#00874035","v","torcer","N");
INSERT INTO portuguese_lemma VALUES ("v#01275761","v","torcer","N");
INSERT INTO portuguese_lemma VALUES ("v#01391432","v","torcer","N");
INSERT INTO portuguese_lemma VALUES ("v#00143914","v","retorcer","N");
INSERT INTO portuguese_lemma VALUES ("v#01010429","v","retorcer","N");
INSERT INTO portuguese_lemma VALUES ("v#00144169","v","granular","N");
INSERT INTO portuguese_lemma VALUES ("r#00144405","r","um_pouco","Y");
INSERT INTO portuguese_lemma VALUES ("r#00144405","r","um_momento","Y");
INSERT INTO portuguese_lemma VALUES ("n#00144445","n","cócegas","N");
INSERT INTO portuguese_lemma VALUES ("n#00093956","n","carícia","N");
INSERT INTO portuguese_lemma VALUES ("n#00268334","n","carícia","N");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","certamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","com_certeza","Y");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","seguramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00154213","r","seguramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","por_certo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","efectivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","com_efeito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00148869","r","com_efeito","Y");
INSERT INTO portuguese_lemma VALUES ("r#00144722","r","na_verdade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00148869","r","na_verdade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00149510","r","na_verdade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00145228","r","de_forma_surpreendente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00145228","r","assombrosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00213301","r","assombrosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00145228","r","surpreendentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00213301","r","surpreendentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00145571","r","suficientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00145571","r","emquantidadesuficiente","N");
INSERT INTO portuguese_lemma VALUES ("r#00145571","r","assaz","N");
INSERT INTO portuguese_lemma VALUES ("v#00145623","v","arrendondar","N");
INSERT INTO portuguese_lemma VALUES ("v#00145623","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#00245305","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#00245987","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#00335506","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#00337013","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#00483753","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#01651565","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#01831830","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#01780161","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#01780295","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("v#01829006","v","acabar","N");
INSERT INTO portuguese_lemma VALUES ("r#00145854","r","insuficientemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00146138","v","revoltar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#02583139","v","revoltar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00146138","v","revoltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01233868","v","revoltar","N");
INSERT INTO portuguese_lemma VALUES ("v#02583139","v","revoltar","N");
INSERT INTO portuguese_lemma VALUES ("a#00146210","a","armado","N");
INSERT INTO portuguese_lemma VALUES ("a#01094647","a","armado","N");
INSERT INTO portuguese_lemma VALUES ("n#00094818","n","aproximação","N");
INSERT INTO portuguese_lemma VALUES ("n#00181376","n","aproximação","N");
INSERT INTO portuguese_lemma VALUES ("n#03727805","n","aproximação","N");
INSERT INTO portuguese_lemma VALUES ("n#05080213","n","aproximação","N");
INSERT INTO portuguese_lemma VALUES ("r#00146387","r","em_todo_o_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00146443","n","concatenação","N");
INSERT INTO portuguese_lemma VALUES ("n#14419737","n","concatenação","N");
INSERT INTO portuguese_lemma VALUES ("n#00095095","n","convergência","N");
INSERT INTO portuguese_lemma VALUES ("n#04512442","n","convergência","N");
INSERT INTO portuguese_lemma VALUES ("n#05518515","n","convergência","N");
INSERT INTO portuguese_lemma VALUES ("n#00095452","n","confluência","N");
INSERT INTO portuguese_lemma VALUES ("n#00095657","n","articulação","N");
INSERT INTO portuguese_lemma VALUES ("n#04335626","n","articulação","N");
INSERT INTO portuguese_lemma VALUES ("n#05297733","n","articulação","N");
INSERT INTO portuguese_lemma VALUES ("n#10024799","n","articulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00147454","n","junção","N");
INSERT INTO portuguese_lemma VALUES ("n#00245212","n","junção","N");
INSERT INTO portuguese_lemma VALUES ("n#02882380","n","junção","N");
INSERT INTO portuguese_lemma VALUES ("n#10024799","n","junção","N");
INSERT INTO portuguese_lemma VALUES ("n#00095872","n","fixação","N");
INSERT INTO portuguese_lemma VALUES ("n#00276342","n","fixação","N");
INSERT INTO portuguese_lemma VALUES ("r#00147597","r","de_mãos_dadas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00245166","r","de_mãos_dadas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00100153","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#00342164","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#00273227","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#00301476","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#00301772","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#00683670","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#01300040","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#01342394","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#01342612","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#01345838","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#01978199","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#02038145","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#02229828","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("v#01883959","v","cair","N");
INSERT INTO portuguese_lemma VALUES ("r#00147876","r","fàcilmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00149802","a","ardiloso","N");
INSERT INTO portuguese_lemma VALUES ("a#00149802","a","Tricky","N");
INSERT INTO portuguese_lemma VALUES ("a#00149802","a","esperto","N");
INSERT INTO portuguese_lemma VALUES ("a#00408224","a","esperto","N");
INSERT INTO portuguese_lemma VALUES ("a#00149802","a","ladino","N");
INSERT INTO portuguese_lemma VALUES ("n#06967282","n","ladino","N");
INSERT INTO portuguese_lemma VALUES ("n#06968052","n","ladino","N");
INSERT INTO portuguese_lemma VALUES ("n#00148446","n","laqueadura","N");
INSERT INTO portuguese_lemma VALUES ("v#00100649","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00103366","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00152762","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00104349","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00160197","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00163072","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00164129","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00164725","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00167516","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00167689","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00182381","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00182537","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00298808","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00429968","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00300708","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00301476","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00433778","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00302438","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00308251","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00308615","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#01393615","v","diminuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00100649","v","cair_do_alto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00148540","r","como_que","Y");
INSERT INTO portuguese_lemma VALUES ("r#00148540","r","como_se","Y");
INSERT INTO portuguese_lemma VALUES ("v#00148597","v","apaixonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00148597","v","enamorar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00148597","v","enamorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00148597","v","apaixonar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00150132","a","precioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00217004","a","precioso","N");
INSERT INTO portuguese_lemma VALUES ("a#02381427","a","precioso","N");
INSERT INTO portuguese_lemma VALUES ("a#02381899","a","precioso","N");
INSERT INTO portuguese_lemma VALUES ("a#02382040","a","precioso","N");
INSERT INTO portuguese_lemma VALUES ("a#02463724","a","precioso","N");
INSERT INTO portuguese_lemma VALUES ("v#00100922","v","suspender","N");
INSERT INTO portuguese_lemma VALUES ("v#00246783","v","suspender","N");
INSERT INTO portuguese_lemma VALUES ("v#00253202","v","suspender","N");
INSERT INTO portuguese_lemma VALUES ("v#00254265","v","suspender","N");
INSERT INTO portuguese_lemma VALUES ("v#00254764","v","suspender","N");
INSERT INTO portuguese_lemma VALUES ("v#00379293","v","suspender","N");
INSERT INTO portuguese_lemma VALUES ("r#00148869","r","efetivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00326324","r","efetivamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00149084","n","ligatura","N");
INSERT INTO portuguese_lemma VALUES ("n#07272084","n","ligatura","N");
INSERT INTO portuguese_lemma VALUES ("n#00149508","n","soldagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00149508","n","soldadura","N");
INSERT INTO portuguese_lemma VALUES ("v#00101662","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#01064160","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#01268426","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#01775973","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#01811792","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#01867419","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#02734338","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#02744820","v","estar","N");
INSERT INTO portuguese_lemma VALUES ("v#00150287","v","adequar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01841631","v","adequar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00150287","v","adaptar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01841631","v","adaptar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00150287","v","ajustar","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","ajustar","N");
INSERT INTO portuguese_lemma VALUES ("v#00204190","v","ajustar","N");
INSERT INTO portuguese_lemma VALUES ("v#00297780","v","ajustar","N");
INSERT INTO portuguese_lemma VALUES ("v#00205442","v","ajustar","N");
INSERT INTO portuguese_lemma VALUES ("v#00206945","v","ajustar","N");
INSERT INTO portuguese_lemma VALUES ("v#00336188","v","ajustar","N");
INSERT INTO portuguese_lemma VALUES ("a#00152252","a","expressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00464568","a","expressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00684959","a","expressivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00152252","a","eloqüente","N");
INSERT INTO portuguese_lemma VALUES ("a#00152252","a","eloquente","N");
INSERT INTO portuguese_lemma VALUES ("r#00150925","r","generalizado","N");
INSERT INTO portuguese_lemma VALUES ("n#00151087","n","detecção","N");
INSERT INTO portuguese_lemma VALUES ("n#04412425","n","detecção","N");
INSERT INTO portuguese_lemma VALUES ("n#06281175","n","detecção","N");
INSERT INTO portuguese_lemma VALUES ("v#00102974","v","proporcionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00336566","v","proporcionar","N");
INSERT INTO portuguese_lemma VALUES ("v#02744451","v","proporcionar","N");
INSERT INTO portuguese_lemma VALUES ("r#00151305","r","afinal","N");
INSERT INTO portuguese_lemma VALUES ("n#00098543","n","achado","N");
INSERT INTO portuguese_lemma VALUES ("n#04475449","n","achado","N");
INSERT INTO portuguese_lemma VALUES ("v#00103366","v","decrescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00182381","v","decrescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00433778","v","decrescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00103366","v","desabar","N");
INSERT INTO portuguese_lemma VALUES ("v#01989053","v","desabar","N");
INSERT INTO portuguese_lemma VALUES ("v#00103366","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00160073","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167689","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00182381","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00300708","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00433778","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00302438","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("v#00308615","v","minguar","N");
INSERT INTO portuguese_lemma VALUES ("r#00151755","r","numa_palavra","Y");
INSERT INTO portuguese_lemma VALUES ("r#00151755","r","em_suma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00151755","r","na_sua_generalidade","Y");
INSERT INTO portuguese_lemma VALUES ("a#00153592","a","mudo","N");
INSERT INTO portuguese_lemma VALUES ("a#00153705","a","mudo","N");
INSERT INTO portuguese_lemma VALUES ("a#00154331","a","mudo","N");
INSERT INTO portuguese_lemma VALUES ("a#00154702","a","mudo","N");
INSERT INTO portuguese_lemma VALUES ("n#10342367","n","mudo","N");
INSERT INTO portuguese_lemma VALUES ("a#00153592","a","muda","N");
INSERT INTO portuguese_lemma VALUES ("n#00360143","n","muda","N");
INSERT INTO portuguese_lemma VALUES ("n#00151914","n","redescoberta","N");
INSERT INTO portuguese_lemma VALUES ("n#00098857","n","identificação","N");
INSERT INTO portuguese_lemma VALUES ("n#03644161","n","identificação","N");
INSERT INTO portuguese_lemma VALUES ("n#04445171","n","identificação","N");
INSERT INTO portuguese_lemma VALUES ("n#05152743","n","identificação","N");
INSERT INTO portuguese_lemma VALUES ("n#05153252","n","identificação","N");
INSERT INTO portuguese_lemma VALUES ("v#00152558","v","encolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00164388","v","encolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00219644","v","encolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00873632","v","encolher","N");
INSERT INTO portuguese_lemma VALUES ("a#00154702","a","calado","N");
INSERT INTO portuguese_lemma VALUES ("n#05135155","n","calado","N");
INSERT INTO portuguese_lemma VALUES ("n#00152727","n","diagnose","N");
INSERT INTO portuguese_lemma VALUES ("n#00152727","n","diagnóstico","N");
INSERT INTO portuguese_lemma VALUES ("n#00153105","n","diagnóstico","N");
INSERT INTO portuguese_lemma VALUES ("v#00104349","v","baixar","N");
INSERT INTO portuguese_lemma VALUES ("v#00273227","v","baixar","N");
INSERT INTO portuguese_lemma VALUES ("v#00301476","v","baixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01341375","v","baixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01343131","v","baixar","N");
INSERT INTO portuguese_lemma VALUES ("v#02233704","v","baixar","N");
INSERT INTO portuguese_lemma VALUES ("v#00104505","v","desaparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00293522","v","desaparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00421917","v","desaparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00297331","v","desaparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00427397","v","desaparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00297825","v","desaparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01475232","v","desaparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00104604","v","ampliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00377885","v","ampliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00104604","v","progredir","N");
INSERT INTO portuguese_lemma VALUES ("v#00169694","v","progredir","N");
INSERT INTO portuguese_lemma VALUES ("v#00252019","v","progredir","N");
INSERT INTO portuguese_lemma VALUES ("v#01360914","v","progredir","N");
INSERT INTO portuguese_lemma VALUES ("r#00153372","r","à_sua_vontade","Y");
INSERT INTO portuguese_lemma VALUES ("a#00153410","a","articulado","N");
INSERT INTO portuguese_lemma VALUES ("n#00153499","n","diagnóstico_diferencial","Y");
INSERT INTO portuguese_lemma VALUES ("n#00153499","n","Diagnostico_diferencial","Y");
INSERT INTO portuguese_lemma VALUES ("r#00153568","r","cuidadosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00226133","r","cuidadosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00282103","r","cuidadosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00153665","n","prognóstico","N");
INSERT INTO portuguese_lemma VALUES ("n#05057929","n","prognóstico","N");
INSERT INTO portuguese_lemma VALUES ("n#05058536","n","prognóstico","N");
INSERT INTO portuguese_lemma VALUES ("n#05435037","n","prognóstico","N");
INSERT INTO portuguese_lemma VALUES ("n#00099792","n","resolução","N");
INSERT INTO portuguese_lemma VALUES ("n#00105760","n","resolução","N");
INSERT INTO portuguese_lemma VALUES ("n#00163047","n","resolução","N");
INSERT INTO portuguese_lemma VALUES ("n#00180228","n","resolução","N");
INSERT INTO portuguese_lemma VALUES ("n#03811208","n","resolução","N");
INSERT INTO portuguese_lemma VALUES ("n#04496054","n","resolução","N");
INSERT INTO portuguese_lemma VALUES ("n#04887532","n","resolução","N");
INSERT INTO portuguese_lemma VALUES ("a#00153898","a","envergonhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00497363","a","envergonhado","N");
INSERT INTO portuguese_lemma VALUES ("r#00154213","r","de_forma_segura","Y");
INSERT INTO portuguese_lemma VALUES ("r#00154213","r","com_segurança","Y");
INSERT INTO portuguese_lemma VALUES ("n#00154233","n","Métodos_de_autenticação","Y");
INSERT INTO portuguese_lemma VALUES ("n#00154233","n","certificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00154233","n","autentificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00154233","n","autenticação","N");
INSERT INTO portuguese_lemma VALUES ("n#06855035","n","autenticação","N");
INSERT INTO portuguese_lemma VALUES ("r#00154307","r","alegadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00154307","r","supostamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00154449","r","supostamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00100230","n","documentação","N");
INSERT INTO portuguese_lemma VALUES ("n#04859637","n","documentação","N");
INSERT INTO portuguese_lemma VALUES ("r#00154449","r","pretensamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00154536","r","ilegalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00157147","a","culpado","N");
INSERT INTO portuguese_lemma VALUES ("a#01268094","a","culpado","N");
INSERT INTO portuguese_lemma VALUES ("n#09633969","n","culpado","N");
INSERT INTO portuguese_lemma VALUES ("n#07469314","n","culpado","N");
INSERT INTO portuguese_lemma VALUES ("r#00154725","r","originalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00167286","r","originalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00431941","r","originalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00154885","r","comodamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00155020","r","comodamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00154885","r","confortavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00155020","r","confortavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00154885","r","de_maneira_agradável","Y");
INSERT INTO portuguese_lemma VALUES ("r#00219110","r","de_maneira_agradável","Y");
INSERT INTO portuguese_lemma VALUES ("v#01421708","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00106300","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00106442","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00106604","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00106728","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00108091","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00108725","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00219109","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00301246","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00301917","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#00388763","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01311485","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01922466","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01311898","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01922895","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01324807","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01333288","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01340005","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01969216","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01969779","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01341057","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01351334","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("v#01436021","v","subir","N");
INSERT INTO portuguese_lemma VALUES ("a#00155144","a","insolente","N");
INSERT INTO portuguese_lemma VALUES ("a#00204987","a","insolente","N");
INSERT INTO portuguese_lemma VALUES ("a#00205511","a","insolente","N");
INSERT INTO portuguese_lemma VALUES ("a#01923659","a","insolente","N");
INSERT INTO portuguese_lemma VALUES ("r#00155621","r","de_modo_geral","Y");
INSERT INTO portuguese_lemma VALUES ("a#00158104","a","sem_vergonha","Y");
INSERT INTO portuguese_lemma VALUES ("a#00158104","a","desavergonhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00158104","a","descarado","N");
INSERT INTO portuguese_lemma VALUES ("a#00158104","a","impúdico","N");
INSERT INTO portuguese_lemma VALUES ("v#00106728","v","elevar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00106728","v","altear","N");
INSERT INTO portuguese_lemma VALUES ("v#00106728","v","crescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00107371","v","crescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00108725","v","crescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00158081","v","crescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00158819","v","crescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00301917","v","crescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00302084","v","crescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00106728","v","avultar","N");
INSERT INTO portuguese_lemma VALUES ("v#00175935","v","avultar","N");
INSERT INTO portuguese_lemma VALUES ("v#00106728","v","acrescentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00107371","v","acrescentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00157347","v","acrescentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00125286","v","acrescentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00125912","v","acrescentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00274935","v","acrescentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00275224","v","acrescentar","N");
INSERT INTO portuguese_lemma VALUES ("r#00155893","r","de_memória","Y");
INSERT INTO portuguese_lemma VALUES ("r#00155893","r","de_cor","Y");
INSERT INTO portuguese_lemma VALUES ("a#00085707","a","assertivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00085707","a","peremptório","N");
INSERT INTO portuguese_lemma VALUES ("a#00667628","a","peremptório","N");
INSERT INTO portuguese_lemma VALUES ("n#00101756","n","indução","N");
INSERT INTO portuguese_lemma VALUES ("n#11468172","n","indução","N");
INSERT INTO portuguese_lemma VALUES ("r#00156496","r","de_viva_voz","Y");
INSERT INTO portuguese_lemma VALUES ("r#00156654","r","de_viva_voz","Y");
INSERT INTO portuguese_lemma VALUES ("r#00156496","r","oralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00156654","r","oralmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00158894","a","enfático","N");
INSERT INTO portuguese_lemma VALUES ("a#00842041","a","enfático","N");
INSERT INTO portuguese_lemma VALUES ("a#00158894","a","enérgico","N");
INSERT INTO portuguese_lemma VALUES ("a#00841934","a","enérgico","N");
INSERT INTO portuguese_lemma VALUES ("a#00873603","a","enérgico","N");
INSERT INTO portuguese_lemma VALUES ("n#00156625","n","instigação","N");
INSERT INTO portuguese_lemma VALUES ("n#00156812","n","coacção","N");
INSERT INTO portuguese_lemma VALUES ("n#01127245","n","coacção","N");
INSERT INTO portuguese_lemma VALUES ("n#00156812","n","coerção","N");
INSERT INTO portuguese_lemma VALUES ("n#00729616","n","coerção","N");
INSERT INTO portuguese_lemma VALUES ("n#00102269","n","efeito","N");
INSERT INTO portuguese_lemma VALUES ("n#07766144","n","efeito","N");
INSERT INTO portuguese_lemma VALUES ("n#07768053","n","efeito","N");
INSERT INTO portuguese_lemma VALUES ("n#07768179","n","efeito","N");
INSERT INTO portuguese_lemma VALUES ("a#00157389","a","associativa","N");
INSERT INTO portuguese_lemma VALUES ("a#00157389","a","associativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00102651","n","exposição_(saúde)","Y");
INSERT INTO portuguese_lemma VALUES ("r#00157811","r","incompletamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00157811","r","de_forma_incompleta","Y");
INSERT INTO portuguese_lemma VALUES ("a#00157925","a","empenhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00518164","a","empenhado","N");
INSERT INTO portuguese_lemma VALUES ("n#00157957","n","usurpação","N");
INSERT INTO portuguese_lemma VALUES ("r#00157967","r","sozinho","N");
INSERT INTO portuguese_lemma VALUES ("a#02143677","a","sozinho","N");
INSERT INTO portuguese_lemma VALUES ("r#00158309","r","certeiramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00158309","r","exactamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00158309","r","precisamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00204523","r","precisamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00204798","r","precisamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00368287","r","precisamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00109250","v","conglomerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00109250","v","amontoar","N");
INSERT INTO portuguese_lemma VALUES ("v#01576236","v","amontoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00109250","v","acumular","N");
INSERT INTO portuguese_lemma VALUES ("v#01032517","v","acumular","N");
INSERT INTO portuguese_lemma VALUES ("v#01518840","v","acumular","N");
INSERT INTO portuguese_lemma VALUES ("v#01849866","v","acumular","N");
INSERT INTO portuguese_lemma VALUES ("v#01576236","v","acumular","N");
INSERT INTO portuguese_lemma VALUES ("n#00158996","n","hipnotismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00158996","n","mesmerismo","N");
INSERT INTO portuguese_lemma VALUES ("r#00159040","r","por_exemplo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00159040","r","ex.","N");
INSERT INTO portuguese_lemma VALUES ("r#00159040","r","p._ex.","Y");
INSERT INTO portuguese_lemma VALUES ("r#00159040","r","como","N");
INSERT INTO portuguese_lemma VALUES ("a#01797633","a","como","N");
INSERT INTO portuguese_lemma VALUES ("v#00109701","v","incorrer","N");
INSERT INTO portuguese_lemma VALUES ("v#02721031","v","incorrer","N");
INSERT INTO portuguese_lemma VALUES ("n#00103541","n","tentação","N");
INSERT INTO portuguese_lemma VALUES ("n#04400046","n","tentação","N");
INSERT INTO portuguese_lemma VALUES ("n#05564760","n","tentação","N");
INSERT INTO portuguese_lemma VALUES ("r#00159889","r","do_início","Y");
INSERT INTO portuguese_lemma VALUES ("r#00159889","r","do_zero","Y");
INSERT INTO portuguese_lemma VALUES ("v#00110229","v","assimilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00110327","v","assimilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00406975","v","assimilar","N");
INSERT INTO portuguese_lemma VALUES ("n#00160415","n","sedução","N");
INSERT INTO portuguese_lemma VALUES ("n#00104245","n","sedução","N");
INSERT INTO portuguese_lemma VALUES ("n#03693301","n","sedução","N");
INSERT INTO portuguese_lemma VALUES ("a#00160425","a","apegado","N");
INSERT INTO portuguese_lemma VALUES ("r#00160440","r","rigorosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179112","r","rigorosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00160440","r","de_perto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00160440","r","perto","N");
INSERT INTO portuguese_lemma VALUES ("r#00160659","r","perto","N");
INSERT INTO portuguese_lemma VALUES ("a#00412848","a","perto","N");
INSERT INTO portuguese_lemma VALUES ("a#00162581","a","desvinculado","N");
INSERT INTO portuguese_lemma VALUES ("r#00160659","r","com_intimidade","Y");
INSERT INTO portuguese_lemma VALUES ("a#00162772","a","separado","N");
INSERT INTO portuguese_lemma VALUES ("a#02036455","a","separado","N");
INSERT INTO portuguese_lemma VALUES ("r#00160834","r","relativamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00160834","r","comparativamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00161018","r","de_forma_predominante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00161018","r","predominantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00161193","r","sem_dificuldades","Y");
INSERT INTO portuguese_lemma VALUES ("v#00111031","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("v#00111859","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("v#01545057","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("v#02258617","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("v#01630991","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("v#02394662","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("v#01639012","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("v#02406011","v","substituir","N");
INSERT INTO portuguese_lemma VALUES ("n#00104850","n","escolha","N");
INSERT INTO portuguese_lemma VALUES ("n#00163047","n","escolha","N");
INSERT INTO portuguese_lemma VALUES ("n#00118200","n","escolha","N");
INSERT INTO portuguese_lemma VALUES ("n#04462889","n","escolha","N");
INSERT INTO portuguese_lemma VALUES ("n#04463475","n","escolha","N");
INSERT INTO portuguese_lemma VALUES ("n#00104850","n","seleção","N");
INSERT INTO portuguese_lemma VALUES ("n#08399586","n","seleção","N");
INSERT INTO portuguese_lemma VALUES ("n#00104850","n","selecção","N");
INSERT INTO portuguese_lemma VALUES ("n#04462889","n","selecção","N");
INSERT INTO portuguese_lemma VALUES ("n#08399586","n","selecção","N");
INSERT INTO portuguese_lemma VALUES ("r#00161630","r","vagarosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00161630","r","devagar","N");
INSERT INTO portuguese_lemma VALUES ("a#00929061","a","devagar","N");
INSERT INTO portuguese_lemma VALUES ("r#00161630","r","lentamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00161888","n","técnicas_de_amostragem","Y");
INSERT INTO portuguese_lemma VALUES ("n#00161888","n","amostragem","N");
INSERT INTO portuguese_lemma VALUES ("r#00161932","r","em_público","Y");
INSERT INTO portuguese_lemma VALUES ("r#00161932","r","publicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00162765","r","publicamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00162083","a","removível","N");
INSERT INTO portuguese_lemma VALUES ("a#01526582","a","removível","N");
INSERT INTO portuguese_lemma VALUES ("a#00162083","a","destacável","N");
INSERT INTO portuguese_lemma VALUES ("r#00162137","r","de_forma_privada","Y");
INSERT INTO portuguese_lemma VALUES ("r#00162137","r","em_particular","Y");
INSERT INTO portuguese_lemma VALUES ("a#00164110","a","cauteloso","N");
INSERT INTO portuguese_lemma VALUES ("a#00317140","a","cauteloso","N");
INSERT INTO portuguese_lemma VALUES ("a#01468566","a","cauteloso","N");
INSERT INTO portuguese_lemma VALUES ("a#00164110","a","cauteloso(a)","N");
INSERT INTO portuguese_lemma VALUES ("a#00164110","a","cuidadoso(a)","N");
INSERT INTO portuguese_lemma VALUES ("n#00105760","n","decisão","N");
INSERT INTO portuguese_lemma VALUES ("n#03810995","n","decisão","N");
INSERT INTO portuguese_lemma VALUES ("n#04496054","n","decisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00163047","n","vontade","N");
INSERT INTO portuguese_lemma VALUES ("n#04371730","n","vontade","N");
INSERT INTO portuguese_lemma VALUES ("n#04589152","n","vontade","N");
INSERT INTO portuguese_lemma VALUES ("a#00163315","a","crédulo","N");
INSERT INTO portuguese_lemma VALUES ("a#00646413","a","crédulo","N");
INSERT INTO portuguese_lemma VALUES ("a#02272305","a","crédulo","N");
INSERT INTO portuguese_lemma VALUES ("a#02162641","a","crédulo","N");
INSERT INTO portuguese_lemma VALUES ("n#00163406","n","reviravolta","N");
INSERT INTO portuguese_lemma VALUES ("n#00163406","n","conversão","N");
INSERT INTO portuguese_lemma VALUES ("n#04471523","n","conversão","N");
INSERT INTO portuguese_lemma VALUES ("v#00112290","v","restaurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00164201","v","restaurar","N");
INSERT INTO portuguese_lemma VALUES ("v#01652221","v","restaurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00112290","v","renovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00112422","v","renovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00164201","v","renovar","N");
INSERT INTO portuguese_lemma VALUES ("v#01121382","v","renovar","N");
INSERT INTO portuguese_lemma VALUES ("a#00165320","a","atento","N");
INSERT INTO portuguese_lemma VALUES ("a#00166039","a","atento","N");
INSERT INTO portuguese_lemma VALUES ("a#00303585","a","atento","N");
INSERT INTO portuguese_lemma VALUES ("a#00317140","a","atento","N");
INSERT INTO portuguese_lemma VALUES ("a#01145007","a","atento","N");
INSERT INTO portuguese_lemma VALUES ("a#01977488","a","atento","N");
INSERT INTO portuguese_lemma VALUES ("n#00163630","n","adulteração","N");
INSERT INTO portuguese_lemma VALUES ("n#00751145","n","adulteração","N");
INSERT INTO portuguese_lemma VALUES ("n#14487443","n","adulteração","N");
INSERT INTO portuguese_lemma VALUES ("n#00106381","n","nomeação","N");
INSERT INTO portuguese_lemma VALUES ("n#00164152","n","nomeação","N");
INSERT INTO portuguese_lemma VALUES ("n#00106381","n","designação","N");
INSERT INTO portuguese_lemma VALUES ("n#00730247","n","designação","N");
INSERT INTO portuguese_lemma VALUES ("a#00163948","a","absorto","N");
INSERT INTO portuguese_lemma VALUES ("a#00163948","a","absorvido","N");
INSERT INTO portuguese_lemma VALUES ("a#02009166","a","absorvido","N");
INSERT INTO portuguese_lemma VALUES ("v#00164444","v","avivar","N");
INSERT INTO portuguese_lemma VALUES ("a#00166461","a","solícito","N");
INSERT INTO portuguese_lemma VALUES ("a#00510407","a","solícito","N");
INSERT INTO portuguese_lemma VALUES ("r#00164890","r","friamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00317390","r","friamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00165018","r","seriamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00166902","a","abstraído","N");
INSERT INTO portuguese_lemma VALUES ("a#00166902","a","ausente","N");
INSERT INTO portuguese_lemma VALUES ("a#01775263","a","ausente","N");
INSERT INTO portuguese_lemma VALUES ("n#09757653","n","ausente","N");
INSERT INTO portuguese_lemma VALUES ("n#00107544","n","Ordenação","N");
INSERT INTO portuguese_lemma VALUES ("n#00107544","n","Ordenação_religiosa","Y");
INSERT INTO portuguese_lemma VALUES ("v#00113548","v","consolidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00113716","v","consolidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00113869","v","consolidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00150444","v","consolidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00166039","v","consolidar","N");
INSERT INTO portuguese_lemma VALUES ("a#00165585","a","sonhador","N");
INSERT INTO portuguese_lemma VALUES ("a#00165766","a","sonolento","N");
INSERT INTO portuguese_lemma VALUES ("a#00188436","a","sonolento","N");
INSERT INTO portuguese_lemma VALUES ("a#00189092","a","sonolento","N");
INSERT INTO portuguese_lemma VALUES ("a#00189253","a","sonolento","N");
INSERT INTO portuguese_lemma VALUES ("n#00165793","n","imposição_das_mãos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00165793","n","Imposição_das_Mãos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00107819","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00108157","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00180278","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00280586","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00213412","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05283408","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05449557","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#06251839","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#07775426","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#10088697","n","movimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00107819","n","passo","N");
INSERT INTO portuguese_lemma VALUES ("n#00184779","n","passo","N");
INSERT INTO portuguese_lemma VALUES ("n#00185003","n","passo","N");
INSERT INTO portuguese_lemma VALUES ("n#00533922","n","passo","N");
INSERT INTO portuguese_lemma VALUES ("n#03948875","n","passo","N");
INSERT INTO portuguese_lemma VALUES ("n#09907411","n","passo","N");
INSERT INTO portuguese_lemma VALUES ("a#00165943","a","distraído","N");
INSERT INTO portuguese_lemma VALUES ("a#00165943","a","esquecido","N");
INSERT INTO portuguese_lemma VALUES ("a#01608465","a","esquecido","N");
INSERT INTO portuguese_lemma VALUES ("r#00166025","r","muito_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00166025","r","por_muito_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00167697","a","atraente","N");
INSERT INTO portuguese_lemma VALUES ("a#00216139","a","atraente","N");
INSERT INTO portuguese_lemma VALUES ("r#00166375","r","de_passagem","Y");
INSERT INTO portuguese_lemma VALUES ("n#00166552","n","roque","N");
INSERT INTO portuguese_lemma VALUES ("n#03523510","n","roque","N");
INSERT INTO portuguese_lemma VALUES ("n#00166552","n","fazerroque","N");
INSERT INTO portuguese_lemma VALUES ("n#00166865","n","en_passant","Y");
INSERT INTO portuguese_lemma VALUES ("v#00166952","v","desvitalizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00167077","a","carismático","N");
INSERT INTO portuguese_lemma VALUES ("a#00167077","a","carismática","N");
INSERT INTO portuguese_lemma VALUES ("a#00168739","a","linda","N");
INSERT INTO portuguese_lemma VALUES ("a#00168739","a","bonita","N");
INSERT INTO portuguese_lemma VALUES ("a#00215099","a","bonita","N");
INSERT INTO portuguese_lemma VALUES ("n#00167446","n","xeque","N");
INSERT INTO portuguese_lemma VALUES ("n#10588357","n","xeque","N");
INSERT INTO portuguese_lemma VALUES ("n#00167446","n","Xeque","N");
INSERT INTO portuguese_lemma VALUES ("n#10588357","n","Xeque","N");
INSERT INTO portuguese_lemma VALUES ("r#00167575","r","por_um_fio","Y");
INSERT INTO portuguese_lemma VALUES ("r#00167575","r","instante","N");
INSERT INTO portuguese_lemma VALUES ("n#10898122","n","instante","N");
INSERT INTO portuguese_lemma VALUES ("n#10952516","n","instante","N");
INSERT INTO portuguese_lemma VALUES ("n#10952736","n","instante","N");
INSERT INTO portuguese_lemma VALUES ("n#10953446","n","instante","N");
INSERT INTO portuguese_lemma VALUES ("n#10953688","n","instante","N");
INSERT INTO portuguese_lemma VALUES ("n#10953874","n","instante","N");
INSERT INTO portuguese_lemma VALUES ("a#00169076","a","chamativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00169076","a","interessante","N");
INSERT INTO portuguese_lemma VALUES ("a#00379463","a","interessante","N");
INSERT INTO portuguese_lemma VALUES ("a#01290353","a","interessante","N");
INSERT INTO portuguese_lemma VALUES ("a#02587936","a","interessante","N");
INSERT INTO portuguese_lemma VALUES ("n#00167764","n","xeque-mate","N");
INSERT INTO portuguese_lemma VALUES ("n#07475035","n","xeque-mate","N");
INSERT INTO portuguese_lemma VALUES ("r#00167920","r","debalde","N");
INSERT INTO portuguese_lemma VALUES ("r#00167920","r","em_vão","Y");
INSERT INTO portuguese_lemma VALUES ("r#00168075","r","em_vão","Y");
INSERT INTO portuguese_lemma VALUES ("r#00167920","r","inutilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00195786","r","inutilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00491438","r","inutilmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00168505","n","estacionamento","N");
INSERT INTO portuguese_lemma VALUES ("n#08615638","n","estacionamento","N");
INSERT INTO portuguese_lemma VALUES ("n#13778671","n","estacionamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00168505","n","parques_de_estacionamento","Y");
INSERT INTO portuguese_lemma VALUES ("n#08615638","n","parques_de_estacionamento","Y");
INSERT INTO portuguese_lemma VALUES ("n#08615810","n","parques_de_estacionamento","Y");
INSERT INTO portuguese_lemma VALUES ("a#00168551","a","irresistível","N");
INSERT INTO portuguese_lemma VALUES ("a#01917404","a","irresistível","N");
INSERT INTO portuguese_lemma VALUES ("a#01917639","a","irresistível","N");
INSERT INTO portuguese_lemma VALUES ("v#00168588","v","restituir","N");
INSERT INTO portuguese_lemma VALUES ("n#00717034","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#00125689","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#00195415","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#00128676","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#00128951","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#00213518","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#00256334","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#05441797","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#07297633","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#05467031","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#07355194","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#05481414","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#05519358","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#11412727","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("n#09984639","n","mudança","N");
INSERT INTO portuguese_lemma VALUES ("a#00168820","a","fotogênico","N");
INSERT INTO portuguese_lemma VALUES ("a#00168820","a","fotogénico","N");
INSERT INTO portuguese_lemma VALUES ("v#00168910","v","reviver","N");
INSERT INTO portuguese_lemma VALUES ("v#00169298","v","reviver","N");
INSERT INTO portuguese_lemma VALUES ("r#00169312","r","de_forma_confidencial","Y");
INSERT INTO portuguese_lemma VALUES ("r#00169312","r","confidencialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00169659","r","em_media","Y");
INSERT INTO portuguese_lemma VALUES ("a#00169955","a","magnético","N");
INSERT INTO portuguese_lemma VALUES ("a#01469677","a","magnético","N");
INSERT INTO portuguese_lemma VALUES ("a#01470298","a","magnético","N");
INSERT INTO portuguese_lemma VALUES ("a#01470813","a","magnético","N");
INSERT INTO portuguese_lemma VALUES ("a#02926188","a","magnético","N");
INSERT INTO portuguese_lemma VALUES ("a#00169955","a","atrativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00539391","v","atrativo","N");
INSERT INTO portuguese_lemma VALUES ("a#02097480","a","atrativo","N");
INSERT INTO portuguese_lemma VALUES ("r#00169971","r","hipoteticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00170045","r","teoricamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00170188","r","teoricamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00170412","r","ao_contrário","Y");
INSERT INTO portuguese_lemma VALUES ("r#00170412","r","mas","N");
INSERT INTO portuguese_lemma VALUES ("r#00170412","r","pelo_contrário","Y");
INSERT INTO portuguese_lemma VALUES ("v#00170500","v","sincopar","N");
INSERT INTO portuguese_lemma VALUES ("v#00317086","v","sincopar","N");
INSERT INTO portuguese_lemma VALUES ("v#00170695","v","actualizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00170857","v","actualizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00170695","v","tornar_atual","Y");
INSERT INTO portuguese_lemma VALUES ("v#00170857","v","atualizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00117331","v","qualificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00136387","v","qualificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00207831","v","qualificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00111216","n","artimanha","N");
INSERT INTO portuguese_lemma VALUES ("n#00172490","n","artimanha","N");
INSERT INTO portuguese_lemma VALUES ("n#00172598","n","artimanha","N");
INSERT INTO portuguese_lemma VALUES ("n#00485559","n","artimanha","N");
INSERT INTO portuguese_lemma VALUES ("n#05065985","n","artimanha","N");
INSERT INTO portuguese_lemma VALUES ("r#00171322","r","na_direção","Y");
INSERT INTO portuguese_lemma VALUES ("a#00171447","a","não_atrativo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00171457","r","na_hora","Y");
INSERT INTO portuguese_lemma VALUES ("r#00171457","r","pontualmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00171458","v","modular","N");
INSERT INTO portuguese_lemma VALUES ("v#00206759","v","modular","N");
INSERT INTO portuguese_lemma VALUES ("v#00982293","v","modular","N");
INSERT INTO portuguese_lemma VALUES ("a#02296415","a","modular","N");
INSERT INTO portuguese_lemma VALUES ("n#00171507","n","mnemônica","N");
INSERT INTO portuguese_lemma VALUES ("v#00117675","v","enriquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00151781","v","enriquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01584550","v","enriquecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00171872","a","atribuível","N");
INSERT INTO portuguese_lemma VALUES ("r#00172020","r","correctamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00203922","r","correctamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00205375","r","correctamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00172073","n","finta","N");
INSERT INTO portuguese_lemma VALUES ("v#00172505","v","optimizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00172598","n","maracutaia","N");
INSERT INTO portuguese_lemma VALUES ("n#00111872","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#00112599","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#02202438","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#02560468","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#02644452","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#03489162","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#02851548","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#02859502","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#02975720","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#03516946","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#04516672","n","ferramenta","N");
INSERT INTO portuguese_lemma VALUES ("n#00111872","n","modo","N");
INSERT INTO portuguese_lemma VALUES ("n#05134016","n","modo","N");
INSERT INTO portuguese_lemma VALUES ("n#09939326","n","modo","N");
INSERT INTO portuguese_lemma VALUES ("n#00111872","n","maneira","N");
INSERT INTO portuguese_lemma VALUES ("n#03835766","n","maneira","N");
INSERT INTO portuguese_lemma VALUES ("n#03856995","n","maneira","N");
INSERT INTO portuguese_lemma VALUES ("n#04930478","n","maneira","N");
INSERT INTO portuguese_lemma VALUES ("n#03858557","n","maneira","N");
INSERT INTO portuguese_lemma VALUES ("n#00111872","n","jeito","N");
INSERT INTO portuguese_lemma VALUES ("n#03858557","n","jeito","N");
INSERT INTO portuguese_lemma VALUES ("v#00118443","v","privar","N");
INSERT INTO portuguese_lemma VALUES ("v#00813536","v","privar","N");
INSERT INTO portuguese_lemma VALUES ("v#01580892","v","privar","N");
INSERT INTO portuguese_lemma VALUES ("v#01581572","v","privar","N");
INSERT INTO portuguese_lemma VALUES ("r#00172980","r","corajosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00173220","a","grávida","N");
INSERT INTO portuguese_lemma VALUES ("a#00173391","a","grávida","N");
INSERT INTO portuguese_lemma VALUES ("a#00173220","a","grávido","N");
INSERT INTO portuguese_lemma VALUES ("a#00173220","a","prenha","N");
INSERT INTO portuguese_lemma VALUES ("v#00118898","v","remover","N");
INSERT INTO portuguese_lemma VALUES ("v#00122604","v","remover","N");
INSERT INTO portuguese_lemma VALUES ("v#00133485","v","remover","N");
INSERT INTO portuguese_lemma VALUES ("v#00118898","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00120982","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00121492","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00122191","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00122353","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00122604","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00571596","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00544143","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00847385","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01351170","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01434278","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00993032","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00997005","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00997134","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00998398","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01054290","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01096854","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01108327","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01266515","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01422262","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#02097800","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#02101789","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01579864","v","tirar","N");
INSERT INTO portuguese_lemma VALUES ("r#00173353","r","profundamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00305570","r","profundamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00173498","r","impacientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00173644","r","pacientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00173644","r","de_forma_paciente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00112599","n","instrumento","N");
INSERT INTO portuguese_lemma VALUES ("n#02560468","n","instrumento","N");
INSERT INTO portuguese_lemma VALUES ("n#02851548","n","instrumento","N");
INSERT INTO portuguese_lemma VALUES ("n#02859502","n","instrumento","N");
INSERT INTO portuguese_lemma VALUES ("n#03025339","n","instrumento","N");
INSERT INTO portuguese_lemma VALUES ("n#03516946","n","instrumento","N");
INSERT INTO portuguese_lemma VALUES ("n#06471345","n","instrumento","N");
INSERT INTO portuguese_lemma VALUES ("a#00173764","a","audível","N");
INSERT INTO portuguese_lemma VALUES ("n#00112808","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#02159544","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#02758863","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03306610","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03519578","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03519981","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03092396","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03096023","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03243979","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03245327","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03426653","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#04426618","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03525842","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#03600463","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("n#06348591","n","estrada","N");
INSERT INTO portuguese_lemma VALUES ("r#00174232","r","instavelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00174782","n","abraço_de_urso","Y");
INSERT INTO portuguese_lemma VALUES ("n#00175174","n","Leveraged_buyout","Y");
INSERT INTO portuguese_lemma VALUES ("n#00175174","n","Leveraged_Buyout","Y");
INSERT INTO portuguese_lemma VALUES ("a#00175300","a","ultrassônico","N");
INSERT INTO portuguese_lemma VALUES ("a#00175887","a","ultrassônico","N");
INSERT INTO portuguese_lemma VALUES ("a#00175300","a","supersônico","N");
INSERT INTO portuguese_lemma VALUES ("a#00175887","a","supersônico","N");
INSERT INTO portuguese_lemma VALUES ("r#00175344","r","estupidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00175490","r","de_forma_única","Y");
INSERT INTO portuguese_lemma VALUES ("r#00175778","r","assimetricamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00175919","r","reciprocamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00405645","r","reciprocamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00405868","r","reciprocamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00175919","r","de_forma_recíproca","Y");
INSERT INTO portuguese_lemma VALUES ("a#00176908","a","auspicioso","N");
INSERT INTO portuguese_lemma VALUES ("r#00176253","r","distalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00176327","v","extirpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01079137","v","extirpar","N");
INSERT INTO portuguese_lemma VALUES ("v#01662118","v","extirpar","N");
INSERT INTO portuguese_lemma VALUES ("r#00176383","r","pesadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00176880","r","repetidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00176981","r","repetidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00176880","r","de_forma_repetida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00176981","r","várias_e_várias_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("v#00177243","v","desnudar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00177243","v","despir-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00177289","r","fortemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00428245","r","fortemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00115902","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#01185611","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#00783240","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#04015246","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#04015405","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#04015637","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#04015786","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#05408794","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("n#09598145","n","recurso","N");
INSERT INTO portuguese_lemma VALUES ("r#00177686","r","vice_versa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00177686","r","vice-versa","N");
INSERT INTO portuguese_lemma VALUES ("v#00121172","v","descascar","N");
INSERT INTO portuguese_lemma VALUES ("v#00861277","v","descascar","N");
INSERT INTO portuguese_lemma VALUES ("r#00178028","r","semana_após_semana","Y");
INSERT INTO portuguese_lemma VALUES ("a#00178126","a","agourento","N");
INSERT INTO portuguese_lemma VALUES ("n#10224446","n","agourento","N");
INSERT INTO portuguese_lemma VALUES ("a#00178126","a","ameaçador","N");
INSERT INTO portuguese_lemma VALUES ("a#00194152","a","ameaçador","N");
INSERT INTO portuguese_lemma VALUES ("r#00178342","r","radicalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00178460","r","religiosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00178586","r","religiosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00178464","a","ensurdecedor","N");
INSERT INTO portuguese_lemma VALUES ("a#00306034","a","ensurdecedor","N");
INSERT INTO portuguese_lemma VALUES ("a#01453467","a","ensurdecedor","N");
INSERT INTO portuguese_lemma VALUES ("v#00121956","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00122077","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00122353","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00124529","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00340120","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00571596","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01351170","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01352390","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01434278","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01485513","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01054290","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01079137","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01108327","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01266515","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01360709","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#02097800","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#01579864","v","sacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00122191","v","arrancar","N");
INSERT INTO portuguese_lemma VALUES ("a#00179586","a","aprovado","N");
INSERT INTO portuguese_lemma VALUES ("r#00179112","r","puramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179112","r","estritamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179212","r","experimentalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179333","r","por_outras_palavras","Y");
INSERT INTO portuguese_lemma VALUES ("r#00179442","r","frouxamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179442","r","relaxadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179442","r","de_forma_relaxada","Y");
INSERT INTO portuguese_lemma VALUES ("r#00179677","r","desnecessariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00195786","r","desnecessariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00408498","r","desnecessariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00179807","r","graciosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00180449","a","constitucional","N");
INSERT INTO portuguese_lemma VALUES ("a#00856863","a","constitucional","N");
INSERT INTO portuguese_lemma VALUES ("a#02550238","a","constitucional","N");
INSERT INTO portuguese_lemma VALUES ("r#00180057","r","habilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00185172","r","habilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00180057","r","caprichosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00180057","r","com_capricho","Y");
INSERT INTO portuguese_lemma VALUES ("a#00180211","a","inconstitucional","N");
INSERT INTO portuguese_lemma VALUES ("r#00180279","r","delicadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00181576","r","delicadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00502847","r","delicadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00180420","r","em_troca","Y");
INSERT INTO portuguese_lemma VALUES ("r#00405868","r","em_troca","Y");
INSERT INTO portuguese_lemma VALUES ("r#00180420","r","por_sua_vez","Y");
INSERT INTO portuguese_lemma VALUES ("r#00180611","r","independentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00450647","r","independentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00118200","n","eleição","N");
INSERT INTO portuguese_lemma VALUES ("n#00118873","n","eleição","N");
INSERT INTO portuguese_lemma VALUES ("n#00183505","n","eleição","N");
INSERT INTO portuguese_lemma VALUES ("n#04463475","n","eleição","N");
INSERT INTO portuguese_lemma VALUES ("a#00181030","a","que_dá_continuaçãoa_si_mesmo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00182244","a","heterogêneo","N");
INSERT INTO portuguese_lemma VALUES ("a#01149134","a","heterogêneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00182244","a","heterogênea","N");
INSERT INTO portuguese_lemma VALUES ("a#01149134","a","heterogênea","N");
INSERT INTO portuguese_lemma VALUES ("n#00181373","n","reeleição","N");
INSERT INTO portuguese_lemma VALUES ("a#00182347","a","automático","N");
INSERT INTO portuguese_lemma VALUES ("a#01439795","a","automático","N");
INSERT INTO portuguese_lemma VALUES ("a#02400554","a","automático","N");
INSERT INTO portuguese_lemma VALUES ("a#02401195","a","automático","N");
INSERT INTO portuguese_lemma VALUES ("n#00181495","n","plebiscito","N");
INSERT INTO portuguese_lemma VALUES ("n#00181495","n","referendo","N");
INSERT INTO portuguese_lemma VALUES ("n#00118732","n","referendo","N");
INSERT INTO portuguese_lemma VALUES ("v#00124529","v","retirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00133485","v","retirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01549420","v","retirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01580390","v","retirar","N");
INSERT INTO portuguese_lemma VALUES ("n#00118732","n","referendum","N");
INSERT INTO portuguese_lemma VALUES ("v#00124634","v","desobstruir","N");
INSERT INTO portuguese_lemma VALUES ("r#00181676","r","no_estrangeiro","Y");
INSERT INTO portuguese_lemma VALUES ("r#00181676","r","no_exterior","Y");
INSERT INTO portuguese_lemma VALUES ("r#00181748","r","espertamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00181748","r","vigorosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00181748","r","astutamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00181875","v","fazer_barulho_ou_algazarra","Y");
INSERT INTO portuguese_lemma VALUES ("v#00181875","v","encher_desordenadamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00181875","v","abarrotar","N");
INSERT INTO portuguese_lemma VALUES ("a#00181904","a","semiautomático","N");
INSERT INTO portuguese_lemma VALUES ("r#00182094","r","in_vivo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00182199","r","positivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00511573","r","positivamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00119067","n","votação","N");
INSERT INTO portuguese_lemma VALUES ("n#00183505","n","votação","N");
INSERT INTO portuguese_lemma VALUES ("v#00125167","v","transbordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00125167","v","desbordar","N");
INSERT INTO portuguese_lemma VALUES ("r#00182316","r","de_forma_excelente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00182316","r","excelentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00182316","r","com_excelência","Y");
INSERT INTO portuguese_lemma VALUES ("v#00125286","v","adicionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00642843","v","adicionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01805970","v","adicionar","N");
INSERT INTO portuguese_lemma VALUES ("v#02745172","v","adicionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00125286","v","somar","N");
INSERT INTO portuguese_lemma VALUES ("v#00125912","v","somar","N");
INSERT INTO portuguese_lemma VALUES ("v#00432790","v","somar","N");
INSERT INTO portuguese_lemma VALUES ("v#00642843","v","somar","N");
INSERT INTO portuguese_lemma VALUES ("n#00182571","n","Eleição_primária","Y");
INSERT INTO portuguese_lemma VALUES ("a#00183402","a","manual","N");
INSERT INTO portuguese_lemma VALUES ("a#02434158","a","manual","N");
INSERT INTO portuguese_lemma VALUES ("a#02584677","a","manual","N");
INSERT INTO portuguese_lemma VALUES ("n#06421301","n","manual","N");
INSERT INTO portuguese_lemma VALUES ("n#04840046","n","manual","N");
INSERT INTO portuguese_lemma VALUES ("a#00183612","a","disponível","N");
INSERT INTO portuguese_lemma VALUES ("a#00184637","a","disponível","N");
INSERT INTO portuguese_lemma VALUES ("a#00185066","a","disponível","N");
INSERT INTO portuguese_lemma VALUES ("a#00740788","a","disponível","N");
INSERT INTO portuguese_lemma VALUES ("r#00183090","r","maravilhosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00183505","n","voto","N");
INSERT INTO portuguese_lemma VALUES ("n#07228751","n","voto","N");
INSERT INTO portuguese_lemma VALUES ("v#00126016","v","incluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00462038","v","incluir","N");
INSERT INTO portuguese_lemma VALUES ("v#01796443","v","incluir","N");
INSERT INTO portuguese_lemma VALUES ("v#01798079","v","incluir","N");
INSERT INTO portuguese_lemma VALUES ("v#01842330","v","incluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00126217","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00274169","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00275528","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00972191","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00972429","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01002550","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01003100","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01003383","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01003631","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01003753","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01009511","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01138007","v","misturar","N");
INSERT INTO portuguese_lemma VALUES ("a#00184637","a","que_está_por_vir","Y");
INSERT INTO portuguese_lemma VALUES ("a#00184637","a","que_está_por_aparecer","Y");
INSERT INTO portuguese_lemma VALUES ("a#00184637","a","que_vem","Y");
INSERT INTO portuguese_lemma VALUES ("a#00184637","a","a_ser_lançado","Y");
INSERT INTO portuguese_lemma VALUES ("a#00184637","a","a_ser_publicado","Y");
INSERT INTO portuguese_lemma VALUES ("r#00184284","r","reconhecidamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00184362","n","voto_secreto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00184363","a","obtenível","N");
INSERT INTO portuguese_lemma VALUES ("a#00184363","a","adquirível","N");
INSERT INTO portuguese_lemma VALUES ("a#00185607","a","adquirível","N");
INSERT INTO portuguese_lemma VALUES ("r#00184530","r","racionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00184778","r","de_forma_crítica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00184778","r","criticamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00185066","a","visível","N");
INSERT INTO portuguese_lemma VALUES ("a#01643240","a","visível","N");
INSERT INTO portuguese_lemma VALUES ("a#02394546","a","visível","N");
INSERT INTO portuguese_lemma VALUES ("n#00184981","n","Voto_de_minerva","Y");
INSERT INTO portuguese_lemma VALUES ("n#00184981","n","Voto_de_Minerva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00185172","r","competentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00185172","r","de_forma_competente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00185172","r","acertadamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00121609","n","equação","N");
INSERT INTO portuguese_lemma VALUES ("n#05001502","n","equação","N");
INSERT INTO portuguese_lemma VALUES ("r#00185567","r","emocionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00185670","r","emocionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00185607","a","comprável","N");
INSERT INTO portuguese_lemma VALUES ("a#00185607","a","à_venda","Y");
INSERT INTO portuguese_lemma VALUES ("n#00185778","n","cesariana","N");
INSERT INTO portuguese_lemma VALUES ("n#00185778","n","cesárea","N");
INSERT INTO portuguese_lemma VALUES ("a#00185921","a","indisponível","N");
INSERT INTO portuguese_lemma VALUES ("r#00185970","r","ansiosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00186193","a","não_adquirível","Y");
INSERT INTO portuguese_lemma VALUES ("r#00186366","r","formalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00186491","r","formalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00538149","a","desperto","N");
INSERT INTO portuguese_lemma VALUES ("a#00538149","a","acordado","N");
INSERT INTO portuguese_lemma VALUES ("a#00187443","a","acordado","N");
INSERT INTO portuguese_lemma VALUES ("r#00187028","r","agradavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00219110","r","agradavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00187028","r","de_forma_bela","Y");
INSERT INTO portuguese_lemma VALUES ("r#00187028","r","belamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00242006","r","belamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00187028","r","gentilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00218479","r","gentilmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00187337","n","gol","N");
INSERT INTO portuguese_lemma VALUES ("n#00187499","n","gol-contra","N");
INSERT INTO portuguese_lemma VALUES ("n#00187499","n","autogolo","N");
INSERT INTO portuguese_lemma VALUES ("n#00187499","n","gol_contra","Y");
INSERT INTO portuguese_lemma VALUES ("v#00128702","v","confinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00889308","v","confinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00128702","v","inserir","N");
INSERT INTO portuguese_lemma VALUES ("v#00974668","v","inserir","N");
INSERT INTO portuguese_lemma VALUES ("v#00128702","v","introduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00610889","v","introduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00611179","v","introduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00974668","v","introduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01112995","v","introduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01423096","v","introduzir","N");
INSERT INTO portuguese_lemma VALUES ("a#00187821","a","adormecido","N");
INSERT INTO portuguese_lemma VALUES ("n#00188449","n","touchback","N");
INSERT INTO portuguese_lemma VALUES ("r#00188510","r","a_saber","Y");
INSERT INTO portuguese_lemma VALUES ("r#00188510","r","isto_é","Y");
INSERT INTO portuguese_lemma VALUES ("n#00188766","n","Touchdown","N");
INSERT INTO portuguese_lemma VALUES ("r#00188779","r","com_entusiasmo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00188779","r","entusiasticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00456484","r","entusiasticamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00188934","n","Golo_de_campo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00189092","a","com_sono","Y");
INSERT INTO portuguese_lemma VALUES ("a#00189092","a","dorminhoco","N");
INSERT INTO portuguese_lemma VALUES ("n#10611541","n","dorminhoco","N");
INSERT INTO portuguese_lemma VALUES ("r#00189401","r","um_dia","Y");
INSERT INTO portuguese_lemma VALUES ("n#00124616","n","corrida","N");
INSERT INTO portuguese_lemma VALUES ("n#00190535","n","corrida","N");
INSERT INTO portuguese_lemma VALUES ("n#00449295","n","corrida","N");
INSERT INTO portuguese_lemma VALUES ("n#05544480","n","corrida","N");
INSERT INTO portuguese_lemma VALUES ("n#05556140","n","corrida","N");
INSERT INTO portuguese_lemma VALUES ("a#00189580","a","adstringente","N");
INSERT INTO portuguese_lemma VALUES ("a#02369027","a","adstringente","N");
INSERT INTO portuguese_lemma VALUES ("a#00189833","a","hemostático","N");
INSERT INTO portuguese_lemma VALUES ("r#00189846","r","orgulhosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00189896","n","corrida_limpa","Y");
INSERT INTO portuguese_lemma VALUES ("v#00190023","v","pontuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00190023","v","marcar_ponto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00190115","a","ciente","N");
INSERT INTO portuguese_lemma VALUES ("a#00190115","a","informado","N");
INSERT INTO portuguese_lemma VALUES ("n#00190180","n","corrida_impulsionada","Y");
INSERT INTO portuguese_lemma VALUES ("v#00130632","v","concatenar","N");
INSERT INTO portuguese_lemma VALUES ("v#01465054","v","concatenar","N");
INSERT INTO portuguese_lemma VALUES ("n#00125430","n","cesta","N");
INSERT INTO portuguese_lemma VALUES ("n#02259850","n","cesta","N");
INSERT INTO portuguese_lemma VALUES ("n#03127925","n","cesta","N");
INSERT INTO portuguese_lemma VALUES ("v#00190682","v","ser_causa_de","Y");
INSERT INTO portuguese_lemma VALUES ("v#00190682","v","ativar","N");
INSERT INTO portuguese_lemma VALUES ("v#00190682","v","produzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00986409","v","produzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01114991","v","produzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01128460","v","produzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01189395","v","produzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01799148","v","produzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00190682","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#00986409","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#01111638","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#01128460","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#01130277","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#01131041","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#01131307","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#01799148","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("v#01583087","v","causar","N");
INSERT INTO portuguese_lemma VALUES ("n#00190931","n","roleta_russa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00190959","r","intensamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00125689","n","troca","N");
INSERT INTO portuguese_lemma VALUES ("n#00719653","n","troca","N");
INSERT INTO portuguese_lemma VALUES ("n#00755465","n","troca","N");
INSERT INTO portuguese_lemma VALUES ("v#00191220","v","biodegradar","N");
INSERT INTO portuguese_lemma VALUES ("a#00190958","a","sensato","N");
INSERT INTO portuguese_lemma VALUES ("a#01825807","a","sensato","N");
INSERT INTO portuguese_lemma VALUES ("a#02569558","a","sensato","N");
INSERT INTO portuguese_lemma VALUES ("v#00191517","v","desativar","N");
INSERT INTO portuguese_lemma VALUES ("v#00191517","v","desactivar","N");
INSERT INTO portuguese_lemma VALUES ("r#00191656","r","sustentadamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00191940","v","reativar","N");
INSERT INTO portuguese_lemma VALUES ("v#00192051","v","amortecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00153724","v","amortecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01576917","v","amortecer","N");
INSERT INTO portuguese_lemma VALUES ("v#02191311","v","amortecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00192051","v","enfraquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00153724","v","enfraquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00270123","v","enfraquecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00192149","n","percolação","N");
INSERT INTO portuguese_lemma VALUES ("n#00126290","n","simplificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00785705","n","simplificação","N");
INSERT INTO portuguese_lemma VALUES ("a#00192332","a","inconsciente","N");
INSERT INTO portuguese_lemma VALUES ("a#00538832","a","inconsciente","N");
INSERT INTO portuguese_lemma VALUES ("a#02400554","a","inconsciente","N");
INSERT INTO portuguese_lemma VALUES ("n#05613274","n","inconsciente","N");
INSERT INTO portuguese_lemma VALUES ("v#00192471","v","petrificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00507485","v","petrificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00126393","n","economia","N");
INSERT INTO portuguese_lemma VALUES ("n#03832817","n","economia","N");
INSERT INTO portuguese_lemma VALUES ("n#04365547","n","economia","N");
INSERT INTO portuguese_lemma VALUES ("n#06149484","n","economia","N");
INSERT INTO portuguese_lemma VALUES ("n#06193947","n","economia","N");
INSERT INTO portuguese_lemma VALUES ("r#00192986","r","peloroubo","N");
INSERT INTO portuguese_lemma VALUES ("r#00192986","r","matreiramente","N");
INSERT INTO portuguese_lemma VALUES ("r#00192986","r","sorrateiramente","N");
INSERT INTO portuguese_lemma VALUES ("a#00192906","a","alarmante","N");
INSERT INTO portuguese_lemma VALUES ("a#00192906","a","inquietante","N");
INSERT INTO portuguese_lemma VALUES ("n#00193225","n","Acomodação","N");
INSERT INTO portuguese_lemma VALUES ("a#00193234","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#00193347","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#00193648","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#00195313","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01079225","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01127147","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01080562","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01450767","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01529876","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01677200","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01731616","a","horrível","N");
INSERT INTO portuguese_lemma VALUES ("n#00127097","n","personalização","N");
INSERT INTO portuguese_lemma VALUES ("n#00127097","n","adaptação","N");
INSERT INTO portuguese_lemma VALUES ("n#09743067","n","adaptação","N");
INSERT INTO portuguese_lemma VALUES ("a#00193347","a","abominável","N");
INSERT INTO portuguese_lemma VALUES ("a#01079225","a","abominável","N");
INSERT INTO portuguese_lemma VALUES ("a#01084054","a","abominável","N");
INSERT INTO portuguese_lemma VALUES ("a#01460421","a","abominável","N");
INSERT INTO portuguese_lemma VALUES ("a#01460679","a","abominável","N");
INSERT INTO portuguese_lemma VALUES ("a#00193347","a","atroz","N");
INSERT INTO portuguese_lemma VALUES ("a#01079225","a","atroz","N");
INSERT INTO portuguese_lemma VALUES ("a#01084054","a","atroz","N");
INSERT INTO portuguese_lemma VALUES ("a#02514380","a","atroz","N");
INSERT INTO portuguese_lemma VALUES ("v#00133085","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#00184548","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#00927388","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#00946301","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#00947309","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#00949234","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#01137704","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#02024716","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#01518840","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#01576236","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#01576416","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#02428924","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#01682716","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#01772676","v","reunir","N");
INSERT INTO portuguese_lemma VALUES ("v#00133085","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00166214","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00166362","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00257011","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00881999","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00884615","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00885494","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00927388","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#01490958","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#01595830","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#02024508","v","unir","N");
INSERT INTO portuguese_lemma VALUES ("v#00133085","v","combinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00274169","v","combinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01002550","v","combinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01813355","v","combinar","N");
INSERT INTO portuguese_lemma VALUES ("v#02658734","v","combinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01841936","v","combinar","N");
INSERT INTO portuguese_lemma VALUES ("r#00193652","r","visivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00382287","r","visivelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00193648","a","medonho","N");
INSERT INTO portuguese_lemma VALUES ("a#00193648","a","terrível","N");
INSERT INTO portuguese_lemma VALUES ("a#00194690","a","terrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01079225","a","terrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01448254","a","terrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01450767","a","terrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01567385","a","terrível","N");
INSERT INTO portuguese_lemma VALUES ("a#01731616","a","terrível","N");
INSERT INTO portuguese_lemma VALUES ("a#00193648","a","temível","N");
INSERT INTO portuguese_lemma VALUES ("a#00193648","a","calamitoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00193648","a","temido","N");
INSERT INTO portuguese_lemma VALUES ("a#00193648","a","pavoroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01731616","a","pavoroso","N");
INSERT INTO portuguese_lemma VALUES ("r#00194156","r","atenciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00196417","r","atenciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00216788","r","atenciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00217105","r","atenciosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00194170","v","ordenhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01164906","v","ordenhar","N");
INSERT INTO portuguese_lemma VALUES ("n#00194257","n","domesticação","N");
INSERT INTO portuguese_lemma VALUES ("n#04905842","n","domesticação","N");
INSERT INTO portuguese_lemma VALUES ("n#13468954","n","domesticação","N");
INSERT INTO portuguese_lemma VALUES ("a#00194152","a","ominoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00133485","v","desmantelar","N");
INSERT INTO portuguese_lemma VALUES ("v#01657977","v","desmantelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00133485","v","desmanchar","N");
INSERT INTO portuguese_lemma VALUES ("v#01113462","v","desmanchar","N");
INSERT INTO portuguese_lemma VALUES ("v#01657977","v","desmanchar","N");
INSERT INTO portuguese_lemma VALUES ("r#00194578","r","severamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00194817","a","pesadelar","N");
INSERT INTO portuguese_lemma VALUES ("n#00127976","n","Habituação","N");
INSERT INTO portuguese_lemma VALUES ("a#00194690","a","assustador","N");
INSERT INTO portuguese_lemma VALUES ("a#00968522","a","assustador","N");
INSERT INTO portuguese_lemma VALUES ("n#00128096","n","variação","N");
INSERT INTO portuguese_lemma VALUES ("n#05441797","n","variação","N");
INSERT INTO portuguese_lemma VALUES ("n#05467031","n","variação","N");
INSERT INTO portuguese_lemma VALUES ("r#00195024","r","regularmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00195024","r","muitasvezes","N");
INSERT INTO portuguese_lemma VALUES ("a#00194887","a","horripilante","N");
INSERT INTO portuguese_lemma VALUES ("r#00195342","r","universalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00195428","r","idealmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00195542","r","mal","N");
INSERT INTO portuguese_lemma VALUES ("n#03802516","n","mal","N");
INSERT INTO portuguese_lemma VALUES ("n#10257548","n","mal","N");
INSERT INTO portuguese_lemma VALUES ("r#00195542","r","erradamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00204125","r","erradamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00128403","n","diversificação","N");
INSERT INTO portuguese_lemma VALUES ("a#00195313","a","macabro","N");
INSERT INTO portuguese_lemma VALUES ("r#00195786","r","sem_necessidade","Y");
INSERT INTO portuguese_lemma VALUES ("a#00196122","a","cabeludo","N");
INSERT INTO portuguese_lemma VALUES ("a#00196122","a","perigoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00614072","a","perigoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01981873","a","perigoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02059811","a","perigoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01983358","a","perigoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00196203","r","devidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00196203","r","decentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00247194","r","decentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00285447","r","decentemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00134645","v","atear_fogo","Y");
INSERT INTO portuguese_lemma VALUES ("v#02760139","v","atear_fogo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00134645","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00262798","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00263602","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00303520","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00820086","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("v#02760139","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("v#01887716","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("v#01891783","v","queimar","N");
INSERT INTO portuguese_lemma VALUES ("r#00196417","r","atentamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00128951","n","substituição_(processos_químicos)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00128951","n","substituição","N");
INSERT INTO portuguese_lemma VALUES ("n#00197772","n","substituição","N");
INSERT INTO portuguese_lemma VALUES ("n#09742155","n","substituição","N");
INSERT INTO portuguese_lemma VALUES ("r#00196692","r","generosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00279867","r","generosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00196758","v","escaldar","N");
INSERT INTO portuguese_lemma VALUES ("r#00196999","r","sem_esforço","Y");
INSERT INTO portuguese_lemma VALUES ("r#00196999","r","com_desenvoltura","Y");
INSERT INTO portuguese_lemma VALUES ("r#00196999","r","facilmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00197182","r","horas","N");
INSERT INTO portuguese_lemma VALUES ("r#00197275","r","detalhadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00197275","r","em_detalhes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00197395","r","favoravelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230444","r","favoravelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00197395","r","auspiciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230444","r","auspiciosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00197423","v","desossar","N");
INSERT INTO portuguese_lemma VALUES ("a#00197124","a","angustiante","N");
INSERT INTO portuguese_lemma VALUES ("a#00197124","a","preocupante","N");
INSERT INTO portuguese_lemma VALUES ("r#00197561","r","desfavoravelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230581","r","desfavoravelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00197561","r","inconvenientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230581","r","inconvenientemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00197590","v","desvicerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00197590","v","destripar","N");
INSERT INTO portuguese_lemma VALUES ("v#00197590","v","desentranhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00197590","v","estripar","N");
INSERT INTO portuguese_lemma VALUES ("v#01590747","v","estripar","N");
INSERT INTO portuguese_lemma VALUES ("r#00197710","r","conjuntamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00197710","r","em_conjunto","Y");
INSERT INTO portuguese_lemma VALUES ("n#00197772","n","reposição","N");
INSERT INTO portuguese_lemma VALUES ("a#00197773","a","mais_hindmost","Y");
INSERT INTO portuguese_lemma VALUES ("r#00198039","r","por_todos_os_lados","Y");
INSERT INTO portuguese_lemma VALUES ("a#00198023","a","avançado","N");
INSERT INTO portuguese_lemma VALUES ("a#01159832","a","avançado","N");
INSERT INTO portuguese_lemma VALUES ("a#01840121","a","avançado","N");
INSERT INTO portuguese_lemma VALUES ("n#00130078","n","ascenção","N");
INSERT INTO portuguese_lemma VALUES ("n#07370410","n","ascenção","N");
INSERT INTO portuguese_lemma VALUES ("n#00130078","n","promoção","N");
INSERT INTO portuguese_lemma VALUES ("n#01117723","n","promoção","N");
INSERT INTO portuguese_lemma VALUES ("n#05409803","n","promoção","N");
INSERT INTO portuguese_lemma VALUES ("n#05412651","n","promoção","N");
INSERT INTO portuguese_lemma VALUES ("v#00198477","v","escalpelar","N");
INSERT INTO portuguese_lemma VALUES ("r#00198661","r","por_acinte","Y");
INSERT INTO portuguese_lemma VALUES ("r#00198661","r","por_desafio","Y");
INSERT INTO portuguese_lemma VALUES ("r#00198845","r","obstinadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00198845","r","teimosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00198850","v","mitigar","N");
INSERT INTO portuguese_lemma VALUES ("v#00613501","v","mitigar","N");
INSERT INTO portuguese_lemma VALUES ("n#00199130","n","mudança_de_estado","Y");
INSERT INTO portuguese_lemma VALUES ("v#00136387","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#00233203","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#00160443","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#00162075","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#00236104","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#00162692","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#00236843","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#01650267","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#01710417","v","restringir","N");
INSERT INTO portuguese_lemma VALUES ("v#00136514","v","refazer","N");
INSERT INTO portuguese_lemma VALUES ("v#01113920","v","refazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00136514","v","reconstruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00428736","v","reconstruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01137221","v","reconstruir","N");
INSERT INTO portuguese_lemma VALUES ("r#00199565","r","timidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00228910","r","timidamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00136665","v","corrigir","N");
INSERT INTO portuguese_lemma VALUES ("v#00426161","v","corrigir","N");
INSERT INTO portuguese_lemma VALUES ("v#00136665","v","retificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00136863","v","retificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00673648","v","retificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00131083","n","ajuste","N");
INSERT INTO portuguese_lemma VALUES ("n#07176804","n","ajuste","N");
INSERT INTO portuguese_lemma VALUES ("n#00131083","n","modificação","N");
INSERT INTO portuguese_lemma VALUES ("n#03008076","n","modificação","N");
INSERT INTO portuguese_lemma VALUES ("n#05441797","n","modificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00131083","n","alteração","N");
INSERT INTO portuguese_lemma VALUES ("n#05441797","n","alteração","N");
INSERT INTO portuguese_lemma VALUES ("v#00136863","v","rectificar","N");
INSERT INTO portuguese_lemma VALUES ("r#00200243","r","tomara","N");
INSERT INTO portuguese_lemma VALUES ("r#00200243","r","esperançoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00200243","r","esperançosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00200243","r","oxalá","N");
INSERT INTO portuguese_lemma VALUES ("v#00137111","v","redigir","N");
INSERT INTO portuguese_lemma VALUES ("v#00671763","v","redigir","N");
INSERT INTO portuguese_lemma VALUES ("r#00200614","r","sem_esperanças","Y");
INSERT INTO portuguese_lemma VALUES ("v#00201034","v","expurgar","N");
INSERT INTO portuguese_lemma VALUES ("v#00201034","v","abreviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00243749","v","abreviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00166656","v","abreviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167181","v","abreviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00201632","v","abreviar","N");
INSERT INTO portuguese_lemma VALUES ("v#00317241","v","abreviar","N");
INSERT INTO portuguese_lemma VALUES ("n#00131763","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#02176672","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#02504113","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#03092682","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#04824319","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#04824539","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#04892853","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#07310642","n","passagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00131763","n","transição","N");
INSERT INTO portuguese_lemma VALUES ("n#00201397","n","transição","N");
INSERT INTO portuguese_lemma VALUES ("n#04825097","n","transição","N");
INSERT INTO portuguese_lemma VALUES ("n#05480908","n","transição","N");
INSERT INTO portuguese_lemma VALUES ("n#05519358","n","transição","N");
INSERT INTO portuguese_lemma VALUES ("r#00201195","r","brutalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00201195","r","de_forma_brutal","Y");
INSERT INTO portuguese_lemma VALUES ("v#00201407","v","interpolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00642644","v","interpolar","N");
INSERT INTO portuguese_lemma VALUES ("r#00201570","r","sabiamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00132095","n","transferência","N");
INSERT INTO portuguese_lemma VALUES ("n#00204553","n","transferência","N");
INSERT INTO portuguese_lemma VALUES ("n#00718330","n","transferência","N");
INSERT INTO portuguese_lemma VALUES ("n#06247181","n","transferência","N");
INSERT INTO portuguese_lemma VALUES ("a#00201961","a","inverso","N");
INSERT INTO portuguese_lemma VALUES ("a#00202115","a","inverso","N");
INSERT INTO portuguese_lemma VALUES ("a#01877763","a","inverso","N");
INSERT INTO portuguese_lemma VALUES ("a#02270178","a","inverso","N");
INSERT INTO portuguese_lemma VALUES ("a#02467982","a","inverso","N");
INSERT INTO portuguese_lemma VALUES ("r#00202028","r","inteligentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00202028","r","de_forma_inteligente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00132311","n","oposição","N");
INSERT INTO portuguese_lemma VALUES ("n#00757904","n","oposição","N");
INSERT INTO portuguese_lemma VALUES ("n#08404188","n","oposição","N");
INSERT INTO portuguese_lemma VALUES ("n#09960784","n","oposição","N");
INSERT INTO portuguese_lemma VALUES ("n#09981153","n","oposição","N");
INSERT INTO portuguese_lemma VALUES ("n#00202620","n","Lockout","N");
INSERT INTO portuguese_lemma VALUES ("n#00132807","n","resistência","N");
INSERT INTO portuguese_lemma VALUES ("n#00757531","n","resistência","N");
INSERT INTO portuguese_lemma VALUES ("n#00132807","n","reação","N");
INSERT INTO portuguese_lemma VALUES ("n#00551220","n","reação","N");
INSERT INTO portuguese_lemma VALUES ("r#00202833","r","em_ordem_alfabética","Y");
INSERT INTO portuguese_lemma VALUES ("r#00202833","r","alfabeticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00203201","r","diplomaticamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00139258","v","abusar","N");
INSERT INTO portuguese_lemma VALUES ("v#01715663","v","abusar","N");
INSERT INTO portuguese_lemma VALUES ("n#00133315","n","rejeição","N");
INSERT INTO portuguese_lemma VALUES ("n#04463201","n","rejeição","N");
INSERT INTO portuguese_lemma VALUES ("n#11505318","n","rejeição","N");
INSERT INTO portuguese_lemma VALUES ("n#00203753","n","evitação","N");
INSERT INTO portuguese_lemma VALUES ("n#00203753","n","sorteio","N");
INSERT INTO portuguese_lemma VALUES ("r#00203783","r","de_forma_indefinida","Y");
INSERT INTO portuguese_lemma VALUES ("r#00203783","r","indefinidamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00139555","v","decair","N");
INSERT INTO portuguese_lemma VALUES ("v#00139972","v","decair","N");
INSERT INTO portuguese_lemma VALUES ("v#00399074","v","decair","N");
INSERT INTO portuguese_lemma VALUES ("r#00203922","r","de_forma_correta","Y");
INSERT INTO portuguese_lemma VALUES ("r#00203922","r","corretamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00204125","r","erroneamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00204125","r","incorretamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00336065","r","incorretamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00204494","a","tímido","N");
INSERT INTO portuguese_lemma VALUES ("a#00331296","a","tímido","N");
INSERT INTO portuguese_lemma VALUES ("a#00204494","a","recatado","N");
INSERT INTO portuguese_lemma VALUES ("a#01476902","a","recatado","N");
INSERT INTO portuguese_lemma VALUES ("n#00134056","n","abandono","N");
INSERT INTO portuguese_lemma VALUES ("n#00134056","n","desamparo","N");
INSERT INTO portuguese_lemma VALUES ("r#00204523","r","de_forma_acurada","Y");
INSERT INTO portuguese_lemma VALUES ("r#00204523","r","justamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00204798","r","justamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00205226","r","justamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00368287","r","justamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00204814","n","apostasia","N");
INSERT INTO portuguese_lemma VALUES ("n#10342469","n","apostasia","N");
INSERT INTO portuguese_lemma VALUES ("r#00204906","r","de_forma_errada","Y");
INSERT INTO portuguese_lemma VALUES ("r#00204906","r","de_forma_injusta","Y");
INSERT INTO portuguese_lemma VALUES ("n#00134568","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#00139061","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#00139768","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#04887366","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#05384981","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#05414101","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#05414335","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#05414453","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("n#10342469","n","renúncia","N");
INSERT INTO portuguese_lemma VALUES ("a#00205511","a","espevitada","N");
INSERT INTO portuguese_lemma VALUES ("a#00205511","a","atrevido","N");
INSERT INTO portuguese_lemma VALUES ("a#02169249","a","atrevido","N");
INSERT INTO portuguese_lemma VALUES ("a#00205511","a","impertinente","N");
INSERT INTO portuguese_lemma VALUES ("a#02169249","a","impertinente","N");
INSERT INTO portuguese_lemma VALUES ("r#00205561","r","injustamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00285266","r","injustamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00134937","n","abnegação","N");
INSERT INTO portuguese_lemma VALUES ("n#01205961","n","abnegação","N");
INSERT INTO portuguese_lemma VALUES ("a#00205696","a","presunçoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00330582","a","presunçoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00589448","a","presunçoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01818024","a","presunçoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00140937","v","aperfeiçoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00329781","v","aperfeiçoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00329953","v","aperfeiçoar","N");
INSERT INTO portuguese_lemma VALUES ("n#00135125","n","forfeit","N");
INSERT INTO portuguese_lemma VALUES ("n#00206130","n","Boicotes","N");
INSERT INTO portuguese_lemma VALUES ("n#00206130","n","boicote","N");
INSERT INTO portuguese_lemma VALUES ("n#00206302","n","proscrição","N");
INSERT INTO portuguese_lemma VALUES ("n#00206302","n","banimento","N");
INSERT INTO portuguese_lemma VALUES ("n#14427633","n","banimento","N");
INSERT INTO portuguese_lemma VALUES ("r#00206749","r","sem","N");
INSERT INTO portuguese_lemma VALUES ("r#00462520","r","sem","N");
INSERT INTO portuguese_lemma VALUES ("n#00135765","n","exclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00254500","n","exclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#04409604","n","exclusão","N");
INSERT INTO portuguese_lemma VALUES ("r#00207127","r","financeiramente","N");
INSERT INTO portuguese_lemma VALUES ("v#00207184","v","melhorar_algo_antigo_ou_ultrapassado","Y");
INSERT INTO portuguese_lemma VALUES ("n#00207306","n","deportação","N");
INSERT INTO portuguese_lemma VALUES ("n#00136174","n","deportação","N");
INSERT INTO portuguese_lemma VALUES ("n#00207434","n","ostracismo","N");
INSERT INTO portuguese_lemma VALUES ("n#14427633","n","ostracismo","N");
INSERT INTO portuguese_lemma VALUES ("r#00207668","r","individualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00207668","r","em_separado","Y");
INSERT INTO portuguese_lemma VALUES ("r#00207668","r","separadamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00207728","v","baratear","N");
INSERT INTO portuguese_lemma VALUES ("v#00207728","v","desvalorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00315020","v","desvalorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00493703","v","desvalorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00493929","v","desvalorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00207728","v","barganhar","N");
INSERT INTO portuguese_lemma VALUES ("v#02259547","v","barganhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00207728","v","rebaixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01228249","v","rebaixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01800422","v","rebaixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01228705","v","rebaixar","N");
INSERT INTO portuguese_lemma VALUES ("v#01343131","v","rebaixar","N");
INSERT INTO portuguese_lemma VALUES ("n#00136174","n","exílio","N");
INSERT INTO portuguese_lemma VALUES ("v#00142397","v","emendar","N");
INSERT INTO portuguese_lemma VALUES ("v#00177962","v","emendar","N");
INSERT INTO portuguese_lemma VALUES ("v#00673648","v","emendar","N");
INSERT INTO portuguese_lemma VALUES ("v#00208055","v","resolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00429256","v","resolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00429804","v","resolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00471542","v","resolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00472610","v","resolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00472976","v","resolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00497027","v","resolver","N");
INSERT INTO portuguese_lemma VALUES ("n#00208141","n","Captividade_Babilônica","Y");
INSERT INTO portuguese_lemma VALUES ("v#00142648","v","agravar","N");
INSERT INTO portuguese_lemma VALUES ("v#00142648","v","exacerbar","N");
INSERT INTO portuguese_lemma VALUES ("v#01242326","v","exacerbar","N");
INSERT INTO portuguese_lemma VALUES ("n#00208277","n","excomunhão","N");
INSERT INTO portuguese_lemma VALUES ("n#14413993","n","excomunhão","N");
INSERT INTO portuguese_lemma VALUES ("r#00208390","r","proeminentemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00208749","a","sobreposto","N");
INSERT INTO portuguese_lemma VALUES ("a#00208749","a","superposto","N");
INSERT INTO portuguese_lemma VALUES ("n#00208943","n","deposição","N");
INSERT INTO portuguese_lemma VALUES ("n#00208943","n","deposição_(poluição)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00136859","n","suspensão","N");
INSERT INTO portuguese_lemma VALUES ("n#00657170","n","suspensão","N");
INSERT INTO portuguese_lemma VALUES ("n#01063578","n","suspensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03450747","n","suspensão","N");
INSERT INTO portuguese_lemma VALUES ("n#05486628","n","suspensão","N");
INSERT INTO portuguese_lemma VALUES ("n#10093359","n","suspensão","N");
INSERT INTO portuguese_lemma VALUES ("n#10969750","n","suspensão","N");
INSERT INTO portuguese_lemma VALUES ("r#00209381","r","cordialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00219855","r","cordialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00432314","r","cordialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00209518","r","impudentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00366490","r","impudentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00209518","r","desavergonhadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00366490","r","desavergonhadamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00209546","n","veto","N");
INSERT INTO portuguese_lemma VALUES ("n#05198928","n","veto","N");
INSERT INTO portuguese_lemma VALUES ("a#00209620","a","coberto_de_relva","Y");
INSERT INTO portuguese_lemma VALUES ("v#00209837","v","apodrecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00399553","v","apodrecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00209837","v","putrefazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00210259","v","putrefazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00399074","v","putrefazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00399553","v","putrefazer","N");
INSERT INTO portuguese_lemma VALUES ("v#00552815","v","putrefazer","N");
INSERT INTO portuguese_lemma VALUES ("n#00137299","n","termino","N");
INSERT INTO portuguese_lemma VALUES ("n#00137299","n","conclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00035222","n","conclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#04822648","n","conclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#05059980","n","conclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#05438121","n","conclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#10966461","n","conclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#10966797","n","conclusão","N");
INSERT INTO portuguese_lemma VALUES ("v#00210259","v","estragar","N");
INSERT INTO portuguese_lemma VALUES ("v#00258665","v","estragar","N");
INSERT INTO portuguese_lemma VALUES ("v#00263044","v","estragar","N");
INSERT INTO portuguese_lemma VALUES ("v#00320369","v","estragar","N");
INSERT INTO portuguese_lemma VALUES ("v#00332972","v","estragar","N");
INSERT INTO portuguese_lemma VALUES ("r#00210446","r","suavemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00458454","r","suavemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00210446","r","sem_problemas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00210651","r","gratuitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00258175","r","gratuitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00350704","r","gratuitamente","N");
INSERT INTO portuguese_lemma VALUES ("a#02399130","a","gratuitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00210651","r","livremente","N");
INSERT INTO portuguese_lemma VALUES ("a#00210484","a","careca","N");
INSERT INTO portuguese_lemma VALUES ("a#00210484","a","calvo","N");
INSERT INTO portuguese_lemma VALUES ("r#00210935","r","rotineiramente","N");
INSERT INTO portuguese_lemma VALUES ("a#00211026","a","calvejante","N");
INSERT INTO portuguese_lemma VALUES ("r#00211061","r","costumeiramente","N");
INSERT INTO portuguese_lemma VALUES ("a#00211092","a","imberbe","N");
INSERT INTO portuguese_lemma VALUES ("a#02153620","a","imberbe","N");
INSERT INTO portuguese_lemma VALUES ("a#00211092","a","glabro","N");
INSERT INTO portuguese_lemma VALUES ("a#02153620","a","glabro","N");
INSERT INTO portuguese_lemma VALUES ("n#00035222","n","culminação","N");
INSERT INTO portuguese_lemma VALUES ("n#15291199","n","culminação","N");
INSERT INTO portuguese_lemma VALUES ("n#00035222","n","finalização","N");
INSERT INTO portuguese_lemma VALUES ("a#00211221","a","depilatório","N");
INSERT INTO portuguese_lemma VALUES ("r#00211517","r","espiritualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00211815","r","indistintamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00212173","a","peludo","N");
INSERT INTO portuguese_lemma VALUES ("a#02309917","a","peludo","N");
INSERT INTO portuguese_lemma VALUES ("a#00212173","a","peluda","N");
INSERT INTO portuguese_lemma VALUES ("n#00138644","n","aposentadoria","N");
INSERT INTO portuguese_lemma VALUES ("n#10054148","n","aposentadoria","N");
INSERT INTO portuguese_lemma VALUES ("v#00145116","v","conservar","N");
INSERT INTO portuguese_lemma VALUES ("v#01522764","v","conservar","N");
INSERT INTO portuguese_lemma VALUES ("v#01829600","v","conservar","N");
INSERT INTO portuguese_lemma VALUES ("v#02682567","v","conservar","N");
INSERT INTO portuguese_lemma VALUES ("v#00145116","v","preservar","N");
INSERT INTO portuguese_lemma VALUES ("v#01522764","v","preservar","N");
INSERT INTO portuguese_lemma VALUES ("n#00212678","n","canção_do_cisne","Y");
INSERT INTO portuguese_lemma VALUES ("v#00212790","v","desidratar","N");
INSERT INTO portuguese_lemma VALUES ("r#00212974","r","periodicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00213052","n","cessão","N");
INSERT INTO portuguese_lemma VALUES ("v#00213223","v","salgar","N");
INSERT INTO portuguese_lemma VALUES ("v#00213353","v","salgar","N");
INSERT INTO portuguese_lemma VALUES ("v#02196214","v","salgar","N");
INSERT INTO portuguese_lemma VALUES ("r#00213301","r","incrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00244787","r","incrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00295825","r","incrivelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00213482","n","extradição","N");
INSERT INTO portuguese_lemma VALUES ("r#00213524","r","impressionantemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00139768","n","desistência","N");
INSERT INTO portuguese_lemma VALUES ("v#00213794","v","enlatar","N");
INSERT INTO portuguese_lemma VALUES ("v#00213794","v","pôr_em_conserva","Y");
INSERT INTO portuguese_lemma VALUES ("n#00213903","n","imunidade","N");
INSERT INTO portuguese_lemma VALUES ("n#05033906","n","imunidade","N");
INSERT INTO portuguese_lemma VALUES ("n#14526764","n","imunidade","N");
INSERT INTO portuguese_lemma VALUES ("n#14527171","n","imunidade","N");
INSERT INTO portuguese_lemma VALUES ("v#00214020","v","hidratar","N");
INSERT INTO portuguese_lemma VALUES ("v#00214407","v","hidratar","N");
INSERT INTO portuguese_lemma VALUES ("v#00215800","v","hidratar","N");
INSERT INTO portuguese_lemma VALUES ("r#00214554","r","de_forma_extravagante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00214554","r","copiosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00214554","r","de_forma_copiosa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00214554","r","abundantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00279867","r","abundantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00214761","r","interessantemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00146425","v","molhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00156574","v","molhar","N");
INSERT INTO portuguese_lemma VALUES ("r#00215237","r","moderadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00215517","r","de_forma_realista","Y");
INSERT INTO portuguese_lemma VALUES ("r#00215661","r","de_forma_não_realista","Y");
INSERT INTO portuguese_lemma VALUES ("n#00215683","n","deitarporterra","N");
INSERT INTO portuguese_lemma VALUES ("v#00215800","v","umidificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00215838","n","subversão","N");
INSERT INTO portuguese_lemma VALUES ("n#00216038","n","protelação","N");
INSERT INTO portuguese_lemma VALUES ("n#00140714","n","demissão","N");
INSERT INTO portuguese_lemma VALUES ("n#07254456","n","demissão","N");
INSERT INTO portuguese_lemma VALUES ("v#00147396","v","demolhar","N");
INSERT INTO portuguese_lemma VALUES ("r#00216485","r","supremamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00216668","a","lanoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01154351","a","lanoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00216834","n","expurgo","N");
INSERT INTO portuguese_lemma VALUES ("r#00216964","r","desconsideradamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00141128","n","devastação","N");
INSERT INTO portuguese_lemma VALUES ("n#00967157","n","devastação","N");
INSERT INTO portuguese_lemma VALUES ("n#05465992","n","devastação","N");
INSERT INTO portuguese_lemma VALUES ("n#10441658","n","devastação","N");
INSERT INTO portuguese_lemma VALUES ("n#00141128","n","destruição","N");
INSERT INTO portuguese_lemma VALUES ("n#05465405","n","destruição","N");
INSERT INTO portuguese_lemma VALUES ("n#10442122","n","destruição","N");
INSERT INTO portuguese_lemma VALUES ("a#00217075","a","barbado","N");
INSERT INTO portuguese_lemma VALUES ("a#00217075","a","barbudo","N");
INSERT INTO portuguese_lemma VALUES ("r#00217105","r","pensativamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00148162","v","inundar","N");
INSERT INTO portuguese_lemma VALUES ("v#00148514","v","inundar","N");
INSERT INTO portuguese_lemma VALUES ("v#01047899","v","inundar","N");
INSERT INTO portuguese_lemma VALUES ("n#00141434","n","desastre","N");
INSERT INTO portuguese_lemma VALUES ("n#05452645","n","desastre","N");
INSERT INTO portuguese_lemma VALUES ("n#10384515","n","desastre","N");
INSERT INTO portuguese_lemma VALUES ("a#00215099","a","bela","N");
INSERT INTO portuguese_lemma VALUES ("a#00215099","a","bonito","N");
INSERT INTO portuguese_lemma VALUES ("a#00216235","a","bonito","N");
INSERT INTO portuguese_lemma VALUES ("a#00217241","a","bonito","N");
INSERT INTO portuguese_lemma VALUES ("a#00215099","a","lindo","N");
INSERT INTO portuguese_lemma VALUES ("a#00216139","a","lindo","N");
INSERT INTO portuguese_lemma VALUES ("a#00215099","a","belo","N");
INSERT INTO portuguese_lemma VALUES ("a#00215694","a","belo","N");
INSERT INTO portuguese_lemma VALUES ("a#00215099","a","formoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00217004","a","formoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00141690","n","ruína","N");
INSERT INTO portuguese_lemma VALUES ("n#03261457","n","ruína","N");
INSERT INTO portuguese_lemma VALUES ("n#05465857","n","ruína","N");
INSERT INTO portuguese_lemma VALUES ("n#09735054","n","ruína","N");
INSERT INTO portuguese_lemma VALUES ("n#14423870","n","ruína","N");
INSERT INTO portuguese_lemma VALUES ("v#00148644","v","umedecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00141958","n","obliteração","N");
INSERT INTO portuguese_lemma VALUES ("v#00148928","v","ressecar","N");
INSERT INTO portuguese_lemma VALUES ("v#00148928","v","estorricar","N");
INSERT INTO portuguese_lemma VALUES ("v#00149082","v","secar","N");
INSERT INTO portuguese_lemma VALUES ("v#00149731","v","secar","N");
INSERT INTO portuguese_lemma VALUES ("v#02771756","v","secar","N");
INSERT INTO portuguese_lemma VALUES ("v#00149082","v","enxugar","N");
INSERT INTO portuguese_lemma VALUES ("v#00955030","v","enxugar","N");
INSERT INTO portuguese_lemma VALUES ("v#00956334","v","enxugar","N");
INSERT INTO portuguese_lemma VALUES ("r#00218479","r","de_forma_cortês","Y");
INSERT INTO portuguese_lemma VALUES ("r#00218479","r","educadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00491150","r","educadamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00216044","a","extraordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#00488857","a","extraordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#00457241","a","extraordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#00918492","a","extraordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#01616002","a","extraordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#02343762","a","extraordinário","N");
INSERT INTO portuguese_lemma VALUES ("r#00218886","r","admiravelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00218886","r","de_forma_admirável","Y");
INSERT INTO portuguese_lemma VALUES ("r#00218886","r","admirávelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00216235","a","de_bom_aspecto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00216235","a","bem_parecido","Y");
INSERT INTO portuguese_lemma VALUES ("n#00142607","n","homicídio","N");
INSERT INTO portuguese_lemma VALUES ("n#00220023","n","homicídio","N");
INSERT INTO portuguese_lemma VALUES ("n#00143589","n","homicídio","N");
INSERT INTO portuguese_lemma VALUES ("n#07361576","n","homicídio","N");
INSERT INTO portuguese_lemma VALUES ("n#00142607","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#00143188","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#07332956","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#05465037","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#05479076","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#07203851","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#07788946","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#10060259","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#10442122","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#10867742","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#10867885","n","morte","N");
INSERT INTO portuguese_lemma VALUES ("n#00142607","n","assassinato","N");
INSERT INTO portuguese_lemma VALUES ("n#00143589","n","assassinato","N");
INSERT INTO portuguese_lemma VALUES ("n#00808183","n","assassinato","N");
INSERT INTO portuguese_lemma VALUES ("v#00219012","v","lubrificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01269379","v","lubrificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00216656","a","esplêndido","N");
INSERT INTO portuguese_lemma VALUES ("a#00216656","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#00216900","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#01125154","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#01232112","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#01617066","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#02231628","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#02232109","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#02382040","a","magnífico","N");
INSERT INTO portuguese_lemma VALUES ("a#00216656","a","glorioso","N");
INSERT INTO portuguese_lemma VALUES ("a#01073959","a","glorioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00216656","a","maravilhoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00217004","a","maravilhoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01520738","a","maravilhoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01617066","a","maravilhoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00219641","r","invertido","N");
INSERT INTO portuguese_lemma VALUES ("r#00219641","r","de_cabeça_pra_baixo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00219641","r","ponta-cabeça","N");
INSERT INTO portuguese_lemma VALUES ("r#00219641","r","virado","N");
INSERT INTO portuguese_lemma VALUES ("a#00216900","a","lindíssimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00217004","a","pulcro","N");
INSERT INTO portuguese_lemma VALUES ("r#00219855","r","de_forma_cordial","Y");
INSERT INTO portuguese_lemma VALUES ("n#00219856","n","eutanásia","N");
INSERT INTO portuguese_lemma VALUES ("a#00217101","a","pitoresca","N");
INSERT INTO portuguese_lemma VALUES ("a#00379575","a","pitoresca","N");
INSERT INTO portuguese_lemma VALUES ("a#00217101","a","pitoresco","N");
INSERT INTO portuguese_lemma VALUES ("a#00379575","a","pitoresco","N");
INSERT INTO portuguese_lemma VALUES ("v#00150029","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00377600","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00920424","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00921157","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01348705","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01087519","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#02140630","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01651336","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01651770","v","abrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00220276","v","desligar","N");
INSERT INTO portuguese_lemma VALUES ("v#01037483","v","desligar","N");
INSERT INTO portuguese_lemma VALUES ("r#00220323","r","de_forma_ambígua","Y");
INSERT INTO portuguese_lemma VALUES ("r#00220323","r","ambiguamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00220323","r","com_equívocos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00220323","r","equivocadamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00220409","n","Homicidio","N");
INSERT INTO portuguese_lemma VALUES ("r#00220490","r","de_modo_inequívoco","Y");
INSERT INTO portuguese_lemma VALUES ("r#00220490","r","inequivocadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00220490","r","sem_equívocos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00220490","r","de_forma_não_ambígua","Y");
INSERT INTO portuguese_lemma VALUES ("n#00143589","n","assassínio","N");
INSERT INTO portuguese_lemma VALUES ("n#00143589","n","homicídio_doloso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00150648","v","debilitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00154952","v","debilitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00255389","v","debilitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00270123","v","debilitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00389856","v","debilitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00150780","v","fortalecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00151781","v","fortalecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00150780","v","fortificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01606205","v","fortificar","N");
INSERT INTO portuguese_lemma VALUES ("n#05635624","n","fortificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00218061","a","feia","N");
INSERT INTO portuguese_lemma VALUES ("a#00218061","a","feio","N");
INSERT INTO portuguese_lemma VALUES ("n#00808183","n","Assassinatos","N");
INSERT INTO portuguese_lemma VALUES ("n#00143925","n","massacre","N");
INSERT INTO portuguese_lemma VALUES ("n#00808655","n","massacre","N");
INSERT INTO portuguese_lemma VALUES ("n#00224260","n","massacre","N");
INSERT INTO portuguese_lemma VALUES ("n#00143925","n","sangue_coagulado","Y");
INSERT INTO portuguese_lemma VALUES ("n#05401753","n","sangue_coagulado","Y");
INSERT INTO portuguese_lemma VALUES ("a#00218557","a","grotesco","N");
INSERT INTO portuguese_lemma VALUES ("a#01214625","a","grotesco","N");
INSERT INTO portuguese_lemma VALUES ("a#00218557","a","monstruoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02514380","a","monstruoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00221819","n","matricida","N");
INSERT INTO portuguese_lemma VALUES ("n#00221819","n","matricídio","N");
INSERT INTO portuguese_lemma VALUES ("v#00221840","v","confirmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00449252","v","confirmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00820352","v","confirmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00892698","v","confirmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00684589","v","confirmar","N");
INSERT INTO portuguese_lemma VALUES ("v#01687336","v","confirmar","N");
INSERT INTO portuguese_lemma VALUES ("v#01816870","v","confirmar","N");
INSERT INTO portuguese_lemma VALUES ("n#00221981","n","fratricídio","N");
INSERT INTO portuguese_lemma VALUES ("v#00151901","v","reforçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535030","v","reforçar","N");
INSERT INTO portuguese_lemma VALUES ("n#00144739","n","suicídio","N");
INSERT INTO portuguese_lemma VALUES ("r#00223395","r","fielmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00223802","a","benfeitor","N");
INSERT INTO portuguese_lemma VALUES ("r#00223859","r","violentamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00808655","n","assassinato_em_massa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00808655","n","carnificina","N");
INSERT INTO portuguese_lemma VALUES ("n#00808655","n","assassínio_em_massa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00808655","n","matança_do_porco","Y");
INSERT INTO portuguese_lemma VALUES ("n#00808655","n","Assassínio_em_massa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00808655","n","abate_de_animais","Y");
INSERT INTO portuguese_lemma VALUES ("n#00224260","n","banho_de_sangue","Y");
INSERT INTO portuguese_lemma VALUES ("a#00224515","a","maligno","N");
INSERT INTO portuguese_lemma VALUES ("a#00227003","a","maligno","N");
INSERT INTO portuguese_lemma VALUES ("a#02594714","a","maligno","N");
INSERT INTO portuguese_lemma VALUES ("a#00224515","a","malvado","N");
INSERT INTO portuguese_lemma VALUES ("a#00225912","a","malvado","N");
INSERT INTO portuguese_lemma VALUES ("a#01083652","a","malvado","N");
INSERT INTO portuguese_lemma VALUES ("a#01193200","a","malvado","N");
INSERT INTO portuguese_lemma VALUES ("a#01964360","a","malvado","N");
INSERT INTO portuguese_lemma VALUES ("a#02394260","a","malvado","N");
INSERT INTO portuguese_lemma VALUES ("n#00224599","n","linchamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00224599","n","linchagem","N");
INSERT INTO portuguese_lemma VALUES ("v#00224651","v","desvaneça-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00224731","a","maldoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00225099","a","maldoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00224731","a","malicioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00224731","a","perverso","N");
INSERT INTO portuguese_lemma VALUES ("n#00224738","n","envenenamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00224738","n","envenenamentos","N");
INSERT INTO portuguese_lemma VALUES ("r#00224941","r","infinitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00225264","r","infinitamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00225070","n","Regicidas","N");
INSERT INTO portuguese_lemma VALUES ("n#00225070","n","regicídio","N");
INSERT INTO portuguese_lemma VALUES ("n#00225070","n","Regicídio","N");
INSERT INTO portuguese_lemma VALUES ("a#00225099","a","malévolo","N");
INSERT INTO portuguese_lemma VALUES ("a#00225099","a","danoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01982806","a","danoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01161984","a","danoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00225564","a","malevolente","N");
INSERT INTO portuguese_lemma VALUES ("n#00225593","n","afogamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00225786","n","estrangulamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00225832","v","inutilizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00225912","a","perversa","N");
INSERT INTO portuguese_lemma VALUES ("a#01138610","a","perversa","N");
INSERT INTO portuguese_lemma VALUES ("a#00225912","a","calúnia","N");
INSERT INTO portuguese_lemma VALUES ("n#01220336","n","calúnia","N");
INSERT INTO portuguese_lemma VALUES ("n#06720600","n","calúnia","N");
INSERT INTO portuguese_lemma VALUES ("v#00154752","v","diluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00487748","v","diluir","N");
INSERT INTO portuguese_lemma VALUES ("a#00226105","a","venenoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00790359","a","venenoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02449952","a","venenoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02329912","a","venenoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00226107","n","espasmo","N");
INSERT INTO portuguese_lemma VALUES ("n#14360459","n","espasmo","N");
INSERT INTO portuguese_lemma VALUES ("r#00226133","r","cautelosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00282103","r","cautelosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00154952","v","rarefazer","N");
INSERT INTO portuguese_lemma VALUES ("n#00226511","n","broncospasmo","N");
INSERT INTO portuguese_lemma VALUES ("n#00226511","n","broncoespasmo","N");
INSERT INTO portuguese_lemma VALUES ("v#00226566","v","intensificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00227165","v","intensificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00263904","v","intensificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00290302","v","intensificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00226618","a","benigno","N");
INSERT INTO portuguese_lemma VALUES ("a#01372568","a","benigno","N");
INSERT INTO portuguese_lemma VALUES ("a#01372773","a","benigno","N");
INSERT INTO portuguese_lemma VALUES ("a#02594565","a","benigno","N");
INSERT INTO portuguese_lemma VALUES ("a#00227003","a","caluníe","N");
INSERT INTO portuguese_lemma VALUES ("r#00227171","r","anormalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00227323","r","raivosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00227484","n","Roubo_de_carro","Y");
INSERT INTO portuguese_lemma VALUES ("a#00224964","a","melhor","N");
INSERT INTO portuguese_lemma VALUES ("a#00228339","a","melhor","N");
INSERT INTO portuguese_lemma VALUES ("n#00147781","n","sacrifício","N");
INSERT INTO portuguese_lemma VALUES ("n#00147781","n","sacrificio","N");
INSERT INTO portuguese_lemma VALUES ("n#00227848","n","hecatombe","N");
INSERT INTO portuguese_lemma VALUES ("n#00228078","n","eletrocução","N");
INSERT INTO portuguese_lemma VALUES ("n#00228078","n","electrocussão","N");
INSERT INTO portuguese_lemma VALUES ("n#00228181","n","Pessoas_executadas_por_decapitação","Y");
INSERT INTO portuguese_lemma VALUES ("n#00228181","n","decapitação","N");
INSERT INTO portuguese_lemma VALUES ("n#01165224","n","decapitação","N");
INSERT INTO portuguese_lemma VALUES ("v#00156574","v","irrigar","N");
INSERT INTO portuguese_lemma VALUES ("v#00156574","v","regar","N");
INSERT INTO portuguese_lemma VALUES ("v#00156978","v","regar","N");
INSERT INTO portuguese_lemma VALUES ("v#01184333","v","regar","N");
INSERT INTO portuguese_lemma VALUES ("n#00228283","n","abolição","N");
INSERT INTO portuguese_lemma VALUES ("n#00228283","n","abolimento","N");
INSERT INTO portuguese_lemma VALUES ("r#00228546","r","deliciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00228546","r","de_forma_deliciosa","Y");
INSERT INTO portuguese_lemma VALUES ("a#00228645","a","ótimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00228645","a","óptimo","N");
INSERT INTO portuguese_lemma VALUES ("v#00156978","v","orvalhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00156978","v","aspergir","N");
INSERT INTO portuguese_lemma VALUES ("r#00228724","r","mentalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00229026","v","distilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00229026","v","purificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00475183","v","purificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00475647","v","purificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00475819","v","purificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00229026","v","destilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00229280","v","destilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00364868","v","destilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00475183","v","destilar","N");
INSERT INTO portuguese_lemma VALUES ("n#00148822","n","fechamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00148822","n","encerramento","N");
INSERT INTO portuguese_lemma VALUES ("r#00229399","r","tranqüilamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00229399","r","quietamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00229801","v","tornar_mais_potente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00229801","v","potencializar","N");
INSERT INTO portuguese_lemma VALUES ("n#00229934","n","extinção","N");
INSERT INTO portuguese_lemma VALUES ("n#05758692","n","extinção","N");
INSERT INTO portuguese_lemma VALUES ("n#05464067","n","extinção","N");
INSERT INTO portuguese_lemma VALUES ("n#13478342","n","extinção","N");
INSERT INTO portuguese_lemma VALUES ("n#13963032","n","extinção","N");
INSERT INTO portuguese_lemma VALUES ("n#14012173","n","extinção","N");
INSERT INTO portuguese_lemma VALUES ("v#00157745","v","aprimorar","N");
INSERT INTO portuguese_lemma VALUES ("a#01434973","a","o_mais_baixo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00230172","n","desaparecimento","N");
INSERT INTO portuguese_lemma VALUES ("r#00230189","r","interiormente","N");
INSERT INTO portuguese_lemma VALUES ("a#00230208","a","péssimo","N");
INSERT INTO portuguese_lemma VALUES ("n#00149581","n","abortamento","N");
INSERT INTO portuguese_lemma VALUES ("n#05456093","n","abortamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00149581","n","abortação","N");
INSERT INTO portuguese_lemma VALUES ("r#00230331","r","externamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00249300","r","externamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00149696","n","aborto_espontâneo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00149696","n","Aborto_espontâneo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00149696","n","óbito_fetal","Y");
INSERT INTO portuguese_lemma VALUES ("r#00230996","r","impecavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00230996","r","sem_falhas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00231138","r","solidamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00231336","r","solidamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00231567","n","anulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00231887","n","anulação","N");
INSERT INTO portuguese_lemma VALUES ("n#01240979","n","anulação","N");
INSERT INTO portuguese_lemma VALUES ("r#00231765","r","voluntariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00305283","r","voluntariamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00231765","r","voluntàriamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00231887","n","ab-rogação","N");
INSERT INTO portuguese_lemma VALUES ("a#00231963","a","mais_saudável","Y");
INSERT INTO portuguese_lemma VALUES ("r#00232172","r","geograficamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00232225","v","vegetar","N");
INSERT INTO portuguese_lemma VALUES ("v#02615580","v","vegetar","N");
INSERT INTO portuguese_lemma VALUES ("n#00232386","n","cancelamento","N");
INSERT INTO portuguese_lemma VALUES ("n#07207142","n","cancelamento","N");
INSERT INTO portuguese_lemma VALUES ("r#00232425","r","cruelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00232600","r","vagamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00232604","n","estorno","N");
INSERT INTO portuguese_lemma VALUES ("v#00232714","v","crescer_exageradamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00232714","v","crescer_até_cobrir","Y");
INSERT INTO portuguese_lemma VALUES ("a#00232754","a","corretivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00232863","n","rescisão","N");
INSERT INTO portuguese_lemma VALUES ("v#00160197","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00236999","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00164725","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00167689","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00182537","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00298808","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00429968","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00439958","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00308251","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00308615","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01228705","v","reduzir","N");
INSERT INTO portuguese_lemma VALUES ("a#00233263","a","bicameral","N");
INSERT INTO portuguese_lemma VALUES ("v#00160443","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#01516187","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#01648949","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#01793793","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#01794033","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#01796443","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#01798079","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#01842330","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#02701210","v","conter","N");
INSERT INTO portuguese_lemma VALUES ("v#00160443","v","limitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00162075","v","limitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00162692","v","limitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01710417","v","limitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01711244","v","limitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00233386","n","neutralização","N");
INSERT INTO portuguese_lemma VALUES ("n#00234423","n","neutralização","N");
INSERT INTO portuguese_lemma VALUES ("n#00234675","n","neutralização","N");
INSERT INTO portuguese_lemma VALUES ("n#13521072","n","neutralização","N");
INSERT INTO portuguese_lemma VALUES ("a#00233442","a","bidirecional","N");
INSERT INTO portuguese_lemma VALUES ("r#00233573","r","dentre","N");
INSERT INTO portuguese_lemma VALUES ("n#00233614","n","desativação","N");
INSERT INTO portuguese_lemma VALUES ("v#00161497","v","delimitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00495195","v","delimitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01837761","v","delimitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00161497","v","marcar","N");
INSERT INTO portuguese_lemma VALUES ("v#00353042","v","marcar","N");
INSERT INTO portuguese_lemma VALUES ("v#00511040","v","marcar","N");
INSERT INTO portuguese_lemma VALUES ("v#00612612","v","marcar","N");
INSERT INTO portuguese_lemma VALUES ("v#00654568","v","marcar","N");
INSERT INTO portuguese_lemma VALUES ("v#00679088","v","marcar","N");
INSERT INTO portuguese_lemma VALUES ("n#00152824","n","inversão","N");
INSERT INTO portuguese_lemma VALUES ("n#07802115","n","inversão","N");
INSERT INTO portuguese_lemma VALUES ("n#00152824","n","reversão","N");
INSERT INTO portuguese_lemma VALUES ("n#00222304","n","reversão","N");
INSERT INTO portuguese_lemma VALUES ("n#00153241","n","início","N");
INSERT INTO portuguese_lemma VALUES ("n#00153747","n","início","N");
INSERT INTO portuguese_lemma VALUES ("n#05437768","n","início","N");
INSERT INTO portuguese_lemma VALUES ("n#05459242","n","início","N");
INSERT INTO portuguese_lemma VALUES ("n#07325990","n","início","N");
INSERT INTO portuguese_lemma VALUES ("n#10965545","n","início","N");
INSERT INTO portuguese_lemma VALUES ("n#00153241","n","começo","N");
INSERT INTO portuguese_lemma VALUES ("n#04515071","n","começo","N");
INSERT INTO portuguese_lemma VALUES ("n#05437768","n","começo","N");
INSERT INTO portuguese_lemma VALUES ("n#05458618","n","começo","N");
INSERT INTO portuguese_lemma VALUES ("n#05459242","n","começo","N");
INSERT INTO portuguese_lemma VALUES ("n#07325990","n","começo","N");
INSERT INTO portuguese_lemma VALUES ("n#10965545","n","começo","N");
INSERT INTO portuguese_lemma VALUES ("r#00235843","r","com_eficiência","Y");
INSERT INTO portuguese_lemma VALUES ("r#00235843","r","de_forma_eficiente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00162509","v","obstruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00210685","v","obstruir","N");
INSERT INTO portuguese_lemma VALUES ("v#02557199","v","obstruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00162509","v","impedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00362765","v","impedir","N");
INSERT INTO portuguese_lemma VALUES ("v#01669882","v","impedir","N");
INSERT INTO portuguese_lemma VALUES ("v#01670590","v","impedir","N");
INSERT INTO portuguese_lemma VALUES ("v#01671583","v","impedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00162509","v","estorvar","N");
INSERT INTO portuguese_lemma VALUES ("v#01670590","v","estorvar","N");
INSERT INTO portuguese_lemma VALUES ("v#01671583","v","estorvar","N");
INSERT INTO portuguese_lemma VALUES ("r#00236763","r","de_forma_charmosa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00236763","r","com_charme","Y");
INSERT INTO portuguese_lemma VALUES ("r#00236763","r","charmosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00236821","n","ativação","N");
INSERT INTO portuguese_lemma VALUES ("n#00236821","n","activação","N");
INSERT INTO portuguese_lemma VALUES ("a#00236989","a","unilateral","N");
INSERT INTO portuguese_lemma VALUES ("a#01417105","a","unilateral","N");
INSERT INTO portuguese_lemma VALUES ("v#00236999","v","ferver","N");
INSERT INTO portuguese_lemma VALUES ("v#00227567","v","ferver","N");
INSERT INTO portuguese_lemma VALUES ("v#00261276","v","ferver","N");
INSERT INTO portuguese_lemma VALUES ("v#00519363","v","ferver","N");
INSERT INTO portuguese_lemma VALUES ("n#00154800","n","estabelecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00154800","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#00650412","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#00737011","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#04768657","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#04423455","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#05997592","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#05999585","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#06071657","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#06239374","n","organização","N");
INSERT INTO portuguese_lemma VALUES ("n#00154800","n","constituição","N");
INSERT INTO portuguese_lemma VALUES ("n#03860186","n","constituição","N");
INSERT INTO portuguese_lemma VALUES ("n#04905119","n","constituição","N");
INSERT INTO portuguese_lemma VALUES ("r#00237423","r","de_forma_preocupante","Y");
INSERT INTO portuguese_lemma VALUES ("v#00163258","v","concentrar","N");
INSERT INTO portuguese_lemma VALUES ("r#00237636","r","conscientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00242663","r","conscientemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00237788","a","bilateral","N");
INSERT INTO portuguese_lemma VALUES ("a#01946012","a","bilateral","N");
INSERT INTO portuguese_lemma VALUES ("a#02372118","a","bilateral","N");
INSERT INTO portuguese_lemma VALUES ("r#00237833","r","subconscientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00245716","r","subconscientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00237833","r","inconscientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00245716","r","inconscientemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00237877","v","desoxidar","N");
INSERT INTO portuguese_lemma VALUES ("n#00155548","n","primeira_aparição","Y");
INSERT INTO portuguese_lemma VALUES ("n#00155548","n","introdução","N");
INSERT INTO portuguese_lemma VALUES ("n#00153747","n","introdução","N");
INSERT INTO portuguese_lemma VALUES ("n#00207301","n","introdução","N");
INSERT INTO portuguese_lemma VALUES ("n#04834552","n","introdução","N");
INSERT INTO portuguese_lemma VALUES ("n#00155548","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#00335147","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#00336149","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#00359430","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#02580524","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#05156002","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#05256705","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#05359169","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#05391158","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("n#07217579","n","apresentação","N");
INSERT INTO portuguese_lemma VALUES ("v#00238720","v","catabolizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00238867","v","oxidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00239321","v","oxidar","N");
INSERT INTO portuguese_lemma VALUES ("r#00239064","r","a_pé","Y");
INSERT INTO portuguese_lemma VALUES ("r#00239064","r","andando","N");
INSERT INTO portuguese_lemma VALUES ("n#00156102","n","iniciativa","N");
INSERT INTO portuguese_lemma VALUES ("n#03790844","n","iniciativa","N");
INSERT INTO portuguese_lemma VALUES ("n#00239483","n","Pedra_Fundamental","Y");
INSERT INTO portuguese_lemma VALUES ("n#00239483","n","pedra_fundamental","Y");
INSERT INTO portuguese_lemma VALUES ("n#03110470","n","pedra_fundamental","Y");
INSERT INTO portuguese_lemma VALUES ("v#00239614","v","enferrujar","N");
INSERT INTO portuguese_lemma VALUES ("v#00239614","v","oxidar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00239688","r","em_massa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00395574","r","em_massa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00239688","r","irresistivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00239688","r","esmagadoramente","N");
INSERT INTO portuguese_lemma VALUES ("a#00239847","a","triangular","N");
INSERT INTO portuguese_lemma VALUES ("v#00646912","v","triangular","N");
INSERT INTO portuguese_lemma VALUES ("a#02049428","a","triangular","N");
INSERT INTO portuguese_lemma VALUES ("r#00239908","r","cada_uma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00239908","r","cada_um","Y");
INSERT INTO portuguese_lemma VALUES ("n#00239910","n","inauguração","N");
INSERT INTO portuguese_lemma VALUES ("n#00243373","n","inauguração","N");
INSERT INTO portuguese_lemma VALUES ("n#05540966","n","inauguração","N");
INSERT INTO portuguese_lemma VALUES ("a#00240008","a","tripartido","N");
INSERT INTO portuguese_lemma VALUES ("v#00164129","v","tornar_menor","Y");
INSERT INTO portuguese_lemma VALUES ("n#00153747","n","fundação","N");
INSERT INTO portuguese_lemma VALUES ("n#06216338","n","fundação","N");
INSERT INTO portuguese_lemma VALUES ("n#00153747","n","criação","N");
INSERT INTO portuguese_lemma VALUES ("n#00583085","n","criação","N");
INSERT INTO portuguese_lemma VALUES ("n#00587652","n","criação","N");
INSERT INTO portuguese_lemma VALUES ("n#02518101","n","criação","N");
INSERT INTO portuguese_lemma VALUES ("n#02858828","n","criação","N");
INSERT INTO portuguese_lemma VALUES ("n#05461527","n","criação","N");
INSERT INTO portuguese_lemma VALUES ("n#06691078","n","criação","N");
INSERT INTO portuguese_lemma VALUES ("n#00153747","n","instituição","N");
INSERT INTO portuguese_lemma VALUES ("n#02859290","n","instituição","N");
INSERT INTO portuguese_lemma VALUES ("n#06002286","n","instituição","N");
INSERT INTO portuguese_lemma VALUES ("n#06217164","n","instituição","N");
INSERT INTO portuguese_lemma VALUES ("a#00240197","a","bimodal","N");
INSERT INTO portuguese_lemma VALUES ("r#00240533","r","de_forma_analítica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00240533","r","analiticamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00164388","v","murchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00241689","v","murchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00164388","v","contrair-se","N");
INSERT INTO portuguese_lemma VALUES ("v#02032934","v","contrair-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00240865","r","de_forma_anárquica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00240865","r","anarquicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00153919","n","prestação","N");
INSERT INTO portuguese_lemma VALUES ("n#00153919","n","instalação","N");
INSERT INTO portuguese_lemma VALUES ("n#02661119","n","instalação","N");
INSERT INTO portuguese_lemma VALUES ("n#03564342","n","instalação","N");
INSERT INTO portuguese_lemma VALUES ("v#00164725","v","ficar_menor","Y");
INSERT INTO portuguese_lemma VALUES ("a#00241260","a","binucleado","N");
INSERT INTO portuguese_lemma VALUES ("r#00241272","r","suspeitosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00241397","a","mononuclear","N");
INSERT INTO portuguese_lemma VALUES ("a#00241672","a","bípede","N");
INSERT INTO portuguese_lemma VALUES ("v#00241689","v","enrugar","N");
INSERT INTO portuguese_lemma VALUES ("v#00871417","v","enrugar","N");
INSERT INTO portuguese_lemma VALUES ("v#01277784","v","enrugar","N");
INSERT INTO portuguese_lemma VALUES ("v#01278427","v","enrugar","N");
INSERT INTO portuguese_lemma VALUES ("a#00241816","a","quadrúpede","N");
INSERT INTO portuguese_lemma VALUES ("n#00242003","n","retomada","N");
INSERT INTO portuguese_lemma VALUES ("a#00242293","a","afro-americano","N");
INSERT INTO portuguese_lemma VALUES ("n#09637013","n","afro-americano","N");
INSERT INTO portuguese_lemma VALUES ("r#00242478","r","beligerantemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00242580","v","consolidar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00243086","r","casualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00263893","r","casualmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00166362","v","unificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00257011","v","unificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01682716","v","unificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00239024","a","branca","N");
INSERT INTO portuguese_lemma VALUES ("a#00239024","a","caucasóide","N");
INSERT INTO portuguese_lemma VALUES ("a#00239024","a","caucasiana","N");
INSERT INTO portuguese_lemma VALUES ("a#00243395","a","caucasiana","N");
INSERT INTO portuguese_lemma VALUES ("n#06962503","n","caucasiana","N");
INSERT INTO portuguese_lemma VALUES ("a#00239024","a","caucasiano","N");
INSERT INTO portuguese_lemma VALUES ("a#00243395","a","caucasiano","N");
INSERT INTO portuguese_lemma VALUES ("n#06962503","n","caucasiano","N");
INSERT INTO portuguese_lemma VALUES ("a#00239024","a","branco","N");
INSERT INTO portuguese_lemma VALUES ("a#00367747","a","branco","N");
INSERT INTO portuguese_lemma VALUES ("n#03877535","n","branco","N");
INSERT INTO portuguese_lemma VALUES ("n#06962503","n","branco","N");
INSERT INTO portuguese_lemma VALUES ("n#09641002","n","branco","N");
INSERT INTO portuguese_lemma VALUES ("a#00239414","a","flavo","N");
INSERT INTO portuguese_lemma VALUES ("a#00239414","a","loiro","N");
INSERT INTO portuguese_lemma VALUES ("r#00243608","r","de_forma_compulsiva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00243608","r","compulsivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00243608","r","obsessivamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00243749","v","encurtar","N");
INSERT INTO portuguese_lemma VALUES ("v#00166656","v","encurtar","N");
INSERT INTO portuguese_lemma VALUES ("v#00219644","v","encurtar","N");
INSERT INTO portuguese_lemma VALUES ("v#00166656","v","condensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167181","v","condensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00364868","v","condensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00366547","v","condensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00166656","v","resumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00681575","v","resumir","N");
INSERT INTO portuguese_lemma VALUES ("v#02752695","v","resumir","N");
INSERT INTO portuguese_lemma VALUES ("n#00243918","n","culinária","N");
INSERT INTO portuguese_lemma VALUES ("a#02707659","a","culinária","N");
INSERT INTO portuguese_lemma VALUES ("n#05626343","n","culinária","N");
INSERT INTO portuguese_lemma VALUES ("n#00243918","n","cozinha","N");
INSERT INTO portuguese_lemma VALUES ("n#02495933","n","cozinha","N");
INSERT INTO portuguese_lemma VALUES ("n#02890846","n","cozinha","N");
INSERT INTO portuguese_lemma VALUES ("n#03422865","n","cozinha","N");
INSERT INTO portuguese_lemma VALUES ("n#05626343","n","cozinha","N");
INSERT INTO portuguese_lemma VALUES ("n#07572206","n","cozinha","N");
INSERT INTO portuguese_lemma VALUES ("n#00243918","n","preparação","N");
INSERT INTO portuguese_lemma VALUES ("n#00574678","n","preparação","N");
INSERT INTO portuguese_lemma VALUES ("n#01143040","n","preparação","N");
INSERT INTO portuguese_lemma VALUES ("n#00741586","n","preparação","N");
INSERT INTO portuguese_lemma VALUES ("n#14031108","n","preparação","N");
INSERT INTO portuguese_lemma VALUES ("r#00243938","r","para_o_sul","Y");
INSERT INTO portuguese_lemma VALUES ("r#00244043","r","para_o_norte","Y");
INSERT INTO portuguese_lemma VALUES ("a#01097044","a","cor_de_linho","Y");
INSERT INTO portuguese_lemma VALUES ("a#00240276","a","marronícoma","N");
INSERT INTO portuguese_lemma VALUES ("a#00240276","a","de_cabelo_castanho","Y");
INSERT INTO portuguese_lemma VALUES ("a#00240276","a","castanícoma","N");
INSERT INTO portuguese_lemma VALUES ("a#00240276","a","fuscícoma","N");
INSERT INTO portuguese_lemma VALUES ("a#00240276","a","obscurícoma","N");
INSERT INTO portuguese_lemma VALUES ("a#00240276","a","brunícoma","N");
INSERT INTO portuguese_lemma VALUES ("a#00240276","a","morena","N");
INSERT INTO portuguese_lemma VALUES ("n#06748679","n","morena","N");
INSERT INTO portuguese_lemma VALUES ("n#09877856","n","morena","N");
INSERT INTO portuguese_lemma VALUES ("r#00244641","r","acreditavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00296131","r","acreditavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00244787","r","inacreditavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00295825","r","inacreditavelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00240704","a","bronzeado","N");
INSERT INTO portuguese_lemma VALUES ("a#00371945","a","bronzeado","N");
INSERT INTO portuguese_lemma VALUES ("n#14290534","n","bronzeado","N");
INSERT INTO portuguese_lemma VALUES ("v#00167516","v","declinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01531148","v","declinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167516","v","descer","N");
INSERT INTO portuguese_lemma VALUES ("v#00301476","v","descer","N");
INSERT INTO portuguese_lemma VALUES ("v#01970646","v","descer","N");
INSERT INTO portuguese_lemma VALUES ("v#01341375","v","descer","N");
INSERT INTO portuguese_lemma VALUES ("v#01978576","v","descer","N");
INSERT INTO portuguese_lemma VALUES ("a#00240868","a","escuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00268709","a","escuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00269848","a","escuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00270492","a","escuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","escuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00354536","a","escuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00380983","a","escuro","N");
INSERT INTO portuguese_lemma VALUES ("v#00167689","v","deprivar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167689","v","embotar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167689","v","desprover","N");
INSERT INTO portuguese_lemma VALUES ("v#00167689","v","deprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#01238101","v","deprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#01240960","v","deprimir","N");
INSERT INTO portuguese_lemma VALUES ("r#00245402","r","ferozmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00245860","a","escareado","N");
INSERT INTO portuguese_lemma VALUES ("v#00167983","v","irmanar","N");
INSERT INTO portuguese_lemma VALUES ("v#00167983","v","irmanar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00246217","v","duplicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00246217","v","multiplicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00168890","v","multiplicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00433261","v","multiplicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00246746","v","triplicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00246746","v","triplicar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00246754","n","grelhado","N");
INSERT INTO portuguese_lemma VALUES ("r#00246934","r","classicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00246940","n","fritura","N");
INSERT INTO portuguese_lemma VALUES ("v#00247048","v","quadruplicar","N");
INSERT INTO portuguese_lemma VALUES ("r#00247194","r","comosedeve","N");
INSERT INTO portuguese_lemma VALUES ("r#00247194","r","comoéjusto","N");
INSERT INTO portuguese_lemma VALUES ("v#00247234","v","quintuplicar","N");
INSERT INTO portuguese_lemma VALUES ("n#00247342","n","caça_furtiva","Y");
INSERT INTO portuguese_lemma VALUES ("a#00243444","a","sangrento","N");
INSERT INTO portuguese_lemma VALUES ("a#00243444","a","sangüíneo","N");
INSERT INTO portuguese_lemma VALUES ("r#00247567","r","caracteristicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00247969","r","contrariamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00247993","a","ensanguentado","N");
INSERT INTO portuguese_lemma VALUES ("v#00169382","v","envelhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00169547","v","envelhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00170328","v","envelhecer","N");
INSERT INTO portuguese_lemma VALUES ("r#00248249","r","profeticamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00248368","n","Tempero","N");
INSERT INTO portuguese_lemma VALUES ("a#00248560","a","violento","N");
INSERT INTO portuguese_lemma VALUES ("a#00841934","a","violento","N");
INSERT INTO portuguese_lemma VALUES ("a#01449500","a","violento","N");
INSERT INTO portuguese_lemma VALUES ("a#01514141","a","violento","N");
INSERT INTO portuguese_lemma VALUES ("a#01515501","a","violento","N");
INSERT INTO portuguese_lemma VALUES ("v#00169694","v","avançar","N");
INSERT INTO portuguese_lemma VALUES ("v#01360914","v","avançar","N");
INSERT INTO portuguese_lemma VALUES ("v#01820991","v","avançar","N");
INSERT INTO portuguese_lemma VALUES ("n#00159157","n","melhoria","N");
INSERT INTO portuguese_lemma VALUES ("n#00265992","n","melhoria","N");
INSERT INTO portuguese_lemma VALUES ("n#05480347","n","melhoria","N");
INSERT INTO portuguese_lemma VALUES ("n#00159157","n","melhoramento","N");
INSERT INTO portuguese_lemma VALUES ("n#00167494","n","melhoramento","N");
INSERT INTO portuguese_lemma VALUES ("n#00265992","n","melhoramento","N");
INSERT INTO portuguese_lemma VALUES ("n#00233535","n","melhoramento","N");
INSERT INTO portuguese_lemma VALUES ("n#13470193","n","melhoramento","N");
INSERT INTO portuguese_lemma VALUES ("n#14422751","n","melhoramento","N");
INSERT INTO portuguese_lemma VALUES ("r#00249043","r","instintivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00249164","r","internamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00249433","a","incruento","N");
INSERT INTO portuguese_lemma VALUES ("n#00159609","n","progresso","N");
INSERT INTO portuguese_lemma VALUES ("n#00159874","n","progresso","N");
INSERT INTO portuguese_lemma VALUES ("n#00249987","n","progresso","N");
INSERT INTO portuguese_lemma VALUES ("n#00182992","n","progresso","N");
INSERT INTO portuguese_lemma VALUES ("n#05480347","n","progresso","N");
INSERT INTO portuguese_lemma VALUES ("n#05489950","n","progresso","N");
INSERT INTO portuguese_lemma VALUES ("n#09725434","n","progresso","N");
INSERT INTO portuguese_lemma VALUES ("r#00249641","r","de_cima","Y");
INSERT INTO portuguese_lemma VALUES ("v#00170328","v","avelhentar","N");
INSERT INTO portuguese_lemma VALUES ("a#00246332","a","corajoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00258473","a","corajoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00170483","v","amadurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00170582","v","amadurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00170705","v","amadurecer","N");
INSERT INTO portuguese_lemma VALUES ("r#00249878","r","a_bordo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00170582","v","madurar","N");
INSERT INTO portuguese_lemma VALUES ("r#00250056","r","ao_longo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00250056","r","junto_a","Y");
INSERT INTO portuguese_lemma VALUES ("r#00250056","r","aoladode","N");
INSERT INTO portuguese_lemma VALUES ("r#00250056","r","ao_lado_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00250056","r","ao_lado","Y");
INSERT INTO portuguese_lemma VALUES ("a#01415513","a","intrépido","N");
INSERT INTO portuguese_lemma VALUES ("n#00250143","n","fluxo_de_trabalho","Y");
INSERT INTO portuguese_lemma VALUES ("r#00250153","r","uniformemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00331194","r","uniformemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00160202","n","desenvolvimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00606479","n","desenvolvimento","N");
INSERT INTO portuguese_lemma VALUES ("a#00250483","a","temerário","N");
INSERT INTO portuguese_lemma VALUES ("a#00250739","a","temerário","N");
INSERT INTO portuguese_lemma VALUES ("r#00250484","r","lado_a_lado","Y");
INSERT INTO portuguese_lemma VALUES ("r#00250484","r","ombro_a_ombro","Y");
INSERT INTO portuguese_lemma VALUES ("v#00250691","v","achar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00250691","v","encontrar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#02612368","v","encontrar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00160599","n","elaboração","N");
INSERT INTO portuguese_lemma VALUES ("n#03699200","n","elaboração","N");
INSERT INTO portuguese_lemma VALUES ("n#03743329","n","elaboração","N");
INSERT INTO portuguese_lemma VALUES ("a#00250739","a","Inconsequente","N");
INSERT INTO portuguese_lemma VALUES ("n#00160717","n","limpeza","N");
INSERT INTO portuguese_lemma VALUES ("n#03834628","n","limpeza","N");
INSERT INTO portuguese_lemma VALUES ("n#13990389","n","limpeza","N");
INSERT INTO portuguese_lemma VALUES ("n#10399525","n","limpeza","N");
INSERT INTO portuguese_lemma VALUES ("v#00171455","v","evoluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00171455","v","desenvolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00252019","v","desenvolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00172633","v","desenvolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00381524","v","desenvolver","N");
INSERT INTO portuguese_lemma VALUES ("v#01188325","v","desenvolver","N");
INSERT INTO portuguese_lemma VALUES ("v#01188481","v","desenvolver","N");
INSERT INTO portuguese_lemma VALUES ("a#00247520","a","heróico","N");
INSERT INTO portuguese_lemma VALUES ("a#00259102","a","heróico","N");
INSERT INTO portuguese_lemma VALUES ("a#01232527","a","heróico","N");
INSERT INTO portuguese_lemma VALUES ("a#01332311","a","heróico","N");
INSERT INTO portuguese_lemma VALUES ("a#02574181","a","heróico","N");
INSERT INTO portuguese_lemma VALUES ("v#00171716","v","elaborar","N");
INSERT INTO portuguese_lemma VALUES ("v#00646817","v","elaborar","N");
INSERT INTO portuguese_lemma VALUES ("v#01188325","v","elaborar","N");
INSERT INTO portuguese_lemma VALUES ("r#00251611","r","a_priori","Y");
INSERT INTO portuguese_lemma VALUES ("v#00171832","v","derivar","N");
INSERT INTO portuguese_lemma VALUES ("v#01797979","v","derivar","N");
INSERT INTO portuguese_lemma VALUES ("v#00251791","v","vir_de","Y");
INSERT INTO portuguese_lemma VALUES ("a#00248123","a","timorato","N");
INSERT INTO portuguese_lemma VALUES ("a#00248426","a","tímida","N");
INSERT INTO portuguese_lemma VALUES ("n#00252169","n","limpeza_a_seco","Y");
INSERT INTO portuguese_lemma VALUES ("r#00252965","r","bilateralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00252965","r","dos_dois_lados","Y");
INSERT INTO portuguese_lemma VALUES ("r#00253117","r","unilateralmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00253196","a","acorrentado","N");
INSERT INTO portuguese_lemma VALUES ("n#00253270","n","depuração","N");
INSERT INTO portuguese_lemma VALUES ("n#00253395","n","catarse","N");
INSERT INTO portuguese_lemma VALUES ("n#00253577","n","catarse","N");
INSERT INTO portuguese_lemma VALUES ("r#00253498","r","descaradamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00253919","n","esterilização_(biologia)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00253919","n","esterilização_(processo)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00253919","n","esterilização","N");
INSERT INTO portuguese_lemma VALUES ("n#00692130","n","esterilização","N");
INSERT INTO portuguese_lemma VALUES ("r#00253938","r","pagamento_na_entrega","Y");
INSERT INTO portuguese_lemma VALUES ("r#00254059","r","no_sentido_anti-horário","Y");
INSERT INTO portuguese_lemma VALUES ("v#00254150","v","incubar","N");
INSERT INTO portuguese_lemma VALUES ("n#00254166","n","pasteurização","N");
INSERT INTO portuguese_lemma VALUES ("n#00254166","n","Pasteurização","N");
INSERT INTO portuguese_lemma VALUES ("a#00250616","a","solto","N");
INSERT INTO portuguese_lemma VALUES ("a#00469578","a","solto","N");
INSERT INTO portuguese_lemma VALUES ("r#00254369","r","sentido_horário","Y");
INSERT INTO portuguese_lemma VALUES ("n#00254415","n","Saneamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00254415","n","saneamento","N");
INSERT INTO portuguese_lemma VALUES ("n#14495466","n","saneamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00254597","n","depilação","N");
INSERT INTO portuguese_lemma VALUES ("r#00254711","r","quinzenalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00254867","v","suavizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00255389","v","suavizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00254922","n","tonsura","N");
INSERT INTO portuguese_lemma VALUES ("n#05539717","n","tonsura","N");
INSERT INTO portuguese_lemma VALUES ("r#00254978","r","mensalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00254978","r","mensal","N");
INSERT INTO portuguese_lemma VALUES ("a#01969707","a","mensal","N");
INSERT INTO portuguese_lemma VALUES ("r#00255075","r","bimestralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00255181","r","bimestralmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00255214","n","ablução","N");
INSERT INTO portuguese_lemma VALUES ("n#00255450","n","ablução","N");
INSERT INTO portuguese_lemma VALUES ("n#00255214","n","banho","N");
INSERT INTO portuguese_lemma VALUES ("n#00165598","n","banho","N");
INSERT INTO portuguese_lemma VALUES ("n#02806530","n","banho","N");
INSERT INTO portuguese_lemma VALUES ("r#00255315","r","semestralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00279174","r","semestralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00352816","r","semestralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00255315","r","bianualmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00279050","r","bianualmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00255389","v","abrandar","N");
INSERT INTO portuguese_lemma VALUES ("v#00255389","v","temperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00203187","v","temperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00302875","v","temperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00303056","v","temperar","N");
INSERT INTO portuguese_lemma VALUES ("v#00559919","v","temperar","N");
INSERT INTO portuguese_lemma VALUES ("v#02191766","v","temperar","N");
INSERT INTO portuguese_lemma VALUES ("v#02192570","v","temperar","N");
INSERT INTO portuguese_lemma VALUES ("r#00255614","r","aqui_anexo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00175034","v","inchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00256507","v","inchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00175935","v","inchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00179925","v","inchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00180220","v","inchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00252740","v","inchar","N");
INSERT INTO portuguese_lemma VALUES ("v#00252877","v","inchar","N");
INSERT INTO portuguese_lemma VALUES ("r#00256189","r","in_situ","Y");
INSERT INTO portuguese_lemma VALUES ("v#00256507","v","inflar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00256507","v","inchar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00257115","n","Xampus","N");
INSERT INTO portuguese_lemma VALUES ("n#00257115","n","xampu","N");
INSERT INTO portuguese_lemma VALUES ("n#04183516","n","xampu","N");
INSERT INTO portuguese_lemma VALUES ("a#00257232","a","nãoencadernado","N");
INSERT INTO portuguese_lemma VALUES ("a#00257232","a","brochado","N");
INSERT INTO portuguese_lemma VALUES ("v#00175614","v","expandir","N");
INSERT INTO portuguese_lemma VALUES ("v#00180494","v","expandir","N");
INSERT INTO portuguese_lemma VALUES ("v#00305537","v","expandir","N");
INSERT INTO portuguese_lemma VALUES ("n#00257580","n","chuveiro","N");
INSERT INTO portuguese_lemma VALUES ("n#04209383","n","chuveiro","N");
INSERT INTO portuguese_lemma VALUES ("r#00257784","r","três_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00476680","r","três_vezes","Y");
INSERT INTO portuguese_lemma VALUES ("r#00257784","r","três","N");
INSERT INTO portuguese_lemma VALUES ("n#13744044","n","três","N");
INSERT INTO portuguese_lemma VALUES ("r#00257864","r","em_si","Y");
INSERT INTO portuguese_lemma VALUES ("r#00257864","r","verbatim","N");
INSERT INTO portuguese_lemma VALUES ("r#00257864","r","palavraporpalavra","N");
INSERT INTO portuguese_lemma VALUES ("r#00257864","r","ipsis_litteris","Y");
INSERT INTO portuguese_lemma VALUES ("v#00258109","v","vazar","N");
INSERT INTO portuguese_lemma VALUES ("v#00529759","v","vazar","N");
INSERT INTO portuguese_lemma VALUES ("r#00258175","r","grátis","N");
INSERT INTO portuguese_lemma VALUES ("a#02399130","a","grátis","N");
INSERT INTO portuguese_lemma VALUES ("r#00258175","r","de_graça","Y");
INSERT INTO portuguese_lemma VALUES ("a#02399130","a","de_graça","Y");
INSERT INTO portuguese_lemma VALUES ("v#00258665","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01298931","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01258127","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01848718","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01370454","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01371248","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#02010400","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#02011437","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01374895","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01376117","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01376459","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01539361","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("v#01623741","v","partir","N");
INSERT INTO portuguese_lemma VALUES ("r#00258677","r","para_fora","Y");
INSERT INTO portuguese_lemma VALUES ("n#00258854","n","retificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00258854","n","correção","N");
INSERT INTO portuguese_lemma VALUES ("n#00811685","n","correção","N");
INSERT INTO portuguese_lemma VALUES ("n#03768230","n","correção","N");
INSERT INTO portuguese_lemma VALUES ("n#03928898","n","correção","N");
INSERT INTO portuguese_lemma VALUES ("v#00176836","v","avariar","N");
INSERT INTO portuguese_lemma VALUES ("v#01078962","v","avariar","N");
INSERT INTO portuguese_lemma VALUES ("r#00259096","r","mais_cedo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00814611","a","mais_cedo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00259177","n","reparação_(legal)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00259544","n","retribuição","N");
INSERT INTO portuguese_lemma VALUES ("n#01121855","n","retribuição","N");
INSERT INTO portuguese_lemma VALUES ("n#01234729","n","retribuição","N");
INSERT INTO portuguese_lemma VALUES ("n#09556237","n","retribuição","N");
INSERT INTO portuguese_lemma VALUES ("n#00166954","n","compensação","N");
INSERT INTO portuguese_lemma VALUES ("n#09559232","n","compensação","N");
INSERT INTO portuguese_lemma VALUES ("n#00166954","n","Compensação","N");
INSERT INTO portuguese_lemma VALUES ("n#09559232","n","Compensação","N");
INSERT INTO portuguese_lemma VALUES ("v#00259927","v","atribular","N");
INSERT INTO portuguese_lemma VALUES ("v#00259927","v","afligir","N");
INSERT INTO portuguese_lemma VALUES ("v#01797730","v","afligir","N");
INSERT INTO portuguese_lemma VALUES ("n#00260051","n","otimização","N");
INSERT INTO portuguese_lemma VALUES ("n#00260051","n","optimização","N");
INSERT INTO portuguese_lemma VALUES ("v#00177802","v","magoar","N");
INSERT INTO portuguese_lemma VALUES ("v#01224189","v","magoar","N");
INSERT INTO portuguese_lemma VALUES ("v#01797347","v","magoar","N");
INSERT INTO portuguese_lemma VALUES ("n#00167086","n","aperfeiçoamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00167086","n","perfeição","N");
INSERT INTO portuguese_lemma VALUES ("n#04549171","n","perfeição","N");
INSERT INTO portuguese_lemma VALUES ("n#10374214","n","perfeição","N");
INSERT INTO portuguese_lemma VALUES ("n#00167178","n","mudança_para_melhor","Y");
INSERT INTO portuguese_lemma VALUES ("n#00167178","n","reforma","N");
INSERT INTO portuguese_lemma VALUES ("n#00510453","n","reforma","N");
INSERT INTO portuguese_lemma VALUES ("v#00177962","v","consertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00261705","v","consertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00262703","v","consertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00177962","v","reparar","N");
INSERT INTO portuguese_lemma VALUES ("v#00689564","v","reparar","N");
INSERT INTO portuguese_lemma VALUES ("a#00256574","a","burguês","N");
INSERT INTO portuguese_lemma VALUES ("a#00256659","a","burguês","N");
INSERT INTO portuguese_lemma VALUES ("a#00293427","a","burguês","N");
INSERT INTO portuguese_lemma VALUES ("n#09869830","n","burguês","N");
INSERT INTO portuguese_lemma VALUES ("a#00256574","a","burguesa","N");
INSERT INTO portuguese_lemma VALUES ("a#00256659","a","burguesa","N");
INSERT INTO portuguese_lemma VALUES ("n#09869830","n","burguesa","N");
INSERT INTO portuguese_lemma VALUES ("n#00260881","n","reforma_agrária","Y");
INSERT INTO portuguese_lemma VALUES ("n#00260881","n","Reforma_Agrária","Y");
INSERT INTO portuguese_lemma VALUES ("n#00260881","n","Reforma_agraria","Y");
INSERT INTO portuguese_lemma VALUES ("r#00261231","r","esteticamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00178413","v","rechear","N");
INSERT INTO portuguese_lemma VALUES ("n#00261604","n","embelezamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00178848","v","revisar","N");
INSERT INTO portuguese_lemma VALUES ("r#00262206","r","ambiciosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00168201","n","decoração","N");
INSERT INTO portuguese_lemma VALUES ("n#00262596","n","decoração","N");
INSERT INTO portuguese_lemma VALUES ("n#00262743","n","decoração","N");
INSERT INTO portuguese_lemma VALUES ("n#02166920","n","decoração","N");
INSERT INTO portuguese_lemma VALUES ("n#02550579","n","decoração","N");
INSERT INTO portuguese_lemma VALUES ("n#02863365","n","decoração","N");
INSERT INTO portuguese_lemma VALUES ("a#00262529","a","dolicocefálico","N");
INSERT INTO portuguese_lemma VALUES ("n#00262596","n","adornamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00262596","n","ornamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00262743","n","ornamento","N");
INSERT INTO portuguese_lemma VALUES ("n#02166920","n","ornamento","N");
INSERT INTO portuguese_lemma VALUES ("n#02550579","n","ornamento","N");
INSERT INTO portuguese_lemma VALUES ("n#02557306","n","ornamento","N");
INSERT INTO portuguese_lemma VALUES ("r#00262655","r","de_forma_anônima","Y");
INSERT INTO portuguese_lemma VALUES ("r#00262655","r","anonimamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00271152","r","anonimamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00262703","v","remendar","N");
INSERT INTO portuguese_lemma VALUES ("a#00258473","a","afoito","N");
INSERT INTO portuguese_lemma VALUES ("a#00258473","a","valoroso","N");
INSERT INTO portuguese_lemma VALUES ("a#00258473","a","valente","N");
INSERT INTO portuguese_lemma VALUES ("a#00260137","a","valente","N");
INSERT INTO portuguese_lemma VALUES ("a#00258473","a","brava","N");
INSERT INTO portuguese_lemma VALUES ("a#00258473","a","arrojado","N");
INSERT INTO portuguese_lemma VALUES ("v#00179295","v","tornar_pior","Y");
INSERT INTO portuguese_lemma VALUES ("v#00263044","v","tornar_imperfeito_ou_defeituoso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00263044","v","criar_uma_falha_ou_defeito","Y");
INSERT INTO portuguese_lemma VALUES ("v#00263044","v","desfigurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00201342","v","desfigurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00839492","v","desfigurar","N");
INSERT INTO portuguese_lemma VALUES ("v#01549905","v","desfigurar","N");
INSERT INTO portuguese_lemma VALUES ("n#00263353","n","tatuagem","N");
INSERT INTO portuguese_lemma VALUES ("n#04395651","n","tatuagem","N");
INSERT INTO portuguese_lemma VALUES ("v#00179925","v","intumescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00179925","v","afofar","N");
INSERT INTO portuguese_lemma VALUES ("a#00259479","a","animoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00263893","r","de_forma_casual","Y");
INSERT INTO portuguese_lemma VALUES ("v#00263904","v","amplificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00434077","v","amplificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00180220","v","inflar","N");
INSERT INTO portuguese_lemma VALUES ("v#00180220","v","encher","N");
INSERT INTO portuguese_lemma VALUES ("v#00315280","v","encher","N");
INSERT INTO portuguese_lemma VALUES ("v#00315864","v","encher","N");
INSERT INTO portuguese_lemma VALUES ("v#00316526","v","encher","N");
INSERT INTO portuguese_lemma VALUES ("v#01808536","v","encher","N");
INSERT INTO portuguese_lemma VALUES ("n#00264192","n","Clearing","N");
INSERT INTO portuguese_lemma VALUES ("n#00264192","n","CLEARING","N");
INSERT INTO portuguese_lemma VALUES ("n#00264192","n","clarificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00264366","n","enriquecimento_(nutrientes)","Y");
INSERT INTO portuguese_lemma VALUES ("n#13271498","n","enriquecimento_(nutrientes)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00264366","n","enriquecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#13271498","n","enriquecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00264529","n","fortificação","N");
INSERT INTO portuguese_lemma VALUES ("n#03385557","n","fortificação","N");
INSERT INTO portuguese_lemma VALUES ("n#05635624","n","fortificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00264775","n","humanização","N");
INSERT INTO portuguese_lemma VALUES ("a#00264776","a","covardemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00264776","a","cobarde","N");
INSERT INTO portuguese_lemma VALUES ("a#00264776","a","covarde","N");
INSERT INTO portuguese_lemma VALUES ("n#09614047","n","covarde","N");
INSERT INTO portuguese_lemma VALUES ("v#00264875","v","acidificar","N");
INSERT INTO portuguese_lemma VALUES ("v#02196690","v","acidificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00170063","n","modernização","N");
INSERT INTO portuguese_lemma VALUES ("v#00265094","v","basificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00170245","n","renovação","N");
INSERT INTO portuguese_lemma VALUES ("n#00811153","n","renovação","N");
INSERT INTO portuguese_lemma VALUES ("n#10349313","n","renovação","N");
INSERT INTO portuguese_lemma VALUES ("n#00265992","n","aprimoramento","N");
INSERT INTO portuguese_lemma VALUES ("r#00266016","r","arrogantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00266016","r","de_forma_arrogante","Y");
INSERT INTO portuguese_lemma VALUES ("a#00266420","a","pusilânime","N");
INSERT INTO portuguese_lemma VALUES ("n#00266645","n","ventilação_(processos_industriais)","Y");
INSERT INTO portuguese_lemma VALUES ("n#04526520","n","ventilação_(processos_industriais)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00266645","n","ventilação","N");
INSERT INTO portuguese_lemma VALUES ("n#04526520","n","ventilação","N");
INSERT INTO portuguese_lemma VALUES ("n#00171220","n","reparação","N");
INSERT INTO portuguese_lemma VALUES ("n#00171220","n","conserto","N");
INSERT INTO portuguese_lemma VALUES ("n#00171220","n","reparo","N");
INSERT INTO portuguese_lemma VALUES ("n#05068616","n","reparo","N");
INSERT INTO portuguese_lemma VALUES ("r#00266955","r","audaciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00266955","r","ousadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00267321","r","adjectivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00267435","r","adverbialmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00267452","a","eupnéico","N");
INSERT INTO portuguese_lemma VALUES ("n#00171721","n","manutenção","N");
INSERT INTO portuguese_lemma VALUES ("n#13365286","n","manutenção","N");
INSERT INTO portuguese_lemma VALUES ("n#09625216","n","manutenção","N");
INSERT INTO portuguese_lemma VALUES ("a#00267871","a","dispnéico","N");
INSERT INTO portuguese_lemma VALUES ("r#00267950","r","amorosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00268056","r","de_forma_angelical","Y");
INSERT INTO portuguese_lemma VALUES ("r#00268056","r","angelicalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00182841","v","recair","N");
INSERT INTO portuguese_lemma VALUES ("r#00268312","r","de_forma_eloqüente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00268312","r","eloqüentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00327848","r","eloqüentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00268457","n","rapidinha","N");
INSERT INTO portuguese_lemma VALUES ("v#00183081","v","paralisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00183284","v","paralisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00183364","v","paralisar","N");
INSERT INTO portuguese_lemma VALUES ("r#00268651","r","atributivamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00183364","v","entorpecer","N");
INSERT INTO portuguese_lemma VALUES ("r#00268797","r","audivelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00268824","n","gentrificação","N");
INSERT INTO portuguese_lemma VALUES ("r#00268909","r","inaudivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00269153","r","genuínamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00269153","r","autenticamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00173090","n","reconstrução","N");
INSERT INTO portuguese_lemma VALUES ("n#04444978","n","reconstrução","N");
INSERT INTO portuguese_lemma VALUES ("n#05363145","n","reconstrução","N");
INSERT INTO portuguese_lemma VALUES ("v#00269682","v","desbloquear","N");
INSERT INTO portuguese_lemma VALUES ("a#00269894","a","sem_terra","Y");
INSERT INTO portuguese_lemma VALUES ("a#00265852","a","iluminado","N");
INSERT INTO portuguese_lemma VALUES ("a#00271580","a","iluminado","N");
INSERT INTO portuguese_lemma VALUES ("a#00840779","a","iluminado","N");
INSERT INTO portuguese_lemma VALUES ("a#01307375","a","iluminado","N");
INSERT INTO portuguese_lemma VALUES ("v#00184403","v","circular","N");
INSERT INTO portuguese_lemma VALUES ("a#00676271","a","circular","N");
INSERT INTO portuguese_lemma VALUES ("v#00656764","v","circular","N");
INSERT INTO portuguese_lemma VALUES ("v#01522716","v","circular","N");
INSERT INTO portuguese_lemma VALUES ("v#01911339","v","circular","N");
INSERT INTO portuguese_lemma VALUES ("a#01966694","a","circular","N");
INSERT INTO portuguese_lemma VALUES ("v#01395599","v","circular","N");
INSERT INTO portuguese_lemma VALUES ("v#00184403","v","mobilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184548","v","mobilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00737150","v","mobilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01097960","v","mobilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184548","v","convocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00538265","v","convocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00538841","v","convocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00705520","v","convocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01097960","v","convocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01007880","v","convocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184775","v","cicatrizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01551679","v","cicatrizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184895","v","oscilar","N");
INSERT INTO portuguese_lemma VALUES ("v#01876530","v","oscilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00184895","v","flutuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01465583","v","flutuar","N");
INSERT INTO portuguese_lemma VALUES ("n#00270800","n","Coaching","N");
INSERT INTO portuguese_lemma VALUES ("v#00270826","v","estabilizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00266706","a","luminoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00273770","a","luminoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00274569","a","luminoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01741423","a","luminoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00174085","n","actuação","N");
INSERT INTO portuguese_lemma VALUES ("n#00174193","n","degradação","N");
INSERT INTO portuguese_lemma VALUES ("a#00271419","a","fluorescente","N");
INSERT INTO portuguese_lemma VALUES ("a#00403505","a","fluorescente","N");
INSERT INTO portuguese_lemma VALUES ("a#00271580","a","aceso","N");
INSERT INTO portuguese_lemma VALUES ("a#00442983","a","aceso","N");
INSERT INTO portuguese_lemma VALUES ("v#01978576","v","aceso","N");
INSERT INTO portuguese_lemma VALUES ("r#00271625","r","aritmeticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00271625","r","de_forma_aritmética","Y");
INSERT INTO portuguese_lemma VALUES ("n#00271636","n","desumanização","N");
INSERT INTO portuguese_lemma VALUES ("v#00271711","v","desestabilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00272177","v","desestabilizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00271813","a","incandescente","N");
INSERT INTO portuguese_lemma VALUES ("a#01122121","a","incandescente","N");
INSERT INTO portuguese_lemma VALUES ("v#00271946","v","firmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00518879","v","firmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00674118","v","firmar","N");
INSERT INTO portuguese_lemma VALUES ("v#00271946","v","estabilizar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00272305","r","assiduamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00175090","n","corrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#03801774","n","corrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#03803876","n","corrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#09734957","n","corrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#10360441","n","corrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#10441111","n","corrupção","N");
INSERT INTO portuguese_lemma VALUES ("a#00272555","a","fosforescente","N");
INSERT INTO portuguese_lemma VALUES ("v#00272683","v","dessensibilizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00272713","n","desmoralização","N");
INSERT INTO portuguese_lemma VALUES ("r#00272844","r","transversalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00293077","r","transversalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00186277","v","costumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00186277","v","acostumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00186743","v","habituar","N");
INSERT INTO portuguese_lemma VALUES ("v#00186743","v","habituar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00186743","v","acostumar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00175673","n","humilhação","N");
INSERT INTO portuguese_lemma VALUES ("r#00273504","r","sem_controle","Y");
INSERT INTO portuguese_lemma VALUES ("v#00186948","v","instruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00407541","v","instruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00407789","v","instruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00508780","v","instruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00562446","v","instruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00562981","v","instruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00186948","v","ensinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00562446","v","ensinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01626476","v","ensinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00273877","n","branqueamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00273963","v","corroer","N");
INSERT INTO portuguese_lemma VALUES ("v#00274283","v","corroer","N");
INSERT INTO portuguese_lemma VALUES ("v#00274724","v","corroer","N");
INSERT INTO portuguese_lemma VALUES ("n#00274009","n","processo_de_branqueamento","Y");
INSERT INTO portuguese_lemma VALUES ("a#00269661","a","negro","N");
INSERT INTO portuguese_lemma VALUES ("a#00367459","a","negro","N");
INSERT INTO portuguese_lemma VALUES ("n#06960662","n","negro","N");
INSERT INTO portuguese_lemma VALUES ("n#09637339","n","negro","N");
INSERT INTO portuguese_lemma VALUES ("a#00269661","a","sombrio","N");
INSERT INTO portuguese_lemma VALUES ("a#00272084","a","sombrio","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","sombrio","N");
INSERT INTO portuguese_lemma VALUES ("a#00354536","a","sombrio","N");
INSERT INTO portuguese_lemma VALUES ("a#01178561","a","sombrio","N");
INSERT INTO portuguese_lemma VALUES ("a#00274551","a","crepuscular","N");
INSERT INTO portuguese_lemma VALUES ("a#00275486","a","crepuscular","N");
INSERT INTO portuguese_lemma VALUES ("v#00274724","v","erodir","N");
INSERT INTO portuguese_lemma VALUES ("r#00274842","r","de_maneira_feliz","Y");
INSERT INTO portuguese_lemma VALUES ("r#00274842","r","que_causa_felicidade","Y");
INSERT INTO portuguese_lemma VALUES ("n#00274941","n","tez","N");
INSERT INTO portuguese_lemma VALUES ("n#03875475","n","tez","N");
INSERT INTO portuguese_lemma VALUES ("n#04976952","n","tez","N");
INSERT INTO portuguese_lemma VALUES ("n#07567139","n","tez","N");
INSERT INTO portuguese_lemma VALUES ("r#00275035","r","formigando","N");
INSERT INTO portuguese_lemma VALUES ("r#00275035","r","dormente","N");
INSERT INTO portuguese_lemma VALUES ("n#04433585","n","dormente","N");
INSERT INTO portuguese_lemma VALUES ("r#00275409","r","pela","N");
INSERT INTO portuguese_lemma VALUES ("r#00275409","r","popa","N");
INSERT INTO portuguese_lemma VALUES ("n#04316646","n","popa","N");
INSERT INTO portuguese_lemma VALUES ("n#00275424","n","tingimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00275572","n","Coloração","N");
INSERT INTO portuguese_lemma VALUES ("v#00275607","v","regularizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01712330","v","regularizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00188537","v","arrumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00188762","v","arrumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00818883","v","arrumar","N");
INSERT INTO portuguese_lemma VALUES ("v#01010586","v","arrumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00188537","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00188762","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00280835","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00281123","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00480481","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01132230","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01134235","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01656551","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02434238","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01668018","v","organizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00275974","r","escarranchado","N");
INSERT INTO portuguese_lemma VALUES ("r#00275974","r","escarranchadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00276076","r","escarranchadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00275974","r","de_cada_lado","Y");
INSERT INTO portuguese_lemma VALUES ("r#00276076","r","de_cada_lado","Y");
INSERT INTO portuguese_lemma VALUES ("n#00276189","n","ambientalismo","N");
INSERT INTO portuguese_lemma VALUES ("n#05970564","n","ambientalismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00276189","n","ecologismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00276214","v","desorganizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02436140","v","desorganizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00276225","r","no_topo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00271594","a","tenebroso","N");
INSERT INTO portuguese_lemma VALUES ("v#00276373","v","bagunçar","N");
INSERT INTO portuguese_lemma VALUES ("v#02735142","v","bagunçar","N");
INSERT INTO portuguese_lemma VALUES ("n#00276620","n","contaminação","N");
INSERT INTO portuguese_lemma VALUES ("n#00276987","n","contaminação","N");
INSERT INTO portuguese_lemma VALUES ("n#10393527","n","contaminação","N");
INSERT INTO portuguese_lemma VALUES ("n#14516743","n","contaminação","N");
INSERT INTO portuguese_lemma VALUES ("n#14821984","n","contaminação","N");
INSERT INTO portuguese_lemma VALUES ("a#00272084","a","sombreado","N");
INSERT INTO portuguese_lemma VALUES ("v#00189468","v","ordenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00190043","v","ordenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00279239","v","ordenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00506658","v","ordenar","N");
INSERT INTO portuguese_lemma VALUES ("v#01010586","v","ordenar","N");
INSERT INTO portuguese_lemma VALUES ("n#00276987","n","poluição","N");
INSERT INTO portuguese_lemma VALUES ("n#10393527","n","poluição","N");
INSERT INTO portuguese_lemma VALUES ("n#14516743","n","poluição","N");
INSERT INTO portuguese_lemma VALUES ("v#00277086","v","antedatar","N");
INSERT INTO portuguese_lemma VALUES ("r#00277435","r","perniciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00378212","r","perniciosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00277569","n","imersão","N");
INSERT INTO portuguese_lemma VALUES ("n#01038485","n","imersão","N");
INSERT INTO portuguese_lemma VALUES ("n#07364115","n","imersão","N");
INSERT INTO portuguese_lemma VALUES ("n#13557158","n","imersão","N");
INSERT INTO portuguese_lemma VALUES ("n#00277811","n","impregnação","N");
INSERT INTO portuguese_lemma VALUES ("a#00278006","a","enluarado","N");
INSERT INTO portuguese_lemma VALUES ("r#00278078","r","descalço","N");
INSERT INTO portuguese_lemma VALUES ("a#02156686","a","descalço","N");
INSERT INTO portuguese_lemma VALUES ("v#00278280","v","rearranjar","N");
INSERT INTO portuguese_lemma VALUES ("v#00278280","v","reordenar","N");
INSERT INTO portuguese_lemma VALUES ("n#00178992","n","irrigação","N");
INSERT INTO portuguese_lemma VALUES ("a#00273770","a","vivído","N");
INSERT INTO portuguese_lemma VALUES ("a#00273770","a","brilhante","N");
INSERT INTO portuguese_lemma VALUES ("a#00274569","a","brilhante","N");
INSERT INTO portuguese_lemma VALUES ("a#00375424","a","brilhante","N");
INSERT INTO portuguese_lemma VALUES ("a#01281852","a","brilhante","N");
INSERT INTO portuguese_lemma VALUES ("a#02232109","a","brilhante","N");
INSERT INTO portuguese_lemma VALUES ("a#00273770","a","radiante","N");
INSERT INTO portuguese_lemma VALUES ("a#00275515","a","radiante","N");
INSERT INTO portuguese_lemma VALUES ("n#00278555","n","jogaráguabenta","N");
INSERT INTO portuguese_lemma VALUES ("n#00278810","n","mastigação","N");
INSERT INTO portuguese_lemma VALUES ("r#00279050","r","a_cada_dois_anos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00279050","r","bienalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00279239","v","colocar_em_ordem_alfabética","Y");
INSERT INTO portuguese_lemma VALUES ("n#00279534","n","bruxismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00279674","n","desfoliação","N");
INSERT INTO portuguese_lemma VALUES ("n#13460034","n","desfoliação","N");
INSERT INTO portuguese_lemma VALUES ("v#00279822","v","oxigenar","N");
INSERT INTO portuguese_lemma VALUES ("n#00180278","n","traslado","N");
INSERT INTO portuguese_lemma VALUES ("n#04211970","n","traslado","N");
INSERT INTO portuguese_lemma VALUES ("n#00180278","n","deslocamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00213182","n","deslocamento","N");
INSERT INTO portuguese_lemma VALUES ("n#05537257","n","deslocamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00280301","v","branquear","N");
INSERT INTO portuguese_lemma VALUES ("v#00280301","v","embranquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00280301","v","alvejar","N");
INSERT INTO portuguese_lemma VALUES ("a#00275515","a","refulgente","N");
INSERT INTO portuguese_lemma VALUES ("a#00280844","a","deslumbrante","N");
INSERT INTO portuguese_lemma VALUES ("v#00280930","v","iluminar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00280972","r","burocraticamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00281101","v","descolorir","N");
INSERT INTO portuguese_lemma VALUES ("v#00281101","v","colorir","N");
INSERT INTO portuguese_lemma VALUES ("v#01163518","v","colorir","N");
INSERT INTO portuguese_lemma VALUES ("v#00836926","v","colorir","N");
INSERT INTO portuguese_lemma VALUES ("v#01163997","v","colorir","N");
INSERT INTO portuguese_lemma VALUES ("v#01729632","v","colorir","N");
INSERT INTO portuguese_lemma VALUES ("r#00281491","r","de_forma_caprichosa","Y");
INSERT INTO portuguese_lemma VALUES ("a#00276849","a","reluzente","N");
INSERT INTO portuguese_lemma VALUES ("a#01741423","a","reluzente","N");
INSERT INTO portuguese_lemma VALUES ("a#00276849","a","faiscante","N");
INSERT INTO portuguese_lemma VALUES ("a#01741423","a","faiscante","N");
INSERT INTO portuguese_lemma VALUES ("a#00282020","a","iridescente","N");
INSERT INTO portuguese_lemma VALUES ("a#00403072","a","iridescente","N");
INSERT INTO portuguese_lemma VALUES ("n#00182418","n","avanço","N");
INSERT INTO portuguese_lemma VALUES ("n#05489950","n","avanço","N");
INSERT INTO portuguese_lemma VALUES ("n#00182418","n","progressão","N");
INSERT INTO portuguese_lemma VALUES ("n#05489950","n","progressão","N");
INSERT INTO portuguese_lemma VALUES ("n#08458912","n","progressão","N");
INSERT INTO portuguese_lemma VALUES ("r#00282103","r","de_forma_cautelosa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00282103","r","com_cautela","Y");
INSERT INTO portuguese_lemma VALUES ("r#00282103","r","com_cuidado","Y");
INSERT INTO portuguese_lemma VALUES ("n#00182783","n","carriera","N");
INSERT INTO portuguese_lemma VALUES ("r#00282858","r","semcessar","N");
INSERT INTO portuguese_lemma VALUES ("v#00194314","v","tingir","N");
INSERT INTO portuguese_lemma VALUES ("v#00197117","v","tingir","N");
INSERT INTO portuguese_lemma VALUES ("n#00283127","n","locomoção","N");
INSERT INTO portuguese_lemma VALUES ("n#04773596","n","locomoção","N");
INSERT INTO portuguese_lemma VALUES ("a#00278090","a","prateado","N");
INSERT INTO portuguese_lemma VALUES ("a#00387392","a","prateado","N");
INSERT INTO portuguese_lemma VALUES ("a#00278090","a","prata","N");
INSERT INTO portuguese_lemma VALUES ("n#03339563","n","prata","N");
INSERT INTO portuguese_lemma VALUES ("n#09629621","n","prata","N");
INSERT INTO portuguese_lemma VALUES ("n#09642587","n","prata","N");
INSERT INTO portuguese_lemma VALUES ("n#10501473","n","prata","N");
INSERT INTO portuguese_lemma VALUES ("n#14986144","n","prata","N");
INSERT INTO portuguese_lemma VALUES ("a#00278090","a","argentino","N");
INSERT INTO portuguese_lemma VALUES ("a#02733922","a","argentino","N");
INSERT INTO portuguese_lemma VALUES ("n#07006309","n","argentino","N");
INSERT INTO portuguese_lemma VALUES ("a#00278090","a","argênteo","N");
INSERT INTO portuguese_lemma VALUES ("a#01529053","a","argênteo","N");
INSERT INTO portuguese_lemma VALUES ("n#00183648","n","caminhada","N");
INSERT INTO portuguese_lemma VALUES ("n#00184167","n","caminhada","N");
INSERT INTO portuguese_lemma VALUES ("n#00201629","n","caminhada","N");
INSERT INTO portuguese_lemma VALUES ("a#00283703","a","maçante","N");
INSERT INTO portuguese_lemma VALUES ("a#01291600","a","maçante","N");
INSERT INTO portuguese_lemma VALUES ("r#00283743","r","caoticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00283743","r","de_forma_caótica","Y");
INSERT INTO portuguese_lemma VALUES ("a#00278681","a","opaco","N");
INSERT INTO portuguese_lemma VALUES ("a#00402602","a","opaco","N");
INSERT INTO portuguese_lemma VALUES ("a#00500611","a","opaco","N");
INSERT INTO portuguese_lemma VALUES ("n#00187446","n","dê_uma_volta","Y");
INSERT INTO portuguese_lemma VALUES ("n#00187446","n","passeio","N");
INSERT INTO portuguese_lemma VALUES ("n#00184167","n","passeio","N");
INSERT INTO portuguese_lemma VALUES ("n#00200342","n","passeio","N");
INSERT INTO portuguese_lemma VALUES ("n#00202291","n","passeio","N");
INSERT INTO portuguese_lemma VALUES ("n#04010205","n","passeio","N");
INSERT INTO portuguese_lemma VALUES ("n#03335176","n","passeio","N");
INSERT INTO portuguese_lemma VALUES ("r#00284183","r","de_forma_barata","Y");
INSERT INTO portuguese_lemma VALUES ("r#00284183","r","barato","N");
INSERT INTO portuguese_lemma VALUES ("r#00334210","r","barato","N");
INSERT INTO portuguese_lemma VALUES ("a#00887042","a","barato","N");
INSERT INTO portuguese_lemma VALUES ("n#00285141","n","sonambulismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00195854","v","dourar","N");
INSERT INTO portuguese_lemma VALUES ("v#00222387","v","dourar","N");
INSERT INTO portuguese_lemma VALUES ("r#00285447","r","como_se_deve","Y");
INSERT INTO portuguese_lemma VALUES ("r#00285447","r","como_é_justo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00285447","r","propriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00285447","r","com_precisão","Y");
INSERT INTO portuguese_lemma VALUES ("n#00185003","n","pernada","N");
INSERT INTO portuguese_lemma VALUES ("a#00280184","a","racista","N");
INSERT INTO portuguese_lemma VALUES ("a#01860484","a","racista","N");
INSERT INTO portuguese_lemma VALUES ("a#00286214","a","imparcial","N");
INSERT INTO portuguese_lemma VALUES ("a#00958151","a","imparcial","N");
INSERT INTO portuguese_lemma VALUES ("a#01723308","a","imparcial","N");
INSERT INTO portuguese_lemma VALUES ("a#01660647","a","imparcial","N");
INSERT INTO portuguese_lemma VALUES ("a#00286470","a","cor-cego","N");
INSERT INTO portuguese_lemma VALUES ("n#00286497","n","andar","N");
INSERT INTO portuguese_lemma VALUES ("n#00286957","n","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01253107","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01839538","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01257215","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01260638","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01261299","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01882170","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01299603","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01911698","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01309662","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01919711","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01310603","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01924023","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01924148","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01316088","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01929254","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01929467","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01333288","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#02091165","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#01432910","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#02091689","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#02091885","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#02092476","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#02102002","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("v#02102398","v","andar","N");
INSERT INTO portuguese_lemma VALUES ("n#02700186","n","andar","N");
INSERT INTO portuguese_lemma VALUES ("r#00286667","r","coloquialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00286667","r","informalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00281363","a","católico","N");
INSERT INTO portuguese_lemma VALUES ("a#02696513","a","católico","N");
INSERT INTO portuguese_lemma VALUES ("n#09679925","n","católico","N");
INSERT INTO portuguese_lemma VALUES ("a#00281363","a","universal","N");
INSERT INTO portuguese_lemma VALUES ("a#00493390","a","universal","N");
INSERT INTO portuguese_lemma VALUES ("a#01511497","a","universal","N");
INSERT INTO portuguese_lemma VALUES ("a#01512420","a","universal","N");
INSERT INTO portuguese_lemma VALUES ("n#00287561","n","trote","N");
INSERT INTO portuguese_lemma VALUES ("n#00331225","n","trote","N");
INSERT INTO portuguese_lemma VALUES ("n#00331381","n","trote","N");
INSERT INTO portuguese_lemma VALUES ("n#00485959","n","trote","N");
INSERT INTO portuguese_lemma VALUES ("n#00288000","n","escola_de_equitação","Y");
INSERT INTO portuguese_lemma VALUES ("n#00288000","n","adestramento","N");
INSERT INTO portuguese_lemma VALUES ("a#00288070","a","dogmático","N");
INSERT INTO portuguese_lemma VALUES ("a#03006389","a","dogmático","N");
INSERT INTO portuguese_lemma VALUES ("a#03061982","a","dogmático","N");
INSERT INTO portuguese_lemma VALUES ("r#00288450","r","detalhada","N");
INSERT INTO portuguese_lemma VALUES ("r#00288450","r","de_A_a_Z","Y");
INSERT INTO portuguese_lemma VALUES ("r#00288450","r","de_forma_compreensível","Y");
INSERT INTO portuguese_lemma VALUES ("a#00282562","a","mesquinho","N");
INSERT INTO portuguese_lemma VALUES ("n#00288671","n","galope","N");
INSERT INTO portuguese_lemma VALUES ("n#00187619","n","vagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01284430","v","vagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01882814","v","vagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01298374","v","vagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01925694","v","vagar","N");
INSERT INTO portuguese_lemma VALUES ("v#00198875","v","vermelhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00373451","v","vermelhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00289392","v","encanecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00289392","v","acinzentar","N");
INSERT INTO portuguese_lemma VALUES ("n#00289659","n","rebolar","N");
INSERT INTO portuguese_lemma VALUES ("a#00286089","a","guardado","N");
INSERT INTO portuguese_lemma VALUES ("v#00289840","v","amarelar","N");
INSERT INTO portuguese_lemma VALUES ("n#00188553","n","marcha","N");
INSERT INTO portuguese_lemma VALUES ("n#00356150","n","marcha","N");
INSERT INTO portuguese_lemma VALUES ("n#06233847","n","marcha","N");
INSERT INTO portuguese_lemma VALUES ("v#00291163","v","irradiar","N");
INSERT INTO portuguese_lemma VALUES ("v#02686952","v","irradiar","N");
INSERT INTO portuguese_lemma VALUES ("v#02767116","v","irradiar","N");
INSERT INTO portuguese_lemma VALUES ("v#02768431","v","irradiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00200388","v","desprender","N");
INSERT INTO portuguese_lemma VALUES ("a#00291471","a","fraterno","N");
INSERT INTO portuguese_lemma VALUES ("a#00291471","a","fraternal","N");
INSERT INTO portuguese_lemma VALUES ("a#00292298","a","fraternal","N");
INSERT INTO portuguese_lemma VALUES ("a#02731699","a","fraternal","N");
INSERT INTO portuguese_lemma VALUES ("r#00291589","r","de_forma_criminal","Y");
INSERT INTO portuguese_lemma VALUES ("r#00291589","r","criminalmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00291663","n","logradoura","N");
INSERT INTO portuguese_lemma VALUES ("v#00200741","v","iluminar","N");
INSERT INTO portuguese_lemma VALUES ("v#02763283","v","iluminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00200741","v","brilhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01829747","v","brilhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01830042","v","brilhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01479299","v","brilhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01888557","v","brilhar","N");
INSERT INTO portuguese_lemma VALUES ("v#02764765","v","brilhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01891783","v","brilhar","N");
INSERT INTO portuguese_lemma VALUES ("n#00292125","n","espreita","N");
INSERT INTO portuguese_lemma VALUES ("r#00292349","r","sequencialmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00292611","a","enterrado","N");
INSERT INTO portuguese_lemma VALUES ("r#00292684","r","condicionalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00201632","v","recortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00851394","v","recortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00861159","v","recortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01198965","v","recortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00201632","v","atalhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00317241","v","atalhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01618884","v","atalhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00292937","a","ocupado","N");
INSERT INTO portuguese_lemma VALUES ("a#01623360","a","ocupado","N");
INSERT INTO portuguese_lemma VALUES ("n#00293125","n","moonwalk","N");
INSERT INTO portuguese_lemma VALUES ("v#00293141","v","embelezar","N");
INSERT INTO portuguese_lemma VALUES ("v#01150345","v","embelezar","N");
INSERT INTO portuguese_lemma VALUES ("v#00202346","v","desdobrar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00202346","v","florescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00202730","v","florescer","N");
INSERT INTO portuguese_lemma VALUES ("v#00202881","v","florescer","N");
INSERT INTO portuguese_lemma VALUES ("a#00289934","a","desempregado","N");
INSERT INTO portuguese_lemma VALUES ("a#00865007","a","desempregado","N");
INSERT INTO portuguese_lemma VALUES ("v#00202730","v","florir","N");
INSERT INTO portuguese_lemma VALUES ("v#00202730","v","desabrochar","N");
INSERT INTO portuguese_lemma VALUES ("v#00249893","v","desabrochar","N");
INSERT INTO portuguese_lemma VALUES ("n#00190909","n","carreira","N");
INSERT INTO portuguese_lemma VALUES ("n#00278455","n","carreira","N");
INSERT INTO portuguese_lemma VALUES ("n#00449295","n","carreira","N");
INSERT INTO portuguese_lemma VALUES ("r#00294459","r","conseqüentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00294577","n","contra-ataque","N");
INSERT INTO portuguese_lemma VALUES ("n#00978173","n","contra-ataque","N");
INSERT INTO portuguese_lemma VALUES ("a#00294579","a","vagaroso","N");
INSERT INTO portuguese_lemma VALUES ("a#00294579","a","vadio","N");
INSERT INTO portuguese_lemma VALUES ("n#10197967","n","vadio","N");
INSERT INTO portuguese_lemma VALUES ("a#00294579","a","preguiçoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00294868","n","rastejamento","N");
INSERT INTO portuguese_lemma VALUES ("a#00295235","a","ocioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00295235","a","prazeroso","N");
INSERT INTO portuguese_lemma VALUES ("v#00295346","v","afinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","afinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00295563","v","desafinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00295697","v","calibrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00739536","v","calibrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00191846","n","travessia","N");
INSERT INTO portuguese_lemma VALUES ("n#00191846","n","viagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00198579","n","viagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00202833","n","viagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00312784","n","viagem","N");
INSERT INTO portuguese_lemma VALUES ("v#01839963","v","viagem","N");
INSERT INTO portuguese_lemma VALUES ("v#01260993","v","viagem","N");
INSERT INTO portuguese_lemma VALUES ("v#01855606","v","viagem","N");
INSERT INTO portuguese_lemma VALUES ("n#04449762","n","viagem","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","sintonizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","acomodar","N");
INSERT INTO portuguese_lemma VALUES ("v#00297780","v","acomodar","N");
INSERT INTO portuguese_lemma VALUES ("v#00207661","v","acomodar","N");
INSERT INTO portuguese_lemma VALUES ("v#00415398","v","acomodar","N");
INSERT INTO portuguese_lemma VALUES ("v#02701445","v","acomodar","N");
INSERT INTO portuguese_lemma VALUES ("v#01843927","v","acomodar","N");
INSERT INTO portuguese_lemma VALUES ("v#01870273","v","acomodar","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","regrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","adaptar","N");
INSERT INTO portuguese_lemma VALUES ("v#00297780","v","adaptar","N");
INSERT INTO portuguese_lemma VALUES ("v#00206945","v","adaptar","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","regular","N");
INSERT INTO portuguese_lemma VALUES ("v#00206759","v","regular","N");
INSERT INTO portuguese_lemma VALUES ("a#01891762","a","regular","N");
INSERT INTO portuguese_lemma VALUES ("a#01961937","a","regular","N");
INSERT INTO portuguese_lemma VALUES ("v#00204023","v","ajeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00297780","v","ajeitar","N");
INSERT INTO portuguese_lemma VALUES ("a#00296061","a","ferrado","N");
INSERT INTO portuguese_lemma VALUES ("v#00204190","v","acertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00966768","v","acertar","N");
INSERT INTO portuguese_lemma VALUES ("v#01382085","v","acertar","N");
INSERT INTO portuguese_lemma VALUES ("n#00296263","n","circum-navegação","N");
INSERT INTO portuguese_lemma VALUES ("n#00296263","n","Circumnavegação","N");
INSERT INTO portuguese_lemma VALUES ("n#00296478","n","peregrinação","N");
INSERT INTO portuguese_lemma VALUES ("n#00311687","n","peregrinação","N");
INSERT INTO portuguese_lemma VALUES ("n#06233236","n","procissão","N");
INSERT INTO portuguese_lemma VALUES ("n#07327288","n","procissão","N");
INSERT INTO portuguese_lemma VALUES ("n#06248227","n","procissão","N");
INSERT INTO portuguese_lemma VALUES ("n#06233236","n","romaria","N");
INSERT INTO portuguese_lemma VALUES ("r#00296836","r","misteriosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00297062","n","vagabundagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00297062","n","vagear","N");
INSERT INTO portuguese_lemma VALUES ("n#00297404","n","drift","N");
INSERT INTO portuguese_lemma VALUES ("v#00297507","v","zerar","N");
INSERT INTO portuguese_lemma VALUES ("n#00297657","n","vau","N");
INSERT INTO portuguese_lemma VALUES ("n#09283623","n","vau","N");
INSERT INTO portuguese_lemma VALUES ("a#02759618","a","socialista","N");
INSERT INTO portuguese_lemma VALUES ("n#07588809","n","socialista","N");
INSERT INTO portuguese_lemma VALUES ("n#00193473","n","turismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00298244","v","engrenar","N");
INSERT INTO portuguese_lemma VALUES ("v#00298244","v","passar_a_marcha","Y");
INSERT INTO portuguese_lemma VALUES ("a#00294050","a","coletivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00435502","a","coletivo","N");
INSERT INTO portuguese_lemma VALUES ("a#02038355","a","coletivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00294050","a","colectivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00435502","a","colectivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00298351","n","eco-turismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00298351","n","ecoturismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00298420","v","entoar","N");
INSERT INTO portuguese_lemma VALUES ("v#01050313","v","entoar","N");
INSERT INTO portuguese_lemma VALUES ("n#00298497","n","condução","N");
INSERT INTO portuguese_lemma VALUES ("n#11512818","n","condução","N");
INSERT INTO portuguese_lemma VALUES ("a#00298767","a","cacofônico","N");
INSERT INTO portuguese_lemma VALUES ("v#00298773","v","reiniciar","N");
INSERT INTO portuguese_lemma VALUES ("a#00295066","a","áspero","N");
INSERT INTO portuguese_lemma VALUES ("a#01730738","a","áspero","N");
INSERT INTO portuguese_lemma VALUES ("a#02132734","a","áspero","N");
INSERT INTO portuguese_lemma VALUES ("a#02243086","a","áspero","N");
INSERT INTO portuguese_lemma VALUES ("v#00206945","v","adequar","N");
INSERT INTO portuguese_lemma VALUES ("a#00295224","a","rouco","N");
INSERT INTO portuguese_lemma VALUES ("a#00295224","a","rouquenho","N");
INSERT INTO portuguese_lemma VALUES ("a#00295224","a","rouca","N");
INSERT INTO portuguese_lemma VALUES ("r#00299753","r","densamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00323315","r","densamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00299933","n","enduro_equestre","Y");
INSERT INTO portuguese_lemma VALUES ("n#00299933","n","Enduro_eqüestre","Y");
INSERT INTO portuguese_lemma VALUES ("n#00300113","n","Trilha_montada","Y");
INSERT INTO portuguese_lemma VALUES ("r#00300247","r","talvez","N");
INSERT INTO portuguese_lemma VALUES ("r#00300247","r","quiçá","N");
INSERT INTO portuguese_lemma VALUES ("r#00300247","r","por_ventura","Y");
INSERT INTO portuguese_lemma VALUES ("r#00300247","r","vai_ver","Y");
INSERT INTO portuguese_lemma VALUES ("r#00300247","r","acaso","N");
INSERT INTO portuguese_lemma VALUES ("r#00420004","r","acaso","N");
INSERT INTO portuguese_lemma VALUES ("r#00300247","r","porventura","N");
INSERT INTO portuguese_lemma VALUES ("r#00420004","r","porventura","N");
INSERT INTO portuguese_lemma VALUES ("a#00300359","a","estridente","N");
INSERT INTO portuguese_lemma VALUES ("a#00713853","a","estridente","N");
INSERT INTO portuguese_lemma VALUES ("a#01163535","a","estridente","N");
INSERT INTO portuguese_lemma VALUES ("n#00194802","n","aviação","N");
INSERT INTO portuguese_lemma VALUES ("n#00195810","n","aviação","N");
INSERT INTO portuguese_lemma VALUES ("n#06096913","n","aviação","N");
INSERT INTO portuguese_lemma VALUES ("r#00300682","r","impossivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00300682","r","impossìvel","N");
INSERT INTO portuguese_lemma VALUES ("a#00300738","a","eufónico","N");
INSERT INTO portuguese_lemma VALUES ("a#01455221","a","eufónico","N");
INSERT INTO portuguese_lemma VALUES ("a#00300738","a","harmonioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00508036","a","harmonioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00529370","a","harmonioso","N");
INSERT INTO portuguese_lemma VALUES ("a#01163083","a","harmonioso","N");
INSERT INTO portuguese_lemma VALUES ("a#01455221","a","harmonioso","N");
INSERT INTO portuguese_lemma VALUES ("r#00300891","r","potencialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00301039","r","absurdamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00301187","a","calculável","N");
INSERT INTO portuguese_lemma VALUES ("n#00195002","n","vôo","N");
INSERT INTO portuguese_lemma VALUES ("n#06102095","n","vôo","N");
INSERT INTO portuguese_lemma VALUES ("v#00301338","v","dyskwalifikować","N");
INSERT INTO portuguese_lemma VALUES ("v#00301338","v","inabilitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00301338","v","desqualificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00972608","v","desqualificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00301432","a","computável","N");
INSERT INTO portuguese_lemma VALUES ("v#00301544","v","calçadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#04200537","n","calçadeira","N");
INSERT INTO portuguese_lemma VALUES ("v#00326672","v","fazer_veste_para_homem","Y");
INSERT INTO portuguese_lemma VALUES ("v#00301856","v","domesticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00302130","v","domesticar","N");
INSERT INTO portuguese_lemma VALUES ("a#00297667","a","inumerável","N");
INSERT INTO portuguese_lemma VALUES ("a#00297667","a","sem_número","Y");
INSERT INTO portuguese_lemma VALUES ("a#00297667","a","incontável","N");
INSERT INTO portuguese_lemma VALUES ("a#00297667","a","inúmero","N");
INSERT INTO portuguese_lemma VALUES ("v#00302130","v","domar","N");
INSERT INTO portuguese_lemma VALUES ("n#00195810","n","voo","N");
INSERT INTO portuguese_lemma VALUES ("a#00302436","a","inestimável","N");
INSERT INTO portuguese_lemma VALUES ("a#02501367","a","inestimável","N");
INSERT INTO portuguese_lemma VALUES ("a#00298353","a","pacato","N");
INSERT INTO portuguese_lemma VALUES ("n#00302861","n","acrobacia_aérea","Y");
INSERT INTO portuguese_lemma VALUES ("v#00302875","v","enrijar","N");
INSERT INTO portuguese_lemma VALUES ("a#00765651","a","quieto","N");
INSERT INTO portuguese_lemma VALUES ("a#01849351","a","quieto","N");
INSERT INTO portuguese_lemma VALUES ("a#00765651","a","silenciosa","N");
INSERT INTO portuguese_lemma VALUES ("n#00303495","n","Voo_a_vela","Y");
INSERT INTO portuguese_lemma VALUES ("v#00209671","v","alargar","N");
INSERT INTO portuguese_lemma VALUES ("a#00303727","a","tempestuoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00299475","a","tempestuoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01680632","a","tempestuoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00303748","n","Asa_delta","Y");
INSERT INTO portuguese_lemma VALUES ("n#00303748","n","asa-delta","N");
INSERT INTO portuguese_lemma VALUES ("n#03491032","n","asa-delta","N");
INSERT INTO portuguese_lemma VALUES ("n#00303849","n","paraquedismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00304349","n","para-pente","N");
INSERT INTO portuguese_lemma VALUES ("n#00304349","n","parapente","N");
INSERT INTO portuguese_lemma VALUES ("v#00210399","v","apertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00291977","v","apertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00292159","v","apertar","N");
INSERT INTO portuguese_lemma VALUES ("v#01456771","v","apertar","N");
INSERT INTO portuguese_lemma VALUES ("a#00304455","a","ondeante","N");
INSERT INTO portuguese_lemma VALUES ("r#00304787","r","o_dia_inteiro","Y");
INSERT INTO portuguese_lemma VALUES ("r#00304787","r","diurnamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00210830","v","estreitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00291977","v","estreitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00292159","v","estreitar","N");
INSERT INTO portuguese_lemma VALUES ("a#00305225","a","ventoso","N");
INSERT INTO portuguese_lemma VALUES ("n#09880741","n","ventoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00305283","r","de_boa_vontade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00305431","r","a_contragosto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00305464","a","encaracolado","N");
INSERT INTO portuguese_lemma VALUES ("a#01030022","a","encaracolado","N");
INSERT INTO portuguese_lemma VALUES ("a#01030372","a","encaracolado","N");
INSERT INTO portuguese_lemma VALUES ("v#00305537","v","dilatar","N");
INSERT INTO portuguese_lemma VALUES ("v#00305846","v","implodir","N");
INSERT INTO portuguese_lemma VALUES ("v#00211486","v","detonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00306298","v","detonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00306723","v","detonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01077449","v","detonar","N");
INSERT INTO portuguese_lemma VALUES ("n#00198579","n","jornada","N");
INSERT INTO portuguese_lemma VALUES ("n#10883946","n","jornada","N");
INSERT INTO portuguese_lemma VALUES ("n#00198945","n","etapa","N");
INSERT INTO portuguese_lemma VALUES ("n#10843624","n","etapa","N");
INSERT INTO portuguese_lemma VALUES ("a#00301854","a","habilidoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02120998","a","habilidoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00301854","a","desenvolto","N");
INSERT INTO portuguese_lemma VALUES ("a#00301854","a","inventivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00607344","a","inventivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00212110","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("v#00212214","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("v#00309310","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("v#00486605","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("v#01078339","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("v#01759021","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("v#01219416","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("v#02761012","v","explodir","N");
INSERT INTO portuguese_lemma VALUES ("n#00307455","n","comute","N");
INSERT INTO portuguese_lemma VALUES ("v#00307568","v","entrar_em_erupção","Y");
INSERT INTO portuguese_lemma VALUES ("v#00212614","v","flamejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00212614","v","coruscar","N");
INSERT INTO portuguese_lemma VALUES ("v#00212614","v","chamejar","N");
INSERT INTO portuguese_lemma VALUES ("n#00308279","n","odisseia","N");
INSERT INTO portuguese_lemma VALUES ("a#00308355","a","bem_cuidado","Y");
INSERT INTO portuguese_lemma VALUES ("n#00199642","n","excursão","N");
INSERT INTO portuguese_lemma VALUES ("n#00201294","n","excursão","N");
INSERT INTO portuguese_lemma VALUES ("n#00202291","n","excursão","N");
INSERT INTO portuguese_lemma VALUES ("a#00308593","a","desamparado","N");
INSERT INTO portuguese_lemma VALUES ("n#00200009","n","trajecto","N");
INSERT INTO portuguese_lemma VALUES ("n#00200009","n","trajeto","N");
INSERT INTO portuguese_lemma VALUES ("r#00308916","r","diabolicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00308916","r","de_forma_diabólica","Y");
INSERT INTO portuguese_lemma VALUES ("a#00303585","a","cuidadosa","N");
INSERT INTO portuguese_lemma VALUES ("a#00303585","a","prudente","N");
INSERT INTO portuguese_lemma VALUES ("a#00317140","a","prudente","N");
INSERT INTO portuguese_lemma VALUES ("a#01825807","a","prudente","N");
INSERT INTO portuguese_lemma VALUES ("a#02569558","a","prudente","N");
INSERT INTO portuguese_lemma VALUES ("a#00303585","a","cautelosa","N");
INSERT INTO portuguese_lemma VALUES ("n#00309276","n","carona","N");
INSERT INTO portuguese_lemma VALUES ("n#10178077","n","carona","N");
INSERT INTO portuguese_lemma VALUES ("v#00309310","v","arrebentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00309310","v","estourar","N");
INSERT INTO portuguese_lemma VALUES ("v#00303520","v","estourar","N");
INSERT INTO portuguese_lemma VALUES ("v#00862467","v","estourar","N");
INSERT INTO portuguese_lemma VALUES ("r#00309515","r","destrutivamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00309632","r","de_forma_detestável","Y");
INSERT INTO portuguese_lemma VALUES ("r#00309632","r","detestavelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00309906","n","Safari","N");
INSERT INTO portuguese_lemma VALUES ("n#00309906","n","Safári","N");
INSERT INTO portuguese_lemma VALUES ("n#00201174","n","exploração","N");
INSERT INTO portuguese_lemma VALUES ("n#00271815","n","exploração","N");
INSERT INTO portuguese_lemma VALUES ("n#00420720","n","exploração","N");
INSERT INTO portuguese_lemma VALUES ("n#00604772","n","exploração","N");
INSERT INTO portuguese_lemma VALUES ("n#00606479","n","exploração","N");
INSERT INTO portuguese_lemma VALUES ("n#04459855","n","exploração","N");
INSERT INTO portuguese_lemma VALUES ("a#00310138","a","consciencioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00310138","a","consciensiosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00214424","v","vigorar","N");
INSERT INTO portuguese_lemma VALUES ("a#00304990","a","minucioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00304990","a","circunstanciado","N");
INSERT INTO portuguese_lemma VALUES ("a#00304990","a","elaborada","N");
INSERT INTO portuguese_lemma VALUES ("a#00304990","a","pormenorizado","N");
INSERT INTO portuguese_lemma VALUES ("a#00304990","a","elaborado","N");
INSERT INTO portuguese_lemma VALUES ("v#00310635","v","proliferar","N");
INSERT INTO portuguese_lemma VALUES ("n#00201629","n","turnê","N");
INSERT INTO portuguese_lemma VALUES ("r#00310720","r","diagonalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00311559","v","escurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00216063","v","escurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#02771020","v","escurecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00311663","a","descuidado","N");
INSERT INTO portuguese_lemma VALUES ("a#00311663","a","negligente","N");
INSERT INTO portuguese_lemma VALUES ("a#00719719","a","negligente","N");
INSERT INTO portuguese_lemma VALUES ("n#00311687","n","Lugares_de_peregrinação_religiosa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00311687","n","peregrinagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00202291","n","viagem_de_recreio","Y");
INSERT INTO portuguese_lemma VALUES ("n#00202291","n","ida","N");
INSERT INTO portuguese_lemma VALUES ("v#00216484","v","lapidar","N");
INSERT INTO portuguese_lemma VALUES ("v#01323518","v","lapidar","N");
INSERT INTO portuguese_lemma VALUES ("n#00312932","n","cruzeiros","N");
INSERT INTO portuguese_lemma VALUES ("n#00312932","n","cruzeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#03141327","n","cruzeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#00312932","n","cruzeiros_(recreio)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00312932","n","velejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01325658","v","velejar","N");
INSERT INTO portuguese_lemma VALUES ("r#00313092","r","de_forma_desastrosa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00313092","r","desastrosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00313387","a","carnívoro","N");
INSERT INTO portuguese_lemma VALUES ("n#01324431","n","carnívoro","N");
INSERT INTO portuguese_lemma VALUES ("a#02680580","a","carnívoro","N");
INSERT INTO portuguese_lemma VALUES ("n#00313502","n","viagem_espacial","Y");
INSERT INTO portuguese_lemma VALUES ("r#00313633","r","ignominiosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00203714","n","Iatismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00203714","n","Náutica","N");
INSERT INTO portuguese_lemma VALUES ("n#05639832","n","Náutica","N");
INSERT INTO portuguese_lemma VALUES ("n#00203714","n","navegação","N");
INSERT INTO portuguese_lemma VALUES ("n#00204151","n","navegação","N");
INSERT INTO portuguese_lemma VALUES ("n#00521429","n","navegação","N");
INSERT INTO portuguese_lemma VALUES ("n#00716331","n","navegação","N");
INSERT INTO portuguese_lemma VALUES ("n#00203714","n","Vela","N");
INSERT INTO portuguese_lemma VALUES ("n#02375096","n","Vela","N");
INSERT INTO portuguese_lemma VALUES ("n#09470343","n","Vela","N");
INSERT INTO portuguese_lemma VALUES ("v#00217744","v","apagar","N");
INSERT INTO portuguese_lemma VALUES ("v#00333717","v","apagar","N");
INSERT INTO portuguese_lemma VALUES ("v#00676082","v","apagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01066360","v","apagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01066739","v","apagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01114673","v","apagar","N");
INSERT INTO portuguese_lemma VALUES ("v#02761897","v","apagar","N");
INSERT INTO portuguese_lemma VALUES ("v#00217744","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#00825871","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#01017466","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#01467965","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#02145429","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#01468595","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#01469149","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#02147109","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#01469864","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#01469958","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#02148369","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#02157731","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("v#01477149","v","esconder","N");
INSERT INTO portuguese_lemma VALUES ("a#00314023","a","herbívoro","N");
INSERT INTO portuguese_lemma VALUES ("n#01324610","n","herbívoro","N");
INSERT INTO portuguese_lemma VALUES ("r#00314384","r","honestamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00314835","r","honestamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00204151","n","Navegacão","N");
INSERT INTO portuguese_lemma VALUES ("n#00204151","n","Navegação","N");
INSERT INTO portuguese_lemma VALUES ("r#00314597","r","desonestamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00218146","v","focalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00731789","v","focalizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00314835","r","sem_rodeios","Y");
INSERT INTO portuguese_lemma VALUES ("n#00315307","n","cabotagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00315700","n","migrações_diárias","Y");
INSERT INTO portuguese_lemma VALUES ("n#00204553","n","transporte","N");
INSERT INTO portuguese_lemma VALUES ("n#00716041","n","transporte","N");
INSERT INTO portuguese_lemma VALUES ("r#00316103","r","lealmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00316318","r","deslealmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00316390","v","ensurdecer","N");
INSERT INTO portuguese_lemma VALUES ("v#02189940","v","ensurdecer","N");
INSERT INTO portuguese_lemma VALUES ("v#02190077","v","ensurdecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00316594","n","Transporte_aéreo_táctico","Y");
INSERT INTO portuguese_lemma VALUES ("n#00316594","n","Transporte_aéreo_tático","Y");
INSERT INTO portuguese_lemma VALUES ("a#00311062","a","esculpido","N");
INSERT INTO portuguese_lemma VALUES ("a#00311062","a","entalhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00311062","a","talhado","N");
INSERT INTO portuguese_lemma VALUES ("n#00205135","n","entrega","N");
INSERT INTO portuguese_lemma VALUES ("v#00317241","v","truncar","N");
INSERT INTO portuguese_lemma VALUES ("r#00317390","r","insensivelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00220692","v","prolongar","N");
INSERT INTO portuguese_lemma VALUES ("v#01421865","v","prolongar","N");
INSERT INTO portuguese_lemma VALUES ("v#00220692","v","extender","N");
INSERT INTO portuguese_lemma VALUES ("v#00221402","v","extender","N");
INSERT INTO portuguese_lemma VALUES ("n#00317917","n","consignação","N");
INSERT INTO portuguese_lemma VALUES ("n#00205456","n","citação","N");
INSERT INTO portuguese_lemma VALUES ("n#04922423","n","citação","N");
INSERT INTO portuguese_lemma VALUES ("n#04922905","n","citação","N");
INSERT INTO portuguese_lemma VALUES ("n#04960176","n","citação","N");
INSERT INTO portuguese_lemma VALUES ("n#05068012","n","citação","N");
INSERT INTO portuguese_lemma VALUES ("a#00312617","a","basal","N");
INSERT INTO portuguese_lemma VALUES ("n#00318735","n","carregue","N");
INSERT INTO portuguese_lemma VALUES ("n#00318735","n","Carry_trade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00319275","r","respeitosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00319635","r","com_reserva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00319635","r","a_distância","Y");
INSERT INTO portuguese_lemma VALUES ("v#00222083","v","cozer","N");
INSERT INTO portuguese_lemma VALUES ("v#00222083","v","fornear","N");
INSERT INTO portuguese_lemma VALUES ("v#00222083","v","assar","N");
INSERT INTO portuguese_lemma VALUES ("v#00320536","v","assar","N");
INSERT INTO portuguese_lemma VALUES ("v#00324560","v","assar","N");
INSERT INTO portuguese_lemma VALUES ("v#01142646","v","assar","N");
INSERT INTO portuguese_lemma VALUES ("n#00206677","n","caçada","N");
INSERT INTO portuguese_lemma VALUES ("n#00206677","n","perseguição","N");
INSERT INTO portuguese_lemma VALUES ("n#00269249","n","perseguição","N");
INSERT INTO portuguese_lemma VALUES ("v#00222387","v","gratinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00222387","v","tornar-se_castanho","Y");
INSERT INTO portuguese_lemma VALUES ("v#00222387","v","acastanhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00222387","v","tostar","N");
INSERT INTO portuguese_lemma VALUES ("v#00322151","v","tostar","N");
INSERT INTO portuguese_lemma VALUES ("n#00320284","n","rastreamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00320284","n","rastreio","N");
INSERT INTO portuguese_lemma VALUES ("n#00320625","n","stalking","N");
INSERT INTO portuguese_lemma VALUES ("r#00320777","r","de_forma_perturbante","Y");
INSERT INTO portuguese_lemma VALUES ("n#00207301","n","inserção","N");
INSERT INTO portuguese_lemma VALUES ("n#00321195","n","intubação","N");
INSERT INTO portuguese_lemma VALUES ("n#00321195","n","Intubação_endotraqueal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00321562","n","cateterismo","N");
INSERT INTO portuguese_lemma VALUES ("r#00322112","r","dubitavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00322112","r","de_forma_duvidosa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00322112","r","duvidosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00437796","r","duvidosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00322321","a","Acaule","N");
INSERT INTO portuguese_lemma VALUES ("n#00208372","n","injeção","N");
INSERT INTO portuguese_lemma VALUES ("n#00447102","n","injeção","N");
INSERT INTO portuguese_lemma VALUES ("v#00223888","v","cozinhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01142893","v","cozinhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01143604","v","cozinhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00323199","a","causal","N");
INSERT INTO portuguese_lemma VALUES ("n#00323532","n","infusão","N");
INSERT INTO portuguese_lemma VALUES ("n#07933891","n","infusão","N");
INSERT INTO portuguese_lemma VALUES ("v#00323571","v","cozinhar_demais","Y");
INSERT INTO portuguese_lemma VALUES ("r#00323666","r","dinamicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00323786","r","para","N");
INSERT INTO portuguese_lemma VALUES ("v#00323856","v","estufar","N");
INSERT INTO portuguese_lemma VALUES ("n#00324056","n","transfusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00324056","n","transfusão_de_sangue","Y");
INSERT INTO portuguese_lemma VALUES ("n#00324056","n","Transfusão_de_Sangue","Y");
INSERT INTO portuguese_lemma VALUES ("n#00324233","n","Perfusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00324233","n","perfusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00209440","n","ascensão","N");
INSERT INTO portuguese_lemma VALUES ("a#00316393","a","motriz","N");
INSERT INTO portuguese_lemma VALUES ("a#00316393","a","motor","N");
INSERT INTO portuguese_lemma VALUES ("a#02666201","a","motor","N");
INSERT INTO portuguese_lemma VALUES ("n#03287733","n","motor","N");
INSERT INTO portuguese_lemma VALUES ("n#03017435","n","motor","N");
INSERT INTO portuguese_lemma VALUES ("n#07769591","n","motor","N");
INSERT INTO portuguese_lemma VALUES ("v#00324560","v","torrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00324806","v","fazer_churrasco","Y");
INSERT INTO portuguese_lemma VALUES ("v#00324806","v","grelhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00328370","v","grelhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00316737","a","responsável","N");
INSERT INTO portuguese_lemma VALUES ("a#01923949","a","responsável","N");
INSERT INTO portuguese_lemma VALUES ("a#02253454","a","responsável","N");
INSERT INTO portuguese_lemma VALUES ("a#01997221","a","responsável","N");
INSERT INTO portuguese_lemma VALUES ("a#01924743","a","responsável","N");
INSERT INTO portuguese_lemma VALUES ("a#02465350","a","responsável","N");
INSERT INTO portuguese_lemma VALUES ("n#07311393","n","responsável","N");
INSERT INTO portuguese_lemma VALUES ("n#07469314","n","responsável","N");
INSERT INTO portuguese_lemma VALUES ("n#00324978","n","Funambulismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00209737","n","escalada","N");
INSERT INTO portuguese_lemma VALUES ("n#00325631","n","escalada","N");
INSERT INTO portuguese_lemma VALUES ("n#07370410","n","escalada","N");
INSERT INTO portuguese_lemma VALUES ("n#05487790","n","escalada","N");
INSERT INTO portuguese_lemma VALUES ("a#00317140","a","cauto","N");
INSERT INTO portuguese_lemma VALUES ("v#00225669","v","fritar","N");
INSERT INTO portuguese_lemma VALUES ("r#00325603","r","educacionalmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00325785","n","alpinismo","N");
INSERT INTO portuguese_lemma VALUES ("r#00326324","r","eficientemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00326324","r","eficazmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00210530","n","descensão","N");
INSERT INTO portuguese_lemma VALUES ("a#00326608","a","tumultuante","N");
INSERT INTO portuguese_lemma VALUES ("r#00326968","r","de_forma_demonstrativa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00326968","r","demonstrativamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00318757","a","celular","N");
INSERT INTO portuguese_lemma VALUES ("n#02992529","n","celular","N");
INSERT INTO portuguese_lemma VALUES ("r#00327408","r","de_forma_elegante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00327601","r","de_forma_elegante","Y");
INSERT INTO portuguese_lemma VALUES ("r#00327408","r","elegantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00327601","r","elegantemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00327408","r","com_elegância","Y");
INSERT INTO portuguese_lemma VALUES ("r#00327601","r","com_elegância","Y");
INSERT INTO portuguese_lemma VALUES ("a#00327690","a","Alveolata","N");
INSERT INTO portuguese_lemma VALUES ("v#00327813","v","fermentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00327813","v","tramar","N");
INSERT INTO portuguese_lemma VALUES ("a#00328017","a","pluricelular","N");
INSERT INTO portuguese_lemma VALUES ("a#00328017","a","multicelular","N");
INSERT INTO portuguese_lemma VALUES ("a#00328128","a","Acytota","N");
INSERT INTO portuguese_lemma VALUES ("a#00328128","a","acelular","N");
INSERT INTO portuguese_lemma VALUES ("n#00328230","n","reentrada","N");
INSERT INTO portuguese_lemma VALUES ("r#00328378","r","eminentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00328502","n","deslizamento","N");
INSERT INTO portuguese_lemma VALUES ("n#07405579","n","deslizamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00328802","v","brotar","N");
INSERT INTO portuguese_lemma VALUES ("v#00357667","v","brotar","N");
INSERT INTO portuguese_lemma VALUES ("v#00328802","v","ramificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00329244","v","ramificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00329031","n","derrapagem","N");
INSERT INTO portuguese_lemma VALUES ("v#00329244","v","desgalhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00329244","v","ramificar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00329396","a","poroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01397998","a","poroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01772305","a","poroso","N");
INSERT INTO portuguese_lemma VALUES ("n#00329468","n","Snowboard","N");
INSERT INTO portuguese_lemma VALUES ("n#04251791","n","Snowboard","N");
INSERT INTO portuguese_lemma VALUES ("n#00212509","n","inundação","N");
INSERT INTO portuguese_lemma VALUES ("n#00817192","n","inundação","N");
INSERT INTO portuguese_lemma VALUES ("n#07796648","n","inundação","N");
INSERT INTO portuguese_lemma VALUES ("n#00212509","n","enchente","N");
INSERT INTO portuguese_lemma VALUES ("n#00804708","n","enchente","N");
INSERT INTO portuguese_lemma VALUES ("n#07796648","n","enchente","N");
INSERT INTO portuguese_lemma VALUES ("a#02712055","a","central","N");
INSERT INTO portuguese_lemma VALUES ("a#00330728","a","central","N");
INSERT INTO portuguese_lemma VALUES ("a#01224859","a","central","N");
INSERT INTO portuguese_lemma VALUES ("a#02494716","a","central","N");
INSERT INTO portuguese_lemma VALUES ("n#02994858","n","central","N");
INSERT INTO portuguese_lemma VALUES ("n#04373264","n","central","N");
INSERT INTO portuguese_lemma VALUES ("n#00212615","n","efusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00330035","n","engatinhamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00330144","v","pulverizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00330160","n","aceleração","N");
INSERT INTO portuguese_lemma VALUES ("n#00330457","n","aceleração","N");
INSERT INTO portuguese_lemma VALUES ("n#05060783","n","aceleração","N");
INSERT INTO portuguese_lemma VALUES ("n#15275851","n","aceleração","N");
INSERT INTO portuguese_lemma VALUES ("a#00330396","a","bifocal","N");
INSERT INTO portuguese_lemma VALUES ("n#00330457","n","aumento_na_velocidade","Y");
INSERT INTO portuguese_lemma VALUES ("r#00330505","r","eticamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00330505","r","de_forma_ética","Y");
INSERT INTO portuguese_lemma VALUES ("a#00330904","a","focal","N");
INSERT INTO portuguese_lemma VALUES ("a#02881438","a","focal","N");
INSERT INTO portuguese_lemma VALUES ("v#00229305","v","moer","N");
INSERT INTO portuguese_lemma VALUES ("v#00332017","v","moer","N");
INSERT INTO portuguese_lemma VALUES ("v#00229305","v","triturar","N");
INSERT INTO portuguese_lemma VALUES ("n#00331102","n","transplante","N");
INSERT INTO portuguese_lemma VALUES ("n#00693679","n","transplante","N");
INSERT INTO portuguese_lemma VALUES ("r#00331194","r","de_maneira_justa","Y");
INSERT INTO portuguese_lemma VALUES ("a#00322942","a","nuclear","N");
INSERT INTO portuguese_lemma VALUES ("a#00576833","a","nuclear","N");
INSERT INTO portuguese_lemma VALUES ("a#02650931","a","nuclear","N");
INSERT INTO portuguese_lemma VALUES ("a#02651049","a","nuclear","N");
INSERT INTO portuguese_lemma VALUES ("a#00322942","a","atómico","N");
INSERT INTO portuguese_lemma VALUES ("a#00576833","a","atómico","N");
INSERT INTO portuguese_lemma VALUES ("a#02650931","a","atómico","N");
INSERT INTO portuguese_lemma VALUES ("a#02651049","a","atómico","N");
INSERT INTO portuguese_lemma VALUES ("a#02667673","a","atómico","N");
INSERT INTO portuguese_lemma VALUES ("a#02677239","a","periférico","N");
INSERT INTO portuguese_lemma VALUES ("a#01786003","a","periférico","N");
INSERT INTO portuguese_lemma VALUES ("n#03916720","n","periférico","N");
INSERT INTO portuguese_lemma VALUES ("a#00331716","a","circunferencial","N");
INSERT INTO portuguese_lemma VALUES ("v#00332154","v","esmiuçar","N");
INSERT INTO portuguese_lemma VALUES ("a#00332375","a","centrífugo","N");
INSERT INTO portuguese_lemma VALUES ("a#02666201","a","centrífugo","N");
INSERT INTO portuguese_lemma VALUES ("a#00335225","a","centrífugo","N");
INSERT INTO portuguese_lemma VALUES ("r#00332596","r","para_todo_o_sempre","Y");
INSERT INTO portuguese_lemma VALUES ("r#00332714","r","excitadamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00332869","a","centrípeto","N");
INSERT INTO portuguese_lemma VALUES ("a#00325147","a","centrípeto","N");
INSERT INTO portuguese_lemma VALUES ("a#00334852","a","centrípeto","N");
INSERT INTO portuguese_lemma VALUES ("n#00333037","n","abducção","N");
INSERT INTO portuguese_lemma VALUES ("n#00775460","n","abducção","N");
INSERT INTO portuguese_lemma VALUES ("n#00333037","n","abdução","N");
INSERT INTO portuguese_lemma VALUES ("n#00775460","n","abdução","N");
INSERT INTO portuguese_lemma VALUES ("n#00333203","n","adução","N");
INSERT INTO portuguese_lemma VALUES ("v#00333277","v","subdividir","N");
INSERT INTO portuguese_lemma VALUES ("a#00333351","a","aferente","N");
INSERT INTO portuguese_lemma VALUES ("n#00214309","n","agitação","N");
INSERT INTO portuguese_lemma VALUES ("n#00347652","n","agitação","N");
INSERT INTO portuguese_lemma VALUES ("n#10070620","n","agitação","N");
INSERT INTO portuguese_lemma VALUES ("a#00325147","a","sensorial","N");
INSERT INTO portuguese_lemma VALUES ("a#02033738","a","sensorial","N");
INSERT INTO portuguese_lemma VALUES ("a#02602652","a","sensorial","N");
INSERT INTO portuguese_lemma VALUES ("v#00230815","v","britar","N");
INSERT INTO portuguese_lemma VALUES ("v#00230815","v","estilhaçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00230815","v","destroçar","N");
INSERT INTO portuguese_lemma VALUES ("v#01077449","v","destroçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00231062","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#00397576","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#00345357","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01294182","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01294396","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#00887219","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#00887884","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01001075","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01007120","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01073112","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01073802","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01075495","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01075648","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#02030158","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01388242","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#02031622","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#02430580","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#01788872","v","separar","N");
INSERT INTO portuguese_lemma VALUES ("v#00231062","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#00397576","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#00399074","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#00433595","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#00857046","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01279833","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#00999598","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01001075","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01459542","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01459696","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01007120","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01550817","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01069335","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01073112","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01073802","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01075495","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01075648","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01563005","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01077267","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01083862","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01388242","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01569784","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01681144","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("v#01788872","v","dividir","N");
INSERT INTO portuguese_lemma VALUES ("n#00334356","n","dardo","N");
INSERT INTO portuguese_lemma VALUES ("n#02545362","n","dardo","N");
INSERT INTO portuguese_lemma VALUES ("n#00215081","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#04693804","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#05085885","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#05090749","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#05097156","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#05144580","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#09185280","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#11447319","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#09611330","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#09919371","n","sinal","N");
INSERT INTO portuguese_lemma VALUES ("n#00215081","n","gesto","N");
INSERT INTO portuguese_lemma VALUES ("n#00796865","n","gesto","N");
INSERT INTO portuguese_lemma VALUES ("n#05146255","n","gesto","N");
INSERT INTO portuguese_lemma VALUES ("n#05146366","n","gesto","N");
INSERT INTO portuguese_lemma VALUES ("r#00334870","r","expressivamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00215471","n","injecção","N");
INSERT INTO portuguese_lemma VALUES ("v#00231588","v","romper","N");
INSERT INTO portuguese_lemma VALUES ("v#02535457","v","romper","N");
INSERT INTO portuguese_lemma VALUES ("r#00335040","r","inexpressivamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00335285","n","mudra","N");
INSERT INTO portuguese_lemma VALUES ("n#00215794","n","inclinação","N");
INSERT INTO portuguese_lemma VALUES ("n#04943578","n","inclinação","N");
INSERT INTO portuguese_lemma VALUES ("n#03955797","n","inclinação","N");
INSERT INTO portuguese_lemma VALUES ("n#03956088","n","inclinação","N");
INSERT INTO portuguese_lemma VALUES ("n#06199561","n","inclinação","N");
INSERT INTO portuguese_lemma VALUES ("n#04701508","n","inclinação","N");
INSERT INTO portuguese_lemma VALUES ("n#10007887","n","inclinação","N");
INSERT INTO portuguese_lemma VALUES ("v#00232021","v","amaciar","N");
INSERT INTO portuguese_lemma VALUES ("r#00336065","r","de_forma_incorreta","Y");
INSERT INTO portuguese_lemma VALUES ("a#00327632","a","incerto","N");
INSERT INTO portuguese_lemma VALUES ("a#02019649","a","incerto","N");
INSERT INTO portuguese_lemma VALUES ("a#00332689","a","incerto","N");
INSERT INTO portuguese_lemma VALUES ("a#00522821","a","incerto","N");
INSERT INTO portuguese_lemma VALUES ("a#01982394","a","incerto","N");
INSERT INTO portuguese_lemma VALUES ("a#02009056","a","incerto","N");
INSERT INTO portuguese_lemma VALUES ("v#00232529","v","partir-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00232529","v","quebrar-se","N");
INSERT INTO portuguese_lemma VALUES ("r#00336293","r","falsamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00399974","r","falsamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00336293","r","mentirosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00399974","r","mentirosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00216454","n","aceno","N");
INSERT INTO portuguese_lemma VALUES ("n#05097156","n","aceno","N");
INSERT INTO portuguese_lemma VALUES ("n#00336561","n","nutação","N");
INSERT INTO portuguese_lemma VALUES ("r#00336567","r","familiarmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00336654","n","incline","N");
INSERT INTO portuguese_lemma VALUES ("a#00328258","a","certo","N");
INSERT INTO portuguese_lemma VALUES ("a#00331522","a","certo","N");
INSERT INTO portuguese_lemma VALUES ("a#00595353","a","certo","N");
INSERT INTO portuguese_lemma VALUES ("a#00595724","a","certo","N");
INSERT INTO portuguese_lemma VALUES ("a#00867566","a","certo","N");
INSERT INTO portuguese_lemma VALUES ("v#00336922","v","fazer_uma_fissura","Y");
INSERT INTO portuguese_lemma VALUES ("v#00336922","v","fissurar","N");
INSERT INTO portuguese_lemma VALUES ("n#00337078","n","genuflexão","N");
INSERT INTO portuguese_lemma VALUES ("n#07275078","n","genuflexão","N");
INSERT INTO portuguese_lemma VALUES ("a#02019649","a","inseguro","N");
INSERT INTO portuguese_lemma VALUES ("a#00331296","a","inseguro","N");
INSERT INTO portuguese_lemma VALUES ("a#02017003","a","inseguro","N");
INSERT INTO portuguese_lemma VALUES ("a#02019099","a","inseguro","N");
INSERT INTO portuguese_lemma VALUES ("a#02020491","a","inseguro","N");
INSERT INTO portuguese_lemma VALUES ("a#02192636","a","inseguro","N");
INSERT INTO portuguese_lemma VALUES ("a#02402704","a","inseguro","N");
INSERT INTO portuguese_lemma VALUES ("n#00337605","n","nistagmo","N");
INSERT INTO portuguese_lemma VALUES ("a#00337841","a","ambivalente","N");
INSERT INTO portuguese_lemma VALUES ("a#00329386","a","duvidoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01846862","a","duvidoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01847441","a","duvidoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00338071","v","fragmentar","N");
INSERT INTO portuguese_lemma VALUES ("n#00338271","n","movimento_sacádico","Y");
INSERT INTO portuguese_lemma VALUES ("a#00330147","a","confiante","N");
INSERT INTO portuguese_lemma VALUES ("n#00217325","n","rearranjo","N");
INSERT INTO portuguese_lemma VALUES ("a#00330451","a","segurado","N");
INSERT INTO portuguese_lemma VALUES ("n#00339646","n","permutação","N");
INSERT INTO portuguese_lemma VALUES ("a#00339742","a","auto-confiante","N");
INSERT INTO portuguese_lemma VALUES ("n#00217846","n","transposição","N");
INSERT INTO portuguese_lemma VALUES ("v#00235191","v","suceder","N");
INSERT INTO portuguese_lemma VALUES ("v#00238795","v","suceder","N");
INSERT INTO portuguese_lemma VALUES ("v#01797749","v","suceder","N");
INSERT INTO portuguese_lemma VALUES ("v#00235191","v","ocorrer","N");
INSERT INTO portuguese_lemma VALUES ("v#00238795","v","ocorrer","N");
INSERT INTO portuguese_lemma VALUES ("v#02612368","v","ocorrer","N");
INSERT INTO portuguese_lemma VALUES ("a#00331522","a","inevitável","N");
INSERT INTO portuguese_lemma VALUES ("a#00333883","a","inevitável","N");
INSERT INTO portuguese_lemma VALUES ("a#00343360","a","inevitável","N");
INSERT INTO portuguese_lemma VALUES ("a#01769762","a","inevitável","N");
INSERT INTO portuguese_lemma VALUES ("a#00331522","a","seguro","N");
INSERT INTO portuguese_lemma VALUES ("a#01059711","a","seguro","N");
INSERT INTO portuguese_lemma VALUES ("a#02018719","a","seguro","N");
INSERT INTO portuguese_lemma VALUES ("n#09608326","n","seguro","N");
INSERT INTO portuguese_lemma VALUES ("n#13344804","n","seguro","N");
INSERT INTO portuguese_lemma VALUES ("n#10426769","n","seguro","N");
INSERT INTO portuguese_lemma VALUES ("r#00340273","r","primeira_classe","Y");
INSERT INTO portuguese_lemma VALUES ("n#00218172","n","embaralhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00972429","v","embaralhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01917549","v","embaralhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00331909","a","predeterminado","N");
INSERT INTO portuguese_lemma VALUES ("a#00331909","a","destinado","N");
INSERT INTO portuguese_lemma VALUES ("a#01682822","a","destinado","N");
INSERT INTO portuguese_lemma VALUES ("v#00341422","v","acontecer_inesperadamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00236311","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#00238223","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01192992","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01253107","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01839538","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01257215","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01261299","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01262658","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01882814","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01299603","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01935233","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01331981","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01333288","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01360914","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01371248","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01402214","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01408362","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01418612","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#02102002","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#02102398","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01832891","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#01833375","v","ir","N");
INSERT INTO portuguese_lemma VALUES ("v#00236311","v","prosseguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00243167","v","prosseguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00530824","v","prosseguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01360914","v","prosseguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01618013","v","prosseguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01831586","v","prosseguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01832078","v","prosseguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00236668","v","vir","N");
INSERT INTO portuguese_lemma VALUES ("v#01262658","v","vir","N");
INSERT INTO portuguese_lemma VALUES ("v#01849746","v","vir","N");
INSERT INTO portuguese_lemma VALUES ("v#01368651","v","vir","N");
INSERT INTO portuguese_lemma VALUES ("v#02053941","v","vir","N");
INSERT INTO portuguese_lemma VALUES ("n#00342028","n","rotação","N");
INSERT INTO portuguese_lemma VALUES ("n#05535152","n","rotação","N");
INSERT INTO portuguese_lemma VALUES ("r#00342110","r","fluentemente","N");
INSERT INTO portuguese_lemma VALUES ("n#00342424","n","circunvolução","N");
INSERT INTO portuguese_lemma VALUES ("r#00342624","r","forçadamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00342626","a","diplomado","N");
INSERT INTO portuguese_lemma VALUES ("n#00221348","n","giro","N");
INSERT INTO portuguese_lemma VALUES ("n#00219627","n","giro","N");
INSERT INTO portuguese_lemma VALUES ("n#00220762","n","giro","N");
INSERT INTO portuguese_lemma VALUES ("n#00343091","n","pronação","N");
INSERT INTO portuguese_lemma VALUES ("v#00343334","v","reincidir","N");
INSERT INTO portuguese_lemma VALUES ("a#00343360","a","inexorável","N");
INSERT INTO portuguese_lemma VALUES ("a#01769762","a","inexorável","N");
INSERT INTO portuguese_lemma VALUES ("a#02357115","a","inexorável","N");
INSERT INTO portuguese_lemma VALUES ("r#00343660","r","piano","N");
INSERT INTO portuguese_lemma VALUES ("r#00388494","r","piano","N");
INSERT INTO portuguese_lemma VALUES ("a#01458303","a","piano","N");
INSERT INTO portuguese_lemma VALUES ("n#03115608","n","piano","N");
INSERT INTO portuguese_lemma VALUES ("n#03899791","n","piano","N");
INSERT INTO portuguese_lemma VALUES ("a#00343700","a","evitável","N");
INSERT INTO portuguese_lemma VALUES ("a#00343883","a","evitável","N");
INSERT INTO portuguese_lemma VALUES ("a#00343883","a","previnível","N");
INSERT INTO portuguese_lemma VALUES ("v#00238223","v","resultar","N");
INSERT INTO portuguese_lemma VALUES ("v#01797447","v","resultar","N");
INSERT INTO portuguese_lemma VALUES ("v#01797616","v","resultar","N");
INSERT INTO portuguese_lemma VALUES ("v#01797749","v","resultar","N");
INSERT INTO portuguese_lemma VALUES ("v#01797979","v","resultar","N");
INSERT INTO portuguese_lemma VALUES ("a#00334865","a","mutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00350069","a","mutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00356339","a","mutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00334865","a","variável","N");
INSERT INTO portuguese_lemma VALUES ("a#01028796","a","variável","N");
INSERT INTO portuguese_lemma VALUES ("a#02384171","a","variável","N");
INSERT INTO portuguese_lemma VALUES ("a#02384454","a","variável","N");
INSERT INTO portuguese_lemma VALUES ("a#02507515","a","variável","N");
INSERT INTO portuguese_lemma VALUES ("n#04508699","n","variável","N");
INSERT INTO portuguese_lemma VALUES ("n#05426934","n","variável","N");
INSERT INTO portuguese_lemma VALUES ("n#06847350","n","variável","N");
INSERT INTO portuguese_lemma VALUES ("v#00238500","v","materializar","N");
INSERT INTO portuguese_lemma VALUES ("r#00344208","r","maldosamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00344492","v","desmaterializar","N");
INSERT INTO portuguese_lemma VALUES ("a#00344686","a","regulável","N");
INSERT INTO portuguese_lemma VALUES ("n#00344942","n","cócoras","N");
INSERT INTO portuguese_lemma VALUES ("n#00344942","n","agachamento","N");
INSERT INTO portuguese_lemma VALUES ("a#00335703","a","volúvel","N");
INSERT INTO portuguese_lemma VALUES ("a#00584626","a","volúvel","N");
INSERT INTO portuguese_lemma VALUES ("a#00335703","a","instável","N");
INSERT INTO portuguese_lemma VALUES ("a#00335990","a","instável","N");
INSERT INTO portuguese_lemma VALUES ("a#00584626","a","instável","N");
INSERT INTO portuguese_lemma VALUES ("a#01998634","a","instável","N");
INSERT INTO portuguese_lemma VALUES ("a#02181387","a","instável","N");
INSERT INTO portuguese_lemma VALUES ("a#02384454","a","instável","N");
INSERT INTO portuguese_lemma VALUES ("n#00345297","n","supinação","N");
INSERT INTO portuguese_lemma VALUES ("n#00220931","n","torção","N");
INSERT INTO portuguese_lemma VALUES ("n#07351909","n","torção","N");
INSERT INTO portuguese_lemma VALUES ("v#00239960","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#00241484","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#00240718","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#00348103","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#00348252","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#00242403","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01526605","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01119504","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01133757","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01273498","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01621230","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01651336","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01661230","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#01778989","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("v#02609439","v","começar","N");
INSERT INTO portuguese_lemma VALUES ("n#00221734","n","aljava","N");
INSERT INTO portuguese_lemma VALUES ("n#04035836","n","aljava","N");
INSERT INTO portuguese_lemma VALUES ("n#00221734","n","tremor","N");
INSERT INTO portuguese_lemma VALUES ("n#00223779","n","tremor","N");
INSERT INTO portuguese_lemma VALUES ("n#07428954","n","tremor","N");
INSERT INTO portuguese_lemma VALUES ("n#05526762","n","tremor","N");
INSERT INTO portuguese_lemma VALUES ("n#10088916","n","tremor","N");
INSERT INTO portuguese_lemma VALUES ("n#00221849","n","onda","N");
INSERT INTO portuguese_lemma VALUES ("n#05473259","n","onda","N");
INSERT INTO portuguese_lemma VALUES ("n#05475302","n","onda","N");
INSERT INTO portuguese_lemma VALUES ("n#05477241","n","onda","N");
INSERT INTO portuguese_lemma VALUES ("n#00346296","n","reorientação","N");
INSERT INTO portuguese_lemma VALUES ("n#06208614","n","reorientação","N");
INSERT INTO portuguese_lemma VALUES ("r#00346822","r","valentemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00346847","a","volatile","N");
INSERT INTO portuguese_lemma VALUES ("a#00346847","a","volátil","N");
INSERT INTO portuguese_lemma VALUES ("a#00584626","a","volátil","N");
INSERT INTO portuguese_lemma VALUES ("a#02519555","a","volátil","N");
INSERT INTO portuguese_lemma VALUES ("a#00346991","a","inalterável","N");
INSERT INTO portuguese_lemma VALUES ("a#00356648","a","inalterável","N");
INSERT INTO portuguese_lemma VALUES ("a#00346991","a","imutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00347400","a","imutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00356648","a","imutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00577782","a","imutável","N");
INSERT INTO portuguese_lemma VALUES ("a#02191070","a","imutável","N");
INSERT INTO portuguese_lemma VALUES ("r#00347216","r","genealogicamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00347400","a","invariável","N");
INSERT INTO portuguese_lemma VALUES ("a#01898654","a","invariável","N");
INSERT INTO portuguese_lemma VALUES ("a#02505716","a","invariável","N");
INSERT INTO portuguese_lemma VALUES ("a#02506408","a","invariável","N");
INSERT INTO portuguese_lemma VALUES ("v#00241308","v","acometer","N");
INSERT INTO portuguese_lemma VALUES ("n#00347652","n","sacolejo","N");
INSERT INTO portuguese_lemma VALUES ("a#00337799","a","fixo","N");
INSERT INTO portuguese_lemma VALUES ("a#00705447","a","fixo","N");
INSERT INTO portuguese_lemma VALUES ("a#01508672","a","fixo","N");
INSERT INTO portuguese_lemma VALUES ("a#02020145","a","fixo","N");
INSERT INTO portuguese_lemma VALUES ("r#00348247","r","com_prazer","Y");
INSERT INTO portuguese_lemma VALUES ("a#00348537","a","traduzível","N");
INSERT INTO portuguese_lemma VALUES ("a#02489092","a","traduzível","N");
INSERT INTO portuguese_lemma VALUES ("n#00348571","n","excitação_doentia","Y");
INSERT INTO portuguese_lemma VALUES ("r#00348911","r","gloriosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00349053","r","gloriosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00349886","n","inversão_de_rota","Y");
INSERT INTO portuguese_lemma VALUES ("a#00350069","a","modificável","N");
INSERT INTO portuguese_lemma VALUES ("a#00356339","a","modificável","N");
INSERT INTO portuguese_lemma VALUES ("v#00243335","v","retomar","N");
INSERT INTO portuguese_lemma VALUES ("v#00243335","v","recomeçar","N");
INSERT INTO portuguese_lemma VALUES ("v#01858686","v","recomeçar","N");
INSERT INTO portuguese_lemma VALUES ("n#00224903","n","Digressão","N");
INSERT INTO portuguese_lemma VALUES ("n#00224903","n","digressão","N");
INSERT INTO portuguese_lemma VALUES ("v#00350461","v","persistir","N");
INSERT INTO portuguese_lemma VALUES ("v#00350461","v","perseverar","N");
INSERT INTO portuguese_lemma VALUES ("v#01785787","v","perseverar","N");
INSERT INTO portuguese_lemma VALUES ("a#00350621","a","ajustado","N");
INSERT INTO portuguese_lemma VALUES ("a#00351523","a","ajustado","N");
INSERT INTO portuguese_lemma VALUES ("a#00352536","a","ajustado","N");
INSERT INTO portuguese_lemma VALUES ("n#00351485","n","mudança_de_magnitude","Y");
INSERT INTO portuguese_lemma VALUES ("r#00351542","r","de_forma_monstruosa","Y");
INSERT INTO portuguese_lemma VALUES ("r#00351542","r","monstruosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00225760","n","redução","N");
INSERT INTO portuguese_lemma VALUES ("n#14780267","n","redução","N");
INSERT INTO portuguese_lemma VALUES ("n#00225760","n","diminuição","N");
INSERT INTO portuguese_lemma VALUES ("n#00227536","n","diminuição","N");
INSERT INTO portuguese_lemma VALUES ("n#00229061","n","diminuição","N");
INSERT INTO portuguese_lemma VALUES ("n#09728815","n","diminuição","N");
INSERT INTO portuguese_lemma VALUES ("n#09731612","n","diminuição","N");
INSERT INTO portuguese_lemma VALUES ("n#09728739","n","diminuição","N");
INSERT INTO portuguese_lemma VALUES ("v#00245305","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00246253","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00335506","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00337013","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00483753","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01642820","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01831830","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01829006","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02735418","v","finalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00245305","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00246253","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00335506","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00337013","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00337397","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00483753","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00518678","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01075648","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#02229828","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01651565","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01831830","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01780161","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01780295","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01829006","v","terminar","N");
INSERT INTO portuguese_lemma VALUES ("a#00342202","a","alterado","N");
INSERT INTO portuguese_lemma VALUES ("v#00245987","v","aportar","N");
INSERT INTO portuguese_lemma VALUES ("a#00352716","a","trocado","N");
INSERT INTO portuguese_lemma VALUES ("a#00354433","a","trocado","N");
INSERT INTO portuguese_lemma VALUES ("a#00352716","a","mudado","N");
INSERT INTO portuguese_lemma VALUES ("a#00354433","a","mudado","N");
INSERT INTO portuguese_lemma VALUES ("n#00352778","n","redução_de_custos","Y");
INSERT INTO portuguese_lemma VALUES ("v#00246253","v","encerrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00337013","v","encerrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01831830","v","encerrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00246253","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00318530","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00428966","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00430365","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00430461","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00472610","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00483753","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00944924","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00945125","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("v#00691426","v","concluir","N");
INSERT INTO portuguese_lemma VALUES ("a#00343387","a","impróprio_para_o_momento","Y");
INSERT INTO portuguese_lemma VALUES ("a#00343387","a","sempiterno","N");
INSERT INTO portuguese_lemma VALUES ("a#00343387","a","prematuro","N");
INSERT INTO portuguese_lemma VALUES ("a#01495535","a","prematuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00343387","a","interminável","N");
INSERT INTO portuguese_lemma VALUES ("a#01382215","a","interminável","N");
INSERT INTO portuguese_lemma VALUES ("a#01691167","a","interminável","N");
INSERT INTO portuguese_lemma VALUES ("n#00227277","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00227536","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00229061","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00232701","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00362355","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05479408","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05523754","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#13282275","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#09728815","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#09731612","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("n#09728739","n","abatimento","N");
INSERT INTO portuguese_lemma VALUES ("r#00353590","r","harmoniosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00227536","n","contracção","N");
INSERT INTO portuguese_lemma VALUES ("n#00365471","n","contracção","N");
INSERT INTO portuguese_lemma VALUES ("v#00246783","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("v#00253202","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("v#00254764","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("v#00362765","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("v#00528650","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("v#00779061","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("v#02018858","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("v#01830886","v","interromper","N");
INSERT INTO portuguese_lemma VALUES ("n#00353992","n","desvalorização","N");
INSERT INTO portuguese_lemma VALUES ("n#00364600","n","desvalorização","N");
INSERT INTO portuguese_lemma VALUES ("n#00353992","n","devaliação","N");
INSERT INTO portuguese_lemma VALUES ("n#00805524","n","devaliação","N");
INSERT INTO portuguese_lemma VALUES ("v#00246916","v","culminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00337971","v","culminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00338157","v","culminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01380705","v","culminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01723022","v","culminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00354452","v","estagnar","N");
INSERT INTO portuguese_lemma VALUES ("v#00354452","v","estancar","N");
INSERT INTO portuguese_lemma VALUES ("v#00247730","v","morrer","N");
INSERT INTO portuguese_lemma VALUES ("v#00250254","v","morrer","N");
INSERT INTO portuguese_lemma VALUES ("v#01784953","v","morrer","N");
INSERT INTO portuguese_lemma VALUES ("v#02620466","v","morrer","N");
INSERT INTO portuguese_lemma VALUES ("v#00247730","v","falecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00250254","v","falecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00228188","n","alívio","N");
INSERT INTO portuguese_lemma VALUES ("n#00228800","n","alívio","N");
INSERT INTO portuguese_lemma VALUES ("n#05570696","n","alívio","N");
INSERT INTO portuguese_lemma VALUES ("a#00354934","a","transformado","N");
INSERT INTO portuguese_lemma VALUES ("v#00247869","v","matar","N");
INSERT INTO portuguese_lemma VALUES ("v#00334181","v","matar","N");
INSERT INTO portuguese_lemma VALUES ("v#00903064","v","matar","N");
INSERT INTO portuguese_lemma VALUES ("v#00903723","v","matar","N");
INSERT INTO portuguese_lemma VALUES ("v#01691743","v","matar","N");
INSERT INTO portuguese_lemma VALUES ("r#00355896","r","futuramente","N");
INSERT INTO portuguese_lemma VALUES ("n#00355919","n","minimização","N");
INSERT INTO portuguese_lemma VALUES ("a#00355950","a","isotônico","N");
INSERT INTO portuguese_lemma VALUES ("a#00894980","a","isotônico","N");
INSERT INTO portuguese_lemma VALUES ("a#02406790","a","isotônico","N");
INSERT INTO portuguese_lemma VALUES ("a#00356110","a","ionizado","N");
INSERT INTO portuguese_lemma VALUES ("n#00229061","n","depleção","N");
INSERT INTO portuguese_lemma VALUES ("a#00356339","a","alterável","N");
INSERT INTO portuguese_lemma VALUES ("n#00229211","n","consumo","N");
INSERT INTO portuguese_lemma VALUES ("n#09726045","n","consumo","N");
INSERT INTO portuguese_lemma VALUES ("r#00356412","r","imediatemente_depois","Y");
INSERT INTO portuguese_lemma VALUES ("r#00356515","r","de_forma_hermética","Y");
INSERT INTO portuguese_lemma VALUES ("r#00356515","r","hermeticamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00356649","v","igualar","N");
INSERT INTO portuguese_lemma VALUES ("v#00289728","v","igualar","N");
INSERT INTO portuguese_lemma VALUES ("v#01817610","v","igualar","N");
INSERT INTO portuguese_lemma VALUES ("n#00356790","n","compressão","N");
INSERT INTO portuguese_lemma VALUES ("n#07313241","n","compressão","N");
INSERT INTO portuguese_lemma VALUES ("n#07419233","n","compressão","N");
INSERT INTO portuguese_lemma VALUES ("a#00346121","a","caraterístico","N");
INSERT INTO portuguese_lemma VALUES ("a#00346121","a","característico","N");
INSERT INTO portuguese_lemma VALUES ("v#00356954","v","bombear","N");
INSERT INTO portuguese_lemma VALUES ("v#01131902","v","bombear","N");
INSERT INTO portuguese_lemma VALUES ("v#01225684","v","bombear","N");
INSERT INTO portuguese_lemma VALUES ("v#01853069","v","bombear","N");
INSERT INTO portuguese_lemma VALUES ("v#01853310","v","bombear","N");
INSERT INTO portuguese_lemma VALUES ("a#00346431","a","sintomático","N");
INSERT INTO portuguese_lemma VALUES ("v#00249716","v","germinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00357667","v","germinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00357451","n","descompressão","N");
INSERT INTO portuguese_lemma VALUES ("a#00346965","a","típico","N");
INSERT INTO portuguese_lemma VALUES ("a#01595440","a","típico","N");
INSERT INTO portuguese_lemma VALUES ("a#02349429","a","típico","N");
INSERT INTO portuguese_lemma VALUES ("a#00346965","a","distintivo","N");
INSERT INTO portuguese_lemma VALUES ("n#05851131","n","distintivo","N");
INSERT INTO portuguese_lemma VALUES ("n#05150806","n","distintivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00357680","n","compactação","N");
INSERT INTO portuguese_lemma VALUES ("n#00357906","n","compactação","N");
INSERT INTO portuguese_lemma VALUES ("n#00358089","n","compactação","N");
INSERT INTO portuguese_lemma VALUES ("n#00357906","n","espessamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00250037","v","rebentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00250037","v","gomar","N");
INSERT INTO portuguese_lemma VALUES ("n#00358089","n","esmagamento","N");
INSERT INTO portuguese_lemma VALUES ("n#14762366","n","esmagamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00358290","n","pulverização","N");
INSERT INTO portuguese_lemma VALUES ("n#00358290","n","trituração","N");
INSERT INTO portuguese_lemma VALUES ("r#00358342","r","horizontalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00250254","v","bater_as_botas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00250254","v","bater_as_botas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00250254","v","comer_capim_pela_raiz","Y");
INSERT INTO portuguese_lemma VALUES ("r#00358516","r","verticalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#01750220","a","eletronegativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00230520","n","extrusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00358931","n","encurtamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00358931","n","abreviatura","N");
INSERT INTO portuguese_lemma VALUES ("n#00359135","n","abreviatura","N");
INSERT INTO portuguese_lemma VALUES ("n#06468123","n","abreviatura","N");
INSERT INTO portuguese_lemma VALUES ("n#07091587","n","abreviatura","N");
INSERT INTO portuguese_lemma VALUES ("n#00359135","n","abreviação","N");
INSERT INTO portuguese_lemma VALUES ("n#06468123","n","abreviação","N");
INSERT INTO portuguese_lemma VALUES ("n#07091587","n","abreviação","N");
INSERT INTO portuguese_lemma VALUES ("a#00359459","a","caridoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02691390","a","caridoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00359511","v","abafar","N");
INSERT INTO portuguese_lemma VALUES ("v#01080303","v","abafar","N");
INSERT INTO portuguese_lemma VALUES ("v#02191311","v","abafar","N");
INSERT INTO portuguese_lemma VALUES ("n#00360143","n","poda","N");
INSERT INTO portuguese_lemma VALUES ("n#00360143","n","estacas","N");
INSERT INTO portuguese_lemma VALUES ("v#00360337","v","enviuvar","N");
INSERT INTO portuguese_lemma VALUES ("v#00360501","v","afogar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00333886","v","afogar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00360601","n","Miniaturização","N");
INSERT INTO portuguese_lemma VALUES ("a#00360650","a","casta","N");
INSERT INTO portuguese_lemma VALUES ("n#08306047","n","casta","N");
INSERT INTO portuguese_lemma VALUES ("a#00360650","a","casto","N");
INSERT INTO portuguese_lemma VALUES ("a#01548694","a","casto","N");
INSERT INTO portuguese_lemma VALUES ("r#00360710","r","de_forma_histérica","Y");
INSERT INTO portuguese_lemma VALUES ("r#00360710","r","histericamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00232015","n","subtração","N");
INSERT INTO portuguese_lemma VALUES ("n#00560394","n","subtração","N");
INSERT INTO portuguese_lemma VALUES ("n#00232015","n","subtracção","N");
INSERT INTO portuguese_lemma VALUES ("n#00560394","n","subtracção","N");
INSERT INTO portuguese_lemma VALUES ("v#00251991","v","vir_ao_mundo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00251991","v","nascer","N");
INSERT INTO portuguese_lemma VALUES ("r#00361065","r","da_mesma_forma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00361065","r","de_forma_idêntica","Y");
INSERT INTO portuguese_lemma VALUES ("a#00350627","a","virgem","N");
INSERT INTO portuguese_lemma VALUES ("a#01584288","a","virgem","N");
INSERT INTO portuguese_lemma VALUES ("a#01907878","a","virgem","N");
INSERT INTO portuguese_lemma VALUES ("a#02824922","a","virgem","N");
INSERT INTO portuguese_lemma VALUES ("n#07667236","n","virgem","N");
INSERT INTO portuguese_lemma VALUES ("a#00350627","a","virginal","N");
INSERT INTO portuguese_lemma VALUES ("a#01907878","a","virginal","N");
INSERT INTO portuguese_lemma VALUES ("a#02824922","a","virginal","N");
INSERT INTO portuguese_lemma VALUES ("n#04537436","n","virginal","N");
INSERT INTO portuguese_lemma VALUES ("n#00232357","n","extenuação","N");
INSERT INTO portuguese_lemma VALUES ("v#00361495","v","enevoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00940803","v","enevoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00361495","v","nublar","N");
INSERT INTO portuguese_lemma VALUES ("v#02770717","v","nublar","N");
INSERT INTO portuguese_lemma VALUES ("v#02771020","v","nublar","N");
INSERT INTO portuguese_lemma VALUES ("r#00361781","r","The_Idle_Class","Y");
INSERT INTO portuguese_lemma VALUES ("a#00361837","a","promíscuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00774006","a","promíscuo","N");
INSERT INTO portuguese_lemma VALUES ("a#02133779","a","promíscuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00361837","a","devasso","N");
INSERT INTO portuguese_lemma VALUES ("a#01549568","a","devasso","N");
INSERT INTO portuguese_lemma VALUES ("a#01727133","a","devasso","N");
INSERT INTO portuguese_lemma VALUES ("a#02133207","a","devasso","N");
INSERT INTO portuguese_lemma VALUES ("a#02133431","a","devasso","N");
INSERT INTO portuguese_lemma VALUES ("n#10552980","n","devasso","N");
INSERT INTO portuguese_lemma VALUES ("n#00361932","n","deflação","N");
INSERT INTO portuguese_lemma VALUES ("n#13459821","n","deflação","N");
INSERT INTO portuguese_lemma VALUES ("n#00232701","n","disconto","N");
INSERT INTO portuguese_lemma VALUES ("n#00232701","n","desconto","N");
INSERT INTO portuguese_lemma VALUES ("n#13274597","n","desconto","N");
INSERT INTO portuguese_lemma VALUES ("n#13282275","n","desconto","N");
INSERT INTO portuguese_lemma VALUES ("v#00362128","v","curvar","N");
INSERT INTO portuguese_lemma VALUES ("v#01280488","v","curvar","N");
INSERT INTO portuguese_lemma VALUES ("v#01390339","v","curvar","N");
INSERT INTO portuguese_lemma VALUES ("a#00362269","a","imoderado","N");
INSERT INTO portuguese_lemma VALUES ("a#00362269","a","desenfreado","N");
INSERT INTO portuguese_lemma VALUES ("a#00362269","a","árdego","N");
INSERT INTO portuguese_lemma VALUES ("r#00362276","r","legivelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00253202","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#00528650","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#00779061","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#00813880","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#01269636","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#01860795","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#01272526","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#01354366","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#02412647","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#01745445","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#01831830","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#01829006","v","parar","N");
INSERT INTO portuguese_lemma VALUES ("v#00362610","v","esperar_um_pouco","Y");
INSERT INTO portuguese_lemma VALUES ("v#00790509","v","esperar_um_pouco","Y");
INSERT INTO portuguese_lemma VALUES ("r#00362831","r","legitimamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00363218","r","legitimamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00352106","a","contente","N");
INSERT INTO portuguese_lemma VALUES ("a#00998186","a","contente","N");
INSERT INTO portuguese_lemma VALUES ("a#01308490","a","contente","N");
INSERT INTO portuguese_lemma VALUES ("a#01308059","a","contente","N");
INSERT INTO portuguese_lemma VALUES ("a#01314288","a","contente","N");
INSERT INTO portuguese_lemma VALUES ("a#01805157","a","contente","N");
INSERT INTO portuguese_lemma VALUES ("n#07531105","n","contente","N");
INSERT INTO portuguese_lemma VALUES ("a#00352106","a","risonho","N");
INSERT INTO portuguese_lemma VALUES ("a#00352106","a","feliz","N");
INSERT INTO portuguese_lemma VALUES ("a#00998186","a","feliz","N");
INSERT INTO portuguese_lemma VALUES ("a#01308490","a","feliz","N");
INSERT INTO portuguese_lemma VALUES ("a#01308059","a","feliz","N");
INSERT INTO portuguese_lemma VALUES ("a#01314288","a","feliz","N");
INSERT INTO portuguese_lemma VALUES ("v#00253929","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00415041","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00415168","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00415444","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00415625","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#00734233","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01842367","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01421290","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01521543","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01523865","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01524047","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01524319","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01582774","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01623741","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("v#01761339","v","abandonar","N");
INSERT INTO portuguese_lemma VALUES ("a#00352451","a","alegre","N");
INSERT INTO portuguese_lemma VALUES ("a#00353226","a","alegre","N");
INSERT INTO portuguese_lemma VALUES ("a#01308059","a","alegre","N");
INSERT INTO portuguese_lemma VALUES ("a#01314288","a","alegre","N");
INSERT INTO portuguese_lemma VALUES ("a#01664015","a","alegre","N");
INSERT INTO portuguese_lemma VALUES ("r#00363463","r","logicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00363744","r","logicamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00363788","n","adição","N");
INSERT INTO portuguese_lemma VALUES ("n#00560621","n","adição","N");
INSERT INTO portuguese_lemma VALUES ("a#00429748","a","ensolarado","N");
INSERT INTO portuguese_lemma VALUES ("n#00364053","n","retrofit","N");
INSERT INTO portuguese_lemma VALUES ("n#00364053","n","Retrofit","N");
INSERT INTO portuguese_lemma VALUES ("n#00234220","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#00235032","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#00235235","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#03983965","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#05109324","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#03984405","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#03984543","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#05479891","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#07369470","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#09729055","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#09904938","n","aumento","N");
INSERT INTO portuguese_lemma VALUES ("n#00234364","n","Reavaliação","N");
INSERT INTO portuguese_lemma VALUES ("n#00234364","n","reavaliação","N");
INSERT INTO portuguese_lemma VALUES ("n#05737025","n","reavaliação","N");
INSERT INTO portuguese_lemma VALUES ("n#05747582","n","reavaliação","N");
INSERT INTO portuguese_lemma VALUES ("a#01309194","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#00863871","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01000655","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01051814","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01101074","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01308632","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01362387","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01309535","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01732472","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("a#01733145","a","triste","N");
INSERT INTO portuguese_lemma VALUES ("r#00364623","r","amoralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00364623","r","de_forma_amoral","Y");
INSERT INTO portuguese_lemma VALUES ("v#00364629","v","pasteurizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","entristecedor","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","nebuloso","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","horrendo","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","enjoado","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","lastimável","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","ermo","N");
INSERT INTO portuguese_lemma VALUES ("a#00354187","a","melancólico","N");
INSERT INTO portuguese_lemma VALUES ("n#00365012","n","fluorização","N");
INSERT INTO portuguese_lemma VALUES ("a#00354536","a","soturno","N");
INSERT INTO portuguese_lemma VALUES ("a#00354536","a","lúgubre","N");
INSERT INTO portuguese_lemma VALUES ("a#01366062","a","lúgubre","N");
INSERT INTO portuguese_lemma VALUES ("r#00365668","r","sensivelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00235235","n","expansão","N");
INSERT INTO portuguese_lemma VALUES ("n#00238469","n","expansão","N");
INSERT INTO portuguese_lemma VALUES ("n#00235235","n","ampliação","N");
INSERT INTO portuguese_lemma VALUES ("n#02641071","n","ampliação","N");
INSERT INTO portuguese_lemma VALUES ("v#00365810","v","sublimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00366020","v","sublimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00475183","v","sublimar","N");
INSERT INTO portuguese_lemma VALUES ("v#01953527","v","sublimar","N");
INSERT INTO portuguese_lemma VALUES ("n#00365995","n","dilatação","N");
INSERT INTO portuguese_lemma VALUES ("a#00366025","a","monoclínico","N");
INSERT INTO portuguese_lemma VALUES ("a#00366185","a","triclínico","N");
INSERT INTO portuguese_lemma VALUES ("n#00366207","n","vasodilatação","N");
INSERT INTO portuguese_lemma VALUES ("n#00366207","n","Vasodilatadores","N");
INSERT INTO portuguese_lemma VALUES ("n#00366317","n","distensão","N");
INSERT INTO portuguese_lemma VALUES ("n#14063633","n","distensão","N");
INSERT INTO portuguese_lemma VALUES ("a#00366355","a","monocromático","N");
INSERT INTO portuguese_lemma VALUES ("a#00398816","a","monocromático","N");
INSERT INTO portuguese_lemma VALUES ("a#03040525","a","monocromático","N");
INSERT INTO portuguese_lemma VALUES ("a#00366526","a","policromático","N");
INSERT INTO portuguese_lemma VALUES ("a#00400193","a","policromático","N");
INSERT INTO portuguese_lemma VALUES ("a#00366691","a","cromático","N");
INSERT INTO portuguese_lemma VALUES ("a#00409750","a","cromático","N");
INSERT INTO portuguese_lemma VALUES ("v#00366858","v","vaporizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00442267","v","vaporizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00366858","v","evaporar","N");
INSERT INTO portuguese_lemma VALUES ("v#00442267","v","evaporar","N");
INSERT INTO portuguese_lemma VALUES ("v#00575720","v","evaporar","N");
INSERT INTO portuguese_lemma VALUES ("r#00367259","r","implicitamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00367568","r","implicitamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00236300","n","inflação","N");
INSERT INTO portuguese_lemma VALUES ("n#09727083","n","inflação","N");
INSERT INTO portuguese_lemma VALUES ("n#00367552","n","exagero","N");
INSERT INTO portuguese_lemma VALUES ("n#06758835","n","exagero","N");
INSERT INTO portuguese_lemma VALUES ("n#07106502","n","exagero","N");
INSERT INTO portuguese_lemma VALUES ("v#00257011","v","intercalar","N");
INSERT INTO portuguese_lemma VALUES ("v#00257011","v","fundir-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00236696","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03972175","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03973414","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03977751","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03981562","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03991813","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03995297","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03999338","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#03999641","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#06384327","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#06667120","n","extensão","N");
INSERT INTO portuguese_lemma VALUES ("n#00236886","n","espalhamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00237068","n","desagregação","N");
INSERT INTO portuguese_lemma VALUES ("n#00237068","n","disseminação","N");
INSERT INTO portuguese_lemma VALUES ("n#03970206","n","disseminação","N");
INSERT INTO portuguese_lemma VALUES ("v#00368847","v","convergir","N");
INSERT INTO portuguese_lemma VALUES ("v#00369064","v","associar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01592263","v","associar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#02434976","v","associar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01658377","v","associar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01683038","v","associar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00369399","n","contratura","N");
INSERT INTO portuguese_lemma VALUES ("n#00369399","n","Contratura","N");
INSERT INTO portuguese_lemma VALUES ("v#00369628","v","carbonizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02771997","v","carbonizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00369694","n","hiperextensão","N");
INSERT INTO portuguese_lemma VALUES ("n#00369802","n","Contracção_muscular","Y");
INSERT INTO portuguese_lemma VALUES ("a#00369831","a","ruivo","N");
INSERT INTO portuguese_lemma VALUES ("n#10513823","n","ruivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00258213","v","esfriar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00258213","v","arrefecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00357392","a","áureo","N");
INSERT INTO portuguese_lemma VALUES ("a#01465459","a","áureo","N");
INSERT INTO portuguese_lemma VALUES ("a#00357392","a","dourado","N");
INSERT INTO portuguese_lemma VALUES ("a#01465459","a","dourado","N");
INSERT INTO portuguese_lemma VALUES ("n#03881805","n","dourado","N");
INSERT INTO portuguese_lemma VALUES ("n#09629533","n","dourado","N");
INSERT INTO portuguese_lemma VALUES ("n#00370261","n","Truncatura_de_um_sólido","Y");
INSERT INTO portuguese_lemma VALUES ("n#00370261","n","Truncatura_de_um_Sólido","Y");
INSERT INTO portuguese_lemma VALUES ("v#00258521","v","sobreaquecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00370267","a","azul_claro","Y");
INSERT INTO portuguese_lemma VALUES ("a#00370267","a","azul_celeste","Y");
INSERT INTO portuguese_lemma VALUES ("n#04969242","n","azul_celeste","Y");
INSERT INTO portuguese_lemma VALUES ("a#00370267","a","azul","N");
INSERT INTO portuguese_lemma VALUES ("a#00358045","a","azul","N");
INSERT INTO portuguese_lemma VALUES ("a#01606058","a","azul","N");
INSERT INTO portuguese_lemma VALUES ("n#03883954","n","azul","N");
INSERT INTO portuguese_lemma VALUES ("n#04969242","n","azul","N");
INSERT INTO portuguese_lemma VALUES ("n#10754805","n","azul","N");
INSERT INTO portuguese_lemma VALUES ("a#00370267","a","cerúleo","N");
INSERT INTO portuguese_lemma VALUES ("n#04969242","n","cerúleo","N");
INSERT INTO portuguese_lemma VALUES ("v#00258652","v","refrigerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00371051","v","refrigerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00371955","v","refrigerar","N");
INSERT INTO portuguese_lemma VALUES ("r#00370597","r","comparavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00370597","r","de_forma_comparável","Y");
INSERT INTO portuguese_lemma VALUES ("a#00358045","a","azulado","N");
INSERT INTO portuguese_lemma VALUES ("n#00370885","n","vaginismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00370885","n","Vaginismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00258851","v","gelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00262285","v","gelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00311143","v","gelar","N");
INSERT INTO portuguese_lemma VALUES ("n#00238268","n","estiramento","N");
INSERT INTO portuguese_lemma VALUES ("a#00371163","a","Azul-Petróleo","N");
INSERT INTO portuguese_lemma VALUES ("v#00259088","v","aquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00259859","v","aquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00260044","v","aquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00260318","v","aquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01665071","v","aquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00259088","v","esquentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00260044","v","esquentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00260318","v","esquentar","N");
INSERT INTO portuguese_lemma VALUES ("n#00238624","n","amplificação","N");
INSERT INTO portuguese_lemma VALUES ("n#05109324","n","amplificação","N");
INSERT INTO portuguese_lemma VALUES ("a#00358294","a","rosado","N");
INSERT INTO portuguese_lemma VALUES ("n#00371735","n","anotação","N");
INSERT INTO portuguese_lemma VALUES ("n#05067461","n","anotação","N");
INSERT INTO portuguese_lemma VALUES ("n#05067694","n","anotação","N");
INSERT INTO portuguese_lemma VALUES ("n#05067911","n","anotação","N");
INSERT INTO portuguese_lemma VALUES ("a#00371945","a","da_cor_do_bronze","Y");
INSERT INTO portuguese_lemma VALUES ("a#00371945","a","de_bronze","Y");
INSERT INTO portuguese_lemma VALUES ("n#00239058","n","acúmulo","N");
INSERT INTO portuguese_lemma VALUES ("n#00239181","n","acúmulo","N");
INSERT INTO portuguese_lemma VALUES ("n#05963394","n","acúmulo","N");
INSERT INTO portuguese_lemma VALUES ("n#07953603","n","acúmulo","N");
INSERT INTO portuguese_lemma VALUES ("n#05969773","n","acúmulo","N");
INSERT INTO portuguese_lemma VALUES ("n#09626584","n","acúmulo","N");
INSERT INTO portuguese_lemma VALUES ("n#00239058","n","acumulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00239181","n","acumulação","N");
INSERT INTO portuguese_lemma VALUES ("n#09625489","n","acumulação","N");
INSERT INTO portuguese_lemma VALUES ("n#09626584","n","acumulação","N");
INSERT INTO portuguese_lemma VALUES ("a#00358571","a","pardo","N");
INSERT INTO portuguese_lemma VALUES ("a#00358571","a","moreno","N");
INSERT INTO portuguese_lemma VALUES ("a#00358571","a","acastanhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00358571","a","marrom","N");
INSERT INTO portuguese_lemma VALUES ("a#00373209","a","marrom","N");
INSERT INTO portuguese_lemma VALUES ("n#04971928","n","marrom","N");
INSERT INTO portuguese_lemma VALUES ("n#04972350","n","marrom","N");
INSERT INTO portuguese_lemma VALUES ("a#00358571","a","castanho","N");
INSERT INTO portuguese_lemma VALUES ("a#00373209","a","castanho","N");
INSERT INTO portuguese_lemma VALUES ("n#04971928","n","castanho","N");
INSERT INTO portuguese_lemma VALUES ("n#04972350","n","castanho","N");
INSERT INTO portuguese_lemma VALUES ("r#00372322","r","indiferentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00372322","r","de_forma_indiferente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00239291","n","colocação","N");
INSERT INTO portuguese_lemma VALUES ("n#00680814","n","colocação","N");
INSERT INTO portuguese_lemma VALUES ("n#03960878","n","colocação","N");
INSERT INTO portuguese_lemma VALUES ("n#07015151","n","colocação","N");
INSERT INTO portuguese_lemma VALUES ("n#00239291","n","depósito","N");
INSERT INTO portuguese_lemma VALUES ("n#00372607","n","depósito","N");
INSERT INTO portuguese_lemma VALUES ("n#03421885","n","depósito","N");
INSERT INTO portuguese_lemma VALUES ("n#06695079","n","depósito","N");
INSERT INTO portuguese_lemma VALUES ("n#13364368","n","depósito","N");
INSERT INTO portuguese_lemma VALUES ("n#00372607","n","armazenamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00811355","n","armazenamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00260044","v","acalentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01212539","v","acalentar","N");
INSERT INTO portuguese_lemma VALUES ("n#00373130","n","inclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00240011","n","inclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#13936304","n","inclusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00239807","n","incorporação_(processos_industriais)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00240204","n","engrandecimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00240204","n","enaltecimento","N");
INSERT INTO portuguese_lemma VALUES ("a#00373621","a","coral","N");
INSERT INTO portuguese_lemma VALUES ("n#01429914","n","coral","N");
INSERT INTO portuguese_lemma VALUES ("a#02874282","a","coral","N");
INSERT INTO portuguese_lemma VALUES ("n#03886321","n","coral","N");
INSERT INTO portuguese_lemma VALUES ("n#05828205","n","coral","N");
INSERT INTO portuguese_lemma VALUES ("v#00373766","v","cauterizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00240588","n","reforço","N");
INSERT INTO portuguese_lemma VALUES ("n#07427224","n","reforço","N");
INSERT INTO portuguese_lemma VALUES ("n#00374224","n","intensificação","N");
INSERT INTO portuguese_lemma VALUES ("r#00374520","r","infrequentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00374520","r","de_forma_infrequente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00374835","n","exacerbação","N");
INSERT INTO portuguese_lemma VALUES ("v#00375021","v","ebulir","N");
INSERT INTO portuguese_lemma VALUES ("n#00241069","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#00799840","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#03812111","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#03865563","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#03933851","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#03970585","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#04370050","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#04407475","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("n#05518168","n","concentração","N");
INSERT INTO portuguese_lemma VALUES ("r#00375163","r","inerentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00375163","r","de_forma_inerente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00375348","n","pervaporação","N");
INSERT INTO portuguese_lemma VALUES ("n#00375625","n","focalização","N");
INSERT INTO portuguese_lemma VALUES ("a#00360195","a","esverdeado","N");
INSERT INTO portuguese_lemma VALUES ("v#00262454","v","derreter","N");
INSERT INTO portuguese_lemma VALUES ("v#00444629","v","derreter","N");
INSERT INTO portuguese_lemma VALUES ("v#00262454","v","amolecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01844178","v","amolecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00376342","a","avelaneira","N");
INSERT INTO portuguese_lemma VALUES ("a#00376342","a","cor_de_avelã","Y");
INSERT INTO portuguese_lemma VALUES ("n#00242022","n","rompimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00242229","n","rompimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05451946","n","rompimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00242229","n","ruptura","N");
INSERT INTO portuguese_lemma VALUES ("v#00376807","v","descongelar","N");
INSERT INTO portuguese_lemma VALUES ("n#00376994","n","fractura","N");
INSERT INTO portuguese_lemma VALUES ("n#14292090","n","fractura","N");
INSERT INTO portuguese_lemma VALUES ("n#00376994","n","fratura","N");
INSERT INTO portuguese_lemma VALUES ("n#14292090","n","fratura","N");
INSERT INTO portuguese_lemma VALUES ("v#00262798","v","carburar","N");
INSERT INTO portuguese_lemma VALUES ("n#00242644","n","estouro","N");
INSERT INTO portuguese_lemma VALUES ("n#00242644","n","explosão","N");
INSERT INTO portuguese_lemma VALUES ("n#00362034","n","explosão","N");
INSERT INTO portuguese_lemma VALUES ("n#05448780","n","explosão","N");
INSERT INTO portuguese_lemma VALUES ("n#05492247","n","explosão","N");
INSERT INTO portuguese_lemma VALUES ("n#07408171","n","explosão","N");
INSERT INTO portuguese_lemma VALUES ("n#05530978","n","explosão","N");
INSERT INTO portuguese_lemma VALUES ("n#05531291","n","explosão","N");
INSERT INTO portuguese_lemma VALUES ("v#00377569","v","fumegar","N");
INSERT INTO portuguese_lemma VALUES ("v#02767922","v","fumegar","N");
INSERT INTO portuguese_lemma VALUES ("n#00377686","n","detonação","N");
INSERT INTO portuguese_lemma VALUES ("n#00377813","n","percussão","N");
INSERT INTO portuguese_lemma VALUES ("n#00876239","n","percussão","N");
INSERT INTO portuguese_lemma VALUES ("n#08217557","n","percussão","N");
INSERT INTO portuguese_lemma VALUES ("v#00263602","v","incinerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00378361","v","incinerar","N");
INSERT INTO portuguese_lemma VALUES ("n#00378069","n","combustão","N");
INSERT INTO portuguese_lemma VALUES ("n#13450206","n","combustão","N");
INSERT INTO portuguese_lemma VALUES ("r#00378212","r","insidiosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00378296","n","incêndio_premeditado","Y");
INSERT INTO portuguese_lemma VALUES ("n#00378296","n","fogo_posto","Y");
INSERT INTO portuguese_lemma VALUES ("v#00378361","v","calcinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00378361","v","reduzir_a_cinzas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00378479","n","ignição","N");
INSERT INTO portuguese_lemma VALUES ("n#03560567","n","ignição","N");
INSERT INTO portuguese_lemma VALUES ("n#13495873","n","ignição","N");
INSERT INTO portuguese_lemma VALUES ("n#00378479","n","Inflamações","N");
INSERT INTO portuguese_lemma VALUES ("n#00378479","n","inflamação","N");
INSERT INTO portuguese_lemma VALUES ("n#14336539","n","inflamação","N");
INSERT INTO portuguese_lemma VALUES ("v#00263886","v","arder","N");
INSERT INTO portuguese_lemma VALUES ("v#01248170","v","arder","N");
INSERT INTO portuguese_lemma VALUES ("v#01885781","v","arder","N");
INSERT INTO portuguese_lemma VALUES ("v#01887716","v","arder","N");
INSERT INTO portuguese_lemma VALUES ("v#02762806","v","arder","N");
INSERT INTO portuguese_lemma VALUES ("v#01887961","v","arder","N");
INSERT INTO portuguese_lemma VALUES ("n#00378706","n","incineração","N");
INSERT INTO portuguese_lemma VALUES ("n#00378706","n","Incinerador","N");
INSERT INTO portuguese_lemma VALUES ("a#00378782","a","verde-azeitona","N");
INSERT INTO portuguese_lemma VALUES ("a#00378782","a","olivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00378880","n","cremação","N");
INSERT INTO portuguese_lemma VALUES ("a#00361864","a","alaranjado","N");
INSERT INTO portuguese_lemma VALUES ("n#03880945","n","alaranjado","N");
INSERT INTO portuguese_lemma VALUES ("a#00361864","a","laranja","N");
INSERT INTO portuguese_lemma VALUES ("n#03880945","n","laranja","N");
INSERT INTO portuguese_lemma VALUES ("n#05783752","n","laranja","N");
INSERT INTO portuguese_lemma VALUES ("n#10758147","n","laranja","N");
INSERT INTO portuguese_lemma VALUES ("a#00361864","a","cor-de-laranja","N");
INSERT INTO portuguese_lemma VALUES ("n#03880945","n","cor-de-laranja","N");
INSERT INTO portuguese_lemma VALUES ("n#00243962","n","combinação","N");
INSERT INTO portuguese_lemma VALUES ("n#00559255","n","combinação","N");
INSERT INTO portuguese_lemma VALUES ("n#03110842","n","combinação","N");
INSERT INTO portuguese_lemma VALUES ("n#05490939","n","combinação","N");
INSERT INTO portuguese_lemma VALUES ("n#06142606","n","combinação","N");
INSERT INTO portuguese_lemma VALUES ("n#06197501","n","combinação","N");
INSERT INTO portuguese_lemma VALUES ("v#00379154","v","cremar","N");
INSERT INTO portuguese_lemma VALUES ("r#00379301","r","inspiradamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00379588","n","enxertia","N");
INSERT INTO portuguese_lemma VALUES ("a#00362144","a","cor-de-rosa","N");
INSERT INTO portuguese_lemma VALUES ("n#03885630","n","cor-de-rosa","N");
INSERT INTO portuguese_lemma VALUES ("n#11807979","n","cor-de-rosa","N");
INSERT INTO portuguese_lemma VALUES ("a#00362144","a","rosa","N");
INSERT INTO portuguese_lemma VALUES ("n#03885630","n","rosa","N");
INSERT INTO portuguese_lemma VALUES ("n#03885875","n","rosa","N");
INSERT INTO portuguese_lemma VALUES ("n#08920236","n","rosa","N");
INSERT INTO portuguese_lemma VALUES ("n#00244416","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#00244665","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#05490939","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#05491211","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#07375405","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#05909338","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#06210851","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#06211515","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("n#10449119","n","mistura","N");
INSERT INTO portuguese_lemma VALUES ("a#00362338","a","purpúreo","N");
INSERT INTO portuguese_lemma VALUES ("a#00362338","a","roxo","N");
INSERT INTO portuguese_lemma VALUES ("n#04970059","n","roxo","N");
INSERT INTO portuguese_lemma VALUES ("n#03885490","n","roxo","N");
INSERT INTO portuguese_lemma VALUES ("a#00362338","a","violeta","N");
INSERT INTO portuguese_lemma VALUES ("n#04536335","n","violeta","N");
INSERT INTO portuguese_lemma VALUES ("n#04970059","n","violeta","N");
INSERT INTO portuguese_lemma VALUES ("n#03885490","n","violeta","N");
INSERT INTO portuguese_lemma VALUES ("n#08691021","n","violeta","N");
INSERT INTO portuguese_lemma VALUES ("a#00362338","a","lilás","N");
INSERT INTO portuguese_lemma VALUES ("n#03885490","n","lilás","N");
INSERT INTO portuguese_lemma VALUES ("n#08613795","n","lilás","N");
INSERT INTO portuguese_lemma VALUES ("a#00362338","a","púrpura","N");
INSERT INTO portuguese_lemma VALUES ("n#04970059","n","púrpura","N");
INSERT INTO portuguese_lemma VALUES ("v#00380424","v","transpor","N");
INSERT INTO portuguese_lemma VALUES ("n#00244573","n","fusão","N");
INSERT INTO portuguese_lemma VALUES ("n#00804210","n","fusão","N");
INSERT INTO portuguese_lemma VALUES ("n#05490810","n","fusão","N");
INSERT INTO portuguese_lemma VALUES ("n#09724169","n","fusão","N");
INSERT INTO portuguese_lemma VALUES ("n#09720762","n","fusão","N");
INSERT INTO portuguese_lemma VALUES ("n#09741527","n","fusão","N");
INSERT INTO portuguese_lemma VALUES ("n#10345580","n","fusão","N");
INSERT INTO portuguese_lemma VALUES ("r#00380590","r","interrogativamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00265330","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("v#00994853","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("v#00996361","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("v#01949674","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("v#01328437","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("v#01330495","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("v#01373274","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("v#01422262","v","transportar","N");
INSERT INTO portuguese_lemma VALUES ("n#00380994","n","homogenização","N");
INSERT INTO portuguese_lemma VALUES ("a#00362449","a","avermelhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00362449","a","carmim","N");
INSERT INTO portuguese_lemma VALUES ("n#03879753","n","carmim","N");
INSERT INTO portuguese_lemma VALUES ("n#04963588","n","carmim","N");
INSERT INTO portuguese_lemma VALUES ("a#00362449","a","sangue-vermelho","N");
INSERT INTO portuguese_lemma VALUES ("a#00362449","a","vermelho","N");
INSERT INTO portuguese_lemma VALUES ("a#00385188","a","vermelho","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","vermelho","N");
INSERT INTO portuguese_lemma VALUES ("n#03879230","n","vermelho","N");
INSERT INTO portuguese_lemma VALUES ("n#04964977","n","vermelho","N");
INSERT INTO portuguese_lemma VALUES ("a#00362449","a","cereja","N");
INSERT INTO portuguese_lemma VALUES ("n#04964443","n","cereja","N");
INSERT INTO portuguese_lemma VALUES ("n#07757132","n","cereja","N");
INSERT INTO portuguese_lemma VALUES ("n#07757312","n","cereja","N");
INSERT INTO portuguese_lemma VALUES ("a#00362449","a","encarnado","N");
INSERT INTO portuguese_lemma VALUES ("n#03879230","n","encarnado","N");
INSERT INTO portuguese_lemma VALUES ("r#00381557","r","intuitivamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00381567","n","a_temperança","Y");
INSERT INTO portuguese_lemma VALUES ("v#00266041","v","transmutar","N");
INSERT INTO portuguese_lemma VALUES ("n#00245212","n","unificação","N");
INSERT INTO portuguese_lemma VALUES ("n#05490810","n","unificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00245479","n","coalescência","N");
INSERT INTO portuguese_lemma VALUES ("r#00382151","r","invisivelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00245609","n","reunificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00245609","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#00654309","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#00654904","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#00798100","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#00799023","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#00799654","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#05978845","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#06166238","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#06167318","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#08415774","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("n#06258566","n","reunião","N");
INSERT INTO portuguese_lemma VALUES ("r#00382507","r","ironicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00382620","r","ironicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00382620","r","de_forma_irônica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00246048","n","abertura","N");
INSERT INTO portuguese_lemma VALUES ("n#00457890","n","abertura","N");
INSERT INTO portuguese_lemma VALUES ("n#03057886","n","abertura","N");
INSERT INTO portuguese_lemma VALUES ("n#09201031","n","abertura","N");
INSERT INTO portuguese_lemma VALUES ("n#10021740","n","abertura","N");
INSERT INTO portuguese_lemma VALUES ("r#00383428","r","irreversivelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00246210","n","separação","N");
INSERT INTO portuguese_lemma VALUES ("n#00255068","n","separação","N");
INSERT INTO portuguese_lemma VALUES ("n#00778210","n","separação","N");
INSERT INTO portuguese_lemma VALUES ("n#00815560","n","separação","N");
INSERT INTO portuguese_lemma VALUES ("n#10342852","n","separação","N");
INSERT INTO portuguese_lemma VALUES ("n#00246501","n","interrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#00660117","n","interrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#05486357","n","interrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#10969750","n","interrupção","N");
INSERT INTO portuguese_lemma VALUES ("n#00246501","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#00687670","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#00687814","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#01063578","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#05137171","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#05486357","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#10093496","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#10969750","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#10970463","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#10972097","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("n#15274441","n","pausa","N");
INSERT INTO portuguese_lemma VALUES ("a#00384099","a","baio","N");
INSERT INTO portuguese_lemma VALUES ("a#00384195","a","pétreo","N");
INSERT INTO portuguese_lemma VALUES ("r#00384783","r","judiciosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00384783","r","sensatamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00384783","r","criteriosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00384933","n","secessão","N");
INSERT INTO portuguese_lemma VALUES ("n#00385649","n","disjunção","N");
INSERT INTO portuguese_lemma VALUES ("n#14417697","n","disjunção","N");
INSERT INTO portuguese_lemma VALUES ("a#00364444","a","tirante","N");
INSERT INTO portuguese_lemma VALUES ("a#00364444","a","amarelo","N");
INSERT INTO portuguese_lemma VALUES ("a#01581686","a","amarelo","N");
INSERT INTO portuguese_lemma VALUES ("n#03881286","n","amarelo","N");
INSERT INTO portuguese_lemma VALUES ("n#03881805","n","amarelo","N");
INSERT INTO portuguese_lemma VALUES ("a#00364444","a","amarelento","N");
INSERT INTO portuguese_lemma VALUES ("a#00364444","a","amarelado","N");
INSERT INTO portuguese_lemma VALUES ("n#00247514","n","divisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00255068","n","divisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00559516","n","divisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00701814","n","divisão","N");
INSERT INTO portuguese_lemma VALUES ("n#05368405","n","divisão","N");
INSERT INTO portuguese_lemma VALUES ("n#06102171","n","divisão","N");
INSERT INTO portuguese_lemma VALUES ("v#00386390","v","evangelizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00828227","v","evangelizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00386392","a","acromático","N");
INSERT INTO portuguese_lemma VALUES ("n#00386450","n","bissetriz","N");
INSERT INTO portuguese_lemma VALUES ("n#13871967","n","bissetriz","N");
INSERT INTO portuguese_lemma VALUES ("n#00386450","n","bissecção","N");
INSERT INTO portuguese_lemma VALUES ("n#00386553","n","carcaças_de_animais","Y");
INSERT INTO portuguese_lemma VALUES ("n#00386553","n","quartel","N");
INSERT INTO portuguese_lemma VALUES ("n#02808393","n","quartel","N");
INSERT INTO portuguese_lemma VALUES ("n#02997669","n","quartel","N");
INSERT INTO portuguese_lemma VALUES ("r#00386587","r","lateralmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00386765","r","lateralmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00386676","n","cisma","N");
INSERT INTO portuguese_lemma VALUES ("n#00386676","n","dissidência","N");
INSERT INTO portuguese_lemma VALUES ("n#10018021","n","dissidência","N");
INSERT INTO portuguese_lemma VALUES ("n#00386676","n","cisão","N");
INSERT INTO portuguese_lemma VALUES ("v#00268521","v","investir","N");
INSERT INTO portuguese_lemma VALUES ("v#01553891","v","investir","N");
INSERT INTO portuguese_lemma VALUES ("v#02386675","v","investir","N");
INSERT INTO portuguese_lemma VALUES ("v#01685814","v","investir","N");
INSERT INTO portuguese_lemma VALUES ("n#00387214","n","dissecção","N");
INSERT INTO portuguese_lemma VALUES ("n#00248688","n","cortamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00248688","n","corte","N");
INSERT INTO portuguese_lemma VALUES ("n#00388065","n","corte","N");
INSERT INTO portuguese_lemma VALUES ("n#04081828","n","corte","N");
INSERT INTO portuguese_lemma VALUES ("n#07653394","n","corte","N");
INSERT INTO portuguese_lemma VALUES ("n#08051946","n","corte","N");
INSERT INTO portuguese_lemma VALUES ("n#10258725","n","corte","N");
INSERT INTO portuguese_lemma VALUES ("r#00387828","r","à_direita","Y");
INSERT INTO portuguese_lemma VALUES ("v#00387919","v","personalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00388065","v","personalizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00388209","r","ao_comprido","Y");
INSERT INTO portuguese_lemma VALUES ("n#00388210","n","fragmentação","N");
INSERT INTO portuguese_lemma VALUES ("n#13484303","n","fragmentação","N");
INSERT INTO portuguese_lemma VALUES ("v#00269459","v","assolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00269459","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00328583","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00734516","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01103603","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#00938146","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01077449","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01078694","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01113462","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01114042","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01620688","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01137612","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("v#01657977","v","destruir","N");
INSERT INTO portuguese_lemma VALUES ("n#00388710","n","bifurcação","N");
INSERT INTO portuguese_lemma VALUES ("n#13887056","n","bifurcação","N");
INSERT INTO portuguese_lemma VALUES ("n#13914265","n","bifurcação","N");
INSERT INTO portuguese_lemma VALUES ("n#00389308","n","quantizacão","N");
INSERT INTO portuguese_lemma VALUES ("n#00389308","n","quantização","N");
INSERT INTO portuguese_lemma VALUES ("a#00366117","a","gris","N");
INSERT INTO portuguese_lemma VALUES ("a#00366117","a","acinzentado","N");
INSERT INTO portuguese_lemma VALUES ("a#00366117","a","cinzenta","N");
INSERT INTO portuguese_lemma VALUES ("a#00366117","a","cinzento","N");
INSERT INTO portuguese_lemma VALUES ("a#02575653","a","cinzento","N");
INSERT INTO portuguese_lemma VALUES ("a#00366117","a","cinza","N");
INSERT INTO portuguese_lemma VALUES ("n#03878371","n","cinza","N");
INSERT INTO portuguese_lemma VALUES ("n#11012676","n","cinza","N");
INSERT INTO portuguese_lemma VALUES ("n#10588962","n","cinza","N");
INSERT INTO portuguese_lemma VALUES ("r#00389804","r","sem_entusiasmo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00390198","n","pontuação","N");
INSERT INTO portuguese_lemma VALUES ("n#00390198","n","Pontuação","N");
INSERT INTO portuguese_lemma VALUES ("n#00390445","n","colocação_de_hífens","Y");
INSERT INTO portuguese_lemma VALUES ("n#00390445","n","divisão_da_palavra_no_final_da_linha","Y");
INSERT INTO portuguese_lemma VALUES ("n#00390581","n","separação_em_sílabas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00390581","n","silabação","N");
INSERT INTO portuguese_lemma VALUES ("n#00390581","n","divisão_em_sílabas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00390735","n","hifenização","N");
INSERT INTO portuguese_lemma VALUES ("n#00391086","n","rasgão","N");
INSERT INTO portuguese_lemma VALUES ("n#09410928","n","rasgão","N");
INSERT INTO portuguese_lemma VALUES ("a#00391487","a","sable","N");
INSERT INTO portuguese_lemma VALUES ("a#00391487","a","saibro","N");
INSERT INTO portuguese_lemma VALUES ("n#00251311","n","remoção","N");
INSERT INTO portuguese_lemma VALUES ("a#00392093","a","nevoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00272165","v","acerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00272165","v","afiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00272277","v","afiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00272424","v","afiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00272798","v","afiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00850117","v","afiar","N");
INSERT INTO portuguese_lemma VALUES ("a#00392460","a","esbranquiçado","N");
INSERT INTO portuguese_lemma VALUES ("a#00403517","a","esbranquiçado","N");
INSERT INTO portuguese_lemma VALUES ("n#00392468","n","derivação","N");
INSERT INTO portuguese_lemma VALUES ("n#05780718","n","derivação","N");
INSERT INTO portuguese_lemma VALUES ("n#06744154","n","derivação","N");
INSERT INTO portuguese_lemma VALUES ("n#08508105","n","derivação","N");
INSERT INTO portuguese_lemma VALUES ("n#13462387","n","derivação","N");
INSERT INTO portuguese_lemma VALUES ("r#00392531","r","logaritimicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00392690","r","mais_longo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00392690","r","mais_comprido","Y");
INSERT INTO portuguese_lemma VALUES ("r#00392690","r","por_mais_tempo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00392782","r","o_mais_comprido","Y");
INSERT INTO portuguese_lemma VALUES ("a#00367459","a","atro","N");
INSERT INTO portuguese_lemma VALUES ("a#00367459","a","preto","N");
INSERT INTO portuguese_lemma VALUES ("n#03877202","n","preto","N");
INSERT INTO portuguese_lemma VALUES ("n#09638009","n","preto","N");
INSERT INTO portuguese_lemma VALUES ("v#00272798","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("n#00815644","n","apontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00625042","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00924431","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00625553","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00955472","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00685329","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00781920","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00782363","v","apontar","N");
INSERT INTO portuguese_lemma VALUES ("a#00367747","a","cândido","N");
INSERT INTO portuguese_lemma VALUES ("a#02271544","a","cândido","N");
INSERT INTO portuguese_lemma VALUES ("n#03877535","n","cândido","N");
INSERT INTO portuguese_lemma VALUES ("a#00367747","a","alvo","N");
INSERT INTO portuguese_lemma VALUES ("n#03877535","n","alvo","N");
INSERT INTO portuguese_lemma VALUES ("n#04586952","n","alvo","N");
INSERT INTO portuguese_lemma VALUES ("n#05419337","n","alvo","N");
INSERT INTO portuguese_lemma VALUES ("n#00393369","n","ablação","N");
INSERT INTO portuguese_lemma VALUES ("a#00393508","a","puro","N");
INSERT INTO portuguese_lemma VALUES ("a#01116978","a","puro","N");
INSERT INTO portuguese_lemma VALUES ("a#01835892","a","puro","N");
INSERT INTO portuguese_lemma VALUES ("a#01053037","a","puro","N");
INSERT INTO portuguese_lemma VALUES ("v#00393677","v","aclimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00393677","v","aclimatar","N");
INSERT INTO portuguese_lemma VALUES ("a#00368180","a","intenso","N");
INSERT INTO portuguese_lemma VALUES ("a#00764129","a","intenso","N");
INSERT INTO portuguese_lemma VALUES ("a#01447403","a","intenso","N");
INSERT INTO portuguese_lemma VALUES ("a#01449858","a","intenso","N");
INSERT INTO portuguese_lemma VALUES ("a#01451847","a","intenso","N");
INSERT INTO portuguese_lemma VALUES ("v#00393953","v","sincronizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00464828","v","sincronizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00464996","v","sincronizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00735866","v","sincronizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00960734","v","sincronizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02739254","v","sincronizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00394135","a","colorido(a)","N");
INSERT INTO portuguese_lemma VALUES ("n#00394242","n","autotomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00394242","n","Autotomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00394485","n","descontaminação","N");
INSERT INTO portuguese_lemma VALUES ("a#00394562","a","colorido","N");
INSERT INTO portuguese_lemma VALUES ("a#00375007","a","colorido","N");
INSERT INTO portuguese_lemma VALUES ("a#00406867","a","colorido","N");
INSERT INTO portuguese_lemma VALUES ("n#00254500","n","deletamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00254500","n","deleção","N");
INSERT INTO portuguese_lemma VALUES ("n#00394803","n","denudação","N");
INSERT INTO portuguese_lemma VALUES ("v#00274169","v","fundir","N");
INSERT INTO portuguese_lemma VALUES ("v#00275897","v","fundir","N");
INSERT INTO portuguese_lemma VALUES ("v#00444629","v","fundir","N");
INSERT INTO portuguese_lemma VALUES ("v#00332368","v","fundir","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","rússeo","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","rúbido","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","rubicundo","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","rubro","N");
INSERT INTO portuguese_lemma VALUES ("a#00531887","a","rubro","N");
INSERT INTO portuguese_lemma VALUES ("n#03879230","n","rubro","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","rúbeo","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","rufo","N");
INSERT INTO portuguese_lemma VALUES ("a#00372041","a","escarlate","N");
INSERT INTO portuguese_lemma VALUES ("n#03879230","n","escarlate","N");
INSERT INTO portuguese_lemma VALUES ("n#04964977","n","escarlate","N");
INSERT INTO portuguese_lemma VALUES ("n#00395654","n","Circuncisao","N");
INSERT INTO portuguese_lemma VALUES ("n#00395654","n","Circuncisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00395654","n","circuncisão","N");
INSERT INTO portuguese_lemma VALUES ("n#01031194","n","circuncisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00396029","n","drenagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00396029","n","dreno","N");
INSERT INTO portuguese_lemma VALUES ("n#00396029","n","águas_residuais","Y");
INSERT INTO portuguese_lemma VALUES ("n#14857021","n","águas_residuais","Y");
INSERT INTO portuguese_lemma VALUES ("a#00396115","a","bicolor","N");
INSERT INTO portuguese_lemma VALUES ("n#00396642","n","enxaguadura","N");
INSERT INTO portuguese_lemma VALUES ("n#00396642","n","enxaguadelas","N");
INSERT INTO portuguese_lemma VALUES ("v#00396880","v","aliar","N");
INSERT INTO portuguese_lemma VALUES ("n#00397010","n","castração","N");
INSERT INTO portuguese_lemma VALUES ("n#00667847","n","castração","N");
INSERT INTO portuguese_lemma VALUES ("n#00179384","n","castração","N");
INSERT INTO portuguese_lemma VALUES ("r#00397327","r","de_forma_significativa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00254803","n","censura","N");
INSERT INTO portuguese_lemma VALUES ("n#00525511","n","censura","N");
INSERT INTO portuguese_lemma VALUES ("v#00397405","v","desmoronar","N");
INSERT INTO portuguese_lemma VALUES ("v#01989053","v","desmoronar","N");
INSERT INTO portuguese_lemma VALUES ("v#01395145","v","desmoronar","N");
INSERT INTO portuguese_lemma VALUES ("v#00397405","v","cair_aos_pedaços","Y");
INSERT INTO portuguese_lemma VALUES ("v#00397405","v","desfazer-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01521543","v","desfazer-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00397576","v","desintegrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00255068","n","segmentação","N");
INSERT INTO portuguese_lemma VALUES ("n#13449156","n","segmentação","N");
INSERT INTO portuguese_lemma VALUES ("n#00255068","n","partição","N");
INSERT INTO portuguese_lemma VALUES ("n#00703319","n","partição","N");
INSERT INTO portuguese_lemma VALUES ("n#13627114","n","partição","N");
INSERT INTO portuguese_lemma VALUES ("a#00398172","a","ouro-colorido","N");
INSERT INTO portuguese_lemma VALUES ("r#00398528","r","medianamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00255421","n","transformação","N");
INSERT INTO portuguese_lemma VALUES ("n#00399030","n","transformação","N");
INSERT INTO portuguese_lemma VALUES ("n#05481414","n","transformação","N");
INSERT INTO portuguese_lemma VALUES ("n#09927401","n","transformação","N");
INSERT INTO portuguese_lemma VALUES ("v#00398953","v","macerar","N");
INSERT INTO portuguese_lemma VALUES ("a#00398978","a","multicor","N");
INSERT INTO portuguese_lemma VALUES ("a#00398978","a","multicolor","N");
INSERT INTO portuguese_lemma VALUES ("v#00399553","v","gorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00400101","v","desmagnetizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00998762","v","desmagnetizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00400192","r","no_duro","Y");
INSERT INTO portuguese_lemma VALUES ("n#00256511","n","florestamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00256511","n","florestação","N");
INSERT INTO portuguese_lemma VALUES ("v#00400427","v","simplificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00400449","n","reflorestação","N");
INSERT INTO portuguese_lemma VALUES ("n#00400449","n","cobertura_vegetal_(restauração)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00400449","n","reflorestamento","N");
INSERT INTO portuguese_lemma VALUES ("a#00400472","a","ruão","N");
INSERT INTO portuguese_lemma VALUES ("v#00278110","v","complicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00279361","v","complicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00278110","v","refinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00330153","v","refinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00330354","v","refinar","N");
INSERT INTO portuguese_lemma VALUES ("a#00401125","a","tricolor","N");
INSERT INTO portuguese_lemma VALUES ("n#04481796","n","tricolor","N");
INSERT INTO portuguese_lemma VALUES ("n#00401194","n","renovação_urbana","Y");
INSERT INTO portuguese_lemma VALUES ("n#00401783","n","Recreação","N");
INSERT INTO portuguese_lemma VALUES ("n#00401783","n","recreação","N");
INSERT INTO portuguese_lemma VALUES ("n#00402128","n","metamorfose","N");
INSERT INTO portuguese_lemma VALUES ("n#00402308","n","metamorfose","N");
INSERT INTO portuguese_lemma VALUES ("n#13514880","n","metamorfose","N");
INSERT INTO portuguese_lemma VALUES ("n#00402671","n","enchimento_(materiais)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00402671","n","enchimento","N");
INSERT INTO portuguese_lemma VALUES ("n#07883031","n","enchimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00402671","n","saturação","N");
INSERT INTO portuguese_lemma VALUES ("a#00757408","a","saturação","N");
INSERT INTO portuguese_lemma VALUES ("r#00402764","r","milagrosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00402938","r","miseràvel","N");
INSERT INTO portuguese_lemma VALUES ("r#00402938","r","miseravelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00402951","n","revenido","N");
INSERT INTO portuguese_lemma VALUES ("n#00258668","n","danificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00258668","n","deterioração","N");
INSERT INTO portuguese_lemma VALUES ("n#13456715","n","deterioração","N");
INSERT INTO portuguese_lemma VALUES ("n#13464204","n","deterioração","N");
INSERT INTO portuguese_lemma VALUES ("n#00403466","n","desfiguração","N");
INSERT INTO portuguese_lemma VALUES ("n#00403466","n","desfiguramento","N");
INSERT INTO portuguese_lemma VALUES ("n#00403783","n","ferimento","N");
INSERT INTO portuguese_lemma VALUES ("n#10257907","n","ferimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00403911","n","queimadura","N");
INSERT INTO portuguese_lemma VALUES ("n#04694090","n","queimadura","N");
INSERT INTO portuguese_lemma VALUES ("n#14289590","n","queimadura","N");
INSERT INTO portuguese_lemma VALUES ("v#00403967","v","despressurizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00403967","v","descompactar","N");
INSERT INTO portuguese_lemma VALUES ("r#00404073","r","mortalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00280835","v","estruturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00404401","v","reconstituir","N");
INSERT INTO portuguese_lemma VALUES ("v#00281123","v","coordenar","N");
INSERT INTO portuguese_lemma VALUES ("v#02437905","v","coordenar","N");
INSERT INTO portuguese_lemma VALUES ("v#02438228","v","coordenar","N");
INSERT INTO portuguese_lemma VALUES ("n#00259853","n","deformação","N");
INSERT INTO portuguese_lemma VALUES ("n#05480717","n","deformação","N");
INSERT INTO portuguese_lemma VALUES ("n#05530333","n","deformação","N");
INSERT INTO portuguese_lemma VALUES ("n#00404959","n","convolução","N");
INSERT INTO portuguese_lemma VALUES ("n#00405106","n","angulação","N");
INSERT INTO portuguese_lemma VALUES ("a#00405179","a","sóbrio","N");
INSERT INTO portuguese_lemma VALUES ("a#00654166","a","sóbrio","N");
INSERT INTO portuguese_lemma VALUES ("a#00799517","a","sóbrio","N");
INSERT INTO portuguese_lemma VALUES ("n#00405206","n","inflexão","N");
INSERT INTO portuguese_lemma VALUES ("v#00281483","v","centralizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00405540","v","desconcentrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00405540","v","descentralizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00405645","r","mutuamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00405645","r","mutualmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00405766","n","estardecócoras","N");
INSERT INTO portuguese_lemma VALUES ("a#00405879","a","pálido","N");
INSERT INTO portuguese_lemma VALUES ("a#00380084","a","pálido","N");
INSERT INTO portuguese_lemma VALUES ("n#00406114","n","palpite","N");
INSERT INTO portuguese_lemma VALUES ("r#00406157","r","inocentemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00282202","v","aprontar","N");
INSERT INTO portuguese_lemma VALUES ("v#00282202","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("v#00406963","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("v#00283094","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("v#00283642","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("v#01142893","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("v#01143604","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("v#01198518","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("v#01626290","v","preparar","N");
INSERT INTO portuguese_lemma VALUES ("n#00407407","n","estreitamento","N");
INSERT INTO portuguese_lemma VALUES ("a#00379319","a","vistoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02280733","a","vistoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00261466","n","ocupação","N");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","ocupação","N");
INSERT INTO portuguese_lemma VALUES ("n#00582868","n","ocupação","N");
INSERT INTO portuguese_lemma VALUES ("n#00382624","n","ocupação","N");
INSERT INTO portuguese_lemma VALUES ("n#00383807","n","ocupação","N");
INSERT INTO portuguese_lemma VALUES ("a#00407766","a","ruidoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01850366","a","ruidoso","N");
INSERT INTO portuguese_lemma VALUES ("r#00407802","r","mais_perto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00407802","r","aquele_que_termina","Y");
INSERT INTO portuguese_lemma VALUES ("r#00407802","r","mais_próximo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00408021","r","o_mais_perto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00408021","r","o_mais_justo","Y");
INSERT INTO portuguese_lemma VALUES ("r#00408021","r","o_mais_próximo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00408031","a","sem_cor","Y");
INSERT INTO portuguese_lemma VALUES ("a#00408031","a","incolor","N");
INSERT INTO portuguese_lemma VALUES ("v#00409119","v","internacionalizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00409200","r","nervosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00409459","r","nervosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00409319","a","pulvéreo","N");
INSERT INTO portuguese_lemma VALUES ("a#02233390","a","pulvéreo","N");
INSERT INTO portuguese_lemma VALUES ("n#00262937","n","operação","N");
INSERT INTO portuguese_lemma VALUES ("n#00378984","n","operação","N");
INSERT INTO portuguese_lemma VALUES ("n#00436664","n","operação","N");
INSERT INTO portuguese_lemma VALUES ("n#00869583","n","operação","N");
INSERT INTO portuguese_lemma VALUES ("n#00611703","n","operação","N");
INSERT INTO portuguese_lemma VALUES ("n#00709934","n","operação","N");
INSERT INTO portuguese_lemma VALUES ("n#09747131","n","operação","N");
INSERT INTO portuguese_lemma VALUES ("r#00409597","r","nunca_mais","Y");
INSERT INTO portuguese_lemma VALUES ("v#00409643","v","americanizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00410406","v","americanizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00263204","n","costume","N");
INSERT INTO portuguese_lemma VALUES ("n#00263789","n","costume","N");
INSERT INTO portuguese_lemma VALUES ("n#00265102","n","costume","N");
INSERT INTO portuguese_lemma VALUES ("n#00265920","n","costume","N");
INSERT INTO portuguese_lemma VALUES ("n#00266254","n","costume","N");
INSERT INTO portuguese_lemma VALUES ("n#04381279","n","costume","N");
INSERT INTO portuguese_lemma VALUES ("n#04382516","n","costume","N");
INSERT INTO portuguese_lemma VALUES ("n#00263204","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("n#00265102","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("n#00265920","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("n#00266254","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("n#03398153","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("n#02783002","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("n#04381279","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("n#04382516","n","hábito","N");
INSERT INTO portuguese_lemma VALUES ("a#00382498","a","cristão","N");
INSERT INTO portuguese_lemma VALUES ("a#00382668","a","cristão","N");
INSERT INTO portuguese_lemma VALUES ("a#02721959","a","cristão","N");
INSERT INTO portuguese_lemma VALUES ("n#06995978","n","cristão","N");
INSERT INTO portuguese_lemma VALUES ("n#09678917","n","cristão","N");
INSERT INTO portuguese_lemma VALUES ("v#00285583","v","modernizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00263789","n","praxe","N");
INSERT INTO portuguese_lemma VALUES ("n#00263789","n","Praxis","N");
INSERT INTO portuguese_lemma VALUES ("n#00263789","n","práxis","N");
INSERT INTO portuguese_lemma VALUES ("n#00263789","n","Práxis","N");
INSERT INTO portuguese_lemma VALUES ("n#00263789","n","costumes","N");
INSERT INTO portuguese_lemma VALUES ("n#04381279","n","costumes","N");
INSERT INTO portuguese_lemma VALUES ("n#04382516","n","costumes","N");
INSERT INTO portuguese_lemma VALUES ("r#00411171","r","numericamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00411312","v","civilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01626835","v","civilizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00264082","n","cooperação","N");
INSERT INTO portuguese_lemma VALUES ("n#00779286","n","cooperação","N");
INSERT INTO portuguese_lemma VALUES ("n#00780822","n","cooperação","N");
INSERT INTO portuguese_lemma VALUES ("v#00411547","v","nacionalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00411547","v","estatizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00411570","r","de_forma_alguma","Y");
INSERT INTO portuguese_lemma VALUES ("a#02267686","a","de_forma_alguma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00411570","r","de_maneira_nenhuma","Y");
INSERT INTO portuguese_lemma VALUES ("a#02267686","a","de_maneira_nenhuma","Y");
INSERT INTO portuguese_lemma VALUES ("r#00411570","r","de_modo_algum","Y");
INSERT INTO portuguese_lemma VALUES ("a#02267686","a","de_modo_algum","Y");
INSERT INTO portuguese_lemma VALUES ("n#00411717","n","formalismo","N");
INSERT INTO portuguese_lemma VALUES ("n#05961867","n","formalismo","N");
INSERT INTO portuguese_lemma VALUES ("n#05971621","n","formalismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00411792","v","privatizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00412048","v","privatizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00411859","n","micofagia","N");
INSERT INTO portuguese_lemma VALUES ("a#00383303","a","civilizado","N");
INSERT INTO portuguese_lemma VALUES ("a#01455171","a","civilizado","N");
INSERT INTO portuguese_lemma VALUES ("r#00412178","r","subjetivamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00264645","n","Simbolismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00264645","n","simbolismo","N");
INSERT INTO portuguese_lemma VALUES ("n#05098128","n","simbolismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00383796","a","civil","N");
INSERT INTO portuguese_lemma VALUES ("a#01454970","a","civil","N");
INSERT INTO portuguese_lemma VALUES ("a#01455171","a","civil","N");
INSERT INTO portuguese_lemma VALUES ("a#02546488","a","civil","N");
INSERT INTO portuguese_lemma VALUES ("a#02546684","a","civil","N");
INSERT INTO portuguese_lemma VALUES ("n#09924742","n","civil","N");
INSERT INTO portuguese_lemma VALUES ("n#00264755","n","modernismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00264755","n","Modernismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00383901","a","humano","N");
INSERT INTO portuguese_lemma VALUES ("a#01207270","a","humano","N");
INSERT INTO portuguese_lemma VALUES ("a#01210344","a","humano","N");
INSERT INTO portuguese_lemma VALUES ("a#02575805","a","humano","N");
INSERT INTO portuguese_lemma VALUES ("a#02575899","a","humano","N");
INSERT INTO portuguese_lemma VALUES ("a#00384214","a","gentio","N");
INSERT INTO portuguese_lemma VALUES ("a#00384214","a","bravio","N");
INSERT INTO portuguese_lemma VALUES ("a#00384214","a","bárbaro","N");
INSERT INTO portuguese_lemma VALUES ("a#01212393","a","bárbaro","N");
INSERT INTO portuguese_lemma VALUES ("n#10553402","n","bárbaro","N");
INSERT INTO portuguese_lemma VALUES ("a#00384214","a","selvagem","N");
INSERT INTO portuguese_lemma VALUES ("a#02276745","a","selvagem","N");
INSERT INTO portuguese_lemma VALUES ("n#10553402","n","selvagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00412839","n","Canibalismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00412839","n","antropofagia","N");
INSERT INTO portuguese_lemma VALUES ("n#00412982","n","antropofagia","N");
INSERT INTO portuguese_lemma VALUES ("n#00412839","n","canibalismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00287066","v","adotar_como_própria","Y");
INSERT INTO portuguese_lemma VALUES ("v#00287066","v","adotar","N");
INSERT INTO portuguese_lemma VALUES ("v#01602202","v","adotar","N");
INSERT INTO portuguese_lemma VALUES ("v#01602355","v","adotar","N");
INSERT INTO portuguese_lemma VALUES ("v#00287066","v","adoptar","N");
INSERT INTO portuguese_lemma VALUES ("v#01509715","v","adoptar","N");
INSERT INTO portuguese_lemma VALUES ("v#02324026","v","adoptar","N");
INSERT INTO portuguese_lemma VALUES ("v#01602202","v","adoptar","N");
INSERT INTO portuguese_lemma VALUES ("v#01602355","v","adoptar","N");
INSERT INTO portuguese_lemma VALUES ("n#00265102","n","emprego","N");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","emprego","N");
INSERT INTO portuguese_lemma VALUES ("n#00582868","n","emprego","N");
INSERT INTO portuguese_lemma VALUES ("n#00383807","n","emprego","N");
INSERT INTO portuguese_lemma VALUES ("n#03631348","n","emprego","N");
INSERT INTO portuguese_lemma VALUES ("n#06283459","n","emprego","N");
INSERT INTO portuguese_lemma VALUES ("a#00413432","a","primitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00774150","a","primitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00778594","a","primitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00779258","a","primitivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00413432","v","imigrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00413704","v","imigrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00415967","v","imigrar","N");
INSERT INTO portuguese_lemma VALUES ("a#00385079","a","clássico","N");
INSERT INTO portuguese_lemma VALUES ("a#00413861","a","clássico","N");
INSERT INTO portuguese_lemma VALUES ("a#02185136","a","clássico","N");
INSERT INTO portuguese_lemma VALUES ("a#02298152","a","clássico","N");
INSERT INTO portuguese_lemma VALUES ("a#02698145","a","clássico","N");
INSERT INTO portuguese_lemma VALUES ("n#03038595","n","clássico","N");
INSERT INTO portuguese_lemma VALUES ("n#09926426","n","clássico","N");
INSERT INTO portuguese_lemma VALUES ("a#00414080","a","neoclássico","N");
INSERT INTO portuguese_lemma VALUES ("v#00287786","v","colonizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02590340","v","colonizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00385718","a","moderno","N");
INSERT INTO portuguese_lemma VALUES ("a#00668208","a","moderno","N");
INSERT INTO portuguese_lemma VALUES ("a#01473088","a","moderno","N");
INSERT INTO portuguese_lemma VALUES ("a#01472209","a","moderno","N");
INSERT INTO portuguese_lemma VALUES ("a#01804618","a","moderno","N");
INSERT INTO portuguese_lemma VALUES ("a#00385718","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00629488","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00778835","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#01473088","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#01472209","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#01472664","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#01804618","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#02266362","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#02266780","a","contemporâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00414518","a","popular","N");
INSERT INTO portuguese_lemma VALUES ("a#00681477","a","popular","N");
INSERT INTO portuguese_lemma VALUES ("a#01536434","a","popular","N");
INSERT INTO portuguese_lemma VALUES ("a#01744822","a","popular","N");
INSERT INTO portuguese_lemma VALUES ("r#00414619","r","opcionalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00414709","a","classificado","N");
INSERT INTO portuguese_lemma VALUES ("r#00414750","r","obrigatoriamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00414823","a","categorizado","N");
INSERT INTO portuguese_lemma VALUES ("v#00287938","v","luxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00287938","v","deslocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01249365","v","deslocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01374681","v","deslocar","N");
INSERT INTO portuguese_lemma VALUES ("v#01285412","v","deslocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00288116","v","povoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00451279","v","povoar","N");
INSERT INTO portuguese_lemma VALUES ("v#00315029","v","povoar","N");
INSERT INTO portuguese_lemma VALUES ("v#01809405","v","povoar","N");
INSERT INTO portuguese_lemma VALUES ("r#00415058","r","organizacionalmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00415398","v","enraizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00415442","n","escravidão","N");
INSERT INTO portuguese_lemma VALUES ("n#00623545","n","escravidão","N");
INSERT INTO portuguese_lemma VALUES ("n#13997253","n","escravidão","N");
INSERT INTO portuguese_lemma VALUES ("n#00266805","n","modo_de_vida","Y");
INSERT INTO portuguese_lemma VALUES ("a#00415696","a","confidencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00452605","a","confidencial","N");
INSERT INTO portuguese_lemma VALUES ("a#01788995","a","confidencial","N");
INSERT INTO portuguese_lemma VALUES ("a#01789223","a","confidencial","N");
INSERT INTO portuguese_lemma VALUES ("r#00415963","r","demasiadamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00416135","v","emigrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01856626","v","emigrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00416399","v","expatriar","N");
INSERT INTO portuguese_lemma VALUES ("n#00416409","n","Suna","N");
INSERT INTO portuguese_lemma VALUES ("a#00416765","a","analisado","N");
INSERT INTO portuguese_lemma VALUES ("v#00416880","v","ser_igual_a","Y");
INSERT INTO portuguese_lemma VALUES ("v#00289728","v","equiparar","N");
INSERT INTO portuguese_lemma VALUES ("v#00653620","v","equiparar","N");
INSERT INTO portuguese_lemma VALUES ("n#00417131","n","chave-de-braço","N");
INSERT INTO portuguese_lemma VALUES ("n#00268156","n","abraço","N");
INSERT INTO portuguese_lemma VALUES ("n#00417859","n","abraço","N");
INSERT INTO portuguese_lemma VALUES ("a#00388571","a","limpo","N");
INSERT INTO portuguese_lemma VALUES ("a#00389229","a","limpo","N");
INSERT INTO portuguese_lemma VALUES ("v#00417596","v","enrijecer","N");
INSERT INTO portuguese_lemma VALUES ("r#00417787","r","por_meio_de","Y");
INSERT INTO portuguese_lemma VALUES ("v#00417856","v","engomar","N");
INSERT INTO portuguese_lemma VALUES ("n#15018889","n","engomar","N");
INSERT INTO portuguese_lemma VALUES ("a#00417898","a","limpável","N");
INSERT INTO portuguese_lemma VALUES ("n#00418025","n","mau_tratamento","Y");
INSERT INTO portuguese_lemma VALUES ("a#00389579","a","imaculado","N");
INSERT INTO portuguese_lemma VALUES ("a#01835400","a","imaculado","N");
INSERT INTO portuguese_lemma VALUES ("n#00270946","n","irritação","N");
INSERT INTO portuguese_lemma VALUES ("n#00792860","n","irritação","N");
INSERT INTO portuguese_lemma VALUES ("n#04491038","n","irritação","N");
INSERT INTO portuguese_lemma VALUES ("n#07518261","n","irritação","N");
INSERT INTO portuguese_lemma VALUES ("n#05589637","n","irritação","N");
INSERT INTO portuguese_lemma VALUES ("n#07518878","n","irritação","N");
INSERT INTO portuguese_lemma VALUES ("n#10337915","n","irritação","N");
INSERT INTO portuguese_lemma VALUES ("v#00290685","v","inrijecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00291639","v","sossegar","N");
INSERT INTO portuguese_lemma VALUES ("a#00390524","a","sujado","N");
INSERT INTO portuguese_lemma VALUES ("a#00390524","a","suja","N");
INSERT INTO portuguese_lemma VALUES ("a#00394778","a","suja","N");
INSERT INTO portuguese_lemma VALUES ("a#00390524","a","sujo","N");
INSERT INTO portuguese_lemma VALUES ("a#00391672","a","sujo","N");
INSERT INTO portuguese_lemma VALUES ("a#00421590","a","sujo","N");
INSERT INTO portuguese_lemma VALUES ("a#00394778","a","sujo","N");
INSERT INTO portuguese_lemma VALUES ("a#00407480","a","sujo","N");
INSERT INTO portuguese_lemma VALUES ("a#00910510","a","sujo","N");
INSERT INTO portuguese_lemma VALUES ("a#01587474","a","sujo","N");
INSERT INTO portuguese_lemma VALUES ("n#00419315","n","Blaxploitation","N");
INSERT INTO portuguese_lemma VALUES ("v#00291365","v","afrouxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00293010","v","afrouxar","N");
INSERT INTO portuguese_lemma VALUES ("r#00419876","r","percepcionalmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00268796","n","injúria","N");
INSERT INTO portuguese_lemma VALUES ("n#00479622","n","injúria","N");
INSERT INTO portuguese_lemma VALUES ("n#00794210","n","injúria","N");
INSERT INTO portuguese_lemma VALUES ("n#00794619","n","injúria","N");
INSERT INTO portuguese_lemma VALUES ("n#05036589","n","injúria","N");
INSERT INTO portuguese_lemma VALUES ("n#06720600","n","injúria","N");
INSERT INTO portuguese_lemma VALUES ("n#00268796","n","abuso","N");
INSERT INTO portuguese_lemma VALUES ("n#00606110","n","abuso","N");
INSERT INTO portuguese_lemma VALUES ("n#00420218","n","abuso_infantil","Y");
INSERT INTO portuguese_lemma VALUES ("r#00420382","r","perpendicularmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00452126","r","perpendicularmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00391672","a","encardido","N");
INSERT INTO portuguese_lemma VALUES ("a#00391672","a","grudento","N");
INSERT INTO portuguese_lemma VALUES ("n#00421047","n","opressão","N");
INSERT INTO portuguese_lemma VALUES ("n#07538674","n","opressão","N");
INSERT INTO portuguese_lemma VALUES ("n#13996719","n","opressão","N");
INSERT INTO portuguese_lemma VALUES ("n#00421210","n","pogrom","N");
INSERT INTO portuguese_lemma VALUES ("n#00421437","n","tortura","N");
INSERT INTO portuguese_lemma VALUES ("n#05572211","n","tortura","N");
INSERT INTO portuguese_lemma VALUES ("n#14333433","n","tortura","N");
INSERT INTO portuguese_lemma VALUES ("v#00421535","v","ausentar","N");
INSERT INTO portuguese_lemma VALUES ("a#00421590","a","imunda","N");
INSERT INTO portuguese_lemma VALUES ("a#00392798","a","sórdido","N");
INSERT INTO portuguese_lemma VALUES ("v#00421917","v","caldear","N");
INSERT INTO portuguese_lemma VALUES ("v#00293860","v","surgir","N");
INSERT INTO portuguese_lemma VALUES ("v#00297068","v","surgir","N");
INSERT INTO portuguese_lemma VALUES ("v#01357011","v","surgir","N");
INSERT INTO portuguese_lemma VALUES ("v#02624263","v","surgir","N");
INSERT INTO portuguese_lemma VALUES ("v#00293860","v","aparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00294626","v","aparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00295748","v","aparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00297068","v","aparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00369654","v","aparecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01839722","v","aparecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00422168","a","gordo","N");
INSERT INTO portuguese_lemma VALUES ("a#00987180","a","gordo","N");
INSERT INTO portuguese_lemma VALUES ("a#00939455","a","gordo","N");
INSERT INTO portuguese_lemma VALUES ("a#00992432","a","gordo","N");
INSERT INTO portuguese_lemma VALUES ("a#00422374","a","piolhoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00422551","n","crucificação","N");
INSERT INTO portuguese_lemma VALUES ("n#01165337","n","crucificação","N");
INSERT INTO portuguese_lemma VALUES ("r#00422619","r","gulosamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00423269","a","ranhoso","N");
INSERT INTO portuguese_lemma VALUES ("a#01890382","a","ranhoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00294626","v","mostrar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00423971","v","publicar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00423971","v","sair_à_luz","Y");
INSERT INTO portuguese_lemma VALUES ("v#00423971","v","vir_a_lume","Y");
INSERT INTO portuguese_lemma VALUES ("v#00423971","v","destacar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00424186","n","privação_de_sono","Y");
INSERT INTO portuguese_lemma VALUES ("v#00295058","v","irromper","N");
INSERT INTO portuguese_lemma VALUES ("n#00270022","n","crueldade","N");
INSERT INTO portuguese_lemma VALUES ("n#03787057","n","crueldade","N");
INSERT INTO portuguese_lemma VALUES ("n#03797439","n","crueldade","N");
INSERT INTO portuguese_lemma VALUES ("n#05579830","n","crueldade","N");
INSERT INTO portuguese_lemma VALUES ("n#00424767","n","atrocidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00425090","n","atrocidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00746033","n","atrocidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03786431","n","atrocidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00270320","n","barbarismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00270320","n","barbárie","N");
INSERT INTO portuguese_lemma VALUES ("n#04830689","n","barbárie","N");
INSERT INTO portuguese_lemma VALUES ("n#00270320","n","actodebárbaro","N");
INSERT INTO portuguese_lemma VALUES ("a#00407480","a","obsceno","N");
INSERT INTO portuguese_lemma VALUES ("a#00425740","a","obsceno","N");
INSERT INTO portuguese_lemma VALUES ("a#00684163","a","obsceno","N");
INSERT INTO portuguese_lemma VALUES ("n#00425451","n","exasperação","N");
INSERT INTO portuguese_lemma VALUES ("n#07518878","n","exasperação","N");
INSERT INTO portuguese_lemma VALUES ("v#00296004","v","comparecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00425740","a","impudico","N");
INSERT INTO portuguese_lemma VALUES ("n#00425781","n","Assédio_Sexual","Y");
INSERT INTO portuguese_lemma VALUES ("n#00425781","n","assédio_sexual","Y");
INSERT INTO portuguese_lemma VALUES ("v#00296448","v","sair","N");
INSERT INTO portuguese_lemma VALUES ("v#00369654","v","sair","N");
INSERT INTO portuguese_lemma VALUES ("v#01258127","v","sair","N");
INSERT INTO portuguese_lemma VALUES ("v#01370454","v","sair","N");
INSERT INTO portuguese_lemma VALUES ("v#01371248","v","sair","N");
INSERT INTO portuguese_lemma VALUES ("n#00426275","n","Bruxos","N");
INSERT INTO portuguese_lemma VALUES ("n#00426275","n","Caça_às_Bruxas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00426275","n","caça_às_bruxas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00426275","n","Caça_as_bruxas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00426301","v","reaparecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00426388","n","Macartismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00426526","n","colonialismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00426757","n","neocolonialismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00426907","a","radioativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00426907","a","radioactivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00426907","a","radiativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00272358","n","recreaçao","N");
INSERT INTO portuguese_lemma VALUES ("n#00272358","n","diversão","N");
INSERT INTO portuguese_lemma VALUES ("n#00429048","n","diversão","N");
INSERT INTO portuguese_lemma VALUES ("n#00818628","n","diversão","N");
INSERT INTO portuguese_lemma VALUES ("v#00297331","v","sumir","N");
INSERT INTO portuguese_lemma VALUES ("v#01360050","v","sumir","N");
INSERT INTO portuguese_lemma VALUES ("n#00331225","n","sacanagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00331225","n","gozação","N");
INSERT INTO portuguese_lemma VALUES ("n#00331225","n","travessura","N");
INSERT INTO portuguese_lemma VALUES ("n#03844003","n","travessura","N");
INSERT INTO portuguese_lemma VALUES ("v#00427802","v","minimizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00308615","v","minimizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00841125","v","minimizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00573480","v","minimizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00864475","v","minimizar","N");
INSERT INTO portuguese_lemma VALUES ("r#00427829","r","comportepago","N");
INSERT INTO portuguese_lemma VALUES ("r#00427829","r","franqueado","N");
INSERT INTO portuguese_lemma VALUES ("r#00427829","r","borne-pago","N");
INSERT INTO portuguese_lemma VALUES ("r#00427944","r","poderosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00428245","r","poderosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00328496","n","festividade","N");
INSERT INTO portuguese_lemma VALUES ("n#15161631","n","festividade","N");
INSERT INTO portuguese_lemma VALUES ("n#10881782","n","festividade","N");
INSERT INTO portuguese_lemma VALUES ("n#00328496","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#05538537","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#05538738","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#07448038","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#07449862","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#05539623","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#05539741","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#06126536","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#08253045","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#08253640","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#06167318","n","festa","N");
INSERT INTO portuguese_lemma VALUES ("n#00328496","n","celebração","N");
INSERT INTO portuguese_lemma VALUES ("n#00509846","n","celebração","N");
INSERT INTO portuguese_lemma VALUES ("n#05539623","n","celebração","N");
INSERT INTO portuguese_lemma VALUES ("a#00428243","a","intocável","N");
INSERT INTO portuguese_lemma VALUES ("a#01761742","a","intocável","N");
INSERT INTO portuguese_lemma VALUES ("a#02526725","a","intocável","N");
INSERT INTO portuguese_lemma VALUES ("n#00337330","n","dança","N");
INSERT INTO portuguese_lemma VALUES ("n#05266564","n","dança","N");
INSERT INTO portuguese_lemma VALUES ("n#00337330","n","baile","N");
INSERT INTO portuguese_lemma VALUES ("n#05266564","n","baile","N");
INSERT INTO portuguese_lemma VALUES ("n#07448717","n","baile","N");
INSERT INTO portuguese_lemma VALUES ("n#07448885","n","baile","N");
INSERT INTO portuguese_lemma VALUES ("v#00428583","v","maximizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00428870","v","maximizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00429048","n","entretenimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00429048","n","entreterimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00330345","n","entreterimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00273579","n","entreterimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00429048","n","divertimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00330345","n","divertimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00515414","n","divertimento","N");
INSERT INTO portuguese_lemma VALUES ("n#01072072","n","divertimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00818628","n","divertimento","N");
INSERT INTO portuguese_lemma VALUES ("a#00399098","a","límpido","N");
INSERT INTO portuguese_lemma VALUES ("a#00401511","a","límpido","N");
INSERT INTO portuguese_lemma VALUES ("n#00429440","n","escapismo","N");
INSERT INTO portuguese_lemma VALUES ("r#00429815","r","predizivelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00429815","r","previsivelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00399675","a","vivaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01872076","a","vivaz","N");
INSERT INTO portuguese_lemma VALUES ("n#00325752","n","aposta","N");
INSERT INTO portuguese_lemma VALUES ("n#00326232","n","aposta","N");
INSERT INTO portuguese_lemma VALUES ("n#09607916","n","aposta","N");
INSERT INTO portuguese_lemma VALUES ("n#00325752","n","jogo_de_azar","Y");
INSERT INTO portuguese_lemma VALUES ("n#00325752","n","jogo_de_azar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00399807","a","confuso","N");
INSERT INTO portuguese_lemma VALUES ("a#00400522","a","confuso","N");
INSERT INTO portuguese_lemma VALUES ("a#00434112","a","confuso","N");
INSERT INTO portuguese_lemma VALUES ("a#01924803","a","confuso","N");
INSERT INTO portuguese_lemma VALUES ("a#00430545","a","nublado","N");
INSERT INTO portuguese_lemma VALUES ("a#00436544","a","nublado","N");
INSERT INTO portuguese_lemma VALUES ("a#00461311","a","nublado","N");
INSERT INTO portuguese_lemma VALUES ("a#00430656","a","nublado","N");
INSERT INTO portuguese_lemma VALUES ("n#00291567","n","passatempo","N");
INSERT INTO portuguese_lemma VALUES ("n#00273579","n","passatempo","N");
INSERT INTO portuguese_lemma VALUES ("n#00432689","n","passatempo","N");
INSERT INTO portuguese_lemma VALUES ("n#00291567","n","hobby","N");
INSERT INTO portuguese_lemma VALUES ("n#00432689","n","hobby","N");
INSERT INTO portuguese_lemma VALUES ("a#00400522","a","desconcertante","N");
INSERT INTO portuguese_lemma VALUES ("a#00711482","a","desconcertante","N");
INSERT INTO portuguese_lemma VALUES ("a#01737277","a","desconcertante","N");
INSERT INTO portuguese_lemma VALUES ("a#00400522","a","intrigante","N");
INSERT INTO portuguese_lemma VALUES ("a#01344684","a","intrigante","N");
INSERT INTO portuguese_lemma VALUES ("a#01897106","a","intrigante","N");
INSERT INTO portuguese_lemma VALUES ("n#00331800","n","brincadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#00511817","n","brincadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#05077026","n","brincadeira","N");
INSERT INTO portuguese_lemma VALUES ("v#00300448","v","avolumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00300448","v","engrossar","N");
INSERT INTO portuguese_lemma VALUES ("n#00273579","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#00431893","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#00289269","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#00289585","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#00290820","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#05542799","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#05990251","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#10090684","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#15256714","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("n#15256915","n","jogo","N");
INSERT INTO portuguese_lemma VALUES ("v#00300599","v","espessar","N");
INSERT INTO portuguese_lemma VALUES ("a#00401511","a","transparente","N");
INSERT INTO portuguese_lemma VALUES ("a#01561343","a","transparente","N");
INSERT INTO portuguese_lemma VALUES ("v#00300986","v","transcorrer","N");
INSERT INTO portuguese_lemma VALUES ("a#00432626","a","translúcido","N");
INSERT INTO portuguese_lemma VALUES ("a#01136895","a","translúcido","N");
INSERT INTO portuguese_lemma VALUES ("n#00432689","n","Passatempos","N");
INSERT INTO portuguese_lemma VALUES ("n#00432689","n","Passa-tempo","N");
INSERT INTO portuguese_lemma VALUES ("r#00432997","r","com_competência","Y");
INSERT INTO portuguese_lemma VALUES ("r#00432997","r","de_forma_proficiente","Y");
INSERT INTO portuguese_lemma VALUES ("r#00432997","r","com_habilidade","Y");
INSERT INTO portuguese_lemma VALUES ("v#00301772","v","tombar","N");
INSERT INTO portuguese_lemma VALUES ("r#00433247","r","de_forma_proibitiva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00433247","r","proibitivamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00433802","n","ginástica","N");
INSERT INTO portuguese_lemma VALUES ("n#00433802","n","Ginástica","N");
INSERT INTO portuguese_lemma VALUES ("n#00433802","n","Ginastica","N");
INSERT INTO portuguese_lemma VALUES ("v#00302438","v","definhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00433972","a","geado","N");
INSERT INTO portuguese_lemma VALUES ("n#00434075","n","acrobacia","N");
INSERT INTO portuguese_lemma VALUES ("n#00434075","n","acobatismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00434097","a","glauco","N");
INSERT INTO portuguese_lemma VALUES ("a#00403517","a","lácteo","N");
INSERT INTO portuguese_lemma VALUES ("n#00276193","n","estrelinha","N");
INSERT INTO portuguese_lemma VALUES ("n#00276193","n","estrela","N");
INSERT INTO portuguese_lemma VALUES ("n#09239740","n","estrela","N");
INSERT INTO portuguese_lemma VALUES ("n#06762045","n","estrela","N");
INSERT INTO portuguese_lemma VALUES ("n#09444783","n","estrela","N");
INSERT INTO portuguese_lemma VALUES ("r#00434921","r","psicologicamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00435142","r","psicologicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00303689","v","desenovelar","N");
INSERT INTO portuguese_lemma VALUES ("v#00303689","v","desfraldar","N");
INSERT INTO portuguese_lemma VALUES ("a#00404496","a","perplexo","N");
INSERT INTO portuguese_lemma VALUES ("a#00434112","a","perplexo","N");
INSERT INTO portuguese_lemma VALUES ("a#01610144","a","perplexo","N");
INSERT INTO portuguese_lemma VALUES ("a#01624304","a","perplexo","N");
INSERT INTO portuguese_lemma VALUES ("a#01701024","a","perplexo","N");
INSERT INTO portuguese_lemma VALUES ("a#01766133","a","perplexo","N");
INSERT INTO portuguese_lemma VALUES ("r#00436088","r","propositalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00436088","r","propositadamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00436676","r","qualitativamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00436848","r","trimestralmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00437125","v","diversificar","N");
INSERT INTO portuguese_lemma VALUES ("r#00437381","r","estranhamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00437539","a","clemente","N");
INSERT INTO portuguese_lemma VALUES ("a#00438166","a","clemente","N");
INSERT INTO portuguese_lemma VALUES ("v#00305536","v","especializar","N");
INSERT INTO portuguese_lemma VALUES ("r#00437796","r","questionavelmente","N");
INSERT INTO portuguese_lemma VALUES ("v#00305843","v","agilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00305843","v","acelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00306811","v","acelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00320978","v","acelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#01405887","v","acelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#01737793","v","acelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00305843","v","apressar","N");
INSERT INTO portuguese_lemma VALUES ("v#00306811","v","apressar","N");
INSERT INTO portuguese_lemma VALUES ("v#00320830","v","apressar","N");
INSERT INTO portuguese_lemma VALUES ("v#00320978","v","apressar","N");
INSERT INTO portuguese_lemma VALUES ("v#01405887","v","apressar","N");
INSERT INTO portuguese_lemma VALUES ("v#01408362","v","apressar","N");
INSERT INTO portuguese_lemma VALUES ("v#01737793","v","apressar","N");
INSERT INTO portuguese_lemma VALUES ("v#00438495","v","desacelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00439958","v","desacelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00307579","v","desacelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00307731","v","desacelerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00306237","v","atrasar","N");
INSERT INTO portuguese_lemma VALUES ("v#00307430","v","atrasar","N");
INSERT INTO portuguese_lemma VALUES ("v#00321115","v","atrasar","N");
INSERT INTO portuguese_lemma VALUES ("v#00321868","v","atrasar","N");
INSERT INTO portuguese_lemma VALUES ("n#00439043","n","desdobramento_de_ações","Y");
INSERT INTO portuguese_lemma VALUES ("v#00306811","v","adiantar","N");
INSERT INTO portuguese_lemma VALUES ("a#00408403","a","sonso","N");
INSERT INTO portuguese_lemma VALUES ("a#00408403","a","idiota","N");
INSERT INTO portuguese_lemma VALUES ("a#00409196","a","idiota","N");
INSERT INTO portuguese_lemma VALUES ("a#01283588","a","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#07216129","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#10039391","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#10100761","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#07308238","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#10197525","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#10358794","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#10496393","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#10599354","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#10667187","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("n#07654252","n","idiota","N");
INSERT INTO portuguese_lemma VALUES ("a#00408403","a","imbecil","N");
INSERT INTO portuguese_lemma VALUES ("a#00409196","a","imbecil","N");
INSERT INTO portuguese_lemma VALUES ("n#10039391","n","imbecil","N");
INSERT INTO portuguese_lemma VALUES ("n#10100761","n","imbecil","N");
INSERT INTO portuguese_lemma VALUES ("n#10197525","n","imbecil","N");
INSERT INTO portuguese_lemma VALUES ("n#10667187","n","imbecil","N");
INSERT INTO portuguese_lemma VALUES ("a#00408403","a","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("a#00408666","a","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("a#00409196","a","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("a#01336587","a","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#10039391","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#10100761","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#07308238","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#10197525","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#10358794","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#10496393","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#10599354","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#10667187","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#07654252","n","estúpido","N");
INSERT INTO portuguese_lemma VALUES ("n#00439826","n","atletismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00886582","n","atletismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00440382","n","salto_em_comprimento","Y");
INSERT INTO portuguese_lemma VALUES ("n#00440382","n","Salto_em_Comprimento","Y");
INSERT INTO portuguese_lemma VALUES ("n#00440509","n","salto_em_altura","Y");
INSERT INTO portuguese_lemma VALUES ("a#00409196","a","fátuo","N");
INSERT INTO portuguese_lemma VALUES ("r#00440745","r","remotamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00440845","r","remotamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00440747","n","esqui","N");
INSERT INTO portuguese_lemma VALUES ("n#04228054","n","esqui","N");
INSERT INTO portuguese_lemma VALUES ("n#00440747","n","Esqui","N");
INSERT INTO portuguese_lemma VALUES ("v#00307731","v","retardar","N");
INSERT INTO portuguese_lemma VALUES ("n#00689955","n","retardar","N");
INSERT INTO portuguese_lemma VALUES ("n#00441073","n","Salto_de_esqui","Y");
INSERT INTO portuguese_lemma VALUES ("n#00441073","n","salto_de_esqui","Y");
INSERT INTO portuguese_lemma VALUES ("a#00441927","a","dextrogiro","N");
INSERT INTO portuguese_lemma VALUES ("n#00442115","n","nadada","N");
INSERT INTO portuguese_lemma VALUES ("n#00442115","n","Natação","N");
INSERT INTO portuguese_lemma VALUES ("n#00442115","n","natação","N");
INSERT INTO portuguese_lemma VALUES ("a#00442255","a","levogiro","N");
INSERT INTO portuguese_lemma VALUES ("v#00442267","v","gaseificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00410709","a","longínquo","N");
INSERT INTO portuguese_lemma VALUES ("a#00411449","a","longínquo","N");
INSERT INTO portuguese_lemma VALUES ("a#00411646","a","longínquo","N");
INSERT INTO portuguese_lemma VALUES ("a#00419892","a","longínquo","N");
INSERT INTO portuguese_lemma VALUES ("a#00451155","a","longínquo","N");
INSERT INTO portuguese_lemma VALUES ("a#01377805","a","longínquo","N");
INSERT INTO portuguese_lemma VALUES ("n#00280090","n","banhe","N");
INSERT INTO portuguese_lemma VALUES ("r#00442774","r","por_atacado","Y");
INSERT INTO portuguese_lemma VALUES ("n#00442847","n","mergulho","N");
INSERT INTO portuguese_lemma VALUES ("v#00309228","v","coalhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00320040","v","coalhar","N");
INSERT INTO portuguese_lemma VALUES ("n#00442981","n","Salto_ornamental","Y");
INSERT INTO portuguese_lemma VALUES ("a#00411449","a","remoto","N");
INSERT INTO portuguese_lemma VALUES ("a#00415243","a","remoto","N");
INSERT INTO portuguese_lemma VALUES ("a#00541614","a","remoto","N");
INSERT INTO portuguese_lemma VALUES ("r#00443097","r","de_forma_retrospectiva","Y");
INSERT INTO portuguese_lemma VALUES ("r#00443097","r","retrospectivamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00309461","v","Induração","N");
INSERT INTO portuguese_lemma VALUES ("a#00443490","a","mais_distante","Y");
INSERT INTO portuguese_lemma VALUES ("v#00310006","v","liquefazer","N");
INSERT INTO portuguese_lemma VALUES ("a#00412848","a","vizinho","N");
INSERT INTO portuguese_lemma VALUES ("a#00533304","a","vizinho","N");
INSERT INTO portuguese_lemma VALUES ("n#06363890","n","vizinho","N");
INSERT INTO portuguese_lemma VALUES ("n#09368224","n","vizinho","N");
INSERT INTO portuguese_lemma VALUES ("n#06949059","n","vizinho","N");
INSERT INTO portuguese_lemma VALUES ("n#07429701","n","vizinho","N");
INSERT INTO portuguese_lemma VALUES ("n#00444846","n","mergulho_autônomo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00444984","a","contíguo","N");
INSERT INTO portuguese_lemma VALUES ("a#00416294","a","contíguo","N");
INSERT INTO portuguese_lemma VALUES ("a#00418121","a","contíguo","N");
INSERT INTO portuguese_lemma VALUES ("a#00533304","a","contíguo","N");
INSERT INTO portuguese_lemma VALUES ("a#00566961","a","contíguo","N");
INSERT INTO portuguese_lemma VALUES ("n#00445055","n","Surfe","N");
INSERT INTO portuguese_lemma VALUES ("a#00413658","a","próximoa","N");
INSERT INTO portuguese_lemma VALUES ("a#00413658","a","pertode","N");
INSERT INTO portuguese_lemma VALUES ("a#00413658","a","juntode","N");
INSERT INTO portuguese_lemma VALUES ("a#00413658","a","juntoa","N");
INSERT INTO portuguese_lemma VALUES ("v#00445169","v","solidificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00445467","v","solidificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00414282","a","acalorado","N");
INSERT INTO portuguese_lemma VALUES ("a#00414282","a","calmoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00414282","a","quente","N");
INSERT INTO portuguese_lemma VALUES ("a#01247240","a","quente","N");
INSERT INTO portuguese_lemma VALUES ("a#02056997","a","quente","N");
INSERT INTO portuguese_lemma VALUES ("n#00445351","n","remo","N");
INSERT INTO portuguese_lemma VALUES ("n#03837422","n","remo","N");
INSERT INTO portuguese_lemma VALUES ("n#03873416","n","remo","N");
INSERT INTO portuguese_lemma VALUES ("n#00445802","n","pugilismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00445802","n","boxe","N");
INSERT INTO portuguese_lemma VALUES ("n#00283141","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#00609840","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#00610417","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#00619159","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#00758807","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#00759769","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#01236296","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#05554348","n","combate","N");
INSERT INTO portuguese_lemma VALUES ("n#00283141","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00283913","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00622068","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00622266","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00505798","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00789391","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00610417","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00614914","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00619159","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00758807","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00759560","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#00759769","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("n#05554348","n","luta","N");
INSERT INTO portuguese_lemma VALUES ("r#00446735","r","de_forma_esquemática","Y");
INSERT INTO portuguese_lemma VALUES ("r#00446735","r","esquematicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00311901","v","reagir","N");
INSERT INTO portuguese_lemma VALUES ("v#00485595","v","reagir","N");
INSERT INTO portuguese_lemma VALUES ("n#00446980","n","arco-e-flecha","N");
INSERT INTO portuguese_lemma VALUES ("n#00446980","n","tiro_com_arco","Y");
INSERT INTO portuguese_lemma VALUES ("v#00312214","v","dissolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00312524","v","dissolver","N");
INSERT INTO portuguese_lemma VALUES ("a#00416294","a","apenso","N");
INSERT INTO portuguese_lemma VALUES ("a#00416294","a","adjacente","N");
INSERT INTO portuguese_lemma VALUES ("a#00533304","a","adjacente","N");
INSERT INTO portuguese_lemma VALUES ("n#00283913","n","Grappling","N");
INSERT INTO portuguese_lemma VALUES ("a#00447753","a","circundante","N");
INSERT INTO portuguese_lemma VALUES ("n#00447957","n","luta_greco-romana","Y");
INSERT INTO portuguese_lemma VALUES ("n#00448126","n","Wrestling_profissional","Y");
INSERT INTO portuguese_lemma VALUES ("n#00448126","n","wrestling","N");
INSERT INTO portuguese_lemma VALUES ("n#00448232","n","sumô","N");
INSERT INTO portuguese_lemma VALUES ("r#00448282","r","seletivamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00417100","a","iminente","N");
INSERT INTO portuguese_lemma VALUES ("a#01668941","a","iminente","N");
INSERT INTO portuguese_lemma VALUES ("v#00312840","v","invalidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00800460","v","invalidar","N");
INSERT INTO portuguese_lemma VALUES ("v#01688749","v","invalidar","N");
INSERT INTO portuguese_lemma VALUES ("n#00448640","n","patinação_no_gelo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00448640","n","Patinagem_no_gelo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00313029","v","esvaziar","N");
INSERT INTO portuguese_lemma VALUES ("v#00313984","v","esvaziar","N");
INSERT INTO portuguese_lemma VALUES ("n#00448748","n","Patinação_Artística_no_gelo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00448748","n","Patinação_artística_no_gelo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00448748","n","patinação_artística","Y");
INSERT INTO portuguese_lemma VALUES ("n#00448958","n","Patinação_sobre_rodas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00313342","v","escoar","N");
INSERT INTO portuguese_lemma VALUES ("v#01417934","v","escoar","N");
INSERT INTO portuguese_lemma VALUES ("n#00449054","n","Skate","N");
INSERT INTO portuguese_lemma VALUES ("a#00418121","a","imediato","N");
INSERT INTO portuguese_lemma VALUES ("a#00733113","a","imediato","N");
INSERT INTO portuguese_lemma VALUES ("a#01523796","a","imediato","N");
INSERT INTO portuguese_lemma VALUES ("a#01863475","a","imediato","N");
INSERT INTO portuguese_lemma VALUES ("n#00449168","n","Patinação_de_velocidade","Y");
INSERT INTO portuguese_lemma VALUES ("n#00449168","n","Patinação_de_Velocidade","Y");
INSERT INTO portuguese_lemma VALUES ("n#00449295","n","Esportes_de_corrida","Y");
INSERT INTO portuguese_lemma VALUES ("v#00449295","v","evacuar","N");
INSERT INTO portuguese_lemma VALUES ("v#00449567","v","evacuar","N");
INSERT INTO portuguese_lemma VALUES ("v#02014024","v","evacuar","N");
INSERT INTO portuguese_lemma VALUES ("v#01421290","v","evacuar","N");
INSERT INTO portuguese_lemma VALUES ("a#00449332","a","envolvente","N");
INSERT INTO portuguese_lemma VALUES ("n#00449517","n","Automobilismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00449517","n","automobilismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00313984","v","evaziar","N");
INSERT INTO portuguese_lemma VALUES ("n#00450070","n","Turfe","N");
INSERT INTO portuguese_lemma VALUES ("n#00450335","n","equitação","N");
INSERT INTO portuguese_lemma VALUES ("n#05638374","n","equitação","N");
INSERT INTO portuguese_lemma VALUES ("v#00451279","v","preencher","N");
INSERT INTO portuguese_lemma VALUES ("v#00690164","v","preencher","N");
INSERT INTO portuguese_lemma VALUES ("n#00451370","n","Ciclismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00451370","n","ciclismo","N");
INSERT INTO portuguese_lemma VALUES ("v#00315029","v","povoar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00315126","v","drenar","N");
INSERT INTO portuguese_lemma VALUES ("v#01158022","v","drenar","N");
INSERT INTO portuguese_lemma VALUES ("n#00451866","n","Desportos_sangrentos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00451866","n","Desporto_sangrento","Y");
INSERT INTO portuguese_lemma VALUES ("n#00452034","n","tourada","N");
INSERT INTO portuguese_lemma VALUES ("n#02917163","n","tourada","N");
INSERT INTO portuguese_lemma VALUES ("n#00452034","n","Tauromaquia","N");
INSERT INTO portuguese_lemma VALUES ("n#00287066","n","caça","N");
INSERT INTO portuguese_lemma VALUES ("n#00410109","n","caça","N");
INSERT INTO portuguese_lemma VALUES ("n#01661356","n","caça","N");
INSERT INTO portuguese_lemma VALUES ("n#02676348","n","caça","N");
INSERT INTO portuguese_lemma VALUES ("v#00315864","v","completar","N");
INSERT INTO portuguese_lemma VALUES ("v#00318530","v","completar","N");
INSERT INTO portuguese_lemma VALUES ("v#00455919","v","completar","N");
INSERT INTO portuguese_lemma VALUES ("n#00452734","n","batida_policial","Y");
INSERT INTO portuguese_lemma VALUES ("a#00421977","a","íntimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00477284","a","íntimo","N");
INSERT INTO portuguese_lemma VALUES ("a#00421977","a","familiar","N");
INSERT INTO portuguese_lemma VALUES ("a#00994581","a","familiar","N");
INSERT INTO portuguese_lemma VALUES ("a#02712817","a","familiar","N");
INSERT INTO portuguese_lemma VALUES ("n#09545171","n","familiar","N");
INSERT INTO portuguese_lemma VALUES ("n#00453478","n","caça_à_raposa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00453731","n","agricultura","N");
INSERT INTO portuguese_lemma VALUES ("n#00588753","n","agricultura","N");
INSERT INTO portuguese_lemma VALUES ("n#00918176","n","agricultura","N");
INSERT INTO portuguese_lemma VALUES ("n#00715321","n","agricultura","N");
INSERT INTO portuguese_lemma VALUES ("n#00288131","n","Pesca","N");
INSERT INTO portuguese_lemma VALUES ("n#00288131","n","pesca","N");
INSERT INTO portuguese_lemma VALUES ("n#00288265","n","pesca","N");
INSERT INTO portuguese_lemma VALUES ("n#00288131","n","pescas","N");
INSERT INTO portuguese_lemma VALUES ("n#00288265","n","pescas","N");
INSERT INTO portuguese_lemma VALUES ("n#00288131","n","pesca_à_linha","Y");
INSERT INTO portuguese_lemma VALUES ("n#00454237","n","pesca_à_linha","Y");
INSERT INTO portuguese_lemma VALUES ("n#00288600","n","fundição","N");
INSERT INTO portuguese_lemma VALUES ("n#00909899","n","fundição","N");
INSERT INTO portuguese_lemma VALUES ("n#03387653","n","fundição","N");
INSERT INTO portuguese_lemma VALUES ("v#00454868","v","puxar_descarga","Y");
INSERT INTO portuguese_lemma VALUES ("n#00455348","n","continuação","N");
INSERT INTO portuguese_lemma VALUES ("n#00657384","n","continuação","N");
INSERT INTO portuguese_lemma VALUES ("n#04823659","n","continuação","N");
INSERT INTO portuguese_lemma VALUES ("n#05441038","n","continuação","N");
INSERT INTO portuguese_lemma VALUES ("v#00318530","v","inteirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00404522","v","inteirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00318860","v","imbuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00456357","v","saturar","N");
INSERT INTO portuguese_lemma VALUES ("n#00456899","n","Jogo_Amistoso","Y");
INSERT INTO portuguese_lemma VALUES ("n#00456899","n","Jogo_amistoso","Y");
INSERT INTO portuguese_lemma VALUES ("v#00457100","v","homogenizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00290820","n","vez","N");
INSERT INTO portuguese_lemma VALUES ("n#05449233","n","vez","N");
INSERT INTO portuguese_lemma VALUES ("n#10391300","n","vez","N");
INSERT INTO portuguese_lemma VALUES ("n#10984524","n","vez","N");
INSERT INTO portuguese_lemma VALUES ("n#00291138","n","ataque","N");
INSERT INTO portuguese_lemma VALUES ("n#00494444","n","ataque","N");
INSERT INTO portuguese_lemma VALUES ("n#00625655","n","ataque","N");
INSERT INTO portuguese_lemma VALUES ("n#00629246","n","ataque","N");
INSERT INTO portuguese_lemma VALUES ("n#00457890","n","Aberturas_de_xadrez","Y");
INSERT INTO portuguese_lemma VALUES ("a#00427123","a","nu","N");
INSERT INTO portuguese_lemma VALUES ("a#00427123","a","pelado","N");
INSERT INTO portuguese_lemma VALUES ("a#02354234","a","pelado","N");
INSERT INTO portuguese_lemma VALUES ("a#00427123","a","despido","N");
INSERT INTO portuguese_lemma VALUES ("a#00427123","a","descoberto","N");
INSERT INTO portuguese_lemma VALUES ("v#00320199","v","coagular","N");
INSERT INTO portuguese_lemma VALUES ("a#00458664","a","em_cabelo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00458890","n","vídeo_game","Y");
INSERT INTO portuguese_lemma VALUES ("n#00458890","n","jogo_de_vídeo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00458890","n","videojogo","N");
INSERT INTO portuguese_lemma VALUES ("n#00458890","n","videogame","N");
INSERT INTO portuguese_lemma VALUES ("a#00458940","a","sem_fundo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00690892","a","sem_fundo","Y");
INSERT INTO portuguese_lemma VALUES ("a#01415917","a","sem_fundo","Y");
INSERT INTO portuguese_lemma VALUES ("a#02443005","a","sem_fundo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00459013","n","realidade_virtual","Y");
INSERT INTO portuguese_lemma VALUES ("n#00459013","n","realidade_virtual","Y");
INSERT INTO portuguese_lemma VALUES ("n#00459284","n","Jogos_de_pinball","Y");
INSERT INTO portuguese_lemma VALUES ("n#00459284","n","pinball","N");
INSERT INTO portuguese_lemma VALUES ("v#00320830","v","instar","N");
INSERT INTO portuguese_lemma VALUES ("n#00459465","n","pachinko","N");
INSERT INTO portuguese_lemma VALUES ("r#00459521","r","de_forma_obscena","Y");
INSERT INTO portuguese_lemma VALUES ("n#00460706","n","peddy-paper","N");
INSERT INTO portuguese_lemma VALUES ("a#00429560","a","nítido","N");
INSERT INTO portuguese_lemma VALUES ("n#00460951","n","Rodada_dupla","Y");
INSERT INTO portuguese_lemma VALUES ("n#00460951","n","dobradinha","N");
INSERT INTO portuguese_lemma VALUES ("v#00322396","v","calar","N");
INSERT INTO portuguese_lemma VALUES ("v#00461493","v","silenciar","N");
INSERT INTO portuguese_lemma VALUES ("v#01204371","v","silenciar","N");
INSERT INTO portuguese_lemma VALUES ("a#00430514","a","nevoeirento","N");
INSERT INTO portuguese_lemma VALUES ("a#02549569","a","nevoeirento","N");
INSERT INTO portuguese_lemma VALUES ("n#00461611","n","Curling","N");
INSERT INTO portuguese_lemma VALUES ("r#00461617","r","grandemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00461617","r","dolorosamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00509533","r","dolorosamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00461782","n","Boliche","N");
INSERT INTO portuguese_lemma VALUES ("r#00462016","r","para_o_sudeste","Y");
INSERT INTO portuguese_lemma VALUES ("n#00462383","n","bolão","N");
INSERT INTO portuguese_lemma VALUES ("n#09608092","n","bolão","N");
INSERT INTO portuguese_lemma VALUES ("n#00462804","n","Lawn_Bowls","Y");
INSERT INTO portuguese_lemma VALUES ("n#00462804","n","lawn_bowls","Y");
INSERT INTO portuguese_lemma VALUES ("a#00431439","a","litorâneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00431439","a","costeiro","N");
INSERT INTO portuguese_lemma VALUES ("n#00463246","n","esporte","N");
INSERT INTO portuguese_lemma VALUES ("n#00274505","n","esporte","N");
INSERT INTO portuguese_lemma VALUES ("a#00431947","a","marítimo","N");
INSERT INTO portuguese_lemma VALUES ("a#02671223","a","marítimo","N");
INSERT INTO portuguese_lemma VALUES ("v#00463469","v","achatar","N");
INSERT INTO portuguese_lemma VALUES ("v#00323924","v","achatar","N");
INSERT INTO portuguese_lemma VALUES ("n#00463543","n","hóquei_no_gelo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00463543","n","Hóquei","N");
INSERT INTO portuguese_lemma VALUES ("n#00463543","n","hóquei","N");
INSERT INTO portuguese_lemma VALUES ("n#00467995","n","hóquei","N");
INSERT INTO portuguese_lemma VALUES ("n#00464037","n","guarda-redes","N");
INSERT INTO portuguese_lemma VALUES ("n#07293634","n","guarda-redes","N");
INSERT INTO portuguese_lemma VALUES ("n#00464037","n","keeper","N");
INSERT INTO portuguese_lemma VALUES ("n#00464277","n","Espirobol","N");
INSERT INTO portuguese_lemma VALUES ("v#00324261","v","alinhar","N");
INSERT INTO portuguese_lemma VALUES ("v#00781082","v","alinhar","N");
INSERT INTO portuguese_lemma VALUES ("n#00464478","n","pólo_aquático","Y");
INSERT INTO portuguese_lemma VALUES ("a#00433594","a","consequente","N");
INSERT INTO portuguese_lemma VALUES ("a#00433594","a","lógico","N");
INSERT INTO portuguese_lemma VALUES ("a#01373247","a","lógico","N");
INSERT INTO portuguese_lemma VALUES ("a#01857552","a","lógico","N");
INSERT INTO portuguese_lemma VALUES ("a#02379915","a","lógico","N");
INSERT INTO portuguese_lemma VALUES ("n#10269785","n","lógico","N");
INSERT INTO portuguese_lemma VALUES ("a#00464845","a","sem_improvisos","Y");
INSERT INTO portuguese_lemma VALUES ("a#00464845","a","sem_remendos","Y");
INSERT INTO portuguese_lemma VALUES ("a#00464845","a","sem_emenda","Y");
INSERT INTO portuguese_lemma VALUES ("n#00297363","n","golfe","N");
INSERT INTO portuguese_lemma VALUES ("v#00465145","v","realinhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00434112","a","confundido","N");
INSERT INTO portuguese_lemma VALUES ("a#00497363","a","confundido","N");
INSERT INTO portuguese_lemma VALUES ("v#00465762","v","deslocar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00325575","v","incorporada","N");
INSERT INTO portuguese_lemma VALUES ("v#00325575","v","incorporar","N");
INSERT INTO portuguese_lemma VALUES ("v#01060691","v","incorporar","N");
INSERT INTO portuguese_lemma VALUES ("v#01840295","v","incorporar","N");
INSERT INTO portuguese_lemma VALUES ("v#00325575","v","integrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00326149","v","integrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00434288","v","integrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00466880","n","Cróquet","N");
INSERT INTO portuguese_lemma VALUES ("n#00466880","n","croquet","N");
INSERT INTO portuguese_lemma VALUES ("n#00467122","n","Paint_ball","Y");
INSERT INTO portuguese_lemma VALUES ("n#00467122","n","Paintball","N");
INSERT INTO portuguese_lemma VALUES ("v#00467346","v","reincorporar","N");
INSERT INTO portuguese_lemma VALUES ("r#00467686","r","à_volta","Y");
INSERT INTO portuguese_lemma VALUES ("r#00467810","r","à_volta","Y");
INSERT INTO portuguese_lemma VALUES ("r#00467686","r","em_redor","Y");
INSERT INTO portuguese_lemma VALUES ("r#00467810","r","em_redor","Y");
INSERT INTO portuguese_lemma VALUES ("v#00467717","v","padronizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00682436","v","padronizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00467995","n","hóquei_em_campo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00467995","n","Hóquei_em_Campo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00467995","n","Hoquei_em_campo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00467995","n","Hóquei_sobre_grama","Y");
INSERT INTO portuguese_lemma VALUES ("r#00468219","r","àquele","N");
INSERT INTO portuguese_lemma VALUES ("n#00299231","n","futebol","N");
INSERT INTO portuguese_lemma VALUES ("n#00304700","n","futebol","N");
INSERT INTO portuguese_lemma VALUES ("n#03378765","n","futebol","N");
INSERT INTO portuguese_lemma VALUES ("n#04254680","n","futebol","N");
INSERT INTO portuguese_lemma VALUES ("a#00468574","a","imanente","N");
INSERT INTO portuguese_lemma VALUES ("a#01221591","a","imanente","N");
INSERT INTO portuguese_lemma VALUES ("v#00468791","v","reorientar","N");
INSERT INTO portuguese_lemma VALUES ("v#00468791","v","orientar","N");
INSERT INTO portuguese_lemma VALUES ("v#01853220","v","orientar","N");
INSERT INTO portuguese_lemma VALUES ("r#00469068","r","estrategicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00469382","v","Desgaste","N");
INSERT INTO portuguese_lemma VALUES ("v#00469382","v","esmerilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00469382","v","desgastar","N");
INSERT INTO portuguese_lemma VALUES ("v#01254324","v","desgastar","N");
INSERT INTO portuguese_lemma VALUES ("n#00469651","n","futebol_americano","Y");
INSERT INTO portuguese_lemma VALUES ("n#00469651","n","futebol_americano","Y");
INSERT INTO portuguese_lemma VALUES ("v#00469904","v","neutralizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00328042","v","neutralizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00905566","v","neutralizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02543874","v","neutralizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00328042","v","anular","N");
INSERT INTO portuguese_lemma VALUES ("v#00543473","v","anular","N");
INSERT INTO portuguese_lemma VALUES ("v#00688807","v","anular","N");
INSERT INTO portuguese_lemma VALUES ("v#02477334","v","anular","N");
INSERT INTO portuguese_lemma VALUES ("v#01688749","v","anular","N");
INSERT INTO portuguese_lemma VALUES ("v#02478584","v","anular","N");
INSERT INTO portuguese_lemma VALUES ("n#05567489","n","anular","N");
INSERT INTO portuguese_lemma VALUES ("v#00470386","v","comercializar","N");
INSERT INTO portuguese_lemma VALUES ("v#01164725","v","comercializar","N");
INSERT INTO portuguese_lemma VALUES ("v#00470701","v","aniquilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00472230","v","aniquilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00470701","v","devastar","N");
INSERT INTO portuguese_lemma VALUES ("v#01257507","v","devastar","N");
INSERT INTO portuguese_lemma VALUES ("v#00470701","v","massacrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00479176","v","massacrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00470701","v","dizimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00471058","v","dizimar","N");
INSERT INTO portuguese_lemma VALUES ("n#00470830","n","Hurling","N");
INSERT INTO portuguese_lemma VALUES ("n#00470966","n","râguebi","N");
INSERT INTO portuguese_lemma VALUES ("n#00470966","n","rúgbi","N");
INSERT INTO portuguese_lemma VALUES ("a#00439077","a","inédito","N");
INSERT INTO portuguese_lemma VALUES ("v#00328583","v","extinguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00328742","v","extinguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00333158","v","extinguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00333569","v","extinguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01327582","v","extinguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01080585","v","extinguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01886493","v","extinguir","N");
INSERT INTO portuguese_lemma VALUES ("n#00471613","n","basebol","N");
INSERT INTO portuguese_lemma VALUES ("n#02799071","n","basebol","N");
INSERT INTO portuguese_lemma VALUES ("n#00471613","n","beisebol","N");
INSERT INTO portuguese_lemma VALUES ("n#02799071","n","beisebol","N");
INSERT INTO portuguese_lemma VALUES ("v#00328742","v","eliminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00685419","v","eliminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01327582","v","eliminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01066739","v","eliminar","N");
INSERT INTO portuguese_lemma VALUES ("v#01114673","v","eliminar","N");
INSERT INTO portuguese_lemma VALUES ("a#00472057","a","que_se_pode_relatar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00472057","a","informável","N");
INSERT INTO portuguese_lemma VALUES ("a#00472057","a","que_se_pode_informar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00472057","a","relatável","N");
INSERT INTO portuguese_lemma VALUES ("a#00472336","a","combinatório","N");
INSERT INTO portuguese_lemma VALUES ("a#00472534","a","combinatório","N");
INSERT INTO portuguese_lemma VALUES ("a#00472694","a","combinatório","N");
INSERT INTO portuguese_lemma VALUES ("a#01331244","a","combinatório","N");
INSERT INTO portuguese_lemma VALUES ("v#00329310","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01254477","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00856275","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00856483","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00856759","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00857046","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01258091","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01260428","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01279833","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00887606","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01319562","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01320816","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00901990","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01322675","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#00999598","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01549420","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01069335","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01555437","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01559055","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01075495","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01075648","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01610834","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("v#01198965","v","cortar","N");
INSERT INTO portuguese_lemma VALUES ("a#00472694","a","combinacional","N");
INSERT INTO portuguese_lemma VALUES ("a#00472694","a","combinável","N");
INSERT INTO portuguese_lemma VALUES ("a#00473243","a","inflamável","N");
INSERT INTO portuguese_lemma VALUES ("a#00473658","a","inflamável","N");
INSERT INTO portuguese_lemma VALUES ("a#00473869","a","incendiário","N");
INSERT INTO portuguese_lemma VALUES ("a#02748097","a","incendiário","N");
INSERT INTO portuguese_lemma VALUES ("n#09810707","n","incendiário","N");
INSERT INTO portuguese_lemma VALUES ("v#00330153","v","polir","N");
INSERT INTO portuguese_lemma VALUES ("v#01245637","v","polir","N");
INSERT INTO portuguese_lemma VALUES ("v#01246095","v","polir","N");
INSERT INTO portuguese_lemma VALUES ("v#01682582","v","polir","N");
INSERT INTO portuguese_lemma VALUES ("v#00330153","v","lustrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01245637","v","lustrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01682582","v","lustrar","N");
INSERT INTO portuguese_lemma VALUES ("a#00474440","a","à_prova_de_fogo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00442295","a","explosivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01094524","a","explosivo","N");
INSERT INTO portuguese_lemma VALUES ("n#03304730","n","explosivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00474881","n","Jogo_perfeito","Y");
INSERT INTO portuguese_lemma VALUES ("v#00330961","v","precipitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01129440","v","precipitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01883959","v","precipitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00330961","v","precipitação","N");
INSERT INTO portuguese_lemma VALUES ("n#00362788","n","precipitação","N");
INSERT INTO portuguese_lemma VALUES ("n#07825204","n","precipitação","N");
INSERT INTO portuguese_lemma VALUES ("n#09673859","n","precipitação","N");
INSERT INTO portuguese_lemma VALUES ("v#00475183","v","apurar","N");
INSERT INTO portuguese_lemma VALUES ("v#02454835","v","apurar","N");
INSERT INTO portuguese_lemma VALUES ("a#00443166","a","ardente","N");
INSERT INTO portuguese_lemma VALUES ("a#00843026","a","ardente","N");
INSERT INTO portuguese_lemma VALUES ("a#01662898","a","ardente","N");
INSERT INTO portuguese_lemma VALUES ("v#00475647","v","depurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00475647","v","purgar","N");
INSERT INTO portuguese_lemma VALUES ("v#00905283","v","purgar","N");
INSERT INTO portuguese_lemma VALUES ("v#01054427","v","purgar","N");
INSERT INTO portuguese_lemma VALUES ("n#00475787","n","Softbol","N");
INSERT INTO portuguese_lemma VALUES ("n#00475787","n","softbol","N");
INSERT INTO portuguese_lemma VALUES ("a#00443968","a","amplo","N");
INSERT INTO portuguese_lemma VALUES ("a#00444189","a","amplo","N");
INSERT INTO portuguese_lemma VALUES ("a#00492304","a","amplo","N");
INSERT INTO portuguese_lemma VALUES ("a#00494005","a","amplo","N");
INSERT INTO portuguese_lemma VALUES ("a#01332909","a","amplo","N");
INSERT INTO portuguese_lemma VALUES ("a#01333157","a","amplo","N");
INSERT INTO portuguese_lemma VALUES ("a#02436517","a","amplo","N");
INSERT INTO portuguese_lemma VALUES ("a#00444189","a","vasto","N");
INSERT INTO portuguese_lemma VALUES ("a#01331722","a","vasto","N");
INSERT INTO portuguese_lemma VALUES ("a#00444189","a","espaçoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00476389","n","Criquete","N");
INSERT INTO portuguese_lemma VALUES ("n#00476389","n","Críquete","N");
INSERT INTO portuguese_lemma VALUES ("n#00476389","n","críquete","N");
INSERT INTO portuguese_lemma VALUES ("a#00444513","a","estreito","N");
INSERT INTO portuguese_lemma VALUES ("a#01358755","a","estreito","N");
INSERT INTO portuguese_lemma VALUES ("a#02439276","a","estreito","N");
INSERT INTO portuguese_lemma VALUES ("a#02439903","a","estreito","N");
INSERT INTO portuguese_lemma VALUES ("n#09446115","n","estreito","N");
INSERT INTO portuguese_lemma VALUES ("a#00444513","a","apertado","N");
INSERT INTO portuguese_lemma VALUES ("a#02526441","a","apertado","N");
INSERT INTO portuguese_lemma VALUES ("v#00476744","v","distorcer","N");
INSERT INTO portuguese_lemma VALUES ("v#00566613","v","distorcer","N");
INSERT INTO portuguese_lemma VALUES ("r#00476807","r","tradicionalmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00476807","r","de_forma_tradicional","Y");
INSERT INTO portuguese_lemma VALUES ("a#00444669","a","confortável","N");
INSERT INTO portuguese_lemma VALUES ("a#00477284","a","confortável","N");
INSERT INTO portuguese_lemma VALUES ("a#02225027","a","confortável","N");
INSERT INTO portuguese_lemma VALUES ("a#00477284","a","acolhedor","N");
INSERT INTO portuguese_lemma VALUES ("n#00477392","n","lacrosse","N");
INSERT INTO portuguese_lemma VALUES ("n#00304385","n","Polo","N");
INSERT INTO portuguese_lemma VALUES ("n#00304385","n","pólo","N");
INSERT INTO portuguese_lemma VALUES ("n#06352396","n","pólo","N");
INSERT INTO portuguese_lemma VALUES ("n#00304385","n","polo","N");
INSERT INTO portuguese_lemma VALUES ("n#03154406","n","polo","N");
INSERT INTO portuguese_lemma VALUES ("a#00445726","a","incómodo","N");
INSERT INTO portuguese_lemma VALUES ("a#00445726","a","pouco_à_vontade","Y");
INSERT INTO portuguese_lemma VALUES ("a#00445726","a","incômodo","N");
INSERT INTO portuguese_lemma VALUES ("n#04490800","n","incômodo","N");
INSERT INTO portuguese_lemma VALUES ("n#05830527","n","incômodo","N");
INSERT INTO portuguese_lemma VALUES ("n#04491038","n","incômodo","N");
INSERT INTO portuguese_lemma VALUES ("n#10337915","n","incômodo","N");
INSERT INTO portuguese_lemma VALUES ("a#00445726","a","desconfortável","N");
INSERT INTO portuguese_lemma VALUES ("a#00446252","a","desconfortável","N");
INSERT INTO portuguese_lemma VALUES ("n#00304700","n","Futebol","N");
INSERT INTO portuguese_lemma VALUES ("a#00446252","a","sem_conforto","Y");
INSERT INTO portuguese_lemma VALUES ("n#00478647","n","drible","N");
INSERT INTO portuguese_lemma VALUES ("n#07432559","n","drible","N");
INSERT INTO portuguese_lemma VALUES ("a#00446347","a","doloroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01139868","a","doloroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01648301","a","doloroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01732472","a","doloroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01733145","a","doloroso","N");
INSERT INTO portuguese_lemma VALUES ("a#00478872","a","azarado","N");
INSERT INTO portuguese_lemma VALUES ("a#01000655","a","azarado","N");
INSERT INTO portuguese_lemma VALUES ("a#01102092","a","azarado","N");
INSERT INTO portuguese_lemma VALUES ("v#00479176","v","genocídio","N");
INSERT INTO portuguese_lemma VALUES ("n#01245159","n","genocídio","N");
INSERT INTO portuguese_lemma VALUES ("r#00479275","r","amanhã","N");
INSERT INTO portuguese_lemma VALUES ("n#10877003","n","amanhã","N");
INSERT INTO portuguese_lemma VALUES ("n#15156311","n","amanhã","N");
INSERT INTO portuguese_lemma VALUES ("n#10964560","n","amanhã","N");
INSERT INTO portuguese_lemma VALUES ("n#00479440","n","Handebol","N");
INSERT INTO portuguese_lemma VALUES ("n#00479440","n","andebol","N");
INSERT INTO portuguese_lemma VALUES ("n#00479440","n","handebol","N");
INSERT INTO portuguese_lemma VALUES ("n#00479887","n","Squash","N");
INSERT INTO portuguese_lemma VALUES ("n#00479887","n","squash","N");
INSERT INTO portuguese_lemma VALUES ("v#00479932","v","automatizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00479932","v","tornar_automático","Y");
INSERT INTO portuguese_lemma VALUES ("r#00480195","r","de_forma_provisória","Y");
INSERT INTO portuguese_lemma VALUES ("r#00480195","r","transitoriamente","N");
INSERT INTO portuguese_lemma VALUES ("r#00480195","r","de_forma_transitória","Y");
INSERT INTO portuguese_lemma VALUES ("n#00480211","n","Voleibol","N");
INSERT INTO portuguese_lemma VALUES ("n#00480211","n","Vôleibol","N");
INSERT INTO portuguese_lemma VALUES ("n#00480211","n","voleibol","N");
INSERT INTO portuguese_lemma VALUES ("n#04540053","n","voleibol","N");
INSERT INTO portuguese_lemma VALUES ("n#00480508","n","Badmínton","N");
INSERT INTO portuguese_lemma VALUES ("n#00480508","n","Badminton","N");
INSERT INTO portuguese_lemma VALUES ("r#00480751","r","transparentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00480751","r","de_forma_transparente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00306597","n","Basquetebol","N");
INSERT INTO portuguese_lemma VALUES ("n#00306597","n","basquetebol","N");
INSERT INTO portuguese_lemma VALUES ("n#02802426","n","basquetebol","N");
INSERT INTO portuguese_lemma VALUES ("n#00306597","n","basquete","N");
INSERT INTO portuguese_lemma VALUES ("n#00306597","n","bola-ao-cesto","N");
INSERT INTO portuguese_lemma VALUES ("v#00481555","v","fazer_digestão","Y");
INSERT INTO portuguese_lemma VALUES ("a#00481592","a","comensurável","N");
INSERT INTO portuguese_lemma VALUES ("a#00449305","a","proporcional","N");
INSERT INTO portuguese_lemma VALUES ("a#00450284","a","proporcional","N");
INSERT INTO portuguese_lemma VALUES ("a#00482948","a","proporcional","N");
INSERT INTO portuguese_lemma VALUES ("a#00894029","a","proporcional","N");
INSERT INTO portuguese_lemma VALUES ("a#00449305","a","correspondente","N");
INSERT INTO portuguese_lemma VALUES ("a#01077975","a","correspondente","N");
INSERT INTO portuguese_lemma VALUES ("a#01903968","a","correspondente","N");
INSERT INTO portuguese_lemma VALUES ("a#01985976","a","correspondente","N");
INSERT INTO portuguese_lemma VALUES ("a#01994404","a","correspondente","N");
INSERT INTO portuguese_lemma VALUES ("a#01994903","a","correspondente","N");
INSERT INTO portuguese_lemma VALUES ("n#10414379","n","correspondente","N");
INSERT INTO portuguese_lemma VALUES ("v#00481739","v","codificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00993892","v","codificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00672235","v","codificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00482059","a","desproporcionado","N");
INSERT INTO portuguese_lemma VALUES ("a#00483048","a","desproporcionado","N");
INSERT INTO portuguese_lemma VALUES ("n#00482122","n","Netball","N");
INSERT INTO portuguese_lemma VALUES ("a#00482139","a","incomensurável","N");
INSERT INTO portuguese_lemma VALUES ("a#00505285","a","incomensurável","N");
INSERT INTO portuguese_lemma VALUES ("v#00482180","v","compatibilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482473","v","compatibilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00483181","v","compatibilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01707306","v","compatibilizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01841740","v","compatibilizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00482298","n","Tênis","N");
INSERT INTO portuguese_lemma VALUES ("n#00482298","n","ténis","N");
INSERT INTO portuguese_lemma VALUES ("n#00482298","n","tênis","N");
INSERT INTO portuguese_lemma VALUES ("v#00482473","v","reconciliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482473","v","conciliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00336188","v","conciliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00764902","v","conciliar","N");
INSERT INTO portuguese_lemma VALUES ("r#00482810","r","incontestavelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00450636","a","comercial","N");
INSERT INTO portuguese_lemma VALUES ("a#02235294","a","comercial","N");
INSERT INTO portuguese_lemma VALUES ("a#02870780","a","comercial","N");
INSERT INTO portuguese_lemma VALUES ("n#05411678","n","comercial","N");
INSERT INTO portuguese_lemma VALUES ("v#00483181","v","harmonizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01706889","v","harmonizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00451123","a","mercantil","N");
INSERT INTO portuguese_lemma VALUES ("a#02756682","a","mercantil","N");
INSERT INTO portuguese_lemma VALUES ("n#00483705","n","ténis_real","Y");
INSERT INTO portuguese_lemma VALUES ("r#00483963","r","insuportavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00484062","r","sem_o_conhecimento_de","Y");
INSERT INTO portuguese_lemma VALUES ("n#00484802","n","Cama_de_gato","Y");
INSERT INTO portuguese_lemma VALUES ("v#00337397","v","arrematar","N");
INSERT INTO portuguese_lemma VALUES ("v#00337397","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01152396","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#00822999","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01126836","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#02022162","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01582491","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01511279","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01513874","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01515833","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#02238770","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01532512","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#02248299","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#02288295","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#02359340","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01719999","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01721088","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01722366","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01722899","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("v#01723410","v","atingir","N");
INSERT INTO portuguese_lemma VALUES ("n#00484910","n","esconde-esconde","N");
INSERT INTO portuguese_lemma VALUES ("a#00485044","a","residencial","N");
INSERT INTO portuguese_lemma VALUES ("a#03109795","a","residencial","N");
INSERT INTO portuguese_lemma VALUES ("a#00485044","a","residêncial","N");
INSERT INTO portuguese_lemma VALUES ("n#00485081","n","amarelinha","N");
INSERT INTO portuguese_lemma VALUES ("n#00485081","n","Amarelinha","N");
INSERT INTO portuguese_lemma VALUES ("a#00485431","a","comissionado","N");
INSERT INTO portuguese_lemma VALUES ("a#00453486","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#00456499","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#00460273","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#00970610","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#00994826","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#01536434","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#01672607","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#02069607","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("a#02234991","a","comum","N");
INSERT INTO portuguese_lemma VALUES ("r#00485902","r","inegavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00485902","r","de_forma_inegável","Y");
INSERT INTO portuguese_lemma VALUES ("v#00338284","v","levar_a_cabo","Y");
INSERT INTO portuguese_lemma VALUES ("v#01126836","v","levar_a_cabo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00338284","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01111638","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01126836","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01644746","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01536195","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01722366","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01746300","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01747342","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01822979","v","realizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00338284","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01126836","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01133312","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01173875","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01174962","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01180692","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01755816","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01612822","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01617687","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01692292","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01692882","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01722366","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01746300","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#01760253","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("v#02599636","v","executar","N");
INSERT INTO portuguese_lemma VALUES ("n#00486130","n","carniça","N");
INSERT INTO portuguese_lemma VALUES ("n#01758895","n","carniça","N");
INSERT INTO portuguese_lemma VALUES ("n#00486130","n","eixo-badeixo","N");
INSERT INTO portuguese_lemma VALUES ("a#00454220","a","democrático","N");
INSERT INTO portuguese_lemma VALUES ("a#00680063","a","democrático","N");
INSERT INTO portuguese_lemma VALUES ("a#02555745","a","democrático","N");
INSERT INTO portuguese_lemma VALUES ("n#00486670","n","dança_das_cadeiras","Y");
INSERT INTO portuguese_lemma VALUES ("a#00454653","a","freqüente","N");
INSERT INTO portuguese_lemma VALUES ("a#01013801","a","freqüente","N");
INSERT INTO portuguese_lemma VALUES ("a#00454653","a","frequente","N");
INSERT INTO portuguese_lemma VALUES ("a#01013801","a","frequente","N");
INSERT INTO portuguese_lemma VALUES ("a#00487198","a","geral","N");
INSERT INTO portuguese_lemma VALUES ("a#00456499","a","geral","N");
INSERT INTO portuguese_lemma VALUES ("a#01050726","a","geral","N");
INSERT INTO portuguese_lemma VALUES ("n#00487228","n","guerra_de_travesseiros","Y");
INSERT INTO portuguese_lemma VALUES ("r#00487408","r","debaixo_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00487408","r","por_baixo_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00487408","r","sob","N");
INSERT INTO portuguese_lemma VALUES ("r#00487408","r","debaixo","N");
INSERT INTO portuguese_lemma VALUES ("r#00487623","r","debaixo","N");
INSERT INTO portuguese_lemma VALUES ("v#00487748","v","adulterar","N");
INSERT INTO portuguese_lemma VALUES ("r#00487759","r","inapropriadamente","N");
INSERT INTO portuguese_lemma VALUES ("n#00487874","n","pega-pega","N");
INSERT INTO portuguese_lemma VALUES ("n#07273136","n","pega-pega","N");
INSERT INTO portuguese_lemma VALUES ("n#00488051","n","jôgo_da_pulga","Y");
INSERT INTO portuguese_lemma VALUES ("r#00488143","r","gramaticalmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00455774","a","excepcional","N");
INSERT INTO portuguese_lemma VALUES ("a#01541117","a","excepcional","N");
INSERT INTO portuguese_lemma VALUES ("a#01616760","a","excepcional","N");
INSERT INTO portuguese_lemma VALUES ("a#02343762","a","excepcional","N");
INSERT INTO portuguese_lemma VALUES ("a#00455774","a","especial","N");
INSERT INTO portuguese_lemma VALUES ("a#01054295","a","especial","N");
INSERT INTO portuguese_lemma VALUES ("a#01618961","a","especial","N");
INSERT INTO portuguese_lemma VALUES ("a#01782133","a","especial","N");
INSERT INTO portuguese_lemma VALUES ("a#02167587","a","especial","N");
INSERT INTO portuguese_lemma VALUES ("n#00488225","n","jogo_de_cartas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00488225","n","jogo_de_cartas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00488301","v","aguar","N");
INSERT INTO portuguese_lemma VALUES ("a#00456130","a","pouco_frequente","Y");
INSERT INTO portuguese_lemma VALUES ("a#00456130","a","de_pouca_densidade","Y");
INSERT INTO portuguese_lemma VALUES ("a#00456130","a","pouco_freqüente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00340255","v","arejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00340460","v","arejar","N");
INSERT INTO portuguese_lemma VALUES ("v#02112345","v","arejar","N");
INSERT INTO portuguese_lemma VALUES ("v#02112891","v","arejar","N");
INSERT INTO portuguese_lemma VALUES ("a#00488857","a","inusual","N");
INSERT INTO portuguese_lemma VALUES ("a#00457241","a","inusual","N");
INSERT INTO portuguese_lemma VALUES ("a#00918492","a","inusual","N");
INSERT INTO portuguese_lemma VALUES ("a#00488857","a","insólito","N");
INSERT INTO portuguese_lemma VALUES ("a#00457241","a","insólito","N");
INSERT INTO portuguese_lemma VALUES ("a#00918492","a","insólito","N");
INSERT INTO portuguese_lemma VALUES ("a#00488857","a","inesperado","N");
INSERT INTO portuguese_lemma VALUES ("a#02259248","a","inesperado","N");
INSERT INTO portuguese_lemma VALUES ("a#00882895","a","inesperado","N");
INSERT INTO portuguese_lemma VALUES ("a#00456499","a","genérico","N");
INSERT INTO portuguese_lemma VALUES ("a#00456499","a","ordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#00649057","a","ordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#00970610","a","ordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#00994826","a","ordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#01536434","a","ordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#01672607","a","ordinário","N");
INSERT INTO portuguese_lemma VALUES ("a#00456499","a","costumeiro","N");
INSERT INTO portuguese_lemma VALUES ("a#01672607","a","costumeiro","N");
INSERT INTO portuguese_lemma VALUES ("v#00489299","v","glorificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00583913","v","glorificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00341011","v","justificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00606341","v","justificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00489768","a","inveterado","N");
INSERT INTO portuguese_lemma VALUES ("v#00341143","v","mensurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00436897","v","mensurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00341143","v","quantificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00492095","v","quantificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00489933","n","bacará","N");
INSERT INTO portuguese_lemma VALUES ("a#00457241","a","incomun","N");
INSERT INTO portuguese_lemma VALUES ("n#00490350","n","vinte-e-um","N");
INSERT INTO portuguese_lemma VALUES ("n#00490350","n","blackjack","N");
INSERT INTO portuguese_lemma VALUES ("a#00457601","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#00920300","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01354054","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01354496","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01354886","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01986829","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01989737","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01992026","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#02070342","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01995401","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("a#02036455","a","diferente","N");
INSERT INTO portuguese_lemma VALUES ("v#00341426","v","pesar","N");
INSERT INTO portuguese_lemma VALUES ("v#01845395","v","pesar","N");
INSERT INTO portuguese_lemma VALUES ("n#04492345","n","pesar","N");
INSERT INTO portuguese_lemma VALUES ("n#05599930","n","pesar","N");
INSERT INTO portuguese_lemma VALUES ("n#05601413","n","pesar","N");
INSERT INTO portuguese_lemma VALUES ("n#05601776","n","pesar","N");
INSERT INTO portuguese_lemma VALUES ("n#07535670","n","pesar","N");
INSERT INTO portuguese_lemma VALUES ("n#07536870","n","pesar","N");
INSERT INTO portuguese_lemma VALUES ("n#10077799","n","pesar","N");
INSERT INTO portuguese_lemma VALUES ("r#00490579","r","em_cima","Y");
INSERT INTO portuguese_lemma VALUES ("r#00490678","r","em_cima","Y");
INSERT INTO portuguese_lemma VALUES ("v#00490968","v","cronometrar","N");
INSERT INTO portuguese_lemma VALUES ("r#00491292","r","utilmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00491366","n","Bridge","N");
INSERT INTO portuguese_lemma VALUES ("n#00491366","n","bridge","N");
INSERT INTO portuguese_lemma VALUES ("v#00491456","v","regredir","N");
INSERT INTO portuguese_lemma VALUES ("a#00491749","a","Hidrofóbica","N");
INSERT INTO portuguese_lemma VALUES ("v#00342505","v","titular","N");
INSERT INTO portuguese_lemma VALUES ("a#01043374","a","titular","N");
INSERT INTO portuguese_lemma VALUES ("a#02816340","a","titular","N");
INSERT INTO portuguese_lemma VALUES ("n#07336733","n","titular","N");
INSERT INTO portuguese_lemma VALUES ("a#00491971","a","hidrossolúvel","N");
INSERT INTO portuguese_lemma VALUES ("a#02265815","a","hidrossolúvel","N");
INSERT INTO portuguese_lemma VALUES ("r#00492269","r","variavelmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00492414","r","veementemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00492414","r","de_forma_veemente","Y");
INSERT INTO portuguese_lemma VALUES ("a#00492477","a","lipófilo","N");
INSERT INTO portuguese_lemma VALUES ("a#02265496","a","lipófilo","N");
INSERT INTO portuguese_lemma VALUES ("n#00492497","n","Dominó_de_baralho","Y");
INSERT INTO portuguese_lemma VALUES ("v#00343123","v","sujar","N");
INSERT INTO portuguese_lemma VALUES ("v#01055474","v","sujar","N");
INSERT INTO portuguese_lemma VALUES ("v#00343123","v","poluir","N");
INSERT INTO portuguese_lemma VALUES ("a#00460554","a","comunitário","N");
INSERT INTO portuguese_lemma VALUES ("a#02548965","a","comunitário","N");
INSERT INTO portuguese_lemma VALUES ("v#00493052","v","descontaminar","N");
INSERT INTO portuguese_lemma VALUES ("a#00460814","a","estatal","N");
INSERT INTO portuguese_lemma VALUES ("a#01791310","a","estatal","N");
INSERT INTO portuguese_lemma VALUES ("a#00460814","a","público","N");
INSERT INTO portuguese_lemma VALUES ("a#01790261","a","público","N");
INSERT INTO portuguese_lemma VALUES ("n#07965817","n","público","N");
INSERT INTO portuguese_lemma VALUES ("n#06103316","n","público","N");
INSERT INTO portuguese_lemma VALUES ("a#02110583","a","individual","N");
INSERT INTO portuguese_lemma VALUES ("a#02036455","a","individual","N");
INSERT INTO portuguese_lemma VALUES ("r#00493494","r","animadamente","N");
INSERT INTO portuguese_lemma VALUES ("a#00493820","a","idiossincrático","N");
INSERT INTO portuguese_lemma VALUES ("v#00344252","v","isolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00345357","v","isolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00345547","v","isolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00345904","v","isolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00346179","v","isolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00344252","v","ilhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00462055","a","respectivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00462055","a","respetivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00462537","a","singular","N");
INSERT INTO portuguese_lemma VALUES ("a#00919283","a","singular","N");
INSERT INTO portuguese_lemma VALUES ("a#01678417","a","singular","N");
INSERT INTO portuguese_lemma VALUES ("a#02112131","a","singular","N");
INSERT INTO portuguese_lemma VALUES ("n#06299916","n","singular","N");
INSERT INTO portuguese_lemma VALUES ("a#00462537","a","único","N");
INSERT INTO portuguese_lemma VALUES ("a#00472062","a","único","N");
INSERT INTO portuguese_lemma VALUES ("a#00576203","a","único","N");
INSERT INTO portuguese_lemma VALUES ("a#00919283","a","único","N");
INSERT INTO portuguese_lemma VALUES ("a#02111616","a","único","N");
INSERT INTO portuguese_lemma VALUES ("a#02112131","a","único","N");
INSERT INTO portuguese_lemma VALUES ("n#00494768","n","pôquer","N");
INSERT INTO portuguese_lemma VALUES ("n#00494768","n","póquer","N");
INSERT INTO portuguese_lemma VALUES ("a#00494907","a","comunicativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00464296","a","comunicativo","N");
INSERT INTO portuguese_lemma VALUES ("a#02956371","a","comunicativo","N");
INSERT INTO portuguese_lemma VALUES ("r#00494948","r","completamente_entregue","Y");
INSERT INTO portuguese_lemma VALUES ("r#00494948","r","sem_reservas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00494948","r","de_todo_o_coração","Y");
INSERT INTO portuguese_lemma VALUES ("r#00494948","r","sem_ressalvas","Y");
INSERT INTO portuguese_lemma VALUES ("r#00495309","r","de_onde","Y");
INSERT INTO portuguese_lemma VALUES ("r#00495309","r","donde","N");
INSERT INTO portuguese_lemma VALUES ("r#00495377","r","não_importa_o_lugar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00495377","r","onde_quer_que","Y");
INSERT INTO portuguese_lemma VALUES ("n#00495524","n","Paciência","N");
INSERT INTO portuguese_lemma VALUES ("n#00495524","n","paciência","N");
INSERT INTO portuguese_lemma VALUES ("n#03659752","n","paciência","N");
INSERT INTO portuguese_lemma VALUES ("a#00495916","a","anedótico","N");
INSERT INTO portuguese_lemma VALUES ("a#03044331","a","anedótico","N");
INSERT INTO portuguese_lemma VALUES ("v#00345547","v","insular","N");
INSERT INTO portuguese_lemma VALUES ("n#00496167","n","Uíste","N");
INSERT INTO portuguese_lemma VALUES ("v#00496266","v","quarentenar","N");
INSERT INTO portuguese_lemma VALUES ("a#00496569","a","comunicável","N");
INSERT INTO portuguese_lemma VALUES ("n#00496599","n","copas","N");
INSERT INTO portuguese_lemma VALUES ("n#02810457","n","copas","N");
INSERT INTO portuguese_lemma VALUES ("a#00496845","a","anglófono","N");
INSERT INTO portuguese_lemma VALUES ("a#00464296","a","falador","N");
INSERT INTO portuguese_lemma VALUES ("n#00317921","n","Canasta","N");
INSERT INTO portuguese_lemma VALUES ("a#00464568","a","significativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01436246","a","significativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01436930","a","significativo","N");
INSERT INTO portuguese_lemma VALUES ("a#02078228","a","significativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00497535","a","francófono","N");
INSERT INTO portuguese_lemma VALUES ("n#00497536","n","Pôquer_fechado","Y");
INSERT INTO portuguese_lemma VALUES ("r#00497560","r","é!","N");
INSERT INTO portuguese_lemma VALUES ("r#00497560","r","sim","N");
INSERT INTO portuguese_lemma VALUES ("r#00497560","r","isso_aí!","Y");
INSERT INTO portuguese_lemma VALUES ("v#00347065","v","impregnar","N");
INSERT INTO portuguese_lemma VALUES ("n#00498086","n","strip_poker","Y");
INSERT INTO portuguese_lemma VALUES ("n#00498086","n","Strip_poker","Y");
INSERT INTO portuguese_lemma VALUES ("n#00498220","n","Pôquer_aberto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00498286","a","heráldico","N");
INSERT INTO portuguese_lemma VALUES ("r#00498499","r","no_alto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00498610","r","no_alto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00499004","r","no_alto","Y");
INSERT INTO portuguese_lemma VALUES ("r#00499084","r","no_alto","Y");
INSERT INTO portuguese_lemma VALUES ("a#00465739","a","narrativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00498988","v","calcificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00499263","n","Tenis_de_mesa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00499263","n","tênis_de_mesa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00499263","n","Ténis_de_Mesa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00499263","n","Ténis-de-mesa","N");
INSERT INTO portuguese_lemma VALUES ("n#00499263","n","pingue-pongue","N");
INSERT INTO portuguese_lemma VALUES ("r#00499340","r","circunstancialmente","N");
INSERT INTO portuguese_lemma VALUES ("r#00499340","r","de_forma_circunstancial","Y");
INSERT INTO portuguese_lemma VALUES ("n#00499477","n","dominó","N");
INSERT INTO portuguese_lemma VALUES ("n#03220802","n","dominó","N");
INSERT INTO portuguese_lemma VALUES ("n#03221205","n","dominó","N");
INSERT INTO portuguese_lemma VALUES ("v#00499812","v","urbanizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00499812","v","industrializar","N");
INSERT INTO portuguese_lemma VALUES ("v#00576979","v","industrializar","N");
INSERT INTO portuguese_lemma VALUES ("n#00499924","n","bilhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00500126","a","hispanófono","N");
INSERT INTO portuguese_lemma VALUES ("a#00466619","a","verbal","N");
INSERT INTO portuguese_lemma VALUES ("a#02172775","a","verbal","N");
INSERT INTO portuguese_lemma VALUES ("a#02619885","a","verbal","N");
INSERT INTO portuguese_lemma VALUES ("v#00500638","v","emulsionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00500834","v","emulsionar","N");
INSERT INTO portuguese_lemma VALUES ("r#00500759","r","prestes_a","Y");
INSERT INTO portuguese_lemma VALUES ("r#00500759","r","no_limiar_de","Y");
INSERT INTO portuguese_lemma VALUES ("r#00500759","r","iminentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00500759","r","a_ponto_de","Y");
INSERT INTO portuguese_lemma VALUES ("a#00501004","a","reticente","N");
INSERT INTO portuguese_lemma VALUES ("n#00501080","n","Bilhar_americano","Y");
INSERT INTO portuguese_lemma VALUES ("r#00501140","r","em_princípio","Y");
INSERT INTO portuguese_lemma VALUES ("n#00501304","n","sinuca","N");
INSERT INTO portuguese_lemma VALUES ("n#00501304","n","snooker","N");
INSERT INTO portuguese_lemma VALUES ("n#00501304","n","Snooker","N");
INSERT INTO portuguese_lemma VALUES ("a#00501313","a","inexpressível","N");
INSERT INTO portuguese_lemma VALUES ("a#00501313","a","sem_expressão","Y");
INSERT INTO portuguese_lemma VALUES ("a#00501723","a","sem_expressão","Y");
INSERT INTO portuguese_lemma VALUES ("r#00501452","r","inconfundivelmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00501722","n","jogo_de_salão","Y");
INSERT INTO portuguese_lemma VALUES ("a#00501723","a","inexpressivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00501870","n","Jogos_de_palavras","Y");
INSERT INTO portuguese_lemma VALUES ("r#00501990","r","para_dentro","Y");
INSERT INTO portuguese_lemma VALUES ("n#00502161","n","Scrabble","N");
INSERT INTO portuguese_lemma VALUES ("a#00468456","a","compacto","N");
INSERT INTO portuguese_lemma VALUES ("a#00468456","a","cerrado","N");
INSERT INTO portuguese_lemma VALUES ("v#00502332","v","desnitrificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00502415","n","jogo_de_tabuleiro","Y");
INSERT INTO portuguese_lemma VALUES ("v#00350087","v","estercar","N");
INSERT INTO portuguese_lemma VALUES ("n#00502822","n","Gamao","N");
INSERT INTO portuguese_lemma VALUES ("n#00502822","n","gamão","N");
INSERT INTO portuguese_lemma VALUES ("n#00502822","n","Gamão","N");
INSERT INTO portuguese_lemma VALUES ("n#00502952","n","damas","N");
INSERT INTO portuguese_lemma VALUES ("n#00502952","n","jogo_de_damas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00503237","n","jogo_de_xadrez","Y");
INSERT INTO portuguese_lemma VALUES ("n#00503237","n","xadrez","N");
INSERT INTO portuguese_lemma VALUES ("n#03011162","n","xadrez","N");
INSERT INTO portuguese_lemma VALUES ("n#02872007","n","xadrez","N");
INSERT INTO portuguese_lemma VALUES ("n#03684740","n","xadrez","N");
INSERT INTO portuguese_lemma VALUES ("n#03174387","n","xadrez","N");
INSERT INTO portuguese_lemma VALUES ("a#00469766","a","friável","N");
INSERT INTO portuguese_lemma VALUES ("a#00708738","a","friável","N");
INSERT INTO portuguese_lemma VALUES ("n#00503981","n","Damas_chinesas","Y");
INSERT INTO portuguese_lemma VALUES ("a#00470209","a","comparável","N");
INSERT INTO portuguese_lemma VALUES ("a#00470381","a","comparável","N");
INSERT INTO portuguese_lemma VALUES ("a#00470640","a","comparável","N");
INSERT INTO portuguese_lemma VALUES ("a#01985976","a","comparável","N");
INSERT INTO portuguese_lemma VALUES ("v#00504019","v","pegar_com_pinça","Y");
INSERT INTO portuguese_lemma VALUES ("v#00504019","v","tomar_entre_dois_dedos","Y");
INSERT INTO portuguese_lemma VALUES ("r#00504153","r","semdelonga","N");
INSERT INTO portuguese_lemma VALUES ("r#00504153","r","semdemora","N");
INSERT INTO portuguese_lemma VALUES ("n#00504209","n","dardos","N");
INSERT INTO portuguese_lemma VALUES ("n#00504325","n","go","N");
INSERT INTO portuguese_lemma VALUES ("r#00504492","r","de_segunda_mão","Y");
INSERT INTO portuguese_lemma VALUES ("a#01640482","a","de_segunda_mão","Y");
INSERT INTO portuguese_lemma VALUES ("a#00504592","a","incomparável","N");
INSERT INTO portuguese_lemma VALUES ("a#00505410","a","incomparável","N");
INSERT INTO portuguese_lemma VALUES ("n#00504660","n","bingo","N");
INSERT INTO portuguese_lemma VALUES ("n#00505126","n","mahjong","N");
INSERT INTO portuguese_lemma VALUES ("n#00505126","n","Mahjong","N");
INSERT INTO portuguese_lemma VALUES ("v#00216841","v","clarificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00216841","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00361681","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00833392","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00606341","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00635987","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00636201","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00636437","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00677246","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#01065456","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("v#02635033","v","explicar","N");
INSERT INTO portuguese_lemma VALUES ("n#00505238","n","Monopólio","N");
INSERT INTO portuguese_lemma VALUES ("n#14444326","n","Monopólio","N");
INSERT INTO portuguese_lemma VALUES ("n#00505238","n","Banco_Imobiliário","Y");
INSERT INTO portuguese_lemma VALUES ("v#00505349","v","desintoxicar","N");
INSERT INTO portuguese_lemma VALUES ("a#00505410","a","sem_comparação","Y");
INSERT INTO portuguese_lemma VALUES ("r#00505639","r","causalmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00505726","n","Shogi","N");
INSERT INTO portuguese_lemma VALUES ("a#00472062","a","inigualável","N");
INSERT INTO portuguese_lemma VALUES ("r#00505853","r","um_a_um","Y");
INSERT INTO portuguese_lemma VALUES ("v#00506040","v","electrificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00506040","v","eletrificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00506040","v","electrizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00506040","v","eletrizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01225706","v","eletrizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00506207","n","jogo_da_velha","Y");
INSERT INTO portuguese_lemma VALUES ("a#01425318","a","compatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00475053","a","compatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00475498","a","compatível","N");
INSERT INTO portuguese_lemma VALUES ("n#00507673","n","jogo_de_fortuna_e_azar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00507716","r","de_ontem","Y");
INSERT INTO portuguese_lemma VALUES ("r#00507716","r","ontem","N");
INSERT INTO portuguese_lemma VALUES ("r#00507819","r","ontem","N");
INSERT INTO portuguese_lemma VALUES ("n#15156187","n","ontem","N");
INSERT INTO portuguese_lemma VALUES ("n#15263138","n","ontem","N");
INSERT INTO portuguese_lemma VALUES ("a#00507789","a","congenial","N");
INSERT INTO portuguese_lemma VALUES ("a#00527630","a","congenial","N");
INSERT INTO portuguese_lemma VALUES ("r#00507927","r","junto","N");
INSERT INTO portuguese_lemma VALUES ("a#00533304","a","junto","N");
INSERT INTO portuguese_lemma VALUES ("r#00507927","r","junta","N");
INSERT INTO portuguese_lemma VALUES ("n#06171035","n","junta","N");
INSERT INTO portuguese_lemma VALUES ("n#06172564","n","junta","N");
INSERT INTO portuguese_lemma VALUES ("n#00508091","n","loteria","N");
INSERT INTO portuguese_lemma VALUES ("n#00508672","n","loteria","N");
INSERT INTO portuguese_lemma VALUES ("a#00474296","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00475213","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00475784","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00528281","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00529913","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00545259","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#00588254","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#01425914","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("a#02270006","a","incompatível","N");
INSERT INTO portuguese_lemma VALUES ("n#00508672","n","Rifa","N");
INSERT INTO portuguese_lemma VALUES ("n#00508672","n","rifa","N");
INSERT INTO portuguese_lemma VALUES ("a#00474818","a","contraditório","N");
INSERT INTO portuguese_lemma VALUES ("a#00545006","a","contraditório","N");
INSERT INTO portuguese_lemma VALUES ("a#02245649","a","contraditório","N");
INSERT INTO portuguese_lemma VALUES ("a#02269664","a","contraditório","N");
INSERT INTO portuguese_lemma VALUES ("n#00509399","n","roleta","N");
INSERT INTO portuguese_lemma VALUES ("n#04113194","n","roleta","N");
INSERT INTO portuguese_lemma VALUES ("n#04113406","n","roleta","N");
INSERT INTO portuguese_lemma VALUES ("v#00509449","v","ondear","N");
INSERT INTO portuguese_lemma VALUES ("a#00510050","a","habilitado","N");
INSERT INTO portuguese_lemma VALUES ("a#00510050","a","competente","N");
INSERT INTO portuguese_lemma VALUES ("a#02120998","a","competente","N");
INSERT INTO portuguese_lemma VALUES ("n#00510050","n","brincadeira_perversa","Y");
INSERT INTO portuguese_lemma VALUES ("v#00510116","v","sardas","N");
INSERT INTO portuguese_lemma VALUES ("n#05245192","n","sardas","N");
INSERT INTO portuguese_lemma VALUES ("a#00476442","a","eficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#01753746","a","eficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#00799334","a","eficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#00839619","a","eficiente","N");
INSERT INTO portuguese_lemma VALUES ("a#00476442","a","eficaz","N");
INSERT INTO portuguese_lemma VALUES ("a#01753746","a","eficaz","N");
INSERT INTO portuguese_lemma VALUES ("a#00799334","a","eficaz","N");
INSERT INTO portuguese_lemma VALUES ("n#00510723","n","compulsão_alimentar","Y");
INSERT INTO portuguese_lemma VALUES ("r#00510852","r","de_forma_contextual","Y");
INSERT INTO portuguese_lemma VALUES ("r#00510852","r","contextualmente","N");
INSERT INTO portuguese_lemma VALUES ("n#00511041","n","farra","N");
INSERT INTO portuguese_lemma VALUES ("n#00329560","n","farra","N");
INSERT INTO portuguese_lemma VALUES ("n#00329560","n","deboche","N");
INSERT INTO portuguese_lemma VALUES ("n#00329560","n","viveremfarra","N");
INSERT INTO portuguese_lemma VALUES ("n#00329560","n","vivernodeboche","N");
INSERT INTO portuguese_lemma VALUES ("n#00329560","n","dissipação","N");
INSERT INTO portuguese_lemma VALUES ("n#00329560","n","orgia","N");
INSERT INTO portuguese_lemma VALUES ("v#00356023","v","curtir","N");
INSERT INTO portuguese_lemma VALUES ("n#00511555","n","carnaval","N");
INSERT INTO portuguese_lemma VALUES ("n#00511676","n","Bacanal","N");
INSERT INTO portuguese_lemma VALUES ("n#00511676","n","bacanal","N");
INSERT INTO portuguese_lemma VALUES ("n#00694827","n","bacanal","N");
INSERT INTO portuguese_lemma VALUES ("v#00512186","v","incapacitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00512186","v","desabilitar","N");
INSERT INTO portuguese_lemma VALUES ("a#00512487","a","Competitivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00512522","n","flerte","N");
INSERT INTO portuguese_lemma VALUES ("n#00330677","n","tolice","N");
INSERT INTO portuguese_lemma VALUES ("n#00330677","n","idiotice","N");
INSERT INTO portuguese_lemma VALUES ("v#00357077","v","habilitar","N");
INSERT INTO portuguese_lemma VALUES ("r#00513831","r","imunologicamente","N");
INSERT INTO portuguese_lemma VALUES ("v#00358208","v","salientar","N");
INSERT INTO portuguese_lemma VALUES ("v#00358208","v","destacar","N");
INSERT INTO portuguese_lemma VALUES ("v#00887219","v","destacar","N");
INSERT INTO portuguese_lemma VALUES ("r#00514272","r","de_forma_judicial","Y");
INSERT INTO portuguese_lemma VALUES ("a#00514278","a","resignado","N");
INSERT INTO portuguese_lemma VALUES ("a#00514396","a","compressível","N");
INSERT INTO portuguese_lemma VALUES ("a#00514613","a","comprimido","N");
INSERT INTO portuguese_lemma VALUES ("a#01655538","a","comprimido","N");
INSERT INTO portuguese_lemma VALUES ("n#03123093","n","comprimido","N");
INSERT INTO portuguese_lemma VALUES ("n#00514787","n","gambozino","N");
INSERT INTO portuguese_lemma VALUES ("r#00514889","r","Recorrentemente","N");
INSERT INTO portuguese_lemma VALUES ("r#00515298","r","estavelmente","N");
INSERT INTO portuguese_lemma VALUES ("a#00481645","a","inteira","N");
INSERT INTO portuguese_lemma VALUES ("a#00481645","a","total","N");
INSERT INTO portuguese_lemma VALUES ("a#00489625","a","total","N");
INSERT INTO portuguese_lemma VALUES ("n#10375432","n","total","N");
INSERT INTO portuguese_lemma VALUES ("a#00481645","a","inteiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00482100","a","inteiro","N");
INSERT INTO portuguese_lemma VALUES ("n#13728499","n","inteiro","N");
INSERT INTO portuguese_lemma VALUES ("n#00515414","n","distração","N");
INSERT INTO portuguese_lemma VALUES ("n#04409041","n","distração","N");
INSERT INTO portuguese_lemma VALUES ("n#00515414","n","distracção","N");
INSERT INTO portuguese_lemma VALUES ("n#04409041","n","distracção","N");
INSERT INTO portuguese_lemma VALUES ("n#00515578","n","Edutainment","N");
INSERT INTO portuguese_lemma VALUES ("a#00482100","a","completo","N");
INSERT INTO portuguese_lemma VALUES ("a#00487168","a","completo","N");
INSERT INTO portuguese_lemma VALUES ("a#00489625","a","completo","N");
INSERT INTO portuguese_lemma VALUES ("n#00332566","n","solenidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03664203","n","solenidade","N");
INSERT INTO portuguese_lemma VALUES ("n#05584266","n","solenidade","N");
INSERT INTO portuguese_lemma VALUES ("a#00516539","a","fracionário","N");
INSERT INTO portuguese_lemma VALUES ("n#00516559","n","Jogos_Nemeus","Y");
INSERT INTO portuguese_lemma VALUES ("n#00516559","n","Jogos_nemeus","Y");
INSERT INTO portuguese_lemma VALUES ("n#00516720","n","jogos_olímpicos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00516900","n","Jogos_Píticos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00516900","n","Jogos_píticos","Y");
INSERT INTO portuguese_lemma VALUES ("a#00517314","a","fragmentário","N");
INSERT INTO portuguese_lemma VALUES ("a#00483994","a","metade","N");
INSERT INTO portuguese_lemma VALUES ("a#00524496","a","metade","N");
INSERT INTO portuguese_lemma VALUES ("n#09891093","n","metade","N");
INSERT INTO portuguese_lemma VALUES ("n#10960792","n","metade","N");
INSERT INTO portuguese_lemma VALUES ("n#00517728","n","festival","N");
INSERT INTO portuguese_lemma VALUES ("v#00360886","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00509295","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01239202","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00981851","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00994853","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01450792","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00996361","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01487311","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01022027","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01022755","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01490572","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01490690","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01025426","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01026409","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("v#01364494","v","carregar","N");
INSERT INTO portuguese_lemma VALUES ("n#00518152","n","Kwanzaa","N");
INSERT INTO portuguese_lemma VALUES ("v#00518288","v","Recarregar","N");
INSERT INTO portuguese_lemma VALUES ("v#00361385","v","facilitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01757338","v","facilitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00518442","n","Saturnália","N");
INSERT INTO portuguese_lemma VALUES ("n#00518442","n","Saturnalia","N");
INSERT INTO portuguese_lemma VALUES ("v#00361554","v","mistificar","N");
INSERT INTO portuguese_lemma VALUES ("v#02577586","v","mistificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00333978","n","gala","N");
INSERT INTO portuguese_lemma VALUES ("a#00485838","a","livre","N");
INSERT INTO portuguese_lemma VALUES ("a#01007914","a","livre","N");
INSERT INTO portuguese_lemma VALUES ("v#00519056","v","bolhadear","N");
INSERT INTO portuguese_lemma VALUES ("v#00519056","v","formar_bolhas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00519056","v","borbulhar","N");
INSERT INTO portuguese_lemma VALUES ("v#01969084","v","borbulhar","N");
INSERT INTO portuguese_lemma VALUES ("a#00519211","a","entregue","N");
INSERT INTO portuguese_lemma VALUES ("a#00519211","a","dedicado","N");
INSERT INTO portuguese_lemma VALUES ("a#00573225","a","dedicado","N");
INSERT INTO portuguese_lemma VALUES ("v#00519363","v","espumar","N");
INSERT INTO portuguese_lemma VALUES ("v#00519363","v","espumejar","N");
INSERT INTO portuguese_lemma VALUES ("a#00519477","a","devotado","N");
INSERT INTO portuguese_lemma VALUES ("a#00519668","a","devotado","N");
INSERT INTO portuguese_lemma VALUES ("n#00334700","n","circo","N");
INSERT INTO portuguese_lemma VALUES ("n#02444381","n","circo","N");
INSERT INTO portuguese_lemma VALUES ("n#06087639","n","circo","N");
INSERT INTO portuguese_lemma VALUES ("n#00334700","n","Artes_circenses","Y");
INSERT INTO portuguese_lemma VALUES ("v#00362427","v","disturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#01208224","v","disturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#00362427","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#00973053","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#01203947","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#01208224","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#01218326","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#01221002","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#01222254","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("v#02065652","v","perturbar","N");
INSERT INTO portuguese_lemma VALUES ("n#00520059","n","Terça-Feira_Gorda","Y");
INSERT INTO portuguese_lemma VALUES ("a#00487168","a","integral","N");
INSERT INTO portuguese_lemma VALUES ("n#06015505","n","integral","N");
INSERT INTO portuguese_lemma VALUES ("a#00487168","a","totalizado","N");
INSERT INTO portuguese_lemma VALUES ("n#00335147","n","exibição","N");
INSERT INTO portuguese_lemma VALUES ("n#00335980","n","exibição","N");
INSERT INTO portuguese_lemma VALUES ("n#00520672","n","cabaret","N");
INSERT INTO portuguese_lemma VALUES ("n#00520672","n","cabaré","N");
INSERT INTO portuguese_lemma VALUES ("n#02931417","n","cabaré","N");
INSERT INTO portuguese_lemma VALUES ("n#00335980","n","exposição","N");
INSERT INTO portuguese_lemma VALUES ("n#00522145","n","exposição","N");
INSERT INTO portuguese_lemma VALUES ("n#00679124","n","exposição","N");
INSERT INTO portuguese_lemma VALUES ("n#06217283","n","exposição","N");
INSERT INTO portuguese_lemma VALUES ("n#09805381","n","exposição","N");
INSERT INTO portuguese_lemma VALUES ("n#14543931","n","exposição","N");
INSERT INTO portuguese_lemma VALUES ("a#00521329","a","realizado","N");
INSERT INTO portuguese_lemma VALUES ("a#02226028","a","realizado","N");
INSERT INTO portuguese_lemma VALUES ("n#07531105","n","realizado","N");
INSERT INTO portuguese_lemma VALUES ("n#00336149","n","demonstração","N");
INSERT INTO portuguese_lemma VALUES ("n#04985559","n","demonstração","N");
INSERT INTO portuguese_lemma VALUES ("n#05148592","n","demonstração","N");
INSERT INTO portuguese_lemma VALUES ("a#00522240","a","completado","N");
INSERT INTO portuguese_lemma VALUES ("a#00522240","a","completa","N");
INSERT INTO portuguese_lemma VALUES ("v#00364478","v","transladar","N");
INSERT INTO portuguese_lemma VALUES ("v#01373274","v","transladar","N");
INSERT INTO portuguese_lemma VALUES ("a#00522463","a","exaustivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00492304","a","exaustivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00364629","v","conformar","N");
INSERT INTO portuguese_lemma VALUES ("v#00364767","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#00617095","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#00610465","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#00812388","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#02108377","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#02108654","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#01513366","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#01513874","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#02288295","v","receber","N");
INSERT INTO portuguese_lemma VALUES ("v#00364767","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#00444338","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#01511279","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#01513874","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#01531769","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#02238770","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#01532512","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#02288295","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#01564908","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#02359340","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#01722366","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("v#01723410","v","obter","N");
INSERT INTO portuguese_lemma VALUES ("a#00523978","a","incompleto","N");
INSERT INTO portuguese_lemma VALUES ("a#01004541","a","incompleto","N");
INSERT INTO portuguese_lemma VALUES ("v#00524083","v","acetilar","N");
INSERT INTO portuguese_lemma VALUES ("v#00524299","v","acetilar","N");
INSERT INTO portuguese_lemma VALUES ("a#00491051","a","partido","N");
INSERT INTO portuguese_lemma VALUES ("n#06131180","n","partido","N");
INSERT INTO portuguese_lemma VALUES ("a#00524607","a","nenhuma","N");
INSERT INTO portuguese_lemma VALUES ("a#00524607","a","nenhum","N");
INSERT INTO portuguese_lemma VALUES ("a#00524607","a","nenhuma_pessoa","Y");
INSERT INTO portuguese_lemma VALUES ("v#00366302","v","assumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00428091","v","assumir","N");
INSERT INTO portuguese_lemma VALUES ("v#01622769","v","assumir","N");
INSERT INTO portuguese_lemma VALUES ("a#00491270","a","parcial","N");
INSERT INTO portuguese_lemma VALUES ("a#01659853","a","parcial","N");
INSERT INTO portuguese_lemma VALUES ("a#00695128","a","parcial","N");
INSERT INTO portuguese_lemma VALUES ("v#00525027","v","reassumir","N");
INSERT INTO portuguese_lemma VALUES ("a#00492304","a","detalhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00492304","a","abrangente","N");
INSERT INTO portuguese_lemma VALUES ("a#00492304","a","extenso","N");
INSERT INTO portuguese_lemma VALUES ("a#00494215","a","extenso","N");
INSERT INTO portuguese_lemma VALUES ("a#01332909","a","extenso","N");
INSERT INTO portuguese_lemma VALUES ("a#01333157","a","extenso","N");
INSERT INTO portuguese_lemma VALUES ("v#00526081","v","carboxilar","N");
INSERT INTO portuguese_lemma VALUES ("n#00526259","n","adágio","N");
INSERT INTO portuguese_lemma VALUES ("n#07047804","n","adágio","N");
INSERT INTO portuguese_lemma VALUES ("n#05350719","n","adágio","N");
INSERT INTO portuguese_lemma VALUES ("n#05351147","n","adágio","N");
INSERT INTO portuguese_lemma VALUES ("v#00527034","v","clausurar","N");
INSERT INTO portuguese_lemma VALUES ("a#00493390","a","global","N");
INSERT INTO portuguese_lemma VALUES ("a#01511497","a","global","N");
INSERT INTO portuguese_lemma VALUES ("a#01512420","a","global","N");
INSERT INTO portuguese_lemma VALUES ("a#01966960","a","global","N");
INSERT INTO portuguese_lemma VALUES ("a#00493390","a","mundial","N");
INSERT INTO portuguese_lemma VALUES ("a#01511497","a","mundial","N");
INSERT INTO portuguese_lemma VALUES ("a#01512420","a","mundial","N");
INSERT INTO portuguese_lemma VALUES ("v#00527232","v","adubar","N");
INSERT INTO portuguese_lemma VALUES ("v#00527232","v","fazer_adubo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00527872","n","sapateado","N");
INSERT INTO portuguese_lemma VALUES ("a#00528167","a","plenário","N");
INSERT INTO portuguese_lemma VALUES ("n#00528397","n","coreografia","N");
INSERT INTO portuguese_lemma VALUES ("n#06816445","n","coreografia","N");
INSERT INTO portuguese_lemma VALUES ("n#07020763","n","coreografia","N");
INSERT INTO portuguese_lemma VALUES ("n#00339532","n","balé","N");
INSERT INTO portuguese_lemma VALUES ("n#07054336","n","balé","N");
INSERT INTO portuguese_lemma VALUES ("a#00528761","a","súper","N");
INSERT INTO portuguese_lemma VALUES ("v#00369536","v","amanhecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00495291","a","constituído","N");
INSERT INTO portuguese_lemma VALUES ("a#01678759","a","sossegado","N");
INSERT INTO portuguese_lemma VALUES ("a#01678759","a","calmo","N");
INSERT INTO portuguese_lemma VALUES ("a#01678759","a","sereno","N");
INSERT INTO portuguese_lemma VALUES ("a#01678759","a","tranquilo","N");
INSERT INTO portuguese_lemma VALUES ("a#01678759","a","tranqüilo","N");
INSERT INTO portuguese_lemma VALUES ("a#01678759","a","calma","N");
INSERT INTO portuguese_lemma VALUES ("n#03839746","n","calma","N");
INSERT INTO portuguese_lemma VALUES ("n#03893757","n","calma","N");
INSERT INTO portuguese_lemma VALUES ("n#03893972","n","calma","N");
INSERT INTO portuguese_lemma VALUES ("n#05586846","n","calma","N");
INSERT INTO portuguese_lemma VALUES ("n#10415727","n","calma","N");
INSERT INTO portuguese_lemma VALUES ("n#00530018","n","dança_moderna","Y");
INSERT INTO portuguese_lemma VALUES ("n#00530018","n","Dança_Moderna","Y");
INSERT INTO portuguese_lemma VALUES ("n#00530208","n","tamanco","N");
INSERT INTO portuguese_lemma VALUES ("n#03047690","n","tamanco","N");
INSERT INTO portuguese_lemma VALUES ("n#00530554","n","dança_do_ventre","Y");
INSERT INTO portuguese_lemma VALUES ("n#00530554","n","Dança_do_Ventre","Y");
INSERT INTO portuguese_lemma VALUES ("v#00531302","v","despovoar","N");
INSERT INTO portuguese_lemma VALUES ("n#00531490","n","Strip-tease","N");
INSERT INTO portuguese_lemma VALUES ("n#00531490","n","striptease","N");
INSERT INTO portuguese_lemma VALUES ("a#00497363","a","acanhado","N");
INSERT INTO portuguese_lemma VALUES ("a#00497363","a","vergonhoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00531904","v","dessalinizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00532288","a","desconcertado","N");
INSERT INTO portuguese_lemma VALUES ("v#00532607","v","externalizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00532739","n","dança_espanhola","Y");
INSERT INTO portuguese_lemma VALUES ("n#00532739","n","fandango","N");
INSERT INTO portuguese_lemma VALUES ("a#01436533","a","compreensível","N");
INSERT INTO portuguese_lemma VALUES ("a#00499123","a","compreensível","N");
INSERT INTO portuguese_lemma VALUES ("n#00533036","n","flamenco","N");
INSERT INTO portuguese_lemma VALUES ("n#00533036","n","Flamenco","N");
INSERT INTO portuguese_lemma VALUES ("a#00533221","a","abordável","N");
INSERT INTO portuguese_lemma VALUES ("n#00533224","n","gavota","N");
INSERT INTO portuguese_lemma VALUES ("n#00533322","n","habanera","N");
INSERT INTO portuguese_lemma VALUES ("a#00499123","a","entendível","N");
INSERT INTO portuguese_lemma VALUES ("n#00533805","n","tarantela","N");
INSERT INTO portuguese_lemma VALUES ("a#00533851","a","incompreensível","N");
INSERT INTO portuguese_lemma VALUES ("a#00939105","a","incompreensível","N");
INSERT INTO portuguese_lemma VALUES ("v#00534222","v","politizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00534250","a","obscuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00899612","a","obscuro","N");
INSERT INTO portuguese_lemma VALUES ("a#02088883","a","obscuro","N");
INSERT INTO portuguese_lemma VALUES ("n#00534849","n","Dança_de_Salão","Y");
INSERT INTO portuguese_lemma VALUES ("n#00534849","n","dança_de_salão","Y");
INSERT INTO portuguese_lemma VALUES ("a#00534918","a","impenetrável","N");
INSERT INTO portuguese_lemma VALUES ("a#00535452","a","côncavo","N");
INSERT INTO portuguese_lemma VALUES ("a#00535452","a","oco","N");
INSERT INTO portuguese_lemma VALUES ("a#02155010","a","oco","N");
INSERT INTO portuguese_lemma VALUES ("n#06728884","n","oco","N");
INSERT INTO portuguese_lemma VALUES ("a#00535844","a","acetabular","N");
INSERT INTO portuguese_lemma VALUES ("a#00536008","a","bicôncavo","N");
INSERT INTO portuguese_lemma VALUES ("n#00536359","n","Charleston","N");
INSERT INTO portuguese_lemma VALUES ("n#09138538","n","Charleston","N");
INSERT INTO portuguese_lemma VALUES ("n#09155798","n","Charleston","N");
INSERT INTO portuguese_lemma VALUES ("n#00536778","n","minueto","N");
INSERT INTO portuguese_lemma VALUES ("n#07056113","n","minueto","N");
INSERT INTO portuguese_lemma VALUES ("n#00537192","n","samba","N");
INSERT INTO portuguese_lemma VALUES ("n#07056895","n","samba","N");
INSERT INTO portuguese_lemma VALUES ("a#00537339","a","convexo","N");
INSERT INTO portuguese_lemma VALUES ("a#00537339","a","envoltória_convexa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00537423","n","tango","N");
INSERT INTO portuguese_lemma VALUES ("n#07057829","n","tango","N");
INSERT INTO portuguese_lemma VALUES ("n#00537534","n","valsa","N");
INSERT INTO portuguese_lemma VALUES ("n#07058184","n","valsa","N");
INSERT INTO portuguese_lemma VALUES ("a#00537745","a","biconvexo","N");
INSERT INTO portuguese_lemma VALUES ("n#00538052","n","mazurca","N");
INSERT INTO portuguese_lemma VALUES ("n#00538144","n","polca","N");
INSERT INTO portuguese_lemma VALUES ("n#07056504","n","polca","N");
INSERT INTO portuguese_lemma VALUES ("n#00538266","n","Chotiça","N");
INSERT INTO portuguese_lemma VALUES ("n#00538668","n","mambo","N");
INSERT INTO portuguese_lemma VALUES ("a#00503751","a","denso","N");
INSERT INTO portuguese_lemma VALUES ("a#01706921","a","denso","N");
INSERT INTO portuguese_lemma VALUES ("a#02299475","a","denso","N");
INSERT INTO portuguese_lemma VALUES ("v#00377424","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#00989536","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01840092","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01844859","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01261627","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01304824","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01915365","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01915865","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01307553","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01317730","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01401176","v","atravessar","N");
INSERT INTO portuguese_lemma VALUES ("n#00540485","n","quadrilha","N");
INSERT INTO portuguese_lemma VALUES ("n#06143363","n","quadrilha","N");
INSERT INTO portuguese_lemma VALUES ("n#08415774","n","quadrilha","N");
INSERT INTO portuguese_lemma VALUES ("a#00505802","a","difuso","N");
INSERT INTO portuguese_lemma VALUES ("a#00514357","a","difuso","N");
INSERT INTO portuguese_lemma VALUES ("v#00541163","v","dilatar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00541163","v","expandir-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00542149","n","dança_da_morte","Y");
INSERT INTO portuguese_lemma VALUES ("n#00542149","n","dança_macabra","Y");
INSERT INTO portuguese_lemma VALUES ("a#00507803","a","apartado","N");
INSERT INTO portuguese_lemma VALUES ("a#00507880","a","disperso","N");
INSERT INTO portuguese_lemma VALUES ("a#00507880","a","esparso","N");
INSERT INTO portuguese_lemma VALUES ("n#00542458","n","Hula","N");
INSERT INTO portuguese_lemma VALUES ("n#00542711","n","dança_da_chuva","Y");
INSERT INTO portuguese_lemma VALUES ("a#00542953","a","concêntrico","N");
INSERT INTO portuguese_lemma VALUES ("a#00543200","a","excêntricos","N");
INSERT INTO portuguese_lemma VALUES ("a#00543200","a","excêntrico","N");
INSERT INTO portuguese_lemma VALUES ("a#00543200","a","excêntrica","N");
INSERT INTO portuguese_lemma VALUES ("a#00543200","a","excêntricas","N");
INSERT INTO portuguese_lemma VALUES ("n#00351993","n","música","N");
INSERT INTO portuguese_lemma VALUES ("n#04417946","n","música","N");
INSERT INTO portuguese_lemma VALUES ("n#05718935","n","música","N");
INSERT INTO portuguese_lemma VALUES ("n#05266809","n","música","N");
INSERT INTO portuguese_lemma VALUES ("v#00380419","v","dar_outra_forma","Y");
INSERT INTO portuguese_lemma VALUES ("v#00380794","v","escalfar","N");
INSERT INTO portuguese_lemma VALUES ("n#00544441","n","carrilhão","N");
INSERT INTO portuguese_lemma VALUES ("a#00544478","a","assombrada","N");
INSERT INTO portuguese_lemma VALUES ("a#00544478","a","obcecado","N");
INSERT INTO portuguese_lemma VALUES ("a#00599468","a","obcecado","N");
INSERT INTO portuguese_lemma VALUES ("n#00545344","n","Música_vocal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00354500","n","Canção","N");
INSERT INTO portuguese_lemma VALUES ("n#00354500","n","Canto","N");
INSERT INTO portuguese_lemma VALUES ("n#00546216","n","Belcanto","N");
INSERT INTO portuguese_lemma VALUES ("n#00546216","n","Bel_Canto","Y");
INSERT INTO portuguese_lemma VALUES ("n#00546216","n","bel_canto","Y");
INSERT INTO portuguese_lemma VALUES ("n#00355108","n","cantoria","N");
INSERT INTO portuguese_lemma VALUES ("n#00355108","n","canção","N");
INSERT INTO portuguese_lemma VALUES ("n#05284501","n","canção","N");
INSERT INTO portuguese_lemma VALUES ("a#00511928","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#00834080","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01280576","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01289497","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01615410","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01660647","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#01724072","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#02281611","a","indiferente","N");
INSERT INTO portuguese_lemma VALUES ("a#00512104","a","conciso","N");
INSERT INTO portuguese_lemma VALUES ("a#00548316","a","conciso","N");
INSERT INTO portuguese_lemma VALUES ("a#00512104","a","lacónico","N");
INSERT INTO portuguese_lemma VALUES ("a#00548316","a","lacónico","N");
INSERT INTO portuguese_lemma VALUES ("a#00512104","a","sucinto","N");
INSERT INTO portuguese_lemma VALUES ("a#00547317","a","sucinto","N");
INSERT INTO portuguese_lemma VALUES ("a#00512104","a","lacônico","N");
INSERT INTO portuguese_lemma VALUES ("a#00512937","a","lacônico","N");
INSERT INTO portuguese_lemma VALUES ("n#00547244","n","scat","N");
INSERT INTO portuguese_lemma VALUES ("a#00547317","a","sumário","N");
INSERT INTO portuguese_lemma VALUES ("n#04857759","n","sumário","N");
INSERT INTO portuguese_lemma VALUES ("n#06468123","n","sumário","N");
INSERT INTO portuguese_lemma VALUES ("n#04859332","n","sumário","N");
INSERT INTO portuguese_lemma VALUES ("n#06468403","n","sumário","N");
INSERT INTO portuguese_lemma VALUES ("n#06468951","n","sumário","N");
INSERT INTO portuguese_lemma VALUES ("n#06469223","n","sumário","N");
INSERT INTO portuguese_lemma VALUES ("n#04859040","n","sumário","N");
INSERT INTO portuguese_lemma VALUES ("a#00547317","a","compêndio","N");
INSERT INTO portuguese_lemma VALUES ("n#06414372","n","compêndio","N");
INSERT INTO portuguese_lemma VALUES ("n#06467996","n","compêndio","N");
INSERT INTO portuguese_lemma VALUES ("n#06468123","n","compêndio","N");
INSERT INTO portuguese_lemma VALUES ("a#00512937","a","curto","N");
INSERT INTO portuguese_lemma VALUES ("a#01379046","a","curto","N");
INSERT INTO portuguese_lemma VALUES ("a#01383972","a","curto","N");
INSERT INTO portuguese_lemma VALUES ("a#01384633","a","curto","N");
INSERT INTO portuguese_lemma VALUES ("a#00548029","a","elíptico","N");
INSERT INTO portuguese_lemma VALUES ("a#02046199","a","elíptico","N");
INSERT INTO portuguese_lemma VALUES ("a#02168132","a","elíptico","N");
INSERT INTO portuguese_lemma VALUES ("v#00383502","v","voltar","N");
INSERT INTO portuguese_lemma VALUES ("v#00649691","v","voltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01422854","v","voltar","N");
INSERT INTO portuguese_lemma VALUES ("a#00548316","a","sentencioso","N");
INSERT INTO portuguese_lemma VALUES ("n#00358063","n","atuação","N");
INSERT INTO portuguese_lemma VALUES ("n#05156358","n","atuação","N");
INSERT INTO portuguese_lemma VALUES ("n#00358063","n","representação","N");
INSERT INTO portuguese_lemma VALUES ("n#00577495","n","representação","N");
INSERT INTO portuguese_lemma VALUES ("n#00789600","n","representação","N");
INSERT INTO portuguese_lemma VALUES ("n#03229963","n","representação","N");
INSERT INTO portuguese_lemma VALUES ("v#00548616","v","nivelar","N");
INSERT INTO portuguese_lemma VALUES ("v#01307142","v","nivelar","N");
INSERT INTO portuguese_lemma VALUES ("v#01307609","v","nivelar","N");
INSERT INTO portuguese_lemma VALUES ("a#00548781","a","prolixo","N");
INSERT INTO portuguese_lemma VALUES ("a#01381736","a","prolixo","N");
INSERT INTO portuguese_lemma VALUES ("n#00358359","n","caracterização","N");
INSERT INTO portuguese_lemma VALUES ("n#07201562","n","caracterização","N");
INSERT INTO portuguese_lemma VALUES ("n#05381135","n","caracterização","N");
INSERT INTO portuguese_lemma VALUES ("n#00549284","n","personificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00597654","n","personificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00933259","n","personificação","N");
INSERT INTO portuguese_lemma VALUES ("n#07108123","n","personificação","N");
INSERT INTO portuguese_lemma VALUES ("n#10418101","n","personificação","N");
INSERT INTO portuguese_lemma VALUES ("n#07470212","n","personificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00549284","n","imitação","N");
INSERT INTO portuguese_lemma VALUES ("n#00549472","n","imitação","N");
INSERT INTO portuguese_lemma VALUES ("n#01020936","n","imitação","N");
INSERT INTO portuguese_lemma VALUES ("n#00549472","n","mímica","N");
INSERT INTO portuguese_lemma VALUES ("n#06875697","n","mímica","N");
INSERT INTO portuguese_lemma VALUES ("n#10318892","n","mímica","N");
INSERT INTO portuguese_lemma VALUES ("n#00549610","n","paródia","N");
INSERT INTO portuguese_lemma VALUES ("n#06780309","n","paródia","N");
INSERT INTO portuguese_lemma VALUES ("a#00549826","a","pleonástico","N");
INSERT INTO portuguese_lemma VALUES ("a#00549826","a","tautológico","N");
INSERT INTO portuguese_lemma VALUES ("a#00549826","a","redundante","N");
INSERT INTO portuguese_lemma VALUES ("a#01524894","a","redundante","N");
INSERT INTO portuguese_lemma VALUES ("a#00549826","a","supérfluo","N");
INSERT INTO portuguese_lemma VALUES ("a#01524894","a","supérfluo","N");
INSERT INTO portuguese_lemma VALUES ("a#00549826","a","desnecessário","N");
INSERT INTO portuguese_lemma VALUES ("a#01524704","a","desnecessário","N");
INSERT INTO portuguese_lemma VALUES ("a#01525512","a","desnecessário","N");
INSERT INTO portuguese_lemma VALUES ("n#00550016","n","pantomima","N");
INSERT INTO portuguese_lemma VALUES ("a#00550282","a","conclusivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00515853","a","definitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00666635","a","definitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00515853","a","decisivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00619212","a","decisivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00649636","a","decisivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00650020","a","decisivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00701178","a","decisivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00550777","a","inconclusivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00551718","v","dinamizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00551913","n","reconstituição","N");
INSERT INTO portuguese_lemma VALUES ("v#00552006","v","concretizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01644746","v","concretizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00552436","n","animação","N");
INSERT INTO portuguese_lemma VALUES ("n#00908405","n","animação","N");
INSERT INTO portuguese_lemma VALUES ("n#04631700","n","animação","N");
INSERT INTO portuguese_lemma VALUES ("n#05005809","n","animação","N");
INSERT INTO portuguese_lemma VALUES ("n#13961642","n","animação","N");
INSERT INTO portuguese_lemma VALUES ("n#00552922","n","desorganização","N");
INSERT INTO portuguese_lemma VALUES ("a#00553140","a","de_acordo_com","Y");
INSERT INTO portuguese_lemma VALUES ("v#00553208","v","eternizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00553208","v","tornar_eterno","Y");
INSERT INTO portuguese_lemma VALUES ("v#00553208","v","imortalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00612042","v","imortalizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00553478","a","concorde","N");
INSERT INTO portuguese_lemma VALUES ("a#00553478","a","conforme","N");
INSERT INTO portuguese_lemma VALUES ("a#00577122","a","conforme","N");
INSERT INTO portuguese_lemma VALUES ("a#00553594","a","consensual","N");
INSERT INTO portuguese_lemma VALUES ("n#00361333","n","surpresa","N");
INSERT INTO portuguese_lemma VALUES ("a#02357479","a","surpresa","N");
INSERT INTO portuguese_lemma VALUES ("n#05442564","n","surpresa","N");
INSERT INTO portuguese_lemma VALUES ("n#05582358","n","surpresa","N");
INSERT INTO portuguese_lemma VALUES ("n#05582577","n","surpresa","N");
INSERT INTO portuguese_lemma VALUES ("n#05582875","n","surpresa","N");
INSERT INTO portuguese_lemma VALUES ("a#00518774","a","unânime","N");
INSERT INTO portuguese_lemma VALUES ("a#00747104","a","unânime","N");
INSERT INTO portuguese_lemma VALUES ("n#00361442","n","tumulto","N");
INSERT INTO portuguese_lemma VALUES ("n#00554541","n","tumulto","N");
INSERT INTO portuguese_lemma VALUES ("n#10068579","n","tumulto","N");
INSERT INTO portuguese_lemma VALUES ("n#00361442","n","escândalo","N");
INSERT INTO portuguese_lemma VALUES ("n#05447394","n","escândalo","N");
INSERT INTO portuguese_lemma VALUES ("a#00553899","a","discordante","N");
INSERT INTO portuguese_lemma VALUES ("n#00361596","n","arrebato","N");
INSERT INTO portuguese_lemma VALUES ("n#00554541","n","kingpin","N");
INSERT INTO portuguese_lemma VALUES ("n#00554541","n","alvoroço","N");
INSERT INTO portuguese_lemma VALUES ("n#00554541","n","turbulência","N");
INSERT INTO portuguese_lemma VALUES ("n#11520989","n","turbulência","N");
INSERT INTO portuguese_lemma VALUES ("n#13979173","n","turbulência","N");
INSERT INTO portuguese_lemma VALUES ("n#14523669","n","turbulência","N");
INSERT INTO portuguese_lemma VALUES ("n#14524383","n","turbulência","N");
INSERT INTO portuguese_lemma VALUES ("a#00554624","a","contrátil","N");
INSERT INTO portuguese_lemma VALUES ("n#00362255","n","desarranjo","N");
INSERT INTO portuguese_lemma VALUES ("n#10330471","n","desarranjo","N");
INSERT INTO portuguese_lemma VALUES ("n#00362507","n","freneticidade","N");
INSERT INTO portuguese_lemma VALUES ("v#00388919","v","mudar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#01855606","v","mudar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00555325","a","condicionado","N");
INSERT INTO portuguese_lemma VALUES ("a#01913413","a","condicionado","N");
INSERT INTO portuguese_lemma VALUES ("v#00389405","v","escovar","N");
INSERT INTO portuguese_lemma VALUES ("v#01243809","v","escovar","N");
INSERT INTO portuguese_lemma VALUES ("v#01243982","v","escovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00956103","v","escovar","N");
INSERT INTO portuguese_lemma VALUES ("a#00522821","a","eventual","N");
INSERT INTO portuguese_lemma VALUES ("a#01522771","a","eventual","N");
INSERT INTO portuguese_lemma VALUES ("a#01751894","a","eventual","N");
INSERT INTO portuguese_lemma VALUES ("a#01961205","a","eventual","N");
INSERT INTO portuguese_lemma VALUES ("a#00523173","a","tentativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00523173","a","provisório","N");
INSERT INTO portuguese_lemma VALUES ("a#00523173","a","temporário","N");
INSERT INTO portuguese_lemma VALUES ("a#01691661","a","temporário","N");
INSERT INTO portuguese_lemma VALUES ("a#01756166","a","temporário","N");
INSERT INTO portuguese_lemma VALUES ("a#01692272","a","temporário","N");
INSERT INTO portuguese_lemma VALUES ("a#00523173","a","provisória","N");
INSERT INTO portuguese_lemma VALUES ("v#00390029","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01317321","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01318647","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#02000133","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01364900","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01406763","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01618507","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01658906","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01661432","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01661609","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01665790","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#01738832","v","conduzir","N");
INSERT INTO portuguese_lemma VALUES ("a#00523702","a","incondicional","N");
INSERT INTO portuguese_lemma VALUES ("a#00730082","a","incondicional","N");
INSERT INTO portuguese_lemma VALUES ("a#01844025","a","incondicional","N");
INSERT INTO portuguese_lemma VALUES ("a#02095346","a","incondicional","N");
INSERT INTO portuguese_lemma VALUES ("n#00363615","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#02563119","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#02598242","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#03265874","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#02849808","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#02965788","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#03113185","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#03118233","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#03229963","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#04536390","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#06999233","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#07149819","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#09987377","n","figura","N");
INSERT INTO portuguese_lemma VALUES ("n#00364173","n","tática","N");
INSERT INTO portuguese_lemma VALUES ("n#04538754","n","tática","N");
INSERT INTO portuguese_lemma VALUES ("n#00364539","n","assistência","N");
INSERT INTO portuguese_lemma VALUES ("n#00782440","n","assistência","N");
INSERT INTO portuguese_lemma VALUES ("n#00783978","n","assistência","N");
INSERT INTO portuguese_lemma VALUES ("n#00800467","n","assistência","N");
INSERT INTO portuguese_lemma VALUES ("n#04012006","n","assistência","N");
INSERT INTO portuguese_lemma VALUES ("n#04015637","n","assistência","N");
INSERT INTO portuguese_lemma VALUES ("a#00558019","a","semicondutores","N");
INSERT INTO portuguese_lemma VALUES ("v#00559390","v","esmagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01097909","v","esmagar","N");
INSERT INTO portuguese_lemma VALUES ("v#01800195","v","esmagar","N");
INSERT INTO portuguese_lemma VALUES ("a#00526734","a","aglomerado","N");
INSERT INTO portuguese_lemma VALUES ("a#00526734","a","movimentado","N");
INSERT INTO portuguese_lemma VALUES ("v#00560391","v","saltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01892104","v","saltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01291867","v","saltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01303431","v","saltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01336773","v","saltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01337493","v","saltar","N");
INSERT INTO portuguese_lemma VALUES ("v#01338935","v","saltar","N");
INSERT INTO portuguese_lemma VALUES ("a#00528181","a","sociável","N");
INSERT INTO portuguese_lemma VALUES ("a#02257141","a","sociável","N");
INSERT INTO portuguese_lemma VALUES ("n#00561226","n","Passe_para_a_frente","Y");
INSERT INTO portuguese_lemma VALUES ("a#00561600","a","proporcionado","N");
INSERT INTO portuguese_lemma VALUES ("a#00561600","a","congruente","N");
INSERT INTO portuguese_lemma VALUES ("a#00561757","a","coincidente","N");
INSERT INTO portuguese_lemma VALUES ("a#02266559","a","coincidente","N");
INSERT INTO portuguese_lemma VALUES ("a#00529038","a","idêntico","N");
INSERT INTO portuguese_lemma VALUES ("a#00845976","a","idêntico","N");
INSERT INTO portuguese_lemma VALUES ("a#01360962","a","idêntico","N");
INSERT INTO portuguese_lemma VALUES ("a#01986273","a","idêntico","N");
INSERT INTO portuguese_lemma VALUES ("a#01990838","a","idêntico","N");
INSERT INTO portuguese_lemma VALUES ("n#00562280","n","obstrução","N");
INSERT INTO portuguese_lemma VALUES ("n#01074498","n","obstrução","N");
INSERT INTO portuguese_lemma VALUES ("a#00562469","a","incongruente","N");
INSERT INTO portuguese_lemma VALUES ("v#00562720","v","desinflar","N");
INSERT INTO portuguese_lemma VALUES ("a#00562803","a","discrepante","N");
INSERT INTO portuguese_lemma VALUES ("n#00564373","n","queimada_dupla","Y");
INSERT INTO portuguese_lemma VALUES ("v#00564695","v","preguear","N");
INSERT INTO portuguese_lemma VALUES ("v#00564857","v","amassar","N");
INSERT INTO portuguese_lemma VALUES ("v#01235355","v","amassar","N");
INSERT INTO portuguese_lemma VALUES ("v#01278427","v","amassar","N");
INSERT INTO portuguese_lemma VALUES ("v#00873019","v","amassar","N");
INSERT INTO portuguese_lemma VALUES ("v#01279631","v","amassar","N");
INSERT INTO portuguese_lemma VALUES ("a#00531862","a","divisório","N");
INSERT INTO portuguese_lemma VALUES ("n#00369708","n","tacada","N");
INSERT INTO portuguese_lemma VALUES ("n#00788473","n","tacada","N");
INSERT INTO portuguese_lemma VALUES ("a#00533750","a","aparentado","N");
INSERT INTO portuguese_lemma VALUES ("n#00567418","n","forehand","N");
INSERT INTO portuguese_lemma VALUES ("n#00371920","n","Serviço","N");
INSERT INTO portuguese_lemma VALUES ("n#00372142","n","ace","N");
INSERT INTO portuguese_lemma VALUES ("a#00569568","a","inconquistável","N");
INSERT INTO portuguese_lemma VALUES ("n#00569898","n","braçada","N");
INSERT INTO portuguese_lemma VALUES ("a#00570099","a","indomável","N");
INSERT INTO portuguese_lemma VALUES ("a#01475526","a","indomável","N");
INSERT INTO portuguese_lemma VALUES ("a#00570225","a","insuperável","N");
INSERT INTO portuguese_lemma VALUES ("a#02357115","a","insuperável","N");
INSERT INTO portuguese_lemma VALUES ("a#00570322","a","invencível","N");
INSERT INTO portuguese_lemma VALUES ("a#02288252","a","invencível","N");
INSERT INTO portuguese_lemma VALUES ("n#00570366","n","Australian_Crawl","Y");
INSERT INTO portuguese_lemma VALUES ("a#00537748","a","consciente","N");
INSERT INTO portuguese_lemma VALUES ("a#01284583","a","consciente","N");
INSERT INTO portuguese_lemma VALUES ("a#01907044","a","consciente","N");
INSERT INTO portuguese_lemma VALUES ("n#00374336","n","borboleta","N");
INSERT INTO portuguese_lemma VALUES ("n#01777374","n","borboleta","N");
INSERT INTO portuguese_lemma VALUES ("n#00374336","n","Borboleta","N");
INSERT INTO portuguese_lemma VALUES ("n#00374336","n","borboletas","N");
INSERT INTO portuguese_lemma VALUES ("n#01777374","n","borboletas","N");
INSERT INTO portuguese_lemma VALUES ("n#00374336","n","mariposa","N");
INSERT INTO portuguese_lemma VALUES ("n#01777374","n","mariposa","N");
INSERT INTO portuguese_lemma VALUES ("n#02283201","n","mariposa","N");
INSERT INTO portuguese_lemma VALUES ("n#00571060","n","bruços","N");
INSERT INTO portuguese_lemma VALUES ("n#00571060","n","Bruços","N");
INSERT INTO portuguese_lemma VALUES ("n#00571060","n","braça","N");
INSERT INTO portuguese_lemma VALUES ("n#13660178","n","braça","N");
INSERT INTO portuguese_lemma VALUES ("n#00374747","n","costas","N");
INSERT INTO portuguese_lemma VALUES ("n#02231899","n","costas","N");
INSERT INTO portuguese_lemma VALUES ("n#03217207","n","costas","N");
INSERT INTO portuguese_lemma VALUES ("n#04306040","n","costas","N");
INSERT INTO portuguese_lemma VALUES ("n#04330266","n","costas","N");
INSERT INTO portuguese_lemma VALUES ("a#00538832","a","esmaecido","N");
INSERT INTO portuguese_lemma VALUES ("a#00538832","a","desacordado","N");
INSERT INTO portuguese_lemma VALUES ("a#00538832","a","desfalecido","N");
INSERT INTO portuguese_lemma VALUES ("a#00538832","a","desmaiado","N");
INSERT INTO portuguese_lemma VALUES ("a#00538832","a","incônscio","N");
INSERT INTO portuguese_lemma VALUES ("a#02400554","a","incônscio","N");
INSERT INTO portuguese_lemma VALUES ("v#00573085","v","desanimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00908099","v","desanimar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238101","v","desanimar","N");
INSERT INTO portuguese_lemma VALUES ("v#01819147","v","desanimar","N");
INSERT INTO portuguese_lemma VALUES ("a#00574010","a","violentado","N");
INSERT INTO portuguese_lemma VALUES ("a#00574010","a","violado","N");
INSERT INTO portuguese_lemma VALUES ("v#00574341","v","despolarizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00574514","v","desmineralizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00575365","n","moleza","N");
INSERT INTO portuguese_lemma VALUES ("n#00377835","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00378419","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00378829","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00380841","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00383807","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00408411","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00409199","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00503108","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#03629197","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#03631348","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#08137495","n","trabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00377835","n","tarefa","N");
INSERT INTO portuguese_lemma VALUES ("n#00378829","n","tarefa","N");
INSERT INTO portuguese_lemma VALUES ("n#00729108","n","tarefa","N");
INSERT INTO portuguese_lemma VALUES ("n#00730247","n","tarefa","N");
INSERT INTO portuguese_lemma VALUES ("n#00796586","n","tarefa","N");
INSERT INTO portuguese_lemma VALUES ("n#00503108","n","tarefa","N");
INSERT INTO portuguese_lemma VALUES ("a#00543180","a","progresista","N");
INSERT INTO portuguese_lemma VALUES ("a#00543180","a","progressista","N");
INSERT INTO portuguese_lemma VALUES ("a#01473088","a","progressista","N");
INSERT INTO portuguese_lemma VALUES ("a#01804618","a","progressista","N");
INSERT INTO portuguese_lemma VALUES ("a#00543564","a","consistente","N");
INSERT INTO portuguese_lemma VALUES ("n#00378984","n","procedimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00660588","n","procedimento","N");
INSERT INTO portuguese_lemma VALUES ("n#03835766","n","procedimento","N");
INSERT INTO portuguese_lemma VALUES ("a#00577405","a","em_conformidade","Y");
INSERT INTO portuguese_lemma VALUES ("a#00577920","a","inconsistente","N");
INSERT INTO portuguese_lemma VALUES ("a#01987207","a","inconsistente","N");
INSERT INTO portuguese_lemma VALUES ("n#00578405","n","auditoria_contábil","Y");
INSERT INTO portuguese_lemma VALUES ("n#00578708","n","lavagem_(roupa)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00578708","n","lavagem","N");
INSERT INTO portuguese_lemma VALUES ("n#07805006","n","lavagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00579082","n","engraxate","N");
INSERT INTO portuguese_lemma VALUES ("a#00545700","a","conspícuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00545700","a","saliente","N");
INSERT INTO portuguese_lemma VALUES ("a#01353982","a","saliente","N");
INSERT INTO portuguese_lemma VALUES ("a#00545700","a","proeminente","N");
INSERT INTO portuguese_lemma VALUES ("a#00546266","a","proeminente","N");
INSERT INTO portuguese_lemma VALUES ("a#00547551","a","proeminente","N");
INSERT INTO portuguese_lemma VALUES ("a#00546266","a","ilustre","N");
INSERT INTO portuguese_lemma VALUES ("a#01321211","a","ilustre","N");
INSERT INTO portuguese_lemma VALUES ("a#00546266","a","importante","N");
INSERT INTO portuguese_lemma VALUES ("a#00618913","a","importante","N");
INSERT INTO portuguese_lemma VALUES ("a#01223408","a","importante","N");
INSERT INTO portuguese_lemma VALUES ("a#01477528","a","importante","N");
INSERT INTO portuguese_lemma VALUES ("a#01758997","a","importante","N");
INSERT INTO portuguese_lemma VALUES ("a#02078228","a","importante","N");
INSERT INTO portuguese_lemma VALUES ("v#00579712","v","dominar","N");
INSERT INTO portuguese_lemma VALUES ("v#01731370","v","dominar","N");
INSERT INTO portuguese_lemma VALUES ("v#00579712","v","subordinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01798079","v","subordinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00579712","v","subjugar","N");
INSERT INTO portuguese_lemma VALUES ("v#00750961","v","subjugar","N");
INSERT INTO portuguese_lemma VALUES ("v#00579712","v","submeter","N");
INSERT INTO portuguese_lemma VALUES ("v#00732394","v","submeter","N");
INSERT INTO portuguese_lemma VALUES ("v#01701149","v","submeter","N");
INSERT INTO portuguese_lemma VALUES ("n#00579977","n","serviço_militar","Y");
INSERT INTO portuguese_lemma VALUES ("n#00580961","n","agregado_familiar","Y");
INSERT INTO portuguese_lemma VALUES ("n#00581090","n","Ferro_De_Passar","Y");
INSERT INTO portuguese_lemma VALUES ("n#00581090","n","ferro_de_passar","Y");
INSERT INTO portuguese_lemma VALUES ("n#02867016","n","ferro_de_passar","Y");
INSERT INTO portuguese_lemma VALUES ("v#00581205","v","visualizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01123901","v","visualizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01636008","v","visualizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02151394","v","visualizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00380841","n","Workload","N");
INSERT INTO portuguese_lemma VALUES ("v#00581355","v","ondular","N");
INSERT INTO portuguese_lemma VALUES ("a#00548185","a","invisível","N");
INSERT INTO portuguese_lemma VALUES ("a#02395922","a","invisível","N");
INSERT INTO portuguese_lemma VALUES ("n#00581772","n","abate","N");
INSERT INTO portuguese_lemma VALUES ("n#00581772","n","indústria_madeireira","Y");
INSERT INTO portuguese_lemma VALUES ("n#00582071","n","papelada","N");
INSERT INTO portuguese_lemma VALUES ("n#00582195","n","serviços_sociais","Y");
INSERT INTO portuguese_lemma VALUES ("n#00582195","n","socorro_social","Y");
INSERT INTO portuguese_lemma VALUES ("a#00582314","a","distiguivel","N");
INSERT INTO portuguese_lemma VALUES ("a#00582314","a","que_pode_ser_distinguido","Y");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","profissão","N");
INSERT INTO portuguese_lemma VALUES ("n#00382624","n","profissão","N");
INSERT INTO portuguese_lemma VALUES ("n#00399744","n","profissão","N");
INSERT INTO portuguese_lemma VALUES ("n#00402228","n","profissão","N");
INSERT INTO portuguese_lemma VALUES ("n#05011927","n","profissão","N");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","ofício","N");
INSERT INTO portuguese_lemma VALUES ("n#00399744","n","ofício","N");
INSERT INTO portuguese_lemma VALUES ("n#10048361","n","ofício","N");
INSERT INTO portuguese_lemma VALUES ("n#00381958","n","função","N");
INSERT INTO portuguese_lemma VALUES ("n#00462318","n","função","N");
INSERT INTO portuguese_lemma VALUES ("n#00722061","n","função","N");
INSERT INTO portuguese_lemma VALUES ("n#04011535","n","função","N");
INSERT INTO portuguese_lemma VALUES ("n#06582403","n","função","N");
INSERT INTO portuguese_lemma VALUES ("n#13781164","n","função","N");
INSERT INTO portuguese_lemma VALUES ("n#09927753","n","função","N");
INSERT INTO portuguese_lemma VALUES ("a#00582636","a","diferenciável","N");
INSERT INTO portuguese_lemma VALUES ("a#02712810","a","diferenciável","N");
INSERT INTO portuguese_lemma VALUES ("a#00549951","a","constante","N");
INSERT INTO portuguese_lemma VALUES ("a#00562853","a","constante","N");
INSERT INTO portuguese_lemma VALUES ("a#00563345","a","constante","N");
INSERT INTO portuguese_lemma VALUES ("a#02385304","a","constante","N");
INSERT INTO portuguese_lemma VALUES ("n#09761890","n","constante","N");
INSERT INTO portuguese_lemma VALUES ("n#00382624","n","vocação","N");
INSERT INTO portuguese_lemma VALUES ("n#00584248","n","vocação","N");
INSERT INTO portuguese_lemma VALUES ("n#00382821","n","especialização","N");
INSERT INTO portuguese_lemma VALUES ("n#00383035","n","especialização","N");
INSERT INTO portuguese_lemma VALUES ("n#09743392","n","especialização","N");
INSERT INTO portuguese_lemma VALUES ("n#00382821","n","Especialidades_médicas","Y");
INSERT INTO portuguese_lemma VALUES ("n#00382821","n","especialidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03741160","n","especialidade","N");
INSERT INTO portuguese_lemma VALUES ("n#05640729","n","especialidade","N");
INSERT INTO portuguese_lemma VALUES ("a#00550615","a","inquebrantável","N");
INSERT INTO portuguese_lemma VALUES ("a#00583990","a","inconstante","N");
INSERT INTO portuguese_lemma VALUES ("n#00383807","n","biscate","N");
INSERT INTO portuguese_lemma VALUES ("a#00551365","a","falso","N");
INSERT INTO portuguese_lemma VALUES ("a#02343098","a","falso","N");
INSERT INTO portuguese_lemma VALUES ("a#00584626","a","caprichoso","N");
INSERT INTO portuguese_lemma VALUES ("n#04545843","n","caprichoso","N");
INSERT INTO portuguese_lemma VALUES ("n#05568649","n","caprichoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00384174","n","dever","N");
INSERT INTO portuguese_lemma VALUES ("n#00461585","n","dever","N");
INSERT INTO portuguese_lemma VALUES ("n#00731811","n","dever","N");
INSERT INTO portuguese_lemma VALUES ("v#01542388","v","dever","N");
INSERT INTO portuguese_lemma VALUES ("v#01542552","v","dever","N");
INSERT INTO portuguese_lemma VALUES ("a#00584820","a","construtivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01818077","a","construtivo","N");
INSERT INTO portuguese_lemma VALUES ("n#00585018","n","teletrabalho","N");
INSERT INTO portuguese_lemma VALUES ("n#00585174","n","serviços","N");
INSERT INTO portuguese_lemma VALUES ("a#00552091","a","criativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01796235","a","criativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00607344","a","criativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00585405","v","preparar_feno","Y");
INSERT INTO portuguese_lemma VALUES ("n#00585660","n","serviços_públicos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00585660","n","utilidade_pública","Y");
INSERT INTO portuguese_lemma VALUES ("n#00384745","n","ministro","N");
INSERT INTO portuguese_lemma VALUES ("n#09983572","n","ministro","N");
INSERT INTO portuguese_lemma VALUES ("n#07412658","n","ministro","N");
INSERT INTO portuguese_lemma VALUES ("a#00585856","a","Reconstructor","N");
INSERT INTO portuguese_lemma VALUES ("a#00585856","a","reconstructor","N");
INSERT INTO portuguese_lemma VALUES ("a#00552772","a","estrutural","N");
INSERT INTO portuguese_lemma VALUES ("a#01038818","a","estrutural","N");
INSERT INTO portuguese_lemma VALUES ("a#02677877","a","estrutural","N");
INSERT INTO portuguese_lemma VALUES ("a#02678054","a","estrutural","N");
INSERT INTO portuguese_lemma VALUES ("a#02719360","a","estrutural","N");
INSERT INTO portuguese_lemma VALUES ("a#02719560","a","estrutural","N");
INSERT INTO portuguese_lemma VALUES ("a#00586183","a","destrutivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00586241","v","erotizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00385376","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#00462982","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#03907971","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#03960878","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#05075602","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#03965003","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#03965383","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#05082507","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#04697893","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#06483454","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#05080036","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#06352837","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#08622201","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#06353479","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#08624196","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#08653706","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#10048803","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#10049911","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#10351976","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#10352475","n","posição","N");
INSERT INTO portuguese_lemma VALUES ("n#00385376","n","cargo","N");
INSERT INTO portuguese_lemma VALUES ("n#10048361","n","cargo","N");
INSERT INTO portuguese_lemma VALUES ("v#00586816","v","redimensionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00587376","a","cáustico","N");
INSERT INTO portuguese_lemma VALUES ("a#01730738","a","cáustico","N");
INSERT INTO portuguese_lemma VALUES ("a#00587376","a","corrosivo","N");
INSERT INTO portuguese_lemma VALUES ("a#02079732","a","corrosivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00588207","a","iconoclástico","N");
INSERT INTO portuguese_lemma VALUES ("a#01691687","a","iconoclástico","N");
INSERT INTO portuguese_lemma VALUES ("v#00397191","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00397666","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00589738","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00590241","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00399152","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00419626","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00422121","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00493867","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#01457245","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#01794033","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#01842330","v","compreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00397191","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00397666","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00589309","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00589738","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00589904","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00398597","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00399152","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00400923","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00401225","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00401762","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00419626","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00422121","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#00493867","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("v#01442173","v","entender","N");
INSERT INTO portuguese_lemma VALUES ("a#00588655","a","esbanjador","N");
INSERT INTO portuguese_lemma VALUES ("n#00588703","n","almirantado","N");
INSERT INTO portuguese_lemma VALUES ("n#08349548","n","almirantado","N");
INSERT INTO portuguese_lemma VALUES ("n#00387454","n","embaixada","N");
INSERT INTO portuguese_lemma VALUES ("n#02636321","n","embaixada","N");
INSERT INTO portuguese_lemma VALUES ("n#06213619","n","embaixada","N");
INSERT INTO portuguese_lemma VALUES ("n#08402693","n","embaixada","N");
INSERT INTO portuguese_lemma VALUES ("n#08402828","n","embaixada","N");
INSERT INTO portuguese_lemma VALUES ("n#00588881","n","dignidade_e_função_de_apóstolo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00397666","v","comprender","N");
INSERT INTO portuguese_lemma VALUES ("v#00589904","v","comprender","N");
INSERT INTO portuguese_lemma VALUES ("v#00398787","v","comprender","N");
INSERT INTO portuguese_lemma VALUES ("v#00494146","v","comprender","N");
INSERT INTO portuguese_lemma VALUES ("n#00387618","n","aprendizado","N");
INSERT INTO portuguese_lemma VALUES ("n#04590750","n","aprendizado","N");
INSERT INTO portuguese_lemma VALUES ("a#00589067","a","convencido","N");
INSERT INTO portuguese_lemma VALUES ("a#00589448","a","convencido","N");
INSERT INTO portuguese_lemma VALUES ("a#01891773","a","convencido","N");
INSERT INTO portuguese_lemma VALUES ("a#00589067","a","cheio_de_si","Y");
INSERT INTO portuguese_lemma VALUES ("a#00589448","a","cheio_de_si","Y");
INSERT INTO portuguese_lemma VALUES ("a#00589067","a","vaidoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00589448","a","vaidoso","N");
INSERT INTO portuguese_lemma VALUES ("n#00589217","n","advocacia","N");
INSERT INTO portuguese_lemma VALUES ("a#00557087","a","saciado","N");
INSERT INTO portuguese_lemma VALUES ("a#00557087","a","satisfeito","N");
INSERT INTO portuguese_lemma VALUES ("a#01805157","a","satisfeito","N");
INSERT INTO portuguese_lemma VALUES ("a#01892506","a","satisfeito","N");
INSERT INTO portuguese_lemma VALUES ("a#02189742","a","satisfeito","N");
INSERT INTO portuguese_lemma VALUES ("n#07531105","n","satisfeito","N");
INSERT INTO portuguese_lemma VALUES ("v#00589469","v","sentir","N");
INSERT INTO portuguese_lemma VALUES ("v#01209074","v","sentir","N");
INSERT INTO portuguese_lemma VALUES ("v#01225879","v","sentir","N");
INSERT INTO portuguese_lemma VALUES ("v#01485693","v","sentir","N");
INSERT INTO portuguese_lemma VALUES ("v#01562344","v","sentir","N");
INSERT INTO portuguese_lemma VALUES ("a#00589624","a","discontente","N");
INSERT INTO portuguese_lemma VALUES ("n#00589691","n","califado","N");
INSERT INTO portuguese_lemma VALUES ("n#15248812","n","califado","N");
INSERT INTO portuguese_lemma VALUES ("n#00589769","n","capitania","N");
INSERT INTO portuguese_lemma VALUES ("a#00557654","a","rebelde","N");
INSERT INTO portuguese_lemma VALUES ("a#00915311","a","rebelde","N");
INSERT INTO portuguese_lemma VALUES ("a#02219878","a","rebelde","N");
INSERT INTO portuguese_lemma VALUES ("n#07341493","n","rebelde","N");
INSERT INTO portuguese_lemma VALUES ("n#07401774","n","rebelde","N");
INSERT INTO portuguese_lemma VALUES ("n#00590148","n","chancelaria","N");
INSERT INTO portuguese_lemma VALUES ("n#03005033","n","chancelaria","N");
INSERT INTO portuguese_lemma VALUES ("a#00590163","a","descontente","N");
INSERT INTO portuguese_lemma VALUES ("v#00590241","v","perceber","N");
INSERT INTO portuguese_lemma VALUES ("v#01442173","v","perceber","N");
INSERT INTO portuguese_lemma VALUES ("v#01449939","v","perceber","N");
INSERT INTO portuguese_lemma VALUES ("a#00557994","a","contestável","N");
INSERT INTO portuguese_lemma VALUES ("a#00558237","a","discutível","N");
INSERT INTO portuguese_lemma VALUES ("a#00570063","a","discutível","N");
INSERT INTO portuguese_lemma VALUES ("a#01728405","a","discutível","N");
INSERT INTO portuguese_lemma VALUES ("a#00558480","a","que_não_se_pode_contestar","Y");
INSERT INTO portuguese_lemma VALUES ("v#00399015","v","digerir","N");
INSERT INTO portuguese_lemma VALUES ("v#01197338","v","digerir","N");
INSERT INTO portuguese_lemma VALUES ("a#00591147","a","demonstrável","N");
INSERT INTO portuguese_lemma VALUES ("a#01619105","a","demonstrável","N");
INSERT INTO portuguese_lemma VALUES ("n#00591236","n","assessoria","N");
INSERT INTO portuguese_lemma VALUES ("a#00591710","a","irrefutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00686264","a","irrefutável","N");
INSERT INTO portuguese_lemma VALUES ("a#00591953","a","incontinente","N");
INSERT INTO portuguese_lemma VALUES ("a#00559642","a","contínuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00562039","a","contínuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00562853","a","contínuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00563345","a","contínuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00564091","a","contínuo","N");
INSERT INTO portuguese_lemma VALUES ("a#00564857","a","contínuo","N");
INSERT INTO portuguese_lemma VALUES ("v#00399995","v","apreciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00691665","v","apreciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00604655","v","apreciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00604807","v","apreciar","N");
INSERT INTO portuguese_lemma VALUES ("v#01212539","v","apreciar","N");
INSERT INTO portuguese_lemma VALUES ("v#01231918","v","apreciar","N");
INSERT INTO portuguese_lemma VALUES ("v#01544040","v","apreciar","N");
INSERT INTO portuguese_lemma VALUES ("a#00592539","a","repetitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01964367","a","repetitivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00592539","a","insistente","N");
INSERT INTO portuguese_lemma VALUES ("a#00678141","a","insistente","N");
INSERT INTO portuguese_lemma VALUES ("a#00560754","a","recorrente","N");
INSERT INTO portuguese_lemma VALUES ("a#00560754","a","perene","N");
INSERT INTO portuguese_lemma VALUES ("a#00641546","a","perene","N");
INSERT INTO portuguese_lemma VALUES ("a#01383728","a","perene","N");
INSERT INTO portuguese_lemma VALUES ("a#01691167","a","perene","N");
INSERT INTO portuguese_lemma VALUES ("v#00400501","v","admitir_a_veracidade_de","Y");
INSERT INTO portuguese_lemma VALUES ("v#00400501","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00412827","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00418578","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00740449","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00555115","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00604807","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00717811","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#02475535","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#02754158","v","reconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00400501","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00490373","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00555115","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00555732","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01530524","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01669261","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01705579","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#02671279","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("v#02745486","v","admitir","N");
INSERT INTO portuguese_lemma VALUES ("n#00592894","n","diretoria_de_um_colégio","Y");
INSERT INTO portuguese_lemma VALUES ("a#00560909","a","persistente","N");
INSERT INTO portuguese_lemma VALUES ("a#00593374","a","casual","N");
INSERT INTO portuguese_lemma VALUES ("a#00715018","a","casual","N");
INSERT INTO portuguese_lemma VALUES ("a#01726809","a","casual","N");
INSERT INTO portuguese_lemma VALUES ("a#00593374","a","esporádico","N");
INSERT INTO portuguese_lemma VALUES ("a#00593374","a","raro","N");
INSERT INTO portuguese_lemma VALUES ("a#01618418","a","raro","N");
INSERT INTO portuguese_lemma VALUES ("v#00400923","v","inferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00428966","v","inferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00430091","v","inferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00430461","v","inferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00944924","v","inferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00593669","v","extrapolar","N");
INSERT INTO portuguese_lemma VALUES ("v#00642644","v","extrapolar","N");
INSERT INTO portuguese_lemma VALUES ("a#00593836","a","intermitente","N");
INSERT INTO portuguese_lemma VALUES ("n#00593837","n","estágio","N");
INSERT INTO portuguese_lemma VALUES ("n#03799375","n","estágio","N");
INSERT INTO portuguese_lemma VALUES ("n#10211203","n","estágio","N");
INSERT INTO portuguese_lemma VALUES ("v#00401225","v","traduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00649804","v","traduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00961947","v","traduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00401225","v","interpretar","N");
INSERT INTO portuguese_lemma VALUES ("v#00635307","v","interpretar","N");
INSERT INTO portuguese_lemma VALUES ("v#01185353","v","interpretar","N");
INSERT INTO portuguese_lemma VALUES ("a#00594004","a","ocasional","N");
INSERT INTO portuguese_lemma VALUES ("a#01067415","a","ocasional","N");
INSERT INTO portuguese_lemma VALUES ("a#01842468","a","ocasional","N");
INSERT INTO portuguese_lemma VALUES ("a#01961205","a","ocasional","N");
INSERT INTO portuguese_lemma VALUES ("a#00594004","a","periódico","N");
INSERT INTO portuguese_lemma VALUES ("a#01967240","a","periódico","N");
INSERT INTO portuguese_lemma VALUES ("n#04946588","n","periódico","N");
INSERT INTO portuguese_lemma VALUES ("a#00561747","a","irregular","N");
INSERT INTO portuguese_lemma VALUES ("a#01539551","a","irregular","N");
INSERT INTO portuguese_lemma VALUES ("a#01962107","a","irregular","N");
INSERT INTO portuguese_lemma VALUES ("a#01900549","a","irregular","N");
INSERT INTO portuguese_lemma VALUES ("a#00561850","a","isolada","N");
INSERT INTO portuguese_lemma VALUES ("v#00401559","v","conhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00401762","v","conhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00402210","v","conhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00402992","v","conhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00608372","v","conhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#01770968","v","conhecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00594477","n","biblioteconomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00401762","v","saber","N");
INSERT INTO portuguese_lemma VALUES ("v#00402210","v","saber","N");
INSERT INTO portuguese_lemma VALUES ("n#04387608","n","saber","N");
INSERT INTO portuguese_lemma VALUES ("n#05999266","n","saber","N");
INSERT INTO portuguese_lemma VALUES ("n#00594738","n","magistratura","N");
INSERT INTO portuguese_lemma VALUES ("n#00594953","n","virilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#04666837","n","virilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00595146","n","mestria","N");
INSERT INTO portuguese_lemma VALUES ("n#00595146","n","maestria","N");
INSERT INTO portuguese_lemma VALUES ("a#00562853","a","incessante","N");
INSERT INTO portuguese_lemma VALUES ("a#01382215","a","incessante","N");
INSERT INTO portuguese_lemma VALUES ("a#00562853","a","sem_paradas","Y");
INSERT INTO portuguese_lemma VALUES ("a#00562853","a","perpétuo","N");
INSERT INTO portuguese_lemma VALUES ("a#01691034","a","perpétuo","N");
INSERT INTO portuguese_lemma VALUES ("a#01691167","a","perpétuo","N");
INSERT INTO portuguese_lemma VALUES ("v#00402103","v","desconhecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00402103","v","ignorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00616857","v","ignorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00544324","v","ignorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00717937","v","ignorar","N");
INSERT INTO portuguese_lemma VALUES ("v#01450453","v","ignorar","N");
INSERT INTO portuguese_lemma VALUES ("a#00564091","a","ininterrupto","N");
INSERT INTO portuguese_lemma VALUES ("n#00392749","n","presidência","N");
INSERT INTO portuguese_lemma VALUES ("n#10966076","n","presidência","N");
INSERT INTO portuguese_lemma VALUES ("n#00597265","n","Presidente","N");
INSERT INTO portuguese_lemma VALUES ("n#00597265","n","presidentes","N");
INSERT INTO portuguese_lemma VALUES ("a#00597758","a","seguido","N");
INSERT INTO portuguese_lemma VALUES ("v#00403772","v","estudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00405251","v","estudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00410090","v","estudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00410381","v","estudar","N");
INSERT INTO portuguese_lemma VALUES ("v#00403772","v","aprender","N");
INSERT INTO portuguese_lemma VALUES ("v#00405251","v","aprender","N");
INSERT INTO portuguese_lemma VALUES ("v#00622450","v","aprender","N");
INSERT INTO portuguese_lemma VALUES ("n#00598056","n","cadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#02418562","n","cadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#03293673","n","cadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#03294261","n","cadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#03419984","n","cadeira","N");
INSERT INTO portuguese_lemma VALUES ("n#06368526","n","cadeira","N");
INSERT INTO portuguese_lemma VALUES ("v#00598278","v","reaprender","N");
INSERT INTO portuguese_lemma VALUES ("v#00598278","v","aprender_de_novo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00598679","a","controlado","N");
INSERT INTO portuguese_lemma VALUES ("v#00404522","v","informar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00404522","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00488567","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00488684","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00496212","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00622450","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01124979","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01456213","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01467502","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01474694","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#01562485","v","descobrir","N");
INSERT INTO portuguese_lemma VALUES ("v#00404522","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00427776","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00428966","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00465761","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00689809","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00466561","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00466852","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00483900","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00721098","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00734348","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00739340","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#00622132","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01124979","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01474694","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#02212275","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01515833","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01538749","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01562037","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01562485","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01562883","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("v#01838645","v","achar","N");
INSERT INTO portuguese_lemma VALUES ("n#00599064","n","Residência_médica","Y");
INSERT INTO portuguese_lemma VALUES ("a#00599468","a","possuído","N");
INSERT INTO portuguese_lemma VALUES ("a#02074673","a","possuído","N");
INSERT INTO portuguese_lemma VALUES ("n#00393890","n","secretaria","N");
INSERT INTO portuguese_lemma VALUES ("n#06172324","n","secretaria","N");
INSERT INTO portuguese_lemma VALUES ("v#00404997","v","noticiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00832778","v","noticiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00833199","v","noticiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00591857","v","noticiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00874175","v","noticiar","N");
INSERT INTO portuguese_lemma VALUES ("a#00600192","a","anárquico","N");
INSERT INTO portuguese_lemma VALUES ("v#00405557","v","ocupar","N");
INSERT INTO portuguese_lemma VALUES ("v#00764618","v","ocupar","N");
INSERT INTO portuguese_lemma VALUES ("v#01808536","v","ocupar","N");
INSERT INTO portuguese_lemma VALUES ("a#00600395","a","errante","N");
INSERT INTO portuguese_lemma VALUES ("a#00964303","a","errante","N");
INSERT INTO portuguese_lemma VALUES ("v#00600724","v","envolver","N");
INSERT INTO portuguese_lemma VALUES ("v#01582070","v","envolver","N");
INSERT INTO portuguese_lemma VALUES ("v#01089313","v","envolver","N");
INSERT INTO portuguese_lemma VALUES ("v#02677332","v","envolver","N");
INSERT INTO portuguese_lemma VALUES ("v#00405932","v","esgotar","N");
INSERT INTO portuguese_lemma VALUES ("v#00787825","v","esgotar","N");
INSERT INTO portuguese_lemma VALUES ("v#01551588","v","esgotar","N");
INSERT INTO portuguese_lemma VALUES ("v#01558918","v","esgotar","N");
INSERT INTO portuguese_lemma VALUES ("v#00405932","v","consumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00786286","v","consumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00787073","v","consumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00792261","v","consumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00814298","v","consumir","N");
INSERT INTO portuguese_lemma VALUES ("v#01551588","v","consumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00601043","v","focar","N");
INSERT INTO portuguese_lemma VALUES ("v#00489333","v","focar","N");
INSERT INTO portuguese_lemma VALUES ("v#01479663","v","focar","N");
INSERT INTO portuguese_lemma VALUES ("v#00406510","v","engulir","N");
INSERT INTO portuguese_lemma VALUES ("a#00569747","a","controverso","N");
INSERT INTO portuguese_lemma VALUES ("a#00602293","a","controverso","N");
INSERT INTO portuguese_lemma VALUES ("a#00569747","a","polémico","N");
INSERT INTO portuguese_lemma VALUES ("a#00570408","a","polémico","N");
INSERT INTO portuguese_lemma VALUES ("a#00569747","a","polêmico","N");
INSERT INTO portuguese_lemma VALUES ("a#00570408","a","polêmico","N");
INSERT INTO portuguese_lemma VALUES ("v#00406673","v","abraçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00976384","v","abraçar","N");
INSERT INTO portuguese_lemma VALUES ("n#00602026","n","Secretário_de_estado","Y");
INSERT INTO portuguese_lemma VALUES ("n#00602026","n","Secretário_de_Estado","Y");
INSERT INTO portuguese_lemma VALUES ("a#00602293","a","conflituoso","N");
INSERT INTO portuguese_lemma VALUES ("v#00602635","v","trabalhar_como_aprendiz","Y");
INSERT INTO portuguese_lemma VALUES ("a#01848815","a","inquestionável","N");
INSERT INTO portuguese_lemma VALUES ("a#01848815","a","incontestado","N");
INSERT INTO portuguese_lemma VALUES ("n#00603319","n","Secretário_da_Marinha_dos_Estados_Unidos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00604228","n","sinecura","N");
INSERT INTO portuguese_lemma VALUES ("v#00604576","v","saber_de_cor","Y");
INSERT INTO portuguese_lemma VALUES ("v#00604576","v","decorar","N");
INSERT INTO portuguese_lemma VALUES ("v#01005978","v","decorar","N");
INSERT INTO portuguese_lemma VALUES ("v#01150345","v","decorar","N");
INSERT INTO portuguese_lemma VALUES ("v#01679806","v","decorar","N");
INSERT INTO portuguese_lemma VALUES ("v#02749247","v","decorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00604576","v","memorizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00605023","n","trono","N");
INSERT INTO portuguese_lemma VALUES ("n#03499424","n","trono","N");
INSERT INTO portuguese_lemma VALUES ("a#00572361","a","incoveniente","N");
INSERT INTO portuguese_lemma VALUES ("a#00605406","a","bisonho","N");
INSERT INTO portuguese_lemma VALUES ("a#00605406","a","inábil","N");
INSERT INTO portuguese_lemma VALUES ("a#00605406","a","desastrado","N");
INSERT INTO portuguese_lemma VALUES ("a#00572731","a","convencional","N");
INSERT INTO portuguese_lemma VALUES ("a#00574540","a","convencional","N");
INSERT INTO portuguese_lemma VALUES ("a#00577179","a","convencional","N");
INSERT INTO portuguese_lemma VALUES ("a#00577578","a","convencional","N");
INSERT INTO portuguese_lemma VALUES ("a#00991505","a","convencional","N");
INSERT INTO portuguese_lemma VALUES ("a#01630148","a","convencional","N");
INSERT INTO portuguese_lemma VALUES ("a#01910102","a","convencional","N");
INSERT INTO portuguese_lemma VALUES ("a#00572731","a","corriqueiro","N");
INSERT INTO portuguese_lemma VALUES ("v#00605671","v","indoutrinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00605783","v","marrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00410090","v","marrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01612295","v","marrar","N");
INSERT INTO portuguese_lemma VALUES ("a#00605893","a","recebido","N");
INSERT INTO portuguese_lemma VALUES ("v#00409147","v","praticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00565367","v","praticar","N");
INSERT INTO portuguese_lemma VALUES ("v#01746847","v","praticar","N");
INSERT INTO portuguese_lemma VALUES ("v#01751275","v","praticar","N");
INSERT INTO portuguese_lemma VALUES ("n#00399744","n","arte","N");
INSERT INTO portuguese_lemma VALUES ("n#00598038","n","arte","N");
INSERT INTO portuguese_lemma VALUES ("n#02213100","n","arte","N");
INSERT INTO portuguese_lemma VALUES ("n#04360761","n","arte","N");
INSERT INTO portuguese_lemma VALUES ("n#06998748","n","arte","N");
INSERT INTO portuguese_lemma VALUES ("v#00606600","v","inculcar","N");
INSERT INTO portuguese_lemma VALUES ("a#00606602","a","não_usual","Y");
INSERT INTO portuguese_lemma VALUES ("v#00607609","v","diplomar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00607609","v","diplomar","N");
INSERT INTO portuguese_lemma VALUES ("n#00607775","n","Carpintaria","N");
INSERT INTO portuguese_lemma VALUES ("n#00607775","n","marcenaria","N");
INSERT INTO portuguese_lemma VALUES ("v#00410666","v","recordar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00410666","v","recordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00412961","v","recordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00413589","v","recordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00696414","v","recordar","N");
INSERT INTO portuguese_lemma VALUES ("v#00410666","v","lembrar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00410666","v","lembrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00609506","v","lembrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00412253","v","lembrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00413589","v","lembrar","N");
INSERT INTO portuguese_lemma VALUES ("a#00608421","a","não_convencional","Y");
INSERT INTO portuguese_lemma VALUES ("a#00575492","a","alternativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01782779","a","alternativo","N");
INSERT INTO portuguese_lemma VALUES ("a#00575615","a","bizzaro","N");
INSERT INTO portuguese_lemma VALUES ("a#00575615","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00917876","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00918492","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00919283","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00968522","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00920300","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00983540","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00984080","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#01519719","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#02042796","a","estranho","N");
INSERT INTO portuguese_lemma VALUES ("a#00575615","a","bizarro","N");
INSERT INTO portuguese_lemma VALUES ("a#00919283","a","bizarro","N");
INSERT INTO portuguese_lemma VALUES ("a#01519719","a","bizarro","N");
INSERT INTO portuguese_lemma VALUES ("n#00608896","n","alvenaria","N");
INSERT INTO portuguese_lemma VALUES ("n#03725717","n","alvenaria","N");
INSERT INTO portuguese_lemma VALUES ("v#00411760","v","esquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00412665","v","esquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00613018","v","esquecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00416059","v","esquecer","N");
INSERT INTO portuguese_lemma VALUES ("n#00609236","n","pintura","N");
INSERT INTO portuguese_lemma VALUES ("n#00717208","n","pintura","N");
INSERT INTO portuguese_lemma VALUES ("n#00598869","n","pintura","N");
INSERT INTO portuguese_lemma VALUES ("n#02598242","n","pintura","N");
INSERT INTO portuguese_lemma VALUES ("n#03078466","n","pintura","N");
INSERT INTO portuguese_lemma VALUES ("n#03079051","n","pintura","N");
INSERT INTO portuguese_lemma VALUES ("n#03160624","n","pintura","N");
INSERT INTO portuguese_lemma VALUES ("a#00576203","a","próprio_de_alguém","Y");
INSERT INTO portuguese_lemma VALUES ("a#00576203","a","indiossincrático","N");
INSERT INTO portuguese_lemma VALUES ("n#00609669","n","encanamento","N");
INSERT INTO portuguese_lemma VALUES ("n#03969041","n","encanamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00412253","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00426277","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00629738","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00427776","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00465761","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00721098","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00489783","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00734348","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00739082","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00739340","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#01634142","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#01124228","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#01483324","v","pensar","N");
INSERT INTO portuguese_lemma VALUES ("v#00412665","v","esqueça-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00576833","a","atômico","N");
INSERT INTO portuguese_lemma VALUES ("a#02667673","a","atômico","N");
INSERT INTO portuguese_lemma VALUES ("n#00402867","n","literatura","N");
INSERT INTO portuguese_lemma VALUES ("n#06169285","n","literatura","N");
INSERT INTO portuguese_lemma VALUES ("n#04685374","n","literatura","N");
INSERT INTO portuguese_lemma VALUES ("n#06364641","n","literatura","N");
INSERT INTO portuguese_lemma VALUES ("n#06365102","n","literatura","N");
INSERT INTO portuguese_lemma VALUES ("n#06366269","n","literatura","N");
INSERT INTO portuguese_lemma VALUES ("n#04800434","n","literatura","N");
INSERT INTO portuguese_lemma VALUES ("n#00402994","n","Arquitetura","N");
INSERT INTO portuguese_lemma VALUES ("n#00402994","n","Arquitectura","N");
INSERT INTO portuguese_lemma VALUES ("n#00402994","n","arquitectura","N");
INSERT INTO portuguese_lemma VALUES ("n#02206447","n","arquitectura","N");
INSERT INTO portuguese_lemma VALUES ("n#03858780","n","arquitectura","N");
INSERT INTO portuguese_lemma VALUES ("n#04659700","n","arquitectura","N");
INSERT INTO portuguese_lemma VALUES ("v#00610770","v","trazer_de_volta","Y");
INSERT INTO portuguese_lemma VALUES ("v#00610928","v","reclamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00844941","v","reclamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00614225","v","reclamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00910891","v","reclamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00616654","v","reclamar","N");
INSERT INTO portuguese_lemma VALUES ("v#02275365","v","reclamar","N");
INSERT INTO portuguese_lemma VALUES ("a#00577362","a","tradicional","N");
INSERT INTO portuguese_lemma VALUES ("a#01630291","a","tradicional","N");
INSERT INTO portuguese_lemma VALUES ("n#00611143","n","direito","N");
INSERT INTO portuguese_lemma VALUES ("a#01197634","a","direito","N");
INSERT INTO portuguese_lemma VALUES ("a#01959343","a","direito","N");
INSERT INTO portuguese_lemma VALUES ("n#04030305","n","direito","N");
INSERT INTO portuguese_lemma VALUES ("v#00413589","v","relembrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00403367","n","pedagogia","N");
INSERT INTO portuguese_lemma VALUES ("n#00570118","n","pedagogia","N");
INSERT INTO portuguese_lemma VALUES ("v#00611481","v","rememorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00612042","v","rememorar","N");
INSERT INTO portuguese_lemma VALUES ("n#00611674","n","Jornalismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00403663","n","política","N");
INSERT INTO portuguese_lemma VALUES ("a#01743546","a","política","N");
INSERT INTO portuguese_lemma VALUES ("a#02646683","a","política","N");
INSERT INTO portuguese_lemma VALUES ("a#02646845","a","política","N");
INSERT INTO portuguese_lemma VALUES ("n#04536028","n","política","N");
INSERT INTO portuguese_lemma VALUES ("n#04673837","n","política","N");
INSERT INTO portuguese_lemma VALUES ("n#04991678","n","política","N");
INSERT INTO portuguese_lemma VALUES ("n#09971476","n","política","N");
INSERT INTO portuguese_lemma VALUES ("v#00612042","v","comemorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00612612","v","comemorar","N");
INSERT INTO portuguese_lemma VALUES ("a#00612114","a","convergente","N");
INSERT INTO portuguese_lemma VALUES ("n#00403778","n","Incisão","N");
INSERT INTO portuguese_lemma VALUES ("n#00403778","n","prática_da_medicina","Y");
INSERT INTO portuguese_lemma VALUES ("n#00403778","n","Medicina","N");
INSERT INTO portuguese_lemma VALUES ("n#00403778","n","medicina","N");
INSERT INTO portuguese_lemma VALUES ("n#04624523","n","medicina","N");
INSERT INTO portuguese_lemma VALUES ("n#00403778","n","remédio","N");
INSERT INTO portuguese_lemma VALUES ("n#00664110","n","remédio","N");
INSERT INTO portuguese_lemma VALUES ("n#02609065","n","remédio","N");
INSERT INTO portuguese_lemma VALUES ("n#02981307","n","remédio","N");
INSERT INTO portuguese_lemma VALUES ("n#03920989","n","remédio","N");
INSERT INTO portuguese_lemma VALUES ("n#03228145","n","remédio","N");
INSERT INTO portuguese_lemma VALUES ("a#00612652","a","divergente","N");
INSERT INTO portuguese_lemma VALUES ("a#02066662","a","divergente","N");
INSERT INTO portuguese_lemma VALUES ("v#00414743","v","reprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#00559552","v","reprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#01080303","v","reprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#00414743","v","suprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#01327582","v","suprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#01649646","v","suprimir","N");
INSERT INTO portuguese_lemma VALUES ("v#02427334","v","suprimir","N");
INSERT INTO portuguese_lemma VALUES ("n#00613282","n","Medicina_preventiva_e_social","Y");
INSERT INTO portuguese_lemma VALUES ("v#00415168","v","largar_mão","Y");
INSERT INTO portuguese_lemma VALUES ("v#00415168","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("v#00546749","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("v#00734233","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("v#01116447","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("v#00758158","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("v#01117812","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("v#00813880","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("v#01829006","v","desistir","N");
INSERT INTO portuguese_lemma VALUES ("n#00613473","n","medicina_alternativa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00613973","n","teologia","N");
INSERT INTO portuguese_lemma VALUES ("n#06182144","n","teologia","N");
INSERT INTO portuguese_lemma VALUES ("n#06183899","n","teologia","N");
INSERT INTO portuguese_lemma VALUES ("n#00404574","n","escrita","N");
INSERT INTO portuguese_lemma VALUES ("n#04794515","n","escrita","N");
INSERT INTO portuguese_lemma VALUES ("n#00405074","n","Criptografia","N");
INSERT INTO portuguese_lemma VALUES ("n#00405074","n","criptografia","N");
INSERT INTO portuguese_lemma VALUES ("n#00405074","n","programação","N");
INSERT INTO portuguese_lemma VALUES ("n#00928947","n","programação","N");
INSERT INTO portuguese_lemma VALUES ("n#01144355","n","programação","N");
INSERT INTO portuguese_lemma VALUES ("n#04533598","n","programação","N");
INSERT INTO portuguese_lemma VALUES ("a#00580464","a","convincente","N");
INSERT INTO portuguese_lemma VALUES ("v#00614999","v","omitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00416622","v","omitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01467965","v","omitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00614999","v","deixar_passar","Y");
INSERT INTO portuguese_lemma VALUES ("v#00416622","v","deixar_passar","Y");
INSERT INTO portuguese_lemma VALUES ("v#00614999","v","preterir","N");
INSERT INTO portuguese_lemma VALUES ("v#00416622","v","preterir","N");
INSERT INTO portuguese_lemma VALUES ("v#00617293","v","preterir","N");
INSERT INTO portuguese_lemma VALUES ("v#00614999","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("v#01419172","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("v#02073714","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("v#01419809","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("v#01420004","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("v#01420304","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("v#01420490","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("v#02100476","v","escapar","N");
INSERT INTO portuguese_lemma VALUES ("a#00580683","a","credível","N");
INSERT INTO portuguese_lemma VALUES ("a#00580683","a","crível","N");
INSERT INTO portuguese_lemma VALUES ("a#00608243","a","crível","N");
INSERT INTO portuguese_lemma VALUES ("v#00615421","v","elidir","N");
INSERT INTO portuguese_lemma VALUES ("a#00615757","a","cozinhado","N");
INSERT INTO portuguese_lemma VALUES ("n#00405203","n","codificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00651289","n","codificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00405203","n","encriptação","N");
INSERT INTO portuguese_lemma VALUES ("v#00416911","v","descurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00416911","v","negligenciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00616857","v","negligenciar","N");
INSERT INTO portuguese_lemma VALUES ("v#01450453","v","negligenciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00416911","v","desleixar","N");
INSERT INTO portuguese_lemma VALUES ("v#00416911","v","descuidar","N");
INSERT INTO portuguese_lemma VALUES ("n#00616279","n","Compressão_de_imagens","Y");
INSERT INTO portuguese_lemma VALUES ("n#00616398","n","Mpeg","N");
INSERT INTO portuguese_lemma VALUES ("n#00616398","n","MPEG","N");
INSERT INTO portuguese_lemma VALUES ("n#00616398","n","grupo_MPEG","Y");
INSERT INTO portuguese_lemma VALUES ("a#00616408","a","gratinado","N");
INSERT INTO portuguese_lemma VALUES ("v#00417162","v","pular","N");
INSERT INTO portuguese_lemma VALUES ("v#01336773","v","pular","N");
INSERT INTO portuguese_lemma VALUES ("v#01338935","v","pular","N");
INSERT INTO portuguese_lemma VALUES ("a#00616532","a","assado","N");
INSERT INTO portuguese_lemma VALUES ("a#00618377","a","assado","N");
INSERT INTO portuguese_lemma VALUES ("n#00617059","n","descodificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00617059","n","Decifração","N");
INSERT INTO portuguese_lemma VALUES ("a#00617137","a","queimado","N");
INSERT INTO portuguese_lemma VALUES ("a#01264509","a","queimado","N");
INSERT INTO portuguese_lemma VALUES ("n#00617337","n","triangulação","N");
INSERT INTO portuguese_lemma VALUES ("n#06008148","n","triangulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00617692","n","Pirotecnia","N");
INSERT INTO portuguese_lemma VALUES ("n#00617692","n","pirotecnia","N");
INSERT INTO portuguese_lemma VALUES ("n#00617692","n","pirotécnica","N");
INSERT INTO portuguese_lemma VALUES ("a#03106846","a","pirotécnica","N");
INSERT INTO portuguese_lemma VALUES ("v#00417819","v","equivocar","N");
INSERT INTO portuguese_lemma VALUES ("v#00417819","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#00619610","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#00419883","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#00420006","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#00421101","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#01138007","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#01222254","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#01222619","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#01791408","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("v#01791973","v","confundir","N");
INSERT INTO portuguese_lemma VALUES ("n#00617865","n","sapateiro","N");
INSERT INTO portuguese_lemma VALUES ("n#09933098","n","sapateiro","N");
INSERT INTO portuguese_lemma VALUES ("n#00617865","n","sapataria","N");
INSERT INTO portuguese_lemma VALUES ("n#04200800","n","sapataria","N");
INSERT INTO portuguese_lemma VALUES ("v#00418258","v","identificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00418578","v","identificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00439864","v","identificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00483299","v","identificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00694228","v","identificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00618493","a","Saltear","N");
INSERT INTO portuguese_lemma VALUES ("a#00618493","a","saltear","N");
INSERT INTO portuguese_lemma VALUES ("v#01601331","v","saltear","N");
INSERT INTO portuguese_lemma VALUES ("n#00618734","n","Contabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00618734","n","contabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#05662532","n","contabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#13354985","n","contabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#13405962","n","contabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#13929037","n","contabilidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00618734","n","contabilidade_(execução)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00619230","n","contabilidade_(execução)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00619011","n","Contabilidade_de_Custos","Y");
INSERT INTO portuguese_lemma VALUES ("n#00619011","n","Contabilidade_de_custos","Y");
INSERT INTO portuguese_lemma VALUES ("v#00418793","v","datar","N");
INSERT INTO portuguese_lemma VALUES ("v#00498714","v","datar","N");
INSERT INTO portuguese_lemma VALUES ("v#00499117","v","datar","N");
INSERT INTO portuguese_lemma VALUES ("n#00619230","n","escrituração","N");
INSERT INTO portuguese_lemma VALUES ("n#00619230","n","Sistemas_de_Contabilidade","Y");
INSERT INTO portuguese_lemma VALUES ("n#00619230","n","escrituração_contábil","Y");
INSERT INTO portuguese_lemma VALUES ("a#00584005","a","cru","N");
INSERT INTO portuguese_lemma VALUES ("a#00584005","a","crua","N");
INSERT INTO portuguese_lemma VALUES ("v#00419381","v","entender_mal","Y");
INSERT INTO portuguese_lemma VALUES ("v#00419381","v","compreender_mal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00620084","n","FIFO","N");
INSERT INTO portuguese_lemma VALUES ("n#00620084","n","Fifo","N");
INSERT INTO portuguese_lemma VALUES ("n#00408287","n","fotografia","N");
INSERT INTO portuguese_lemma VALUES ("n#00580612","n","fotografia","N");
INSERT INTO portuguese_lemma VALUES ("n#00907919","n","fotografia","N");
INSERT INTO portuguese_lemma VALUES ("n#03113185","n","fotografia","N");
INSERT INTO portuguese_lemma VALUES ("n#03118233","n","fotografia","N");
INSERT INTO portuguese_lemma VALUES ("n#04248607","n","fotografia","N");
INSERT INTO portuguese_lemma VALUES ("n#09674939","n","fotografia","N");
INSERT INTO portuguese_lemma VALUES ("a#00620585","a","não_cooperativo","Y");
INSERT INTO portuguese_lemma VALUES ("a#00620585","a","que_não_coopera","Y");
INSERT INTO portuguese_lemma VALUES ("v#00420006","v","obscurecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00420006","v","obnubilar","N");
INSERT INTO portuguese_lemma VALUES ("a#00620731","a","corrupto","N");
INSERT INTO portuguese_lemma VALUES ("a#02319129","a","corrupto","N");
INSERT INTO portuguese_lemma VALUES ("n#00408411","n","mão-de-obra","N");
INSERT INTO portuguese_lemma VALUES ("n#08212347","n","mão-de-obra","N");
INSERT INTO portuguese_lemma VALUES ("v#00420545","v","elucidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00420545","v","esclarecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00635987","v","esclarecer","N");
INSERT INTO portuguese_lemma VALUES ("a#00621207","a","desonesto","N");
INSERT INTO portuguese_lemma VALUES ("a#00621207","a","venal","N");
INSERT INTO portuguese_lemma VALUES ("a#00621207","a","corruptível","N");
INSERT INTO portuguese_lemma VALUES ("n#00409314","n","empenho","N");
INSERT INTO portuguese_lemma VALUES ("n#03811466","n","empenho","N");
INSERT INTO portuguese_lemma VALUES ("n#00409314","n","esforço","N");
INSERT INTO portuguese_lemma VALUES ("n#00624553","n","esforço","N");
INSERT INTO portuguese_lemma VALUES ("n#00503611","n","esforço","N");
INSERT INTO portuguese_lemma VALUES ("n#00505681","n","esforço","N");
INSERT INTO portuguese_lemma VALUES ("n#00508046","n","esforço","N");
INSERT INTO portuguese_lemma VALUES ("n#00503108","n","esforço","N");
INSERT INTO portuguese_lemma VALUES ("n#00622068","n","grande_esforço","Y");
INSERT INTO portuguese_lemma VALUES ("n#00622068","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00505798","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00789391","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00609840","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00610417","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00619159","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00756240","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00758807","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("n#00759769","n","batalha","N");
INSERT INTO portuguese_lemma VALUES ("v#00622204","v","desmoralizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238101","v","desmoralizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00622384","v","atordoar","N");
INSERT INTO portuguese_lemma VALUES ("n#00410109","n","Caça","N");
INSERT INTO portuguese_lemma VALUES ("a#00622828","a","anti-séptico","N");
INSERT INTO portuguese_lemma VALUES ("a#00622828","a","antisséptico","N");
INSERT INTO portuguese_lemma VALUES ("n#02724207","n","antisséptico","N");
INSERT INTO portuguese_lemma VALUES ("a#00623356","a","sinérgico","N");
INSERT INTO portuguese_lemma VALUES ("a#00623356","a","interativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01946439","a","interativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00623545","n","Escravidão","N");
INSERT INTO portuguese_lemma VALUES ("a#00623814","a","antiácido","N");
INSERT INTO portuguese_lemma VALUES ("n#00411168","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("n#03705476","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("n#04394770","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("n#04395081","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("n#04395690","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("n#10339059","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("n#10339565","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("n#10340761","n","dificuldade","N");
INSERT INTO portuguese_lemma VALUES ("v#00623947","v","espiritualizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00589115","a","considerável","N");
INSERT INTO portuguese_lemma VALUES ("a#00589915","a","considerável","N");
INSERT INTO portuguese_lemma VALUES ("v#00422928","v","ler","N");
INSERT INTO portuguese_lemma VALUES ("v#00423416","v","ler","N");
INSERT INTO portuguese_lemma VALUES ("v#00425047","v","ler","N");
INSERT INTO portuguese_lemma VALUES ("v#00425290","v","ler","N");
INSERT INTO portuguese_lemma VALUES ("v#00624230","v","ler","N");
INSERT INTO portuguese_lemma VALUES ("a#00589915","a","apreciável","N");
INSERT INTO portuguese_lemma VALUES ("n#00411620","n","exercício_fisico","Y");
INSERT INTO portuguese_lemma VALUES ("v#00423896","v","reler","N");
INSERT INTO portuguese_lemma VALUES ("a#00625774","a","insustancial","N");
INSERT INTO portuguese_lemma VALUES ("a#00625774","a","insubstancial","N");
INSERT INTO portuguese_lemma VALUES ("n#00625993","n","fisiculturismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00625993","n","fisioculturismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00625993","n","Fisiculturismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00625993","n","culturismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00626136","a","etéreo","N");
INSERT INTO portuguese_lemma VALUES ("v#00424702","v","proclamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00687592","v","proclamar","N");
INSERT INTO portuguese_lemma VALUES ("n#00626574","n","supino","N");
INSERT INTO portuguese_lemma VALUES ("a#01239781","a","supino","N");
INSERT INTO portuguese_lemma VALUES ("a#00591892","a","material","N");
INSERT INTO portuguese_lemma VALUES ("n#04977814","n","material","N");
INSERT INTO portuguese_lemma VALUES ("v#00424940","v","ditar","N");
INSERT INTO portuguese_lemma VALUES ("v#00506658","v","ditar","N");
INSERT INTO portuguese_lemma VALUES ("v#00507599","v","ditar","N");
INSERT INTO portuguese_lemma VALUES ("a#00592078","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#00592283","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#00832150","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#01518826","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#01717117","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#01710523","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#02391455","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#02392134","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#02594072","a","físico","N");
INSERT INTO portuguese_lemma VALUES ("n#03904884","n","físico","N");
INSERT INTO portuguese_lemma VALUES ("n#07474830","n","físico","N");
INSERT INTO portuguese_lemma VALUES ("a#00627410","a","imaterial","N");
INSERT INTO portuguese_lemma VALUES ("a#00630802","a","imaterial","N");
INSERT INTO portuguese_lemma VALUES ("a#01488066","a","imaterial","N");
INSERT INTO portuguese_lemma VALUES ("v#00425290","v","escanear","N");
INSERT INTO portuguese_lemma VALUES ("v#00627824","v","ler_em_diagonal","Y");
INSERT INTO portuguese_lemma VALUES ("v#00627824","v","ler_superficialmente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00426161","v","ler_fazendo_correções","Y");
INSERT INTO portuguese_lemma VALUES ("n#00628390","n","Cooper","N");
INSERT INTO portuguese_lemma VALUES ("v#00426277","v","raciocínar","N");
INSERT INTO portuguese_lemma VALUES ("v#00426277","v","refletir","N");
INSERT INTO portuguese_lemma VALUES ("v#00427308","v","refletir","N");
INSERT INTO portuguese_lemma VALUES ("v#01462444","v","refletir","N");
INSERT INTO portuguese_lemma VALUES ("v#02136754","v","refletir","N");
INSERT INTO portuguese_lemma VALUES ("v#01462616","v","refletir","N");
INSERT INTO portuguese_lemma VALUES ("v#01890214","v","refletir","N");
INSERT INTO portuguese_lemma VALUES ("v#02766925","v","refletir","N");
INSERT INTO portuguese_lemma VALUES ("n#00628692","n","alongamento","N");
INSERT INTO portuguese_lemma VALUES ("n#02636015","n","alongamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00629257","v","racionalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00629492","v","racionalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00606341","v","racionalizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00414547","n","Flexão","N");
INSERT INTO portuguese_lemma VALUES ("a#00594049","a","corpórea","N");
INSERT INTO portuguese_lemma VALUES ("a#00594049","a","corpóreo","N");
INSERT INTO portuguese_lemma VALUES ("a#01711095","a","corpóreo","N");
INSERT INTO portuguese_lemma VALUES ("a#02524050","a","corpóreo","N");
INSERT INTO portuguese_lemma VALUES ("v#00630026","v","filosofar","N");
INSERT INTO portuguese_lemma VALUES ("n#00630071","n","Agachamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00630268","n","Flexão_de_perna","Y");
INSERT INTO portuguese_lemma VALUES ("a#00594345","a","corporal","N");
INSERT INTO portuguese_lemma VALUES ("v#00427308","v","contemplar","N");
INSERT INTO portuguese_lemma VALUES ("v#00475833","v","contemplar","N");
INSERT INTO portuguese_lemma VALUES ("v#00476424","v","contemplar","N");
INSERT INTO portuguese_lemma VALUES ("v#00711715","v","contemplar","N");
INSERT INTO portuguese_lemma VALUES ("v#01459552","v","contemplar","N");
INSERT INTO portuguese_lemma VALUES ("v#01481912","v","contemplar","N");
INSERT INTO portuguese_lemma VALUES ("a#00630466","a","corporativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01670669","a","corporativo","N");
INSERT INTO portuguese_lemma VALUES ("a#02038355","a","corporativo","N");
INSERT INTO portuguese_lemma VALUES ("a#02984781","a","corporativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00630960","n","Ioga","N");
INSERT INTO portuguese_lemma VALUES ("n#00630960","n","ioga","N");
INSERT INTO portuguese_lemma VALUES ("n#06239361","n","ioga","N");
INSERT INTO portuguese_lemma VALUES ("n#00631168","n","Hata-ioga","N");
INSERT INTO portuguese_lemma VALUES ("n#00631168","n","Hata_ioga","Y");
INSERT INTO portuguese_lemma VALUES ("a#00595155","a","espiritual","N");
INSERT INTO portuguese_lemma VALUES ("a#01978427","a","espiritual","N");
INSERT INTO portuguese_lemma VALUES ("a#02455584","a","espiritual","N");
INSERT INTO portuguese_lemma VALUES ("n#00415881","n","prática","N");
INSERT INTO portuguese_lemma VALUES ("n#00574902","n","prática","N");
INSERT INTO portuguese_lemma VALUES ("a#00595353","a","correto","N");
INSERT INTO portuguese_lemma VALUES ("a#00728191","a","correto","N");
INSERT INTO portuguese_lemma VALUES ("v#00631398","v","teologizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00631712","n","consultas","N");
INSERT INTO portuguese_lemma VALUES ("n#00631712","n","consultoria","N");
INSERT INTO portuguese_lemma VALUES ("n#08073844","n","consultoria","N");
INSERT INTO portuguese_lemma VALUES ("v#00427776","v","supor","N");
INSERT INTO portuguese_lemma VALUES ("v#00428091","v","supor","N");
INSERT INTO portuguese_lemma VALUES ("v#00633443","v","supor","N");
INSERT INTO portuguese_lemma VALUES ("v#00430091","v","supor","N");
INSERT INTO portuguese_lemma VALUES ("v#00620765","v","supor","N");
INSERT INTO portuguese_lemma VALUES ("v#00621026","v","supor","N");
INSERT INTO portuguese_lemma VALUES ("v#01009821","v","supor","N");
INSERT INTO portuguese_lemma VALUES ("a#00595724","a","afinado","N");
INSERT INTO portuguese_lemma VALUES ("n#00631887","n","cosmetologia","N");
INSERT INTO portuguese_lemma VALUES ("v#00428091","v","pressupor","N");
INSERT INTO portuguese_lemma VALUES ("v#00484801","v","pressupor","N");
INSERT INTO portuguese_lemma VALUES ("v#00484968","v","pressupor","N");
INSERT INTO portuguese_lemma VALUES ("v#00428091","v","presumir","N");
INSERT INTO portuguese_lemma VALUES ("v#00550404","v","presumir","N");
INSERT INTO portuguese_lemma VALUES ("n#00632342","n","Medicina_familiar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00596241","a","incorreto","N");
INSERT INTO portuguese_lemma VALUES ("a#01808627","a","incorreto","N");
INSERT INTO portuguese_lemma VALUES ("v#00428321","v","raciocinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00633265","v","raciocinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00632716","n","Optometria","N");
INSERT INTO portuguese_lemma VALUES ("n#00632716","n","optometria","N");
INSERT INTO portuguese_lemma VALUES ("v#00632931","v","teorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00633094","v","teorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00633443","v","teorizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00596698","a","errôneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00596698","a","erróneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00633084","a","falaz","N");
INSERT INTO portuguese_lemma VALUES ("n#00633108","n","empirismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00635699","n","empirismo","N");
INSERT INTO portuguese_lemma VALUES ("n#05970311","n","empirismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00633329","n","diligência","N");
INSERT INTO portuguese_lemma VALUES ("n#04297098","n","diligência","N");
INSERT INTO portuguese_lemma VALUES ("n#04673006","n","diligência","N");
INSERT INTO portuguese_lemma VALUES ("n#04865114","n","diligência","N");
INSERT INTO portuguese_lemma VALUES ("n#00416938","n","investigação","N");
INSERT INTO portuguese_lemma VALUES ("n#00418126","n","investigação","N");
INSERT INTO portuguese_lemma VALUES ("n#00604772","n","investigação","N");
INSERT INTO portuguese_lemma VALUES ("n#04467719","n","investigação","N");
INSERT INTO portuguese_lemma VALUES ("n#04470360","n","investigação","N");
INSERT INTO portuguese_lemma VALUES ("n#00422134","n","análise","N");
INSERT INTO portuguese_lemma VALUES ("n#04451818","n","análise","N");
INSERT INTO portuguese_lemma VALUES ("n#04604475","n","análise","N");
INSERT INTO portuguese_lemma VALUES ("v#00428966","v","chegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00444338","v","chegar","N");
INSERT INTO portuguese_lemma VALUES ("v#01368651","v","chegar","N");
INSERT INTO portuguese_lemma VALUES ("v#01375966","v","chegar","N");
INSERT INTO portuguese_lemma VALUES ("v#01379952","v","chegar","N");
INSERT INTO portuguese_lemma VALUES ("v#00428966","v","deduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00430461","v","deduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00432991","v","deduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00944924","v","deduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00691426","v","deduzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00428966","v","decidir","N");
INSERT INTO portuguese_lemma VALUES ("v#00471542","v","decidir","N");
INSERT INTO portuguese_lemma VALUES ("v#00472610","v","decidir","N");
INSERT INTO portuguese_lemma VALUES ("v#00472976","v","decidir","N");
INSERT INTO portuguese_lemma VALUES ("v#00518436","v","decidir","N");
INSERT INTO portuguese_lemma VALUES ("n#00426345","n","enumeração","N");
INSERT INTO portuguese_lemma VALUES ("n#06490887","n","enumeração","N");
INSERT INTO portuguese_lemma VALUES ("n#00426345","n","contar","N");
INSERT INTO portuguese_lemma VALUES ("v#00641935","v","contar","N");
INSERT INTO portuguese_lemma VALUES ("v#00642112","v","contar","N");
INSERT INTO portuguese_lemma VALUES ("v#00644776","v","contar","N");
INSERT INTO portuguese_lemma VALUES ("v#00645379","v","contar","N");
INSERT INTO portuguese_lemma VALUES ("v#00682542","v","contar","N");
INSERT INTO portuguese_lemma VALUES ("v#01549722","v","contar","N");
INSERT INTO portuguese_lemma VALUES ("v#02683489","v","contar","N");
INSERT INTO portuguese_lemma VALUES ("a#00634862","a","corrigível","N");
INSERT INTO portuguese_lemma VALUES ("v#00429256","v","solucionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00635456","a","incorrigível","N");
INSERT INTO portuguese_lemma VALUES ("v#00635523","v","responder","N");
INSERT INTO portuguese_lemma VALUES ("v#00430222","v","responder","N");
INSERT INTO portuguese_lemma VALUES ("v#00485595","v","responder","N");
INSERT INTO portuguese_lemma VALUES ("v#00718308","v","responder","N");
INSERT INTO portuguese_lemma VALUES ("v#00718737","v","responder","N");
INSERT INTO portuguese_lemma VALUES ("v#00487007","v","responder","N");
INSERT INTO portuguese_lemma VALUES ("v#00554194","v","responder","N");
INSERT INTO portuguese_lemma VALUES ("n#00419850","n","examinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00435242","v","examinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00436525","v","examinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00697419","v","examinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535682","v","examinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01460594","v","examinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01458506","v","examinar","N");
INSERT INTO portuguese_lemma VALUES ("v#02152812","v","examinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00419850","n","inspecionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00697062","v","inspecionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01259471","v","inspecionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01458506","v","inspecionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01482454","v","inspecionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01664310","v","inspecionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00635955","a","cosmopolita","N");
INSERT INTO portuguese_lemma VALUES ("a#01106614","a","cosmopolita","N");
INSERT INTO portuguese_lemma VALUES ("n#09967406","n","cosmopolita","N");
INSERT INTO portuguese_lemma VALUES ("a#00636391","a","viajado","N");
INSERT INTO portuguese_lemma VALUES ("a#02454206","a","viajado","N");
INSERT INTO portuguese_lemma VALUES ("v#00430365","v","induzir","N");
INSERT INTO portuguese_lemma VALUES ("v#00523422","v","induzir","N");
INSERT INTO portuguese_lemma VALUES ("v#02384554","v","induzir","N");
INSERT INTO portuguese_lemma VALUES ("n#00417674","n","examinação","N");
INSERT INTO portuguese_lemma VALUES ("n#00417674","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00639975","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00644702","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00507777","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00508046","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00794614","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00508441","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00564770","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00649604","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#00657820","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#04429650","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#04468129","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#05378329","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("n#05379363","n","teste","N");
INSERT INTO portuguese_lemma VALUES ("a#00636547","a","provincial","N");
INSERT INTO portuguese_lemma VALUES ("a#02597243","a","provincial","N");
INSERT INTO portuguese_lemma VALUES ("v#00430461","v","depreender","N");
INSERT INTO portuguese_lemma VALUES ("n#00418126","n","inquérito","N");
INSERT INTO portuguese_lemma VALUES ("n#00637354","n","inquérito","N");
INSERT INTO portuguese_lemma VALUES ("n#04467719","n","inquérito","N");
INSERT INTO portuguese_lemma VALUES ("n#04470360","n","inquérito","N");
INSERT INTO portuguese_lemma VALUES ("n#07193184","n","inquérito","N");
INSERT INTO portuguese_lemma VALUES ("n#05376578","n","inquérito","N");
INSERT INTO portuguese_lemma VALUES ("n#00418126","n","questionamento","N");
INSERT INTO portuguese_lemma VALUES ("v#00430666","v","basear","N");
INSERT INTO portuguese_lemma VALUES ("v#00430666","v","fundamentar","N");
INSERT INTO portuguese_lemma VALUES ("n#00417296","n","pesquisa","N");
INSERT INTO portuguese_lemma VALUES ("n#00604772","n","pesquisa","N");
INSERT INTO portuguese_lemma VALUES ("n#04467719","n","pesquisa","N");
INSERT INTO portuguese_lemma VALUES ("n#04470360","n","pesquisa","N");
INSERT INTO portuguese_lemma VALUES ("n#05800998","n","pesquisa","N");
INSERT INTO portuguese_lemma VALUES ("v#00637115","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#00665476","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01111638","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01114991","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01117358","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01135342","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01136484","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01655505","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01140839","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#01739099","v","construir","N");
INSERT INTO portuguese_lemma VALUES ("v#00430966","v","calcular","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","calcular","N");
INSERT INTO portuguese_lemma VALUES ("v#00626821","v","calcular","N");
INSERT INTO portuguese_lemma VALUES ("v#00430966","v","computar","N");
INSERT INTO portuguese_lemma VALUES ("v#01549722","v","computar","N");
INSERT INTO portuguese_lemma VALUES ("a#00601207","a","paroquial","N");
INSERT INTO portuguese_lemma VALUES ("a#02871695","a","paroquial","N");
INSERT INTO portuguese_lemma VALUES ("n#00637546","n","investigação_operacional","Y");
INSERT INTO portuguese_lemma VALUES ("a#00637857","a","laxativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00638243","n","clonagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00638243","n","Clonagem","N");
INSERT INTO portuguese_lemma VALUES ("a#00638253","a","constipado","N");
INSERT INTO portuguese_lemma VALUES ("v#00431606","v","processar","N");
INSERT INTO portuguese_lemma VALUES ("v#01660593","v","processar","N");
INSERT INTO portuguese_lemma VALUES ("a#00639356","a","inconsiderado","N");
INSERT INTO portuguese_lemma VALUES ("a#02420757","a","inconsiderado","N");
INSERT INTO portuguese_lemma VALUES ("n#00418704","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#00639975","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#00503375","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#04921417","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#04441868","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#04468129","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#04469208","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#04589992","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#05434281","n","experiência","N");
INSERT INTO portuguese_lemma VALUES ("n#00418704","n","experimento","N");
INSERT INTO portuguese_lemma VALUES ("n#04468129","n","experimento","N");
INSERT INTO portuguese_lemma VALUES ("v#00639693","v","recalcular","N");
INSERT INTO portuguese_lemma VALUES ("a#00639842","a","cortês","N");
INSERT INTO portuguese_lemma VALUES ("a#00641343","a","cortês","N");
INSERT INTO portuguese_lemma VALUES ("a#00641460","a","cortês","N");
INSERT INTO portuguese_lemma VALUES ("a#00606022","a","cortês","N");
INSERT INTO portuguese_lemma VALUES ("a#02161503","a","cortês","N");
INSERT INTO portuguese_lemma VALUES ("n#00640188","n","pesquisa_de_mercado","Y");
INSERT INTO portuguese_lemma VALUES ("v#00640262","v","elevar_ao_cubo","Y");
INSERT INTO portuguese_lemma VALUES ("v#00640262","v","cubar","N");
INSERT INTO portuguese_lemma VALUES ("v#00640650","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00689809","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00466313","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00466561","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00466852","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00691312","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00468967","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00711715","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00497921","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00552303","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#01210323","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("v#01483324","v","considerar","N");
INSERT INTO portuguese_lemma VALUES ("a#00604516","a","brusco","N");
INSERT INTO portuguese_lemma VALUES ("a#01094377","a","brusco","N");
INSERT INTO portuguese_lemma VALUES ("a#01095581","a","brusco","N");
INSERT INTO portuguese_lemma VALUES ("a#00604516","a","brusca","N");
INSERT INTO portuguese_lemma VALUES ("n#00640889","n","Microscopia","N");
INSERT INTO portuguese_lemma VALUES ("n#00640889","n","microscopia","N");
INSERT INTO portuguese_lemma VALUES ("n#00641109","n","microscópio_eletrônico","Y");
INSERT INTO portuguese_lemma VALUES ("n#03279508","n","microscópio_eletrônico","Y");
INSERT INTO portuguese_lemma VALUES ("a#00641158","a","gentil","N");
INSERT INTO portuguese_lemma VALUES ("a#00641460","a","gentil","N");
INSERT INTO portuguese_lemma VALUES ("a#01133876","a","gentil","N");
INSERT INTO portuguese_lemma VALUES ("a#01879678","a","gentil","N");
INSERT INTO portuguese_lemma VALUES ("v#00432991","v","subtrair","N");
INSERT INTO portuguese_lemma VALUES ("a#00641640","a","indelicado","N");
INSERT INTO portuguese_lemma VALUES ("a#00641640","a","impolido","N");
INSERT INTO portuguese_lemma VALUES ("n#00641693","n","Projeto_genoma_humano","Y");
INSERT INTO portuguese_lemma VALUES ("n#00641693","n","Projeto_Genoma_Humano","Y");
INSERT INTO portuguese_lemma VALUES ("n#00641820","n","investigação_científica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00641820","n","projectos_de_investigação","Y");
INSERT INTO portuguese_lemma VALUES ("a#00641944","a","descortês","N");
INSERT INTO portuguese_lemma VALUES ("a#00642152","a","descortês","N");
INSERT INTO portuguese_lemma VALUES ("a#00641944","a","malcriado","N");
INSERT INTO portuguese_lemma VALUES ("a#00641944","a","malcomportado","N");
INSERT INTO portuguese_lemma VALUES ("a#00641944","a","mal-educado","N");
INSERT INTO portuguese_lemma VALUES ("a#00641944","a","grosseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00606314","a","grosseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#01881881","a","grosseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#01882256","a","grosseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#01882384","a","grosseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00641944","a","rude","N");
INSERT INTO portuguese_lemma VALUES ("a#01881881","a","rude","N");
INSERT INTO portuguese_lemma VALUES ("n#00642045","n","Endoscopia","N");
INSERT INTO portuguese_lemma VALUES ("n#00642045","n","endoscopia","N");
INSERT INTO portuguese_lemma VALUES ("a#00606022","a","polido","N");
INSERT INTO portuguese_lemma VALUES ("a#01005306","a","polido","N");
INSERT INTO portuguese_lemma VALUES ("a#02161503","a","polido","N");
INSERT INTO portuguese_lemma VALUES ("a#00606022","a","educado","N");
INSERT INTO portuguese_lemma VALUES ("a#02161503","a","educado","N");
INSERT INTO portuguese_lemma VALUES ("n#00642446","n","Colonoscopia","N");
INSERT INTO portuguese_lemma VALUES ("n#00642446","n","colonoscopia","N");
INSERT INTO portuguese_lemma VALUES ("v#00434448","v","analisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00434651","v","analisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00643910","v","analisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00499778","v","analisar","N");
INSERT INTO portuguese_lemma VALUES ("n#00643208","n","Sigmoidoscopia","N");
INSERT INTO portuguese_lemma VALUES ("a#01796235","a","criador","N");
INSERT INTO portuguese_lemma VALUES ("n#06944789","n","criador","N");
INSERT INTO portuguese_lemma VALUES ("n#09873899","n","criador","N");
INSERT INTO portuguese_lemma VALUES ("n#00643772","n","rinoscopia","N");
INSERT INTO portuguese_lemma VALUES ("a#00607344","a","imaginativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00643910","v","decompor","N");
INSERT INTO portuguese_lemma VALUES ("v#00499778","v","decompor","N");
INSERT INTO portuguese_lemma VALUES ("v#00643910","v","analizar_sintaticamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00435117","v","sintetizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00644430","v","sintetizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00681575","v","sintetizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00435242","v","analizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535831","v","analizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00608243","a","acreditável","N");
INSERT INTO portuguese_lemma VALUES ("n#00644967","n","selecção_(processos_físicos)","Y");
INSERT INTO portuguese_lemma VALUES ("a#00608804","a","incríveis","N");
INSERT INTO portuguese_lemma VALUES ("a#00608804","a","inacreditável","N");
INSERT INTO portuguese_lemma VALUES ("a#00608804","a","inacreditáveis","N");
INSERT INTO portuguese_lemma VALUES ("a#00608804","a","incrível","N");
INSERT INTO portuguese_lemma VALUES ("a#02301236","a","incrível","N");
INSERT INTO portuguese_lemma VALUES ("v#00645552","v","diagnosticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00645771","v","diagnosticar","N");
INSERT INTO portuguese_lemma VALUES ("a#00609131","a","estarrecedor","N");
INSERT INTO portuguese_lemma VALUES ("v#00436180","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00436444","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00437696","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00438083","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00594188","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00790940","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("v#01163620","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("v#00791942","v","explorar","N");
INSERT INTO portuguese_lemma VALUES ("a#00609374","a","improvável","N");
INSERT INTO portuguese_lemma VALUES ("a#01412415","a","improvável","N");
INSERT INTO portuguese_lemma VALUES ("a#01357397","a","improvável","N");
INSERT INTO portuguese_lemma VALUES ("a#01800169","a","improvável","N");
INSERT INTO portuguese_lemma VALUES ("n#00646187","n","anatomia","N");
INSERT INTO portuguese_lemma VALUES ("n#04055717","n","anatomia","N");
INSERT INTO portuguese_lemma VALUES ("n#06057539","n","anatomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00646332","n","uranálise","N");
INSERT INTO portuguese_lemma VALUES ("n#00646332","n","elementos_anormais_e_sedimentos_(EAS)","Y");
INSERT INTO portuguese_lemma VALUES ("n#00646332","n","exame_sumário_de_urina","Y");
INSERT INTO portuguese_lemma VALUES ("n#00646332","n","urinálise","N");
INSERT INTO portuguese_lemma VALUES ("n#00646504","n","escatologia","N");
INSERT INTO portuguese_lemma VALUES ("n#07124928","n","escatologia","N");
INSERT INTO portuguese_lemma VALUES ("n#00646504","n","Coprologia","N");
INSERT INTO portuguese_lemma VALUES ("n#00646680","n","caso_estudo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00646833","n","análises_químicas","Y");
INSERT INTO portuguese_lemma VALUES ("v#00436897","v","medir","N");
INSERT INTO portuguese_lemma VALUES ("a#00610425","a","céptico","N");
INSERT INTO portuguese_lemma VALUES ("a#02345143","a","céptico","N");
INSERT INTO portuguese_lemma VALUES ("a#00610425","a","cético","N");
INSERT INTO portuguese_lemma VALUES ("a#02345143","a","cético","N");
INSERT INTO portuguese_lemma VALUES ("n#10604634","n","cético","N");
INSERT INTO portuguese_lemma VALUES ("n#00647270","n","análise_qualitativa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00647536","n","colorimetria","N");
INSERT INTO portuguese_lemma VALUES ("a#00610721","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00612746","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00613646","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00614865","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00618913","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00619212","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#02865172","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#02830645","a","crítico","N");
INSERT INTO portuguese_lemma VALUES ("n#09979072","n","crítico","N");
INSERT INTO portuguese_lemma VALUES ("n#07194134","n","crítico","N");
INSERT INTO portuguese_lemma VALUES ("n#07194366","n","crítico","N");
INSERT INTO portuguese_lemma VALUES ("a#00648089","a","chicaneiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00648089","a","trapaceiro","N");
INSERT INTO portuguese_lemma VALUES ("n#09998101","n","trapaceiro","N");
INSERT INTO portuguese_lemma VALUES ("v#00437696","v","pesquisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00438083","v","pesquisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535682","v","pesquisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535831","v","pesquisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00594188","v","pesquisar","N");
INSERT INTO portuguese_lemma VALUES ("v#00437696","v","buscar","N");
INSERT INTO portuguese_lemma VALUES ("v#00438083","v","buscar","N");
INSERT INTO portuguese_lemma VALUES ("v#00594188","v","buscar","N");
INSERT INTO portuguese_lemma VALUES ("n#00604336","n","buscar","N");
INSERT INTO portuguese_lemma VALUES ("v#00898737","v","buscar","N");
INSERT INTO portuguese_lemma VALUES ("v#00899903","v","buscar","N");
INSERT INTO portuguese_lemma VALUES ("v#01332965","v","buscar","N");
INSERT INTO portuguese_lemma VALUES ("v#00437696","v","investigar","N");
INSERT INTO portuguese_lemma VALUES ("v#00438083","v","investigar","N");
INSERT INTO portuguese_lemma VALUES ("v#00534018","v","investigar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535682","v","investigar","N");
INSERT INTO portuguese_lemma VALUES ("v#00594188","v","investigar","N");
INSERT INTO portuguese_lemma VALUES ("v#00437696","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("n#00604336","n","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00848754","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00898737","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#01317064","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00899749","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00899903","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#01474374","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#01533628","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#02240881","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("v#01725008","v","procurar","N");
INSERT INTO portuguese_lemma VALUES ("n#00423641","n","Titulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00423641","n","titulação","N");
INSERT INTO portuguese_lemma VALUES ("n#05038823","n","titulação","N");
INSERT INTO portuguese_lemma VALUES ("v#00648764","v","guglar","N");
INSERT INTO portuguese_lemma VALUES ("v#00648764","v","googlar","N");
INSERT INTO portuguese_lemma VALUES ("n#00649090","n","análise_fundamentalista","Y");
INSERT INTO portuguese_lemma VALUES ("v#00649245","v","re-explorar","N");
INSERT INTO portuguese_lemma VALUES ("n#00649266","n","Análise_Técnica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00649266","n","análise_técnica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00649482","n","espectroscopia","N");
INSERT INTO portuguese_lemma VALUES ("n#00649760","n","diálise","N");
INSERT INTO portuguese_lemma VALUES ("n#00650543","n","diálise","N");
INSERT INTO portuguese_lemma VALUES ("v#00650016","v","discriminar","N");
INSERT INTO portuguese_lemma VALUES ("v#02193765","v","discriminar","N");
INSERT INTO portuguese_lemma VALUES ("v#02512305","v","discriminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00650016","v","diferenciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00439665","v","diferenciar","N");
INSERT INTO portuguese_lemma VALUES ("v#00650016","v","distinguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00438616","v","distinguir","N");
INSERT INTO portuguese_lemma VALUES ("n#00650543","n","Hemodialise","N");
INSERT INTO portuguese_lemma VALUES ("n#00650543","n","hemodiálise","N");
INSERT INTO portuguese_lemma VALUES ("a#00614072","a","grave","N");
INSERT INTO portuguese_lemma VALUES ("a#00654166","a","grave","N");
INSERT INTO portuguese_lemma VALUES ("a#02044251","a","grave","N");
INSERT INTO portuguese_lemma VALUES ("a#00614072","a","perigosa","N");
INSERT INTO portuguese_lemma VALUES ("a#02059811","a","perigosa","N");
INSERT INTO portuguese_lemma VALUES ("a#01983358","a","perigosa","N");
INSERT INTO portuguese_lemma VALUES ("n#00651176","n","Analogia","N");
INSERT INTO portuguese_lemma VALUES ("n#00651176","n","analogia","N");
INSERT INTO portuguese_lemma VALUES ("n#05780339","n","analogia","N");
INSERT INTO portuguese_lemma VALUES ("a#00614381","a","adoentado","N");
INSERT INTO portuguese_lemma VALUES ("a#01172889","a","adoentado","N");
INSERT INTO portuguese_lemma VALUES ("n#00425999","n","visita_de_inspeção","Y");
INSERT INTO portuguese_lemma VALUES ("n#00428474","n","vigilância","N");
INSERT INTO portuguese_lemma VALUES ("n#03676672","n","vigilância","N");
INSERT INTO portuguese_lemma VALUES ("n#00428474","n","vigilângia","N");
INSERT INTO portuguese_lemma VALUES ("v#00652622","v","catalogar","N");
INSERT INTO portuguese_lemma VALUES ("v#01626844","v","catalogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00440138","v","comparar","N");
INSERT INTO portuguese_lemma VALUES ("v#02729632","v","comparar","N");
INSERT INTO portuguese_lemma VALUES ("n#00652975","n","Hemograma_completo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00652975","n","Hemograma","N");
INSERT INTO portuguese_lemma VALUES ("n#00427077","n","recenseamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00427077","n","censo","N");
INSERT INTO portuguese_lemma VALUES ("n#00427077","n","Censo_demográfico","Y");
INSERT INTO portuguese_lemma VALUES ("n#00653518","n","contagem_regressiva","Y");
INSERT INTO portuguese_lemma VALUES ("n#00653518","n","retrocontagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00653811","n","_contagem","Y");
INSERT INTO portuguese_lemma VALUES ("n#00653958","n","recontagem","N");
INSERT INTO portuguese_lemma VALUES ("v#00654258","v","reconsiderar","N");
INSERT INTO portuguese_lemma VALUES ("n#00654563","n","espionagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00654563","n","Espionagem","N");
INSERT INTO portuguese_lemma VALUES ("v#00441099","v","classificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00442641","v","classificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00443221","v","classificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01029852","v","classificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01710005","v","classificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01798079","v","classificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00428745","n","assintência","N");
INSERT INTO portuguese_lemma VALUES ("n#00428745","n","cuidado","N");
INSERT INTO portuguese_lemma VALUES ("n#00531481","n","cuidado","N");
INSERT INTO portuguese_lemma VALUES ("n#01059900","n","cuidado","N");
INSERT INTO portuguese_lemma VALUES ("n#00787413","n","cuidado","N");
INSERT INTO portuguese_lemma VALUES ("a#00655136","a","coroado","N");
INSERT INTO portuguese_lemma VALUES ("v#00655555","v","referir","N");
INSERT INTO portuguese_lemma VALUES ("v#00494966","v","referir","N");
INSERT INTO portuguese_lemma VALUES ("v#01329795","v","referir","N");
INSERT INTO portuguese_lemma VALUES ("v#01825574","v","referir","N");
INSERT INTO portuguese_lemma VALUES ("a#00618913","a","crucial","N");
INSERT INTO portuguese_lemma VALUES ("a#01223960","a","crucial","N");
INSERT INTO portuguese_lemma VALUES ("a#01426469","a","crucial","N");
INSERT INTO portuguese_lemma VALUES ("v#00655792","v","reclassificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00656107","v","dicotomizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00619212","a","fundamental","N");
INSERT INTO portuguese_lemma VALUES ("a#00856572","a","fundamental","N");
INSERT INTO portuguese_lemma VALUES ("a#01224859","a","fundamental","N");
INSERT INTO portuguese_lemma VALUES ("a#01784854","a","fundamental","N");
INSERT INTO portuguese_lemma VALUES ("a#02237849","a","fundamental","N");
INSERT INTO portuguese_lemma VALUES ("v#00656292","v","estereotipar","N");
INSERT INTO portuguese_lemma VALUES ("n#00656524","n","primeiros_socorros","Y");
INSERT INTO portuguese_lemma VALUES ("n#00656524","n","Primeiros_socorros","Y");
INSERT INTO portuguese_lemma VALUES ("v#00442337","v","agrupar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00442337","v","agrupar","N");
INSERT INTO portuguese_lemma VALUES ("a#00619729","a","formalizado","N");
INSERT INTO portuguese_lemma VALUES ("a#00619729","a","formalizada","N");
INSERT INTO portuguese_lemma VALUES ("a#00657198","a","tridimensional","N");
INSERT INTO portuguese_lemma VALUES ("a#00660809","a","tridimensional","N");
INSERT INTO portuguese_lemma VALUES ("a#00657198","a","cúbico","N");
INSERT INTO portuguese_lemma VALUES ("a#00657804","a","cúbico","N");
INSERT INTO portuguese_lemma VALUES ("v#00657260","v","categorizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00657604","n","cuidados_médicos","Y");
INSERT INTO portuguese_lemma VALUES ("a#00657804","a","cubóide","N");
INSERT INTO portuguese_lemma VALUES ("a#00658022","a","isométrico","N");
INSERT INTO portuguese_lemma VALUES ("v#00443221","v","ranquiar","N");
INSERT INTO portuguese_lemma VALUES ("n#00430183","n","tratamento","N");
INSERT INTO portuguese_lemma VALUES ("n#01059900","n","tratamento","N");
INSERT INTO portuguese_lemma VALUES ("n#00735486","n","tratamento","N");
INSERT INTO portuguese_lemma VALUES ("n#03857483","n","tratamento","N");
INSERT INTO portuguese_lemma VALUES ("a#00658259","a","unidimensional","N");
INSERT INTO portuguese_lemma VALUES ("a#00659715","a","unidimensional","N");
INSERT INTO portuguese_lemma VALUES ("n#00658627","n","hospitalização","N");
INSERT INTO portuguese_lemma VALUES ("a#00658680","a","linear","N");
INSERT INTO portuguese_lemma VALUES ("a#00658752","a","rectilíneo","N");
INSERT INTO portuguese_lemma VALUES ("a#00658942","a","bidimensional","N");
INSERT INTO portuguese_lemma VALUES ("n#00659048","n","massagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00659048","n","Massagem","N");
INSERT INTO portuguese_lemma VALUES ("a#00659530","a","alisado","N");
INSERT INTO portuguese_lemma VALUES ("v#00444338","v","classificar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00659946","n","Reflexoterapia","N");
INSERT INTO portuguese_lemma VALUES ("a#00660019","a","multidimensional","N");
INSERT INTO portuguese_lemma VALUES ("v#00660102","v","posicionar-se","N");
INSERT INTO portuguese_lemma VALUES ("a#00660313","a","dimensional","N");
INSERT INTO portuguese_lemma VALUES ("a#02985102","a","dimensional","N");
INSERT INTO portuguese_lemma VALUES ("v#00660381","v","priorizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00660783","n","manicuro","N");
INSERT INTO portuguese_lemma VALUES ("n#00660783","n","Manicuro","N");
INSERT INTO portuguese_lemma VALUES ("a#00660809","a","Imagem_3D","Y");
INSERT INTO portuguese_lemma VALUES ("a#00660809","a","Imagem_3d","Y");
INSERT INTO portuguese_lemma VALUES ("n#00660957","n","Pedicuro","N");
INSERT INTO portuguese_lemma VALUES ("v#00445269","v","valorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#01605484","v","valorizar","N");
INSERT INTO portuguese_lemma VALUES ("v#00445269","v","avaliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00459984","v","avaliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00682230","v","avaliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00470089","v","avaliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","avaliar","N");
INSERT INTO portuguese_lemma VALUES ("v#01578016","v","avaliar","N");
INSERT INTO portuguese_lemma VALUES ("v#01605484","v","avaliar","N");
INSERT INTO portuguese_lemma VALUES ("v#00445269","v","taxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00470089","v","taxar","N");
INSERT INTO portuguese_lemma VALUES ("v#00844161","v","taxar","N");
INSERT INTO portuguese_lemma VALUES ("v#01577503","v","taxar","N");
INSERT INTO portuguese_lemma VALUES ("n#00661091","n","Terapias","N");
INSERT INTO portuguese_lemma VALUES ("n#00661091","n","terapia","N");
INSERT INTO portuguese_lemma VALUES ("n#03228145","n","terapia","N");
INSERT INTO portuguese_lemma VALUES ("v#00445388","v","aferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00445388","v","contrastar","N");
INSERT INTO portuguese_lemma VALUES ("v#01875649","v","contrastar","N");
INSERT INTO portuguese_lemma VALUES ("v#00445764","v","conferir","N");
INSERT INTO portuguese_lemma VALUES ("v#01548251","v","conferir","N");
INSERT INTO portuguese_lemma VALUES ("v#00445764","v","checar","N");
INSERT INTO portuguese_lemma VALUES ("a#00662139","a","Furador","N");
INSERT INTO portuguese_lemma VALUES ("v#00446050","v","verificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00446362","v","verificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00448015","v","verificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01718539","v","verificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00662196","n","aromaterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#00662196","n","Aromaterapia","N");
INSERT INTO portuguese_lemma VALUES ("a#00624789","a","cortado","N");
INSERT INTO portuguese_lemma VALUES ("a#00625738","a","cortado","N");
INSERT INTO portuguese_lemma VALUES ("n#00662340","n","quimioterapia","N");
INSERT INTO portuguese_lemma VALUES ("v#00446362","v","assegurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00603511","v","assegurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00664276","v","autenticar","N");
INSERT INTO portuguese_lemma VALUES ("a#00627092","a","curioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00879259","a","curioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00919283","a","curioso","N");
INSERT INTO portuguese_lemma VALUES ("a#01288978","a","curioso","N");
INSERT INTO portuguese_lemma VALUES ("n#00664577","n","terapia_ocupacional","Y");
INSERT INTO portuguese_lemma VALUES ("n#00664577","n","Terapia_Ocupacional","Y");
INSERT INTO portuguese_lemma VALUES ("v#00448230","v","validar","N");
INSERT INTO portuguese_lemma VALUES ("v#00667224","v","validar","N");
INSERT INTO portuguese_lemma VALUES ("v#00448230","v","demonstrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01471335","v","demonstrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01470807","v","demonstrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00664849","n","alimentação","N");
INSERT INTO portuguese_lemma VALUES ("n#00684853","n","alimentação","N");
INSERT INTO portuguese_lemma VALUES ("n#05625967","n","alimentação","N");
INSERT INTO portuguese_lemma VALUES ("n#00664849","n","nutrição","N");
INSERT INTO portuguese_lemma VALUES ("n#05625967","n","nutrição","N");
INSERT INTO portuguese_lemma VALUES ("n#13523661","n","nutrição","N");
INSERT INTO portuguese_lemma VALUES ("v#00665476","v","por","N");
INSERT INTO portuguese_lemma VALUES ("v#00665476","v","deitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01063016","v","deitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00665476","v","delinear","N");
INSERT INTO portuguese_lemma VALUES ("v#00989084","v","delinear","N");
INSERT INTO portuguese_lemma VALUES ("v#01089750","v","delinear","N");
INSERT INTO portuguese_lemma VALUES ("v#01689379","v","delinear","N");
INSERT INTO portuguese_lemma VALUES ("v#01697628","v","delinear","N");
INSERT INTO portuguese_lemma VALUES ("v#01873293","v","delinear","N");
INSERT INTO portuguese_lemma VALUES ("v#00449036","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#00449252","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#01471335","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#00686544","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#00813161","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#01718539","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#02532886","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#01797447","v","provar","N");
INSERT INTO portuguese_lemma VALUES ("v#00449252","v","constatar","N");
INSERT INTO portuguese_lemma VALUES ("v#00449252","v","corroborar","N");
INSERT INTO portuguese_lemma VALUES ("a#00628521","a","atual","N");
INSERT INTO portuguese_lemma VALUES ("a#00629037","a","atual","N");
INSERT INTO portuguese_lemma VALUES ("a#00629488","a","atual","N");
INSERT INTO portuguese_lemma VALUES ("a#00668208","a","atual","N");
INSERT INTO portuguese_lemma VALUES ("a#00628521","a","actual","N");
INSERT INTO portuguese_lemma VALUES ("a#00667822","a","actual","N");
INSERT INTO portuguese_lemma VALUES ("a#00668208","a","actual","N");
INSERT INTO portuguese_lemma VALUES ("a#00972642","a","actual","N");
INSERT INTO portuguese_lemma VALUES ("n#00666232","n","apendicectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00666350","n","amputação","N");
INSERT INTO portuguese_lemma VALUES ("n#14550469","n","amputação","N");
INSERT INTO portuguese_lemma VALUES ("n#00666468","n","angioplastia","N");
INSERT INTO portuguese_lemma VALUES ("v#00449544","v","documentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00677802","v","documentar","N");
INSERT INTO portuguese_lemma VALUES ("n#00666600","n","artrodese","N");
INSERT INTO portuguese_lemma VALUES ("n#00666884","n","artroscopia","N");
INSERT INTO portuguese_lemma VALUES ("v#00666886","v","contradizer","N");
INSERT INTO portuguese_lemma VALUES ("v#00823436","v","contradizer","N");
INSERT INTO portuguese_lemma VALUES ("v#00666886","v","negar","N");
INSERT INTO portuguese_lemma VALUES ("v#01515455","v","negar","N");
INSERT INTO portuguese_lemma VALUES ("v#02214190","v","negar","N");
INSERT INTO portuguese_lemma VALUES ("a#00629488","a","dia_de_hoje","Y");
INSERT INTO portuguese_lemma VALUES ("a#00629488","a","hodierno","N");
INSERT INTO portuguese_lemma VALUES ("n#00667384","n","psicocirurgia","N");
INSERT INTO portuguese_lemma VALUES ("v#00667747","v","desmentir","N");
INSERT INTO portuguese_lemma VALUES ("v#00836705","v","desmentir","N");
INSERT INTO portuguese_lemma VALUES ("v#02663141","v","desmentir","N");
INSERT INTO portuguese_lemma VALUES ("v#00667747","v","refutar","N");
INSERT INTO portuguese_lemma VALUES ("v#00814850","v","refutar","N");
INSERT INTO portuguese_lemma VALUES ("a#00667822","a","em_curso","Y");
INSERT INTO portuguese_lemma VALUES ("a#00667936","a","ligado","N");
INSERT INTO portuguese_lemma VALUES ("a#00667936","a","em_linha","Y");
INSERT INTO portuguese_lemma VALUES ("a#00667936","a","online","N");
INSERT INTO portuguese_lemma VALUES ("v#00450535","v","aguentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00802946","v","aguentar","N");
INSERT INTO portuguese_lemma VALUES ("v#01842330","v","aguentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00450535","v","suportar","N");
INSERT INTO portuguese_lemma VALUES ("v#00802946","v","suportar","N");
INSERT INTO portuguese_lemma VALUES ("v#00607177","v","suportar","N");
INSERT INTO portuguese_lemma VALUES ("v#00450535","v","tolerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00802946","v","tolerar","N");
INSERT INTO portuguese_lemma VALUES ("v#02109404","v","tolerar","N");
INSERT INTO portuguese_lemma VALUES ("v#02457585","v","tolerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00450535","v","aturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00802946","v","aturar","N");
INSERT INTO portuguese_lemma VALUES ("n#00668112","n","cauterização","N");
INSERT INTO portuguese_lemma VALUES ("a#00668208","a","até_a_data","Y");
INSERT INTO portuguese_lemma VALUES ("a#00668208","a","vigente","N");
INSERT INTO portuguese_lemma VALUES ("a#00668366","a","mais_recente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00668552","n","colostomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00668736","n","craniotomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00450980","v","engolir","N");
INSERT INTO portuguese_lemma VALUES ("v#00683670","v","engolir","N");
INSERT INTO portuguese_lemma VALUES ("v#00737352","v","engolir","N");
INSERT INTO portuguese_lemma VALUES ("v#00817727","v","engolir","N");
INSERT INTO portuguese_lemma VALUES ("v#00450980","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00463353","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00686879","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00486774","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00541962","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01116447","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01513653","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01530096","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01530524","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01531351","v","aceitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00668829","n","criocirurgia","N");
INSERT INTO portuguese_lemma VALUES ("n#00669000","n","colecistectomia","N");
INSERT INTO portuguese_lemma VALUES ("a#00669021","a","obsoleta","N");
INSERT INTO portuguese_lemma VALUES ("a#00669021","a","obsoleto","N");
INSERT INTO portuguese_lemma VALUES ("a#00631602","a","obsoleto","N");
INSERT INTO portuguese_lemma VALUES ("a#00974159","a","obsoleto","N");
INSERT INTO portuguese_lemma VALUES ("v#00451176","v","consentir","N");
INSERT INTO portuguese_lemma VALUES ("v#00764222","v","consentir","N");
INSERT INTO portuguese_lemma VALUES ("v#00541962","v","consentir","N");
INSERT INTO portuguese_lemma VALUES ("v#00546749","v","consentir","N");
INSERT INTO portuguese_lemma VALUES ("a#00631602","a","desatualizado","N");
INSERT INTO portuguese_lemma VALUES ("a#00631602","a","antiquado","N");
INSERT INTO portuguese_lemma VALUES ("a#00974159","a","antiquado","N");
INSERT INTO portuguese_lemma VALUES ("a#00974519","a","antiquado","N");
INSERT INTO portuguese_lemma VALUES ("a#00631602","a","antigo","N");
INSERT INTO portuguese_lemma VALUES ("a#01667095","a","antigo","N");
INSERT INTO portuguese_lemma VALUES ("a#01666003","a","antigo","N");
INSERT INTO portuguese_lemma VALUES ("a#00631927","a","maldita","N");
INSERT INTO portuguese_lemma VALUES ("a#00631927","a","maldito","N");
INSERT INTO portuguese_lemma VALUES ("a#00632391","a","maldito","N");
INSERT INTO portuguese_lemma VALUES ("a#01392473","a","maldito","N");
INSERT INTO portuguese_lemma VALUES ("a#01457549","a","maldito","N");
INSERT INTO portuguese_lemma VALUES ("n#00669481","n","curetagem","N");
INSERT INTO portuguese_lemma VALUES ("n#00669687","n","Aborto_por_sucção","Y");
INSERT INTO portuguese_lemma VALUES ("a#00632302","a","amaldiçoado","N");
INSERT INTO portuguese_lemma VALUES ("a#00632391","a","amaldiçoado","N");
INSERT INTO portuguese_lemma VALUES ("n#00669932","n","desbridamento","N");
INSERT INTO portuguese_lemma VALUES ("a#00632391","a","condenado","N");
INSERT INTO portuguese_lemma VALUES ("n#07182455","n","condenado","N");
INSERT INTO portuguese_lemma VALUES ("v#00452184","v","julgar","N");
INSERT INTO portuguese_lemma VALUES ("v#00453431","v","julgar","N");
INSERT INTO portuguese_lemma VALUES ("v#00468967","v","julgar","N");
INSERT INTO portuguese_lemma VALUES ("v#00558050","v","julgar","N");
INSERT INTO portuguese_lemma VALUES ("v#01483324","v","julgar","N");
INSERT INTO portuguese_lemma VALUES ("v#01704695","v","julgar","N");
INSERT INTO portuguese_lemma VALUES ("a#00670741","a","bendito","N");
INSERT INTO portuguese_lemma VALUES ("a#01148764","a","bendito","N");
INSERT INTO portuguese_lemma VALUES ("a#02054075","a","bendito","N");
INSERT INTO portuguese_lemma VALUES ("v#00671335","v","subestimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00673766","v","subestimar","N");
INSERT INTO portuguese_lemma VALUES ("n#00436664","n","operação_cirúrgica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00436664","n","Cirurgia","N");
INSERT INTO portuguese_lemma VALUES ("n#00436664","n","cirurgia","N");
INSERT INTO portuguese_lemma VALUES ("n#06063588","n","cirurgia","N");
INSERT INTO portuguese_lemma VALUES ("v#00672017","v","supervalorizado","N");
INSERT INTO portuguese_lemma VALUES ("v#00672017","v","superestimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00672017","v","super-estimado","N");
INSERT INTO portuguese_lemma VALUES ("a#00672226","a","personalizado","N");
INSERT INTO portuguese_lemma VALUES ("n#01096873","n","personalizado","N");
INSERT INTO portuguese_lemma VALUES ("a#01768252","a","personalizado","N");
INSERT INTO portuguese_lemma VALUES ("a#00672382","a","sob_medida","Y");
INSERT INTO portuguese_lemma VALUES ("v#00453556","v","chutar","N");
INSERT INTO portuguese_lemma VALUES ("v#01370561","v","chutar","N");
INSERT INTO portuguese_lemma VALUES ("v#01371756","v","chutar","N");
INSERT INTO portuguese_lemma VALUES ("v#00453556","v","estimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00673571","v","estimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00459984","v","estimar","N");
INSERT INTO portuguese_lemma VALUES ("v#00682230","v","estimar","N");
INSERT INTO portuguese_lemma VALUES ("v#01247189","v","estimar","N");
INSERT INTO portuguese_lemma VALUES ("a#00672785","a","garantido","N");
INSERT INTO portuguese_lemma VALUES ("a#00636519","a","artesanal","N");
INSERT INTO portuguese_lemma VALUES ("v#00673766","v","fazer_pouco","Y");
INSERT INTO portuguese_lemma VALUES ("v#00673766","v","menosprezar","N");
INSERT INTO portuguese_lemma VALUES ("v#00544324","v","menosprezar","N");
INSERT INTO portuguese_lemma VALUES ("v#01211520","v","menosprezar","N");
INSERT INTO portuguese_lemma VALUES ("v#01828070","v","menosprezar","N");
INSERT INTO portuguese_lemma VALUES ("v#00454501","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00687033","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00541962","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00548199","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00583639","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00584625","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#01667768","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#01672350","v","aprovar","N");
INSERT INTO portuguese_lemma VALUES ("a#00674270","a","feito_em_casa","Y");
INSERT INTO portuguese_lemma VALUES ("a#00674270","a","caseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#00987605","a","caseiro","N");
INSERT INTO portuguese_lemma VALUES ("a#01039366","a","caseiro","N");
INSERT INTO portuguese_lemma VALUES ("n#10653388","n","caseiro","N");
INSERT INTO portuguese_lemma VALUES ("v#00454769","v","desaprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00856429","v","desaprovar","N");
INSERT INTO portuguese_lemma VALUES ("v#00674517","v","carimbar","N");
INSERT INTO portuguese_lemma VALUES ("v#00455018","v","selecionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00456563","v","selecionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00455018","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00456210","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00456424","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00456709","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00457036","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00458205","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00679937","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#00723222","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#01172225","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("v#01635578","v","escolher","N");
INSERT INTO portuguese_lemma VALUES ("n#00674760","n","gastrectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00675064","n","Gastrostomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00675064","n","gastrostomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00675592","v","posicionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01354457","v","posicionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00675701","a","cíclico","N");
INSERT INTO portuguese_lemma VALUES ("a#00676555","a","cíclico","N");
INSERT INTO portuguese_lemma VALUES ("a#00677545","a","cíclico","N");
INSERT INTO portuguese_lemma VALUES ("a#01967803","a","cíclico","N");
INSERT INTO portuguese_lemma VALUES ("v#00675768","v","peneirar","N");
INSERT INTO portuguese_lemma VALUES ("v#02098827","v","peneirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00675768","v","coar","N");
INSERT INTO portuguese_lemma VALUES ("v#01000892","v","coar","N");
INSERT INTO portuguese_lemma VALUES ("a#00675928","a","alternado","N");
INSERT INTO portuguese_lemma VALUES ("a#00676093","a","alternado","N");
INSERT INTO portuguese_lemma VALUES ("a#00763767","a","alternado","N");
INSERT INTO portuguese_lemma VALUES ("a#00675928","a","alterno","N");
INSERT INTO portuguese_lemma VALUES ("a#00676093","a","alterno","N");
INSERT INTO portuguese_lemma VALUES ("a#00763767","a","alterno","N");
INSERT INTO portuguese_lemma VALUES ("a#00675928","a","alternante","N");
INSERT INTO portuguese_lemma VALUES ("a#00675928","a","alternativa","N");
INSERT INTO portuguese_lemma VALUES ("a#00763767","a","alternativa","N");
INSERT INTO portuguese_lemma VALUES ("n#04463475","n","alternativa","N");
INSERT INTO portuguese_lemma VALUES ("n#00676834","n","Hemostasia","N");
INSERT INTO portuguese_lemma VALUES ("n#00676834","n","hemostase","N");
INSERT INTO portuguese_lemma VALUES ("v#00456424","v","eleger","N");
INSERT INTO portuguese_lemma VALUES ("v#01172225","v","eleger","N");
INSERT INTO portuguese_lemma VALUES ("v#01635578","v","eleger","N");
INSERT INTO portuguese_lemma VALUES ("a#00676999","a","heterocíclico","N");
INSERT INTO portuguese_lemma VALUES ("v#00456563","v","extrair","N");
INSERT INTO portuguese_lemma VALUES ("v#01351754","v","extrair","N");
INSERT INTO portuguese_lemma VALUES ("v#01266515","v","extrair","N");
INSERT INTO portuguese_lemma VALUES ("n#00677174","n","histerectomia","N");
INSERT INTO portuguese_lemma VALUES ("a#00677313","a","acíclico","N");
INSERT INTO portuguese_lemma VALUES ("a#00677877","a","acíclico","N");
INSERT INTO portuguese_lemma VALUES ("a#01970604","a","acíclico","N");
INSERT INTO portuguese_lemma VALUES ("a#00677545","a","ciclíco","N");
INSERT INTO portuguese_lemma VALUES ("v#00457036","v","especificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00484149","v","especificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00641405","v","especificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00641602","v","especificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00691100","v","especificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01780912","v","especificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00457036","v","designar","N");
INSERT INTO portuguese_lemma VALUES ("v#01635578","v","designar","N");
INSERT INTO portuguese_lemma VALUES ("v#01636187","v","designar","N");
INSERT INTO portuguese_lemma VALUES ("v#00677966","v","dedicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00601416","v","dedicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00601722","v","dedicar","N");
INSERT INTO portuguese_lemma VALUES ("n#00678010","n","incisão","N");
INSERT INTO portuguese_lemma VALUES ("a#00641153","a","anual","N");
INSERT INTO portuguese_lemma VALUES ("a#02489110","a","anual","N");
INSERT INTO portuguese_lemma VALUES ("v#00457479","v","agendar","N");
INSERT INTO portuguese_lemma VALUES ("v#00540104","v","agendar","N");
INSERT INTO portuguese_lemma VALUES ("a#00641938","a","nocturno","N");
INSERT INTO portuguese_lemma VALUES ("a#02705522","a","nocturno","N");
INSERT INTO portuguese_lemma VALUES ("a#00641938","a","noturno","N");
INSERT INTO portuguese_lemma VALUES ("a#02705522","a","noturno","N");
INSERT INTO portuguese_lemma VALUES ("n#07047679","n","noturno","N");
INSERT INTO portuguese_lemma VALUES ("a#00679147","a","danificado","N");
INSERT INTO portuguese_lemma VALUES ("a#00679147","a","avariado","N");
INSERT INTO portuguese_lemma VALUES ("v#00458368","v","optar","N");
INSERT INTO portuguese_lemma VALUES ("v#01635578","v","optar","N");
INSERT INTO portuguese_lemma VALUES ("v#00458368","v","preferir","N");
INSERT INTO portuguese_lemma VALUES ("v#01246259","v","preferir","N");
INSERT INTO portuguese_lemma VALUES ("v#01635007","v","preferir","N");
INSERT INTO portuguese_lemma VALUES ("a#00679717","a","dilapidados","N");
INSERT INTO portuguese_lemma VALUES ("a#00679717","a","malcuidada","N");
INSERT INTO portuguese_lemma VALUES ("a#00679717","a","dilapidadas","N");
INSERT INTO portuguese_lemma VALUES ("a#00679717","a","malcuidado","N");
INSERT INTO portuguese_lemma VALUES ("a#00679717","a","dilapidado","N");
INSERT INTO portuguese_lemma VALUES ("a#00679717","a","dilapidada","N");
INSERT INTO portuguese_lemma VALUES ("a#00680005","a","enrugado","N");
INSERT INTO portuguese_lemma VALUES ("a#00680156","a","quebrado","N");
INSERT INTO portuguese_lemma VALUES ("v#00680346","v","predeterminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00702773","v","predeterminar","N");
INSERT INTO portuguese_lemma VALUES ("n#00680658","n","vitrectomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00680692","v","predispor","N");
INSERT INTO portuguese_lemma VALUES ("n#00680914","n","episiotomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00681071","n","Ileostomia","N");
INSERT INTO portuguese_lemma VALUES ("a#00681094","a","indemne","N");
INSERT INTO portuguese_lemma VALUES ("a#01319182","a","indemne","N");
INSERT INTO portuguese_lemma VALUES ("a#00681094","a","indene","N");
INSERT INTO portuguese_lemma VALUES ("a#01319182","a","indene","N");
INSERT INTO portuguese_lemma VALUES ("a#00681094","a","intato","N");
INSERT INTO portuguese_lemma VALUES ("a#00681268","a","intacto","N");
INSERT INTO portuguese_lemma VALUES ("a#00647484","a","surdo","N");
INSERT INTO portuguese_lemma VALUES ("a#01194328","a","surdo","N");
INSERT INTO portuguese_lemma VALUES ("a#02176106","a","surdo","N");
INSERT INTO portuguese_lemma VALUES ("a#00682168","a","surdo-mudo","N");
INSERT INTO portuguese_lemma VALUES ("n#00682243","n","Lipoaspiração","N");
INSERT INTO portuguese_lemma VALUES ("n#00682625","n","Otoplastia","N");
INSERT INTO portuguese_lemma VALUES ("a#00682662","a","sem_ouvido_musical","Y");
INSERT INTO portuguese_lemma VALUES ("n#00682738","n","Laminectomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00682781","v","avaliar_novamente","Y");
INSERT INTO portuguese_lemma VALUES ("v#00682781","v","reavaliar","N");
INSERT INTO portuguese_lemma VALUES ("n#00682856","n","laparotomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00682928","v","censurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00558872","v","censurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00824066","v","censurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00559552","v","censurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00842772","v","censurar","N");
INSERT INTO portuguese_lemma VALUES ("n#00683012","n","laparoscopia","N");
INSERT INTO portuguese_lemma VALUES ("a#00683185","a","indecente","N");
INSERT INTO portuguese_lemma VALUES ("a#01539022","a","indecente","N");
INSERT INTO portuguese_lemma VALUES ("a#01880918","a","indecente","N");
INSERT INTO portuguese_lemma VALUES ("a#02133207","a","indecente","N");
INSERT INTO portuguese_lemma VALUES ("a#02133779","a","indecente","N");
INSERT INTO portuguese_lemma VALUES ("v#00460650","v","crer","N");
INSERT INTO portuguese_lemma VALUES ("v#00684273","v","crer","N");
INSERT INTO portuguese_lemma VALUES ("v#00464775","v","crer","N");
INSERT INTO portuguese_lemma VALUES ("v#00721098","v","crer","N");
INSERT INTO portuguese_lemma VALUES ("v#00460650","v","acreditar","N");
INSERT INTO portuguese_lemma VALUES ("v#00684273","v","acreditar","N");
INSERT INTO portuguese_lemma VALUES ("v#00721098","v","acreditar","N");
INSERT INTO portuguese_lemma VALUES ("n#05014301","n","acreditar","N");
INSERT INTO portuguese_lemma VALUES ("n#00684128","n","lobotomia","N");
INSERT INTO portuguese_lemma VALUES ("a#00684334","a","sugestivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01323096","a","sugestivo","N");
INSERT INTO portuguese_lemma VALUES ("a#01977669","a","sugestivo","N");
INSERT INTO portuguese_lemma VALUES ("a#02091300","a","sugestivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00684645","v","descrer","N");
INSERT INTO portuguese_lemma VALUES ("v#00684645","v","desacreditar","N");
INSERT INTO portuguese_lemma VALUES ("v#00853195","v","desacreditar","N");
INSERT INTO portuguese_lemma VALUES ("a#00650020","a","determinante","N");
INSERT INTO portuguese_lemma VALUES ("n#06140000","n","determinante","N");
INSERT INTO portuguese_lemma VALUES ("a#00650271","a","fatídico","N");
INSERT INTO portuguese_lemma VALUES ("v#00685419","v","rejeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00462716","v","rejeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00687181","v","rejeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00541445","v","rejeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00541774","v","rejeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#02214190","v","rejeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#01531148","v","rejeitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00685508","n","mastectomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00686039","v","repudiar","N");
INSERT INTO portuguese_lemma VALUES ("v#00911917","v","repudiar","N");
INSERT INTO portuguese_lemma VALUES ("n#00686385","n","nefrectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00686385","n","Nefrectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00686570","n","Ooforectomia","N");
INSERT INTO portuguese_lemma VALUES ("a#00686573","a","indeciso","N");
INSERT INTO portuguese_lemma VALUES ("a#02215139","a","indeciso","N");
INSERT INTO portuguese_lemma VALUES ("n#00687135","n","Pneumonectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00687252","n","Prostatectomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00464049","v","ter_dúvida","Y");
INSERT INTO portuguese_lemma VALUES ("v#00464049","v","estar_em_dúvida","Y");
INSERT INTO portuguese_lemma VALUES ("v#00464049","v","duvidar","N");
INSERT INTO portuguese_lemma VALUES ("v#00687523","v","duvidar","N");
INSERT INTO portuguese_lemma VALUES ("v#01802820","v","duvidar","N");
INSERT INTO portuguese_lemma VALUES ("n#00687365","n","Salpingectomia","N");
INSERT INTO portuguese_lemma VALUES ("a#00652648","a","alegado","N");
INSERT INTO portuguese_lemma VALUES ("a#00687750","a","anunciado","N");
INSERT INTO portuguese_lemma VALUES ("n#00687769","n","esplenectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00687857","n","Estapedectomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00464450","v","desconfiar","N");
INSERT INTO portuguese_lemma VALUES ("n#00688220","n","Tiroidectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00688766","n","Miringotomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00688768","v","repensar","N");
INSERT INTO portuguese_lemma VALUES ("n#00688915","n","Neurocirurgia","N");
INSERT INTO portuguese_lemma VALUES ("n#00689062","n","rinoplastia","N");
INSERT INTO portuguese_lemma VALUES ("a#00654166","a","sério","N");
INSERT INTO portuguese_lemma VALUES ("a#01226825","a","sério","N");
INSERT INTO portuguese_lemma VALUES ("a#01840027","a","sério","N");
INSERT INTO portuguese_lemma VALUES ("a#02043566","a","sério","N");
INSERT INTO portuguese_lemma VALUES ("a#00654166","a","parco","N");
INSERT INTO portuguese_lemma VALUES ("a#00654166","a","sisudo","N");
INSERT INTO portuguese_lemma VALUES ("n#00689467","n","Osteotomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00689467","n","OSTEOTOMIA","N");
INSERT INTO portuguese_lemma VALUES ("n#00689995","n","Faloplastia","N");
INSERT INTO portuguese_lemma VALUES ("a#00654761","a","profundo","N");
INSERT INTO portuguese_lemma VALUES ("a#01801376","a","profundo","N");
INSERT INTO portuguese_lemma VALUES ("a#00654761","a","fundo","N");
INSERT INTO portuguese_lemma VALUES ("n#04556371","n","fundo","N");
INSERT INTO portuguese_lemma VALUES ("n#08511970","n","fundo","N");
INSERT INTO portuguese_lemma VALUES ("n#06693004","n","fundo","N");
INSERT INTO portuguese_lemma VALUES ("n#09282363","n","fundo","N");
INSERT INTO portuguese_lemma VALUES ("n#09376526","n","fundo","N");
INSERT INTO portuguese_lemma VALUES ("n#13358549","n","fundo","N");
INSERT INTO portuguese_lemma VALUES ("v#00466561","v","sentir-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00690501","n","cirurgia_plástica","Y");
INSERT INTO portuguese_lemma VALUES ("n#00691050","n","resecção","N");
INSERT INTO portuguese_lemma VALUES ("n#00691330","n","rizotomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00691516","v","chamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00753881","v","chamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00536087","v","chamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00538265","v","chamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00696267","v","chamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00697540","v","chamar","N");
INSERT INTO portuguese_lemma VALUES ("v#00691665","v","gostar","N");
INSERT INTO portuguese_lemma VALUES ("v#01212539","v","gostar","N");
INSERT INTO portuguese_lemma VALUES ("v#01776952","v","gostar","N");
INSERT INTO portuguese_lemma VALUES ("v#01213391","v","gostar","N");
INSERT INTO portuguese_lemma VALUES ("v#01238865","v","gostar","N");
INSERT INTO portuguese_lemma VALUES ("a#00691696","a","desinteressante","N");
INSERT INTO portuguese_lemma VALUES ("a#00691696","a","raso","N");
INSERT INTO portuguese_lemma VALUES ("n#09433134","n","raso","N");
INSERT INTO portuguese_lemma VALUES ("v#00691944","v","indentificar-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00692130","n","Esterilização","N");
INSERT INTO portuguese_lemma VALUES ("v#00467945","v","favorecer","N");
INSERT INTO portuguese_lemma VALUES ("v#00692580","v","reificar","N");
INSERT INTO portuguese_lemma VALUES ("v#00692580","v","coisificar","N");
INSERT INTO portuguese_lemma VALUES ("a#00657242","a","profunda","N");
INSERT INTO portuguese_lemma VALUES ("n#00693109","n","Experiência_de_Michelson-Morley","Y");
INSERT INTO portuguese_lemma VALUES ("n#00693109","n","Experiência_de_michelson-morley","Y");
INSERT INTO portuguese_lemma VALUES ("v#00693172","v","romantizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00657800","a","superficial","N");
INSERT INTO portuguese_lemma VALUES ("a#01802133","a","superficial","N");
INSERT INTO portuguese_lemma VALUES ("a#01803304","a","superficial","N");
INSERT INTO portuguese_lemma VALUES ("a#00658187","a","superficial","N");
INSERT INTO portuguese_lemma VALUES ("a#02607907","a","superficial","N");
INSERT INTO portuguese_lemma VALUES ("n#00693399","n","traqueostomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00693679","n","transplantação_de_órgãos","Y");
INSERT INTO portuguese_lemma VALUES ("v#00469237","v","respeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00469237","v","venerar","N");
INSERT INTO portuguese_lemma VALUES ("v#01778568","v","venerar","N");
INSERT INTO portuguese_lemma VALUES ("v#00469237","v","prezar","N");
INSERT INTO portuguese_lemma VALUES ("v#00694641","v","desrespeitar","N");
INSERT INTO portuguese_lemma VALUES ("v#02457825","v","desrespeitar","N");
INSERT INTO portuguese_lemma VALUES ("n#00736721","n","justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#00694866","n","justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#04826235","n","justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#04839154","n","justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#03801117","n","justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#04850341","n","justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#08135342","n","justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#00736721","n","Justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#08135342","n","Justiça","N");
INSERT INTO portuguese_lemma VALUES ("n#00694990","n","ministração","N");
INSERT INTO portuguese_lemma VALUES ("n#00694990","n","aplicação","N");
INSERT INTO portuguese_lemma VALUES ("n#00607299","n","aplicação","N");
INSERT INTO portuguese_lemma VALUES ("n#00729616","n","aplicação","N");
INSERT INTO portuguese_lemma VALUES ("n#06570110","n","aplicação","N");
INSERT INTO portuguese_lemma VALUES ("a#00695209","a","vitorioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00704898","a","vitorioso","N");
INSERT INTO portuguese_lemma VALUES ("a#02333314","a","vitorioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00695209","a","triunfante","N");
INSERT INTO portuguese_lemma VALUES ("a#00704898","a","triunfante","N");
INSERT INTO portuguese_lemma VALUES ("a#02333314","a","triunfante","N");
INSERT INTO portuguese_lemma VALUES ("n#00695300","n","sedação","N");
INSERT INTO portuguese_lemma VALUES ("a#00695335","a","invito","N");
INSERT INTO portuguese_lemma VALUES ("v#00695475","v","supervalorizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00695523","a","desafiador","N");
INSERT INTO portuguese_lemma VALUES ("a#00711113","a","desafiador","N");
INSERT INTO portuguese_lemma VALUES ("n#00695717","n","Lavagem_Vaginal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00695717","n","lavagem_vaginal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00695944","n","clister","N");
INSERT INTO portuguese_lemma VALUES ("n#00695944","n","enema","N");
INSERT INTO portuguese_lemma VALUES ("v#00470717","v","reexaminar","N");
INSERT INTO portuguese_lemma VALUES ("v#00470717","v","rever","N");
INSERT INTO portuguese_lemma VALUES ("v#00696414","v","rever","N");
INSERT INTO portuguese_lemma VALUES ("v#00696852","v","rever","N");
INSERT INTO portuguese_lemma VALUES ("v#00673530","v","rever","N");
INSERT INTO portuguese_lemma VALUES ("v#01657018","v","rever","N");
INSERT INTO portuguese_lemma VALUES ("a#00696335","a","relutante","N");
INSERT INTO portuguese_lemma VALUES ("a#00811969","a","relutante","N");
INSERT INTO portuguese_lemma VALUES ("a#00696518","a","complacente","N");
INSERT INTO portuguese_lemma VALUES ("a#00696518","a","submisso","N");
INSERT INTO portuguese_lemma VALUES ("v#00696700","v","vistoriar","N");
INSERT INTO portuguese_lemma VALUES ("v#01259471","v","vistoriar","N");
INSERT INTO portuguese_lemma VALUES ("v#01482454","v","vistoriar","N");
INSERT INTO portuguese_lemma VALUES ("n#00696882","n","curativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01118744","a","curativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00698004","n","Flebotomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00698348","n","Toracotomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00698609","n","flebotomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00698959","n","desfibrilação","N");
INSERT INTO portuguese_lemma VALUES ("n#00699146","n","Desintoxicação","N");
INSERT INTO portuguese_lemma VALUES ("n#00699146","n","desintoxicação","N");
INSERT INTO portuguese_lemma VALUES ("n#00699320","n","desintoxicação","N");
INSERT INTO portuguese_lemma VALUES ("a#00665079","a","primário","N");
INSERT INTO portuguese_lemma VALUES ("a#01781200","a","primário","N");
INSERT INTO portuguese_lemma VALUES ("n#06221291","n","primário","N");
INSERT INTO portuguese_lemma VALUES ("v#00472976","v","propor-se","N");
INSERT INTO portuguese_lemma VALUES ("n#00699736","n","cura_pela_fé","Y");
INSERT INTO portuguese_lemma VALUES ("v#00473111","v","determinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00473721","v","determinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00622132","v","determinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01840766","v","determinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00700000","n","fisioterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#00700000","n","Fisioterapia","N");
INSERT INTO portuguese_lemma VALUES ("v#00700336","v","formatar","N");
INSERT INTO portuguese_lemma VALUES ("n#00700421","n","fitoterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#00700421","n","Fitoterapia","N");
INSERT INTO portuguese_lemma VALUES ("v#00700517","v","cobrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01585711","v","cobrar","N");
INSERT INTO portuguese_lemma VALUES ("v#02320903","v","cobrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00449352","n","Psicoterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#00449352","n","psicoterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#04630512","n","psicoterapia","N");
INSERT INTO portuguese_lemma VALUES ("v#00474001","v","se_moldar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00701178","a","decidido","N");
INSERT INTO portuguese_lemma VALUES ("a#00701178","a","resoluto","N");
INSERT INTO portuguese_lemma VALUES ("a#00667628","a","evidente","N");
INSERT INTO portuguese_lemma VALUES ("a#01234186","a","evidente","N");
INSERT INTO portuguese_lemma VALUES ("a#01560095","a","evidente","N");
INSERT INTO portuguese_lemma VALUES ("a#01560359","a","evidente","N");
INSERT INTO portuguese_lemma VALUES ("n#00701491","n","Terapia_de_aversão","Y");
INSERT INTO portuguese_lemma VALUES ("v#00474461","v","reformar","N");
INSERT INTO portuguese_lemma VALUES ("v#01660870","v","reformar","N");
INSERT INTO portuguese_lemma VALUES ("n#00702418","n","inundações","N");
INSERT INTO portuguese_lemma VALUES ("v#00703310","v","predestinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00703512","v","cogitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00476424","v","cogitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00734348","v","cogitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00703512","v","meditar","N");
INSERT INTO portuguese_lemma VALUES ("v#00476424","v","meditar","N");
INSERT INTO portuguese_lemma VALUES ("a#00669950","a","deprimido","N");
INSERT INTO portuguese_lemma VALUES ("a#01155404","a","deprimido","N");
INSERT INTO portuguese_lemma VALUES ("a#01230153","a","deprimido","N");
INSERT INTO portuguese_lemma VALUES ("a#02281938","a","deprimido","N");
INSERT INTO portuguese_lemma VALUES ("a#02413221","a","deprimido","N");
INSERT INTO portuguese_lemma VALUES ("a#00669950","a","trevas","N");
INSERT INTO portuguese_lemma VALUES ("n#10073287","n","trevas","N");
INSERT INTO portuguese_lemma VALUES ("n#10418027","n","trevas","N");
INSERT INTO portuguese_lemma VALUES ("n#00703688","n","terapia_em_grupo","Y");
INSERT INTO portuguese_lemma VALUES ("n#00704064","n","hipnoterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#00704064","n","Hipnoterapia","N");
INSERT INTO portuguese_lemma VALUES ("v#00704249","v","remoer","N");
INSERT INTO portuguese_lemma VALUES ("n#00451738","n","psicanálise","N");
INSERT INTO portuguese_lemma VALUES ("v#00476424","v","ponderar","N");
INSERT INTO portuguese_lemma VALUES ("v#00729378","v","ponderar","N");
INSERT INTO portuguese_lemma VALUES ("v#00625900","v","ponderar","N");
INSERT INTO portuguese_lemma VALUES ("v#00704690","v","planejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00705227","v","planejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01638368","v","planejar","N");
INSERT INTO portuguese_lemma VALUES ("a#00704898","a","triunfador","N");
INSERT INTO portuguese_lemma VALUES ("a#00704898","a","exultante","N");
INSERT INTO portuguese_lemma VALUES ("a#00704898","a","jubiloso","N");
INSERT INTO portuguese_lemma VALUES ("a#01367211","a","jubiloso","N");
INSERT INTO portuguese_lemma VALUES ("v#00477282","v","aspirar","N");
INSERT INTO portuguese_lemma VALUES ("n#00705580","n","Radioterapia","N");
INSERT INTO portuguese_lemma VALUES ("a#00705616","a","sublime","N");
INSERT INTO portuguese_lemma VALUES ("a#01074523","a","sublime","N");
INSERT INTO portuguese_lemma VALUES ("a#02353726","a","sublime","N");
INSERT INTO portuguese_lemma VALUES ("a#02056566","a","sublime","N");
INSERT INTO portuguese_lemma VALUES ("n#00706605","n","Eletroconvulsoterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#00706605","n","eletroconvulsoterapia","N");
INSERT INTO portuguese_lemma VALUES ("n#00706605","n","eletrochoque","N");
INSERT INTO portuguese_lemma VALUES ("a#00706688","a","frágil","N");
INSERT INTO portuguese_lemma VALUES ("a#00674840","a","frágil","N");
INSERT INTO portuguese_lemma VALUES ("v#00706975","v","conspirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00707624","v","conspirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00706975","v","conjurar","N");
INSERT INTO portuguese_lemma VALUES ("v#00707956","v","intrigar","N");
INSERT INTO portuguese_lemma VALUES ("v#01827903","v","intrigar","N");
INSERT INTO portuguese_lemma VALUES ("n#00707967","n","Quiropraxia","N");
INSERT INTO portuguese_lemma VALUES ("v#00708128","v","maquinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00708332","n","Medicina_natural","Y");
INSERT INTO portuguese_lemma VALUES ("a#00708498","a","quebradiça","N");
INSERT INTO portuguese_lemma VALUES ("v#00479160","v","pretender","N");
INSERT INTO portuguese_lemma VALUES ("v#00479584","v","pretender","N");
INSERT INTO portuguese_lemma VALUES ("v#01246466","v","pretender","N");
INSERT INTO portuguese_lemma VALUES ("v#00479584","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#00592804","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#00876332","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#00594839","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#00596010","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#00596144","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#01175810","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#01632536","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#01636187","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("v#01861884","v","propor","N");
INSERT INTO portuguese_lemma VALUES ("n#00709205","n","osteopatia","N");
INSERT INTO portuguese_lemma VALUES ("v#00479841","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00612000","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01188485","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01124810","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01824339","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01824532","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01244897","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01245362","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01245981","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01246175","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01246466","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#01247460","v","desejar","N");
INSERT INTO portuguese_lemma VALUES ("v#00479841","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01188485","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01824339","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01824532","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01244897","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01245362","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01825962","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01245981","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("v#01246466","v","querer","N");
INSERT INTO portuguese_lemma VALUES ("a#00674840","a","quebradiço","N");
INSERT INTO portuguese_lemma VALUES ("a#00674840","a","delicado","N");
INSERT INTO portuguese_lemma VALUES ("v#00479979","v","destinar","N");
INSERT INTO portuguese_lemma VALUES ("n#00709521","n","desinfecção","N");
INSERT INTO portuguese_lemma VALUES ("n#00709659","n","cloragem","N");
INSERT INTO portuguese_lemma VALUES ("n#13448622","n","cloragem","N");
INSERT INTO portuguese_lemma VALUES ("a#00709744","a","inquebrável","N");
INSERT INTO portuguese_lemma VALUES ("v#00480481","v","orquestrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01707737","v","orquestrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00710015","n","anticoagulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00710155","n","Acupuntura","N");
INSERT INTO portuguese_lemma VALUES ("n#00710155","n","acupuntura","N");
INSERT INTO portuguese_lemma VALUES ("n#00710550","n","Treinamento_Autógeno","Y");
INSERT INTO portuguese_lemma VALUES ("n#00710550","n","treinamento_autógeno","Y");
INSERT INTO portuguese_lemma VALUES ("v#00710606","v","mapear","N");
INSERT INTO portuguese_lemma VALUES ("n#00710889","n","homeopatia","N");
INSERT INTO portuguese_lemma VALUES ("a#00676443","a","estrito","N");
INSERT INTO portuguese_lemma VALUES ("a#00868874","a","estrito","N");
INSERT INTO portuguese_lemma VALUES ("a#00676443","a","rigoroso","N");
INSERT INTO portuguese_lemma VALUES ("a#00868874","a","rigoroso","N");
INSERT INTO portuguese_lemma VALUES ("a#01248007","a","rigoroso","N");
INSERT INTO portuguese_lemma VALUES ("a#02288133","a","rigoroso","N");
INSERT INTO portuguese_lemma VALUES ("n#00711127","n","hidroterapia","N");
INSERT INTO portuguese_lemma VALUES ("v#00711550","v","projetar","N");
INSERT INTO portuguese_lemma VALUES ("v#01125984","v","projetar","N");
INSERT INTO portuguese_lemma VALUES ("v#01464668","v","projetar","N");
INSERT INTO portuguese_lemma VALUES ("v#00711715","v","entreter","N");
INSERT INTO portuguese_lemma VALUES ("v#01698431","v","entreter","N");
INSERT INTO portuguese_lemma VALUES ("v#01698559","v","entreter","N");
INSERT INTO portuguese_lemma VALUES ("n#00456982","n","fricção","N");
INSERT INTO portuguese_lemma VALUES ("n#07800619","n","fricção","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","orçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00723851","v","orçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00724029","v","orçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","prognosticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00591090","v","prognosticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00621460","v","prognosticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00626821","v","prognosticar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","prever","N");
INSERT INTO portuguese_lemma VALUES ("v#00720808","v","prever","N");
INSERT INTO portuguese_lemma VALUES ("v#00591090","v","prever","N");
INSERT INTO portuguese_lemma VALUES ("v#00621460","v","prever","N");
INSERT INTO portuguese_lemma VALUES ("v#00626821","v","prever","N");
INSERT INTO portuguese_lemma VALUES ("v#00659397","v","prever","N");
INSERT INTO portuguese_lemma VALUES ("v#01124126","v","prever","N");
INSERT INTO portuguese_lemma VALUES ("v#00482033","v","predizer","N");
INSERT INTO portuguese_lemma VALUES ("v#00591090","v","predizer","N");
INSERT INTO portuguese_lemma VALUES ("v#00621460","v","predizer","N");
INSERT INTO portuguese_lemma VALUES ("v#00626821","v","predizer","N");
INSERT INTO portuguese_lemma VALUES ("v#00926702","v","predizer","N");
INSERT INTO portuguese_lemma VALUES ("n#00457130","n","revestimento","N");
INSERT INTO portuguese_lemma VALUES ("n#04489410","n","revestimento","N");
INSERT INTO portuguese_lemma VALUES ("v#00712708","v","depender","N");
INSERT INTO portuguese_lemma VALUES ("v#02663848","v","depender","N");
INSERT INTO portuguese_lemma VALUES ("v#02664017","v","depender","N");
INSERT INTO portuguese_lemma VALUES ("v#01817306","v","depender","N");
INSERT INTO portuguese_lemma VALUES ("v#01852531","v","depender","N");
INSERT INTO portuguese_lemma VALUES ("n#00712833","n","Unção","N");
INSERT INTO portuguese_lemma VALUES ("a#00678141","a","urgente","N");
INSERT INTO portuguese_lemma VALUES ("a#00713558","a","urgente","N");
INSERT INTO portuguese_lemma VALUES ("n#00712979","n","Fumigação","N");
INSERT INTO portuguese_lemma VALUES ("n#00712979","n","fumigação","N");
INSERT INTO portuguese_lemma VALUES ("n#00713135","n","folheação","N");
INSERT INTO portuguese_lemma VALUES ("v#00482838","v","associar","N");
INSERT INTO portuguese_lemma VALUES ("v#00740053","v","associar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482838","v","conectar","N");
INSERT INTO portuguese_lemma VALUES ("v#01069391","v","conectar","N");
INSERT INTO portuguese_lemma VALUES ("v#00877947","v","conectar","N");
INSERT INTO portuguese_lemma VALUES ("v#00482838","v","relacionar","N");
INSERT INTO portuguese_lemma VALUES ("v#02458103","v","relacionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01825574","v","relacionar","N");
INSERT INTO portuguese_lemma VALUES ("v#02724417","v","relacionar","N");
INSERT INTO portuguese_lemma VALUES ("n#00713250","n","galvanização","N");
INSERT INTO portuguese_lemma VALUES ("n#01262109","n","galvanização","N");
INSERT INTO portuguese_lemma VALUES ("n#13485968","n","galvanização","N");
INSERT INTO portuguese_lemma VALUES ("a#00713995","a","suplicante","N");
INSERT INTO portuguese_lemma VALUES ("v#00713996","v","correlacionar","N");
INSERT INTO portuguese_lemma VALUES ("n#00714173","n","luxação","N");
INSERT INTO portuguese_lemma VALUES ("v#00714273","v","desassociar","N");
INSERT INTO portuguese_lemma VALUES ("a#00714320","a","importuno","N");
INSERT INTO portuguese_lemma VALUES ("v#00714884","v","debater","N");
INSERT INTO portuguese_lemma VALUES ("v#00525378","v","debater","N");
INSERT INTO portuguese_lemma VALUES ("v#00552181","v","debater","N");
INSERT INTO portuguese_lemma VALUES ("n#00714944","n","artesanato","N");
INSERT INTO portuguese_lemma VALUES ("n#03485655","n","artesanato","N");
INSERT INTO portuguese_lemma VALUES ("a#00680955","a","parlamentar","N");
INSERT INTO portuguese_lemma VALUES ("a#00681181","a","parlamentar","N");
INSERT INTO portuguese_lemma VALUES ("a#02590962","a","parlamentar","N");
INSERT INTO portuguese_lemma VALUES ("n#09955781","n","parlamentar","N");
INSERT INTO portuguese_lemma VALUES ("n#10400309","n","parlamentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00484458","v","decretar","N");
INSERT INTO portuguese_lemma VALUES ("v#00695426","v","decretar","N");
INSERT INTO portuguese_lemma VALUES ("n#00716179","n","vasectomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00716520","n","vasovasostomia","N");
INSERT INTO portuguese_lemma VALUES ("n#00716676","n","Vulvectomia","N");
INSERT INTO portuguese_lemma VALUES ("v#00716758","v","postular","N");
INSERT INTO portuguese_lemma VALUES ("n#00716777","n","vivisecção","N");
INSERT INTO portuguese_lemma VALUES ("n#00716777","n","vivissecção","N");
INSERT INTO portuguese_lemma VALUES ("a#00681981","a","da_república","Y");
INSERT INTO portuguese_lemma VALUES ("a#00681981","a","republicano","N");
INSERT INTO portuguese_lemma VALUES ("a#02598312","a","republicano","N");
INSERT INTO portuguese_lemma VALUES ("n#00716945","n","lubrificação","N");
INSERT INTO portuguese_lemma VALUES ("v#00717045","v","assertar","N");
INSERT INTO portuguese_lemma VALUES ("v#00717045","v","insistir","N");
INSERT INTO portuguese_lemma VALUES ("v#00777931","v","insistir","N");
INSERT INTO portuguese_lemma VALUES ("v#00556026","v","insistir","N");
INSERT INTO portuguese_lemma VALUES ("n#00717208","n","Pintura","N");
INSERT INTO portuguese_lemma VALUES ("a#00717684","a","autocrático","N");
INSERT INTO portuguese_lemma VALUES ("a#00717684","a","ditatorial","N");
INSERT INTO portuguese_lemma VALUES ("a#00787357","a","ditatorial","N");
INSERT INTO portuguese_lemma VALUES ("a#02712678","a","ditatorial","N");
INSERT INTO portuguese_lemma VALUES ("a#00718137","a","despótico","N");
INSERT INTO portuguese_lemma VALUES ("n#00718195","n","Folha-de-flandres","N");
INSERT INTO portuguese_lemma VALUES ("a#00718635","a","totalitário","N");
INSERT INTO portuguese_lemma VALUES ("a#02818111","a","totalitário","N");
INSERT INTO portuguese_lemma VALUES ("a#00718924","a","discrionário","N");
INSERT INTO portuguese_lemma VALUES ("a#00718924","a","arbitrária","N");
INSERT INTO portuguese_lemma VALUES ("a#00718924","a","arbitrário","N");
INSERT INTO portuguese_lemma VALUES ("n#00461585","n","obrigação","N");
INSERT INTO portuguese_lemma VALUES ("n#00523477","n","obrigação","N");
INSERT INTO portuguese_lemma VALUES ("n#05074715","n","obrigação","N");
INSERT INTO portuguese_lemma VALUES ("n#09665083","n","obrigação","N");
INSERT INTO portuguese_lemma VALUES ("n#14490110","n","obrigação","N");
INSERT INTO portuguese_lemma VALUES ("n#10395239","n","obrigação","N");
INSERT INTO portuguese_lemma VALUES ("v#00487007","v","atender","N");
INSERT INTO portuguese_lemma VALUES ("v#01486353","v","atender","N");
INSERT INTO portuguese_lemma VALUES ("n#00461778","n","incumbência","N");
INSERT INTO portuguese_lemma VALUES ("n#01131425","n","incumbência","N");
INSERT INTO portuguese_lemma VALUES ("v#00487133","v","antecipar","N");
INSERT INTO portuguese_lemma VALUES ("v#00720808","v","antecipar","N");
INSERT INTO portuguese_lemma VALUES ("a#00684959","a","demonstrativo","N");
INSERT INTO portuguese_lemma VALUES ("a#01323962","a","demonstrativo","N");
INSERT INTO portuguese_lemma VALUES ("a#02356048","a","demonstrativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00720497","v","aguardar_ansiosamente","Y");
INSERT INTO portuguese_lemma VALUES ("n#00462318","n","papel","N");
INSERT INTO portuguese_lemma VALUES ("n#04552661","n","papel","N");
INSERT INTO portuguese_lemma VALUES ("n#04731024","n","papel","N");
INSERT INTO portuguese_lemma VALUES ("n#04731186","n","papel","N");
INSERT INTO portuguese_lemma VALUES ("n#10744736","n","papel","N");
INSERT INTO portuguese_lemma VALUES ("n#15074962","n","papel","N");
INSERT INTO portuguese_lemma VALUES ("n#15093938","n","papel","N");
INSERT INTO portuguese_lemma VALUES ("v#00720808","v","antever","N");
INSERT INTO portuguese_lemma VALUES ("v#01124126","v","antever","N");
INSERT INTO portuguese_lemma VALUES ("a#00721157","a","que_se_pode_negar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00721157","a","negável","N");
INSERT INTO portuguese_lemma VALUES ("a#00685949","a","que_não_se_pode_negar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00685949","a","inegável","N");
INSERT INTO portuguese_lemma VALUES ("a#00721636","a","incontestável","N");
INSERT INTO portuguese_lemma VALUES ("a#00686264","a","incontestável","N");
INSERT INTO portuguese_lemma VALUES ("n#00722061","n","Papel_social","Y");
INSERT INTO portuguese_lemma VALUES ("a#00722110","a","denotativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00489333","v","centrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01825948","v","centrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00722253","n","Papel_Social_de_Gênero","Y");
INSERT INTO portuguese_lemma VALUES ("n#00722253","n","Papel_social_de_gênero","Y");
INSERT INTO portuguese_lemma VALUES ("v#00722675","v","fascinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00725046","v","fascinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01232387","v","fascinar","N");
INSERT INTO portuguese_lemma VALUES ("v#01242449","v","fascinar","N");
INSERT INTO portuguese_lemma VALUES ("v#00722675","v","interessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01242774","v","interessar","N");
INSERT INTO portuguese_lemma VALUES ("v#01827745","v","interessar","N");
INSERT INTO portuguese_lemma VALUES ("n#00722984","n","arremessador","N");
INSERT INTO portuguese_lemma VALUES ("a#00723163","a","conotativa","N");
INSERT INTO portuguese_lemma VALUES ("a#00723163","a","conotativo","N");
INSERT INTO portuguese_lemma VALUES ("n#00723241","n","receptor","N");
INSERT INTO portuguese_lemma VALUES ("n#03217746","n","receptor","N");
INSERT INTO portuguese_lemma VALUES ("n#07143863","n","receptor","N");
INSERT INTO portuguese_lemma VALUES ("v#00723349","v","terlugar","N");
INSERT INTO portuguese_lemma VALUES ("v#00490373","v","levar_em_conta","Y");
INSERT INTO portuguese_lemma VALUES ("v#00724029","v","fazer_orçamento","Y");
INSERT INTO portuguese_lemma VALUES ("a#00724081","a","de_confiança","Y");
INSERT INTO portuguese_lemma VALUES ("a#00724081","a","fiável","N");
INSERT INTO portuguese_lemma VALUES ("a#02346141","a","fiável","N");
INSERT INTO portuguese_lemma VALUES ("a#02465519","a","fiável","N");
INSERT INTO portuguese_lemma VALUES ("a#00724081","a","fidedigno","N");
INSERT INTO portuguese_lemma VALUES ("a#01997748","a","fidedigno","N");
INSERT INTO portuguese_lemma VALUES ("a#00724081","a","confiável","N");
INSERT INTO portuguese_lemma VALUES ("a#02346141","a","confiável","N");
INSERT INTO portuguese_lemma VALUES ("a#02465519","a","confiável","N");
INSERT INTO portuguese_lemma VALUES ("a#00724081","a","digno_de_confiança","Y");
INSERT INTO portuguese_lemma VALUES ("a#02273326","a","digno_de_confiança","Y");
INSERT INTO portuguese_lemma VALUES ("a#02163862","a","digno_de_confiança","Y");
INSERT INTO portuguese_lemma VALUES ("a#02465519","a","digno_de_confiança","Y");
INSERT INTO portuguese_lemma VALUES ("v#00490924","v","reservar","N");
INSERT INTO portuguese_lemma VALUES ("v#01702479","v","reservar","N");
INSERT INTO portuguese_lemma VALUES ("a#00724596","a","procurado","N");
INSERT INTO portuguese_lemma VALUES ("v#00724664","v","precaver","N");
INSERT INTO portuguese_lemma VALUES ("v#00724664","v","precaver-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00491471","v","estontear","N");
INSERT INTO portuguese_lemma VALUES ("v#00491471","v","admirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01247189","v","admirar","N");
INSERT INTO portuguese_lemma VALUES ("v#01481912","v","admirar","N");
INSERT INTO portuguese_lemma VALUES ("v#00491471","v","espantar","N");
INSERT INTO portuguese_lemma VALUES ("v#00491471","v","assombrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00491581","v","assombrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01217847","v","assombrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00491471","v","surpreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00491581","v","surpreender","N");
INSERT INTO portuguese_lemma VALUES ("v#00492198","v","surpreender","N");
INSERT INTO portuguese_lemma VALUES ("v#01234366","v","surpreender","N");
INSERT INTO portuguese_lemma VALUES ("v#01771348","v","surpreender","N");
INSERT INTO portuguese_lemma VALUES ("a#00724861","a","não_confiável","Y");
INSERT INTO portuguese_lemma VALUES ("v#00725046","v","deslumbrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00725046","v","impressionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00493735","v","impressionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01206630","v","impressionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01207643","v","impressionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01770252","v","impressionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00725227","a","errático","N");
INSERT INTO portuguese_lemma VALUES ("v#00491581","v","sobressaltar","N");
INSERT INTO portuguese_lemma VALUES ("n#00725383","n","atacante","N");
INSERT INTO portuguese_lemma VALUES ("n#09821253","n","atacante","N");
INSERT INTO portuguese_lemma VALUES ("n#00725775","n","zagueiro","N");
INSERT INTO portuguese_lemma VALUES ("n#07095815","n","zagueiro","N");
INSERT INTO portuguese_lemma VALUES ("n#00725775","n","beque","N");
INSERT INTO portuguese_lemma VALUES ("n#07095815","n","beque","N");
INSERT INTO portuguese_lemma VALUES ("v#00492345","v","imputar","N");
INSERT INTO portuguese_lemma VALUES ("v#00492345","v","atribuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00726784","v","atribuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00493321","v","atribuir","N");
INSERT INTO portuguese_lemma VALUES ("v#00740053","v","atribuir","N");
INSERT INTO portuguese_lemma VALUES ("v#01524852","v","atribuir","N");
INSERT INTO portuguese_lemma VALUES ("n#00726369","n","linebacker","N");
INSERT INTO portuguese_lemma VALUES ("a#00726445","a","interdependente","N");
INSERT INTO portuguese_lemma VALUES ("n#00726567","n","quarterback","N");
INSERT INTO portuguese_lemma VALUES ("a#00726723","a","parasita","N");
INSERT INTO portuguese_lemma VALUES ("n#10252674","n","parasita","N");
INSERT INTO portuguese_lemma VALUES ("a#00727113","a","cofidente","N");
INSERT INTO portuguese_lemma VALUES ("a#00727268","a","simbiôntico","N");
INSERT INTO portuguese_lemma VALUES ("v#00727409","v","antropomorfizar","N");
INSERT INTO portuguese_lemma VALUES ("a#00691625","a","de_menor","Y");
INSERT INTO portuguese_lemma VALUES ("n#00727500","n","center","N");
INSERT INTO portuguese_lemma VALUES ("v#00727573","v","personificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01723690","v","personificar","N");
INSERT INTO portuguese_lemma VALUES ("v#01840295","v","personificar","N");
INSERT INTO portuguese_lemma VALUES ("n#00727743","n","guard","N");
INSERT INTO portuguese_lemma VALUES ("v#00727991","v","culpar","N");
INSERT INTO portuguese_lemma VALUES ("v#00842772","v","culpar","N");
INSERT INTO portuguese_lemma VALUES ("a#00692511","a","autônomo","N");
INSERT INTO portuguese_lemma VALUES ("a#00822609","a","autônomo","N");
INSERT INTO portuguese_lemma VALUES ("a#01009075","a","autônomo","N");
INSERT INTO portuguese_lemma VALUES ("a#02401440","a","autônomo","N");
INSERT INTO portuguese_lemma VALUES ("n#00728641","n","trabalho_escolar","Y");
INSERT INTO portuguese_lemma VALUES ("n#00729108","n","trabalho_escolar","Y");
INSERT INTO portuguese_lemma VALUES ("a#00728826","a","comutativa","N");
INSERT INTO portuguese_lemma VALUES ("a#00728826","a","comutativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00494146","v","compenetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00494146","v","aprofundar","N");
INSERT INTO portuguese_lemma VALUES ("v#00494146","v","compenetrar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00494146","v","penetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00836413","v","penetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01229071","v","penetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01769693","v","penetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#01993031","v","penetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#02018524","v","penetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#02019011","v","penetrar","N");
INSERT INTO portuguese_lemma VALUES ("n#00729108","n","lição_de_casa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00729108","n","dever_de_casa","Y");
INSERT INTO portuguese_lemma VALUES ("n#00729108","n","tarefa_de_casa","Y");
INSERT INTO portuguese_lemma VALUES ("v#00729109","v","traçar","N");
INSERT INTO portuguese_lemma VALUES ("v#01089750","v","traçar","N");
INSERT INTO portuguese_lemma VALUES ("v#01159988","v","traçar","N");
INSERT INTO portuguese_lemma VALUES ("v#00729109","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#00781491","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01357963","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01360914","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01363279","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01367094","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01383938","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01758181","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#02600255","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01797749","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("v#01859779","v","seguir","N");
INSERT INTO portuguese_lemma VALUES ("n#00469204","n","lição","N");
INSERT INTO portuguese_lemma VALUES ("n#00571937","n","lição","N");
INSERT INTO portuguese_lemma VALUES ("n#04955371","n","lição","N");
INSERT INTO portuguese_lemma VALUES ("n#05003239","n","lição","N");
INSERT INTO portuguese_lemma VALUES ("v#00729378","v","interrogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00533379","v","interrogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535464","v","interrogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00729378","v","perguntar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00729378","v","questionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00533379","v","questionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00535464","v","questionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00608227","v","questionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00625900","v","questionar","N");
INSERT INTO portuguese_lemma VALUES ("a#00729439","a","auto-suficiente","N");
INSERT INTO portuguese_lemma VALUES ("n#00469856","n","exercício","N");
INSERT INTO portuguese_lemma VALUES ("n#00574902","n","exercício","N");
INSERT INTO portuguese_lemma VALUES ("n#10917007","n","exercício","N");
INSERT INTO portuguese_lemma VALUES ("v#00494966","v","mencionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00689564","v","mencionar","N");
INSERT INTO portuguese_lemma VALUES ("v#01023574","v","mencionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00692561","v","mencionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00717396","v","mencionar","N");
INSERT INTO portuguese_lemma VALUES ("v#00495195","v","demarcar","N");
INSERT INTO portuguese_lemma VALUES ("n#00730538","n","vigia","N");
INSERT INTO portuguese_lemma VALUES ("n#03986562","n","vigia","N");
INSERT INTO portuguese_lemma VALUES ("n#00730538","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#00880662","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#06010550","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#08215801","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#06945104","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#10150071","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#07380622","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#07485319","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#07675146","n","guarda","N");
INSERT INTO portuguese_lemma VALUES ("n#00470944","n","missão","N");
INSERT INTO portuguese_lemma VALUES ("n#00471060","n","missão","N");
INSERT INTO portuguese_lemma VALUES ("n#00623965","n","missão","N");
INSERT INTO portuguese_lemma VALUES ("n#06213619","n","missão","N");
INSERT INTO portuguese_lemma VALUES ("n#06214058","n","missão","N");
INSERT INTO portuguese_lemma VALUES ("a#00730985","a","tendencioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00695128","a","tendencioso","N");
INSERT INTO portuguese_lemma VALUES ("v#00731000","v","capitalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02279772","v","capitalizar","N");
INSERT INTO portuguese_lemma VALUES ("v#02330742","v","capitalizar","N");
INSERT INTO portuguese_lemma VALUES ("n#00471384","n","recado","N");
INSERT INTO portuguese_lemma VALUES ("a#00731955","a","aliado","N");
INSERT INTO portuguese_lemma VALUES ("a#02476485","a","aliado","N");
INSERT INTO portuguese_lemma VALUES ("n#06165226","n","aliado","N");
INSERT INTO portuguese_lemma VALUES ("n#07070950","n","aliado","N");
INSERT INTO portuguese_lemma VALUES ("a#00732160","a","neutro","N");
INSERT INTO portuguese_lemma VALUES ("a#01424959","a","neutro","N");
INSERT INTO portuguese_lemma VALUES ("a#00732160","a","neutral","N");
INSERT INTO portuguese_lemma VALUES ("a#01818992","a","neutral","N");
INSERT INTO portuguese_lemma VALUES ("v#00732224","v","prestar","N");
INSERT INTO portuguese_lemma VALUES ("v#01588837","v","prestar","N");
INSERT INTO portuguese_lemma VALUES ("a#00697470","a","descritivo","N");
INSERT INTO portuguese_lemma VALUES ("a#00732682","a","descritivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00732394","v","resignar-se","N");
INSERT INTO portuguese_lemma VALUES ("v#00732394","v","resignar","N");
INSERT INTO portuguese_lemma VALUES ("v#01612615","v","resignar","N");
INSERT INTO portuguese_lemma VALUES ("v#02379198","v","resignar","N");
INSERT INTO portuguese_lemma VALUES ("v#01623278","v","resignar","N");
INSERT INTO portuguese_lemma VALUES ("a#02187633","a","normativo","N");
INSERT INTO portuguese_lemma VALUES ("a#02757372","a","normativo","N");
INSERT INTO portuguese_lemma VALUES ("v#00732552","v","observar","N");
INSERT INTO portuguese_lemma VALUES ("v#01449939","v","observar","N");
INSERT INTO portuguese_lemma VALUES ("v#01450271","v","observar","N");
INSERT INTO portuguese_lemma VALUES ("v#02130160","v","observar","N");
INSERT INTO portuguese_lemma VALUES ("v#01457770","v","observar","N");
INSERT INTO portuguese_lemma VALUES ("v#01485469","v","observar","N");
INSERT INTO portuguese_lemma VALUES ("v#01673353","v","observar","N");
INSERT INTO portuguese_lemma VALUES ("v#00732552","v","controlar","N");
INSERT INTO portuguese_lemma VALUES ("v#00834531","v","controlar","N");
INSERT INTO portuguese_lemma VALUES ("v#01230482","v","controlar","N");
INSERT INTO portuguese_lemma VALUES ("v#01481005","v","controlar","N");
INSERT INTO portuguese_lemma VALUES ("v#01664310","v","controlar","N");
INSERT INTO portuguese_lemma VALUES ("v#01711244","v","controlar","N");
INSERT INTO portuguese_lemma VALUES ("n#00472071","n","transgressão","N");
INSERT INTO portuguese_lemma VALUES ("n#00745005","n","transgressão","N");
INSERT INTO portuguese_lemma VALUES ("n#00472071","n","delito","N");
INSERT INTO portuguese_lemma VALUES ("a#00698075","a","desejável","N");
INSERT INTO portuguese_lemma VALUES ("a#00812035","a","desejável","N");
INSERT INTO portuguese_lemma VALUES ("v#00733250","v","fatorar","N");
INSERT INTO portuguese_lemma VALUES ("n#00472484","n","violação","N");
INSERT INTO portuguese_lemma VALUES ("n#00491673","n","violação","N");
INSERT INTO portuguese_lemma VALUES ("n#00770543","n","violação","N");
INSERT INTO portuguese_lemma VALUES ("n#00472484","n","invasão","N");
INSERT INTO portuguese_lemma VALUES ("n#00627831","n","invasão","N");
INSERT INTO portuguese_lemma VALUES ("n#00628646","n","invasão","N");
INSERT INTO portuguese_lemma VALUES ("n#00977132","n","invasão","N");
INSERT INTO portuguese_lemma VALUES ("n#05527236","n","invasão","N");
INSERT INTO portuguese_lemma VALUES ("a#00733541","a","invejável","N");
INSERT INTO portuguese_lemma VALUES ("a#00733743","a","preferível","N");
INSERT INTO portuguese_lemma VALUES ("v#00733895","v","acreditar_em","Y");
INSERT INTO portuguese_lemma VALUES ("a#00734318","a","destruído","N");
INSERT INTO portuguese_lemma VALUES ("a#01392646","a","destruído","N");
INSERT INTO portuguese_lemma VALUES ("v#00734348","v","pensar_sobre","Y");
INSERT INTO portuguese_lemma VALUES ("v#00734348","v","pensar_em","Y");
INSERT INTO portuguese_lemma VALUES ("v#00734587","v","abstrair","N");
INSERT INTO portuguese_lemma VALUES ("v#00734790","v","plantar","N");
INSERT INTO portuguese_lemma VALUES ("v#00656388","v","plantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01030643","v","plantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01079342","v","plantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01191107","v","plantar","N");
INSERT INTO portuguese_lemma VALUES ("v#00734790","v","implantar","N");
INSERT INTO portuguese_lemma VALUES ("v#01528821","v","implantar","N");
INSERT INTO portuguese_lemma VALUES ("a#00734906","a","estragado","N");
INSERT INTO portuguese_lemma VALUES ("a#00701326","a","enguiçado","N");
INSERT INTO portuguese_lemma VALUES ("n#00474548","n","mau_comportamento","Y");
INSERT INTO portuguese_lemma VALUES ("n#00736219","n","Delinquência_juvenil","Y");
INSERT INTO portuguese_lemma VALUES ("n#00736219","n","Delinqüência_juvenil","Y");
INSERT INTO portuguese_lemma VALUES ("a#00736299","a","ruim","N");
INSERT INTO portuguese_lemma VALUES ("a#01078381","a","ruim","N");
INSERT INTO portuguese_lemma VALUES ("a#01083652","a","ruim","N");
INSERT INTO portuguese_lemma VALUES ("a#01084323","a","ruim","N");
INSERT INTO portuguese_lemma VALUES ("a#00736671","a","esfarrapado","N");
INSERT INTO portuguese_lemma VALUES ("a#02434210","a","esfarrapado","N");
INSERT INTO portuguese_lemma VALUES ("a#02582697","a","esfarrapado","N");
INSERT INTO portuguese_lemma VALUES ("v#00736799","v","recriar","N");
INSERT INTO portuguese_lemma VALUES ("v#01113585","v","recriar","N");
INSERT INTO portuguese_lemma VALUES ("n#00475542","n","Anormalidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00475542","n","anormalidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03764247","n","anormalidade","N");
INSERT INTO portuguese_lemma VALUES ("n#04367023","n","anormalidade","N");
INSERT INTO portuguese_lemma VALUES ("n#10403506","n","anormalidade","N");
INSERT INTO portuguese_lemma VALUES ("n#14505667","n","anormalidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00475542","n","irregularidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03745305","n","irregularidade","N");
INSERT INTO portuguese_lemma VALUES ("n#03954192","n","irregularidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00475699","n","Sociologia_do_desvio","Y");
INSERT INTO portuguese_lemma VALUES ("n#00475699","n","Comportamento_divergente","Y");
INSERT INTO portuguese_lemma VALUES ("a#00737432","a","conservado","N");
INSERT INTO portuguese_lemma VALUES ("v#00737476","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00733757","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00825349","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00826212","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("v#00827658","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01084280","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01575110","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("v#01575585","v","capturar","N");
INSERT INTO portuguese_lemma VALUES ("a#00737703","a","protegido","N");
INSERT INTO portuguese_lemma VALUES ("a#01812371","a","protegido","N");
INSERT INTO portuguese_lemma VALUES ("n#10485989","n","protegido","N");
INSERT INTO portuguese_lemma VALUES ("n#00737705","n","parafilia","N");
INSERT INTO portuguese_lemma VALUES ("n#00737705","n","Parafilia","N");
INSERT INTO portuguese_lemma VALUES ("a#00737801","a","mantido","N");
INSERT INTO portuguese_lemma VALUES ("n#00737894","n","exibicionismo","N");
INSERT INTO portuguese_lemma VALUES ("n#06889701","n","exibicionismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00737973","a","destrutível","N");
INSERT INTO portuguese_lemma VALUES ("n#00738058","n","fetiche","N");
INSERT INTO portuguese_lemma VALUES ("n#01207342","n","fetiche","N");
INSERT INTO portuguese_lemma VALUES ("n#03603958","n","fetiche","N");
INSERT INTO portuguese_lemma VALUES ("n#00738270","n","pedofilia","N");
INSERT INTO portuguese_lemma VALUES ("n#10412669","n","pedofilia","N");
INSERT INTO portuguese_lemma VALUES ("a#00738368","a","indestrutível","N");
INSERT INTO portuguese_lemma VALUES ("n#00738372","n","voyeurismo","N");
INSERT INTO portuguese_lemma VALUES ("a#00738593","a","determinável","N");
INSERT INTO portuguese_lemma VALUES ("n#00738598","n","zoofilia","N");
INSERT INTO portuguese_lemma VALUES ("n#00858060","n","zoofilia","N");
INSERT INTO portuguese_lemma VALUES ("n#00738598","n","zoossexualidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00858060","n","zoossexualidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00738697","n","obscenidade","N");
INSERT INTO portuguese_lemma VALUES ("n#04903678","n","obscenidade","N");
INSERT INTO portuguese_lemma VALUES ("n#05331114","n","obscenidade","N");
INSERT INTO portuguese_lemma VALUES ("a#00738829","a","averiguável","N");
INSERT INTO portuguese_lemma VALUES ("a#00738829","a","constatável","N");
INSERT INTO portuguese_lemma VALUES ("a#00738829","a","verificável","N");
INSERT INTO portuguese_lemma VALUES ("a#00739789","a","imprevisível","N");
INSERT INTO portuguese_lemma VALUES ("a#01842001","a","imprevisível","N");
INSERT INTO portuguese_lemma VALUES ("a#00705447","a","inváriavel","N");
INSERT INTO portuguese_lemma VALUES ("v#00502333","v","comunicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00591857","v","comunicar","N");
INSERT INTO portuguese_lemma VALUES ("v#00502333","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00503459","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00503786","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00628262","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00655894","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00658752","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00719161","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00982468","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#00983791","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01422262","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01424107","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01527254","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01568149","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("v#01570315","v","transmitir","N");
INSERT INTO portuguese_lemma VALUES ("n#00741797","n","evasão_fiscal","Y");
INSERT INTO portuguese_lemma VALUES ("n#00741925","n","prevaricação","N");
INSERT INTO portuguese_lemma VALUES ("n#00742645","n","desperdício","N");
INSERT INTO portuguese_lemma VALUES ("n#04894964","n","desperdício","N");
INSERT INTO portuguese_lemma VALUES ("a#00742714","a","rudimentar","N");
INSERT INTO portuguese_lemma VALUES ("a#01784703","a","rudimentar","N");
INSERT INTO portuguese_lemma VALUES ("v#00743344","v","contactar","N");
INSERT INTO portuguese_lemma VALUES ("v#00743344","v","entrar_em_contato","Y");
INSERT INTO portuguese_lemma VALUES ("v#00743344","v","manter_contato_com","Y");
INSERT INTO portuguese_lemma VALUES ("v#00743344","v","estar_em_contato_com","Y");
INSERT INTO portuguese_lemma VALUES ("v#00743344","v","ter_contato_com","Y");
INSERT INTO portuguese_lemma VALUES ("v#00743344","v","contatar","N");
INSERT INTO portuguese_lemma VALUES ("a#00744141","a","adiabático","N");
INSERT INTO portuguese_lemma VALUES ("n#13427481","n","adiabático","N");
INSERT INTO portuguese_lemma VALUES ("a#00744277","a","diferenciado","N");
INSERT INTO portuguese_lemma VALUES ("a#02277829","a","diferenciado","N");
INSERT INTO portuguese_lemma VALUES ("n#00479886","n","injustiça","N");
INSERT INTO portuguese_lemma VALUES ("n#03804255","n","injustiça","N");
INSERT INTO portuguese_lemma VALUES ("a#00797776","a","intrincado","N");
INSERT INTO portuguese_lemma VALUES ("a#02091753","a","intrincado","N");
INSERT INTO portuguese_lemma VALUES ("a#02178500","a","intrincado","N");
INSERT INTO portuguese_lemma VALUES ("a#00797776","a","foda","N");
INSERT INTO portuguese_lemma VALUES ("n#00543107","n","foda","N");
INSERT INTO portuguese_lemma VALUES ("a#00797776","a","difícil","N");
INSERT INTO portuguese_lemma VALUES ("a#00711482","a","difícil","N");
INSERT INTO portuguese_lemma VALUES ("a#00748795","a","difícil","N");
INSERT INTO portuguese_lemma VALUES ("a#00797776","a","árduo","N");
INSERT INTO portuguese_lemma VALUES ("a#01648301","a","árduo","N");
INSERT INTO portuguese_lemma VALUES ("n#00745431","n","abominação","N");
INSERT INTO portuguese_lemma VALUES ("n#05577676","n","abominação","N");
INSERT INTO portuguese_lemma VALUES ("n#05577810","n","abominação","N");
INSERT INTO portuguese_lemma VALUES ("n#05577970","n","abominação","N");
INSERT INTO portuguese_lemma VALUES ("n#07547805","n","abominação","N");
INSERT INTO portuguese_lemma VALUES ("v#00505537","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00752493","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00510998","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00753428","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00753734","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00531494","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#00540576","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#01018065","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#01553614","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#01611740","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("v#01702479","v","pedir","N");
INSERT INTO portuguese_lemma VALUES ("n#00745637","n","imoralidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00481262","n","imoralidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00745637","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#00480585","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#04842313","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#03802516","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#03844003","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#04007415","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#04007891","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#07550369","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#07550666","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("n#10442294","n","maldade","N");
INSERT INTO portuguese_lemma VALUES ("a#00711113","a","laborioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00719289","a","laborioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00711113","a","complicado","N");
INSERT INTO portuguese_lemma VALUES ("a#02093020","a","complicado","N");
INSERT INTO portuguese_lemma VALUES ("a#00745858","a","arduo","N");
INSERT INTO portuguese_lemma VALUES ("a#00797350","a","arduo","N");
INSERT INTO portuguese_lemma VALUES ("a#00837977","a","arduo","N");
INSERT INTO portuguese_lemma VALUES ("n#00480876","n","irreverência","N");
INSERT INTO portuguese_lemma VALUES ("n#06207733","n","irreverência","N");
INSERT INTO portuguese_lemma VALUES ("a#00711868","a","frustrante","N");
INSERT INTO portuguese_lemma VALUES ("n#00746587","n","sacrilégio","N");
INSERT INTO portuguese_lemma VALUES ("n#00746587","n","Profanação","N");
INSERT INTO portuguese_lemma VALUES ("n#00746587","n","blasfêmia","N");
INSERT INTO portuguese_lemma VALUES ("n#07124172","n","blasfêmia","N");
INSERT INTO portuguese_lemma VALUES ("n#00746587","n","profanação","N");
INSERT INTO portuguese_lemma VALUES ("n#05333774","n","profanação","N");
INSERT INTO portuguese_lemma VALUES ("n#00746587","n","blasfémia","N");
INSERT INTO portuguese_lemma VALUES ("n#07124172","n","blasfémia","N");
INSERT INTO portuguese_lemma VALUES ("v#00506398","v","impetrar","N");
INSERT INTO portuguese_lemma VALUES ("v#00506398","v","mandar","N");
INSERT INTO portuguese_lemma VALUES ("v#00698219","v","mandar","N");
INSERT INTO portuguese_lemma VALUES ("a#00746819","a","complicada","N");
INSERT INTO portuguese_lemma VALUES ("a#00712274","a","cócegozo","N");
INSERT INTO portuguese_lemma VALUES ("a#00712274","a","sensitivo","N");
INSERT INTO portuguese_lemma VALUES ("n#10488309","n","sensitivo","N");
INSERT INTO portuguese_lemma VALUES ("v#00506658","v","receitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00506658","v","prescrever","N");
INSERT INTO portuguese_lemma VALUES ("v#00506658","v","comandar","N");
INSERT INTO portuguese_lemma VALUES ("v#01662020","v","comandar","N");
INSERT INTO portuguese_lemma VALUES ("n#00747215","n","Pornografia","N");
INSERT INTO portuguese_lemma VALUES ("n#00747215","n","pornografia","N");
INSERT INTO portuguese_lemma VALUES ("n#00747215","n","filme_pornô","Y");
INSERT INTO portuguese_lemma VALUES ("n#00747215","n","pornô","N");
INSERT INTO portuguese_lemma VALUES ("n#00747519","n","pornografia_infantil","Y");
INSERT INTO portuguese_lemma VALUES ("n#00482009","n","prostituição","N");
INSERT INTO portuguese_lemma VALUES ("n#00748307","n","devassidão","N");
INSERT INTO portuguese_lemma VALUES ("n#00748307","n","dissolução","N");
INSERT INTO portuguese_lemma VALUES ("n#00482267","n","bebida","N");
INSERT INTO portuguese_lemma VALUES ("n#00540820","n","bebida","N");
INSERT INTO portuguese_lemma VALUES ("n#00540981","n","bebida","N");
INSERT INTO portuguese_lemma VALUES ("n#05908749","n","bebida","N");
INSERT INTO portuguese_lemma VALUES ("n#05910601","n","bebida","N");
INSERT INTO portuguese_lemma VALUES ("n#05911542","n","bebida","N");
INSERT INTO portuguese_lemma VALUES ("n#09270508","n","bebida","N");
INSERT INTO portuguese_lemma VALUES ("a#00748674","a","espinhoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00748674","a","cheio_de_espinhos","Y");
INSERT INTO portuguese_lemma VALUES ("a#00748795","a","problemático","N");
INSERT INTO portuguese_lemma VALUES ("a#01846685","a","problemático","N");
INSERT INTO portuguese_lemma VALUES ("a#00749040","a","controvertido","N");
INSERT INTO portuguese_lemma VALUES ("n#00749105","n","Pub_crawl","Y");
INSERT INTO portuguese_lemma VALUES ("n#00749574","n","desonestidade","N");
INSERT INTO portuguese_lemma VALUES ("n#04874672","n","desonestidade","N");
INSERT INTO portuguese_lemma VALUES ("n#00482966","n","traição","N");
INSERT INTO portuguese_lemma VALUES ("n#00500041","n","traição","N");
INSERT INTO portuguese_lemma VALUES ("n#03822672","n","traição","N");
INSERT INTO portuguese_lemma VALUES ("n#04879879","n","traição","N");
INSERT INTO portuguese_lemma VALUES ("n#04879964","n","traição","N");
INSERT INTO portuguese_lemma VALUES ("n#10027590","n","traição","N");
INSERT INTO portuguese_lemma VALUES ("n#00750306","n","charlatanismo","N");
INSERT INTO portuguese_lemma VALUES ("n#00750405","n","Pirataria","N");
INSERT INTO portuguese_lemma VALUES ("n#00750405","n","plágio","N");
INSERT INTO portuguese_lemma VALUES ("n#07277158","n","plágio","N");
INSERT INTO portuguese_lemma VALUES ("n#00750405","n","pirata","N");
INSERT INTO portuguese_lemma VALUES ("n#10435367","n","pirata","N");
INSERT INTO portuguese_lemma VALUES ("a#00750712","a","indolor","N");
INSERT INTO portuguese_lemma VALUES ("a#01713095","a","indolor","N");
INSERT INTO portuguese_lemma VALUES ("a#00750843","a","simplificado","N");
INSERT INTO portuguese_lemma VALUES ("n#00751145","n","falsificação","N");
INSERT INTO portuguese_lemma VALUES ("n#00768921","n","falsificação","N");
INSERT INTO portuguese_lemma VALUES ("n#03562126","n","falsificação","N");
INSERT INTO portuguese_lemma VALUES ("n#03562262","n","falsificação","N");
INSERT INTO portuguese_lemma VALUES ("a#00751353","a","plantígrados","N");
INSERT INTO portuguese_lemma VALUES ("a#00716336","a","digno","N");
INSERT INTO portuguese_lemma VALUES ("a#02513269","a","digno","N");
INSERT INTO portuguese_lemma VALUES ("a#02461416","a","digno","N");
INSERT INTO portuguese_lemma VALUES ("a#02462532","a","digno","N");
INSERT INTO portuguese_lemma VALUES ("v#00510062","v","dar_ordem","Y");
INSERT INTO portuguese_lemma VALUES ("n#00484777","n","mentira","N");
INSERT INTO portuguese_lemma VALUES ("n#03820287","n","mentira","N");
INSERT INTO portuguese_lemma VALUES ("n#05062653","n","mentira","N");
INSERT INTO portuguese_lemma VALUES ("n#05063005","n","mentira","N");
INSERT INTO portuguese_lemma VALUES ("n#05063177","n","mentira","N");
INSERT INTO portuguese_lemma VALUES ("n#13960464","n","mentira","N");
INSERT INTO portuguese_lemma VALUES ("a#00752110","a","distinto","N");
INSERT INTO portuguese_lemma VALUES ("a#01225735","a","distinto","N");
INSERT INTO portuguese_lemma VALUES ("a#01989737","a","distinto","N");
INSERT INTO portuguese_lemma VALUES ("a#02036455","a","distinto","N");
INSERT INTO portuguese_lemma VALUES ("n#00752431","n","dissimulação","N");
INSERT INTO portuguese_lemma VALUES ("n#00752431","n","enganação","N");
INSERT INTO portuguese_lemma VALUES ("a#00752555","a","degradante","N");
INSERT INTO portuguese_lemma VALUES ("a#01228050","a","degradante","N");
INSERT INTO portuguese_lemma VALUES ("a#01611490","a","degradante","N");
INSERT INTO portuguese_lemma VALUES ("v#00510998","v","exigir","N");
INSERT INTO portuguese_lemma VALUES ("v#00512630","v","exigir","N");
INSERT INTO portuguese_lemma VALUES ("v#00687967","v","exigir","N");
INSERT INTO portuguese_lemma VALUES ("v#00510998","v","solicitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00721528","v","solicitar","N");
INSERT INTO portuguese_lemma VALUES ("v#00510998","v","rogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00753428","v","rogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00515892","v","rogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00516106","v","rogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00516262","v","rogar","N");
INSERT INTO portuguese_lemma VALUES ("v#00531494","v","rogar","N");
INSERT INTO portuguese_lemma VALUES ("a#00717534","a","ridículo","N");
INSERT INTO portuguese_lemma VALUES ("a#01214625","a","ridículo","N");
INSERT INTO portuguese_lemma VALUES ("n#00485559","n","astúcia","N");
INSERT INTO portuguese_lemma VALUES ("n#05621178","n","astúcia","N");
INSERT INTO portuguese_lemma VALUES ("n#04353391","n","astúcia","N");
INSERT INTO portuguese_lemma VALUES ("a#00753504","a","presidencial","N");
INSERT INTO portuguese_lemma VALUES ("a#02747901","a","presidencial","N");
INSERT INTO portuguese_lemma VALUES ("n#00485959","n","hoax","N");
INSERT INTO portuguese_lemma VALUES ("n#00485959","n","fraude","N");
INSERT INTO portuguese_lemma VALUES ("a#00754107","a","diligente","N");
INSERT INTO portuguese_lemma VALUES ("a#00719289","a","diligente","N");
INSERT INTO portuguese_lemma VALUES ("a#00841997","a","diligente","N");
INSERT INTO portuguese_lemma VALUES ("a#01736122","a","diligente","N");
INSERT INTO portuguese_lemma VALUES ("n#00754280","n","pilantragem","N");
INSERT INTO portuguese_lemma VALUES ("a#00719072","a","assíduo","N");
INSERT INTO portuguese_lemma VALUES ("a#00719289","a","assíduo","N");
INSERT INTO portuguese_lemma VALUES ("v#00512256","v","requisitar","N");
INSERT INTO portuguese_lemma VALUES ("a#00719289","a","aplicado","N");
INSERT INTO portuguese_lemma VALUES ("a#02876509","a","aplicado","N");
INSERT INTO portuguese_lemma VALUES ("a#00719289","a","operoso","N");
INSERT INTO portuguese_lemma VALUES ("a#00719289","a","esforçado","N");
INSERT INTO portuguese_lemma VALUES ("a#00719289","a","trabalhador","N");
INSERT INTO portuguese_lemma VALUES ("n#06957738","n","trabalhador","N");
INSERT INTO portuguese_lemma VALUES ("n#07240707","n","trabalhador","N");
INSERT INTO portuguese_lemma VALUES ("n#07360164","n","trabalhador","N");
INSERT INTO portuguese_lemma VALUES ("n#07505214","n","trabalhador","N");
INSERT INTO portuguese_lemma VALUES ("n#07687635","n","trabalhador","N");
INSERT INTO portuguese_lemma VALUES ("n#00486766","n","delírio","N");
INSERT INTO portuguese_lemma VALUES ("n#10323024","n","delírio","N");
INSERT INTO portuguese_lemma VALUES ("n#10326963","n","delírio","N");
INSERT INTO portuguese_lemma VALUES ("a#00754873","a","desatencioso","N");
INSERT INTO portuguese_lemma VALUES ("a#00754873","a","sem_cuidado","Y");
INSERT INTO portuguese_lemma VALUES ("v#00512630","v","demandar","N");
INSERT INTO portuguese_lemma VALUES ("n#00487065","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#03683012","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#04674715","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#03686135","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#03686637","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#03687137","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#03687267","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#03687456","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("n#04561534","n","aparência","N");
INSERT INTO portuguese_lemma VALUES ("a#02214365","a","lasso","N");
INSERT INTO portuguese_lemma VALUES ("a#02403671","a","lasso","N");
INSERT INTO portuguese_lemma VALUES ("a#02405160","a","lasso","N");
INSERT INTO portuguese_lemma VALUES ("n#00755500","n","finja","N");
INSERT INTO portuguese_lemma VALUES ("n#00755673","n","fingimento","N");
INSERT INTO portuguese_lemma VALUES ("n#05063809","n","fingimento","N");
INSERT INTO portuguese_lemma VALUES ("n#00755673","n","ação_de_fingir","Y");
INSERT INTO portuguese_lemma VALUES ("n#00755673","n","ação_de_afectar","Y");
INSERT INTO portuguese_lemma VALUES ("n#00755673","n","afetação","N");
INSERT INTO portuguese_lemma VALUES ("v#00513425","v","requerer","N");
INSERT INTO portuguese_lemma VALUES ("v#00721528","v","requerer","N");
INSERT INTO portuguese_lemma VALUES ("v#00808096","v","requerer","N");
INSERT INTO portuguese_lemma VALUES ("n#00487495","n","postura","N");
INSERT INTO portuguese_lemma VALUES ("n#03965003","n","postura","N");
INSERT INTO portuguese_lemma VALUES ("n#05082507","n","postura","N");
INSERT INTO portuguese_lemma VALUES ("n#04697893","n","postura","N");
INSERT INTO portuguese_lemma VALUES ("v#00756076","v","custar","N");
INSERT INTO portuguese_lemma VALUES ("v#01793319","v","custar","N");
INSERT INTO portuguese_lemma VALUES ("v#01843641","v","custar","N");
INSERT INTO portuguese_lemma VALUES ("a#00756091","a","diluído","N");
INSERT INTO portuguese_lemma VALUES ("n#00756194","n","mascarada","N");
INSERT INTO portuguese_lemma VALUES ("a#00720832","a","aquoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02153394","a","aquoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02429238","a","aquoso","N");
INSERT INTO portuguese_lemma VALUES ("a#02499433","a","