# Host: 	    Database: 	    Date:
# ---------------------------------------------------------
#

DROP TABLE IF EXISTS portuguese_index;
CREATE TABLE portuguese_index (lemma VARCHAR(255)  NOT NULL PRIMARY KEY,id_n TEXT,id_v TEXT,id_a TEXT,id_r TEXT);

INSERT INTO portuguese_index VALUES ("capaz","NULL","NULL","a#00001740 a#00053037 a#00053327 a#00138021 a#00301090 a#00301385 a#00301854 a#00302615 a#00476218 a#00812035 a#00968256 a#01077975 a#01316335 a#01317331","NULL");
INSERT INTO portuguese_index VALUES ("ente","n#00001740","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entidade","n#00001740","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ser","n#00001740 n#00004258 n#00002086 n#00008019 n#07192170 n#10054265","v#01717851 v#01775163 v#01775973","NULL","NULL");
INSERT INTO portuguese_index VALUES ("a_capela","NULL","NULL","NULL","r#00001740");
INSERT INTO portuguese_index VALUES ("espirar","NULL","v#00001740 v#00529549","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respirar","NULL","v#00001740 v#00529549 v#01784886","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entidade_física","n#00001930","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incapaz","NULL","NULL","a#00002062 a#00054157 a#00477567 a#00302770 a#00477390 a#01754281","NULL");
INSERT INTO portuguese_index VALUES ("entidade_abstrata","n#00013018","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abstração","n#00013018","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("idéia_abstrata","n#00013018","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dorsal","n#05557500","NULL","a#00002312 a#00132127","NULL");
INSERT INTO portuguese_index VALUES ("coisa","n#00002452 n#00020709 n#02586441 n#03495843","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dificilmente","NULL","NULL","NULL","r#00002621 r#00003093");
INSERT INTO portuguese_index VALUES ("quasenão","NULL","NULL","NULL","r#00002621");
INSERT INTO portuguese_index VALUES ("quase_não","NULL","NULL","NULL","r#00002621");
INSERT INTO portuguese_index VALUES ("logoque","NULL","NULL","NULL","r#00002621");
INSERT INTO portuguese_index VALUES ("objeto_físico","n#00009457","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("objeto","n#00009457 n#05810948 n#06132724 n#04761832","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hiperventilar","NULL","v#00002942 v#00003133","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apenas","NULL","NULL","NULL","r#00003093 r#00004722 r#00008600 r#00011011");
INSERT INTO portuguese_index VALUES ("arrotar","NULL","v#00003431","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_essência","NULL","NULL","NULL","r#00003483");
INSERT INTO portuguese_index VALUES ("basicamente","NULL","NULL","NULL","r#00003483");
INSERT INTO portuguese_index VALUES ("fundamentalmente","NULL","NULL","NULL","r#00003483");
INSERT INTO portuguese_index VALUES ("essencialmente","NULL","NULL","NULL","r#00003483");
INSERT INTO portuguese_index VALUES ("emergente","NULL","NULL","a#00003469 a#01733082","NULL");
INSERT INTO portuguese_index VALUES ("unidade","n#03614902 n#03727089 n#06683928 n#09760609 n#09946775","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("todo","n#03614902","NULL","a#02269635","NULL");
INSERT INTO portuguese_index VALUES ("soluçar","NULL","v#00003826","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parturiente","NULL","NULL","a#00003829","NULL");
INSERT INTO portuguese_index VALUES ("parturienta","NULL","NULL","a#00003829","NULL");
INSERT INTO portuguese_index VALUES ("congênere","n#00003993","NULL","a#02989167","NULL");
INSERT INTO portuguese_index VALUES ("suspirar","NULL","v#00003011 v#00667147 v#01247460","NULL","NULL");
INSERT INTO portuguese_index VALUES ("moribundo","NULL","NULL","a#00004171","NULL");
INSERT INTO portuguese_index VALUES ("negativamente","NULL","NULL","NULL","r#00004184 r#00004288");
INSERT INTO portuguese_index VALUES ("axalar","NULL","v#00004227","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expirar","NULL","v#00004227","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ser_vivo","n#00004258 n#00002086","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("organismo","n#00004258 n#00002086 n#06239959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amavelmente","NULL","NULL","NULL","r#00004394 r#00165561 r#00187028");
INSERT INTO portuguese_index VALUES ("naturalmente","NULL","NULL","NULL","r#00004394 r#00038625 r#00140403 r#00488773 r#00505352");
INSERT INTO portuguese_index VALUES ("abreviado","NULL","NULL","a#00004413 a#01436432 a#01436791 a#01442597","NULL");
INSERT INTO portuguese_index VALUES ("criatura","n#00002086 n#00008019 n#07192170","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emanar","NULL","v#00004605 v#00381814 v#00546192","NULL","NULL");
INSERT INTO portuguese_index VALUES ("todavia","NULL","NULL","NULL","r#00004722");
INSERT INTO portuguese_index VALUES ("simplesmente","NULL","NULL","NULL","r#00004722 r#00005055");
INSERT INTO portuguese_index VALUES ("meramente","NULL","NULL","NULL","r#00004722");
INSERT INTO portuguese_index VALUES ("somente","NULL","NULL","NULL","r#00004722 r#00008600 r#00011011");
INSERT INTO portuguese_index VALUES ("só","NULL","NULL","a#02143677","r#00004722");
INSERT INTO portuguese_index VALUES ("espirrar","NULL","v#00004819","NULL","NULL");
INSERT INTO portuguese_index VALUES ("singelamente","NULL","NULL","NULL","r#00004967 r#00246296");
INSERT INTO portuguese_index VALUES ("inalar","NULL","v#00003763","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inspirar","NULL","v#00003763 v#00582621","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perfeito","n#13804889","NULL","a#00005515 a#00595724 a#01686285 a#01687891","NULL");
INSERT INTO portuguese_index VALUES ("absoluto","NULL","NULL","a#00005515 a#00684153","NULL");
INSERT INTO portuguese_index VALUES ("possivelmente","NULL","NULL","NULL","r#00005343 r#00300247");
INSERT INTO portuguese_index VALUES ("bufar","NULL","v#00005526 v#01045073","NULL","NULL");
INSERT INTO portuguese_index VALUES ("automaticamente","NULL","NULL","NULL","r#00005567 r#00114029");
INSERT INTO portuguese_index VALUES ("implícito","NULL","NULL","a#00005599 a#00941485 a#00894544","NULL");
INSERT INTO portuguese_index VALUES ("infinito","n#00028651","NULL","a#00006265 a#00297667 a#00955713 a#00956714 a#01382215","NULL");
INSERT INTO portuguese_index VALUES ("imensamente","NULL","NULL","NULL","r#00005779");
INSERT INTO portuguese_index VALUES ("enormemente","NULL","NULL","NULL","r#00005779 r#00196540 r#00461617");
INSERT INTO portuguese_index VALUES ("bentos","n#00005787","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tossir","NULL","v#00005815 v#00121607","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anão","n#00005930 n#09541125 n#10040344","NULL","a#01393024","NULL");
INSERT INTO portuguese_index VALUES ("Heterotrofismo","n#00006024","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relativo","NULL","NULL","a#00007066 a#00450284","NULL");
INSERT INTO portuguese_index VALUES ("grosseiramente","NULL","NULL","NULL","r#00006034");
INSERT INTO portuguese_index VALUES ("indelicadamente","NULL","NULL","NULL","r#00006034");
INSERT INTO portuguese_index VALUES ("em_grande_parte","NULL","NULL","NULL","r#00006105 r#00065359");
INSERT INTO portuguese_index VALUES ("em_maior_número_das_ocasiões","NULL","NULL","NULL","r#00006105");
INSERT INTO portuguese_index VALUES ("maioritariamente","NULL","NULL","NULL","r#00006105");
INSERT INTO portuguese_index VALUES ("pela_maior_parte","NULL","NULL","NULL","r#00006105");
INSERT INTO portuguese_index VALUES ("pais","n#00006150","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("progenitor","n#00006150 n#10399491","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expectorar","NULL","v#00006238","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cuspir","NULL","v#00006238 v#00069271 v#00069431 v#02757182","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relacional","NULL","NULL","a#00006245","NULL");
INSERT INTO portuguese_index VALUES ("notavelmente","NULL","NULL","NULL","r#00006259 r#00139266 r#00328378");
INSERT INTO portuguese_index VALUES ("significativamente","NULL","NULL","NULL","r#00006259 r#00367868 r#00509970");
INSERT INTO portuguese_index VALUES ("vida","n#00002880 n#03653606 n#03654105 n#04477455 n#06659588 n#07373813 n#07810857 n#10059340 n#13961642 n#10060845 n#10865688 n#10866015 n#10866163 n#15141059","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hidrófilo","NULL","NULL","a#00006336","NULL");
INSERT INTO portuguese_index VALUES ("absorvente","NULL","NULL","a#00006336 a#01290570","NULL");
INSERT INTO portuguese_index VALUES ("bionte","n#00006400","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protobionte","n#00006400","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("célula","n#00003095 n#02410439 n#06189358","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respirar_ruidosamente","NULL","v#00006697","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assoprar","NULL","v#00005052","NULL","NULL");
INSERT INTO portuguese_index VALUES ("soprar","NULL","v#00005052 v#01892072 v#02769642","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_ou_menos","NULL","NULL","a#01615410","r#00007015");
INSERT INTO portuguese_index VALUES ("cerca_de","NULL","NULL","NULL","r#00007015 r#00071456");
INSERT INTO portuguese_index VALUES ("aproximadamente","NULL","NULL","NULL","r#00007015");
INSERT INTO portuguese_index VALUES ("cerca","n#02670460 n#14859100","NULL","NULL","r#00007015");
INSERT INTO portuguese_index VALUES ("abrir_a_boca","NULL","v#00007328","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bocejar","NULL","v#00007328 v#02718750","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agente_causador","n#00003731","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("causador","n#00003731","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("causa","n#00003731 n#00509919 n#00765298 n#01182654 n#05460141 n#06659860","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deveras","NULL","NULL","NULL","r#00007488");
INSERT INTO portuguese_index VALUES ("esponjoso","NULL","NULL","a#00007516 a#01154964","NULL");
INSERT INTO portuguese_index VALUES ("em_parte","NULL","NULL","NULL","r#00007703");
INSERT INTO portuguese_index VALUES ("parcialmente","NULL","NULL","NULL","r#00007703");
INSERT INTO portuguese_index VALUES ("pestanejar","NULL","v#00007739 v#02160177","NULL","NULL");
INSERT INTO portuguese_index VALUES ("piscar","NULL","v#00007739 v#02160177","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alguém","n#00004123 n#06831177","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ser_humano","n#00004123 n#01967203","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pessoa","n#00004123 n#03643456 n#04056183 n#04774665 n#07337458 n#07392506 n#07426815","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indivíduo","n#00004123 n#07337458","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resistente","NULL","NULL","a#00008724 a#00661296 a#00673790 a#01709288","NULL");
INSERT INTO portuguese_index VALUES ("ao_todo","NULL","NULL","NULL","r#00008007");
INSERT INTO portuguese_index VALUES ("totalmente","NULL","NULL","NULL","r#00008007");
INSERT INTO portuguese_index VALUES ("cem_por_cento","NULL","NULL","NULL","r#00008007 r#00008997");
INSERT INTO portuguese_index VALUES ("cabalmente","NULL","NULL","NULL","r#00008007");
INSERT INTO portuguese_index VALUES ("completamente","NULL","NULL","NULL","r#00008007 r#00010466");
INSERT INTO portuguese_index VALUES ("inteiramente","NULL","NULL","NULL","r#00008007 r#00008997");
INSERT INTO portuguese_index VALUES ("piscar_o_olho","NULL","v#00008299","NULL","NULL");
INSERT INTO portuguese_index VALUES ("piscar_de_olhos","NULL","v#00005779","NULL","NULL");
INSERT INTO portuguese_index VALUES ("piscar_os_olhos","NULL","v#00005779","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exclusive","NULL","NULL","NULL","r#00008600");
INSERT INTO portuguese_index VALUES ("unicamente","NULL","NULL","NULL","r#00008600 r#00175490");
INSERT INTO portuguese_index VALUES ("não_mais_que","NULL","NULL","NULL","r#00008600");
INSERT INTO portuguese_index VALUES ("exclusivamente","NULL","NULL","NULL","r#00008600 r#00175490");
INSERT INTO portuguese_index VALUES ("ser_vesgo","NULL","v#00008602","NULL","NULL");
INSERT INTO portuguese_index VALUES ("olhar_de_soslaio","NULL","v#00008602","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vesguear","NULL","v#00008602","NULL","NULL");
INSERT INTO portuguese_index VALUES ("100_por_cento","NULL","NULL","NULL","r#00008997");
INSERT INTO portuguese_index VALUES ("de_cabo_a_rabo","NULL","NULL","NULL","r#00008997");
INSERT INTO portuguese_index VALUES ("absolutamente","NULL","NULL","NULL","r#00008997");
INSERT INTO portuguese_index VALUES ("desplumar","NULL","v#00006226","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depenar","NULL","v#00006226","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trocar","NULL","v#00006226 v#00081068 v#00081221 v#00111031 v#00161987 v#00169458 v#00384218 v#00551065 v#00584410 v#01544679 v#01545057 v#02259005 v#02259241 v#01630321","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mudar","NULL","v#00006226 v#00074063 v#00077276 v#00079689 v#00082064 v#00083639 v#00083947 v#00140123 v#00111031 v#00169458 v#00201342 v#00266041 v#00385513 v#00551210 v#00389126 v#00389297 v#00584410 v#01855606","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descamar","NULL","v#00009492","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descamar-se","NULL","v#00009492","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ascético","NULL","NULL","a#00009618 a#02644177","NULL");
INSERT INTO portuguese_index VALUES ("saculejar","NULL","v#00006497","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tremer","NULL","v#00006497 v#00009323 v#00009431 v#01289419 v#01888784 v#01289759 v#01289878 v#01289996","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perfeitamente","NULL","NULL","NULL","r#00009650 r#00230996");
INSERT INTO portuguese_index VALUES ("fibrilar","NULL","v#00009884","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_favor","NULL","NULL","NULL","r#00009966");
INSERT INTO portuguese_index VALUES ("faça_favor","NULL","NULL","NULL","r#00009966");
INSERT INTO portuguese_index VALUES ("guloso","n#10132988","NULL","a#00009978","NULL");
INSERT INTO portuguese_index VALUES ("comilão","NULL","NULL","a#00009978","NULL");
INSERT INTO portuguese_index VALUES ("imperfeitamente","NULL","NULL","NULL","r#00010047");
INSERT INTO portuguese_index VALUES ("mover_reflexivamente","NULL","v#00010054","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mover_involuntariamente","NULL","v#00010054","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agir_involuntariamente","NULL","v#00010241","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agir_reflexivamente","NULL","v#00010241","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agir","NULL","v#00007023 v#02376631","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parecer","NULL","v#00007023 v#00023357 v#01461214 v#01461433","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_papel","NULL","v#00007023","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atuar","NULL","v#00007023 v#00741672 v#01177668","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comportar-se","NULL","v#00007023 v#02518161 v#02519666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cheiamente","NULL","NULL","NULL","r#00010466");
INSERT INTO portuguese_index VALUES ("em_cheio","NULL","NULL","NULL","r#00010466");
INSERT INTO portuguese_index VALUES ("plenamente","NULL","NULL","NULL","r#00010466");
INSERT INTO portuguese_index VALUES ("voraz","NULL","NULL","a#00010726 a#00031138","NULL");
INSERT INTO portuguese_index VALUES ("pobremente","NULL","NULL","NULL","r#00011516");
INSERT INTO portuguese_index VALUES ("fracamente","NULL","NULL","NULL","r#00011516 r#00036291");
INSERT INTO portuguese_index VALUES ("abstrato","NULL","NULL","a#00012300 a#00899226","NULL");
INSERT INTO portuguese_index VALUES ("fazer","NULL","v#00012267 v#00079910 v#00665476 v#00698256 v#00986409 v#01113245 v#01114991 v#01118767 v#01119363 v#01119839 v#01126333 v#01128460 v#01130277 v#01132676 v#01156631 v#01173875 v#01174962 v#01177668 v#01188481 v#01189395 v#01197357 v#01799148 v#01755504 v#01612822 v#01617687 v#01722366 v#01746300 v#02599636 v#01788243","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adquirir","NULL","v#00012267 v#00063646 v#00403772 v#01511279 v#02208265 v#01513874 v#02212103 v#02238770 v#01532512 v#02288295 v#01564908 v#02359340 v#01722366","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conquistar","NULL","v#00012267 v#00755606 v#01575110","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concetual","NULL","NULL","a#00012800","NULL");
INSERT INTO portuguese_index VALUES ("conceptual","NULL","NULL","a#00012800","NULL");
INSERT INTO portuguese_index VALUES ("conceitual","NULL","NULL","a#00012800","NULL");
INSERT INTO portuguese_index VALUES ("esfriar","NULL","v#00012613 v#00258213 v#00258652","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endurecer","NULL","v#00012613 v#00302875 v#00303309 v#00417596 v#00290685 v#00309461","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ideal","NULL","NULL","a#00013009 a#01687994 a#02577177","NULL");
INSERT INTO portuguese_index VALUES ("bem","n#00018376 n#02476046 n#04005893 n#04006260 n#04015246 n#04017901 n#09533920 n#09534283","NULL","NULL","r#00012779 r#00013429 r#00015471 r#00018302 r#00053004 r#00053152");
INSERT INTO portuguese_index VALUES ("ideológico","NULL","NULL","a#02456935 a#02745555","NULL");
INSERT INTO portuguese_index VALUES ("concreto","n#14820180","NULL","a#00013216 a#02151830","NULL");
INSERT INTO portuguese_index VALUES ("simular","NULL","v#00008958 v#00568049 v#00849332 v#01178910 v#01179881 v#01191194","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tangível","NULL","NULL","a#00013825 a#00592078 a#01717117 a#02391455","NULL");
INSERT INTO portuguese_index VALUES ("basto","NULL","NULL","a#00014012","NULL");
INSERT INTO portuguese_index VALUES ("bastante","NULL","NULL","a#00014012 a#00014561 a#02224478","r#00018302 r#00056539 r#00059171 r#00145571");
INSERT INTO portuguese_index VALUES ("farto","NULL","NULL","a#00014012 a#01028190 a#01734691","NULL");
INSERT INTO portuguese_index VALUES ("copioso","NULL","NULL","a#00014012 a#00014561","NULL");
INSERT INTO portuguese_index VALUES ("abundante","NULL","NULL","a#00014012 a#00014561 a#00014897 a#00015183 a#00015684","NULL");
INSERT INTO portuguese_index VALUES ("lauto","NULL","NULL","a#00014012 a#00014561","NULL");
INSERT INTO portuguese_index VALUES ("estremecer","NULL","v#00009323 v#01289419 v#01289759","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacudir","NULL","v#00009323 v#01281178 v#01876028 v#01289996 v#01890351 v#01292413 v#01295618","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tiritar","NULL","v#00009431 v#01289419 v#01289759 v#01289878","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bater_queixo","NULL","v#00009431","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consideravelmente","NULL","NULL","NULL","r#00014285");
INSERT INTO portuguese_index VALUES ("substancialmente","NULL","NULL","NULL","r#00014285 r#00379432");
INSERT INTO portuguese_index VALUES ("descansar","NULL","v#00009549","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cochilar","NULL","v#00009549 v#00009805 v#00015303 v#00015498","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repousar","NULL","v#00009549 v#01065785","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dormir","NULL","v#00009549 v#00009805 v#00017282","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_atividade","NULL","v#00014549","NULL","NULL");
INSERT INTO portuguese_index VALUES ("se_movimentando","NULL","v#00014549","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tirar_uma_soneca","NULL","v#00009805 v#00015303","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intimamente","NULL","NULL","NULL","r#00015007 r#00160659");
INSERT INTO portuguese_index VALUES ("fácil","NULL","NULL","a#00015044 a#00714553 a#01803149","NULL");
INSERT INTO portuguese_index VALUES ("Power_nap","NULL","v#00015303","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dormitar","NULL","v#00015303 v#00015498","NULL","NULL");
INSERT INTO portuguese_index VALUES ("satisfatoriamente","NULL","NULL","NULL","r#00015368");
INSERT INTO portuguese_index VALUES ("bicho","n#00008019 n#02236355 n#10508379","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("besta","n#00008019 n#03136369 n#07105886","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animal","n#00008019","NULL","a#01212141 a#01802774","NULL");
INSERT INTO portuguese_index VALUES ("abudante","NULL","NULL","a#00015684 a#01028190","NULL");
INSERT INTO portuguese_index VALUES ("hibernar","NULL","v#00015946 v#02596004","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gravemente","NULL","NULL","NULL","r#00015953 r#00183823");
INSERT INTO portuguese_index VALUES ("torrencial","NULL","NULL","a#00016532 a#00601250","NULL");
INSERT INTO portuguese_index VALUES ("cabecear","NULL","v#00016573","NULL","NULL");
INSERT INTO portuguese_index VALUES ("verde","n#03882559","NULL","a#01029155 a#00360195 a#00395177 a#00407480 a#01431944 a#01864865 a#02523929","NULL");
INSERT INTO portuguese_index VALUES ("insuficiente","NULL","NULL","a#02226257 a#00053941 a#00109552 a#02225138 a#02225593","NULL");
INSERT INTO portuguese_index VALUES ("escasso","NULL","NULL","a#02226257 a#00109260 a#00109552 a#01801006 a#02225593","NULL");
INSERT INTO portuguese_index VALUES ("ressonar","NULL","v#00017031","NULL","NULL");
INSERT INTO portuguese_index VALUES ("roncar","NULL","v#00017031 v#00619854","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vida_vegetal","n#00008864","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vegetal","n#00008864 n#07707451 n#07708798 n#07709333 n#07713895 n#12212361","NULL","a#00111046","NULL");
INSERT INTO portuguese_index VALUES ("flora","n#00008864 n#06240750","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("planta","n#00008864 n#02856109 n#02563119","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pior","NULL","NULL","a#00227300 a#00229218 a#00232068","r#00017241");
INSERT INTO portuguese_index VALUES ("adormecer","NULL","v#00017282","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ainda","NULL","NULL","NULL","r#00017639 r#00027795 r#00027918 r#00031304 r#00047534");
INSERT INTO portuguese_index VALUES ("aceitável","NULL","NULL","a#00018244 a#00968443 a#01077729 a#01761871 a#02187477","NULL");
INSERT INTO portuguese_index VALUES ("deitar-se_na_cama","NULL","v#00017865","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cair_no_sono_aos_poucos","NULL","v#00017865","NULL","NULL");
INSERT INTO portuguese_index VALUES ("levantar","NULL","v#00012725 v#00693379 v#00998639 v#00999117 v#01546768 v#01079137 v#01086949 v#01611359 v#01969601 v#01343923 v#01975587 v#01351052","NULL","NULL");
INSERT INTO portuguese_index VALUES ("erguer","NULL","v#00012725 v#00998639 v#00999117 v#01546768 v#01611359 v#01343923 v#01345256 v#01351052","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acordar","NULL","v#00012846 v#00013061 v#00020133 v#00016821 v#00208055 v#00541962 v#00547364 v#01894164","NULL","NULL");
INSERT INTO portuguese_index VALUES ("levantar-se","NULL","v#00012846 v#01969216","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despertar","n#01259773","v#00012846 v#00013061","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inadmissível","NULL","NULL","a#00018584 a#01762582","NULL");
INSERT INTO portuguese_index VALUES ("inaceitável","NULL","NULL","a#00018584 a#00018850 a#02083053 a#02298766 a#02317021","NULL");
INSERT INTO portuguese_index VALUES ("nativo","n#00019046","NULL","a#01037148","NULL");
INSERT INTO portuguese_index VALUES ("natureza","n#00019128 n#03647591 n#03716446 n#06691078 n#06860237","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("objeto_natural","n#00019128","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sempre","NULL","NULL","NULL","r#00019339 r#00020280 r#00020476 r#00088931 r#00227968");
INSERT INTO portuguese_index VALUES ("afetar","NULL","v#00013620 v#00091848 v#00822999 v#01206630","NULL","NULL");
INSERT INTO portuguese_index VALUES ("substância","n#09947198 n#00020090 n#00020827 n#04546812 n#14806838","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cômodo","NULL","NULL","a#00020860","NULL");
INSERT INTO portuguese_index VALUES ("prático","NULL","NULL","a#00020860 a#00572128 a#01762874 a#01871755","NULL");
INSERT INTO portuguese_index VALUES ("útil","NULL","NULL","a#00020860 a#00527630 a#00572128 a#01039045","NULL");
INSERT INTO portuguese_index VALUES ("atacar","NULL","v#00013890 v#00585325 v#00758805 v#00759367 v#00760028 v#00762743 v#00764752 v#01750864","NULL","NULL");
INSERT INTO portuguese_index VALUES ("que_não_pode_ser_acessado","NULL","NULL","a#00019874","NULL");
INSERT INTO portuguese_index VALUES ("inacessível","NULL","NULL","a#00019874 a#00021389 a#00185921 a#00186193","NULL");
INSERT INTO portuguese_index VALUES ("ulcerar","NULL","v#00019982 v#00537153","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distante","NULL","NULL","a#00021389 a#00410709 a#00411239 a#00411449 a#00411646 a#00414420 a#00419892 a#01377805 a#01915914","r#00166318");
INSERT INTO portuguese_index VALUES ("isolado","NULL","NULL","a#00021389 a#00535306 a#01788497 a#02036124 a#02036731 a#02143903","NULL");
INSERT INTO portuguese_index VALUES ("sucessivamente","NULL","NULL","NULL","r#00020142");
INSERT INTO portuguese_index VALUES ("consecutivamente","NULL","NULL","NULL","r#00020142");
INSERT INTO portuguese_index VALUES ("constantemente","NULL","NULL","NULL","r#00020280 r#00050186 r#00174491 r#00282858");
INSERT INTO portuguese_index VALUES ("continuamente","NULL","NULL","NULL","r#00020280 r#00088931 r#00282858");
INSERT INTO portuguese_index VALUES ("eternamente","NULL","NULL","NULL","r#00020280 r#00087542 r#00087916 r#00089076 r#00332596 r#00332596");
INSERT INTO portuguese_index VALUES ("perpetuamente","NULL","NULL","NULL","r#00020280 r#00227968 r#00332596");
INSERT INTO portuguese_index VALUES ("incessantemente","NULL","NULL","NULL","r#00020280 r#00282858");
INSERT INTO portuguese_index VALUES ("de_forma_contínua","NULL","NULL","NULL","r#00020476");
INSERT INTO portuguese_index VALUES ("de_forma_constante","NULL","NULL","NULL","r#00020476");
INSERT INTO portuguese_index VALUES ("invariavelmente","NULL","NULL","NULL","r#00020476");
INSERT INTO portuguese_index VALUES ("mesmerizar","NULL","v#00020671","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hipnotizar","NULL","v#00020671","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jamais","NULL","NULL","NULL","r#00020759");
INSERT INTO portuguese_index VALUES ("em_tempo_algum","NULL","NULL","NULL","r#00020759");
INSERT INTO portuguese_index VALUES ("nunca","NULL","NULL","NULL","r#00020759");
INSERT INTO portuguese_index VALUES ("prestável","NULL","NULL","a#00022378 a#01145952 a#01146379","NULL");
INSERT INTO portuguese_index VALUES ("matéria","n#00020827 n#04479710 n#04950638 n#05005867","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anestesiar","NULL","v#00021065","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obsequioso","NULL","NULL","a#00022683","NULL");
INSERT INTO portuguese_index VALUES ("ocasionalmente","NULL","NULL","NULL","r#00021212");
INSERT INTO portuguese_index VALUES ("vez_por_outra","NULL","NULL","NULL","r#00021212");
INSERT INTO portuguese_index VALUES ("de_quando_em_quando","NULL","NULL","NULL","r#00021212");
INSERT INTO portuguese_index VALUES ("de_vez_em_quando","NULL","NULL","NULL","r#00021212");
INSERT INTO portuguese_index VALUES ("uma_vez","NULL","NULL","NULL","r#00021212 r#00021878 r#00118869");
INSERT INTO portuguese_index VALUES ("outrora","NULL","NULL","NULL","r#00021212 r#00021878");
INSERT INTO portuguese_index VALUES ("alimento","n#00011575 n#07556637 n#05617748 n#05622219 n#05625967 n#09626009 n#05834217","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comida","n#00011575 n#05625967 n#09626009","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nutriente","n#00011575 n#00021734","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Nutrientes","n#00021734","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exacto","NULL","NULL","a#00023303 a#00595724","NULL");
INSERT INTO portuguese_index VALUES ("acurado","NULL","NULL","a#00023303","NULL");
INSERT INTO portuguese_index VALUES ("justo","NULL","NULL","a#00023303 a#00595353 a#00958151 a#01447937 a#01963374 a#02526441","NULL");
INSERT INTO portuguese_index VALUES ("exato","NULL","NULL","a#00023303 a#00595724 a#00867566","NULL");
INSERT INTO portuguese_index VALUES ("preciso","NULL","NULL","a#00023303 a#00595724 a#00867566 a#01765920","NULL");
INSERT INTO portuguese_index VALUES ("às_vezes","NULL","NULL","NULL","r#00021878");
INSERT INTO portuguese_index VALUES ("por_vezes","NULL","NULL","NULL","r#00021878");
INSERT INTO portuguese_index VALUES ("as_vezes","NULL","NULL","NULL","r#00021878");
INSERT INTO portuguese_index VALUES ("artefato","n#00021939","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("produto","n#00021939 n#02749953 n#02476046 n#02987655 n#03175725 n#03640400 n#04510165 n#11415842 n#10763715","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("utensílio","n#00021939 n#04516672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("da_mesma_maneira_que","NULL","NULL","NULL","r#00022131");
INSERT INTO portuguese_index VALUES ("tanto_quanto","NULL","NULL","NULL","r#00022131");
INSERT INTO portuguese_index VALUES ("fiel","NULL","NULL","a#00023738 a#00911761 a#00961392","NULL");
INSERT INTO portuguese_index VALUES ("a_muito_tempo_atrás","NULL","NULL","NULL","r#00022401");
INSERT INTO portuguese_index VALUES ("energizar","NULL","v#00015782","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excitar","NULL","v#00015782 v#00558963 v#00559102 v#01202849 v#01202989 v#01225706 v#01448459","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estimular","NULL","v#00015782 v#00350457 v#00539509 v#01133437 v#01200852 v#01448459 v#01741432","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animar","NULL","v#00015782 v#00260180 v#00582994 v#01202849 v#01210207","NULL","NULL");
INSERT INTO portuguese_index VALUES ("praticamente","NULL","NULL","NULL","r#00022829 r#00053512 r#00053744");
INSERT INTO portuguese_index VALUES ("cirúrgico","NULL","NULL","a#00022852 a#02670911 a#02888968","NULL");
INSERT INTO portuguese_index VALUES ("artigo","n#00012704 n#02214249 n#02476046 n#02987655 n#04550840 n#04739220 n#06269956 n#04771731 n#04819775 n#06681177 n#05009327 n#05010999","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_tal_quantidade","NULL","NULL","NULL","r#00023074");
INSERT INTO portuguese_index VALUES ("tanto","NULL","NULL","a#01491308","r#00023074");
INSERT INTO portuguese_index VALUES ("característica_psicológica","n#00023100","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paradoxalmente","NULL","NULL","NULL","r#00023263");
INSERT INTO portuguese_index VALUES ("cognição","n#00013243","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compreensão","n#00013243 n#04044520 n#04473075 n#04473430 n#04474097 n#04474949 n#04699267","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conhecimento","n#00013243 n#05640729 n#04387608 n#05677952 n#05999266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("noção","n#00013243 n#04494358 n#04545843","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfalecer","NULL","v#00023646","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esvanecer","NULL","v#00023646 v#00293522","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmaiar","NULL","v#00023646","NULL","NULL");
INSERT INTO portuguese_index VALUES ("motivação","n#00013700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("motivo","n#00013700 n#04546376 n#05270769 n#05271609 n#06659860","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intenção","n#00013700 n#04533598 n#04546018 n#04586952 n#04587307 n#04588033 n#05982720 n#04588594 n#04588994 n#04951584 n#04955260","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("necessidade","n#00013700 n#06846327 n#09367991 n#10367157 n#14450691","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("errado","NULL","NULL","a#00023854 a#00596241 a#01694081 a#02036397 a#02234253 a#02343098","NULL");
INSERT INTO portuguese_index VALUES ("equivocado","NULL","NULL","a#00023854 a#01224253","NULL");
INSERT INTO portuguese_index VALUES ("não","n#05383289","NULL","NULL","r#00024073");
INSERT INTO portuguese_index VALUES ("infiel","NULL","NULL","a#00024139 a#00959731 a#00960971 a#00962939","NULL");
INSERT INTO portuguese_index VALUES ("atributo","n#00024264","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predicado","n#00024264","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("propriedade","n#00024264 n#00018376 n#00517391 n#04015246 n#09525525 n#09528888 n#09534283","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("característica","n#00024264 n#03719538 n#04504455 n#05102576","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_ação","NULL","v#00024279","NULL","NULL");
INSERT INTO portuguese_index VALUES ("costumado","NULL","NULL","a#00025588","NULL");
INSERT INTO portuguese_index VALUES ("habitual","NULL","NULL","a#00025588 a#00456499 a#01576838 a#00457087 a#00573324 a#01014088","NULL");
INSERT INTO portuguese_index VALUES ("habituado","NULL","NULL","a#00025588 a#00025790 a#01576838","NULL");
INSERT INTO portuguese_index VALUES ("usual","NULL","NULL","a#00025790 a#00456499 a#01576838 a#00970610","NULL");
INSERT INTO portuguese_index VALUES ("refrescar","NULL","v#00024649 v#00024814 v#00164444 v#00258213 v#00370126 v#00258652","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estado","n#00016185 n#06374245 n#10031939 n#10032130 n#10048803 n#10345365","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("situação","n#00016185 n#03960878 n#06353805 n#10032130 n#10034299 n#10035141","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("condição","n#00016185 n#10032130 n#13923030 n#10035141 n#10048803","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("um_ou_outro","NULL","NULL","NULL","r#00024893");
INSERT INTO portuguese_index VALUES ("também_não","NULL","NULL","NULL","r#00024893");
INSERT INTO portuguese_index VALUES ("novo","NULL","NULL","a#00026167 a#00778835 a#01581807 a#01582587 a#01583415 a#01627275 a#01666848","NULL");
INSERT INTO portuguese_index VALUES ("estressar","NULL","v#00017738","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ácida","NULL","NULL","a#00026478","NULL");
INSERT INTO portuguese_index VALUES ("para_qualquer_parte","NULL","NULL","NULL","r#00025290");
INSERT INTO portuguese_index VALUES ("em_qualquer_lugar","NULL","NULL","NULL","r#00025290");
INSERT INTO portuguese_index VALUES ("algures","NULL","NULL","NULL","r#00025290");
INSERT INTO portuguese_index VALUES ("nenhures","NULL","NULL","NULL","r#00025290");
INSERT INTO portuguese_index VALUES ("em_qualquer_parte","NULL","NULL","NULL","r#00025290");
INSERT INTO portuguese_index VALUES ("em_nenhum_lugar","NULL","NULL","NULL","r#00025464");
INSERT INTO portuguese_index VALUES ("em_nenhuma_parte","NULL","NULL","NULL","r#00025464");
INSERT INTO portuguese_index VALUES ("em_parte_alguma","NULL","NULL","NULL","r#00025464");
INSERT INTO portuguese_index VALUES ("azeda","NULL","NULL","a#00026658","NULL");
INSERT INTO portuguese_index VALUES ("ácido","n#10463819","NULL","a#00026658 a#02369179","NULL");
INSERT INTO portuguese_index VALUES ("algum_lugar","NULL","NULL","NULL","r#00025559");
INSERT INTO portuguese_index VALUES ("alcalino","NULL","NULL","a#00025728","NULL");
INSERT INTO portuguese_index VALUES ("em_toda_parte","NULL","NULL","NULL","r#00025728");
INSERT INTO portuguese_index VALUES ("em_todo_o_lugar","NULL","NULL","NULL","r#00025728");
INSERT INTO portuguese_index VALUES ("em_toda_a_parte","NULL","NULL","NULL","r#00025728");
INSERT INTO portuguese_index VALUES ("de_alguma_forma","NULL","NULL","NULL","r#00026137");
INSERT INTO portuguese_index VALUES ("por_algum_meio","NULL","NULL","NULL","r#00026137");
INSERT INTO portuguese_index VALUES ("emoção","n#00014045 n#05560772 n#05560878 n#05596946","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sentimento","n#00014045 n#05560878 n#07481951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impressão","n#00014045 n#02852588 n#03172719 n#03684009 n#04439113 n#04544110 n#04944510 n#05006313 n#05129243 n#10013828","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descontrair","NULL","v#00018644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pegar_leve","NULL","v#00018644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relaxar","NULL","v#00018644","a#00197151","NULL");
INSERT INTO portuguese_index VALUES ("anfotérico","NULL","NULL","a#00026515","NULL");
INSERT INTO portuguese_index VALUES ("de_qualquer_forma","NULL","NULL","NULL","r#00026571");
INSERT INTO portuguese_index VALUES ("em_todo_o_caso","NULL","NULL","NULL","r#00026571");
INSERT INTO portuguese_index VALUES ("de_qualquer_maneira","NULL","NULL","NULL","r#00026571");
INSERT INTO portuguese_index VALUES ("de_qualquer_jeito","NULL","NULL","NULL","r#00026571 r#00027384");
INSERT INTO portuguese_index VALUES ("além_de","NULL","NULL","NULL","r#00026571 r#00029037");
INSERT INTO portuguese_index VALUES ("localização","n#00014887 n#00101111 n#03682189 n#03960878","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ponto","n#00014887 n#05542893 n#04514257 n#05096549 n#05101450 n#05106558 n#05126526 n#10025218","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lugar","n#00014887 n#00381958 n#06483454 n#08490039 n#08500433 n#06351684 n#06352837 n#06353805 n#06354148 n#06368526 n#08653706 n#06391607 n#13947415","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_qualquer_modo","NULL","NULL","NULL","r#00027258");
INSERT INTO portuguese_index VALUES ("estender","NULL","v#00019111 v#00105798 v#00209671 v#00377885","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esticar","NULL","v#00019111 v#00028167 v#00240810 v#00221402 v#01449591","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alongar","NULL","v#00019111 v#00219507 v#00220504 v#00221402","NULL","NULL");
INSERT INTO portuguese_index VALUES ("no_entanto","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("contudo","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("por_mais_que","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("apesar_de","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("porém","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("apesar_disso","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("não_obstante","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("ainda_assim","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("se_bobear","NULL","NULL","NULL","r#00027384");
INSERT INTO portuguese_index VALUES ("aceitado","NULL","NULL","a#00028460","NULL");
INSERT INTO portuguese_index VALUES ("aceito","NULL","NULL","a#00028460","NULL");
INSERT INTO portuguese_index VALUES ("reconhecido","NULL","NULL","a#00028460 a#01146493 a#01636507","NULL");
INSERT INTO portuguese_index VALUES ("forma_geométrica","n#00015185","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forma","n#00015185 n#03858557","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formato","n#00015185 n#04677385 n#06636806","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("até_agora","NULL","NULL","NULL","r#00027918 r#00172151");
INSERT INTO portuguese_index VALUES ("até","NULL","NULL","NULL","r#00027918");
INSERT INTO portuguese_index VALUES ("até_então","NULL","NULL","NULL","r#00027918");
INSERT INTO portuguese_index VALUES ("declarável","NULL","NULL","a#00028181","NULL");
INSERT INTO portuguese_index VALUES ("espaço_temporal","n#00015594","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tempo","n#00015594 n#05302217 n#11456462 n#07847974 n#10843624 n#10850147 n#10945309 n#10947554 n#10947841 n#10953446 n#10955141 n#15269513 n#10969191","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suposto","NULL","NULL","a#00029357 a#00608628 a#01357137 a#01357609 a#01559282 a#01846462","NULL");
INSERT INTO portuguese_index VALUES ("putativo","NULL","NULL","a#00029512","NULL");
INSERT INTO portuguese_index VALUES ("sorrir","NULL","v#00019944 v#00020314 v#00020449 v#00020571","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espaço","n#00028651 n#00029007 n#06862202 n#09922737 n#10024194","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fora","NULL","NULL","NULL","r#00029037 r#00110919");
INSERT INTO portuguese_index VALUES ("espaço_fásico","n#00029114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sequioso","NULL","NULL","a#00029343 a#01270004","NULL");
INSERT INTO portuguese_index VALUES ("cobiçoso","NULL","NULL","a#00029343","NULL");
INSERT INTO portuguese_index VALUES ("além_disso","NULL","NULL","NULL","r#00029367");
INSERT INTO portuguese_index VALUES ("em_continuação","NULL","NULL","NULL","r#00029367");
INSERT INTO portuguese_index VALUES ("mais_adiante","NULL","NULL","NULL","r#00029367");
INSERT INTO portuguese_index VALUES ("aliás","NULL","NULL","NULL","r#00029367 r#00156222");
INSERT INTO portuguese_index VALUES ("demais","NULL","NULL","NULL","r#00029367 r#00047392");
INSERT INTO portuguese_index VALUES ("ademais","NULL","NULL","NULL","r#00029367 r#00046167 r#00080304");
INSERT INTO portuguese_index VALUES ("mais","NULL","NULL","NULL","r#00029367 r#00099712");
INSERT INTO portuguese_index VALUES ("acontecimento","n#00017297 n#05432762 n#05437656 n#05538537","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evento","n#00017297 n#05432762 n#05437656 n#05447746","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fato","n#00017297 n#03438739 n#04482936","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("zurrar","NULL","v#00029630","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_longe","NULL","NULL","NULL","r#00029639");
INSERT INTO portuguese_index VALUES ("processos_físicos","n#09669871","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acumulativo","NULL","NULL","a#00029769","NULL");
INSERT INTO portuguese_index VALUES ("cumulativo","NULL","NULL","a#00029769 a#00048460","NULL");
INSERT INTO portuguese_index VALUES ("ganancioso","NULL","NULL","a#00029933","NULL");
INSERT INTO portuguese_index VALUES ("avaro","NULL","NULL","a#00029933","NULL");
INSERT INTO portuguese_index VALUES ("ávido","NULL","NULL","a#00029933 a#00771844 a#00843026 a#00844949 a#01063943","NULL");
INSERT INTO portuguese_index VALUES ("mais_afastado","NULL","NULL","NULL","r#00029985");
INSERT INTO portuguese_index VALUES ("casquinar","NULL","v#00020971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ato","n#00017487 n#00022246 n#00550341 n#04904391 n#04913178 n#05258426","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ação","n#00017487 n#00022246 n#13333833 n#09606854 n#13417071 n#10090167","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("feito","n#00017487 n#00020977 n#00021392","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("possessivo","NULL","NULL","a#00030508","NULL");
INSERT INTO portuguese_index VALUES ("predatório","NULL","NULL","a#00030798 a#00084022","NULL");
INSERT INTO portuguese_index VALUES ("predador","NULL","NULL","a#00030798 a#00084022","NULL");
INSERT INTO portuguese_index VALUES ("agrupação","n#00017954","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grupo","n#00017954 n#04606861 n#05963394 n#07954014 n#05965972 n#05969508 n#05969773 n#05972379 n#05990251 n#05991008 n#06117068 n#06123389 n#08400452","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conjunto","n#00017954 n#07954014 n#07985135 n#05992373","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cacarejar","NULL","v#00031418","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_mas","NULL","NULL","NULL","r#00031515");
INSERT INTO portuguese_index VALUES ("já_não","NULL","NULL","NULL","r#00031515");
INSERT INTO portuguese_index VALUES ("não_mais","NULL","NULL","NULL","r#00031515");
INSERT INTO portuguese_index VALUES ("daqui_para_frente","NULL","NULL","NULL","r#00031606");
INSERT INTO portuguese_index VALUES ("gracejar","NULL","v#00021890 v#00578703","NULL","NULL");
INSERT INTO portuguese_index VALUES ("já","NULL","NULL","NULL","r#00031798 r#00033922");
INSERT INTO portuguese_index VALUES ("rir","NULL","v#00022011","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gargalhar","NULL","v#00022011","NULL","NULL");
INSERT INTO portuguese_index VALUES ("muito","NULL","NULL","NULL","r#00031899 r#00046299 r#00056539 r#00059171");
INSERT INTO portuguese_index VALUES ("relação","n#00018916 n#09924828 n#09925062 n#09931077 n#13794417 n#09934446 n#13795695 n#09947717 n#13812607 n#10036039 n#10036283","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conexão","n#00018916 n#07177545 n#13792842 n#10345982","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fabulosamente","NULL","NULL","NULL","r#00032180");
INSERT INTO portuguese_index VALUES ("fantasticamente","NULL","NULL","NULL","r#00032180 r#00213301");
INSERT INTO portuguese_index VALUES ("convulsionar","NULL","v#00032297 v#01388813","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atlético","NULL","NULL","a#00032497 a#00828661 a#02907656","NULL");
INSERT INTO portuguese_index VALUES ("acrobático","NULL","NULL","a#00032497","NULL");
INSERT INTO portuguese_index VALUES ("posse","n#00018376 n#00239910 n#00809702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serelepe","n#02355227","NULL","a#00033527","NULL");
INSERT INTO portuguese_index VALUES ("lépido","NULL","NULL","a#00033527","NULL");
INSERT INTO portuguese_index VALUES ("lesto","NULL","NULL","a#00033527","NULL");
INSERT INTO portuguese_index VALUES ("rápido","NULL","NULL","a#00033527 a#00800735 a#00925538 a#00926833 a#00928268 a#00928545 a#00979862 a#01863475","r#00085811 r#00105603");
INSERT INTO portuguese_index VALUES ("ativo","NULL","NULL","a#00033527 a#00039581","NULL");
INSERT INTO portuguese_index VALUES ("ligeiro","NULL","NULL","a#00033527 a#00928268 a#00928545 a#01281477","NULL");
INSERT INTO portuguese_index VALUES ("ágil","NULL","NULL","a#00033527 a#00149236 a#01281477","NULL");
INSERT INTO portuguese_index VALUES ("relação_social","n#00032823","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("doravante","NULL","NULL","NULL","r#00032863 r#00103859");
INSERT INTO portuguese_index VALUES ("de_agora_em_diante","NULL","NULL","NULL","r#00032863 r#00103859");
INSERT INTO portuguese_index VALUES ("a_partir_de_agora","NULL","NULL","NULL","r#00032863 r#00067265 r#00103859");
INSERT INTO portuguese_index VALUES ("franzir_o_cenho","NULL","v#00022810","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_cara_feia","NULL","v#00022810","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mensagem","n#00019671 n#04729537 n#04950638","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comunicação","n#00019671 n#04728675 n#04968827 n#05056012 n#07212612","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fulminar","NULL","v#00022963","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hiperativo","NULL","NULL","a#00033206","NULL");
INSERT INTO portuguese_index VALUES ("ativo_em_excesso","NULL","NULL","a#00033206","NULL");
INSERT INTO portuguese_index VALUES ("agora_mesmo","NULL","NULL","NULL","r#00033308");
INSERT INTO portuguese_index VALUES ("neste_instante","NULL","NULL","NULL","r#00033308");
INSERT INTO portuguese_index VALUES ("olhar","n#00563114","v#00033406 v#01456984 v#01457770 v#01459903 v#01482231 v#01483772 v#01673353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instantaneamente","NULL","NULL","NULL","r#00033421 r#00048739");
INSERT INTO portuguese_index VALUES ("imediatamente","NULL","NULL","NULL","r#00033421 r#00035320 r#00048739 r#00051848 r#00105162 r#00105467 r#00170715 r#00504281");
INSERT INTO portuguese_index VALUES ("inativo","NULL","NULL","a#00033574","NULL");
INSERT INTO portuguese_index VALUES ("aparentar","NULL","v#00023357 v#00568049","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quantia","n#03972490","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("medida","n#03972490 n#00643864 n#03976830 n#03977358","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quantidade","n#03972490 n#03977751 n#03983517 n#05108740 n#04507519","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("magnitude","n#03972490 n#03971772 n#03972175 n#03973414 n#03977358 n#04025511 n#04025970 n#04028728 n#09956529","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("número","n#03972490 n#03971772 n#03983517 n#03990394 n#04507519 n#04511080 n#04774380 n#04841846 n#04842744 n#04948541 n#05097671 n#05156818 n#09598019 n#09765658 n#13741022 n#09894639","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("um_tanto","NULL","NULL","NULL","r#00033663");
INSERT INTO portuguese_index VALUES ("um","n#13742573","NULL","NULL","r#00033663");
INSERT INTO portuguese_index VALUES ("pouco","n#09909906 n#13773725","NULL","NULL","r#00033663 r#00100002");
INSERT INTO portuguese_index VALUES ("pronto","NULL","NULL","a#01862436","r#00033922");
INSERT INTO portuguese_index VALUES ("cedo","NULL","NULL","a#00773513 a#00778288 a#01588864","r#00033922 r#00100082");
INSERT INTO portuguese_index VALUES ("logo","n#07272084","NULL","NULL","r#00033922");
INSERT INTO portuguese_index VALUES ("brevemente","NULL","NULL","NULL","r#00033922 r#00034189 r#00034308 r#00048268 r#00085811 r#00092682 r#00289860 r#00297319");
INSERT INTO portuguese_index VALUES ("aplaudir","NULL","v#00023765 v#00583639 v#00584625 v#00584733","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bater_palmas","NULL","v#00023765 v#00584733","NULL","NULL");
INSERT INTO portuguese_index VALUES ("o_mais_rápido_possível","NULL","NULL","NULL","r#00034137");
INSERT INTO portuguese_index VALUES ("o_mais_breve_possível","NULL","NULL","NULL","r#00034137");
INSERT INTO portuguese_index VALUES ("fenómeno","n#00020461 n#05524610","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fenômeno","n#00020461 n#05524610","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inerte","NULL","NULL","a#00034881 a#01565038","NULL");
INSERT INTO portuguese_index VALUES ("momentaneamente","NULL","NULL","NULL","r#00034403 r#00092814");
INSERT INTO portuguese_index VALUES ("gentileza","n#00020804 n#00795713","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bondade","n#00020804 n#03800378 n#05696348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delicadeza","n#00020804 n#03775320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amabilidade","n#00020804 n#04654652 n#04840011 n#05696348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("o_mais_precoce","NULL","NULL","NULL","r#00034641");
INSERT INTO portuguese_index VALUES ("Abdominoplastia","n#00034777","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aborto","n#00034939 n#00149581 n#00149696 n#05456093","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("com_freqüência","NULL","NULL","NULL","r#00035058");
INSERT INTO portuguese_index VALUES ("amiúde","NULL","NULL","NULL","r#00035058");
INSERT INTO portuguese_index VALUES ("freqüentemente","NULL","NULL","NULL","r#00035058");
INSERT INTO portuguese_index VALUES ("vira_e_mexe","NULL","NULL","NULL","r#00035058");
INSERT INTO portuguese_index VALUES ("muitas_vezes","NULL","NULL","NULL","r#00035058");
INSERT INTO portuguese_index VALUES ("frequentemente","NULL","NULL","NULL","r#00035058");
INSERT INTO portuguese_index VALUES ("pigarrear","NULL","v#00035089 v#00121607","NULL","NULL");
INSERT INTO portuguese_index VALUES ("façanha","n#00020977 n#00021392 n#00046344 n#00024789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consumação","n#00020977 n#00061598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("realização","n#00020977 n#00021392 n#00061322 n#00035534 n#00035970 n#00036271 n#00061811 n#00931847 n#00729882","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conquista","n#00020977 n#00037624 n#00054499 n#00104245","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jubilado","n#10525617","NULL","a#00035368","NULL");
INSERT INTO portuguese_index VALUES ("aposentado","n#10525617","NULL","a#00035368","NULL");
INSERT INTO portuguese_index VALUES ("raramente","NULL","NULL","NULL","r#00035385 r#00374520");
INSERT INTO portuguese_index VALUES ("curiosamente","NULL","NULL","NULL","r#00035491 r#00081881 r#00214761");
INSERT INTO portuguese_index VALUES ("agon","n#00035697","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("com_justiça","NULL","NULL","NULL","r#00035718");
INSERT INTO portuguese_index VALUES ("razoavelmente","NULL","NULL","NULL","r#00035718 r#00215811");
INSERT INTO portuguese_index VALUES ("lavar","NULL","v#00035758 v#00557686 v#01054290 v#01056327","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limpar","NULL","v#00035758 v#00025612 v#00040766 v#00120982 v#00123998 v#00124634 v#01311896 v#00955030 v#01392918 v#01054290 v#01054427 v#01108327 v#01360709","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aberto","NULL","NULL","a#00037427 a#01592532 a#01593054 a#01653135 a#01594537 a#01654582 a#01642540 a#01790966 a#01814114 a#01931860 a#02008784","NULL");
INSERT INTO portuguese_index VALUES ("lestamente","NULL","NULL","NULL","r#00036291");
INSERT INTO portuguese_index VALUES ("levemente","NULL","NULL","NULL","r#00036291");
INSERT INTO portuguese_index VALUES ("ligeiramente","NULL","NULL","NULL","r#00036291");
INSERT INTO portuguese_index VALUES ("meio","n#00111872 n#06315687 n#09891093 n#10410402","NULL","a#00483994","r#00036291");
INSERT INTO portuguese_index VALUES ("lavar-se","NULL","v#00025612","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extensivamente","NULL","NULL","NULL","r#00036609");
INSERT INTO portuguese_index VALUES ("amplamente","NULL","NULL","NULL","r#00036609 r#00495524 r#00495663");
INSERT INTO portuguese_index VALUES ("largamente","NULL","NULL","NULL","r#00036609 r#00495663");
INSERT INTO portuguese_index VALUES ("proeza","n#00021392 n#00046344","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intrinsecamente","NULL","NULL","NULL","r#00036762");
INSERT INTO portuguese_index VALUES ("esfregar","NULL","v#00025940 v#01249724 v#00853039 v#01251228 v#00853429 v#00955030","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ensaboar","NULL","v#00036932","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infalivelmente","NULL","NULL","NULL","r#00036935");
INSERT INTO portuguese_index VALUES ("sem_falta","NULL","NULL","NULL","r#00036935");
INSERT INTO portuguese_index VALUES ("impreterivelmente","NULL","NULL","NULL","r#00036935");
INSERT INTO portuguese_index VALUES ("definitivamente","NULL","NULL","NULL","r#00036935 r#00087916");
INSERT INTO portuguese_index VALUES ("lento","NULL","NULL","a#00036998 a#00929061 a#00931158","NULL");
INSERT INTO portuguese_index VALUES ("obra-prima","n#00037006 n#03727605","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enxaguar","NULL","v#00037138 v#01270199","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gargarejar","NULL","v#00037138","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bochechar","NULL","v#00037138","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sinceramente","NULL","NULL","NULL","r#00037226 r#00160086 r#00165018 r#00378365");
INSERT INTO portuguese_index VALUES ("barbear-se","NULL","v#00037298","NULL","NULL");
INSERT INTO portuguese_index VALUES ("barbear","NULL","v#00037298 v#00042792 v#00851394","NULL","NULL");
INSERT INTO portuguese_index VALUES ("raspar","NULL","v#00037298 v#00845525 v#00894368 v#01141322","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atividade","n#00022246 n#00261466 n#10090167","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("realmente","NULL","NULL","NULL","r#00037470 r#00148869");
INSERT INTO portuguese_index VALUES ("de_fato","NULL","NULL","NULL","r#00037470 r#00144722 r#00148869");
INSERT INTO portuguese_index VALUES ("depilar","NULL","v#00037514","NULL","NULL");
INSERT INTO portuguese_index VALUES ("progressivo","NULL","NULL","a#00038771 a#01804417 a#01805641","NULL");
INSERT INTO portuguese_index VALUES ("tomar_banho","NULL","v#00026695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("banhar-se","NULL","v#00026695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("verdadeiramente","NULL","NULL","NULL","r#00038013 r#00400192");
INSERT INTO portuguese_index VALUES ("duchar","NULL","v#00038199","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indolente","NULL","NULL","a#00038260","NULL");
INSERT INTO portuguese_index VALUES ("conduta","n#00022737 n#00792210 n#03835766","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corrente","n#00022737 n#02416750 n#05513139 n#06793150 n#11443532 n#11514559 n#13652994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curso","n#00022737 n#00568196 n#06115327 n#06115587 n#06249735 n#06250108 n#06389665 n#06390208 n#06390488 n#06709272 n#09959689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caminho","n#00022737 n#00111872 n#00266805 n#02159544 n#03244388 n#03640589 n#03640660 n#03096023 n#03096228 n#03243979 n#03525842 n#03527842 n#03600463 n#06348591 n#06709272","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pentear","NULL","v#00026985","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compreensivelmente","NULL","NULL","NULL","r#00038625");
INSERT INTO portuguese_index VALUES ("decerto","NULL","NULL","NULL","r#00038625");
INSERT INTO portuguese_index VALUES ("de_acordo","NULL","NULL","NULL","r#00038625");
INSERT INTO portuguese_index VALUES ("claro","NULL","NULL","a#00273770 a#00405879 a#02009688","r#00038625 r#00181901");
INSERT INTO portuguese_index VALUES ("agencioso","NULL","NULL","a#00039581","NULL");
INSERT INTO portuguese_index VALUES ("interação","n#00022878 n#00023032","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("activista","n#07409291","NULL","a#00039122","NULL");
INSERT INTO portuguese_index VALUES ("ativista","NULL","NULL","a#00039122","NULL");
INSERT INTO portuguese_index VALUES ("interacção","n#00023032","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ligação","n#00023118 n#00094409 n#00147454 n#00095872 n#02222271 n#02488140 n#02882380 n#02929916 n#04742189 n#06586471 n#11436283 n#09925062 n#09931077 n#13792183 n#09931775 n#09993288 n#10024799 n#10036283 n#10345365 n#10345982 n#10346799 n#10347124 n#10347254","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contato","n#00023118 n#00079716 n#00125629 n#07279285 n#10346256","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evidentemente","NULL","NULL","NULL","r#00039318");
INSERT INTO portuguese_index VALUES ("obviamente","NULL","NULL","NULL","r#00039318");
INSERT INTO portuguese_index VALUES ("abertamente","NULL","NULL","NULL","r#00039318 r#00053394 r#00078558 r#00314835");
INSERT INTO portuguese_index VALUES ("de_forma_evidente","NULL","NULL","NULL","r#00039318");
INSERT INTO portuguese_index VALUES ("claramente","NULL","NULL","NULL","r#00039318 r#00078558 r#00180057 r#00307479 r#00307639");
INSERT INTO portuguese_index VALUES ("contato_visual","n#00039740","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("busque","n#00039916","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aparentemente","NULL","NULL","NULL","r#00039941");
INSERT INTO portuguese_index VALUES ("intercâmbio","n#00023668","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cuidar-se","NULL","v#00040353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_novo","NULL","NULL","NULL","r#00040365 r#00112843 r#00226550");
INSERT INTO portuguese_index VALUES ("uma_vez_mais","NULL","NULL","NULL","r#00040365");
INSERT INTO portuguese_index VALUES ("outra_vez","NULL","NULL","NULL","r#00040365 r#00112843");
INSERT INTO portuguese_index VALUES ("novamente","NULL","NULL","NULL","r#00040365 r#00112601 r#00112843");
INSERT INTO portuguese_index VALUES ("intercambio","n#00023860","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reciprocidade","n#00023860 n#09971796","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Casualmente","NULL","NULL","NULL","r#00040547");
INSERT INTO portuguese_index VALUES ("por_acaso","NULL","NULL","NULL","r#00040547");
INSERT INTO portuguese_index VALUES ("à_toa","NULL","NULL","NULL","r#00040547");
INSERT INTO portuguese_index VALUES ("acidentalmente","NULL","NULL","NULL","r#00040547 r#00062650 r#00263893");
INSERT INTO portuguese_index VALUES ("inesperadamente","NULL","NULL","NULL","r#00040719");
INSERT INTO portuguese_index VALUES ("de_repente","NULL","NULL","NULL","r#00040719 r#00061528 r#00061677 r#00151957");
INSERT INTO portuguese_index VALUES ("sem_mais_nem_menos","NULL","NULL","NULL","r#00040719");
INSERT INTO portuguese_index VALUES ("da_cartola","NULL","NULL","NULL","r#00040719");
INSERT INTO portuguese_index VALUES ("inopinadamente","NULL","NULL","NULL","r#00040719");
INSERT INTO portuguese_index VALUES ("repentinamente","NULL","NULL","NULL","r#00040719 r#00061528 r#00061677");
INSERT INTO portuguese_index VALUES ("do_nada","NULL","NULL","NULL","r#00040719 r#00159889");
INSERT INTO portuguese_index VALUES ("maquiar","NULL","v#00040928","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maquilar","NULL","v#00040928","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extinto","NULL","NULL","a#00041051 a#00100213","NULL");
INSERT INTO portuguese_index VALUES ("liquidado","NULL","NULL","a#00041051","NULL");
INSERT INTO portuguese_index VALUES ("apagado","NULL","NULL","a#00041051","NULL");
INSERT INTO portuguese_index VALUES ("revogado","NULL","NULL","a#00041051","NULL");
INSERT INTO portuguese_index VALUES ("extincto","NULL","NULL","a#00041051 a#00100213","NULL");
INSERT INTO portuguese_index VALUES ("enfatizar","NULL","v#00041206 v#00197117 v#00685448 v#00686083","NULL","NULL");
INSERT INTO portuguese_index VALUES ("realçar","NULL","v#00041206 v#00358208","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luta_de_espadas","n#00041468","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pintar","NULL","v#00029095 v#00932708 v#01156145 v#01156290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("boliche","n#00041740 n#00461782","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("especificamente","NULL","NULL","NULL","r#00041758");
INSERT INTO portuguese_index VALUES ("concretamente","NULL","NULL","NULL","r#00041758");
INSERT INTO portuguese_index VALUES ("aquisição","n#00046246 n#00077419 n#00047517 n#00049855 n#00051225 n#04438179 n#09536731 n#00047131 n#13253612","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_geral","NULL","NULL","NULL","r#00041954 r#00155621 r#00221583 r#00221795");
INSERT INTO portuguese_index VALUES ("generalmente","NULL","NULL","NULL","r#00041954 r#00155621");
INSERT INTO portuguese_index VALUES ("empoar","NULL","v#00042173","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_sorte","NULL","NULL","NULL","r#00042254");
INSERT INTO portuguese_index VALUES ("afortunadamente","NULL","NULL","NULL","r#00042254");
INSERT INTO portuguese_index VALUES ("felizmente","NULL","NULL","NULL","r#00042254 r#00050297 r#00199882 r#00199986");
INSERT INTO portuguese_index VALUES ("causalidade","n#00042311 n#13780606","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tristemente","NULL","NULL","NULL","r#00042614 r#00050556 r#00404501");
INSERT INTO portuguese_index VALUES ("descontentemente","NULL","NULL","NULL","r#00042614 r#00050556");
INSERT INTO portuguese_index VALUES ("partida","n#00029100 n#00029442 n#00031963 n#03560567 n#05542799 n#05554348 n#06118344","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infelizmente","NULL","NULL","NULL","r#00042769");
INSERT INTO portuguese_index VALUES ("desgraçadamente","NULL","NULL","NULL","r#00042769");
INSERT INTO portuguese_index VALUES ("lamentavelmente","NULL","NULL","NULL","r#00042769 r#00093270");
INSERT INTO portuguese_index VALUES ("em_vista_disso","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("por_este_motivo","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("consequentemente","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("dessa_forma","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("por_isto","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("de_tal_modo","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("desse_jeito","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("portanto","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("assim_sendo","NULL","NULL","NULL","r#00043003");
INSERT INTO portuguese_index VALUES ("assim","NULL","NULL","a#01491308","r#00043003 r#00118363 r#00121002");
INSERT INTO portuguese_index VALUES ("daqui","NULL","NULL","NULL","r#00043003 r#00043521");
INSERT INTO portuguese_index VALUES ("ataviar","NULL","v#00043078","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vestir","NULL","v#00043078 v#00044149 v#00031591 v#00033917 v#00034046 v#00036087 v#00037183 v#00293528","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descobrimento","n#00098007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descoberta","n#00098007 n#04475449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perfumar","NULL","v#00043480","NULL","NULL");
INSERT INTO portuguese_index VALUES ("daí","NULL","NULL","NULL","r#00043608");
INSERT INTO portuguese_index VALUES ("desde_aí","NULL","NULL","NULL","r#00043608");
INSERT INTO portuguese_index VALUES ("por_isso","NULL","NULL","NULL","r#00043608");
INSERT INTO portuguese_index VALUES ("eliminação","n#00043609 n#00251311 n#00253361 n#13473392","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("efetivo","NULL","NULL","a#00044309 a#01753746","NULL");
INSERT INTO portuguese_index VALUES ("efectivo","NULL","NULL","a#00044309","NULL");
INSERT INTO portuguese_index VALUES ("verdadeiro","NULL","NULL","a#00044309 a#01351228 a#02044571 a#02095155 a#02341880 a#02350264","NULL");
INSERT INTO portuguese_index VALUES ("real","n#13667908","NULL","a#00044309 a#00629037 a#01534893 a#02044571 a#02598692","NULL");
INSERT INTO portuguese_index VALUES ("jogada","n#00043902 n#00108013","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebatida","n#00043902","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("batida","n#00043902 n#00125629 n#00086415 n#05499044 n#07410745 n#07923297","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("roupa_formal","NULL","v#00044149","NULL","NULL");
INSERT INTO portuguese_index VALUES ("implementação","n#00061322","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("execução","n#00061322 n#00061811 n#00729616 n#00729882 n#01163779 n#09750253","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vocacionalmente","NULL","NULL","NULL","r#00044262");
INSERT INTO portuguese_index VALUES ("potencial","NULL","NULL","a#00045137 a#01811604","NULL");
INSERT INTO portuguese_index VALUES ("possível","NULL","NULL","a#00045137 a#01750551 a#01752028","NULL");
INSERT INTO portuguese_index VALUES ("cara_a_cara","NULL","NULL","NULL","r#00044394");
INSERT INTO portuguese_index VALUES ("emergência","n#00044455 n#00027592 n#05458815 n#07417405","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("latente","NULL","NULL","a#00045320","NULL");
INSERT INTO portuguese_index VALUES ("equalizador","n#00121287","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("equalização","n#00121287","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pontiagudo","NULL","NULL","a#00045472","NULL");
INSERT INTO portuguese_index VALUES ("exumação","n#00044900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subagudo","NULL","NULL","a#00044987","NULL");
INSERT INTO portuguese_index VALUES ("mitzvá","n#00045114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crónico","NULL","NULL","a#00045826 a#00489768","NULL");
INSERT INTO portuguese_index VALUES ("crônico","NULL","NULL","a#00045826 a#00489768","NULL");
INSERT INTO portuguese_index VALUES ("impulsão","n#00045250 n#00065545 n#00112312 n#11447851","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("propulsão","n#00045250 n#11497777","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("degenerativo","NULL","NULL","a#00046069","NULL");
INSERT INTO portuguese_index VALUES ("virulento","NULL","NULL","a#00045561 a#01730738 a#02449952","NULL");
INSERT INTO portuguese_index VALUES ("melhora","n#00058089","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("restabelecimento","n#00058089","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reabilitação","n#00058089","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para_além","NULL","NULL","NULL","r#00045704");
INSERT INTO portuguese_index VALUES ("perder_peso","NULL","v#00045817 v#00045817","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reduzir_peso","NULL","v#00045817","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emagrecer","NULL","v#00045817 v#00430999","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mortal","NULL","NULL","a#00046646 a#00941009 a#00941191 a#01446038 a#01495166 a#01658677","NULL");
INSERT INTO portuguese_index VALUES ("recuperação","n#00058314 n#00060414 n#04444540 n#05521978 n#09718984","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caso_contrário","NULL","NULL","NULL","r#00046002");
INSERT INTO portuguese_index VALUES ("adaptável","NULL","NULL","a#00046109 a#01027263","NULL");
INSERT INTO portuguese_index VALUES ("ganhar_peso","NULL","v#00046151","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engordar","NULL","v#00046151 v#00812836","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adicionalmente","NULL","NULL","NULL","r#00046167 r#00212411");
INSERT INTO portuguese_index VALUES ("de_lambuja","NULL","NULL","NULL","r#00046167");
INSERT INTO portuguese_index VALUES ("fuga","n#00046177 n#00032687 n#00034082 n#05281448","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escapatória","n#00046177 n#02651996","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escape","n#00046177 n#00032687","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demasiado","NULL","NULL","a#01470633","r#00046299");
INSERT INTO portuguese_index VALUES ("extremamente","NULL","NULL","NULL","r#00046299 r#00196540");
INSERT INTO portuguese_index VALUES ("excessivo","NULL","NULL","a#00549826 a#01470633 a#01524894 a#01929728","r#00046299");
INSERT INTO portuguese_index VALUES ("adaptativo","NULL","NULL","a#00046471","NULL");
INSERT INTO portuguese_index VALUES ("toque","n#00079716 n#04373543 n#05468490 n#05514913","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrumar-se","NULL","v#00032951","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vestir-se","NULL","v#00032951","NULL","NULL");
INSERT INTO portuguese_index VALUES ("loucamente","NULL","NULL","NULL","r#00046639 r#00080890 r#00503370");
INSERT INTO portuguese_index VALUES ("disfuncional","NULL","NULL","a#00046792 a#01275057","NULL");
INSERT INTO portuguese_index VALUES ("extraordinària","NULL","NULL","NULL","r#00046863");
INSERT INTO portuguese_index VALUES ("extraordinariamente","NULL","NULL","NULL","r#00046863 r#00454512");
INSERT INTO portuguese_index VALUES ("viciado","n#09768830 n#09769076","NULL","a#00047029","NULL");
INSERT INTO portuguese_index VALUES ("alcoólico","NULL","NULL","a#00050590 a#01111705","NULL");
INSERT INTO portuguese_index VALUES ("experimentar","NULL","v#00047317 v#00080645 v#00402992 v#00597061 v#00813161 v#01209074 v#01443215 v#02108377 v#01444597 v#01726604 v#02532886","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excessivamente","NULL","NULL","NULL","r#00047392 r#00487759");
INSERT INTO portuguese_index VALUES ("medos","NULL","NULL","NULL","r#00047392");
INSERT INTO portuguese_index VALUES ("de_forma_excessiva","NULL","NULL","NULL","r#00047392");
INSERT INTO portuguese_index VALUES ("dependente","NULL","NULL","a#00047406 a#00523065 a#00690180 a#00727113","NULL");
INSERT INTO portuguese_index VALUES ("também","NULL","NULL","NULL","r#00047534");
INSERT INTO portuguese_index VALUES ("assim_mesmo","NULL","NULL","NULL","r#00047534");
INSERT INTO portuguese_index VALUES ("idem","NULL","NULL","NULL","r#00047534");
INSERT INTO portuguese_index VALUES ("outrossim","NULL","NULL","NULL","r#00047534");
INSERT INTO portuguese_index VALUES ("a_propósito","NULL","NULL","NULL","r#00047641 r#00156222 r#00167816");
INSERT INTO portuguese_index VALUES ("a_tempo","NULL","NULL","NULL","r#00047641 r#00167816");
INSERT INTO portuguese_index VALUES ("expediente","n#00025398","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("viciante","NULL","NULL","a#00047786","NULL");
INSERT INTO portuguese_index VALUES ("finalmente","NULL","NULL","NULL","r#00047903 r#00048138 r#00065822");
INSERT INTO portuguese_index VALUES ("afinal_de_contas","NULL","NULL","NULL","r#00047903");
INSERT INTO portuguese_index VALUES ("por_fim","NULL","NULL","NULL","r#00047903 r#00048138 r#00065822");
INSERT INTO portuguese_index VALUES ("ultimamente","NULL","NULL","NULL","r#00047903 r#00107416");
INSERT INTO portuguese_index VALUES ("até_que_enfim","NULL","NULL","NULL","r#00047903 r#00048138");
INSERT INTO portuguese_index VALUES ("enfim","NULL","NULL","NULL","r#00047903 r#00048138");
INSERT INTO portuguese_index VALUES ("aditivo","NULL","NULL","a#00048129 a#00048219","NULL");
INSERT INTO portuguese_index VALUES ("mais_cedo_ou_mais_tarde","NULL","NULL","NULL","r#00048138");
INSERT INTO portuguese_index VALUES ("emfim","NULL","NULL","NULL","r#00048138");
INSERT INTO portuguese_index VALUES ("chegar_la-metaforicamente","n#00025788","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atualmente","NULL","NULL","NULL","r#00048268 r#00048475 r#00049220");
INSERT INTO portuguese_index VALUES ("presentemente","NULL","NULL","NULL","r#00048268 r#00048475");
INSERT INTO portuguese_index VALUES ("actualmente","NULL","NULL","NULL","r#00048268 r#00048475 r#00049220");
INSERT INTO portuguese_index VALUES ("chegada","n#00025919 n#00026283 n#05438121","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vinda","n#00025919 n#00026283 n#00027910","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hoje","n#10848167 n#15156001","NULL","NULL","r#00048475 r#00207366");
INSERT INTO portuguese_index VALUES ("hoje_em_dia","n#15262921","NULL","NULL","r#00048475");
INSERT INTO portuguese_index VALUES ("conseguimento","n#00026147","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_delonga","NULL","NULL","NULL","r#00048739");
INSERT INTO portuguese_index VALUES ("em_seguida","NULL","NULL","NULL","r#00048739 r#00117620");
INSERT INTO portuguese_index VALUES ("directamente","NULL","NULL","NULL","r#00048739");
INSERT INTO portuguese_index VALUES ("advento","n#00026283","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extra","NULL","NULL","a#00048219 a#01524894","NULL");
INSERT INTO portuguese_index VALUES ("adicional","NULL","NULL","a#00048219 a#00049554 a#01782889","NULL");
INSERT INTO portuguese_index VALUES ("entrada","n#00026402 n#00290685 n#02591205 n#03244388 n#02641840 n#03985684 n#07582277 n#09611330","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ingresso","n#00026402 n#09538207","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("complementar","NULL","v#00455919","a#00858284 a#00049554 a#02269499","NULL");
INSERT INTO portuguese_index VALUES ("agora","n#15119919","NULL","NULL","r#00049220");
INSERT INTO portuguese_index VALUES ("ora","NULL","NULL","NULL","r#00049220");
INSERT INTO portuguese_index VALUES ("no_presente","NULL","NULL","NULL","r#00049220");
INSERT INTO portuguese_index VALUES ("incremental","NULL","NULL","a#01804974","NULL");
INSERT INTO portuguese_index VALUES ("intrusão","n#00049530 n#00472484","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calçar","NULL","v#00049770 v#00301544","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acesso","n#00027115 n#00181619 n#02159544 n#02591205 n#04031707","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suplementar","NULL","NULL","a#00049554 a#01782889","NULL");
INSERT INTO portuguese_index VALUES ("despojar","NULL","v#00035494","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despir","NULL","v#00035494","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desnudar","NULL","v#00035494 v#00133822","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agresivamente","NULL","NULL","NULL","r#00049947");
INSERT INTO portuguese_index VALUES ("brilhantemente","NULL","NULL","NULL","r#00049947 r#00211651 r#00429534");
INSERT INTO portuguese_index VALUES ("matricula","n#00027235","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("matrícula","n#00027235 n#01248608","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inscrição","n#00027235 n#04828090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("registro","n#00027235 n#04071876 n#04881717 n#04883282 n#04984758","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_parar","NULL","NULL","NULL","r#00050186");
INSERT INTO portuguese_index VALUES ("firmemente","NULL","NULL","NULL","r#00050186 r#00050817 r#00092569 r#00224700 r#00300137");
INSERT INTO portuguese_index VALUES ("ablativo","n#06312418","NULL","a#00050260 a#03041636","NULL");
INSERT INTO portuguese_index VALUES ("contentemente","NULL","NULL","NULL","r#00050297");
INSERT INTO portuguese_index VALUES ("alegremente","NULL","NULL","NULL","r#00050297 r#00230749 r#00280168 r#00348247");
INSERT INTO portuguese_index VALUES ("redutor","NULL","NULL","a#00050446","NULL");
INSERT INTO portuguese_index VALUES ("aparição","n#00050484 n#04532842 n#05458256 n#06896270","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caber","NULL","v#00036087","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colocar","NULL","v#00036087 v#00207305 v#00665476 v#01026409 v#01496497 v#01030210 v#01528821 v#01063016 v#01079342 v#01613239 v#01354457","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trazer","NULL","v#00036087 v#01433674 v#00996361 v#01328437 v#01422262 v#01424107 v#01527254","NULL","NULL");
INSERT INTO portuguese_index VALUES ("usar","NULL","v#00036087 v#00788109 v#00792261 v#01752442","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pôr","NULL","v#00036087 v#00207305 v#00665476 v#01026409 v#01030210 v#01062571 v#01063016 v#01079342 v#01085355 v#01613239 v#01970646 v#01354457","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_hesitação","NULL","NULL","NULL","r#00050817 r#00241550 r#00298765");
INSERT INTO portuguese_index VALUES ("com_firmeza","NULL","NULL","NULL","r#00050817 r#00051017");
INSERT INTO portuguese_index VALUES ("diretamente","NULL","NULL","NULL","r#00051017");
INSERT INTO portuguese_index VALUES ("com_convicção","NULL","NULL","NULL","r#00051017");
INSERT INTO portuguese_index VALUES ("adequado","NULL","NULL","a#00053037 a#00053327 a#00812035 a#00968256 a#01077975 a#01316335 a#01878870 a#01879667","NULL");
INSERT INTO portuguese_index VALUES ("volta","n#00027910 n#05538316 n#13869547","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regresso","n#00027910 n#00211639 n#05538316","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retorno","n#00027910 n#00089351 n#00211639 n#13256691 n#13479380","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penetração_de_mercado","n#00051897","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vestido","n#02456798 n#02222774 n#03051540 n#03113657 n#02600401 n#02764599 n#03450516 n#03450734 n#04097866 n#03346396 n#03438739","v#00037183 v#00106592","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exatamente","NULL","NULL","NULL","r#00052152 r#00158309 r#00204523");
INSERT INTO portuguese_index VALUES ("incompetente","NULL","NULL","a#00054157 a#00511214 a#01128103 a#02229324","NULL");
INSERT INTO portuguese_index VALUES ("pouso","n#00052500","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aterrissagem","n#00052500 n#00188766","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aterragem","n#00052500 n#00305005","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fecundar","NULL","v#00052548 v#00504270","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inseminar","NULL","v#00052548","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fertilizar","NULL","v#00052548 v#00504270","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adesivo","NULL","NULL","a#00052672","NULL");
INSERT INTO portuguese_index VALUES ("amargamente","NULL","NULL","NULL","r#00052882");
INSERT INTO portuguese_index VALUES ("aderente","NULL","NULL","a#00053032","NULL");
INSERT INTO portuguese_index VALUES ("despedida","n#00029442 n#04973475","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engravidar","NULL","v#00037785","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emprenhar","NULL","v#00037785 v#00053341","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depressa","NULL","NULL","NULL","r#00053274");
INSERT INTO portuguese_index VALUES ("coerente","NULL","NULL","a#00055097 a#00433594 a#00802172 a#01857552","NULL");
INSERT INTO portuguese_index VALUES ("tenaz","n#04450749","NULL","a#00055097 a#01934939 a#02216747","NULL");
INSERT INTO portuguese_index VALUES ("semrodeios","NULL","NULL","NULL","r#00053394");
INSERT INTO portuguese_index VALUES ("saída_à_francesa","n#00053405","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coesivo","NULL","NULL","a#00053564","NULL");
INSERT INTO portuguese_index VALUES ("coeso","NULL","NULL","a#00053564","NULL");
INSERT INTO portuguese_index VALUES ("desaparição","n#00029712","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("viscoso","NULL","NULL","a#00053691 a#00054109 a#02417028","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_prática","NULL","NULL","NULL","r#00053744");
INSERT INTO portuguese_index VALUES ("quase","NULL","NULL","NULL","r#00053744 r#00073033");
INSERT INTO portuguese_index VALUES ("retirada","n#00029961 n#00031519 n#00031741","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("provavelmente","NULL","NULL","NULL","r#00053952 r#00138611");
INSERT INTO portuguese_index VALUES ("depois","NULL","NULL","NULL","r#00054212 r#00117620 r#00146281");
INSERT INTO portuguese_index VALUES ("a_seguir","NULL","NULL","NULL","r#00054212");
INSERT INTO portuguese_index VALUES ("próximo","NULL","NULL","a#00130334 a#00412848 a#00413658 a#00415743 a#00417100 a#00419102 a#01668941","r#00054212 r#00160440");
INSERT INTO portuguese_index VALUES ("seguinte","NULL","NULL","a#00130202 a#00130334","r#00054212");
INSERT INTO portuguese_index VALUES ("conceber","NULL","v#00054285 v#00038574 v#00711550 v#01122689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("temporiamente","NULL","NULL","NULL","r#00054327 r#00088303");
INSERT INTO portuguese_index VALUES ("provisoriamente","NULL","NULL","NULL","r#00054327 r#00064946 r#00088303 r#00480195");
INSERT INTO portuguese_index VALUES ("por_enquanto","NULL","NULL","NULL","r#00054327 r#00064946");
INSERT INTO portuguese_index VALUES ("esfacelamento","n#00054328","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gerar","NULL","v#00038574 v#00038872 v#00056683 v#01118767 v#01119839","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_filho","NULL","v#00038574","NULL","NULL");
INSERT INTO portuguese_index VALUES ("procriar","NULL","v#00038574 v#00038872 v#00056683 v#01118767","NULL","NULL");
INSERT INTO portuguese_index VALUES ("à_máquina","NULL","NULL","NULL","r#00054636");
INSERT INTO portuguese_index VALUES ("evacuação","n#00054821 n#00395797 n#13473097","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("terrivelmente","NULL","NULL","NULL","r#00054950 r#00055101 r#00056340 r#00199565 r#00316486 r#00505744");
INSERT INTO portuguese_index VALUES ("ejacular","NULL","v#00055010 v#00981944","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abissalmente","NULL","NULL","NULL","r#00055101");
INSERT INTO portuguese_index VALUES ("reproduzir","NULL","v#00038872 v#00649220 v#00979715","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deserção","n#00030682","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("processual","NULL","NULL","a#00055340","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_intolerável","NULL","NULL","NULL","r#00055518");
INSERT INTO portuguese_index VALUES ("inaceitavelmente","NULL","NULL","NULL","r#00055518");
INSERT INTO portuguese_index VALUES ("intoleravelmente","NULL","NULL","NULL","r#00055518");
INSERT INTO portuguese_index VALUES ("essencial","NULL","NULL","a#00056407 a#00807895 a#00808287 a#00886008 a#00858627 a#02865172 a#01523975 a#01524177 a#01524557","NULL");
INSERT INTO portuguese_index VALUES ("substancial","NULL","NULL","a#00056407 a#00590782 a#00592078 a#00857259 a#02165307","NULL");
INSERT INTO portuguese_index VALUES ("substantivo","n#06303540 n#04766930 n#04768298","NULL","a#00056407","NULL");
INSERT INTO portuguese_index VALUES ("propagar","NULL","v#00039057 v#00039309","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abusivamente","NULL","NULL","NULL","r#00055739");
INSERT INTO portuguese_index VALUES ("de_forma_abusiva","NULL","NULL","NULL","r#00055739");
INSERT INTO portuguese_index VALUES ("admiradamente","NULL","NULL","NULL","r#00055859");
INSERT INTO portuguese_index VALUES ("adornado","NULL","NULL","a#00056778","NULL");
INSERT INTO portuguese_index VALUES ("expatriação","n#00031327","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emigração","n#00031327","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inocular","NULL","v#00056093","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imigração","n#00031422 n#08413834 n#07334599","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("horrivelmente","NULL","NULL","NULL","r#00056340");
INSERT INTO portuguese_index VALUES ("de_forma_drástica","NULL","NULL","NULL","r#00056652");
INSERT INTO portuguese_index VALUES ("drasticamente","NULL","NULL","NULL","r#00056652");
INSERT INTO portuguese_index VALUES ("quer_que","NULL","NULL","NULL","r#00056729");
INSERT INTO portuguese_index VALUES ("nada","n#09893278","NULL","NULL","r#00056729");
INSERT INTO portuguese_index VALUES ("pôr_no_mundo","NULL","v#00039991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_à_luz","NULL","v#00039991 v#00039991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_a_luz","NULL","v#00039991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parir","NULL","v#00039991 v#00040631 v#00040829 v#00040922 v#00041013 v#00041201 v#00041285 v#00041370 v#00041451 v#01197357","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter","NULL","v#00039991 v#00045715 v#00045966 v#01443215 v#01509295 v#01795751 v#01842330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_nenhuma_maneira","NULL","NULL","NULL","r#00057042");
INSERT INTO portuguese_index VALUES ("nem_a_pau","NULL","NULL","NULL","r#00057042");
INSERT INTO portuguese_index VALUES ("de_modo_nenhum","NULL","NULL","NULL","r#00057042");
INSERT INTO portuguese_index VALUES ("porra_nenhuma","NULL","NULL","NULL","r#00057042");
INSERT INTO portuguese_index VALUES ("nem_que_a_vaca_tussa","NULL","NULL","NULL","r#00057042");
INSERT INTO portuguese_index VALUES ("de_forma_nenhuma","NULL","NULL","a#02267686","r#00057042");
INSERT INTO portuguese_index VALUES ("exaustivamente","NULL","NULL","NULL","r#00057257");
INSERT INTO portuguese_index VALUES ("minuciosamente","NULL","v#01460594","NULL","r#00057388 r#00057892");
INSERT INTO portuguese_index VALUES ("recessão","n#00031866 n#00811593 n#10092910 n#10394468","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desembarque","n#00058002 n#00058247","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("direto","NULL","NULL","a#00729544","r#00058128");
INSERT INTO portuguese_index VALUES ("embarque","n#00058337","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indiretamente","NULL","NULL","NULL","r#00058359");
INSERT INTO portuguese_index VALUES ("indirectamente","NULL","NULL","NULL","r#00058359");
INSERT INTO portuguese_index VALUES ("saída","n#00032499 n#02651996","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escapada","n#00032687","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aguardar","NULL","v#00041553 v#00059376 v#00487408 v#01811441 v#01800838 v#01803556","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esperar","NULL","v#00041553 v#00059376 v#00706047 v#00487408 v#01804961 v#01811441 v#01244897 v#01245981 v#01246466 v#01800838 v#01803556","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evasão","n#00059127 n#00033906 n#00173283 n#06761099","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("um_monte","NULL","NULL","NULL","r#00059171");
INSERT INTO portuguese_index VALUES ("muita","NULL","NULL","NULL","r#00059171");
INSERT INTO portuguese_index VALUES ("mui","NULL","NULL","NULL","r#00059171");
INSERT INTO portuguese_index VALUES ("manobra","n#00033506 n#00109256 n#00363237 n#00611703 n#00615775 n#04538754","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abortar","NULL","v#00042125 v#00059899 v#00246783","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guarnecido","NULL","NULL","a#00059782","NULL");
INSERT INTO portuguese_index VALUES ("mais_e_mais","NULL","NULL","NULL","r#00059854");
INSERT INTO portuguese_index VALUES ("progressivamente","NULL","NULL","NULL","r#00059854");
INSERT INTO portuguese_index VALUES ("cada_vez_mais","NULL","NULL","NULL","r#00059854");
INSERT INTO portuguese_index VALUES ("crescentemente","NULL","NULL","NULL","r#00059854");
INSERT INTO portuguese_index VALUES ("estofado","NULL","NULL","a#00059965","NULL");
INSERT INTO portuguese_index VALUES ("eclodir","NULL","v#00060185 v#00063095","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hégira","n#00060548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anteriormente","NULL","NULL","NULL","r#00060632 r#00074095 r#00265579");
INSERT INTO portuguese_index VALUES ("diante","NULL","NULL","NULL","r#00060632");
INSERT INTO portuguese_index VALUES ("previamente","NULL","NULL","NULL","r#00060632");
INSERT INTO portuguese_index VALUES ("em_lugar_anterior","NULL","NULL","NULL","r#00060632 r#00118965");
INSERT INTO portuguese_index VALUES ("antes","NULL","NULL","NULL","r#00060632 r#00060939");
INSERT INTO portuguese_index VALUES ("Underground_railroad","n#00060817","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("capar","NULL","v#00060833 v#00061079","NULL","NULL");
INSERT INTO portuguese_index VALUES ("castrar","NULL","v#00060833","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dantes","NULL","NULL","NULL","r#00060939");
INSERT INTO portuguese_index VALUES ("colinérgico","NULL","NULL","a#00060969","NULL");
INSERT INTO portuguese_index VALUES ("anticolinérgico","NULL","NULL","a#00061088","NULL");
INSERT INTO portuguese_index VALUES ("Anti-colinérgico","NULL","NULL","a#00061088","NULL");
INSERT INTO portuguese_index VALUES ("Surfacing","n#00061171","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subsequentemente","NULL","NULL","NULL","r#00061203");
INSERT INTO portuguese_index VALUES ("posteriormente","NULL","NULL","NULL","r#00061203");
INSERT INTO portuguese_index VALUES ("após","NULL","NULL","NULL","r#00061203");
INSERT INTO portuguese_index VALUES ("subseqüentemente","NULL","NULL","NULL","r#00061203");
INSERT INTO portuguese_index VALUES ("mais_tarde","NULL","NULL","NULL","r#00061203 r#00117620 r#00146281 r#00155488");
INSERT INTO portuguese_index VALUES ("alerta","NULL","NULL","a#00149236","NULL");
INSERT INTO portuguese_index VALUES ("bem_disposto","NULL","NULL","a#00149236","NULL");
INSERT INTO portuguese_index VALUES ("hábil","NULL","NULL","a#00149236 a#00061885 a#01090656 a#02120998","NULL");
INSERT INTO portuguese_index VALUES ("animado","NULL","NULL","a#00149236 a#00120252 a#00353226","NULL");
INSERT INTO portuguese_index VALUES ("expedição","n#00034968 n#00200777 n#00621864 n#00716041 n#06218497","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("envio","n#00034968 n#01060234","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precipitadamente","NULL","NULL","NULL","r#00061528 r#00206479 r#00429390");
INSERT INTO portuguese_index VALUES ("abruptamente","NULL","NULL","NULL","r#00061528 r#00429390");
INSERT INTO portuguese_index VALUES ("subitamente","NULL","NULL","NULL","r#00061528 r#00061677 r#00151957");
INSERT INTO portuguese_index VALUES ("esterilizar","NULL","v#00061595 v#00062582","NULL","NULL");
INSERT INTO portuguese_index VALUES ("genial","NULL","NULL","a#00061885","NULL");
INSERT INTO portuguese_index VALUES ("engenhoso","NULL","NULL","a#00061885 a#00301854","NULL");
INSERT INTO portuguese_index VALUES ("astuto","NULL","NULL","a#00061885 a#00148874 a#00149802 a#00407935 a#01253976 a#01256495 a#02347493","NULL");
INSERT INTO portuguese_index VALUES ("orgasmo","n#00035701","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("menstruar","NULL","v#00062203","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intencionalmente","NULL","NULL","NULL","r#00062330");
INSERT INTO portuguese_index VALUES ("deliberadamente","NULL","NULL","NULL","r#00062330");
INSERT INTO portuguese_index VALUES ("de_propósito","NULL","NULL","NULL","r#00062330 r#00507323");
INSERT INTO portuguese_index VALUES ("de_forma_intencional","NULL","NULL","NULL","r#00062330");
INSERT INTO portuguese_index VALUES ("por_escolha","NULL","NULL","NULL","r#00062330");
INSERT INTO portuguese_index VALUES ("nomeadamente","NULL","NULL","NULL","r#00062330");
INSERT INTO portuguese_index VALUES ("expressamente","NULL","NULL","NULL","r#00062330 r#00085512");
INSERT INTO portuguese_index VALUES ("jeitoso","NULL","NULL","a#01090656","NULL");
INSERT INTO portuguese_index VALUES ("sem_querer","NULL","NULL","NULL","r#00062650");
INSERT INTO portuguese_index VALUES ("involuntariamente","NULL","NULL","NULL","r#00062650");
INSERT INTO portuguese_index VALUES ("obtenção","n#00036271 n#00051225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conformemente","NULL","NULL","NULL","r#00062857");
INSERT INTO portuguese_index VALUES ("correspondentemente","NULL","NULL","NULL","r#00062857");
INSERT INTO portuguese_index VALUES ("récorde","n#00036443","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ao_invés_de","NULL","NULL","NULL","r#00063172");
INSERT INTO portuguese_index VALUES ("em_vez_de","NULL","NULL","NULL","r#00063172");
INSERT INTO portuguese_index VALUES ("alternativamente","NULL","NULL","NULL","r#00063172");
INSERT INTO portuguese_index VALUES ("desajeitado","NULL","NULL","a#00065067 a#01091940","NULL");
INSERT INTO portuguese_index VALUES ("irritar","NULL","v#00044261 v#00503715 v#01771194 v#01220279 v#01221002 v#01221478 v#01221816 v#01221988 v#01222491 v#01795333","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recorde_mundial","n#00063559","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Recorde_Mundial","n#00063559","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Recordes_mundiais","n#00063559","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desengoçado","NULL","NULL","a#00065335","NULL");
INSERT INTO portuguese_index VALUES ("sucesso","n#00036683 n#00037139 n#14474052","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triunfo","n#00036683 n#05596663","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("êxito","n#00036683 n#10383516","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inflamar","NULL","v#00063724","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acalmar","NULL","v#00044675 v#00519450 v#00812117 v#01204371 v#01204852 v#01238399 v#01238553","a#00197151","NULL");
INSERT INTO portuguese_index VALUES ("anatomicamente","NULL","NULL","NULL","r#00064083");
INSERT INTO portuguese_index VALUES ("melhorar","NULL","v#00044854 v#00062604 v#00140363 v#00140682 v#00140937 v#00142397 v#00157745 v#00184775 v#00385378","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atenuar","NULL","v#00044854 v#00613501","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amenizar","NULL","v#00044854 v#00116292 v#00167516","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aliviar","NULL","v#00044854 v#00056311 v#00361385 v#00819436 v#01204852 v#01238399 v#01238553 v#01238726","a#00477896","NULL");
INSERT INTO portuguese_index VALUES ("arrasa-quarteirão","n#00064151","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cegamente","NULL","NULL","NULL","r#00064189 r#00173992");
INSERT INTO portuguese_index VALUES ("às_cegas","NULL","NULL","NULL","r#00064189 r#00173992");
INSERT INTO portuguese_index VALUES ("cronologicamente","NULL","NULL","NULL","r#00064464");
INSERT INTO portuguese_index VALUES ("propício","NULL","NULL","a#00064479 a#00176908 a#00177964 a#00178165 a#01602210","NULL");
INSERT INTO portuguese_index VALUES ("vantajoso","NULL","NULL","a#00064479 a#00067152 a#00178165 a#01747057","NULL");
INSERT INTO portuguese_index VALUES ("profícuo","NULL","NULL","a#00064479 a#00883926","NULL");
INSERT INTO portuguese_index VALUES ("favorável","NULL","NULL","a#00064479 a#00178165 a#00315634 a#00572209 a#00942944 a#00943564 a#00944158 a#01023795","NULL");
INSERT INTO portuguese_index VALUES ("massagear","NULL","v#00064487","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sensação","n#00037139 n#04413760 n#04419902 n#05586720","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estrondo","n#00037139 n#07430211","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clinicamente","NULL","NULL","NULL","r#00064583");
INSERT INTO portuguese_index VALUES ("machucar","NULL","v#00045186 v#00048850 v#00069684 v#00177802","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aleijar","NULL","v#00045186","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ferir","NULL","v#00045186 v#00048850 v#00069684","NULL","NULL");
INSERT INTO portuguese_index VALUES ("doer","NULL","v#00045186 v#00054373 v#01451659 v#01452083","NULL","NULL");
INSERT INTO portuguese_index VALUES ("benéfico","NULL","NULL","a#00067152","NULL");
INSERT INTO portuguese_index VALUES ("bom","NULL","NULL","a#00067152 a#00597129 a#00998470 a#01076114 a#01082452 a#01280193 a#01529605 a#01602469 a#01807436 a#01921348","NULL");
INSERT INTO portuguese_index VALUES ("boa","n#03325584","NULL","a#00067152 a#00998470 a#01076114 a#01082452 a#01529605","NULL");
INSERT INTO portuguese_index VALUES ("indispor","NULL","v#00064889","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ao_mesmo_tempo","NULL","NULL","NULL","r#00064946 r#00120095 r#00120223 r#00153261");
INSERT INTO portuguese_index VALUES ("entretanto","NULL","NULL","NULL","r#00064946");
INSERT INTO portuguese_index VALUES ("positiva","NULL","NULL","a#00065064","NULL");
INSERT INTO portuguese_index VALUES ("positivo","NULL","NULL","a#00065064 a#01747057","NULL");
INSERT INTO portuguese_index VALUES ("sofrer","NULL","v#00054373 v#00045966 v#00054559 v#01224912 v#02108377 v#02719807","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enquanto_isso","NULL","NULL","NULL","r#00065184");
INSERT INTO portuguese_index VALUES ("duas_vezes","NULL","NULL","NULL","r#00065294");
INSERT INTO portuguese_index VALUES ("duas","n#13743269","NULL","NULL","r#00065294");
INSERT INTO portuguese_index VALUES ("padecer","NULL","v#00045715 v#00054559","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfavorável","NULL","NULL","a#00067911 a#00943257 a#00944348 a#01082026","NULL");
INSERT INTO portuguese_index VALUES ("desvantajoso","NULL","NULL","a#00067911","NULL");
INSERT INTO portuguese_index VALUES ("estar_bem","NULL","v#00065495","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sentir-se_bem","NULL","v#00065495","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extensamente","NULL","NULL","NULL","r#00065575 r#00495663");
INSERT INTO portuguese_index VALUES ("contrair","NULL","v#00045966 v#00059435 v#00164388 v#00873632 v#00951804","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negativo","NULL","NULL","a#00065667 a#01750220 a#00554376 a#00202234","NULL");
INSERT INTO portuguese_index VALUES ("aventureiro","NULL","NULL","a#00068206","NULL");
INSERT INTO portuguese_index VALUES ("por_último","NULL","NULL","NULL","r#00065822");
INSERT INTO portuguese_index VALUES ("crédito","n#00038052 n#09631860 n#09634656 n#09651550 n#09655443","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mas_não_menos_importante","NULL","NULL","NULL","r#00065963");
INSERT INTO portuguese_index VALUES ("último","NULL","NULL","a#00668366 a#00958252","r#00065963 r#00167575");
INSERT INTO portuguese_index VALUES ("choramingar","NULL","v#00046267 v#00046397","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gemer","NULL","v#00046267 v#00667147 v#00708262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arriscado","NULL","NULL","a#00841837 a#00196122 a#01983358","NULL");
INSERT INTO portuguese_index VALUES ("destemido","NULL","NULL","a#00841837 a#00081671 a#00246332 a#01415513 a#00264459","NULL");
INSERT INTO portuguese_index VALUES ("arriscador","NULL","NULL","a#00841837","NULL");
INSERT INTO portuguese_index VALUES ("audaz","NULL","NULL","a#00841837 a#00246332 a#01415513","NULL");
INSERT INTO portuguese_index VALUES ("audacioso","NULL","NULL","a#00841837 a#00246332 a#01415513","NULL");
INSERT INTO portuguese_index VALUES ("ousado","NULL","NULL","a#00841837 a#01415513","NULL");
INSERT INTO portuguese_index VALUES ("derramar_lágrimas","NULL","v#00046397","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chorar","NULL","v#00046397","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insucesso","n#00066216","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falha","n#00066216 n#00038702 n#00042411 n#09278537 n#14417551 n#10377620","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acusadoramente","NULL","NULL","NULL","r#00066418");
INSERT INTO portuguese_index VALUES ("fracasso","n#00038702 n#05484555","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("erro","n#00038702 n#00042411 n#00042960 n#00043865 n#00043956 n#03768006 n#03768117 n#04853765 n#04529867 n#04531221 n#04531479 n#05071571 n#10377620","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adiante","NULL","NULL","NULL","r#00066781");
INSERT INTO portuguese_index VALUES ("diante_de","NULL","NULL","NULL","r#00066781");
INSERT INTO portuguese_index VALUES ("em_presença_de","NULL","NULL","NULL","r#00066781");
INSERT INTO portuguese_index VALUES ("defronte","NULL","NULL","NULL","r#00066781");
INSERT INTO portuguese_index VALUES ("ante","NULL","NULL","NULL","r#00066781");
INSERT INTO portuguese_index VALUES ("em_frente","NULL","NULL","NULL","r#00066781 r#00170412");
INSERT INTO portuguese_index VALUES ("frente","n#03398467 n#06320385 n#06320533","NULL","NULL","r#00066781");
INSERT INTO portuguese_index VALUES ("lacrimejar","NULL","v#00046943","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aconselhável","NULL","NULL","a#00069386","NULL");
INSERT INTO portuguese_index VALUES ("antecipadamente","NULL","NULL","NULL","r#00067045");
INSERT INTO portuguese_index VALUES ("para_diante","NULL","NULL","NULL","r#00067265 r#00103859");
INSERT INTO portuguese_index VALUES ("falta","n#00067397 n#00770997 n#01234090 n#10058951 n#10367399 n#10367751","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("omissão","n#00067397 n#05706954","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negligência","n#00067397 n#00043956 n#00738966 n#00476598 n#00478127 n#03677496 n#03677676 n#03677991","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descuido","n#00067397 n#00043956 n#04661926","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("derrota","n#00039700 n#05558471 n#05605777","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perda","n#00039700 n#00135125 n#04022310 n#05455763 n#09595129 n#13328273","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transpirar","NULL","v#00047342 v#00047530","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suar","NULL","v#00047342","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rendição","n#00067707","v#01117812","NULL","NULL");
INSERT INTO portuguese_index VALUES ("capitulação","n#00067707","v#01117812","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desaconselhável","NULL","NULL","a#00067767 a#00932565","NULL");
INSERT INTO portuguese_index VALUES ("obstáculo","n#00040027 n#02254968 n#02299904 n#02300099 n#02819465 n#03549589 n#03051325 n#03839993 n#04345915 n#04022756 n#04394770 n#04395081 n#05688990 n#04395690 n#05690269 n#04396568 n#04396796 n#04396893","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frustração","n#00040027 n#05589778 n#05605777","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exsudar","NULL","v#00047530","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para_frente","NULL","NULL","NULL","r#00068070");
INSERT INTO portuguese_index VALUES ("o_tempo_todo","NULL","NULL","NULL","r#00068215");
INSERT INTO portuguese_index VALUES ("desde_o_começo","NULL","NULL","NULL","r#00068215");
INSERT INTO portuguese_index VALUES ("Recidiva","n#00040312","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quebra","n#00040312","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reincidência","n#00068617","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decepção","n#00040483 n#05605549","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inadimplência","n#00068901 n#13300411","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_cumprimento","n#00068901","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parada","n#00068901 n#00198945 n#08428485","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anaeróbico","NULL","NULL","a#00069060","NULL");
INSERT INTO portuguese_index VALUES ("aeróbico","NULL","NULL","a#00069217","NULL");
INSERT INTO portuguese_index VALUES ("excretar","NULL","v#00069295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estético","NULL","NULL","a#00071970 a#02280052 a#02753417","NULL");
INSERT INTO portuguese_index VALUES ("igual","n#06953318","NULL","a#00845976","r#00069672");
INSERT INTO portuguese_index VALUES ("em_voz_alta","NULL","NULL","NULL","r#00069771 r#00069901");
INSERT INTO portuguese_index VALUES ("vulnerar","NULL","v#00048850","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lesar","NULL","v#00048850 v#00069684","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emvozalta","NULL","NULL","NULL","r#00069901");
INSERT INTO portuguese_index VALUES ("ruidosamente","NULL","NULL","NULL","r#00069901");
INSERT INTO portuguese_index VALUES ("artístico","NULL","NULL","a#00072351 a#02280052 a#02753288","NULL");
INSERT INTO portuguese_index VALUES ("cosmético","n#03113152 n#03714235","NULL","a#00070111 a#01039405","NULL");
INSERT INTO portuguese_index VALUES ("calcar","NULL","v#00049302","NULL","NULL");
INSERT INTO portuguese_index VALUES ("randomicamente","NULL","NULL","NULL","r#00070765");
INSERT INTO portuguese_index VALUES ("arbitrariamente","NULL","NULL","NULL","r#00070765");
INSERT INTO portuguese_index VALUES ("aleatóriamente","NULL","NULL","NULL","r#00070765");
INSERT INTO portuguese_index VALUES ("ao_acaso","NULL","NULL","NULL","r#00070765");
INSERT INTO portuguese_index VALUES ("atabalhoadamente","NULL","NULL","NULL","r#00070765");
INSERT INTO portuguese_index VALUES ("a_torto_e_a_direito","NULL","NULL","NULL","r#00070765 r#00433363");
INSERT INTO portuguese_index VALUES ("a_esmo","NULL","NULL","NULL","r#00070765");
INSERT INTO portuguese_index VALUES ("aleatoriamente","NULL","NULL","NULL","r#00070765 r#00244578 r#00433363");
INSERT INTO portuguese_index VALUES ("afetado","NULL","NULL","a#00073543 a#00075417 a#01559903 a#01570470","NULL");
INSERT INTO portuguese_index VALUES ("equívoco","n#00042411","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engano","n#00042411 n#05064035","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impressionado","NULL","NULL","a#00071142","NULL");
INSERT INTO portuguese_index VALUES ("por_perto","NULL","NULL","NULL","r#00071165 r#00071321");
INSERT INTO portuguese_index VALUES ("tortuar","NULL","v#00071178","NULL","NULL");
INSERT INTO portuguese_index VALUES ("torturar","NULL","v#00071178 v#01794523 v#01802689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atormentar","NULL","v#00071178 v#01794523 v#01802689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ao_pé_de","NULL","NULL","NULL","r#00071321");
INSERT INTO portuguese_index VALUES ("sujeito","n#04761687","NULL","a#00071559 a#01924743","NULL");
INSERT INTO portuguese_index VALUES ("puxar","NULL","v#00050353 v#00993032 v#00997005 v#00998398 v#01233464","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estirar","NULL","v#00050353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_aí","NULL","NULL","NULL","r#00071840");
INSERT INTO portuguese_index VALUES ("fazer_xixi","NULL","v#00072012","NULL","NULL");
INSERT INTO portuguese_index VALUES ("urinar","NULL","v#00072012","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mijar","NULL","v#00072012","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mácula","n#00043135","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mancha","n#00043135 n#04682319 n#03689246 n#04693804 n#03696524 n#04694809 n#05088890 n#07837298","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imune","NULL","NULL","a#00072281 a#02252092 a#02365900 a#02745862","NULL");
INSERT INTO portuguese_index VALUES ("isento","NULL","NULL","a#00072281 a#02254137","NULL");
INSERT INTO portuguese_index VALUES ("confusão","n#00043311 n#04531479 n#05581054 n#07508092 n#10068579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desesperadamente","NULL","NULL","NULL","r#00072849 r#00200614 r#00301840 r#00506807");
INSERT INTO portuguese_index VALUES ("urgentemente","NULL","NULL","NULL","r#00072849");
INSERT INTO portuguese_index VALUES ("expelir","NULL","v#00051051 v#00071198 v#01891307","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bumerangue","n#00073032","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perto_de","NULL","NULL","NULL","r#00073033");
INSERT INTO portuguese_index VALUES ("por_pouco","NULL","NULL","NULL","r#00073033");
INSERT INTO portuguese_index VALUES ("virtualmente","NULL","NULL","NULL","r#00073033 r#00111451");
INSERT INTO portuguese_index VALUES ("artificial","NULL","NULL","a#00075417 a#00075798 a#00114728 a#00551365 a#01516193 a#01517836 a#01620591","NULL");
INSERT INTO portuguese_index VALUES ("arredondamento","n#00073177","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distorção","n#00073713","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forçado","NULL","NULL","a#00076086","NULL");
INSERT INTO portuguese_index VALUES ("em_especial","NULL","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("principalmente","NULL","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("maiormente","NULL","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("primariamente","NULL","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("precipuamente","NULL","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("antes_de_mais_nada","NULL","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("notadamente","NULL","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("especialmente","NULL","NULL","NULL","r#00073897 r#00084223 r#00139266 r#00502710");
INSERT INTO portuguese_index VALUES ("sobretudo","n#03057021 n#03456665","NULL","NULL","r#00073897");
INSERT INTO portuguese_index VALUES ("cagar","NULL","v#00074038","NULL","NULL");
INSERT INTO portuguese_index VALUES ("defecar","NULL","v#00074038","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ato_falho","n#00074092","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Acto_falho","n#00074092","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artificioso","NULL","NULL","a#00074094","NULL");
INSERT INTO portuguese_index VALUES ("atrás","NULL","NULL","NULL","r#00074095");
INSERT INTO portuguese_index VALUES ("há","NULL","NULL","NULL","r#00074095");
INSERT INTO portuguese_index VALUES ("há_tempo","NULL","NULL","NULL","r#00074095");
INSERT INTO portuguese_index VALUES ("faz","NULL","NULL","NULL","r#00074095");
INSERT INTO portuguese_index VALUES ("às_avessas","NULL","NULL","NULL","r#00074407");
INSERT INTO portuguese_index VALUES ("para_trás","NULL","NULL","NULL","r#00074407 r#00075966");
INSERT INTO portuguese_index VALUES ("de_costas","NULL","NULL","NULL","r#00074407 r#00075966");
INSERT INTO portuguese_index VALUES ("constipar","NULL","v#00074558","NULL","NULL");
INSERT INTO portuguese_index VALUES ("natural","NULL","NULL","a#00076892 a#01349983 a#01513557 a#01515628 a#01518608 a#01521837 a#01538156 a#01884502","NULL");
INSERT INTO portuguese_index VALUES ("fiasco","n#00044168 n#05484900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bobagem","n#00044168 n#06612266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gafe","n#00044168 n#00076196 n#00045336","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sangrar","NULL","v#00074834","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exaurir-se","NULL","v#00052062","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exaurir","NULL","v#00052062","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cansar-se","NULL","v#00052062","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afirmativo","NULL","NULL","a#00075135 a#01747447","NULL");
INSERT INTO portuguese_index VALUES ("de_volta","NULL","NULL","NULL","r#00075161");
INSERT INTO portuguese_index VALUES ("avante","NULL","NULL","NULL","r#00075442");
INSERT INTO portuguese_index VALUES ("pelo_contrario","NULL","NULL","NULL","r#00075656 r#00075739");
INSERT INTO portuguese_index VALUES ("por_detraz_ás_avessas","NULL","NULL","NULL","r#00075656 r#00075739");
INSERT INTO portuguese_index VALUES ("surpreso","NULL","NULL","a#02357479","r#00075656");
INSERT INTO portuguese_index VALUES ("atraz","NULL","NULL","NULL","r#00075656 r#00075739");
INSERT INTO portuguese_index VALUES ("detrás","NULL","NULL","NULL","r#00075739");
INSERT INTO portuguese_index VALUES ("fumble","n#00075912","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fatigar","NULL","v#00052840 v#01243090","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para_lá_e_para_cá","NULL","NULL","NULL","r#00076193");
INSERT INTO portuguese_index VALUES ("vai_e_vem","NULL","NULL","NULL","r#00076193");
INSERT INTO portuguese_index VALUES ("vaivém","NULL","NULL","NULL","r#00076193");
INSERT INTO portuguese_index VALUES ("solecismo","n#00076196","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regurgitar","NULL","v#00053004 v#01178335","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vomitar","n#00118733","v#00053004 v#00077071","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tropeço","n#00076563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tombo","n#00045686","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flutuante","NULL","NULL","a#00076921","NULL");
INSERT INTO portuguese_index VALUES ("à_tona","NULL","NULL","a#00076921","NULL");
INSERT INTO portuguese_index VALUES ("à_deriva","NULL","NULL","a#00077059 a#01910652","r#00267558 r#00267704");
INSERT INTO portuguese_index VALUES ("compra","n#00077419 n#00047517 n#00049855 n#00050836 n#13253612","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comercialmente","NULL","NULL","NULL","r#00077497");
INSERT INTO portuguese_index VALUES ("receoso","NULL","NULL","a#00080744","NULL");
INSERT INTO portuguese_index VALUES ("sufocar","NULL","v#00053673","NULL","NULL");
INSERT INTO portuguese_index VALUES ("asfixiar","NULL","v#00053673 v#00053789 v#00359511 v#01476180 v#01569181","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afogar","NULL","v#00053673 v#00329171 v#00333886","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estrangular","NULL","v#00053789 v#00359511","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conversamente","NULL","NULL","NULL","r#00078050");
INSERT INTO portuguese_index VALUES ("congelar","NULL","v#00078138 v#00183882 v#00254265 v#00374135 v#00261966 v#00262285 v#00311143 v#02758581 v#02758826","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amedrontado","NULL","NULL","a#00078463","NULL");
INSERT INTO portuguese_index VALUES ("anexação","n#00078536 n#00373418","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incorporação","n#00078536 n#00239807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("explicitamente","NULL","NULL","NULL","r#00078558 r#00085512 r#00367418");
INSERT INTO portuguese_index VALUES ("declaradamente","NULL","NULL","NULL","r#00078558");
INSERT INTO portuguese_index VALUES ("aterrorizado","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("pasmo","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("espantado","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("horrorizado","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("pasmado","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("apavorado","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("chocado","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("chocada","NULL","NULL","a#00078576","NULL");
INSERT INTO portuguese_index VALUES ("ranger","n#07169157","v#00078578 v#01394464","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agoráfobo","NULL","NULL","a#00078705","NULL");
INSERT INTO portuguese_index VALUES ("agorafóbico","NULL","NULL","a#00078705","NULL");
INSERT INTO portuguese_index VALUES ("agoráfoba","NULL","NULL","a#00078705","NULL");
INSERT INTO portuguese_index VALUES ("tratar","NULL","v#00054862 v#00699711 v#01659890 v#01660593","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coisacomprada","n#00047517","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apreensivo","NULL","NULL","a#00079069 a#00783553","NULL");
INSERT INTO portuguese_index VALUES ("sem_dúvidas","NULL","NULL","NULL","r#00079107");
INSERT INTO portuguese_index VALUES ("indubitavelmente","NULL","NULL","NULL","r#00079107");
INSERT INTO portuguese_index VALUES ("indubitável","NULL","NULL","NULL","r#00079107");
INSERT INTO portuguese_index VALUES ("indubitàvelmente","NULL","NULL","NULL","r#00079107");
INSERT INTO portuguese_index VALUES ("sem_dúvida","NULL","NULL","NULL","r#00079107 r#00144722 r#00150134");
INSERT INTO portuguese_index VALUES ("sem_dúvida_alguma","NULL","NULL","NULL","r#00079107 r#00150134");
INSERT INTO portuguese_index VALUES ("claustrofóbico","NULL","NULL","a#00079356","NULL");
INSERT INTO portuguese_index VALUES ("compra_e_venda","n#00047814","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comércio","n#00047814 n#00706993 n#01091905 n#01094725 n#00720146 n#08065093","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hoje_à_noite","NULL","NULL","NULL","r#00079499");
INSERT INTO portuguese_index VALUES ("esta_tarde","NULL","NULL","NULL","r#00079499");
INSERT INTO portuguese_index VALUES ("esta_noite","NULL","NULL","NULL","r#00079499");
INSERT INTO portuguese_index VALUES ("activamente","NULL","NULL","NULL","r#00079617");
INSERT INTO portuguese_index VALUES ("ativamente","NULL","NULL","NULL","r#00079617 r#00280283");
INSERT INTO portuguese_index VALUES ("assustado","NULL","NULL","a#00082641","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_passiva","NULL","NULL","NULL","r#00079748");
INSERT INTO portuguese_index VALUES ("passivamente","NULL","NULL","NULL","r#00079748");
INSERT INTO portuguese_index VALUES ("embaixo","NULL","NULL","NULL","r#00079866");
INSERT INTO portuguese_index VALUES ("a_mais","NULL","NULL","NULL","r#00079947");
INSERT INTO portuguese_index VALUES ("porbaixode","NULL","NULL","NULL","r#00080039");
INSERT INTO portuguese_index VALUES ("abaixode","NULL","NULL","NULL","r#00080039");
INSERT INTO portuguese_index VALUES ("debaixode","NULL","NULL","NULL","r#00080039");
INSERT INTO portuguese_index VALUES ("acima","NULL","NULL","a#01155248","r#00080169 r#00096636");
INSERT INTO portuguese_index VALUES ("Insider_trading","n#00080242","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desdenhosamente","NULL","NULL","NULL","r#00080534 r#00282700");
INSERT INTO portuguese_index VALUES ("contratualmente","NULL","NULL","NULL","r#00080768");
INSERT INTO portuguese_index VALUES ("manipular","NULL","v#00055748 v#00824623 v#01230482","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dispensar","NULL","v#00055849","NULL","NULL");
INSERT INTO portuguese_index VALUES ("administrar","NULL","v#00055849 v#01656373","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diáriamente","NULL","NULL","NULL","r#00081486");
INSERT INTO portuguese_index VALUES ("diariamente","NULL","NULL","NULL","r#00081486 r#00177818");
INSERT INTO portuguese_index VALUES ("digitalizar","NULL","v#00081509 v#00563824","NULL","NULL");
INSERT INTO portuguese_index VALUES ("xenófobo","NULL","NULL","a#00081513","NULL");
INSERT INTO portuguese_index VALUES ("gestão_de_compras","n#00049855","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semanalmente","NULL","NULL","NULL","r#00081591");
INSERT INTO portuguese_index VALUES ("sem_medo","NULL","NULL","a#00081671","NULL");
INSERT INTO portuguese_index VALUES ("curar","NULL","v#00056004 v#00056406 v#00184775","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sanar","NULL","v#00056004","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sarar","NULL","v#00056004 v#00184775","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anualmente","NULL","NULL","NULL","r#00081737 r#00250570");
INSERT INTO portuguese_index VALUES ("procura","n#00050044 n#00946650 n#00686428 n#05770391","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marketing","n#00082081 n#01112420 n#01115162","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("socorrer","NULL","v#00056138 v#01737017 v#01739424","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ajudar","NULL","v#00056138 v#00206998 v#00803166 v#02000133 v#01643863 v#01732330 v#01737017 v#01739424 v#01742587 v#01872462","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agressivo","NULL","NULL","a#00085200 a#00107565 a#00085707 a#01193636 a#01301600","NULL");
INSERT INTO portuguese_index VALUES ("aí","NULL","NULL","NULL","r#00082308");
INSERT INTO portuguese_index VALUES ("ali","NULL","NULL","NULL","r#00082308 r#00109151");
INSERT INTO portuguese_index VALUES ("lá","n#05139941","NULL","NULL","r#00082308");
INSERT INTO portuguese_index VALUES ("acolá","NULL","NULL","NULL","r#00082308 r#00109151");
INSERT INTO portuguese_index VALUES ("além","n#15143864","NULL","NULL","r#00082308");
INSERT INTO portuguese_index VALUES ("aceitação","n#00050643 n#00117820 n#04696956 n#10039397 n#10341904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remediar","NULL","v#00056406 v#00613501","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sucessão","n#00050836 n#00651987 n#03938674 n#06248029 n#09755313","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("belicoso","NULL","NULL","a#00085894 a#01518860 a#01680772","NULL");
INSERT INTO portuguese_index VALUES ("assunção","n#00050952","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("competitivo","NULL","NULL","a#00083003 a#00297755","NULL");
INSERT INTO portuguese_index VALUES ("enfaixar","NULL","v#00083124","NULL","NULL");
INSERT INTO portuguese_index VALUES ("única","NULL","NULL","a#02112131","r#00083541");
INSERT INTO portuguese_index VALUES ("umaum","NULL","NULL","NULL","r#00083541");
INSERT INTO portuguese_index VALUES ("espólio","n#00051119 n#09543577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("herança","n#00051119 n#03850874 n#04921011 n#03852131 n#09534283 n#09543723 n#13263779 n#09698925","v#02315525","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprovisionamento","n#00051225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compras","n#00051225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suprimentos","n#00051225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("operar","NULL","v#00057137 v#00834531 v#01048914 v#01664787","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apropriação","n#00083975 n#00084895 n#00776732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("particularmente","NULL","NULL","NULL","r#00084223");
INSERT INTO portuguese_index VALUES ("medicar","NULL","v#00084230","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adopção","n#00051562 n#00117820","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adoção","n#00051562 n#00117820 n#01185292","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("naturalização","n#00084642","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estupefazer","NULL","v#00057616","NULL","NULL");
INSERT INTO portuguese_index VALUES ("narcotizar","NULL","v#00057616","NULL","NULL");
INSERT INTO portuguese_index VALUES ("truculento","NULL","NULL","a#00084795","NULL");
INSERT INTO portuguese_index VALUES ("batalhador","NULL","NULL","a#00084795","NULL");
INSERT INTO portuguese_index VALUES ("lutador","n#07167829 n#10793168","NULL","a#00084795","NULL");
INSERT INTO portuguese_index VALUES ("alhures","NULL","NULL","NULL","r#00085002 r#00235438");
INSERT INTO portuguese_index VALUES ("em_outro_lugar","NULL","NULL","NULL","r#00085002");
INSERT INTO portuguese_index VALUES ("em_outra_parte","NULL","NULL","NULL","r#00085002");
INSERT INTO portuguese_index VALUES ("Preemptividade","n#00085041","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preempção","n#00085041 n#05178394 n#05178571 n#05957238","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confiscação","n#00051907 n#00088481","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inquieto","NULL","NULL","a#00087965 a#01855798 a#02337269","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_experimental","NULL","NULL","NULL","r#00085339");
INSERT INTO portuguese_index VALUES ("ungir","NULL","v#00085626","NULL","NULL");
INSERT INTO portuguese_index VALUES ("untar","NULL","v#00085626 v#01269379","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emocional","NULL","NULL","a#00085630 a#00853776 a#01927279 a#02747446","NULL");
INSERT INTO portuguese_index VALUES ("excitado","NULL","NULL","a#00085630 a#00919542 a#02056997","NULL");
INSERT INTO portuguese_index VALUES ("Confiscação","n#00085678","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rapidamente","NULL","NULL","NULL","r#00085811");
INSERT INTO portuguese_index VALUES ("rápidamente","NULL","NULL","NULL","r#00085811");
INSERT INTO portuguese_index VALUES ("vapt_vupt","NULL","NULL","NULL","r#00085811");
INSERT INTO portuguese_index VALUES ("transtornado","NULL","NULL","a#00085870","NULL");
INSERT INTO portuguese_index VALUES ("perturbado","NULL","NULL","a#00085870 a#02458262","NULL");
INSERT INTO portuguese_index VALUES ("expropriação","n#00086140","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agitado","NULL","NULL","a#00086210","NULL");
INSERT INTO portuguese_index VALUES ("frenético","NULL","NULL","a#00086210 a#00086341 a#02390724 a#02544892","NULL");
INSERT INTO portuguese_index VALUES ("febril","NULL","NULL","a#00086210 a#02726715","NULL");
INSERT INTO portuguese_index VALUES ("injectar","NULL","v#00058757","NULL","NULL");
INSERT INTO portuguese_index VALUES ("injetar","NULL","v#00058757 v#01195201 v#01199213","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_rápido","NULL","NULL","NULL","r#00086528");
INSERT INTO portuguese_index VALUES ("mais_depressa","NULL","NULL","NULL","r#00086528");
INSERT INTO portuguese_index VALUES ("histérico","NULL","NULL","a#00086606 a#01584287","NULL");
INSERT INTO portuguese_index VALUES ("mais_devagar","NULL","NULL","NULL","r#00086621");
INSERT INTO portuguese_index VALUES ("mais_lento","NULL","NULL","NULL","r#00086621");
INSERT INTO portuguese_index VALUES ("imprima","n#00086654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("requisação","n#00086654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("o_mais_veloz","NULL","NULL","NULL","r#00086685");
INSERT INTO portuguese_index VALUES ("o_mais_rápido","NULL","NULL","NULL","r#00086685");
INSERT INTO portuguese_index VALUES ("psicadélico","NULL","NULL","a#00089566 a#00376227 a#01777822","NULL");
INSERT INTO portuguese_index VALUES ("vacinar","NULL","v#00086835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("categoricamente","NULL","NULL","NULL","r#00087188");
INSERT INTO portuguese_index VALUES ("rotundamente","NULL","NULL","NULL","r#00087188 r#00181901 r#00228815");
INSERT INTO portuguese_index VALUES ("Sequestro_de_bens","n#00087218","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sequestro","n#00087218 n#00775702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Seqüestro_de_bens","n#00087218","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adoentar","NULL","v#00087454","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adoecer","NULL","v#00087454","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contagiar-se","NULL","v#00059435","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_fim","NULL","NULL","NULL","r#00087777");
INSERT INTO portuguese_index VALUES ("ad_infinitum","NULL","NULL","NULL","r#00087777");
INSERT INTO portuguese_index VALUES ("dependência_psicológica","n#00087849","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("permanentemente","NULL","NULL","NULL","r#00087916");
INSERT INTO portuguese_index VALUES ("em_definitivo","NULL","NULL","NULL","r#00087916");
INSERT INTO portuguese_index VALUES ("para_sempre","NULL","NULL","NULL","r#00087916 r#00332596");
INSERT INTO portuguese_index VALUES ("de_uma_vez_por_todas","NULL","NULL","NULL","r#00087916 r#00092985");
INSERT INTO portuguese_index VALUES ("temporariamente","NULL","NULL","NULL","r#00088303 r#00179212");
INSERT INTO portuguese_index VALUES ("envenenar","NULL","v#00088339 v#00151672 v#00532429 v#01323338 v#01323793 v#01210676 v#02580678","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embriagar","NULL","v#00088532","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intoxicar","NULL","v#00088532 v#01323338 v#01236227","NULL","NULL");
INSERT INTO portuguese_index VALUES ("a_vontade","NULL","NULL","NULL","r#00088655");
INSERT INTO portuguese_index VALUES ("de_improviso","NULL","NULL","NULL","r#00088655");
INSERT INTO portuguese_index VALUES ("à_vontade","NULL","NULL","NULL","r#00088655 r#00153372");
INSERT INTO portuguese_index VALUES ("espontaneamente","NULL","NULL","NULL","r#00088655 r#00191889");
INSERT INTO portuguese_index VALUES ("infetar","NULL","v#00060266","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infectar","NULL","v#00060266 v#00060850 v#00605498","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contaminar","NULL","v#00060266 v#00343123 v#00343478 v#01055474","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arresto","n#00054269","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("provisionalmente","NULL","NULL","NULL","r#00088777");
INSERT INTO portuguese_index VALUES ("agradável","NULL","NULL","a#01735813 a#01728957 a#01944086","NULL");
INSERT INTO portuguese_index VALUES ("altamente","NULL","NULL","NULL","r#00089267 r#00089408 r#00089643");
INSERT INTO portuguese_index VALUES ("desinfectar","NULL","v#00089324","NULL","NULL");
INSERT INTO portuguese_index VALUES ("restituição","n#00089351 n#00270275 n#00401459","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("muitíssimo","NULL","NULL","NULL","r#00089408 r#00196540");
INSERT INTO portuguese_index VALUES ("chateante","NULL","NULL","a#00092842","NULL");
INSERT INTO portuguese_index VALUES ("molestante","NULL","NULL","a#00092842","NULL");
INSERT INTO portuguese_index VALUES ("irritativo","NULL","NULL","a#00092842","NULL");
INSERT INTO portuguese_index VALUES ("aborrecedor","NULL","NULL","a#00092842","NULL");
INSERT INTO portuguese_index VALUES ("irritante","NULL","NULL","a#00092842 a#00446347 a#02310185","NULL");
INSERT INTO portuguese_index VALUES ("encomendar","NULL","v#00060850 v#00505537","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contagiar","NULL","v#00060850","NULL","NULL");
INSERT INTO portuguese_index VALUES ("execução_hipotecária","n#00090076","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perigosamente","NULL","NULL","NULL","r#00090228");
INSERT INTO portuguese_index VALUES ("arriscadamente","NULL","NULL","NULL","r#00090228");
INSERT INTO portuguese_index VALUES ("recebimento","n#00055481 n#06630852","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_enérgica","NULL","NULL","NULL","r#00090651");
INSERT INTO portuguese_index VALUES ("energicamente","NULL","NULL","NULL","r#00090651");
INSERT INTO portuguese_index VALUES ("mutilar","NULL","v#00090888 v#00201342","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_má_vontade","NULL","NULL","NULL","r#00091259");
INSERT INTO portuguese_index VALUES ("relutantemente","NULL","NULL","NULL","r#00091259");
INSERT INTO portuguese_index VALUES ("duramente","NULL","NULL","NULL","r#00092047");
INSERT INTO portuguese_index VALUES ("degradar","NULL","v#00062377 v#00207728","NULL","NULL");
INSERT INTO portuguese_index VALUES ("degenerar","NULL","v#00062377","NULL","NULL");
INSERT INTO portuguese_index VALUES ("piorar","NULL","v#00062377 v#00139555 v#00139972 v#00140259 v#00142648 v#00182841","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deteriorar","NULL","v#00062377 v#00208497 v#00176836 v#00179295 v#00332972","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrematação","n#00092366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("leilão","n#00092366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("almoeda","n#00092366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hasta","n#00092366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insone","NULL","NULL","a#00092391 a#00187176","NULL");
INSERT INTO portuguese_index VALUES ("estreitamente","NULL","NULL","NULL","r#00092569 r#00300137");
INSERT INTO portuguese_index VALUES ("resumidamente","NULL","NULL","NULL","r#00092682 r#00289860");
INSERT INTO portuguese_index VALUES ("convalescer","NULL","v#00062604","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recuperar","NULL","v#00062604 v#00369166 v#01538351 v#01539506","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recursivo","NULL","NULL","a#00092848","NULL");
INSERT INTO portuguese_index VALUES ("heurístico","NULL","NULL","a#00092933","NULL");
INSERT INTO portuguese_index VALUES ("conclusivamente","NULL","NULL","NULL","r#00092985");
INSERT INTO portuguese_index VALUES ("de_forma_conclusiva","NULL","NULL","NULL","r#00092985");
INSERT INTO portuguese_index VALUES ("capitalização","n#00093006 n#00951626 n#00952214","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deploravelmente","NULL","NULL","NULL","r#00093270");
INSERT INTO portuguese_index VALUES ("alienável","NULL","NULL","a#00093275","NULL");
INSERT INTO portuguese_index VALUES ("salvamento","n#00058512","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salvação","n#00058512 n#00058978 n#00096513 n#14539165","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enlanguescer","NULL","v#00093593 v#00389992","NULL","NULL");
INSERT INTO portuguese_index VALUES ("focalmente","NULL","NULL","NULL","r#00093731");
INSERT INTO portuguese_index VALUES ("inalienável","NULL","NULL","a#00093810 a#00694483","NULL");
INSERT INTO portuguese_index VALUES ("atrofiar","NULL","v#00093979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("causar_atrofia","NULL","v#00093979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atrofiar-se","NULL","v#00093979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("redenção","n#00058978","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hipertrofiar","NULL","v#00094153","NULL","NULL");
INSERT INTO portuguese_index VALUES ("absolvição","n#00094240 n#00095121","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intransmissível","NULL","NULL","a#00094324","NULL");
INSERT INTO portuguese_index VALUES ("vivo","NULL","NULL","a#00102211 a#00121842 a#00190653 a#00804371 a#00805115 a#01872306 a#02106366","NULL");
INSERT INTO portuguese_index VALUES ("acontecer","NULL","v#00063646 v#00077064 v#00083639 v#00250539 v#00234840 v#00235191 v#00236065 v#00238795 v#00239152 v#00379987 v#00723349 v#01520476 v#01768893 v#01791776","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indulgência","n#00094500 n#01073241 n#04638585 n#04884627","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("viável","NULL","NULL","a#00098270 a#01752028","NULL");
INSERT INTO portuguese_index VALUES ("vital","NULL","NULL","a#00098405 a#00122245","NULL");
INSERT INTO portuguese_index VALUES ("morto","n#04056323","NULL","a#00098580 a#00099137","NULL");
INSERT INTO portuguese_index VALUES ("semvida","NULL","NULL","a#00098580","NULL");
INSERT INTO portuguese_index VALUES ("para_baixo","NULL","NULL","NULL","r#00095320");
INSERT INTO portuguese_index VALUES ("juso","NULL","NULL","NULL","r#00095320");
INSERT INTO portuguese_index VALUES ("de_forma_descendente","NULL","NULL","NULL","r#00095320");
INSERT INTO portuguese_index VALUES ("abaixo","NULL","NULL","a#02491961","r#00095320 r#00486067 r#00487408");
INSERT INTO portuguese_index VALUES ("emancipação","n#00060117 n#01247413","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("folhear","NULL","v#00095747 v#01269224","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falecido","n#07203851","NULL","a#00099137","NULL");
INSERT INTO portuguese_index VALUES ("assassinado","NULL","NULL","a#00096072","NULL");
INSERT INTO portuguese_index VALUES ("resgate","n#00060540 n#00061001 n#09560583","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_ascendente","NULL","NULL","NULL","r#00096333");
INSERT INTO portuguese_index VALUES ("para_cima","NULL","NULL","NULL","r#00096636 r#00490410 r#00490498");
INSERT INTO portuguese_index VALUES ("aumentar","NULL","v#00065214 v#00104604 v#00105400 v#00105798 v#00154966 v#01421708 v#00106728 v#00107371 v#00108242 v#00108348 v#00108725 v#00108988 v#00227165 v#00158081 v#00164255 v#00263904 v#00180494 v#00290302 v#00214843 v#00219109 v#00301091 v#00301246 v#00434077 v#00346551 v#00540946 v#00388763 v#00574735 v#00569024 v#01345133 v#01351334 v#01421865","NULL","r#00097011");
INSERT INTO portuguese_index VALUES ("reconquista","n#00061101","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elevar","NULL","v#00108988 v#00380903 v#00641929 v#01343923","NULL","r#00097011");
INSERT INTO portuguese_index VALUES ("supurar","NULL","v#00097179","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invocação","n#00097244","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desempenho","n#00061811","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("francamente","NULL","NULL","NULL","r#00097522 r#00097620 r#00314835");
INSERT INTO portuguese_index VALUES ("regenerar","NULL","v#00097621 v#00097941 v#00114858 v#00167824 v#00168393 v#00168588 v#00385189","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_vida","NULL","NULL","a#00097768 a#00100373 a#00122649 a#01087557","NULL");
INSERT INTO portuguese_index VALUES ("inviável","NULL","NULL","a#00098043 a#01836350","NULL");
INSERT INTO portuguese_index VALUES ("em_casa","NULL","NULL","NULL","r#00098166 r#00098267");
INSERT INTO portuguese_index VALUES ("natimorto","NULL","NULL","a#00098307","NULL");
INSERT INTO portuguese_index VALUES ("iniciar","NULL","v#00098346 v#00239960 v#00242403 v#00964911 v#01133757 v#01778989","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inicializar","NULL","v#00098346 v#00700896","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mecanica","n#00062253","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mecanismo","n#00062253 n#02560468 n#02979815 n#06757099 n#09682313","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pedra-inoperante","NULL","NULL","a#00098450","NULL");
INSERT INTO portuguese_index VALUES ("ressuscitar","NULL","v#00066831 v#00098770","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serviço","n#00062420 n#00371920 n#00379388 n#00381958 n#00384296 n#00461778 n#00666638 n#01032368 n#00784280 n#02661119 n#03303697 n#06084772 n#09593730","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artesiano","NULL","NULL","a#00098933","NULL");
INSERT INTO portuguese_index VALUES ("bis","n#00099439","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Improvisação","n#00099588","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exercitar","NULL","v#00067743 v#01180029","NULL","NULL");
INSERT INTO portuguese_index VALUES ("malhar","NULL","v#00067743 v#00068375 v#00820086","NULL","NULL");
INSERT INTO portuguese_index VALUES ("malabarismo","n#00099799 n#00338994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ilusão","n#00063210 n#00486766 n#04531761 n#04561043","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("truque","n#00063210 n#00111216 n#00172598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("magia","n#00063210 n#04578926","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("treinar","NULL","v#00067976 v#00068375 v#00602805 v#00407541 v#00565367 v#01804414","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interpretação","n#00063574 n#00358063 n#00359430 n#04447241 n#04551850 n#04787112 n#05157992 n#05361340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exercitar-se","NULL","v#00068375 v#01180029","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alfabético","NULL","NULL","a#00100634 a#02614194","NULL");
INSERT INTO portuguese_index VALUES ("alfabeto","n#04876596","NULL","a#00100634 a#02614194","NULL");
INSERT INTO portuguese_index VALUES ("longe","NULL","NULL","a#00410709 a#00450915","r#00100883");
INSERT INTO portuguese_index VALUES ("de_longe","NULL","NULL","NULL","r#00100883 r#00440745 r#00440845");
INSERT INTO portuguese_index VALUES ("altruísta","n#10421956","NULL","a#00101609","NULL");
INSERT INTO portuguese_index VALUES ("humanitário","NULL","NULL","a#00101609 a#01210344 a#01211005 a#02755563","NULL");
INSERT INTO portuguese_index VALUES ("peidar","NULL","v#00101629","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fungar","NULL","v#00101779","NULL","NULL");
INSERT INTO portuguese_index VALUES ("egocêntrico","NULL","NULL","a#00101800","NULL");
INSERT INTO portuguese_index VALUES ("Transposição","n#00102162","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impreciso","NULL","NULL","a#00105604 a#01767638","NULL");
INSERT INTO portuguese_index VALUES ("ambíguo","NULL","NULL","a#00105604 a#00851170","NULL");
INSERT INTO portuguese_index VALUES ("vago","NULL","NULL","a#00105604 a#00400770 a#01036561","NULL");
INSERT INTO portuguese_index VALUES ("dúbio","NULL","NULL","a#00105604 a#00851170","NULL");
INSERT INTO portuguese_index VALUES ("indefinido","NULL","NULL","a#00105604 a#00328009","NULL");
INSERT INTO portuguese_index VALUES ("jam","n#00102374","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("automatização","n#00064182","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("automação","n#00064182","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Automaçao","n#00064182","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("danificar","NULL","v#00069684 v#00176836 v#00259755","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_primeiro_lugar","NULL","NULL","NULL","r#00102736");
INSERT INTO portuguese_index VALUES ("antes_de_tudo","NULL","NULL","NULL","r#00102736");
INSERT INTO portuguese_index VALUES ("ao_princípio","NULL","NULL","NULL","r#00102736");
INSERT INTO portuguese_index VALUES ("primeiro","n#09770029","NULL","a#00958735 a#00960836","r#00102736");
INSERT INTO portuguese_index VALUES ("salivar","NULL","v#00102791","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enigmático","NULL","NULL","a#00102930 a#00499987 a#00855484","NULL");
INSERT INTO portuguese_index VALUES ("babar","NULL","v#00102974 v#01827425","NULL","NULL");
INSERT INTO portuguese_index VALUES ("durante","NULL","NULL","NULL","r#00103087");
INSERT INTO portuguese_index VALUES ("lancha","n#00064905","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lançamento","n#00064905 n#00066170 n#00155548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_início","NULL","NULL","NULL","r#00103194");
INSERT INTO portuguese_index VALUES ("primeiramente","NULL","NULL","NULL","r#00103194");
INSERT INTO portuguese_index VALUES ("inicialmente","NULL","NULL","NULL","r#00103194");
INSERT INTO portuguese_index VALUES ("avermelhar","NULL","v#00070161 v#00198875 v#00373451","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corar","NULL","v#00070161 v#00280301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enrubescer","NULL","v#00070161","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ruborizar","NULL","v#00070161","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_muitos_significados","NULL","NULL","a#00103447","NULL");
INSERT INTO portuguese_index VALUES ("pela_primeira_vez","NULL","NULL","NULL","r#00103554");
INSERT INTO portuguese_index VALUES ("empalidecer","NULL","v#00103619","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clarear","NULL","v#00103619 v#00216484 v#00384451 v#02764122 v#01893399","NULL","NULL");
INSERT INTO portuguese_index VALUES ("etc","NULL","NULL","NULL","r#00103664");
INSERT INTO portuguese_index VALUES ("etc.","NULL","NULL","NULL","r#00103664");
INSERT INTO portuguese_index VALUES ("etcetera","NULL","NULL","NULL","r#00103664");
INSERT INTO portuguese_index VALUES ("etcétera","NULL","NULL","NULL","r#00103664");
INSERT INTO portuguese_index VALUES ("não_ambíguo","NULL","NULL","a#00103696","NULL");
INSERT INTO portuguese_index VALUES ("empurrão","n#00065545 n#00112312 n#00182673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forca","n#00065545 n#01164874 n#03412906 n#03044012","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impulso","n#00065545 n#00065905 n#00112312 n#01174251 n#03932233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bronzear","NULL","v#00070485 v#00222387","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_fora","NULL","NULL","NULL","r#00104003");
INSERT INTO portuguese_index VALUES ("além-mar","NULL","NULL","NULL","r#00104003");
INSERT INTO portuguese_index VALUES ("ao","NULL","NULL","NULL","r#00104003");
INSERT INTO portuguese_index VALUES ("estrangeiro","n#08168367 n#07273101 n#07273655 n#07614356 n#10661216","NULL","a#00983540 a#00984080 a#00986373","r#00104003");
INSERT INTO portuguese_index VALUES ("exterior","NULL","NULL","a#00900690","r#00104003");
INSERT INTO portuguese_index VALUES ("no","NULL","NULL","NULL","r#00104003 r#00167575");
INSERT INTO portuguese_index VALUES ("ultramar","NULL","NULL","a#01381473","r#00104003");
INSERT INTO portuguese_index VALUES ("ambicioso","NULL","NULL","a#00107334 a#00711113","NULL");
INSERT INTO portuguese_index VALUES ("firewall","n#00104088 n#03348142","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parede_à_prova_de_fogo","n#00104088","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expor_ao_sol","NULL","v#00104147","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ímpeto","n#00065905","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arranco","n#00065905","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ao_menos","NULL","NULL","NULL","r#00104345");
INSERT INTO portuguese_index VALUES ("no_mínimo","NULL","NULL","NULL","r#00104345");
INSERT INTO portuguese_index VALUES ("pelo_menos","NULL","NULL","NULL","r#00104345");
INSERT INTO portuguese_index VALUES ("rolamento","n#00104409 n#02780315","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("no_máximo","NULL","NULL","NULL","r#00104528 r#00105775");
INSERT INTO portuguese_index VALUES ("arremesso","n#00066170 n#00106272","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compulsivo","NULL","NULL","a#00107954 a#01583659 a#01585022","NULL");
INSERT INTO portuguese_index VALUES ("liberar","NULL","v#00071198 v#01011620 v#01648022 v#01648347 v#02467399 v#01701277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ejetar","NULL","v#00071198 v#01007120","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expulsar","NULL","v#00071198 v#01636409 v#02499312 v#01704959 v#02503803 v#02504280","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Calmamente","NULL","NULL","NULL","r#00104990");
INSERT INTO portuguese_index VALUES ("prontamente","NULL","NULL","NULL","r#00105341 r#00105467 r#00105603 r#00161193");
INSERT INTO portuguese_index VALUES ("sem_demora","NULL","NULL","a#01900630","r#00105467");
INSERT INTO portuguese_index VALUES ("caçoar","NULL","v#00071715 v#00578703 v#00580082","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_fino","n#00105624","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_magro","n#00105624","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("no_seu_melhor","NULL","NULL","NULL","r#00105775");
INSERT INTO portuguese_index VALUES ("lance","n#00066813","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desapegado","NULL","NULL","a#00109022","NULL");
INSERT INTO portuguese_index VALUES ("liberal","n#10257084","NULL","a#00109022 a#00281123 a#00542311 a#00869389 a#01062627 a#01062993 a#01065548 a#01958902","NULL");
INSERT INTO portuguese_index VALUES ("generoso","NULL","NULL","a#00109022 a#01028190 a#01062993 a#01114658","NULL");
INSERT INTO portuguese_index VALUES ("unanimemente","NULL","NULL","NULL","r#00106316");
INSERT INTO portuguese_index VALUES ("unanimimente","NULL","NULL","NULL","r#00106316");
INSERT INTO portuguese_index VALUES ("de_forma_unânime","NULL","NULL","NULL","r#00106316");
INSERT INTO portuguese_index VALUES ("ordinariamente","NULL","NULL","NULL","r#00106921");
INSERT INTO portuguese_index VALUES ("geralmente","NULL","NULL","NULL","r#00106921 r#00155621");
INSERT INTO portuguese_index VALUES ("usualmente","NULL","NULL","NULL","r#00106921");
INSERT INTO portuguese_index VALUES ("habitualmente","NULL","NULL","NULL","r#00106921 r#00211061");
INSERT INTO portuguese_index VALUES ("normalmente","NULL","NULL","NULL","r#00106921");
INSERT INTO portuguese_index VALUES ("popularmente","NULL","NULL","NULL","r#00106921");
INSERT INTO portuguese_index VALUES ("comumente","NULL","NULL","NULL","r#00106921");
INSERT INTO portuguese_index VALUES ("passar_por_cima","NULL","v#00072443","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atropelar","NULL","v#00072443","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exíguo","NULL","NULL","a#00107017","NULL");
INSERT INTO portuguese_index VALUES ("exígua","NULL","NULL","a#00107017","NULL");
INSERT INTO portuguese_index VALUES ("recentemente","NULL","NULL","NULL","r#00107416 r#00112601");
INSERT INTO portuguese_index VALUES ("há_pouco_tempo","NULL","NULL","NULL","r#00107416");
INSERT INTO portuguese_index VALUES ("anabólico","NULL","NULL","a#00107648 a#02619404","NULL");
INSERT INTO portuguese_index VALUES ("impredizivelmente","NULL","NULL","NULL","r#00107722");
INSERT INTO portuguese_index VALUES ("imprevisivelmente","NULL","NULL","NULL","r#00107722");
INSERT INTO portuguese_index VALUES ("fraturar","NULL","v#00107943 v#01621084","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quebrar","NULL","v#00107943 v#00263044 v#00333594 v#00333907 v#00231588 v#00858865 v#01298931","NULL","NULL");
INSERT INTO portuguese_index VALUES ("catabólico","NULL","NULL","a#00107984","NULL");
INSERT INTO portuguese_index VALUES ("pouco_a_pouco","NULL","NULL","NULL","r#00107987 r#00422281");
INSERT INTO portuguese_index VALUES ("gradualmente","NULL","NULL","NULL","r#00107987");
INSERT INTO portuguese_index VALUES ("aqui","n#08489497","NULL","NULL","r#00108647");
INSERT INTO portuguese_index VALUES ("sinclinal","NULL","NULL","a#00109133","NULL");
INSERT INTO portuguese_index VALUES ("eis_aqui","NULL","NULL","NULL","r#00109151");
INSERT INTO portuguese_index VALUES ("eis_ali","NULL","NULL","NULL","r#00109151");
INSERT INTO portuguese_index VALUES ("eis","NULL","NULL","NULL","r#00109151");
INSERT INTO portuguese_index VALUES ("eis_aí","NULL","NULL","NULL","r#00109151");
INSERT INTO portuguese_index VALUES ("diádromo","NULL","NULL","a#00109504","NULL");
INSERT INTO portuguese_index VALUES ("historicamente","NULL","NULL","NULL","r#00109569 r#00109687");
INSERT INTO portuguese_index VALUES ("alterar","NULL","v#00074063 v#00082064 v#00083947 v#01144692","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pacificamente","NULL","NULL","NULL","r#00109817 r#00186756");
INSERT INTO portuguese_index VALUES ("calmamente","NULL","NULL","NULL","r#00109817");
INSERT INTO portuguese_index VALUES ("tranquilamente","NULL","NULL","NULL","r#00109817 r#00186756");
INSERT INTO portuguese_index VALUES ("cientificamente","NULL","NULL","NULL","r#00109949");
INSERT INTO portuguese_index VALUES ("relativo_ao_ânus","NULL","NULL","a#00113640","NULL");
INSERT INTO portuguese_index VALUES ("anal","NULL","NULL","a#00113640 a#02620436","NULL");
INSERT INTO portuguese_index VALUES ("humildemente","NULL","NULL","NULL","r#00110286 r#00397466");
INSERT INTO portuguese_index VALUES ("analógico","NULL","NULL","a#00110497 a#01419462","NULL");
INSERT INTO portuguese_index VALUES ("a_céu_aberto","NULL","NULL","NULL","r#00110659");
INSERT INTO portuguese_index VALUES ("ao_ar_livre","NULL","NULL","NULL","r#00110659");
INSERT INTO portuguese_index VALUES ("digital","n#12882779","NULL","a#00110701 a#02713096 a#02713232","NULL");
INSERT INTO portuguese_index VALUES ("enterrada","n#00110745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("no_interior","NULL","NULL","NULL","r#00110815");
INSERT INTO portuguese_index VALUES ("em","NULL","NULL","NULL","r#00110815");
INSERT INTO portuguese_index VALUES ("dentro","NULL","NULL","NULL","r#00110815");
INSERT INTO portuguese_index VALUES ("adentro","NULL","NULL","NULL","r#00110815");
INSERT INTO portuguese_index VALUES ("analítico","NULL","NULL","a#00110853 a#00111415 a#00112231 a#02620550","NULL");
INSERT INTO portuguese_index VALUES ("sintético","NULL","NULL","a#00114728 a#00115396 a#00116264 a#01069737 a#01517060 a#01518147","NULL");
INSERT INTO portuguese_index VALUES ("literalmente","NULL","NULL","NULL","r#00111269 r#00257864 r#00340133");
INSERT INTO portuguese_index VALUES ("polisintético","NULL","NULL","a#00112018","NULL");
INSERT INTO portuguese_index VALUES ("silenciosamente","NULL","NULL","NULL","r#00112090");
INSERT INTO portuguese_index VALUES ("internacionalmente","NULL","NULL","NULL","r#00112279");
INSERT INTO portuguese_index VALUES ("forçosamente","NULL","NULL","NULL","r#00112393 r#00342351 r#00342624");
INSERT INTO portuguese_index VALUES ("necessariamente","NULL","NULL","NULL","r#00112393 r#00408375");
INSERT INTO portuguese_index VALUES ("inevitavelmente","NULL","NULL","NULL","r#00112393 r#00208557 r#00218369");
INSERT INTO portuguese_index VALUES ("clique","n#00112828 n#07118210","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clicar","n#00112828","v#02185664","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cutucão","n#00112997","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diferentemente","NULL","NULL","NULL","r#00113082");
INSERT INTO portuguese_index VALUES ("de_forma_diferente","NULL","NULL","NULL","r#00113082");
INSERT INTO portuguese_index VALUES ("excepcionalmente","NULL","NULL","NULL","r#00113082 r#00178793");
INSERT INTO portuguese_index VALUES ("imprensa","n#00072419 n#03170199 n#03170463 n#04736003","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pressão","n#00072419 n#00356790 n#04044869 n#04422106 n#11429458 n#07825463 n#10368592","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("raivosa","NULL","NULL","a#00113818","NULL");
INSERT INTO portuguese_index VALUES ("irado","NULL","NULL","a#00113818 a#00115193","NULL");
INSERT INTO portuguese_index VALUES ("irritado","NULL","NULL","a#00113818","NULL");
INSERT INTO portuguese_index VALUES ("bravo","NULL","NULL","a#00113818 a#00246332 a#00258473 a#02391401","NULL");
INSERT INTO portuguese_index VALUES ("zangado","NULL","NULL","a#00113818 a#00115193","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_oficial","NULL","NULL","NULL","r#00114310");
INSERT INTO portuguese_index VALUES ("oficialmente","NULL","NULL","NULL","r#00114310 r#00186491");
INSERT INTO portuguese_index VALUES ("puxão","n#00073144","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tração","n#00073144","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("raivoso","NULL","NULL","a#00117872 a#00299475 a#02786473","NULL");
INSERT INTO portuguese_index VALUES ("furibundo","NULL","NULL","a#00117872","NULL");
INSERT INTO portuguese_index VALUES ("furioso","NULL","NULL","a#00117872 a#00299475","NULL");
INSERT INTO portuguese_index VALUES ("feroz","NULL","NULL","a#00117872 a#00299475 a#01212393 a#01445872 a#01449500 a#02276991 a#02391401","NULL");
INSERT INTO portuguese_index VALUES ("centralmente","NULL","NULL","NULL","r#00114750");
INSERT INTO portuguese_index VALUES ("tornar-se","NULL","v#00077064 v#00083639 v#00250539 v#01791776","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colérico","NULL","NULL","a#00114921 a#01135914 a#01726613","NULL");
INSERT INTO portuguese_index VALUES ("transmudar","NULL","v#00077276","NULL","NULL");
INSERT INTO portuguese_index VALUES ("converter","n#00199130","v#00077276 v#00111031 v#00268049","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transformar","NULL","v#00077276 v#00266041 v#00266431 v#00266920 v#00380419 v#00390255 v#01791776","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modificar","NULL","v#00077276 v#00082064 v#00083947 v#00117331 v#00266431 v#00266920 v#00389126 v#01144692","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fisicamente","NULL","NULL","NULL","r#00115254");
INSERT INTO portuguese_index VALUES ("reboque","n#00115292","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebocador","n#00115292 n#04495843","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indignado","NULL","NULL","a#00115494","NULL");
INSERT INTO portuguese_index VALUES ("de_preferência","NULL","NULL","NULL","r#00115554");
INSERT INTO portuguese_index VALUES ("preferivelmente","NULL","NULL","NULL","r#00115554");
INSERT INTO portuguese_index VALUES ("preferencialmente","NULL","NULL","NULL","r#00115554");
INSERT INTO portuguese_index VALUES ("politicamente","NULL","NULL","NULL","r#00115745 r#00115859");
INSERT INTO portuguese_index VALUES ("extirpação","n#00115803 n#00393369","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lívido","NULL","NULL","a#00115906 a#00267889","NULL");
INSERT INTO portuguese_index VALUES ("simbolicamente","NULL","NULL","NULL","r#00116280 r#00126733");
INSERT INTO portuguese_index VALUES ("alcar","n#00074216","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elevação","n#00074216 n#00209440 n#06692424","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("levantamento","n#00074216 n#00618461","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ejeção","n#00074431","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expulsão","n#00074431 n#00135765 n#00230520 n#09715904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acrimonioso","NULL","NULL","a#00116744 a#01320002","NULL");
INSERT INTO portuguese_index VALUES ("rancoroso","NULL","NULL","a#00116940","NULL");
INSERT INTO portuguese_index VALUES ("defenestração","n#00116989","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("junto_com","NULL","NULL","NULL","r#00117082");
INSERT INTO portuguese_index VALUES ("bem_como","NULL","NULL","NULL","r#00117082");
INSERT INTO portuguese_index VALUES ("coletivamente","NULL","NULL","NULL","r#00117082");
INSERT INTO portuguese_index VALUES ("em_companhia_de","NULL","NULL","NULL","r#00117082");
INSERT INTO portuguese_index VALUES ("juntamente","NULL","NULL","NULL","r#00117082 r#00197710");
INSERT INTO portuguese_index VALUES ("reconverter","NULL","v#00117498","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arroto","n#00117578","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("então","NULL","NULL","NULL","r#00117903");
INSERT INTO portuguese_index VALUES ("piscamento","n#00117959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ficar","NULL","v#00078446 v#00101662 v#01268426 v#01371015 v#02229828 v#01800547 v#01801598 v#01865371 v#01868387 v#02731242 v#02744820","NULL","NULL");
INSERT INTO portuguese_index VALUES ("permanecer","NULL","v#00078446 v#01064160 v#01268426 v#01801598 v#01865371 v#01868387 v#02731242","NULL","NULL");
INSERT INTO portuguese_index VALUES ("continuar","NULL","v#00078446 v#00118523 v#00243167 v#00530824 v#00781491 v#01360914 v#01618013 v#01828422 v#01831586 v#01832078 v#02747709 v#02747922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manter","NULL","v#00078446 v#00607000 v#00732552 v#00687441 v#00687837 v#01151753 v#00805632 v#01508080 v#01522764 v#01828422","NULL","NULL");
INSERT INTO portuguese_index VALUES ("volumetricamente","NULL","NULL","NULL","r#00118253");
INSERT INTO portuguese_index VALUES ("desconsiderando","NULL","NULL","NULL","r#00118531");
INSERT INTO portuguese_index VALUES ("independente","NULL","NULL","a#00691708 a#00696017 a#01009075 a#02401440","r#00118531");
INSERT INTO portuguese_index VALUES ("Cuspir","n#00118552","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Emese","n#00118733","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("êmese","n#00118733","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vômito","n#00118733 n#14855992","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("uma","NULL","NULL","NULL","r#00118869");
INSERT INTO portuguese_index VALUES ("antigamente","NULL","NULL","NULL","r#00118965");
INSERT INTO portuguese_index VALUES ("conquanto","NULL","NULL","NULL","r#00119139");
INSERT INTO portuguese_index VALUES ("embora","NULL","NULL","NULL","r#00119139 r#00232936");
INSERT INTO portuguese_index VALUES ("ainda_que","NULL","NULL","NULL","r#00119139");
INSERT INTO portuguese_index VALUES ("posto_que","NULL","NULL","NULL","r#00119139");
INSERT INTO portuguese_index VALUES ("Hiperêmese_gravídica","n#00119402","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hiperemese_gravídica","n#00119402","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salto","n#00076072 n#00076442 n#00076563 n#00076714 n#02813812 n#03969685 n#05481281","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pulo","n#00076072 n#00076442 n#00076563 n#05481281","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_outro_lado","NULL","NULL","NULL","r#00119578");
INSERT INTO portuguese_index VALUES ("por_um_lado","NULL","NULL","NULL","r#00119798");
INSERT INTO portuguese_index VALUES ("com_sucesso","NULL","NULL","NULL","r#00119940");
INSERT INTO portuguese_index VALUES ("com","NULL","v#00301544","NULL","r#00119940 r#00250056");
INSERT INTO portuguese_index VALUES ("lúpulo","n#00076442 n#12397864 n#12398174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concomitantemente","NULL","NULL","NULL","r#00120095");
INSERT INTO portuguese_index VALUES ("de_forma_concomitante","NULL","NULL","NULL","r#00120095");
INSERT INTO portuguese_index VALUES ("de_forma_simultânea","NULL","NULL","NULL","r#00120095");
INSERT INTO portuguese_index VALUES ("simultaneamente","NULL","NULL","NULL","r#00120095 r#00120223");
INSERT INTO portuguese_index VALUES ("concorrentemente","NULL","NULL","NULL","r#00120223");
INSERT INTO portuguese_index VALUES ("deixar","NULL","v#00079910 v#01609431 v#00771490 v#00545347 v#01860795 v#01579009 v#01649126 v#01829006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sistematicamente","NULL","NULL","NULL","r#00120474");
INSERT INTO portuguese_index VALUES ("consistentemente","NULL","NULL","NULL","r#00120474");
INSERT INTO portuguese_index VALUES ("anónimo","NULL","NULL","a#00123651 a#00123835 a#00234227","NULL");
INSERT INTO portuguese_index VALUES ("anônimo","NULL","NULL","a#00123651 a#00123835 a#00234227","NULL");
INSERT INTO portuguese_index VALUES ("incógnito","NULL","NULL","a#00123835 a#02089724","NULL");
INSERT INTO portuguese_index VALUES ("tornar","NULL","v#00080395 v#00146138 v#00101662","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deste_modo","NULL","NULL","NULL","r#00121002");
INSERT INTO portuguese_index VALUES ("binominal","NULL","NULL","a#00121183","NULL");
INSERT INTO portuguese_index VALUES ("binária","NULL","NULL","a#00121183","NULL");
INSERT INTO portuguese_index VALUES ("binomial","NULL","NULL","a#00121183","NULL");
INSERT INTO portuguese_index VALUES ("alternar","NULL","v#00080777","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antecedente","n#04953355","NULL","a#00124764","NULL");
INSERT INTO portuguese_index VALUES ("fotograficamente","NULL","NULL","NULL","r#00121894");
INSERT INTO portuguese_index VALUES ("constitucionalmente","NULL","NULL","NULL","r#00122124");
INSERT INTO portuguese_index VALUES ("anterior","NULL","NULL","a#00125081 a#00814611 a#01666340","NULL");
INSERT INTO portuguese_index VALUES ("prévio","NULL","NULL","a#00125081 a#00129370 a#01666340","NULL");
INSERT INTO portuguese_index VALUES ("anticonstitucionalmente","NULL","NULL","NULL","r#00122273");
INSERT INTO portuguese_index VALUES ("preexistente","NULL","NULL","a#00125249","NULL");
INSERT INTO portuguese_index VALUES ("democraticamente","NULL","NULL","NULL","r#00122427");
INSERT INTO portuguese_index VALUES ("subsequente","NULL","NULL","a#00125346 a#00130048","NULL");
INSERT INTO portuguese_index VALUES ("subseqüente","NULL","NULL","a#00125346","NULL");
INSERT INTO portuguese_index VALUES ("ulterior","NULL","NULL","a#00125346 a#00125852 a#00420174 a#01645393","NULL");
INSERT INTO portuguese_index VALUES ("posterior","NULL","NULL","a#00125346 a#00125852 a#00134163 a#00134388 a#00197253 a#00197568","NULL");
INSERT INTO portuguese_index VALUES ("pontaria","n#00077986","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tiro","n#00077986 n#00635718","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("à_parte","NULL","NULL","NULL","r#00122816 r#00180756 r#00207668");
INSERT INTO portuguese_index VALUES ("resultante","NULL","NULL","a#01902400","NULL");
INSERT INTO portuguese_index VALUES ("conseqüente","NULL","NULL","a#01902400 a#00433594","NULL");
INSERT INTO portuguese_index VALUES ("decorrente","NULL","NULL","a#01902400","NULL");
INSERT INTO portuguese_index VALUES ("concomitante","NULL","NULL","a#01902400","NULL");
INSERT INTO portuguese_index VALUES ("anexado","NULL","NULL","a#01902400","NULL");
INSERT INTO portuguese_index VALUES ("digitalmente","NULL","NULL","NULL","r#00123000 r#00123112");
INSERT INTO portuguese_index VALUES ("variar","NULL","v#00082064 v#00304906 v#00982514 v#01816363 v#01816538","NULL","NULL");
INSERT INTO portuguese_index VALUES ("economicamente","NULL","NULL","NULL","r#00123229 r#00123365 r#00123500");
INSERT INTO portuguese_index VALUES ("eletronicamente","NULL","NULL","NULL","r#00123582");
INSERT INTO portuguese_index VALUES ("de_forma_étnica","NULL","NULL","NULL","r#00123695");
INSERT INTO portuguese_index VALUES ("etnicamente","NULL","NULL","NULL","r#00123695");
INSERT INTO portuguese_index VALUES ("tiro_de_arma_de_fogo","n#00078903","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("geneticamente","NULL","NULL","NULL","r#00123924");
INSERT INTO portuguese_index VALUES ("graficamente","NULL","NULL","NULL","r#00124038 r#00132797 r#00310847");
INSERT INTO portuguese_index VALUES ("aquática","NULL","NULL","a#00124077","NULL");
INSERT INTO portuguese_index VALUES ("aquático","NULL","NULL","a#00124077 a#02636582","NULL");
INSERT INTO portuguese_index VALUES ("otimizar","NULL","v#00124226 v#00172505","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marinho","NULL","NULL","a#00126777 a#02670038 a#02671223","NULL");
INSERT INTO portuguese_index VALUES ("mover","NULL","v#00124442 v#01249365 v#01374681","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subaquático","NULL","NULL","a#00124493 a#00124685 a#02472252","NULL");
INSERT INTO portuguese_index VALUES ("pela_lei","NULL","NULL","NULL","r#00124611");
INSERT INTO portuguese_index VALUES ("legalmente","NULL","NULL","NULL","r#00124611 r#00251820");
INSERT INTO portuguese_index VALUES ("tiroteio","n#00124617","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manualmente","NULL","NULL","NULL","r#00124702");
INSERT INTO portuguese_index VALUES ("terrestre","n#10699262","NULL","a#00127354 a#01131511 a#02454611 a#02594240 a#02810102","NULL");
INSERT INTO portuguese_index VALUES ("anfíbio","n#01627424 n#02704792","NULL","a#00125319 a#02831979","NULL");
INSERT INTO portuguese_index VALUES ("baterdeleve","n#00125436","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("realisticamente","NULL","NULL","NULL","r#00125481 r#00215517");
INSERT INTO portuguese_index VALUES ("em_flagrante","NULL","NULL","NULL","r#00125602");
INSERT INTO portuguese_index VALUES ("com_a_boca_na_butija","NULL","NULL","NULL","r#00125602");
INSERT INTO portuguese_index VALUES ("revolucionar","NULL","v#00125633 v#00605310 v#02402695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acima_mencionado","NULL","NULL","a#00128303","NULL");
INSERT INTO portuguese_index VALUES ("precedente","NULL","NULL","a#00128422","NULL");
INSERT INTO portuguese_index VALUES ("introdutório","NULL","NULL","a#00128526 a#01009709","NULL");
INSERT INTO portuguese_index VALUES ("socialmente","NULL","NULL","NULL","r#00126527 r#00126638");
INSERT INTO portuguese_index VALUES ("preparatório","NULL","NULL","a#00126830","NULL");
INSERT INTO portuguese_index VALUES ("técnicamente","NULL","NULL","NULL","r#00126837 r#00126972");
INSERT INTO portuguese_index VALUES ("na_realidade","NULL","NULL","NULL","r#00126837");
INSERT INTO portuguese_index VALUES ("tecnicamente","NULL","NULL","NULL","r#00126837 r#00126972 r#00127130");
INSERT INTO portuguese_index VALUES ("andar_até_a_primeira_base","n#00127286","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("andada","n#00127286 n#00184167 n#13894154 n#10111948","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("temporalmente","NULL","NULL","NULL","r#00127339");
INSERT INTO portuguese_index VALUES ("consecutivo","NULL","NULL","a#00129930 a#00563963","NULL");
INSERT INTO portuguese_index VALUES ("bola_válida","n#00127866","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("terapeuticamente","NULL","NULL","NULL","r#00127866");
INSERT INTO portuguese_index VALUES ("bola_de_falta","n#00082548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tipicamente","NULL","NULL","NULL","r#00128168");
INSERT INTO portuguese_index VALUES ("verbalmente","NULL","NULL","NULL","r#00128456 r#00128554");
INSERT INTO portuguese_index VALUES ("sem_precedentes","NULL","NULL","a#00128572 a#01377933","NULL");
INSERT INTO portuguese_index VALUES ("globalmente","NULL","NULL","NULL","r#00128882");
INSERT INTO portuguese_index VALUES ("eletricamente","NULL","NULL","NULL","r#00128989");
INSERT INTO portuguese_index VALUES ("quimicamente","NULL","NULL","NULL","r#00129089 r#00129228");
INSERT INTO portuguese_index VALUES ("pré-natal","NULL","NULL","a#00129103 a#01733661","NULL");
INSERT INTO portuguese_index VALUES ("perinatal","NULL","NULL","a#00129276","NULL");
INSERT INTO portuguese_index VALUES ("longitudinalmente","NULL","NULL","NULL","r#00129675");
INSERT INTO portuguese_index VALUES ("de_forma_mágica","NULL","NULL","NULL","r#00129788");
INSERT INTO portuguese_index VALUES ("putout","n#00130093","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Strike_out","n#00130347","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("strikeout","n#00130347","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profissionalmente","NULL","NULL","NULL","r#00130432");
INSERT INTO portuguese_index VALUES ("demanhã","NULL","NULL","a#00130518","NULL");
INSERT INTO portuguese_index VALUES ("espacialmente","NULL","NULL","NULL","r#00130549");
INSERT INTO portuguese_index VALUES ("escolha_do_defensor","n#00130673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fly_de_sacrifício","n#00130987","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frontal","n#05541231","NULL","a#00131018 a#00131176 a#00198757","NULL");
INSERT INTO portuguese_index VALUES ("sociolinguisticamente","NULL","NULL","NULL","r#00131018");
INSERT INTO portuguese_index VALUES ("pré-frontal","NULL","NULL","a#00131297","NULL");
INSERT INTO portuguese_index VALUES ("rabo","n#01665222 n#02463611 n#02359063 n#04316646 n#03465129 n#05306476 n#05514410 n#04289965 n#04306560 n#08625846 n#08629508 n#10967384","NULL","a#00134163 a#00197253","NULL");
INSERT INTO portuguese_index VALUES ("traseiro","n#01665222 n#02463611 n#02359063 n#02359166 n#04162599 n#04316646 n#03465129 n#05306476 n#05514410 n#04306560 n#04306912 n#04515461 n#08511970 n#06314878 n#08625846 n#08629508 n#10967384","NULL","a#00134163 a#00197253 a#00197568","NULL");
INSERT INTO portuguese_index VALUES ("pessoalmente","NULL","NULL","NULL","r#00132060 r#00132158 r#00132322 r#00366266 r#00366393");
INSERT INTO portuguese_index VALUES ("crista","n#00869601 n#01792255 n#06301604 n#11825211","NULL","a#00132127","NULL");
INSERT INTO portuguese_index VALUES ("na_pessoa","NULL","NULL","NULL","r#00132158");
INSERT INTO portuguese_index VALUES ("home_run","n#00132355","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Homerun","n#00132355","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ventral","NULL","NULL","a#00132385 a#02934594","NULL");
INSERT INTO portuguese_index VALUES ("Rebatida_simples","n#00132601","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patologicamente","NULL","NULL","NULL","r#00132673");
INSERT INTO portuguese_index VALUES ("de_forma_patológica","NULL","NULL","NULL","r#00132673");
INSERT INTO portuguese_index VALUES ("Rebatida_dupla","n#00132756","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rebatida_tripla","n#00086151","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triplo","n#00086151 n#04510642","NULL","a#02115749 a#02116036","NULL");
INSERT INTO portuguese_index VALUES ("inapelável","NULL","NULL","a#00133065","NULL");
INSERT INTO portuguese_index VALUES ("visualmente","NULL","NULL","NULL","r#00133140");
INSERT INTO portuguese_index VALUES ("golpe","n#00086415 n#00224275 n#00754280","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apetitoso","NULL","NULL","a#00133417 a#02282891","NULL");
INSERT INTO portuguese_index VALUES ("biologicamente","NULL","NULL","NULL","r#00133613");
INSERT INTO portuguese_index VALUES ("bofetada","n#00086637 n#00087184 n#07410745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bioquimicamente","NULL","NULL","NULL","r#00133987");
INSERT INTO portuguese_index VALUES ("acessível","NULL","NULL","a#00134060 a#00134251 a#00533221","NULL");
INSERT INTO portuguese_index VALUES ("nocaute","n#00134099","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("moralmente","NULL","NULL","NULL","r#00134203 r#00364477");
INSERT INTO portuguese_index VALUES ("perfurador","n#00134780","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ponche","n#00134780","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("darbofetadas","n#00134780","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("murro","n#00134780","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("soco","n#00134780 n#07336999","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_acústica","NULL","NULL","NULL","r#00134843");
INSERT INTO portuguese_index VALUES ("acusticamente","NULL","NULL","NULL","r#00134843");
INSERT INTO portuguese_index VALUES ("alegoricamente","NULL","NULL","NULL","r#00135198");
INSERT INTO portuguese_index VALUES ("localmente","NULL","NULL","NULL","r#00135314 r#00135418");
INSERT INTO portuguese_index VALUES ("atempado","NULL","NULL","a#00137926","NULL");
INSERT INTO portuguese_index VALUES ("regionalmente","NULL","NULL","NULL","r#00135567");
INSERT INTO portuguese_index VALUES ("nacionalmente","NULL","NULL","NULL","r#00135667");
INSERT INTO portuguese_index VALUES ("inapropriado","NULL","NULL","a#00135718 a#00529913 a#01017738 a#01129823","NULL");
INSERT INTO portuguese_index VALUES ("chute","n#00136329 n#00788473","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vencido","NULL","NULL","a#00138848","NULL");
INSERT INTO portuguese_index VALUES ("sexualmente","NULL","NULL","NULL","r#00136469 r#00136561");
INSERT INTO portuguese_index VALUES ("lexicamente","NULL","NULL","NULL","r#00136663");
INSERT INTO portuguese_index VALUES ("que_não_foi_pago_na_data_certa","NULL","NULL","a#00139589","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_cirúrgica","NULL","NULL","NULL","r#00137142");
INSERT INTO portuguese_index VALUES ("através_de_cirurgia","NULL","NULL","NULL","r#00137142");
INSERT INTO portuguese_index VALUES ("cirurgicamente","NULL","NULL","NULL","r#00137142");
INSERT INTO portuguese_index VALUES ("cromatograficamente","NULL","NULL","NULL","r#00137459");
INSERT INTO portuguese_index VALUES ("de_forma_cromatográfica","NULL","NULL","NULL","r#00137459");
INSERT INTO portuguese_index VALUES ("alternadamente","NULL","NULL","NULL","r#00137562");
INSERT INTO portuguese_index VALUES ("indevido","NULL","NULL","a#00137641 a#00137943 a#01945350","NULL");
INSERT INTO portuguese_index VALUES ("escanteio","n#00137709","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respectivamente","NULL","NULL","NULL","r#00137915");
INSERT INTO portuguese_index VALUES ("similarmente","NULL","NULL","NULL","r#00138060");
INSERT INTO portuguese_index VALUES ("igualmente","NULL","NULL","NULL","r#00138060 r#00332069");
INSERT INTO portuguese_index VALUES ("repercutir","NULL","v#00092182","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ósculo","n#00090133","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beijo","n#00090133","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("secundariamente","NULL","NULL","NULL","r#00138291");
INSERT INTO portuguese_index VALUES ("procedente","NULL","NULL","a#00140892 a#01906028","NULL");
INSERT INTO portuguese_index VALUES ("pertinente","NULL","NULL","a#00140892 a#01905215 a#01906028","NULL");
INSERT INTO portuguese_index VALUES ("apto","NULL","NULL","a#00140892 a#01077975","NULL");
INSERT INTO portuguese_index VALUES ("apropriado","NULL","NULL","a#00140892 a#00812035 a#01077975 a#01316335 a#01879667","NULL");
INSERT INTO portuguese_index VALUES ("virar_do_avesso","NULL","v#00092585","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inverter","NULL","v#00092585 v#00268521","NULL","NULL");
INSERT INTO portuguese_index VALUES ("virar","NULL","v#00092585 v#01274944 v#01301287 v#01302894 v#01303191 v#02033295 v#01390339 v#01431957 v#01436577 v#01791776","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reverter","NULL","v#00092585 v#00268771","NULL","NULL");
INSERT INTO portuguese_index VALUES ("linguado","n#00138799","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beijo_de_língua","n#00138799","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_dramática","NULL","NULL","NULL","r#00138945");
INSERT INTO portuguese_index VALUES ("dramaticamente","NULL","NULL","NULL","r#00138945 r#00188353 r#00246802");
INSERT INTO portuguese_index VALUES ("agarrão","n#00138956","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pegada","n#00138956 n#04984123","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pegar","n#00138956","v#00379587 v#00589904 v#00825349 v#00826212 v#00826635 v#00827658 v#00982468 v#01442761 v#01576416 v#02486534 v#02761134","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_terra","NULL","NULL","NULL","r#00139173");
INSERT INTO portuguese_index VALUES ("de_forma_notável","NULL","NULL","NULL","r#00139266");
INSERT INTO portuguese_index VALUES ("memorávelmente","NULL","NULL","NULL","r#00139266");
INSERT INTO portuguese_index VALUES ("apropiadamente","NULL","NULL","NULL","r#00139508");
INSERT INTO portuguese_index VALUES ("convenientemente","NULL","NULL","NULL","r#00139508 r#00197395 r#00230444");
INSERT INTO portuguese_index VALUES ("apropriadamente","NULL","NULL","NULL","r#00139508 r#00185172");
INSERT INTO portuguese_index VALUES ("adequadamente","NULL","NULL","NULL","r#00139508 r#00369718");
INSERT INTO portuguese_index VALUES ("interceptação","n#00139758","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recepção","n#00091354 n#04747092 n#04894307 n#06630852 n#06128644","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artificialmente","NULL","NULL","NULL","r#00140566");
INSERT INTO portuguese_index VALUES ("manipulação","n#00091972 n#00102995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manejo","n#00091972","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alterar_para","NULL","v#00094296","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agudamente","NULL","NULL","NULL","r#00140759");
INSERT INTO portuguese_index VALUES ("cronicamente","NULL","NULL","NULL","r#00140884 r#00141033");
INSERT INTO portuguese_index VALUES ("deformar","NULL","v#00140967 v#00476744 v#00477665 v#00924489 v#01584875","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contraditoriamente","NULL","NULL","NULL","r#00141146");
INSERT INTO portuguese_index VALUES ("exame","n#00141176 n#00417674 n#00644702 n#05378329","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("individualizar","NULL","v#00141362","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autópsia","n#00141396","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("necropse","n#00141396","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("necrópsia","n#00141396","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("episodicamente","NULL","NULL","NULL","r#00141405");
INSERT INTO portuguese_index VALUES ("check-in","n#00141669","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Check_in","n#00141669","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("verificação","n#00092615 n#00153961 n#00154233 n#04486906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controle","n#00092615 n#00513665 n#04074963 n#05193781 n#04046475","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limite","n#00092615 n#02621671 n#03992325 n#03992719 n#08501114 n#06279059 n#06279444 n#06314081 n#06336706 n#13871452 n#10018921 n#10019175 n#10019310 n#10019436","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inspeção","n#00092615 n#00564770","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arbóreo","NULL","NULL","a#00144204 a#02638121","NULL");
INSERT INTO portuguese_index VALUES ("arenoso","NULL","NULL","a#00144426 a#01097044","NULL");
INSERT INTO portuguese_index VALUES ("formar","NULL","v#00095506 v#01139594","NULL","NULL");
INSERT INTO portuguese_index VALUES ("argiloso","NULL","NULL","a#00144604 a#02905050","NULL");
INSERT INTO portuguese_index VALUES ("equipado","NULL","NULL","a#00142622 a#01096990 a#01844002","NULL");
INSERT INTO portuguese_index VALUES ("humanamente","NULL","NULL","NULL","r#00142662 r#00359302");
INSERT INTO portuguese_index VALUES ("comparação","n#00093090 n#03729864 n#07108282 n#09980356","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desarmado","NULL","NULL","a#00142917 a#00145995","NULL");
INSERT INTO portuguese_index VALUES ("inerme","NULL","NULL","a#00142917 a#00145995 a#02524032","NULL");
INSERT INTO portuguese_index VALUES ("acompanhamento","n#00093268 n#00455348 n#00530280 n#03377582 n#07031752 n#07580053","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revisão","n#00093268 n#00897811 n#06428976","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("judicialmente","NULL","NULL","NULL","r#00143257 r#00514272");
INSERT INTO portuguese_index VALUES ("moldar","NULL","v#00143338 v#01139594","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indefeso","NULL","NULL","a#00143376 a#01179759 a#01886783 a#02524032","NULL");
INSERT INTO portuguese_index VALUES ("blindado","n#02739889 n#02740061","NULL","a#00143589 a#00146883","NULL");
INSERT INTO portuguese_index VALUES ("cristalizar","NULL","v#00096666 v#00309849 v#00311317","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superficialmente","NULL","NULL","NULL","r#00143722");
INSERT INTO portuguese_index VALUES ("torcer","NULL","v#00143914 v#00874035 v#01275761 v#01391432","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retorcer","NULL","v#00143914 v#01010429","NULL","NULL");
INSERT INTO portuguese_index VALUES ("granular","NULL","v#00144169","NULL","NULL");
INSERT INTO portuguese_index VALUES ("um_pouco","NULL","NULL","NULL","r#00144405");
INSERT INTO portuguese_index VALUES ("um_momento","NULL","NULL","NULL","r#00144405");
INSERT INTO portuguese_index VALUES ("cócegas","n#00144445","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carícia","n#00093956 n#00268334","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("certamente","NULL","NULL","NULL","r#00144722");
INSERT INTO portuguese_index VALUES ("com_certeza","NULL","NULL","NULL","r#00144722");
INSERT INTO portuguese_index VALUES ("seguramente","NULL","NULL","NULL","r#00144722 r#00154213");
INSERT INTO portuguese_index VALUES ("por_certo","NULL","NULL","NULL","r#00144722");
INSERT INTO portuguese_index VALUES ("efectivamente","NULL","NULL","NULL","r#00144722");
INSERT INTO portuguese_index VALUES ("com_efeito","NULL","NULL","NULL","r#00144722 r#00148869");
INSERT INTO portuguese_index VALUES ("na_verdade","NULL","NULL","NULL","r#00144722 r#00148869 r#00149510");
INSERT INTO portuguese_index VALUES ("de_forma_surpreendente","NULL","NULL","NULL","r#00145228");
INSERT INTO portuguese_index VALUES ("assombrosamente","NULL","NULL","NULL","r#00145228 r#00213301");
INSERT INTO portuguese_index VALUES ("surpreendentemente","NULL","NULL","NULL","r#00145228 r#00213301");
INSERT INTO portuguese_index VALUES ("suficientemente","NULL","NULL","NULL","r#00145571");
INSERT INTO portuguese_index VALUES ("emquantidadesuficiente","NULL","NULL","NULL","r#00145571");
INSERT INTO portuguese_index VALUES ("assaz","NULL","NULL","NULL","r#00145571");
INSERT INTO portuguese_index VALUES ("arrendondar","NULL","v#00145623","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acabar","NULL","v#00145623 v#00245305 v#00245987 v#00335506 v#00337013 v#00483753 v#01651565 v#01831830 v#01780161 v#01780295 v#01829006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insuficientemente","NULL","NULL","NULL","r#00145854");
INSERT INTO portuguese_index VALUES ("revoltar-se","NULL","v#00146138 v#02583139","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revoltar","NULL","v#00146138 v#01233868 v#02583139","NULL","NULL");
INSERT INTO portuguese_index VALUES ("armado","NULL","NULL","a#00146210 a#01094647","NULL");
INSERT INTO portuguese_index VALUES ("aproximação","n#00094818 n#00181376 n#03727805 n#05080213","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_todo_o_tempo","NULL","NULL","NULL","r#00146387");
INSERT INTO portuguese_index VALUES ("concatenação","n#00146443 n#14419737","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convergência","n#00095095 n#04512442 n#05518515","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confluência","n#00095452","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("articulação","n#00095657 n#04335626 n#05297733 n#10024799","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("junção","n#00147454 n#00245212 n#02882380 n#10024799","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fixação","n#00095872 n#00276342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_mãos_dadas","NULL","NULL","NULL","r#00147597 r#00245166");
INSERT INTO portuguese_index VALUES ("cair","NULL","v#00100153 v#00342164 v#00273227 v#00301476 v#00301772 v#00683670 v#01300040 v#01342394 v#01342612 v#01345838 v#01978199 v#02038145 v#02229828 v#01883959","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fàcilmente","NULL","NULL","NULL","r#00147876");
INSERT INTO portuguese_index VALUES ("ardiloso","NULL","NULL","a#00149802","NULL");
INSERT INTO portuguese_index VALUES ("Tricky","NULL","NULL","a#00149802","NULL");
INSERT INTO portuguese_index VALUES ("esperto","NULL","NULL","a#00149802 a#00408224","NULL");
INSERT INTO portuguese_index VALUES ("ladino","n#06967282 n#06968052","NULL","a#00149802","NULL");
INSERT INTO portuguese_index VALUES ("laqueadura","n#00148446","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diminuir","NULL","v#00100649 v#00103366 v#00152762 v#00104349 v#00160197 v#00163072 v#00164129 v#00164725 v#00167516 v#00167689 v#00182381 v#00182537 v#00298808 v#00429968 v#00300708 v#00301476 v#00433778 v#00302438 v#00308251 v#00308615 v#01393615","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cair_do_alto","NULL","v#00100649","NULL","NULL");
INSERT INTO portuguese_index VALUES ("como_que","NULL","NULL","NULL","r#00148540");
INSERT INTO portuguese_index VALUES ("como_se","NULL","NULL","NULL","r#00148540");
INSERT INTO portuguese_index VALUES ("apaixonar","NULL","v#00148597","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enamorar-se","NULL","v#00148597","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enamorar","NULL","v#00148597","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apaixonar-se","NULL","v#00148597","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precioso","NULL","NULL","a#00150132 a#00217004 a#02381427 a#02381899 a#02382040 a#02463724","NULL");
INSERT INTO portuguese_index VALUES ("suspender","NULL","v#00100922 v#00246783 v#00253202 v#00254265 v#00254764 v#00379293","NULL","NULL");
INSERT INTO portuguese_index VALUES ("efetivamente","NULL","NULL","NULL","r#00148869 r#00326324");
INSERT INTO portuguese_index VALUES ("ligatura","n#00149084 n#07272084","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("soldagem","n#00149508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("soldadura","n#00149508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estar","NULL","v#00101662 v#01064160 v#01268426 v#01775973 v#01811792 v#01867419 v#02734338 v#02744820","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adequar-se","NULL","v#00150287 v#01841631","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adaptar-se","NULL","v#00150287 v#01841631","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ajustar","NULL","v#00150287 v#00204023 v#00204190 v#00297780 v#00205442 v#00206945 v#00336188","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expressivo","NULL","NULL","a#00152252 a#00464568 a#00684959","NULL");
INSERT INTO portuguese_index VALUES ("eloqüente","NULL","NULL","a#00152252","NULL");
INSERT INTO portuguese_index VALUES ("eloquente","NULL","NULL","a#00152252","NULL");
INSERT INTO portuguese_index VALUES ("generalizado","NULL","NULL","NULL","r#00150925");
INSERT INTO portuguese_index VALUES ("detecção","n#00151087 n#04412425 n#06281175","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proporcionar","NULL","v#00102974 v#00336566 v#02744451","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afinal","NULL","NULL","NULL","r#00151305");
INSERT INTO portuguese_index VALUES ("achado","n#00098543 n#04475449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decrescer","NULL","v#00103366 v#00182381 v#00433778","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desabar","NULL","v#00103366 v#01989053","NULL","NULL");
INSERT INTO portuguese_index VALUES ("minguar","NULL","v#00103366 v#00160073 v#00167689 v#00182381 v#00300708 v#00433778 v#00302438 v#00308615","NULL","NULL");
INSERT INTO portuguese_index VALUES ("numa_palavra","NULL","NULL","NULL","r#00151755");
INSERT INTO portuguese_index VALUES ("em_suma","NULL","NULL","NULL","r#00151755");
INSERT INTO portuguese_index VALUES ("na_sua_generalidade","NULL","NULL","NULL","r#00151755");
INSERT INTO portuguese_index VALUES ("mudo","n#10342367","NULL","a#00153592 a#00153705 a#00154331 a#00154702","NULL");
INSERT INTO portuguese_index VALUES ("muda","n#00360143","NULL","a#00153592","NULL");
INSERT INTO portuguese_index VALUES ("redescoberta","n#00151914","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("identificação","n#00098857 n#03644161 n#04445171 n#05152743 n#05153252","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encolher","NULL","v#00152558 v#00164388 v#00219644 v#00873632","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calado","n#05135155","NULL","a#00154702","NULL");
INSERT INTO portuguese_index VALUES ("diagnose","n#00152727","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diagnóstico","n#00152727 n#00153105","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("baixar","NULL","v#00104349 v#00273227 v#00301476 v#01341375 v#01343131 v#02233704","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desaparecer","NULL","v#00104505 v#00293522 v#00421917 v#00297331 v#00427397 v#00297825 v#01475232","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ampliar","NULL","v#00104604 v#00377885","NULL","NULL");
INSERT INTO portuguese_index VALUES ("progredir","NULL","v#00104604 v#00169694 v#00252019 v#01360914","NULL","NULL");
INSERT INTO portuguese_index VALUES ("à_sua_vontade","NULL","NULL","NULL","r#00153372");
INSERT INTO portuguese_index VALUES ("articulado","NULL","NULL","a#00153410","NULL");
INSERT INTO portuguese_index VALUES ("diagnóstico_diferencial","n#00153499","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Diagnostico_diferencial","n#00153499","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cuidadosamente","NULL","NULL","NULL","r#00153568 r#00226133 r#00282103");
INSERT INTO portuguese_index VALUES ("prognóstico","n#00153665 n#05057929 n#05058536 n#05435037","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resolução","n#00099792 n#00105760 n#00163047 n#00180228 n#03811208 n#04496054 n#04887532","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("envergonhado","NULL","NULL","a#00153898 a#00497363","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_segura","NULL","NULL","NULL","r#00154213");
INSERT INTO portuguese_index VALUES ("com_segurança","NULL","NULL","NULL","r#00154213");
INSERT INTO portuguese_index VALUES ("Métodos_de_autenticação","n#00154233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("certificação","n#00154233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autentificação","n#00154233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autenticação","n#00154233 n#06855035","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alegadamente","NULL","NULL","NULL","r#00154307");
INSERT INTO portuguese_index VALUES ("supostamente","NULL","NULL","NULL","r#00154307 r#00154449");
INSERT INTO portuguese_index VALUES ("documentação","n#00100230 n#04859637","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pretensamente","NULL","NULL","NULL","r#00154449");
INSERT INTO portuguese_index VALUES ("ilegalmente","NULL","NULL","NULL","r#00154536");
INSERT INTO portuguese_index VALUES ("culpado","n#09633969 n#07469314","NULL","a#00157147 a#01268094","NULL");
INSERT INTO portuguese_index VALUES ("originalmente","NULL","NULL","NULL","r#00154725 r#00167286 r#00431941");
INSERT INTO portuguese_index VALUES ("comodamente","NULL","NULL","NULL","r#00154885 r#00155020");
INSERT INTO portuguese_index VALUES ("confortavelmente","NULL","NULL","NULL","r#00154885 r#00155020");
INSERT INTO portuguese_index VALUES ("de_maneira_agradável","NULL","NULL","NULL","r#00154885 r#00219110");
INSERT INTO portuguese_index VALUES ("subir","NULL","v#01421708 v#00106300 v#00106442 v#00106604 v#00106728 v#00108091 v#00108725 v#00219109 v#00301246 v#00301917 v#00388763 v#01311485 v#01922466 v#01311898 v#01922895 v#01324807 v#01333288 v#01340005 v#01969216 v#01969779 v#01341057 v#01351334 v#01436021","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insolente","NULL","NULL","a#00155144 a#00204987 a#00205511 a#01923659","NULL");
INSERT INTO portuguese_index VALUES ("de_modo_geral","NULL","NULL","NULL","r#00155621");
INSERT INTO portuguese_index VALUES ("sem_vergonha","NULL","NULL","a#00158104","NULL");
INSERT INTO portuguese_index VALUES ("desavergonhado","NULL","NULL","a#00158104","NULL");
INSERT INTO portuguese_index VALUES ("descarado","NULL","NULL","a#00158104","NULL");
INSERT INTO portuguese_index VALUES ("impúdico","NULL","NULL","a#00158104","NULL");
INSERT INTO portuguese_index VALUES ("elevar-se","NULL","v#00106728","NULL","NULL");
INSERT INTO portuguese_index VALUES ("altear","NULL","v#00106728","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crescer","NULL","v#00106728 v#00107371 v#00108725 v#00158081 v#00158819 v#00301917 v#00302084","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avultar","NULL","v#00106728 v#00175935","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acrescentar","NULL","v#00106728 v#00107371 v#00157347 v#00125286 v#00125912 v#00274935 v#00275224","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_memória","NULL","NULL","NULL","r#00155893");
INSERT INTO portuguese_index VALUES ("de_cor","NULL","NULL","NULL","r#00155893");
INSERT INTO portuguese_index VALUES ("assertivo","NULL","NULL","a#00085707","NULL");
INSERT INTO portuguese_index VALUES ("peremptório","NULL","NULL","a#00085707 a#00667628","NULL");
INSERT INTO portuguese_index VALUES ("indução","n#00101756 n#11468172","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_viva_voz","NULL","NULL","NULL","r#00156496 r#00156654");
INSERT INTO portuguese_index VALUES ("oralmente","NULL","NULL","NULL","r#00156496 r#00156654");
INSERT INTO portuguese_index VALUES ("enfático","NULL","NULL","a#00158894 a#00842041","NULL");
INSERT INTO portuguese_index VALUES ("enérgico","NULL","NULL","a#00158894 a#00841934 a#00873603","NULL");
INSERT INTO portuguese_index VALUES ("instigação","n#00156625","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coacção","n#00156812 n#01127245","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coerção","n#00156812 n#00729616","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("efeito","n#00102269 n#07766144 n#07768053 n#07768179","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("associativa","NULL","NULL","a#00157389","NULL");
INSERT INTO portuguese_index VALUES ("associativo","NULL","NULL","a#00157389","NULL");
INSERT INTO portuguese_index VALUES ("exposição_(saúde)","n#00102651","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incompletamente","NULL","NULL","NULL","r#00157811");
INSERT INTO portuguese_index VALUES ("de_forma_incompleta","NULL","NULL","NULL","r#00157811");
INSERT INTO portuguese_index VALUES ("empenhado","NULL","NULL","a#00157925 a#00518164","NULL");
INSERT INTO portuguese_index VALUES ("usurpação","n#00157957","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sozinho","NULL","NULL","a#02143677","r#00157967");
INSERT INTO portuguese_index VALUES ("certeiramente","NULL","NULL","NULL","r#00158309");
INSERT INTO portuguese_index VALUES ("exactamente","NULL","NULL","NULL","r#00158309");
INSERT INTO portuguese_index VALUES ("precisamente","NULL","NULL","NULL","r#00158309 r#00204523 r#00204798 r#00368287");
INSERT INTO portuguese_index VALUES ("conglomerar","NULL","v#00109250","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amontoar","NULL","v#00109250 v#01576236","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acumular","NULL","v#00109250 v#01032517 v#01518840 v#01849866 v#01576236","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hipnotismo","n#00158996","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mesmerismo","n#00158996","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_exemplo","NULL","NULL","NULL","r#00159040");
INSERT INTO portuguese_index VALUES ("ex.","NULL","NULL","NULL","r#00159040");
INSERT INTO portuguese_index VALUES ("p._ex.","NULL","NULL","NULL","r#00159040");
INSERT INTO portuguese_index VALUES ("como","NULL","NULL","a#01797633","r#00159040");
INSERT INTO portuguese_index VALUES ("incorrer","NULL","v#00109701 v#02721031","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tentação","n#00103541 n#04400046 n#05564760","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("do_início","NULL","NULL","NULL","r#00159889");
INSERT INTO portuguese_index VALUES ("do_zero","NULL","NULL","NULL","r#00159889");
INSERT INTO portuguese_index VALUES ("assimilar","NULL","v#00110229 v#00110327 v#00406975","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sedução","n#00160415 n#00104245 n#03693301","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apegado","NULL","NULL","a#00160425","NULL");
INSERT INTO portuguese_index VALUES ("rigorosamente","NULL","NULL","NULL","r#00160440 r#00179112");
INSERT INTO portuguese_index VALUES ("de_perto","NULL","NULL","NULL","r#00160440");
INSERT INTO portuguese_index VALUES ("perto","NULL","NULL","a#00412848","r#00160440 r#00160659");
INSERT INTO portuguese_index VALUES ("desvinculado","NULL","NULL","a#00162581","NULL");
INSERT INTO portuguese_index VALUES ("com_intimidade","NULL","NULL","NULL","r#00160659");
INSERT INTO portuguese_index VALUES ("separado","NULL","NULL","a#00162772 a#02036455","NULL");
INSERT INTO portuguese_index VALUES ("relativamente","NULL","NULL","NULL","r#00160834");
INSERT INTO portuguese_index VALUES ("comparativamente","NULL","NULL","NULL","r#00160834");
INSERT INTO portuguese_index VALUES ("de_forma_predominante","NULL","NULL","NULL","r#00161018");
INSERT INTO portuguese_index VALUES ("predominantemente","NULL","NULL","NULL","r#00161018");
INSERT INTO portuguese_index VALUES ("sem_dificuldades","NULL","NULL","NULL","r#00161193");
INSERT INTO portuguese_index VALUES ("substituir","NULL","v#00111031 v#00111859 v#01545057 v#02258617 v#01630991 v#02394662 v#01639012 v#02406011","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escolha","n#00104850 n#00163047 n#00118200 n#04462889 n#04463475","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("seleção","n#00104850 n#08399586","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("selecção","n#00104850 n#04462889 n#08399586","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vagarosamente","NULL","NULL","NULL","r#00161630");
INSERT INTO portuguese_index VALUES ("devagar","NULL","NULL","a#00929061","r#00161630");
INSERT INTO portuguese_index VALUES ("lentamente","NULL","NULL","NULL","r#00161630");
INSERT INTO portuguese_index VALUES ("técnicas_de_amostragem","n#00161888","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amostragem","n#00161888","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_público","NULL","NULL","NULL","r#00161932");
INSERT INTO portuguese_index VALUES ("publicamente","NULL","NULL","NULL","r#00161932 r#00162765");
INSERT INTO portuguese_index VALUES ("removível","NULL","NULL","a#00162083 a#01526582","NULL");
INSERT INTO portuguese_index VALUES ("destacável","NULL","NULL","a#00162083","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_privada","NULL","NULL","NULL","r#00162137");
INSERT INTO portuguese_index VALUES ("em_particular","NULL","NULL","NULL","r#00162137");
INSERT INTO portuguese_index VALUES ("cauteloso","NULL","NULL","a#00164110 a#00317140 a#01468566","NULL");
INSERT INTO portuguese_index VALUES ("cauteloso(a)","NULL","NULL","a#00164110","NULL");
INSERT INTO portuguese_index VALUES ("cuidadoso(a)","NULL","NULL","a#00164110","NULL");
INSERT INTO portuguese_index VALUES ("decisão","n#00105760 n#03810995 n#04496054","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vontade","n#00163047 n#04371730 n#04589152","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crédulo","NULL","NULL","a#00163315 a#00646413 a#02272305 a#02162641","NULL");
INSERT INTO portuguese_index VALUES ("reviravolta","n#00163406","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conversão","n#00163406 n#04471523","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("restaurar","NULL","v#00112290 v#00164201 v#01652221","NULL","NULL");
INSERT INTO portuguese_index VALUES ("renovar","NULL","v#00112290 v#00112422 v#00164201 v#01121382","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atento","NULL","NULL","a#00165320 a#00166039 a#00303585 a#00317140 a#01145007 a#01977488","NULL");
INSERT INTO portuguese_index VALUES ("adulteração","n#00163630 n#00751145 n#14487443","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nomeação","n#00106381 n#00164152","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("designação","n#00106381 n#00730247","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("absorto","NULL","NULL","a#00163948","NULL");
INSERT INTO portuguese_index VALUES ("absorvido","NULL","NULL","a#00163948 a#02009166","NULL");
INSERT INTO portuguese_index VALUES ("avivar","NULL","v#00164444","NULL","NULL");
INSERT INTO portuguese_index VALUES ("solícito","NULL","NULL","a#00166461 a#00510407","NULL");
INSERT INTO portuguese_index VALUES ("friamente","NULL","NULL","NULL","r#00164890 r#00317390");
INSERT INTO portuguese_index VALUES ("seriamente","NULL","NULL","NULL","r#00165018");
INSERT INTO portuguese_index VALUES ("abstraído","NULL","NULL","a#00166902","NULL");
INSERT INTO portuguese_index VALUES ("ausente","n#09757653","NULL","a#00166902 a#01775263","NULL");
INSERT INTO portuguese_index VALUES ("Ordenação","n#00107544","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ordenação_religiosa","n#00107544","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consolidar","NULL","v#00113548 v#00113716 v#00113869 v#00150444 v#00166039","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sonhador","NULL","NULL","a#00165585","NULL");
INSERT INTO portuguese_index VALUES ("sonolento","NULL","NULL","a#00165766 a#00188436 a#00189092 a#00189253","NULL");
INSERT INTO portuguese_index VALUES ("imposição_das_mãos","n#00165793","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Imposição_das_Mãos","n#00165793","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("movimento","n#00107819 n#00108157 n#00180278 n#00280586 n#00213412 n#05283408 n#05449557 n#06251839 n#07775426 n#10088697","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passo","n#00107819 n#00184779 n#00185003 n#00533922 n#03948875 n#09907411","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distraído","NULL","NULL","a#00165943","NULL");
INSERT INTO portuguese_index VALUES ("esquecido","NULL","NULL","a#00165943 a#01608465","NULL");
INSERT INTO portuguese_index VALUES ("muito_tempo","NULL","NULL","NULL","r#00166025");
INSERT INTO portuguese_index VALUES ("por_muito_tempo","NULL","NULL","NULL","r#00166025");
INSERT INTO portuguese_index VALUES ("atraente","NULL","NULL","a#00167697 a#00216139","NULL");
INSERT INTO portuguese_index VALUES ("de_passagem","NULL","NULL","NULL","r#00166375");
INSERT INTO portuguese_index VALUES ("roque","n#00166552 n#03523510","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazerroque","n#00166552","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("en_passant","n#00166865","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desvitalizar","NULL","v#00166952","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carismático","NULL","NULL","a#00167077","NULL");
INSERT INTO portuguese_index VALUES ("carismática","NULL","NULL","a#00167077","NULL");
INSERT INTO portuguese_index VALUES ("linda","NULL","NULL","a#00168739","NULL");
INSERT INTO portuguese_index VALUES ("bonita","NULL","NULL","a#00168739 a#00215099","NULL");
INSERT INTO portuguese_index VALUES ("xeque","n#00167446 n#10588357","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Xeque","n#00167446 n#10588357","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_um_fio","NULL","NULL","NULL","r#00167575");
INSERT INTO portuguese_index VALUES ("instante","n#10898122 n#10952516 n#10952736 n#10953446 n#10953688 n#10953874","NULL","NULL","r#00167575");
INSERT INTO portuguese_index VALUES ("chamativo","NULL","NULL","a#00169076","NULL");
INSERT INTO portuguese_index VALUES ("interessante","NULL","NULL","a#00169076 a#00379463 a#01290353 a#02587936","NULL");
INSERT INTO portuguese_index VALUES ("xeque-mate","n#00167764 n#07475035","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("debalde","NULL","NULL","NULL","r#00167920");
INSERT INTO portuguese_index VALUES ("em_vão","NULL","NULL","NULL","r#00167920 r#00168075");
INSERT INTO portuguese_index VALUES ("inutilmente","NULL","NULL","NULL","r#00167920 r#00195786 r#00491438");
INSERT INTO portuguese_index VALUES ("estacionamento","n#00168505 n#08615638 n#13778671","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parques_de_estacionamento","n#00168505 n#08615638 n#08615810","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irresistível","NULL","NULL","a#00168551 a#01917404 a#01917639","NULL");
INSERT INTO portuguese_index VALUES ("restituir","NULL","v#00168588","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mudança","n#00717034 n#00125689 n#00195415 n#00128676 n#00128951 n#00213518 n#00256334 n#05441797 n#07297633 n#05467031 n#07355194 n#05481414 n#05519358 n#11412727 n#09984639","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fotogênico","NULL","NULL","a#00168820","NULL");
INSERT INTO portuguese_index VALUES ("fotogénico","NULL","NULL","a#00168820","NULL");
INSERT INTO portuguese_index VALUES ("reviver","NULL","v#00168910 v#00169298","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_confidencial","NULL","NULL","NULL","r#00169312");
INSERT INTO portuguese_index VALUES ("confidencialmente","NULL","NULL","NULL","r#00169312");
INSERT INTO portuguese_index VALUES ("em_media","NULL","NULL","NULL","r#00169659");
INSERT INTO portuguese_index VALUES ("magnético","NULL","NULL","a#00169955 a#01469677 a#01470298 a#01470813 a#02926188","NULL");
INSERT INTO portuguese_index VALUES ("atrativo","NULL","v#00539391","a#00169955 a#02097480","NULL");
INSERT INTO portuguese_index VALUES ("hipoteticamente","NULL","NULL","NULL","r#00169971");
INSERT INTO portuguese_index VALUES ("teoricamente","NULL","NULL","NULL","r#00170045 r#00170188");
INSERT INTO portuguese_index VALUES ("ao_contrário","NULL","NULL","NULL","r#00170412");
INSERT INTO portuguese_index VALUES ("mas","NULL","NULL","NULL","r#00170412");
INSERT INTO portuguese_index VALUES ("pelo_contrário","NULL","NULL","NULL","r#00170412");
INSERT INTO portuguese_index VALUES ("sincopar","NULL","v#00170500 v#00317086","NULL","NULL");
INSERT INTO portuguese_index VALUES ("actualizar","NULL","v#00170695 v#00170857","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tornar_atual","NULL","v#00170695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atualizar","NULL","v#00170857","NULL","NULL");
INSERT INTO portuguese_index VALUES ("qualificar","NULL","v#00117331 v#00136387 v#00207831","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artimanha","n#00111216 n#00172490 n#00172598 n#00485559 n#05065985","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("na_direção","NULL","NULL","NULL","r#00171322");
INSERT INTO portuguese_index VALUES ("não_atrativo","NULL","NULL","a#00171447","NULL");
INSERT INTO portuguese_index VALUES ("na_hora","NULL","NULL","NULL","r#00171457");
INSERT INTO portuguese_index VALUES ("pontualmente","NULL","NULL","NULL","r#00171457");
INSERT INTO portuguese_index VALUES ("modular","NULL","v#00171458 v#00206759 v#00982293","a#02296415","NULL");
INSERT INTO portuguese_index VALUES ("mnemônica","n#00171507","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enriquecer","NULL","v#00117675 v#00151781 v#01584550","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atribuível","NULL","NULL","a#00171872","NULL");
INSERT INTO portuguese_index VALUES ("correctamente","NULL","NULL","NULL","r#00172020 r#00203922 r#00205375");
INSERT INTO portuguese_index VALUES ("finta","n#00172073","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("optimizar","NULL","v#00172505","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maracutaia","n#00172598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ferramenta","n#00111872 n#00112599 n#02202438 n#02560468 n#02644452 n#03489162 n#02851548 n#02859502 n#02975720 n#03516946 n#04516672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modo","n#00111872 n#05134016 n#09939326","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maneira","n#00111872 n#03835766 n#03856995 n#04930478 n#03858557","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jeito","n#00111872 n#03858557","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("privar","NULL","v#00118443 v#00813536 v#01580892 v#01581572","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corajosamente","NULL","NULL","NULL","r#00172980");
INSERT INTO portuguese_index VALUES ("grávida","NULL","NULL","a#00173220 a#00173391","NULL");
INSERT INTO portuguese_index VALUES ("grávido","NULL","NULL","a#00173220","NULL");
INSERT INTO portuguese_index VALUES ("prenha","NULL","NULL","a#00173220","NULL");
INSERT INTO portuguese_index VALUES ("remover","NULL","v#00118898 v#00122604 v#00133485","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tirar","NULL","v#00118898 v#00120982 v#00121492 v#00122191 v#00122353 v#00122604 v#00571596 v#00544143 v#00847385 v#01351170 v#01434278 v#00993032 v#00997005 v#00997134 v#00998398 v#01054290 v#01096854 v#01108327 v#01266515 v#01422262 v#02097800 v#02101789 v#01579864","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profundamente","NULL","NULL","NULL","r#00173353 r#00305570");
INSERT INTO portuguese_index VALUES ("impacientemente","NULL","NULL","NULL","r#00173498");
INSERT INTO portuguese_index VALUES ("pacientemente","NULL","NULL","NULL","r#00173644");
INSERT INTO portuguese_index VALUES ("de_forma_paciente","NULL","NULL","NULL","r#00173644");
INSERT INTO portuguese_index VALUES ("instrumento","n#00112599 n#02560468 n#02851548 n#02859502 n#03025339 n#03516946 n#06471345","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("audível","NULL","NULL","a#00173764","NULL");
INSERT INTO portuguese_index VALUES ("estrada","n#00112808 n#02159544 n#02758863 n#03306610 n#03519578 n#03519981 n#03092396 n#03096023 n#03243979 n#03245327 n#03426653 n#04426618 n#03525842 n#03600463 n#06348591","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instavelmente","NULL","NULL","NULL","r#00174232");
INSERT INTO portuguese_index VALUES ("abraço_de_urso","n#00174782","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Leveraged_buyout","n#00175174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Leveraged_Buyout","n#00175174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ultrassônico","NULL","NULL","a#00175300 a#00175887","NULL");
INSERT INTO portuguese_index VALUES ("supersônico","NULL","NULL","a#00175300 a#00175887","NULL");
INSERT INTO portuguese_index VALUES ("estupidamente","NULL","NULL","NULL","r#00175344");
INSERT INTO portuguese_index VALUES ("de_forma_única","NULL","NULL","NULL","r#00175490");
INSERT INTO portuguese_index VALUES ("assimetricamente","NULL","NULL","NULL","r#00175778");
INSERT INTO portuguese_index VALUES ("reciprocamente","NULL","NULL","NULL","r#00175919 r#00405645 r#00405868");
INSERT INTO portuguese_index VALUES ("de_forma_recíproca","NULL","NULL","NULL","r#00175919");
INSERT INTO portuguese_index VALUES ("auspicioso","NULL","NULL","a#00176908","NULL");
INSERT INTO portuguese_index VALUES ("distalmente","NULL","NULL","NULL","r#00176253");
INSERT INTO portuguese_index VALUES ("extirpar","NULL","v#00176327 v#01079137 v#01662118","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pesadamente","NULL","NULL","NULL","r#00176383");
INSERT INTO portuguese_index VALUES ("repetidamente","NULL","NULL","NULL","r#00176880 r#00176981");
INSERT INTO portuguese_index VALUES ("de_forma_repetida","NULL","NULL","NULL","r#00176880");
INSERT INTO portuguese_index VALUES ("várias_e_várias_vezes","NULL","NULL","NULL","r#00176981");
INSERT INTO portuguese_index VALUES ("desnudar-se","NULL","v#00177243","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despir-se","NULL","v#00177243","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fortemente","NULL","NULL","NULL","r#00177289 r#00428245");
INSERT INTO portuguese_index VALUES ("recurso","n#00115902 n#01185611 n#00783240 n#04015246 n#04015405 n#04015637 n#04015786 n#05408794 n#09598145","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vice_versa","NULL","NULL","NULL","r#00177686");
INSERT INTO portuguese_index VALUES ("vice-versa","NULL","NULL","NULL","r#00177686");
INSERT INTO portuguese_index VALUES ("descascar","NULL","v#00121172 v#00861277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semana_após_semana","NULL","NULL","NULL","r#00178028");
INSERT INTO portuguese_index VALUES ("agourento","n#10224446","NULL","a#00178126","NULL");
INSERT INTO portuguese_index VALUES ("ameaçador","NULL","NULL","a#00178126 a#00194152","NULL");
INSERT INTO portuguese_index VALUES ("radicalmente","NULL","NULL","NULL","r#00178342");
INSERT INTO portuguese_index VALUES ("religiosamente","NULL","NULL","NULL","r#00178460 r#00178586");
INSERT INTO portuguese_index VALUES ("ensurdecedor","NULL","NULL","a#00178464 a#00306034 a#01453467","NULL");
INSERT INTO portuguese_index VALUES ("sacar","NULL","v#00121956 v#00122077 v#00122353 v#00124529 v#00340120 v#00571596 v#01351170 v#01352390 v#01434278 v#01485513 v#01054290 v#01079137 v#01108327 v#01266515 v#01360709 v#02097800 v#01579864","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrancar","NULL","v#00122191","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprovado","NULL","NULL","a#00179586","NULL");
INSERT INTO portuguese_index VALUES ("puramente","NULL","NULL","NULL","r#00179112");
INSERT INTO portuguese_index VALUES ("estritamente","NULL","NULL","NULL","r#00179112");
INSERT INTO portuguese_index VALUES ("experimentalmente","NULL","NULL","NULL","r#00179212");
INSERT INTO portuguese_index VALUES ("por_outras_palavras","NULL","NULL","NULL","r#00179333");
INSERT INTO portuguese_index VALUES ("frouxamente","NULL","NULL","NULL","r#00179442");
INSERT INTO portuguese_index VALUES ("relaxadamente","NULL","NULL","NULL","r#00179442");
INSERT INTO portuguese_index VALUES ("de_forma_relaxada","NULL","NULL","NULL","r#00179442");
INSERT INTO portuguese_index VALUES ("desnecessariamente","NULL","NULL","NULL","r#00179677 r#00195786 r#00408498");
INSERT INTO portuguese_index VALUES ("graciosamente","NULL","NULL","NULL","r#00179807");
INSERT INTO portuguese_index VALUES ("constitucional","NULL","NULL","a#00180449 a#00856863 a#02550238","NULL");
INSERT INTO portuguese_index VALUES ("habilmente","NULL","NULL","NULL","r#00180057 r#00185172");
INSERT INTO portuguese_index VALUES ("caprichosamente","NULL","NULL","NULL","r#00180057");
INSERT INTO portuguese_index VALUES ("com_capricho","NULL","NULL","NULL","r#00180057");
INSERT INTO portuguese_index VALUES ("inconstitucional","NULL","NULL","a#00180211","NULL");
INSERT INTO portuguese_index VALUES ("delicadamente","NULL","NULL","NULL","r#00180279 r#00181576 r#00502847");
INSERT INTO portuguese_index VALUES ("em_troca","NULL","NULL","NULL","r#00180420 r#00405868");
INSERT INTO portuguese_index VALUES ("por_sua_vez","NULL","NULL","NULL","r#00180420");
INSERT INTO portuguese_index VALUES ("independentemente","NULL","NULL","NULL","r#00180611 r#00450647");
INSERT INTO portuguese_index VALUES ("eleição","n#00118200 n#00118873 n#00183505 n#04463475","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("que_dá_continuaçãoa_si_mesmo","NULL","NULL","a#00181030","NULL");
INSERT INTO portuguese_index VALUES ("heterogêneo","NULL","NULL","a#00182244 a#01149134","NULL");
INSERT INTO portuguese_index VALUES ("heterogênea","NULL","NULL","a#00182244 a#01149134","NULL");
INSERT INTO portuguese_index VALUES ("reeleição","n#00181373","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("automático","NULL","NULL","a#00182347 a#01439795 a#02400554 a#02401195","NULL");
INSERT INTO portuguese_index VALUES ("plebiscito","n#00181495","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("referendo","n#00181495 n#00118732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retirar","NULL","v#00124529 v#00133485 v#01549420 v#01580390","NULL","NULL");
INSERT INTO portuguese_index VALUES ("referendum","n#00118732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desobstruir","NULL","v#00124634","NULL","NULL");
INSERT INTO portuguese_index VALUES ("no_estrangeiro","NULL","NULL","NULL","r#00181676");
INSERT INTO portuguese_index VALUES ("no_exterior","NULL","NULL","NULL","r#00181676");
INSERT INTO portuguese_index VALUES ("espertamente","NULL","NULL","NULL","r#00181748");
INSERT INTO portuguese_index VALUES ("vigorosamente","NULL","NULL","NULL","r#00181748");
INSERT INTO portuguese_index VALUES ("astutamente","NULL","NULL","NULL","r#00181748");
INSERT INTO portuguese_index VALUES ("fazer_barulho_ou_algazarra","NULL","v#00181875","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encher_desordenadamente","NULL","v#00181875","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abarrotar","NULL","v#00181875","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semiautomático","NULL","NULL","a#00181904","NULL");
INSERT INTO portuguese_index VALUES ("in_vivo","NULL","NULL","NULL","r#00182094");
INSERT INTO portuguese_index VALUES ("positivamente","NULL","NULL","NULL","r#00182199 r#00511573");
INSERT INTO portuguese_index VALUES ("votação","n#00119067 n#00183505","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transbordar","NULL","v#00125167","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desbordar","NULL","v#00125167","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_excelente","NULL","NULL","NULL","r#00182316");
INSERT INTO portuguese_index VALUES ("excelentemente","NULL","NULL","NULL","r#00182316");
INSERT INTO portuguese_index VALUES ("com_excelência","NULL","NULL","NULL","r#00182316");
INSERT INTO portuguese_index VALUES ("adicionar","NULL","v#00125286 v#00642843 v#01805970 v#02745172","NULL","NULL");
INSERT INTO portuguese_index VALUES ("somar","NULL","v#00125286 v#00125912 v#00432790 v#00642843","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Eleição_primária","n#00182571","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manual","n#06421301 n#04840046","NULL","a#00183402 a#02434158 a#02584677","NULL");
INSERT INTO portuguese_index VALUES ("disponível","NULL","NULL","a#00183612 a#00184637 a#00185066 a#00740788","NULL");
INSERT INTO portuguese_index VALUES ("maravilhosamente","NULL","NULL","NULL","r#00183090");
INSERT INTO portuguese_index VALUES ("voto","n#00183505 n#07228751","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incluir","NULL","v#00126016 v#00462038 v#01796443 v#01798079 v#01842330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("misturar","NULL","v#00126217 v#00274169 v#00275528 v#00972191 v#00972429 v#01002550 v#01003100 v#01003383 v#01003631 v#01003753 v#01009511 v#01138007","NULL","NULL");
INSERT INTO portuguese_index VALUES ("que_está_por_vir","NULL","NULL","a#00184637","NULL");
INSERT INTO portuguese_index VALUES ("que_está_por_aparecer","NULL","NULL","a#00184637","NULL");
INSERT INTO portuguese_index VALUES ("que_vem","NULL","NULL","a#00184637","NULL");
INSERT INTO portuguese_index VALUES ("a_ser_lançado","NULL","NULL","a#00184637","NULL");
INSERT INTO portuguese_index VALUES ("a_ser_publicado","NULL","NULL","a#00184637","NULL");
INSERT INTO portuguese_index VALUES ("reconhecidamente","NULL","NULL","NULL","r#00184284");
INSERT INTO portuguese_index VALUES ("voto_secreto","n#00184362","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obtenível","NULL","NULL","a#00184363","NULL");
INSERT INTO portuguese_index VALUES ("adquirível","NULL","NULL","a#00184363 a#00185607","NULL");
INSERT INTO portuguese_index VALUES ("racionalmente","NULL","NULL","NULL","r#00184530");
INSERT INTO portuguese_index VALUES ("de_forma_crítica","NULL","NULL","NULL","r#00184778");
INSERT INTO portuguese_index VALUES ("criticamente","NULL","NULL","NULL","r#00184778");
INSERT INTO portuguese_index VALUES ("visível","NULL","NULL","a#00185066 a#01643240 a#02394546","NULL");
INSERT INTO portuguese_index VALUES ("Voto_de_minerva","n#00184981","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Voto_de_Minerva","n#00184981","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("competentemente","NULL","NULL","NULL","r#00185172");
INSERT INTO portuguese_index VALUES ("de_forma_competente","NULL","NULL","NULL","r#00185172");
INSERT INTO portuguese_index VALUES ("acertadamente","NULL","NULL","NULL","r#00185172");
INSERT INTO portuguese_index VALUES ("equação","n#00121609 n#05001502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emocionalmente","NULL","NULL","NULL","r#00185567 r#00185670");
INSERT INTO portuguese_index VALUES ("comprável","NULL","NULL","a#00185607","NULL");
INSERT INTO portuguese_index VALUES ("à_venda","NULL","NULL","a#00185607","NULL");
INSERT INTO portuguese_index VALUES ("cesariana","n#00185778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cesárea","n#00185778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indisponível","NULL","NULL","a#00185921","NULL");
INSERT INTO portuguese_index VALUES ("ansiosamente","NULL","NULL","NULL","r#00185970");
INSERT INTO portuguese_index VALUES ("não_adquirível","NULL","NULL","a#00186193","NULL");
INSERT INTO portuguese_index VALUES ("formalmente","NULL","NULL","NULL","r#00186366 r#00186491");
INSERT INTO portuguese_index VALUES ("desperto","NULL","NULL","a#00538149","NULL");
INSERT INTO portuguese_index VALUES ("acordado","NULL","NULL","a#00538149 a#00187443","NULL");
INSERT INTO portuguese_index VALUES ("agradavelmente","NULL","NULL","NULL","r#00187028 r#00219110");
INSERT INTO portuguese_index VALUES ("de_forma_bela","NULL","NULL","NULL","r#00187028");
INSERT INTO portuguese_index VALUES ("belamente","NULL","NULL","NULL","r#00187028 r#00242006");
INSERT INTO portuguese_index VALUES ("gentilmente","NULL","NULL","NULL","r#00187028 r#00218479");
INSERT INTO portuguese_index VALUES ("gol","n#00187337","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gol-contra","n#00187499","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autogolo","n#00187499","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gol_contra","n#00187499","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confinar","NULL","v#00128702 v#00889308","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inserir","NULL","v#00128702 v#00974668","NULL","NULL");
INSERT INTO portuguese_index VALUES ("introduzir","NULL","v#00128702 v#00610889 v#00611179 v#00974668 v#01112995 v#01423096","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adormecido","NULL","NULL","a#00187821","NULL");
INSERT INTO portuguese_index VALUES ("touchback","n#00188449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("a_saber","NULL","NULL","NULL","r#00188510");
INSERT INTO portuguese_index VALUES ("isto_é","NULL","NULL","NULL","r#00188510");
INSERT INTO portuguese_index VALUES ("Touchdown","n#00188766","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("com_entusiasmo","NULL","NULL","NULL","r#00188779");
INSERT INTO portuguese_index VALUES ("entusiasticamente","NULL","NULL","NULL","r#00188779 r#00456484");
INSERT INTO portuguese_index VALUES ("Golo_de_campo","n#00188934","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("com_sono","NULL","NULL","a#00189092","NULL");
INSERT INTO portuguese_index VALUES ("dorminhoco","n#10611541","NULL","a#00189092","NULL");
INSERT INTO portuguese_index VALUES ("um_dia","NULL","NULL","NULL","r#00189401");
INSERT INTO portuguese_index VALUES ("corrida","n#00124616 n#00190535 n#00449295 n#05544480 n#05556140","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adstringente","NULL","NULL","a#00189580 a#02369027","NULL");
INSERT INTO portuguese_index VALUES ("hemostático","NULL","NULL","a#00189833","NULL");
INSERT INTO portuguese_index VALUES ("orgulhosamente","NULL","NULL","NULL","r#00189846");
INSERT INTO portuguese_index VALUES ("corrida_limpa","n#00189896","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pontuar","NULL","v#00190023","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marcar_ponto","NULL","v#00190023","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ciente","NULL","NULL","a#00190115","NULL");
INSERT INTO portuguese_index VALUES ("informado","NULL","NULL","a#00190115","NULL");
INSERT INTO portuguese_index VALUES ("corrida_impulsionada","n#00190180","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concatenar","NULL","v#00130632 v#01465054","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cesta","n#00125430 n#02259850 n#03127925","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ser_causa_de","NULL","v#00190682","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ativar","NULL","v#00190682","NULL","NULL");
INSERT INTO portuguese_index VALUES ("produzir","NULL","v#00190682 v#00986409 v#01114991 v#01128460 v#01189395 v#01799148","NULL","NULL");
INSERT INTO portuguese_index VALUES ("causar","NULL","v#00190682 v#00986409 v#01111638 v#01128460 v#01130277 v#01131041 v#01131307 v#01799148 v#01583087","NULL","NULL");
INSERT INTO portuguese_index VALUES ("roleta_russa","n#00190931","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intensamente","NULL","NULL","NULL","r#00190959");
INSERT INTO portuguese_index VALUES ("troca","n#00125689 n#00719653 n#00755465","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("biodegradar","NULL","v#00191220","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sensato","NULL","NULL","a#00190958 a#01825807 a#02569558","NULL");
INSERT INTO portuguese_index VALUES ("desativar","NULL","v#00191517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desactivar","NULL","v#00191517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sustentadamente","NULL","NULL","NULL","r#00191656");
INSERT INTO portuguese_index VALUES ("reativar","NULL","v#00191940","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amortecer","NULL","v#00192051 v#00153724 v#01576917 v#02191311","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enfraquecer","NULL","v#00192051 v#00153724 v#00270123","NULL","NULL");
INSERT INTO portuguese_index VALUES ("percolação","n#00192149","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("simplificação","n#00126290 n#00785705","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inconsciente","n#05613274","NULL","a#00192332 a#00538832 a#02400554","NULL");
INSERT INTO portuguese_index VALUES ("petrificar","NULL","v#00192471 v#00507485","NULL","NULL");
INSERT INTO portuguese_index VALUES ("economia","n#00126393 n#03832817 n#04365547 n#06149484 n#06193947","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("peloroubo","NULL","NULL","NULL","r#00192986");
INSERT INTO portuguese_index VALUES ("matreiramente","NULL","NULL","NULL","r#00192986");
INSERT INTO portuguese_index VALUES ("sorrateiramente","NULL","NULL","NULL","r#00192986");
INSERT INTO portuguese_index VALUES ("alarmante","NULL","NULL","a#00192906","NULL");
INSERT INTO portuguese_index VALUES ("inquietante","NULL","NULL","a#00192906","NULL");
INSERT INTO portuguese_index VALUES ("Acomodação","n#00193225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("horrível","NULL","NULL","a#00193234 a#00193347 a#00193648 a#00195313 a#00354187 a#01079225 a#01127147 a#01080562 a#01450767 a#01529876 a#01677200 a#01731616","NULL");
INSERT INTO portuguese_index VALUES ("personalização","n#00127097","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adaptação","n#00127097 n#09743067","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abominável","NULL","NULL","a#00193347 a#01079225 a#01084054 a#01460421 a#01460679","NULL");
INSERT INTO portuguese_index VALUES ("atroz","NULL","NULL","a#00193347 a#01079225 a#01084054 a#02514380","NULL");
INSERT INTO portuguese_index VALUES ("reunir","NULL","v#00133085 v#00184548 v#00927388 v#00946301 v#00947309 v#00949234 v#01137704 v#02024716 v#01518840 v#01576236 v#01576416 v#02428924 v#01682716 v#01772676","NULL","NULL");
INSERT INTO portuguese_index VALUES ("unir","NULL","v#00133085 v#00166214 v#00166362 v#00257011 v#00881999 v#00884615 v#00885494 v#00927388 v#01490958 v#01595830 v#02024508","NULL","NULL");
INSERT INTO portuguese_index VALUES ("combinar","NULL","v#00133085 v#00274169 v#01002550 v#01813355 v#02658734 v#01841936","NULL","NULL");
INSERT INTO portuguese_index VALUES ("visivelmente","NULL","NULL","NULL","r#00193652 r#00382287");
INSERT INTO portuguese_index VALUES ("medonho","NULL","NULL","a#00193648","NULL");
INSERT INTO portuguese_index VALUES ("terrível","NULL","NULL","a#00193648 a#00194690 a#01079225 a#01448254 a#01450767 a#01567385 a#01731616","NULL");
INSERT INTO portuguese_index VALUES ("temível","NULL","NULL","a#00193648","NULL");
INSERT INTO portuguese_index VALUES ("calamitoso","NULL","NULL","a#00193648","NULL");
INSERT INTO portuguese_index VALUES ("temido","NULL","NULL","a#00193648","NULL");
INSERT INTO portuguese_index VALUES ("pavoroso","NULL","NULL","a#00193648 a#01731616","NULL");
INSERT INTO portuguese_index VALUES ("atenciosamente","NULL","NULL","NULL","r#00194156 r#00196417 r#00216788 r#00217105");
INSERT INTO portuguese_index VALUES ("ordenhar","NULL","v#00194170 v#01164906","NULL","NULL");
INSERT INTO portuguese_index VALUES ("domesticação","n#00194257 n#04905842 n#13468954","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ominoso","NULL","NULL","a#00194152","NULL");
INSERT INTO portuguese_index VALUES ("desmantelar","NULL","v#00133485 v#01657977","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmanchar","NULL","v#00133485 v#01113462 v#01657977","NULL","NULL");
INSERT INTO portuguese_index VALUES ("severamente","NULL","NULL","NULL","r#00194578");
INSERT INTO portuguese_index VALUES ("pesadelar","NULL","NULL","a#00194817","NULL");
INSERT INTO portuguese_index VALUES ("Habituação","n#00127976","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assustador","NULL","NULL","a#00194690 a#00968522","NULL");
INSERT INTO portuguese_index VALUES ("variação","n#00128096 n#05441797 n#05467031","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regularmente","NULL","NULL","NULL","r#00195024");
INSERT INTO portuguese_index VALUES ("muitasvezes","NULL","NULL","NULL","r#00195024");
INSERT INTO portuguese_index VALUES ("horripilante","NULL","NULL","a#00194887","NULL");
INSERT INTO portuguese_index VALUES ("universalmente","NULL","NULL","NULL","r#00195342");
INSERT INTO portuguese_index VALUES ("idealmente","NULL","NULL","NULL","r#00195428");
INSERT INTO portuguese_index VALUES ("mal","n#03802516 n#10257548","NULL","NULL","r#00195542");
INSERT INTO portuguese_index VALUES ("erradamente","NULL","NULL","NULL","r#00195542 r#00204125");
INSERT INTO portuguese_index VALUES ("diversificação","n#00128403","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("macabro","NULL","NULL","a#00195313","NULL");
INSERT INTO portuguese_index VALUES ("sem_necessidade","NULL","NULL","NULL","r#00195786");
INSERT INTO portuguese_index VALUES ("cabeludo","NULL","NULL","a#00196122","NULL");
INSERT INTO portuguese_index VALUES ("perigoso","NULL","NULL","a#00196122 a#00614072 a#01981873 a#02059811 a#01983358","NULL");
INSERT INTO portuguese_index VALUES ("devidamente","NULL","NULL","NULL","r#00196203");
INSERT INTO portuguese_index VALUES ("decentemente","NULL","NULL","NULL","r#00196203 r#00247194 r#00285447");
INSERT INTO portuguese_index VALUES ("atear_fogo","NULL","v#00134645 v#02760139","NULL","NULL");
INSERT INTO portuguese_index VALUES ("queimar","NULL","v#00134645 v#00262798 v#00263602 v#00303520 v#00820086 v#02760139 v#01887716 v#01891783","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atentamente","NULL","NULL","NULL","r#00196417");
INSERT INTO portuguese_index VALUES ("substituição_(processos_químicos)","n#00128951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("substituição","n#00128951 n#00197772 n#09742155","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("generosamente","NULL","NULL","NULL","r#00196692 r#00279867");
INSERT INTO portuguese_index VALUES ("escaldar","NULL","v#00196758","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_esforço","NULL","NULL","NULL","r#00196999");
INSERT INTO portuguese_index VALUES ("com_desenvoltura","NULL","NULL","NULL","r#00196999");
INSERT INTO portuguese_index VALUES ("facilmente","NULL","NULL","NULL","r#00196999");
INSERT INTO portuguese_index VALUES ("horas","NULL","NULL","NULL","r#00197182");
INSERT INTO portuguese_index VALUES ("detalhadamente","NULL","NULL","NULL","r#00197275");
INSERT INTO portuguese_index VALUES ("em_detalhes","NULL","NULL","NULL","r#00197275");
INSERT INTO portuguese_index VALUES ("favoravelmente","NULL","NULL","NULL","r#00197395 r#00230444");
INSERT INTO portuguese_index VALUES ("auspiciosamente","NULL","NULL","NULL","r#00197395 r#00230444");
INSERT INTO portuguese_index VALUES ("desossar","NULL","v#00197423","NULL","NULL");
INSERT INTO portuguese_index VALUES ("angustiante","NULL","NULL","a#00197124","NULL");
INSERT INTO portuguese_index VALUES ("preocupante","NULL","NULL","a#00197124","NULL");
INSERT INTO portuguese_index VALUES ("desfavoravelmente","NULL","NULL","NULL","r#00197561 r#00230581");
INSERT INTO portuguese_index VALUES ("inconvenientemente","NULL","NULL","NULL","r#00197561 r#00230581");
INSERT INTO portuguese_index VALUES ("desvicerar","NULL","v#00197590","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destripar","NULL","v#00197590","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desentranhar","NULL","v#00197590","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estripar","NULL","v#00197590 v#01590747","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conjuntamente","NULL","NULL","NULL","r#00197710");
INSERT INTO portuguese_index VALUES ("em_conjunto","NULL","NULL","NULL","r#00197710");
INSERT INTO portuguese_index VALUES ("reposição","n#00197772","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_hindmost","NULL","NULL","a#00197773","NULL");
INSERT INTO portuguese_index VALUES ("por_todos_os_lados","NULL","NULL","NULL","r#00198039");
INSERT INTO portuguese_index VALUES ("avançado","NULL","NULL","a#00198023 a#01159832 a#01840121","NULL");
INSERT INTO portuguese_index VALUES ("ascenção","n#00130078 n#07370410","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("promoção","n#00130078 n#01117723 n#05409803 n#05412651","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escalpelar","NULL","v#00198477","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_acinte","NULL","NULL","NULL","r#00198661");
INSERT INTO portuguese_index VALUES ("por_desafio","NULL","NULL","NULL","r#00198661");
INSERT INTO portuguese_index VALUES ("obstinadamente","NULL","NULL","NULL","r#00198845");
INSERT INTO portuguese_index VALUES ("teimosamente","NULL","NULL","NULL","r#00198845");
INSERT INTO portuguese_index VALUES ("mitigar","NULL","v#00198850 v#00613501","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mudança_de_estado","n#00199130","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("restringir","NULL","v#00136387 v#00233203 v#00160443 v#00162075 v#00236104 v#00162692 v#00236843 v#01650267 v#01710417","NULL","NULL");
INSERT INTO portuguese_index VALUES ("refazer","NULL","v#00136514 v#01113920","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reconstruir","NULL","v#00136514 v#00428736 v#01137221","NULL","NULL");
INSERT INTO portuguese_index VALUES ("timidamente","NULL","NULL","NULL","r#00199565 r#00228910");
INSERT INTO portuguese_index VALUES ("corrigir","NULL","v#00136665 v#00426161","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retificar","NULL","v#00136665 v#00136863 v#00673648","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ajuste","n#00131083 n#07176804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modificação","n#00131083 n#03008076 n#05441797","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alteração","n#00131083 n#05441797","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rectificar","NULL","v#00136863","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tomara","NULL","NULL","NULL","r#00200243");
INSERT INTO portuguese_index VALUES ("esperançoso","NULL","NULL","NULL","r#00200243");
INSERT INTO portuguese_index VALUES ("esperançosamente","NULL","NULL","NULL","r#00200243");
INSERT INTO portuguese_index VALUES ("oxalá","NULL","NULL","NULL","r#00200243");
INSERT INTO portuguese_index VALUES ("redigir","NULL","v#00137111 v#00671763","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_esperanças","NULL","NULL","NULL","r#00200614");
INSERT INTO portuguese_index VALUES ("expurgar","NULL","v#00201034","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abreviar","NULL","v#00201034 v#00243749 v#00166656 v#00167181 v#00201632 v#00317241","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passagem","n#00131763 n#02176672 n#02504113 n#03092682 n#04824319 n#04824539 n#04892853 n#07310642","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transição","n#00131763 n#00201397 n#04825097 n#05480908 n#05519358","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("brutalmente","NULL","NULL","NULL","r#00201195");
INSERT INTO portuguese_index VALUES ("de_forma_brutal","NULL","NULL","NULL","r#00201195");
INSERT INTO portuguese_index VALUES ("interpolar","NULL","v#00201407 v#00642644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sabiamente","NULL","NULL","NULL","r#00201570");
INSERT INTO portuguese_index VALUES ("transferência","n#00132095 n#00204553 n#00718330 n#06247181","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inverso","NULL","NULL","a#00201961 a#00202115 a#01877763 a#02270178 a#02467982","NULL");
INSERT INTO portuguese_index VALUES ("inteligentemente","NULL","NULL","NULL","r#00202028");
INSERT INTO portuguese_index VALUES ("de_forma_inteligente","NULL","NULL","NULL","r#00202028");
INSERT INTO portuguese_index VALUES ("oposição","n#00132311 n#00757904 n#08404188 n#09960784 n#09981153","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Lockout","n#00202620","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resistência","n#00132807 n#00757531","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reação","n#00132807 n#00551220","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_ordem_alfabética","NULL","NULL","NULL","r#00202833");
INSERT INTO portuguese_index VALUES ("alfabeticamente","NULL","NULL","NULL","r#00202833");
INSERT INTO portuguese_index VALUES ("diplomaticamente","NULL","NULL","NULL","r#00203201");
INSERT INTO portuguese_index VALUES ("abusar","NULL","v#00139258 v#01715663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rejeição","n#00133315 n#04463201 n#11505318","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evitação","n#00203753","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sorteio","n#00203753","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_indefinida","NULL","NULL","NULL","r#00203783");
INSERT INTO portuguese_index VALUES ("indefinidamente","NULL","NULL","NULL","r#00203783");
INSERT INTO portuguese_index VALUES ("decair","NULL","v#00139555 v#00139972 v#00399074","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_correta","NULL","NULL","NULL","r#00203922");
INSERT INTO portuguese_index VALUES ("corretamente","NULL","NULL","NULL","r#00203922");
INSERT INTO portuguese_index VALUES ("erroneamente","NULL","NULL","NULL","r#00204125");
INSERT INTO portuguese_index VALUES ("incorretamente","NULL","NULL","NULL","r#00204125 r#00336065");
INSERT INTO portuguese_index VALUES ("tímido","NULL","NULL","a#00204494 a#00331296","NULL");
INSERT INTO portuguese_index VALUES ("recatado","NULL","NULL","a#00204494 a#01476902","NULL");
INSERT INTO portuguese_index VALUES ("abandono","n#00134056","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desamparo","n#00134056","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_acurada","NULL","NULL","NULL","r#00204523");
INSERT INTO portuguese_index VALUES ("justamente","NULL","NULL","NULL","r#00204523 r#00204798 r#00205226 r#00368287");
INSERT INTO portuguese_index VALUES ("apostasia","n#00204814 n#10342469","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_errada","NULL","NULL","NULL","r#00204906");
INSERT INTO portuguese_index VALUES ("de_forma_injusta","NULL","NULL","NULL","r#00204906");
INSERT INTO portuguese_index VALUES ("renúncia","n#00134568 n#00139061 n#00139768 n#04887366 n#05384981 n#05414101 n#05414335 n#05414453 n#10342469","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espevitada","NULL","NULL","a#00205511","NULL");
INSERT INTO portuguese_index VALUES ("atrevido","NULL","NULL","a#00205511 a#02169249","NULL");
INSERT INTO portuguese_index VALUES ("impertinente","NULL","NULL","a#00205511 a#02169249","NULL");
INSERT INTO portuguese_index VALUES ("injustamente","NULL","NULL","NULL","r#00205561 r#00285266");
INSERT INTO portuguese_index VALUES ("abnegação","n#00134937 n#01205961","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("presunçoso","NULL","NULL","a#00205696 a#00330582 a#00589448 a#01818024","NULL");
INSERT INTO portuguese_index VALUES ("aperfeiçoar","NULL","v#00140937 v#00329781 v#00329953","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forfeit","n#00135125","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Boicotes","n#00206130","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("boicote","n#00206130","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proscrição","n#00206302","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("banimento","n#00206302 n#14427633","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem","NULL","NULL","NULL","r#00206749 r#00462520");
INSERT INTO portuguese_index VALUES ("exclusão","n#00135765 n#00254500 n#04409604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("financeiramente","NULL","NULL","NULL","r#00207127");
INSERT INTO portuguese_index VALUES ("melhorar_algo_antigo_ou_ultrapassado","NULL","v#00207184","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deportação","n#00207306 n#00136174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ostracismo","n#00207434 n#14427633","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("individualmente","NULL","NULL","NULL","r#00207668");
INSERT INTO portuguese_index VALUES ("em_separado","NULL","NULL","NULL","r#00207668");
INSERT INTO portuguese_index VALUES ("separadamente","NULL","NULL","NULL","r#00207668");
INSERT INTO portuguese_index VALUES ("baratear","NULL","v#00207728","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desvalorizar","NULL","v#00207728 v#00315020 v#00493703 v#00493929","NULL","NULL");
INSERT INTO portuguese_index VALUES ("barganhar","NULL","v#00207728 v#02259547","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebaixar","NULL","v#00207728 v#01228249 v#01800422 v#01228705 v#01343131","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exílio","n#00136174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emendar","NULL","v#00142397 v#00177962 v#00673648","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resolver","NULL","v#00208055 v#00429256 v#00429804 v#00471542 v#00472610 v#00472976 v#00497027","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Captividade_Babilônica","n#00208141","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agravar","NULL","v#00142648","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exacerbar","NULL","v#00142648 v#01242326","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excomunhão","n#00208277 n#14413993","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proeminentemente","NULL","NULL","NULL","r#00208390");
INSERT INTO portuguese_index VALUES ("sobreposto","NULL","NULL","a#00208749","NULL");
INSERT INTO portuguese_index VALUES ("superposto","NULL","NULL","a#00208749","NULL");
INSERT INTO portuguese_index VALUES ("deposição","n#00208943","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deposição_(poluição)","n#00208943","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suspensão","n#00136859 n#00657170 n#01063578 n#03450747 n#05486628 n#10093359 n#10969750","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cordialmente","NULL","NULL","NULL","r#00209381 r#00219855 r#00432314");
INSERT INTO portuguese_index VALUES ("impudentemente","NULL","NULL","NULL","r#00209518 r#00366490");
INSERT INTO portuguese_index VALUES ("desavergonhadamente","NULL","NULL","NULL","r#00209518 r#00366490");
INSERT INTO portuguese_index VALUES ("veto","n#00209546 n#05198928","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coberto_de_relva","NULL","NULL","a#00209620","NULL");
INSERT INTO portuguese_index VALUES ("apodrecer","NULL","v#00209837 v#00399553","NULL","NULL");
INSERT INTO portuguese_index VALUES ("putrefazer","NULL","v#00209837 v#00210259 v#00399074 v#00399553 v#00552815","NULL","NULL");
INSERT INTO portuguese_index VALUES ("termino","n#00137299","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conclusão","n#00137299 n#00035222 n#04822648 n#05059980 n#05438121 n#10966461 n#10966797","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estragar","NULL","v#00210259 v#00258665 v#00263044 v#00320369 v#00332972","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suavemente","NULL","NULL","NULL","r#00210446 r#00458454");
INSERT INTO portuguese_index VALUES ("sem_problemas","NULL","NULL","NULL","r#00210446");
INSERT INTO portuguese_index VALUES ("gratuitamente","NULL","NULL","a#02399130","r#00210651 r#00258175 r#00350704");
INSERT INTO portuguese_index VALUES ("livremente","NULL","NULL","NULL","r#00210651");
INSERT INTO portuguese_index VALUES ("careca","NULL","NULL","a#00210484","NULL");
INSERT INTO portuguese_index VALUES ("calvo","NULL","NULL","a#00210484","NULL");
INSERT INTO portuguese_index VALUES ("rotineiramente","NULL","NULL","NULL","r#00210935");
INSERT INTO portuguese_index VALUES ("calvejante","NULL","NULL","a#00211026","NULL");
INSERT INTO portuguese_index VALUES ("costumeiramente","NULL","NULL","NULL","r#00211061");
INSERT INTO portuguese_index VALUES ("imberbe","NULL","NULL","a#00211092 a#02153620","NULL");
INSERT INTO portuguese_index VALUES ("glabro","NULL","NULL","a#00211092 a#02153620","NULL");
INSERT INTO portuguese_index VALUES ("culminação","n#00035222 n#15291199","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("finalização","n#00035222","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depilatório","NULL","NULL","a#00211221","NULL");
INSERT INTO portuguese_index VALUES ("espiritualmente","NULL","NULL","NULL","r#00211517");
INSERT INTO portuguese_index VALUES ("indistintamente","NULL","NULL","NULL","r#00211815");
INSERT INTO portuguese_index VALUES ("peludo","NULL","NULL","a#00212173 a#02309917","NULL");
INSERT INTO portuguese_index VALUES ("peluda","NULL","NULL","a#00212173","NULL");
INSERT INTO portuguese_index VALUES ("aposentadoria","n#00138644 n#10054148","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conservar","NULL","v#00145116 v#01522764 v#01829600 v#02682567","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preservar","NULL","v#00145116 v#01522764","NULL","NULL");
INSERT INTO portuguese_index VALUES ("canção_do_cisne","n#00212678","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desidratar","NULL","v#00212790","NULL","NULL");
INSERT INTO portuguese_index VALUES ("periodicamente","NULL","NULL","NULL","r#00212974");
INSERT INTO portuguese_index VALUES ("cessão","n#00213052","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salgar","NULL","v#00213223 v#00213353 v#02196214","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incrivelmente","NULL","NULL","NULL","r#00213301 r#00244787 r#00295825");
INSERT INTO portuguese_index VALUES ("extradição","n#00213482","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impressionantemente","NULL","NULL","NULL","r#00213524");
INSERT INTO portuguese_index VALUES ("desistência","n#00139768","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enlatar","NULL","v#00213794","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pôr_em_conserva","NULL","v#00213794","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imunidade","n#00213903 n#05033906 n#14526764 n#14527171","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hidratar","NULL","v#00214020 v#00214407 v#00215800","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_extravagante","NULL","NULL","NULL","r#00214554");
INSERT INTO portuguese_index VALUES ("copiosamente","NULL","NULL","NULL","r#00214554");
INSERT INTO portuguese_index VALUES ("de_forma_copiosa","NULL","NULL","NULL","r#00214554");
INSERT INTO portuguese_index VALUES ("abundantemente","NULL","NULL","NULL","r#00214554 r#00279867");
INSERT INTO portuguese_index VALUES ("interessantemente","NULL","NULL","NULL","r#00214761");
INSERT INTO portuguese_index VALUES ("molhar","NULL","v#00146425 v#00156574","NULL","NULL");
INSERT INTO portuguese_index VALUES ("moderadamente","NULL","NULL","NULL","r#00215237");
INSERT INTO portuguese_index VALUES ("de_forma_realista","NULL","NULL","NULL","r#00215517");
INSERT INTO portuguese_index VALUES ("de_forma_não_realista","NULL","NULL","NULL","r#00215661");
INSERT INTO portuguese_index VALUES ("deitarporterra","n#00215683","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("umidificar","NULL","v#00215800","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subversão","n#00215838","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protelação","n#00216038","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demissão","n#00140714 n#07254456","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demolhar","NULL","v#00147396","NULL","NULL");
INSERT INTO portuguese_index VALUES ("supremamente","NULL","NULL","NULL","r#00216485");
INSERT INTO portuguese_index VALUES ("lanoso","NULL","NULL","a#00216668 a#01154351","NULL");
INSERT INTO portuguese_index VALUES ("expurgo","n#00216834","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desconsideradamente","NULL","NULL","NULL","r#00216964");
INSERT INTO portuguese_index VALUES ("devastação","n#00141128 n#00967157 n#05465992 n#10441658","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destruição","n#00141128 n#05465405 n#10442122","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("barbado","NULL","NULL","a#00217075","NULL");
INSERT INTO portuguese_index VALUES ("barbudo","NULL","NULL","a#00217075","NULL");
INSERT INTO portuguese_index VALUES ("pensativamente","NULL","NULL","NULL","r#00217105");
INSERT INTO portuguese_index VALUES ("inundar","NULL","v#00148162 v#00148514 v#01047899","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desastre","n#00141434 n#05452645 n#10384515","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bela","NULL","NULL","a#00215099","NULL");
INSERT INTO portuguese_index VALUES ("bonito","NULL","NULL","a#00215099 a#00216235 a#00217241","NULL");
INSERT INTO portuguese_index VALUES ("lindo","NULL","NULL","a#00215099 a#00216139","NULL");
INSERT INTO portuguese_index VALUES ("belo","NULL","NULL","a#00215099 a#00215694","NULL");
INSERT INTO portuguese_index VALUES ("formoso","NULL","NULL","a#00215099 a#00217004","NULL");
INSERT INTO portuguese_index VALUES ("ruína","n#00141690 n#03261457 n#05465857 n#09735054 n#14423870","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("umedecer","NULL","v#00148644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obliteração","n#00141958","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ressecar","NULL","v#00148928","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estorricar","NULL","v#00148928","NULL","NULL");
INSERT INTO portuguese_index VALUES ("secar","NULL","v#00149082 v#00149731 v#02771756","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enxugar","NULL","v#00149082 v#00955030 v#00956334","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_cortês","NULL","NULL","NULL","r#00218479");
INSERT INTO portuguese_index VALUES ("educadamente","NULL","NULL","NULL","r#00218479 r#00491150");
INSERT INTO portuguese_index VALUES ("extraordinário","NULL","NULL","a#00216044 a#00488857 a#00457241 a#00918492 a#01616002 a#02343762","NULL");
INSERT INTO portuguese_index VALUES ("admiravelmente","NULL","NULL","NULL","r#00218886");
INSERT INTO portuguese_index VALUES ("de_forma_admirável","NULL","NULL","NULL","r#00218886");
INSERT INTO portuguese_index VALUES ("admirávelmente","NULL","NULL","NULL","r#00218886");
INSERT INTO portuguese_index VALUES ("de_bom_aspecto","NULL","NULL","a#00216235","NULL");
INSERT INTO portuguese_index VALUES ("bem_parecido","NULL","NULL","a#00216235","NULL");
INSERT INTO portuguese_index VALUES ("homicídio","n#00142607 n#00220023 n#00143589 n#07361576","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("morte","n#00142607 n#00143188 n#07332956 n#05465037 n#05479076 n#07203851 n#07788946 n#10060259 n#10442122 n#10867742 n#10867885","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assassinato","n#00142607 n#00143589 n#00808183","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lubrificar","NULL","v#00219012 v#01269379","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esplêndido","NULL","NULL","a#00216656","NULL");
INSERT INTO portuguese_index VALUES ("magnífico","NULL","NULL","a#00216656 a#00216900 a#01125154 a#01232112 a#01617066 a#02231628 a#02232109 a#02382040","NULL");
INSERT INTO portuguese_index VALUES ("glorioso","NULL","NULL","a#00216656 a#01073959","NULL");
INSERT INTO portuguese_index VALUES ("maravilhoso","NULL","NULL","a#00216656 a#00217004 a#01520738 a#01617066","NULL");
INSERT INTO portuguese_index VALUES ("invertido","NULL","NULL","NULL","r#00219641");
INSERT INTO portuguese_index VALUES ("de_cabeça_pra_baixo","NULL","NULL","NULL","r#00219641");
INSERT INTO portuguese_index VALUES ("ponta-cabeça","NULL","NULL","NULL","r#00219641");
INSERT INTO portuguese_index VALUES ("virado","NULL","NULL","NULL","r#00219641");
INSERT INTO portuguese_index VALUES ("lindíssimo","NULL","NULL","a#00216900","NULL");
INSERT INTO portuguese_index VALUES ("pulcro","NULL","NULL","a#00217004","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_cordial","NULL","NULL","NULL","r#00219855");
INSERT INTO portuguese_index VALUES ("eutanásia","n#00219856","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pitoresca","NULL","NULL","a#00217101 a#00379575","NULL");
INSERT INTO portuguese_index VALUES ("pitoresco","NULL","NULL","a#00217101 a#00379575","NULL");
INSERT INTO portuguese_index VALUES ("abrir","NULL","v#00150029 v#00377600 v#00920424 v#00921157 v#01348705 v#01087519 v#02140630 v#01651336 v#01651770","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desligar","NULL","v#00220276 v#01037483","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_ambígua","NULL","NULL","NULL","r#00220323");
INSERT INTO portuguese_index VALUES ("ambiguamente","NULL","NULL","NULL","r#00220323");
INSERT INTO portuguese_index VALUES ("com_equívocos","NULL","NULL","NULL","r#00220323");
INSERT INTO portuguese_index VALUES ("equivocadamente","NULL","NULL","NULL","r#00220323");
INSERT INTO portuguese_index VALUES ("Homicidio","n#00220409","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_modo_inequívoco","NULL","NULL","NULL","r#00220490");
INSERT INTO portuguese_index VALUES ("inequivocadamente","NULL","NULL","NULL","r#00220490");
INSERT INTO portuguese_index VALUES ("sem_equívocos","NULL","NULL","NULL","r#00220490");
INSERT INTO portuguese_index VALUES ("de_forma_não_ambígua","NULL","NULL","NULL","r#00220490");
INSERT INTO portuguese_index VALUES ("assassínio","n#00143589","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homicídio_doloso","n#00143589","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("debilitar","NULL","v#00150648 v#00154952 v#00255389 v#00270123 v#00389856","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fortalecer","NULL","v#00150780 v#00151781","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fortificar","n#05635624","v#00150780 v#01606205","NULL","NULL");
INSERT INTO portuguese_index VALUES ("feia","NULL","NULL","a#00218061","NULL");
INSERT INTO portuguese_index VALUES ("feio","NULL","NULL","a#00218061","NULL");
INSERT INTO portuguese_index VALUES ("Assassinatos","n#00808183","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("massacre","n#00143925 n#00808655 n#00224260","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sangue_coagulado","n#00143925 n#05401753","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grotesco","NULL","NULL","a#00218557 a#01214625","NULL");
INSERT INTO portuguese_index VALUES ("monstruoso","NULL","NULL","a#00218557 a#02514380","NULL");
INSERT INTO portuguese_index VALUES ("matricida","n#00221819","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("matricídio","n#00221819","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confirmar","NULL","v#00221840 v#00449252 v#00820352 v#00892698 v#00684589 v#01687336 v#01816870","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fratricídio","n#00221981","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reforçar","NULL","v#00151901 v#00535030","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suicídio","n#00144739","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fielmente","NULL","NULL","NULL","r#00223395");
INSERT INTO portuguese_index VALUES ("benfeitor","NULL","NULL","a#00223802","NULL");
INSERT INTO portuguese_index VALUES ("violentamente","NULL","NULL","NULL","r#00223859");
INSERT INTO portuguese_index VALUES ("assassinato_em_massa","n#00808655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carnificina","n#00808655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assassínio_em_massa","n#00808655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("matança_do_porco","n#00808655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Assassínio_em_massa","n#00808655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abate_de_animais","n#00808655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("banho_de_sangue","n#00224260","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maligno","NULL","NULL","a#00224515 a#00227003 a#02594714","NULL");
INSERT INTO portuguese_index VALUES ("malvado","NULL","NULL","a#00224515 a#00225912 a#01083652 a#01193200 a#01964360 a#02394260","NULL");
INSERT INTO portuguese_index VALUES ("linchamento","n#00224599","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("linchagem","n#00224599","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desvaneça-se","NULL","v#00224651","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maldoso","NULL","NULL","a#00224731 a#00225099","NULL");
INSERT INTO portuguese_index VALUES ("malicioso","NULL","NULL","a#00224731","NULL");
INSERT INTO portuguese_index VALUES ("perverso","NULL","NULL","a#00224731","NULL");
INSERT INTO portuguese_index VALUES ("envenenamento","n#00224738","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("envenenamentos","n#00224738","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infinitamente","NULL","NULL","NULL","r#00224941 r#00225264");
INSERT INTO portuguese_index VALUES ("Regicidas","n#00225070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regicídio","n#00225070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Regicídio","n#00225070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("malévolo","NULL","NULL","a#00225099","NULL");
INSERT INTO portuguese_index VALUES ("danoso","NULL","NULL","a#00225099 a#01982806 a#01161984","NULL");
INSERT INTO portuguese_index VALUES ("malevolente","NULL","NULL","a#00225564","NULL");
INSERT INTO portuguese_index VALUES ("afogamento","n#00225593","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estrangulamento","n#00225786","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inutilizar","NULL","v#00225832","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perversa","NULL","NULL","a#00225912 a#01138610","NULL");
INSERT INTO portuguese_index VALUES ("calúnia","n#01220336 n#06720600","NULL","a#00225912","NULL");
INSERT INTO portuguese_index VALUES ("diluir","NULL","v#00154752 v#00487748","NULL","NULL");
INSERT INTO portuguese_index VALUES ("venenoso","NULL","NULL","a#00226105 a#00790359 a#02449952 a#02329912","NULL");
INSERT INTO portuguese_index VALUES ("espasmo","n#00226107 n#14360459","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cautelosamente","NULL","NULL","NULL","r#00226133 r#00282103");
INSERT INTO portuguese_index VALUES ("rarefazer","NULL","v#00154952","NULL","NULL");
INSERT INTO portuguese_index VALUES ("broncospasmo","n#00226511","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("broncoespasmo","n#00226511","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intensificar","NULL","v#00226566 v#00227165 v#00263904 v#00290302","NULL","NULL");
INSERT INTO portuguese_index VALUES ("benigno","NULL","NULL","a#00226618 a#01372568 a#01372773 a#02594565","NULL");
INSERT INTO portuguese_index VALUES ("caluníe","NULL","NULL","a#00227003","NULL");
INSERT INTO portuguese_index VALUES ("anormalmente","NULL","NULL","NULL","r#00227171");
INSERT INTO portuguese_index VALUES ("raivosamente","NULL","NULL","NULL","r#00227323");
INSERT INTO portuguese_index VALUES ("Roubo_de_carro","n#00227484","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("melhor","NULL","NULL","a#00224964 a#00228339","NULL");
INSERT INTO portuguese_index VALUES ("sacrifício","n#00147781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacrificio","n#00147781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hecatombe","n#00227848","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletrocução","n#00228078","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("electrocussão","n#00228078","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pessoas_executadas_por_decapitação","n#00228181","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decapitação","n#00228181 n#01165224","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irrigar","NULL","v#00156574","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regar","NULL","v#00156574 v#00156978 v#01184333","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abolição","n#00228283","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abolimento","n#00228283","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deliciosamente","NULL","NULL","NULL","r#00228546");
INSERT INTO portuguese_index VALUES ("de_forma_deliciosa","NULL","NULL","NULL","r#00228546");
INSERT INTO portuguese_index VALUES ("ótimo","NULL","NULL","a#00228645","NULL");
INSERT INTO portuguese_index VALUES ("óptimo","NULL","NULL","a#00228645","NULL");
INSERT INTO portuguese_index VALUES ("orvalhar","NULL","v#00156978","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aspergir","NULL","v#00156978","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mentalmente","NULL","NULL","NULL","r#00228724");
INSERT INTO portuguese_index VALUES ("distilar","NULL","v#00229026","NULL","NULL");
INSERT INTO portuguese_index VALUES ("purificar","NULL","v#00229026 v#00475183 v#00475647 v#00475819","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destilar","NULL","v#00229026 v#00229280 v#00364868 v#00475183","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fechamento","n#00148822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encerramento","n#00148822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tranqüilamente","NULL","NULL","NULL","r#00229399");
INSERT INTO portuguese_index VALUES ("quietamente","NULL","NULL","NULL","r#00229399");
INSERT INTO portuguese_index VALUES ("tornar_mais_potente","NULL","v#00229801","NULL","NULL");
INSERT INTO portuguese_index VALUES ("potencializar","NULL","v#00229801","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extinção","n#00229934 n#05758692 n#05464067 n#13478342 n#13963032 n#14012173","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprimorar","NULL","v#00157745","NULL","NULL");
INSERT INTO portuguese_index VALUES ("o_mais_baixo","NULL","NULL","a#01434973","NULL");
INSERT INTO portuguese_index VALUES ("desaparecimento","n#00230172","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interiormente","NULL","NULL","NULL","r#00230189");
INSERT INTO portuguese_index VALUES ("péssimo","NULL","NULL","a#00230208","NULL");
INSERT INTO portuguese_index VALUES ("abortamento","n#00149581 n#05456093","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abortação","n#00149581","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("externamente","NULL","NULL","NULL","r#00230331 r#00249300");
INSERT INTO portuguese_index VALUES ("aborto_espontâneo","n#00149696","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Aborto_espontâneo","n#00149696","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("óbito_fetal","n#00149696","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impecavelmente","NULL","NULL","NULL","r#00230996");
INSERT INTO portuguese_index VALUES ("sem_falhas","NULL","NULL","NULL","r#00230996");
INSERT INTO portuguese_index VALUES ("solidamente","NULL","NULL","NULL","r#00231138 r#00231336");
INSERT INTO portuguese_index VALUES ("anulação","n#00231567 n#00231887 n#01240979","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("voluntariamente","NULL","NULL","NULL","r#00231765 r#00305283");
INSERT INTO portuguese_index VALUES ("voluntàriamente","NULL","NULL","NULL","r#00231765");
INSERT INTO portuguese_index VALUES ("ab-rogação","n#00231887","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_saudável","NULL","NULL","a#00231963","NULL");
INSERT INTO portuguese_index VALUES ("geograficamente","NULL","NULL","NULL","r#00232172");
INSERT INTO portuguese_index VALUES ("vegetar","NULL","v#00232225 v#02615580","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cancelamento","n#00232386 n#07207142","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cruelmente","NULL","NULL","NULL","r#00232425");
INSERT INTO portuguese_index VALUES ("vagamente","NULL","NULL","NULL","r#00232600");
INSERT INTO portuguese_index VALUES ("estorno","n#00232604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crescer_exageradamente","NULL","v#00232714","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crescer_até_cobrir","NULL","v#00232714","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corretivo","NULL","NULL","a#00232754","NULL");
INSERT INTO portuguese_index VALUES ("rescisão","n#00232863","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reduzir","NULL","v#00160197 v#00236999 v#00164725 v#00167689 v#00182537 v#00298808 v#00429968 v#00439958 v#00308251 v#00308615 v#01228705","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bicameral","NULL","NULL","a#00233263","NULL");
INSERT INTO portuguese_index VALUES ("conter","NULL","v#00160443 v#01516187 v#01648949 v#01793793 v#01794033 v#01796443 v#01798079 v#01842330 v#02701210","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limitar","NULL","v#00160443 v#00162075 v#00162692 v#01710417 v#01711244","NULL","NULL");
INSERT INTO portuguese_index VALUES ("neutralização","n#00233386 n#00234423 n#00234675 n#13521072","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bidirecional","NULL","NULL","a#00233442","NULL");
INSERT INTO portuguese_index VALUES ("dentre","NULL","NULL","NULL","r#00233573");
INSERT INTO portuguese_index VALUES ("desativação","n#00233614","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delimitar","NULL","v#00161497 v#00495195 v#01837761","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marcar","NULL","v#00161497 v#00353042 v#00511040 v#00612612 v#00654568 v#00679088","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inversão","n#00152824 n#07802115","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reversão","n#00152824 n#00222304","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("início","n#00153241 n#00153747 n#05437768 n#05459242 n#07325990 n#10965545","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("começo","n#00153241 n#04515071 n#05437768 n#05458618 n#05459242 n#07325990 n#10965545","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("com_eficiência","NULL","NULL","NULL","r#00235843");
INSERT INTO portuguese_index VALUES ("de_forma_eficiente","NULL","NULL","NULL","r#00235843");
INSERT INTO portuguese_index VALUES ("obstruir","NULL","v#00162509 v#00210685 v#02557199","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impedir","NULL","v#00162509 v#00362765 v#01669882 v#01670590 v#01671583","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estorvar","NULL","v#00162509 v#01670590 v#01671583","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_charmosa","NULL","NULL","NULL","r#00236763");
INSERT INTO portuguese_index VALUES ("com_charme","NULL","NULL","NULL","r#00236763");
INSERT INTO portuguese_index VALUES ("charmosamente","NULL","NULL","NULL","r#00236763");
INSERT INTO portuguese_index VALUES ("ativação","n#00236821","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("activação","n#00236821","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("unilateral","NULL","NULL","a#00236989 a#01417105","NULL");
INSERT INTO portuguese_index VALUES ("ferver","NULL","v#00236999 v#00227567 v#00261276 v#00519363","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estabelecimento","n#00154800","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("organização","n#00154800 n#00650412 n#00737011 n#04768657 n#04423455 n#05997592 n#05999585 n#06071657 n#06239374","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("constituição","n#00154800 n#03860186 n#04905119","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_preocupante","NULL","NULL","NULL","r#00237423");
INSERT INTO portuguese_index VALUES ("concentrar","NULL","v#00163258","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conscientemente","NULL","NULL","NULL","r#00237636 r#00242663");
INSERT INTO portuguese_index VALUES ("bilateral","NULL","NULL","a#00237788 a#01946012 a#02372118","NULL");
INSERT INTO portuguese_index VALUES ("subconscientemente","NULL","NULL","NULL","r#00237833 r#00245716");
INSERT INTO portuguese_index VALUES ("inconscientemente","NULL","NULL","NULL","r#00237833 r#00245716");
INSERT INTO portuguese_index VALUES ("desoxidar","NULL","v#00237877","NULL","NULL");
INSERT INTO portuguese_index VALUES ("primeira_aparição","n#00155548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("introdução","n#00155548 n#00153747 n#00207301 n#04834552","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apresentação","n#00155548 n#00335147 n#00336149 n#00359430 n#02580524 n#05156002 n#05256705 n#05359169 n#05391158 n#07217579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("catabolizar","NULL","v#00238720","NULL","NULL");
INSERT INTO portuguese_index VALUES ("oxidar","NULL","v#00238867 v#00239321","NULL","NULL");
INSERT INTO portuguese_index VALUES ("a_pé","NULL","NULL","NULL","r#00239064");
INSERT INTO portuguese_index VALUES ("andando","NULL","NULL","NULL","r#00239064");
INSERT INTO portuguese_index VALUES ("iniciativa","n#00156102 n#03790844","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pedra_Fundamental","n#00239483","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pedra_fundamental","n#00239483 n#03110470","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enferrujar","NULL","v#00239614","NULL","NULL");
INSERT INTO portuguese_index VALUES ("oxidar-se","NULL","v#00239614","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_massa","NULL","NULL","NULL","r#00239688 r#00395574");
INSERT INTO portuguese_index VALUES ("irresistivelmente","NULL","NULL","NULL","r#00239688");
INSERT INTO portuguese_index VALUES ("esmagadoramente","NULL","NULL","NULL","r#00239688");
INSERT INTO portuguese_index VALUES ("triangular","NULL","v#00646912","a#00239847 a#02049428","NULL");
INSERT INTO portuguese_index VALUES ("cada_uma","NULL","NULL","NULL","r#00239908");
INSERT INTO portuguese_index VALUES ("cada_um","NULL","NULL","NULL","r#00239908");
INSERT INTO portuguese_index VALUES ("inauguração","n#00239910 n#00243373 n#05540966","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tripartido","NULL","NULL","a#00240008","NULL");
INSERT INTO portuguese_index VALUES ("tornar_menor","NULL","v#00164129","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fundação","n#00153747 n#06216338","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criação","n#00153747 n#00583085 n#00587652 n#02518101 n#02858828 n#05461527 n#06691078","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instituição","n#00153747 n#02859290 n#06002286 n#06217164","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bimodal","NULL","NULL","a#00240197","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_analítica","NULL","NULL","NULL","r#00240533");
INSERT INTO portuguese_index VALUES ("analiticamente","NULL","NULL","NULL","r#00240533");
INSERT INTO portuguese_index VALUES ("murchar","NULL","v#00164388 v#00241689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contrair-se","NULL","v#00164388 v#02032934","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_anárquica","NULL","NULL","NULL","r#00240865");
INSERT INTO portuguese_index VALUES ("anarquicamente","NULL","NULL","NULL","r#00240865");
INSERT INTO portuguese_index VALUES ("prestação","n#00153919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instalação","n#00153919 n#02661119 n#03564342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ficar_menor","NULL","v#00164725","NULL","NULL");
INSERT INTO portuguese_index VALUES ("binucleado","NULL","NULL","a#00241260","NULL");
INSERT INTO portuguese_index VALUES ("suspeitosamente","NULL","NULL","NULL","r#00241272");
INSERT INTO portuguese_index VALUES ("mononuclear","NULL","NULL","a#00241397","NULL");
INSERT INTO portuguese_index VALUES ("bípede","NULL","NULL","a#00241672","NULL");
INSERT INTO portuguese_index VALUES ("enrugar","NULL","v#00241689 v#00871417 v#01277784 v#01278427","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quadrúpede","NULL","NULL","a#00241816","NULL");
INSERT INTO portuguese_index VALUES ("retomada","n#00242003","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afro-americano","n#09637013","NULL","a#00242293","NULL");
INSERT INTO portuguese_index VALUES ("beligerantemente","NULL","NULL","NULL","r#00242478");
INSERT INTO portuguese_index VALUES ("consolidar-se","NULL","v#00242580","NULL","NULL");
INSERT INTO portuguese_index VALUES ("casualmente","NULL","NULL","NULL","r#00243086 r#00263893");
INSERT INTO portuguese_index VALUES ("unificar","NULL","v#00166362 v#00257011 v#01682716","NULL","NULL");
INSERT INTO portuguese_index VALUES ("branca","NULL","NULL","a#00239024","NULL");
INSERT INTO portuguese_index VALUES ("caucasóide","NULL","NULL","a#00239024","NULL");
INSERT INTO portuguese_index VALUES ("caucasiana","n#06962503","NULL","a#00239024 a#00243395","NULL");
INSERT INTO portuguese_index VALUES ("caucasiano","n#06962503","NULL","a#00239024 a#00243395","NULL");
INSERT INTO portuguese_index VALUES ("branco","n#03877535 n#06962503 n#09641002","NULL","a#00239024 a#00367747","NULL");
INSERT INTO portuguese_index VALUES ("flavo","NULL","NULL","a#00239414","NULL");
INSERT INTO portuguese_index VALUES ("loiro","NULL","NULL","a#00239414","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_compulsiva","NULL","NULL","NULL","r#00243608");
INSERT INTO portuguese_index VALUES ("compulsivamente","NULL","NULL","NULL","r#00243608");
INSERT INTO portuguese_index VALUES ("obsessivamente","NULL","NULL","NULL","r#00243608");
INSERT INTO portuguese_index VALUES ("encurtar","NULL","v#00243749 v#00166656 v#00219644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("condensar","NULL","v#00166656 v#00167181 v#00364868 v#00366547","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resumir","NULL","v#00166656 v#00681575 v#02752695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("culinária","n#00243918 n#05626343","NULL","a#02707659","NULL");
INSERT INTO portuguese_index VALUES ("cozinha","n#00243918 n#02495933 n#02890846 n#03422865 n#05626343 n#07572206","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preparação","n#00243918 n#00574678 n#01143040 n#00741586 n#14031108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para_o_sul","NULL","NULL","NULL","r#00243938");
INSERT INTO portuguese_index VALUES ("para_o_norte","NULL","NULL","NULL","r#00244043");
INSERT INTO portuguese_index VALUES ("cor_de_linho","NULL","NULL","a#01097044","NULL");
INSERT INTO portuguese_index VALUES ("marronícoma","NULL","NULL","a#00240276","NULL");
INSERT INTO portuguese_index VALUES ("de_cabelo_castanho","NULL","NULL","a#00240276","NULL");
INSERT INTO portuguese_index VALUES ("castanícoma","NULL","NULL","a#00240276","NULL");
INSERT INTO portuguese_index VALUES ("fuscícoma","NULL","NULL","a#00240276","NULL");
INSERT INTO portuguese_index VALUES ("obscurícoma","NULL","NULL","a#00240276","NULL");
INSERT INTO portuguese_index VALUES ("brunícoma","NULL","NULL","a#00240276","NULL");
INSERT INTO portuguese_index VALUES ("morena","n#06748679 n#09877856","NULL","a#00240276","NULL");
INSERT INTO portuguese_index VALUES ("acreditavelmente","NULL","NULL","NULL","r#00244641 r#00296131");
INSERT INTO portuguese_index VALUES ("inacreditavelmente","NULL","NULL","NULL","r#00244787 r#00295825");
INSERT INTO portuguese_index VALUES ("bronzeado","n#14290534","NULL","a#00240704 a#00371945","NULL");
INSERT INTO portuguese_index VALUES ("declinar","NULL","v#00167516 v#01531148","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descer","NULL","v#00167516 v#00301476 v#01970646 v#01341375 v#01978576","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escuro","NULL","NULL","a#00240868 a#00268709 a#00269848 a#00270492 a#00354187 a#00354536 a#00380983","NULL");
INSERT INTO portuguese_index VALUES ("deprivar","NULL","v#00167689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embotar","NULL","v#00167689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desprover","NULL","v#00167689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deprimir","NULL","v#00167689 v#01238101 v#01240960","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ferozmente","NULL","NULL","NULL","r#00245402");
INSERT INTO portuguese_index VALUES ("escareado","NULL","NULL","a#00245860","NULL");
INSERT INTO portuguese_index VALUES ("irmanar","NULL","v#00167983","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irmanar-se","NULL","v#00167983","NULL","NULL");
INSERT INTO portuguese_index VALUES ("duplicar","NULL","v#00246217","NULL","NULL");
INSERT INTO portuguese_index VALUES ("multiplicar","NULL","v#00246217 v#00168890 v#00433261","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triplicar","NULL","v#00246746","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triplicar-se","NULL","v#00246746","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grelhado","n#00246754","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("classicamente","NULL","NULL","NULL","r#00246934");
INSERT INTO portuguese_index VALUES ("fritura","n#00246940","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quadruplicar","NULL","v#00247048","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comosedeve","NULL","NULL","NULL","r#00247194");
INSERT INTO portuguese_index VALUES ("comoéjusto","NULL","NULL","NULL","r#00247194");
INSERT INTO portuguese_index VALUES ("quintuplicar","NULL","v#00247234","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caça_furtiva","n#00247342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sangrento","NULL","NULL","a#00243444","NULL");
INSERT INTO portuguese_index VALUES ("sangüíneo","NULL","NULL","a#00243444","NULL");
INSERT INTO portuguese_index VALUES ("caracteristicamente","NULL","NULL","NULL","r#00247567");
INSERT INTO portuguese_index VALUES ("contrariamente","NULL","NULL","NULL","r#00247969");
INSERT INTO portuguese_index VALUES ("ensanguentado","NULL","NULL","a#00247993","NULL");
INSERT INTO portuguese_index VALUES ("envelhecer","NULL","v#00169382 v#00169547 v#00170328","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profeticamente","NULL","NULL","NULL","r#00248249");
INSERT INTO portuguese_index VALUES ("Tempero","n#00248368","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("violento","NULL","NULL","a#00248560 a#00841934 a#01449500 a#01514141 a#01515501","NULL");
INSERT INTO portuguese_index VALUES ("avançar","NULL","v#00169694 v#01360914 v#01820991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("melhoria","n#00159157 n#00265992 n#05480347","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("melhoramento","n#00159157 n#00167494 n#00265992 n#00233535 n#13470193 n#14422751","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instintivamente","NULL","NULL","NULL","r#00249043");
INSERT INTO portuguese_index VALUES ("internamente","NULL","NULL","NULL","r#00249164");
INSERT INTO portuguese_index VALUES ("incruento","NULL","NULL","a#00249433","NULL");
INSERT INTO portuguese_index VALUES ("progresso","n#00159609 n#00159874 n#00249987 n#00182992 n#05480347 n#05489950 n#09725434","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_cima","NULL","NULL","NULL","r#00249641");
INSERT INTO portuguese_index VALUES ("avelhentar","NULL","v#00170328","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corajoso","NULL","NULL","a#00246332 a#00258473","NULL");
INSERT INTO portuguese_index VALUES ("amadurecer","NULL","v#00170483 v#00170582 v#00170705","NULL","NULL");
INSERT INTO portuguese_index VALUES ("a_bordo","NULL","NULL","NULL","r#00249878");
INSERT INTO portuguese_index VALUES ("madurar","NULL","v#00170582","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ao_longo","NULL","NULL","NULL","r#00250056");
INSERT INTO portuguese_index VALUES ("junto_a","NULL","NULL","NULL","r#00250056");
INSERT INTO portuguese_index VALUES ("aoladode","NULL","NULL","NULL","r#00250056");
INSERT INTO portuguese_index VALUES ("ao_lado_de","NULL","NULL","NULL","r#00250056");
INSERT INTO portuguese_index VALUES ("ao_lado","NULL","NULL","NULL","r#00250056");
INSERT INTO portuguese_index VALUES ("intrépido","NULL","NULL","a#01415513","NULL");
INSERT INTO portuguese_index VALUES ("fluxo_de_trabalho","n#00250143","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("uniformemente","NULL","NULL","NULL","r#00250153 r#00331194");
INSERT INTO portuguese_index VALUES ("desenvolvimento","n#00160202 n#00606479","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("temerário","NULL","NULL","a#00250483 a#00250739","NULL");
INSERT INTO portuguese_index VALUES ("lado_a_lado","NULL","NULL","NULL","r#00250484");
INSERT INTO portuguese_index VALUES ("ombro_a_ombro","NULL","NULL","NULL","r#00250484");
INSERT INTO portuguese_index VALUES ("achar-se","NULL","v#00250691","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encontrar-se","NULL","v#00250691 v#02612368","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elaboração","n#00160599 n#03699200 n#03743329","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Inconsequente","NULL","NULL","a#00250739","NULL");
INSERT INTO portuguese_index VALUES ("limpeza","n#00160717 n#03834628 n#13990389 n#10399525","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evoluir","NULL","v#00171455","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desenvolver","NULL","v#00171455 v#00252019 v#00172633 v#00381524 v#01188325 v#01188481","NULL","NULL");
INSERT INTO portuguese_index VALUES ("heróico","NULL","NULL","a#00247520 a#00259102 a#01232527 a#01332311 a#02574181","NULL");
INSERT INTO portuguese_index VALUES ("elaborar","NULL","v#00171716 v#00646817 v#01188325","NULL","NULL");
INSERT INTO portuguese_index VALUES ("a_priori","NULL","NULL","NULL","r#00251611");
INSERT INTO portuguese_index VALUES ("derivar","NULL","v#00171832 v#01797979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vir_de","NULL","v#00251791","NULL","NULL");
INSERT INTO portuguese_index VALUES ("timorato","NULL","NULL","a#00248123","NULL");
INSERT INTO portuguese_index VALUES ("tímida","NULL","NULL","a#00248426","NULL");
INSERT INTO portuguese_index VALUES ("limpeza_a_seco","n#00252169","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bilateralmente","NULL","NULL","NULL","r#00252965");
INSERT INTO portuguese_index VALUES ("dos_dois_lados","NULL","NULL","NULL","r#00252965");
INSERT INTO portuguese_index VALUES ("unilateralmente","NULL","NULL","NULL","r#00253117");
INSERT INTO portuguese_index VALUES ("acorrentado","NULL","NULL","a#00253196","NULL");
INSERT INTO portuguese_index VALUES ("depuração","n#00253270","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("catarse","n#00253395 n#00253577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descaradamente","NULL","NULL","NULL","r#00253498");
INSERT INTO portuguese_index VALUES ("esterilização_(biologia)","n#00253919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esterilização_(processo)","n#00253919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esterilização","n#00253919 n#00692130","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pagamento_na_entrega","NULL","NULL","NULL","r#00253938");
INSERT INTO portuguese_index VALUES ("no_sentido_anti-horário","NULL","NULL","NULL","r#00254059");
INSERT INTO portuguese_index VALUES ("incubar","NULL","v#00254150","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pasteurização","n#00254166","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pasteurização","n#00254166","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("solto","NULL","NULL","a#00250616 a#00469578","NULL");
INSERT INTO portuguese_index VALUES ("sentido_horário","NULL","NULL","NULL","r#00254369");
INSERT INTO portuguese_index VALUES ("Saneamento","n#00254415","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saneamento","n#00254415 n#14495466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depilação","n#00254597","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quinzenalmente","NULL","NULL","NULL","r#00254711");
INSERT INTO portuguese_index VALUES ("suavizar","NULL","v#00254867 v#00255389","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tonsura","n#00254922 n#05539717","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mensalmente","NULL","NULL","NULL","r#00254978");
INSERT INTO portuguese_index VALUES ("mensal","NULL","NULL","a#01969707","r#00254978");
INSERT INTO portuguese_index VALUES ("bimestralmente","NULL","NULL","NULL","r#00255075 r#00255181");
INSERT INTO portuguese_index VALUES ("ablução","n#00255214 n#00255450","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("banho","n#00255214 n#00165598 n#02806530","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semestralmente","NULL","NULL","NULL","r#00255315 r#00279174 r#00352816");
INSERT INTO portuguese_index VALUES ("bianualmente","NULL","NULL","NULL","r#00255315 r#00279050");
INSERT INTO portuguese_index VALUES ("abrandar","NULL","v#00255389","NULL","NULL");
INSERT INTO portuguese_index VALUES ("temperar","NULL","v#00255389 v#00203187 v#00302875 v#00303056 v#00559919 v#02191766 v#02192570","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aqui_anexo","NULL","NULL","NULL","r#00255614");
INSERT INTO portuguese_index VALUES ("inchar","NULL","v#00175034 v#00256507 v#00175935 v#00179925 v#00180220 v#00252740 v#00252877","NULL","NULL");
INSERT INTO portuguese_index VALUES ("in_situ","NULL","NULL","NULL","r#00256189");
INSERT INTO portuguese_index VALUES ("inflar-se","NULL","v#00256507","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inchar-se","NULL","v#00256507","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Xampus","n#00257115","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("xampu","n#00257115 n#04183516","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nãoencadernado","NULL","NULL","a#00257232","NULL");
INSERT INTO portuguese_index VALUES ("brochado","NULL","NULL","a#00257232","NULL");
INSERT INTO portuguese_index VALUES ("expandir","NULL","v#00175614 v#00180494 v#00305537","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chuveiro","n#00257580 n#04209383","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("três_vezes","NULL","NULL","NULL","r#00257784 r#00476680");
INSERT INTO portuguese_index VALUES ("três","n#13744044","NULL","NULL","r#00257784");
INSERT INTO portuguese_index VALUES ("em_si","NULL","NULL","NULL","r#00257864");
INSERT INTO portuguese_index VALUES ("verbatim","NULL","NULL","NULL","r#00257864");
INSERT INTO portuguese_index VALUES ("palavraporpalavra","NULL","NULL","NULL","r#00257864");
INSERT INTO portuguese_index VALUES ("ipsis_litteris","NULL","NULL","NULL","r#00257864");
INSERT INTO portuguese_index VALUES ("vazar","NULL","v#00258109 v#00529759","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grátis","NULL","NULL","a#02399130","r#00258175");
INSERT INTO portuguese_index VALUES ("de_graça","NULL","NULL","a#02399130","r#00258175");
INSERT INTO portuguese_index VALUES ("partir","NULL","v#00258665 v#01298931 v#01258127 v#01848718 v#01370454 v#01371248 v#02010400 v#02011437 v#01374895 v#01376117 v#01376459 v#01539361 v#01623741","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para_fora","NULL","NULL","NULL","r#00258677");
INSERT INTO portuguese_index VALUES ("retificação","n#00258854","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("correção","n#00258854 n#00811685 n#03768230 n#03928898","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avariar","NULL","v#00176836 v#01078962","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_cedo","NULL","NULL","a#00814611","r#00259096");
INSERT INTO portuguese_index VALUES ("reparação_(legal)","n#00259177","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retribuição","n#00259544 n#01121855 n#01234729 n#09556237","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compensação","n#00166954 n#09559232","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Compensação","n#00166954 n#09559232","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atribular","NULL","v#00259927","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afligir","NULL","v#00259927 v#01797730","NULL","NULL");
INSERT INTO portuguese_index VALUES ("otimização","n#00260051","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("optimização","n#00260051","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("magoar","NULL","v#00177802 v#01224189 v#01797347","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aperfeiçoamento","n#00167086","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perfeição","n#00167086 n#04549171 n#10374214","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mudança_para_melhor","n#00167178","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reforma","n#00167178 n#00510453","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consertar","NULL","v#00177962 v#00261705 v#00262703","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reparar","NULL","v#00177962 v#00689564","NULL","NULL");
INSERT INTO portuguese_index VALUES ("burguês","n#09869830","NULL","a#00256574 a#00256659 a#00293427","NULL");
INSERT INTO portuguese_index VALUES ("burguesa","n#09869830","NULL","a#00256574 a#00256659","NULL");
INSERT INTO portuguese_index VALUES ("reforma_agrária","n#00260881","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reforma_Agrária","n#00260881","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reforma_agraria","n#00260881","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esteticamente","NULL","NULL","NULL","r#00261231");
INSERT INTO portuguese_index VALUES ("rechear","NULL","v#00178413","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embelezamento","n#00261604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revisar","NULL","v#00178848","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ambiciosamente","NULL","NULL","NULL","r#00262206");
INSERT INTO portuguese_index VALUES ("decoração","n#00168201 n#00262596 n#00262743 n#02166920 n#02550579 n#02863365","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dolicocefálico","NULL","NULL","a#00262529","NULL");
INSERT INTO portuguese_index VALUES ("adornamento","n#00262596","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ornamento","n#00262596 n#00262743 n#02166920 n#02550579 n#02557306","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_anônima","NULL","NULL","NULL","r#00262655");
INSERT INTO portuguese_index VALUES ("anonimamente","NULL","NULL","NULL","r#00262655 r#00271152");
INSERT INTO portuguese_index VALUES ("remendar","NULL","v#00262703","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afoito","NULL","NULL","a#00258473","NULL");
INSERT INTO portuguese_index VALUES ("valoroso","NULL","NULL","a#00258473","NULL");
INSERT INTO portuguese_index VALUES ("valente","NULL","NULL","a#00258473 a#00260137","NULL");
INSERT INTO portuguese_index VALUES ("brava","NULL","NULL","a#00258473","NULL");
INSERT INTO portuguese_index VALUES ("arrojado","NULL","NULL","a#00258473","NULL");
INSERT INTO portuguese_index VALUES ("tornar_pior","NULL","v#00179295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tornar_imperfeito_ou_defeituoso","NULL","v#00263044","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criar_uma_falha_ou_defeito","NULL","v#00263044","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfigurar","NULL","v#00263044 v#00201342 v#00839492 v#01549905","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tatuagem","n#00263353 n#04395651","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intumescer","NULL","v#00179925","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afofar","NULL","v#00179925","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animoso","NULL","NULL","a#00259479","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_casual","NULL","NULL","NULL","r#00263893");
INSERT INTO portuguese_index VALUES ("amplificar","NULL","v#00263904 v#00434077","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inflar","NULL","v#00180220","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encher","NULL","v#00180220 v#00315280 v#00315864 v#00316526 v#01808536","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Clearing","n#00264192","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("CLEARING","n#00264192","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clarificação","n#00264192","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enriquecimento_(nutrientes)","n#00264366 n#13271498","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enriquecimento","n#00264366 n#13271498","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fortificação","n#00264529 n#03385557 n#05635624","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("humanização","n#00264775","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("covardemente","NULL","NULL","a#00264776","NULL");
INSERT INTO portuguese_index VALUES ("cobarde","NULL","NULL","a#00264776","NULL");
INSERT INTO portuguese_index VALUES ("covarde","n#09614047","NULL","a#00264776","NULL");
INSERT INTO portuguese_index VALUES ("acidificar","NULL","v#00264875 v#02196690","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modernização","n#00170063","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("basificar","NULL","v#00265094","NULL","NULL");
INSERT INTO portuguese_index VALUES ("renovação","n#00170245 n#00811153 n#10349313","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprimoramento","n#00265992","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrogantemente","NULL","NULL","NULL","r#00266016");
INSERT INTO portuguese_index VALUES ("de_forma_arrogante","NULL","NULL","NULL","r#00266016");
INSERT INTO portuguese_index VALUES ("pusilânime","NULL","NULL","a#00266420","NULL");
INSERT INTO portuguese_index VALUES ("ventilação_(processos_industriais)","n#00266645 n#04526520","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ventilação","n#00266645 n#04526520","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reparação","n#00171220","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conserto","n#00171220","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reparo","n#00171220 n#05068616","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("audaciosamente","NULL","NULL","NULL","r#00266955");
INSERT INTO portuguese_index VALUES ("ousadamente","NULL","NULL","NULL","r#00266955");
INSERT INTO portuguese_index VALUES ("adjectivamente","NULL","NULL","NULL","r#00267321");
INSERT INTO portuguese_index VALUES ("adverbialmente","NULL","NULL","NULL","r#00267435");
INSERT INTO portuguese_index VALUES ("eupnéico","NULL","NULL","a#00267452","NULL");
INSERT INTO portuguese_index VALUES ("manutenção","n#00171721 n#13365286 n#09625216","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dispnéico","NULL","NULL","a#00267871","NULL");
INSERT INTO portuguese_index VALUES ("amorosamente","NULL","NULL","NULL","r#00267950");
INSERT INTO portuguese_index VALUES ("de_forma_angelical","NULL","NULL","NULL","r#00268056");
INSERT INTO portuguese_index VALUES ("angelicalmente","NULL","NULL","NULL","r#00268056");
INSERT INTO portuguese_index VALUES ("recair","NULL","v#00182841","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_eloqüente","NULL","NULL","NULL","r#00268312");
INSERT INTO portuguese_index VALUES ("eloqüentemente","NULL","NULL","NULL","r#00268312 r#00327848");
INSERT INTO portuguese_index VALUES ("rapidinha","n#00268457","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paralisar","NULL","v#00183081 v#00183284 v#00183364","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atributivamente","NULL","NULL","NULL","r#00268651");
INSERT INTO portuguese_index VALUES ("entorpecer","NULL","v#00183364","NULL","NULL");
INSERT INTO portuguese_index VALUES ("audivelmente","NULL","NULL","NULL","r#00268797");
INSERT INTO portuguese_index VALUES ("gentrificação","n#00268824","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inaudivelmente","NULL","NULL","NULL","r#00268909");
INSERT INTO portuguese_index VALUES ("genuínamente","NULL","NULL","NULL","r#00269153");
INSERT INTO portuguese_index VALUES ("autenticamente","NULL","NULL","NULL","r#00269153");
INSERT INTO portuguese_index VALUES ("reconstrução","n#00173090 n#04444978 n#05363145","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desbloquear","NULL","v#00269682","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_terra","NULL","NULL","a#00269894","NULL");
INSERT INTO portuguese_index VALUES ("iluminado","NULL","NULL","a#00265852 a#00271580 a#00840779 a#01307375","NULL");
INSERT INTO portuguese_index VALUES ("circular","NULL","v#00184403 v#00656764 v#01522716 v#01911339 v#01395599","a#00676271 a#01966694","NULL");
INSERT INTO portuguese_index VALUES ("mobilizar","NULL","v#00184403 v#00184548 v#00737150 v#01097960","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convocar","NULL","v#00184548 v#00538265 v#00538841 v#00705520 v#01097960 v#01007880","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cicatrizar","NULL","v#00184775 v#01551679","NULL","NULL");
INSERT INTO portuguese_index VALUES ("oscilar","NULL","v#00184895 v#01876530","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flutuar","NULL","v#00184895 v#01465583","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Coaching","n#00270800","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estabilizar","NULL","v#00270826","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luminoso","NULL","NULL","a#00266706 a#00273770 a#00274569 a#01741423","NULL");
INSERT INTO portuguese_index VALUES ("actuação","n#00174085","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("degradação","n#00174193","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fluorescente","NULL","NULL","a#00271419 a#00403505","NULL");
INSERT INTO portuguese_index VALUES ("aceso","NULL","v#01978576","a#00271580 a#00442983","NULL");
INSERT INTO portuguese_index VALUES ("aritmeticamente","NULL","NULL","NULL","r#00271625");
INSERT INTO portuguese_index VALUES ("de_forma_aritmética","NULL","NULL","NULL","r#00271625");
INSERT INTO portuguese_index VALUES ("desumanização","n#00271636","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desestabilizar","NULL","v#00271711 v#00272177","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incandescente","NULL","NULL","a#00271813 a#01122121","NULL");
INSERT INTO portuguese_index VALUES ("firmar","NULL","v#00271946 v#00518879 v#00674118","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estabilizar-se","NULL","v#00271946","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assiduamente","NULL","NULL","NULL","r#00272305");
INSERT INTO portuguese_index VALUES ("corrupção","n#00175090 n#03801774 n#03803876 n#09734957 n#10360441 n#10441111","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fosforescente","NULL","NULL","a#00272555","NULL");
INSERT INTO portuguese_index VALUES ("dessensibilizar","NULL","v#00272683","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmoralização","n#00272713","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transversalmente","NULL","NULL","NULL","r#00272844 r#00293077");
INSERT INTO portuguese_index VALUES ("costumar","NULL","v#00186277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acostumar","NULL","v#00186277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("habituar","NULL","v#00186743","NULL","NULL");
INSERT INTO portuguese_index VALUES ("habituar-se","NULL","v#00186743","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acostumar-se","NULL","v#00186743","NULL","NULL");
INSERT INTO portuguese_index VALUES ("humilhação","n#00175673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_controle","NULL","NULL","NULL","r#00273504");
INSERT INTO portuguese_index VALUES ("instruir","NULL","v#00186948 v#00407541 v#00407789 v#00508780 v#00562446 v#00562981","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ensinar","NULL","v#00186948 v#00562446 v#01626476","NULL","NULL");
INSERT INTO portuguese_index VALUES ("branqueamento","n#00273877","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corroer","NULL","v#00273963 v#00274283 v#00274724","NULL","NULL");
INSERT INTO portuguese_index VALUES ("processo_de_branqueamento","n#00274009","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negro","n#06960662 n#09637339","NULL","a#00269661 a#00367459","NULL");
INSERT INTO portuguese_index VALUES ("sombrio","NULL","NULL","a#00269661 a#00272084 a#00354187 a#00354536 a#01178561","NULL");
INSERT INTO portuguese_index VALUES ("crepuscular","NULL","NULL","a#00274551 a#00275486","NULL");
INSERT INTO portuguese_index VALUES ("erodir","NULL","v#00274724","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_maneira_feliz","NULL","NULL","NULL","r#00274842");
INSERT INTO portuguese_index VALUES ("que_causa_felicidade","NULL","NULL","NULL","r#00274842");
INSERT INTO portuguese_index VALUES ("tez","n#00274941 n#03875475 n#04976952 n#07567139","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formigando","NULL","NULL","NULL","r#00275035");
INSERT INTO portuguese_index VALUES ("dormente","n#04433585","NULL","NULL","r#00275035");
INSERT INTO portuguese_index VALUES ("pela","NULL","NULL","NULL","r#00275409");
INSERT INTO portuguese_index VALUES ("popa","n#04316646","NULL","NULL","r#00275409");
INSERT INTO portuguese_index VALUES ("tingimento","n#00275424","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Coloração","n#00275572","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regularizar","NULL","v#00275607 v#01712330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrumar","NULL","v#00188537 v#00188762 v#00818883 v#01010586","NULL","NULL");
INSERT INTO portuguese_index VALUES ("organizar","NULL","v#00188537 v#00188762 v#00280835 v#00281123 v#00480481 v#01132230 v#01134235 v#01656551 v#02434238 v#01668018","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escarranchado","NULL","NULL","NULL","r#00275974");
INSERT INTO portuguese_index VALUES ("escarranchadamente","NULL","NULL","NULL","r#00275974 r#00276076");
INSERT INTO portuguese_index VALUES ("de_cada_lado","NULL","NULL","NULL","r#00275974 r#00276076");
INSERT INTO portuguese_index VALUES ("ambientalismo","n#00276189 n#05970564","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ecologismo","n#00276189","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desorganizar","NULL","v#00276214 v#02436140","NULL","NULL");
INSERT INTO portuguese_index VALUES ("no_topo","NULL","NULL","NULL","r#00276225");
INSERT INTO portuguese_index VALUES ("tenebroso","NULL","NULL","a#00271594","NULL");
INSERT INTO portuguese_index VALUES ("bagunçar","NULL","v#00276373 v#02735142","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contaminação","n#00276620 n#00276987 n#10393527 n#14516743 n#14821984","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sombreado","NULL","NULL","a#00272084","NULL");
INSERT INTO portuguese_index VALUES ("ordenar","NULL","v#00189468 v#00190043 v#00279239 v#00506658 v#01010586","NULL","NULL");
INSERT INTO portuguese_index VALUES ("poluição","n#00276987 n#10393527 n#14516743","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antedatar","NULL","v#00277086","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perniciosamente","NULL","NULL","NULL","r#00277435 r#00378212");
INSERT INTO portuguese_index VALUES ("imersão","n#00277569 n#01038485 n#07364115 n#13557158","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impregnação","n#00277811","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enluarado","NULL","NULL","a#00278006","NULL");
INSERT INTO portuguese_index VALUES ("descalço","NULL","NULL","a#02156686","r#00278078");
INSERT INTO portuguese_index VALUES ("rearranjar","NULL","v#00278280","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reordenar","NULL","v#00278280","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irrigação","n#00178992","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vivído","NULL","NULL","a#00273770","NULL");
INSERT INTO portuguese_index VALUES ("brilhante","NULL","NULL","a#00273770 a#00274569 a#00375424 a#01281852 a#02232109","NULL");
INSERT INTO portuguese_index VALUES ("radiante","NULL","NULL","a#00273770 a#00275515","NULL");
INSERT INTO portuguese_index VALUES ("jogaráguabenta","n#00278555","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mastigação","n#00278810","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("a_cada_dois_anos","NULL","NULL","NULL","r#00279050");
INSERT INTO portuguese_index VALUES ("bienalmente","NULL","NULL","NULL","r#00279050");
INSERT INTO portuguese_index VALUES ("colocar_em_ordem_alfabética","NULL","v#00279239","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bruxismo","n#00279534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfoliação","n#00279674 n#13460034","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("oxigenar","NULL","v#00279822","NULL","NULL");
INSERT INTO portuguese_index VALUES ("traslado","n#00180278 n#04211970","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deslocamento","n#00180278 n#00213182 n#05537257","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("branquear","NULL","v#00280301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embranquecer","NULL","v#00280301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alvejar","NULL","v#00280301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("refulgente","NULL","NULL","a#00275515","NULL");
INSERT INTO portuguese_index VALUES ("deslumbrante","NULL","NULL","a#00280844","NULL");
INSERT INTO portuguese_index VALUES ("iluminar-se","NULL","v#00280930","NULL","NULL");
INSERT INTO portuguese_index VALUES ("burocraticamente","NULL","NULL","NULL","r#00280972");
INSERT INTO portuguese_index VALUES ("descolorir","NULL","v#00281101","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colorir","NULL","v#00281101 v#01163518 v#00836926 v#01163997 v#01729632","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_caprichosa","NULL","NULL","NULL","r#00281491");
INSERT INTO portuguese_index VALUES ("reluzente","NULL","NULL","a#00276849 a#01741423","NULL");
INSERT INTO portuguese_index VALUES ("faiscante","NULL","NULL","a#00276849 a#01741423","NULL");
INSERT INTO portuguese_index VALUES ("iridescente","NULL","NULL","a#00282020 a#00403072","NULL");
INSERT INTO portuguese_index VALUES ("avanço","n#00182418 n#05489950","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("progressão","n#00182418 n#05489950 n#08458912","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_cautelosa","NULL","NULL","NULL","r#00282103");
INSERT INTO portuguese_index VALUES ("com_cautela","NULL","NULL","NULL","r#00282103");
INSERT INTO portuguese_index VALUES ("com_cuidado","NULL","NULL","NULL","r#00282103");
INSERT INTO portuguese_index VALUES ("carriera","n#00182783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semcessar","NULL","NULL","NULL","r#00282858");
INSERT INTO portuguese_index VALUES ("tingir","NULL","v#00194314 v#00197117","NULL","NULL");
INSERT INTO portuguese_index VALUES ("locomoção","n#00283127 n#04773596","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prateado","NULL","NULL","a#00278090 a#00387392","NULL");
INSERT INTO portuguese_index VALUES ("prata","n#03339563 n#09629621 n#09642587 n#10501473 n#14986144","NULL","a#00278090","NULL");
INSERT INTO portuguese_index VALUES ("argentino","n#07006309","NULL","a#00278090 a#02733922","NULL");
INSERT INTO portuguese_index VALUES ("argênteo","NULL","NULL","a#00278090 a#01529053","NULL");
INSERT INTO portuguese_index VALUES ("caminhada","n#00183648 n#00184167 n#00201629","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maçante","NULL","NULL","a#00283703 a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("caoticamente","NULL","NULL","NULL","r#00283743");
INSERT INTO portuguese_index VALUES ("de_forma_caótica","NULL","NULL","NULL","r#00283743");
INSERT INTO portuguese_index VALUES ("opaco","NULL","NULL","a#00278681 a#00402602 a#00500611","NULL");
INSERT INTO portuguese_index VALUES ("dê_uma_volta","n#00187446","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passeio","n#00187446 n#00184167 n#00200342 n#00202291 n#04010205 n#03335176","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_barata","NULL","NULL","NULL","r#00284183");
INSERT INTO portuguese_index VALUES ("barato","NULL","NULL","a#00887042","r#00284183 r#00334210");
INSERT INTO portuguese_index VALUES ("sonambulismo","n#00285141","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dourar","NULL","v#00195854 v#00222387","NULL","NULL");
INSERT INTO portuguese_index VALUES ("como_se_deve","NULL","NULL","NULL","r#00285447");
INSERT INTO portuguese_index VALUES ("como_é_justo","NULL","NULL","NULL","r#00285447");
INSERT INTO portuguese_index VALUES ("propriamente","NULL","NULL","NULL","r#00285447");
INSERT INTO portuguese_index VALUES ("com_precisão","NULL","NULL","NULL","r#00285447");
INSERT INTO portuguese_index VALUES ("pernada","n#00185003","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("racista","NULL","NULL","a#00280184 a#01860484","NULL");
INSERT INTO portuguese_index VALUES ("imparcial","NULL","NULL","a#00286214 a#00958151 a#01723308 a#01660647","NULL");
INSERT INTO portuguese_index VALUES ("cor-cego","NULL","NULL","a#00286470","NULL");
INSERT INTO portuguese_index VALUES ("andar","n#00286497 n#00286957 n#02700186","v#01253107 v#01839538 v#01257215 v#01260638 v#01261299 v#01882170 v#01299603 v#01911698 v#01309662 v#01919711 v#01310603 v#01924023 v#01924148 v#01316088 v#01929254 v#01929467 v#01333288 v#02091165 v#01432910 v#02091689 v#02091885 v#02092476 v#02102002 v#02102398","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coloquialmente","NULL","NULL","NULL","r#00286667");
INSERT INTO portuguese_index VALUES ("informalmente","NULL","NULL","NULL","r#00286667");
INSERT INTO portuguese_index VALUES ("católico","n#09679925","NULL","a#00281363 a#02696513","NULL");
INSERT INTO portuguese_index VALUES ("universal","NULL","NULL","a#00281363 a#00493390 a#01511497 a#01512420","NULL");
INSERT INTO portuguese_index VALUES ("trote","n#00287561 n#00331225 n#00331381 n#00485959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escola_de_equitação","n#00288000","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adestramento","n#00288000","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dogmático","NULL","NULL","a#00288070 a#03006389 a#03061982","NULL");
INSERT INTO portuguese_index VALUES ("detalhada","NULL","NULL","NULL","r#00288450");
INSERT INTO portuguese_index VALUES ("de_A_a_Z","NULL","NULL","NULL","r#00288450");
INSERT INTO portuguese_index VALUES ("de_forma_compreensível","NULL","NULL","NULL","r#00288450");
INSERT INTO portuguese_index VALUES ("mesquinho","NULL","NULL","a#00282562","NULL");
INSERT INTO portuguese_index VALUES ("galope","n#00288671","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vagar","n#00187619","v#01284430 v#01882814 v#01298374 v#01925694","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vermelhar","NULL","v#00198875 v#00373451","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encanecer","NULL","v#00289392","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acinzentar","NULL","v#00289392","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebolar","n#00289659","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guardado","NULL","NULL","a#00286089","NULL");
INSERT INTO portuguese_index VALUES ("amarelar","NULL","v#00289840","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marcha","n#00188553 n#00356150 n#06233847","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irradiar","NULL","v#00291163 v#02686952 v#02767116 v#02768431","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desprender","NULL","v#00200388","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fraterno","NULL","NULL","a#00291471","NULL");
INSERT INTO portuguese_index VALUES ("fraternal","NULL","NULL","a#00291471 a#00292298 a#02731699","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_criminal","NULL","NULL","NULL","r#00291589");
INSERT INTO portuguese_index VALUES ("criminalmente","NULL","NULL","NULL","r#00291589");
INSERT INTO portuguese_index VALUES ("logradoura","n#00291663","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("iluminar","NULL","v#00200741 v#02763283","NULL","NULL");
INSERT INTO portuguese_index VALUES ("brilhar","NULL","v#00200741 v#01829747 v#01830042 v#01479299 v#01888557 v#02764765 v#01891783","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espreita","n#00292125","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sequencialmente","NULL","NULL","NULL","r#00292349");
INSERT INTO portuguese_index VALUES ("enterrado","NULL","NULL","a#00292611","NULL");
INSERT INTO portuguese_index VALUES ("condicionalmente","NULL","NULL","NULL","r#00292684");
INSERT INTO portuguese_index VALUES ("recortar","NULL","v#00201632 v#00851394 v#00861159 v#01198965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atalhar","NULL","v#00201632 v#00317241 v#01618884","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ocupado","NULL","NULL","a#00292937 a#01623360","NULL");
INSERT INTO portuguese_index VALUES ("moonwalk","n#00293125","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embelezar","NULL","v#00293141 v#01150345","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desdobrar-se","NULL","v#00202346","NULL","NULL");
INSERT INTO portuguese_index VALUES ("florescer","NULL","v#00202346 v#00202730 v#00202881","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desempregado","NULL","NULL","a#00289934 a#00865007","NULL");
INSERT INTO portuguese_index VALUES ("florir","NULL","v#00202730","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desabrochar","NULL","v#00202730 v#00249893","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carreira","n#00190909 n#00278455 n#00449295","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conseqüentemente","NULL","NULL","NULL","r#00294459");
INSERT INTO portuguese_index VALUES ("contra-ataque","n#00294577 n#00978173","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vagaroso","NULL","NULL","a#00294579","NULL");
INSERT INTO portuguese_index VALUES ("vadio","n#10197967","NULL","a#00294579","NULL");
INSERT INTO portuguese_index VALUES ("preguiçoso","NULL","NULL","a#00294579","NULL");
INSERT INTO portuguese_index VALUES ("rastejamento","n#00294868","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ocioso","NULL","NULL","a#00295235","NULL");
INSERT INTO portuguese_index VALUES ("prazeroso","NULL","NULL","a#00295235","NULL");
INSERT INTO portuguese_index VALUES ("afinar","NULL","v#00295346 v#00204023","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desafinar","NULL","v#00295563","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calibrar","NULL","v#00295697 v#00739536","NULL","NULL");
INSERT INTO portuguese_index VALUES ("travessia","n#00191846","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("viagem","n#00191846 n#00198579 n#00202833 n#00312784 n#04449762","v#01839963 v#01260993 v#01855606","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sintonizar","NULL","v#00204023","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acomodar","NULL","v#00204023 v#00297780 v#00207661 v#00415398 v#02701445 v#01843927 v#01870273","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regrar","NULL","v#00204023","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adaptar","NULL","v#00204023 v#00297780 v#00206945","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regular","NULL","v#00204023 v#00206759","a#01891762 a#01961937","NULL");
INSERT INTO portuguese_index VALUES ("ajeitar","NULL","v#00204023 v#00297780","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ferrado","NULL","NULL","a#00296061","NULL");
INSERT INTO portuguese_index VALUES ("acertar","NULL","v#00204190 v#00966768 v#01382085","NULL","NULL");
INSERT INTO portuguese_index VALUES ("circum-navegação","n#00296263","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Circumnavegação","n#00296263","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("peregrinação","n#00296478 n#00311687","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("procissão","n#06233236 n#07327288 n#06248227","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("romaria","n#06233236","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("misteriosamente","NULL","NULL","NULL","r#00296836");
INSERT INTO portuguese_index VALUES ("vagabundagem","n#00297062","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vagear","n#00297062","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("drift","n#00297404","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("zerar","NULL","v#00297507","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vau","n#00297657 n#09283623","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("socialista","n#07588809","NULL","a#02759618","NULL");
INSERT INTO portuguese_index VALUES ("turismo","n#00193473","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engrenar","NULL","v#00298244","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passar_a_marcha","NULL","v#00298244","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coletivo","NULL","NULL","a#00294050 a#00435502 a#02038355","NULL");
INSERT INTO portuguese_index VALUES ("colectivo","NULL","NULL","a#00294050 a#00435502","NULL");
INSERT INTO portuguese_index VALUES ("eco-turismo","n#00298351","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ecoturismo","n#00298351","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entoar","NULL","v#00298420 v#01050313","NULL","NULL");
INSERT INTO portuguese_index VALUES ("condução","n#00298497 n#11512818","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cacofônico","NULL","NULL","a#00298767","NULL");
INSERT INTO portuguese_index VALUES ("reiniciar","NULL","v#00298773","NULL","NULL");
INSERT INTO portuguese_index VALUES ("áspero","NULL","NULL","a#00295066 a#01730738 a#02132734 a#02243086","NULL");
INSERT INTO portuguese_index VALUES ("adequar","NULL","v#00206945","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rouco","NULL","NULL","a#00295224","NULL");
INSERT INTO portuguese_index VALUES ("rouquenho","NULL","NULL","a#00295224","NULL");
INSERT INTO portuguese_index VALUES ("rouca","NULL","NULL","a#00295224","NULL");
INSERT INTO portuguese_index VALUES ("densamente","NULL","NULL","NULL","r#00299753 r#00323315");
INSERT INTO portuguese_index VALUES ("enduro_equestre","n#00299933","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Enduro_eqüestre","n#00299933","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Trilha_montada","n#00300113","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("talvez","NULL","NULL","NULL","r#00300247");
INSERT INTO portuguese_index VALUES ("quiçá","NULL","NULL","NULL","r#00300247");
INSERT INTO portuguese_index VALUES ("por_ventura","NULL","NULL","NULL","r#00300247");
INSERT INTO portuguese_index VALUES ("vai_ver","NULL","NULL","NULL","r#00300247");
INSERT INTO portuguese_index VALUES ("acaso","NULL","NULL","NULL","r#00300247 r#00420004");
INSERT INTO portuguese_index VALUES ("porventura","NULL","NULL","NULL","r#00300247 r#00420004");
INSERT INTO portuguese_index VALUES ("estridente","NULL","NULL","a#00300359 a#00713853 a#01163535","NULL");
INSERT INTO portuguese_index VALUES ("aviação","n#00194802 n#00195810 n#06096913","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impossivelmente","NULL","NULL","NULL","r#00300682");
INSERT INTO portuguese_index VALUES ("impossìvel","NULL","NULL","NULL","r#00300682");
INSERT INTO portuguese_index VALUES ("eufónico","NULL","NULL","a#00300738 a#01455221","NULL");
INSERT INTO portuguese_index VALUES ("harmonioso","NULL","NULL","a#00300738 a#00508036 a#00529370 a#01163083 a#01455221","NULL");
INSERT INTO portuguese_index VALUES ("potencialmente","NULL","NULL","NULL","r#00300891");
INSERT INTO portuguese_index VALUES ("absurdamente","NULL","NULL","NULL","r#00301039");
INSERT INTO portuguese_index VALUES ("calculável","NULL","NULL","a#00301187","NULL");
INSERT INTO portuguese_index VALUES ("vôo","n#00195002 n#06102095","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dyskwalifikować","NULL","v#00301338","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inabilitar","NULL","v#00301338","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desqualificar","NULL","v#00301338 v#00972608","NULL","NULL");
INSERT INTO portuguese_index VALUES ("computável","NULL","NULL","a#00301432","NULL");
INSERT INTO portuguese_index VALUES ("calçadeira","n#04200537","v#00301544","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_veste_para_homem","NULL","v#00326672","NULL","NULL");
INSERT INTO portuguese_index VALUES ("domesticar","NULL","v#00301856 v#00302130","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inumerável","NULL","NULL","a#00297667","NULL");
INSERT INTO portuguese_index VALUES ("sem_número","NULL","NULL","a#00297667","NULL");
INSERT INTO portuguese_index VALUES ("incontável","NULL","NULL","a#00297667","NULL");
INSERT INTO portuguese_index VALUES ("inúmero","NULL","NULL","a#00297667","NULL");
INSERT INTO portuguese_index VALUES ("domar","NULL","v#00302130","NULL","NULL");
INSERT INTO portuguese_index VALUES ("voo","n#00195810","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inestimável","NULL","NULL","a#00302436 a#02501367","NULL");
INSERT INTO portuguese_index VALUES ("pacato","NULL","NULL","a#00298353","NULL");
INSERT INTO portuguese_index VALUES ("acrobacia_aérea","n#00302861","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enrijar","NULL","v#00302875","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quieto","NULL","NULL","a#00765651 a#01849351","NULL");
INSERT INTO portuguese_index VALUES ("silenciosa","NULL","NULL","a#00765651","NULL");
INSERT INTO portuguese_index VALUES ("Voo_a_vela","n#00303495","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alargar","NULL","v#00209671","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tempestuoso","NULL","NULL","a#00303727 a#00299475 a#01680632","NULL");
INSERT INTO portuguese_index VALUES ("Asa_delta","n#00303748","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("asa-delta","n#00303748 n#03491032","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paraquedismo","n#00303849","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para-pente","n#00304349","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parapente","n#00304349","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apertar","NULL","v#00210399 v#00291977 v#00292159 v#01456771","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ondeante","NULL","NULL","a#00304455","NULL");
INSERT INTO portuguese_index VALUES ("o_dia_inteiro","NULL","NULL","NULL","r#00304787");
INSERT INTO portuguese_index VALUES ("diurnamente","NULL","NULL","NULL","r#00304787");
INSERT INTO portuguese_index VALUES ("estreitar","NULL","v#00210830 v#00291977 v#00292159","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ventoso","n#09880741","NULL","a#00305225","NULL");
INSERT INTO portuguese_index VALUES ("de_boa_vontade","NULL","NULL","NULL","r#00305283");
INSERT INTO portuguese_index VALUES ("a_contragosto","NULL","NULL","NULL","r#00305431");
INSERT INTO portuguese_index VALUES ("encaracolado","NULL","NULL","a#00305464 a#01030022 a#01030372","NULL");
INSERT INTO portuguese_index VALUES ("dilatar","NULL","v#00305537","NULL","NULL");
INSERT INTO portuguese_index VALUES ("implodir","NULL","v#00305846","NULL","NULL");
INSERT INTO portuguese_index VALUES ("detonar","NULL","v#00211486 v#00306298 v#00306723 v#01077449","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jornada","n#00198579 n#10883946","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("etapa","n#00198945 n#10843624","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("habilidoso","NULL","NULL","a#00301854 a#02120998","NULL");
INSERT INTO portuguese_index VALUES ("desenvolto","NULL","NULL","a#00301854","NULL");
INSERT INTO portuguese_index VALUES ("inventivo","NULL","NULL","a#00301854 a#00607344","NULL");
INSERT INTO portuguese_index VALUES ("explodir","NULL","v#00212110 v#00212214 v#00309310 v#00486605 v#01078339 v#01759021 v#01219416 v#02761012","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comute","n#00307455","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entrar_em_erupção","NULL","v#00307568","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flamejar","NULL","v#00212614","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coruscar","NULL","v#00212614","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chamejar","NULL","v#00212614","NULL","NULL");
INSERT INTO portuguese_index VALUES ("odisseia","n#00308279","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bem_cuidado","NULL","NULL","a#00308355","NULL");
INSERT INTO portuguese_index VALUES ("excursão","n#00199642 n#00201294 n#00202291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desamparado","NULL","NULL","a#00308593","NULL");
INSERT INTO portuguese_index VALUES ("trajecto","n#00200009","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trajeto","n#00200009","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diabolicamente","NULL","NULL","NULL","r#00308916");
INSERT INTO portuguese_index VALUES ("de_forma_diabólica","NULL","NULL","NULL","r#00308916");
INSERT INTO portuguese_index VALUES ("cuidadosa","NULL","NULL","a#00303585","NULL");
INSERT INTO portuguese_index VALUES ("prudente","NULL","NULL","a#00303585 a#00317140 a#01825807 a#02569558","NULL");
INSERT INTO portuguese_index VALUES ("cautelosa","NULL","NULL","a#00303585","NULL");
INSERT INTO portuguese_index VALUES ("carona","n#00309276 n#10178077","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrebentar","NULL","v#00309310","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estourar","NULL","v#00309310 v#00303520 v#00862467","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destrutivamente","NULL","NULL","NULL","r#00309515");
INSERT INTO portuguese_index VALUES ("de_forma_detestável","NULL","NULL","NULL","r#00309632");
INSERT INTO portuguese_index VALUES ("detestavelmente","NULL","NULL","NULL","r#00309632");
INSERT INTO portuguese_index VALUES ("Safari","n#00309906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Safári","n#00309906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exploração","n#00201174 n#00271815 n#00420720 n#00604772 n#00606479 n#04459855","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consciencioso","NULL","NULL","a#00310138","NULL");
INSERT INTO portuguese_index VALUES ("consciensiosamente","NULL","NULL","a#00310138","NULL");
INSERT INTO portuguese_index VALUES ("vigorar","NULL","v#00214424","NULL","NULL");
INSERT INTO portuguese_index VALUES ("minucioso","NULL","NULL","a#00304990","NULL");
INSERT INTO portuguese_index VALUES ("circunstanciado","NULL","NULL","a#00304990","NULL");
INSERT INTO portuguese_index VALUES ("elaborada","NULL","NULL","a#00304990","NULL");
INSERT INTO portuguese_index VALUES ("pormenorizado","NULL","NULL","a#00304990","NULL");
INSERT INTO portuguese_index VALUES ("elaborado","NULL","NULL","a#00304990","NULL");
INSERT INTO portuguese_index VALUES ("proliferar","NULL","v#00310635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("turnê","n#00201629","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diagonalmente","NULL","NULL","NULL","r#00310720");
INSERT INTO portuguese_index VALUES ("escurecer","NULL","v#00311559 v#00216063 v#02771020","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descuidado","NULL","NULL","a#00311663","NULL");
INSERT INTO portuguese_index VALUES ("negligente","NULL","NULL","a#00311663 a#00719719","NULL");
INSERT INTO portuguese_index VALUES ("Lugares_de_peregrinação_religiosa","n#00311687","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("peregrinagem","n#00311687","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("viagem_de_recreio","n#00202291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ida","n#00202291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lapidar","NULL","v#00216484 v#01323518","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cruzeiros","n#00312932","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cruzeiro","n#00312932 n#03141327","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cruzeiros_(recreio)","n#00312932","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("velejar","n#00312932","v#01325658","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_desastrosa","NULL","NULL","NULL","r#00313092");
INSERT INTO portuguese_index VALUES ("desastrosamente","NULL","NULL","NULL","r#00313092");
INSERT INTO portuguese_index VALUES ("carnívoro","n#01324431","NULL","a#00313387 a#02680580","NULL");
INSERT INTO portuguese_index VALUES ("viagem_espacial","n#00313502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ignominiosamente","NULL","NULL","NULL","r#00313633");
INSERT INTO portuguese_index VALUES ("Iatismo","n#00203714","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Náutica","n#00203714 n#05639832","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("navegação","n#00203714 n#00204151 n#00521429 n#00716331","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vela","n#00203714 n#02375096 n#09470343","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apagar","NULL","v#00217744 v#00333717 v#00676082 v#01066360 v#01066739 v#01114673 v#02761897","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esconder","NULL","v#00217744 v#00825871 v#01017466 v#01467965 v#02145429 v#01468595 v#01469149 v#02147109 v#01469864 v#01469958 v#02148369 v#02157731 v#01477149","NULL","NULL");
INSERT INTO portuguese_index VALUES ("herbívoro","n#01324610","NULL","a#00314023","NULL");
INSERT INTO portuguese_index VALUES ("honestamente","NULL","NULL","NULL","r#00314384 r#00314835");
INSERT INTO portuguese_index VALUES ("Navegacão","n#00204151","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Navegação","n#00204151","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desonestamente","NULL","NULL","NULL","r#00314597");
INSERT INTO portuguese_index VALUES ("focalizar","NULL","v#00218146 v#00731789","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_rodeios","NULL","NULL","NULL","r#00314835");
INSERT INTO portuguese_index VALUES ("cabotagem","n#00315307","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("migrações_diárias","n#00315700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transporte","n#00204553 n#00716041","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lealmente","NULL","NULL","NULL","r#00316103");
INSERT INTO portuguese_index VALUES ("deslealmente","NULL","NULL","NULL","r#00316318");
INSERT INTO portuguese_index VALUES ("ensurdecer","NULL","v#00316390 v#02189940 v#02190077","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Transporte_aéreo_táctico","n#00316594","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Transporte_aéreo_tático","n#00316594","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esculpido","NULL","NULL","a#00311062","NULL");
INSERT INTO portuguese_index VALUES ("entalhado","NULL","NULL","a#00311062","NULL");
INSERT INTO portuguese_index VALUES ("talhado","NULL","NULL","a#00311062","NULL");
INSERT INTO portuguese_index VALUES ("entrega","n#00205135","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("truncar","NULL","v#00317241","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insensivelmente","NULL","NULL","NULL","r#00317390");
INSERT INTO portuguese_index VALUES ("prolongar","NULL","v#00220692 v#01421865","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extender","NULL","v#00220692 v#00221402","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consignação","n#00317917","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("citação","n#00205456 n#04922423 n#04922905 n#04960176 n#05068012","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("basal","NULL","NULL","a#00312617","NULL");
INSERT INTO portuguese_index VALUES ("carregue","n#00318735","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Carry_trade","n#00318735","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respeitosamente","NULL","NULL","NULL","r#00319275");
INSERT INTO portuguese_index VALUES ("com_reserva","NULL","NULL","NULL","r#00319635");
INSERT INTO portuguese_index VALUES ("a_distância","NULL","NULL","NULL","r#00319635");
INSERT INTO portuguese_index VALUES ("cozer","NULL","v#00222083","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fornear","NULL","v#00222083","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assar","NULL","v#00222083 v#00320536 v#00324560 v#01142646","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caçada","n#00206677","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perseguição","n#00206677 n#00269249","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gratinar","NULL","v#00222387","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tornar-se_castanho","NULL","v#00222387","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acastanhar","NULL","v#00222387","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tostar","NULL","v#00222387 v#00322151","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rastreamento","n#00320284","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rastreio","n#00320284","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("stalking","n#00320625","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_perturbante","NULL","NULL","NULL","r#00320777");
INSERT INTO portuguese_index VALUES ("inserção","n#00207301","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intubação","n#00321195","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Intubação_endotraqueal","n#00321195","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cateterismo","n#00321562","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dubitavelmente","NULL","NULL","NULL","r#00322112");
INSERT INTO portuguese_index VALUES ("de_forma_duvidosa","NULL","NULL","NULL","r#00322112");
INSERT INTO portuguese_index VALUES ("duvidosamente","NULL","NULL","NULL","r#00322112 r#00437796");
INSERT INTO portuguese_index VALUES ("Acaule","NULL","NULL","a#00322321","NULL");
INSERT INTO portuguese_index VALUES ("injeção","n#00208372 n#00447102","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cozinhar","NULL","v#00223888 v#01142893 v#01143604","NULL","NULL");
INSERT INTO portuguese_index VALUES ("causal","NULL","NULL","a#00323199","NULL");
INSERT INTO portuguese_index VALUES ("infusão","n#00323532 n#07933891","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cozinhar_demais","NULL","v#00323571","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dinamicamente","NULL","NULL","NULL","r#00323666");
INSERT INTO portuguese_index VALUES ("para","NULL","NULL","NULL","r#00323786");
INSERT INTO portuguese_index VALUES ("estufar","NULL","v#00323856","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transfusão","n#00324056","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transfusão_de_sangue","n#00324056","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Transfusão_de_Sangue","n#00324056","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Perfusão","n#00324233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perfusão","n#00324233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ascensão","n#00209440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("motriz","NULL","NULL","a#00316393","NULL");
INSERT INTO portuguese_index VALUES ("motor","n#03287733 n#03017435 n#07769591","NULL","a#00316393 a#02666201","NULL");
INSERT INTO portuguese_index VALUES ("torrar","NULL","v#00324560","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_churrasco","NULL","v#00324806","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grelhar","NULL","v#00324806 v#00328370","NULL","NULL");
INSERT INTO portuguese_index VALUES ("responsável","n#07311393 n#07469314","NULL","a#00316737 a#01923949 a#02253454 a#01997221 a#01924743 a#02465350","NULL");
INSERT INTO portuguese_index VALUES ("Funambulismo","n#00324978","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escalada","n#00209737 n#00325631 n#07370410 n#05487790","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cauto","NULL","NULL","a#00317140","NULL");
INSERT INTO portuguese_index VALUES ("fritar","NULL","v#00225669","NULL","NULL");
INSERT INTO portuguese_index VALUES ("educacionalmente","NULL","NULL","NULL","r#00325603");
INSERT INTO portuguese_index VALUES ("alpinismo","n#00325785","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eficientemente","NULL","NULL","NULL","r#00326324");
INSERT INTO portuguese_index VALUES ("eficazmente","NULL","NULL","NULL","r#00326324");
INSERT INTO portuguese_index VALUES ("descensão","n#00210530","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tumultuante","NULL","NULL","a#00326608","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_demonstrativa","NULL","NULL","NULL","r#00326968");
INSERT INTO portuguese_index VALUES ("demonstrativamente","NULL","NULL","NULL","r#00326968");
INSERT INTO portuguese_index VALUES ("celular","n#02992529","NULL","a#00318757","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_elegante","NULL","NULL","NULL","r#00327408 r#00327601");
INSERT INTO portuguese_index VALUES ("elegantemente","NULL","NULL","NULL","r#00327408 r#00327601");
INSERT INTO portuguese_index VALUES ("com_elegância","NULL","NULL","NULL","r#00327408 r#00327601");
INSERT INTO portuguese_index VALUES ("Alveolata","NULL","NULL","a#00327690","NULL");
INSERT INTO portuguese_index VALUES ("fermentar","NULL","v#00327813","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tramar","NULL","v#00327813","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pluricelular","NULL","NULL","a#00328017","NULL");
INSERT INTO portuguese_index VALUES ("multicelular","NULL","NULL","a#00328017","NULL");
INSERT INTO portuguese_index VALUES ("Acytota","NULL","NULL","a#00328128","NULL");
INSERT INTO portuguese_index VALUES ("acelular","NULL","NULL","a#00328128","NULL");
INSERT INTO portuguese_index VALUES ("reentrada","n#00328230","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eminentemente","NULL","NULL","NULL","r#00328378");
INSERT INTO portuguese_index VALUES ("deslizamento","n#00328502 n#07405579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("brotar","NULL","v#00328802 v#00357667","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ramificar","NULL","v#00328802 v#00329244","NULL","NULL");
INSERT INTO portuguese_index VALUES ("derrapagem","n#00329031","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desgalhar","NULL","v#00329244","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ramificar-se","NULL","v#00329244","NULL","NULL");
INSERT INTO portuguese_index VALUES ("poroso","NULL","NULL","a#00329396 a#01397998 a#01772305","NULL");
INSERT INTO portuguese_index VALUES ("Snowboard","n#00329468 n#04251791","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inundação","n#00212509 n#00817192 n#07796648","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enchente","n#00212509 n#00804708 n#07796648","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("central","n#02994858 n#04373264","NULL","a#02712055 a#00330728 a#01224859 a#02494716","NULL");
INSERT INTO portuguese_index VALUES ("efusão","n#00212615","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engatinhamento","n#00330035","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pulverizar","NULL","v#00330144","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aceleração","n#00330160 n#00330457 n#05060783 n#15275851","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bifocal","NULL","NULL","a#00330396","NULL");
INSERT INTO portuguese_index VALUES ("aumento_na_velocidade","n#00330457","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eticamente","NULL","NULL","NULL","r#00330505");
INSERT INTO portuguese_index VALUES ("de_forma_ética","NULL","NULL","NULL","r#00330505");
INSERT INTO portuguese_index VALUES ("focal","NULL","NULL","a#00330904 a#02881438","NULL");
INSERT INTO portuguese_index VALUES ("moer","NULL","v#00229305 v#00332017","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triturar","NULL","v#00229305","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transplante","n#00331102 n#00693679","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_maneira_justa","NULL","NULL","NULL","r#00331194");
INSERT INTO portuguese_index VALUES ("nuclear","NULL","NULL","a#00322942 a#00576833 a#02650931 a#02651049","NULL");
INSERT INTO portuguese_index VALUES ("atómico","NULL","NULL","a#00322942 a#00576833 a#02650931 a#02651049 a#02667673","NULL");
INSERT INTO portuguese_index VALUES ("periférico","n#03916720","NULL","a#02677239 a#01786003","NULL");
INSERT INTO portuguese_index VALUES ("circunferencial","NULL","NULL","a#00331716","NULL");
INSERT INTO portuguese_index VALUES ("esmiuçar","NULL","v#00332154","NULL","NULL");
INSERT INTO portuguese_index VALUES ("centrífugo","NULL","NULL","a#00332375 a#02666201 a#00335225","NULL");
INSERT INTO portuguese_index VALUES ("para_todo_o_sempre","NULL","NULL","NULL","r#00332596");
INSERT INTO portuguese_index VALUES ("excitadamente","NULL","NULL","NULL","r#00332714");
INSERT INTO portuguese_index VALUES ("centrípeto","NULL","NULL","a#00332869 a#00325147 a#00334852","NULL");
INSERT INTO portuguese_index VALUES ("abducção","n#00333037 n#00775460","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abdução","n#00333037 n#00775460","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adução","n#00333203","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subdividir","NULL","v#00333277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aferente","NULL","NULL","a#00333351","NULL");
INSERT INTO portuguese_index VALUES ("agitação","n#00214309 n#00347652 n#10070620","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sensorial","NULL","NULL","a#00325147 a#02033738 a#02602652","NULL");
INSERT INTO portuguese_index VALUES ("britar","NULL","v#00230815","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estilhaçar","NULL","v#00230815","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destroçar","NULL","v#00230815 v#01077449","NULL","NULL");
INSERT INTO portuguese_index VALUES ("separar","NULL","v#00231062 v#00397576 v#00345357 v#01294182 v#01294396 v#00887219 v#00887884 v#01001075 v#01007120 v#01073112 v#01073802 v#01075495 v#01075648 v#02030158 v#01388242 v#02031622 v#02430580 v#01788872","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dividir","NULL","v#00231062 v#00397576 v#00399074 v#00433595 v#00857046 v#01279833 v#00999598 v#01001075 v#01459542 v#01459696 v#01007120 v#01550817 v#01069335 v#01073112 v#01073802 v#01075495 v#01075648 v#01563005 v#01077267 v#01083862 v#01388242 v#01569784 v#01681144 v#01788872","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dardo","n#00334356 n#02545362","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sinal","n#00215081 n#04693804 n#05085885 n#05090749 n#05097156 n#05144580 n#09185280 n#11447319 n#09611330 n#09919371","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gesto","n#00215081 n#00796865 n#05146255 n#05146366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expressivamente","NULL","NULL","NULL","r#00334870");
INSERT INTO portuguese_index VALUES ("injecção","n#00215471","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("romper","NULL","v#00231588 v#02535457","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inexpressivamente","NULL","NULL","NULL","r#00335040");
INSERT INTO portuguese_index VALUES ("mudra","n#00335285","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inclinação","n#00215794 n#04943578 n#03955797 n#03956088 n#06199561 n#04701508 n#10007887","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amaciar","NULL","v#00232021","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_incorreta","NULL","NULL","NULL","r#00336065");
INSERT INTO portuguese_index VALUES ("incerto","NULL","NULL","a#00327632 a#02019649 a#00332689 a#00522821 a#01982394 a#02009056","NULL");
INSERT INTO portuguese_index VALUES ("partir-se","NULL","v#00232529","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quebrar-se","NULL","v#00232529","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falsamente","NULL","NULL","NULL","r#00336293 r#00399974");
INSERT INTO portuguese_index VALUES ("mentirosamente","NULL","NULL","NULL","r#00336293 r#00399974");
INSERT INTO portuguese_index VALUES ("aceno","n#00216454 n#05097156","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nutação","n#00336561","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("familiarmente","NULL","NULL","NULL","r#00336567");
INSERT INTO portuguese_index VALUES ("incline","n#00336654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("certo","NULL","NULL","a#00328258 a#00331522 a#00595353 a#00595724 a#00867566","NULL");
INSERT INTO portuguese_index VALUES ("fazer_uma_fissura","NULL","v#00336922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fissurar","NULL","v#00336922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("genuflexão","n#00337078 n#07275078","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inseguro","NULL","NULL","a#02019649 a#00331296 a#02017003 a#02019099 a#02020491 a#02192636 a#02402704","NULL");
INSERT INTO portuguese_index VALUES ("nistagmo","n#00337605","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ambivalente","NULL","NULL","a#00337841","NULL");
INSERT INTO portuguese_index VALUES ("duvidoso","NULL","NULL","a#00329386 a#01846862 a#01847441","NULL");
INSERT INTO portuguese_index VALUES ("fragmentar","NULL","v#00338071","NULL","NULL");
INSERT INTO portuguese_index VALUES ("movimento_sacádico","n#00338271","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confiante","NULL","NULL","a#00330147","NULL");
INSERT INTO portuguese_index VALUES ("rearranjo","n#00217325","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segurado","NULL","NULL","a#00330451","NULL");
INSERT INTO portuguese_index VALUES ("permutação","n#00339646","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("auto-confiante","NULL","NULL","a#00339742","NULL");
INSERT INTO portuguese_index VALUES ("transposição","n#00217846","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suceder","NULL","v#00235191 v#00238795 v#01797749","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ocorrer","NULL","v#00235191 v#00238795 v#02612368","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inevitável","NULL","NULL","a#00331522 a#00333883 a#00343360 a#01769762","NULL");
INSERT INTO portuguese_index VALUES ("seguro","n#09608326 n#13344804 n#10426769","NULL","a#00331522 a#01059711 a#02018719","NULL");
INSERT INTO portuguese_index VALUES ("primeira_classe","NULL","NULL","NULL","r#00340273");
INSERT INTO portuguese_index VALUES ("embaralhar","n#00218172","v#00972429 v#01917549","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predeterminado","NULL","NULL","a#00331909","NULL");
INSERT INTO portuguese_index VALUES ("destinado","NULL","NULL","a#00331909 a#01682822","NULL");
INSERT INTO portuguese_index VALUES ("acontecer_inesperadamente","NULL","v#00341422","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ir","NULL","v#00236311 v#00238223 v#01192992 v#01253107 v#01839538 v#01257215 v#01261299 v#01262658 v#01882814 v#01299603 v#01935233 v#01331981 v#01333288 v#01360914 v#01371248 v#01402214 v#01408362 v#01418612 v#02102002 v#02102398 v#01832891 v#01833375","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prosseguir","NULL","v#00236311 v#00243167 v#00530824 v#01360914 v#01618013 v#01831586 v#01832078","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vir","NULL","v#00236668 v#01262658 v#01849746 v#01368651 v#02053941","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rotação","n#00342028 n#05535152","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fluentemente","NULL","NULL","NULL","r#00342110");
INSERT INTO portuguese_index VALUES ("circunvolução","n#00342424","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forçadamente","NULL","NULL","NULL","r#00342624");
INSERT INTO portuguese_index VALUES ("diplomado","NULL","NULL","a#00342626","NULL");
INSERT INTO portuguese_index VALUES ("giro","n#00221348 n#00219627 n#00220762","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pronação","n#00343091","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reincidir","NULL","v#00343334","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inexorável","NULL","NULL","a#00343360 a#01769762 a#02357115","NULL");
INSERT INTO portuguese_index VALUES ("piano","n#03115608 n#03899791","NULL","a#01458303","r#00343660 r#00388494");
INSERT INTO portuguese_index VALUES ("evitável","NULL","NULL","a#00343700 a#00343883","NULL");
INSERT INTO portuguese_index VALUES ("previnível","NULL","NULL","a#00343883","NULL");
INSERT INTO portuguese_index VALUES ("resultar","NULL","v#00238223 v#01797447 v#01797616 v#01797749 v#01797979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mutável","NULL","NULL","a#00334865 a#00350069 a#00356339","NULL");
INSERT INTO portuguese_index VALUES ("variável","n#04508699 n#05426934 n#06847350","NULL","a#00334865 a#01028796 a#02384171 a#02384454 a#02507515","NULL");
INSERT INTO portuguese_index VALUES ("materializar","NULL","v#00238500","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maldosamente","NULL","NULL","NULL","r#00344208");
INSERT INTO portuguese_index VALUES ("desmaterializar","NULL","v#00344492","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regulável","NULL","NULL","a#00344686","NULL");
INSERT INTO portuguese_index VALUES ("cócoras","n#00344942","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agachamento","n#00344942","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("volúvel","NULL","NULL","a#00335703 a#00584626","NULL");
INSERT INTO portuguese_index VALUES ("instável","NULL","NULL","a#00335703 a#00335990 a#00584626 a#01998634 a#02181387 a#02384454","NULL");
INSERT INTO portuguese_index VALUES ("supinação","n#00345297","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("torção","n#00220931 n#07351909","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("começar","NULL","v#00239960 v#00241484 v#00240718 v#00348103 v#00348252 v#00242403 v#01526605 v#01119504 v#01133757 v#01273498 v#01621230 v#01651336 v#01661230 v#01778989 v#02609439","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aljava","n#00221734 n#04035836","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tremor","n#00221734 n#00223779 n#07428954 n#05526762 n#10088916","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("onda","n#00221849 n#05473259 n#05475302 n#05477241","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reorientação","n#00346296 n#06208614","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("valentemente","NULL","NULL","NULL","r#00346822");
INSERT INTO portuguese_index VALUES ("volatile","NULL","NULL","a#00346847","NULL");
INSERT INTO portuguese_index VALUES ("volátil","NULL","NULL","a#00346847 a#00584626 a#02519555","NULL");
INSERT INTO portuguese_index VALUES ("inalterável","NULL","NULL","a#00346991 a#00356648","NULL");
INSERT INTO portuguese_index VALUES ("imutável","NULL","NULL","a#00346991 a#00347400 a#00356648 a#00577782 a#02191070","NULL");
INSERT INTO portuguese_index VALUES ("genealogicamente","NULL","NULL","NULL","r#00347216");
INSERT INTO portuguese_index VALUES ("invariável","NULL","NULL","a#00347400 a#01898654 a#02505716 a#02506408","NULL");
INSERT INTO portuguese_index VALUES ("acometer","NULL","v#00241308","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacolejo","n#00347652","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fixo","NULL","NULL","a#00337799 a#00705447 a#01508672 a#02020145","NULL");
INSERT INTO portuguese_index VALUES ("com_prazer","NULL","NULL","NULL","r#00348247");
INSERT INTO portuguese_index VALUES ("traduzível","NULL","NULL","a#00348537 a#02489092","NULL");
INSERT INTO portuguese_index VALUES ("excitação_doentia","n#00348571","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gloriosamente","NULL","NULL","NULL","r#00348911 r#00349053");
INSERT INTO portuguese_index VALUES ("inversão_de_rota","n#00349886","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modificável","NULL","NULL","a#00350069 a#00356339","NULL");
INSERT INTO portuguese_index VALUES ("retomar","NULL","v#00243335","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recomeçar","NULL","v#00243335 v#01858686","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Digressão","n#00224903","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("digressão","n#00224903","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("persistir","NULL","v#00350461","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perseverar","NULL","v#00350461 v#01785787","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ajustado","NULL","NULL","a#00350621 a#00351523 a#00352536","NULL");
INSERT INTO portuguese_index VALUES ("mudança_de_magnitude","n#00351485","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_monstruosa","NULL","NULL","NULL","r#00351542");
INSERT INTO portuguese_index VALUES ("monstruosamente","NULL","NULL","NULL","r#00351542");
INSERT INTO portuguese_index VALUES ("redução","n#00225760 n#14780267","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diminuição","n#00225760 n#00227536 n#00229061 n#09728815 n#09731612 n#09728739","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("finalizar","NULL","v#00245305 v#00246253 v#00335506 v#00337013 v#00483753 v#01642820 v#01831830 v#01829006 v#02735418","NULL","NULL");
INSERT INTO portuguese_index VALUES ("terminar","NULL","v#00245305 v#00246253 v#00335506 v#00337013 v#00337397 v#00483753 v#00518678 v#01075648 v#02229828 v#01651565 v#01831830 v#01780161 v#01780295 v#01829006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alterado","NULL","NULL","a#00342202","NULL");
INSERT INTO portuguese_index VALUES ("aportar","NULL","v#00245987","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trocado","NULL","NULL","a#00352716 a#00354433","NULL");
INSERT INTO portuguese_index VALUES ("mudado","NULL","NULL","a#00352716 a#00354433","NULL");
INSERT INTO portuguese_index VALUES ("redução_de_custos","n#00352778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encerrar","NULL","v#00246253 v#00337013 v#01831830","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concluir","NULL","v#00246253 v#00318530 v#00428966 v#00430365 v#00430461 v#00472610 v#00483753 v#00944924 v#00945125 v#00691426","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impróprio_para_o_momento","NULL","NULL","a#00343387","NULL");
INSERT INTO portuguese_index VALUES ("sempiterno","NULL","NULL","a#00343387","NULL");
INSERT INTO portuguese_index VALUES ("prematuro","NULL","NULL","a#00343387 a#01495535","NULL");
INSERT INTO portuguese_index VALUES ("interminável","NULL","NULL","a#00343387 a#01382215 a#01691167","NULL");
INSERT INTO portuguese_index VALUES ("abatimento","n#00227277 n#00227536 n#00229061 n#00232701 n#00362355 n#05479408 n#05523754 n#13282275 n#09728815 n#09731612 n#09728739","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("harmoniosamente","NULL","NULL","NULL","r#00353590");
INSERT INTO portuguese_index VALUES ("contracção","n#00227536 n#00365471","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interromper","NULL","v#00246783 v#00253202 v#00254764 v#00362765 v#00528650 v#00779061 v#02018858 v#01830886","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desvalorização","n#00353992 n#00364600","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("devaliação","n#00353992 n#00805524","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("culminar","NULL","v#00246916 v#00337971 v#00338157 v#01380705 v#01723022","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estagnar","NULL","v#00354452","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estancar","NULL","v#00354452","NULL","NULL");
INSERT INTO portuguese_index VALUES ("morrer","NULL","v#00247730 v#00250254 v#01784953 v#02620466","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falecer","NULL","v#00247730 v#00250254","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alívio","n#00228188 n#00228800 n#05570696","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transformado","NULL","NULL","a#00354934","NULL");
INSERT INTO portuguese_index VALUES ("matar","NULL","v#00247869 v#00334181 v#00903064 v#00903723 v#01691743","NULL","NULL");
INSERT INTO portuguese_index VALUES ("futuramente","NULL","NULL","NULL","r#00355896");
INSERT INTO portuguese_index VALUES ("minimização","n#00355919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("isotônico","NULL","NULL","a#00355950 a#00894980 a#02406790","NULL");
INSERT INTO portuguese_index VALUES ("ionizado","NULL","NULL","a#00356110","NULL");
INSERT INTO portuguese_index VALUES ("depleção","n#00229061","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alterável","NULL","NULL","a#00356339","NULL");
INSERT INTO portuguese_index VALUES ("consumo","n#00229211 n#09726045","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imediatemente_depois","NULL","NULL","NULL","r#00356412");
INSERT INTO portuguese_index VALUES ("de_forma_hermética","NULL","NULL","NULL","r#00356515");
INSERT INTO portuguese_index VALUES ("hermeticamente","NULL","NULL","NULL","r#00356515");
INSERT INTO portuguese_index VALUES ("igualar","NULL","v#00356649 v#00289728 v#01817610","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compressão","n#00356790 n#07313241 n#07419233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caraterístico","NULL","NULL","a#00346121","NULL");
INSERT INTO portuguese_index VALUES ("característico","NULL","NULL","a#00346121","NULL");
INSERT INTO portuguese_index VALUES ("bombear","NULL","v#00356954 v#01131902 v#01225684 v#01853069 v#01853310","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sintomático","NULL","NULL","a#00346431","NULL");
INSERT INTO portuguese_index VALUES ("germinar","NULL","v#00249716 v#00357667","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descompressão","n#00357451","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("típico","NULL","NULL","a#00346965 a#01595440 a#02349429","NULL");
INSERT INTO portuguese_index VALUES ("distintivo","n#05851131 n#05150806","NULL","a#00346965","NULL");
INSERT INTO portuguese_index VALUES ("compactação","n#00357680 n#00357906 n#00358089","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espessamento","n#00357906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebentar","NULL","v#00250037","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gomar","NULL","v#00250037","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esmagamento","n#00358089 n#14762366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pulverização","n#00358290","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trituração","n#00358290","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("horizontalmente","NULL","NULL","NULL","r#00358342");
INSERT INTO portuguese_index VALUES ("bater_as_botas","NULL","v#00250254 v#00250254","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comer_capim_pela_raiz","NULL","v#00250254","NULL","NULL");
INSERT INTO portuguese_index VALUES ("verticalmente","NULL","NULL","NULL","r#00358516");
INSERT INTO portuguese_index VALUES ("eletronegativo","NULL","NULL","a#01750220","NULL");
INSERT INTO portuguese_index VALUES ("extrusão","n#00230520","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encurtamento","n#00358931","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abreviatura","n#00358931 n#00359135 n#06468123 n#07091587","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abreviação","n#00359135 n#06468123 n#07091587","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caridoso","NULL","NULL","a#00359459 a#02691390","NULL");
INSERT INTO portuguese_index VALUES ("abafar","NULL","v#00359511 v#01080303 v#02191311","NULL","NULL");
INSERT INTO portuguese_index VALUES ("poda","n#00360143","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estacas","n#00360143","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enviuvar","NULL","v#00360337","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afogar-se","NULL","v#00360501 v#00333886","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Miniaturização","n#00360601","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("casta","n#08306047","NULL","a#00360650","NULL");
INSERT INTO portuguese_index VALUES ("casto","NULL","NULL","a#00360650 a#01548694","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_histérica","NULL","NULL","NULL","r#00360710");
INSERT INTO portuguese_index VALUES ("histericamente","NULL","NULL","NULL","r#00360710");
INSERT INTO portuguese_index VALUES ("subtração","n#00232015 n#00560394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subtracção","n#00232015 n#00560394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vir_ao_mundo","NULL","v#00251991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nascer","NULL","v#00251991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("da_mesma_forma","NULL","NULL","NULL","r#00361065");
INSERT INTO portuguese_index VALUES ("de_forma_idêntica","NULL","NULL","NULL","r#00361065");
INSERT INTO portuguese_index VALUES ("virgem","n#07667236","NULL","a#00350627 a#01584288 a#01907878 a#02824922","NULL");
INSERT INTO portuguese_index VALUES ("virginal","n#04537436","NULL","a#00350627 a#01907878 a#02824922","NULL");
INSERT INTO portuguese_index VALUES ("extenuação","n#00232357","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enevoar","NULL","v#00361495 v#00940803","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nublar","NULL","v#00361495 v#02770717 v#02771020","NULL","NULL");
INSERT INTO portuguese_index VALUES ("The_Idle_Class","NULL","NULL","NULL","r#00361781");
INSERT INTO portuguese_index VALUES ("promíscuo","NULL","NULL","a#00361837 a#00774006 a#02133779","NULL");
INSERT INTO portuguese_index VALUES ("devasso","n#10552980","NULL","a#00361837 a#01549568 a#01727133 a#02133207 a#02133431","NULL");
INSERT INTO portuguese_index VALUES ("deflação","n#00361932 n#13459821","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disconto","n#00232701","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desconto","n#00232701 n#13274597 n#13282275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curvar","NULL","v#00362128 v#01280488 v#01390339","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imoderado","NULL","NULL","a#00362269","NULL");
INSERT INTO portuguese_index VALUES ("desenfreado","NULL","NULL","a#00362269","NULL");
INSERT INTO portuguese_index VALUES ("árdego","NULL","NULL","a#00362269","NULL");
INSERT INTO portuguese_index VALUES ("legivelmente","NULL","NULL","NULL","r#00362276");
INSERT INTO portuguese_index VALUES ("parar","NULL","v#00253202 v#00528650 v#00779061 v#00813880 v#01269636 v#01860795 v#01272526 v#01354366 v#02412647 v#01745445 v#01831830 v#01829006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esperar_um_pouco","NULL","v#00362610 v#00790509","NULL","NULL");
INSERT INTO portuguese_index VALUES ("legitimamente","NULL","NULL","NULL","r#00362831 r#00363218");
INSERT INTO portuguese_index VALUES ("contente","n#07531105","NULL","a#00352106 a#00998186 a#01308490 a#01308059 a#01314288 a#01805157","NULL");
INSERT INTO portuguese_index VALUES ("risonho","NULL","NULL","a#00352106","NULL");
INSERT INTO portuguese_index VALUES ("feliz","NULL","NULL","a#00352106 a#00998186 a#01308490 a#01308059 a#01314288","NULL");
INSERT INTO portuguese_index VALUES ("abandonar","NULL","v#00253929 v#00415041 v#00415168 v#00415444 v#00415625 v#00734233 v#01842367 v#01421290 v#01521543 v#01523865 v#01524047 v#01524319 v#01582774 v#01623741 v#01761339","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alegre","NULL","NULL","a#00352451 a#00353226 a#01308059 a#01314288 a#01664015","NULL");
INSERT INTO portuguese_index VALUES ("logicamente","NULL","NULL","NULL","r#00363463 r#00363744");
INSERT INTO portuguese_index VALUES ("adição","n#00363788 n#00560621","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ensolarado","NULL","NULL","a#00429748","NULL");
INSERT INTO portuguese_index VALUES ("retrofit","n#00364053","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Retrofit","n#00364053","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aumento","n#00234220 n#00235032 n#00235235 n#03983965 n#05109324 n#03984405 n#03984543 n#05479891 n#07369470 n#09729055 n#09904938","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reavaliação","n#00234364","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reavaliação","n#00234364 n#05737025 n#05747582","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triste","NULL","NULL","a#01309194 a#00863871 a#01000655 a#01051814 a#01101074 a#01308632 a#01362387 a#01309535 a#01732472 a#01733145","NULL");
INSERT INTO portuguese_index VALUES ("amoralmente","NULL","NULL","NULL","r#00364623");
INSERT INTO portuguese_index VALUES ("de_forma_amoral","NULL","NULL","NULL","r#00364623");
INSERT INTO portuguese_index VALUES ("pasteurizar","NULL","v#00364629","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entristecedor","NULL","NULL","a#00354187","NULL");
INSERT INTO portuguese_index VALUES ("nebuloso","NULL","NULL","a#00354187","NULL");
INSERT INTO portuguese_index VALUES ("horrendo","NULL","NULL","a#00354187","NULL");
INSERT INTO portuguese_index VALUES ("enjoado","NULL","NULL","a#00354187","NULL");
INSERT INTO portuguese_index VALUES ("lastimável","NULL","NULL","a#00354187","NULL");
INSERT INTO portuguese_index VALUES ("ermo","NULL","NULL","a#00354187","NULL");
INSERT INTO portuguese_index VALUES ("melancólico","NULL","NULL","a#00354187","NULL");
INSERT INTO portuguese_index VALUES ("fluorização","n#00365012","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("soturno","NULL","NULL","a#00354536","NULL");
INSERT INTO portuguese_index VALUES ("lúgubre","NULL","NULL","a#00354536 a#01366062","NULL");
INSERT INTO portuguese_index VALUES ("sensivelmente","NULL","NULL","NULL","r#00365668");
INSERT INTO portuguese_index VALUES ("expansão","n#00235235 n#00238469","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ampliação","n#00235235 n#02641071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sublimar","NULL","v#00365810 v#00366020 v#00475183 v#01953527","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dilatação","n#00365995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("monoclínico","NULL","NULL","a#00366025","NULL");
INSERT INTO portuguese_index VALUES ("triclínico","NULL","NULL","a#00366185","NULL");
INSERT INTO portuguese_index VALUES ("vasodilatação","n#00366207","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vasodilatadores","n#00366207","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distensão","n#00366317 n#14063633","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("monocromático","NULL","NULL","a#00366355 a#00398816 a#03040525","NULL");
INSERT INTO portuguese_index VALUES ("policromático","NULL","NULL","a#00366526 a#00400193","NULL");
INSERT INTO portuguese_index VALUES ("cromático","NULL","NULL","a#00366691 a#00409750","NULL");
INSERT INTO portuguese_index VALUES ("vaporizar","NULL","v#00366858 v#00442267","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evaporar","NULL","v#00366858 v#00442267 v#00575720","NULL","NULL");
INSERT INTO portuguese_index VALUES ("implicitamente","NULL","NULL","NULL","r#00367259 r#00367568");
INSERT INTO portuguese_index VALUES ("inflação","n#00236300 n#09727083","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exagero","n#00367552 n#06758835 n#07106502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intercalar","NULL","v#00257011","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fundir-se","NULL","v#00257011","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extensão","n#00236696 n#03972175 n#03973414 n#03977751 n#03981562 n#03991813 n#03995297 n#03999338 n#03999641 n#06384327 n#06667120","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espalhamento","n#00236886","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desagregação","n#00237068","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disseminação","n#00237068 n#03970206","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convergir","NULL","v#00368847","NULL","NULL");
INSERT INTO portuguese_index VALUES ("associar-se","NULL","v#00369064 v#01592263 v#02434976 v#01658377 v#01683038","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contratura","n#00369399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Contratura","n#00369399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carbonizar","NULL","v#00369628 v#02771997","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hiperextensão","n#00369694","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Contracção_muscular","n#00369802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ruivo","n#10513823","NULL","a#00369831","NULL");
INSERT INTO portuguese_index VALUES ("esfriar-se","NULL","v#00258213","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrefecer","NULL","v#00258213","NULL","NULL");
INSERT INTO portuguese_index VALUES ("áureo","NULL","NULL","a#00357392 a#01465459","NULL");
INSERT INTO portuguese_index VALUES ("dourado","n#03881805 n#09629533","NULL","a#00357392 a#01465459","NULL");
INSERT INTO portuguese_index VALUES ("Truncatura_de_um_sólido","n#00370261","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Truncatura_de_um_Sólido","n#00370261","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sobreaquecer","NULL","v#00258521","NULL","NULL");
INSERT INTO portuguese_index VALUES ("azul_claro","NULL","NULL","a#00370267","NULL");
INSERT INTO portuguese_index VALUES ("azul_celeste","n#04969242","NULL","a#00370267","NULL");
INSERT INTO portuguese_index VALUES ("azul","n#03883954 n#04969242 n#10754805","NULL","a#00370267 a#00358045 a#01606058","NULL");
INSERT INTO portuguese_index VALUES ("cerúleo","n#04969242","NULL","a#00370267","NULL");
INSERT INTO portuguese_index VALUES ("refrigerar","NULL","v#00258652 v#00371051 v#00371955","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comparavelmente","NULL","NULL","NULL","r#00370597");
INSERT INTO portuguese_index VALUES ("de_forma_comparável","NULL","NULL","NULL","r#00370597");
INSERT INTO portuguese_index VALUES ("azulado","NULL","NULL","a#00358045","NULL");
INSERT INTO portuguese_index VALUES ("vaginismo","n#00370885","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vaginismo","n#00370885","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gelar","NULL","v#00258851 v#00262285 v#00311143","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estiramento","n#00238268","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Azul-Petróleo","NULL","NULL","a#00371163","NULL");
INSERT INTO portuguese_index VALUES ("aquecer","NULL","v#00259088 v#00259859 v#00260044 v#00260318 v#01665071","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esquentar","NULL","v#00259088 v#00260044 v#00260318","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amplificação","n#00238624 n#05109324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rosado","NULL","NULL","a#00358294","NULL");
INSERT INTO portuguese_index VALUES ("anotação","n#00371735 n#05067461 n#05067694 n#05067911","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("da_cor_do_bronze","NULL","NULL","a#00371945","NULL");
INSERT INTO portuguese_index VALUES ("de_bronze","NULL","NULL","a#00371945","NULL");
INSERT INTO portuguese_index VALUES ("acúmulo","n#00239058 n#00239181 n#05963394 n#07953603 n#05969773 n#09626584","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acumulação","n#00239058 n#00239181 n#09625489 n#09626584","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pardo","NULL","NULL","a#00358571","NULL");
INSERT INTO portuguese_index VALUES ("moreno","NULL","NULL","a#00358571","NULL");
INSERT INTO portuguese_index VALUES ("acastanhado","NULL","NULL","a#00358571","NULL");
INSERT INTO portuguese_index VALUES ("marrom","n#04971928 n#04972350","NULL","a#00358571 a#00373209","NULL");
INSERT INTO portuguese_index VALUES ("castanho","n#04971928 n#04972350","NULL","a#00358571 a#00373209","NULL");
INSERT INTO portuguese_index VALUES ("indiferentemente","NULL","NULL","NULL","r#00372322");
INSERT INTO portuguese_index VALUES ("de_forma_indiferente","NULL","NULL","NULL","r#00372322");
INSERT INTO portuguese_index VALUES ("colocação","n#00239291 n#00680814 n#03960878 n#07015151","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depósito","n#00239291 n#00372607 n#03421885 n#06695079 n#13364368","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("armazenamento","n#00372607 n#00811355","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acalentar","NULL","v#00260044 v#01212539","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inclusão","n#00373130 n#00240011 n#13936304","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incorporação_(processos_industriais)","n#00239807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engrandecimento","n#00240204","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enaltecimento","n#00240204","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coral","n#01429914 n#03886321 n#05828205","NULL","a#00373621 a#02874282","NULL");
INSERT INTO portuguese_index VALUES ("cauterizar","NULL","v#00373766","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reforço","n#00240588 n#07427224","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intensificação","n#00374224","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infrequentemente","NULL","NULL","NULL","r#00374520");
INSERT INTO portuguese_index VALUES ("de_forma_infrequente","NULL","NULL","NULL","r#00374520");
INSERT INTO portuguese_index VALUES ("exacerbação","n#00374835","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ebulir","NULL","v#00375021","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concentração","n#00241069 n#00799840 n#03812111 n#03865563 n#03933851 n#03970585 n#04370050 n#04407475 n#05518168","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inerentemente","NULL","NULL","NULL","r#00375163");
INSERT INTO portuguese_index VALUES ("de_forma_inerente","NULL","NULL","NULL","r#00375163");
INSERT INTO portuguese_index VALUES ("pervaporação","n#00375348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("focalização","n#00375625","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esverdeado","NULL","NULL","a#00360195","NULL");
INSERT INTO portuguese_index VALUES ("derreter","NULL","v#00262454 v#00444629","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amolecer","NULL","v#00262454 v#01844178","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avelaneira","NULL","NULL","a#00376342","NULL");
INSERT INTO portuguese_index VALUES ("cor_de_avelã","NULL","NULL","a#00376342","NULL");
INSERT INTO portuguese_index VALUES ("rompimento","n#00242022 n#00242229 n#05451946","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ruptura","n#00242229","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descongelar","NULL","v#00376807","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fractura","n#00376994 n#14292090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fratura","n#00376994 n#14292090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carburar","NULL","v#00262798","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estouro","n#00242644","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("explosão","n#00242644 n#00362034 n#05448780 n#05492247 n#07408171 n#05530978 n#05531291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fumegar","NULL","v#00377569 v#02767922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("detonação","n#00377686","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("percussão","n#00377813 n#00876239 n#08217557","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incinerar","NULL","v#00263602 v#00378361","NULL","NULL");
INSERT INTO portuguese_index VALUES ("combustão","n#00378069 n#13450206","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insidiosamente","NULL","NULL","NULL","r#00378212");
INSERT INTO portuguese_index VALUES ("incêndio_premeditado","n#00378296","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fogo_posto","n#00378296","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calcinar","NULL","v#00378361","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reduzir_a_cinzas","NULL","v#00378361","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ignição","n#00378479 n#03560567 n#13495873","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Inflamações","n#00378479","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inflamação","n#00378479 n#14336539","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arder","NULL","v#00263886 v#01248170 v#01885781 v#01887716 v#02762806 v#01887961","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incineração","n#00378706","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Incinerador","n#00378706","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("verde-azeitona","NULL","NULL","a#00378782","NULL");
INSERT INTO portuguese_index VALUES ("olivo","NULL","NULL","a#00378782","NULL");
INSERT INTO portuguese_index VALUES ("cremação","n#00378880","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alaranjado","n#03880945","NULL","a#00361864","NULL");
INSERT INTO portuguese_index VALUES ("laranja","n#03880945 n#05783752 n#10758147","NULL","a#00361864","NULL");
INSERT INTO portuguese_index VALUES ("cor-de-laranja","n#03880945","NULL","a#00361864","NULL");
INSERT INTO portuguese_index VALUES ("combinação","n#00243962 n#00559255 n#03110842 n#05490939 n#06142606 n#06197501","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cremar","NULL","v#00379154","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inspiradamente","NULL","NULL","NULL","r#00379301");
INSERT INTO portuguese_index VALUES ("enxertia","n#00379588","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cor-de-rosa","n#03885630 n#11807979","NULL","a#00362144","NULL");
INSERT INTO portuguese_index VALUES ("rosa","n#03885630 n#03885875 n#08920236","NULL","a#00362144","NULL");
INSERT INTO portuguese_index VALUES ("mistura","n#00244416 n#00244665 n#05490939 n#05491211 n#07375405 n#05909338 n#06210851 n#06211515 n#10449119","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("purpúreo","NULL","NULL","a#00362338","NULL");
INSERT INTO portuguese_index VALUES ("roxo","n#04970059 n#03885490","NULL","a#00362338","NULL");
INSERT INTO portuguese_index VALUES ("violeta","n#04536335 n#04970059 n#03885490 n#08691021","NULL","a#00362338","NULL");
INSERT INTO portuguese_index VALUES ("lilás","n#03885490 n#08613795","NULL","a#00362338","NULL");
INSERT INTO portuguese_index VALUES ("púrpura","n#04970059","NULL","a#00362338","NULL");
INSERT INTO portuguese_index VALUES ("transpor","NULL","v#00380424","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fusão","n#00244573 n#00804210 n#05490810 n#09724169 n#09720762 n#09741527 n#10345580","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interrogativamente","NULL","NULL","NULL","r#00380590");
INSERT INTO portuguese_index VALUES ("transportar","NULL","v#00265330 v#00994853 v#00996361 v#01949674 v#01328437 v#01330495 v#01373274 v#01422262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homogenização","n#00380994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avermelhado","NULL","NULL","a#00362449","NULL");
INSERT INTO portuguese_index VALUES ("carmim","n#03879753 n#04963588","NULL","a#00362449","NULL");
INSERT INTO portuguese_index VALUES ("sangue-vermelho","NULL","NULL","a#00362449","NULL");
INSERT INTO portuguese_index VALUES ("vermelho","n#03879230 n#04964977","NULL","a#00362449 a#00385188 a#00372041","NULL");
INSERT INTO portuguese_index VALUES ("cereja","n#04964443 n#07757132 n#07757312","NULL","a#00362449","NULL");
INSERT INTO portuguese_index VALUES ("encarnado","n#03879230","NULL","a#00362449","NULL");
INSERT INTO portuguese_index VALUES ("intuitivamente","NULL","NULL","NULL","r#00381557");
INSERT INTO portuguese_index VALUES ("a_temperança","n#00381567","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transmutar","NULL","v#00266041","NULL","NULL");
INSERT INTO portuguese_index VALUES ("unificação","n#00245212 n#05490810","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coalescência","n#00245479","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invisivelmente","NULL","NULL","NULL","r#00382151");
INSERT INTO portuguese_index VALUES ("reunificação","n#00245609","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reunião","n#00245609 n#00654309 n#00654904 n#00798100 n#00799023 n#00799654 n#05978845 n#06166238 n#06167318 n#08415774 n#06258566","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ironicamente","NULL","NULL","NULL","r#00382507 r#00382620");
INSERT INTO portuguese_index VALUES ("de_forma_irônica","NULL","NULL","NULL","r#00382620");
INSERT INTO portuguese_index VALUES ("abertura","n#00246048 n#00457890 n#03057886 n#09201031 n#10021740","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irreversivelmente","NULL","NULL","NULL","r#00383428");
INSERT INTO portuguese_index VALUES ("separação","n#00246210 n#00255068 n#00778210 n#00815560 n#10342852","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interrupção","n#00246501 n#00660117 n#05486357 n#10969750","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pausa","n#00246501 n#00687670 n#00687814 n#01063578 n#05137171 n#05486357 n#10093496 n#10969750 n#10970463 n#10972097 n#15274441","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("baio","NULL","NULL","a#00384099","NULL");
INSERT INTO portuguese_index VALUES ("pétreo","NULL","NULL","a#00384195","NULL");
INSERT INTO portuguese_index VALUES ("judiciosamente","NULL","NULL","NULL","r#00384783");
INSERT INTO portuguese_index VALUES ("sensatamente","NULL","NULL","NULL","r#00384783");
INSERT INTO portuguese_index VALUES ("criteriosamente","NULL","NULL","NULL","r#00384783");
INSERT INTO portuguese_index VALUES ("secessão","n#00384933","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disjunção","n#00385649 n#14417697","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tirante","NULL","NULL","a#00364444","NULL");
INSERT INTO portuguese_index VALUES ("amarelo","n#03881286 n#03881805","NULL","a#00364444 a#01581686","NULL");
INSERT INTO portuguese_index VALUES ("amarelento","NULL","NULL","a#00364444","NULL");
INSERT INTO portuguese_index VALUES ("amarelado","NULL","NULL","a#00364444","NULL");
INSERT INTO portuguese_index VALUES ("divisão","n#00247514 n#00255068 n#00559516 n#00701814 n#05368405 n#06102171","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evangelizar","NULL","v#00386390 v#00828227","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acromático","NULL","NULL","a#00386392","NULL");
INSERT INTO portuguese_index VALUES ("bissetriz","n#00386450 n#13871967","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bissecção","n#00386450","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carcaças_de_animais","n#00386553","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quartel","n#00386553 n#02808393 n#02997669","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lateralmente","NULL","NULL","NULL","r#00386587 r#00386765");
INSERT INTO portuguese_index VALUES ("cisma","n#00386676","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dissidência","n#00386676 n#10018021","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cisão","n#00386676","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("investir","NULL","v#00268521 v#01553891 v#02386675 v#01685814","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dissecção","n#00387214","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cortamento","n#00248688","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corte","n#00248688 n#00388065 n#04081828 n#07653394 n#08051946 n#10258725","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("à_direita","NULL","NULL","NULL","r#00387828");
INSERT INTO portuguese_index VALUES ("personalizar","NULL","v#00387919 v#00388065","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ao_comprido","NULL","NULL","NULL","r#00388209");
INSERT INTO portuguese_index VALUES ("fragmentação","n#00388210 n#13484303","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assolar","NULL","v#00269459","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destruir","NULL","v#00269459 v#00328583 v#00734516 v#01103603 v#00938146 v#01077449 v#01078694 v#01113462 v#01114042 v#01620688 v#01137612 v#01657977","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bifurcação","n#00388710 n#13887056 n#13914265","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quantizacão","n#00389308","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quantização","n#00389308","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gris","NULL","NULL","a#00366117","NULL");
INSERT INTO portuguese_index VALUES ("acinzentado","NULL","NULL","a#00366117","NULL");
INSERT INTO portuguese_index VALUES ("cinzenta","NULL","NULL","a#00366117","NULL");
INSERT INTO portuguese_index VALUES ("cinzento","NULL","NULL","a#00366117 a#02575653","NULL");
INSERT INTO portuguese_index VALUES ("cinza","n#03878371 n#11012676 n#10588962","NULL","a#00366117","NULL");
INSERT INTO portuguese_index VALUES ("sem_entusiasmo","NULL","NULL","NULL","r#00389804");
INSERT INTO portuguese_index VALUES ("pontuação","n#00390198","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pontuação","n#00390198","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colocação_de_hífens","n#00390445","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divisão_da_palavra_no_final_da_linha","n#00390445","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("separação_em_sílabas","n#00390581","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("silabação","n#00390581","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divisão_em_sílabas","n#00390581","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hifenização","n#00390735","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rasgão","n#00391086 n#09410928","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sable","NULL","NULL","a#00391487","NULL");
INSERT INTO portuguese_index VALUES ("saibro","NULL","NULL","a#00391487","NULL");
INSERT INTO portuguese_index VALUES ("remoção","n#00251311","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nevoso","NULL","NULL","a#00392093","NULL");
INSERT INTO portuguese_index VALUES ("acerar","NULL","v#00272165","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afiar","NULL","v#00272165 v#00272277 v#00272424 v#00272798 v#00850117","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esbranquiçado","NULL","NULL","a#00392460 a#00403517","NULL");
INSERT INTO portuguese_index VALUES ("derivação","n#00392468 n#05780718 n#06744154 n#08508105 n#13462387","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("logaritimicamente","NULL","NULL","NULL","r#00392531");
INSERT INTO portuguese_index VALUES ("mais_longo","NULL","NULL","NULL","r#00392690");
INSERT INTO portuguese_index VALUES ("mais_comprido","NULL","NULL","NULL","r#00392690");
INSERT INTO portuguese_index VALUES ("por_mais_tempo","NULL","NULL","NULL","r#00392690");
INSERT INTO portuguese_index VALUES ("o_mais_comprido","NULL","NULL","NULL","r#00392782");
INSERT INTO portuguese_index VALUES ("atro","NULL","NULL","a#00367459","NULL");
INSERT INTO portuguese_index VALUES ("preto","n#03877202 n#09638009","NULL","a#00367459","NULL");
INSERT INTO portuguese_index VALUES ("apontar","n#00815644","v#00272798 v#00625042 v#00924431 v#00625553 v#00955472 v#00685329 v#00781920 v#00782363","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cândido","n#03877535","NULL","a#00367747 a#02271544","NULL");
INSERT INTO portuguese_index VALUES ("alvo","n#03877535 n#04586952 n#05419337","NULL","a#00367747","NULL");
INSERT INTO portuguese_index VALUES ("ablação","n#00393369","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("puro","NULL","NULL","a#00393508 a#01116978 a#01835892 a#01053037","NULL");
INSERT INTO portuguese_index VALUES ("aclimar","NULL","v#00393677","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aclimatar","NULL","v#00393677","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intenso","NULL","NULL","a#00368180 a#00764129 a#01447403 a#01449858 a#01451847","NULL");
INSERT INTO portuguese_index VALUES ("sincronizar","NULL","v#00393953 v#00464828 v#00464996 v#00735866 v#00960734 v#02739254","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colorido(a)","NULL","NULL","a#00394135","NULL");
INSERT INTO portuguese_index VALUES ("autotomia","n#00394242","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Autotomia","n#00394242","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descontaminação","n#00394485","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colorido","NULL","NULL","a#00394562 a#00375007 a#00406867","NULL");
INSERT INTO portuguese_index VALUES ("deletamento","n#00254500","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deleção","n#00254500","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("denudação","n#00394803","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fundir","NULL","v#00274169 v#00275897 v#00444629 v#00332368","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rússeo","NULL","NULL","a#00372041","NULL");
INSERT INTO portuguese_index VALUES ("rúbido","NULL","NULL","a#00372041","NULL");
INSERT INTO portuguese_index VALUES ("rubicundo","NULL","NULL","a#00372041","NULL");
INSERT INTO portuguese_index VALUES ("rubro","n#03879230","NULL","a#00372041 a#00531887","NULL");
INSERT INTO portuguese_index VALUES ("rúbeo","NULL","NULL","a#00372041","NULL");
INSERT INTO portuguese_index VALUES ("rufo","NULL","NULL","a#00372041","NULL");
INSERT INTO portuguese_index VALUES ("escarlate","n#03879230 n#04964977","NULL","a#00372041","NULL");
INSERT INTO portuguese_index VALUES ("Circuncisao","n#00395654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Circuncisão","n#00395654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("circuncisão","n#00395654 n#01031194","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("drenagem","n#00396029","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dreno","n#00396029","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("águas_residuais","n#00396029 n#14857021","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bicolor","NULL","NULL","a#00396115","NULL");
INSERT INTO portuguese_index VALUES ("enxaguadura","n#00396642","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enxaguadelas","n#00396642","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aliar","NULL","v#00396880","NULL","NULL");
INSERT INTO portuguese_index VALUES ("castração","n#00397010 n#00667847 n#00179384","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_significativa","NULL","NULL","NULL","r#00397327");
INSERT INTO portuguese_index VALUES ("censura","n#00254803 n#00525511","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmoronar","NULL","v#00397405 v#01989053 v#01395145","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cair_aos_pedaços","NULL","v#00397405","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfazer-se","NULL","v#00397405 v#01521543","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desintegrar","NULL","v#00397576","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segmentação","n#00255068 n#13449156","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("partição","n#00255068 n#00703319 n#13627114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ouro-colorido","NULL","NULL","a#00398172","NULL");
INSERT INTO portuguese_index VALUES ("medianamente","NULL","NULL","NULL","r#00398528");
INSERT INTO portuguese_index VALUES ("transformação","n#00255421 n#00399030 n#05481414 n#09927401","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("macerar","NULL","v#00398953","NULL","NULL");
INSERT INTO portuguese_index VALUES ("multicor","NULL","NULL","a#00398978","NULL");
INSERT INTO portuguese_index VALUES ("multicolor","NULL","NULL","a#00398978","NULL");
INSERT INTO portuguese_index VALUES ("gorar","NULL","v#00399553","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmagnetizar","NULL","v#00400101 v#00998762","NULL","NULL");
INSERT INTO portuguese_index VALUES ("no_duro","NULL","NULL","NULL","r#00400192");
INSERT INTO portuguese_index VALUES ("florestamento","n#00256511","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("florestação","n#00256511","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("simplificar","NULL","v#00400427","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reflorestação","n#00400449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cobertura_vegetal_(restauração)","n#00400449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reflorestamento","n#00400449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ruão","NULL","NULL","a#00400472","NULL");
INSERT INTO portuguese_index VALUES ("complicar","NULL","v#00278110 v#00279361","NULL","NULL");
INSERT INTO portuguese_index VALUES ("refinar","NULL","v#00278110 v#00330153 v#00330354","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tricolor","n#04481796","NULL","a#00401125","NULL");
INSERT INTO portuguese_index VALUES ("renovação_urbana","n#00401194","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Recreação","n#00401783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recreação","n#00401783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("metamorfose","n#00402128 n#00402308 n#13514880","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enchimento_(materiais)","n#00402671","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enchimento","n#00402671 n#07883031","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saturação","n#00402671","NULL","a#00757408","NULL");
INSERT INTO portuguese_index VALUES ("milagrosamente","NULL","NULL","NULL","r#00402764");
INSERT INTO portuguese_index VALUES ("miseràvel","NULL","NULL","NULL","r#00402938");
INSERT INTO portuguese_index VALUES ("miseravelmente","NULL","NULL","NULL","r#00402938");
INSERT INTO portuguese_index VALUES ("revenido","n#00402951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("danificação","n#00258668","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deterioração","n#00258668 n#13456715 n#13464204","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfiguração","n#00403466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfiguramento","n#00403466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ferimento","n#00403783 n#10257907","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("queimadura","n#00403911 n#04694090 n#14289590","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despressurizar","NULL","v#00403967","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descompactar","NULL","v#00403967","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mortalmente","NULL","NULL","NULL","r#00404073");
INSERT INTO portuguese_index VALUES ("estruturar","NULL","v#00280835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reconstituir","NULL","v#00404401","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coordenar","NULL","v#00281123 v#02437905 v#02438228","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deformação","n#00259853 n#05480717 n#05530333","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convolução","n#00404959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("angulação","n#00405106","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sóbrio","NULL","NULL","a#00405179 a#00654166 a#00799517","NULL");
INSERT INTO portuguese_index VALUES ("inflexão","n#00405206","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("centralizar","NULL","v#00281483","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desconcentrar","NULL","v#00405540","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descentralizar","NULL","v#00405540","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mutuamente","NULL","NULL","NULL","r#00405645");
INSERT INTO portuguese_index VALUES ("mutualmente","NULL","NULL","NULL","r#00405645");
INSERT INTO portuguese_index VALUES ("estardecócoras","n#00405766","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pálido","NULL","NULL","a#00405879 a#00380084","NULL");
INSERT INTO portuguese_index VALUES ("palpite","n#00406114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inocentemente","NULL","NULL","NULL","r#00406157");
INSERT INTO portuguese_index VALUES ("aprontar","NULL","v#00282202","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preparar","NULL","v#00282202 v#00406963 v#00283094 v#00283642 v#01142893 v#01143604 v#01198518 v#01626290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estreitamento","n#00407407","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vistoso","NULL","NULL","a#00379319 a#02280733","NULL");
INSERT INTO portuguese_index VALUES ("ocupação","n#00261466 n#00381958 n#00582868 n#00382624 n#00383807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ruidoso","NULL","NULL","a#00407766 a#01850366","NULL");
INSERT INTO portuguese_index VALUES ("mais_perto","NULL","NULL","NULL","r#00407802");
INSERT INTO portuguese_index VALUES ("aquele_que_termina","NULL","NULL","NULL","r#00407802");
INSERT INTO portuguese_index VALUES ("mais_próximo","NULL","NULL","NULL","r#00407802");
INSERT INTO portuguese_index VALUES ("o_mais_perto","NULL","NULL","NULL","r#00408021");
INSERT INTO portuguese_index VALUES ("o_mais_justo","NULL","NULL","NULL","r#00408021");
INSERT INTO portuguese_index VALUES ("o_mais_próximo","NULL","NULL","NULL","r#00408021");
INSERT INTO portuguese_index VALUES ("sem_cor","NULL","NULL","a#00408031","NULL");
INSERT INTO portuguese_index VALUES ("incolor","NULL","NULL","a#00408031","NULL");
INSERT INTO portuguese_index VALUES ("internacionalizar","NULL","v#00409119","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nervosamente","NULL","NULL","NULL","r#00409200 r#00409459");
INSERT INTO portuguese_index VALUES ("pulvéreo","NULL","NULL","a#00409319 a#02233390","NULL");
INSERT INTO portuguese_index VALUES ("operação","n#00262937 n#00378984 n#00436664 n#00869583 n#00611703 n#00709934 n#09747131","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nunca_mais","NULL","NULL","NULL","r#00409597");
INSERT INTO portuguese_index VALUES ("americanizar","NULL","v#00409643 v#00410406","NULL","NULL");
INSERT INTO portuguese_index VALUES ("costume","n#00263204 n#00263789 n#00265102 n#00265920 n#00266254 n#04381279 n#04382516","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hábito","n#00263204 n#00265102 n#00265920 n#00266254 n#03398153 n#02783002 n#04381279 n#04382516","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cristão","n#06995978 n#09678917","NULL","a#00382498 a#00382668 a#02721959","NULL");
INSERT INTO portuguese_index VALUES ("modernizar","NULL","v#00285583","NULL","NULL");
INSERT INTO portuguese_index VALUES ("praxe","n#00263789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Praxis","n#00263789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("práxis","n#00263789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Práxis","n#00263789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("costumes","n#00263789 n#04381279 n#04382516","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("numericamente","NULL","NULL","NULL","r#00411171");
INSERT INTO portuguese_index VALUES ("civilizar","NULL","v#00411312 v#01626835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cooperação","n#00264082 n#00779286 n#00780822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nacionalizar","NULL","v#00411547","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estatizar","NULL","v#00411547","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_alguma","NULL","NULL","a#02267686","r#00411570");
INSERT INTO portuguese_index VALUES ("de_maneira_nenhuma","NULL","NULL","a#02267686","r#00411570");
INSERT INTO portuguese_index VALUES ("de_modo_algum","NULL","NULL","a#02267686","r#00411570");
INSERT INTO portuguese_index VALUES ("formalismo","n#00411717 n#05961867 n#05971621","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("privatizar","NULL","v#00411792 v#00412048","NULL","NULL");
INSERT INTO portuguese_index VALUES ("micofagia","n#00411859","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("civilizado","NULL","NULL","a#00383303 a#01455171","NULL");
INSERT INTO portuguese_index VALUES ("subjetivamente","NULL","NULL","NULL","r#00412178");
INSERT INTO portuguese_index VALUES ("Simbolismo","n#00264645","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("simbolismo","n#00264645 n#05098128","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("civil","n#09924742","NULL","a#00383796 a#01454970 a#01455171 a#02546488 a#02546684","NULL");
INSERT INTO portuguese_index VALUES ("modernismo","n#00264755","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Modernismo","n#00264755","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("humano","NULL","NULL","a#00383901 a#01207270 a#01210344 a#02575805 a#02575899","NULL");
INSERT INTO portuguese_index VALUES ("gentio","NULL","NULL","a#00384214","NULL");
INSERT INTO portuguese_index VALUES ("bravio","NULL","NULL","a#00384214","NULL");
INSERT INTO portuguese_index VALUES ("bárbaro","n#10553402","NULL","a#00384214 a#01212393","NULL");
INSERT INTO portuguese_index VALUES ("selvagem","n#10553402","NULL","a#00384214 a#02276745","NULL");
INSERT INTO portuguese_index VALUES ("Canibalismo","n#00412839","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antropofagia","n#00412839 n#00412982","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("canibalismo","n#00412839","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adotar_como_própria","NULL","v#00287066","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adotar","NULL","v#00287066 v#01602202 v#01602355","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adoptar","NULL","v#00287066 v#01509715 v#02324026 v#01602202 v#01602355","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emprego","n#00265102 n#00381958 n#00582868 n#00383807 n#03631348 n#06283459","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("primitivo","NULL","NULL","a#00413432 a#00774150 a#00778594 a#00779258","NULL");
INSERT INTO portuguese_index VALUES ("imigrar","NULL","v#00413432 v#00413704 v#00415967","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clássico","n#03038595 n#09926426","NULL","a#00385079 a#00413861 a#02185136 a#02298152 a#02698145","NULL");
INSERT INTO portuguese_index VALUES ("neoclássico","NULL","NULL","a#00414080","NULL");
INSERT INTO portuguese_index VALUES ("colonizar","NULL","v#00287786 v#02590340","NULL","NULL");
INSERT INTO portuguese_index VALUES ("moderno","NULL","NULL","a#00385718 a#00668208 a#01473088 a#01472209 a#01804618","NULL");
INSERT INTO portuguese_index VALUES ("contemporâneo","NULL","NULL","a#00385718 a#00629488 a#00778835 a#01473088 a#01472209 a#01472664 a#01804618 a#02266362 a#02266780","NULL");
INSERT INTO portuguese_index VALUES ("popular","NULL","NULL","a#00414518 a#00681477 a#01536434 a#01744822","NULL");
INSERT INTO portuguese_index VALUES ("opcionalmente","NULL","NULL","NULL","r#00414619");
INSERT INTO portuguese_index VALUES ("classificado","NULL","NULL","a#00414709","NULL");
INSERT INTO portuguese_index VALUES ("obrigatoriamente","NULL","NULL","NULL","r#00414750");
INSERT INTO portuguese_index VALUES ("categorizado","NULL","NULL","a#00414823","NULL");
INSERT INTO portuguese_index VALUES ("luxar","NULL","v#00287938","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deslocar","NULL","v#00287938 v#01249365 v#01374681 v#01285412","NULL","NULL");
INSERT INTO portuguese_index VALUES ("povoar","NULL","v#00288116 v#00451279 v#00315029 v#01809405","NULL","NULL");
INSERT INTO portuguese_index VALUES ("organizacionalmente","NULL","NULL","NULL","r#00415058");
INSERT INTO portuguese_index VALUES ("enraizar","NULL","v#00415398","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escravidão","n#00415442 n#00623545 n#13997253","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modo_de_vida","n#00266805","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confidencial","NULL","NULL","a#00415696 a#00452605 a#01788995 a#01789223","NULL");
INSERT INTO portuguese_index VALUES ("demasiadamente","NULL","NULL","NULL","r#00415963");
INSERT INTO portuguese_index VALUES ("emigrar","NULL","v#00416135 v#01856626","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expatriar","NULL","v#00416399","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Suna","n#00416409","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("analisado","NULL","NULL","a#00416765","NULL");
INSERT INTO portuguese_index VALUES ("ser_igual_a","NULL","v#00416880","NULL","NULL");
INSERT INTO portuguese_index VALUES ("equiparar","NULL","v#00289728 v#00653620","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chave-de-braço","n#00417131","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abraço","n#00268156 n#00417859","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limpo","NULL","NULL","a#00388571 a#00389229","NULL");
INSERT INTO portuguese_index VALUES ("enrijecer","NULL","v#00417596","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_meio_de","NULL","NULL","NULL","r#00417787");
INSERT INTO portuguese_index VALUES ("engomar","n#15018889","v#00417856","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limpável","NULL","NULL","a#00417898","NULL");
INSERT INTO portuguese_index VALUES ("mau_tratamento","n#00418025","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imaculado","NULL","NULL","a#00389579 a#01835400","NULL");
INSERT INTO portuguese_index VALUES ("irritação","n#00270946 n#00792860 n#04491038 n#07518261 n#05589637 n#07518878 n#10337915","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inrijecer","NULL","v#00290685","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sossegar","NULL","v#00291639","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sujado","NULL","NULL","a#00390524","NULL");
INSERT INTO portuguese_index VALUES ("suja","NULL","NULL","a#00390524 a#00394778","NULL");
INSERT INTO portuguese_index VALUES ("sujo","NULL","NULL","a#00390524 a#00391672 a#00421590 a#00394778 a#00407480 a#00910510 a#01587474","NULL");
INSERT INTO portuguese_index VALUES ("Blaxploitation","n#00419315","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afrouxar","NULL","v#00291365 v#00293010","NULL","NULL");
INSERT INTO portuguese_index VALUES ("percepcionalmente","NULL","NULL","NULL","r#00419876");
INSERT INTO portuguese_index VALUES ("injúria","n#00268796 n#00479622 n#00794210 n#00794619 n#05036589 n#06720600","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abuso","n#00268796 n#00606110","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abuso_infantil","n#00420218","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perpendicularmente","NULL","NULL","NULL","r#00420382 r#00452126");
INSERT INTO portuguese_index VALUES ("encardido","NULL","NULL","a#00391672","NULL");
INSERT INTO portuguese_index VALUES ("grudento","NULL","NULL","a#00391672","NULL");
INSERT INTO portuguese_index VALUES ("opressão","n#00421047 n#07538674 n#13996719","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pogrom","n#00421210","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tortura","n#00421437 n#05572211 n#14333433","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ausentar","NULL","v#00421535","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imunda","NULL","NULL","a#00421590","NULL");
INSERT INTO portuguese_index VALUES ("sórdido","NULL","NULL","a#00392798","NULL");
INSERT INTO portuguese_index VALUES ("caldear","NULL","v#00421917","NULL","NULL");
INSERT INTO portuguese_index VALUES ("surgir","NULL","v#00293860 v#00297068 v#01357011 v#02624263","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aparecer","NULL","v#00293860 v#00294626 v#00295748 v#00297068 v#00369654 v#01839722","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gordo","NULL","NULL","a#00422168 a#00987180 a#00939455 a#00992432","NULL");
INSERT INTO portuguese_index VALUES ("piolhoso","NULL","NULL","a#00422374","NULL");
INSERT INTO portuguese_index VALUES ("crucificação","n#00422551 n#01165337","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gulosamente","NULL","NULL","NULL","r#00422619");
INSERT INTO portuguese_index VALUES ("ranhoso","NULL","NULL","a#00423269 a#01890382","NULL");
INSERT INTO portuguese_index VALUES ("mostrar-se","NULL","v#00294626","NULL","NULL");
INSERT INTO portuguese_index VALUES ("publicar-se","NULL","v#00423971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sair_à_luz","NULL","v#00423971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vir_a_lume","NULL","v#00423971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destacar-se","NULL","v#00423971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("privação_de_sono","n#00424186","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irromper","NULL","v#00295058","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crueldade","n#00270022 n#03787057 n#03797439 n#05579830","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atrocidade","n#00424767 n#00425090 n#00746033 n#03786431","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("barbarismo","n#00270320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("barbárie","n#00270320 n#04830689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("actodebárbaro","n#00270320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obsceno","NULL","NULL","a#00407480 a#00425740 a#00684163","NULL");
INSERT INTO portuguese_index VALUES ("exasperação","n#00425451 n#07518878","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comparecer","NULL","v#00296004","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impudico","NULL","NULL","a#00425740","NULL");
INSERT INTO portuguese_index VALUES ("Assédio_Sexual","n#00425781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assédio_sexual","n#00425781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sair","NULL","v#00296448 v#00369654 v#01258127 v#01370454 v#01371248","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bruxos","n#00426275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Caça_às_Bruxas","n#00426275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caça_às_bruxas","n#00426275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Caça_as_bruxas","n#00426275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reaparecer","NULL","v#00426301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Macartismo","n#00426388","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colonialismo","n#00426526","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("neocolonialismo","n#00426757","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("radioativo","NULL","NULL","a#00426907","NULL");
INSERT INTO portuguese_index VALUES ("radioactivo","NULL","NULL","a#00426907","NULL");
INSERT INTO portuguese_index VALUES ("radiativo","NULL","NULL","a#00426907","NULL");
INSERT INTO portuguese_index VALUES ("recreaçao","n#00272358","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diversão","n#00272358 n#00429048 n#00818628","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sumir","NULL","v#00297331 v#01360050","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacanagem","n#00331225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gozação","n#00331225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("travessura","n#00331225 n#03844003","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("minimizar","NULL","v#00427802 v#00308615 v#00841125 v#00573480 v#00864475","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comportepago","NULL","NULL","NULL","r#00427829");
INSERT INTO portuguese_index VALUES ("franqueado","NULL","NULL","NULL","r#00427829");
INSERT INTO portuguese_index VALUES ("borne-pago","NULL","NULL","NULL","r#00427829");
INSERT INTO portuguese_index VALUES ("poderosamente","NULL","NULL","NULL","r#00427944 r#00428245");
INSERT INTO portuguese_index VALUES ("festividade","n#00328496 n#15161631 n#10881782","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("festa","n#00328496 n#05538537 n#05538738 n#07448038 n#07449862 n#05539623 n#05539741 n#06126536 n#08253045 n#08253640 n#06167318","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("celebração","n#00328496 n#00509846 n#05539623","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intocável","NULL","NULL","a#00428243 a#01761742 a#02526725","NULL");
INSERT INTO portuguese_index VALUES ("dança","n#00337330 n#05266564","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("baile","n#00337330 n#05266564 n#07448717 n#07448885","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maximizar","NULL","v#00428583 v#00428870","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entretenimento","n#00429048","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entreterimento","n#00429048 n#00330345 n#00273579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divertimento","n#00429048 n#00330345 n#00515414 n#01072072 n#00818628","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("límpido","NULL","NULL","a#00399098 a#00401511","NULL");
INSERT INTO portuguese_index VALUES ("escapismo","n#00429440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predizivelmente","NULL","NULL","NULL","r#00429815");
INSERT INTO portuguese_index VALUES ("previsivelmente","NULL","NULL","NULL","r#00429815");
INSERT INTO portuguese_index VALUES ("vivaz","NULL","NULL","a#00399675 a#01872076","NULL");
INSERT INTO portuguese_index VALUES ("aposta","n#00325752 n#00326232 n#09607916","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogo_de_azar","n#00325752 n#00325752","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confuso","NULL","NULL","a#00399807 a#00400522 a#00434112 a#01924803","NULL");
INSERT INTO portuguese_index VALUES ("nublado","NULL","NULL","a#00430545 a#00436544 a#00461311 a#00430656","NULL");
INSERT INTO portuguese_index VALUES ("passatempo","n#00291567 n#00273579 n#00432689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hobby","n#00291567 n#00432689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desconcertante","NULL","NULL","a#00400522 a#00711482 a#01737277","NULL");
INSERT INTO portuguese_index VALUES ("intrigante","NULL","NULL","a#00400522 a#01344684 a#01897106","NULL");
INSERT INTO portuguese_index VALUES ("brincadeira","n#00331800 n#00511817 n#05077026","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avolumar","NULL","v#00300448","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engrossar","NULL","v#00300448","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogo","n#00273579 n#00431893 n#00289269 n#00289585 n#00290820 n#05542799 n#05990251 n#10090684 n#15256714 n#15256915","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espessar","NULL","v#00300599","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transparente","NULL","NULL","a#00401511 a#01561343","NULL");
INSERT INTO portuguese_index VALUES ("transcorrer","NULL","v#00300986","NULL","NULL");
INSERT INTO portuguese_index VALUES ("translúcido","NULL","NULL","a#00432626 a#01136895","NULL");
INSERT INTO portuguese_index VALUES ("Passatempos","n#00432689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Passa-tempo","n#00432689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("com_competência","NULL","NULL","NULL","r#00432997");
INSERT INTO portuguese_index VALUES ("de_forma_proficiente","NULL","NULL","NULL","r#00432997");
INSERT INTO portuguese_index VALUES ("com_habilidade","NULL","NULL","NULL","r#00432997");
INSERT INTO portuguese_index VALUES ("tombar","NULL","v#00301772","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_proibitiva","NULL","NULL","NULL","r#00433247");
INSERT INTO portuguese_index VALUES ("proibitivamente","NULL","NULL","NULL","r#00433247");
INSERT INTO portuguese_index VALUES ("ginástica","n#00433802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ginástica","n#00433802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ginastica","n#00433802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("definhar","NULL","v#00302438","NULL","NULL");
INSERT INTO portuguese_index VALUES ("geado","NULL","NULL","a#00433972","NULL");
INSERT INTO portuguese_index VALUES ("acrobacia","n#00434075","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acobatismo","n#00434075","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("glauco","NULL","NULL","a#00434097","NULL");
INSERT INTO portuguese_index VALUES ("lácteo","NULL","NULL","a#00403517","NULL");
INSERT INTO portuguese_index VALUES ("estrelinha","n#00276193","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estrela","n#00276193 n#09239740 n#06762045 n#09444783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("psicologicamente","NULL","NULL","NULL","r#00434921 r#00435142");
INSERT INTO portuguese_index VALUES ("desenovelar","NULL","v#00303689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfraldar","NULL","v#00303689","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perplexo","NULL","NULL","a#00404496 a#00434112 a#01610144 a#01624304 a#01701024 a#01766133","NULL");
INSERT INTO portuguese_index VALUES ("propositalmente","NULL","NULL","NULL","r#00436088");
INSERT INTO portuguese_index VALUES ("propositadamente","NULL","NULL","NULL","r#00436088");
INSERT INTO portuguese_index VALUES ("qualitativamente","NULL","NULL","NULL","r#00436676");
INSERT INTO portuguese_index VALUES ("trimestralmente","NULL","NULL","NULL","r#00436848");
INSERT INTO portuguese_index VALUES ("diversificar","NULL","v#00437125","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estranhamente","NULL","NULL","NULL","r#00437381");
INSERT INTO portuguese_index VALUES ("clemente","NULL","NULL","a#00437539 a#00438166","NULL");
INSERT INTO portuguese_index VALUES ("especializar","NULL","v#00305536","NULL","NULL");
INSERT INTO portuguese_index VALUES ("questionavelmente","NULL","NULL","NULL","r#00437796");
INSERT INTO portuguese_index VALUES ("agilizar","NULL","v#00305843","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acelerar","NULL","v#00305843 v#00306811 v#00320978 v#01405887 v#01737793","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apressar","NULL","v#00305843 v#00306811 v#00320830 v#00320978 v#01405887 v#01408362 v#01737793","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desacelerar","NULL","v#00438495 v#00439958 v#00307579 v#00307731","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atrasar","NULL","v#00306237 v#00307430 v#00321115 v#00321868","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desdobramento_de_ações","n#00439043","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adiantar","NULL","v#00306811","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sonso","NULL","NULL","a#00408403","NULL");
INSERT INTO portuguese_index VALUES ("idiota","n#07216129 n#10039391 n#10100761 n#07308238 n#10197525 n#10358794 n#10496393 n#10599354 n#10667187 n#07654252","NULL","a#00408403 a#00409196 a#01283588","NULL");
INSERT INTO portuguese_index VALUES ("imbecil","n#10039391 n#10100761 n#10197525 n#10667187","NULL","a#00408403 a#00409196","NULL");
INSERT INTO portuguese_index VALUES ("estúpido","n#10039391 n#10100761 n#07308238 n#10197525 n#10358794 n#10496393 n#10599354 n#10667187 n#07654252","NULL","a#00408403 a#00408666 a#00409196 a#01336587","NULL");
INSERT INTO portuguese_index VALUES ("atletismo","n#00439826 n#00886582","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salto_em_comprimento","n#00440382","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Salto_em_Comprimento","n#00440382","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salto_em_altura","n#00440509","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fátuo","NULL","NULL","a#00409196","NULL");
INSERT INTO portuguese_index VALUES ("remotamente","NULL","NULL","NULL","r#00440745 r#00440845");
INSERT INTO portuguese_index VALUES ("esqui","n#00440747 n#04228054","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Esqui","n#00440747","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retardar","n#00689955","v#00307731","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Salto_de_esqui","n#00441073","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salto_de_esqui","n#00441073","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dextrogiro","NULL","NULL","a#00441927","NULL");
INSERT INTO portuguese_index VALUES ("nadada","n#00442115","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Natação","n#00442115","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("natação","n#00442115","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("levogiro","NULL","NULL","a#00442255","NULL");
INSERT INTO portuguese_index VALUES ("gaseificar","NULL","v#00442267","NULL","NULL");
INSERT INTO portuguese_index VALUES ("longínquo","NULL","NULL","a#00410709 a#00411449 a#00411646 a#00419892 a#00451155 a#01377805","NULL");
INSERT INTO portuguese_index VALUES ("banhe","n#00280090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por_atacado","NULL","NULL","NULL","r#00442774");
INSERT INTO portuguese_index VALUES ("mergulho","n#00442847","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coalhar","NULL","v#00309228 v#00320040","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Salto_ornamental","n#00442981","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remoto","NULL","NULL","a#00411449 a#00415243 a#00541614","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_retrospectiva","NULL","NULL","NULL","r#00443097");
INSERT INTO portuguese_index VALUES ("retrospectivamente","NULL","NULL","NULL","r#00443097");
INSERT INTO portuguese_index VALUES ("Induração","NULL","v#00309461","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_distante","NULL","NULL","a#00443490","NULL");
INSERT INTO portuguese_index VALUES ("liquefazer","NULL","v#00310006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vizinho","n#06363890 n#09368224 n#06949059 n#07429701","NULL","a#00412848 a#00533304","NULL");
INSERT INTO portuguese_index VALUES ("mergulho_autônomo","n#00444846","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contíguo","NULL","NULL","a#00444984 a#00416294 a#00418121 a#00533304 a#00566961","NULL");
INSERT INTO portuguese_index VALUES ("Surfe","n#00445055","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("próximoa","NULL","NULL","a#00413658","NULL");
INSERT INTO portuguese_index VALUES ("pertode","NULL","NULL","a#00413658","NULL");
INSERT INTO portuguese_index VALUES ("juntode","NULL","NULL","a#00413658","NULL");
INSERT INTO portuguese_index VALUES ("juntoa","NULL","NULL","a#00413658","NULL");
INSERT INTO portuguese_index VALUES ("solidificar","NULL","v#00445169 v#00445467","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acalorado","NULL","NULL","a#00414282","NULL");
INSERT INTO portuguese_index VALUES ("calmoso","NULL","NULL","a#00414282","NULL");
INSERT INTO portuguese_index VALUES ("quente","NULL","NULL","a#00414282 a#01247240 a#02056997","NULL");
INSERT INTO portuguese_index VALUES ("remo","n#00445351 n#03837422 n#03873416","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pugilismo","n#00445802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("boxe","n#00445802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("combate","n#00283141 n#00609840 n#00610417 n#00619159 n#00758807 n#00759769 n#01236296 n#05554348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luta","n#00283141 n#00283913 n#00622068 n#00622266 n#00505798 n#00789391 n#00610417 n#00614914 n#00619159 n#00758807 n#00759560 n#00759769 n#05554348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_esquemática","NULL","NULL","NULL","r#00446735");
INSERT INTO portuguese_index VALUES ("esquematicamente","NULL","NULL","NULL","r#00446735");
INSERT INTO portuguese_index VALUES ("reagir","NULL","v#00311901 v#00485595","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arco-e-flecha","n#00446980","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tiro_com_arco","n#00446980","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dissolver","NULL","v#00312214 v#00312524","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apenso","NULL","NULL","a#00416294","NULL");
INSERT INTO portuguese_index VALUES ("adjacente","NULL","NULL","a#00416294 a#00533304","NULL");
INSERT INTO portuguese_index VALUES ("Grappling","n#00283913","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("circundante","NULL","NULL","a#00447753","NULL");
INSERT INTO portuguese_index VALUES ("luta_greco-romana","n#00447957","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Wrestling_profissional","n#00448126","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("wrestling","n#00448126","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sumô","n#00448232","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("seletivamente","NULL","NULL","NULL","r#00448282");
INSERT INTO portuguese_index VALUES ("iminente","NULL","NULL","a#00417100 a#01668941","NULL");
INSERT INTO portuguese_index VALUES ("invalidar","NULL","v#00312840 v#00800460 v#01688749","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patinação_no_gelo","n#00448640","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Patinagem_no_gelo","n#00448640","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esvaziar","NULL","v#00313029 v#00313984","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Patinação_Artística_no_gelo","n#00448748","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Patinação_artística_no_gelo","n#00448748","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patinação_artística","n#00448748","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Patinação_sobre_rodas","n#00448958","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escoar","NULL","v#00313342 v#01417934","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Skate","n#00449054","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imediato","NULL","NULL","a#00418121 a#00733113 a#01523796 a#01863475","NULL");
INSERT INTO portuguese_index VALUES ("Patinação_de_velocidade","n#00449168","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Patinação_de_Velocidade","n#00449168","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Esportes_de_corrida","n#00449295","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evacuar","NULL","v#00449295 v#00449567 v#02014024 v#01421290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("envolvente","NULL","NULL","a#00449332","NULL");
INSERT INTO portuguese_index VALUES ("Automobilismo","n#00449517","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("automobilismo","n#00449517","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evaziar","NULL","v#00313984","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Turfe","n#00450070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("equitação","n#00450335 n#05638374","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preencher","NULL","v#00451279 v#00690164","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ciclismo","n#00451370","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ciclismo","n#00451370","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("povoar-se","NULL","v#00315029","NULL","NULL");
INSERT INTO portuguese_index VALUES ("drenar","NULL","v#00315126 v#01158022","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Desportos_sangrentos","n#00451866","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Desporto_sangrento","n#00451866","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tourada","n#00452034 n#02917163","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tauromaquia","n#00452034","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caça","n#00287066 n#00410109 n#01661356 n#02676348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("completar","NULL","v#00315864 v#00318530 v#00455919","NULL","NULL");
INSERT INTO portuguese_index VALUES ("batida_policial","n#00452734","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("íntimo","NULL","NULL","a#00421977 a#00477284","NULL");
INSERT INTO portuguese_index VALUES ("familiar","n#09545171","NULL","a#00421977 a#00994581 a#02712817","NULL");
INSERT INTO portuguese_index VALUES ("caça_à_raposa","n#00453478","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agricultura","n#00453731 n#00588753 n#00918176 n#00715321","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pesca","n#00288131","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pesca","n#00288131 n#00288265","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pescas","n#00288131 n#00288265","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pesca_à_linha","n#00288131 n#00454237","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fundição","n#00288600 n#00909899 n#03387653","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("puxar_descarga","NULL","v#00454868","NULL","NULL");
INSERT INTO portuguese_index VALUES ("continuação","n#00455348 n#00657384 n#04823659 n#05441038","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inteirar","NULL","v#00318530 v#00404522","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imbuir","NULL","v#00318860","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saturar","NULL","v#00456357","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Jogo_Amistoso","n#00456899","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Jogo_amistoso","n#00456899","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homogenizar","NULL","v#00457100","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vez","n#00290820 n#05449233 n#10391300 n#10984524","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ataque","n#00291138 n#00494444 n#00625655 n#00629246","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Aberturas_de_xadrez","n#00457890","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nu","NULL","NULL","a#00427123","NULL");
INSERT INTO portuguese_index VALUES ("pelado","NULL","NULL","a#00427123 a#02354234","NULL");
INSERT INTO portuguese_index VALUES ("despido","NULL","NULL","a#00427123","NULL");
INSERT INTO portuguese_index VALUES ("descoberto","NULL","NULL","a#00427123","NULL");
INSERT INTO portuguese_index VALUES ("coagular","NULL","v#00320199","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_cabelo","NULL","NULL","a#00458664","NULL");
INSERT INTO portuguese_index VALUES ("vídeo_game","n#00458890","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogo_de_vídeo","n#00458890","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("videojogo","n#00458890","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("videogame","n#00458890","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_fundo","NULL","NULL","a#00458940 a#00690892 a#01415917 a#02443005","NULL");
INSERT INTO portuguese_index VALUES ("realidade_virtual","n#00459013 n#00459013","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Jogos_de_pinball","n#00459284","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pinball","n#00459284","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instar","NULL","v#00320830","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pachinko","n#00459465","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_obscena","NULL","NULL","NULL","r#00459521");
INSERT INTO portuguese_index VALUES ("peddy-paper","n#00460706","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nítido","NULL","NULL","a#00429560","NULL");
INSERT INTO portuguese_index VALUES ("Rodada_dupla","n#00460951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dobradinha","n#00460951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calar","NULL","v#00322396","NULL","NULL");
INSERT INTO portuguese_index VALUES ("silenciar","NULL","v#00461493 v#01204371","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nevoeirento","NULL","NULL","a#00430514 a#02549569","NULL");
INSERT INTO portuguese_index VALUES ("Curling","n#00461611","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grandemente","NULL","NULL","NULL","r#00461617");
INSERT INTO portuguese_index VALUES ("dolorosamente","NULL","NULL","NULL","r#00461617 r#00509533");
INSERT INTO portuguese_index VALUES ("Boliche","n#00461782","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para_o_sudeste","NULL","NULL","NULL","r#00462016");
INSERT INTO portuguese_index VALUES ("bolão","n#00462383 n#09608092","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Lawn_Bowls","n#00462804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lawn_bowls","n#00462804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("litorâneo","NULL","NULL","a#00431439","NULL");
INSERT INTO portuguese_index VALUES ("costeiro","NULL","NULL","a#00431439","NULL");
INSERT INTO portuguese_index VALUES ("esporte","n#00463246 n#00274505","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marítimo","NULL","NULL","a#00431947 a#02671223","NULL");
INSERT INTO portuguese_index VALUES ("achatar","NULL","v#00463469 v#00323924","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hóquei_no_gelo","n#00463543","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hóquei","n#00463543","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hóquei","n#00463543 n#00467995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guarda-redes","n#00464037 n#07293634","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("keeper","n#00464037","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Espirobol","n#00464277","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alinhar","NULL","v#00324261 v#00781082","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pólo_aquático","n#00464478","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consequente","NULL","NULL","a#00433594","NULL");
INSERT INTO portuguese_index VALUES ("lógico","n#10269785","NULL","a#00433594 a#01373247 a#01857552 a#02379915","NULL");
INSERT INTO portuguese_index VALUES ("sem_improvisos","NULL","NULL","a#00464845","NULL");
INSERT INTO portuguese_index VALUES ("sem_remendos","NULL","NULL","a#00464845","NULL");
INSERT INTO portuguese_index VALUES ("sem_emenda","NULL","NULL","a#00464845","NULL");
INSERT INTO portuguese_index VALUES ("golfe","n#00297363","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("realinhar","NULL","v#00465145","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confundido","NULL","NULL","a#00434112 a#00497363","NULL");
INSERT INTO portuguese_index VALUES ("deslocar-se","NULL","v#00465762","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incorporada","NULL","v#00325575","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incorporar","NULL","v#00325575 v#01060691 v#01840295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("integrar","NULL","v#00325575 v#00326149 v#00434288","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cróquet","n#00466880","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("croquet","n#00466880","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Paint_ball","n#00467122","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Paintball","n#00467122","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reincorporar","NULL","v#00467346","NULL","NULL");
INSERT INTO portuguese_index VALUES ("à_volta","NULL","NULL","NULL","r#00467686 r#00467810");
INSERT INTO portuguese_index VALUES ("em_redor","NULL","NULL","NULL","r#00467686 r#00467810");
INSERT INTO portuguese_index VALUES ("padronizar","NULL","v#00467717 v#00682436","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hóquei_em_campo","n#00467995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hóquei_em_Campo","n#00467995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hoquei_em_campo","n#00467995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hóquei_sobre_grama","n#00467995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("àquele","NULL","NULL","NULL","r#00468219");
INSERT INTO portuguese_index VALUES ("futebol","n#00299231 n#00304700 n#03378765 n#04254680","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imanente","NULL","NULL","a#00468574 a#01221591","NULL");
INSERT INTO portuguese_index VALUES ("reorientar","NULL","v#00468791","NULL","NULL");
INSERT INTO portuguese_index VALUES ("orientar","NULL","v#00468791 v#01853220","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estrategicamente","NULL","NULL","NULL","r#00469068");
INSERT INTO portuguese_index VALUES ("Desgaste","NULL","v#00469382","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esmerilar","NULL","v#00469382","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desgastar","NULL","v#00469382 v#01254324","NULL","NULL");
INSERT INTO portuguese_index VALUES ("futebol_americano","n#00469651 n#00469651","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("neutralizar","NULL","v#00469904 v#00328042 v#00905566 v#02543874","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anular","n#05567489","v#00328042 v#00543473 v#00688807 v#02477334 v#01688749 v#02478584","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comercializar","NULL","v#00470386 v#01164725","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aniquilar","NULL","v#00470701 v#00472230","NULL","NULL");
INSERT INTO portuguese_index VALUES ("devastar","NULL","v#00470701 v#01257507","NULL","NULL");
INSERT INTO portuguese_index VALUES ("massacrar","NULL","v#00470701 v#00479176","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dizimar","NULL","v#00470701 v#00471058","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hurling","n#00470830","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("râguebi","n#00470966","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rúgbi","n#00470966","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inédito","NULL","NULL","a#00439077","NULL");
INSERT INTO portuguese_index VALUES ("extinguir","NULL","v#00328583 v#00328742 v#00333158 v#00333569 v#01327582 v#01080585 v#01886493","NULL","NULL");
INSERT INTO portuguese_index VALUES ("basebol","n#00471613 n#02799071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beisebol","n#00471613 n#02799071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eliminar","NULL","v#00328742 v#00685419 v#01327582 v#01066739 v#01114673","NULL","NULL");
INSERT INTO portuguese_index VALUES ("que_se_pode_relatar","NULL","NULL","a#00472057","NULL");
INSERT INTO portuguese_index VALUES ("informável","NULL","NULL","a#00472057","NULL");
INSERT INTO portuguese_index VALUES ("que_se_pode_informar","NULL","NULL","a#00472057","NULL");
INSERT INTO portuguese_index VALUES ("relatável","NULL","NULL","a#00472057","NULL");
INSERT INTO portuguese_index VALUES ("combinatório","NULL","NULL","a#00472336 a#00472534 a#00472694 a#01331244","NULL");
INSERT INTO portuguese_index VALUES ("cortar","NULL","v#00329310 v#01254477 v#00856275 v#00856483 v#00856759 v#00857046 v#01258091 v#01260428 v#01279833 v#00887606 v#01319562 v#01320816 v#00901990 v#01322675 v#00999598 v#01549420 v#01069335 v#01555437 v#01559055 v#01075495 v#01075648 v#01610834 v#01198965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("combinacional","NULL","NULL","a#00472694","NULL");
INSERT INTO portuguese_index VALUES ("combinável","NULL","NULL","a#00472694","NULL");
INSERT INTO portuguese_index VALUES ("inflamável","NULL","NULL","a#00473243 a#00473658","NULL");
INSERT INTO portuguese_index VALUES ("incendiário","n#09810707","NULL","a#00473869 a#02748097","NULL");
INSERT INTO portuguese_index VALUES ("polir","NULL","v#00330153 v#01245637 v#01246095 v#01682582","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lustrar","NULL","v#00330153 v#01245637 v#01682582","NULL","NULL");
INSERT INTO portuguese_index VALUES ("à_prova_de_fogo","NULL","NULL","a#00474440","NULL");
INSERT INTO portuguese_index VALUES ("explosivo","n#03304730","NULL","a#00442295 a#01094524","NULL");
INSERT INTO portuguese_index VALUES ("Jogo_perfeito","n#00474881","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precipitar","NULL","v#00330961 v#01129440 v#01883959","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precipitação","n#00362788 n#07825204 n#09673859","v#00330961","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apurar","NULL","v#00475183 v#02454835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ardente","NULL","NULL","a#00443166 a#00843026 a#01662898","NULL");
INSERT INTO portuguese_index VALUES ("depurar","NULL","v#00475647","NULL","NULL");
INSERT INTO portuguese_index VALUES ("purgar","NULL","v#00475647 v#00905283 v#01054427","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Softbol","n#00475787","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("softbol","n#00475787","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amplo","NULL","NULL","a#00443968 a#00444189 a#00492304 a#00494005 a#01332909 a#01333157 a#02436517","NULL");
INSERT INTO portuguese_index VALUES ("vasto","NULL","NULL","a#00444189 a#01331722","NULL");
INSERT INTO portuguese_index VALUES ("espaçoso","NULL","NULL","a#00444189","NULL");
INSERT INTO portuguese_index VALUES ("Criquete","n#00476389","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Críquete","n#00476389","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("críquete","n#00476389","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estreito","n#09446115","NULL","a#00444513 a#01358755 a#02439276 a#02439903","NULL");
INSERT INTO portuguese_index VALUES ("apertado","NULL","NULL","a#00444513 a#02526441","NULL");
INSERT INTO portuguese_index VALUES ("distorcer","NULL","v#00476744 v#00566613","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tradicionalmente","NULL","NULL","NULL","r#00476807");
INSERT INTO portuguese_index VALUES ("de_forma_tradicional","NULL","NULL","NULL","r#00476807");
INSERT INTO portuguese_index VALUES ("confortável","NULL","NULL","a#00444669 a#00477284 a#02225027","NULL");
INSERT INTO portuguese_index VALUES ("acolhedor","NULL","NULL","a#00477284","NULL");
INSERT INTO portuguese_index VALUES ("lacrosse","n#00477392","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Polo","n#00304385","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pólo","n#00304385 n#06352396","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("polo","n#00304385 n#03154406","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incómodo","NULL","NULL","a#00445726","NULL");
INSERT INTO portuguese_index VALUES ("pouco_à_vontade","NULL","NULL","a#00445726","NULL");
INSERT INTO portuguese_index VALUES ("incômodo","n#04490800 n#05830527 n#04491038 n#10337915","NULL","a#00445726","NULL");
INSERT INTO portuguese_index VALUES ("desconfortável","NULL","NULL","a#00445726 a#00446252","NULL");
INSERT INTO portuguese_index VALUES ("Futebol","n#00304700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_conforto","NULL","NULL","a#00446252","NULL");
INSERT INTO portuguese_index VALUES ("drible","n#00478647 n#07432559","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("doloroso","NULL","NULL","a#00446347 a#01139868 a#01648301 a#01732472 a#01733145","NULL");
INSERT INTO portuguese_index VALUES ("azarado","NULL","NULL","a#00478872 a#01000655 a#01102092","NULL");
INSERT INTO portuguese_index VALUES ("genocídio","n#01245159","v#00479176","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amanhã","n#10877003 n#15156311 n#10964560","NULL","NULL","r#00479275");
INSERT INTO portuguese_index VALUES ("Handebol","n#00479440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("andebol","n#00479440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("handebol","n#00479440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Squash","n#00479887","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("squash","n#00479887","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("automatizar","NULL","v#00479932","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tornar_automático","NULL","v#00479932","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_provisória","NULL","NULL","NULL","r#00480195");
INSERT INTO portuguese_index VALUES ("transitoriamente","NULL","NULL","NULL","r#00480195");
INSERT INTO portuguese_index VALUES ("de_forma_transitória","NULL","NULL","NULL","r#00480195");
INSERT INTO portuguese_index VALUES ("Voleibol","n#00480211","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vôleibol","n#00480211","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("voleibol","n#00480211 n#04540053","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Badmínton","n#00480508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Badminton","n#00480508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transparentemente","NULL","NULL","NULL","r#00480751");
INSERT INTO portuguese_index VALUES ("de_forma_transparente","NULL","NULL","NULL","r#00480751");
INSERT INTO portuguese_index VALUES ("Basquetebol","n#00306597","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("basquetebol","n#00306597 n#02802426","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("basquete","n#00306597","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bola-ao-cesto","n#00306597","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_digestão","NULL","v#00481555","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comensurável","NULL","NULL","a#00481592","NULL");
INSERT INTO portuguese_index VALUES ("proporcional","NULL","NULL","a#00449305 a#00450284 a#00482948 a#00894029","NULL");
INSERT INTO portuguese_index VALUES ("correspondente","n#10414379","NULL","a#00449305 a#01077975 a#01903968 a#01985976 a#01994404 a#01994903","NULL");
INSERT INTO portuguese_index VALUES ("codificar","NULL","v#00481739 v#00993892 v#00672235","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desproporcionado","NULL","NULL","a#00482059 a#00483048","NULL");
INSERT INTO portuguese_index VALUES ("Netball","n#00482122","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incomensurável","NULL","NULL","a#00482139 a#00505285","NULL");
INSERT INTO portuguese_index VALUES ("compatibilizar","NULL","v#00482180 v#00482473 v#00483181 v#01707306 v#01841740","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tênis","n#00482298","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ténis","n#00482298","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tênis","n#00482298","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reconciliar","NULL","v#00482473","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conciliar","NULL","v#00482473 v#00336188 v#00764902","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incontestavelmente","NULL","NULL","NULL","r#00482810");
INSERT INTO portuguese_index VALUES ("comercial","n#05411678","NULL","a#00450636 a#02235294 a#02870780","NULL");
INSERT INTO portuguese_index VALUES ("harmonizar","NULL","v#00483181 v#01706889","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mercantil","NULL","NULL","a#00451123 a#02756682","NULL");
INSERT INTO portuguese_index VALUES ("ténis_real","n#00483705","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insuportavelmente","NULL","NULL","NULL","r#00483963");
INSERT INTO portuguese_index VALUES ("sem_o_conhecimento_de","NULL","NULL","NULL","r#00484062");
INSERT INTO portuguese_index VALUES ("Cama_de_gato","n#00484802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrematar","NULL","v#00337397","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atingir","NULL","v#00337397 v#01152396 v#00822999 v#01126836 v#02022162 v#01582491 v#01511279 v#01513874 v#01515833 v#02238770 v#01532512 v#02248299 v#02288295 v#02359340 v#01719999 v#01721088 v#01722366 v#01722899 v#01723410","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esconde-esconde","n#00484910","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("residencial","NULL","NULL","a#00485044 a#03109795","NULL");
INSERT INTO portuguese_index VALUES ("residêncial","NULL","NULL","a#00485044","NULL");
INSERT INTO portuguese_index VALUES ("amarelinha","n#00485081","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Amarelinha","n#00485081","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comissionado","NULL","NULL","a#00485431","NULL");
INSERT INTO portuguese_index VALUES ("comum","NULL","NULL","a#00453486 a#00456499 a#00460273 a#00970610 a#00994826 a#01536434 a#01672607 a#02069607 a#02234991","NULL");
INSERT INTO portuguese_index VALUES ("inegavelmente","NULL","NULL","NULL","r#00485902");
INSERT INTO portuguese_index VALUES ("de_forma_inegável","NULL","NULL","NULL","r#00485902");
INSERT INTO portuguese_index VALUES ("levar_a_cabo","NULL","v#00338284 v#01126836","NULL","NULL");
INSERT INTO portuguese_index VALUES ("realizar","NULL","v#00338284 v#01111638 v#01126836 v#01644746 v#01536195 v#01722366 v#01746300 v#01747342 v#01822979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("executar","NULL","v#00338284 v#01126836 v#01133312 v#01173875 v#01174962 v#01180692 v#01755816 v#01612822 v#01617687 v#01692292 v#01692882 v#01722366 v#01746300 v#01760253 v#02599636","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carniça","n#00486130 n#01758895","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eixo-badeixo","n#00486130","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("democrático","NULL","NULL","a#00454220 a#00680063 a#02555745","NULL");
INSERT INTO portuguese_index VALUES ("dança_das_cadeiras","n#00486670","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("freqüente","NULL","NULL","a#00454653 a#01013801","NULL");
INSERT INTO portuguese_index VALUES ("frequente","NULL","NULL","a#00454653 a#01013801","NULL");
INSERT INTO portuguese_index VALUES ("geral","NULL","NULL","a#00487198 a#00456499 a#01050726","NULL");
INSERT INTO portuguese_index VALUES ("guerra_de_travesseiros","n#00487228","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("debaixo_de","NULL","NULL","NULL","r#00487408");
INSERT INTO portuguese_index VALUES ("por_baixo_de","NULL","NULL","NULL","r#00487408");
INSERT INTO portuguese_index VALUES ("sob","NULL","NULL","NULL","r#00487408");
INSERT INTO portuguese_index VALUES ("debaixo","NULL","NULL","NULL","r#00487408 r#00487623");
INSERT INTO portuguese_index VALUES ("adulterar","NULL","v#00487748","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inapropriadamente","NULL","NULL","NULL","r#00487759");
INSERT INTO portuguese_index VALUES ("pega-pega","n#00487874 n#07273136","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jôgo_da_pulga","n#00488051","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gramaticalmente","NULL","NULL","NULL","r#00488143");
INSERT INTO portuguese_index VALUES ("excepcional","NULL","NULL","a#00455774 a#01541117 a#01616760 a#02343762","NULL");
INSERT INTO portuguese_index VALUES ("especial","NULL","NULL","a#00455774 a#01054295 a#01618961 a#01782133 a#02167587","NULL");
INSERT INTO portuguese_index VALUES ("jogo_de_cartas","n#00488225 n#00488225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aguar","NULL","v#00488301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pouco_frequente","NULL","NULL","a#00456130","NULL");
INSERT INTO portuguese_index VALUES ("de_pouca_densidade","NULL","NULL","a#00456130","NULL");
INSERT INTO portuguese_index VALUES ("pouco_freqüente","NULL","NULL","a#00456130","NULL");
INSERT INTO portuguese_index VALUES ("arejar","NULL","v#00340255 v#00340460 v#02112345 v#02112891","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inusual","NULL","NULL","a#00488857 a#00457241 a#00918492","NULL");
INSERT INTO portuguese_index VALUES ("insólito","NULL","NULL","a#00488857 a#00457241 a#00918492","NULL");
INSERT INTO portuguese_index VALUES ("inesperado","NULL","NULL","a#00488857 a#02259248 a#00882895","NULL");
INSERT INTO portuguese_index VALUES ("genérico","NULL","NULL","a#00456499","NULL");
INSERT INTO portuguese_index VALUES ("ordinário","NULL","NULL","a#00456499 a#00649057 a#00970610 a#00994826 a#01536434 a#01672607","NULL");
INSERT INTO portuguese_index VALUES ("costumeiro","NULL","NULL","a#00456499 a#01672607","NULL");
INSERT INTO portuguese_index VALUES ("glorificar","NULL","v#00489299 v#00583913","NULL","NULL");
INSERT INTO portuguese_index VALUES ("justificar","NULL","v#00341011 v#00606341","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inveterado","NULL","NULL","a#00489768","NULL");
INSERT INTO portuguese_index VALUES ("mensurar","NULL","v#00341143 v#00436897","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quantificar","NULL","v#00341143 v#00492095","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bacará","n#00489933","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incomun","NULL","NULL","a#00457241","NULL");
INSERT INTO portuguese_index VALUES ("vinte-e-um","n#00490350","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("blackjack","n#00490350","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diferente","NULL","NULL","a#00457601 a#00920300 a#01354054 a#01354496 a#01354886 a#01986829 a#01989737 a#01992026 a#02070342 a#01995401 a#02036455","NULL");
INSERT INTO portuguese_index VALUES ("pesar","n#04492345 n#05599930 n#05601413 n#05601776 n#07535670 n#07536870 n#10077799","v#00341426 v#01845395","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_cima","NULL","NULL","NULL","r#00490579 r#00490678");
INSERT INTO portuguese_index VALUES ("cronometrar","NULL","v#00490968","NULL","NULL");
INSERT INTO portuguese_index VALUES ("utilmente","NULL","NULL","NULL","r#00491292");
INSERT INTO portuguese_index VALUES ("Bridge","n#00491366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bridge","n#00491366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regredir","NULL","v#00491456","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hidrofóbica","NULL","NULL","a#00491749","NULL");
INSERT INTO portuguese_index VALUES ("titular","n#07336733","v#00342505","a#01043374 a#02816340","NULL");
INSERT INTO portuguese_index VALUES ("hidrossolúvel","NULL","NULL","a#00491971 a#02265815","NULL");
INSERT INTO portuguese_index VALUES ("variavelmente","NULL","NULL","NULL","r#00492269");
INSERT INTO portuguese_index VALUES ("veementemente","NULL","NULL","NULL","r#00492414");
INSERT INTO portuguese_index VALUES ("de_forma_veemente","NULL","NULL","NULL","r#00492414");
INSERT INTO portuguese_index VALUES ("lipófilo","NULL","NULL","a#00492477 a#02265496","NULL");
INSERT INTO portuguese_index VALUES ("Dominó_de_baralho","n#00492497","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sujar","NULL","v#00343123 v#01055474","NULL","NULL");
INSERT INTO portuguese_index VALUES ("poluir","NULL","v#00343123","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comunitário","NULL","NULL","a#00460554 a#02548965","NULL");
INSERT INTO portuguese_index VALUES ("descontaminar","NULL","v#00493052","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estatal","NULL","NULL","a#00460814 a#01791310","NULL");
INSERT INTO portuguese_index VALUES ("público","n#07965817 n#06103316","NULL","a#00460814 a#01790261","NULL");
INSERT INTO portuguese_index VALUES ("individual","NULL","NULL","a#02110583 a#02036455","NULL");
INSERT INTO portuguese_index VALUES ("animadamente","NULL","NULL","NULL","r#00493494");
INSERT INTO portuguese_index VALUES ("idiossincrático","NULL","NULL","a#00493820","NULL");
INSERT INTO portuguese_index VALUES ("isolar","NULL","v#00344252 v#00345357 v#00345547 v#00345904 v#00346179","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ilhar","NULL","v#00344252","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respectivo","NULL","NULL","a#00462055","NULL");
INSERT INTO portuguese_index VALUES ("respetivo","NULL","NULL","a#00462055","NULL");
INSERT INTO portuguese_index VALUES ("singular","n#06299916","NULL","a#00462537 a#00919283 a#01678417 a#02112131","NULL");
INSERT INTO portuguese_index VALUES ("único","NULL","NULL","a#00462537 a#00472062 a#00576203 a#00919283 a#02111616 a#02112131","NULL");
INSERT INTO portuguese_index VALUES ("pôquer","n#00494768","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("póquer","n#00494768","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comunicativo","NULL","NULL","a#00494907 a#00464296 a#02956371","NULL");
INSERT INTO portuguese_index VALUES ("completamente_entregue","NULL","NULL","NULL","r#00494948");
INSERT INTO portuguese_index VALUES ("sem_reservas","NULL","NULL","NULL","r#00494948");
INSERT INTO portuguese_index VALUES ("de_todo_o_coração","NULL","NULL","NULL","r#00494948");
INSERT INTO portuguese_index VALUES ("sem_ressalvas","NULL","NULL","NULL","r#00494948");
INSERT INTO portuguese_index VALUES ("de_onde","NULL","NULL","NULL","r#00495309");
INSERT INTO portuguese_index VALUES ("donde","NULL","NULL","NULL","r#00495309");
INSERT INTO portuguese_index VALUES ("não_importa_o_lugar","NULL","NULL","NULL","r#00495377");
INSERT INTO portuguese_index VALUES ("onde_quer_que","NULL","NULL","NULL","r#00495377");
INSERT INTO portuguese_index VALUES ("Paciência","n#00495524","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paciência","n#00495524 n#03659752","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anedótico","NULL","NULL","a#00495916 a#03044331","NULL");
INSERT INTO portuguese_index VALUES ("insular","NULL","v#00345547","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Uíste","n#00496167","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quarentenar","NULL","v#00496266","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comunicável","NULL","NULL","a#00496569","NULL");
INSERT INTO portuguese_index VALUES ("copas","n#00496599 n#02810457","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anglófono","NULL","NULL","a#00496845","NULL");
INSERT INTO portuguese_index VALUES ("falador","NULL","NULL","a#00464296","NULL");
INSERT INTO portuguese_index VALUES ("Canasta","n#00317921","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("significativo","NULL","NULL","a#00464568 a#01436246 a#01436930 a#02078228","NULL");
INSERT INTO portuguese_index VALUES ("francófono","NULL","NULL","a#00497535","NULL");
INSERT INTO portuguese_index VALUES ("Pôquer_fechado","n#00497536","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("é!","NULL","NULL","NULL","r#00497560");
INSERT INTO portuguese_index VALUES ("sim","NULL","NULL","NULL","r#00497560");
INSERT INTO portuguese_index VALUES ("isso_aí!","NULL","NULL","NULL","r#00497560");
INSERT INTO portuguese_index VALUES ("impregnar","NULL","v#00347065","NULL","NULL");
INSERT INTO portuguese_index VALUES ("strip_poker","n#00498086","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Strip_poker","n#00498086","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pôquer_aberto","n#00498220","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("heráldico","NULL","NULL","a#00498286","NULL");
INSERT INTO portuguese_index VALUES ("no_alto","NULL","NULL","NULL","r#00498499 r#00498610 r#00499004 r#00499084");
INSERT INTO portuguese_index VALUES ("narrativo","NULL","NULL","a#00465739","NULL");
INSERT INTO portuguese_index VALUES ("calcificar","NULL","v#00498988","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tenis_de_mesa","n#00499263","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tênis_de_mesa","n#00499263","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ténis_de_Mesa","n#00499263","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ténis-de-mesa","n#00499263","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pingue-pongue","n#00499263","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("circunstancialmente","NULL","NULL","NULL","r#00499340");
INSERT INTO portuguese_index VALUES ("de_forma_circunstancial","NULL","NULL","NULL","r#00499340");
INSERT INTO portuguese_index VALUES ("dominó","n#00499477 n#03220802 n#03221205","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("urbanizar","NULL","v#00499812","NULL","NULL");
INSERT INTO portuguese_index VALUES ("industrializar","NULL","v#00499812 v#00576979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bilhar","n#00499924","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hispanófono","NULL","NULL","a#00500126","NULL");
INSERT INTO portuguese_index VALUES ("verbal","NULL","NULL","a#00466619 a#02172775 a#02619885","NULL");
INSERT INTO portuguese_index VALUES ("emulsionar","NULL","v#00500638 v#00500834","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prestes_a","NULL","NULL","NULL","r#00500759");
INSERT INTO portuguese_index VALUES ("no_limiar_de","NULL","NULL","NULL","r#00500759");
INSERT INTO portuguese_index VALUES ("iminentemente","NULL","NULL","NULL","r#00500759");
INSERT INTO portuguese_index VALUES ("a_ponto_de","NULL","NULL","NULL","r#00500759");
INSERT INTO portuguese_index VALUES ("reticente","NULL","NULL","a#00501004","NULL");
INSERT INTO portuguese_index VALUES ("Bilhar_americano","n#00501080","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_princípio","NULL","NULL","NULL","r#00501140");
INSERT INTO portuguese_index VALUES ("sinuca","n#00501304","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("snooker","n#00501304","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Snooker","n#00501304","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inexpressível","NULL","NULL","a#00501313","NULL");
INSERT INTO portuguese_index VALUES ("sem_expressão","NULL","NULL","a#00501313 a#00501723","NULL");
INSERT INTO portuguese_index VALUES ("inconfundivelmente","NULL","NULL","NULL","r#00501452");
INSERT INTO portuguese_index VALUES ("jogo_de_salão","n#00501722","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inexpressivo","NULL","NULL","a#00501723","NULL");
INSERT INTO portuguese_index VALUES ("Jogos_de_palavras","n#00501870","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("para_dentro","NULL","NULL","NULL","r#00501990");
INSERT INTO portuguese_index VALUES ("Scrabble","n#00502161","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compacto","NULL","NULL","a#00468456","NULL");
INSERT INTO portuguese_index VALUES ("cerrado","NULL","NULL","a#00468456","NULL");
INSERT INTO portuguese_index VALUES ("desnitrificar","NULL","v#00502332","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogo_de_tabuleiro","n#00502415","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estercar","NULL","v#00350087","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Gamao","n#00502822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gamão","n#00502822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Gamão","n#00502822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("damas","n#00502952","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogo_de_damas","n#00502952","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogo_de_xadrez","n#00503237","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("xadrez","n#00503237 n#03011162 n#02872007 n#03684740 n#03174387","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("friável","NULL","NULL","a#00469766 a#00708738","NULL");
INSERT INTO portuguese_index VALUES ("Damas_chinesas","n#00503981","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comparável","NULL","NULL","a#00470209 a#00470381 a#00470640 a#01985976","NULL");
INSERT INTO portuguese_index VALUES ("pegar_com_pinça","NULL","v#00504019","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tomar_entre_dois_dedos","NULL","v#00504019","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semdelonga","NULL","NULL","NULL","r#00504153");
INSERT INTO portuguese_index VALUES ("semdemora","NULL","NULL","NULL","r#00504153");
INSERT INTO portuguese_index VALUES ("dardos","n#00504209","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("go","n#00504325","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_segunda_mão","NULL","NULL","a#01640482","r#00504492");
INSERT INTO portuguese_index VALUES ("incomparável","NULL","NULL","a#00504592 a#00505410","NULL");
INSERT INTO portuguese_index VALUES ("bingo","n#00504660","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mahjong","n#00505126","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mahjong","n#00505126","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clarificar","NULL","v#00216841","NULL","NULL");
INSERT INTO portuguese_index VALUES ("explicar","NULL","v#00216841 v#00361681 v#00833392 v#00606341 v#00635987 v#00636201 v#00636437 v#00677246 v#01065456 v#02635033","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Monopólio","n#00505238 n#14444326","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Banco_Imobiliário","n#00505238","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desintoxicar","NULL","v#00505349","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_comparação","NULL","NULL","a#00505410","NULL");
INSERT INTO portuguese_index VALUES ("causalmente","NULL","NULL","NULL","r#00505639");
INSERT INTO portuguese_index VALUES ("Shogi","n#00505726","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inigualável","NULL","NULL","a#00472062","NULL");
INSERT INTO portuguese_index VALUES ("um_a_um","NULL","NULL","NULL","r#00505853");
INSERT INTO portuguese_index VALUES ("electrificar","NULL","v#00506040","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletrificar","NULL","v#00506040","NULL","NULL");
INSERT INTO portuguese_index VALUES ("electrizar","NULL","v#00506040","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletrizar","NULL","v#00506040 v#01225706","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogo_da_velha","n#00506207","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compatível","NULL","NULL","a#01425318 a#00475053 a#00475498","NULL");
INSERT INTO portuguese_index VALUES ("jogo_de_fortuna_e_azar","n#00507673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_ontem","NULL","NULL","NULL","r#00507716");
INSERT INTO portuguese_index VALUES ("ontem","n#15156187 n#15263138","NULL","NULL","r#00507716 r#00507819");
INSERT INTO portuguese_index VALUES ("congenial","NULL","NULL","a#00507789 a#00527630","NULL");
INSERT INTO portuguese_index VALUES ("junto","NULL","NULL","a#00533304","r#00507927");
INSERT INTO portuguese_index VALUES ("junta","n#06171035 n#06172564","NULL","NULL","r#00507927");
INSERT INTO portuguese_index VALUES ("loteria","n#00508091 n#00508672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incompatível","NULL","NULL","a#00474296 a#00475213 a#00475784 a#00528281 a#00529913 a#00545259 a#00588254 a#01425914 a#02270006","NULL");
INSERT INTO portuguese_index VALUES ("Rifa","n#00508672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rifa","n#00508672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contraditório","NULL","NULL","a#00474818 a#00545006 a#02245649 a#02269664","NULL");
INSERT INTO portuguese_index VALUES ("roleta","n#00509399 n#04113194 n#04113406","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ondear","NULL","v#00509449","NULL","NULL");
INSERT INTO portuguese_index VALUES ("habilitado","NULL","NULL","a#00510050","NULL");
INSERT INTO portuguese_index VALUES ("competente","NULL","NULL","a#00510050 a#02120998","NULL");
INSERT INTO portuguese_index VALUES ("brincadeira_perversa","n#00510050","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sardas","n#05245192","v#00510116","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eficiente","NULL","NULL","a#00476442 a#01753746 a#00799334 a#00839619","NULL");
INSERT INTO portuguese_index VALUES ("eficaz","NULL","NULL","a#00476442 a#01753746 a#00799334","NULL");
INSERT INTO portuguese_index VALUES ("compulsão_alimentar","n#00510723","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_contextual","NULL","NULL","NULL","r#00510852");
INSERT INTO portuguese_index VALUES ("contextualmente","NULL","NULL","NULL","r#00510852");
INSERT INTO portuguese_index VALUES ("farra","n#00511041 n#00329560","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deboche","n#00329560","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("viveremfarra","n#00329560","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vivernodeboche","n#00329560","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dissipação","n#00329560","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("orgia","n#00329560","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curtir","NULL","v#00356023","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carnaval","n#00511555","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bacanal","n#00511676","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bacanal","n#00511676 n#00694827","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incapacitar","NULL","v#00512186","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desabilitar","NULL","v#00512186","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Competitivo","NULL","NULL","a#00512487","NULL");
INSERT INTO portuguese_index VALUES ("flerte","n#00512522","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tolice","n#00330677","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("idiotice","n#00330677","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("habilitar","NULL","v#00357077","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imunologicamente","NULL","NULL","NULL","r#00513831");
INSERT INTO portuguese_index VALUES ("salientar","NULL","v#00358208","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destacar","NULL","v#00358208 v#00887219","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_forma_judicial","NULL","NULL","NULL","r#00514272");
INSERT INTO portuguese_index VALUES ("resignado","NULL","NULL","a#00514278","NULL");
INSERT INTO portuguese_index VALUES ("compressível","NULL","NULL","a#00514396","NULL");
INSERT INTO portuguese_index VALUES ("comprimido","n#03123093","NULL","a#00514613 a#01655538","NULL");
INSERT INTO portuguese_index VALUES ("gambozino","n#00514787","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Recorrentemente","NULL","NULL","NULL","r#00514889");
INSERT INTO portuguese_index VALUES ("estavelmente","NULL","NULL","NULL","r#00515298");
INSERT INTO portuguese_index VALUES ("inteira","NULL","NULL","a#00481645","NULL");
INSERT INTO portuguese_index VALUES ("total","n#10375432","NULL","a#00481645 a#00489625","NULL");
INSERT INTO portuguese_index VALUES ("inteiro","n#13728499","NULL","a#00481645 a#00482100","NULL");
INSERT INTO portuguese_index VALUES ("distração","n#00515414 n#04409041","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distracção","n#00515414 n#04409041","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Edutainment","n#00515578","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("completo","NULL","NULL","a#00482100 a#00487168 a#00489625","NULL");
INSERT INTO portuguese_index VALUES ("solenidade","n#00332566 n#03664203 n#05584266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fracionário","NULL","NULL","a#00516539","NULL");
INSERT INTO portuguese_index VALUES ("Jogos_Nemeus","n#00516559","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Jogos_nemeus","n#00516559","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogos_olímpicos","n#00516720","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Jogos_Píticos","n#00516900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Jogos_píticos","n#00516900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fragmentário","NULL","NULL","a#00517314","NULL");
INSERT INTO portuguese_index VALUES ("metade","n#09891093 n#10960792","NULL","a#00483994 a#00524496","NULL");
INSERT INTO portuguese_index VALUES ("festival","n#00517728","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carregar","NULL","v#00360886 v#00509295 v#01239202 v#00981851 v#00994853 v#01450792 v#00996361 v#01487311 v#01022027 v#01022755 v#01490572 v#01490690 v#01025426 v#01026409 v#01364494","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Kwanzaa","n#00518152","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Recarregar","NULL","v#00518288","NULL","NULL");
INSERT INTO portuguese_index VALUES ("facilitar","NULL","v#00361385 v#01757338","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Saturnália","n#00518442","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Saturnalia","n#00518442","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mistificar","NULL","v#00361554 v#02577586","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gala","n#00333978","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("livre","NULL","NULL","a#00485838 a#01007914","NULL");
INSERT INTO portuguese_index VALUES ("bolhadear","NULL","v#00519056","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formar_bolhas","NULL","v#00519056","NULL","NULL");
INSERT INTO portuguese_index VALUES ("borbulhar","NULL","v#00519056 v#01969084","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entregue","NULL","NULL","a#00519211","NULL");
INSERT INTO portuguese_index VALUES ("dedicado","NULL","NULL","a#00519211 a#00573225","NULL");
INSERT INTO portuguese_index VALUES ("espumar","NULL","v#00519363","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espumejar","NULL","v#00519363","NULL","NULL");
INSERT INTO portuguese_index VALUES ("devotado","NULL","NULL","a#00519477 a#00519668","NULL");
INSERT INTO portuguese_index VALUES ("circo","n#00334700 n#02444381 n#06087639","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Artes_circenses","n#00334700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disturbar","NULL","v#00362427 v#01208224","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perturbar","NULL","v#00362427 v#00973053 v#01203947 v#01208224 v#01218326 v#01221002 v#01222254 v#02065652","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Terça-Feira_Gorda","n#00520059","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("integral","n#06015505","NULL","a#00487168","NULL");
INSERT INTO portuguese_index VALUES ("totalizado","NULL","NULL","a#00487168","NULL");
INSERT INTO portuguese_index VALUES ("exibição","n#00335147 n#00335980","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cabaret","n#00520672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cabaré","n#00520672 n#02931417","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exposição","n#00335980 n#00522145 n#00679124 n#06217283 n#09805381 n#14543931","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("realizado","n#07531105","NULL","a#00521329 a#02226028","NULL");
INSERT INTO portuguese_index VALUES ("demonstração","n#00336149 n#04985559 n#05148592","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("completado","NULL","NULL","a#00522240","NULL");
INSERT INTO portuguese_index VALUES ("completa","NULL","NULL","a#00522240","NULL");
INSERT INTO portuguese_index VALUES ("transladar","NULL","v#00364478 v#01373274","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exaustivo","NULL","NULL","a#00522463 a#00492304","NULL");
INSERT INTO portuguese_index VALUES ("conformar","NULL","v#00364629","NULL","NULL");
INSERT INTO portuguese_index VALUES ("receber","NULL","v#00364767 v#00617095 v#00610465 v#00812388 v#02108377 v#02108654 v#01513366 v#01513874 v#02288295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obter","NULL","v#00364767 v#00444338 v#01511279 v#01513874 v#01531769 v#02238770 v#01532512 v#02288295 v#01564908 v#02359340 v#01722366 v#01723410","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incompleto","NULL","NULL","a#00523978 a#01004541","NULL");
INSERT INTO portuguese_index VALUES ("acetilar","NULL","v#00524083 v#00524299","NULL","NULL");
INSERT INTO portuguese_index VALUES ("partido","n#06131180","NULL","a#00491051","NULL");
INSERT INTO portuguese_index VALUES ("nenhuma","NULL","NULL","a#00524607","NULL");
INSERT INTO portuguese_index VALUES ("nenhum","NULL","NULL","a#00524607","NULL");
INSERT INTO portuguese_index VALUES ("nenhuma_pessoa","NULL","NULL","a#00524607","NULL");
INSERT INTO portuguese_index VALUES ("assumir","NULL","v#00366302 v#00428091 v#01622769","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parcial","NULL","NULL","a#00491270 a#01659853 a#00695128","NULL");
INSERT INTO portuguese_index VALUES ("reassumir","NULL","v#00525027","NULL","NULL");
INSERT INTO portuguese_index VALUES ("detalhado","NULL","NULL","a#00492304","NULL");
INSERT INTO portuguese_index VALUES ("abrangente","NULL","NULL","a#00492304","NULL");
INSERT INTO portuguese_index VALUES ("extenso","NULL","NULL","a#00492304 a#00494215 a#01332909 a#01333157","NULL");
INSERT INTO portuguese_index VALUES ("carboxilar","NULL","v#00526081","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adágio","n#00526259 n#07047804 n#05350719 n#05351147","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clausurar","NULL","v#00527034","NULL","NULL");
INSERT INTO portuguese_index VALUES ("global","NULL","NULL","a#00493390 a#01511497 a#01512420 a#01966960","NULL");
INSERT INTO portuguese_index VALUES ("mundial","NULL","NULL","a#00493390 a#01511497 a#01512420","NULL");
INSERT INTO portuguese_index VALUES ("adubar","NULL","v#00527232","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_adubo","NULL","v#00527232","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sapateado","n#00527872","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("plenário","NULL","NULL","a#00528167","NULL");
INSERT INTO portuguese_index VALUES ("coreografia","n#00528397 n#06816445 n#07020763","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("balé","n#00339532 n#07054336","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("súper","NULL","NULL","a#00528761","NULL");
INSERT INTO portuguese_index VALUES ("amanhecer","NULL","v#00369536","NULL","NULL");
INSERT INTO portuguese_index VALUES ("constituído","NULL","NULL","a#00495291","NULL");
INSERT INTO portuguese_index VALUES ("sossegado","NULL","NULL","a#01678759","NULL");
INSERT INTO portuguese_index VALUES ("calmo","NULL","NULL","a#01678759","NULL");
INSERT INTO portuguese_index VALUES ("sereno","NULL","NULL","a#01678759","NULL");
INSERT INTO portuguese_index VALUES ("tranquilo","NULL","NULL","a#01678759","NULL");
INSERT INTO portuguese_index VALUES ("tranqüilo","NULL","NULL","a#01678759","NULL");
INSERT INTO portuguese_index VALUES ("calma","n#03839746 n#03893757 n#03893972 n#05586846 n#10415727","NULL","a#01678759","NULL");
INSERT INTO portuguese_index VALUES ("dança_moderna","n#00530018","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Dança_Moderna","n#00530018","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tamanco","n#00530208 n#03047690","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dança_do_ventre","n#00530554","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Dança_do_Ventre","n#00530554","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despovoar","NULL","v#00531302","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Strip-tease","n#00531490","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("striptease","n#00531490","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acanhado","NULL","NULL","a#00497363","NULL");
INSERT INTO portuguese_index VALUES ("vergonhoso","NULL","NULL","a#00497363","NULL");
INSERT INTO portuguese_index VALUES ("dessalinizar","NULL","v#00531904","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desconcertado","NULL","NULL","a#00532288","NULL");
INSERT INTO portuguese_index VALUES ("externalizar","NULL","v#00532607","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dança_espanhola","n#00532739","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fandango","n#00532739","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compreensível","NULL","NULL","a#01436533 a#00499123","NULL");
INSERT INTO portuguese_index VALUES ("flamenco","n#00533036","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Flamenco","n#00533036","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abordável","NULL","NULL","a#00533221","NULL");
INSERT INTO portuguese_index VALUES ("gavota","n#00533224","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("habanera","n#00533322","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entendível","NULL","NULL","a#00499123","NULL");
INSERT INTO portuguese_index VALUES ("tarantela","n#00533805","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incompreensível","NULL","NULL","a#00533851 a#00939105","NULL");
INSERT INTO portuguese_index VALUES ("politizar","NULL","v#00534222","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obscuro","NULL","NULL","a#00534250 a#00899612 a#02088883","NULL");
INSERT INTO portuguese_index VALUES ("Dança_de_Salão","n#00534849","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dança_de_salão","n#00534849","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impenetrável","NULL","NULL","a#00534918","NULL");
INSERT INTO portuguese_index VALUES ("côncavo","NULL","NULL","a#00535452","NULL");
INSERT INTO portuguese_index VALUES ("oco","n#06728884","NULL","a#00535452 a#02155010","NULL");
INSERT INTO portuguese_index VALUES ("acetabular","NULL","NULL","a#00535844","NULL");
INSERT INTO portuguese_index VALUES ("bicôncavo","NULL","NULL","a#00536008","NULL");
INSERT INTO portuguese_index VALUES ("Charleston","n#00536359 n#09138538 n#09155798","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("minueto","n#00536778 n#07056113","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("samba","n#00537192 n#07056895","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convexo","NULL","NULL","a#00537339","NULL");
INSERT INTO portuguese_index VALUES ("envoltória_convexa","NULL","NULL","a#00537339","NULL");
INSERT INTO portuguese_index VALUES ("tango","n#00537423 n#07057829","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("valsa","n#00537534 n#07058184","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("biconvexo","NULL","NULL","a#00537745","NULL");
INSERT INTO portuguese_index VALUES ("mazurca","n#00538052","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("polca","n#00538144 n#07056504","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chotiça","n#00538266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mambo","n#00538668","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("denso","NULL","NULL","a#00503751 a#01706921 a#02299475","NULL");
INSERT INTO portuguese_index VALUES ("atravessar","NULL","v#00377424 v#00989536 v#01840092 v#01844859 v#01261627 v#01304824 v#01915365 v#01915865 v#01307553 v#01317730 v#01401176","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quadrilha","n#00540485 n#06143363 n#08415774","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("difuso","NULL","NULL","a#00505802 a#00514357","NULL");
INSERT INTO portuguese_index VALUES ("dilatar-se","NULL","v#00541163","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expandir-se","NULL","v#00541163","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dança_da_morte","n#00542149","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dança_macabra","n#00542149","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apartado","NULL","NULL","a#00507803","NULL");
INSERT INTO portuguese_index VALUES ("disperso","NULL","NULL","a#00507880","NULL");
INSERT INTO portuguese_index VALUES ("esparso","NULL","NULL","a#00507880","NULL");
INSERT INTO portuguese_index VALUES ("Hula","n#00542458","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dança_da_chuva","n#00542711","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concêntrico","NULL","NULL","a#00542953","NULL");
INSERT INTO portuguese_index VALUES ("excêntricos","NULL","NULL","a#00543200","NULL");
INSERT INTO portuguese_index VALUES ("excêntrico","NULL","NULL","a#00543200","NULL");
INSERT INTO portuguese_index VALUES ("excêntrica","NULL","NULL","a#00543200","NULL");
INSERT INTO portuguese_index VALUES ("excêntricas","NULL","NULL","a#00543200","NULL");
INSERT INTO portuguese_index VALUES ("música","n#00351993 n#04417946 n#05718935 n#05266809","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_outra_forma","NULL","v#00380419","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escalfar","NULL","v#00380794","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carrilhão","n#00544441","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assombrada","NULL","NULL","a#00544478","NULL");
INSERT INTO portuguese_index VALUES ("obcecado","NULL","NULL","a#00544478 a#00599468","NULL");
INSERT INTO portuguese_index VALUES ("Música_vocal","n#00545344","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Canção","n#00354500","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Canto","n#00354500","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Belcanto","n#00546216","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bel_Canto","n#00546216","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bel_canto","n#00546216","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cantoria","n#00355108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("canção","n#00355108 n#05284501","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indiferente","NULL","NULL","a#00511928 a#00834080 a#01280576 a#01289497 a#01615410 a#01660647 a#01724072 a#02281611","NULL");
INSERT INTO portuguese_index VALUES ("conciso","NULL","NULL","a#00512104 a#00548316","NULL");
INSERT INTO portuguese_index VALUES ("lacónico","NULL","NULL","a#00512104 a#00548316","NULL");
INSERT INTO portuguese_index VALUES ("sucinto","NULL","NULL","a#00512104 a#00547317","NULL");
INSERT INTO portuguese_index VALUES ("lacônico","NULL","NULL","a#00512104 a#00512937","NULL");
INSERT INTO portuguese_index VALUES ("scat","n#00547244","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sumário","n#04857759 n#06468123 n#04859332 n#06468403 n#06468951 n#06469223 n#04859040","NULL","a#00547317","NULL");
INSERT INTO portuguese_index VALUES ("compêndio","n#06414372 n#06467996 n#06468123","NULL","a#00547317","NULL");
INSERT INTO portuguese_index VALUES ("curto","NULL","NULL","a#00512937 a#01379046 a#01383972 a#01384633","NULL");
INSERT INTO portuguese_index VALUES ("elíptico","NULL","NULL","a#00548029 a#02046199 a#02168132","NULL");
INSERT INTO portuguese_index VALUES ("voltar","NULL","v#00383502 v#00649691 v#01422854","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sentencioso","NULL","NULL","a#00548316","NULL");
INSERT INTO portuguese_index VALUES ("atuação","n#00358063 n#05156358","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("representação","n#00358063 n#00577495 n#00789600 n#03229963","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nivelar","NULL","v#00548616 v#01307142 v#01307609","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prolixo","NULL","NULL","a#00548781 a#01381736","NULL");
INSERT INTO portuguese_index VALUES ("caracterização","n#00358359 n#07201562 n#05381135","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("personificação","n#00549284 n#00597654 n#00933259 n#07108123 n#10418101 n#07470212","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imitação","n#00549284 n#00549472 n#01020936","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mímica","n#00549472 n#06875697 n#10318892","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paródia","n#00549610 n#06780309","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pleonástico","NULL","NULL","a#00549826","NULL");
INSERT INTO portuguese_index VALUES ("tautológico","NULL","NULL","a#00549826","NULL");
INSERT INTO portuguese_index VALUES ("redundante","NULL","NULL","a#00549826 a#01524894","NULL");
INSERT INTO portuguese_index VALUES ("supérfluo","NULL","NULL","a#00549826 a#01524894","NULL");
INSERT INTO portuguese_index VALUES ("desnecessário","NULL","NULL","a#00549826 a#01524704 a#01525512","NULL");
INSERT INTO portuguese_index VALUES ("pantomima","n#00550016","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conclusivo","NULL","NULL","a#00550282","NULL");
INSERT INTO portuguese_index VALUES ("definitivo","NULL","NULL","a#00515853 a#00666635","NULL");
INSERT INTO portuguese_index VALUES ("decisivo","NULL","NULL","a#00515853 a#00619212 a#00649636 a#00650020 a#00701178","NULL");
INSERT INTO portuguese_index VALUES ("inconclusivo","NULL","NULL","a#00550777","NULL");
INSERT INTO portuguese_index VALUES ("dinamizar","NULL","v#00551718","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reconstituição","n#00551913","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concretizar","NULL","v#00552006 v#01644746","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animação","n#00552436 n#00908405 n#04631700 n#05005809 n#13961642","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desorganização","n#00552922","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_acordo_com","NULL","NULL","a#00553140","NULL");
INSERT INTO portuguese_index VALUES ("eternizar","NULL","v#00553208","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tornar_eterno","NULL","v#00553208","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imortalizar","NULL","v#00553208 v#00612042","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concorde","NULL","NULL","a#00553478","NULL");
INSERT INTO portuguese_index VALUES ("conforme","NULL","NULL","a#00553478 a#00577122","NULL");
INSERT INTO portuguese_index VALUES ("consensual","NULL","NULL","a#00553594","NULL");
INSERT INTO portuguese_index VALUES ("surpresa","n#00361333 n#05442564 n#05582358 n#05582577 n#05582875","NULL","a#02357479","NULL");
INSERT INTO portuguese_index VALUES ("unânime","NULL","NULL","a#00518774 a#00747104","NULL");
INSERT INTO portuguese_index VALUES ("tumulto","n#00361442 n#00554541 n#10068579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escândalo","n#00361442 n#05447394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discordante","NULL","NULL","a#00553899","NULL");
INSERT INTO portuguese_index VALUES ("arrebato","n#00361596","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("kingpin","n#00554541","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alvoroço","n#00554541","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("turbulência","n#00554541 n#11520989 n#13979173 n#14523669 n#14524383","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contrátil","NULL","NULL","a#00554624","NULL");
INSERT INTO portuguese_index VALUES ("desarranjo","n#00362255 n#10330471","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("freneticidade","n#00362507","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mudar-se","NULL","v#00388919 v#01855606","NULL","NULL");
INSERT INTO portuguese_index VALUES ("condicionado","NULL","NULL","a#00555325 a#01913413","NULL");
INSERT INTO portuguese_index VALUES ("escovar","NULL","v#00389405 v#01243809 v#01243982 v#00956103","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eventual","NULL","NULL","a#00522821 a#01522771 a#01751894 a#01961205","NULL");
INSERT INTO portuguese_index VALUES ("tentativo","NULL","NULL","a#00523173","NULL");
INSERT INTO portuguese_index VALUES ("provisório","NULL","NULL","a#00523173","NULL");
INSERT INTO portuguese_index VALUES ("temporário","NULL","NULL","a#00523173 a#01691661 a#01756166 a#01692272","NULL");
INSERT INTO portuguese_index VALUES ("provisória","NULL","NULL","a#00523173","NULL");
INSERT INTO portuguese_index VALUES ("conduzir","NULL","v#00390029 v#01317321 v#01318647 v#02000133 v#01364900 v#01406763 v#01618507 v#01658906 v#01661432 v#01661609 v#01665790 v#01738832","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incondicional","NULL","NULL","a#00523702 a#00730082 a#01844025 a#02095346","NULL");
INSERT INTO portuguese_index VALUES ("figura","n#00363615 n#02563119 n#02598242 n#03265874 n#02849808 n#02965788 n#03113185 n#03118233 n#03229963 n#04536390 n#06999233 n#07149819 n#09987377","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tática","n#00364173 n#04538754","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assistência","n#00364539 n#00782440 n#00783978 n#00800467 n#04012006 n#04015637","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semicondutores","NULL","NULL","a#00558019","NULL");
INSERT INTO portuguese_index VALUES ("esmagar","NULL","v#00559390 v#01097909 v#01800195","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aglomerado","NULL","NULL","a#00526734","NULL");
INSERT INTO portuguese_index VALUES ("movimentado","NULL","NULL","a#00526734","NULL");
INSERT INTO portuguese_index VALUES ("saltar","NULL","v#00560391 v#01892104 v#01291867 v#01303431 v#01336773 v#01337493 v#01338935","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sociável","NULL","NULL","a#00528181 a#02257141","NULL");
INSERT INTO portuguese_index VALUES ("Passe_para_a_frente","n#00561226","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proporcionado","NULL","NULL","a#00561600","NULL");
INSERT INTO portuguese_index VALUES ("congruente","NULL","NULL","a#00561600","NULL");
INSERT INTO portuguese_index VALUES ("coincidente","NULL","NULL","a#00561757 a#02266559","NULL");
INSERT INTO portuguese_index VALUES ("idêntico","NULL","NULL","a#00529038 a#00845976 a#01360962 a#01986273 a#01990838","NULL");
INSERT INTO portuguese_index VALUES ("obstrução","n#00562280 n#01074498","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incongruente","NULL","NULL","a#00562469","NULL");
INSERT INTO portuguese_index VALUES ("desinflar","NULL","v#00562720","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discrepante","NULL","NULL","a#00562803","NULL");
INSERT INTO portuguese_index VALUES ("queimada_dupla","n#00564373","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preguear","NULL","v#00564695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amassar","NULL","v#00564857 v#01235355 v#01278427 v#00873019 v#01279631","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divisório","NULL","NULL","a#00531862","NULL");
INSERT INTO portuguese_index VALUES ("tacada","n#00369708 n#00788473","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aparentado","NULL","NULL","a#00533750","NULL");
INSERT INTO portuguese_index VALUES ("forehand","n#00567418","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Serviço","n#00371920","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ace","n#00372142","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inconquistável","NULL","NULL","a#00569568","NULL");
INSERT INTO portuguese_index VALUES ("braçada","n#00569898","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indomável","NULL","NULL","a#00570099 a#01475526","NULL");
INSERT INTO portuguese_index VALUES ("insuperável","NULL","NULL","a#00570225 a#02357115","NULL");
INSERT INTO portuguese_index VALUES ("invencível","NULL","NULL","a#00570322 a#02288252","NULL");
INSERT INTO portuguese_index VALUES ("Australian_Crawl","n#00570366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consciente","NULL","NULL","a#00537748 a#01284583 a#01907044","NULL");
INSERT INTO portuguese_index VALUES ("borboleta","n#00374336 n#01777374","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Borboleta","n#00374336","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("borboletas","n#00374336 n#01777374","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mariposa","n#00374336 n#01777374 n#02283201","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bruços","n#00571060","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bruços","n#00571060","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("braça","n#00571060 n#13660178","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("costas","n#00374747 n#02231899 n#03217207 n#04306040 n#04330266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esmaecido","NULL","NULL","a#00538832","NULL");
INSERT INTO portuguese_index VALUES ("desacordado","NULL","NULL","a#00538832","NULL");
INSERT INTO portuguese_index VALUES ("desfalecido","NULL","NULL","a#00538832","NULL");
INSERT INTO portuguese_index VALUES ("desmaiado","NULL","NULL","a#00538832","NULL");
INSERT INTO portuguese_index VALUES ("incônscio","NULL","NULL","a#00538832 a#02400554","NULL");
INSERT INTO portuguese_index VALUES ("desanimar","NULL","v#00573085 v#00908099 v#01238101 v#01819147","NULL","NULL");
INSERT INTO portuguese_index VALUES ("violentado","NULL","NULL","a#00574010","NULL");
INSERT INTO portuguese_index VALUES ("violado","NULL","NULL","a#00574010","NULL");
INSERT INTO portuguese_index VALUES ("despolarizar","NULL","v#00574341","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmineralizar","NULL","v#00574514","NULL","NULL");
INSERT INTO portuguese_index VALUES ("moleza","n#00575365","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trabalho","n#00377835 n#00378419 n#00378829 n#00380841 n#00381958 n#00383807 n#00408411 n#00409199 n#00503108 n#03629197 n#03631348 n#08137495","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tarefa","n#00377835 n#00378829 n#00729108 n#00730247 n#00796586 n#00503108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("progresista","NULL","NULL","a#00543180","NULL");
INSERT INTO portuguese_index VALUES ("progressista","NULL","NULL","a#00543180 a#01473088 a#01804618","NULL");
INSERT INTO portuguese_index VALUES ("consistente","NULL","NULL","a#00543564","NULL");
INSERT INTO portuguese_index VALUES ("procedimento","n#00378984 n#00660588 n#03835766","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_conformidade","NULL","NULL","a#00577405","NULL");
INSERT INTO portuguese_index VALUES ("inconsistente","NULL","NULL","a#00577920 a#01987207","NULL");
INSERT INTO portuguese_index VALUES ("auditoria_contábil","n#00578405","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lavagem_(roupa)","n#00578708","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lavagem","n#00578708 n#07805006","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engraxate","n#00579082","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conspícuo","NULL","NULL","a#00545700","NULL");
INSERT INTO portuguese_index VALUES ("saliente","NULL","NULL","a#00545700 a#01353982","NULL");
INSERT INTO portuguese_index VALUES ("proeminente","NULL","NULL","a#00545700 a#00546266 a#00547551","NULL");
INSERT INTO portuguese_index VALUES ("ilustre","NULL","NULL","a#00546266 a#01321211","NULL");
INSERT INTO portuguese_index VALUES ("importante","NULL","NULL","a#00546266 a#00618913 a#01223408 a#01477528 a#01758997 a#02078228","NULL");
INSERT INTO portuguese_index VALUES ("dominar","NULL","v#00579712 v#01731370","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subordinar","NULL","v#00579712 v#01798079","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subjugar","NULL","v#00579712 v#00750961","NULL","NULL");
INSERT INTO portuguese_index VALUES ("submeter","NULL","v#00579712 v#00732394 v#01701149","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serviço_militar","n#00579977","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agregado_familiar","n#00580961","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ferro_De_Passar","n#00581090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ferro_de_passar","n#00581090 n#02867016","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("visualizar","NULL","v#00581205 v#01123901 v#01636008 v#02151394","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Workload","n#00380841","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ondular","NULL","v#00581355","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invisível","NULL","NULL","a#00548185 a#02395922","NULL");
INSERT INTO portuguese_index VALUES ("abate","n#00581772","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indústria_madeireira","n#00581772","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("papelada","n#00582071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serviços_sociais","n#00582195","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("socorro_social","n#00582195","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distiguivel","NULL","NULL","a#00582314","NULL");
INSERT INTO portuguese_index VALUES ("que_pode_ser_distinguido","NULL","NULL","a#00582314","NULL");
INSERT INTO portuguese_index VALUES ("profissão","n#00381958 n#00382624 n#00399744 n#00402228 n#05011927","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ofício","n#00381958 n#00399744 n#10048361","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("função","n#00381958 n#00462318 n#00722061 n#04011535 n#06582403 n#13781164 n#09927753","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diferenciável","NULL","NULL","a#00582636 a#02712810","NULL");
INSERT INTO portuguese_index VALUES ("constante","n#09761890","NULL","a#00549951 a#00562853 a#00563345 a#02385304","NULL");
INSERT INTO portuguese_index VALUES ("vocação","n#00382624 n#00584248","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("especialização","n#00382821 n#00383035 n#09743392","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Especialidades_médicas","n#00382821","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("especialidade","n#00382821 n#03741160 n#05640729","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inquebrantável","NULL","NULL","a#00550615","NULL");
INSERT INTO portuguese_index VALUES ("inconstante","NULL","NULL","a#00583990","NULL");
INSERT INTO portuguese_index VALUES ("biscate","n#00383807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falso","NULL","NULL","a#00551365 a#02343098","NULL");
INSERT INTO portuguese_index VALUES ("caprichoso","n#04545843 n#05568649","NULL","a#00584626","NULL");
INSERT INTO portuguese_index VALUES ("dever","n#00384174 n#00461585 n#00731811","v#01542388 v#01542552","NULL","NULL");
INSERT INTO portuguese_index VALUES ("construtivo","NULL","NULL","a#00584820 a#01818077","NULL");
INSERT INTO portuguese_index VALUES ("teletrabalho","n#00585018","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serviços","n#00585174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criativo","NULL","NULL","a#00552091 a#01796235 a#00607344","NULL");
INSERT INTO portuguese_index VALUES ("preparar_feno","NULL","v#00585405","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serviços_públicos","n#00585660","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("utilidade_pública","n#00585660","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ministro","n#00384745 n#09983572 n#07412658","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reconstructor","NULL","NULL","a#00585856","NULL");
INSERT INTO portuguese_index VALUES ("reconstructor","NULL","NULL","a#00585856","NULL");
INSERT INTO portuguese_index VALUES ("estrutural","NULL","NULL","a#00552772 a#01038818 a#02677877 a#02678054 a#02719360 a#02719560","NULL");
INSERT INTO portuguese_index VALUES ("destrutivo","NULL","NULL","a#00586183","NULL");
INSERT INTO portuguese_index VALUES ("erotizar","NULL","v#00586241","NULL","NULL");
INSERT INTO portuguese_index VALUES ("posição","n#00385376 n#00462982 n#03907971 n#03960878 n#05075602 n#03965003 n#03965383 n#05082507 n#04697893 n#06483454 n#05080036 n#06352837 n#08622201 n#06353479 n#08624196 n#08653706 n#10048803 n#10049911 n#10351976 n#10352475","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cargo","n#00385376 n#10048361","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("redimensionar","NULL","v#00586816","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cáustico","NULL","NULL","a#00587376 a#01730738","NULL");
INSERT INTO portuguese_index VALUES ("corrosivo","NULL","NULL","a#00587376 a#02079732","NULL");
INSERT INTO portuguese_index VALUES ("iconoclástico","NULL","NULL","a#00588207 a#01691687","NULL");
INSERT INTO portuguese_index VALUES ("compreender","NULL","v#00397191 v#00397666 v#00589738 v#00590241 v#00399152 v#00419626 v#00422121 v#00493867 v#01457245 v#01794033 v#01842330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entender","NULL","v#00397191 v#00397666 v#00589309 v#00589738 v#00589904 v#00398597 v#00399152 v#00400923 v#00401225 v#00401762 v#00419626 v#00422121 v#00493867 v#01442173","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esbanjador","NULL","NULL","a#00588655","NULL");
INSERT INTO portuguese_index VALUES ("almirantado","n#00588703 n#08349548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embaixada","n#00387454 n#02636321 n#06213619 n#08402693 n#08402828","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dignidade_e_função_de_apóstolo","n#00588881","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comprender","NULL","v#00397666 v#00589904 v#00398787 v#00494146","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprendizado","n#00387618 n#04590750","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convencido","NULL","NULL","a#00589067 a#00589448 a#01891773","NULL");
INSERT INTO portuguese_index VALUES ("cheio_de_si","NULL","NULL","a#00589067 a#00589448","NULL");
INSERT INTO portuguese_index VALUES ("vaidoso","NULL","NULL","a#00589067 a#00589448","NULL");
INSERT INTO portuguese_index VALUES ("advocacia","n#00589217","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saciado","NULL","NULL","a#00557087","NULL");
INSERT INTO portuguese_index VALUES ("satisfeito","n#07531105","NULL","a#00557087 a#01805157 a#01892506 a#02189742","NULL");
INSERT INTO portuguese_index VALUES ("sentir","NULL","v#00589469 v#01209074 v#01225879 v#01485693 v#01562344","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discontente","NULL","NULL","a#00589624","NULL");
INSERT INTO portuguese_index VALUES ("califado","n#00589691 n#15248812","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("capitania","n#00589769","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebelde","n#07341493 n#07401774","NULL","a#00557654 a#00915311 a#02219878","NULL");
INSERT INTO portuguese_index VALUES ("chancelaria","n#00590148 n#03005033","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descontente","NULL","NULL","a#00590163","NULL");
INSERT INTO portuguese_index VALUES ("perceber","NULL","v#00590241 v#01442173 v#01449939","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contestável","NULL","NULL","a#00557994","NULL");
INSERT INTO portuguese_index VALUES ("discutível","NULL","NULL","a#00558237 a#00570063 a#01728405","NULL");
INSERT INTO portuguese_index VALUES ("que_não_se_pode_contestar","NULL","NULL","a#00558480","NULL");
INSERT INTO portuguese_index VALUES ("digerir","NULL","v#00399015 v#01197338","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demonstrável","NULL","NULL","a#00591147 a#01619105","NULL");
INSERT INTO portuguese_index VALUES ("assessoria","n#00591236","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irrefutável","NULL","NULL","a#00591710 a#00686264","NULL");
INSERT INTO portuguese_index VALUES ("incontinente","NULL","NULL","a#00591953","NULL");
INSERT INTO portuguese_index VALUES ("contínuo","NULL","NULL","a#00559642 a#00562039 a#00562853 a#00563345 a#00564091 a#00564857","NULL");
INSERT INTO portuguese_index VALUES ("apreciar","NULL","v#00399995 v#00691665 v#00604655 v#00604807 v#01212539 v#01231918 v#01544040","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repetitivo","NULL","NULL","a#00592539 a#01964367","NULL");
INSERT INTO portuguese_index VALUES ("insistente","NULL","NULL","a#00592539 a#00678141","NULL");
INSERT INTO portuguese_index VALUES ("recorrente","NULL","NULL","a#00560754","NULL");
INSERT INTO portuguese_index VALUES ("perene","NULL","NULL","a#00560754 a#00641546 a#01383728 a#01691167","NULL");
INSERT INTO portuguese_index VALUES ("admitir_a_veracidade_de","NULL","v#00400501","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reconhecer","NULL","v#00400501 v#00412827 v#00418578 v#00740449 v#00555115 v#00604807 v#00717811 v#02475535 v#02754158","NULL","NULL");
INSERT INTO portuguese_index VALUES ("admitir","NULL","v#00400501 v#00490373 v#00555115 v#00555732 v#01530524 v#01669261 v#01705579 v#02671279 v#02745486","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diretoria_de_um_colégio","n#00592894","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("persistente","NULL","NULL","a#00560909","NULL");
INSERT INTO portuguese_index VALUES ("casual","NULL","NULL","a#00593374 a#00715018 a#01726809","NULL");
INSERT INTO portuguese_index VALUES ("esporádico","NULL","NULL","a#00593374","NULL");
INSERT INTO portuguese_index VALUES ("raro","NULL","NULL","a#00593374 a#01618418","NULL");
INSERT INTO portuguese_index VALUES ("inferir","NULL","v#00400923 v#00428966 v#00430091 v#00430461 v#00944924","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extrapolar","NULL","v#00593669 v#00642644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intermitente","NULL","NULL","a#00593836","NULL");
INSERT INTO portuguese_index VALUES ("estágio","n#00593837 n#03799375 n#10211203","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("traduzir","NULL","v#00401225 v#00649804 v#00961947","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interpretar","NULL","v#00401225 v#00635307 v#01185353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ocasional","NULL","NULL","a#00594004 a#01067415 a#01842468 a#01961205","NULL");
INSERT INTO portuguese_index VALUES ("periódico","n#04946588","NULL","a#00594004 a#01967240","NULL");
INSERT INTO portuguese_index VALUES ("irregular","NULL","NULL","a#00561747 a#01539551 a#01962107 a#01900549","NULL");
INSERT INTO portuguese_index VALUES ("isolada","NULL","NULL","a#00561850","NULL");
INSERT INTO portuguese_index VALUES ("conhecer","NULL","v#00401559 v#00401762 v#00402210 v#00402992 v#00608372 v#01770968","NULL","NULL");
INSERT INTO portuguese_index VALUES ("biblioteconomia","n#00594477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saber","n#04387608 n#05999266","v#00401762 v#00402210","NULL","NULL");
INSERT INTO portuguese_index VALUES ("magistratura","n#00594738","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("virilidade","n#00594953 n#04666837","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mestria","n#00595146","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maestria","n#00595146","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incessante","NULL","NULL","a#00562853 a#01382215","NULL");
INSERT INTO portuguese_index VALUES ("sem_paradas","NULL","NULL","a#00562853","NULL");
INSERT INTO portuguese_index VALUES ("perpétuo","NULL","NULL","a#00562853 a#01691034 a#01691167","NULL");
INSERT INTO portuguese_index VALUES ("desconhecer","NULL","v#00402103","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ignorar","NULL","v#00402103 v#00616857 v#00544324 v#00717937 v#01450453","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ininterrupto","NULL","NULL","a#00564091","NULL");
INSERT INTO portuguese_index VALUES ("presidência","n#00392749 n#10966076","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Presidente","n#00597265","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("presidentes","n#00597265","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("seguido","NULL","NULL","a#00597758","NULL");
INSERT INTO portuguese_index VALUES ("estudar","NULL","v#00403772 v#00405251 v#00410090 v#00410381","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprender","NULL","v#00403772 v#00405251 v#00622450","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cadeira","n#00598056 n#02418562 n#03293673 n#03294261 n#03419984 n#06368526","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reaprender","NULL","v#00598278","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprender_de_novo","NULL","v#00598278","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controlado","NULL","NULL","a#00598679","NULL");
INSERT INTO portuguese_index VALUES ("informar-se","NULL","v#00404522","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descobrir","NULL","v#00404522 v#00488567 v#00488684 v#00496212 v#00622450 v#01124979 v#01456213 v#01467502 v#01474694 v#01562485","NULL","NULL");
INSERT INTO portuguese_index VALUES ("achar","NULL","v#00404522 v#00427776 v#00428966 v#00465761 v#00689809 v#00466561 v#00466852 v#00482033 v#00483900 v#00721098 v#00734348 v#00739340 v#00622132 v#01124979 v#01474694 v#02212275 v#01515833 v#01538749 v#01562037 v#01562485 v#01562883 v#01838645","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Residência_médica","n#00599064","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("possuído","NULL","NULL","a#00599468 a#02074673","NULL");
INSERT INTO portuguese_index VALUES ("secretaria","n#00393890 n#06172324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("noticiar","NULL","v#00404997 v#00832778 v#00833199 v#00591857 v#00874175","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anárquico","NULL","NULL","a#00600192","NULL");
INSERT INTO portuguese_index VALUES ("ocupar","NULL","v#00405557 v#00764618 v#01808536","NULL","NULL");
INSERT INTO portuguese_index VALUES ("errante","NULL","NULL","a#00600395 a#00964303","NULL");
INSERT INTO portuguese_index VALUES ("envolver","NULL","v#00600724 v#01582070 v#01089313 v#02677332","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esgotar","NULL","v#00405932 v#00787825 v#01551588 v#01558918","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consumir","NULL","v#00405932 v#00786286 v#00787073 v#00792261 v#00814298 v#01551588","NULL","NULL");
INSERT INTO portuguese_index VALUES ("focar","NULL","v#00601043 v#00489333 v#01479663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engulir","NULL","v#00406510","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controverso","NULL","NULL","a#00569747 a#00602293","NULL");
INSERT INTO portuguese_index VALUES ("polémico","NULL","NULL","a#00569747 a#00570408","NULL");
INSERT INTO portuguese_index VALUES ("polêmico","NULL","NULL","a#00569747 a#00570408","NULL");
INSERT INTO portuguese_index VALUES ("abraçar","NULL","v#00406673 v#00976384","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Secretário_de_estado","n#00602026","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Secretário_de_Estado","n#00602026","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conflituoso","NULL","NULL","a#00602293","NULL");
INSERT INTO portuguese_index VALUES ("trabalhar_como_aprendiz","NULL","v#00602635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inquestionável","NULL","NULL","a#01848815","NULL");
INSERT INTO portuguese_index VALUES ("incontestado","NULL","NULL","a#01848815","NULL");
INSERT INTO portuguese_index VALUES ("Secretário_da_Marinha_dos_Estados_Unidos","n#00603319","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sinecura","n#00604228","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saber_de_cor","NULL","v#00604576","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decorar","NULL","v#00604576 v#01005978 v#01150345 v#01679806 v#02749247","NULL","NULL");
INSERT INTO portuguese_index VALUES ("memorizar","NULL","v#00604576","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trono","n#00605023 n#03499424","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incoveniente","NULL","NULL","a#00572361","NULL");
INSERT INTO portuguese_index VALUES ("bisonho","NULL","NULL","a#00605406","NULL");
INSERT INTO portuguese_index VALUES ("inábil","NULL","NULL","a#00605406","NULL");
INSERT INTO portuguese_index VALUES ("desastrado","NULL","NULL","a#00605406","NULL");
INSERT INTO portuguese_index VALUES ("convencional","NULL","NULL","a#00572731 a#00574540 a#00577179 a#00577578 a#00991505 a#01630148 a#01910102","NULL");
INSERT INTO portuguese_index VALUES ("corriqueiro","NULL","NULL","a#00572731","NULL");
INSERT INTO portuguese_index VALUES ("indoutrinar","NULL","v#00605671","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marrar","NULL","v#00605783 v#00410090 v#01612295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recebido","NULL","NULL","a#00605893","NULL");
INSERT INTO portuguese_index VALUES ("praticar","NULL","v#00409147 v#00565367 v#01746847 v#01751275","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arte","n#00399744 n#00598038 n#02213100 n#04360761 n#06998748","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inculcar","NULL","v#00606600","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_usual","NULL","NULL","a#00606602","NULL");
INSERT INTO portuguese_index VALUES ("diplomar-se","NULL","v#00607609","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diplomar","NULL","v#00607609","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Carpintaria","n#00607775","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marcenaria","n#00607775","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recordar-se","NULL","v#00410666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recordar","NULL","v#00410666 v#00412961 v#00413589 v#00696414","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lembrar-se","NULL","v#00410666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lembrar","NULL","v#00410666 v#00609506 v#00412253 v#00413589","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_convencional","NULL","NULL","a#00608421","NULL");
INSERT INTO portuguese_index VALUES ("alternativo","NULL","NULL","a#00575492 a#01782779","NULL");
INSERT INTO portuguese_index VALUES ("bizzaro","NULL","NULL","a#00575615","NULL");
INSERT INTO portuguese_index VALUES ("estranho","NULL","NULL","a#00575615 a#00917876 a#00918492 a#00919283 a#00968522 a#00920300 a#00983540 a#00984080 a#01519719 a#02042796","NULL");
INSERT INTO portuguese_index VALUES ("bizarro","NULL","NULL","a#00575615 a#00919283 a#01519719","NULL");
INSERT INTO portuguese_index VALUES ("alvenaria","n#00608896 n#03725717","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esquecer","NULL","v#00411760 v#00412665 v#00613018 v#00416059","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pintura","n#00609236 n#00717208 n#00598869 n#02598242 n#03078466 n#03079051 n#03160624","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("próprio_de_alguém","NULL","NULL","a#00576203","NULL");
INSERT INTO portuguese_index VALUES ("indiossincrático","NULL","NULL","a#00576203","NULL");
INSERT INTO portuguese_index VALUES ("encanamento","n#00609669 n#03969041","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pensar","NULL","v#00412253 v#00426277 v#00629738 v#00427776 v#00465761 v#00721098 v#00489783 v#00734348 v#00739082 v#00739340 v#01634142 v#01124228 v#01483324","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esqueça-se","NULL","v#00412665","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atômico","NULL","NULL","a#00576833 a#02667673","NULL");
INSERT INTO portuguese_index VALUES ("literatura","n#00402867 n#06169285 n#04685374 n#06364641 n#06365102 n#06366269 n#04800434","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Arquitetura","n#00402994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Arquitectura","n#00402994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arquitectura","n#00402994 n#02206447 n#03858780 n#04659700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trazer_de_volta","NULL","v#00610770","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reclamar","NULL","v#00610928 v#00844941 v#00614225 v#00910891 v#00616654 v#02275365","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tradicional","NULL","NULL","a#00577362 a#01630291","NULL");
INSERT INTO portuguese_index VALUES ("direito","n#00611143 n#04030305","NULL","a#01197634 a#01959343","NULL");
INSERT INTO portuguese_index VALUES ("relembrar","NULL","v#00413589","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pedagogia","n#00403367 n#00570118","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rememorar","NULL","v#00611481 v#00612042","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Jornalismo","n#00611674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("política","n#00403663 n#04536028 n#04673837 n#04991678 n#09971476","NULL","a#01743546 a#02646683 a#02646845","NULL");
INSERT INTO portuguese_index VALUES ("comemorar","NULL","v#00612042 v#00612612","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convergente","NULL","NULL","a#00612114","NULL");
INSERT INTO portuguese_index VALUES ("Incisão","n#00403778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prática_da_medicina","n#00403778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Medicina","n#00403778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("medicina","n#00403778 n#04624523","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remédio","n#00403778 n#00664110 n#02609065 n#02981307 n#03920989 n#03228145","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divergente","NULL","NULL","a#00612652 a#02066662","NULL");
INSERT INTO portuguese_index VALUES ("reprimir","NULL","v#00414743 v#00559552 v#01080303","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suprimir","NULL","v#00414743 v#01327582 v#01649646 v#02427334","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Medicina_preventiva_e_social","n#00613282","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("largar_mão","NULL","v#00415168","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desistir","NULL","v#00415168 v#00546749 v#00734233 v#01116447 v#00758158 v#01117812 v#00813880 v#01829006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("medicina_alternativa","n#00613473","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("teologia","n#00613973 n#06182144 n#06183899","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escrita","n#00404574 n#04794515","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Criptografia","n#00405074","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criptografia","n#00405074","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("programação","n#00405074 n#00928947 n#01144355 n#04533598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convincente","NULL","NULL","a#00580464","NULL");
INSERT INTO portuguese_index VALUES ("omitir","NULL","v#00614999 v#00416622 v#01467965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deixar_passar","NULL","v#00614999 v#00416622","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preterir","NULL","v#00614999 v#00416622 v#00617293","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escapar","NULL","v#00614999 v#01419172 v#02073714 v#01419809 v#01420004 v#01420304 v#01420490 v#02100476","NULL","NULL");
INSERT INTO portuguese_index VALUES ("credível","NULL","NULL","a#00580683","NULL");
INSERT INTO portuguese_index VALUES ("crível","NULL","NULL","a#00580683 a#00608243","NULL");
INSERT INTO portuguese_index VALUES ("elidir","NULL","v#00615421","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cozinhado","NULL","NULL","a#00615757","NULL");
INSERT INTO portuguese_index VALUES ("codificação","n#00405203 n#00651289","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encriptação","n#00405203","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descurar","NULL","v#00416911","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negligenciar","NULL","v#00416911 v#00616857 v#01450453","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desleixar","NULL","v#00416911","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descuidar","NULL","v#00416911","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Compressão_de_imagens","n#00616279","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mpeg","n#00616398","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("MPEG","n#00616398","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grupo_MPEG","n#00616398","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gratinado","NULL","NULL","a#00616408","NULL");
INSERT INTO portuguese_index VALUES ("pular","NULL","v#00417162 v#01336773 v#01338935","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assado","NULL","NULL","a#00616532 a#00618377","NULL");
INSERT INTO portuguese_index VALUES ("descodificação","n#00617059","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Decifração","n#00617059","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("queimado","NULL","NULL","a#00617137 a#01264509","NULL");
INSERT INTO portuguese_index VALUES ("triangulação","n#00617337 n#06008148","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pirotecnia","n#00617692","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pirotecnia","n#00617692","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pirotécnica","n#00617692","NULL","a#03106846","NULL");
INSERT INTO portuguese_index VALUES ("equivocar","NULL","v#00417819","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confundir","NULL","v#00417819 v#00619610 v#00419883 v#00420006 v#00421101 v#01138007 v#01222254 v#01222619 v#01791408 v#01791973","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sapateiro","n#00617865 n#09933098","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sapataria","n#00617865 n#04200800","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("identificar","NULL","v#00418258 v#00418578 v#00439864 v#00483299 v#00694228","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Saltear","NULL","NULL","a#00618493","NULL");
INSERT INTO portuguese_index VALUES ("saltear","NULL","v#01601331","a#00618493","NULL");
INSERT INTO portuguese_index VALUES ("Contabilidade","n#00618734","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contabilidade","n#00618734 n#05662532 n#13354985 n#13405962 n#13929037","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contabilidade_(execução)","n#00618734 n#00619230","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Contabilidade_de_Custos","n#00619011","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Contabilidade_de_custos","n#00619011","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("datar","NULL","v#00418793 v#00498714 v#00499117","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escrituração","n#00619230","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sistemas_de_Contabilidade","n#00619230","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escrituração_contábil","n#00619230","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cru","NULL","NULL","a#00584005","NULL");
INSERT INTO portuguese_index VALUES ("crua","NULL","NULL","a#00584005","NULL");
INSERT INTO portuguese_index VALUES ("entender_mal","NULL","v#00419381","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compreender_mal","NULL","v#00419381","NULL","NULL");
INSERT INTO portuguese_index VALUES ("FIFO","n#00620084","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fifo","n#00620084","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fotografia","n#00408287 n#00580612 n#00907919 n#03113185 n#03118233 n#04248607 n#09674939","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_cooperativo","NULL","NULL","a#00620585","NULL");
INSERT INTO portuguese_index VALUES ("que_não_coopera","NULL","NULL","a#00620585","NULL");
INSERT INTO portuguese_index VALUES ("obscurecer","NULL","v#00420006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obnubilar","NULL","v#00420006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corrupto","NULL","NULL","a#00620731 a#02319129","NULL");
INSERT INTO portuguese_index VALUES ("mão-de-obra","n#00408411 n#08212347","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elucidar","NULL","v#00420545","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esclarecer","NULL","v#00420545 v#00635987","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desonesto","NULL","NULL","a#00621207","NULL");
INSERT INTO portuguese_index VALUES ("venal","NULL","NULL","a#00621207","NULL");
INSERT INTO portuguese_index VALUES ("corruptível","NULL","NULL","a#00621207","NULL");
INSERT INTO portuguese_index VALUES ("empenho","n#00409314 n#03811466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esforço","n#00409314 n#00624553 n#00503611 n#00505681 n#00508046 n#00503108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grande_esforço","n#00622068","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("batalha","n#00622068 n#00505798 n#00789391 n#00609840 n#00610417 n#00619159 n#00756240 n#00758807 n#00759769","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmoralizar","NULL","v#00622204 v#01238101","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atordoar","NULL","v#00622384","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Caça","n#00410109","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anti-séptico","NULL","NULL","a#00622828","NULL");
INSERT INTO portuguese_index VALUES ("antisséptico","n#02724207","NULL","a#00622828","NULL");
INSERT INTO portuguese_index VALUES ("sinérgico","NULL","NULL","a#00623356","NULL");
INSERT INTO portuguese_index VALUES ("interativo","NULL","NULL","a#00623356 a#01946439","NULL");
INSERT INTO portuguese_index VALUES ("Escravidão","n#00623545","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antiácido","NULL","NULL","a#00623814","NULL");
INSERT INTO portuguese_index VALUES ("dificuldade","n#00411168 n#03705476 n#04394770 n#04395081 n#04395690 n#10339059 n#10339565 n#10340761","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espiritualizar","NULL","v#00623947","NULL","NULL");
INSERT INTO portuguese_index VALUES ("considerável","NULL","NULL","a#00589115 a#00589915","NULL");
INSERT INTO portuguese_index VALUES ("ler","NULL","v#00422928 v#00423416 v#00425047 v#00425290 v#00624230","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apreciável","NULL","NULL","a#00589915","NULL");
INSERT INTO portuguese_index VALUES ("exercício_fisico","n#00411620","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reler","NULL","v#00423896","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insustancial","NULL","NULL","a#00625774","NULL");
INSERT INTO portuguese_index VALUES ("insubstancial","NULL","NULL","a#00625774","NULL");
INSERT INTO portuguese_index VALUES ("fisiculturismo","n#00625993","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fisioculturismo","n#00625993","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fisiculturismo","n#00625993","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("culturismo","n#00625993","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("etéreo","NULL","NULL","a#00626136","NULL");
INSERT INTO portuguese_index VALUES ("proclamar","NULL","v#00424702 v#00687592","NULL","NULL");
INSERT INTO portuguese_index VALUES ("supino","n#00626574","NULL","a#01239781","NULL");
INSERT INTO portuguese_index VALUES ("material","n#04977814","NULL","a#00591892","NULL");
INSERT INTO portuguese_index VALUES ("ditar","NULL","v#00424940 v#00506658 v#00507599","NULL","NULL");
INSERT INTO portuguese_index VALUES ("físico","n#03904884 n#07474830","NULL","a#00592078 a#00592283 a#00832150 a#01518826 a#01717117 a#01710523 a#02391455 a#02392134 a#02594072","NULL");
INSERT INTO portuguese_index VALUES ("imaterial","NULL","NULL","a#00627410 a#00630802 a#01488066","NULL");
INSERT INTO portuguese_index VALUES ("escanear","NULL","v#00425290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ler_em_diagonal","NULL","v#00627824","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ler_superficialmente","NULL","v#00627824","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ler_fazendo_correções","NULL","v#00426161","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cooper","n#00628390","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("raciocínar","NULL","v#00426277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("refletir","NULL","v#00426277 v#00427308 v#01462444 v#02136754 v#01462616 v#01890214 v#02766925","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alongamento","n#00628692 n#02636015","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("racionalizar","NULL","v#00629257 v#00629492 v#00606341","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Flexão","n#00414547","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corpórea","NULL","NULL","a#00594049","NULL");
INSERT INTO portuguese_index VALUES ("corpóreo","NULL","NULL","a#00594049 a#01711095 a#02524050","NULL");
INSERT INTO portuguese_index VALUES ("filosofar","NULL","v#00630026","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Agachamento","n#00630071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Flexão_de_perna","n#00630268","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corporal","NULL","NULL","a#00594345","NULL");
INSERT INTO portuguese_index VALUES ("contemplar","NULL","v#00427308 v#00475833 v#00476424 v#00711715 v#01459552 v#01481912","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corporativo","NULL","NULL","a#00630466 a#01670669 a#02038355 a#02984781","NULL");
INSERT INTO portuguese_index VALUES ("Ioga","n#00630960","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ioga","n#00630960 n#06239361","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hata-ioga","n#00631168","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hata_ioga","n#00631168","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espiritual","NULL","NULL","a#00595155 a#01978427 a#02455584","NULL");
INSERT INTO portuguese_index VALUES ("prática","n#00415881 n#00574902","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("correto","NULL","NULL","a#00595353 a#00728191","NULL");
INSERT INTO portuguese_index VALUES ("teologizar","NULL","v#00631398","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consultas","n#00631712","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consultoria","n#00631712 n#08073844","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("supor","NULL","v#00427776 v#00428091 v#00633443 v#00430091 v#00620765 v#00621026 v#01009821","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afinado","NULL","NULL","a#00595724","NULL");
INSERT INTO portuguese_index VALUES ("cosmetologia","n#00631887","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pressupor","NULL","v#00428091 v#00484801 v#00484968","NULL","NULL");
INSERT INTO portuguese_index VALUES ("presumir","NULL","v#00428091 v#00550404","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Medicina_familiar","n#00632342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incorreto","NULL","NULL","a#00596241 a#01808627","NULL");
INSERT INTO portuguese_index VALUES ("raciocinar","NULL","v#00428321 v#00633265","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Optometria","n#00632716","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("optometria","n#00632716","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("teorizar","NULL","v#00632931 v#00633094 v#00633443","NULL","NULL");
INSERT INTO portuguese_index VALUES ("errôneo","NULL","NULL","a#00596698","NULL");
INSERT INTO portuguese_index VALUES ("erróneo","NULL","NULL","a#00596698","NULL");
INSERT INTO portuguese_index VALUES ("falaz","NULL","NULL","a#00633084","NULL");
INSERT INTO portuguese_index VALUES ("empirismo","n#00633108 n#00635699 n#05970311","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diligência","n#00633329 n#04297098 n#04673006 n#04865114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("investigação","n#00416938 n#00418126 n#00604772 n#04467719 n#04470360","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("análise","n#00422134 n#04451818 n#04604475","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chegar","NULL","v#00428966 v#00444338 v#01368651 v#01375966 v#01379952","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deduzir","NULL","v#00428966 v#00430461 v#00432991 v#00944924 v#00691426","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decidir","NULL","v#00428966 v#00471542 v#00472610 v#00472976 v#00518436","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enumeração","n#00426345 n#06490887","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contar","n#00426345","v#00641935 v#00642112 v#00644776 v#00645379 v#00682542 v#01549722 v#02683489","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corrigível","NULL","NULL","a#00634862","NULL");
INSERT INTO portuguese_index VALUES ("solucionar","NULL","v#00429256","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incorrigível","NULL","NULL","a#00635456","NULL");
INSERT INTO portuguese_index VALUES ("responder","NULL","v#00635523 v#00430222 v#00485595 v#00718308 v#00718737 v#00487007 v#00554194","NULL","NULL");
INSERT INTO portuguese_index VALUES ("examinar","n#00419850","v#00435242 v#00436525 v#00697419 v#00535682 v#01460594 v#01458506 v#02152812","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inspecionar","n#00419850","v#00697062 v#01259471 v#01458506 v#01482454 v#01664310","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cosmopolita","n#09967406","NULL","a#00635955 a#01106614","NULL");
INSERT INTO portuguese_index VALUES ("viajado","NULL","NULL","a#00636391 a#02454206","NULL");
INSERT INTO portuguese_index VALUES ("induzir","NULL","v#00430365 v#00523422 v#02384554","NULL","NULL");
INSERT INTO portuguese_index VALUES ("examinação","n#00417674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("teste","n#00417674 n#00639975 n#00644702 n#00507777 n#00508046 n#00794614 n#00508441 n#00564770 n#00649604 n#00657820 n#04429650 n#04468129 n#05378329 n#05379363","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("provincial","NULL","NULL","a#00636547 a#02597243","NULL");
INSERT INTO portuguese_index VALUES ("depreender","NULL","v#00430461","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inquérito","n#00418126 n#00637354 n#04467719 n#04470360 n#07193184 n#05376578","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("questionamento","n#00418126","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("basear","NULL","v#00430666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fundamentar","NULL","v#00430666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pesquisa","n#00417296 n#00604772 n#04467719 n#04470360 n#05800998","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("construir","NULL","v#00637115 v#00665476 v#01111638 v#01114991 v#01117358 v#01135342 v#01136484 v#01655505 v#01140839 v#01739099","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calcular","NULL","v#00430966 v#00482033 v#00626821","NULL","NULL");
INSERT INTO portuguese_index VALUES ("computar","NULL","v#00430966 v#01549722","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paroquial","NULL","NULL","a#00601207 a#02871695","NULL");
INSERT INTO portuguese_index VALUES ("investigação_operacional","n#00637546","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("laxativo","NULL","NULL","a#00637857","NULL");
INSERT INTO portuguese_index VALUES ("clonagem","n#00638243","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Clonagem","n#00638243","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("constipado","NULL","NULL","a#00638253","NULL");
INSERT INTO portuguese_index VALUES ("processar","NULL","v#00431606 v#01660593","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inconsiderado","NULL","NULL","a#00639356 a#02420757","NULL");
INSERT INTO portuguese_index VALUES ("experiência","n#00418704 n#00639975 n#00503375 n#04921417 n#04441868 n#04468129 n#04469208 n#04589992 n#05434281","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("experimento","n#00418704 n#04468129","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recalcular","NULL","v#00639693","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cortês","NULL","NULL","a#00639842 a#00641343 a#00641460 a#00606022 a#02161503","NULL");
INSERT INTO portuguese_index VALUES ("pesquisa_de_mercado","n#00640188","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elevar_ao_cubo","NULL","v#00640262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cubar","NULL","v#00640262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("considerar","NULL","v#00640650 v#00689809 v#00466313 v#00466561 v#00466852 v#00691312 v#00468967 v#00711715 v#00482033 v#00497921 v#00552303 v#01210323 v#01483324","NULL","NULL");
INSERT INTO portuguese_index VALUES ("brusco","NULL","NULL","a#00604516 a#01094377 a#01095581","NULL");
INSERT INTO portuguese_index VALUES ("brusca","NULL","NULL","a#00604516","NULL");
INSERT INTO portuguese_index VALUES ("Microscopia","n#00640889","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("microscopia","n#00640889","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("microscópio_eletrônico","n#00641109 n#03279508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gentil","NULL","NULL","a#00641158 a#00641460 a#01133876 a#01879678","NULL");
INSERT INTO portuguese_index VALUES ("subtrair","NULL","v#00432991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indelicado","NULL","NULL","a#00641640","NULL");
INSERT INTO portuguese_index VALUES ("impolido","NULL","NULL","a#00641640","NULL");
INSERT INTO portuguese_index VALUES ("Projeto_genoma_humano","n#00641693","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Projeto_Genoma_Humano","n#00641693","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("investigação_científica","n#00641820","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("projectos_de_investigação","n#00641820","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descortês","NULL","NULL","a#00641944 a#00642152","NULL");
INSERT INTO portuguese_index VALUES ("malcriado","NULL","NULL","a#00641944","NULL");
INSERT INTO portuguese_index VALUES ("malcomportado","NULL","NULL","a#00641944","NULL");
INSERT INTO portuguese_index VALUES ("mal-educado","NULL","NULL","a#00641944","NULL");
INSERT INTO portuguese_index VALUES ("grosseiro","NULL","NULL","a#00641944 a#00606314 a#01881881 a#01882256 a#01882384","NULL");
INSERT INTO portuguese_index VALUES ("rude","NULL","NULL","a#00641944 a#01881881","NULL");
INSERT INTO portuguese_index VALUES ("Endoscopia","n#00642045","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endoscopia","n#00642045","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("polido","NULL","NULL","a#00606022 a#01005306 a#02161503","NULL");
INSERT INTO portuguese_index VALUES ("educado","NULL","NULL","a#00606022 a#02161503","NULL");
INSERT INTO portuguese_index VALUES ("Colonoscopia","n#00642446","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colonoscopia","n#00642446","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("analisar","NULL","v#00434448 v#00434651 v#00643910 v#00499778","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sigmoidoscopia","n#00643208","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criador","n#06944789 n#09873899","NULL","a#01796235","NULL");
INSERT INTO portuguese_index VALUES ("rinoscopia","n#00643772","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imaginativo","NULL","NULL","a#00607344","NULL");
INSERT INTO portuguese_index VALUES ("decompor","NULL","v#00643910 v#00499778","NULL","NULL");
INSERT INTO portuguese_index VALUES ("analizar_sintaticamente","NULL","v#00643910","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sintetizar","NULL","v#00435117 v#00644430 v#00681575","NULL","NULL");
INSERT INTO portuguese_index VALUES ("analizar","NULL","v#00435242 v#00535831","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acreditável","NULL","NULL","a#00608243","NULL");
INSERT INTO portuguese_index VALUES ("selecção_(processos_físicos)","n#00644967","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incríveis","NULL","NULL","a#00608804","NULL");
INSERT INTO portuguese_index VALUES ("inacreditável","NULL","NULL","a#00608804","NULL");
INSERT INTO portuguese_index VALUES ("inacreditáveis","NULL","NULL","a#00608804","NULL");
INSERT INTO portuguese_index VALUES ("incrível","NULL","NULL","a#00608804 a#02301236","NULL");
INSERT INTO portuguese_index VALUES ("diagnosticar","NULL","v#00645552 v#00645771","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estarrecedor","NULL","NULL","a#00609131","NULL");
INSERT INTO portuguese_index VALUES ("explorar","NULL","v#00436180 v#00436444 v#00437696 v#00438083 v#00594188 v#00790940 v#01163620 v#00791942","NULL","NULL");
INSERT INTO portuguese_index VALUES ("improvável","NULL","NULL","a#00609374 a#01412415 a#01357397 a#01800169","NULL");
INSERT INTO portuguese_index VALUES ("anatomia","n#00646187 n#04055717 n#06057539","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("uranálise","n#00646332","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elementos_anormais_e_sedimentos_(EAS)","n#00646332","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exame_sumário_de_urina","n#00646332","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("urinálise","n#00646332","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escatologia","n#00646504 n#07124928","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Coprologia","n#00646504","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caso_estudo","n#00646680","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("análises_químicas","n#00646833","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("medir","NULL","v#00436897","NULL","NULL");
INSERT INTO portuguese_index VALUES ("céptico","NULL","NULL","a#00610425 a#02345143","NULL");
INSERT INTO portuguese_index VALUES ("cético","n#10604634","NULL","a#00610425 a#02345143","NULL");
INSERT INTO portuguese_index VALUES ("análise_qualitativa","n#00647270","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colorimetria","n#00647536","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crítico","n#09979072 n#07194134 n#07194366","NULL","a#00610721 a#00612746 a#00613646 a#00614865 a#00618913 a#00619212 a#02865172 a#02830645","NULL");
INSERT INTO portuguese_index VALUES ("chicaneiro","NULL","NULL","a#00648089","NULL");
INSERT INTO portuguese_index VALUES ("trapaceiro","n#09998101","NULL","a#00648089","NULL");
INSERT INTO portuguese_index VALUES ("pesquisar","NULL","v#00437696 v#00438083 v#00535682 v#00535831 v#00594188","NULL","NULL");
INSERT INTO portuguese_index VALUES ("buscar","n#00604336","v#00437696 v#00438083 v#00594188 v#00898737 v#00899903 v#01332965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("investigar","NULL","v#00437696 v#00438083 v#00534018 v#00535682 v#00594188","NULL","NULL");
INSERT INTO portuguese_index VALUES ("procurar","n#00604336","v#00437696 v#00848754 v#00898737 v#01317064 v#00899749 v#00899903 v#01474374 v#01533628 v#02240881 v#01725008","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Titulação","n#00423641","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("titulação","n#00423641 n#05038823","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guglar","NULL","v#00648764","NULL","NULL");
INSERT INTO portuguese_index VALUES ("googlar","NULL","v#00648764","NULL","NULL");
INSERT INTO portuguese_index VALUES ("análise_fundamentalista","n#00649090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("re-explorar","NULL","v#00649245","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Análise_Técnica","n#00649266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("análise_técnica","n#00649266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espectroscopia","n#00649482","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diálise","n#00649760 n#00650543","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discriminar","NULL","v#00650016 v#02193765 v#02512305","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diferenciar","NULL","v#00650016 v#00439665","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distinguir","NULL","v#00650016 v#00438616","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hemodialise","n#00650543","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hemodiálise","n#00650543","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grave","NULL","NULL","a#00614072 a#00654166 a#02044251","NULL");
INSERT INTO portuguese_index VALUES ("perigosa","NULL","NULL","a#00614072 a#02059811 a#01983358","NULL");
INSERT INTO portuguese_index VALUES ("Analogia","n#00651176","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("analogia","n#00651176 n#05780339","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adoentado","NULL","NULL","a#00614381 a#01172889","NULL");
INSERT INTO portuguese_index VALUES ("visita_de_inspeção","n#00425999","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vigilância","n#00428474 n#03676672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vigilângia","n#00428474","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("catalogar","NULL","v#00652622 v#01626844","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comparar","NULL","v#00440138 v#02729632","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hemograma_completo","n#00652975","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hemograma","n#00652975","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recenseamento","n#00427077","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("censo","n#00427077","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Censo_demográfico","n#00427077","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contagem_regressiva","n#00653518","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retrocontagem","n#00653518","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("_contagem","n#00653811","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recontagem","n#00653958","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reconsiderar","NULL","v#00654258","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espionagem","n#00654563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Espionagem","n#00654563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("classificar","NULL","v#00441099 v#00442641 v#00443221 v#01029852 v#01710005 v#01798079","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assintência","n#00428745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cuidado","n#00428745 n#00531481 n#01059900 n#00787413","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coroado","NULL","NULL","a#00655136","NULL");
INSERT INTO portuguese_index VALUES ("referir","NULL","v#00655555 v#00494966 v#01329795 v#01825574","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crucial","NULL","NULL","a#00618913 a#01223960 a#01426469","NULL");
INSERT INTO portuguese_index VALUES ("reclassificar","NULL","v#00655792","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dicotomizar","NULL","v#00656107","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fundamental","NULL","NULL","a#00619212 a#00856572 a#01224859 a#01784854 a#02237849","NULL");
INSERT INTO portuguese_index VALUES ("estereotipar","NULL","v#00656292","NULL","NULL");
INSERT INTO portuguese_index VALUES ("primeiros_socorros","n#00656524","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Primeiros_socorros","n#00656524","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agrupar-se","NULL","v#00442337","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agrupar","NULL","v#00442337","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formalizado","NULL","NULL","a#00619729","NULL");
INSERT INTO portuguese_index VALUES ("formalizada","NULL","NULL","a#00619729","NULL");
INSERT INTO portuguese_index VALUES ("tridimensional","NULL","NULL","a#00657198 a#00660809","NULL");
INSERT INTO portuguese_index VALUES ("cúbico","NULL","NULL","a#00657198 a#00657804","NULL");
INSERT INTO portuguese_index VALUES ("categorizar","NULL","v#00657260","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cuidados_médicos","n#00657604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cubóide","NULL","NULL","a#00657804","NULL");
INSERT INTO portuguese_index VALUES ("isométrico","NULL","NULL","a#00658022","NULL");
INSERT INTO portuguese_index VALUES ("ranquiar","NULL","v#00443221","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tratamento","n#00430183 n#01059900 n#00735486 n#03857483","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("unidimensional","NULL","NULL","a#00658259 a#00659715","NULL");
INSERT INTO portuguese_index VALUES ("hospitalização","n#00658627","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("linear","NULL","NULL","a#00658680","NULL");
INSERT INTO portuguese_index VALUES ("rectilíneo","NULL","NULL","a#00658752","NULL");
INSERT INTO portuguese_index VALUES ("bidimensional","NULL","NULL","a#00658942","NULL");
INSERT INTO portuguese_index VALUES ("massagem","n#00659048","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Massagem","n#00659048","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alisado","NULL","NULL","a#00659530","NULL");
INSERT INTO portuguese_index VALUES ("classificar-se","NULL","v#00444338","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reflexoterapia","n#00659946","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("multidimensional","NULL","NULL","a#00660019","NULL");
INSERT INTO portuguese_index VALUES ("posicionar-se","NULL","v#00660102","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dimensional","NULL","NULL","a#00660313 a#02985102","NULL");
INSERT INTO portuguese_index VALUES ("priorizar","NULL","v#00660381","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manicuro","n#00660783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Manicuro","n#00660783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Imagem_3D","NULL","NULL","a#00660809","NULL");
INSERT INTO portuguese_index VALUES ("Imagem_3d","NULL","NULL","a#00660809","NULL");
INSERT INTO portuguese_index VALUES ("Pedicuro","n#00660957","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("valorizar","NULL","v#00445269 v#01605484","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avaliar","NULL","v#00445269 v#00459984 v#00682230 v#00470089 v#00482033 v#01578016 v#01605484","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taxar","NULL","v#00445269 v#00470089 v#00844161 v#01577503","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Terapias","n#00661091","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("terapia","n#00661091 n#03228145","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aferir","NULL","v#00445388","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contrastar","NULL","v#00445388 v#01875649","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conferir","NULL","v#00445764 v#01548251","NULL","NULL");
INSERT INTO portuguese_index VALUES ("checar","NULL","v#00445764","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Furador","NULL","NULL","a#00662139","NULL");
INSERT INTO portuguese_index VALUES ("verificar","NULL","v#00446050 v#00446362 v#00448015 v#01718539","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aromaterapia","n#00662196","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Aromaterapia","n#00662196","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cortado","NULL","NULL","a#00624789 a#00625738","NULL");
INSERT INTO portuguese_index VALUES ("quimioterapia","n#00662340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assegurar","NULL","v#00446362 v#00603511","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autenticar","NULL","v#00664276","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curioso","NULL","NULL","a#00627092 a#00879259 a#00919283 a#01288978","NULL");
INSERT INTO portuguese_index VALUES ("terapia_ocupacional","n#00664577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Terapia_Ocupacional","n#00664577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("validar","NULL","v#00448230 v#00667224","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demonstrar","NULL","v#00448230 v#01471335 v#01470807","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alimentação","n#00664849 n#00684853 n#05625967","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nutrição","n#00664849 n#05625967 n#13523661","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("por","NULL","v#00665476","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deitar","NULL","v#00665476 v#01063016","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delinear","NULL","v#00665476 v#00989084 v#01089750 v#01689379 v#01697628 v#01873293","NULL","NULL");
INSERT INTO portuguese_index VALUES ("provar","NULL","v#00449036 v#00449252 v#01471335 v#00686544 v#00813161 v#01718539 v#02532886 v#01797447","NULL","NULL");
INSERT INTO portuguese_index VALUES ("constatar","NULL","v#00449252","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corroborar","NULL","v#00449252","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atual","NULL","NULL","a#00628521 a#00629037 a#00629488 a#00668208","NULL");
INSERT INTO portuguese_index VALUES ("actual","NULL","NULL","a#00628521 a#00667822 a#00668208 a#00972642","NULL");
INSERT INTO portuguese_index VALUES ("apendicectomia","n#00666232","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amputação","n#00666350 n#14550469","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("angioplastia","n#00666468","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("documentar","NULL","v#00449544 v#00677802","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artrodese","n#00666600","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artroscopia","n#00666884","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contradizer","NULL","v#00666886 v#00823436","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negar","NULL","v#00666886 v#01515455 v#02214190","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dia_de_hoje","NULL","NULL","a#00629488","NULL");
INSERT INTO portuguese_index VALUES ("hodierno","NULL","NULL","a#00629488","NULL");
INSERT INTO portuguese_index VALUES ("psicocirurgia","n#00667384","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmentir","NULL","v#00667747 v#00836705 v#02663141","NULL","NULL");
INSERT INTO portuguese_index VALUES ("refutar","NULL","v#00667747 v#00814850","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_curso","NULL","NULL","a#00667822","NULL");
INSERT INTO portuguese_index VALUES ("ligado","NULL","NULL","a#00667936","NULL");
INSERT INTO portuguese_index VALUES ("em_linha","NULL","NULL","a#00667936","NULL");
INSERT INTO portuguese_index VALUES ("online","NULL","NULL","a#00667936","NULL");
INSERT INTO portuguese_index VALUES ("aguentar","NULL","v#00450535 v#00802946 v#01842330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suportar","NULL","v#00450535 v#00802946 v#00607177","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tolerar","NULL","v#00450535 v#00802946 v#02109404 v#02457585","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aturar","NULL","v#00450535 v#00802946","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cauterização","n#00668112","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("até_a_data","NULL","NULL","a#00668208","NULL");
INSERT INTO portuguese_index VALUES ("vigente","NULL","NULL","a#00668208","NULL");
INSERT INTO portuguese_index VALUES ("mais_recente","NULL","NULL","a#00668366","NULL");
INSERT INTO portuguese_index VALUES ("colostomia","n#00668552","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("craniotomia","n#00668736","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engolir","NULL","v#00450980 v#00683670 v#00737352 v#00817727","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aceitar","NULL","v#00450980 v#00463353 v#00686879 v#00486774 v#00541962 v#01116447 v#01513653 v#01530096 v#01530524 v#01531351","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criocirurgia","n#00668829","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colecistectomia","n#00669000","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obsoleta","NULL","NULL","a#00669021","NULL");
INSERT INTO portuguese_index VALUES ("obsoleto","NULL","NULL","a#00669021 a#00631602 a#00974159","NULL");
INSERT INTO portuguese_index VALUES ("consentir","NULL","v#00451176 v#00764222 v#00541962 v#00546749","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desatualizado","NULL","NULL","a#00631602","NULL");
INSERT INTO portuguese_index VALUES ("antiquado","NULL","NULL","a#00631602 a#00974159 a#00974519","NULL");
INSERT INTO portuguese_index VALUES ("antigo","NULL","NULL","a#00631602 a#01667095 a#01666003","NULL");
INSERT INTO portuguese_index VALUES ("maldita","NULL","NULL","a#00631927","NULL");
INSERT INTO portuguese_index VALUES ("maldito","NULL","NULL","a#00631927 a#00632391 a#01392473 a#01457549","NULL");
INSERT INTO portuguese_index VALUES ("curetagem","n#00669481","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Aborto_por_sucção","n#00669687","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amaldiçoado","NULL","NULL","a#00632302 a#00632391","NULL");
INSERT INTO portuguese_index VALUES ("desbridamento","n#00669932","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("condenado","n#07182455","NULL","a#00632391","NULL");
INSERT INTO portuguese_index VALUES ("julgar","NULL","v#00452184 v#00453431 v#00468967 v#00558050 v#01483324 v#01704695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bendito","NULL","NULL","a#00670741 a#01148764 a#02054075","NULL");
INSERT INTO portuguese_index VALUES ("subestimar","NULL","v#00671335 v#00673766","NULL","NULL");
INSERT INTO portuguese_index VALUES ("operação_cirúrgica","n#00436664","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cirurgia","n#00436664","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cirurgia","n#00436664 n#06063588","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("supervalorizado","NULL","v#00672017","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superestimar","NULL","v#00672017","NULL","NULL");
INSERT INTO portuguese_index VALUES ("super-estimado","NULL","v#00672017","NULL","NULL");
INSERT INTO portuguese_index VALUES ("personalizado","n#01096873","NULL","a#00672226 a#01768252","NULL");
INSERT INTO portuguese_index VALUES ("sob_medida","NULL","NULL","a#00672382","NULL");
INSERT INTO portuguese_index VALUES ("chutar","NULL","v#00453556 v#01370561 v#01371756","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estimar","NULL","v#00453556 v#00673571 v#00459984 v#00682230 v#01247189","NULL","NULL");
INSERT INTO portuguese_index VALUES ("garantido","NULL","NULL","a#00672785","NULL");
INSERT INTO portuguese_index VALUES ("artesanal","NULL","NULL","a#00636519","NULL");
INSERT INTO portuguese_index VALUES ("fazer_pouco","NULL","v#00673766","NULL","NULL");
INSERT INTO portuguese_index VALUES ("menosprezar","NULL","v#00673766 v#00544324 v#01211520 v#01828070","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprovar","NULL","v#00454501 v#00687033 v#00541962 v#00548199 v#00583639 v#00584625 v#01667768 v#01672350","NULL","NULL");
INSERT INTO portuguese_index VALUES ("feito_em_casa","NULL","NULL","a#00674270","NULL");
INSERT INTO portuguese_index VALUES ("caseiro","n#10653388","NULL","a#00674270 a#00987605 a#01039366","NULL");
INSERT INTO portuguese_index VALUES ("desaprovar","NULL","v#00454769 v#00856429","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carimbar","NULL","v#00674517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("selecionar","NULL","v#00455018 v#00456563","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escolher","NULL","v#00455018 v#00456210 v#00456424 v#00456709 v#00457036 v#00458205 v#00679937 v#00723222 v#01172225 v#01635578","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gastrectomia","n#00674760","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Gastrostomia","n#00675064","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gastrostomia","n#00675064","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("posicionar","NULL","v#00675592 v#01354457","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cíclico","NULL","NULL","a#00675701 a#00676555 a#00677545 a#01967803","NULL");
INSERT INTO portuguese_index VALUES ("peneirar","NULL","v#00675768 v#02098827","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coar","NULL","v#00675768 v#01000892","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alternado","NULL","NULL","a#00675928 a#00676093 a#00763767","NULL");
INSERT INTO portuguese_index VALUES ("alterno","NULL","NULL","a#00675928 a#00676093 a#00763767","NULL");
INSERT INTO portuguese_index VALUES ("alternante","NULL","NULL","a#00675928","NULL");
INSERT INTO portuguese_index VALUES ("alternativa","n#04463475","NULL","a#00675928 a#00763767","NULL");
INSERT INTO portuguese_index VALUES ("Hemostasia","n#00676834","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hemostase","n#00676834","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eleger","NULL","v#00456424 v#01172225 v#01635578","NULL","NULL");
INSERT INTO portuguese_index VALUES ("heterocíclico","NULL","NULL","a#00676999","NULL");
INSERT INTO portuguese_index VALUES ("extrair","NULL","v#00456563 v#01351754 v#01266515","NULL","NULL");
INSERT INTO portuguese_index VALUES ("histerectomia","n#00677174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acíclico","NULL","NULL","a#00677313 a#00677877 a#01970604","NULL");
INSERT INTO portuguese_index VALUES ("ciclíco","NULL","NULL","a#00677545","NULL");
INSERT INTO portuguese_index VALUES ("especificar","NULL","v#00457036 v#00484149 v#00641405 v#00641602 v#00691100 v#01780912","NULL","NULL");
INSERT INTO portuguese_index VALUES ("designar","NULL","v#00457036 v#01635578 v#01636187","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dedicar","NULL","v#00677966 v#00601416 v#00601722","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incisão","n#00678010","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anual","NULL","NULL","a#00641153 a#02489110","NULL");
INSERT INTO portuguese_index VALUES ("agendar","NULL","v#00457479 v#00540104","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nocturno","NULL","NULL","a#00641938 a#02705522","NULL");
INSERT INTO portuguese_index VALUES ("noturno","n#07047679","NULL","a#00641938 a#02705522","NULL");
INSERT INTO portuguese_index VALUES ("danificado","NULL","NULL","a#00679147","NULL");
INSERT INTO portuguese_index VALUES ("avariado","NULL","NULL","a#00679147","NULL");
INSERT INTO portuguese_index VALUES ("optar","NULL","v#00458368 v#01635578","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preferir","NULL","v#00458368 v#01246259 v#01635007","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dilapidados","NULL","NULL","a#00679717","NULL");
INSERT INTO portuguese_index VALUES ("malcuidada","NULL","NULL","a#00679717","NULL");
INSERT INTO portuguese_index VALUES ("dilapidadas","NULL","NULL","a#00679717","NULL");
INSERT INTO portuguese_index VALUES ("malcuidado","NULL","NULL","a#00679717","NULL");
INSERT INTO portuguese_index VALUES ("dilapidado","NULL","NULL","a#00679717","NULL");
INSERT INTO portuguese_index VALUES ("dilapidada","NULL","NULL","a#00679717","NULL");
INSERT INTO portuguese_index VALUES ("enrugado","NULL","NULL","a#00680005","NULL");
INSERT INTO portuguese_index VALUES ("quebrado","NULL","NULL","a#00680156","NULL");
INSERT INTO portuguese_index VALUES ("predeterminar","NULL","v#00680346 v#00702773","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vitrectomia","n#00680658","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predispor","NULL","v#00680692","NULL","NULL");
INSERT INTO portuguese_index VALUES ("episiotomia","n#00680914","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ileostomia","n#00681071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indemne","NULL","NULL","a#00681094 a#01319182","NULL");
INSERT INTO portuguese_index VALUES ("indene","NULL","NULL","a#00681094 a#01319182","NULL");
INSERT INTO portuguese_index VALUES ("intato","NULL","NULL","a#00681094","NULL");
INSERT INTO portuguese_index VALUES ("intacto","NULL","NULL","a#00681268","NULL");
INSERT INTO portuguese_index VALUES ("surdo","NULL","NULL","a#00647484 a#01194328 a#02176106","NULL");
INSERT INTO portuguese_index VALUES ("surdo-mudo","NULL","NULL","a#00682168","NULL");
INSERT INTO portuguese_index VALUES ("Lipoaspiração","n#00682243","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Otoplastia","n#00682625","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_ouvido_musical","NULL","NULL","a#00682662","NULL");
INSERT INTO portuguese_index VALUES ("Laminectomia","n#00682738","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avaliar_novamente","NULL","v#00682781","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reavaliar","NULL","v#00682781","NULL","NULL");
INSERT INTO portuguese_index VALUES ("laparotomia","n#00682856","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("censurar","NULL","v#00682928 v#00558872 v#00824066 v#00559552 v#00842772","NULL","NULL");
INSERT INTO portuguese_index VALUES ("laparoscopia","n#00683012","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indecente","NULL","NULL","a#00683185 a#01539022 a#01880918 a#02133207 a#02133779","NULL");
INSERT INTO portuguese_index VALUES ("crer","NULL","v#00460650 v#00684273 v#00464775 v#00721098","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acreditar","n#05014301","v#00460650 v#00684273 v#00721098","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lobotomia","n#00684128","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sugestivo","NULL","NULL","a#00684334 a#01323096 a#01977669 a#02091300","NULL");
INSERT INTO portuguese_index VALUES ("descrer","NULL","v#00684645","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desacreditar","NULL","v#00684645 v#00853195","NULL","NULL");
INSERT INTO portuguese_index VALUES ("determinante","n#06140000","NULL","a#00650020","NULL");
INSERT INTO portuguese_index VALUES ("fatídico","NULL","NULL","a#00650271","NULL");
INSERT INTO portuguese_index VALUES ("rejeitar","NULL","v#00685419 v#00462716 v#00687181 v#00541445 v#00541774 v#02214190 v#01531148","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mastectomia","n#00685508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repudiar","NULL","v#00686039 v#00911917","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nefrectomia","n#00686385","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Nefrectomia","n#00686385","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ooforectomia","n#00686570","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indeciso","NULL","NULL","a#00686573 a#02215139","NULL");
INSERT INTO portuguese_index VALUES ("Pneumonectomia","n#00687135","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Prostatectomia","n#00687252","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_dúvida","NULL","v#00464049","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estar_em_dúvida","NULL","v#00464049","NULL","NULL");
INSERT INTO portuguese_index VALUES ("duvidar","NULL","v#00464049 v#00687523 v#01802820","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Salpingectomia","n#00687365","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alegado","NULL","NULL","a#00652648","NULL");
INSERT INTO portuguese_index VALUES ("anunciado","NULL","NULL","a#00687750","NULL");
INSERT INTO portuguese_index VALUES ("esplenectomia","n#00687769","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Estapedectomia","n#00687857","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desconfiar","NULL","v#00464450","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tiroidectomia","n#00688220","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Miringotomia","n#00688766","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repensar","NULL","v#00688768","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Neurocirurgia","n#00688915","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rinoplastia","n#00689062","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sério","NULL","NULL","a#00654166 a#01226825 a#01840027 a#02043566","NULL");
INSERT INTO portuguese_index VALUES ("parco","NULL","NULL","a#00654166","NULL");
INSERT INTO portuguese_index VALUES ("sisudo","NULL","NULL","a#00654166","NULL");
INSERT INTO portuguese_index VALUES ("Osteotomia","n#00689467","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("OSTEOTOMIA","n#00689467","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Faloplastia","n#00689995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profundo","NULL","NULL","a#00654761 a#01801376","NULL");
INSERT INTO portuguese_index VALUES ("fundo","n#04556371 n#08511970 n#06693004 n#09282363 n#09376526 n#13358549","NULL","a#00654761","NULL");
INSERT INTO portuguese_index VALUES ("sentir-se","NULL","v#00466561","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cirurgia_plástica","n#00690501","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resecção","n#00691050","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rizotomia","n#00691330","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chamar","NULL","v#00691516 v#00753881 v#00536087 v#00538265 v#00696267 v#00697540","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gostar","NULL","v#00691665 v#01212539 v#01776952 v#01213391 v#01238865","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desinteressante","NULL","NULL","a#00691696","NULL");
INSERT INTO portuguese_index VALUES ("raso","n#09433134","NULL","a#00691696","NULL");
INSERT INTO portuguese_index VALUES ("indentificar-se","NULL","v#00691944","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Esterilização","n#00692130","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("favorecer","NULL","v#00467945","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reificar","NULL","v#00692580","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coisificar","NULL","v#00692580","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profunda","NULL","NULL","a#00657242","NULL");
INSERT INTO portuguese_index VALUES ("Experiência_de_Michelson-Morley","n#00693109","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Experiência_de_michelson-morley","n#00693109","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("romantizar","NULL","v#00693172","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superficial","NULL","NULL","a#00657800 a#01802133 a#01803304 a#00658187 a#02607907","NULL");
INSERT INTO portuguese_index VALUES ("traqueostomia","n#00693399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transplantação_de_órgãos","n#00693679","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respeitar","NULL","v#00469237","NULL","NULL");
INSERT INTO portuguese_index VALUES ("venerar","NULL","v#00469237 v#01778568","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prezar","NULL","v#00469237","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desrespeitar","NULL","v#00694641 v#02457825","NULL","NULL");
INSERT INTO portuguese_index VALUES ("justiça","n#00736721 n#00694866 n#04826235 n#04839154 n#03801117 n#04850341 n#08135342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Justiça","n#00736721 n#08135342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ministração","n#00694990","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aplicação","n#00694990 n#00607299 n#00729616 n#06570110","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vitorioso","NULL","NULL","a#00695209 a#00704898 a#02333314","NULL");
INSERT INTO portuguese_index VALUES ("triunfante","NULL","NULL","a#00695209 a#00704898 a#02333314","NULL");
INSERT INTO portuguese_index VALUES ("sedação","n#00695300","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invito","NULL","NULL","a#00695335","NULL");
INSERT INTO portuguese_index VALUES ("supervalorizar","NULL","v#00695475","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desafiador","NULL","NULL","a#00695523 a#00711113","NULL");
INSERT INTO portuguese_index VALUES ("Lavagem_Vaginal","n#00695717","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lavagem_vaginal","n#00695717","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clister","n#00695944","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enema","n#00695944","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reexaminar","NULL","v#00470717","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rever","NULL","v#00470717 v#00696414 v#00696852 v#00673530 v#01657018","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relutante","NULL","NULL","a#00696335 a#00811969","NULL");
INSERT INTO portuguese_index VALUES ("complacente","NULL","NULL","a#00696518","NULL");
INSERT INTO portuguese_index VALUES ("submisso","NULL","NULL","a#00696518","NULL");
INSERT INTO portuguese_index VALUES ("vistoriar","NULL","v#00696700 v#01259471 v#01482454","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curativo","n#00696882","NULL","a#01118744","NULL");
INSERT INTO portuguese_index VALUES ("Flebotomia","n#00698004","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Toracotomia","n#00698348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flebotomia","n#00698609","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfibrilação","n#00698959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Desintoxicação","n#00699146","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desintoxicação","n#00699146 n#00699320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("primário","n#06221291","NULL","a#00665079 a#01781200","NULL");
INSERT INTO portuguese_index VALUES ("propor-se","NULL","v#00472976","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cura_pela_fé","n#00699736","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("determinar","NULL","v#00473111 v#00473721 v#00622132 v#01840766","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fisioterapia","n#00700000","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fisioterapia","n#00700000","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formatar","NULL","v#00700336","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fitoterapia","n#00700421","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fitoterapia","n#00700421","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cobrar","NULL","v#00700517 v#01585711 v#02320903","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Psicoterapia","n#00449352","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("psicoterapia","n#00449352 n#04630512","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("se_moldar","NULL","v#00474001","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decidido","NULL","NULL","a#00701178","NULL");
INSERT INTO portuguese_index VALUES ("resoluto","NULL","NULL","a#00701178","NULL");
INSERT INTO portuguese_index VALUES ("evidente","NULL","NULL","a#00667628 a#01234186 a#01560095 a#01560359","NULL");
INSERT INTO portuguese_index VALUES ("Terapia_de_aversão","n#00701491","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reformar","NULL","v#00474461 v#01660870","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inundações","n#00702418","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predestinar","NULL","v#00703310","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cogitar","NULL","v#00703512 v#00476424 v#00734348","NULL","NULL");
INSERT INTO portuguese_index VALUES ("meditar","NULL","v#00703512 v#00476424","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deprimido","NULL","NULL","a#00669950 a#01155404 a#01230153 a#02281938 a#02413221","NULL");
INSERT INTO portuguese_index VALUES ("trevas","n#10073287 n#10418027","NULL","a#00669950","NULL");
INSERT INTO portuguese_index VALUES ("terapia_em_grupo","n#00703688","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hipnoterapia","n#00704064","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Hipnoterapia","n#00704064","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remoer","NULL","v#00704249","NULL","NULL");
INSERT INTO portuguese_index VALUES ("psicanálise","n#00451738","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ponderar","NULL","v#00476424 v#00729378 v#00625900","NULL","NULL");
INSERT INTO portuguese_index VALUES ("planejar","NULL","v#00704690 v#00705227 v#01638368","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triunfador","NULL","NULL","a#00704898","NULL");
INSERT INTO portuguese_index VALUES ("exultante","NULL","NULL","a#00704898","NULL");
INSERT INTO portuguese_index VALUES ("jubiloso","NULL","NULL","a#00704898 a#01367211","NULL");
INSERT INTO portuguese_index VALUES ("aspirar","NULL","v#00477282","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Radioterapia","n#00705580","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sublime","NULL","NULL","a#00705616 a#01074523 a#02353726 a#02056566","NULL");
INSERT INTO portuguese_index VALUES ("Eletroconvulsoterapia","n#00706605","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletroconvulsoterapia","n#00706605","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletrochoque","n#00706605","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frágil","NULL","NULL","a#00706688 a#00674840","NULL");
INSERT INTO portuguese_index VALUES ("conspirar","NULL","v#00706975 v#00707624","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conjurar","NULL","v#00706975","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intrigar","NULL","v#00707956 v#01827903","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Quiropraxia","n#00707967","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maquinar","NULL","v#00708128","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Medicina_natural","n#00708332","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quebradiça","NULL","NULL","a#00708498","NULL");
INSERT INTO portuguese_index VALUES ("pretender","NULL","v#00479160 v#00479584 v#01246466","NULL","NULL");
INSERT INTO portuguese_index VALUES ("propor","NULL","v#00479584 v#00592804 v#00876332 v#00594839 v#00596010 v#00596144 v#01175810 v#01632536 v#01636187 v#01861884","NULL","NULL");
INSERT INTO portuguese_index VALUES ("osteopatia","n#00709205","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desejar","NULL","v#00479841 v#00612000 v#01188485 v#01124810 v#01824339 v#01824532 v#01244897 v#01245362 v#01245981 v#01246175 v#01246466 v#01247460","NULL","NULL");
INSERT INTO portuguese_index VALUES ("querer","NULL","v#00479841 v#01188485 v#01824339 v#01824532 v#01244897 v#01245362 v#01825962 v#01245981 v#01246466","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quebradiço","NULL","NULL","a#00674840","NULL");
INSERT INTO portuguese_index VALUES ("delicado","NULL","NULL","a#00674840","NULL");
INSERT INTO portuguese_index VALUES ("destinar","NULL","v#00479979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desinfecção","n#00709521","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cloragem","n#00709659 n#13448622","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inquebrável","NULL","NULL","a#00709744","NULL");
INSERT INTO portuguese_index VALUES ("orquestrar","NULL","v#00480481 v#01707737","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anticoagulação","n#00710015","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Acupuntura","n#00710155","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acupuntura","n#00710155","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Treinamento_Autógeno","n#00710550","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("treinamento_autógeno","n#00710550","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mapear","NULL","v#00710606","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homeopatia","n#00710889","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estrito","NULL","NULL","a#00676443 a#00868874","NULL");
INSERT INTO portuguese_index VALUES ("rigoroso","NULL","NULL","a#00676443 a#00868874 a#01248007 a#02288133","NULL");
INSERT INTO portuguese_index VALUES ("hidroterapia","n#00711127","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("projetar","NULL","v#00711550 v#01125984 v#01464668","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entreter","NULL","v#00711715 v#01698431 v#01698559","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fricção","n#00456982 n#07800619","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("orçar","NULL","v#00482033 v#00723851 v#00724029","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prognosticar","NULL","v#00482033 v#00591090 v#00621460 v#00626821","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prever","NULL","v#00482033 v#00720808 v#00591090 v#00621460 v#00626821 v#00659397 v#01124126","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predizer","NULL","v#00482033 v#00591090 v#00621460 v#00626821 v#00926702","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revestimento","n#00457130 n#04489410","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depender","NULL","v#00712708 v#02663848 v#02664017 v#01817306 v#01852531","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Unção","n#00712833","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("urgente","NULL","NULL","a#00678141 a#00713558","NULL");
INSERT INTO portuguese_index VALUES ("Fumigação","n#00712979","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fumigação","n#00712979","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("folheação","n#00713135","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("associar","NULL","v#00482838 v#00740053","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conectar","NULL","v#00482838 v#01069391 v#00877947","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relacionar","NULL","v#00482838 v#02458103 v#01825574 v#02724417","NULL","NULL");
INSERT INTO portuguese_index VALUES ("galvanização","n#00713250 n#01262109 n#13485968","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suplicante","NULL","NULL","a#00713995","NULL");
INSERT INTO portuguese_index VALUES ("correlacionar","NULL","v#00713996","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luxação","n#00714173","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desassociar","NULL","v#00714273","NULL","NULL");
INSERT INTO portuguese_index VALUES ("importuno","NULL","NULL","a#00714320","NULL");
INSERT INTO portuguese_index VALUES ("debater","NULL","v#00714884 v#00525378 v#00552181","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artesanato","n#00714944 n#03485655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parlamentar","n#09955781 n#10400309","NULL","a#00680955 a#00681181 a#02590962","NULL");
INSERT INTO portuguese_index VALUES ("decretar","NULL","v#00484458 v#00695426","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vasectomia","n#00716179","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vasovasostomia","n#00716520","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vulvectomia","n#00716676","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("postular","NULL","v#00716758","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vivisecção","n#00716777","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vivissecção","n#00716777","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("da_república","NULL","NULL","a#00681981","NULL");
INSERT INTO portuguese_index VALUES ("republicano","NULL","NULL","a#00681981 a#02598312","NULL");
INSERT INTO portuguese_index VALUES ("lubrificação","n#00716945","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assertar","NULL","v#00717045","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insistir","NULL","v#00717045 v#00777931 v#00556026","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pintura","n#00717208","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autocrático","NULL","NULL","a#00717684","NULL");
INSERT INTO portuguese_index VALUES ("ditatorial","NULL","NULL","a#00717684 a#00787357 a#02712678","NULL");
INSERT INTO portuguese_index VALUES ("despótico","NULL","NULL","a#00718137","NULL");
INSERT INTO portuguese_index VALUES ("Folha-de-flandres","n#00718195","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("totalitário","NULL","NULL","a#00718635 a#02818111","NULL");
INSERT INTO portuguese_index VALUES ("discrionário","NULL","NULL","a#00718924","NULL");
INSERT INTO portuguese_index VALUES ("arbitrária","NULL","NULL","a#00718924","NULL");
INSERT INTO portuguese_index VALUES ("arbitrário","NULL","NULL","a#00718924","NULL");
INSERT INTO portuguese_index VALUES ("obrigação","n#00461585 n#00523477 n#05074715 n#09665083 n#14490110 n#10395239","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atender","NULL","v#00487007 v#01486353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incumbência","n#00461778 n#01131425","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antecipar","NULL","v#00487133 v#00720808","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demonstrativo","NULL","NULL","a#00684959 a#01323962 a#02356048","NULL");
INSERT INTO portuguese_index VALUES ("aguardar_ansiosamente","NULL","v#00720497","NULL","NULL");
INSERT INTO portuguese_index VALUES ("papel","n#00462318 n#04552661 n#04731024 n#04731186 n#10744736 n#15074962 n#15093938","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antever","NULL","v#00720808 v#01124126","NULL","NULL");
INSERT INTO portuguese_index VALUES ("que_se_pode_negar","NULL","NULL","a#00721157","NULL");
INSERT INTO portuguese_index VALUES ("negável","NULL","NULL","a#00721157","NULL");
INSERT INTO portuguese_index VALUES ("que_não_se_pode_negar","NULL","NULL","a#00685949","NULL");
INSERT INTO portuguese_index VALUES ("inegável","NULL","NULL","a#00685949","NULL");
INSERT INTO portuguese_index VALUES ("incontestável","NULL","NULL","a#00721636 a#00686264","NULL");
INSERT INTO portuguese_index VALUES ("Papel_social","n#00722061","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("denotativo","NULL","NULL","a#00722110","NULL");
INSERT INTO portuguese_index VALUES ("centrar","NULL","v#00489333 v#01825948","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Papel_Social_de_Gênero","n#00722253","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Papel_social_de_gênero","n#00722253","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fascinar","NULL","v#00722675 v#00725046 v#01232387 v#01242449","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interessar","NULL","v#00722675 v#01242774 v#01827745","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arremessador","n#00722984","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conotativa","NULL","NULL","a#00723163","NULL");
INSERT INTO portuguese_index VALUES ("conotativo","NULL","NULL","a#00723163","NULL");
INSERT INTO portuguese_index VALUES ("receptor","n#00723241 n#03217746 n#07143863","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("terlugar","NULL","v#00723349","NULL","NULL");
INSERT INTO portuguese_index VALUES ("levar_em_conta","NULL","v#00490373","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_orçamento","NULL","v#00724029","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_confiança","NULL","NULL","a#00724081","NULL");
INSERT INTO portuguese_index VALUES ("fiável","NULL","NULL","a#00724081 a#02346141 a#02465519","NULL");
INSERT INTO portuguese_index VALUES ("fidedigno","NULL","NULL","a#00724081 a#01997748","NULL");
INSERT INTO portuguese_index VALUES ("confiável","NULL","NULL","a#00724081 a#02346141 a#02465519","NULL");
INSERT INTO portuguese_index VALUES ("digno_de_confiança","NULL","NULL","a#00724081 a#02273326 a#02163862 a#02465519","NULL");
INSERT INTO portuguese_index VALUES ("reservar","NULL","v#00490924 v#01702479","NULL","NULL");
INSERT INTO portuguese_index VALUES ("procurado","NULL","NULL","a#00724596","NULL");
INSERT INTO portuguese_index VALUES ("precaver","NULL","v#00724664","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precaver-se","NULL","v#00724664","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estontear","NULL","v#00491471","NULL","NULL");
INSERT INTO portuguese_index VALUES ("admirar","NULL","v#00491471 v#01247189 v#01481912","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espantar","NULL","v#00491471","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assombrar","NULL","v#00491471 v#00491581 v#01217847","NULL","NULL");
INSERT INTO portuguese_index VALUES ("surpreender","NULL","v#00491471 v#00491581 v#00492198 v#01234366 v#01771348","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_confiável","NULL","NULL","a#00724861","NULL");
INSERT INTO portuguese_index VALUES ("deslumbrar","NULL","v#00725046","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impressionar","NULL","v#00725046 v#00493735 v#01206630 v#01207643 v#01770252","NULL","NULL");
INSERT INTO portuguese_index VALUES ("errático","NULL","NULL","a#00725227","NULL");
INSERT INTO portuguese_index VALUES ("sobressaltar","NULL","v#00491581","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atacante","n#00725383 n#09821253","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("zagueiro","n#00725775 n#07095815","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beque","n#00725775 n#07095815","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imputar","NULL","v#00492345","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atribuir","NULL","v#00492345 v#00726784 v#00493321 v#00740053 v#01524852","NULL","NULL");
INSERT INTO portuguese_index VALUES ("linebacker","n#00726369","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interdependente","NULL","NULL","a#00726445","NULL");
INSERT INTO portuguese_index VALUES ("quarterback","n#00726567","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parasita","n#10252674","NULL","a#00726723","NULL");
INSERT INTO portuguese_index VALUES ("cofidente","NULL","NULL","a#00727113","NULL");
INSERT INTO portuguese_index VALUES ("simbiôntico","NULL","NULL","a#00727268","NULL");
INSERT INTO portuguese_index VALUES ("antropomorfizar","NULL","v#00727409","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_menor","NULL","NULL","a#00691625","NULL");
INSERT INTO portuguese_index VALUES ("center","n#00727500","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("personificar","NULL","v#00727573 v#01723690 v#01840295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guard","n#00727743","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("culpar","NULL","v#00727991 v#00842772","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autônomo","NULL","NULL","a#00692511 a#00822609 a#01009075 a#02401440","NULL");
INSERT INTO portuguese_index VALUES ("trabalho_escolar","n#00728641 n#00729108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comutativa","NULL","NULL","a#00728826","NULL");
INSERT INTO portuguese_index VALUES ("comutativo","NULL","NULL","a#00728826","NULL");
INSERT INTO portuguese_index VALUES ("compenetrar","NULL","v#00494146","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprofundar","NULL","v#00494146","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compenetrar-se","NULL","v#00494146","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penetrar","NULL","v#00494146 v#00836413 v#01229071 v#01769693 v#01993031 v#02018524 v#02019011","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lição_de_casa","n#00729108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dever_de_casa","n#00729108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tarefa_de_casa","n#00729108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("traçar","NULL","v#00729109 v#01089750 v#01159988","NULL","NULL");
INSERT INTO portuguese_index VALUES ("seguir","NULL","v#00729109 v#00781491 v#01357963 v#01360914 v#01363279 v#01367094 v#01383938 v#01758181 v#02600255 v#01797749 v#01859779","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lição","n#00469204 n#00571937 n#04955371 n#05003239","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interrogar","NULL","v#00729378 v#00533379 v#00535464","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perguntar-se","NULL","v#00729378","NULL","NULL");
INSERT INTO portuguese_index VALUES ("questionar","NULL","v#00729378 v#00533379 v#00535464 v#00608227 v#00625900","NULL","NULL");
INSERT INTO portuguese_index VALUES ("auto-suficiente","NULL","NULL","a#00729439","NULL");
INSERT INTO portuguese_index VALUES ("exercício","n#00469856 n#00574902 n#10917007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mencionar","NULL","v#00494966 v#00689564 v#01023574 v#00692561 v#00717396","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demarcar","NULL","v#00495195","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vigia","n#00730538 n#03986562","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guarda","n#00730538 n#00880662 n#06010550 n#08215801 n#06945104 n#10150071 n#07380622 n#07485319 n#07675146","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("missão","n#00470944 n#00471060 n#00623965 n#06213619 n#06214058","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tendencioso","NULL","NULL","a#00730985 a#00695128","NULL");
INSERT INTO portuguese_index VALUES ("capitalizar","NULL","v#00731000 v#02279772 v#02330742","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recado","n#00471384","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aliado","n#06165226 n#07070950","NULL","a#00731955 a#02476485","NULL");
INSERT INTO portuguese_index VALUES ("neutro","NULL","NULL","a#00732160 a#01424959","NULL");
INSERT INTO portuguese_index VALUES ("neutral","NULL","NULL","a#00732160 a#01818992","NULL");
INSERT INTO portuguese_index VALUES ("prestar","NULL","v#00732224 v#01588837","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descritivo","NULL","NULL","a#00697470 a#00732682","NULL");
INSERT INTO portuguese_index VALUES ("resignar-se","NULL","v#00732394","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resignar","NULL","v#00732394 v#01612615 v#02379198 v#01623278","NULL","NULL");
INSERT INTO portuguese_index VALUES ("normativo","NULL","NULL","a#02187633 a#02757372","NULL");
INSERT INTO portuguese_index VALUES ("observar","NULL","v#00732552 v#01449939 v#01450271 v#02130160 v#01457770 v#01485469 v#01673353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controlar","NULL","v#00732552 v#00834531 v#01230482 v#01481005 v#01664310 v#01711244","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transgressão","n#00472071 n#00745005","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delito","n#00472071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desejável","NULL","NULL","a#00698075 a#00812035","NULL");
INSERT INTO portuguese_index VALUES ("fatorar","NULL","v#00733250","NULL","NULL");
INSERT INTO portuguese_index VALUES ("violação","n#00472484 n#00491673 n#00770543","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invasão","n#00472484 n#00627831 n#00628646 n#00977132 n#05527236","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invejável","NULL","NULL","a#00733541","NULL");
INSERT INTO portuguese_index VALUES ("preferível","NULL","NULL","a#00733743","NULL");
INSERT INTO portuguese_index VALUES ("acreditar_em","NULL","v#00733895","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destruído","NULL","NULL","a#00734318 a#01392646","NULL");
INSERT INTO portuguese_index VALUES ("pensar_sobre","NULL","v#00734348","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pensar_em","NULL","v#00734348","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abstrair","NULL","v#00734587","NULL","NULL");
INSERT INTO portuguese_index VALUES ("plantar","NULL","v#00734790 v#00656388 v#01030643 v#01079342 v#01191107","NULL","NULL");
INSERT INTO portuguese_index VALUES ("implantar","NULL","v#00734790 v#01528821","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estragado","NULL","NULL","a#00734906","NULL");
INSERT INTO portuguese_index VALUES ("enguiçado","NULL","NULL","a#00701326","NULL");
INSERT INTO portuguese_index VALUES ("mau_comportamento","n#00474548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Delinquência_juvenil","n#00736219","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Delinqüência_juvenil","n#00736219","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ruim","NULL","NULL","a#00736299 a#01078381 a#01083652 a#01084323","NULL");
INSERT INTO portuguese_index VALUES ("esfarrapado","NULL","NULL","a#00736671 a#02434210 a#02582697","NULL");
INSERT INTO portuguese_index VALUES ("recriar","NULL","v#00736799 v#01113585","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Anormalidade","n#00475542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anormalidade","n#00475542 n#03764247 n#04367023 n#10403506 n#14505667","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irregularidade","n#00475542 n#03745305 n#03954192","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sociologia_do_desvio","n#00475699","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Comportamento_divergente","n#00475699","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conservado","NULL","NULL","a#00737432","NULL");
INSERT INTO portuguese_index VALUES ("capturar","NULL","v#00737476 v#00733757 v#00825349 v#00826212 v#00827658 v#01084280 v#01575110 v#01575585","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protegido","n#10485989","NULL","a#00737703 a#01812371","NULL");
INSERT INTO portuguese_index VALUES ("parafilia","n#00737705","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Parafilia","n#00737705","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mantido","NULL","NULL","a#00737801","NULL");
INSERT INTO portuguese_index VALUES ("exibicionismo","n#00737894 n#06889701","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destrutível","NULL","NULL","a#00737973","NULL");
INSERT INTO portuguese_index VALUES ("fetiche","n#00738058 n#01207342 n#03603958","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pedofilia","n#00738270 n#10412669","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indestrutível","NULL","NULL","a#00738368","NULL");
INSERT INTO portuguese_index VALUES ("voyeurismo","n#00738372","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("determinável","NULL","NULL","a#00738593","NULL");
INSERT INTO portuguese_index VALUES ("zoofilia","n#00738598 n#00858060","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("zoossexualidade","n#00738598 n#00858060","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obscenidade","n#00738697 n#04903678 n#05331114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("averiguável","NULL","NULL","a#00738829","NULL");
INSERT INTO portuguese_index VALUES ("constatável","NULL","NULL","a#00738829","NULL");
INSERT INTO portuguese_index VALUES ("verificável","NULL","NULL","a#00738829","NULL");
INSERT INTO portuguese_index VALUES ("imprevisível","NULL","NULL","a#00739789 a#01842001","NULL");
INSERT INTO portuguese_index VALUES ("inváriavel","NULL","NULL","a#00705447","NULL");
INSERT INTO portuguese_index VALUES ("comunicar","NULL","v#00502333 v#00591857","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transmitir","NULL","v#00502333 v#00503459 v#00503786 v#00628262 v#00655894 v#00658752 v#00719161 v#00982468 v#00983791 v#01422262 v#01424107 v#01527254 v#01568149 v#01570315","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evasão_fiscal","n#00741797","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prevaricação","n#00741925","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desperdício","n#00742645 n#04894964","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rudimentar","NULL","NULL","a#00742714 a#01784703","NULL");
INSERT INTO portuguese_index VALUES ("contactar","NULL","v#00743344","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entrar_em_contato","NULL","v#00743344","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manter_contato_com","NULL","v#00743344","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estar_em_contato_com","NULL","v#00743344","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_contato_com","NULL","v#00743344","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contatar","NULL","v#00743344","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adiabático","n#13427481","NULL","a#00744141","NULL");
INSERT INTO portuguese_index VALUES ("diferenciado","NULL","NULL","a#00744277 a#02277829","NULL");
INSERT INTO portuguese_index VALUES ("injustiça","n#00479886 n#03804255","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intrincado","NULL","NULL","a#00797776 a#02091753 a#02178500","NULL");
INSERT INTO portuguese_index VALUES ("foda","n#00543107","NULL","a#00797776","NULL");
INSERT INTO portuguese_index VALUES ("difícil","NULL","NULL","a#00797776 a#00711482 a#00748795","NULL");
INSERT INTO portuguese_index VALUES ("árduo","NULL","NULL","a#00797776 a#01648301","NULL");
INSERT INTO portuguese_index VALUES ("abominação","n#00745431 n#05577676 n#05577810 n#05577970 n#07547805","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pedir","NULL","v#00505537 v#00752493 v#00510998 v#00753428 v#00753734 v#00531494 v#00540576 v#01018065 v#01553614 v#01611740 v#01702479","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imoralidade","n#00745637 n#00481262","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maldade","n#00745637 n#00480585 n#04842313 n#03802516 n#03844003 n#04007415 n#04007891 n#07550369 n#07550666 n#10442294","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("laborioso","NULL","NULL","a#00711113 a#00719289","NULL");
INSERT INTO portuguese_index VALUES ("complicado","NULL","NULL","a#00711113 a#02093020","NULL");
INSERT INTO portuguese_index VALUES ("arduo","NULL","NULL","a#00745858 a#00797350 a#00837977","NULL");
INSERT INTO portuguese_index VALUES ("irreverência","n#00480876 n#06207733","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frustrante","NULL","NULL","a#00711868","NULL");
INSERT INTO portuguese_index VALUES ("sacrilégio","n#00746587","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Profanação","n#00746587","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("blasfêmia","n#00746587 n#07124172","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profanação","n#00746587 n#05333774","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("blasfémia","n#00746587 n#07124172","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impetrar","NULL","v#00506398","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mandar","NULL","v#00506398 v#00698219","NULL","NULL");
INSERT INTO portuguese_index VALUES ("complicada","NULL","NULL","a#00746819","NULL");
INSERT INTO portuguese_index VALUES ("cócegozo","NULL","NULL","a#00712274","NULL");
INSERT INTO portuguese_index VALUES ("sensitivo","n#10488309","NULL","a#00712274","NULL");
INSERT INTO portuguese_index VALUES ("receitar","NULL","v#00506658","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prescrever","NULL","v#00506658","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comandar","NULL","v#00506658 v#01662020","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pornografia","n#00747215","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pornografia","n#00747215","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filme_pornô","n#00747215","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pornô","n#00747215","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pornografia_infantil","n#00747519","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prostituição","n#00482009","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("devassidão","n#00748307","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dissolução","n#00748307","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bebida","n#00482267 n#00540820 n#00540981 n#05908749 n#05910601 n#05911542 n#09270508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espinhoso","NULL","NULL","a#00748674","NULL");
INSERT INTO portuguese_index VALUES ("cheio_de_espinhos","NULL","NULL","a#00748674","NULL");
INSERT INTO portuguese_index VALUES ("problemático","NULL","NULL","a#00748795 a#01846685","NULL");
INSERT INTO portuguese_index VALUES ("controvertido","NULL","NULL","a#00749040","NULL");
INSERT INTO portuguese_index VALUES ("Pub_crawl","n#00749105","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desonestidade","n#00749574 n#04874672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("traição","n#00482966 n#00500041 n#03822672 n#04879879 n#04879964 n#10027590","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("charlatanismo","n#00750306","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pirataria","n#00750405","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("plágio","n#00750405 n#07277158","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pirata","n#00750405 n#10435367","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indolor","NULL","NULL","a#00750712 a#01713095","NULL");
INSERT INTO portuguese_index VALUES ("simplificado","NULL","NULL","a#00750843","NULL");
INSERT INTO portuguese_index VALUES ("falsificação","n#00751145 n#00768921 n#03562126 n#03562262","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("plantígrados","NULL","NULL","a#00751353","NULL");
INSERT INTO portuguese_index VALUES ("digno","NULL","NULL","a#00716336 a#02513269 a#02461416 a#02462532","NULL");
INSERT INTO portuguese_index VALUES ("dar_ordem","NULL","v#00510062","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mentira","n#00484777 n#03820287 n#05062653 n#05063005 n#05063177 n#13960464","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distinto","NULL","NULL","a#00752110 a#01225735 a#01989737 a#02036455","NULL");
INSERT INTO portuguese_index VALUES ("dissimulação","n#00752431","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enganação","n#00752431","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("degradante","NULL","NULL","a#00752555 a#01228050 a#01611490","NULL");
INSERT INTO portuguese_index VALUES ("exigir","NULL","v#00510998 v#00512630 v#00687967","NULL","NULL");
INSERT INTO portuguese_index VALUES ("solicitar","NULL","v#00510998 v#00721528","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rogar","NULL","v#00510998 v#00753428 v#00515892 v#00516106 v#00516262 v#00531494","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ridículo","NULL","NULL","a#00717534 a#01214625","NULL");
INSERT INTO portuguese_index VALUES ("astúcia","n#00485559 n#05621178 n#04353391","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("presidencial","NULL","NULL","a#00753504 a#02747901","NULL");
INSERT INTO portuguese_index VALUES ("hoax","n#00485959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fraude","n#00485959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diligente","NULL","NULL","a#00754107 a#00719289 a#00841997 a#01736122","NULL");
INSERT INTO portuguese_index VALUES ("pilantragem","n#00754280","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assíduo","NULL","NULL","a#00719072 a#00719289","NULL");
INSERT INTO portuguese_index VALUES ("requisitar","NULL","v#00512256","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aplicado","NULL","NULL","a#00719289 a#02876509","NULL");
INSERT INTO portuguese_index VALUES ("operoso","NULL","NULL","a#00719289","NULL");
INSERT INTO portuguese_index VALUES ("esforçado","NULL","NULL","a#00719289","NULL");
INSERT INTO portuguese_index VALUES ("trabalhador","n#06957738 n#07240707 n#07360164 n#07505214 n#07687635","NULL","a#00719289","NULL");
INSERT INTO portuguese_index VALUES ("delírio","n#00486766 n#10323024 n#10326963","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desatencioso","NULL","NULL","a#00754873","NULL");
INSERT INTO portuguese_index VALUES ("sem_cuidado","NULL","NULL","a#00754873","NULL");
INSERT INTO portuguese_index VALUES ("demandar","NULL","v#00512630","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aparência","n#00487065 n#03683012 n#04674715 n#03686135 n#03686637 n#03687137 n#03687267 n#03687456 n#04561534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lasso","NULL","NULL","a#02214365 a#02403671 a#02405160","NULL");
INSERT INTO portuguese_index VALUES ("finja","n#00755500","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fingimento","n#00755673 n#05063809","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ação_de_fingir","n#00755673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ação_de_afectar","n#00755673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afetação","n#00755673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("requerer","NULL","v#00513425 v#00721528 v#00808096","NULL","NULL");
INSERT INTO portuguese_index VALUES ("postura","n#00487495 n#03965003 n#05082507 n#04697893","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("custar","NULL","v#00756076 v#01793319 v#01843641","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diluído","NULL","NULL","a#00756091","NULL");
INSERT INTO portuguese_index VALUES ("mascarada","n#00756194","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aquoso","NULL","NULL","a#00720832 a#02153394 a#02429238 a#02499433 a#02636582","NULL");
INSERT INTO portuguese_index VALUES ("Obscurantismo","n#00756470","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caimento","n#00756919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decadência","n#00756919 n#09730726 n#10360885 n#14440875 n#10440704","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pecado","n#00488251 n#03784496","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saturado","NULL","NULL","a#00757236","NULL");
INSERT INTO portuguese_index VALUES ("pecado_original","n#00757483","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("renunciar","NULL","v#00514894 v#00798717 v#01523865 v#01574799 v#01612615 v#02379198 v#01623278","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pecado_capital","n#00757730","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apostatar","NULL","v#00757856","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abnegar","NULL","v#00515285","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afirmar","NULL","v#00515522 v#00684295 v#00686932 v#00687837 v#00689221","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inveja","n#00489418 n#05612539","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diplomático","NULL","NULL","a#00722597 a#02557914","NULL");
INSERT INTO portuguese_index VALUES ("avarícia","n#00758525","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avidez","n#00758525","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ganância","n#00758525 n#04945530 n#04945758","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cobiça","n#00758525 n#04945530","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avareza","n#00758525 n#04945530 n#04945758","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preguiça","n#00758795 n#02456962 n#04637108 n#04637444","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ira","n#00489929 n#05587878 n#05588413 n#10110870","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sete_pecados_capitais","n#00489929 n#00490089","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cólera","n#00489929 n#05587878 n#05588413 n#10163886","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gula","n#00490089 n#04886101 n#04945530","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pedir_esmolas","NULL","v#00515892","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suplicar","NULL","v#00515892 v#00516106 v#00516262 v#00531494","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luxúria","n#00759335 n#07489714","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insensível","NULL","NULL","a#00759458 a#02032175","NULL");
INSERT INTO portuguese_index VALUES ("terrorismo","n#00759500 n#00490349","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("implorar","NULL","v#00516262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Terrorismo","n#00490349","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rezar","NULL","v#00516449","NULL","NULL");
INSERT INTO portuguese_index VALUES ("orar","NULL","v#00516449 v#00828901","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pacífico","NULL","NULL","a#01679348 a#01678209 a#01679594 a#02392836","NULL");
INSERT INTO portuguese_index VALUES ("comungar","NULL","v#00760187 v#01172838","NULL","NULL");
INSERT INTO portuguese_index VALUES ("advogar","NULL","v#00760576","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pleitear","NULL","v#00760576","NULL","NULL");
INSERT INTO portuguese_index VALUES ("professar","NULL","v#00760735 v#00828901","NULL","NULL");
INSERT INTO portuguese_index VALUES ("directo","NULL","NULL","a#00724516","NULL");
INSERT INTO portuguese_index VALUES ("interceder","NULL","v#00517401","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mediar","NULL","v#00517401","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concertar","NULL","v#00517621","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agenciar","NULL","v#00517734","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negociar","NULL","v#00517734","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indireto","NULL","NULL","a#00726016 a#00729725 a#00733920 a#01854546","NULL");
INSERT INTO portuguese_index VALUES ("Bioterrorismo","n#00763132","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bioterrorismo","n#00763132","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ecoterrorismo","n#00764031","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concordar","NULL","v#00518879 v#00764222 v#00541962 v#00546534 v#00547364","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apaziguar","NULL","v#00519450 v#01204852","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impelir","NULL","v#00519742 v#00524434 v#01133626","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aguçado","NULL","NULL","a#00765862","NULL");
INSERT INTO portuguese_index VALUES ("pontudo","NULL","NULL","a#00765862 a#01809655 a#01811352","NULL");
INSERT INTO portuguese_index VALUES ("honesto","NULL","NULL","a#00729544 a#01222360 a#02180157","NULL");
INSERT INTO portuguese_index VALUES ("crime","n#00490590 n#00767477 n#00491673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("persuadir","NULL","v#00766418 v#00521816 v#00522671 v#00527377 v#01762892","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convencer","NULL","v#00766418 v#00522671 v#00527377 v#01762892","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Criminalidade_por_país","n#00767477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crimes","n#00767477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vender","NULL","v#00521283 v#01535023 v#01536410","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assalto","n#00767826 n#00494444 n#00774009 n#00781685 n#00499935 n#00500852","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adular","NULL","v#00768778 v#00880518","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rapto","n#00769944 n#00775460 n#00775702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("roubar","n#00769944","v#01104624 v#00987154 v#01556315 v#02292432 v#01586504 v#01586816 v#02322230 v#01600942 v#01601331 v#01753347","NULL","NULL");
INSERT INTO portuguese_index VALUES ("roubo","n#00769944 n#00499179 n#00781685 n#00966599 n#00966869 n#09543577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retrógrado","NULL","NULL","a#00770114","NULL");
INSERT INTO portuguese_index VALUES ("dissuadir","NULL","v#00770141 v#01819147","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infração","n#00492547","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infracção","n#00492547","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pirataria_moderna","n#00770834","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encorajar","NULL","v#00523848 v#01806407 v#01240173 v#01240452 v#01818835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instigar","NULL","v#00524434 v#01230365 v#01738093 v#01741432","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incitar","NULL","v#00524434 v#00531787 v#00539509 v#00838665 v#01131307 v#01133626 v#01200852 v#01738093 v#01761948","NULL","NULL");
INSERT INTO portuguese_index VALUES ("argumentar","NULL","v#00524590","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perjúrio","n#00772381","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obtuso","NULL","NULL","a#00772492 a#01811905 a#02169359","NULL");
INSERT INTO portuguese_index VALUES ("apresentar","NULL","v#00525080 v#00596010 v#00610889 v#00693379 v#01174962 v#01462865 v#01464775 v#01579272 v#01617687 v#02425112","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indiscreto","NULL","NULL","a#00773109","NULL");
INSERT INTO portuguese_index VALUES ("imprudente","NULL","NULL","a#00773109 a#00773455 a#01826937","NULL");
INSERT INTO portuguese_index VALUES ("cometimento","n#00493986","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estupro","n#00494087 n#00846961","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discutir","NULL","v#00525378 v#00553000 v#00638965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atentado","n#00494444","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beijar-se","NULL","v#00525851","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bicar_reciprocamente","NULL","v#00525851","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Abuso_sexual","n#00774107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Abuso_Sexual","n#00774107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discriminatório","NULL","NULL","a#00737499","NULL");
INSERT INTO portuguese_index VALUES ("porfiar","NULL","v#00774344 v#00526635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bigamia","n#00775095 n#13964466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disputar","NULL","v#00526635 v#01094086","NULL","NULL");
INSERT INTO portuguese_index VALUES ("altercar","NULL","v#00526635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("querelar","NULL","v#00526635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indispor-se","NULL","v#00526635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discriminativo","NULL","NULL","a#00775301","NULL");
INSERT INTO portuguese_index VALUES ("seqüestro","n#00775460 n#00775702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eclético","NULL","NULL","a#00775486","NULL");
INSERT INTO portuguese_index VALUES ("selectivo","NULL","NULL","a#00738936 a#01863246","NULL");
INSERT INTO portuguese_index VALUES ("seletivo","NULL","NULL","a#00738936 a#01863246","NULL");
INSERT INTO portuguese_index VALUES ("Sequestros","n#00775702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Seqüestro","n#00775702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("opor-se","NULL","v#00775831","NULL","NULL");
INSERT INTO portuguese_index VALUES ("opor","NULL","v#00776059","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indiscriminado","NULL","NULL","a#00776090","NULL");
INSERT INTO portuguese_index VALUES ("suborno","n#00776262 n#13284562","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descartável","n#03212003","NULL","a#00776570 a#00777418","NULL");
INSERT INTO portuguese_index VALUES ("Apropriação_indébita","n#00776732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("peculato","n#00776732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enfeitiçar","NULL","v#00776988 v#00528182","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encantar","NULL","v#00776988 v#00528182 v#01232387 v#01238865 v#01239874 v#01242449 v#01247684 v#01763119","NULL","NULL");
INSERT INTO portuguese_index VALUES ("roubo_da_identidade","n#00777069","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Falsidade_ideológica","n#00777069","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falsidade_ideológica","n#00777069","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("utilizável","NULL","NULL","a#00740788 a#02049113 a#02496674","NULL");
INSERT INTO portuguese_index VALUES ("usável","NULL","NULL","a#00740788 a#02049113 a#02496674","NULL");
INSERT INTO portuguese_index VALUES ("líquido","n#10387643 n#10720281","NULL","a#00741101 a#01525937 a#02152669","NULL");
INSERT INTO portuguese_index VALUES ("distal","NULL","NULL","a#00778363 a#00778680","NULL");
INSERT INTO portuguese_index VALUES ("pausar","NULL","v#00779061","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sagital","NULL","NULL","a#00779240","NULL");
INSERT INTO portuguese_index VALUES ("Sagital","NULL","NULL","a#00779240","NULL");
INSERT INTO portuguese_index VALUES ("inconfundível","NULL","NULL","a#00742364","NULL");
INSERT INTO portuguese_index VALUES ("intrometer","NULL","v#00530210","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intrometer-se","NULL","v#00530210","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divagar","NULL","v#00780575","NULL","NULL");
INSERT INTO portuguese_index VALUES ("furto","n#00499179 n#00966869","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indistinto","NULL","NULL","a#00744086","NULL");
INSERT INTO portuguese_index VALUES ("abordar","NULL","v#00531339","NULL","NULL");
INSERT INTO portuguese_index VALUES ("latrocínio","n#00499935","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Crimes_de_guerra","n#00782518","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crime_de_guerra","n#00782518","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engodar","NULL","v#00531787 v#02577755","NULL","NULL");
INSERT INTO portuguese_index VALUES ("seduzir","NULL","v#00531787 v#00783246 v#00979094 v#01233160 v#02577755","NULL","NULL");
INSERT INTO portuguese_index VALUES ("induzir_em_tentação","NULL","v#00531787","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desencaminhar","NULL","v#00531787 v#00783246","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pirataria","n#00783527","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("monolítico","NULL","NULL","a#00746926","NULL");
INSERT INTO portuguese_index VALUES ("perguntar","n#05376578","v#00532796 v#00533091 v#00533379 v#00535464 v#00867409 v#00608227 v#00625900","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extorsão","n#00784388 n#01061726","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divisível","NULL","NULL","a#00784533 a#00785406","NULL");
INSERT INTO portuguese_index VALUES ("chantagem","n#00784598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tributo","n#00784755 n#01122387 n#05020724 n#09580808","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bisbilhotar","NULL","v#00784874","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fofocar","NULL","v#00784874 v#01041954","NULL","NULL");
INSERT INTO portuguese_index VALUES ("xeretar","NULL","v#00784874","NULL","NULL");
INSERT INTO portuguese_index VALUES ("separável","NULL","NULL","a#00785002","NULL");
INSERT INTO portuguese_index VALUES ("espiar","NULL","v#00533715 v#00533881","NULL","NULL");
INSERT INTO portuguese_index VALUES ("joint_venture","n#00785596","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Investimento_estrangeiro_direto","n#00785818","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tentativa","n#00503375 n#00503611 n#00786887 n#00787061 n#00787218 n#00508046 n#00503108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inseparável","NULL","NULL","a#00748891","NULL");
INSERT INTO portuguese_index VALUES ("dominador","NULL","NULL","a#00749952","NULL");
INSERT INTO portuguese_index VALUES ("ensaio","n#00787218 n#00794614 n#00576606 n#04469208 n#04830849","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incursão","n#00787307","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autoritário","NULL","NULL","a#00787357","NULL");
INSERT INTO portuguese_index VALUES ("catequizar","NULL","v#00787359","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contribuição","n#00504440 n#09548864 n#09549012","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mandão","NULL","NULL","a#00787595","NULL");
INSERT INTO portuguese_index VALUES ("re-examinar","NULL","v#00788971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("duelo","n#00506044 n#00760027","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("telefonar","NULL","v#00536087","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ligar","NULL","v#00536087 v#00877947 v#00927388 v#00927971 v#01789530","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Oferta_Pública_de_Aquisição","n#00789906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Oferta_pública_de_aquisição","n#00789906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("servil","NULL","NULL","a#00790086 a#00790540 a#01066226","NULL");
INSERT INTO portuguese_index VALUES ("discar","NULL","v#00536527","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subserviente","NULL","NULL","a#00790691 a#02330064","NULL");
INSERT INTO portuguese_index VALUES ("Co-dominância","NULL","NULL","a#00753744","NULL");
INSERT INTO portuguese_index VALUES ("Codominância","NULL","NULL","a#00753744","NULL");
INSERT INTO portuguese_index VALUES ("dominante","n#06858266","NULL","a#00753744 a#00756320","NULL");
INSERT INTO portuguese_index VALUES ("ensaios","n#00791527","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ELISA","n#00791875","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imunohistoquímica","n#00792142","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preeminente","NULL","NULL","a#00754691","NULL");
INSERT INTO portuguese_index VALUES ("o_mais_alto_na_escala","NULL","NULL","a#00754691","NULL");
INSERT INTO portuguese_index VALUES ("preponderante","NULL","NULL","a#00754691","NULL");
INSERT INTO portuguese_index VALUES ("primordial","NULL","NULL","a#00754691 a#02231896","NULL");
INSERT INTO portuguese_index VALUES ("Ensaio_clínico","n#00792356","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("soberano","NULL","NULL","a#00755040 a#01009075","NULL");
INSERT INTO portuguese_index VALUES ("supremo","NULL","NULL","a#00755040 a#01523410","NULL");
INSERT INTO portuguese_index VALUES ("subordinada","NULL","NULL","a#00792991","NULL");
INSERT INTO portuguese_index VALUES ("subordinado","NULL","NULL","a#00792991 a#02244428","NULL");
INSERT INTO portuguese_index VALUES ("adjunto","n#07087094","NULL","a#00793250","NULL");
INSERT INTO portuguese_index VALUES ("auxiliar","n#09780249","v#02000133 v#01643863 v#01737017","a#00793250 a#01782889 a#02244428","NULL");
INSERT INTO portuguese_index VALUES ("convidar","NULL","v#00539240 v#01007880 v#01233051 v#01624484","NULL","NULL");
INSERT INTO portuguese_index VALUES ("secundário","n#09312645","NULL","a#00756119 a#01413476 a#01782330 a#01786141 a#02244428","NULL");
INSERT INTO portuguese_index VALUES ("provocar","NULL","v#00539509 v#00577163 v#00838665 v#00986409 v#01111638 v#01128460 v#01130277 v#01133437 v#01799148 v#01200852 v#01202849 v#01221988 v#01224189 v#01230365 v#01583087 v#01741432 v#01761948","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concitar","NULL","v#00539509 v#01200852","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desafiar","NULL","v#00539509 v#00868097 v#00868591","NULL","NULL");
INSERT INTO portuguese_index VALUES ("audição","n#00794614 n#04374245","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dramático","NULL","NULL","a#00757276 a#01231198 a#01408283","NULL");
INSERT INTO portuguese_index VALUES ("planificar","NULL","v#00540104","NULL","NULL");
INSERT INTO portuguese_index VALUES ("programar","NULL","v#00540104 v#00540315 v#01193948","NULL","NULL");
INSERT INTO portuguese_index VALUES ("melodramático","NULL","NULL","a#00795078","NULL");
INSERT INTO portuguese_index VALUES ("espetacular","NULL","NULL","a#00757679 a#01231198","NULL");
INSERT INTO portuguese_index VALUES ("projectos-piloto","n#00795352","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("projeto","n#00508925 n#00594989 n#04528166 n#04533598 n#04536390 n#04541674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proibir","NULL","v#00540739 v#00796392 v#00541183 v#02214190 v#02493666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proscrever","NULL","v#00540739 v#02480923","NULL","NULL");
INSERT INTO portuguese_index VALUES ("teatral","NULL","NULL","a#00758388 a#02813315","NULL");
INSERT INTO portuguese_index VALUES ("aventura","n#00509169 n#01117164","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excluir","NULL","v#00541183 v#01793672","NULL","NULL");
INSERT INTO portuguese_index VALUES ("barrar","NULL","v#00541183 v#01127075 v#01476483","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desprezar","NULL","v#00541445 v#01211520","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recusar","NULL","v#00541445 v#00541774 v#02214190 v#01531148 v#02755017","NULL","NULL");
INSERT INTO portuguese_index VALUES ("potável","NULL","NULL","a#00797113","NULL");
INSERT INTO portuguese_index VALUES ("bêbedo","NULL","NULL","a#00759599","NULL");
INSERT INTO portuguese_index VALUES ("bêbada","NULL","NULL","a#00759599","NULL");
INSERT INTO portuguese_index VALUES ("embriagado","NULL","NULL","a#00759599 a#00920260","NULL");
INSERT INTO portuguese_index VALUES ("ébrio","NULL","NULL","a#00759599 a#00920260","NULL");
INSERT INTO portuguese_index VALUES ("bêbado","n#09782167 n#07230168","NULL","a#00759599 a#00920260","NULL");
INSERT INTO portuguese_index VALUES ("maratona","n#00797361 n#07460546","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("orgíaco","NULL","NULL","a#00797706 a#02134162","NULL");
INSERT INTO portuguese_index VALUES ("empreendimento_de_risco","n#00797878","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Espeleologia","n#00798108","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espeleologia","n#00798108 n#06121554","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("campanha","n#00509919 n#00621581 n#05556394 n#06727012","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ligeiramente_embriagado","NULL","NULL","a#00798384","NULL");
INSERT INTO portuguese_index VALUES ("tocado","NULL","NULL","a#00798384","NULL");
INSERT INTO portuguese_index VALUES ("abjurar","NULL","v#00798717","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pedrado","NULL","NULL","a#00798879","NULL");
INSERT INTO portuguese_index VALUES ("drogado","n#07229072","NULL","a#00798879","NULL");
INSERT INTO portuguese_index VALUES ("campanha_publicitária","n#00798959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Campanha_Publicitária","n#00798959","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("devolver","NULL","v#00799076 v#01367732 v#01422854","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decorrer","NULL","v#00799383","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grogue","n#07904865","NULL","a#00799401","NULL");
INSERT INTO portuguese_index VALUES ("consumismo","n#00799409","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Campanha_eleitoral","n#00511429","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("candidatura","n#00511429","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rescindir","NULL","v#00543473","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cassar","NULL","v#00543473","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revogar","NULL","v#00543473 v#02427334 v#02477334 v#01688749 v#02478584","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cancelar","NULL","v#00543473 v#01066739 v#02477334 v#02477655 v#02477755 v#01688749","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descumprir","NULL","v#00800242","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cego","NULL","NULL","a#00761969 a#02076031 a#02160135","NULL");
INSERT INTO portuguese_index VALUES ("Feminismo","n#00800421","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("feminismo","n#00800421 n#05967773","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desafiado","NULL","NULL","a#00800464","NULL");
INSERT INTO portuguese_index VALUES ("desmarcar","NULL","v#00544143","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deixar_de_lado","NULL","v#00544324","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desconsiderar","NULL","v#00544324 v#00717937 v#01450453","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descartar","NULL","v#00544324 v#01520955","NULL","NULL");
INSERT INTO portuguese_index VALUES ("absolver","NULL","v#00544745 v#00612323","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dispersar","NULL","v#00544745 v#01386521 v#01387651","NULL","NULL");
INSERT INTO portuguese_index VALUES ("debochar","NULL","v#00544883","NULL","NULL");
INSERT INTO portuguese_index VALUES ("auto-ajuda","n#00802111","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afiado","NULL","NULL","a#00802179","NULL");
INSERT INTO portuguese_index VALUES ("risco","n#00512734 n#03689511 n#04080923 n#06338089 n#10427605 n#10428324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perigo","n#00512734 n#00802629 n#10427326 n#10427605 n#10428324 n#14543552","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("permitir","NULL","v#00545347 v#00545978 v#01543501 v#02255715 v#01649126 v#02671279 v#02745486","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agüentar","NULL","v#00802946","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forte","n#02716224","NULL","a#00764129 a#01112066 a#01141075 a#01142322 a#01451021 a#02210262","NULL");
INSERT INTO portuguese_index VALUES ("autorizar","NULL","v#00545978 v#02447370","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salgado","NULL","NULL","a#00803846 a#01020992 a#01021767 a#02283993","NULL");
INSERT INTO portuguese_index VALUES ("assentir","NULL","v#00546534 v#00898210","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dizer_sim","NULL","v#00546534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("responder_que_sim","NULL","v#00546534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aquiescer","NULL","v#00546534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curvar-se_ao_peso_de","NULL","v#00546749","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ceder","NULL","v#00546749 v#01526289 v#01529125 v#01582922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sucumbir","NULL","v#00546749 v#01582922 v#02620466","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dissentir","NULL","v#00546908","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discordar","NULL","v#00546908 v#02718543","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vívido","NULL","NULL","a#00765788 a#01314056","NULL");
INSERT INTO portuguese_index VALUES ("controlo_de_cheias","n#00804708","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imperialismo","n#00514713 n#04711992 n#04994987","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regulação","n#00514820 n#00999787","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regulamentos","n#00514820 n#04501800 n#04908212","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desregulamentação","n#00805337","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Desregulamentação","n#00805337","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desregulação","n#00805337","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indexação","n#00805868 n#01013156","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conceder","NULL","v#00547843 v#01543325 v#01543501 v#01548251 v#01548440 v#01568959 v#01578132 v#01582922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subscrever","NULL","v#00548039 v#00673751","NULL","NULL");
INSERT INTO portuguese_index VALUES ("garantia_de_qualidade","n#00806484","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controle_de_qualidade","n#00806484","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controlo_de_qualidade","n#00806484","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sancionar","NULL","v#00548199","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deferir","NULL","v#00548199","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dessecado","NULL","NULL","a#00806991 a#01020064 a#02552849","NULL");
INSERT INTO portuguese_index VALUES ("coordenação","n#00515970 n#04363056 n#09938510","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("objectar","NULL","v#00807461","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sincronização","n#00807500 n#01001097 n#13845239","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_vitalidade","NULL","NULL","a#00808011","NULL");
INSERT INTO portuguese_index VALUES ("sem_brilho","NULL","NULL","a#00808011","NULL");
INSERT INTO portuguese_index VALUES ("restrição","n#00516738 n#00744571 n#01149621 n#03234268 n#04502083 n#06247701 n#10084797","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limitação","n#00516738 n#00742557 n#03234268 n#03992325 n#04021804 n#04021969 n#04502083 n#10084797 n#10935522","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_constante_mudança","NULL","NULL","a#00808822","NULL");
INSERT INTO portuguese_index VALUES ("que_muda_constantemente","NULL","NULL","a#00808822","NULL");
INSERT INTO portuguese_index VALUES ("marcado_pela_mudança_constante","NULL","NULL","a#00808822","NULL");
INSERT INTO portuguese_index VALUES ("entrevistar","NULL","v#00549731 v#00550052","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cinético","NULL","NULL","a#00809164 a#01563349 a#02893827","NULL");
INSERT INTO portuguese_index VALUES ("possessão","n#00517391 n#09525525 n#09528888 n#09533920","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("varrer_a_sua_testada","NULL","v#00550404","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evadir","NULL","v#00550404","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esquivar","NULL","v#00550404","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evitar","NULL","v#00550404 v#00551242 v#00551826 v#01419809 v#01669882 v#01670590 v#01671583 v#01671878 v#01678404 v#02599004 v#02726164","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Posse","n#00809702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("propulsores","NULL","NULL","a#00809790","NULL");
INSERT INTO portuguese_index VALUES ("autopropelido","NULL","NULL","a#00810164 a#01562488","NULL");
INSERT INTO portuguese_index VALUES ("semovente","NULL","NULL","a#00810164 a#01562488","NULL");
INSERT INTO portuguese_index VALUES ("fuxicar","NULL","v#00810385","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chicanear","NULL","v#00810385","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aperrear","NULL","v#00810385","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atazanar","NULL","v#00810385","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retenção","n#00810598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contornar","NULL","v#00551045 v#01848681 v#01689752","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ansiosa","NULL","NULL","a#00772140","NULL");
INSERT INTO portuguese_index VALUES ("ansioso","NULL","NULL","a#00772140 a#02337269","NULL");
INSERT INTO portuguese_index VALUES ("armazenagem","n#00811355","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impaciente","NULL","NULL","a#00811536 a#01674134","NULL");
INSERT INTO portuguese_index VALUES ("contrafeito","NULL","NULL","a#00811969 a#01293882 a#02566453","NULL");
INSERT INTO portuguese_index VALUES ("renegar","NULL","v#00551826","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tropa_de_Choque","n#00812154","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tropa_de_choque","n#00812154","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enfrentar","NULL","v#00551957","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deliberar","NULL","v#00552181 v#00552303","NULL","NULL");
INSERT INTO portuguese_index VALUES ("temporão","NULL","NULL","a#00773513 a#00778288 a#01588864","NULL");
INSERT INTO portuguese_index VALUES ("precoce","NULL","NULL","a#00773513 a#01768163","NULL");
INSERT INTO portuguese_index VALUES ("de_antemão","NULL","NULL","a#00813915","NULL");
INSERT INTO portuguese_index VALUES ("praguejar","NULL","v#00814458","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maldizer","NULL","v#00814458","NULL","NULL");
INSERT INTO portuguese_index VALUES ("blasfemar","NULL","v#00814458","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nítrico","NULL","NULL","a#00814468","NULL");
INSERT INTO portuguese_index VALUES ("o_mais_cedo","NULL","NULL","a#00814611","NULL");
INSERT INTO portuguese_index VALUES ("tosquiadeira","n#00814665","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("governo","n#00520891 n#00728919 n#06000383","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("orientação","n#00521002 n#00681366 n#04705763 n#09960026","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("visar","n#00815644","v#00998182","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retrucar","NULL","v#00554194","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pilotagem","n#00521429","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mirim","NULL","NULL","a#00815849","NULL");
INSERT INTO portuguese_index VALUES ("mediano","NULL","NULL","a#00776394","NULL");
INSERT INTO portuguese_index VALUES ("tardio","NULL","NULL","a#00776933 a#00780206 a#00781480 a#01841295 a#01829998","NULL");
INSERT INTO portuguese_index VALUES ("Navegação_astronômica","n#00816530","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Navegação_astronómica","n#00816530","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("póstumo","NULL","NULL","a#00817242","NULL");
INSERT INTO portuguese_index VALUES ("confessar","NULL","v#00555115 v#00817909 v#00555732 v#00818805 v#00556340 v#00819923","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Navegação_estimada","n#00817394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proteção","n#00522858 n#00611021 n#01213886","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protecção","n#00522858 n#04192858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("primitiva","NULL","NULL","a#00779258","NULL");
INSERT INTO portuguese_index VALUES ("responsabilidade","n#00523477 n#00731811 n#03679828 n#04669828 n#10395239 n#10411732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incipiente","NULL","NULL","a#00779846","NULL");
INSERT INTO portuguese_index VALUES ("preservação","n#00819024","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conservação","n#00819024 n#00524093 n#05521821","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conservação_(processo_industrial)","n#00524093","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Conservação_da_natureza","n#00524093","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conservação_do_solo","n#00819641","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conservação_da_água","n#00819858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reserva","n#00524765 n#00790310 n#08462205 n#06332265","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("médio","NULL","NULL","a#00781222 a#01786937 a#01594146","NULL");
INSERT INTO portuguese_index VALUES ("declarar","NULL","v#00557342 v#00558050 v#00594839 v#00654101 v#00683308 v#00686932","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manifestar","NULL","v#01471335 v#01470807","NULL","NULL");
INSERT INTO portuguese_index VALUES ("certificar","NULL","v#01471335","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dizer","NULL","v#01471335 v#00594839 v#00628548 v#00638109 v#00955472 v#00652168 v#00662493 v#00662608 v#00979870 v#00663647 v#00682542","NULL","NULL");
INSERT INTO portuguese_index VALUES ("honorário","NULL","NULL","a#00821959","NULL");
INSERT INTO portuguese_index VALUES ("desassossegado","NULL","NULL","a#00783094","NULL");
INSERT INTO portuguese_index VALUES ("preocupado","NULL","NULL","a#00783553 a#02338153","NULL");
INSERT INTO portuguese_index VALUES ("beatificar","NULL","v#00822912","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precaução","n#00527379 n#03676318 n#04349454","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("canonizar","NULL","v#00823129","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precário","NULL","NULL","a#00783825 a#01757483 a#02095037 a#02181387","NULL");
INSERT INTO portuguese_index VALUES ("oriental","NULL","NULL","a#00784074 a#00784535 a#00784668 a#00786285 a#00786532","NULL");
INSERT INTO portuguese_index VALUES ("desdizer","NULL","v#00823436","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repreender","NULL","v#00558872 v#00824066 v#00559552 v#00560318 v#00826201 v#00842772","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criticar","NULL","v#00558872 v#00560756 v#01096097","NULL","NULL");
INSERT INTO portuguese_index VALUES ("defesa","n#00527713 n#00611021","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escudo","n#00527713 n#03296478 n#03342262 n#03316835 n#04192858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vacinação","n#00823884 n#14364306","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reprovar","NULL","v#00824066 v#00559552 v#01720528 v#02599528","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ocidental","NULL","NULL","a#00785018 a#00785346 a#00785555 a#00786092","NULL");
INSERT INTO portuguese_index VALUES ("repreensão","n#05003120 n#06714420 n#07246036","v#00559552","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incriminar","NULL","v#00559552 v#00572217 v#00571723 v#02636921","NULL","NULL");
INSERT INTO portuguese_index VALUES ("condenar","NULL","v#00559552 v#00581023 v#00586096 v#00613686 v#00613914 v#01471095","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aikido","n#00825331","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artes_marciais","n#00825443","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("judô","n#00825773","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jiu-jítsu","n#00825951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jiu-jitsu","n#00825951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deplorar","NULL","v#00826333","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caratê","n#00826397","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tae_kown_do","n#00826681","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taekwondo","n#00826681","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taekwon-do","n#00826681","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tai_chi","n#00826789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("t'ai_chi_chuan","n#00826789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tai_chi_chuan","n#00826789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taichi","n#00826789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taichichuan","n#00826789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("t'ai_chi","n#00826789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insulação","n#00529661","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("isolamento","n#00529661 n#00778860 n#10343201 n#14415518","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predicar","NULL","v#00561647","NULL","NULL");
INSERT INTO portuguese_index VALUES ("advocar","NULL","v#00561647","NULL","NULL");
INSERT INTO portuguese_index VALUES ("argumentar_a_favor","NULL","v#00561647","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pregar","NULL","v#00561647 v#00929765 v#01530273","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_sermão","NULL","v#00561791","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pontificar","NULL","v#00828754","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comestível","NULL","NULL","a#00828779","NULL");
INSERT INTO portuguese_index VALUES ("imunização","n#00828990","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tutela","n#00531481","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tóxico","n#15032376","NULL","a#00790359 a#01552949 a#02329506","NULL");
INSERT INTO portuguese_index VALUES ("instruído","NULL","NULL","a#00790754 a#02005587","NULL");
INSERT INTO portuguese_index VALUES ("douto","NULL","NULL","a#00790754","NULL");
INSERT INTO portuguese_index VALUES ("sábio","NULL","NULL","a#00790754 a#02005587 a#02445888","NULL");
INSERT INTO portuguese_index VALUES ("erudito","n#07549738","NULL","a#00790754 a#02083615","NULL");
INSERT INTO portuguese_index VALUES ("vedações","n#00830099","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vedação","n#00830099","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impermeabilizante","n#00830099","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("educar","NULL","v#00562981 v#01626476 v#02387910 v#01626835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("uso","n#00532309 n#00605730","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semiletrado","NULL","NULL","a#00830630","NULL");
INSERT INTO portuguese_index VALUES ("palestrar","NULL","v#00563537","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falar","NULL","v#00563537 v#00634807 v#00638109 v#00638965 v#00944788 v#00651246 v#00652168 v#00662608 v#00682542 v#00699711 v#01034312","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respiração","n#00532749 n#00831191 n#00831782 n#00835032 n#00836537 n#10646827","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ignorante","n#10198958","NULL","a#00830981","NULL");
INSERT INTO portuguese_index VALUES ("iletrado","NULL","NULL","a#00830981","NULL");
INSERT INTO portuguese_index VALUES ("analfabeto","n#09790047 n#10199103","NULL","a#00830981 a#01421679","NULL");
INSERT INTO portuguese_index VALUES ("advertir","NULL","v#00563742 v#00832907 v#00589833 v#00590070 v#00590217 v#00590442 v#00591857","NULL","NULL");
INSERT INTO portuguese_index VALUES ("informar","NULL","v#00564266 v#00833199 v#00591857 v#00874175 v#00644776","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cardiografia","n#00832092","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletrocardiografia","n#00832092","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletrocardiograma","n#00832092 n#07004057","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ecocardiografia","n#00832306","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respiração_boca-a-boca","n#00832626","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reanimação_Cardiorrespiratória","n#00832626","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reanimação_cardiorrespiratória","n#00832626","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("notificar","NULL","v#00832778 v#00833199 v#00591857 v#00874175 v#00965390","NULL","NULL");
INSERT INTO portuguese_index VALUES ("operativo","NULL","NULL","a#00833018 a#03150985","NULL");
INSERT INTO portuguese_index VALUES ("Manobra_de_heimlich","n#00833119","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Manobra_de_Heimlich","n#00833119","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Eupneia","n#00833491","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Eupnéia","n#00833491","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eupnéia","n#00833491","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hipopnéia","n#00833772","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hiperventilação","n#00833870","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enganar","NULL","v#00834009 v#00579423 v#01755765","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mentir","NULL","v#00565685 v#00835294 v#00835506","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Respiração_de_Cheyne-Stokes","n#00834290","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Respiração_de_cheyne-stokes","n#00834290","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acto_de_fumar","n#00834636","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tabagismo","n#00834636","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perjurar","NULL","v#00834745","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expiração","n#00835267 n#05465037 n#15268682","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impressionante","NULL","NULL","a#00795989 a#01229098 a#01229558 a#01229969 a#01231198","NULL");
INSERT INTO portuguese_index VALUES ("embromar","NULL","v#00835506","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pare_de_enrolar","NULL","v#00835506","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tergiversar","NULL","v#00835506","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inútil","NULL","NULL","a#00796147 a#02377697 a#02378162 a#02502163","NULL");
INSERT INTO portuguese_index VALUES ("vão","NULL","NULL","a#00796147 a#01795599 a#02377697 a#02378162 a#02383606","NULL");
INSERT INTO portuguese_index VALUES ("ronco","n#00835976","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("simbolizar","NULL","v#00566766","NULL","NULL");
INSERT INTO portuguese_index VALUES ("representar","NULL","v#00566766 v#00668411 v#01157275 v#01158733 v#01177316 v#01177668 v#01723690 v#01732942 v#01733234 v#01759792 v#01787769 v#01840295 v#01840890 v#01862875 v#01876322","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respiração_ruidosa","n#00836407","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respiração_difícil","n#00836407","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penoso","NULL","NULL","a#00797350","NULL");
INSERT INTO portuguese_index VALUES ("Inspiração","n#00536863","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inalação","n#00536863","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inspiração","n#00536863 n#04467595 n#04492995","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ofego","n#00837098","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esgotador","NULL","NULL","a#00837249","NULL");
INSERT INTO portuguese_index VALUES ("fatigante","NULL","NULL","a#00837249","NULL");
INSERT INTO portuguese_index VALUES ("bocejo","n#00837293","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fingir","NULL","v#00568049 v#01721556 v#01178910 v#02519494","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ingestão","n#00537659","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Alimentação","n#00537892","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer-se_de_morto","NULL","v#00838995","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fingir-se_de_morto","NULL","v#00838995","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coprofagia","n#00839163","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("choque_elétrico","n#00538490 n#14291823","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("choque","n#00538490 n#01172252 n#05468143","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flato","n#00538647","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("peido","n#00538647 n#14035695","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flatulência","n#00538647 n#07090573 n#14035695","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gás","n#00538647 n#10388113 n#10671811","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deglutição","n#00839778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exagerar","NULL","v#00569024 v#01751567","NULL","NULL");
INSERT INTO portuguese_index VALUES ("econômico","NULL","NULL","a#00800491 a#01800273 a#02303421 a#02559635 a#02559751","NULL");
INSERT INTO portuguese_index VALUES ("económico","NULL","NULL","a#00800491 a#01800273 a#02303421 a#02559635 a#02559751","NULL");
INSERT INTO portuguese_index VALUES ("banquete","n#00840751 n#05538738 n#07449862 n#07578093 n#08253640","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("re-enfatizar","NULL","v#00840809","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Geofagia","n#00840898","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("geofagia","n#00840898","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ineficiente","NULL","NULL","a#00840902","NULL");
INSERT INTO portuguese_index VALUES ("paste","n#00539647","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anti-econômico","NULL","NULL","a#00841159","NULL");
INSERT INTO portuguese_index VALUES ("denunciar","NULL","v#00570314 v#01709703","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delatar","NULL","v#00570314","NULL","NULL");
INSERT INTO portuguese_index VALUES ("degustação","n#00841901","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("drástico","NULL","NULL","a#00841934","NULL");
INSERT INTO portuguese_index VALUES ("mordidela","n#00842197","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mordiscar","n#00842281","v#00798513 v#01446569","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sugue","n#00842692","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impetuoso","NULL","NULL","a#00842704","NULL");
INSERT INTO portuguese_index VALUES ("acusar","NULL","v#00842772 v#00572217 v#00571723","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_força","NULL","NULL","a#00842914","NULL");
INSERT INTO portuguese_index VALUES ("arguir","NULL","v#00572217","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criminar","NULL","v#00572217","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inculpar","NULL","v#00572217","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elástico","n#03259308","NULL","a#00843146 a#00803840 a#00975648","NULL");
INSERT INTO portuguese_index VALUES ("gole","n#00541182 n#03230670","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bondage","n#00843681","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sexo_seguro","n#00844048","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tributar","NULL","v#00844161","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transa","n#00541686 n#05566729","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sexo","n#00541686 n#00543107 n#03910916 n#04271545 n#05566729 n#05991993","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flexível","NULL","NULL","a#00844719 a#00969783 a#00971706 a#00973925 a#00975648 a#02289057","NULL");
INSERT INTO portuguese_index VALUES ("concepção","n#00542207 n#04357520 n#04493671 n#04533598 n#05461527","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("injuriar","NULL","v#00845299 v#01221816","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insultar","NULL","v#00845299 v#00573247 v#00575170 v#00586673 v#00587063 v#01221816","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inseminação_artificial","n#00845352","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Relação_sexual_humana","n#00845523","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relação_sexual","n#00845523","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coito","n#00845523 n#00543107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cópula","n#00845523 n#00543107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("metida","n#00543107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trepada","n#00543107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eleito","NULL","NULL","a#00846052 a#01294857","NULL");
INSERT INTO portuguese_index VALUES ("eleitoral","NULL","NULL","a#00806210 a#02560387","NULL");
INSERT INTO portuguese_index VALUES ("difamar","NULL","v#00846509","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caluniar","NULL","v#00846509","NULL","NULL");
INSERT INTO portuguese_index VALUES ("denegrir","NULL","v#00846509 v#00847870 v#00864475","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assignat","NULL","NULL","a#00846944","NULL");
INSERT INTO portuguese_index VALUES ("atribuido","NULL","NULL","a#00846944","NULL");
INSERT INTO portuguese_index VALUES ("afecto","NULL","NULL","a#00846944","NULL");
INSERT INTO portuguese_index VALUES ("afeto","n#05560772","NULL","a#00846944","NULL");
INSERT INTO portuguese_index VALUES ("acasalamento","n#00847340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Acasalamento","n#00847340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cópula","n#00847340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acoplamento","n#00847340 n#03119510 n#03533654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("opcional","NULL","NULL","a#00847399","NULL");
INSERT INTO portuguese_index VALUES ("acasalamento_preferencial","n#00847770","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("facultativo","NULL","NULL","a#00847861 a#01194974 a#01617859","NULL");
INSERT INTO portuguese_index VALUES ("imprescindível","NULL","NULL","a#00807895 a#00808287 a#00858627 a#01524177 a#01524557","NULL");
INSERT INTO portuguese_index VALUES ("obrigatório","NULL","NULL","a#00807895 a#00808287 a#01524557","NULL");
INSERT INTO portuguese_index VALUES ("ofender","NULL","v#00575170 v#01221816 v#01224189 v#01235670","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forçoso","NULL","NULL","a#00808287","NULL");
INSERT INTO portuguese_index VALUES ("compulsório","NULL","NULL","a#00808287","NULL");
INSERT INTO portuguese_index VALUES ("adultério","n#00848466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fornicação","n#00848466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fornicação","n#00848745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incesto","n#00848891","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coito_interrompido","n#00849059","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("onanismo","n#00849059 n#00855674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("zombar","NULL","v#00849080 v#00851933 v#00852922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sexo_anal","n#00849294","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sodomia","n#00849294","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("airoso","NULL","NULL","a#00809143","NULL");
INSERT INTO portuguese_index VALUES ("garboso","NULL","NULL","a#00809143","NULL");
INSERT INTO portuguese_index VALUES ("elegante","NULL","NULL","a#00809143 a#00924655 a#01090737 a#01092969","NULL");
INSERT INTO portuguese_index VALUES ("esbelto","NULL","NULL","a#00809143 a#00936334 a#00938625 a#01092969","NULL");
INSERT INTO portuguese_index VALUES ("gracioso","NULL","NULL","a#00809143 a#01139352 a#01092969","NULL");
INSERT INTO portuguese_index VALUES ("procriação","n#00546046","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reprodução","n#00546046 n#00658528 n#02498378 n#03229727 n#09698499","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caricaturar","NULL","v#00849592","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_caricaturas","NULL","v#00849592","NULL","NULL");
INSERT INTO portuguese_index VALUES ("miscigenação","n#00546214 n#00546649","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demasiado_educado","NULL","NULL","a#00849912","NULL");
INSERT INTO portuguese_index VALUES ("parodiar","NULL","v#00849939 v#01723963","NULL","NULL");
INSERT INTO portuguese_index VALUES ("geração","n#00546392 n#06195881 n#06196326 n#10955750","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luxuriante","NULL","NULL","a#00809989 a#01953089","NULL");
INSERT INTO portuguese_index VALUES ("luxuoso","NULL","NULL","a#00809989 a#01953089 a#01953265","NULL");
INSERT INTO portuguese_index VALUES ("Biogenese","n#00850260","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("biogênese","n#00850260 n#13438817","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Biogénese","n#00850260","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hibridização","n#00546649","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mistificar_por_pilhéria","NULL","v#00851100","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_blague","NULL","v#00851100","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deselegante","NULL","NULL","a#00851103","NULL");
INSERT INTO portuguese_index VALUES ("esporar","NULL","v#00577163","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esporear","NULL","v#00577163","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reptar","NULL","v#00577163","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endogamia","n#00851587 n#13965049","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Planejamento_familiar_natural","n#00851689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enfadar","NULL","v#00577495","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incomodar","NULL","v#00577495 v#01220151 v#01221002 v#01221478 v#01221988 v#01790538 v#01791408 v#01229968 v#01230185 v#02018858 v#02507464 v#01709356","NULL","NULL");
INSERT INTO portuguese_index VALUES ("importunar","NULL","v#00577495 v#01220151 v#01221002 v#01221478 v#01221988","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elegível","NULL","NULL","a#00851744","NULL");
INSERT INTO portuguese_index VALUES ("ridicularizar","NULL","v#00851933 v#00852922 v#00853195 v#00853445","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacanear","NULL","v#00851933 v#01104624","NULL","NULL");
INSERT INTO portuguese_index VALUES ("planejamento_familiar","n#00851994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("planeamento_familiar","n#00851994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controle_de_natalidade","n#00851994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controlo_de_natalidade","n#00851994","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contracepção","n#00852181","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conveniente","NULL","NULL","a#00812035 a#01077975 a#01878870 a#01879667","NULL");
INSERT INTO portuguese_index VALUES ("escarnecer","NULL","v#00852922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inelegível","NULL","NULL","a#00852988 a#01404042","NULL");
INSERT INTO portuguese_index VALUES ("inadequado","NULL","NULL","a#00853473","NULL");
INSERT INTO portuguese_index VALUES ("preliminares","n#00853835","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estimulação","n#00853835","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("soba","n#00547908","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("brincar","NULL","v#00854150","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afetivo","NULL","NULL","a#00813947","NULL");
INSERT INTO portuguese_index VALUES ("sexo_oral","n#00854876","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cunilíngua","n#00855055","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("felação","n#00855169 n#00855301","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chupa","n#00855169","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bulir","NULL","v#00580082","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chupada","n#00855301","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("boquete","n#00855301","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("meia-nove","n#00855407","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sessenta_e_nove","n#00855407","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passar_em_revista","NULL","v#00580256","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autoerotismo","n#00855527","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Masturbaçao","n#00855674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("masturbação","n#00855674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Masturbação","n#00855674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arbitrar","NULL","v#00855794 v#02691890","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depreciar","NULL","v#00580569 v#00864475","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lírico","NULL","NULL","a#00856011 a#01468994 a#01501990 a#02856286 a#02856460","NULL");
INSERT INTO portuguese_index VALUES ("frottage","n#00856076","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empolgante","NULL","NULL","a#00856132","NULL");
INSERT INTO portuguese_index VALUES ("promiscuidade","n#00856342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Promiscuidade","n#00856342","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("louvar","NULL","v#00856824 v#00583639 v#00583913 v#00584625","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elogiar","NULL","v#00856824 v#00597534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homossexualidade","n#00856847","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bissexualidade","n#00857160","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saudar","NULL","v#00581587 v#00607679 v#00607777 v#00609843 v#00610047 v#00900214 v#00610299","NULL","NULL");
INSERT INTO portuguese_index VALUES ("safismo","n#00857424","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lesbianismo","n#00857424","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tribadismo","n#00857530","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impassível","NULL","NULL","a#00816707","NULL");
INSERT INTO portuguese_index VALUES ("corvejar","NULL","v#00581935","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crocitar","NULL","v#00581935 v#01060065","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grasnar","NULL","v#00581935 v#01060065","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cantar","NULL","v#00581935 v#00711517 v#01067816 v#01183701 v#01184598","NULL","NULL");
INSERT INTO portuguese_index VALUES ("heterossexualidade","n#00857664","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pederastia","n#00857872","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pederastia","n#00857872","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exultar","NULL","v#00582048","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filosófico","NULL","NULL","a#00817110 a#02647426","NULL");
INSERT INTO portuguese_index VALUES ("bestialidade","n#00858060","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fleumático","NULL","NULL","a#00858340","NULL");
INSERT INTO portuguese_index VALUES ("soneca","n#00858377 n#00858849","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sesta","n#00858377 n#00551029 n#00858849 n#10971856 n#15273955","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("liderar_a_torcida","NULL","v#00858437","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ser_o_líder_da_torcida","NULL","v#00858437","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estoico","NULL","NULL","a#00858558","NULL");
INSERT INTO portuguese_index VALUES ("estóico","NULL","NULL","a#00858558","NULL");
INSERT INTO portuguese_index VALUES ("aclamar","NULL","v#00582462 v#00583639 v#00584625 v#00584733","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cochilo","n#00551029 n#00858849","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empírico","NULL","NULL","a#00817794 a#02812227","NULL");
INSERT INTO portuguese_index VALUES ("resposta","n#00551220 n#05053336 n#05055491 n#05379686 n#05380025 n#07200527","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animar-se","NULL","v#00582840","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alegrar-se","NULL","v#00582840 v#01237680","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alegrar","NULL","v#00582994 v#01237013 v#01237403","NULL","NULL");
INSERT INTO portuguese_index VALUES ("testável","NULL","NULL","a#00859453","NULL");
INSERT INTO portuguese_index VALUES ("capaz_de_ser_provado_como_falso","NULL","NULL","a#00859453","NULL");
INSERT INTO portuguese_index VALUES ("confirmável","NULL","NULL","a#00859453","NULL");
INSERT INTO portuguese_index VALUES ("existencial","NULL","NULL","a#00859632","NULL");
INSERT INTO portuguese_index VALUES ("recrear","NULL","v#00583232","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divertir","NULL","v#00583232 v#01698431 v#01698559","NULL","NULL");
INSERT INTO portuguese_index VALUES ("experimental","NULL","NULL","a#00818899 a#02712486","NULL");
INSERT INTO portuguese_index VALUES ("teórico","NULL","NULL","a#00819481 a#00862327","NULL");
INSERT INTO portuguese_index VALUES ("hipotético","NULL","NULL","a#00820398","NULL");
INSERT INTO portuguese_index VALUES ("promulgar","NULL","v#00861560 v#02427916","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tropismo","n#00861611","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tropismo","n#00861611","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clamar","NULL","v#00584625","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ovacionar","NULL","v#00584625 v#00584733","NULL","NULL");
INSERT INTO portuguese_index VALUES ("especulativo","NULL","NULL","a#00820554","NULL");
INSERT INTO portuguese_index VALUES ("geotropismo","n#00861990","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("metafísico","NULL","NULL","a#00820749 a#01520849 a#02653696","NULL");
INSERT INTO portuguese_index VALUES ("heliotropismo","n#00862079","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vaiar","NULL","v#00862225","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vaia","NULL","v#00862225","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fototropismo","n#00862399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agredir","NULL","v#00585325 v#00758805 v#00760028","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taxia","n#00862686","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quimiotaxia","n#00862859","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Quimiotaxia","n#00862859","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forense","NULL","NULL","a#00863361 a#02017613","NULL");
INSERT INTO portuguese_index VALUES ("Reflexos","n#00554907","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reflexo","n#00554907","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autónomo","NULL","NULL","a#00822609","NULL");
INSERT INTO portuguese_index VALUES ("desempregados","NULL","NULL","a#00864693","NULL");
INSERT INTO portuguese_index VALUES ("reflexo_patelar","n#00864859","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anatematizar","NULL","v#00864910","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abominar","NULL","v#00864910 v#01211403","NULL","NULL");
INSERT INTO portuguese_index VALUES ("blogar","NULL","v#00865280","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reflexo_de_Moro","n#00865284","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("xingar","NULL","v#00586673","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desbocar","NULL","v#00586673","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enfeitiçado","NULL","NULL","a#00865765 a#01405188","NULL");
INSERT INTO portuguese_index VALUES ("Miose","n#00865808","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("miose","n#00865808 n#13512725","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fascinado","NULL","NULL","a#00865848","NULL");
INSERT INTO portuguese_index VALUES ("amaldiçoar","NULL","v#00586866 v#00613914","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Midríase","n#00866079","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desiludido","NULL","NULL","a#00866392 a#02333976","NULL");
INSERT INTO portuguese_index VALUES ("Reflexo_faríngeo","n#00866423","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("benzer","NULL","v#00587155","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bendizer","NULL","v#00587155 v#01548774","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abençoar","NULL","v#00587155 v#01548774","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pele_de_galinha","n#00866606","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrepio","n#00866606 n#07520112 n#10291206","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pele-de-galinha","n#00866606","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("santificar","NULL","v#00587298","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consagrar","NULL","v#00587298 v#00601306 v#01625416","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reflexo_plantar","n#00866882","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desencorajante","NULL","NULL","a#00867213","NULL");
INSERT INTO portuguese_index VALUES ("qüestionar","NULL","v#00867409","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desencorajador","NULL","NULL","a#00867520","NULL");
INSERT INTO portuguese_index VALUES ("desalentador","NULL","NULL","a#00867520","NULL");
INSERT INTO portuguese_index VALUES ("trema","n#00557607 n#06823760","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("choro","n#00557729","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pranto","n#00557729 n#05262010 n#05286621 n#05387878","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lamento","n#00558177 n#06379568 n#05332420 n#07208930 n#05387878","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cálculo","n#00558391 n#00561931 n#04470977 n#04604195 n#06517779","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cáculo","n#00869583","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impugnar","NULL","v#00869596","NULL","NULL");
INSERT INTO portuguese_index VALUES ("candidatar","NULL","v#00869596","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avisar","NULL","v#00589833 v#00590070 v#00590442 v#00591502 v#00591742 v#00591857","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alertar","NULL","v#00589833 v#00591365","NULL","NULL");
INSERT INTO portuguese_index VALUES ("admoestar","NULL","v#00590070 v#00590442","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prevenir","NULL","v#00590070 v#00590442","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ameaçar","NULL","v#00590553 v#00590929 v#01067194 v#01839881","NULL","NULL");
INSERT INTO portuguese_index VALUES ("integração","n#00560004 n#00779108 n#00803600","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("multiplicação","n#00560144 n#09729457","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Subtraçao","n#00560394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sinal_de_menos","n#00560394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agourar","NULL","v#00591090","NULL","NULL");
INSERT INTO portuguese_index VALUES ("augurar","NULL","v#00591090","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pressagiar","NULL","v#00591090","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profetizar","NULL","v#00591090 v#00924777","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exponenciação","n#00872411","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alarmar","NULL","v#00591365","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endotérmico","NULL","NULL","a#00872510","NULL");
INSERT INTO portuguese_index VALUES ("aconselhar","NULL","v#00591502","NULL","NULL");
INSERT INTO portuguese_index VALUES ("opiniar","NULL","v#00591502","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Adição_de_matrizes","n#00872900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exotérmico","NULL","NULL","a#00872906","NULL");
INSERT INTO portuguese_index VALUES ("Produto_de_matrizes","n#00872986","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endógeno","NULL","NULL","a#00873113 a#02876745","NULL");
INSERT INTO portuguese_index VALUES ("exógeno","NULL","NULL","a#00873251","NULL");
INSERT INTO portuguese_index VALUES ("energético","NULL","NULL","a#00873603","NULL");
INSERT INTO portuguese_index VALUES ("anunciar","NULL","v#00591857 v#00935827 v#00654101 v#00660471 v#00660910 v#00661487","NULL","NULL");
INSERT INTO portuguese_index VALUES ("julgamento","n#00561563 n#00768711 n#00771599 n#00775506","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("critica","n#00561563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("juízo","n#00561563 n#04495853 n#04918568","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("familiarizar","NULL","v#00874175","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adjudicação","n#00874457","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avaliação_(ciência)","n#00874806","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avaliação","n#00874806 n#00561931 n#04426384 n#04428566","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incansável","NULL","NULL","a#00832806","NULL");
INSERT INTO portuguese_index VALUES ("infatigável","NULL","NULL","a#00832806","NULL");
INSERT INTO portuguese_index VALUES ("inesgotável","NULL","NULL","a#00832806 a#01008289","NULL");
INSERT INTO portuguese_index VALUES ("recomendar","NULL","v#00592685 v#00598264","NULL","NULL");
INSERT INTO portuguese_index VALUES ("అత్యవసరం","NULL","NULL","a#00833067","NULL");
INSERT INTO portuguese_index VALUES ("estimativa","n#00561931","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sugerir","NULL","v#00592804 v#00623193 v#00627339 v#00629806","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vigoroso","NULL","NULL","a#00875422 a#02039845","NULL");
INSERT INTO portuguese_index VALUES ("letárgico","NULL","NULL","a#00875712","NULL");
INSERT INTO portuguese_index VALUES ("promover","NULL","v#00593041 v#01741671","NULL","NULL");
INSERT INTO portuguese_index VALUES ("juízo_de_valor","n#00875838","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Juizo_de_valor","n#00875838","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extraviar","NULL","v#00876104","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lânguido","NULL","NULL","a#01849739 a#00834080","NULL");
INSERT INTO portuguese_index VALUES ("consultar","NULL","v#00593630 v#00593763 v#00594016 v#01651097 v#01695786","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apático","NULL","NULL","a#00834080 a#01289497 a#02281611","NULL");
INSERT INTO portuguese_index VALUES ("ausculta","n#00876542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("auscultação","n#00876542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atividade_sensorial","n#00876737","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("percepção","n#00562902 n#04406962 n#04410319","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exportável","NULL","NULL","a#00876989","NULL");
INSERT INTO portuguese_index VALUES ("que_pode_ser_exportado","NULL","NULL","a#00876989","NULL");
INSERT INTO portuguese_index VALUES ("fazer_referência","NULL","v#00594016","NULL","NULL");
INSERT INTO portuguese_index VALUES ("olhada","n#00563114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exploratório","NULL","NULL","a#00877345","NULL");
INSERT INTO portuguese_index VALUES ("olhadela","n#00563576","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deflexão","n#00563576","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relance","n#00563576","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mirada","n#00563576","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preliminar","NULL","NULL","a#00878086 a#00856572","NULL");
INSERT INTO portuguese_index VALUES ("atestar","NULL","v#00594839 v#00686544","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aceder","NULL","v#00594989","NULL","NULL");
INSERT INTO portuguese_index VALUES ("olhar_fixo","n#00564117","v#01459552","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contemplação","n#00564461 n#04459998","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("olho_gordo","n#00879156","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mau-olhado","n#00879156","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mau_olhado","n#00879156","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inspecção","n#00564770","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("observância","n#00565102","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vislumbre","n#00565102","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("observação","n#00565102 n#00565444 n#00881649 n#00647699 n#00729616 n#04406962 n#04412315 n#05068616 n#05069878","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("monitorização","n#00880046","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gabar","NULL","v#00880227","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aumentado","NULL","NULL","a#00880586","NULL");
INSERT INTO portuguese_index VALUES ("melhorado","NULL","NULL","a#00880765","NULL");
INSERT INTO portuguese_index VALUES ("realçado","NULL","NULL","a#00880765","NULL");
INSERT INTO portuguese_index VALUES ("salientado","NULL","NULL","a#00880765","NULL");
INSERT INTO portuguese_index VALUES ("inflado","NULL","NULL","a#00837815","NULL");
INSERT INTO portuguese_index VALUES ("hiperbólico","NULL","NULL","a#00837815","NULL");
INSERT INTO portuguese_index VALUES ("bajular","NULL","v#00881534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parabenizar","NULL","v#00597423 v#00597631","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reduzido","NULL","NULL","a#00838646 a#01264643 a#01162081","NULL");
INSERT INTO portuguese_index VALUES ("felicitar","NULL","v#00597631","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_ouvidos","n#00882159","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escuta","n#00882159","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atenue","NULL","NULL","a#00882166","NULL");
INSERT INTO portuguese_index VALUES ("leitura_labial","n#00882554","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pequeno","NULL","NULL","a#00839486 a#01228148 a#01336443 a#01337063 a#01358565 a#01413178 a#01469123 a#01589390 a#02229453","NULL");
INSERT INTO portuguese_index VALUES ("paladar","n#00882702","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_presente","NULL","v#00882802","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exalarcheiro","n#00567476","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encarregar","NULL","v#00598374 v#01603985 v#02480803","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remitente","NULL","NULL","a#00883188","NULL");
INSERT INTO portuguese_index VALUES ("ostentar","NULL","v#00883226 v#01466509","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vangloriar-se","NULL","v#00883226","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fanfarrear","NULL","v#00883226","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ensinamento","n#00567704","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("didáctica","n#00567704","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Educação","n#00567704 n#08132637","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("educação","n#00567704 n#00570118 n#03851783 n#04440488 n#04589767","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instrução","n#00567704 n#04921417 n#03851783 n#04589767 n#04941372 n#05082722","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ensino","n#00567704 n#00570118 n#04440488","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formação","n#00567704 n#00593716 n#02715450 n#04921417 n#06232231","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prometer","NULL","v#00598975 v#00884317","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aula","n#00568196 n#00571937 n#06115327","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penhorar","NULL","v#00599443","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empreendedor","n#10060352","NULL","a#00884778","NULL");
INSERT INTO portuguese_index VALUES ("obrigar","NULL","v#00599940 v#01707058 v#01708245 v#01745992","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empresarial","NULL","NULL","a#00842132 a#03064382","NULL");
INSERT INTO portuguese_index VALUES ("educação_de_jovens_e_adultos","n#00885297","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("educação_de_adultos","n#00885297","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entusiasta","n#07256227","NULL","a#00885695","NULL");
INSERT INTO portuguese_index VALUES ("entusiástico","NULL","NULL","a#00885695","NULL");
INSERT INTO portuguese_index VALUES ("ensino_básico","n#00885858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fervoroso","NULL","NULL","a#00843026","NULL");
INSERT INTO portuguese_index VALUES ("zeloso","NULL","NULL","a#00843026","NULL");
INSERT INTO portuguese_index VALUES ("fervente","NULL","NULL","a#00843026","NULL");
INSERT INTO portuguese_index VALUES ("evangélico","NULL","NULL","a#00886681 a#02922814 a#02923005","NULL");
INSERT INTO portuguese_index VALUES ("ensino_superior","n#00886699","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_votos","NULL","v#00601123","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ensino_secundário","n#00886807 n#06150140","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pedagogia","n#00570118","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comprometer","NULL","v#00601722 v#00701304 v#00701625 v#01036592 v#01826476","NULL","NULL");
INSERT INTO portuguese_index VALUES ("morno","NULL","NULL","a#00844091 a#02407643","NULL");
INSERT INTO portuguese_index VALUES ("tépido","NULL","NULL","a#00844091 a#02407643","NULL");
INSERT INTO portuguese_index VALUES ("Desportos_colectivos","n#00887544","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("catequese","n#00887882","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invejoso","NULL","NULL","a#00845237","NULL");
INSERT INTO portuguese_index VALUES ("invejosa","NULL","NULL","a#00845237","NULL");
INSERT INTO portuguese_index VALUES ("ciumento","NULL","NULL","a#00845237 a#02345311","NULL");
INSERT INTO portuguese_index VALUES ("nostálgico","NULL","NULL","a#00889098 a#01977669","NULL");
INSERT INTO portuguese_index VALUES ("assinar","NULL","v#00602606 v#00673751 v#00674118 v#02209745 v#01679448","NULL","NULL");
INSERT INTO portuguese_index VALUES ("garantir","NULL","v#00602914 v#00603511 v#00604530","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parelho","NULL","NULL","a#00845976","NULL");
INSERT INTO portuguese_index VALUES ("análogo","n#04746430","NULL","a#00845976 a#01170142 a#01994404","NULL");
INSERT INTO portuguese_index VALUES ("jurar","NULL","v#00603145 v#00683865","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afiançar","NULL","v#00890100","NULL","NULL");
INSERT INTO portuguese_index VALUES ("equivalente","n#05026508 n#05695554","NULL","a#00847587 a#01985976 a#02502016","NULL");
INSERT INTO portuguese_index VALUES ("certificar-se","NULL","v#00603511","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assegurar-se","NULL","v#00603511","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_certeza","NULL","v#00603511","NULL","NULL");
INSERT INTO portuguese_index VALUES ("co-igual","NULL","NULL","a#00890781","NULL");
INSERT INTO portuguese_index VALUES ("equidistante","NULL","NULL","a#00890985","NULL");
INSERT INTO portuguese_index VALUES ("eqüidistante","NULL","NULL","a#00890985","NULL");
INSERT INTO portuguese_index VALUES ("propedêutica","n#00891642","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Propedêutica","n#00891642","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("seminário","n#00892145 n#00892413 n#08285109 n#08327816","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agradecer","NULL","v#00604655 v#00604807","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sleep-learning","n#00892538","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passar_quitação","NULL","v#00892698","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_recibo","NULL","v#00892698","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conferência","n#00573978 n#05343252 n#06197821","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escusar","NULL","v#00605154 v#00612955 v#00613352 v#01748679","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desculpar-se","NULL","v#00605303","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disciplina","n#00574577 n#03823941 n#04378256 n#04594727","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eximir","NULL","v#00605518 v#00611497 v#02412175","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excusar","NULL","v#00605518","NULL","NULL");
INSERT INTO portuguese_index VALUES ("treino","n#00574678","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("simétrico","NULL","NULL","a#00894029 a#02371718","NULL");
INSERT INTO portuguese_index VALUES ("desequilibrado","NULL","NULL","a#00894757","NULL");
INSERT INTO portuguese_index VALUES ("hipertônico","NULL","NULL","a#00895126","NULL");
INSERT INTO portuguese_index VALUES ("hipotônico","NULL","NULL","a#00895276","NULL");
INSERT INTO portuguese_index VALUES ("defender","NULL","v#00606523 v#00687837 v#00765509 v#00765817 v#01129064 v#00766532 v#00766986 v#00780965 v#01870507","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inequívoco","NULL","NULL","a#00896555 a#00940969","NULL");
INSERT INTO portuguese_index VALUES ("unívoco","NULL","NULL","a#00896555","NULL");
INSERT INTO portuguese_index VALUES ("cumprimentar","NULL","v#00607777 v#00670272","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ensaio_geral","n#00897365","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eradicável","NULL","NULL","a#00897517","NULL");
INSERT INTO portuguese_index VALUES ("dirigir","NULL","v#00608070 v#00781920 v#01172098 v#01317321 v#01317898 v#01935104 v#01658906 v#01661432 v#01662020 v#01663616 v#01731370","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apertar_as_mãos","NULL","v#00898019","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obliterável","NULL","NULL","a#00898132","NULL");
INSERT INTO portuguese_index VALUES ("acenar","NULL","v#00898210 v#00608770 v#01041644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curvar-se","NULL","v#00609009","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inclinar-se","NULL","v#00609009 v#02033295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modelação","n#00898804 n#00937895","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("modelagem","n#00898804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esotérico","NULL","NULL","a#00898963","NULL");
INSERT INTO portuguese_index VALUES ("Simulação","n#00899049","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("simulação","n#00899049 n#05666700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abstruso","NULL","NULL","a#00899226","NULL");
INSERT INTO portuguese_index VALUES ("abstracto","NULL","NULL","a#00899226","NULL");
INSERT INTO portuguese_index VALUES ("recôndito","NULL","NULL","a#00899226","NULL");
INSERT INTO portuguese_index VALUES ("dramatização","n#00899292 n#00930868","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("misterioso","NULL","NULL","a#00899612 a#00855736 a#00892302 a#01519719 a#01515354","NULL");
INSERT INTO portuguese_index VALUES ("oculto","n#09503877","NULL","a#00899612","NULL");
INSERT INTO portuguese_index VALUES ("secreto","NULL","NULL","a#00899612 a#02012899","NULL");
INSERT INTO portuguese_index VALUES ("arcano","n#05003422","NULL","a#00899612","NULL");
INSERT INTO portuguese_index VALUES ("Teatro_de_Fantoches","n#00899657","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("teatro_de_fantoches","n#00899657","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cabalístico","NULL","NULL","a#00855484","NULL");
INSERT INTO portuguese_index VALUES ("místico","NULL","NULL","a#00855736 a#01935744 a#02863247 a#02863464","NULL");
INSERT INTO portuguese_index VALUES ("misteriosa","NULL","NULL","a#00855736 a#00892302","NULL");
INSERT INTO portuguese_index VALUES ("retrato","n#00900375 n#03113185 n#03160624 n#05381542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recepcionar","NULL","v#00610465","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desenho","n#00579072 n#00594989 n#02557662 n#02598242 n#03265874 n#02849808 n#02965788 n#03113185 n#03118233 n#03229963 n#03343837 n#04536390 n#04541674 n#06998748 n#06999233 n#05252378 n#05255398 n#05381542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despidir","NULL","v#00900961","NULL","NULL");
INSERT INTO portuguese_index VALUES ("principal","NULL","NULL","a#00856572 a#00960836 a#02228883","NULL");
INSERT INTO portuguese_index VALUES ("Tomografia","n#00901083","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("biogênico","NULL","NULL","a#00901161","NULL");
INSERT INTO portuguese_index VALUES ("constituinte","n#06312966","NULL","a#00856863","NULL");
INSERT INTO portuguese_index VALUES ("orgânico","NULL","NULL","a#00856863 a#01041379 a#01166875 a#01619269 a#01619659 a#02558767","NULL");
INSERT INTO portuguese_index VALUES ("Ultra-som","n#00901789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ultrasonografia","n#00901789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ultrassom","n#00901789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ultra_som","n#00901789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preceder","NULL","v#00611179 v#01364150 v#01639896 v#01836899 v#01852936","NULL","NULL");
INSERT INTO portuguese_index VALUES ("virtual","NULL","NULL","a#00902157 a#01872957","NULL");
INSERT INTO portuguese_index VALUES ("Tomografia_por_emissão_de_pósitrões","n#00902376","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tomografia_por_emissão_de_positrões","n#00902376","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exonerar","NULL","v#00611497","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ressonância_magnética","n#00902579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ressonância_Magnética","n#00902579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fluoroscopia","n#00903201","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fluoroscopia","n#00903201","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_obrigatório","NULL","NULL","a#00903264","NULL");
INSERT INTO portuguese_index VALUES ("Radiologia","n#00903309","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("radiologia","n#00903309","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desculpar","NULL","v#00612137 v#00613352","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perdoar","NULL","v#00612137 v#00612955 v#00613352","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dispensável","NULL","NULL","a#00903449","NULL");
INSERT INTO portuguese_index VALUES ("que_pode_ser_dispensado","NULL","NULL","a#00903449","NULL");
INSERT INTO portuguese_index VALUES ("indispensável","NULL","NULL","a#00858627 a#02865172 a#01524177","NULL");
INSERT INTO portuguese_index VALUES ("que_não_pode_ser_dispensado","NULL","NULL","a#00858627","NULL");
INSERT INTO portuguese_index VALUES ("inocentar","NULL","v#00612323","NULL","NULL");
INSERT INTO portuguese_index VALUES ("admirável","NULL","NULL","a#00859179 a#01229558 a#01617066 a#01735655","NULL");
INSERT INTO portuguese_index VALUES ("radiografia","n#00904428 n#04042358 n#04100620","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desprezível","NULL","NULL","a#00904548 a#01085389","NULL");
INSERT INTO portuguese_index VALUES ("xerografia","n#00904904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patético","NULL","NULL","a#00859856 a#02079830","NULL");
INSERT INTO portuguese_index VALUES ("angiografia","n#00905336","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ético","NULL","NULL","a#00860061","NULL");
INSERT INTO portuguese_index VALUES ("anistiar","NULL","v#00905677","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_ético","NULL","NULL","a#00905728","NULL");
INSERT INTO portuguese_index VALUES ("arteriografia","n#00905742","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gratís","NULL","NULL","a#00905905 a#01007914 a#02399130","NULL");
INSERT INTO portuguese_index VALUES ("paliar","NULL","v#00613501","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encefalografia","n#00906290","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("provar_a_culpa","NULL","v#00613686","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sentenciar","NULL","v#00613914","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depreciativo","NULL","NULL","a#00907032","NULL");
INSERT INTO portuguese_index VALUES ("lamentar","NULL","v#00614225 v#00910891 v#00616908 v#00617155 v#01225879 v#01226113 v#01226222 v#01797204","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pejorativo","NULL","NULL","a#00907243","NULL");
INSERT INTO portuguese_index VALUES ("dizer_coisas_xulas","NULL","v#00614681","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cinematografia","n#00907919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cinematografia","n#00907919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("birra","n#14406303","v#00614873","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tomada","n#00582762 n#03274137 n#04548771","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eufemístico","NULL","NULL","a#00908483","NULL");
INSERT INTO portuguese_index VALUES ("inofensivo","NULL","NULL","a#00908483 a#01159655 a#01627459 a#01628677","NULL");
INSERT INTO portuguese_index VALUES ("eufórico","NULL","NULL","a#00863471","NULL");
INSERT INTO portuguese_index VALUES ("condescender","NULL","v#00908977 v#02591455","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lanifício","n#00909193","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resmungar","NULL","v#00615688 v#00707668","NULL","NULL");
INSERT INTO portuguese_index VALUES ("murmurar","NULL","v#00615688 v#00620008 v#00707393 v#00707668","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expansivo","NULL","NULL","a#00909220","NULL");
INSERT INTO portuguese_index VALUES ("Tecelagem","n#00909281","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tecelagem","n#00909281","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ralhar","NULL","v#00909573","NULL","NULL");
INSERT INTO portuguese_index VALUES ("plano","n#02563119 n#05837271 n#04528166 n#04533598 n#04536390 n#04541674 n#05910940 n#06614729 n#09985988","NULL","a#00864501","NULL");
INSERT INTO portuguese_index VALUES ("queixar-se","NULL","v#00616273 v#00616908 v#01802219","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protestar","NULL","v#00616273 v#01718881","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gravação","n#00910203 n#04063868","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("playback","n#00910533","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gritar","n#07123012","v#00616654 v#00617311 v#00617516 v#00617840 v#00618000 v#00618946 v#00619098 v#00915041 v#00915423 v#00709491 v#00709609 v#00710825 v#00712888 v#00714796","NULL","NULL");
INSERT INTO portuguese_index VALUES ("construção","n#00585093 n#00585619 n#00715519","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("edificação","n#00585093 n#05987835","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nivelado","NULL","NULL","a#00911091","NULL");
INSERT INTO portuguese_index VALUES ("desuniforme","NULL","NULL","a#00865276","NULL");
INSERT INTO portuguese_index VALUES ("desnivelado","NULL","NULL","a#00865276","NULL");
INSERT INTO portuguese_index VALUES ("despadronizado","NULL","NULL","a#00865276","NULL");
INSERT INTO portuguese_index VALUES ("lastimar","NULL","v#00616908 v#01821996","NULL","NULL");
INSERT INTO portuguese_index VALUES ("erecção","n#00911752","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fabricação","n#00585619 n#00593220 n#00593550","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exclamar","NULL","v#00617311","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bradar","NULL","v#00617311 v#00617840 v#00709770","NULL","NULL");
INSERT INTO portuguese_index VALUES ("berrar","NULL","v#00617311 v#00617516 v#00617840 v#00618000","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nivelação","n#00586129","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("construção_de_estradas","n#00912733","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cheio_de_remendos","NULL","NULL","a#00912814","NULL");
INSERT INTO portuguese_index VALUES ("desigual","NULL","NULL","a#00912814 a#01354054 a#01354886 a#02373868","NULL");
INSERT INTO portuguese_index VALUES ("construção_naval","n#00912822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("balar","NULL","v#00617840","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grunhir","NULL","v#00617840","NULL","NULL");
INSERT INTO portuguese_index VALUES ("actividades_de_produção","n#00912960","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("produção","n#00912960 n#00586701 n#02639315 n#03052506 n#03860882 n#03175725 n#03640400 n#04960631 n#05256705 n#13758745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("urrar","NULL","v#00618000","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mugir","NULL","v#00618000 v#00619854 v#00706217 v#00709311 v#00709609 v#00710694 v#01055018","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vociferar","NULL","v#00618000 v#00619854 v#00709609 v#00709770 v#00710694","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rústico","n#00913274","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("par","n#05980665 n#05982514 n#06953318 n#07466257 n#09769393","NULL","a#00913387","NULL");
INSERT INTO portuguese_index VALUES ("que_não_tem_o_segundo_elemento_do_par","NULL","NULL","a#00913454","NULL");
INSERT INTO portuguese_index VALUES ("impar","NULL","NULL","a#00913454","NULL");
INSERT INTO portuguese_index VALUES ("ímpar","NULL","NULL","a#00913454","NULL");
INSERT INTO portuguese_index VALUES ("sempre-verde","NULL","NULL","a#00867029","NULL");
INSERT INTO portuguese_index VALUES ("produção_em_massa","n#00914182","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("produção_exagerada","n#00914343","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superprodução","n#00914343","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("correcto","NULL","NULL","a#00867566","NULL");
INSERT INTO portuguese_index VALUES ("rendimento","n#00587304 n#09538207 n#13256691 n#13258362 n#09541569 n#09542379 n#09542577 n#09588854","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interpor","NULL","v#00619197 v#01423342 v#02098964","NULL","NULL");
INSERT INTO portuguese_index VALUES ("literal","NULL","NULL","a#00914983 a#01947389","NULL");
INSERT INTO portuguese_index VALUES ("textual","NULL","NULL","a#00914983 a#01947389 a#02925879","NULL");
INSERT INTO portuguese_index VALUES ("matemático","n#07400665","NULL","a#00868482 a#01752187 a#01848562 a#02125544 a#02710477","NULL");
INSERT INTO portuguese_index VALUES ("cultivo","n#00588408 n#00916023 n#00588753 n#00589348 n#00918176 n#06317219","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cochichar","NULL","v#00620008","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sussurrar","NULL","v#00620008 v#01494559","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falar_alto","NULL","v#00916123","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aquacultura","n#00916147","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apicultura","n#00916285","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Apicultura","n#00916285","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ímpar","NULL","NULL","a#00916383","NULL");
INSERT INTO portuguese_index VALUES ("pecuária","n#00588753 n#00917211 n#00590607 n#01403412","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("redondo","NULL","NULL","a#00869694 a#01966694","NULL");
INSERT INTO portuguese_index VALUES ("entusiasmar","NULL","v#00620548 v#01830192","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adivinhar","NULL","v#00620765 v#00621460 v#00926702 v#01443076","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aventurar","NULL","v#00620765 v#02545272","NULL","NULL");
INSERT INTO portuguese_index VALUES ("produção_animal","n#00917211","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exploração_pecuária","n#00917211","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arboricultura","n#00917614","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cultura","n#00589348 n#00920510 n#04437483 n#04590255 n#06194409 n#06152585","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pressentir","NULL","v#00621460","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fungível","NULL","NULL","a#00917956","NULL");
INSERT INTO portuguese_index VALUES ("monocultura","n#00918055","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Monocultura","n#00918055","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vicário","NULL","NULL","a#00918354 a#01598125 a#01784104","NULL");
INSERT INTO portuguese_index VALUES ("horticultura","n#00918383 n#01104544","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apostar","NULL","v#00621875 v#01138523 v#00785799","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excitável","NULL","NULL","a#00918779 a#02104277","NULL");
INSERT INTO portuguese_index VALUES ("hidroponia","n#00918976","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agricultura_mista","n#00919396","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excitada","NULL","NULL","a#00919542","NULL");
INSERT INTO portuguese_index VALUES ("entusiasmado","NULL","NULL","a#00919542 a#01928926","NULL");
INSERT INTO portuguese_index VALUES ("nervoso","NULL","NULL","a#00872229 a#02337269 a#02683628","NULL");
INSERT INTO portuguese_index VALUES ("redeterminar","NULL","v#00919960","NULL","NULL");
INSERT INTO portuguese_index VALUES ("louco","n#07384558 n#10490141","NULL","a#00872382 a#01997327 a#01999213 a#02572038","NULL");
INSERT INTO portuguese_index VALUES ("criação_de_gado","n#00590607","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encontrar","NULL","v#00622450 v#00818883 v#01382085 v#02212275 v#01538749 v#01562037 v#01562883","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ver","NULL","v#00622450 v#01442638 v#01449939 v#01456984 v#01457245 v#02130160 v#01457770 v#02131777 v#01459552 v#01459903 v#02150510 v#01474588 v#01474694 v#01481176 v#01481785 v#01482231 v#01483772 v#01673353 v#01695786","NULL","NULL");
INSERT INTO portuguese_index VALUES ("excitante","NULL","NULL","a#00921014 a#02306763","NULL");
INSERT INTO portuguese_index VALUES ("suspeitar","NULL","v#00622918 v#00625778","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jardinagem","n#00921160","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("horticultura_de_mercado","n#00921289 n#01104544","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("evidenciar","NULL","v#00623193 v#01464347","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indicar","NULL","v#00623193 v#00625042 v#00627736 v#00646401 v#00679088 v#00717396","NULL","NULL");
INSERT INTO portuguese_index VALUES ("denotar","NULL","v#00623193 v#00630586","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sinalizar","NULL","v#00623193 v#00703699","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_tirar_o_fôlego","NULL","NULL","a#00921369","NULL");
INSERT INTO portuguese_index VALUES ("sem_fôlego","NULL","NULL","a#00921369","NULL");
INSERT INTO portuguese_index VALUES ("floricultura","n#00921399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("elétrico","n#04335435","NULL","a#00874188 a#02826701 a#02622421","NULL");
INSERT INTO portuguese_index VALUES ("eletrizante","NULL","NULL","a#00874188 a#02622421","NULL");
INSERT INTO portuguese_index VALUES ("assinalar","NULL","v#00623416 v#00625553 v#00627736 v#00685329","NULL","NULL");
INSERT INTO portuguese_index VALUES ("glamoroso","NULL","NULL","a#00922051","NULL");
INSERT INTO portuguese_index VALUES ("glamouroso","NULL","NULL","a#00922051","NULL");
INSERT INTO portuguese_index VALUES ("glamourosa","NULL","NULL","a#00922051","NULL");
INSERT INTO portuguese_index VALUES ("prestigioso","NULL","NULL","a#00922051 a#01830703 a#01911900","NULL");
INSERT INTO portuguese_index VALUES ("movimentação_de_terras","n#00592125 n#00602398","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mineração","n#00592125","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mineração","n#00592125","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("terraplenagem","n#00592125 n#00602398","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extracção_de_minérios_a_céu_aberto","n#00922848","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("minas_a_céu_aberto","n#00922848","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mostrar","NULL","v#00624230 v#00625042 v#00639232 v#00659537 v#00685329 v#01462865 v#01463238 v#01464775 v#01465746 v#01470807","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exploração_de_pedreiras","n#00922968","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perfuração","n#00923130 n#00944633 n#09389867","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indústria","n#00592801 n#06011363","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manufatura","n#00592801 n#02662271","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atenuante","NULL","NULL","a#00923671","NULL");
INSERT INTO portuguese_index VALUES ("industrialização","n#00593063","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fabrico","n#00593220","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acusatório","NULL","NULL","a#00924257","NULL");
INSERT INTO portuguese_index VALUES ("acusante","NULL","NULL","a#00924257","NULL");
INSERT INTO portuguese_index VALUES ("acusador","n#09762385","NULL","a#00924257","NULL");
INSERT INTO portuguese_index VALUES ("foliação","n#00924438","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cartografia","n#00924579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cartografia","n#00924579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prenunciar","NULL","v#00924777","NULL","NULL");
INSERT INTO portuguese_index VALUES ("admirar-se","NULL","v#00925490","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forjamento","n#00925622","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Indústria_metal-mecânica","n#00925732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estranhar","NULL","v#00925735","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maravilhar-se","NULL","v#00925735","NULL","NULL");
INSERT INTO portuguese_index VALUES ("renovável","NULL","NULL","a#00925820 a#01962982","NULL");
INSERT INTO portuguese_index VALUES ("formular","NULL","v#00626484 v#00663647 v#01122191","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sofrido","NULL","NULL","a#00926141","NULL");
INSERT INTO portuguese_index VALUES ("exausto","NULL","NULL","a#00926141 a#02432562","NULL");
INSERT INTO portuguese_index VALUES ("reformular","NULL","v#00926310","NULL","NULL");
INSERT INTO portuguese_index VALUES ("restante","NULL","NULL","a#01993695","NULL");
INSERT INTO portuguese_index VALUES ("confecção","n#00594429","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("existente","NULL","NULL","a#00879511 a#00880469 a#01668162 a#01774902 a#01872415","NULL");
INSERT INTO portuguese_index VALUES ("especular","NULL","v#00927049","a#02008082","NULL");
INSERT INTO portuguese_index VALUES ("curtume","n#00927062","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_alusão_a","NULL","v#00627339","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_dica","NULL","v#00627339","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aludir","NULL","v#00627339 v#00692561 v#00694753","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reportar-se","NULL","v#00627339 v#00694753","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insinuar","NULL","v#00627512","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destituído","NULL","NULL","a#00927978","NULL");
INSERT INTO portuguese_index VALUES ("planejamento","n#00595211 n#04466419","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desaparecido","NULL","NULL","a#00928414 a#01450178","NULL");
INSERT INTO portuguese_index VALUES ("contraindicar","NULL","v#00928476","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remanescente","NULL","NULL","a#00880469","NULL");
INSERT INTO portuguese_index VALUES ("planejamento_urbano","n#00928542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Planejamento_Urbano","n#00928542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("urbanismo","n#00928542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estudos_urbanos","n#00928542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("planeamento_urbano","n#00928542","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delimitação_de_zonas","n#00928751","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vivente","NULL","NULL","a#00880818 a#01872306","NULL");
INSERT INTO portuguese_index VALUES ("programação_de_computadores","n#00928947","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("programação_lógica","n#00929285 n#06902193","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("programação_orientada_à_objetos","n#00929432","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("orientação_à_objetos","n#00929432","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("programação_orientada_a_objetos","n#00929432","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esperado","NULL","NULL","a#00929567","NULL");
INSERT INTO portuguese_index VALUES ("exalar","NULL","v#00929703 v#01794910","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autoria","n#00596202","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antecipado","NULL","NULL","a#00140416","NULL");
INSERT INTO portuguese_index VALUES ("previsto","NULL","NULL","a#00140416","NULL");
INSERT INTO portuguese_index VALUES ("implicar","NULL","v#00629331 v#02636325","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conotar","NULL","v#00629331","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esperável","NULL","NULL","a#00930022","NULL");
INSERT INTO portuguese_index VALUES ("imprevisto","NULL","NULL","a#02259248 a#00882895","NULL");
INSERT INTO portuguese_index VALUES ("evocar","NULL","v#00629806","NULL","NULL");
INSERT INTO portuguese_index VALUES ("não_previsto","NULL","NULL","a#00882895","NULL");
INSERT INTO portuguese_index VALUES ("sugestionar","NULL","v#00630133","NULL","NULL");
INSERT INTO portuguese_index VALUES ("historiografia","n#00931217","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Livros_de_história","n#00931217","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("romantização","n#00931453","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("significar","NULL","v#00630586 v#00630864 v#00631192 v#00631336 v#00646401","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lexicografia","n#00931721","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intencionar","NULL","v#00631047","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reificação","n#00932298 n#00932804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reificação","n#00932298 n#00932804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("querer_dizer","NULL","v#00631192 v#00646401 v#00646401","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exteriorização","n#00932624","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacrificável","NULL","NULL","a#00932695","NULL");
INSERT INTO portuguese_index VALUES ("esgotável","NULL","NULL","a#00932695","NULL");
INSERT INTO portuguese_index VALUES ("coisificação","n#00932804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caro","NULL","NULL","a#00886202 a#00886586 a#00886802 a#01401996","NULL");
INSERT INTO portuguese_index VALUES ("falar_em_línguas","NULL","v#00933239","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encarnação","n#00933259 n#09530238","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expressar","NULL","v#00933403 v#00636716 v#00639232 v#00663647 v#00719571","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divulgar","NULL","v#00632077 v#00660910","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revelar","NULL","v#00632077 v#01017658 v#01463238 v#01463992 v#01467069 v#01467502 v#02144243","NULL","NULL");
INSERT INTO portuguese_index VALUES ("barata","n#02233338","NULL","a#00887042","NULL");
INSERT INTO portuguese_index VALUES ("artes_e_ofícios","n#00935005","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pagável","NULL","NULL","a#00887956","NULL");
INSERT INTO portuguese_index VALUES ("possível_financeiramente","NULL","NULL","a#00887956","NULL");
INSERT INTO portuguese_index VALUES ("cerâmica","n#00598347 n#02415383 n#02415562 n#03165269","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sair_do_armário","NULL","v#00935456","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Decantação","n#00935608","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decantação_(floculação)","n#00935608","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmascarar","NULL","v#00935631 v#01358573","NULL","NULL");
INSERT INTO portuguese_index VALUES ("versado","NULL","NULL","a#00936038 a#02120998 a#02227946","NULL");
INSERT INTO portuguese_index VALUES ("gastronomia","n#00936296 n#07572206","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_velho","NULL","NULL","a#00889260","NULL");
INSERT INTO portuguese_index VALUES ("Origami","n#00936456","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("origami","n#00936456","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_confiançaem","NULL","v#00634158","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Gravura","n#00599329","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("talha","n#00599509","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escultura","n#00599509 n#02973558 n#03290519 n#07958727","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("morta","NULL","NULL","a#00937985","NULL");
INSERT INTO portuguese_index VALUES ("expirado","NULL","NULL","a#00937985","NULL");
INSERT INTO portuguese_index VALUES ("Topiária","n#00938134","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("topiária","n#00938134","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inválido","NULL","NULL","a#00891123 a#02380291 a#02381059","NULL");
INSERT INTO portuguese_index VALUES ("pirografia","n#00938240","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pintura_a_óleo","n#00938538","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aquarela","n#00938642 n#04558578 n#04558804 n#14991319","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("válido","NULL","NULL","a#00891553 a#02379369","NULL");
INSERT INTO portuguese_index VALUES ("água-forte","n#00938791 n#03299406","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("explicável","NULL","NULL","a#00891659","NULL");
INSERT INTO portuguese_index VALUES ("inexplicável","NULL","NULL","a#00939105","NULL");
INSERT INTO portuguese_index VALUES ("serigrafia","n#00939231","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("litografia","n#00939338 n#06680002","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("composição","n#00600817 n#02480311 n#03860186 n#03962359 n#04516798","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arranjo","n#00939628 n#05277879","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transcrição","n#00939628 n#04787636 n#06349828 n#13568238","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paradoxal","NULL","NULL","a#00892717","NULL");
INSERT INTO portuguese_index VALUES ("ofuscar","NULL","v#00940214","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recapitulação","n#00940217","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vebalizar","NULL","v#00636716","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proferir","NULL","v#00636716 v#00638109","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invenção","n#00601160 n#02865563 n#04357520 n#05063809","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("explícito","NULL","NULL","a#00893241 a#01362408","NULL");
INSERT INTO portuguese_index VALUES ("Neologismos","n#00940560","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("neologismo","n#00940560 n#06294441","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formulação","n#00940842 n#05836275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("declarado","NULL","NULL","a#00893638","NULL");
INSERT INTO portuguese_index VALUES ("determinado","NULL","NULL","a#00893638 a#01918563 a#02476338","NULL");
INSERT INTO portuguese_index VALUES ("abordagem","n#00601680","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expresso","NULL","NULL","a#00941148 a#00977699","NULL");
INSERT INTO portuguese_index VALUES ("gráfico","n#02424707 n#06998748 n#05252690 n#07000195 n#10475297","NULL","a#00893992 a#01872076 a#02173797 a#02571860 a#02572017","NULL");
INSERT INTO portuguese_index VALUES ("soltar","NULL","v#00637628 v#00983824 v#01474550 v#01011620 v#01585759 v#01757994 v#01977701 v#01648022 v#01648260","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avenida_arborizada","n#00941604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inerente","NULL","NULL","a#00894544 a#01294559","NULL");
INSERT INTO portuguese_index VALUES ("verbalizar","NULL","v#00638109 v#00943281","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conversar","NULL","v#00638109 v#00638965 v#00653048","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tácito","NULL","NULL","a#00942163","NULL");
INSERT INTO portuguese_index VALUES ("indutivo","NULL","NULL","a#00942163","NULL");
INSERT INTO portuguese_index VALUES ("Petroglifo","n#00942440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("petróglifo","n#00942440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atrasado","NULL","NULL","a#00942871","NULL");
INSERT INTO portuguese_index VALUES ("paracentese","n#00943471","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amniocentese","n#00943600","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("punção_lombar","n#00944068","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Punção_Lombar","n#00944068","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indescritível","NULL","NULL","a#00896556","NULL");
INSERT INTO portuguese_index VALUES ("inefável","NULL","NULL","a#00896556 a#01977916","NULL");
INSERT INTO portuguese_index VALUES ("toracocentese","n#00944296","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extensível","NULL","NULL","a#00944449 a#01434530","NULL");
INSERT INTO portuguese_index VALUES ("desabafar","NULL","v#00639889","NULL","NULL");
INSERT INTO portuguese_index VALUES ("montagem","n#00604176 n#03019833","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insolúvel","NULL","NULL","a#00945207","NULL");
INSERT INTO portuguese_index VALUES ("recitar","NULL","v#00640416 v#00712534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("listar","NULL","v#01529966","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coleta","n#00945916 n#07189633","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enumerar","NULL","v#00641064 v#00642112","NULL","NULL");
INSERT INTO portuguese_index VALUES ("busca","n#00946650 n#05770391","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("erétil","NULL","NULL","a#00947012 a#01236443","NULL");
INSERT INTO portuguese_index VALUES ("utilização","n#00605730 n#00607299","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expansível","NULL","NULL","a#00947264","NULL");
INSERT INTO portuguese_index VALUES ("precisar","NULL","v#00641602 v#00808096 v#00808394 v#01796135","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogar","n#00947596","v#00727813 v#01138523 v#01149470 v#00785799 v#01035585 v#01646814","NULL","NULL");
INSERT INTO portuguese_index VALUES ("uso_excessivo","n#00606110","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("uso_de_drogas","n#00947923","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("externo","NULL","NULL","a#00900427 a#00900690 a#00903717 a#00986718 a#01296215","NULL");
INSERT INTO portuguese_index VALUES ("valorização_de_terras","n#00948640","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interno","NULL","NULL","a#00900967 a#00904509 a#01293035 a#01294830","NULL");
INSERT INTO portuguese_index VALUES ("numerar","NULL","v#00948853","NULL","NULL");
INSERT INTO portuguese_index VALUES ("capacidade_de_reciclagem_(materiais)","n#00948868","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reciclagem","n#00948868","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Reciclagem","n#00948868","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reutilização","n#00948868","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paginar","NULL","v#00949093","NULL","NULL");
INSERT INTO portuguese_index VALUES ("numerar_as_páginas","NULL","v#00949093","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compaginar","NULL","v#00949093","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interior","n#06333215 n#06333474 n#06366622","NULL","a#00901710 a#00904509","NULL");
INSERT INTO portuguese_index VALUES ("adventício","NULL","NULL","a#00902134","NULL");
INSERT INTO portuguese_index VALUES ("engenharia","n#00607693 n#04660658","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tecnologia","n#00607693 n#04660658","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Engenharia_Automóvel","n#00950070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Engenharia_automóvel","n#00950070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engenharia_química","n#00950217 n#06127460","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tecnologia_das_comunicações","n#00950356","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tecnologia_da_comunicação","n#00950356","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tecnologia_informática","n#00950705","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Alta-tecnologia","n#00950858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Alta_Tecnologia","n#00950858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alta_tecnologia","n#00950858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maglev","n#00951233","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sobreexploração","n#00951433","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comercialização","n#00951781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Eletrificação","n#00952615","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletrificação","n#00952615","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relatar","NULL","v#00645239 v#00653371 v#00655029 v#00655324","NULL","NULL");
INSERT INTO portuguese_index VALUES ("narrar","NULL","v#00645239 v#00645379 v#00954271","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recontar","NULL","v#00645379","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerra_psicológica","n#00953410","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bloqueio","n#00954086","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caolho","NULL","NULL","a#00954233","NULL");
INSERT INTO portuguese_index VALUES ("guerra_eletrônica","n#00954751","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_olhos","NULL","NULL","a#00954965","NULL");
INSERT INTO portuguese_index VALUES ("pormenorizar","NULL","v#00956250","NULL","NULL");
INSERT INTO portuguese_index VALUES ("detalhar","NULL","v#00956250","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Armagedão","n#00956340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tornar_mais_belo","NULL","v#00647197","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caracterizar","NULL","v#00647376 v#01840484","NULL","NULL");
INSERT INTO portuguese_index VALUES ("injusto","NULL","NULL","a#00910225 a#00911265 a#01964483","NULL");
INSERT INTO portuguese_index VALUES ("definir","NULL","v#00647845","NULL","NULL");
INSERT INTO portuguese_index VALUES ("redefinir","NULL","v#00957549","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repetir","NULL","v#00648110 v#00648571","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ecoar","NULL","v#00648110","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eco","n#03914178 n#05380255","v#00648110","NULL","NULL");
INSERT INTO portuguese_index VALUES ("equitativo","NULL","NULL","a#00958151","NULL");
INSERT INTO portuguese_index VALUES ("papaguear","NULL","v#00648571","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reiterar","NULL","v#00648713 v#01770650","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Naval","n#00958477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerra_naval","n#00958477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conflito","n#00614914 n#00615322 n#00756240 n#04714679 n#10071502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disputa","n#00615322 n#01170813 n#00758807 n#05368498 n#05369177 n#05369518 n#07242104","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recorrer","NULL","v#00649691 v#02590072","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regressar","NULL","v#00649691 v#02004528 v#01367732","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Luta_de_Classes","n#00959800","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luta_de_classes","n#00959800","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perfido","NULL","NULL","a#00912879","NULL");
INSERT INTO portuguese_index VALUES ("pérfido","NULL","NULL","a#00912879","NULL");
INSERT INTO portuguese_index VALUES ("traiçoeiro","NULL","NULL","a#00912879 a#02061126","NULL");
INSERT INTO portuguese_index VALUES ("dublar","NULL","v#00650192","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Defesa_Civil","n#00960688","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("defesa_civil","n#00960688","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adulterino","NULL","NULL","a#00961195","NULL");
INSERT INTO portuguese_index VALUES ("latinizar","NULL","v#00961243 v#00995525","NULL","NULL");
INSERT INTO portuguese_index VALUES ("leal","NULL","NULL","a#00961392 a#01677671","NULL");
INSERT INTO portuguese_index VALUES ("parafrasear","NULL","v#00961736","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insurreição","n#00617685","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revolta","n#00617685 n#00963896","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebelião","n#00617685 n#00618461 n#00963896 n#01177327","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lexicalizar","NULL","v#00962190","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerra_civil","n#00962567","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revoluções","n#00618075","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução","n#00618075","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revolução","n#00618075 n#05524865","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_fé","NULL","NULL","a#00962939","NULL");
INSERT INTO portuguese_index VALUES ("contra-revolução","n#00963057","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alçamento","n#00618461","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insurgência","n#00618461","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insurgente","NULL","NULL","a#00963283","NULL");
INSERT INTO portuguese_index VALUES ("subversivo","n#10527334","NULL","a#00963283","NULL");
INSERT INTO portuguese_index VALUES ("motinada","n#00963896","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Motim","n#00963896","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("motim","n#00963896","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sedição","n#00963896","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falível","NULL","NULL","a#00964090","NULL");
INSERT INTO portuguese_index VALUES ("Revolta_Camponesa_de_1381","n#00964105","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolta_camponesa_de_1381","n#00964105","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falar_gírias","NULL","v#00964110","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contenda","n#00619159 n#01168961 n#01176335","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agressão","n#00619453 n#00803370","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infalível","NULL","NULL","a#00964906","NULL");
INSERT INTO portuguese_index VALUES ("descrever","NULL","v#00653371 v#00668209","NULL","NULL");
INSERT INTO portuguese_index VALUES ("à_prova_de_erros","NULL","NULL","a#00916510","NULL");
INSERT INTO portuguese_index VALUES ("à_prova_de_falhas","NULL","NULL","a#00916510","NULL");
INSERT INTO portuguese_index VALUES ("força","n#00619852 n#03928263 n#03928353 n#03930785 n#03931784 n#04043948 n#04044314 n#07799815","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("violência","n#00619852 n#03931784 n#03933665 n#10070833","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reportar","NULL","v#00965687 v#00655029","NULL","NULL");
INSERT INTO portuguese_index VALUES ("violência_doméstica","n#00965718","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acostumado","NULL","NULL","a#00917237","NULL");
INSERT INTO portuguese_index VALUES ("conhecido","n#07060310 n#07280379 n#10037654","NULL","a#00917237","NULL");
INSERT INTO portuguese_index VALUES ("pilhagem","n#00965895 n#00966599 n#09543413 n#09543577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saque","n#00965895 n#00966599 n#09543413 n#09543577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pouco_familiar","NULL","NULL","a#00917876","NULL");
INSERT INTO portuguese_index VALUES ("desconhecido","NULL","NULL","a#00917876 a#01322204 a#01377488","NULL");
INSERT INTO portuguese_index VALUES ("espoliação","n#00966869","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("depredação","n#00967310","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Armas_químicas","n#00967622","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_química","n#00967622","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("publicar","NULL","v#00655737 v#01192426 v#01193001","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fantástico","NULL","NULL","a#00918955 a#01617066 a#01936778","NULL");
INSERT INTO portuguese_index VALUES ("Armas_biológicas","n#00967780","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerra_biológica","n#00967780","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alastrar","NULL","v#00655894","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espalhar","NULL","v#00655894 v#00656764 v#00942906 v#00944275 v#00944672 v#01416364 v#01611746 v#01386521 v#01387651 v#01426321","NULL","NULL");
INSERT INTO portuguese_index VALUES ("difundir","NULL","v#00655894 v#01426321","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disseminar","NULL","v#00655894 v#00944672","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esquisito","NULL","NULL","a#00968522 a#01519719","NULL");
INSERT INTO portuguese_index VALUES ("Cruzada","n#00968715","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalhas_das_Cruzadas","n#00968715","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cruzada","n#00968715","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exótico","NULL","NULL","a#00968730 a#00984080","NULL");
INSERT INTO portuguese_index VALUES ("Primeira_Cruzada","n#00969087","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Primeira_cruzada","n#00969087","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gótico","n#06955706","NULL","a#00969103 a#02817384 a#02817485","NULL");
INSERT INTO portuguese_index VALUES ("Segunda_cruzada","n#00969225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Segunda_Cruzada","n#00969225","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semear","NULL","v#00656388 v#01030643 v#01501347","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Terceira_Cruzada","n#00969421","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Terceira_cruzada","n#00969421","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Quarta_cruzada","n#00969684","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Quarta_Cruzada","n#00969684","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Quinta_Cruzada","n#00969858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Quinta_cruzada","n#00969858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sexta_Cruzada","n#00970079","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sexta_cruzada","n#00970079","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("popularizar","NULL","v#00970215","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sétima_cruzada","n#00970331","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sétima_Cruzada","n#00970331","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chique","NULL","NULL","a#00971075 a#00975171 a#00924655 a#00975778","NULL");
INSERT INTO portuguese_index VALUES ("propagandear","NULL","v#00971460","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pronunciar","NULL","v#00657821 v#00662608 v#00669510","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inovador","n#10434725","NULL","a#01473088 a#01687586 a#01804618","NULL");
INSERT INTO portuguese_index VALUES ("guerra","n#00626011 n#01236296 n#10071856","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("do_balacobaco","NULL","NULL","a#00973677","NULL");
INSERT INTO portuguese_index VALUES ("ataque_aéreo","n#00974111","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fora_de_moda","NULL","NULL","a#00974159","NULL");
INSERT INTO portuguese_index VALUES ("defasado","NULL","NULL","a#00974159","NULL");
INSERT INTO portuguese_index VALUES ("passado","n#10849142","NULL","a#00974159","NULL");
INSERT INTO portuguese_index VALUES ("démodé","NULL","NULL","a#00974159 a#00974519","NULL");
INSERT INTO portuguese_index VALUES ("Dog-fight","n#00974224","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Dogfight","n#00974224","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ultrapassado","NULL","NULL","a#00974519","NULL");
INSERT INTO portuguese_index VALUES ("trunfar","NULL","v#00975202","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogar_trunfo","NULL","v#00975202","NULL","NULL");
INSERT INTO portuguese_index VALUES ("classudo","NULL","NULL","a#00975778","NULL");
INSERT INTO portuguese_index VALUES ("blitzkrieg","n#00975781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerra_relâmpago","n#00975781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Blitzkrieg","n#00975781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("veloz","NULL","NULL","a#00925538 a#00928268 a#00928545 a#00979862","NULL");
INSERT INTO portuguese_index VALUES ("rápida","NULL","NULL","a#00925538","NULL");
INSERT INTO portuguese_index VALUES ("acelerado","NULL","NULL","a#00977105","NULL");
INSERT INTO portuguese_index VALUES ("tocar_trombeta","NULL","v#00977871","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trombetear","NULL","v#00977871","NULL","NULL");
INSERT INTO portuguese_index VALUES ("articular","NULL","v#00662493","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bombardeio","n#00978413 n#00987863","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("instantânea","NULL","NULL","a#00979031","NULL");
INSERT INTO portuguese_index VALUES ("instantâneo","NULL","NULL","a#00979031","NULL");
INSERT INTO portuguese_index VALUES ("célere","NULL","NULL","a#00928545","NULL");
INSERT INTO portuguese_index VALUES ("breve","NULL","NULL","a#00979862 a#01384633","NULL");
INSERT INTO portuguese_index VALUES ("ofensa","n#00630513 n#00794210 n#00794619","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alado","NULL","NULL","a#00980287 a#02566799","NULL");
INSERT INTO portuguese_index VALUES ("guerra_suja","n#00980394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Forças_de_manutenção_da_paz_das_Nações_Unidas","n#00980904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manutenção_da_paz","n#00980904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Boinas_azuis","n#00980904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mandrião","NULL","NULL","a#00981304","NULL");
INSERT INTO portuguese_index VALUES ("balbuciar","NULL","v#00981544 v#00707668","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gaguejar","NULL","v#00981544 v#01802606 v#01802820","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preguisoço","NULL","NULL","a#00930350","NULL");
INSERT INTO portuguese_index VALUES ("ralar","NULL","v#00981814","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cecear","NULL","v#00982178","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flexionar","NULL","v#00982514 v#02036977","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sigint","n#00982852","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("SIGINT","n#00982852","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acentuar","NULL","v#00665390 v#00685448","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emitir","NULL","v#00983824 v#01890772","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exigente","NULL","NULL","a#00932728 a#00933065 a#01189109","NULL");
INSERT INTO portuguese_index VALUES ("detalhista","NULL","NULL","a#00933065","NULL");
INSERT INTO portuguese_index VALUES ("cuidadoso","NULL","NULL","a#00984879","NULL");
INSERT INTO portuguese_index VALUES ("escotismo","n#00634183","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("meticuloso","NULL","NULL","a#00934010 a#01838529","NULL");
INSERT INTO portuguese_index VALUES ("arfar","NULL","v#00986173","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pançudo","NULL","NULL","a#00986457","NULL");
INSERT INTO portuguese_index VALUES ("abdominal","NULL","NULL","a#00986457 a#02934594","NULL");
INSERT INTO portuguese_index VALUES ("gorducho","NULL","NULL","a#00986766","NULL");
INSERT INTO portuguese_index VALUES ("rechonchudo","NULL","NULL","a#00986766","NULL");
INSERT INTO portuguese_index VALUES ("roliço","NULL","NULL","a#00986766","NULL");
INSERT INTO portuguese_index VALUES ("viçosa","NULL","NULL","a#00986975","NULL");
INSERT INTO portuguese_index VALUES ("rechonchuda","NULL","NULL","a#00986975","NULL");
INSERT INTO portuguese_index VALUES ("encorpado","NULL","NULL","a#00987180","NULL");
INSERT INTO portuguese_index VALUES ("corpulento","NULL","NULL","a#00987180 a#00988077","NULL");
INSERT INTO portuguese_index VALUES ("obeso","NULL","NULL","a#00987180 a#00939455","NULL");
INSERT INTO portuguese_index VALUES ("grosso","NULL","NULL","a#00987180 a#01384438 a#00935294 a#02438192","NULL");
INSERT INTO portuguese_index VALUES ("espesso","NULL","NULL","a#00987180 a#02438192 a#02298243","NULL");
INSERT INTO portuguese_index VALUES ("magro","NULL","NULL","a#00936334 a#00989830 a#00938625","NULL");
INSERT INTO portuguese_index VALUES ("tênue","NULL","NULL","a#00936334 a#02415172","NULL");
INSERT INTO portuguese_index VALUES ("dramatizar","NULL","v#00988287","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caudal","n#00988320 n#15277730","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salva","n#00988320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("torrente","n#00988320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saraivada","n#00988320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("voleio","n#00988320","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anoréxico","NULL","NULL","a#00988797","NULL");
INSERT INTO portuguese_index VALUES ("retratar","NULL","v#00668960","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cadavérico","NULL","NULL","a#00936982","NULL");
INSERT INTO portuguese_index VALUES ("fino","NULL","NULL","a#00936982 a#02231896 a#02295611 a#02959553","NULL");
INSERT INTO portuguese_index VALUES ("extenuado","NULL","NULL","a#00936982 a#02433000","NULL");
INSERT INTO portuguese_index VALUES ("fogo_cruzado","n#00990474 n#07134179","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delgado","NULL","NULL","a#00938625","NULL");
INSERT INTO portuguese_index VALUES ("franzino","NULL","NULL","a#00938625","NULL");
INSERT INTO portuguese_index VALUES ("esguio","NULL","NULL","a#00938625 a#01339034","NULL");
INSERT INTO portuguese_index VALUES ("Fogo_amigo","n#00990963","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fogo_amigo","n#00990963","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afixar","NULL","v#00991900 v#01298283 v#00928943 v#01591835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gesticular","NULL","v#00992041","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adipose","NULL","NULL","a#00992133","NULL");
INSERT INTO portuguese_index VALUES ("datação","n#00992331","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gordurento","NULL","NULL","a#00992432","NULL");
INSERT INTO portuguese_index VALUES ("gorduroso","NULL","NULL","a#00992432","NULL");
INSERT INTO portuguese_index VALUES ("oleoso","NULL","NULL","a#00992432 a#01699838","NULL");
INSERT INTO portuguese_index VALUES ("cumprimentar-se","NULL","v#00992518","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Datação_por_radiocarbono","n#00992732","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_gordura","NULL","NULL","a#00992955","NULL");
INSERT INTO portuguese_index VALUES ("escrever","NULL","v#00671763 v#00680967 v#01160885 v#01164896 v#01166173 v#01169420 v#01192426","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nefasto","NULL","NULL","a#00940889","NULL");
INSERT INTO portuguese_index VALUES ("fatal","NULL","NULL","a#00940889 a#00941191","NULL");
INSERT INTO portuguese_index VALUES ("letal","NULL","NULL","a#00941191","NULL");
INSERT INTO portuguese_index VALUES ("terminal","n#04413419","NULL","a#00994073 a#02812147","NULL");
INSERT INTO portuguese_index VALUES ("encriptar","NULL","v#00672235","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fogo_de_supressão","n#00994144","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fogo_de_Supressão","n#00994144","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curável","NULL","NULL","a#00994410 a#01521776","NULL");
INSERT INTO portuguese_index VALUES ("descodificar","NULL","v#00994454","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decifrar","NULL","v#00994454","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incurável","NULL","NULL","a#00994567","NULL");
INSERT INTO portuguese_index VALUES ("transliterar","NULL","v#00672595","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Medidas_de_ataque_eletrônico","n#00995134","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Medidas_de_Ataque_Eletrônico","n#00995134","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reescrever","NULL","v#00995838","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escrever_novamente","NULL","v#00995838","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indulgente","NULL","NULL","a#00944158 a#01297315 a#01763159","NULL");
INSERT INTO portuguese_index VALUES ("partidário","NULL","NULL","a#00944158","NULL");
INSERT INTO portuguese_index VALUES ("Jihad","n#00996513","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jihad","n#00996673","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerra_mundial","n#00996817","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mensuração","n#00643864","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("medição","n#00643864 n#06864725","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contra-assinar","NULL","v#00997432","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endossar","NULL","v#00674764","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coassinar","NULL","v#00998030","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gravar","NULL","v#00675051 v#00677013 v#00677950 v#00678373 v#01195497 v#01768630","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Antropometria","n#00998604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antropometria","n#00998604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("audiometria","n#00998982","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Audiometria","n#00998982","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sobrescrever","NULL","v#00999079","NULL","NULL");
INSERT INTO portuguese_index VALUES ("batimetria","n#00999089","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calibração","n#00999245","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afinação","n#00999588","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ajustagem","n#00999787","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reajuste","n#00999787","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deletar","NULL","v#00676082 v#01066739","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alinhamento","n#01000068 n#05077146","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("registar","NULL","v#00676476 v#00899510","NULL","NULL");
INSERT INTO portuguese_index VALUES ("temperamento_igual","n#01000610","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desgracioso","NULL","NULL","a#01001180","NULL");
INSERT INTO portuguese_index VALUES ("Camber","n#01001344","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vocalização","n#01001640","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arquivar","NULL","v#01001643 v#01384638","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fecundo","NULL","NULL","a#00950068 a#01002055 a#01027790 a#01794787","NULL");
INSERT INTO portuguese_index VALUES ("fértil","NULL","NULL","a#00950068 a#01002055 a#01027790 a#01028986 a#01794787","NULL");
INSERT INTO portuguese_index VALUES ("calorimetria","n#01001814","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Calorimetria","n#01001814","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("andar_enfileirado","NULL","v#01001857","NULL","NULL");
INSERT INTO portuguese_index VALUES ("andar_em_fila","NULL","v#01001857","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cefalometria","n#01001923","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cefalometria","n#01001923","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("densitometria","n#01002008","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dosimetria","n#01002165","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fertilizável","NULL","NULL","a#01002170","NULL");
INSERT INTO portuguese_index VALUES ("improdutivo","NULL","NULL","a#01029715","NULL");
INSERT INTO portuguese_index VALUES ("infértil","NULL","NULL","a#01029715 a#00951040","NULL");
INSERT INTO portuguese_index VALUES ("estéril","NULL","NULL","a#01029715 a#00951040 a#01191747 a#02041174","NULL");
INSERT INTO portuguese_index VALUES ("Gravimetria","n#01002413","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hidrometria","n#01002413","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colocar_no_diário","NULL","v#00677950","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colocar_no_registro","NULL","v#00677950","NULL","NULL");
INSERT INTO portuguese_index VALUES ("registrar","NULL","v#00677950 v#01020356 v#01464543 v#01683922 v#01684156","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lançar","NULL","v#00677950 v#00846245 v#00847023 v#01035130 v#01035585 v#01036035 v#01038983 v#01040233 v#01514655 v#01515196 v#01328739 v#01396032 v#01699581","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hipsometria","n#01002554","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filmar","NULL","v#01002740 v#01711965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gravar_em_fita_de_vídeo","NULL","v#00678373","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tirar_foto","NULL","v#00678482","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fotografar","NULL","v#00678482","NULL","NULL");
INSERT INTO portuguese_index VALUES ("citofotometria","n#01003435","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Quantificacao","n#01003570","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quantificação","n#01003570","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divergência","n#01004072 n#05863302","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sublinhar","NULL","v#01004235 v#00686083","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interminado","NULL","NULL","a#01004318 a#01005675","NULL");
INSERT INTO portuguese_index VALUES ("escrever_à_máquina","NULL","v#01004692","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pendente","NULL","NULL","a#00952879","NULL");
INSERT INTO portuguese_index VALUES ("terminado","NULL","NULL","a#01005063","NULL");
INSERT INTO portuguese_index VALUES ("finalizado","NULL","NULL","a#01005063","NULL");
INSERT INTO portuguese_index VALUES ("acabado","NULL","NULL","a#01005063","NULL");
INSERT INTO portuguese_index VALUES ("espirometria","n#01005473","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Espirometria","n#01005473","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engenharia_cartográfica","n#00406027","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("explicitar","NULL","v#00680102","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eletromiografia","n#01006054","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mamografia","n#01006188","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rabiscar","NULL","v#01006239","NULL","NULL");
INSERT INTO portuguese_index VALUES ("termografia","n#01006313","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criar_um_rascunho","NULL","v#01006421","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limitado","NULL","NULL","a#01006566","NULL");
INSERT INTO portuguese_index VALUES ("finito","NULL","NULL","a#01006566 a#01008439","NULL");
INSERT INTO portuguese_index VALUES ("corresponder-se","NULL","v#01006810","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corresponder","NULL","v#01006810","NULL","NULL");
INSERT INTO portuguese_index VALUES ("telegrafar","NULL","v#01007222","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ilimitado","NULL","NULL","a#00955713 a#01008289 a#01844500","NULL");
INSERT INTO portuguese_index VALUES ("teste_de_Rorschach","n#01007907","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Teste_de_rorschach","n#01007907","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tornar_a_somar","NULL","v#00681575 v#02752695","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infinita","NULL","NULL","a#01008174 a#01382215","NULL");
INSERT INTO portuguese_index VALUES ("infindável","NULL","NULL","a#01008174 a#01382215","NULL");
INSERT INTO portuguese_index VALUES ("recapitular","NULL","v#01008903","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inaugural","NULL","NULL","a#00957396","NULL");
INSERT INTO portuguese_index VALUES ("formalização","n#01009637","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ordenação","n#00651563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("final","n#05438448","NULL","a#00958252 a#01523143","NULL");
INSERT INTO portuguese_index VALUES ("sequência","n#00651987 n#03938674 n#04823659 n#06246946 n#06247375","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alternação","n#00652141","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("layout","n#00652266","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("literacia","n#01011028","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arquetípico","NULL","NULL","a#01011392","NULL");
INSERT INTO portuguese_index VALUES ("inventários_(elaboração)","n#00652628","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chamada","n#00652802 n#05328790","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reafirmar","NULL","v#01011923","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reafirmar-se","NULL","v#01011923","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inicial","NULL","NULL","a#00959792","NULL");
INSERT INTO portuguese_index VALUES ("agrupamento","n#00653260","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("original","NULL","NULL","a#00960367 a#01626576 a#01627275","NULL");
INSERT INTO portuguese_index VALUES ("homologar","NULL","v#00684839","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ratificar","NULL","v#00684839","NULL","NULL");
INSERT INTO portuguese_index VALUES ("classificação","n#00653558 n#00656397 n#04425786 n#05955891 n#09752695","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sistemas_de_classificação","n#00653558","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sortimento","n#00653558","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("categorização","n#00653558 n#04425786 n#05955891","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reconfirmar","NULL","v#01012905","NULL","NULL");
INSERT INTO portuguese_index VALUES ("primeira","NULL","NULL","a#00960836","NULL");
INSERT INTO portuguese_index VALUES ("depor","NULL","v#01013040","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estratificação","n#01013604 n#13562328","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taxonomia","n#01013770 n#06153186 n#08378356","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tipologia","n#01013971","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agregaçao","n#00654309","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incidir","NULL","v#00685764","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intermédio","NULL","NULL","a#00963005","NULL");
INSERT INTO portuguese_index VALUES ("aglomeração","n#01014490 n#05963394 n#07959269 n#06225016","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ordem_alfabética","n#01014607","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compilação","n#01014731 n#06592844 n#06593099","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("testemunhar","NULL","v#01014821","NULL","NULL");
INSERT INTO portuguese_index VALUES ("meio_caminho","NULL","NULL","a#01014838","NULL");
INSERT INTO portuguese_index VALUES ("metade_do_caminho","NULL","NULL","a#01014838","NULL");
INSERT INTO portuguese_index VALUES ("entre_dois_extremos","NULL","NULL","a#00963684","NULL");
INSERT INTO portuguese_index VALUES ("intermediário","n#09777012","NULL","a#00963684","NULL");
INSERT INTO portuguese_index VALUES ("centralização","n#01015175 n#01237872","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penúltimo","NULL","NULL","a#01015185 a#00962104","NULL");
INSERT INTO portuguese_index VALUES ("colheita","n#00655017 n#09380644","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("secundarista","NULL","NULL","a#01015599","NULL");
INSERT INTO portuguese_index VALUES ("secundanista","NULL","NULL","a#01015599","NULL");
INSERT INTO portuguese_index VALUES ("Conquiliologia","n#01015689","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recolha_de_lixo","n#01015843","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coletor_de_lixo","n#01015843 n#10120330","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aduzir","NULL","v#00686832 v#01449236","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alegar","NULL","v#00686832 v#00686932","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antepenúltimo","NULL","NULL","a#00961599","NULL");
INSERT INTO portuguese_index VALUES ("recolha","n#01016201","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apelar","NULL","v#01016316 v#01701639 v#02497824","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Designers_de_selos","n#00656057","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filatelia","n#00656057","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segundo","n#10543057 n#10944012 n#10952516 n#10952736 n#10953446 n#10953688 n#10953874","NULL","a#00964638 a#02104904","NULL");
INSERT INTO portuguese_index VALUES ("aerofilatelia","n#01016628","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrecadação","n#01016748","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sustentar","NULL","v#00687441 v#00805632 v#00830295 v#01210323 v#01816870","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triagem","n#01017167","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("são","NULL","NULL","a#00965604 a#01121949 a#02073443 a#02164003","NULL");
INSERT INTO portuguese_index VALUES ("prosseguimento","n#00657384","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aflito","NULL","NULL","a#01018264","NULL");
INSERT INTO portuguese_index VALUES ("reivindicar","NULL","v#00688439 v#02275365","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prolongamento","n#01018366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repetição","n#00657820 n#05120310 n#05311563 n#05470763 n#05471216 n#07343363","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aleijado","NULL","NULL","a#01018788","NULL");
INSERT INTO portuguese_index VALUES ("perneta","NULL","NULL","a#01018788","NULL");
INSERT INTO portuguese_index VALUES ("estropiado","NULL","NULL","a#01018788","NULL");
INSERT INTO portuguese_index VALUES ("capenga","NULL","NULL","a#01018788 a#02325304 a#02404081","NULL");
INSERT INTO portuguese_index VALUES ("manco","NULL","NULL","a#01018788 a#02325304","NULL");
INSERT INTO portuguese_index VALUES ("coxo","n#09978889","NULL","a#01018788","NULL");
INSERT INTO portuguese_index VALUES ("estipule","NULL","v#01018928 v#01019472","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ecolalia","n#01018951","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ecolalia","n#01018951 n#07200421","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("iteração","n#01019129","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("redundância","n#01019248 n#05120310 n#07090938","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deficiente_físico","NULL","NULL","a#01019283","NULL");
INSERT INTO portuguese_index VALUES ("deficiente","NULL","NULL","a#01019283","NULL");
INSERT INTO portuguese_index VALUES ("reiteração","n#01019372","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estipular","NULL","v#01019472","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convencionar","NULL","v#01019472","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acto_de_copiar","n#00658241","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cópia","n#00658241 n#02498378 n#02509368 n#04609235 n#04882005","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("replicação","n#01019703 n#03229727","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("duplicação","n#01019703 n#03257343","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frouxo","NULL","NULL","a#01019713","NULL");
INSERT INTO portuguese_index VALUES ("brando","NULL","NULL","a#01019713 a#01108119","NULL");
INSERT INTO portuguese_index VALUES ("mole","NULL","NULL","a#01019713 a#01105979 a#02328483","NULL");
INSERT INTO portuguese_index VALUES ("flácido","NULL","NULL","a#01019713 a#01105979","NULL");
INSERT INTO portuguese_index VALUES ("fofo","NULL","NULL","a#01019713 a#01154030 a#01105979","NULL");
INSERT INTO portuguese_index VALUES ("remarcar","NULL","v#00689564","NULL","NULL");
INSERT INTO portuguese_index VALUES ("notar","NULL","v#00689564 v#00717811 v#01449939","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comentar","NULL","v#00689564 v#01033189 v#00717396","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alta_fidelidade","n#01020488","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sair_apressado","NULL","v#01020594","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sair_a_toda","NULL","v#01020594","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encorpar","NULL","v#00690164","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anotar","NULL","v#00690367 v#01169236","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Imitação","n#01020936","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emulação","n#01021270","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("persistência","n#00659771 n#03811466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perseverança","n#00659771","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indecoroso","NULL","NULL","a#01021607","NULL");
INSERT INTO portuguese_index VALUES ("arranjar","NULL","v#00690810 v#01004644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("providenciar","NULL","v#00690810","NULL","NULL");
INSERT INTO portuguese_index VALUES ("particularizar","NULL","v#00691100","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dobrável","NULL","NULL","a#00969996","NULL");
INSERT INTO portuguese_index VALUES ("generalizar","NULL","v#00691426 v#00691749","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descontinuação","n#00660117","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("citar","NULL","v#00692018 v#01023574 v#00692561 v#01169330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inflexível","NULL","NULL","a#01023289 a#01024597 a#01025913 a#00976417","NULL");
INSERT INTO portuguese_index VALUES ("processo","n#00660588 n#00660718 n#00765298 n#01182654 n#00775506 n#00776884","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rígido","NULL","NULL","a#00971439 a#01508672","NULL");
INSERT INTO portuguese_index VALUES ("rígida","NULL","NULL","a#00971439","NULL");
INSERT INTO portuguese_index VALUES ("teso","NULL","NULL","a#00971439","NULL");
INSERT INTO portuguese_index VALUES ("cotar","NULL","v#01023925 v#01605484","NULL","NULL");
INSERT INTO portuguese_index VALUES ("levantamentos_cartográficos","n#01024643","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("procedimento_operativo","n#01024811","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intransigente","NULL","NULL","a#00972485","NULL");
INSERT INTO portuguese_index VALUES ("invocar","NULL","v#01024864","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Procedimento_operacional_padrão","n#01024968","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Procedimento_Operacional_Padrão","n#01024968","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ereção","n#01025411 n#14038185","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desenterrar","NULL","v#00693918 v#02143539 v#02286550","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nomear","NULL","v#00694228 v#00696267 v#01632168 v#01632536 v#01635578 v#01636187 v#01686884","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rotina","n#00662121","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ramerrão","n#00662121","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_alusã_oa","NULL","v#00694753","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cerimônia","n#01026897 n#00662816 n#05539741","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ajustável","NULL","NULL","a#01027263 a#01027686","NULL");
INSERT INTO portuguese_index VALUES ("opinar","NULL","v#00695551","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ser_de_opinião","NULL","v#00695551","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rito","n#00663366 n#00664709","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ritual","n#00663366 n#00665779 n#06416049","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("baptizar","NULL","v#00695868","NULL","NULL");
INSERT INTO portuguese_index VALUES ("batizar","NULL","v#00695868 v#00696177","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cerimônia_religiosa","n#01028082","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("denominar","NULL","v#00696029 v#00696267 v#00697540","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intitular","NULL","v#00696029 v#00697050","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apelidar","NULL","v#00696177","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adoração","n#01028655 n#01043989","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exaltação","n#01029114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apoteose","n#01029114 n#07416028","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mudar_de_nome","NULL","v#01029212","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebatizar","NULL","v#01029212","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rebaptizar","NULL","v#01029212","NULL","NULL");
INSERT INTO portuguese_index VALUES ("renomear","NULL","v#01029212 v#02396981","NULL","NULL");
INSERT INTO portuguese_index VALUES ("liturgia","n#00664709 n#00667300 n#01035853","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vigília","n#01029671 n#07380622","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rotular","NULL","v#01029852 v#01588493","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cacheado","NULL","NULL","a#01030022","NULL");
INSERT INTO portuguese_index VALUES ("crespo","NULL","NULL","a#01030372","NULL");
INSERT INTO portuguese_index VALUES ("excomungar","NULL","v#00697695 v#02402112","NULL","NULL");
INSERT INTO portuguese_index VALUES ("em_ondas","NULL","NULL","a#01030691","NULL");
INSERT INTO portuguese_index VALUES ("enviar","NULL","v#00698219 v#00720562 v#00985091 v#01437597 v#01437888 v#01328437 v#01328739 v#01329795 v#01331285 v#01955508 v#02231661 v#01543212 v#01603572","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Naturismo","n#01031563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nudismo","n#01031563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("naturismo","n#01031563","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("travestismo","n#01031858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aborígena","NULL","NULL","a#00983275","NULL");
INSERT INTO portuguese_index VALUES ("adotivo","NULL","NULL","a#01034296 a#01406263 a#01406418","NULL");
INSERT INTO portuguese_index VALUES ("adotado","NULL","NULL","a#01034296","NULL");
INSERT INTO portuguese_index VALUES ("adoptivo","NULL","NULL","a#01034296 a#01406263 a#01406418","NULL");
INSERT INTO portuguese_index VALUES ("discursar","NULL","v#01034312","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacramento","n#00668363","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intimidar","NULL","v#01035199 v#01214618 v#01781180 v#01219733 v#01819554","NULL","NULL");
INSERT INTO portuguese_index VALUES ("A_Última_Ceia","n#01035504","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sêder_de_Pessach","n#01035667","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pactuar","NULL","v#00701304","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chegar_a_um_meio-termo","NULL","v#00701304","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Liturgia","n#01035853","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arriscar","NULL","v#00701625 v#01734987 v#02545272 v#01735720 v#01839881","NULL","NULL");
INSERT INTO portuguese_index VALUES ("oriundo","NULL","NULL","a#00985314","NULL");
INSERT INTO portuguese_index VALUES ("endémico","NULL","NULL","a#00985314 a#01427757","NULL");
INSERT INTO portuguese_index VALUES ("endêmico","NULL","NULL","a#00985314 a#01106815 a#01427757","NULL");
INSERT INTO portuguese_index VALUES ("esponsais","n#00670127","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("noivado","n#00670127 n#07228211","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tagarelar","NULL","v#00702218 v#01065630","NULL","NULL");
INSERT INTO portuguese_index VALUES ("casamento","n#00669682 n#00669775 n#01037469 n#07228211 n#05540443 n#05985550 n#06130826 n#10061309","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aborígene","n#09676490","NULL","a#01037148 a#02599509","NULL");
INSERT INTO portuguese_index VALUES ("indígena","n#06967275","NULL","a#01037148","NULL");
INSERT INTO portuguese_index VALUES ("Ritos_de_passagem","n#01037294","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ritos_de_passagem","n#01037294","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("do_casamento","n#01037469","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extrangeiro","NULL","NULL","a#00986373","NULL");
INSERT INTO portuguese_index VALUES ("alienígena","n#09484465","NULL","a#00986373","NULL");
INSERT INTO portuguese_index VALUES ("casamento_civil","n#01037577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ao_estrangeiro","NULL","NULL","a#01037763","NULL");
INSERT INTO portuguese_index VALUES ("batismo","n#00670476 n#00671096","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("internacional","NULL","NULL","a#00986718 a#01512129","NULL");
INSERT INTO portuguese_index VALUES ("domesticado","NULL","NULL","a#00986917","NULL");
INSERT INTO portuguese_index VALUES ("domesticada","NULL","NULL","a#00986917","NULL");
INSERT INTO portuguese_index VALUES ("doméstica","NULL","NULL","a#00986917 a#02695515","NULL");
INSERT INTO portuguese_index VALUES ("Efusão","n#01038147","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aspersão","n#01038261","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nacional","NULL","NULL","a#00987147 a#01056006 a#01511652 a#01790832 a#02750618 a#02750785 a#02750888","NULL");
INSERT INTO portuguese_index VALUES ("baptismo","n#00671096","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("autárquico","NULL","NULL","a#00987395","NULL");
INSERT INTO portuguese_index VALUES ("municipal","NULL","NULL","a#00987395 a#02547019","NULL");
INSERT INTO portuguese_index VALUES ("bater_papo","NULL","v#00703394","NULL","NULL");
INSERT INTO portuguese_index VALUES ("papear","NULL","v#00703394","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Crisma","n#00671188","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("crisma","n#00671188 n#04486906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confirmação","n#00671188 n#05824739 n#04486906 n#04986937","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("doméstico","NULL","NULL","a#00987605 a#02695515","NULL");
INSERT INTO portuguese_index VALUES ("penitência","n#01039140 n#01165537 n#07536870","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Penitência","n#01039140","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confissão","n#00671737 n#04861370 n#05390481","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conversar_por_sinais","NULL","v#00703699","NULL","NULL");
INSERT INTO portuguese_index VALUES ("santificação","n#01039925","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beatificação","n#01040128 n#01040390","NULL","a#01130614","NULL");
INSERT INTO portuguese_index VALUES ("que_pode_ser_esquecido","NULL","NULL","a#01040239","NULL");
INSERT INTO portuguese_index VALUES ("esquecível","NULL","NULL","a#01040239","NULL");
INSERT INTO portuguese_index VALUES ("canonização","n#01040390","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Canonização","n#01040390","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inesquecível","NULL","NULL","a#00989449","NULL");
INSERT INTO portuguese_index VALUES ("consagração","n#00672889","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("memorável","NULL","NULL","a#01040752","NULL");
INSERT INTO portuguese_index VALUES ("digna_de_recordação","NULL","NULL","a#01040752","NULL");
INSERT INTO portuguese_index VALUES ("calar-se","NULL","v#00704873","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calar_a_boca","NULL","v#00704873","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vingativo","NULL","NULL","a#01041634","NULL");
INSERT INTO portuguese_index VALUES ("libação","n#01041835","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ceremonioso","NULL","NULL","a#00990821","NULL");
INSERT INTO portuguese_index VALUES ("formal","NULL","NULL","a#00990821 a#01573544","NULL");
INSERT INTO portuguese_index VALUES ("carola","n#01041968","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("difundir_idéias","NULL","v#01042228","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espalhar_rumores","NULL","v#01042228","NULL","NULL");
INSERT INTO portuguese_index VALUES ("missa","n#00674047 n#05274220","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("solene","NULL","NULL","a#00991360 a#00991505 a#02044251","NULL");
INSERT INTO portuguese_index VALUES ("uivar","NULL","v#00706217 v#01046059 v#00710694","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bhakti","n#01042998","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("novena","n#01043189","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Via_Crucis","n#01043333","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Via_Crúcis","n#01043333","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Via_crúcis","n#01043333","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assoviar","NULL","v#01043441 v#02183626","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assobiar","NULL","v#01043441 v#01043887 v#01053771","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bênção","n#00674885 n#05373317 n#05373820 n#10382904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apitar","NULL","v#01043887 v#02183626","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sibilar","NULL","v#01043887 v#01054186 v#02188198","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adorar","n#01043989 n#00675531","v#01212539 v#01213998 v#01778017 v#01214483","NULL","NULL");
INSERT INTO portuguese_index VALUES ("idolatria","n#01044084","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("informal","NULL","NULL","a#01044240 a#01045711 a#01634027 a#02045369","NULL");
INSERT INTO portuguese_index VALUES ("veneração","n#00675531","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gemir","n#05332420","v#00708262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("carpir","NULL","v#00708262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lamentar-se","NULL","v#00708262","NULL","NULL");
INSERT INTO portuguese_index VALUES ("literário","NULL","NULL","a#00994136 a#01364640 a#02625317","NULL");
INSERT INTO portuguese_index VALUES ("rosnar","NULL","v#01045719","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coloquial","NULL","NULL","a#00994581","NULL");
INSERT INTO portuguese_index VALUES ("rugir","NULL","v#01046059 v#00710694 v#00712888","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vernáculo","NULL","NULL","a#00994826","NULL");
INSERT INTO portuguese_index VALUES ("vernáculo","NULL","NULL","a#00994826","NULL");
INSERT INTO portuguese_index VALUES ("heliolatria","n#01046348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ulular","NULL","v#00709311","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bramir","NULL","v#00709311 v#00710694","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ressurgência","n#01047338","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revitalização","n#01047338","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ressurreição","n#01047338 n#00678641","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("última","NULL","NULL","a#00996053","NULL");
INSERT INTO portuguese_index VALUES ("latir","NULL","v#00709901","NULL","NULL");
INSERT INTO portuguese_index VALUES ("renascimento","n#00678421","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afortunado","NULL","NULL","a#01047874 a#01468097","NULL");
INSERT INTO portuguese_index VALUES ("regeneração","n#00678537 n#09697656","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ressuscitação","n#01048210","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("balir","NULL","v#01048330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fortuito","NULL","NULL","a#01048587 a#01285892 a#01349435","NULL");
INSERT INTO portuguese_index VALUES ("ocultação","n#01048912","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sortudo","NULL","NULL","a#01049210 a#01468097","NULL");
INSERT INTO portuguese_index VALUES ("sortuda","NULL","NULL","a#01049210 a#01468097","NULL");
INSERT INTO portuguese_index VALUES ("camuflagem","n#01049266 n#02944459 n#04679074","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cantarolar","NULL","v#01049470 v#01055829","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abjeto","NULL","NULL","a#01049941","NULL");
INSERT INTO portuguese_index VALUES ("desastroso","NULL","NULL","a#00999773","NULL");
INSERT INTO portuguese_index VALUES ("mendigo","n#07106951 n#07107212","NULL","a#01050603","NULL");
INSERT INTO portuguese_index VALUES ("mendiga","NULL","NULL","a#01050603","NULL");
INSERT INTO portuguese_index VALUES ("sem-abrigo","NULL","NULL","a#01050603","NULL");
INSERT INTO portuguese_index VALUES ("sem-teto","n#13943053","NULL","a#01050603","NULL");
INSERT INTO portuguese_index VALUES ("cantar_à_tirolesa","NULL","v#01050651","NULL","NULL");
INSERT INTO portuguese_index VALUES ("miserável","NULL","NULL","a#01000655 a#01102092 a#02235465","NULL");
INSERT INTO portuguese_index VALUES ("lastimoso","NULL","NULL","a#01000655","NULL");
INSERT INTO portuguese_index VALUES ("coitado","NULL","NULL","a#01000655","NULL");
INSERT INTO portuguese_index VALUES ("pobre","NULL","NULL","a#01000655 a#01951368","NULL");
INSERT INTO portuguese_index VALUES ("Lavagem_de_Dinheiro","n#01051221","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lavagem_de_dinheiro","n#01051221","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("posicionamento","n#00680814","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("declamar","NULL","v#00712534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("citar_novamente","NULL","v#00712534","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lamentável","NULL","NULL","a#01001630 a#01312607 a#01139868 a#01732472 a#02235465","NULL");
INSERT INTO portuguese_index VALUES ("cheiroso","NULL","NULL","a#01052248 a#01052611 a#01736947","NULL");
INSERT INTO portuguese_index VALUES ("fragrante","NULL","NULL","a#01052248","NULL");
INSERT INTO portuguese_index VALUES ("aromática","NULL","NULL","a#01052248","NULL");
INSERT INTO portuguese_index VALUES ("perfumado","NULL","NULL","a#01052248 a#01052611","NULL");
INSERT INTO portuguese_index VALUES ("cricrilar","NULL","v#01052301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chilrear","NULL","v#01052301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pipilar","NULL","v#01052301 v#01053623","NULL","NULL");
INSERT INTO portuguese_index VALUES ("piar","NULL","v#01052301 v#01053623 v#01730663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trinar","NULL","v#01052301 v#01730663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gorjear","NULL","v#01052301 v#01053623","NULL","NULL");
INSERT INTO portuguese_index VALUES ("plantações","n#01052450","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("miar","NULL","v#01052782","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ronronar","NULL","v#00713508 v#02188587","NULL","NULL");
INSERT INTO portuguese_index VALUES ("malcheiroso","NULL","NULL","a#01053144 a#01053634 a#01627049","NULL");
INSERT INTO portuguese_index VALUES ("fedorento","NULL","NULL","a#01053144 a#01053634 a#01127782 a#01627049","NULL");
INSERT INTO portuguese_index VALUES ("dedilhação","n#01053207","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dedilhamento","n#01053207","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("digitação","n#01053207","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("buzinar","NULL","v#01053339 v#01053495","NULL","NULL");
INSERT INTO portuguese_index VALUES ("permanência","n#00682063 n#03944434 n#10859737","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guinchar","NULL","v#01053623","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fétido","NULL","NULL","a#01053634 a#01054832","NULL");
INSERT INTO portuguese_index VALUES ("chiar","NULL","v#01053771","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bolorento","NULL","NULL","a#01003225 a#01070088","NULL");
INSERT INTO portuguese_index VALUES ("habitação","n#00682217 n#00682554 n#02275625 n#02618194 n#02837386 n#02933800","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alojamentos_temporários","n#01054227","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("locação","n#00682434","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contubérnio","n#00682697","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coabitação","n#00682697","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ranço","NULL","NULL","a#01003861 a#01017083","NULL");
INSERT INTO portuguese_index VALUES ("rançoso","NULL","NULL","a#01003861 a#01017083","NULL");
INSERT INTO portuguese_index VALUES ("acampamento","n#00682920 n#02372560 n#02945161 n#02373172 n#02842353 n#06258431 n#06282697","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trilar","NULL","v#01055266","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estadia","n#00683061","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trautear","NULL","v#01055829","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abastecimento","n#00684444","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fornecimento","n#00684444 n#01060234 n#09726614 n#13777344","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rega","n#01057631","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inodoro","NULL","NULL","a#01057775","NULL");
INSERT INTO portuguese_index VALUES ("crepitar","NULL","v#01058224 v#02175384","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alimentação_forçada","n#01058291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gavagem","n#01058291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_comentários","NULL","v#00717396","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amamentação","n#01058870","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conjugado","n#13729732","NULL","a#01059252","NULL");
INSERT INTO portuguese_index VALUES ("fixada","NULL","NULL","a#01059400","NULL");
INSERT INTO portuguese_index VALUES ("fixado","NULL","NULL","a#01059400","NULL");
INSERT INTO portuguese_index VALUES ("fixa","NULL","NULL","a#01059400","NULL");
INSERT INTO portuguese_index VALUES ("esnobar","NULL","v#00717937","NULL","NULL");
INSERT INTO portuguese_index VALUES ("firme","NULL","NULL","a#01059711 a#02191804","NULL");
INSERT INTO portuguese_index VALUES ("relinchar","NULL","v#01059743","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cuidados_de_saúde","n#01059900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("seguro-saúde","n#01059900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Assistência_médica","n#01059900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("geoestacionário","NULL","NULL","a#01059911","NULL");
INSERT INTO portuguese_index VALUES ("emissão","n#01060234 n#04964806 n#13367593 n#09679767 n#10653495","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estacionário","NULL","NULL","a#01060445 a#01462629 a#01565252","NULL");
INSERT INTO portuguese_index VALUES ("Logística","n#01060745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("logística","n#01060745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Logistica","n#01060745","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("subvenção","n#00686316 n#13267014 n#09547118","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demanda","n#00686428 n#09725817","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exprimir","NULL","v#00719571","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_a_bainha","NULL","v#01061799","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bainhar","NULL","v#01061799","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sinistro","n#01061945","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sinistro","n#01061945","NULL","a#01132515","NULL");
INSERT INTO portuguese_index VALUES ("autônoma","NULL","NULL","a#01009075","NULL");
INSERT INTO portuguese_index VALUES ("autonômico","NULL","NULL","a#01009075 a#02401440","NULL");
INSERT INTO portuguese_index VALUES ("fuga_de_cérebros","n#01062468","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remeter","NULL","v#00720562 v#00985091 v#01437888 v#00985935","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ociosidade","n#01062583 n#01065441","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intervalo","n#00687670 n#04588587 n#06016276 n#06858779 n#15269513 n#15272887","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("definido","NULL","NULL","a#01062938","NULL");
INSERT INTO portuguese_index VALUES ("Semana_do_saco_cheio","n#01063234","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hesitação","n#00687997 n#04645599 n#04645943","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compartilhar","NULL","v#00721709 v#01569784 v#01856887","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espera","n#00688424","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("relaxação","n#00688597","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repouso","n#00688597 n#05587497 n#10972097","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indolência","n#01064613","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dormência","n#01064863 n#14322528","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprisionado","NULL","NULL","a#01065126","NULL");
INSERT INTO portuguese_index VALUES ("cativado","NULL","NULL","a#01065126","NULL");
INSERT INTO portuguese_index VALUES ("lazer","n#00689161 n#10863399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Lazer","n#00689161","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("férias","n#01065687 n#15118453 n#15137425 n#15137556 n#10863595","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atraso","n#00689955 n#01067577 n#04366760 n#15275598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adiar","n#00689955","v#01653732 v#01803891 v#01804043 v#01804260","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pensar_duas_vezes","NULL","v#01066292","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atacar_de_frente","NULL","v#01066433","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predominante","NULL","NULL","a#01013974","NULL");
INSERT INTO portuguese_index VALUES ("adiamento","n#01066881 n#01067070 n#10970463","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deferimento","n#01067070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infrequente","NULL","NULL","a#01067193","NULL");
INSERT INTO portuguese_index VALUES ("infreqüente","NULL","NULL","a#01067193","NULL");
INSERT INTO portuguese_index VALUES ("infrequënte","NULL","NULL","a#01067193","NULL");
INSERT INTO portuguese_index VALUES ("procrastinação","n#01067362","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("operação_tartaruga","n#01067577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fresco","NULL","NULL","a#01014707 a#01302469 a#01627275 a#02407953","NULL");
INSERT INTO portuguese_index VALUES ("recente","NULL","NULL","a#01014707 a#01018698 a#01582587 a#01583415 a#01666848","NULL");
INSERT INTO portuguese_index VALUES ("efervecente","NULL","NULL","a#01068104","NULL");
INSERT INTO portuguese_index VALUES ("estaladiço","NULL","NULL","a#01068104","NULL");
INSERT INTO portuguese_index VALUES ("crocante","NULL","NULL","a#01068104","NULL");
INSERT INTO portuguese_index VALUES ("congelante","NULL","NULL","a#01068104","NULL");
INSERT INTO portuguese_index VALUES ("interpolação","n#00691229 n#05802730","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intervenção","n#00691229 n#00805766","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interjeição","n#00691229 n#07125958","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abstinência","n#00691683 n#03824571","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recato","n#01069125","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pudicícia","n#01069125","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("celibato","n#01069125 n#13967507","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("castidade","n#01069125 n#03800842","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pútrido","NULL","NULL","a#01069187","NULL");
INSERT INTO portuguese_index VALUES ("auto-controle","n#01069578","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("auto-monitorização","n#01069578","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abstemia","n#00692239","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jejum","n#01069980","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dieta","n#01070187 n#05617748 n#05618089 n#05618405","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("râncido","NULL","NULL","a#01017083","NULL");
INSERT INTO portuguese_index VALUES ("controlo_do_tráfego","n#01070432","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inibição","n#00692957 n#03825629","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tolerância","n#00693087 n#03657928 n#03658162 n#03929954 n#04703024","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("leniência","n#01071213","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clemência","n#00693354","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perdão","n#00693354 n#00795926 n#00811226 n#04919295 n#05616059","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("misericórdia","n#00693354 n#01227495 n#03785586 n#03785836 n#14474435","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delícia","n#00693635","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prazer","n#00693635 n#04490585 n#05568771 n#07491038","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("luto","n#01072236 n#14718822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("competir","NULL","v#00727087 v#01122194 v#02672187","NULL","NULL");
INSERT INTO portuguese_index VALUES ("satisfação","n#00694042 n#05598965 n#05599694 n#10075968","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gratificação","n#01072780","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salgada","NULL","NULL","a#01021767","NULL");
INSERT INTO portuguese_index VALUES ("interferência","n#00694910","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impedimento","n#00694910 n#04395690","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antagonismo","n#01074252 n#07548366 n#13860548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amistoso","NULL","NULL","a#01022285","NULL");
INSERT INTO portuguese_index VALUES ("amigo","n#07060310 n#07128110 n#07128451 n#07172243 n#07280379","NULL","a#01022285","NULL");
INSERT INTO portuguese_index VALUES ("amigável","NULL","NULL","a#01022285 a#01195116","NULL");
INSERT INTO portuguese_index VALUES ("cerco","n#00695744","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assédio","n#00695744","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sítio","n#00695744 n#02666240 n#06359193","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amável","NULL","NULL","a#01022795 a#01133876 a#01086370 a#01318368","NULL");
INSERT INTO portuguese_index VALUES ("afável","NULL","NULL","a#01022795 a#01133876 a#01086370","NULL");
INSERT INTO portuguese_index VALUES ("paralização","n#00696570","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("complicação","n#01076359 n#04766620 n#13933221","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("social","NULL","NULL","a#01024073 a#02141600 a#02145689 a#02149785 a#02603799 a#02604008","NULL");
INSERT INTO portuguese_index VALUES ("carrancudo","NULL","NULL","a#01077158","NULL");
INSERT INTO portuguese_index VALUES ("frio","n#04629604 n#03916773 n#05015463 n#05015678 n#03917363 n#04422784 n#07786705","NULL","a#02409908 a#01199751 a#02408499 a#01206050 a#01206648 a#02407953 a#02531422","NULL");
INSERT INTO portuguese_index VALUES ("rocar","NULL","v#01077329","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prevenção","n#00697202","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escolher_ao_acaso","NULL","v#00731520","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sortear","NULL","v#00731520","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intercepção","n#01078279","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("congelado","NULL","NULL","a#01078302","NULL");
INSERT INTO portuguese_index VALUES ("gelado","n#07614500","NULL","a#01078302 a#01200711 a#01253592 a#01206648","NULL");
INSERT INTO portuguese_index VALUES ("encarar","NULL","v#00732096 v#01459552 v#01751966 v#02693691","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profilaxia","n#01079295","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("supressão","n#00697514","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repressão","n#00697514 n#09723333 n#10083617","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frutífero","NULL","NULL","a#01027790","NULL");
INSERT INTO portuguese_index VALUES ("proveitoso","NULL","NULL","a#01027790 a#01944327","NULL");
INSERT INTO portuguese_index VALUES ("ação_em_grupo","n#01080366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("produtivo","NULL","NULL","a#01028535 a#01793947 a#01796064 a#02221280","NULL");
INSERT INTO portuguese_index VALUES ("confederação","n#00700029 n#08303275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Confederação","n#00700029","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aliança","n#00700029 n#03241409 n#03603916 n#05075069 n#05363971 n#06155266 n#08305114 n#14418822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fraternização","n#01081867","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afiliação","n#01082061 n#13930385","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filiação","n#01082061 n#13930385","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prolífico","NULL","NULL","a#01028986 a#01794787","NULL");
INSERT INTO portuguese_index VALUES ("descolonização","n#01082548","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abortado","NULL","NULL","a#01082714","NULL");
INSERT INTO portuguese_index VALUES ("abortivo","NULL","NULL","a#01082714","NULL");
INSERT INTO portuguese_index VALUES ("fracassado","NULL","NULL","a#01082714","NULL");
INSERT INTO portuguese_index VALUES ("frustrado","NULL","NULL","a#01082714 a#02333976","NULL");
INSERT INTO portuguese_index VALUES ("sem_filhos","NULL","NULL","a#01029868","NULL");
INSERT INTO portuguese_index VALUES ("sair_fora","NULL","v#00734233","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distribuição","n#00701398 n#00721822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pleno","NULL","NULL","a#01030147","NULL");
INSERT INTO portuguese_index VALUES ("lotado","NULL","NULL","a#01030147","NULL");
INSERT INTO portuguese_index VALUES ("cheio","NULL","NULL","a#01030147 a#02189742","NULL");
INSERT INTO portuguese_index VALUES ("demolir","NULL","v#00734516 v#01141322","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destinação","n#01083504","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repartição","n#00701814","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("racionamento","n#00702810","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parte","n#00702886 n#02479780 n#02719232 n#03090721 n#03296757 n#04515709 n#04819171 n#06684175 n#06686864 n#09381264 n#09562733 n#09945970","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("parcela","n#00702886 n#09575153 n#13728818","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cheio_demais","NULL","NULL","a#01085167","NULL");
INSERT INTO portuguese_index VALUES ("dificultar","NULL","v#00735512","NULL","NULL");
INSERT INTO portuguese_index VALUES ("partilha","n#00703319","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("generosidade","n#00703445 n#03787376 n#04832244 n#05696348","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("doação","n#00703535 n#00706393 n#01089778 n#09545388 n#09549012 n#09550413","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("correr","NULL","v#00735772 v#01257991 v#01306607 v#01314495 v#01408362 v#01414286 v#01416044 v#02070874","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estufado","NULL","NULL","a#01086118 a#01033667","NULL");
INSERT INTO portuguese_index VALUES ("vazio","n#10024042","NULL","a#02155613 a#02155010","NULL");
INSERT INTO portuguese_index VALUES ("assistência_social","n#01086945","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segurança_social","n#01086945 n#00704970","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("refletivo","NULL","NULL","a#01087093","NULL");
INSERT INTO portuguese_index VALUES ("em_branco","NULL","NULL","a#01087093","NULL");
INSERT INTO portuguese_index VALUES ("prover_de_armas","NULL","v#00736298","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desarmar","NULL","v#01087835 v#01088005","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vacante","NULL","NULL","a#01036561","NULL");
INSERT INTO portuguese_index VALUES ("desocupado","NULL","NULL","a#01036561","NULL");
INSERT INTO portuguese_index VALUES ("auxílio","n#01088168 n#00782440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assistência_humanitária","n#01088168","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmobilizar","NULL","v#01088192","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esgotado","NULL","NULL","a#01088881","NULL");
INSERT INTO portuguese_index VALUES ("situar","NULL","v#00737527 v#01085355 v#01354457 v#01838645","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Medicare","n#01089009","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atenção_primária_à_saúde","n#01089297","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Atenção_Primária_à_Saúde","n#01089297","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Filantropia","n#01089483","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filantropia","n#01089483","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tripular","NULL","v#01089614","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caridade","n#00706393 n#03794149","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contributo","n#01089778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esmola","n#00706785 n#01090225 n#09562146","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("funcional","NULL","NULL","a#01038551 a#01039791 a#01041233 a#01763584 a#02049113 a#02741248","NULL");
INSERT INTO portuguese_index VALUES ("lutar","NULL","v#00738369 v#00739127 v#00739256 v#00739748 v#01033445 v#01033610 v#02371811","NULL","NULL");
INSERT INTO portuguese_index VALUES ("debater-se","NULL","v#00738369 v#01275761","NULL","NULL");
INSERT INTO portuguese_index VALUES ("brigar","NULL","v#00738369 v#00739256","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decorativo","NULL","NULL","a#01039405","NULL");
INSERT INTO portuguese_index VALUES ("ornamental","NULL","NULL","a#01039405","NULL");
INSERT INTO portuguese_index VALUES ("batalhar","NULL","v#00739127 v#00739748 v#01639540","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resistir","NULL","v#00739256 v#01092284 v#01115916 v#00757252 v#00768078 v#02518161 v#01785787 v#01845783 v#01847498 v#01848077","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recalcitrar","NULL","v#01091844","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comércio_justo","n#01092315","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("combater","NULL","v#00739748","NULL","NULL");
INSERT INTO portuguese_index VALUES ("defeituoso","NULL","NULL","a#01040694 a#01597240 a#01752953","NULL");
INSERT INTO portuguese_index VALUES ("Livre-cambismo","n#01092643","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comércio_livre","n#01092643","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tratado_Norte-Americano_de_Livre_Comércio","n#01092769","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tratado_norte-americano_de_livre_comércio","n#01092769","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("NAFTA","n#01092769","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comércio_electrónico","n#01092974","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comércio_eletrônico","n#01092974","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerrear","NULL","v#01093172 v#01639540","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empréstimo","n#00708190 n#00720897 n#04754686 n#09651550","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("usura","n#01093855 n#13320045","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arbitragem","n#01093965 n#01190884 n#07150850","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_campanha","NULL","v#01094086","NULL","NULL");
INSERT INTO portuguese_index VALUES ("concorrer","NULL","v#01094086","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Oferta_pública_inicial","n#01094575","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negócio","n#01094725 n#00710194 n#00720146 n#02586441","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exercer","NULL","v#00741327 v#00793027 v#01509192 v#01751275","NULL","NULL");
INSERT INTO portuguese_index VALUES ("servir","NULL","v#00741327 v#00742204 v#00802507 v#00804159 v#01732720 v#01822108","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atividade_comercial","n#01095753","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rotacionar","NULL","v#01096305","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transação","n#00710382 n#00717352","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("negociação","n#00710382 n#05347846","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("funcionar","NULL","v#00741990 v#01048914 v#01049188 v#01526290 v#01732720","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fornecido","NULL","NULL","a#01096990","NULL");
INSERT INTO portuguese_index VALUES ("mobilado","NULL","NULL","a#01096990","NULL");
INSERT INTO portuguese_index VALUES ("campo_de_acção","n#01097119","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engajar-se","NULL","v#01097192","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alistar-se","NULL","v#01097192","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mercado","n#00711063 n#02813645 n#02666767 n#03461385 n#03722288 n#03057237 n#06230917 n#06319069","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encarregado","NULL","NULL","a#01097315","NULL");
INSERT INTO portuguese_index VALUES ("emestoque","NULL","NULL","a#01097690","NULL");
INSERT INTO portuguese_index VALUES ("Mercado_cinza","n#01098071","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mecado_de_trabalho","n#01098404","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("angariar","NULL","v#01098452","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aliciar","NULL","v#01098452","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recrutar","NULL","v#01098452 v#01533484 v#01683922","NULL","NULL");
INSERT INTO portuguese_index VALUES ("engajar","NULL","v#01098452 v#01533348","NULL","NULL");
INSERT INTO portuguese_index VALUES ("finança","n#01098698","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alistar","NULL","v#01098706","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Taxa_mínima_de_atratividade","n#01098968","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("financiamento","n#00712138","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("investimento","n#00712429 n#03820287","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perder","NULL","v#00743671 v#01161087 v#01381493 v#02197091 v#01563515 v#01564539 v#01574799","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mero","NULL","NULL","a#01048044","NULL");
INSERT INTO portuguese_index VALUES ("nominal","NULL","NULL","a#01099810 a#01939784 a#02768958 a#02769128","NULL");
INSERT INTO portuguese_index VALUES ("alavancagem_financeira","n#01099946","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("específico","NULL","NULL","a#01048288 a#01053344 a#01105233 a#02751840","NULL");
INSERT INTO portuguese_index VALUES ("ganhar","NULL","v#00744139 v#02288295 v#01565625 v#01565865","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vencer","NULL","v#00744139 v#00745497 v#01101913 v#01104018 v#00750517 v#00750961 v#00751530 v#02288295","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flotação","n#00712796","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("banca","n#00712922 n#02316600","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Publicidade","n#00713435","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("publicidade","n#00713435 n#05409803 n#05411061 n#05411678","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("triunfar","NULL","v#00745497 v#00751530 v#01823370","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ultrapassar","NULL","v#01101913 v#01104018 v#00748500 v#00750961","NULL","NULL");
INSERT INTO portuguese_index VALUES ("derrotar","NULL","v#01101913 v#01104018 v#00750517 v#00750961 v#00751530 v#01110517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superar","NULL","v#01101913 v#01104018 v#00748500 v#00749317 v#01107544 v#00750517 v#00750961 v#00751530 v#00785120 v#01787206 v#01820991","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bater","NULL","v#01101913 v#00820743 v#00838192 v#00841893 v#01242391 v#01242832 v#01247804 v#01394200 v#01398919 v#01399576 v#00960484 v#01405044 v#00966768 v#01412204 v#01414288 v#00969318 v#01414626 v#01415807 v#00971909 v#01879579 v#01287022 v#01292817 v#01293113 v#01297757 v#01350615 v#01399476 v#01430443 v#01431218 v#01434230 v#01434414 v#02094428 v#02104161 v#01489353 v#01489975 v#01490371","NULL","NULL");
INSERT INTO portuguese_index VALUES ("publicitação","n#00713952","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("publicação","n#00713952 n#00715056 n#04944010 n#04944510","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("editoração_electrónica","n#01102256","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("editoração_eletrônica","n#01102256","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serialização","n#01102862","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disseminado","NULL","NULL","a#01053199","NULL");
INSERT INTO portuguese_index VALUES ("rotogravura","n#01103492","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ad-hoc","NULL","NULL","a#01103529","NULL");
INSERT INTO portuguese_index VALUES ("ad_hoc","n#06294584","NULL","a#01103529","NULL");
INSERT INTO portuguese_index VALUES ("circunstancial","NULL","NULL","a#01053999","NULL");
INSERT INTO portuguese_index VALUES ("particular","NULL","NULL","a#01054295","NULL");
INSERT INTO portuguese_index VALUES ("avulso","NULL","NULL","a#01054295","NULL");
INSERT INTO portuguese_index VALUES ("peculiar","NULL","NULL","a#01054295","NULL");
INSERT INTO portuguese_index VALUES ("próprio","NULL","NULL","a#01054295 a#01055105 a#01704265","NULL");
INSERT INTO portuguese_index VALUES ("Catering","n#01104324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agro-indústria","n#00715321","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agronegócio","n#00715321","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Agronegocio","n#00715321","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trapacear","NULL","v#01104624 v#02572119 v#02573275","NULL","NULL");
INSERT INTO portuguese_index VALUES ("edifício","n#00715519 n#02347413 n#03295140 n#03431817","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Edificio","n#00715519","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inespecífico","NULL","NULL","a#01105620","NULL");
INSERT INTO portuguese_index VALUES ("não_específico","NULL","NULL","a#01105620","NULL");
INSERT INTO portuguese_index VALUES ("transporte_aéreo","n#01105635","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ser_melhor_que","NULL","v#00748500","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apresentar_melhor_que","NULL","v#00748500","NULL","NULL");
INSERT INTO portuguese_index VALUES ("federal","NULL","NULL","a#01106129 a#01107206 a#01606214 a#02725829","NULL");
INSERT INTO portuguese_index VALUES ("frete","n#00716809","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("local","n#06352837 n#06353805","NULL","a#01056664 a#01368524","NULL");
INSERT INTO portuguese_index VALUES ("balsa","n#01106587 n#03329663","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("unitário","n#07985135","NULL","a#01058903 a#02358518","NULL");
INSERT INTO portuguese_index VALUES ("pensar_mais_que","NULL","v#01107544","NULL","NULL");
INSERT INTO portuguese_index VALUES ("centralizado","NULL","NULL","a#01107751","NULL");
INSERT INTO portuguese_index VALUES ("descentralizado","NULL","NULL","a#01107973","NULL");
INSERT INTO portuguese_index VALUES ("técnico","n#07162467 n#07633507 n#07633674 n#10722575","NULL","a#01060035 a#02610258 a#02610463","NULL");
INSERT INTO portuguese_index VALUES ("não_técnico","NULL","NULL","a#01109096","NULL");
INSERT INTO portuguese_index VALUES ("permuta","n#00719653","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proprietário","n#10245236 n#07451379 n#07451666 n#07489798 n#09528577","NULL","a#01109914","NULL");
INSERT INTO portuguese_index VALUES ("transacção","n#00720146","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superar_pela_força","NULL","v#01110517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Aluguel","n#00721131","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arrendamento","n#00721131 n#15274863","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aluguel","n#00721131 n#09570568","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Base_roubada","NULL","v#00753225","NULL","NULL");
INSERT INTO portuguese_index VALUES ("importação","n#01111750 n#03564667","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exportação","n#00721409 n#02653164","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exuberante","NULL","NULL","a#01111965","NULL");
INSERT INTO portuguese_index VALUES ("contrabando","n#00721552 n#02491764","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mercadologia","n#01112420","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Marketing","n#01112420","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tacanho","NULL","NULL","a#01063943","NULL");
INSERT INTO portuguese_index VALUES ("ávaro","NULL","NULL","a#01063943","NULL");
INSERT INTO portuguese_index VALUES ("marketing_direto","n#01112739","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Distribuição","n#00721822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("venda","n#00721968 n#00723154 n#01115162 n#01117541 n#02851939 n#04901002","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tinhoso","NULL","NULL","a#01064900","NULL");
INSERT INTO portuguese_index VALUES ("tráfico","n#00722332","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trânsito","n#00722332 n#06231214","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tráfego","n#00722332 n#06231214","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("narcotráfico","n#01114055","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("simonia","n#01114172","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("varejo","n#01114458","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retalho","n#01114458","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_xeque-mate","NULL","v#01114475","NULL","NULL");
INSERT INTO portuguese_index VALUES ("venda_por_atacado","n#01114646","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atacado","n#01114646","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("magnânimo","NULL","NULL","a#01114658 a#01589045","NULL");
INSERT INTO portuguese_index VALUES ("grande_coração","NULL","NULL","a#01114658","NULL");
INSERT INTO portuguese_index VALUES ("empatar","NULL","v#01115190","NULL","NULL");
INSERT INTO portuguese_index VALUES ("legítimo","NULL","NULL","a#01115349 a#01345445 a#01350601 a#01351228","NULL");
INSERT INTO portuguese_index VALUES ("genuíno","NULL","NULL","a#01115349 a#01067073 a#02044571 a#02342342","NULL");
INSERT INTO portuguese_index VALUES ("autêntico","NULL","NULL","a#01115349 a#01067073 a#02095155 a#02342342 a#02346141","NULL");
INSERT INTO portuguese_index VALUES ("equalizar","NULL","v#01115411","NULL","NULL");
INSERT INTO portuguese_index VALUES ("render-se","NULL","v#00756817 v#01529125","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descargas_não_controladas","n#01115589","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tele-marketing","n#01116026","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("telemarketing","n#01116026","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Telemarketing","n#01116026","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("telemetria","n#01116206","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tonometria","n#01116696","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pretendido","NULL","NULL","a#01068366","NULL");
INSERT INTO portuguese_index VALUES ("assumido","NULL","NULL","a#01068366","NULL");
INSERT INTO portuguese_index VALUES ("pretenso","NULL","NULL","a#01068366","NULL");
INSERT INTO portuguese_index VALUES ("fictício","NULL","NULL","a#01068366 a#01867344 a#02727706","NULL");
INSERT INTO portuguese_index VALUES ("forjado","NULL","NULL","a#01068663","NULL");
INSERT INTO portuguese_index VALUES ("farsante","NULL","NULL","a#01068914","NULL");
INSERT INTO portuguese_index VALUES ("liquidação","n#01117723 n#01118776","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aparente","NULL","NULL","a#01069289 a#02394916","NULL");
INSERT INTO portuguese_index VALUES ("feira","n#00725119 n#03461385 n#06218045","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("geocêntrico","NULL","NULL","a#01118568","NULL");
INSERT INTO portuguese_index VALUES ("heliocêntrico","NULL","NULL","a#01118928","NULL");
INSERT INTO portuguese_index VALUES ("dotado","NULL","NULL","a#01119192","NULL");
INSERT INTO portuguese_index VALUES ("talentoso","NULL","NULL","a#01119192","NULL");
INSERT INTO portuguese_index VALUES ("assaltar","NULL","v#00760028","NULL","NULL");
INSERT INTO portuguese_index VALUES ("violentar","NULL","v#00760028 v#01750864","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pagamento","n#00725730 n#09555462","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("molestar","NULL","v#01120759 v#01221002 v#01221988","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amortização","n#01121070 n#01122938","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Amortização","n#01121070","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("celebrado","NULL","NULL","a#01121402","NULL");
INSERT INTO portuguese_index VALUES ("comemorado","NULL","NULL","a#01121402 a#01321211","NULL");
INSERT INTO portuguese_index VALUES ("comemorada","NULL","NULL","a#01121402","NULL");
INSERT INTO portuguese_index VALUES ("divino","NULL","NULL","a#01074523 a#01130016 a#01130200 a#01130706 a#01209639 a#01977777","NULL");
INSERT INTO portuguese_index VALUES ("reembolso","n#01121690 n#13282161 n#13290002 n#13299651","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("duelar","NULL","v#01121948","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despesas","n#00726534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("déficit_público","n#01122754","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("migração","n#00727594 n#05451289","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corrida_do_ouro","n#01123304","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Stampede","n#01123420","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("controle_social","n#01123598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("muito_bom","NULL","NULL","a#01076845","NULL");
INSERT INTO portuguese_index VALUES ("sanção","n#00728675 n#00738216 n#05176607 n#05013621 n#05015182","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("satisfatório","NULL","NULL","a#01077729 a#02001946","NULL");
INSERT INTO portuguese_index VALUES ("governação","n#00728919","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("administração","n#00728919 n#00734610 n#00736489 n#06071657 n#06188759 n#06201180","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sólido","n#13860793 n#14480772 n#15046900","NULL","a#01077859 a#02151388 a#02273952 a#02165307","NULL");
INSERT INTO portuguese_index VALUES ("contra-atacar","NULL","v#01125084","NULL","NULL");
INSERT INTO portuguese_index VALUES ("legislação","n#00729291 n#04906199","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("minar","NULL","v#01125724 v#01163620 v#01415345","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emboscar","NULL","v#00764381 v#01138204 v#01142203","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apavorante","NULL","NULL","a#01079225","NULL");
INSERT INTO portuguese_index VALUES ("invadir","NULL","v#00764618 v#02654686","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vinificação","n#01126564","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Viticultura","n#01126709","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("viticultura","n#01126709","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deplorável","NULL","NULL","a#01312607","NULL");
INSERT INTO portuguese_index VALUES ("cumprimento_(legal)","n#00729616","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cumprimento","n#00729616 n#00729882","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imposição","n#00729616 n#04492223","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_barricadas","NULL","v#01127075","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Implementação_de_software","n#00729882","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sitiar","NULL","v#01127411","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cercar","NULL","v#01127411 v#01094220 v#01107492","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fedorenta","NULL","NULL","a#01127782","NULL");
INSERT INTO portuguese_index VALUES ("fedido","NULL","NULL","a#01127782","NULL");
INSERT INTO portuguese_index VALUES ("fedida","NULL","NULL","a#01127782","NULL");
INSERT INTO portuguese_index VALUES ("execução_da_lei","n#01128137","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("proteger","NULL","v#00765817 v#01129064 v#01130169","NULL","NULL");
INSERT INTO portuguese_index VALUES ("medíocre","NULL","NULL","a#01128253 a#01921502 a#02235907","NULL");
INSERT INTO portuguese_index VALUES ("dominação","n#00730747","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("travesso","NULL","NULL","a#01128406 a#02121859","NULL");
INSERT INTO portuguese_index VALUES ("levado","NULL","NULL","a#01128406","NULL");
INSERT INTO portuguese_index VALUES ("imunizar","NULL","v#01128778","NULL","NULL");
INSERT INTO portuguese_index VALUES ("monopolização","n#01128806","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guardar","NULL","v#00766532 v#01508080 v#01516644 v#01522764 v#01849866 v#01673353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salvaguardar","NULL","v#00766532","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salvar","NULL","v#00766532 v#01739424 v#01739567","NULL","NULL");
INSERT INTO portuguese_index VALUES ("angelical","NULL","NULL","a#01082754 a#01399812 a#02870663","NULL");
INSERT INTO portuguese_index VALUES ("angélico","NULL","NULL","a#01082754 a#01399812 a#02870663","NULL");
INSERT INTO portuguese_index VALUES ("ônus_da_prova","n#01130905","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("má","NULL","NULL","a#01083652","NULL");
INSERT INTO portuguese_index VALUES ("maléfica","NULL","NULL","a#01083652","NULL");
INSERT INTO portuguese_index VALUES ("maléfico","NULL","NULL","a#01083652","NULL");
INSERT INTO portuguese_index VALUES ("mau","NULL","NULL","a#01083652 a#01084323 a#02036077 a#02234253","NULL");
INSERT INTO portuguese_index VALUES ("repelir","NULL","v#01131197 v#01234179","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nefando","NULL","NULL","a#01084054","NULL");
INSERT INTO portuguese_index VALUES ("bombardear","NULL","v#01131902","NULL","NULL");
INSERT INTO portuguese_index VALUES ("providência","n#01132327","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diabólico","NULL","NULL","a#01132515 a#01133374","NULL");
INSERT INTO portuguese_index VALUES ("infernal","NULL","NULL","a#01132515 a#01303776 a#01802774 a#02859053","NULL");
INSERT INTO portuguese_index VALUES ("obediência","n#00734248 n#00755927 n#03841543","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vil","NULL","NULL","a#01085389","NULL");
INSERT INTO portuguese_index VALUES ("gestão","n#00734610 n#00736489 n#00742277","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maestro","n#01133760 n#07175013","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Maestros","n#01133760","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atirar","NULL","v#00769883 v#00770753 v#00771991 v#00772389 v#00847023 v#01035130 v#01036035 v#01038983 v#01040233 v#01292413","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lhano","NULL","NULL","a#01133876","NULL");
INSERT INTO portuguese_index VALUES ("disparar","NULL","v#00770419 v#00770753 v#00771529 v#00771991 v#01891307","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Biorremediação","n#01135163","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("supervisão","n#00735967","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superintendência","n#00735967","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resmungão","NULL","NULL","a#01087670","NULL");
INSERT INTO portuguese_index VALUES ("abrir_fogo","NULL","v#00771529","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gerenciamento","n#00736489","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rústico","n#10804102","NULL","a#01136127 a#01093535","NULL");
INSERT INTO portuguese_index VALUES ("mal_humorado","NULL","NULL","a#01088163","NULL");
INSERT INTO portuguese_index VALUES ("birrento","NULL","NULL","a#01088163","NULL");
INSERT INTO portuguese_index VALUES ("rabugento","n#09984047","NULL","a#01088163","NULL");
INSERT INTO portuguese_index VALUES ("petulante","NULL","NULL","a#01136541","NULL");
INSERT INTO portuguese_index VALUES ("irritadiço","NULL","NULL","a#01136541","NULL");
INSERT INTO portuguese_index VALUES ("metralhar","NULL","v#01136835","NULL","NULL");
INSERT INTO portuguese_index VALUES ("taciturno","NULL","NULL","a#01088903 a#02383380","NULL");
INSERT INTO portuguese_index VALUES ("fuzilar","NULL","v#00772688","NULL","NULL");
INSERT INTO portuguese_index VALUES ("torpedear","NULL","v#01137983","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reestruturação","n#00737598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("restruturação","n#00737598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("remodelagem","n#00737598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reorganização","n#00737598","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estar_em_uma_emboscada","NULL","v#01138204","NULL","NULL");
INSERT INTO portuguese_index VALUES ("misógino","NULL","NULL","a#01138316 a#02464491","NULL");
INSERT INTO portuguese_index VALUES ("megera","n#07573451","NULL","a#01138610","NULL");
INSERT INTO portuguese_index VALUES ("autorização","n#00737978 n#05176607 n#04045518 n#05013621 n#05015182","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogar_os_dados","NULL","v#01138733","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogar_dados","NULL","v#01138733","NULL","NULL");
INSERT INTO portuguese_index VALUES ("permissão","n#00738404","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("licença","n#00738404 n#04916758 n#10082169 n#10082705 n#15139432","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dobrar","NULL","v#00774319 v#01277784 v#00872449 v#01278427 v#01280488 v#01391432 v#01410999","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Nihil_obstat","n#01139749","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conter-se","NULL","v#01139756","NULL","NULL");
INSERT INTO portuguese_index VALUES ("refrear-se","NULL","v#01139756","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fluente","NULL","NULL","a#01090843","NULL");
INSERT INTO portuguese_index VALUES ("fluido","n#14939445","NULL","a#01090843 a#02261746","NULL");
INSERT INTO portuguese_index VALUES ("pescar_caranguejo","NULL","v#01140065","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acreditação","n#01140193","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("delegação","n#00739358 n#00739664 n#06213619","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mandato","n#01140658 n#04903413 n#04919548 n#04922001","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pescar","NULL","v#00775186","NULL","NULL");
INSERT INTO portuguese_index VALUES ("catar","NULL","v#00775186 v#00947443 v#01534043","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atrapalhado","NULL","NULL","a#01091940","NULL");
INSERT INTO portuguese_index VALUES ("devolução","n#01141160","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("misericordioso","NULL","NULL","a#01142196 a#01507134","NULL");
INSERT INTO portuguese_index VALUES ("Tolerância","n#01142324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sistemas_de_condutas","n#01142519","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gradual","NULL","NULL","a#01142804 a#01144359","NULL");
INSERT INTO portuguese_index VALUES ("súbito","NULL","NULL","a#01094125","NULL");
INSERT INTO portuguese_index VALUES ("repentino","NULL","NULL","a#01094125 a#01094377 a#01095581","NULL");
INSERT INTO portuguese_index VALUES ("repentina","NULL","NULL","a#01094125","NULL");
INSERT INTO portuguese_index VALUES ("abrupto","NULL","NULL","a#01094125 a#01094377 a#01095581","NULL");
INSERT INTO portuguese_index VALUES ("escarpado","NULL","NULL","a#01094377","NULL");
INSERT INTO portuguese_index VALUES ("caçar","NULL","v#00777314 v#01365796","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fulminante","NULL","NULL","a#01144102","NULL");
INSERT INTO portuguese_index VALUES ("montear","NULL","v#01144657","NULL","NULL");
INSERT INTO portuguese_index VALUES ("andar_à_caça_de","NULL","v#01144657","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emrampa","NULL","NULL","a#01095196","NULL");
INSERT INTO portuguese_index VALUES ("gerência","n#00742277","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("directriz","n#00742277","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("direcção","n#00742277 n#06389665","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("direção","n#00742277 n#04698475 n#06389665","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("íngreme","NULL","NULL","a#01144887","NULL");
INSERT INTO portuguese_index VALUES ("íngrime","NULL","NULL","a#01144887","NULL");
INSERT INTO portuguese_index VALUES ("transferência_do_controle","n#01145015","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transferência_da_administração","n#01145015","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("golpe_de_estado","n#01145015","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amarra","n#00742557","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perpendicular","n#03917973 n#13870680","NULL","a#01145422 a#01145724 a#01182362 a#01657344 a#01657644 a#01657914","NULL");
INSERT INTO portuguese_index VALUES ("gramatical","NULL","NULL","a#01097599 a#02664693","NULL");
INSERT INTO portuguese_index VALUES ("freio","n#00743021 n#02329003","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("batalhar_por_algo","NULL","v#01146051","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agradecido","NULL","NULL","a#01146493 a#01146732 a#01801327","NULL");
INSERT INTO portuguese_index VALUES ("grato","NULL","NULL","a#01146493 a#01308059","NULL");
INSERT INTO portuguese_index VALUES ("gratidão","n#07504343 n#07504529","NULL","a#01146493","NULL");
INSERT INTO portuguese_index VALUES ("confinamento","n#00743461 n#13998576","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apreciativo","NULL","NULL","a#01146732","NULL");
INSERT INTO portuguese_index VALUES ("obrigado","NULL","NULL","a#01146732 a#01616891","NULL");
INSERT INTO portuguese_index VALUES ("aprisionamento","n#01146768","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jogar_golfe","NULL","v#01146793","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esgrimir","NULL","v#00779381","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mal-agradecido","NULL","NULL","a#01147044","NULL");
INSERT INTO portuguese_index VALUES ("ingrato","NULL","NULL","a#01147044","NULL");
INSERT INTO portuguese_index VALUES ("bloquear","NULL","v#00779487 v#01013332","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prisão_domiciliar","n#01147135","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("haplóide","NULL","NULL","a#01147433","NULL");
INSERT INTO portuguese_index VALUES ("contenção_(indústria_nuclear)","n#01147451","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contenção","n#01147451","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diplóide","NULL","NULL","a#01147622","NULL");
INSERT INTO portuguese_index VALUES ("regulamentação","n#00744399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cobrir","NULL","v#00780570 v#00822267 v#00840079 v#01235224 v#00860970 v#01264283 v#00876484 v#00909621 v#02147109 v#02310674 v#02395000 v#02688794","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Desconfidencialização","n#01149115","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("especificação","n#00745088","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estipulação","n#00745088","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infeliz","NULL","NULL","a#01101074","NULL");
INSERT INTO portuguese_index VALUES ("vasoconstrição","n#01150096","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("privação","n#01150200 n#04022310 n#14493426","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empobrecimento","n#01150467 n#10397144","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("direcionar","NULL","v#00781920 v#01935104","NULL","NULL");
INSERT INTO portuguese_index VALUES ("duro","NULL","NULL","a#01102688 a#01951986","NULL");
INSERT INTO portuguese_index VALUES ("dificil","NULL","NULL","a#01102688","NULL");
INSERT INTO portuguese_index VALUES ("dura","NULL","NULL","a#01102688","NULL");
INSERT INTO portuguese_index VALUES ("política_de_apaziguamento","n#01150938","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pacificação","n#01151097 n#05075242","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mirar","NULL","v#00782363 v#01457770 v#02131777 v#01459903 v#01483772 v#02199307 v#01673353","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_ferro","NULL","NULL","a#01151246","NULL");
INSERT INTO portuguese_index VALUES ("conciliação","n#01151407","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mundialização","n#01151605","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("internacionalização","n#01151605","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nacionalização","n#01151788 n#01152300 n#01152461","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("granítico","NULL","NULL","a#01103580","NULL");
INSERT INTO portuguese_index VALUES ("privatização","n#01152033","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endurecido","NULL","NULL","a#01152091 a#01155815 a#01459158 a#02447779","NULL");
INSERT INTO portuguese_index VALUES ("fazer_mira","NULL","v#00783092","NULL","NULL");
INSERT INTO portuguese_index VALUES ("macio","NULL","NULL","a#01104721 a#02130839 a#02326811","NULL");
INSERT INTO portuguese_index VALUES ("direccionar","NULL","v#01152896","NULL","NULL");
INSERT INTO portuguese_index VALUES ("federação","n#01153305 n#08303275","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desforrar","NULL","v#00784203","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vingar","NULL","v#00784203","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vingar-se","NULL","v#00784203","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discriminação","n#01153548 n#05748054","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fofa","NULL","NULL","a#01154030","NULL");
INSERT INTO portuguese_index VALUES ("nomenklatura","n#01154083","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discriminação_etária","n#01154373","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fisiologismo","n#01154487","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Heterossexismo","n#01154772","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dedetizar","NULL","v#01154825","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desinsetizar","NULL","v#01154825","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Nepotismo","n#01154900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nepotismo","n#01154900","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Racismo","n#01155044","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("racismo","n#01155044 n#06203758","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("avaçar","NULL","v#00785251","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Secularização","n#01155465","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Sexismo","n#01155893","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sexismo","n#01155893","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chauvinismo","n#01156070 n#04878646","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("doce","NULL","NULL","a#01109560 a#02226998 a#02257076","NULL");
INSERT INTO portuguese_index VALUES ("mobilização","n#01156438 n#01230283","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tomar","NULL","v#00786286 v#00795711 v#00796419 v#00796874 v#00817921 v#00826635 v#01509715 v#02248299","NULL","NULL");
INSERT INTO portuguese_index VALUES ("equipamento","n#00749390 n#02200827 n#02560468 n#02644452 n#02859872","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("armamento","n#00749390 n#02208998 n#03601056 n#03601456","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gastar","NULL","v#00787073 v#00787825 v#01551317 v#02301502","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desarmamento","n#01157557","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conscrição","n#01157850","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alistamento","n#01157850","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("came","n#01158064","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esbanjar","NULL","v#01158181 v#02264601","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmobilização","n#01158190","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estandardização","n#00750783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homologação","n#00750783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("padronização","n#00750783 n#13938440","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("normalização","n#00750783","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empregar","NULL","v#00788109 v#00793027 v#01533348 v#01641059 v#01641377","NULL","NULL");
INSERT INTO portuguese_index VALUES ("utilizar","NULL","v#00788109 v#00789325 v#01746847 v#01752442","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estabilização","n#00750993","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espiritoso","NULL","NULL","a#01159217","NULL");
INSERT INTO portuguese_index VALUES ("que_não_causa_danos","NULL","NULL","a#01159655","NULL");
INSERT INTO portuguese_index VALUES ("inócuo","NULL","NULL","a#01159655 a#01113405 a#01611839 a#01627635","NULL");
INSERT INTO portuguese_index VALUES ("inocente","NULL","NULL","a#01113405 a#01320705","NULL");
INSERT INTO portuguese_index VALUES ("daninho","NULL","NULL","a#01982806","NULL");
INSERT INTO portuguese_index VALUES ("nocivo","NULL","NULL","a#01982806 a#01552949","NULL");
INSERT INTO portuguese_index VALUES ("prejudicial","NULL","NULL","a#01982806 a#01161984","NULL");
INSERT INTO portuguese_index VALUES ("punição","n#00751324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penalização","n#00751324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("castigo","n#00751324 n#01161017 n#05035921","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penalidade","n#00751324 n#13301174","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fraudulento","NULL","NULL","a#01160584","NULL");
INSERT INTO portuguese_index VALUES ("abusivo","NULL","NULL","a#01160584","NULL");
INSERT INTO portuguese_index VALUES ("surra","n#00752384 n#01162784 n#05558898","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endereçar","NULL","v#01160899 v#00937138","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deletério","NULL","NULL","a#01114647","NULL");
INSERT INTO portuguese_index VALUES ("injuriante","NULL","NULL","a#01114647","NULL");
INSERT INTO portuguese_index VALUES ("desperdiçar","NULL","v#01161087 v#00813321 v#01552355 v#02708123","NULL","NULL");
INSERT INTO portuguese_index VALUES ("calunioso","NULL","NULL","a#01161233","NULL");
INSERT INTO portuguese_index VALUES ("difamatório","NULL","NULL","a#01161233","NULL");
INSERT INTO portuguese_index VALUES ("infamante","NULL","NULL","a#01161233 a#01549964","NULL");
INSERT INTO portuguese_index VALUES ("usar_inapropriadamente","NULL","v#01161290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("usar_erradamente","NULL","v#01161290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tratar_erradamente","NULL","v#01161290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("usar_para_propósitos_errados","NULL","v#01161290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("catastrófico","NULL","NULL","a#01161635","NULL");
INSERT INTO portuguese_index VALUES ("detenção","n#01161635","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prisão","n#01161635 n#02805443 n#02872007 n#03684740 n#03823540 n#03174387","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encarceramento","n#01162376","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insidioso","NULL","NULL","a#01115759 a#02060106 a#02097884","NULL");
INSERT INTO portuguese_index VALUES ("reutilizar","NULL","v#01162425","NULL","NULL");
INSERT INTO portuguese_index VALUES ("usar_novamente","NULL","v#01162425","NULL","NULL");
INSERT INTO portuguese_index VALUES ("usar_de_novo","NULL","v#01162425","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reusar","NULL","v#01162425","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reciclar","NULL","v#01162425 v#02052877","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aproveitar","NULL","v#00790940 v#01247684 v#01445091","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flagelação","n#01163047","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consonante","NULL","NULL","a#01163320","NULL");
INSERT INTO portuguese_index VALUES ("minerar","NULL","v#01163620","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escavar","NULL","v#01163620 v#01282545 v#01310660 v#01311103 v#01311378","NULL","NULL");
INSERT INTO portuguese_index VALUES ("punição_importanta","n#01163779","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pena_de_morte","n#01163779","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pena_capital","n#01163779","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pena_de_morte","n#01163779","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sinfônico","NULL","NULL","a#01163941 a#03002040","NULL");
INSERT INTO portuguese_index VALUES ("lapidação","n#01164394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pessoas_executadas_por_apedrejamento","n#01164394","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dissonante","NULL","NULL","a#01164561","NULL");
INSERT INTO portuguese_index VALUES ("saudável","NULL","NULL","a#01164763 a#01121949 a#01172692 a#02434492","NULL");
INSERT INTO portuguese_index VALUES ("Mortes_por_enforcamento","n#01164874","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anti-helmíntico","NULL","NULL","a#01165266","NULL");
INSERT INTO portuguese_index VALUES ("viciar","NULL","v#01165290","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pessoas_executadas_por_crucificação","n#01165337","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antimicrobiano","NULL","NULL","a#01165474","NULL");
INSERT INTO portuguese_index VALUES ("terapêutico","NULL","NULL","a#01118744 a#02691349","NULL");
INSERT INTO portuguese_index VALUES ("aplicar","NULL","v#00793027 v#00933530 v#01746847","NULL","NULL");
INSERT INTO portuguese_index VALUES ("câmbio","n#00755465 n#13326620","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comer","NULL","v#00793267 v#00794578 v#00802008 v#00806050 v#00814298 v#00977560","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salutar","NULL","NULL","a#01119178","NULL");
INSERT INTO portuguese_index VALUES ("compromisso","n#01166760 n#01205564 n#05366843","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dilema","n#01166760 n#05686086","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("submissão","n#00755761","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("profilático","NULL","NULL","a#01167269","NULL");
INSERT INTO portuguese_index VALUES ("preventivo","NULL","NULL","a#01167269 a#01763813","NULL");
INSERT INTO portuguese_index VALUES ("discórdia","n#00756240 n#01170175 n#04984698 n#07180787 n#07181546 n#13979064","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jantar","n#05627549 n#05629070 n#06128171 n#08256567","v#01167780 v#00794350","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_um_piquenique","NULL","v#01168259","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ação_direta","n#01168369","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protesto","n#01168369 n#01170502 n#00762587 n#05386838","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patogénico","NULL","NULL","a#01168434","NULL");
INSERT INTO portuguese_index VALUES ("patogênico","NULL","NULL","a#01168434","NULL");
INSERT INTO portuguese_index VALUES ("concorrência","n#00756855","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("competição","n#00756855 n#05542799","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("médico","n#07220340 n#10165109 n#10305802","NULL","a#01120947 a#02475324 a#02585051","NULL");
INSERT INTO portuguese_index VALUES ("devorar","NULL","v#00795195 v#00797570 v#00798099 v#01193099 v#00813980 v#01196802 v#00814298 v#01202651","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sugar","NULL","v#00795606 v#01266812 v#01890060","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chupar","NULL","v#00795606 v#01266812 v#01890060","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confronto","n#00757904 n#10071502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("operável","NULL","NULL","a#01169817","NULL");
INSERT INTO portuguese_index VALUES ("inoperável","NULL","NULL","a#01169940 a#02125198","NULL");
INSERT INTO portuguese_index VALUES ("beber","NULL","v#00795711 v#00796419 v#00796874 v#00817921","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salubre","NULL","NULL","a#01121949 a#02558184 a#02558996","NULL");
INSERT INTO portuguese_index VALUES ("desafio","n#00758369 n#05399705 n#05399907 n#07231943 n#10039715","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Distúrbio","n#01170502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Distúrbios_e_Protestos","n#01170502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bebericar","NULL","v#00796117","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sorver","NULL","v#00796117","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contravenção","n#01170813","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("discussão","n#01170813 n#05340429 n#05342032 n#05342315 n#05368498 n#05369177 n#05369518","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pugna","n#00758807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("peleja","n#00758807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lamber","NULL","v#00796296 v#00981543","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Esgrima","n#01171644","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esgrima","n#01171644","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anictérico","NULL","NULL","a#01171955 a#02623991","NULL");
INSERT INTO portuguese_index VALUES ("briga","n#00759769","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tocar","n#05514913","v#01172701 v#00820504 v#00820743 v#00824033 v#00881541 v#01038527 v#01133626 v#01181779 v#01208417 v#01366372 v#01493348","NULL","NULL");
INSERT INTO portuguese_index VALUES ("doentio","NULL","NULL","a#01172889","NULL");
INSERT INTO portuguese_index VALUES ("doente","NULL","NULL","a#01172889 a#02421145","NULL");
INSERT INTO portuguese_index VALUES ("insalubre","NULL","NULL","a#01172889 a#02559534","NULL");
INSERT INTO portuguese_index VALUES ("porrada","n#00760227","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contragolpe","n#01173569","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("artrítico","NULL","NULL","a#01173795","NULL");
INSERT INTO portuguese_index VALUES ("tragar","NULL","v#00798099","NULL","NULL");
INSERT INTO portuguese_index VALUES ("asmático","NULL","NULL","a#01174048","NULL");
INSERT INTO portuguese_index VALUES ("ruminar","NULL","v#01174555","NULL","NULL");
INSERT INTO portuguese_index VALUES ("folear","NULL","v#00798823","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_uma_olhada","NULL","v#00798823 v#02131777","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pastar","NULL","v#00798823 v#01085489","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caseoso","NULL","NULL","a#01175541","NULL");
INSERT INTO portuguese_index VALUES ("dar","NULL","v#01175810 v#00802507 v#01134616 v#01505951 v#01506768 v#01506956 v#01525019 v#01526289 v#01529125 v#01543501 v#01736614 v#01548161 v#01568149 v#01570315 v#01578132 v#01579009 v#01579272 v#01582922 v#01583087 v#01590833 v#02336483 v#02339413 v#02357873 v#02358327","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desordenar","NULL","v#01176079","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_bagunça","NULL","v#01176079","NULL","NULL");
INSERT INTO portuguese_index VALUES ("superação","n#01176219","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patológico","NULL","NULL","a#01126996 a#01528424 a#02649865","NULL");
INSERT INTO portuguese_index VALUES ("mórbido","NULL","NULL","a#01126996","NULL");
INSERT INTO portuguese_index VALUES ("edematoso","NULL","NULL","a#01176544","NULL");
INSERT INTO portuguese_index VALUES ("espumoso","NULL","NULL","a#01176787 a#02276305","NULL");
INSERT INTO portuguese_index VALUES ("gangrenoso","NULL","NULL","a#01176973","NULL");
INSERT INTO portuguese_index VALUES ("inflamatório","NULL","NULL","a#01177246","NULL");
INSERT INTO portuguese_index VALUES ("ictérico","NULL","NULL","a#01177556","NULL");
INSERT INTO portuguese_index VALUES ("pancadaria","n#01177583","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manifestação","n#00763104 n#05091595 n#05148592 n#05149034 n#05458088","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mental","NULL","NULL","a#01177899 a#01711900","NULL");
INSERT INTO portuguese_index VALUES ("descorado","NULL","NULL","a#01128686","NULL");
INSERT INTO portuguese_index VALUES ("Walkout","n#01178195","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Festa_do_chá_de_boston","n#01178415","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Festa_do_Chá_de_Boston","n#01178415","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alimentar","NULL","v#00801099 v#00802380 v#00803055 v#00803340 v#00803617 v#01185475 v#00818436 v#00819568","a#02434800","NULL");
INSERT INTO portuguese_index VALUES ("dar_comida","NULL","v#00801099","NULL","NULL");
INSERT INTO portuguese_index VALUES ("celeste","NULL","NULL","a#01178974 a#01129832 a#02538008 a#02538172","NULL");
INSERT INTO portuguese_index VALUES ("rebeldia","n#01179393","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desobediência","n#01179707 n#04909414","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alimentar-se","NULL","v#00802008","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desobediência_civil","n#01179927","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Desobediência_Civil","n#01179927","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desacato","n#01180200","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contempt_of_court","n#01180557","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suprir","NULL","v#00803055 v#00804764 v#01588115 v#01590833 v#02332999 v#02338386 v#02338975 v#02339413 v#01689594","NULL","NULL");
INSERT INTO portuguese_index VALUES ("devido_processo_legal","n#01181475","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("digerível","NULL","NULL","a#01182024","NULL");
INSERT INTO portuguese_index VALUES ("assimilável","NULL","NULL","a#01182302","NULL");
INSERT INTO portuguese_index VALUES ("processo_judicial","n#01182654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pleito","n#01182654","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fornecer","NULL","v#00804159 v#01588115 v#01590833 v#02332999 v#02336483 v#02338386 v#02338975 v#01689594 v#02744451","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prover","NULL","v#00804159 v#01590833 v#01597666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ação_popular","n#01183166","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("satifazer","NULL","v#00804764","NULL","NULL");
INSERT INTO portuguese_index VALUES ("montar_a_cavalo","NULL","v#01184058","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_cabeça","NULL","NULL","a#01184261","NULL");
INSERT INTO portuguese_index VALUES ("colmar","NULL","v#00805478 v#01233838","NULL","NULL");
INSERT INTO portuguese_index VALUES ("satisfazer","NULL","v#00805478 v#01194238 v#01238865 v#01816054 v#01239189 v#01822979","NULL","NULL");
INSERT INTO portuguese_index VALUES ("procedimento_legal","n#01184814","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pesado","NULL","NULL","a#01184932 a#01189109 a#01141075","NULL");
INSERT INTO portuguese_index VALUES ("Adoção","n#01185292","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("almoçar","NULL","v#00806050","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recursos_(legislação)","n#01185611","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apelação","n#01185611","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apelo","n#01185611 n#04888919 n#05360326 n#05370393 n#05371036 n#07186828 n#05374441","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desjejuar","NULL","v#00806298","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maciço","NULL","NULL","a#01135871","NULL");
INSERT INTO portuguese_index VALUES ("revogação","n#01185981 n#01258852","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falência","n#01186397 n#14478433","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bancarrota","n#01186397 n#14478433","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("leve","NULL","NULL","a#01136498 a#01187777","NULL");
INSERT INTO portuguese_index VALUES ("amamentar","NULL","v#01186428","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_de_mamar","NULL","v#01186428","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alimentar_um_bebê_com_o_leite_produzido_pelas_próprias_glândulas_mamárias","NULL","v#01186428","NULL","NULL");
INSERT INTO portuguese_index VALUES ("litígio","n#01186810","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmamar","NULL","v#01186958","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passar_fome","NULL","v#01187537 v#01188144","NULL","NULL");
INSERT INTO portuguese_index VALUES ("morrer_de_fome","NULL","v#01187537 v#01188144","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esfomear","NULL","v#01187740","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sentença","n#00768711 n#00771599","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estar_faminto","NULL","v#01188144","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estar_esfomeado","NULL","v#01188144","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_sede","NULL","v#01188485","NULL","NULL");
INSERT INTO portuguese_index VALUES ("industrial","n#10204177","NULL","a#01139194 a#01248288 a#02434036 a#02579003","NULL");
INSERT INTO portuguese_index VALUES ("necessitar","NULL","v#00808096 v#00808394 v#01795937","NULL","NULL");
INSERT INTO portuguese_index VALUES ("onerosa","NULL","NULL","a#01189109","NULL");
INSERT INTO portuguese_index VALUES ("oneroso","NULL","NULL","a#01189109","NULL");
INSERT INTO portuguese_index VALUES ("condenação","n#00770012 n#10935869","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jejuar","NULL","v#01189427","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embraigar","NULL","v#01190494","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tutela_antecipada","n#01190561","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tutela_Antecipada","n#01190561","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beber_vinho","NULL","v#01190840","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfrutar","NULL","v#00809681 v#00810782 v#01247684","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gozar","NULL","v#00809681 v#00810782 v#01247684 v#02197360","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ditame","n#00771599","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distrair-se","NULL","v#01191232","NULL","NULL");
INSERT INTO portuguese_index VALUES ("divertir-se","NULL","v#01191232","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fatwa","n#01191610","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("veredicto","n#01192150","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("veredito","n#01192150","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mergulhar","NULL","v#00810652 v#01962865 v#01967373","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imergir","NULL","v#00810652 v#01085892 v#01086204","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dispor","NULL","v#01192628 v#01004644","NULL","NULL");
INSERT INTO portuguese_index VALUES ("poder","n#04041746 n#04044314 n#10048361 n#10396003","v#01192628 v#02744451","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enfadonho","NULL","NULL","a#01143295 a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("ponderado","NULL","NULL","a#01143295","NULL");
INSERT INTO portuguese_index VALUES ("fartar","NULL","v#01193721","NULL","NULL");
INSERT INTO portuguese_index VALUES ("saciar","NULL","v#01193721 v#00819436","NULL","NULL");
INSERT INTO portuguese_index VALUES ("quitação","n#01193886","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contentar","NULL","v#01194238 v#01816844","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atencioso","NULL","NULL","a#01145007","NULL");
INSERT INTO portuguese_index VALUES ("cevar","NULL","v#00812836","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sentir_o_gosto","NULL","v#00813161","NULL","NULL");
INSERT INTO portuguese_index VALUES ("legalização","n#01195380","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("serviçal","NULL","NULL","a#01145952","NULL");
INSERT INTO portuguese_index VALUES ("legitimação","n#01195584","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("degustar","NULL","v#01195675","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Processo","n#00775506","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abster-se","NULL","v#00813536 v#02463426","NULL","NULL");
INSERT INTO portuguese_index VALUES ("privar-se","NULL","v#00813536 v#01574799","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abster","NULL","v#00813536 v#02463426","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corte_marcial","n#01196316","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ordália","n#01196477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("braço_direito","NULL","NULL","a#01197634","NULL");
INSERT INTO portuguese_index VALUES ("metabolizar","NULL","v#01197750","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fumar","NULL","v#00815217","NULL","NULL");
INSERT INTO portuguese_index VALUES ("misto","NULL","NULL","a#01149429","NULL");
INSERT INTO portuguese_index VALUES ("sortido","NULL","NULL","a#01149429 a#02065665","NULL");
INSERT INTO portuguese_index VALUES ("homogêneo","NULL","NULL","a#01150078","NULL");
INSERT INTO portuguese_index VALUES ("homogéneo","NULL","NULL","a#01150078","NULL");
INSERT INTO portuguese_index VALUES ("homogênea","NULL","NULL","a#01150078","NULL");
INSERT INTO portuguese_index VALUES ("mastigar","NULL","v#01201089","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mascar","NULL","v#01201089","NULL","NULL");
INSERT INTO portuguese_index VALUES ("heterossexual","n#10173895","NULL","a#01201100","NULL");
INSERT INTO portuguese_index VALUES ("hetero","n#10173895","NULL","a#01201100","NULL");
INSERT INTO portuguese_index VALUES ("divórcio","n#01201271","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Divorcio","n#01201271","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homossexual","n#07324791","NULL","a#01151299","NULL");
INSERT INTO portuguese_index VALUES ("gay","n#07324791","NULL","a#01151299 a#01151663","NULL");
INSERT INTO portuguese_index VALUES ("homo","n#07324791","NULL","a#01151299","NULL");
INSERT INTO portuguese_index VALUES ("Quarentena","n#01201645","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reclusão","n#00778763","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ingurgitar","NULL","v#00817727","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deglutir","NULL","v#00817727","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cocooning","n#01201906","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bicha","n#06235683 n#06235973 n#06236741 n#06237025 n#06237536 n#06238584 n#07254887 n#07324791","NULL","a#01151663","NULL");
INSERT INTO portuguese_index VALUES ("veado","n#02430045 n#02431122 n#02431337 n#07254887 n#07324791","NULL","a#01151663","NULL");
INSERT INTO portuguese_index VALUES ("libar","NULL","v#00817921","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segregação","n#01202184 n#08380340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lésbico","NULL","NULL","a#01202212","NULL");
INSERT INTO portuguese_index VALUES ("transexual","n#10725893","NULL","a#01202634","NULL");
INSERT INTO portuguese_index VALUES ("transsexual","NULL","NULL","a#01202634","NULL");
INSERT INTO portuguese_index VALUES ("separatismo","n#01202665 n#04943704","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nutrir","NULL","v#00818436 v#00819568","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colaboração","n#00779286 n#00780822 n#00780971","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bissexuado","NULL","NULL","a#01203147","NULL");
INSERT INTO portuguese_index VALUES ("bissexual","n#09857007","NULL","a#01203147","NULL");
INSERT INTO portuguese_index VALUES ("bi","n#09857007","NULL","a#01203147","NULL");
INSERT INTO portuguese_index VALUES ("brainstorming","n#01203277","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hierárquico","NULL","NULL","a#01203288","NULL");
INSERT INTO portuguese_index VALUES ("hierárquica","NULL","NULL","a#01203288","NULL");
INSERT INTO portuguese_index VALUES ("trabalho_em_equipe","n#01203494","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conformidade","n#01203676 n#04713692 n#06211963 n#05363971 n#05364269 n#07176682 n#07176804 n#05367418 n#10064507 n#13971802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("graduável","NULL","NULL","a#01203873","NULL");
INSERT INTO portuguese_index VALUES ("matar_a_sede","NULL","v#00819436","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formalidade","n#01204055 n#04911420 n#07455007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alto","n#06872785","NULL","a#01153628 a#01154473 a#01159358 a#01393833 a#02228043 a#02273366","NULL");
INSERT INTO portuguese_index VALUES ("coação","n#00780822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("capitanear","NULL","NULL","a#02227888","NULL");
INSERT INTO portuguese_index VALUES ("magestoso","NULL","NULL","a#01154473","NULL");
INSERT INTO portuguese_index VALUES ("eminente","NULL","NULL","a#01154473","NULL");
INSERT INTO portuguese_index VALUES ("elevado","NULL","NULL","a#01154473 a#02353726","NULL");
INSERT INTO portuguese_index VALUES ("contratos_administrativos","n#01205564 n#05367418","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acordo","n#01205564 n#04894916 n#05072418 n#05074858 n#05363971 n#07176682 n#07176804 n#05367418 n#10064507 n#10065762 n#13971802 n#13971901","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("meio-termo","n#01205564 n#05366843","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encostar","NULL","v#00820504 v#01206849 v#01546768 v#01590007 v#01832678","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alto_nível","NULL","NULL","a#01205746","NULL");
INSERT INTO portuguese_index VALUES ("reconciliação","n#01205827","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dedicação","n#00781577","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("empinado","NULL","NULL","a#01206164","NULL");
INSERT INTO portuguese_index VALUES ("superior","NULL","NULL","a#01155248 a#02230368 a#02231896 a#02232640","NULL");
INSERT INTO portuguese_index VALUES ("esbarrar","NULL","v#01206849","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mexer","NULL","v#00821875 v#01446901 v#01249365 v#01277972 v#01292817 v#01293113 v#01399476 v#01430443 v#01448459","NULL","NULL");
INSERT INTO portuguese_index VALUES ("socorro","n#00782440 n#00783978","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ajuda","n#00782440 n#00783978 n#04015637 n#09546163","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("facilitação","n#01208291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("de_ponta","NULL","NULL","a#01208571","NULL");
INSERT INTO portuguese_index VALUES ("serviço_social","n#01208924","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manusear","NULL","v#01209953 v#00824033 v#00824623","NULL","NULL");
INSERT INTO portuguese_index VALUES ("puericultura","n#01209963","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apalpar","NULL","v#00823811 v#00898029 v#01314738 v#01455581","NULL","NULL");
INSERT INTO portuguese_index VALUES ("creche","n#01210439 n#03165466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Help_Desk","n#01210547","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("help_desk","n#01210547","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alojamento","n#01210816 n#03546340","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("graduado","NULL","NULL","a#01211665","NULL");
INSERT INTO portuguese_index VALUES ("consolação","n#00785538","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consolo","n#00785538 n#05570308","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("conforto","n#00785538 n#10364483 n#14446493 n#10396588","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("manejar","NULL","v#00824623 v#00834266 v#01664310","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Eliminação_da_conjunção","n#00785705","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mais_alto","NULL","NULL","a#01160972","NULL");
INSERT INTO portuguese_index VALUES ("derradeiro","NULL","NULL","a#01161103","NULL");
INSERT INTO portuguese_index VALUES ("passar","NULL","v#00825100 v#01611746 v#01401176 v#01418612 v#01526289 v#01720906 v#02709277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disparado","NULL","NULL","a#01212346","NULL");
INSERT INTO portuguese_index VALUES ("a_grande_altura","NULL","NULL","a#01212346","NULL");
INSERT INTO portuguese_index VALUES ("baixa","NULL","NULL","a#01161459","NULL");
INSERT INTO portuguese_index VALUES ("baixo","n#02260894 n#02804123 n#02804610 n#03897123 n#05142857","NULL","a#01161459 a#01396363 a#02274731","NULL");
INSERT INTO portuguese_index VALUES ("apoio","n#00786193 n#03444976 n#13365698","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suporte","n#00786193 n#00788240 n#03903868 n#04081044 n#03444976","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agarrar","NULL","v#00825349 v#00826635 v#00828075 v#01216331 v#00828409 v#00832443 v#00833964 v#00986697 v#01084280","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segurar","NULL","v#00825349 v#00828075 v#00828539 v#00833964 v#00986697 v#01508080 v#02215001 v#01842330","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aderência","n#00786502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adesão","n#00786502","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nasal","n#07119211","NULL","a#01213550 a#02978781","NULL");
INSERT INTO portuguese_index VALUES ("mecenato","n#01213886","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("usurpar","NULL","v#00923962 v#02274482","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agudo","NULL","NULL","a#01163535","NULL");
INSERT INTO portuguese_index VALUES ("auspício","n#00787413","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patrocínios","n#01215036","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("patrocínio","n#01215036","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apreender","NULL","v#00827485 v#02273293","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prender","NULL","v#00827485 v#00905930 v#00915832 v#02494356","NULL","NULL");
INSERT INTO portuguese_index VALUES ("endosso","n#00787700 n#06405198","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprovaçã0","n#00787796","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aprovação","n#00787796 n#05013089 n#06687178 n#05013621 n#06687701 n#05015182 n#06692572 n#05363971 n#05364269 n#07177192 n#10341656","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amparo","n#00788240 n#04192858","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pegar_de_súbito","NULL","v#00828075","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contrabaixo","n#02803934 n#02804123","NULL","a#01216145","NULL");
INSERT INTO portuguese_index VALUES ("sustentação","n#00788511","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agarrar_com_firmeza","NULL","v#00828409","NULL","NULL");
INSERT INTO portuguese_index VALUES ("abrochar","NULL","v#00828409","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Representação_proporcional","n#01217720","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contratação","n#00789880","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("admiração","n#00790504 n#05575841 n#05582358 n#05582577 n#07510184","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adulação","n#01218766 n#06695579 n#06695753","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("glorificação","n#01218932","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escorar","NULL","v#00830295 v#01304944","NULL","NULL");
INSERT INTO portuguese_index VALUES ("idealização","n#01219075","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alpino","NULL","NULL","a#01168321 a#02781577 a#02781733","NULL");
INSERT INTO portuguese_index VALUES ("alpestre","NULL","NULL","a#01168321 a#02781733","NULL");
INSERT INTO portuguese_index VALUES ("montanhoso","NULL","NULL","a#01168553","NULL");
INSERT INTO portuguese_index VALUES ("aferrar","NULL","v#01220303","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enganchar","NULL","v#01220303 v#00934848","NULL","NULL");
INSERT INTO portuguese_index VALUES ("difamação","n#01220336","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aderir","NULL","v#00831685 v#00929232","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colar","n#02417043 n#03024882 n#03034095","v#00831685 v#00909290 v#00928943","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comportamento","n#00792210 n#00792361 n#03835766 n#03844696 n#10091030","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("heterológico","NULL","NULL","a#01221057","NULL");
INSERT INTO portuguese_index VALUES ("aglutinar","NULL","v#01221684 v#01222016","NULL","NULL");
INSERT INTO portuguese_index VALUES ("honesta","NULL","NULL","a#01222360","NULL");
INSERT INTO portuguese_index VALUES ("sincero","NULL","NULL","a#01222360 a#00862877 a#02043991 a#02094882","NULL");
INSERT INTO portuguese_index VALUES ("sincera","NULL","NULL","a#01222360","NULL");
INSERT INTO portuguese_index VALUES ("bullying","n#01222477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intimidação","n#01222477 n#07523760 n#07542881","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("girar","NULL","v#00832742 v#01274944 v#01397433 v#02046572 v#01398848 v#01436577","NULL","NULL");
INSERT INTO portuguese_index VALUES ("zombaria","n#00793584","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desonroso","NULL","NULL","a#01222884 a#01227137","NULL");
INSERT INTO portuguese_index VALUES ("enrolar","NULL","v#01223616","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encantador","NULL","NULL","a#01223781","NULL");
INSERT INTO portuguese_index VALUES ("encrespar","NULL","v#01223833","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frisar","NULL","v#01223833","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enganoso","NULL","NULL","a#01173082 a#01224253 a#01583880","NULL");
INSERT INTO portuguese_index VALUES ("brincar_com","NULL","v#01224211","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enganador","NULL","NULL","a#01224253 a#01583880","NULL");
INSERT INTO portuguese_index VALUES ("ilusório","NULL","NULL","a#01224253 a#01583880 a#01937390","NULL");
INSERT INTO portuguese_index VALUES ("simulado","n#01224700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insolência","n#01224914 n#03848510","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afronta","n#00794619","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insulto","n#00794619 n#05036589","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indignidade","n#01225299","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("retransmitir","NULL","v#01225576","NULL","NULL");
INSERT INTO portuguese_index VALUES ("veraz","NULL","NULL","a#01225772","NULL");
INSERT INTO portuguese_index VALUES ("desconsideração","n#00795053","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("afagar","NULL","v#00835172 v#00835355 v#01226600 v#01425892 v#01752616","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esnobada","n#00795231","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desprezo","n#00795231 n#03848385 n#05037154 n#05577544 n#05610803","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("embusteiro","NULL","NULL","a#01226129","NULL");
INSERT INTO portuguese_index VALUES ("acariciar","NULL","v#00835355 v#01226600 v#01243661 v#00976384 v#01425348 v#01425511 v#01425892","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mimosear","NULL","v#01226600 v#01425892 v#01752616","NULL","NULL");
INSERT INTO portuguese_index VALUES ("augusto","NULL","NULL","a#01226660","NULL");
INSERT INTO portuguese_index VALUES ("venerável","NULL","NULL","a#01226660 a#01646794","NULL");
INSERT INTO portuguese_index VALUES ("favor","n#00795713 n#04016883","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imoral","NULL","NULL","a#01227137 a#01549291","NULL");
INSERT INTO portuguese_index VALUES ("piedade","n#01227495 n#03785586 n#03785836 n#05615127 n#05615476 n#05615645","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desgraçado","NULL","NULL","a#01227546","NULL");
INSERT INTO portuguese_index VALUES ("ignominioso","NULL","NULL","a#01227546","NULL");
INSERT INTO portuguese_index VALUES ("torpe","NULL","NULL","a#01227546","NULL");
INSERT INTO portuguese_index VALUES ("perfurar","n#04024396","v#00836413 v#01441100 v#00989536 v#01443021","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ternura","n#00796487 n#05615833","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("civilidade","n#00796572 n#04914133","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cortesia","n#00796730 n#03846037 n#04912982 n#03846796 n#05036276","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sentido","n#00797132 n#05651971 n#04474450 n#04546018 n#04952374","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("galanteria","n#01228792","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("expectante","NULL","NULL","a#01228797","NULL");
INSERT INTO portuguese_index VALUES ("respeito","n#00797364 n#04704758 n#10358350","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("reverência","n#00797364 n#07274890","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desesperado","NULL","NULL","a#01229020 a#01752815","NULL");
INSERT INTO portuguese_index VALUES ("falta_de_esperança","NULL","NULL","a#01229020","NULL");
INSERT INTO portuguese_index VALUES ("permear","NULL","v#01229071","NULL","NULL");
INSERT INTO portuguese_index VALUES ("preito","n#00797621","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("homenagem","n#00797621","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pálida","NULL","NULL","a#01178561","NULL");
INSERT INTO portuguese_index VALUES ("escalvado","NULL","NULL","a#01178561","NULL");
INSERT INTO portuguese_index VALUES ("assembléia","n#00798100 n#06071059","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apunhalar","NULL","v#01230350 v#01231652","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esfaquear","NULL","v#01230350 v#01231652","NULL","NULL");
INSERT INTO portuguese_index VALUES ("convocação","n#00798926 n#06213417","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encontro","n#00799023 n#00799534 n#05518643 n#06167318 n#06204637","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("institucional","NULL","NULL","a#01180352 a#02579660","NULL");
INSERT INTO portuguese_index VALUES ("cutucar","NULL","v#01231252","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hora_combinada","n#00799534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rendez-vous","n#00799534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rendezvous","n#00799534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("local_combinado","n#00799534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ponto_de_encontro","n#00799534","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aferroar","NULL","v#01231652","NULL","NULL");
INSERT INTO portuguese_index VALUES ("congregação","n#00799654 n#05986276","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sessão","n#00799933 n#05345420","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consolável","NULL","NULL","a#01232204","NULL");
INSERT INTO portuguese_index VALUES ("inconsolável","NULL","NULL","a#01232298","NULL");
INSERT INTO portuguese_index VALUES ("desolado","NULL","NULL","a#01232507 a#01191747","NULL");
INSERT INTO portuguese_index VALUES ("horizontal","NULL","NULL","a#01181690","NULL");
INSERT INTO portuguese_index VALUES ("transversal","NULL","NULL","a#01232917 a#01445705 a#01445917","NULL");
INSERT INTO portuguese_index VALUES ("dar_um_tapa","NULL","v#01233027","NULL","NULL");
INSERT INTO portuguese_index VALUES ("visita","n#00800256 n#07135598 n#07668613","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fio_de_prumo","NULL","NULL","a#01182362","NULL");
INSERT INTO portuguese_index VALUES ("vertical","NULL","NULL","a#01182362 a#01182936 a#01235859","NULL");
INSERT INTO portuguese_index VALUES ("comparecimento","n#00800467","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("presença","n#00800467 n#00800818 n#03844696 n#04544425 n#06364655 n#06896983 n#10056790","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("honrado","NULL","NULL","a#01182936","NULL");
INSERT INTO portuguese_index VALUES ("inclinado","NULL","NULL","a#01183055 a#01239240","NULL");
INSERT INTO portuguese_index VALUES ("telhar","NULL","v#01234223 v#01338663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entelhar","NULL","v#01234223","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ausência","n#00801297 n#10058951 n#14088412 n#10367399","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("absenteísmo","n#01234528","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("absentismo","n#01234528 n#01234612","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Absenteísmo_escolar","n#01234612","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("oblíqua","NULL","NULL","a#01183635","NULL");
INSERT INTO portuguese_index VALUES ("esguelhado","NULL","NULL","a#01183635","NULL");
INSERT INTO portuguese_index VALUES ("enviesado","NULL","NULL","a#01183635","NULL");
INSERT INTO portuguese_index VALUES ("revanche","n#00802092","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vingança","n#00802092 n#00802243 n#01235946","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trabalhar","NULL","v#01235355 v#01145518 v#01641924 v#01643531 v#02415039 v#02419773 v#01769888","NULL","NULL");
INSERT INTO portuguese_index VALUES ("represália","n#01235946","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dar_uma_cabeçada","NULL","v#01236009","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colidir","NULL","v#00841893 v#00844770 v#01076634","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ortostático","NULL","NULL","a#01236716","NULL");
INSERT INTO portuguese_index VALUES ("rivalidade","n#01236947","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dente_por_dente","n#01237080","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("olho_por_olho","n#01237080","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("troco","n#01237080 n#09642046","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("democratização","n#01237294","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("errar","NULL","v#00843365 v#01284430 v#01925694","NULL","NULL");
INSERT INTO portuguese_index VALUES ("falhar","NULL","v#00843365 v#01723893 v#01724773","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descentralização_de_poderes","n#01238058","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descentralização","n#01238058","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Integração_Vertical","n#01238607","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Integração_vertical","n#01238607","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("socar","NULL","v#00843947","NULL","NULL");
INSERT INTO portuguese_index VALUES ("participação","n#00804778 n#09932591 n#13924659","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("propenso","NULL","NULL","a#01239534 a#01292884","NULL");
INSERT INTO portuguese_index VALUES ("chocar","NULL","v#00844770 v#01762963 v#01783022 v#01235670","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mediação","n#01240432 n#07150644 n#08352303","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("roçar","NULL","v#00845525 v#00893983 v#01319562","NULL","NULL");
INSERT INTO portuguese_index VALUES ("neutralidade","n#01240850 n#05039819 n#06205018","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rega_(pulverização)","NULL","NULL","a#01240931","NULL");
INSERT INTO portuguese_index VALUES ("justificação","n#01241331 n#00806644 n#04485374 n#05051677 n#05052012","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exoneração","n#01241331","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("justificativa","n#00806644 n#04485374 n#05051677","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hospitaleira","NULL","NULL","a#01242101","NULL");
INSERT INTO portuguese_index VALUES ("hospitaleiro","NULL","NULL","a#01242101 a#01914346","NULL");
INSERT INTO portuguese_index VALUES ("inóspito","NULL","NULL","a#01242489 a#01192235 a#01244195","NULL");
INSERT INTO portuguese_index VALUES ("Resistência_não-violenta","n#01242716","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("resistência_não_violenta","n#01242716","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("árido","NULL","NULL","a#01191747 a#02430075","NULL");
INSERT INTO portuguese_index VALUES ("greve_de_fome","n#01242962","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ramadão","n#01243089 n#15218272","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Satyagraha","n#01243262","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hostil","NULL","NULL","a#01192235","NULL");
INSERT INTO portuguese_index VALUES ("greve","n#00807301 n#01244341","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("limpar_o_pó","NULL","v#01244351","NULL","NULL");
INSERT INTO portuguese_index VALUES ("dragar","NULL","v#01244516","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desenrascanço","n#01244593","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beligerante","NULL","NULL","a#01193636","NULL");
INSERT INTO portuguese_index VALUES ("Sabotagem","n#01244895","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sabotagem","n#01244895","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exterminação","n#00808417","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Genocídios","n#01245159","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("solução_final","n#01245471","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Holocausto","n#01245471","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alisar","NULL","v#01245986 v#01252971 v#01583993","NULL","NULL");
INSERT INTO portuguese_index VALUES ("contrário","NULL","NULL","a#01746928 a#01662756 a#02269846","NULL");
INSERT INTO portuguese_index VALUES ("oposto","NULL","NULL","a#01746928 a#01662756 a#01993040","NULL");
INSERT INTO portuguese_index VALUES ("amolar","NULL","v#00850117","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tocaia","n#01246926","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Emboscada","n#01246926","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emboscada","n#01246926","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bem-intencionado","NULL","NULL","a#01247025","NULL");
INSERT INTO portuguese_index VALUES ("forgoso","NULL","NULL","a#01247240","NULL");
INSERT INTO portuguese_index VALUES ("ricochetear","NULL","v#00850850","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alforria","n#01247807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("burrice","n#01248075","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estupidez","n#01248075 n#05645597","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("admissão","n#00810466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acolhimento","n#00810466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acolhida","n#00810466","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ígneo","NULL","NULL","a#01248958 a#01354925 a#02852265","NULL");
INSERT INTO portuguese_index VALUES ("amnistia","n#00811226","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("indulto","n#00811226","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("escombro","n#01249483","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demolição_de_edifícios","n#01249483","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("demolição","n#01249483 n#05465405","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vandalismo","n#01249816","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vandalismo","n#01249816","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("emenda","n#00811685","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Infanticidio","n#01250492","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infanticídio","n#01250492","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infanticida","n#01250492 n#10204833","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("térmico","NULL","NULL","a#01199167 a#02613791","NULL");
INSERT INTO portuguese_index VALUES ("termal","NULL","NULL","a#01199167 a#02613791","NULL");
INSERT INTO portuguese_index VALUES ("transmutação","n#01250826 n#05481414","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tropical","NULL","NULL","a#01199477 a#01364102 a#02324343 a#02929500","NULL");
INSERT INTO portuguese_index VALUES ("arranhar","NULL","v#00852916 v#01306654","NULL","NULL");
INSERT INTO portuguese_index VALUES ("friccionar","NULL","v#00853039","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ártico","n#08496477","NULL","a#01200711 a#02687613","NULL");
INSERT INTO portuguese_index VALUES ("polar","NULL","NULL","a#01200711 a#02444147","NULL");
INSERT INTO portuguese_index VALUES ("esmaecer","NULL","v#01252216","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colonização","n#00814102","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desmonte","n#01252800","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("radiação","n#00814655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irradiação","n#00814655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exposição_às_radiações","n#00814655","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("radiações","n#00814655 n#07828438 n#13545184","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("frigorífico","n#04070727","NULL","a#01253022","NULL");
INSERT INTO portuguese_index VALUES ("emanação","n#00814731","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gélido","NULL","NULL","a#01253592","NULL");
INSERT INTO portuguese_index VALUES ("refrigerante_(mecânica)","NULL","NULL","a#01253661","NULL");
INSERT INTO portuguese_index VALUES ("harmonização","n#01253778","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("juvenil","n#06950430","NULL","a#01254432 a#01430680 a#01589874","NULL");
INSERT INTO portuguese_index VALUES ("teletransporte","n#01254473","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fatiar","NULL","v#01254477","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amputar","NULL","v#01254692","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estival","NULL","NULL","a#01203530","NULL");
INSERT INTO portuguese_index VALUES ("outonal","NULL","NULL","a#01255296 a#01491930","NULL");
INSERT INTO portuguese_index VALUES ("karaokê","n#01255302","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Karaoke","n#01255302","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("invernoso","NULL","NULL","a#01255807","NULL");
INSERT INTO portuguese_index VALUES ("invernal","NULL","NULL","a#01255807","NULL");
INSERT INTO portuguese_index VALUES ("hibernal","NULL","NULL","a#01255807","NULL");
INSERT INTO portuguese_index VALUES ("Solmização","n#01255935","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esculpir","NULL","v#00856483 v#01068877 v#01684337","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forjar","n#03562262","v#01256374","NULL","NULL");
INSERT INTO portuguese_index VALUES ("liderança","n#00816340 n#04017485 n#05617310 n#10355477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("talhar","NULL","v#00856759 v#01611123","NULL","NULL");
INSERT INTO portuguese_index VALUES ("timão","n#01256615 n#03512911","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("leme","n#01256615 n#03512911 n#04117216","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Terminal","n#01256743","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sensual","NULL","NULL","a#01257145 a#01710829 a#02131072","NULL");
INSERT INTO portuguese_index VALUES ("precedência","n#01257145 n#05047279 n#13949802","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tórrido","NULL","NULL","a#01257330","NULL");
INSERT INTO portuguese_index VALUES ("Aluvião","n#00817192 n#09193282","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aluvião","n#00817192 n#11445395 n#07796648","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("liberdade_condicional","n#01257701 n#01258251","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("condicional","n#01257701","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("povoação","n#00817287","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("população","n#00817287 n#05957883 n#06069040 n#06079663 n#08179879 n#13779804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decepar","NULL","v#01258091","NULL","NULL");
INSERT INTO portuguese_index VALUES ("picar","NULL","v#01258091 v#00991175","NULL","NULL");
INSERT INTO portuguese_index VALUES ("glacial","NULL","NULL","a#01206648","NULL");
INSERT INTO portuguese_index VALUES ("abater","NULL","v#00857882","NULL","NULL");
INSERT INTO portuguese_index VALUES ("derrubar","NULL","v#00857882 v#01700655 v#01345619 v#01437506","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revogação","n#01258852","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("antropóide","NULL","NULL","a#01259015 a#01260282","NULL");
INSERT INTO portuguese_index VALUES ("antropomorfo","NULL","NULL","a#01259123","NULL");
INSERT INTO portuguese_index VALUES ("antropomórfico","NULL","NULL","a#01259123","NULL");
INSERT INTO portuguese_index VALUES ("trabalhar_a_pedra","NULL","v#01259328","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cinzelar","NULL","v#01259328","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imperfeito","n#13805020 n#13805734","NULL","a#01207972 a#01752167","NULL");
INSERT INTO portuguese_index VALUES ("lascar","NULL","v#01259458 v#02469274","NULL","NULL");
INSERT INTO portuguese_index VALUES ("galhofa","n#00818628","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inumano","NULL","NULL","a#01260707 a#01262611 a#01212686","NULL");
INSERT INTO portuguese_index VALUES ("desumano","NULL","NULL","a#01260707 a#01262611 a#01212686","NULL");
INSERT INTO portuguese_index VALUES ("excitação","n#00818927 n#05596946 n#10111097","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desflorestação","n#01262441 n#14519097","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("podar","NULL","v#00861159 v#00901682 v#00901990 v#01075495","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pelar","NULL","v#00861277","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desalmado","NULL","NULL","a#01212393","NULL");
INSERT INTO portuguese_index VALUES ("cruel","NULL","NULL","a#01212393","NULL");
INSERT INTO portuguese_index VALUES ("brutal","NULL","NULL","a#01212393 a#01212141","NULL");
INSERT INTO portuguese_index VALUES ("bestial","NULL","NULL","a#01212141","NULL");
INSERT INTO portuguese_index VALUES ("recrutamento","n#01263711","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("A_Sangue_Frio","NULL","NULL","a#01212686","NULL");
INSERT INTO portuguese_index VALUES ("A_sangue_frio","NULL","NULL","a#01212686","NULL");
INSERT INTO portuguese_index VALUES ("consulta","n#00820543 n#05343797","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revestir","NULL","v#01264283 v#00867480 v#02339413","NULL","NULL");
INSERT INTO portuguese_index VALUES ("humorístico","NULL","NULL","a#01212979","NULL");
INSERT INTO portuguese_index VALUES ("engraçado","NULL","NULL","a#01212979 a#01213770 a#01267076","NULL");
INSERT INTO portuguese_index VALUES ("desabafo","n#00820821","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("busseta","NULL","NULL","a#01213430","NULL");
INSERT INTO portuguese_index VALUES ("cômico","n#07168145","NULL","a#01213770 a#02973392","NULL");
INSERT INTO portuguese_index VALUES ("cômica","NULL","NULL","a#01213770","NULL");
INSERT INTO portuguese_index VALUES ("divertido","NULL","NULL","a#01213770 a#01737913 a#01738083 a#01733541","NULL");
INSERT INTO portuguese_index VALUES ("limpeza_étnica","n#01265734","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Limpeza_étnica","n#01265734","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irônico","NULL","NULL","a#01266092 a#02123118","NULL");
INSERT INTO portuguese_index VALUES ("hilário","NULL","NULL","a#01266841","NULL");
INSERT INTO portuguese_index VALUES ("hilária","NULL","NULL","a#01266841","NULL");
INSERT INTO portuguese_index VALUES ("hilariante","NULL","NULL","a#01266841","NULL");
INSERT INTO portuguese_index VALUES ("galvanizar","NULL","v#01266895","NULL","NULL");
INSERT INTO portuguese_index VALUES ("jocoso","NULL","NULL","a#01267076","NULL");
INSERT INTO portuguese_index VALUES ("gracejador","NULL","NULL","a#01267076","NULL");
INSERT INTO portuguese_index VALUES ("pavimentar","NULL","v#01267098","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Up_grade","n#01267588","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Upgrade","n#01267588","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vampirismo","n#01267808","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cobrir_com_asfalto","NULL","v#01267866","NULL","NULL");
INSERT INTO portuguese_index VALUES ("asfaltar","NULL","v#01267866","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pôr_manteiga","NULL","v#01267998","NULL","NULL");
INSERT INTO portuguese_index VALUES ("passar_manteiga_em","NULL","v#01267998","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amanteigar","NULL","v#01267998","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sutil","NULL","NULL","a#01268194","NULL");
INSERT INTO portuguese_index VALUES ("espirituoso","NULL","NULL","a#01268194","NULL");
INSERT INTO portuguese_index VALUES ("Xenoenxerto","n#01268271","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sondar","NULL","v#01268297","NULL","NULL");
INSERT INTO portuguese_index VALUES ("azeitar","NULL","v#01268571","NULL","NULL");
INSERT INTO portuguese_index VALUES ("com_fome","NULL","NULL","a#01216853","NULL");
INSERT INTO portuguese_index VALUES ("esfomeado","NULL","NULL","a#01216853","NULL");
INSERT INTO portuguese_index VALUES ("esfomeada","NULL","NULL","a#01216853","NULL");
INSERT INTO portuguese_index VALUES ("faminto","NULL","NULL","a#01216853 a#01217232 a#02190848","NULL");
INSERT INTO portuguese_index VALUES ("envernizar","NULL","v#01269224","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_do_Alamo","n#01269360","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("faminta","NULL","NULL","a#01217232","NULL");
INSERT INTO portuguese_index VALUES ("vidrar","NULL","v#01269521","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Atlanta","n#01269633 n#09076675","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("caiar","NULL","v#01269702 v#02148109","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sedento","NULL","NULL","a#01270004","NULL");
INSERT INTO portuguese_index VALUES ("com_sede","NULL","NULL","a#01270004 a#02554140","NULL");
INSERT INTO portuguese_index VALUES ("apressado","NULL","NULL","a#01270175 a#01270704","NULL");
INSERT INTO portuguese_index VALUES ("Corregidor","n#01270343","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_da_Grã-Bretanha","n#01270628","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("precipitado","NULL","NULL","a#01270704 a#01270868","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_do_Bulge","n#01271107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_do_bulge","n#01271107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("identificável","NULL","NULL","a#01272397","NULL");
INSERT INTO portuguese_index VALUES ("cobrir_com_alcatrão","NULL","v#01272457","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alcatroar","NULL","v#01272457","NULL","NULL");
INSERT INTO portuguese_index VALUES ("classificável","NULL","NULL","a#01272718","NULL");
INSERT INTO portuguese_index VALUES ("diagnosticável","NULL","NULL","a#01272836","NULL");
INSERT INTO portuguese_index VALUES ("intangível","NULL","NULL","a#01273454","NULL");
INSERT INTO portuguese_index VALUES ("irreconhecível","NULL","NULL","a#01273773","NULL");
INSERT INTO portuguese_index VALUES ("subjetivo","NULL","NULL","a#01221591 a#01557713","NULL");
INSERT INTO portuguese_index VALUES ("Cannae","n#01274000","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lesionado","NULL","NULL","a#01274261","NULL");
INSERT INTO portuguese_index VALUES ("atingido","NULL","NULL","a#01274261","NULL");
INSERT INTO portuguese_index VALUES ("deteriorado","NULL","NULL","a#01274261","NULL");
INSERT INTO portuguese_index VALUES ("circuncidar","NULL","v#01274341","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Queroneia","n#01274531","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esfolar","NULL","v#01274657","NULL","NULL");
INSERT INTO portuguese_index VALUES ("puncionar","NULL","v#00870386","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chapultepec","n#01275142","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grande","NULL","NULL","a#01224655 a#01328712 a#01387149 a#01394252 a#01160734","NULL");
INSERT INTO portuguese_index VALUES ("básico","NULL","NULL","a#01224859","NULL");
INSERT INTO portuguese_index VALUES ("proficiente","NULL","NULL","a#02228883","NULL");
INSERT INTO portuguese_index VALUES ("Dien_Bien_Phu","n#01277540","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("notável","n#10276238","NULL","a#01225735 a#01160734 a#02080535 a#02463310","NULL");
INSERT INTO portuguese_index VALUES ("grandioso","NULL","NULL","a#01278251 a#01160734","NULL");
INSERT INTO portuguese_index VALUES ("o_máximo","NULL","NULL","a#01412424","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Fontenoy","n#01278873","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("histórico","n#04678654 n#15121406","NULL","a#02720062 a#01666584 a#01865778 a#02695970","NULL");
INSERT INTO portuguese_index VALUES ("franzir","NULL","v#00873481","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perceptível","NULL","NULL","a#01279310","NULL");
INSERT INTO portuguese_index VALUES ("que_pode_ser_medido","NULL","NULL","a#01279310","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_gettysburg","n#01279615","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Gettysburg","n#01279615","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estratégico","NULL","NULL","a#01226931 a#02720498","NULL");
INSERT INTO portuguese_index VALUES ("insignificante","NULL","NULL","a#01228148 a#01413178 a#01437706 a#02383331","NULL");
INSERT INTO portuguese_index VALUES ("trivial","NULL","NULL","a#01228148 a#01688757 a#02046079","NULL");
INSERT INTO portuguese_index VALUES ("Revolta_dos_sipais","n#01281154","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolta_dos_Sipais","n#01281154","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Ipso","n#01281427","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("imponente","NULL","NULL","a#01229558","NULL");
INSERT INTO portuguese_index VALUES ("surpreendente","NULL","NULL","a#01229558 a#02248299 a#02248624","NULL");
INSERT INTO portuguese_index VALUES ("embrulhar","NULL","v#00876484 v#01088107","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impo","NULL","NULL","a#01230556","NULL");
INSERT INTO portuguese_index VALUES ("nobre","n#10271677","NULL","a#01230556 a#01530980 a#01533758 a#01861920 a#02513269","NULL");
INSERT INTO portuguese_index VALUES ("Leuctra","n#01283753","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fulgurante","NULL","NULL","a#01283787","NULL");
INSERT INTO portuguese_index VALUES ("Leyte","n#01284124","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acertado","NULL","NULL","a#01231198","NULL");
INSERT INTO portuguese_index VALUES ("espectacular","NULL","NULL","a#01231198","NULL");
INSERT INTO portuguese_index VALUES ("desembrulhar","NULL","v#01284271","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Little_Big_Horn","n#01284444","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_little_bighorn","n#01284444","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Little_Bighorn","n#01284444","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desatar","NULL","v#00877495 v#00891231 v#00919225 v#00919360","NULL","NULL");
INSERT INTO portuguese_index VALUES ("formigueiro","NULL","NULL","a#01284836","NULL");
INSERT INTO portuguese_index VALUES ("formidável","NULL","NULL","a#01284836 a#01160734","NULL");
INSERT INTO portuguese_index VALUES ("atar","NULL","v#00877947 v#00878404 v#00879090 v#00888252 v#00890366 v#01303547","NULL","NULL");
INSERT INTO portuguese_index VALUES ("juntar","NULL","v#00877947 v#00881672 v#00881999 v#00884615 v#00885494 v#01306853 v#00927388 v#00946301 v#01560184 v#01576236 v#02488834 v#01697233","NULL","NULL");
INSERT INTO portuguese_index VALUES ("amarrar","NULL","v#00877947 v#00879090 v#00888252 v#00890366","NULL","NULL");
INSERT INTO portuguese_index VALUES ("copular","NULL","v#00877947 v#00977560 v#00979971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_Macedônicas","n#01285567","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_magenta","n#01285784","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Magenta","n#01285784","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Baía_de_manila","n#01286181","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Baía_de_Manila","n#01286181","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mantineia","n#01286393","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("percebível","NULL","NULL","a#01233569","NULL");
INSERT INTO portuguese_index VALUES ("que_se_pode_detectar","NULL","NULL","a#01233569","NULL");
INSERT INTO portuguese_index VALUES ("detectável","NULL","NULL","a#01234018","NULL");
INSERT INTO portuguese_index VALUES ("observável","NULL","NULL","a#01234186","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_midway","n#01287782","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Midway","n#01287782","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("marcado","NULL","NULL","a#00152474","NULL");
INSERT INTO portuguese_index VALUES ("agrilhoar","NULL","v#01288052","NULL","NULL");
INSERT INTO portuguese_index VALUES ("algemar","NULL","v#01288052 v#01288201","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acorrentar","NULL","v#01288052","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Minden","n#01288057","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desencadear","NULL","v#00880156 v#00880392 v#01011908 v#01129019","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encadear","NULL","v#01288636","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Orleães","n#01289830","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cravar","NULL","v#00881419 v#00892529 v#00928943 v#00988821","NULL","NULL");
INSERT INTO portuguese_index VALUES ("grudar","NULL","v#00881672 v#01614581","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mar_das_Filipinas","n#01290997","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mar_das_filipinas","n#01290997","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("portátil","NULL","NULL","a#01291589 a#01525776","NULL");
INSERT INTO portuguese_index VALUES ("Pleven","n#01291674","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Poitiers","n#01291839","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ter_queda_para","NULL","NULL","a#01239240","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_puebla","n#01292200","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("batalha_de_Puebla","n#01292200","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Pidna","n#01292343","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("unir_por_anastomose","NULL","v#01292366","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anastomosar","NULL","v#01292366","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ravenna","n#01292553","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_rocroi","n#01292735","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Rocroi","n#01292735","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tendente","NULL","NULL","a#01292884","NULL");
INSERT INTO portuguese_index VALUES ("acoplar","NULL","v#00883027 v#00884615","NULL","NULL");
INSERT INTO portuguese_index VALUES ("casar","NULL","v#00883027 v#02488834 v#01696632","NULL","NULL");
INSERT INTO portuguese_index VALUES ("predisposto","NULL","NULL","a#01293049","NULL");
INSERT INTO portuguese_index VALUES ("acidente-accident-prone","NULL","NULL","a#01293049","NULL");
INSERT INTO portuguese_index VALUES ("avesso","NULL","NULL","a#01240781 a#01694081","NULL");
INSERT INTO portuguese_index VALUES ("Salerno","n#01293650","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Santiago_de_Cuba","n#01293832 n#08750822","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desunir","NULL","v#01294182","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extrovertido","NULL","NULL","a#01294185 a#01295443 a#02149674","NULL");
INSERT INTO portuguese_index VALUES ("desarticular","NULL","v#01294632","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Soissons","n#01294791","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sucessivo","NULL","NULL","a#01242110 a#01608832","NULL");
INSERT INTO portuguese_index VALUES ("futuro","n#03408721 n#04777460 n#10849807 n#10964560","NULL","a#01242110 a#01668628 a#01811757 a#02992914","NULL");
INSERT INTO portuguese_index VALUES ("Somme","n#01295373 n#01295528","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suturar","NULL","v#01296154","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Siracusa","n#01296296","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anexar","NULL","v#00885494 v#00906566 v#01328705 v#01329141","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Tarawa","n#01296697","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deduzível","NULL","NULL","a#01296718","NULL");
INSERT INTO portuguese_index VALUES ("ilativo","NULL","NULL","a#01296816 a#01296961 a#02748952","NULL");
INSERT INTO portuguese_index VALUES ("Depender_de_algo","NULL","v#01297174","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Prender_por_drobradiça","NULL","v#01297174","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prender_por_drobradiça","NULL","v#01297174","NULL","NULL");
INSERT INTO portuguese_index VALUES ("etiquetar","NULL","v#01297401 v#01588493","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Termópilas","n#01297484","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("decadente","NULL","NULL","a#01297658","NULL");
INSERT INTO portuguese_index VALUES ("voluptuoso","NULL","NULL","a#01298239","NULL");
INSERT INTO portuguese_index VALUES ("desvincular","NULL","v#00887219","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_waterloo","n#01299476","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Batalha_de_Waterloo","n#01299476","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("descolar","NULL","v#00887884","NULL","NULL");
INSERT INTO portuguese_index VALUES ("severo","NULL","NULL","a#01247049 a#01450767","NULL");
INSERT INTO portuguese_index VALUES ("Ypres","n#01300508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("disciplinar","NULL","v#02553428","a#01300661 a#03061081 a#03061455","NULL");
INSERT INTO portuguese_index VALUES ("reter","NULL","v#00889308 v#01508080 v#01516187 v#02215001 v#01560310 v#01670590 v#01803556 v#01829600 v#01842985","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Civil_Americana","n#01301630","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_de_Secessão","n#01301630","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_de_secessão","n#01301630","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_da_Independência_dos_Estados_Unidos_da_América","n#01302086","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_seis_dias","n#01302449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_Seis_Dias","n#01302449","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_Yom_Kipur","n#01302683","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_yom_kipur","n#01302683","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("infeccioso","NULL","NULL","a#01302811","NULL");
INSERT INTO portuguese_index VALUES ("contagioso","NULL","NULL","a#01302811 a#01303042 a#01303298","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_dos_Balcãs","n#01302935","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_dos_Bálcãs","n#01302935","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transmissível","NULL","NULL","a#01303042","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_boers","n#01303252","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_Boers","n#01303252","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_comunista_chinesa","n#01303582","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_da_Crimeia","n#01303739","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_cubana","n#01303934","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_Cubana","n#01303934","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Civil_Inglesa","n#01304121","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_civil_inglesa","n#01304121","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_Gloriosa","n#01304356","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_gloriosa","n#01304356","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("noticioso","NULL","NULL","a#01250761 a#01270374 a#01251743","NULL");
INSERT INTO portuguese_index VALUES ("informativo","NULL","NULL","a#01250761 a#01251743 a#02749150","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Franco-Prussiana","n#01304629","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estar_ancorado_no_ancoradouro","NULL","v#01304716","NULL","NULL");
INSERT INTO portuguese_index VALUES ("consultivo","NULL","NULL","a#01304802","NULL");
INSERT INTO portuguese_index VALUES ("aconselhador","NULL","NULL","a#01304802","NULL");
INSERT INTO portuguese_index VALUES ("consultor","n#07065373","NULL","a#01304802","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Franco-Indígena","n#01304820","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_franco-indígena","n#01304820","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ancorar","NULL","v#01304944","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_Francesa","n#01305007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revoluçao_francesa","n#01305007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_francesa","n#01305007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atracar","NULL","v#01305099","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_Cem_Anos","n#01305147","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_golfo","n#01305310","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_Golfo","n#01305310","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_da_Coreia","n#01305551","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gnóstico","NULL","NULL","a#01305792","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_Mexicana","n#01305796","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_mexicana","n#01305796","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agnóstico","n#09779124","NULL","a#01305929","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_Napoleónicas","n#01306358","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_Napoleônicas","n#01306358","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_Peloponeso","n#01306911","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_peloponeso","n#01306911","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_punicas","n#01307299","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_púnicas","n#01307299","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerras_Púnicas","n#01307299","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("guerra_púnica","n#01307299","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("culto","NULL","NULL","a#01307375","NULL");
INSERT INTO portuguese_index VALUES ("aplainar","NULL","v#01307389","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_de_fevereiro","n#01307754","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_de_Fevereiro","n#01307754","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_de_Outubro","n#01308008","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Revolução_de_outubro","n#01308008","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lido","NULL","NULL","a#01254561","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Russo-Japonesa","n#01308260","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("repor","NULL","v#00894115","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_sete_anos","n#01308438","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_Sete_Anos","n#01308438","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Hispano-Americana","n#01308668","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("perdido","NULL","NULL","a#01308736 a#01450178","NULL");
INSERT INTO portuguese_index VALUES ("sem_pistas","NULL","NULL","a#01308736","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_Civil_Espanhola","n#01308837","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_dos_Trinta_Anos","n#01309109","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rascar","NULL","v#00894368","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coçar","NULL","v#00894368","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_de_Tróia","n#01309395","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_de_Troia","n#01309395","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_de_tróia","n#01309395","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cavar","NULL","v#01309701 v#01310249 v#01311103 v#01312810 v#01443021 v#02042067","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_vietnã","n#01309807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_Vietnam","n#01309807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_do_Vietnã","n#01309807","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_de_Sucessão_Austríaca","n#01310347","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_de_sucessão_austríaca","n#01310347","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_da_sucessão_espanhola","n#01310789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_da_Sucessão_Espanhola","n#01310789","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_das_rosas","n#01311045","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_das_Rosas","n#01311045","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distorcido","NULL","NULL","a#01311067","NULL");
INSERT INTO portuguese_index VALUES ("inabitado","NULL","NULL","a#01311321 a#01258382","NULL");
INSERT INTO portuguese_index VALUES ("Guerra_anglo-americana_de_1812","n#01311344","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Primeira_Guerra_Mundial","n#01311520","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Primeira_guerra_mundial","n#01311520","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colonizado","NULL","NULL","a#01311605","NULL");
INSERT INTO portuguese_index VALUES ("Segunda_Guerra_Mundial","n#01312096 n#01312096","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("povoado","n#06107243 n#06382213","NULL","a#01312215","NULL");
INSERT INTO portuguese_index VALUES ("populoso","NULL","NULL","a#01312376","NULL");
INSERT INTO portuguese_index VALUES ("desabitado","NULL","NULL","a#01258382","NULL");
INSERT INTO portuguese_index VALUES ("derelito","NULL","NULL","a#00996592","NULL");
INSERT INTO portuguese_index VALUES ("abandonado","NULL","NULL","a#00996592 a#01317231","NULL");
INSERT INTO portuguese_index VALUES ("derrelicto","NULL","NULL","a#00996592","NULL");
INSERT INTO portuguese_index VALUES ("derrelito","NULL","NULL","a#00996592","NULL");
INSERT INTO portuguese_index VALUES ("solitário","NULL","NULL","a#00021796 a#02111616 a#02143677","NULL");
INSERT INTO portuguese_index VALUES ("herdável","NULL","NULL","a#01313929","NULL");
INSERT INTO portuguese_index VALUES ("patrimonial","NULL","NULL","a#01259559","NULL");
INSERT INTO portuguese_index VALUES ("hereditário","NULL","NULL","a#01259559","NULL");
INSERT INTO portuguese_index VALUES ("tatear","NULL","v#01314738","NULL","NULL");
INSERT INTO portuguese_index VALUES ("palpar","NULL","v#01314738","NULL","NULL");
INSERT INTO portuguese_index VALUES ("navegar","NULL","v#01315333 v#01260993","NULL","NULL");
INSERT INTO portuguese_index VALUES ("poiquilotérmico","n#01315581","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adquirido","NULL","NULL","a#01315670","NULL");
INSERT INTO portuguese_index VALUES ("congênito","NULL","NULL","a#01513899","NULL");
INSERT INTO portuguese_index VALUES ("congénito","NULL","NULL","a#01513899","NULL");
INSERT INTO portuguese_index VALUES ("inata","NULL","NULL","a#01513899","NULL");
INSERT INTO portuguese_index VALUES ("inato","NULL","NULL","a#01513899 a#01335708","NULL");
INSERT INTO portuguese_index VALUES ("infestantes","n#00862484","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vérmina","n#00862484 n#10748506","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("restrito","NULL","NULL","a#01316222 a#02002227","NULL");
INSERT INTO portuguese_index VALUES ("inibido","NULL","NULL","a#01316222","NULL");
INSERT INTO portuguese_index VALUES ("detritívoro","n#01316422","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irrestrito","NULL","NULL","a#01317012","NULL");
INSERT INTO portuguese_index VALUES ("animal_de_carga","n#01317089","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("burro_de_carga","n#01317089 n#01317391","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animais_de_tiro","n#01317294","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animal_doméstico","n#01317541","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ferido","NULL","NULL","a#01317954 a#01265318","NULL");
INSERT INTO portuguese_index VALUES ("machucado","NULL","NULL","a#01265318","NULL");
INSERT INTO portuguese_index VALUES ("Animal_de_estimação","n#01318894","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("animal_de_estimação","n#01318894","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vasculhar","NULL","v#00900489 v#00900615 v#01277218","NULL","NULL");
INSERT INTO portuguese_index VALUES ("esgravatar","NULL","v#00900489","NULL","NULL");
INSERT INTO portuguese_index VALUES ("revolver","NULL","v#00900489 v#01010429","NULL","NULL");
INSERT INTO portuguese_index VALUES ("salvo","NULL","NULL","a#01266688","NULL");
INSERT INTO portuguese_index VALUES ("ceifar","NULL","v#01319562 v#01319885","NULL","NULL");
INSERT INTO portuguese_index VALUES ("foiçar","NULL","v#01319562","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pesca_acessória","n#01319685","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ileso","NULL","NULL","a#01319712","NULL");
INSERT INTO portuguese_index VALUES ("incólume","NULL","NULL","a#01319712","NULL");
INSERT INTO portuguese_index VALUES ("gadanhar","NULL","v#01319885","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segar","NULL","v#01319885","NULL","NULL");
INSERT INTO portuguese_index VALUES ("respigar","NULL","v#00901473","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colher","n#03387931 n#04381073 n#09917014","v#00901473 v#00947443","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Haplóide","n#01320314","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("haploide","n#01320314","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cisalhar","NULL","v#00901682","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tosar","NULL","v#00901682","NULL","NULL");
INSERT INTO portuguese_index VALUES ("irrepreensível","NULL","NULL","a#01320705","NULL");
INSERT INTO portuguese_index VALUES ("irreprochável","NULL","NULL","a#01320705","NULL");
INSERT INTO portuguese_index VALUES ("sem_culpa","NULL","NULL","a#01320705","NULL");
INSERT INTO portuguese_index VALUES ("tosquiar","NULL","v#01320816","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fêmea","n#00865075 n#09619168","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aparar","NULL","v#00901990 v#02751952","NULL","NULL");
INSERT INTO portuguese_index VALUES ("macho","n#00865379 n#01403546 n#09624168 n#07148689 n#07391044 n#10288763 n#07616904","NULL","a#01475831 a#01422274 a#01422054 a#01422507","NULL");
INSERT INTO portuguese_index VALUES ("adultos","n#00865569","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("adulto","n#00865569 n#06938480","NULL","a#01427081","NULL");
INSERT INTO portuguese_index VALUES ("culpável","NULL","NULL","a#01321529","NULL");
INSERT INTO portuguese_index VALUES ("reprovável","NULL","NULL","a#01321529","NULL");
INSERT INTO portuguese_index VALUES ("censurável","NULL","NULL","a#01321529","NULL");
INSERT INTO portuguese_index VALUES ("repreensível","NULL","NULL","a#01321529 a#02035765","NULL");
INSERT INTO portuguese_index VALUES ("cria","n#00865638","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prole","n#00865638 n#07990824","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filhote","n#00865638 n#01322343 n#01322685","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estampar","NULL","v#00902579","NULL","NULL");
INSERT INTO portuguese_index VALUES ("criminal","NULL","NULL","a#01269451","NULL");
INSERT INTO portuguese_index VALUES ("criminoso","NULL","NULL","a#01269451 a#02553733","NULL");
INSERT INTO portuguese_index VALUES ("lobacho","n#01322508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lobato","n#01322508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lobinho","n#01322508","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filhote_de_cachorro","n#01322604","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("punível","NULL","NULL","a#01322846","NULL");
INSERT INTO portuguese_index VALUES ("passível","NULL","NULL","a#01322846 a#02366365","NULL");
INSERT INTO portuguese_index VALUES ("empeçonhar","NULL","v#01323338","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apedrejar","NULL","v#01323518","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Pedigree","n#01323599","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("gigante","n#00867448 n#06004802 n#06851909 n#07167525 n#07289774 n#07289899","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("didático","NULL","NULL","a#01324131","NULL");
INSERT INTO portuguese_index VALUES ("didáctico","NULL","NULL","a#01324131","NULL");
INSERT INTO portuguese_index VALUES ("didática","NULL","NULL","a#01324131","NULL");
INSERT INTO portuguese_index VALUES ("sobrevivente","n#01324142 n#10681060 n#10681194","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("mutantes","n#01324305 n#07425392","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("educativo","NULL","NULL","a#01271113 a#01271218 a#02946221","NULL");
INSERT INTO portuguese_index VALUES ("carnivora","n#01324431","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("explanatório","NULL","NULL","a#01271318","NULL");
INSERT INTO portuguese_index VALUES ("explicativo","NULL","NULL","a#01271318","NULL");
INSERT INTO portuguese_index VALUES ("Insetívoro","n#01324799","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("insectívoros","n#01324799 n#01889074","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("assassinar","NULL","v#01325128 v#01691743 v#01692186","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chifre","n#00869086 n#01325658","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("corno","n#00869086 n#01325658 n#01325853 n#09982152","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("edificador","NULL","NULL","a#01325451","NULL");
INSERT INTO portuguese_index VALUES ("galhada","n#01325658","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sacrificar","NULL","v#00904575 v#01589983","NULL","NULL");
INSERT INTO portuguese_index VALUES ("integrado","NULL","NULL","a#01326148","NULL");
INSERT INTO portuguese_index VALUES ("microorganismo","n#01326291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("microrganismo","n#01326291","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("segregado","NULL","NULL","a#01326917","NULL");
INSERT INTO portuguese_index VALUES ("atirar_na_cabeça","NULL","v#01327020","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anaeróbio","n#01327028","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazerdormir","NULL","v#01327133 v#01494178","NULL","NULL");
INSERT INTO portuguese_index VALUES ("liquidar","NULL","v#00905566 v#02254495","NULL","NULL");
INSERT INTO portuguese_index VALUES ("erradicar","NULL","v#01327582 v#01079137 v#01662118","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exterminar","NULL","v#01327582 v#01662118","NULL","NULL");
INSERT INTO portuguese_index VALUES ("obter_rapidamente","NULL","v#01328212","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desengatar","NULL","v#01328340","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vírus_de_computador","n#00871107 n#06585816","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vírus","n#00871107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vírus","n#00871107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Virus","n#00871107","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("incorporar_a","NULL","v#01329141","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bordar","NULL","v#00907105 v#01667607","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cápsideo","n#01329794","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Capsídeo","n#01329794","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("combinado","NULL","NULL","a#01329830 a#02476338","NULL");
INSERT INTO portuguese_index VALUES ("adenovírus","n#01330126","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cerzir","NULL","v#01330676","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bunyaviridae","n#01331345","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("compositivo","NULL","NULL","a#01331459","NULL");
INSERT INTO portuguese_index VALUES ("Filovirus","n#01331659","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("filovírus","n#01331659","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Vírus_de_Marburg","n#01332181","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intelectual","n#06949872 n#10708292 n#10708454","NULL","a#02679427 a#01279724 a#01712221 a#01859558","NULL");
INSERT INTO portuguese_index VALUES ("Flaviviridae","n#01332653","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Flavivírus","n#01332653 n#01332795","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tampar","NULL","v#00909621 v#00975083 v#01467965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Flavivirus","n#01332795","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vírus_do_Oeste_do_Nilo","n#01332940","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Arenavírus","n#01333082","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Arenavirus","n#01333082","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("racional","NULL","NULL","a#01279909 a#01712221 a#01857252 a#01857881 a#02703636","NULL");
INSERT INTO portuguese_index VALUES ("Rhabdovírus","n#01333301","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rhabdovirus","n#01333301","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("varíola","n#01334217 n#14124423","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inteligente","NULL","NULL","a#01281024 a#01857881 a#02161378","NULL");
INSERT INTO portuguese_index VALUES ("viróide","n#01334690","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bacteriófago","n#01334862","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fago","n#01334862","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encadernar","NULL","v#01335804","NULL","NULL");
INSERT INTO portuguese_index VALUES ("encapar","NULL","v#01335804 v#01336635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Retroviridae","n#01336282","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recobrir","NULL","v#01336541","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lerdo","NULL","NULL","a#01336587","NULL");
INSERT INTO portuguese_index VALUES ("enfronhar","NULL","v#01336635","NULL","NULL");
INSERT INTO portuguese_index VALUES ("VIH","n#01336718","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("inteligível","NULL","NULL","a#01336926","NULL");
INSERT INTO portuguese_index VALUES ("Paramyxovirus","n#01337191","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Picornavirus","n#01337583","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Enterovírus","n#01337915","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enterovírus","n#01337915","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Enterovirus","n#01337915","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vendar","NULL","v#01337927","NULL","NULL");
INSERT INTO portuguese_index VALUES ("deliberado","NULL","NULL","a#01337939","NULL");
INSERT INTO portuguese_index VALUES ("proposital","NULL","NULL","a#01338116","NULL");
INSERT INTO portuguese_index VALUES ("premeditado","NULL","NULL","a#01338116","NULL");
INSERT INTO portuguese_index VALUES ("intencional","NULL","NULL","a#01338116","NULL");
INSERT INTO portuguese_index VALUES ("coroar","NULL","v#00914003 v#01838402","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rhinovirus","n#01338537","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ladrilhar","NULL","v#01338663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("azulejar","NULL","v#01338663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("herpes","n#01338685 n#14131950 n#14132102","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Herpes_simplex_virus","n#01338908","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Epstein_Barr","n#01339623","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Epstein-barr","n#01339623","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Epstein-Barr","n#01339623","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desenhado","NULL","NULL","a#01771118","NULL");
INSERT INTO portuguese_index VALUES ("projetado","NULL","NULL","a#01771118","NULL");
INSERT INTO portuguese_index VALUES ("Citomegalovirus","n#01339801","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Citomegalovírus","n#01339801","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("citomegalovírus","n#01339801","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("exasperador","NULL","NULL","a#01340422 a#01737503","NULL");
INSERT INTO portuguese_index VALUES ("agravante","NULL","NULL","a#01340422","NULL");
INSERT INTO portuguese_index VALUES ("exasperante","NULL","NULL","a#01340422 a#01737503","NULL");
INSERT INTO portuguese_index VALUES ("fixar","NULL","v#00915832 v#00919067","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aumentativo","NULL","NULL","a#01340522 a#02535645","NULL");
INSERT INTO portuguese_index VALUES ("Rotavirus","n#01341090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rotavírus","n#01341090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paliativo","NULL","NULL","a#01341153","NULL");
INSERT INTO portuguese_index VALUES ("parvovírus","n#01341183","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Parvovirus","n#01341183","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Parvovírus","n#01341183","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("analgésico","n#02707683","NULL","a#01341490","NULL");
INSERT INTO portuguese_index VALUES ("Monera","n#01341876","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interessado","NULL","NULL","a#01288643 a#01453075","NULL");
INSERT INTO portuguese_index VALUES ("engastar","NULL","v#01342536","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aborrecida","NULL","NULL","a#01343200","NULL");
INSERT INTO portuguese_index VALUES ("aferrolhar","NULL","v#00919067","NULL","NULL");
INSERT INTO portuguese_index VALUES ("curisoso","NULL","NULL","a#01290353","NULL");
INSERT INTO portuguese_index VALUES ("fascinante","NULL","NULL","a#01290570","NULL");
INSERT INTO portuguese_index VALUES ("recreativo","NULL","NULL","a#01737913","NULL");
INSERT INTO portuguese_index VALUES ("entretido","NULL","NULL","a#01738083","NULL");
INSERT INTO portuguese_index VALUES ("cerrar","NULL","v#00919962","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fechar","NULL","v#00919962 v#00921313 v#02140781 v#01651958","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aborrecido","NULL","NULL","a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("cansativo","NULL","NULL","a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("tedioso","NULL","NULL","a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("fastidioso","NULL","NULL","a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("entediante","NULL","NULL","a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("chato","n#10391513","NULL","a#01291600","NULL");
INSERT INTO portuguese_index VALUES ("insípido","NULL","NULL","a#01345997 a#02393401 a#02399399 a#01831399","NULL");
INSERT INTO portuguese_index VALUES ("soporífico","NULL","NULL","a#01346198 a#02309187","NULL");
INSERT INTO portuguese_index VALUES ("soporífero","NULL","NULL","a#01346198 a#02309187","NULL");
INSERT INTO portuguese_index VALUES ("prosaico","NULL","NULL","a#01346343 a#02018649","NULL");
INSERT INTO portuguese_index VALUES ("reabrir","NULL","v#01346693","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intramural","NULL","NULL","a#01346755","NULL");
INSERT INTO portuguese_index VALUES ("extramural","NULL","NULL","a#01347138","NULL");
INSERT INTO portuguese_index VALUES ("trancar","NULL","v#00922436 v#01476483 v#01810320","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intrínseco","NULL","NULL","a#01348258","NULL");
INSERT INTO portuguese_index VALUES ("intrínseca","NULL","NULL","a#01348258","NULL");
INSERT INTO portuguese_index VALUES ("bactéria","n#00884781","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destrancar","NULL","v#01348705","NULL","NULL");
INSERT INTO portuguese_index VALUES ("acidental","NULL","NULL","a#01349435 a#01726809","NULL");
INSERT INTO portuguese_index VALUES ("probiótico","n#01349495","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alheio","NULL","NULL","a#01295935","NULL");
INSERT INTO portuguese_index VALUES ("bacilo","n#01349948 n#01377602","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bacillus_anthracis","n#01350226","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("forçar","NULL","v#01350449 v#01278717 v#01707058 v#01708245 v#01745767","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bacillus_subtilis","n#01350485","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Estranho","NULL","NULL","a#01296448","NULL");
INSERT INTO portuguese_index VALUES ("introvertido","NULL","NULL","a#01350674 a#01351021 a#01988024","NULL");
INSERT INTO portuguese_index VALUES ("Yersinia_pestis","n#01350701","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bacteria_de_forma_arredondada","n#01350855","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coco","n#01350855 n#07772935 n#12587803","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Brucella","n#01351170","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Helicobacter_pylori","n#01351688","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("intrusivo","NULL","NULL","a#01352067 a#01353014","NULL");
INSERT INTO portuguese_index VALUES ("desaparafusar","NULL","v#01352528","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aparafusar","NULL","v#01352996 v#01353169","NULL","NULL");
INSERT INTO portuguese_index VALUES ("atarraxar","NULL","v#01353169","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Bolt","NULL","NULL","a#01353982","NULL");
INSERT INTO portuguese_index VALUES ("interditar","NULL","v#01354006","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rhizobium","n#01354324","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impermeabilizar","NULL","v#01354405","NULL","NULL");
INSERT INTO portuguese_index VALUES ("paquerar","NULL","v#00927971","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interligar","NULL","v#01355646","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vulcânico","NULL","NULL","a#01355746 a#02293760 a#02826169","NULL");
INSERT INTO portuguese_index VALUES ("invasivo","NULL","NULL","a#01355966 a#01356365","NULL");
INSERT INTO portuguese_index VALUES ("desconectar","NULL","v#01356038","NULL","NULL");
INSERT INTO portuguese_index VALUES ("confinado","NULL","NULL","a#01356283","NULL");
INSERT INTO portuguese_index VALUES ("Bacillaceae","n#01356459","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("selar","NULL","v#01356582 v#01492422","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Clostridium_botulinum","n#01357328","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estimulador","NULL","NULL","a#01302744","NULL");
INSERT INTO portuguese_index VALUES ("algas_azuis-verdes","n#01358572","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Cyanobacteria","n#01358572","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("tentador","NULL","NULL","a#01358695 a#02097480","NULL");
INSERT INTO portuguese_index VALUES ("In_Vitro","NULL","NULL","a#01359277","NULL");
INSERT INTO portuguese_index VALUES ("in_vitro","NULL","NULL","a#01359277","NULL");
INSERT INTO portuguese_index VALUES ("enfileirar","NULL","v#00931057 v#02036755 v#02703539","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rugoso","NULL","NULL","a#01359861 a#01360413","NULL");
INSERT INTO portuguese_index VALUES ("Pseudomonadales","n#01360330","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("isotrópico","NULL","NULL","a#01360804","NULL");
INSERT INTO portuguese_index VALUES ("Pseudomonas","n#01360937","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("destestável","NULL","NULL","a#01308632","NULL");
INSERT INTO portuguese_index VALUES ("Nitrobacter","n#01362196","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agridoce","NULL","NULL","a#01362273 a#02396354","NULL");
INSERT INTO portuguese_index VALUES ("lutuoso","NULL","NULL","a#01362387 a#01313142","NULL");
INSERT INTO portuguese_index VALUES ("Nitrosomonas","n#01362480","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("melancólica","NULL","NULL","a#01309603","NULL");
INSERT INTO portuguese_index VALUES ("pensativo","NULL","NULL","a#01310388","NULL");
INSERT INTO portuguese_index VALUES ("trágico","NULL","NULL","a#01310000 a#02738787","NULL");
INSERT INTO portuguese_index VALUES ("pesaroso","NULL","NULL","a#01364008","NULL");
INSERT INTO portuguese_index VALUES ("amargo","NULL","NULL","a#01311905 a#01730738 a#02282305 a#02316897","NULL");
INSERT INTO portuguese_index VALUES ("pendurar","NULL","v#00934848 v#01015949 v#01016520","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Neisseria_gonorrhoeae","n#01365885","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cingir","NULL","v#00935164 v#01006889","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fúnebre","NULL","NULL","a#01313142 a#01314939","NULL");
INSERT INTO portuguese_index VALUES ("agoniado","NULL","NULL","a#01366525","NULL");
INSERT INTO portuguese_index VALUES ("Corynebacterium_diphtheriae","n#01366700","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ditoso","NULL","NULL","a#01313549","NULL");
INSERT INTO portuguese_index VALUES ("cimentar","NULL","v#01366926","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extático","NULL","NULL","a#01367008","NULL");
INSERT INTO portuguese_index VALUES ("grampear","NULL","v#01367069 v#02189714","NULL","NULL");
INSERT INTO portuguese_index VALUES ("agrafar","NULL","v#01367069","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Listeria_monocytogenes","n#01367208","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Enterobacteriaceae","n#01367430","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("festivo","NULL","NULL","a#01314056","NULL");
INSERT INTO portuguese_index VALUES ("jovial","NULL","NULL","a#01314288","NULL");
INSERT INTO portuguese_index VALUES ("abotoar","NULL","v#01367862","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desabotoar","NULL","v#01368001","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alfinetar","NULL","v#00936910","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Escherichia_coli","n#01368338","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("klebsiela","n#01368672","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("suculento","NULL","NULL","a#01368793","NULL");
INSERT INTO portuguese_index VALUES ("salmonelas","n#01368973","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("desfilar","NULL","v#00937646 v#01307876","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Serratia","n#01369633","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arruinar","NULL","v#00938146 v#01077449","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rickettsiales","n#01370913","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rickettsiaceae","n#01371092","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recuo","n#07350754","v#00939368","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chlamydiaceae","n#01372372","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("borrifar","NULL","v#00940318 v#00941419 v#00941968 v#00942761 v#02757475 v#01884584","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chlamydia","n#01372709 n#14175579","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chlamydophila_psittaci","n#01372944","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bondoso","NULL","NULL","a#00221441","NULL");
INSERT INTO portuguese_index VALUES ("benévolo","NULL","NULL","a#00221441","NULL");
INSERT INTO portuguese_index VALUES ("benevolente","NULL","NULL","a#00221441","NULL");
INSERT INTO portuguese_index VALUES ("Chlamydia_trachomatis","n#01373090","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("transcedente","NULL","NULL","a#01374912 a#02344793","NULL");
INSERT INTO portuguese_index VALUES ("Actinomycetales","n#01374989","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sabido","NULL","NULL","a#01320533","NULL");
INSERT INTO portuguese_index VALUES ("fazer_jorrar","NULL","v#01375637","NULL","NULL");
INSERT INTO portuguese_index VALUES ("famosa","NULL","NULL","a#01321211","NULL");
INSERT INTO portuguese_index VALUES ("famoso","NULL","NULL","a#01321211","NULL");
INSERT INTO portuguese_index VALUES ("célebre","NULL","NULL","a#01321211","NULL");
INSERT INTO portuguese_index VALUES ("de_renome","NULL","NULL","a#01321211","NULL");
INSERT INTO portuguese_index VALUES ("extravasar","NULL","v#01375909","NULL","NULL");
INSERT INTO portuguese_index VALUES ("umeceder","NULL","v#00942761","NULL","NULL");
INSERT INTO portuguese_index VALUES ("umectar","NULL","v#00942761","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lendário","NULL","NULL","a#01376355 a#01935744","NULL");
INSERT INTO portuguese_index VALUES ("legendário","NULL","NULL","a#01376355","NULL");
INSERT INTO portuguese_index VALUES ("proverbial","NULL","NULL","a#01376522 a#02990304","NULL");
INSERT INTO portuguese_index VALUES ("bem_conhecido","NULL","NULL","a#01376705","NULL");
INSERT INTO portuguese_index VALUES ("desconhecida","NULL","NULL","a#01322204","NULL");
INSERT INTO portuguese_index VALUES ("Mycobacterium_tuberculosis","n#01377278","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mycobacterium_leprae","n#01377804","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apreciado","NULL","NULL","a#01378429","NULL");
INSERT INTO portuguese_index VALUES ("mixobactéria","n#01378545","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("distribuir","NULL","v#00944672 v#00945383 v#01507640","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Micrococcus","n#01379116","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("despregar","NULL","v#00945383","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Lactobacillaceae","n#01379636","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("redistribuir","NULL","v#01379965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("aéreo","NULL","NULL","a#02353498","NULL");
INSERT INTO portuguese_index VALUES ("Lactobacillus_acidophilus","n#01380298","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coligir","NULL","v#00946301","NULL","NULL");
INSERT INTO portuguese_index VALUES ("recolher","NULL","v#00946301 v#01576416","NULL","NULL");
INSERT INTO portuguese_index VALUES ("coletar","NULL","v#00946301 v#01576416","NULL","NULL");
INSERT INTO portuguese_index VALUES ("oceâneo","NULL","NULL","a#01326812","NULL");
INSERT INTO portuguese_index VALUES ("oceânico","NULL","NULL","a#01326812 a#02671693","NULL");
INSERT INTO portuguese_index VALUES ("reagrupar","NULL","v#00946962","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Spirochaetes","n#01382033","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espiroqueta","n#01382033","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colhar","NULL","v#00947443","NULL","NULL");
INSERT INTO portuguese_index VALUES ("apanhar","NULL","v#00947443 v#00987154 v#01332965","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colher_cogumelos","NULL","v#01382437","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Borrelia_burgdorferi","n#01383151","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("astronômico","NULL","NULL","a#01383582 a#02646605","NULL");
INSERT INTO portuguese_index VALUES ("galáctico","NULL","NULL","a#01383582 a#02849098","NULL");
INSERT INTO portuguese_index VALUES ("galático","NULL","NULL","a#01383582 a#02849098","NULL");
INSERT INTO portuguese_index VALUES ("Plancton","n#01383638","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("plâncton","n#01383638","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maior","NULL","NULL","a#01330301 a#01339584 a#01410738 a#01427081 a#01449238","NULL");
INSERT INTO portuguese_index VALUES ("fitoplâncton","n#01383896","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("zooplâncton","n#01384164","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nécton","n#01384313","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("volumoso","NULL","NULL","a#01384438","NULL");
INSERT INTO portuguese_index VALUES ("massudo","NULL","NULL","a#01384438","NULL");
INSERT INTO portuguese_index VALUES ("colecionar","NULL","v#00949234","NULL","NULL");
INSERT INTO portuguese_index VALUES ("micróbio","n#01384491","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comensalismo","n#01384687 n#13842241","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("colossal","NULL","NULL","a#01331233","NULL");
INSERT INTO portuguese_index VALUES ("agregar","NULL","v#00949746","NULL","NULL");
INSERT INTO portuguese_index VALUES ("muitogrande","NULL","NULL","a#01331722","NULL");
INSERT INTO portuguese_index VALUES ("imenso","NULL","NULL","a#01331722 a#01333157","NULL");
INSERT INTO portuguese_index VALUES ("enorme","NULL","NULL","a#01331722 a#01333157","NULL");
INSERT INTO portuguese_index VALUES ("tremendo","NULL","NULL","a#01331722 a#01617066","NULL");
INSERT INTO portuguese_index VALUES ("ectoparasita","n#01385330","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("hospedeiro","n#00912971 n#10187130","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("anfitrião","n#00912971 n#10187130 n#10187491","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cósmico","NULL","NULL","a#01332088 a#02550660","NULL");
INSERT INTO portuguese_index VALUES ("cósmica","NULL","NULL","a#01332088 a#02550660","NULL");
INSERT INTO portuguese_index VALUES ("descomunal","NULL","NULL","a#01332180 a#01470869","NULL");
INSERT INTO portuguese_index VALUES ("elefântico","NULL","NULL","a#01332180","NULL");
INSERT INTO portuguese_index VALUES ("elefantino","NULL","NULL","a#01332180","NULL");
INSERT INTO portuguese_index VALUES ("gigantesco","NULL","NULL","a#01332180 a#01386538","NULL");
INSERT INTO portuguese_index VALUES ("patógeno","n#01386007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Agente_infeccioso","n#01386007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("microrganismos_patogénicos","n#01386007","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("épico","NULL","NULL","a#01332311 a#03015589","NULL");
INSERT INTO portuguese_index VALUES ("enfardar","NULL","v#01386200","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Mirmecofilia","n#01386354","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("arear","NULL","v#01386433","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lixar","NULL","v#01387022","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protoctista","n#01387065","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("prototista","n#01387065","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Protista","n#01387208","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Protistas","n#01387208","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vasta","NULL","NULL","a#01333157","NULL");
INSERT INTO portuguese_index VALUES ("protista","n#01387451","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("entrançar","NULL","v#01387656 v#01042567 v#01518924 v#01674717","NULL","NULL");
INSERT INTO portuguese_index VALUES ("trançar","NULL","v#01387656 v#01042033 v#01042567 v#01519569 v#01674717","NULL","NULL");
INSERT INTO portuguese_index VALUES ("comprimir","NULL","v#00951804","NULL","NULL");
INSERT INTO portuguese_index VALUES ("nacroscópico","NULL","NULL","a#01408489 a#02516316","NULL");
INSERT INTO portuguese_index VALUES ("massivo","NULL","NULL","a#01334723","NULL");
INSERT INTO portuguese_index VALUES ("Protozoários","n#01389188","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("protozoário","n#01389188 n#01389507","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("meter","NULL","v#00952864 v#00977560","NULL","NULL");
INSERT INTO portuguese_index VALUES ("enfiar","NULL","v#00952864","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lacerar","NULL","v#01390486","NULL","NULL");
INSERT INTO portuguese_index VALUES ("titânico","NULL","NULL","a#01390683","NULL");
INSERT INTO portuguese_index VALUES ("passar_a_ferro","NULL","v#00953839","NULL","NULL");
INSERT INTO portuguese_index VALUES ("rolar","NULL","v#00954183 v#01274944","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diminuto","NULL","NULL","a#01408925 a#01337063 a#01338679 a#02127826","NULL");
INSERT INTO portuguese_index VALUES ("nanico","NULL","NULL","a#01337063","NULL");
INSERT INTO portuguese_index VALUES ("minúsculo","NULL","NULL","a#01337063 a#01467298","NULL");
INSERT INTO portuguese_index VALUES ("ameba","n#01392380","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Foraminifera","n#01392843","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("menor","n#06950430","NULL","a#01338439","NULL");
INSERT INTO portuguese_index VALUES ("varrer","NULL","v#00955911 v#00956103 v#01277218","NULL","NULL");
INSERT INTO portuguese_index VALUES ("microscópico","NULL","NULL","a#01393822 a#02516570 a#02918844","NULL");
INSERT INTO portuguese_index VALUES ("espremer","NULL","v#00956757 v#01447868 v#01456771","NULL","NULL");
INSERT INTO portuguese_index VALUES ("pequenito","NULL","NULL","a#01395028","NULL");
INSERT INTO portuguese_index VALUES ("chapar","NULL","v#01395049","NULL","NULL");
INSERT INTO portuguese_index VALUES ("laminar","NULL","v#01395049 v#01625666","NULL","NULL");
INSERT INTO portuguese_index VALUES ("banhar","NULL","v#01395049","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ciliophora","n#01395254","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ciliados","n#01395254","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cobrir_com_estanho","NULL","v#01395382","NULL","NULL");
INSERT INTO portuguese_index VALUES ("lícito","NULL","NULL","a#01339871 a#01345445 a#01486941 a#01761871","NULL");
INSERT INTO portuguese_index VALUES ("niquelar","NULL","v#01395663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("cromar","NULL","v#01395945","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fora_da_lei","NULL","NULL","a#01340247","NULL");
INSERT INTO portuguese_index VALUES ("ilegal","NULL","NULL","a#01340247 a#01346039 a#01403760 a#01352342 a#01487511","NULL");
INSERT INTO portuguese_index VALUES ("argentar","NULL","v#01396328","NULL","NULL");
INSERT INTO portuguese_index VALUES ("algas","n#01397114","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("alga","n#01397114 n#01397497","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sem_chumbo","NULL","NULL","a#01397125 a#01656520","NULL");
INSERT INTO portuguese_index VALUES ("macroalga","n#01397497","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ervas_marinhas","n#01397871","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Erva_marinha","n#01397871","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("furado","NULL","NULL","a#01397998","NULL");
INSERT INTO portuguese_index VALUES ("açoitar","NULL","v#01398032 v#01411085 v#01412204","NULL","NULL");
INSERT INTO portuguese_index VALUES ("chicotear","NULL","v#01398032 v#01411085","NULL","NULL");
INSERT INTO portuguese_index VALUES ("clorofila","n#01398212","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("flagelar","NULL","v#01398443 v#01411085","NULL","NULL");
INSERT INTO portuguese_index VALUES ("estanque","NULL","NULL","a#01398528","NULL");
INSERT INTO portuguese_index VALUES ("hermético","NULL","NULL","a#01398772","NULL");
INSERT INTO portuguese_index VALUES ("bater_repetidamente","NULL","v#01398919","NULL","NULL");
INSERT INTO portuguese_index VALUES ("impermeável","NULL","NULL","a#01398941 a#01772609","NULL");
INSERT INTO portuguese_index VALUES ("bacterioclorofila","n#01399065","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ficobilina","n#01399236","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ficoeritrina","n#01399366","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ficocianina","n#01399450","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ázimo","NULL","NULL","a#01399949","NULL");
INSERT INTO portuguese_index VALUES ("golpear","NULL","v#00960484 v#00966768 v#00971544","NULL","NULL");
INSERT INTO portuguese_index VALUES ("sotavento","NULL","NULL","a#01400098","NULL");
INSERT INTO portuguese_index VALUES ("barlavento","NULL","NULL","a#01400336","NULL");
INSERT INTO portuguese_index VALUES ("legal","NULL","NULL","a#01344765 a#02379792","NULL");
INSERT INTO portuguese_index VALUES ("judiciário","NULL","NULL","a#01345200 a#02581140 a#02581340","NULL");
INSERT INTO portuguese_index VALUES ("diatomácea","n#01401106","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("diatomáceas","n#01401106","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("regulamentar","NULL","NULL","a#01401532","NULL");
INSERT INTO portuguese_index VALUES ("estatutário","NULL","NULL","a#01401532 a#02802848","NULL");
INSERT INTO portuguese_index VALUES ("estrelar","NULL","v#00961786","NULL","NULL");
INSERT INTO portuguese_index VALUES ("interdito","NULL","NULL","a#01402498","NULL");
INSERT INTO portuguese_index VALUES ("proibido","NULL","NULL","a#01402498 a#01761375","NULL");
INSERT INTO portuguese_index VALUES ("Phaeophyta","n#01402600","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bater_de_leve","NULL","v#01403314","NULL","NULL");
INSERT INTO portuguese_index VALUES ("extrajudicial","NULL","NULL","a#01403316","NULL");
INSERT INTO portuguese_index VALUES ("Laminariales","n#01403457","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("ilegítimo","NULL","NULL","a#01403760 a#01407465","NULL");
INSERT INTO portuguese_index VALUES ("ilícito","NULL","NULL","a#01403760 a#01550572","NULL");
INSERT INTO portuguese_index VALUES ("Fucales","n#01403805","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Fucaceae","n#01404129","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("penal","NULL","NULL","a#01348338 a#01833472 a#02593962","NULL");
INSERT INTO portuguese_index VALUES ("legível","NULL","NULL","a#01404702 a#01348978","NULL");
INSERT INTO portuguese_index VALUES ("Fucus_vesiculosus","n#01405250","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("biológica","NULL","NULL","a#01349727 a#02522941","NULL");
INSERT INTO portuguese_index VALUES ("biológico","NULL","NULL","a#01349727 a#02522941","NULL");
INSERT INTO portuguese_index VALUES ("Euglenofita","n#01406904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("euglenófita","n#01406904","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chlorophyta","n#01407065","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Algas_verdes","n#01407065","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chlorophyceae","n#01407465","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("algas_verdes","n#01407798","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ulvophyceae","n#01408088","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ulvales","n#01408253","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Ulvaceae","n#01408383","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Alface-do-mar","n#01408743","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chlamydomonadales","n#01408880","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Volvocaceae","n#01409065","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Volvox","n#01409244","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Chlamydomonadaceae","n#01409477","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("semelhante","NULL","NULL","a#01353127 a#01354252 a#01971846 a#01994192","NULL");
INSERT INTO portuguese_index VALUES ("Chlamydomonas","n#01409665","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Zygnematales","n#01409940","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("similar","NULL","NULL","a#01354252 a#01993830","NULL");
INSERT INTO portuguese_index VALUES ("parecido","NULL","NULL","a#01354252","NULL");
INSERT INTO portuguese_index VALUES ("Chlorococcales","n#01410847","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("vergastar","NULL","v#01411085","NULL","NULL");
INSERT INTO portuguese_index VALUES ("provável","NULL","NULL","a#01355038 a#01355667 a#01356660","NULL");
INSERT INTO portuguese_index VALUES ("Oedogoniales","n#01411556","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Charophyceae","n#01412085","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("espancar","NULL","v#00967932","NULL","NULL");
INSERT INTO portuguese_index VALUES ("maltratar","NULL","v#00967932 v#02513989 v#01715663","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Charales","n#01412279","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Desmidiaceae","n#01413188","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rhodophyceae","n#01413744","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Rhodophyta","n#01413942","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("bater_com_os_nós_dos_dedos","NULL","v#00969318","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beijar_ruidosamente","NULL","v#00969517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("fazer_ruído_de_sucção","NULL","v#00969517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("beijocar","NULL","v#00969517","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Limitado","NULL","NULL","a#01358077","NULL");
INSERT INTO portuguese_index VALUES ("de_bolso","NULL","NULL","a#01358565","NULL");
INSERT INTO portuguese_index VALUES ("modesto","NULL","NULL","a#01358565 a#01469123 a#01475714 a#01476902 a#01779195 a#02229453","NULL");
INSERT INTO portuguese_index VALUES ("esmurrar","NULL","v#01415285","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Porphyra","n#01415393","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Eucariontes","n#01415626","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eukaryota","n#01415626","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("eucariota","n#01415626","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("Eukaryota","n#01415626","NULL","NULL","NULL");
INSERT INTO portuguese_index VALUES ("