# coding: utf-8

"""
    fatcat

    Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata.   # noqa: E501

    The version of the OpenAPI document: 0.4.0
    Contact: webservices@archive.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class FilesetFile(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'path': 'str',
        'size': 'int',
        'md5': 'str',
        'sha1': 'str',
        'sha256': 'str',
        'mimetype': 'str',
        'extra': 'dict(str, object)'
    }

    attribute_map = {
        'path': 'path',
        'size': 'size',
        'md5': 'md5',
        'sha1': 'sha1',
        'sha256': 'sha256',
        'mimetype': 'mimetype',
        'extra': 'extra'
    }

    def __init__(self, path=None, size=None, md5=None, sha1=None, sha256=None, mimetype=None, extra=None):  # noqa: E501
        """FilesetFile - a model defined in OpenAPI"""  # noqa: E501

        self._path = None
        self._size = None
        self._md5 = None
        self._sha1 = None
        self._sha256 = None
        self._mimetype = None
        self._extra = None
        self.discriminator = None

        self.path = path
        self.size = size
        if md5 is not None:
            self.md5 = md5
        if sha1 is not None:
            self.sha1 = sha1
        if sha256 is not None:
            self.sha256 = sha256
        if mimetype is not None:
            self.mimetype = mimetype
        if extra is not None:
            self.extra = extra

    @property
    def path(self):
        """Gets the path of this FilesetFile.  # noqa: E501

        Path name of file within this fileset (eg, directory)   # noqa: E501

        :return: The path of this FilesetFile.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this FilesetFile.

        Path name of file within this fileset (eg, directory)   # noqa: E501

        :param path: The path of this FilesetFile.  # noqa: E501
        :type: str
        """
        if path is None:
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def size(self):
        """Gets the size of this FilesetFile.  # noqa: E501

        File size in bytes  # noqa: E501

        :return: The size of this FilesetFile.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this FilesetFile.

        File size in bytes  # noqa: E501

        :param size: The size of this FilesetFile.  # noqa: E501
        :type: int
        """
        if size is None:
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def md5(self):
        """Gets the md5 of this FilesetFile.  # noqa: E501

        MD5 hash of data, in hex encoding  # noqa: E501

        :return: The md5 of this FilesetFile.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this FilesetFile.

        MD5 hash of data, in hex encoding  # noqa: E501

        :param md5: The md5 of this FilesetFile.  # noqa: E501
        :type: str
        """
        if md5 is not None and len(md5) > 32:
            raise ValueError("Invalid value for `md5`, length must be less than or equal to `32`")  # noqa: E501
        if md5 is not None and len(md5) < 32:
            raise ValueError("Invalid value for `md5`, length must be greater than or equal to `32`")  # noqa: E501
        if md5 is not None and not re.search(r'[a-f0-9]{32}', md5):  # noqa: E501
            raise ValueError(r"Invalid value for `md5`, must be a follow pattern or equal to `/[a-f0-9]{32}/`")  # noqa: E501

        self._md5 = md5

    @property
    def sha1(self):
        """Gets the sha1 of this FilesetFile.  # noqa: E501

        SHA-1 hash of data, in hex encoding  # noqa: E501

        :return: The sha1 of this FilesetFile.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this FilesetFile.

        SHA-1 hash of data, in hex encoding  # noqa: E501

        :param sha1: The sha1 of this FilesetFile.  # noqa: E501
        :type: str
        """
        if sha1 is not None and len(sha1) > 40:
            raise ValueError("Invalid value for `sha1`, length must be less than or equal to `40`")  # noqa: E501
        if sha1 is not None and len(sha1) < 40:
            raise ValueError("Invalid value for `sha1`, length must be greater than or equal to `40`")  # noqa: E501
        if sha1 is not None and not re.search(r'[a-f0-9]{40}', sha1):  # noqa: E501
            raise ValueError(r"Invalid value for `sha1`, must be a follow pattern or equal to `/[a-f0-9]{40}/`")  # noqa: E501

        self._sha1 = sha1

    @property
    def sha256(self):
        """Gets the sha256 of this FilesetFile.  # noqa: E501

        SHA-256 hash of data, in hex encoding  # noqa: E501

        :return: The sha256 of this FilesetFile.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this FilesetFile.

        SHA-256 hash of data, in hex encoding  # noqa: E501

        :param sha256: The sha256 of this FilesetFile.  # noqa: E501
        :type: str
        """
        if sha256 is not None and len(sha256) > 64:
            raise ValueError("Invalid value for `sha256`, length must be less than or equal to `64`")  # noqa: E501
        if sha256 is not None and len(sha256) < 64:
            raise ValueError("Invalid value for `sha256`, length must be greater than or equal to `64`")  # noqa: E501
        if sha256 is not None and not re.search(r'[a-f0-9]{64}', sha256):  # noqa: E501
            raise ValueError(r"Invalid value for `sha256`, must be a follow pattern or equal to `/[a-f0-9]{64}/`")  # noqa: E501

        self._sha256 = sha256

    @property
    def mimetype(self):
        """Gets the mimetype of this FilesetFile.  # noqa: E501


        :return: The mimetype of this FilesetFile.  # noqa: E501
        :rtype: str
        """
        return self._mimetype

    @mimetype.setter
    def mimetype(self, mimetype):
        """Sets the mimetype of this FilesetFile.


        :param mimetype: The mimetype of this FilesetFile.  # noqa: E501
        :type: str
        """

        self._mimetype = mimetype

    @property
    def extra(self):
        """Gets the extra of this FilesetFile.  # noqa: E501

        Free-form additional metadata about this specific file in the set. Eg, `original_url`. See guide for nomative (but unenforced) schema fields.   # noqa: E501

        :return: The extra of this FilesetFile.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._extra

    @extra.setter
    def extra(self, extra):
        """Sets the extra of this FilesetFile.

        Free-form additional metadata about this specific file in the set. Eg, `original_url`. See guide for nomative (but unenforced) schema fields.   # noqa: E501

        :param extra: The extra of this FilesetFile.  # noqa: E501
        :type: dict(str, object)
        """

        self._extra = extra

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FilesetFile):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
