/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.util.Logger;

public class Elements {
    public static final String[] elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
    public static final int elementNumberMax = elementSymbols.length;
    public static Map<String, Integer> htElementMap;
    public static final String[] elementNames;
    private static final String naturalIsotopes = "1H,12C,14N,";
    private static final short[] altElementNumbers;
    public static final int altElementMax;
    private static final String[] altElementSymbols;
    private static final String[] altElementNames;

    public static final short elementNumberFromSymbol(String string, boolean bl) {
        Serializable serializable;
        if (htElementMap == null) {
            Integer n;
            String string2;
            serializable = new Hashtable();
            int n2 = elementNumberMax;
            while (--n2 >= 0) {
                string2 = elementSymbols[n2];
                n = n2;
                serializable.put(string2, n);
                if (string2.length() != 2) continue;
                serializable.put(string2.toUpperCase(), n);
            }
            n2 = altElementMax;
            while (--n2 >= 4) {
                string2 = altElementSymbols[n2];
                n = altElementNumbers[n2];
                serializable.put(string2, n);
                if (string2.length() != 2) continue;
                serializable.put(string2.toUpperCase(), n);
            }
            htElementMap = serializable;
        }
        if (string == null) {
            return 0;
        }
        serializable = htElementMap.get(string);
        if (serializable != null) {
            return (short)((Integer)serializable).intValue();
        }
        if (!bl) {
            Logger.error("'" + string + "' is not a recognized symbol");
        }
        return 0;
    }

    public static final String elementSymbolFromNumber(int n) {
        if (n >= elementNumberMax) {
            int n2 = altElementMax;
            while (--n2 >= 0) {
                if (n != altElementNumbers[n2]) continue;
                return altElementSymbols[n2];
            }
            n %= 128;
        }
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementSymbols[n];
    }

    public static final String elementNameFromNumber(int n) {
        if (n >= elementNumberMax) {
            int n2 = altElementMax;
            while (--n2 >= 0) {
                if (n != altElementNumbers[n2]) continue;
                return altElementNames[n2];
            }
            n %= 128;
        }
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementNames[n];
    }

    public static final String altElementNameFromIndex(int n) {
        return altElementNames[n];
    }

    public static final short altElementNumberFromIndex(int n) {
        return altElementNumbers[n];
    }

    public static final String altElementSymbolFromIndex(int n) {
        return altElementSymbols[n];
    }

    public static final String altIsotopeSymbolFromIndex(int n) {
        short s = altElementNumbers[n];
        return (s >> 7) + Elements.elementSymbolFromNumber(s & 0x7F);
    }

    public static final short getAtomicAndIsotopeNumber(int n, int n2) {
        return (short)((n < 0 ? 0 : n) + (n2 <= 0 ? 0 : n2 << 7));
    }

    public static final int altElementIndexFromNumber(int n) {
        for (int i = 0; i < altElementMax; ++i) {
            if (altElementNumbers[i] != n) continue;
            return i;
        }
        return 0;
    }

    public static final boolean isNaturalIsotope(String string) {
        return naturalIsotopes.indexOf(string + ",") >= 0;
    }

    static {
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        altElementNumbers = new short[]{0, 13, 16, 55, 257, 385, 1414, 1670, 1798, 1927};
        altElementMax = altElementNumbers.length;
        altElementSymbols = new String[]{"Xx", "Al", "S", "Cs", "D", "T", "11C", "13C", "14C", "15N"};
        altElementNames = new String[]{"dummy", "aluminium", "sulphur", "caesium", "deuterium", "tritium", "", "", "", ""};
    }
}

