/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.JmolMolecule;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspf;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Polymer;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.OutputStringBuffer;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.util.TriangleData;
import org.jmol.util.XmlUtil;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelCollection
extends BondCollection {
    protected BitSet bsSymmetry;
    protected String modelSetName;
    protected Model[] models = new Model[1];
    protected int modelCount;
    SymmetryInterface[] unitCells;
    protected int[] modelNumbers = new int[1];
    protected int[] modelFileNumbers = new int[1];
    protected String[] modelNumbersForAtomLabel = new String[1];
    protected String[] modelNames = new String[1];
    protected String[] frameTitles = new String[1];
    protected BitSet[] elementsPresent;
    protected boolean isXYZ;
    protected boolean isPDB;
    protected Properties modelSetProperties;
    protected Map<String, Object> modelSetAuxiliaryInfo;
    protected Group[] groups;
    protected int groupCount;
    protected int baseGroupIndex = 0;
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];
    protected boolean haveBioClasses = true;
    protected JmolBioResolver jbr = null;
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    private final Matrix3f matTemp = new Matrix3f();
    private final Matrix3f matInv = new Matrix3f();
    private final Point3f ptTemp = new Point3f();
    private final Point3f averageAtomPoint = new Point3f();
    private boolean isBbcageDefault;
    private BitSet bboxModels;
    private BitSet bboxAtoms;
    private final BoxInfo boxInfo = new BoxInfo();
    protected List<StateScript> stateScripts;
    private int thisStateModel;
    protected List<Point3f[]> trajectorySteps;
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};
    private BitSet selectedMolecules;
    private int selectedMoleculeCount;
    private static final boolean showRebondTimes = true;
    protected BitSet bsAll;
    protected ShapeManager shapeManager;
    private static float hbondMin = 2.5f;
    boolean proteinStructureTainted;
    private SymmetryInterface symTemp;

    public ModelCollection() {
        this.boxInfo.setBbcage(1.0f);
        this.stateScripts = new ArrayList<StateScript>();
        this.thisStateModel = 0;
        this.selectedMolecules = new BitSet();
        this.proteinStructureTainted = false;
    }

    protected void mergeModelArrays(ModelSet modelSet) {
        this.atoms = modelSet.atoms;
        this.bonds = modelSet.bonds;
        this.stateScripts = modelSet.stateScripts;
        this.proteinStructureTainted = modelSet.proteinStructureTainted;
        this.thisStateModel = -1;
        this.bsSymmetry = modelSet.bsSymmetry;
        this.modelFileNumbers = modelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = modelSet.modelNumbersForAtomLabel;
        this.modelNames = modelSet.modelNames;
        this.modelNumbers = modelSet.modelNumbers;
        this.frameTitles = modelSet.frameTitles;
        this.mergeAtomArrays(modelSet);
    }

    protected void mergeModels(ModelSet modelSet) {
        for (int i = 0; i < modelSet.modelCount; ++i) {
            Model model = this.models[i] = modelSet.models[i];
            model.modelSet = (ModelSet)this;
            for (int j = 0; j < model.chainCount; ++j) {
                model.chains[j].setModelSet(model.modelSet);
            }
        }
    }

    @Override
    protected void releaseModelSet() {
        this.models = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        super.releaseModelSet();
    }

    public String getModelSetName() {
        return this.modelSetName;
    }

    public Model[] getModels() {
        return this.models;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public SymmetryInterface[] getCellInfos() {
        return this.unitCells;
    }

    public SymmetryInterface getUnitCell(int n) {
        return this.unitCells != null && n >= 0 && n < this.unitCells.length ? this.unitCells[n] : null;
    }

    public List<Object> getPlaneIntersection(int n, Point4f point4f, float f, int n2, int n3) {
        Object object;
        Point3f[] point3fArray = null;
        switch (n) {
            case 1614417984: {
                object = this.getUnitCell(n3);
                if (object == null) {
                    return null;
                }
                point3fArray = object.getCanonicalCopy(f);
                break;
            }
            case 1679429641: {
                point3fArray = this.boxInfo.getCanonicalCopy(f);
            }
        }
        object = new ArrayList();
        object.add(point3fArray);
        return TriangleData.intersectPlane(point4f, (List<Object>)object, n2);
    }

    public String getModelName(int n) {
        return this.modelCount < 1 ? "" : (n >= 0 ? this.modelNames[n] : this.modelNumbersForAtomLabel[-1 - n]);
    }

    public String getModelTitle(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "title");
    }

    public String getModelFileName(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "fileName");
    }

    public void setFrameTitle(BitSet bitSet, String string) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            this.frameTitles[n] = string;
            n = bitSet.nextSetBit(n + 1);
        }
    }

    public String getFrameTitle(int n) {
        return n >= 0 && n < this.modelCount ? this.frameTitles[n] : "";
    }

    public String getModelNumberForAtomLabel(int n) {
        return this.modelNumbersForAtomLabel[n];
    }

    protected void calculatePolymers(BitSet bitSet) {
        if (this.jbr == null) {
            return;
        }
        if (bitSet != null) {
            this.jbr.clearBioPolymers(this.groups, this.groupCount, bitSet);
        }
        boolean bl = !this.viewer.isPdbSequential();
        for (int i = this.baseGroupIndex; i < this.groupCount; ++i) {
            Group group = this.groups[i];
            boolean bl2 = bl && !this.isJmolDataFrame(this.atoms[group.firstAtomIndex].modelIndex);
            Polymer polymer = this.jbr.buildBioPolymer(group, this.groups, i, bl2);
            if (polymer == null || polymer.monomerCount == 0) continue;
            this.addBioPolymerToModel(polymer, group.getModel());
            i += polymer.monomerCount - 1;
        }
    }

    protected void addBioPolymerToModel(Polymer polymer, Model model) {
        if (model.bioPolymers.length == 0 || polymer == null) {
            model.bioPolymers = new Polymer[8];
        }
        if (polymer == null) {
            model.bioPolymerCount = 0;
            return;
        }
        if (model.bioPolymerCount == model.bioPolymers.length) {
            model.bioPolymers = (Polymer[])ArrayUtil.doubleLength(model.bioPolymers);
        }
        polymer.bioPolymerIndexInModel = model.bioPolymerCount;
        model.bioPolymers[model.bioPolymerCount++] = polymer;
    }

    public float[] getNotionalUnitcell() {
        return this.unitCells == null || this.unitCells[0] == null ? null : this.unitCells[0].getNotionalUnitCell();
    }

    public boolean setCrystallographicDefaults() {
        return !this.isPDB && this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public Point3f getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    public Point3f getBoundBoxCenter(int n) {
        if (this.isJmolDataFrame(n)) {
            return new Point3f();
        }
        return this.boxInfo.getBoundBoxCenter();
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3fi[] getBboxVertices() {
        return this.boxInfo.getBboxVertices();
    }

    public Map<String, Object> getBoundBoxInfo() {
        return this.boxInfo.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.bboxModels;
    }

    public void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl, float f) {
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(point3f, point3f2, bl, f);
    }

    public String getBoundBoxCommand(boolean bl) {
        if (!bl && this.bboxAtoms != null) {
            return "boundbox " + Escape.escape(this.bboxAtoms);
        }
        this.ptTemp.set(this.boxInfo.getBoundBoxCenter());
        Vector3f vector3f = this.boxInfo.getBoundBoxCornerVector();
        String string = bl ? "boundbox " + Escape.escape(this.ptTemp) + " " + Escape.escape(vector3f) + "\n#or\n" : "";
        this.ptTemp.sub(vector3f);
        string = string + "boundbox corners " + Escape.escape(this.ptTemp) + " ";
        this.ptTemp.scaleAdd(2.0f, vector3f, this.ptTemp);
        float f = Math.abs(8.0f * vector3f.x * vector3f.y * vector3f.z);
        string = string + Escape.escape(this.ptTemp) + " # volume = " + f;
        return string;
    }

    public int getDefaultVdwType(int n) {
        return !this.models[n].isPDB ? 5 : (this.models[n].hydrogenCount == 0 ? 4 : 5);
    }

    public boolean setRotationRadius(int n, float f) {
        if (this.isJmolDataFrame(n)) {
            this.models[n].defaultRotationRadius = f;
            return false;
        }
        return true;
    }

    public float calcRotationRadius(int n, Point3f point3f) {
        if (this.isJmolDataFrame(n)) {
            float f = this.models[n].defaultRotationRadius;
            return f == 0.0f ? 10.0f : f;
        }
        float f = 0.0f;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.isJmolDataFrame(this.atoms[n2])) {
                n = this.atoms[n2].modelIndex;
                while (n2 >= 0 && this.atoms[n2].modelIndex == n) {
                    --n2;
                }
                continue;
            }
            Atom atom = this.atoms[n2];
            float f2 = point3f.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (!(f3 > f)) continue;
            f = f3;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public void calcBoundBoxDimensions(BitSet bitSet, float f) {
        if (bitSet != null && bitSet.nextSetBit(0) < 0) {
            bitSet = null;
        }
        if (bitSet == null && this.isBbcageDefault || this.atomCount < 2) {
            return;
        }
        this.bboxAtoms = BitSetUtil.copy(bitSet);
        this.bboxModels = this.getModelBitSet(this.bboxAtoms, false);
        if (this.calcAtomsMinMax(bitSet, this.boxInfo) == this.atomCount) {
            this.isBbcageDefault = true;
        }
        if (bitSet == null) {
            this.averageAtomPoint.set(this.getAtomSetCenter(null));
            if (this.unitCells != null) {
                this.calcUnitCellMinMax();
            }
        }
        this.boxInfo.setBbcage(f);
    }

    public BoxInfo getBoxInfo(BitSet bitSet, float f) {
        if (bitSet == null) {
            return this.boxInfo;
        }
        BoxInfo boxInfo = new BoxInfo();
        this.calcAtomsMinMax(bitSet, boxInfo);
        boxInfo.setBbcage(f);
        return boxInfo;
    }

    public int calcAtomsMinMax(BitSet bitSet, BoxInfo boxInfo) {
        int n;
        boxInfo.reset();
        int n2 = 0;
        boolean bl = bitSet == null;
        int n3 = n = bl ? this.atomCount - 1 : bitSet.nextSetBit(0);
        while (n3 >= 0) {
            ++n2;
            if (!this.isJmolDataFrame(this.atoms[n3])) {
                boxInfo.addBoundBoxPoint(this.atoms[n3]);
            }
            n3 = bl ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        return n2;
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            Point3f[] point3fArray = this.unitCells[i].getUnitCellVertices();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(point3fArray[j]);
            }
        }
    }

    public float calcRotationRadius(BitSet bitSet) {
        Point3f point3f = this.getAtomSetCenter(bitSet);
        float f = 0.0f;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.atoms[n];
            float f2 = point3f.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (f3 > f) {
                f = f3;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return f == 0.0f ? 10.0f : f;
    }

    public Point3f[][] getCenterAndPoints(List<BitSet[]> list, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2;
        int n = bl ? 1 : 0;
        int n2 = list.size();
        while (--n2 >= 0) {
            BitSet[] bitSetArray = list.get(n2);
            bitSet2 = bitSetArray[0];
            bitSet = bitSetArray[1];
            n += Math.min(bitSet2.cardinality(), bitSet.cardinality());
        }
        Point3f[][] point3fArray = new Point3f[2][n];
        if (bl) {
            point3fArray[0][0] = new Point3f();
            point3fArray[1][0] = new Point3f();
        }
        int n3 = list.size();
        while (--n3 >= 0) {
            BitSet[] bitSetArray = list.get(n3);
            bitSet2 = bitSetArray[0];
            bitSet = bitSetArray[1];
            int n4 = bitSet2.nextSetBit(0);
            int n5 = bitSet.nextSetBit(0);
            while (n4 >= 0 && n5 >= 0) {
                point3fArray[0][--n] = this.atoms[n4];
                point3fArray[1][n] = this.atoms[n5];
                if (bl) {
                    point3fArray[0][0].add(this.atoms[n4]);
                    point3fArray[1][0].add(this.atoms[n5]);
                }
                n4 = bitSet2.nextSetBit(n4 + 1);
                n5 = bitSet.nextSetBit(n5 + 1);
            }
        }
        if (bl) {
            point3fArray[0][0].scale(1.0f / (float)(point3fArray[0].length - 1));
            point3fArray[1][0].scale(1.0f / (float)(point3fArray[1].length - 1));
        }
        return point3fArray;
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        int n = 0;
        if (bitSet != null) {
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.isJmolDataFrame(this.atoms[n2])) {
                    ++n;
                    point3f.add(this.atoms[n2]);
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        if (n > 0) {
            point3f.scale(1.0f / (float)n);
        }
        return point3f;
    }

    @Override
    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        super.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
        if ((n == 1095763988 || n == 1632634889) && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds();
        }
    }

    public StateScript addStateScript(String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl, boolean bl2) {
        int n = this.viewer.getCurrentModelIndex();
        if (bl) {
            if (this.thisStateModel != n) {
                string = "frame " + (n < 0 ? "" + n : this.getModelNumberDotted(n)) + ";\n  " + string;
            }
            this.thisStateModel = n;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, string, bitSet, bitSet2, bitSet3, string2, bl2);
        if (stateScript.isValid()) {
            this.stateScripts.add(stateScript);
        }
        return stateScript;
    }

    protected void defineStructure(int n, String string, String string2, int n2, int n3, char c, int n4, char c2, char c3, int n5, char c4) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 10);
        }
        this.structures[this.structureCount++] = new Structure(n, string, string2, n2, n3, c, Group.getSeqcode(n4, c2), c3, Group.getSeqcode(n5, c4));
    }

    protected void calculateStructuresAllExcept(BitSet bitSet, boolean bl) {
        this.freezeModels();
        int n = this.modelCount;
        while (--n >= 0) {
            if (!this.models[n].isPDB || bitSet.get(n)) continue;
            this.models[n].calculateStructures();
        }
        this.setStructureIds();
        if (bl) {
            this.propagateSecondaryStructure();
        }
    }

    public void setProteinType(BitSet bitSet, byte by) {
        short s;
        int n;
        int n2 = -1;
        int n3 = -1;
        BitSet bitSet2 = new BitSet();
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            if (n3 != n4 - 1) {
                n2 = -1;
            }
            n2 = this.atoms[n4].group.setProteinStructureType(by, n2);
            n = this.atoms[n4].modelIndex;
            bitSet2.set(n);
            this.models[n].structureTainted = true;
            this.proteinStructureTainted = true;
            n3 = n4 = this.atoms[n4].group.lastAtomIndex;
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        int[] nArray = new int[this.modelCount];
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bitSet2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            n3 = this.atoms[n].getStrucNo();
            if (n3 < 1000 && n3 > nArray[s]) {
                nArray[s] = n3;
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bitSet2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            if (this.atoms[n].getStrucNo() > 1000) {
                short s2 = s;
                int n5 = nArray[s2] + 1;
                nArray[s2] = n5;
                this.atoms[n].group.setProteinStructureId(n5);
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
    }

    private void freezeModels() {
        int n = this.modelCount;
        while (--n >= 0) {
            int n2;
            Model model = this.models[n];
            model.chains = (Chain[])ArrayUtil.setLength(model.chains, model.chainCount);
            model.groupCount = -1;
            model.getGroupCount();
            for (n2 = 0; n2 < model.chainCount; ++n2) {
                model.chains[n2].groups = (Group[])ArrayUtil.setLength(model.chains[n2].groups, model.chains[n2].groupCount);
            }
            model.bioPolymers = (Polymer[])ArrayUtil.setLength(model.bioPolymers, model.bioPolymerCount);
            n2 = model.bioPolymerCount;
            while (--n2 >= 0) {
                model.bioPolymers[n2].freeze();
            }
        }
    }

    public float[][] getStructureList() {
        return this.viewer.getStructureList();
    }

    public void setStructureList(float[][] fArray) {
        int n = this.modelCount;
        while (--n >= 0) {
            Model model = this.models[n];
            model.bioPolymers = (Polymer[])ArrayUtil.setLength(model.bioPolymers, model.bioPolymerCount);
            int n2 = model.bioPolymerCount;
            while (--n2 >= 0) {
                model.bioPolymers[n2].setStructureList(fArray);
            }
        }
    }

    public BitSet setConformation(BitSet bitSet) {
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            this.models[n].setConformation(bitSet);
            n = bitSet2.nextSetBit(n + 1);
        }
        return bitSet;
    }

    public BitSet getConformation(int n, int n2, boolean bl) {
        BitSet bitSet = new BitSet();
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            int n4;
            if (n3 != n && n >= 0 || (n4 = this.getAltLocCountInModel(n3)) == 0 || n2 >= n4) continue;
            String string = this.getAltLocListInModel(n3);
            BitSet bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(n3);
            if (n2 >= 0) {
                int n5 = n4;
                while (--n5 >= 0) {
                    if (n5 == n2) continue;
                    bitSet2.andNot(this.getAtomBits(0x10001F, string.substring(n5, n5 + 1)));
                }
            }
            if (bitSet2.nextSetBit(0) < 0) continue;
            bitSet.or(bitSet2);
            if (!bl) continue;
            this.models[n3].setConformation(bitSet2);
        }
        return bitSet;
    }

    public Map<String, String> getHeteroList(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Map map;
            if (n >= 0 && n2 != n || (map = (Map)this.getModelAuxiliaryInfo(n2, "hetNames")) == null) continue;
            bl = true;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                hashtable.put(string, (String)entry.getValue());
            }
        }
        return bl ? hashtable : (Map)this.getModelSetAuxiliaryInfo("hetNames");
    }

    public Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    public Map<String, Object> getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    public String getModelSetProperty(String string) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(string);
    }

    protected boolean getModelSetAuxiliaryInfoBoolean(String string) {
        return this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(string) && (Boolean)this.modelSetAuxiliaryInfo.get(string) != false;
    }

    protected int getTrajectoryCount() {
        return this.trajectorySteps == null ? 0 : this.trajectorySteps.size();
    }

    public int getTrajectoryIndex(int n) {
        return this.models[n].trajectoryBaseIndex;
    }

    public boolean isTrajectory(int n) {
        return this.models[n].isTrajectory;
    }

    public boolean isTrajectory(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n = nArray[0];
        for (int i = 1; i <= n; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || !this.models[this.atoms[n2].modelIndex].isTrajectory) continue;
            return true;
        }
        return false;
    }

    public BitSet getModelBitSet(BitSet bitSet, boolean bl) {
        int n;
        BitSet bitSet2 = new BitSet();
        short s = 0;
        boolean bl2 = bitSet == null;
        int n2 = n = bl2 ? 0 : bitSet.nextSetBit(0);
        while (n2 >= 0 && n2 < this.atomCount) {
            s = this.atoms[n2].modelIndex;
            bitSet2.set(s);
            if (bl) {
                int n3 = this.models[s].trajectoryBaseIndex;
                for (int i = 0; i < this.modelCount; ++i) {
                    if (this.models[i].trajectoryBaseIndex != n3) continue;
                    bitSet2.set(i);
                }
            }
            n2 = this.models[s].firstAtomIndex + this.models[s].atomCount - 1;
            n2 = bl2 ? n2 + 1 : bitSet.nextSetBit(n2 + 1);
        }
        return bitSet2;
    }

    public BitSet getIterativeModels(boolean bl) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bl && this.isJmolDataFrame(i) || this.models[i].trajectoryBaseIndex != i) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public void selectDisplayedTrajectories(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isTrajectory || this.atoms[this.models[i].firstAtomIndex].modelIndex == i) continue;
            bitSet.clear(i);
        }
    }

    public String getModelNumberDotted(int n) {
        return this.modelCount < 1 || n < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[n]);
    }

    public int getModelNumber(int n) {
        return this.modelNumbers[n];
    }

    public int getModelFileNumber(int n) {
        return this.modelFileNumbers[n];
    }

    public Properties getModelProperties(int n) {
        return this.models[n].properties;
    }

    public String getModelProperty(int n, String string) {
        Properties properties = this.models[n].properties;
        return properties == null ? null : properties.getProperty(string);
    }

    public Map<String, Object> getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.models[n].auxiliaryInfo;
    }

    public void setModelAuxiliaryInfo(int n, Object object, Object object2) {
        this.models[n].auxiliaryInfo.put((String)object, object2);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        if (n < 0) {
            return null;
        }
        return this.models[n].auxiliaryInfo.get(string);
    }

    protected boolean getModelAuxiliaryInfoBoolean(int n, String string) {
        Map<String, Object> map = this.models[n].auxiliaryInfo;
        return map != null && map.containsKey(string) && (Boolean)map.get(string) != false;
    }

    protected int getModelAuxiliaryInfoInt(int n, String string) {
        Map<String, Object> map = this.models[n].auxiliaryInfo;
        if (map != null && map.containsKey(string)) {
            return (Integer)map.get(string);
        }
        return Integer.MIN_VALUE;
    }

    public int getInsertionCountInModel(int n) {
        return this.models[n].nInsertions;
    }

    public String getModelFileType(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "fileType");
    }

    public static int modelFileNumberFromFloat(float f) {
        int n;
        int n2 = (int)f;
        for (n = (int)(((double)(f - (float)n2) + 1.0E-5) * 10000.0); n != 0 && n % 10 == 0; n /= 10) {
        }
        return n2 * 1000000 + n;
    }

    public int getAltLocCountInModel(int n) {
        return this.models[n].nAltLocs;
    }

    private void propagateSecondaryStructure() {
        int n = this.structureCount;
        while (--n >= 0) {
            Structure structure = this.structures[n];
            this.models[structure.modelIndex].addSecondaryStructure(structure.type, structure.structureID, structure.serialID, structure.strandCount, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
        }
    }

    public int getChainCount(boolean bl) {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getChainCount(bl);
        }
        return n;
    }

    public int getBioPolymerCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (this.models[n2].isTrajectory && this.models[n2].trajectoryBaseIndex != n2) continue;
            n += this.models[n2].getBioPolymerCount();
        }
        return n;
    }

    public int getBioPolymerCountInModel(int n) {
        if (n < 0) {
            return this.getBioPolymerCount();
        }
        if (this.models[n].isTrajectory && this.models[n].trajectoryBaseIndex != n) {
            return 0;
        }
        return this.models[n].getBioPolymerCount();
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, List<Point3f[]> list) {
        boolean bl = this.viewer.getTraceAlpha();
        float f = this.viewer.getSheetSmoothing();
        int n = 0x7FFFFFFE;
        for (int i = 0; i < this.modelCount; ++i) {
            int n2 = this.models[i].getBioPolymerCount();
            for (int j = 0; j < n2; ++j) {
                n = this.models[i].getBioPolymer(j).getPolymerPointsAndVectors(n, bitSet, list, bl, f);
            }
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int n) {
        if (n < 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                this.recalculateLeadMidpointsAndWingVectors(i);
            }
            return;
        }
        int n2 = this.models[n].getBioPolymerCount();
        for (int i = 0; i < n2; ++i) {
            this.models[n].getBioPolymer(i).recalculateLeadMidpointsAndWingVectors();
        }
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.models[n].getBioPolymer(n2).getLeadMidpoints();
    }

    public int getChainCountInModel(int n, boolean bl) {
        if (n < 0) {
            return this.getChainCount(bl);
        }
        return this.models[n].getChainCount(bl);
    }

    public int getGroupCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getGroupCount();
        }
        return n;
    }

    public int getGroupCountInModel(int n) {
        if (n < 0) {
            return this.getGroupCount();
        }
        return this.models[n].getGroupCount();
    }

    public void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedGroupsCount(bitSet);
        }
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedMonomersCount(bitSet);
        }
    }

    public void calcRasmolHydrogenBonds(BitSet bitSet, BitSet bitSet2, List<Bond> list, boolean bl, int n) {
        boolean bl2 = bitSet.equals(bitSet2);
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (this.models[n2].trajectoryBaseIndex != n2) continue;
            if (list == null) {
                this.clearRasmolHydrogenBonds(n2, bitSet);
                if (!bl2) {
                    this.clearRasmolHydrogenBonds(n2, bitSet2);
                }
            }
            this.getRasmolHydrogenBonds(this.models[n2], bitSet, bitSet2, list, bl, n);
        }
    }

    public void calculateStraightness() {
        if (this.getHaveStraightness()) {
            return;
        }
        char c = 'S';
        char c2 = this.viewer.getQuaternionFrame();
        int n = this.viewer.getHelixStep();
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Model model = this.models[n2];
            int n3 = model.getBioPolymerCount();
            for (int i = 0; i < n3; ++i) {
                model.bioPolymers[i].getPdbData(this.viewer, c, c2, n, 2, false, null, null, null, null, false, false, new BitSet());
            }
        }
        this.setHaveStraightness(true);
    }

    public Quaternion[] getAtomGroupQuaternions(BitSet bitSet, int n, char c) {
        int n2 = 0;
        ArrayList<Quaternion> arrayList = new ArrayList<Quaternion>();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0 && n2 < n) {
            block7: {
                Quaternion quaternion;
                Group group;
                block6: {
                    group = this.atoms[n3].group;
                    quaternion = group.getQuaternion(c);
                    if (quaternion != null) break block6;
                    if (group.seqcode == Integer.MIN_VALUE) {
                        quaternion = group.getQuaternionFrame(this.atoms);
                    }
                    if (quaternion == null) break block7;
                }
                ++n2;
                arrayList.add(quaternion);
                n3 = group.lastAtomIndex;
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        Quaternion[] quaternionArray = new Quaternion[arrayList.size()];
        for (int i = 0; i < quaternionArray.length; ++i) {
            quaternionArray[i] = (Quaternion)arrayList.get(i);
        }
        return quaternionArray;
    }

    public String getPdbAtomData(BitSet bitSet, OutputStringBuffer outputStringBuffer) {
        if (this.atomCount == 0) {
            return "";
        }
        if (outputStringBuffer == null) {
            outputStringBuffer = new OutputStringBuffer(null);
        }
        short s = this.atoms[0].modelIndex;
        short s2 = -1;
        boolean bl = s != this.atoms[this.atomCount - 1].modelIndex;
        LabelToken[] labelTokenArray = null;
        LabelToken[] labelTokenArray2 = null;
        LabelToken[] labelTokenArray3 = null;
        LabelToken[] labelTokenArray4 = null;
        LabelToken[] labelTokenArray5 = null;
        LabelToken[] labelTokenArray6 = null;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            boolean bl2;
            Atom atom = this.atoms[n];
            if (bl && atom.modelIndex != s2) {
                if (s2 != -1) {
                    outputStringBuffer.append("ENDMDL\n");
                }
                s2 = atom.modelIndex;
                outputStringBuffer.append("MODEL     " + (s2 + 1) + "\n");
            }
            String string = atom.getAtomName();
            boolean bl3 = bl2 = atom.getElementSymbol().length() == 2 || string.length() >= 4 || Character.isDigit(string.charAt(0));
            LabelToken[] labelTokenArray7 = !this.models[atom.modelIndex].isPDB ? (bl2 ? (labelTokenArray == null ? LabelToken.compile(this.viewer, "HETATM%5.-5i %-4.4a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]\n", '\u0000', null) : labelTokenArray) : (labelTokenArray2 == null ? LabelToken.compile(this.viewer, "HETATM%5.-5i  %-3.3a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]\n", '\u0000', null) : labelTokenArray2)) : (atom.isHetero() ? (bl2 ? (labelTokenArray3 == null ? LabelToken.compile(this.viewer, "HETATM%5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]\n", '\u0000', null) : labelTokenArray3) : (labelTokenArray4 == null ? LabelToken.compile(this.viewer, "HETATM%5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]\n", '\u0000', null) : labelTokenArray4)) : (bl2 ? (labelTokenArray5 == null ? LabelToken.compile(this.viewer, "ATOM  %5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]\n", '\u0000', null) : labelTokenArray5) : (labelTokenArray6 == null ? LabelToken.compile(this.viewer, "ATOM  %5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]\n", '\u0000', null) : labelTokenArray6)));
            outputStringBuffer.append(LabelToken.formatLabel(this.viewer, atom, null, labelTokenArray7, '\u0000', null));
            n = bitSet.nextSetBit(n + 1);
        }
        if (bl) {
            outputStringBuffer.append("ENDMDL\n");
        }
        return outputStringBuffer.toString();
    }

    public String getPdbData(int n, String string, BitSet bitSet, Object[] objectArray, OutputStringBuffer outputStringBuffer) {
        if (this.isJmolDataFrame(n)) {
            n = this.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        Model model = this.models[n];
        if (outputStringBuffer == null) {
            outputStringBuffer = new OutputStringBuffer(null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = string.indexOf("draw") >= 0;
        BitSet bitSet2 = null;
        BitSet bitSet3 = new BitSet();
        boolean bl2 = this.models[n].isPDB;
        char c = '\u0000';
        if (objectArray == null) {
            char c2;
            if (!bl2) {
                return null;
            }
            boolean bl3 = false;
            char c3 = c = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'R';
            char c4 = c != 'R' ? (char)'r' : (c2 = string.length() > 13 && string.indexOf("ramachandran ") >= 0 ? (char)string.charAt(13) : (char)'R');
            if (c2 == 'r') {
                c2 = this.viewer.getQuaternionFrame();
            }
            int n2 = this.viewer.getHelixStep();
            int n3 = string.indexOf("diff") < 0 ? 0 : (string.indexOf("2") < 0 ? 1 : 2);
            int n4 = model.getBioPolymerCount();
            if (!bl) {
                outputStringBuffer.append("REMARK   6 Jmol PDB-encoded data: " + string + ";");
                if (c != 'R') {
                    outputStringBuffer.append("  quaternionFrame = \"" + c2 + "\"");
                    bl3 = true;
                }
                outputStringBuffer.append("\nREMARK   6 Jmol Version ").append(Viewer.getJmolVersion()).append('\n');
                if (c == 'R') {
                    outputStringBuffer.append("REMARK   6 Jmol data min = {-180 -180 -180} max = {180 180 180} unScaledXyz = xyz * {1 1 1} + {0 0 0} plotScale = {100 100 100}\n");
                } else {
                    outputStringBuffer.append("REMARK   6 Jmol data min = {-1 -1 -1} max = {1 1 1} unScaledXyz = xyz * {0.1 0.1 0.1} + {0 0 0} plotScale = {100 100 100}\n");
                }
            }
            for (int i = 0; i < n4; ++i) {
                model.bioPolymers[i].getPdbData(this.viewer, c, c2, n2, n3, bl, bitSet2, outputStringBuffer, stringBuffer, bitSet, i == 0, bl3, bitSet3);
            }
            bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(n);
        } else {
            bitSet2 = (BitSet)objectArray[0];
            float[] fArray = (float[])objectArray[1];
            float[] fArray2 = (float[])objectArray[2];
            float[] fArray3 = (float[])objectArray[3];
            boolean bl4 = fArray3 != null;
            Point3f point3f = (Point3f)objectArray[4];
            Point3f point3f2 = (Point3f)objectArray[5];
            Point3f point3f3 = (Point3f)objectArray[6];
            Point3f point3f4 = (Point3f)objectArray[7];
            outputStringBuffer.append("REMARK   6 Jmol PDB-encoded data: ").append(string).append(";\n");
            outputStringBuffer.append("REMARK   6 Jmol data").append(" min = ").append(Escape.escape(point3f)).append(" max = ").append(Escape.escape(point3f2)).append(" unScaledXyz = xyz * ").append(Escape.escape(point3f3)).append(" + ").append(Escape.escape(point3f4)).append(";\n");
            String string2 = "";
            Atom atom = null;
            int n5 = bitSet2.nextSetBit(0);
            int n6 = 0;
            while (n5 >= 0) {
                float f;
                float f2 = fArray[n6];
                float f3 = fArray2[n6];
                float f4 = f = bl4 ? fArray3[n6] : 0.0f;
                if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f))) {
                    Atom atom2 = this.atoms[n5];
                    if (bl2) {
                        outputStringBuffer.append(LabelToken.formatLabel(this.viewer, atom2, "ATOM  %-6i%4a%1A%3n %1c%4R%1E   "));
                        bitSet3.set(n5);
                    } else {
                        outputStringBuffer.append(LabelToken.formatLabel(this.viewer, atom2, "ATOM  %-6i%4a%1A%3n %1c%4R%1E   "));
                    }
                    outputStringBuffer.append(TextFormat.sprintf("%-8.2f%-8.2f%-10.2f    %6.3f          %2s    %s\n", new Object[]{atom2.getElementSymbol(false).toUpperCase(), string2, new float[]{f2, f3, f, 0.0f}}));
                    if (atom != null && atom.getPolymerIndexInModel() == atom2.getPolymerIndexInModel()) {
                        stringBuffer.append("CONECT").append(TextFormat.formatString("%5i", "i", atom.getAtomNumber())).append(TextFormat.formatString("%5i", "i", atom2.getAtomNumber())).append('\n');
                    }
                    atom = atom2;
                }
                n5 = bitSet2.nextSetBit(n5 + 1);
                ++n6;
            }
        }
        outputStringBuffer.append(stringBuffer.toString());
        if (bl) {
            return outputStringBuffer.toString();
        }
        bitSet.and(bitSet2);
        if (bl2) {
            outputStringBuffer.append("\n\n" + this.getProteinStructureState(bitSet3, false, c == 'R', true));
        }
        return outputStringBuffer.toString();
    }

    public boolean isJmolDataFrame(int n) {
        return n >= 0 && n < this.modelCount && this.models[n].isJmolDataFrame;
    }

    private boolean isJmolDataFrame(Atom atom) {
        return this.models[atom.modelIndex].isJmolDataFrame;
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        Model model = this.models[string == null ? this.models[n2].dataSourceFrame : n];
        if (string == null) {
            string = this.models[n2].jmolFrameType;
        }
        if (n >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable<String, Integer>();
            }
            this.models[n2].dataSourceFrame = n;
            this.models[n2].jmolFrameType = string;
            model.dataFrames.put(string, n2);
        }
        if (string.startsWith("quaternion") && string.indexOf("deriv") < 0) {
            string = string.substring(0, string.indexOf(" "));
            model.dataFrames.put(string, n2);
        }
    }

    public int getJmolDataFrameIndex(int n, String string) {
        if (this.models[n].dataFrames == null) {
            return -1;
        }
        Integer n2 = this.models[n].dataFrames.get(string);
        return n2 == null ? -1 : n2;
    }

    protected void clearDataFrameReference(int n) {
        for (int i = 0; i < this.modelCount; ++i) {
            Map<String, Integer> map = this.models[i].dataFrames;
            if (map == null) continue;
            Iterator<Integer> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != n) continue;
                iterator.remove();
            }
        }
    }

    public String getJmolFrameType(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int n, StateManager.Orientation orientation) {
        this.models[n].orientation = orientation;
    }

    public StateManager.Orientation getModelOrientation(int n) {
        return this.models[n].orientation;
    }

    private String getFullPDBHeader(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "fileHeader");
        if (string != null) {
            return string;
        }
        string = this.viewer.getCurrentFileAsString();
        int n2 = string.length();
        int n3 = pdbRecords.length;
        block4: while (--n3 >= 0) {
            String string2 = pdbRecords[n3];
            int n4 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n4) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    this.setModelAuxiliaryInfo(n, "fileHeader", "");
                    return "";
                }
            }
            if (n4 >= n2) continue;
            n2 = ++n4;
        }
        string = string.substring(0, n2);
        this.setModelAuxiliaryInfo(n, "fileHeader", string);
        return string;
    }

    public String getPDBHeader(int n) {
        return this.isPDB ? this.getFullPDBHeader(n) : this.getFileHeader(n);
    }

    public String getFileHeader(int n) {
        if (n < 0) {
            return "";
        }
        if (this.isPDB) {
            return this.getFullPDBHeader(n);
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "fileHeader");
        if (string == null) {
            string = this.modelSetName;
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public Map<String, Object> getModelInfo(BitSet bitSet) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", this.modelSetName);
        hashtable.put("modelCount", this.modelCount);
        hashtable.put("modelSetHasVibrationVectors", this.modelSetHasVibrationVectors());
        if (this.modelSetProperties != null) {
            hashtable.put("modelSetProperties", this.modelSetProperties);
        }
        hashtable.put("modelCountSelected", BitSetUtil.cardinalityOf(bitSet));
        hashtable.put("modelsSelected", bitSet);
        ArrayList arrayList = new ArrayList();
        this.getMolecules();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Float f;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", n);
            hashtable2.put("num", this.getModelNumber(n));
            hashtable2.put("file_model", this.getModelNumberDotted(n));
            hashtable2.put("name", this.getModelName(n));
            String string = this.getModelTitle(n);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = this.getModelFileName(n)) != null) {
                hashtable2.put("file", string);
            }
            hashtable2.put("vibrationVectors", this.modelHasVibrationVectors(n));
            hashtable2.put("atomCount", this.models[n].atomCount);
            hashtable2.put("bondCount", this.models[n].getBondCount());
            hashtable2.put("groupCount", this.models[n].getGroupCount());
            hashtable2.put("moleculeCount", this.models[n].moleculeCount);
            hashtable2.put("polymerCount", this.models[n].bioPolymerCount);
            hashtable2.put("chainCount", this.getChainCountInModel(n, true));
            if (this.models[n].properties != null) {
                hashtable2.put("modelProperties", this.models[n].properties);
            }
            if ((f = (Float)this.getModelAuxiliaryInfo(n, "Energy")) != null) {
                hashtable2.put("energy", f);
            }
            hashtable2.put("atomCount", this.models[n].atomCount);
            arrayList.add(hashtable2);
            n = bitSet.nextSetBit(n + 1);
        }
        hashtable.put("models", arrayList);
        return hashtable;
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public String getAltLocListInModel(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        return string == null ? "" : string;
    }

    private String getInsertionListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        return string == null ? "" : string;
    }

    public int getModelSymmetryCount(int n) {
        String[] stringArray;
        return this.models[n].biosymmetryCount > 0 || this.unitCells == null || this.unitCells[n] == null || (stringArray = this.unitCells[n].getSymmetryOperations()) == null ? this.models[n].biosymmetryCount : stringArray.length;
    }

    public String getSymmetryOperation(int n, String string, int n2, Point3f point3f, Point3f point3f2, String string2, boolean bl) {
        Map<String, Object> map = this.getSpaceGroupInfo(n, string, n2, point3f, point3f2, string2);
        if (map == null) {
            return "";
        }
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        --n2;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || n2 >= 0 && n2 != i) continue;
            if (string2 != null) {
                return (String)objectArray[i][3];
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            if (!bl) {
                if (n2 < 0) {
                    stringBuffer.append(i + 1).append("\t");
                }
                stringBuffer.append(objectArray[i][0]).append("\t");
            }
            stringBuffer.append(objectArray[i][2]);
        }
        if (stringBuffer.length() == 0 && string2 != null) {
            stringBuffer.append("draw " + string2 + "* delete");
        }
        return stringBuffer.toString();
    }

    public int[] getModelCellRange(int n) {
        if (this.unitCells == null) {
            return null;
        }
        return this.unitCells[n].getCellRange();
    }

    public boolean modelHasVibrationVectors(int n) {
        if (this.vibrationVectors != null) {
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (n >= 0 && this.atoms[n2].modelIndex != n || this.vibrationVectors[n2] == null || !(this.vibrationVectors[n2].length() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public BitSet getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            bitSet.or(this.elementsPresent[i]);
        }
        return bitSet;
    }

    private String getSymmetryInfoAsString(int n) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        return symmetryInterface == null ? "no symmetry information" : symmetryInterface.getSymmetryInfoString();
    }

    public List<Map<String, Object>> getMoleculeInfo(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.moleculeCount; ++i) {
            bitSet2 = BitSetUtil.copy(bitSet);
            JmolMolecule jmolMolecule = this.molecules[i];
            bitSet2.and(jmolMolecule.atomList);
            if (bitSet2.length() <= 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("number", jmolMolecule.moleculeIndex + 1);
            hashtable.put("modelNumber", this.getModelNumberDotted(jmolMolecule.modelIndex));
            hashtable.put("numberInModel", jmolMolecule.indexInModel + 1);
            hashtable.put("nAtoms", jmolMolecule.atomCount);
            hashtable.put("nElements", jmolMolecule.nElements);
            hashtable.put("mf", jmolMolecule.getMolecularFormula(false));
            arrayList.add(hashtable);
        }
        return arrayList;
    }

    public int getMoleculeIndex(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].indexInModel;
        }
        return 0;
    }

    public BitSet getMoleculeBitSet(BitSet bitSet) {
        int n;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bitSet2 = BitSetUtil.copy(bitSet);
        BitSet bitSet3 = BitSetUtil.copy(bitSet);
        BitSet bitSet4 = new BitSet();
        while ((n = bitSet3.length()) > 0) {
            bitSet4 = this.getMoleculeBitSet(n - 1);
            bitSet3.andNot(bitSet4);
            bitSet2.or(bitSet4);
        }
        return bitSet2;
    }

    public BitSet getMoleculeBitSet(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public void rotateAtoms(Matrix3f matrix3f, Matrix3f matrix3f2, BitSet bitSet, boolean bl, Point3f point3f, boolean bl2) {
        this.bspf = null;
        BitSet bitSet2 = bl ? this.getMoleculeBitSet(bitSet) : BitSetUtil.copy(bitSet);
        BitSetUtil.andNot(bitSet2, this.viewer.getMotionFixedAtoms());
        if (matrix3f == null) {
            this.matTemp.set(matrix3f2);
        } else {
            this.matInv.set(matrix3f2);
            this.matInv.invert();
            this.ptTemp.set(0.0f, 0.0f, 0.0f);
            this.matTemp.mul(matrix3f, matrix3f2);
            this.matTemp.mul(this.matInv, this.matTemp);
        }
        int n = 0;
        int n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            if (bl2) {
                this.atoms[n2].sub(point3f);
                this.matTemp.transform(this.atoms[n2]);
                this.atoms[n2].add(point3f);
            } else {
                this.ptTemp.add(this.atoms[n2]);
                this.matTemp.transform(this.atoms[n2]);
                this.ptTemp.sub(this.atoms[n2]);
            }
            this.taint(n2, (byte)2);
            ++n;
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
        if (n == 0) {
            return;
        }
        if (!bl2) {
            this.ptTemp.scale(1.0f / (float)n);
            n2 = bitSet2.nextSetBit(0);
            while (n2 >= 0) {
                this.atoms[n2].add(this.ptTemp);
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public void invertSelected(Point3f point3f, Point4f point4f, int n, BitSet bitSet, BitSet bitSet2) {
        this.bspf = null;
        if (point3f != null) {
            int n2 = bitSet2.nextSetBit(0);
            while (n2 >= 0) {
                float f = (point3f.x - this.atoms[n2].x) * 2.0f;
                float f2 = (point3f.y - this.atoms[n2].y) * 2.0f;
                float f3 = (point3f.z - this.atoms[n2].z) * 2.0f;
                this.setAtomCoordRelative(n2, f, f2, f3);
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
            return;
        }
        if (point4f != null) {
            Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
            vector3f.normalize();
            float f = (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
            int n3 = bitSet2.nextSetBit(0);
            while (n3 >= 0) {
                float f4 = -Measure.distanceToPlane(point4f, f, (Point3f)this.atoms[n3]) * 2.0f;
                float f5 = vector3f.x * f4;
                float f6 = vector3f.y * f4;
                float f7 = vector3f.z * f4;
                this.setAtomCoordRelative(n3, f5, f6, f7);
                n3 = bitSet2.nextSetBit(n3 + 1);
            }
            return;
        }
        if (n >= 0) {
            Object object;
            Atom atom = this.atoms[n];
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return;
            }
            BitSet bitSet3 = new BitSet();
            ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
            BitSet bitSet4 = this.viewer.getModelUndeletedAtomsBitSet(atom.modelIndex);
            for (int i = 0; i < bondArray.length; ++i) {
                object = bondArray[i].getOtherAtom(atom);
                if (bitSet.get(((Atom)object).index)) {
                    bitSet3.or(JmolMolecule.getBranchBitSet(this.atoms, bitSet4, ((Atom)object).index, n, true, true));
                    continue;
                }
                arrayList.add((Point3f)object);
            }
            if (arrayList.size() == 0) {
                return;
            }
            point3f = Measure.getCenterAndPoints(arrayList)[0];
            Vector3f vector3f = new Vector3f(atom);
            vector3f.sub(point3f);
            object = new Quaternion(vector3f, 180.0f);
            this.rotateAtoms(null, ((Quaternion)object).getMatrix(), bitSet3, false, atom, true);
        }
    }

    public Vector3f getModelDipole(int n) {
        if (n < 0) {
            return null;
        }
        Vector3f vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "dipole");
        if (vector3f == null) {
            vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "DIPOLE_VEC");
        }
        return vector3f;
    }

    public Vector3f calculateMolecularDipole(int n) {
        if (this.partialCharges == null || n < 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != n) continue;
            float f3 = this.partialCharges[i];
            if (f3 < 0.0f) {
                ++n3;
                f2 += f3;
                vector3f2.scaleAdd(f3, this.atoms[i], vector3f2);
                continue;
            }
            if (!(f3 > 0.0f)) continue;
            ++n2;
            f += f3;
            vector3f.scaleAdd(f3, this.atoms[i], vector3f);
        }
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        vector3f.scale(1.0f / f);
        vector3f2.scale(1.0f / f2);
        vector3f.sub(vector3f2);
        Logger.warn("CalculateMolecularDipole: this is an approximate result -- needs checking");
        vector3f.scale(f * 4.8f);
        return vector3f;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        if (n < 0) {
            return this.moleculeCount;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (n != i) continue;
            n2 += this.models[i].moleculeCount;
        }
        return n2;
    }

    public void calcSelectedMoleculesCount(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.moleculeCount; ++i) {
            BitSetUtil.copy(bitSet, bitSet2);
            bitSet2.and(this.molecules[i].atomList);
            if (bitSet2.length() <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    public JmolMolecule[] getMolecules() {
        int n;
        if (this.moleculeCount > 0) {
            return this.molecules;
        }
        if (this.molecules == null) {
            this.molecules = new JmolMolecule[4];
        }
        this.moleculeCount = 0;
        BitSet bitSet = new BitSet(this.atomCount);
        Model model = null;
        BitSet[] bitSetArray = new BitSet[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            bitSetArray[n] = this.viewer.getModelUndeletedAtomsBitSet(n);
            model = this.models[n];
            model.moleculeCount = 0;
            int n2 = 0;
            int n3 = model.getBioPolymerCount();
            for (int i = 0; i < n3; ++i) {
                BitSet bitSet2 = new BitSet();
                model.getBioPolymer(i).getRange(bitSet2);
                int n4 = bitSet2.nextSetBit(0);
                if (n4 < 0) continue;
                this.molecules = JmolMolecule.addMolecule(this.molecules, this.moleculeCount++, this.atoms, n4, bitSet2, model.modelIndex, n2++, bitSet);
            }
        }
        this.molecules = JmolMolecule.getMolecules(this.atoms, bitSetArray, this.molecules, this.moleculeCount, bitSet);
        n = this.moleculeCount = this.molecules.length;
        while (--n >= 0) {
            model = this.models[this.molecules[n].modelIndex];
            model.firstMoleculeIndex = n;
            ++model.moleculeCount;
        }
        return this.molecules;
    }

    public boolean hasCalculatedHBonds(BitSet bitSet) {
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            if (this.models[this.atoms[n].modelIndex].hasRasmolHBonds) {
                return true;
            }
            n = bitSet2.nextSetBit(n + 1);
        }
        return false;
    }

    public void clearRasmolHydrogenBonds(int n, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n2 = 0;
        this.models[n].hasRasmolHBonds = false;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            Bond bond = this.bonds[n3];
            if (n >= 0 && this.models[bond.atom1.modelIndex].trajectoryBaseIndex != n || (bond.order & 0x7000) == 0) continue;
            if (bitSet != null && !bitSet.get(bond.atom1.index)) {
                this.models[n].hasRasmolHBonds = true;
                continue;
            }
            bitSet2.set(n3);
            ++n2;
        }
        if (n2 > 0) {
            this.deleteBonds(bitSet2, false);
        }
    }

    protected void initializeBspf() {
        if (this.bspf == null) {
            if (Logger.debugging) {
                Logger.startTimer();
            }
            this.bspf = new Bspf(3);
            Logger.debug("sequential bspt order");
            int n = this.atomCount;
            while (--n >= 0) {
                Atom atom = this.atoms[n];
                this.bspf.addTuple(this.models[atom.modelIndex].trajectoryBaseIndex, atom);
            }
            if (Logger.debugging) {
                Logger.checkTimer("Time to build bspf");
                this.bspf.stats();
            }
        }
    }

    protected void initializeBspt(int n) {
        this.initializeBspf();
        if (this.bspf.isInitialized(n)) {
            return;
        }
        this.bspf.initialize(n, this.atoms, this.viewer.getModelUndeletedAtomsBitSet(n));
    }

    public void setIteratorForPoint(AtomIndexIterator atomIndexIterator, int n, Point3f point3f, float f) {
        this.initializeBspt(n);
        atomIndexIterator.set(n, this.models[n].firstAtomIndex, Integer.MAX_VALUE, point3f, f);
    }

    public void setIteratorForAtom(AtomIndexIterator atomIndexIterator, int n, int n2, float f) {
        if (n < 0) {
            n = this.atoms[n2].modelIndex;
        }
        n = this.models[n].trajectoryBaseIndex;
        this.initializeBspt(n);
        atomIndexIterator.set(n, this.models[n].firstAtomIndex, n2, this.atoms[n2], f);
    }

    public AtomIndexIterator getSelectedAtomIterator(BitSet bitSet, boolean bl, boolean bl2, boolean bl3) {
        this.initializeBspf();
        AtomIteratorWithinModel atomIteratorWithinModel = new AtomIteratorWithinModel();
        atomIteratorWithinModel.initialize(this.bspf, bitSet, bl, bl2, bl3, this.viewer.isParallel());
        return atomIteratorWithinModel;
    }

    @Override
    public int getBondCountInModel(int n) {
        return n < 0 ? this.bondCount : this.models[n].getBondCount();
    }

    public int calculateStruts(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3;
        this.makeConnections(0.0f, Float.MAX_VALUE, 32768, 12291, bitSet, bitSet2, null, false, 0.0f);
        int n = bitSet.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        short s = this.atoms[n].modelIndex;
        Model model = this.models[s];
        if (!model.isPDB) {
            return 0;
        }
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        Atom atom = null;
        if (bitSet.equals(bitSet2)) {
            bitSet3 = bitSet;
        } else {
            bitSet3 = BitSetUtil.copy(bitSet);
            bitSet3.or(bitSet2);
        }
        bitSet3.and(this.viewer.getModelUndeletedAtomsBitSet(s));
        int n2 = bitSet3.nextSetBit(0);
        while (n2 >= 0) {
            if (this.atoms[n2].isVisible(0) && this.atoms[n2].atomID == 2 && this.atoms[n2].getGroupID() != 5) {
                atom = this.atoms[n2];
                arrayList.add(atom);
            }
            n2 = bitSet3.nextSetBit(n2 + 1);
        }
        if (arrayList.size() == 0) {
            return 0;
        }
        float f = this.viewer.getStrutLengthMaximum();
        short s2 = (short)(this.viewer.getStrutDefaultRadius() * 2000.0f);
        int n3 = this.viewer.getStrutSpacingMinimum();
        boolean bl = this.viewer.getStrutsMultiple();
        List<Atom[]> list = model.getBioPolymer(atom.getPolymerIndexInModel()).calculateStruts((ModelSet)this, this.atoms, bitSet, bitSet2, arrayList, f, n3, bl);
        for (int i = 0; i < list.size(); ++i) {
            Atom[] atomArray = list.get(i);
            this.bondAtoms(atomArray[0], atomArray[1], 32768, s2, null, 0.0f, true);
        }
        return list.size();
    }

    public int getAtomCountInModel(int n) {
        return n < 0 ? this.atomCount : this.models[n].atomCount;
    }

    public BitSet getModelAtomBitSetIncludingDeleted(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        if (bitSet == null && this.bsAll == null) {
            this.bsAll = BitSetUtil.setAll(this.atomCount);
        }
        if (bitSet == null) {
            bitSet2.or(this.bsAll);
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bitSet2.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return bitSet2;
    }

    public BitSet getModelAtomBitSetIncludingDeleted(int n, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = n < 0 ? this.bsAll : this.models[n].bsAtoms;
        if (bitSet == null) {
            bitSet = this.bsAll = BitSetUtil.setAll(this.atomCount);
        }
        return bl ? BitSetUtil.copy(bitSet) : bitSet;
    }

    @Override
    public BitSet getAtomBits(int n, Object object) {
        switch (n) {
            default: {
                return super.getAtomBits(n, object);
            }
            case 1073741864: {
                return this.getBasePairBits((String)object);
            }
            case 1679429641: {
                BoxInfo boxInfo = this.getBoxInfo((BitSet)object, 1.0f);
                BitSet bitSet = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                int n2 = bitSet.nextSetBit(0);
                while (n2 >= 0) {
                    if (!boxInfo.isWithin(this.atoms[n2])) {
                        bitSet.clear(n2);
                    }
                    n2 = bitSet.nextSetBit(n2 + 1);
                }
                return bitSet;
            }
            case 1095761934: {
                return this.getMoleculeBitSet((BitSet)object);
            }
            case 1087373320: {
                return this.getSequenceBits((String)object, null);
            }
            case 1048615: {
                int[] nArray = (int[])object;
                int n3 = nArray[0];
                int n4 = nArray[1];
                char c = (char)nArray[2];
                BitSet bitSet = new BitSet();
                boolean bl = this.viewer.getChainCaseSensitive();
                if (!bl) {
                    c = Character.toUpperCase(c);
                }
                int n5 = this.modelCount;
                while (--n5 >= 0) {
                    this.models[n5].selectSeqcodeRange(n3, n4, c, bitSet, bl);
                }
                return bitSet;
            }
            case 3145753: {
                BitSet bitSet = new BitSet(this.atomCount);
                short s = -1;
                int n6 = 0;
                int n7 = this.atomCount;
                block13: while (--n7 >= 0) {
                    Atom atom = this.atoms[n7];
                    BitSet bitSet2 = atom.getAtomSymmetry();
                    if (bitSet2 == null) continue;
                    if (atom.modelIndex != s) {
                        s = atom.modelIndex;
                        if (this.getModelCellRange(s) == null) continue;
                        n6 = this.getModelSymmetryCount(s);
                    }
                    int n8 = 0;
                    int n9 = n6;
                    while (--n9 >= 0) {
                        if (!bitSet2.get(n9) || ++n8 <= 1) continue;
                        bitSet.set(n7);
                        continue block13;
                    }
                }
                return bitSet;
            }
            case 1089470478: {
                return BitSetUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = new BitSet(this.atomCount)) : this.bsSymmetry);
            }
            case 1614417984: {
                BitSet bitSet = new BitSet();
                SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                if (symmetryInterface == null) {
                    return bitSet;
                }
                Point3f point3f = new Point3f(1.0f, 1.0f, 1.0f);
                Point3f point3f2 = new Point3f();
                int n10 = this.atomCount;
                while (--n10 >= 0) {
                    if (!this.isInLatticeCell(n10, point3f, point3f2, false)) continue;
                    bitSet.set(n10);
                }
                return bitSet;
            }
            case 1095761925: 
        }
        BitSet bitSet = new BitSet();
        int[] nArray = (int[])object;
        Point3f point3f = new Point3f((float)nArray[0] / 1000.0f, (float)nArray[1] / 1000.0f, (float)nArray[2] / 1000.0f);
        Point3f point3f3 = new Point3f();
        boolean bl = !this.viewer.getFractionalRelative();
        int n11 = this.atomCount;
        while (--n11 >= 0) {
            if (!this.isInLatticeCell(n11, point3f, point3f3, bl)) continue;
            bitSet.set(n11);
        }
        return bitSet;
    }

    private boolean isInLatticeCell(int n, Point3f point3f, Point3f point3f2, boolean bl) {
        short s = this.atoms[n].modelIndex;
        SymmetryInterface symmetryInterface = this.getUnitCell(s);
        if (symmetryInterface == null) {
            return false;
        }
        point3f2.set(this.atoms[n]);
        symmetryInterface.toFractional(point3f2, bl);
        float f = 0.02f;
        if (point3f2.x < point3f.x - 1.0f - f || point3f2.x > point3f.x + f) {
            return false;
        }
        if (point3f2.y < point3f.y - 1.0f - f || point3f2.y > point3f.y + f) {
            return false;
        }
        return !(point3f2.z < point3f.z - 1.0f - f) && !(point3f2.z > point3f.z + f);
    }

    public BitSet getAtomsWithin(float f, BitSet bitSet, boolean bl) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = this.getIterativeModels(false);
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false);
        if (bl) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                int n2 = this.modelCount;
                while (--n2 >= 0) {
                    if (!bitSet3.get(n2)) continue;
                    if (f < 0.0f) {
                        this.getAtomsWithin(f, this.atoms[n].getFractionalUnitCoord(true), bitSet2, -1);
                        continue;
                    }
                    this.setIteratorForAtom(atomIndexIterator, n2, n, f);
                    atomIndexIterator.addAtoms(bitSet2);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        } else {
            bitSet2.or(bitSet);
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (f < 0.0f) {
                    this.getAtomsWithin(f, this.atoms[n], bitSet2, this.atoms[n].modelIndex);
                } else {
                    this.setIteratorForAtom(atomIndexIterator, -1, n, f);
                    atomIndexIterator.addAtoms(bitSet2);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }
        atomIndexIterator.release();
        return bitSet2;
    }

    public BitSet getGroupsWithin(int n, BitSet bitSet) {
        BitSet bitSet2 = this.getIterativeModels(false);
        BitSet bitSet3 = new BitSet();
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (!bitSet2.get(n2)) continue;
            Model model = this.models[n2];
            int n3 = model.bioPolymerCount;
            while (--n3 >= 0) {
                model.bioPolymers[n3].getRangeGroups(n, bitSet, bitSet3);
            }
        }
        return bitSet3;
    }

    public BitSet getAtomsWithin(float f, Point3f point3f, BitSet bitSet, int n) {
        if (bitSet == null) {
            bitSet = new BitSet();
        }
        if (f < 0.0f) {
            f = -f;
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                Atom atom = this.atoms[n2];
                if (n >= 0 && this.atoms[n2].modelIndex != n || bitSet.get(n2) || !(atom.getFractionalUnitDistance(point3f, point3f2, point3f3) <= f)) continue;
                bitSet.set(atom.index);
            }
            return bitSet;
        }
        BitSet bitSet2 = this.getIterativeModels(true);
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false);
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            if (!bitSet2.get(n3)) continue;
            this.setIteratorForAtom(atomIndexIterator, -1, this.models[n3].firstAtomIndex, -1.0f);
            atomIndexIterator.set(point3f, f);
            atomIndexIterator.addAtoms(bitSet);
        }
        atomIndexIterator.release();
        return bitSet;
    }

    private String getBasePairInfo(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Bond> arrayList = new ArrayList<Bond>();
        this.calcRasmolHydrogenBonds(bitSet, bitSet, arrayList, true, 1);
        int n = arrayList.size();
        while (--n >= 0) {
            Bond bond = (Bond)arrayList.get(n);
            ModelCollection.getAtomResidueInfo(stringBuffer, bond.atom1);
            stringBuffer.append(" - ");
            ModelCollection.getAtomResidueInfo(stringBuffer, bond.atom2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static void getAtomResidueInfo(StringBuffer stringBuffer, Atom atom) {
        stringBuffer.append("[").append(atom.getGroup3(false)).append("]").append(atom.getSeqcodeString()).append(":");
        char c = atom.getChainID();
        stringBuffer.append(c == '\u0000' ? " " : "" + c);
    }

    private BitSet getBasePairBits(String string) {
        BitSet bitSet = new BitSet();
        if (string.length() % 2 != 0) {
            return bitSet;
        }
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        ArrayList<Bond> arrayList = new ArrayList<Bond>();
        if (string.length() == 0) {
            bitSet2 = bitSet3 = this.viewer.getModelUndeletedAtomsBitSet(-1);
            this.calcRasmolHydrogenBonds(bitSet2, bitSet3, arrayList, true, 1);
        } else {
            int n = 0;
            while (n < string.length()) {
                if ((bitSet2 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0 || (bitSet3 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0) continue;
                this.calcRasmolHydrogenBonds(bitSet2, bitSet3, arrayList, true, 1);
            }
        }
        BitSet bitSet4 = new BitSet();
        int n = arrayList.size();
        while (--n >= 0) {
            Bond bond = (Bond)arrayList.get(n);
            bitSet4.set(bond.atom1.index);
            bitSet4.set(bond.atom2.index);
        }
        return super.getAtomBits(1087373318, bitSet4);
    }

    public BitSet getSequenceBits(String string, BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.viewer.getModelUndeletedAtomsBitSet(-1);
        }
        int n = string.length();
        BitSet bitSet2 = new BitSet();
        if (n == 0) {
            return bitSet2;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            int n2 = this.getBioPolymerCountInModel(i);
            block1: for (int j = 0; j < n2; ++j) {
                Polymer polymer = this.models[i].getBioPolymer(j);
                String string2 = polymer.getSequence();
                int n3 = -1;
                while (true) {
                    ++n3;
                    if ((n3 = string2.indexOf(string, n3)) < 0) continue block1;
                    polymer.getPolymerSequenceAtoms(n3, n, bitSet, bitSet2);
                }
            }
        }
        return bitSet2;
    }

    @Override
    public void deleteBonds(BitSet bitSet, boolean bl) {
        if (!bl) {
            BitSet bitSet2 = new BitSet();
            BitSet bitSet3 = new BitSet();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                Atom atom = this.bonds[n].atom1;
                if (!this.models[atom.modelIndex].isModelKit) {
                    bitSet2.clear();
                    bitSet3.clear();
                    bitSet2.set(atom.index);
                    bitSet3.set(this.bonds[n].getAtomIndex2());
                    this.addStateScript("connect ", null, bitSet2, bitSet3, "delete", false, true);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }
        super.deleteBonds(bitSet, bl);
    }

    protected int[] makeConnections(float f, float f2, int n, int n2, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, float f3) {
        boolean bl2;
        boolean bl3;
        if (bitSet3 == null) {
            bitSet3 = new BitSet();
        }
        boolean bl4 = n == 65535;
        boolean bl5 = bl3 = n == 131071;
        if (bl3) {
            n = 1;
        }
        boolean bl6 = (n & 0x7800) != 0;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        float f4 = f * f;
        float f5 = f2 * f2;
        switch (n2) {
            case 12291: {
                return this.deleteConnections(f, f2, n, bitSet, bitSet2, bl, bl3, f4, f5);
            }
            case 1073741852: {
                if (n != 515) {
                    return this.autoBond(bitSet, bitSet2, bitSet3, bl, bl6);
                }
                bl8 = true;
                bl10 = true;
                break;
            }
            case 1087373321: {
                bl7 = true;
                break;
            }
            case 1073742024: {
                bl8 = true;
                break;
            }
            case 0x40000050: {
                bl9 = true;
            }
        }
        this.defaultCovalentMad = this.viewer.getMadBond();
        boolean bl11 = f < 0.0f;
        boolean bl12 = bl2 = f2 < 0.0f;
        if (bl11) {
            f = -f;
        }
        if (bl2) {
            f2 = -f2;
        }
        short s = this.getDefaultMadFromOrder(n);
        int n3 = 0;
        int n4 = 0;
        Bond bond = null;
        int n5 = bl ? 1 : this.atomCount;
        Atom atom = null;
        Atom atom2 = null;
        float f6 = 0.0f;
        float f7 = 0.0f;
        short s2 = (short)(n | 0x20000);
        int n6 = bitSet.nextSetBit(0);
        while (n6 >= 0) {
            block28: {
                int n7;
                block27: {
                    block26: {
                        if (!bl) break block26;
                        bond = this.bonds[n6];
                        atom = bond.atom1;
                        atom2 = bond.atom2;
                        break block27;
                    }
                    atom = this.atoms[n6];
                    if (atom.isDeleted()) break block28;
                }
                int n8 = n7 = bl ? n5 : bitSet2.nextSetBit(0);
                while (n7 >= 0) {
                    block30: {
                        block29: {
                            if (bl) break block29;
                            if (n7 == n6) break block30;
                            atom2 = this.atoms[n7];
                            if (atom.modelIndex != atom2.modelIndex || atom2.isDeleted() || atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != '\u0000' && atom2.alternateLocationID != '\u0000') break block30;
                            bond = atom.getBond(atom2);
                        }
                        if (!(bond == null && (bl7 || bl8) || bond != null && bl9)) {
                            float f8 = atom.distanceSquared(atom2);
                            if (bl11 || bl2) {
                                f6 = atom.distance(atom2);
                                f7 = atom.getBondingRadiusFloat() + atom2.getBondingRadiusFloat();
                            }
                            if (!(!bl11 ? f8 < f4 : f6 < f7 * f) && !(!bl2 ? f8 > f5 : f6 > f7 * f2)) {
                                if (bond != null) {
                                    if (!bl7 && !bl4) {
                                        bond.setOrder(n);
                                        this.bsAromatic.clear(bond.index);
                                    }
                                    if (!bl7 || bl4 || n == bond.order || s2 == bond.order || bl6 && bond.isHydrogen()) {
                                        bitSet3.set(bond.index);
                                        ++n4;
                                    }
                                } else {
                                    bitSet3.set(this.bondAtoms((Atom)atom, (Atom)atom2, (int)n, (short)s, (BitSet)bitSet3, (float)f3, (boolean)true).index);
                                    ++n3;
                                }
                            }
                        }
                    }
                    n7 = bl ? n7 - 1 : bitSet2.nextSetBit(n7 + 1);
                }
            }
            n6 = bitSet.nextSetBit(n6 + 1);
        }
        if (bl10) {
            this.assignAromaticBonds(true, bitSet3);
        }
        if (!bl7) {
            this.shapeManager.setShapeSize(1, Integer.MIN_VALUE, null, bitSet3);
        }
        return new int[]{n3, n4};
    }

    /*
     * Enabled aggressive block sorting
     */
    public int autoBond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, short s) {
        BitSet bitSet5;
        int n;
        boolean bl;
        if (this.atomCount == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getBondTolerance();
        float f2 = this.viewer.getMinBondDistance();
        float f3 = f2 * f2;
        int n2 = 0;
        Logger.startTimer();
        short s2 = -1;
        boolean bl2 = bl = bitSet == null;
        if (bl) {
            n = 0;
            bitSet5 = null;
        } else {
            if (bitSet.equals(bitSet2)) {
                bitSet5 = bitSet;
            } else {
                bitSet5 = BitSetUtil.copy(bitSet);
                bitSet5.or(bitSet2);
            }
            n = bitSet5.nextSetBit(0);
        }
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, true);
        int n3 = n;
        while (true) {
            block10: {
                boolean bl3;
                float f4;
                Atom atom;
                boolean bl4;
                boolean bl5;
                block12: {
                    block9: {
                        block11: {
                            if (n3 < 0 || n3 >= this.atomCount) break block9;
                            bl5 = bl || bitSet.get(n3);
                            bl4 = bl || bitSet2.get(n3);
                            atom = this.atoms[n3];
                            if (atom.isDeleted()) break block10;
                            short s3 = atom.modelIndex;
                            if (s3 == s2) break block11;
                            s2 = s3;
                            if (!this.isJmolDataFrame(s3)) break block11;
                            n3 = this.models[s3].firstAtomIndex + this.models[s3].atomCount - 1;
                            break block10;
                        }
                        if ((f4 = atom.getBondingRadiusFloat()) == 0.0f) break block10;
                        bl3 = bitSet3 != null && bitSet3.get(n3);
                        float f5 = f4 + this.maxBondingRadius + f;
                        this.setIteratorForAtom(atomIndexIterator, -1, n3, f5);
                        break block12;
                    }
                    Logger.checkTimer("Time to autoBond");
                    return n2;
                }
                while (atomIndexIterator.hasNext()) {
                    short s4;
                    boolean bl6;
                    Atom atom2 = this.atoms[atomIndexIterator.next()];
                    if (atom2.isDeleted()) continue;
                    int n4 = atom2.index;
                    boolean bl7 = bl || bitSet.get(n4);
                    boolean bl8 = bl6 = bl || bitSet2.get(n4);
                    if (!bl7 && !bl6 || (!bl5 || !bl6) && (!bl4 || !bl7) || bl3 && bitSet3.get(n4) || (s4 = this.getBondOrder(f4, atom2.getBondingRadiusFloat(), atomIndexIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bitSet4)) continue;
                    ++n2;
                }
                atomIndexIterator.release();
            }
            n3 = bl ? n3 + 1 : bitSet5.nextSetBit(n3 + 1);
        }
    }

    private int[] autoBond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2) {
        if (bl) {
            BitSet bitSet4 = bitSet;
            bitSet = new BitSet();
            bitSet2 = new BitSet();
            int n = bitSet4.nextSetBit(0);
            while (n >= 0) {
                bitSet.set(this.bonds[n].atom1.index);
                bitSet2.set(this.bonds[n].atom2.index);
                n = bitSet4.nextSetBit(n + 1);
            }
        }
        return new int[]{bl2 ? this.autoHbond(bitSet, bitSet2) : this.autoBond(bitSet, bitSet2, null, bitSet3, this.viewer.getMadBond()), 0};
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2) {
        this.bsHBondsRasmol = new BitSet();
        boolean bl = false;
        int n = bitSet.nextSetBit(0);
        while (n >= 0 && !bl) {
            if (this.atoms[n].getElementNumber() == 1) {
                bl = true;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        n = this.viewer.getHbondsRasmol() ? 1 : 0;
        if (n != 0 && !bl) {
            Logger.info("Rasmol pseudo-hbond calculation");
            this.calcRasmolHydrogenBonds(bitSet, bitSet2, null, false, Integer.MAX_VALUE);
            return -BitSetUtil.cardinalityOf(this.bsHBondsRasmol);
        }
        Logger.info(bl ? "Standard Hbond calculation" : "Jmol pseudo-hbond calculation");
        BitSet bitSet3 = null;
        if (!bl) {
            bitSet3 = new BitSet();
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                byte by = this.atoms[n2].atomID;
                switch (by) {
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 64: {
                        bitSet3.set(n2);
                    }
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        float f = this.viewer.getHbondsDistanceMax();
        float f2 = (float)((double)this.viewer.getHbondsAngleMin() * Math.PI / 180.0);
        float f3 = f * f;
        float f4 = hbondMin * hbondMin;
        float f5 = 1.0f;
        float f6 = f > hbondMin ? f4 : f3;
        float f7 = f > hbondMin ? hbondMin : f;
        int n3 = 0;
        float f8 = 0.0f;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        if (Logger.debugging) {
            Logger.startTimer();
        }
        Point3f point3f = null;
        Point3f point3f2 = null;
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(bitSet2, false, false, false);
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            block16: {
                boolean bl2;
                float f9;
                float f10;
                float f11;
                short s;
                Object object;
                boolean bl3;
                Atom atom;
                block18: {
                    block17: {
                        atom = this.atoms[n4];
                        short s2 = atom.getElementNumber();
                        boolean bl4 = bl3 = s2 == 1;
                        if (!bl3 && (bl || s2 != 7 && s2 != 8) || bl3 && !bl) break block16;
                        if (!bl3) break block17;
                        object = atom.bonds;
                        if (object == null) break block16;
                        s = 0;
                        for (int i = 0; i < ((Bond[])object).length && s == 0; ++i) {
                            Atom atom2 = object[i].getOtherAtom(atom);
                            short s3 = atom2.getElementNumber();
                            s = s3 == 7 || s3 == 8 ? (short)1 : 0;
                        }
                        if (s == 0) break block16;
                        f11 = f7;
                        f10 = f5;
                        f9 = f6;
                        bl2 = false;
                        break block18;
                    }
                    f11 = f;
                    f10 = f4;
                    f9 = f3;
                    bl2 = bitSet3.get(n4);
                }
                this.setIteratorForAtom(atomIndexIterator, -1, atom.index, f11);
                while (atomIndexIterator.hasNext()) {
                    int n5;
                    object = this.atoms[atomIndexIterator.next()];
                    s = ((Atom)object).getElementNumber();
                    if (object == atom || !bl3 && s != 7 && s != 8 || bl3 && s == 1 || (f8 = atomIndexIterator.foundDistance2()) < f10 || f8 > f9 || bl2 && bitSet3.get(((Atom)object).index) || atom.isBonded((Atom)object)) continue;
                    if (f2 > 0.0f) {
                        vector3f.sub(atom, (Tuple3f)object);
                        point3f2 = ModelCollection.checkMinAttachedAngle(atom, f2, vector3f, vector3f2, bl);
                        if (point3f2 == null) continue;
                        vector3f.scale(-1.0f);
                        point3f = ModelCollection.checkMinAttachedAngle((Atom)object, f2, vector3f, vector3f2, bl);
                        if (point3f == null) continue;
                    }
                    float f12 = 0.0f;
                    if (bl3 && !Float.isNaN(point3f.x) && !Float.isNaN(point3f2.x)) {
                        n5 = 4096;
                        f12 = (float)HBond.getEnergy((float)Math.sqrt(f8), point3f.distance(atom), point3f.distance(point3f2), ((Point3f)object).distance(point3f2)) / 1000.0f;
                    } else {
                        n5 = 2048;
                    }
                    this.bsHBondsRasmol.set(this.addHBond(atom, (Atom)object, n5, f12));
                    ++n3;
                }
            }
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        atomIndexIterator.release();
        this.shapeManager.setShapeSize(1, Integer.MIN_VALUE, null, this.bsHBondsRasmol);
        if (Logger.debugging) {
            Logger.checkTimer("Time to hbond");
        }
        return bl ? n3 : -n3;
    }

    private static Point3f checkMinAttachedAngle(Atom atom, float f, Vector3f vector3f, Vector3f vector3f2, boolean bl) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null || bondArray.length == 0) {
            return new Point3f(Float.NaN, 0.0f, 0.0f);
        }
        Atom atom2 = null;
        float f2 = Float.MAX_VALUE;
        int n = bondArray.length;
        while (--n >= 0) {
            if (!bondArray[n].isCovalent()) continue;
            Atom atom3 = bondArray[n].getOtherAtom(atom);
            if (!bl && atom3.getElementNumber() == 1) continue;
            vector3f2.sub(atom, atom3);
            float f3 = vector3f2.angle(vector3f);
            if (f3 < f) {
                return null;
            }
            if (!(f3 < f2)) continue;
            atom2 = atom3;
            f2 = f3;
        }
        return atom2;
    }

    void setStructureIds() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            int n5;
            int n6 = this.atoms[i].modelIndex;
            n3 = n6;
            if (n6 != n4) {
                n = 0;
                n4 = n3;
                n2 = -1;
            }
            if ((n5 = this.atoms[i].getStrucNo()) == n2 || n5 == 0) continue;
            this.atoms[i].getGroup().setProteinStructureId(++n);
            n2 = n;
        }
    }

    public String getProteinStructureState(BitSet bitSet, boolean bl, boolean bl2, boolean bl3) {
        int n;
        BitSet bitSet2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        BitSet bitSet3 = null;
        if (bl) {
            if (!this.proteinStructureTainted) {
                return "";
            }
            bitSet3 = new BitSet();
            for (n = 0; n < this.atomCount; ++n) {
                if (!this.models[this.atoms[n].modelIndex].isStructureTainted()) continue;
                bitSet3.set(n);
            }
            bitSet3.set(this.atomCount);
        }
        for (n = 0; n <= this.atomCount; ++n) {
            char c;
            if (n != this.atomCount && bitSet != null && !bitSet.get(n) || bl && !bitSet3.get(n)) continue;
            n3 = 0;
            if (n == this.atomCount || (n3 = this.atoms[n].getStrucNo()) != n5) {
                if (bitSet2 != null) {
                    if (n2 == 3 || n2 == 1 || n2 == 2) {
                        ++n8;
                        if (bitSet == null) {
                            c = this.atoms[n4].modelIndex;
                            stringBuffer.append("  structure ").append(JmolConstants.getProteinStructureName(n2, false)).append(" ").append(Escape.escape(bitSet2)).append("    \t# model=").append(this.getModelNumberDotted(c)).append(" & (").append(n6).append(" - ").append(n7).append(");\n");
                        } else {
                            StringBuffer stringBuffer5;
                            String string6;
                            switch (n2) {
                                case 3: {
                                    int n12 = ++n9;
                                    if (string == null || bl3) {
                                        string = TextFormat.formatString("%3N %3N", "N", n12);
                                    }
                                    string6 = "HELIX  %ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB";
                                    stringBuffer5 = stringBuffer3;
                                    break;
                                }
                                case 2: {
                                    int n12 = ++n11;
                                    if (string == null || bl3) {
                                        string = TextFormat.formatString("%3N %3A 0", "N", n12);
                                        string = TextFormat.formatString(string, "A", "S" + n12);
                                    }
                                    string6 = "SHEET  %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    stringBuffer5 = stringBuffer4;
                                    break;
                                }
                                default: {
                                    int n12 = ++n10;
                                    if (string == null || bl3) {
                                        string = TextFormat.formatString("%3N %3N", "N", n12);
                                    }
                                    string6 = "TURN   %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    stringBuffer5 = stringBuffer2;
                                }
                            }
                            string6 = TextFormat.formatString(string6, "ID", string);
                            string6 = TextFormat.formatString(string6, "GROUPA", string2);
                            string6 = TextFormat.formatString(string6, "CA", string4);
                            string6 = TextFormat.formatString(string6, "RESA", n6);
                            string6 = TextFormat.formatString(string6, "GROUPB", string3);
                            string6 = TextFormat.formatString(string6, "CB", string5);
                            string6 = TextFormat.formatString(string6, "RESB", n7);
                            stringBuffer5.append(string6);
                            if (!bl3) {
                                stringBuffer5.append(" strucno= ").append(n5);
                            }
                            stringBuffer5.append("\n");
                        }
                    }
                    bitSet2 = null;
                }
                if (n3 == 0 || bitSet != null && bl2 && (Float.isNaN(this.atoms[n].getGroupParameter(1112539142)) || Float.isNaN(this.atoms[n].getGroupParameter(1112539143)))) continue;
            }
            if ((c = this.atoms[n].getChainID()) == '\u0000') {
                c = ' ';
            }
            if (bitSet2 == null) {
                bitSet2 = new BitSet();
                n6 = this.atoms[n].getResno();
                string2 = this.atoms[n].getGroup3(false);
                string4 = "" + c;
            }
            n2 = this.atoms[n].getProteinStructureType();
            string = this.atoms[n].getProteinStructureTag();
            bitSet2.set(n);
            n5 = n3;
            n7 = this.atoms[n].getResno();
            string3 = this.atoms[n].getGroup3(false);
            string5 = "" + c;
            n4 = n;
        }
        if (n8 > 0) {
            stringBuffer.append("\n");
        }
        return bitSet == null ? stringBuffer.toString() : stringBuffer3.append(stringBuffer4).append(stringBuffer2).append(stringBuffer).toString();
    }

    public String getModelInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("model count = ");
        stringBuffer.append(this.modelCount).append("\nmodelSetHasVibrationVectors:").append(this.modelSetHasVibrationVectors());
        if (this.modelSetProperties == null) {
            stringBuffer.append("\nProperties: null");
        } else {
            Enumeration<?> enumeration = this.modelSetProperties.propertyNames();
            stringBuffer.append("\nProperties:");
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n ").append(string).append("=").append(this.modelSetProperties.getProperty(string));
            }
        }
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\n").append(i).append(":").append(this.getModelNumberDotted(i)).append(":").append(this.getModelName(i)).append(":").append(this.getModelTitle(i)).append("\nmodelHasVibrationVectors:").append(this.modelHasVibrationVectors(i));
        }
        return stringBuffer.toString();
    }

    public String getSymmetryInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("Symmetry Information:");
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n").append(this.getSymmetryInfoAsString(i));
        }
        return stringBuffer.toString();
    }

    public BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        int n2;
        int n3;
        BitSet bitSet2 = new BitSet();
        int[] nArray = new int[this.atomCount];
        boolean bl = n == 30720;
        boolean bl2 = n == 65535;
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bonds[n3];
            if (!bl2 && !bond.is(n) && (!bl || !bond.isHydrogen())) continue;
            if (bitSet.get(bond.atom1.index)) {
                n2 = bond.atom2.index;
                nArray[n2] = nArray[n2] + 1;
                bitSet2.set(n2);
            }
            if (!bitSet.get(bond.atom2.index)) continue;
            n2 = bond.atom1.index;
            nArray[n2] = nArray[n2] + 1;
            bitSet2.set(n2);
        }
        n3 = f == 0.0f ? 1 : 0;
        n2 = this.atomCount;
        while (--n2 >= 0) {
            int n4 = nArray[n2];
            if ((float)n4 < f || (float)n4 > f2) {
                bitSet2.clear(n2);
                continue;
            }
            if (n3 == 0 || n4 != 0) continue;
            bitSet2.set(n2);
        }
        return bitSet2;
    }

    public String getModelExtract(BitSet bitSet, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[this.atomCount];
        StringBuffer stringBuffer = new StringBuffer();
        String string = bl2 ? "Jmol Model Kit" : this.viewer.getFullPathName();
        stringBuffer.append(string).append("\nJmol version ").append(Viewer.getJmolVersion()).append("\nEXTRACT: ").append(Escape.escape(bitSet)).append("\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        Quaternion quaternion = bl ? this.viewer.getRotationQuaternion() : null;
        Point3f point3f = new Point3f();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            if (quaternion == null || !this.atoms[n3].isDeleted()) {
                nArray[n3] = ++n;
                this.getAtomRecordMOL(stringBuffer2, n3, quaternion, point3f);
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bonds[n3];
            if (!bitSet.get(bond.atom1.index) || !bitSet.get(bond.atom2.index) || bond.isHydrogen()) continue;
            this.getBondRecordMOL(stringBuffer2, n3, nArray);
            ++n2;
        }
        if (n > 999 || n2 > 999) {
            Logger.error("ModelManager.java::getModel: ERROR atom/bond overflow");
            return "";
        }
        TextFormat.rFill(stringBuffer, "   ", "" + n);
        TextFormat.rFill(stringBuffer, "   ", "" + n2);
        stringBuffer.append("  0  0  0\n");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    private void getAtomRecordMOL(StringBuffer stringBuffer, int n, Quaternion quaternion, Point3f point3f) {
        if (quaternion == null) {
            point3f.set(this.atoms[n]);
        } else {
            quaternion.transform(this.atoms[n], point3f);
        }
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(point3f.x, 9));
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(point3f.y, 9));
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(point3f.z, 9));
        stringBuffer.append(" ").append(((this.atoms[n].isDeleted() ? "Xx" : this.getElementSymbol(n)) + "  ").substring(0, 2)).append("\n");
    }

    private void getBondRecordMOL(StringBuffer stringBuffer, int n, int[] nArray) {
        Bond bond = this.bonds[n];
        TextFormat.rFill(stringBuffer, "   ", "" + nArray[bond.atom1.index]);
        TextFormat.rFill(stringBuffer, "   ", "" + nArray[bond.atom2.index]);
        int n2 = bond.getValence();
        if (n2 > 3) {
            n2 = 1;
        }
        switch (bond.order & 0xFFFDFFFF) {
            case 515: {
                n2 = 4;
                break;
            }
            case 66: {
                n2 = 5;
                break;
            }
            case 513: {
                n2 = 6;
                break;
            }
            case 514: {
                n2 = 7;
            }
        }
        stringBuffer.append("  ").append(n2).append("\n");
    }

    @Override
    public String getChimeInfo(int n, BitSet bitSet) {
        int n2;
        switch (n) {
            case 1073741982: {
                break;
            }
            case 1073741864: {
                return this.getBasePairInfo(bitSet);
            }
            default: {
                return super.getChimeInfo(n, bitSet);
            }
        }
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        if (this.models[0].isPDB) {
            stringBuffer.append("\nMolecule name ....... " + this.getModelSetAuxiliaryInfo("COMPND"));
            stringBuffer.append("\nSecondary Structure . PDB Data Records");
            stringBuffer.append("\nBrookhaven Code ..... " + this.modelSetName);
            n2 = this.modelCount;
            while (--n2 >= 0) {
                n3 += this.models[n2].getChainCount(false);
            }
            stringBuffer.append("\nNumber of Chains .... " + n3);
            n3 = 0;
            n2 = this.modelCount;
            while (--n2 >= 0) {
                n3 += this.models[n2].getGroupCount(false);
            }
            n4 = 0;
            n2 = this.modelCount;
            while (--n2 >= 0) {
                n4 += this.models[n2].getGroupCount(true);
            }
            stringBuffer.append("\nNumber of Groups .... " + n3);
            if (n4 > 0) {
                stringBuffer.append(" (" + n4 + ")");
            }
            n2 = this.atomCount;
            while (--n2 >= 0) {
                if (!this.atoms[n2].isHetero()) continue;
                ++n4;
            }
        }
        stringBuffer.append("\nNumber of Atoms ..... " + (this.atomCount - n4));
        if (n4 > 0) {
            stringBuffer.append(" (" + n4 + ")");
        }
        stringBuffer.append("\nNumber of Bonds ..... " + this.bondCount);
        stringBuffer.append("\nNumber of Models ...... " + this.modelCount);
        if (this.models[0].isPDB) {
            n2 = 0;
            int n5 = 0;
            int n6 = 0;
            if (this.structures != null) {
                int n7 = this.structureCount;
                while (--n7 >= 0) {
                    switch (this.structures[n7].type) {
                        case 3: {
                            ++n2;
                            break;
                        }
                        case 2: {
                            ++n5;
                            break;
                        }
                        case 1: {
                            ++n6;
                        }
                    }
                }
            }
            stringBuffer.append("\nNumber of Helices ... " + n2);
            stringBuffer.append("\nNumber of Strands ... " + n5);
            stringBuffer.append("\nNumber of Turns ..... " + n6);
        }
        return stringBuffer.append('\n').toString().substring(1);
    }

    public String getModelFileInfo(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            String string = this.getModelNumberDotted(i);
            stringBuffer.append("\n\nfile[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelFileName(i))).append("\ntitle[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelTitle(i))).append("\nname[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelName(i)));
        }
        return stringBuffer.toString();
    }

    public Map<String, Object> getAuxiliaryInfo(BitSet bitSet) {
        Map<String, Object> map = this.modelSetAuxiliaryInfo;
        if (map == null) {
            return map;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            Map<String, Object> map2 = this.getModelAuxiliaryInfo(i);
            arrayList.add(map2);
        }
        map.put("models", arrayList);
        return map;
    }

    public List<Map<String, Object>> getAllAtomInfo(BitSet bitSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            arrayList.add(this.getAtomInfoLong(n));
            n = bitSet.nextSetBit(n + 1);
        }
        return arrayList;
    }

    public void getAtomIdentityInfo(int n, Map<String, Object> map) {
        map.put("_ipt", n);
        map.put("atomIndex", n);
        map.put("atomno", this.getAtomNumber(n));
        map.put("info", this.getAtomInfo(n, null));
        map.put("sym", this.getElementSymbol(n));
    }

    private Map<String, Object> getAtomInfoLong(int n) {
        Atom atom = this.atoms[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(n, hashtable);
        hashtable.put("element", this.getElementName(n));
        hashtable.put("elemno", this.getElementNumber(n));
        hashtable.put("x", new Float(this.atoms[n].x));
        hashtable.put("y", new Float(this.atoms[n].y));
        hashtable.put("z", new Float(this.atoms[n].z));
        hashtable.put("coord", new Point3f(atom));
        if (this.vibrationVectors != null && this.vibrationVectors[n] != null) {
            hashtable.put("vibVector", new Vector3f(this.vibrationVectors[n]));
        }
        hashtable.put("bondCount", atom.getCovalentBondCount());
        hashtable.put("radius", Float.valueOf((float)((double)atom.getRasMolRadius() / 120.0)));
        hashtable.put("model", atom.getModelNumberForLabel());
        hashtable.put("visible", this.atoms[n].isVisible(0));
        hashtable.put("clickabilityFlags", atom.clickabilityFlags);
        hashtable.put("visibilityFlags", atom.shapeVisibilityFlags);
        hashtable.put("spacefill", new Float(atom.getRadius()));
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(atom.colixAtom));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", atom.colixAtom);
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", atom.getFormalCharge());
        hashtable.put("partialCharge", new Float(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", new Float(f));
        }
        if (this.models[atom.modelIndex].isPDB) {
            hashtable.put("resname", atom.getGroup3(false));
            int n2 = atom.getSeqNumber();
            char c = atom.getInsertionCode();
            if (n2 > 0) {
                hashtable.put("resno", n2);
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            char c2 = atom.getChainID();
            hashtable.put("name", this.getAtomName(n));
            hashtable.put("chain", c2 == '\u0000' ? "" : "" + c2);
            hashtable.put("atomID", atom.atomID);
            hashtable.put("groupID", atom.getGroupID());
            if (atom.alternateLocationID != '\u0000') {
                hashtable.put("altLocation", "" + atom.alternateLocationID);
            }
            hashtable.put("structure", atom.getProteinStructureType());
            hashtable.put("polymerLength", atom.getPolymerLength());
            hashtable.put("occupancy", atom.getOccupancy100());
            int n3 = atom.getBfactor100();
            hashtable.put("temp", n3 / 100);
        }
        return hashtable;
    }

    public List<Map<String, Object>> getAllBondInfo(BitSet bitSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int n = bitSet.cardinality() == 1 ? bitSet.nextSetBit(0) : -1;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!(n >= 0 ? this.bonds[i].atom1.index == n || this.bonds[i].atom2.index == n : bitSet.get(this.bonds[i].atom1.index) && bitSet.get(this.bonds[i].atom2.index))) continue;
            arrayList.add(this.getBondInfo(i));
        }
        return arrayList;
    }

    private Map<String, Object> getBondInfo(int n) {
        Bond bond = this.bonds[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", n);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(atom.index, hashtable2);
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(atom2.index, hashtable3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", Float.valueOf(JmolConstants.getBondOrderNumberFromOrder(this.bonds[n].order)));
        hashtable.put("radius", Float.valueOf((float)((double)bond.mad / 2000.0)));
        hashtable.put("length_Ang", Float.valueOf(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(bond.colix));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", Integer.valueOf(bond.colix));
        boolean bl = bond.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        return hashtable;
    }

    public Map<String, List<Map<String, Object>>> getAllChainInfo(BitSet bitSet) {
        Hashtable<String, List<Map<String, Object>>> hashtable = new Hashtable<String, List<Map<String, Object>>>();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            List<Map<String, List<Map<String, Object>>>> list = this.getChainInfo(i, bitSet);
            if (list.size() <= 0) continue;
            hashtable2.put("modelIndex", i);
            hashtable2.put("chains", list);
            arrayList.add(hashtable2);
        }
        hashtable.put("models", arrayList);
        return hashtable;
    }

    private List<Map<String, List<Map<String, Object>>>> getChainInfo(int n, BitSet bitSet) {
        Model model = this.models[n];
        int n2 = model.getChainCount(true);
        ArrayList<Map<String, List<Map<String, Object>>>> arrayList = new ArrayList<Map<String, List<Map<String, Object>>>>();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChain(i);
            ArrayList arrayList2 = new ArrayList();
            int n3 = chain.getGroupCount();
            Hashtable hashtable = new Hashtable();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bitSet.get(group.firstAtomIndex)) continue;
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                hashtable2.put("groupIndex", j);
                hashtable2.put("groupID", group.getGroupID());
                String string = group.getSeqcodeString();
                if (string != null) {
                    hashtable2.put("seqCode", string);
                }
                hashtable2.put("_apt1", group.firstAtomIndex);
                hashtable2.put("_apt2", group.lastAtomIndex);
                hashtable2.put("atomInfo1", this.getAtomInfo(group.firstAtomIndex, null));
                hashtable2.put("atomInfo2", this.getAtomInfo(group.lastAtomIndex, null));
                hashtable2.put("visibilityFlags", group.shapeVisibilityFlags);
                arrayList2.add(hashtable2);
            }
            if (arrayList2.isEmpty()) continue;
            hashtable.put("residues", arrayList2);
            arrayList.add(hashtable);
        }
        return arrayList;
    }

    public Map<String, List<Map<String, Object>>> getAllPolymerInfo(BitSet bitSet) {
        Hashtable<String, List<Map<String, Object>>> hashtable = new Hashtable<String, List<Map<String, Object>>>();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            ArrayList<Map<String, Object>> arrayList2 = new ArrayList<Map<String, Object>>();
            int n = this.models[i].getBioPolymerCount();
            for (int j = 0; j < n; ++j) {
                Map<String, Object> map = this.models[i].getBioPolymer(j).getPolymerInfo(bitSet);
                if (map.isEmpty()) continue;
                arrayList2.add(map);
            }
            if (arrayList2.size() <= 0) continue;
            hashtable2.put("modelIndex", Integer.valueOf(i));
            hashtable2.put("polymers", arrayList2);
            arrayList.add(hashtable2);
        }
        hashtable.put("models", arrayList);
        return hashtable;
    }

    public String getUnitCellInfoText() {
        int n = this.viewer.getCurrentModelIndex();
        if (n < 0) {
            return "no single current model";
        }
        if (this.unitCells == null) {
            return "not applicable";
        }
        return this.unitCells[n].getUnitCellInfo();
    }

    public Map<String, Object> getSpaceGroupInfo(int n, String string, int n2, Point3f point3f, Point3f point3f2, String string2) {
        Object object;
        String string3 = null;
        Map<String, Object> map = null;
        SymmetryInterface symmetryInterface = null;
        Object[][] objectArray = null;
        if (string == null) {
            if (n <= 0) {
                int n3 = n = point3f instanceof Atom ? ((Atom)point3f).modelIndex : this.viewer.getCurrentModelIndex();
            }
            if (n < 0) {
                string3 = "no single current model";
            } else if (this.unitCells == null || this.unitCells[n] == null) {
                string3 = "not applicable";
            }
            if (string3 != null) {
                map = new Hashtable();
                map.put("spaceGroupInfo", string3);
                map.put("symmetryInfo", "");
                return map;
            }
            if (point3f == null && string2 == null && n2 != 0) {
                map = (Map)this.getModelAuxiliaryInfo(n, "spaceGroupInfo");
            }
            if (map != null) {
                return map;
            }
            map = new Hashtable();
            if (point3f == null && string2 == null && n2 == 0) {
                this.setModelAuxiliaryInfo(n, "spaceGroupInfo", map);
            }
            symmetryInterface = this.unitCells[n];
            string = symmetryInterface.getSpaceGroupName();
            object = this.unitCells[n].getSymmetryOperations();
            if (object == null) {
                string3 = "\n no symmetry operations employed";
            } else {
                this.getSymTemp(true);
                this.symTemp.setSpaceGroup(false);
                string3 = "\n" + ((String[])object).length + " symmetry operations employed:";
                objectArray = new Object[((String[])object).length][];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    int n4 = this.symTemp.addSpaceGroupOperation("=" + object[i], i + 1);
                    if (n4 < 0) continue;
                    Object[] objectArray2 = objectArray[i] = n2 > 0 && n2 - 1 != n4 ? null : this.symTemp.getSymmetryOperationDescription(n4, symmetryInterface, point3f, point3f2, string2);
                    if (objectArray[i] == null) continue;
                    string3 = string3 + "\n" + (i + 1) + "\t" + objectArray[i][0] + "\t" + objectArray[i][2];
                }
            }
        } else {
            map = new Hashtable<String, Object>();
        }
        map.put("spaceGroupName", string);
        this.getSymTemp(true);
        object = this.symTemp.getSpaceGroupInfo(string, symmetryInterface);
        if (objectArray != null) {
            map.put("operations", objectArray);
            map.put("symmetryInfo", string3);
        }
        if (object == null) {
            object = "could not identify space group from name: " + string + "\nformat: show spacegroup \"2\" or \"P 2c\" " + "or \"C m m m\" or \"x, y, z;-x ,-y, -z\"";
        }
        map.put("spaceGroupInfo", object);
        return map;
    }

    public Object getSymmetryInfo(BitSet bitSet, String string, int n, Point3f point3f, Point3f point3f2, String string2, int n2) {
        int n3;
        int n4 = -1;
        if (bitSet == null) {
            n4 = this.viewer.getCurrentModelIndex();
            if (n4 < 0) {
                return "";
            }
            bitSet = this.viewer.getModelUndeletedAtomsBitSet(n4);
        }
        if ((n3 = bitSet.nextSetBit(0)) < 0) {
            return "";
        }
        n4 = this.atoms[n3].modelIndex;
        SymmetryInterface symmetryInterface = this.getUnitCell(n4);
        if (symmetryInterface == null) {
            return "";
        }
        if (point3f2 != null) {
            return this.getSymmetryOperation(n4, null, n, point3f, point3f2, string2 == null ? "sym" : string2, n2 == 1826248716);
        }
        if (string == null) {
            String[] stringArray = symmetryInterface.getSymmetryOperations();
            if (stringArray == null || n == 0 || Math.abs(n) > stringArray.length) {
                return "";
            }
            string = n > 0 ? stringArray[n - 1] : stringArray[-1 - n];
        } else {
            n = 0;
        }
        this.getSymTemp(false);
        this.symTemp.setSpaceGroup(false);
        int n5 = this.symTemp.addSpaceGroupOperation((n < 0 ? "!" : "=") + string, Math.abs(n));
        if (n5 < 0) {
            return "";
        }
        this.symTemp.setUnitCell(symmetryInterface.getNotionalUnitCell());
        point3f = new Point3f(point3f == null ? this.atoms[n3] : point3f);
        if (n2 == 0x8100010) {
            symmetryInterface.toFractional(point3f, false);
            if (Float.isNaN(point3f.x)) {
                return "";
            }
            Point3f point3f3 = new Point3f();
            this.symTemp.newSpaceGroupPoint(n5, point3f, point3f3, 0, 0, 0);
            this.symTemp.toCartesian(point3f3, false);
            return point3f3;
        }
        Object[] objectArray = this.symTemp.getSymmetryOperationDescription(n5, symmetryInterface, point3f, point3f2, string2 == null ? "sym" : string2);
        int n6 = (Integer)objectArray[9];
        switch (n2) {
            case 135266306: {
                return objectArray;
            }
            case 7: {
                String[] stringArray = new String[]{(String)objectArray[0], (String)objectArray[1], (String)objectArray[2], Escape.escape((Vector3f)objectArray[4]), Escape.escape((Vector3f)objectArray[5]), Escape.escape((Point3f)objectArray[6]), Escape.escape((Point3f)objectArray[7]), Escape.escape((Vector3f)objectArray[8]), "" + objectArray[9], "" + Escape.escape((Matrix4f)objectArray[10])};
                return stringArray;
            }
            case 1073741982: {
                return objectArray[0];
            }
            default: {
                return objectArray[2];
            }
            case 135184: {
                return objectArray[3];
            }
            case 1073742178: {
                return objectArray[5];
            }
            case 12289: {
                return objectArray[6];
            }
            case 0x8100010: {
                return objectArray[7];
            }
            case 135266319: 
            case 1073741854: {
                return n6 == 0 == (n2 == 135266319) ? (Vector3f)objectArray[8] : null;
            }
            case 0x8100001: {
                return objectArray[9];
            }
            case 12: 
        }
        return objectArray[10];
    }

    private void getSymTemp(boolean bl) {
        if (this.symTemp == null || bl) {
            this.symTemp = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
    }

    protected void deleteModel(int n, int n2, int n3, BitSet bitSet, BitSet bitSet2) {
        int n4;
        if (n < 0) {
            this.bspf = null;
            this.bsAll = null;
            this.molecules = null;
            this.moleculeCount = 0;
            this.isBbcageDefault = false;
            this.calcBoundBoxDimensions(null, 1.0f);
            return;
        }
        this.modelNumbers = (int[])ArrayUtil.deleteElements(this.modelNumbers, n, 1);
        this.modelFileNumbers = (int[])ArrayUtil.deleteElements(this.modelFileNumbers, n, 1);
        this.modelNumbersForAtomLabel = (String[])ArrayUtil.deleteElements(this.modelNumbersForAtomLabel, n, 1);
        this.modelNames = (String[])ArrayUtil.deleteElements(this.modelNames, n, 1);
        this.frameTitles = (String[])ArrayUtil.deleteElements(this.frameTitles, n, 1);
        this.thisStateModel = -1;
        int n5 = 0;
        int n6 = this.structureCount;
        while (--n6 >= 0) {
            if (this.structures[n6].modelIndex > n) {
                --this.structures[n6].modelIndex;
                continue;
            }
            if (this.structures[n6].modelIndex != n) break;
            this.structures = (Structure[])ArrayUtil.deleteElements(this.structures, n6, 1);
            ++n5;
        }
        this.structureCount -= n5;
        String[] stringArray = (String[])this.getModelSetAuxiliaryInfo("group3Lists");
        int[][] nArray = (int[][])this.getModelSetAuxiliaryInfo("group3Counts");
        int n7 = n + 1;
        if (stringArray != null && stringArray[n7] != null) {
            n4 = stringArray[n7].length() / 6;
            while (--n4 >= 0) {
                if (nArray[n7][n4] <= 0) continue;
                int[] nArray2 = nArray[0];
                int n8 = n4;
                nArray2[n8] = nArray2[n8] - nArray[n7][n4];
                if (nArray[0][n4] != 0) continue;
                stringArray[0] = stringArray[0].substring(0, n4 * 6) + ",[" + stringArray[0].substring(n4 * 6 + 2);
            }
        }
        if (stringArray != null) {
            this.modelSetAuxiliaryInfo.put("group3Lists", ArrayUtil.deleteElements(stringArray, n, 1));
            this.modelSetAuxiliaryInfo.put("group3Counts", ArrayUtil.deleteElements(nArray, n, 1));
        }
        if (this.unitCells != null) {
            n4 = this.modelCount;
            while (--n4 > n) {
                this.unitCells[n4].setModelIndex(this.unitCells[n4].getModelIndex() - 1);
            }
            this.unitCells = (SymmetryInterface[])ArrayUtil.deleteElements(this.unitCells, n, 1);
        }
        n4 = this.stateScripts.size();
        while (--n4 >= 0) {
            if (this.stateScripts.get(n4).deleteAtoms(n, bitSet2, bitSet)) continue;
            this.stateScripts.remove(n4);
        }
        this.deleteModelAtoms(n2, n3, bitSet);
        this.viewer.deleteModelAtoms(n2, n3, bitSet);
    }

    public String getMoInfo(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            int n2;
            Map map;
            if (n >= 0 && i != n || (map = (Map)this.viewer.getModelAuxiliaryInfo(i, "moData")) == null) continue;
            List list = (List)map.get("mos");
            int n3 = n2 = list == null ? 0 : list.size();
            if (n2 == 0) continue;
            int n4 = n2;
            while (--n4 >= 0) {
                String string;
                Float f;
                String string2;
                Map map2 = (Map)list.get(n4);
                String string3 = (String)map2.get("type");
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = (String)map2.get("energyUnits")) == null) {
                    string2 = "";
                }
                if ((f = (Float)map2.get("occupancy")) != null) {
                    string3 = "occupancy " + f.floatValue() + " " + string3;
                }
                if ((string = (String)map2.get("symmetry")) != null) {
                    string3 = string3 + string;
                }
                stringBuffer.append(TextFormat.sprintf("model %-2s;  mo %-2i # energy %-8.3f %s %s\n", new Object[]{this.getModelNumberDotted(i), n4 + 1, map2.get("energy"), string2, string3}));
            }
        }
        return stringBuffer.toString();
    }

    public void assignAtom(int n, String string, boolean bl) {
        Serializable serializable;
        if (string == null) {
            string = "C";
        }
        Atom atom = this.atoms[n];
        BitSet bitSet = new BitSet();
        boolean bl2 = atom.getElementNumber() == 1;
        short s = Elements.elementNumberFromSymbol(string, true);
        boolean bl3 = false;
        if (s > 0) {
            this.setElement(atom, s);
            this.viewer.setShapeSize(0, this.viewer.getDefaultRadiusData(), BitSetUtil.setBit(n));
            this.setAtomName(n, string + atom.getAtomNumber());
            if (!this.models[atom.modelIndex].isModelKit) {
                this.taint(n, (byte)0);
            }
        } else if (string.equals("Pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (string.equals("Mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (string.equals("X")) {
            bl3 = true;
        } else if (!string.equals(".")) {
            return;
        }
        this.removeUnnecessaryBonds(atom, bl3);
        float f = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (bl2) {
                f = 1.5f;
            } else if (!bl2 && s == 1) {
                f = 1.0f;
            }
        }
        if (f != 0.0f) {
            serializable = new Vector3f(atom);
            ((Tuple3f)serializable).sub(this.atoms[atom.getBondedAtomIndex(0)]);
            float f2 = ((Vector3f)serializable).length();
            ((Vector3f)serializable).normalize();
            ((Tuple3f)serializable).scale(f - f2);
            this.setAtomCoordRelative(n, ((Vector3f)serializable).x, ((Vector3f)serializable).y, ((Vector3f)serializable).z);
        }
        serializable = BitSetUtil.setBit(n);
        if (s != 1 && bl) {
            this.bspf = null;
            bitSet = this.getAtomsWithin(1.0f, (BitSet)serializable, false);
            bitSet.andNot((BitSet)serializable);
            if (bitSet.nextSetBit(0) >= 0) {
                this.viewer.deleteAtoms(bitSet, false);
            }
            bitSet = this.viewer.getModelUndeletedAtomsBitSet(atom.modelIndex);
            bitSet.andNot(this.getAtomBits(1613758468, null));
            this.makeConnections(0.1f, 1.8f, 1, 0x40000050, (BitSet)serializable, bitSet, null, false, 0.0f);
        }
        this.viewer.addHydrogens((BitSet)serializable, false, true);
    }

    public void deleteAtoms(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n >= 0 && n < this.atomCount) {
            this.atoms[n].delete(bitSet2);
            n = bitSet.nextSetBit(n + 1);
        }
        BitSet bitSet3 = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            BitSetUtil.copy(bitSet, bitSet3);
            bitSet3.and(this.models[i].bsAtoms);
            this.models[i].bsDeleted.or(bitSet3);
        }
        this.deleteBonds(bitSet2, false);
    }

    public void appendLoadStates(StringBuffer stringBuffer) {
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append(this.getModelLoadState(i));
        }
    }

    public String getModelLoadState(int n) {
        if (n < 0) {
            n = this.modelCount - 1;
        }
        if (this.isJmolDataFrame(n)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.models[n].loadState);
        if (this.models[n].isModelKit) {
            BitSet bitSet = this.getModelAtomBitSetIncludingDeleted(n, false);
            if (this.tainted != null) {
                if (this.tainted[2] != null) {
                    this.tainted[2].andNot(bitSet);
                }
                if (this.tainted[3] != null) {
                    this.tainted[3].andNot(bitSet);
                }
            }
            this.models[n].loadScript = new StringBuffer();
            Viewer.getInlineData(stringBuffer, this.getModelExtract(bitSet, false, true), false);
        } else {
            stringBuffer.append(this.models[n].loadScript);
        }
        return stringBuffer.toString();
    }

    public String getModelCml(BitSet bitSet, int n, boolean bl) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = BitSetUtil.cardinalityOf(bitSet);
        if (n2 == 0) {
            return "";
        }
        XmlUtil.openTag(stringBuffer, "molecule");
        XmlUtil.openTag(stringBuffer, "atomArray");
        BitSet bitSet2 = new BitSet();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0 && --n >= 0) {
            object2 = this.atoms[n3];
            object = ((Atom)object2).getAtomName();
            TextFormat.simpleReplace((String)object, "\"", "''");
            bitSet2.set(((Atom)object2).index);
            XmlUtil.appendTag(stringBuffer, "atom/", new String[]{"id", "a" + (((Atom)object2).index + 1), "title", ((Atom)object2).getAtomName(), "elementType", ((Atom)object2).getElementSymbol(), "x3", "" + ((Atom)object2).x, "y3", "" + ((Atom)object2).y, "z3", "" + ((Atom)object2).z});
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        XmlUtil.closeTag(stringBuffer, "atomArray");
        if (bl) {
            XmlUtil.openTag(stringBuffer, "bondArray");
            for (n3 = 0; n3 < this.bondCount; ++n3) {
                String string;
                object2 = this.bonds[n3];
                object = ((Bond)object2).atom1;
                Atom atom = ((Bond)object2).atom2;
                if (!bitSet2.get(((Atom)object).index) || !bitSet2.get(atom.index) || (string = JmolConstants.getCmlOrder(((Bond)object2).order)) == null) continue;
                XmlUtil.appendTag(stringBuffer, "bond/", new String[]{"atomRefs2", "a" + (((Bond)object2).atom1.index + 1) + " a" + (((Bond)object2).atom2.index + 1), "order", string});
            }
            XmlUtil.closeTag(stringBuffer, "bondArray");
        }
        XmlUtil.closeTag(stringBuffer, "molecule");
        return stringBuffer.toString();
    }

    protected void growAtomArrays(int n) {
        this.atoms = (Atom[])ArrayUtil.setLength(this.atoms, n);
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])ArrayUtil.setLength(this.vibrationVectors, n);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.setLength(this.occupancies, n);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.setLength(this.bfactor100s, n);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.setLength(this.partialCharges, n);
        }
        if (this.ellipsoids != null) {
            this.ellipsoids = (Object[][])ArrayUtil.setLength(this.ellipsoids, n);
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.setLength(this.atomNames, n);
        }
        if (this.atomTypes != null) {
            this.atomTypes = ArrayUtil.setLength(this.atomTypes, n);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.setLength(this.atomSerials, n);
        }
    }

    protected Atom addAtom(int n, Group group, short s, String string, int n2, int n3, float f, float f2, float f3) {
        return this.addAtom(n, group, s, string, n2, n3, f, f2, f3, Float.NaN, Float.NaN, Float.NaN, Float.NaN, 0, 0.0f, 100, Float.NaN, null, false, '\u0000', (byte)0, null);
    }

    protected Atom addAtom(int n, Group group, short s, String string, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, int n4, float f8, int n5, float f9, Object[] objectArray, boolean bl, char c, byte by, BitSet bitSet) {
        Atom atom = new Atom(n, this.atomCount, f, f2, f3, f4, bitSet, n3, s, n4, bl, c);
        ++this.models[n].atomCount;
        this.models[n].bsAtoms.set(this.atomCount);
        if (s % 128 == 1) {
            ++this.models[n].hydrogenCount;
        }
        this.atoms[this.atomCount] = atom;
        this.setBFactor(this.atomCount, f9);
        this.setOccupancy(this.atomCount, n5);
        this.setPartialCharge(this.atomCount, f8);
        if (objectArray != null) {
            this.setEllipsoid(this.atomCount, objectArray);
        }
        atom.group = group;
        atom.colixAtom = this.viewer.getColixAtomPalette(atom, (byte)1);
        if (string != null) {
            int n6 = string.indexOf(0);
            if (n6 >= 0) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.atoms.length];
                }
                this.atomTypes[this.atomCount] = string.substring(n6 + 1);
                string = string.substring(0, n6);
            }
            atom.atomID = by;
            if (by == 0) {
                if (this.atomNames == null) {
                    this.atomNames = new String[this.atoms.length];
                }
                this.atomNames[this.atomCount] = string.intern();
            }
        }
        if (n2 != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.atoms.length];
            }
            this.atomSerials[this.atomCount] = n2;
        }
        if (!Float.isNaN(f5)) {
            this.setVibrationVector(this.atomCount, f5, f6, f7);
        }
        ++this.atomCount;
        return atom;
    }

    public String getInlineData(int n) {
        StringBuffer stringBuffer = this.models[n >= 0 ? n : this.modelCount - 1].loadScript;
        if (stringBuffer == null) {
            return "";
        }
        int n2 = stringBuffer.lastIndexOf("data \"");
        if (n2 < 0) {
            return null;
        }
        n2 = stringBuffer.indexOf("\"", n2 + 7);
        int n3 = stringBuffer.lastIndexOf("end \"");
        if (n3 < n2 || n2 < 0) {
            return null;
        }
        return stringBuffer.substring(n2 + 2, n3);
    }

    public boolean isAtomPDB(int n) {
        return n >= 0 && this.models[this.atoms[n].modelIndex].isPDB;
    }

    public boolean isAtomAssignable(int n) {
        return n >= 0 && this.atoms[n].modelIndex == this.modelCount - 1;
    }

    public int getGroupAtom(Atom atom, int n, String string) {
        Group group = atom.group;
        int n2 = group.getMonomerIndex();
        if (n2 < 0) {
            return -1;
        }
        Group[] groupArray = this.models[atom.modelIndex].getBioPolymer(group.getBioPolymerIndexInModel()).getGroups();
        int n3 = n2 + n;
        if (n3 >= 0 && n3 < groupArray.length) {
            Group group2 = groupArray[n3];
            if (n == 1 && !group2.isConnectedPrevious()) {
                return -1;
            }
            if ("0".equals(string)) {
                return group2.getLeadAtomIndex();
            }
            int n4 = group2.getLastAtomIndex();
            for (int i = group2.getFirstAtomIndex(); i <= n4; ++i) {
                if (string != null && !string.equalsIgnoreCase(this.atoms[i].getAtomName())) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean haveModelKit() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isModelKit) continue;
            return true;
        }
        return false;
    }

    public BitSet getModelKitStateBitset(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = BitSetUtil.copy(bitSet2);
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.models[i].isModelKit) continue;
            bitSet3.andNot(this.models[i].bsAtoms);
        }
        return BitSetUtil.deleteBits(bitSet, bitSet3);
    }

    public void setAtomNamesAndNumbers(int n, int n2, AtomCollection atomCollection) {
        if (n2 < 0) {
            n = this.models[this.atoms[n].modelIndex].firstAtomIndex;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atomCount];
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        boolean bl = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
        int s = Integer.MAX_VALUE;
        int n3 = 1;
        for (int i = n; i < this.atomCount; ++i) {
            short s2;
            Atom atom = this.atoms[i];
            if (atom.modelIndex != s2) {
                s2 = atom.modelIndex;
                int n4 = n3 = bl ? 0 : 1;
            }
            if (this.atomSerials[i] == 0 || n2 < 0) {
                int n5 = this.atomSerials[i] = i < n2 ? atomCollection.atomSerials[i] : n3;
            }
            if (this.atomNames[i] == null || n2 < 0) {
                this.atomNames[i] = (atom.getElementSymbol() + this.atomSerials[i]).intern();
            }
            if (this.models[s2].isModelKit && (atom.getElementNumber() <= 0 || atom.isDeleted())) continue;
            ++n3;
        }
    }

    private static class Structure {
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;
        int modelIndex;
        String structureID;
        int serialID;
        int strandCount;

        Structure(int n, String string, String string2, int n2, int n3, char c, int n4, char c2, int n5) {
            this.modelIndex = n;
            this.structureID = string2;
            this.strandCount = n3;
            this.serialID = n2;
            this.startChainID = c;
            this.startSeqcode = n4;
            this.endChainID = c2;
            this.endSeqcode = n5;
            this.type = "helix".equals(string) ? (byte)3 : ("sheet".equals(string) ? (byte)2 : ("turn".equals(string) ? (byte)1 : 0));
        }
    }

    public static class StateScript {
        private int modelIndex;
        private BitSet bsBonds;
        private BitSet bsAtoms1;
        private BitSet bsAtoms2;
        private String script1;
        private String script2;
        boolean postDefinitions;

        StateScript(int n, String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl) {
            this.modelIndex = n;
            this.script1 = string;
            this.bsBonds = BitSetUtil.copy(bitSet);
            this.bsAtoms1 = BitSetUtil.copy(bitSet2);
            this.bsAtoms2 = BitSetUtil.copy(bitSet3);
            this.script2 = string2;
            this.postDefinitions = bl;
        }

        public boolean isValid() {
            return !(this.script1 == null || this.script1.length() <= 0 || this.bsBonds != null && this.bsBonds.nextSetBit(0) < 0 || this.bsAtoms1 != null && this.bsAtoms1.nextSetBit(0) < 0 || this.bsAtoms2 != null && this.bsAtoms2.nextSetBit(0) < 0);
        }

        public String toString() {
            String string;
            if (!this.isValid()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.script1);
            if (this.bsBonds != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsBonds, false));
            }
            if (this.bsAtoms1 != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsAtoms1));
            }
            if (this.bsAtoms2 != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsAtoms2));
            }
            if (this.script2 != null) {
                stringBuffer.append(" ").append(this.script2);
            }
            if (!(string = stringBuffer.toString()).endsWith(";")) {
                string = string + ";";
            }
            return string;
        }

        public boolean isConnect() {
            return this.script1.indexOf("connect") == 0;
        }

        public boolean deleteAtoms(int n, BitSet bitSet, BitSet bitSet2) {
            if (n == this.modelIndex) {
                return false;
            }
            if (n > this.modelIndex) {
                return true;
            }
            BitSetUtil.deleteBits(this.bsBonds, bitSet);
            BitSetUtil.deleteBits(this.bsAtoms1, bitSet2);
            BitSetUtil.deleteBits(this.bsAtoms2, bitSet2);
            return this.isValid();
        }

        public void setModelIndex(int n) {
            this.modelIndex = n;
        }
    }
}

