"""
Electrolyte database.

Design::

     ┌────────────────────────────┐
     │           Validate         │
     │  ┌───────┐    ┌──────┐     │
     │  │JSON   │    │JSON  │     │
     │  │input  │    │schema│     │
     │  │data   │    │      │     │
     │  └───────┴┐ ┌─┴──────┘     │
     │           │ │              │
     │        ┌──▼─▼───┐          │
     │        │        │NO        │
     │        │ VALID? ├───►Error │
     │        └────┬───┘          │
     │             │              │
     │             │YES           │
     └─────────────┼──────────────┘
                   │                      ┌───────────────┐
     DB API........│.....                 │  reaction     │
        ...    ┌───▼───┐ ..    ;;;;;;;;   ├───────────────┤
       ..      │Load   ├──.───►;      ;   │  component    │
      ..       └───────┘  .    ; DB   ;───┼───────────────┤
     .          ▲         ..   ;      ;   │  base         │
    ..          │          .   ;;;;;;;;   ├───────────────┤
    .           │           ...           └───────────────┘
    .           │              ...        ...........................
    .   ┌───────▼┐    ┌─────────┐...    ...──────────┐   ┌───────────...
    .   │ Search ├───►│ Fetch   │  .   .. │ Component◄──o│ HasConfig │ .
    ..  └────────┘    └────┬────┘  .  ..  └──────▲───┘   └───o───────┘  .
     ...                   │      .  ..          │           │          .
        ...                │    ...  .           │           │         ..
           .....           │  ...   ..   ┌───────x───┐       │         .
                 . ... .. .│...     .    │ Reaction  │◄──────┘        ..
                           │        .    └─────▲─────┘                .
                           │        .          │                    ..
                           │        .  **┌─────x───┐               ..
                           └─────────.──►│ Result  │     Data model
                                     ... └─────────┘            ..
                                       .....                ....
                                            ............ ...
"""
__author__ = "Dan Gunter"

# Convenience imports
from .db_api import ElectrolyteDB