# This file is automatically generated from ${fd.name}, DO NOT EDIT!

import asyncio
import nats.aio

import nrpc
import nrpc.exc
from nrpc import nrpc_pb2

% for mod, alias in g.extra_imports():
import ${mod} as ${alias}
% endfor


PKG_SUBJECT = '${g.get_pkg_subject(fd)}'
PKG_SUBJECT_PARAMS = [${', '.join("'%s'" % p for p in g.get_pkg_params(fd))}]
PKG_SUBJECT_PARAMS_COUNT = ${len(g.get_pkg_params(fd))}
% for sd in fd.service:


${sd.name}_SUBJECT = '${g.get_svc_subject(sd)}'
${sd.name}_SUBJECT_PARAMS = [${', '.join("'%s'" % p for p in g.get_svc_params(sd))}]
${sd.name}_SUBJECT_PARAMS_COUNT = ${len(g.get_svc_params(sd))}


class ${sd.name}Handler:
    methods = {
    % for md in sd.method:
        '${g.get_mt_subject(md)}': ('${md.name}', ${len(g.get_mt_params(md))}, ${g.get_type(md.input_type) if md.input_type != '.nrpc.Void' else 'None'}, ${md.output_type != '.nrpc.NoReply'}, ${md.output_type == '.nrpc.Void'}, ${g.mt_has_streamed_reply(md)}),
    % endfor
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, ${
        ', '.join(
            ["pkg_%s='*'" % p for p in g.get_pkg_params(fd)]
            + ["svc_%s='*'" % p for p in g.get_svc_params(sd)]
            + ["method='>'"]
        )
    }):
        return '.'.join([
            ${', '.join(
                (['"%s"'%g.get_pkg_subject(fd)] if g.get_pkg_subject(fd) else [])
                + ["pkg_%s" % p for p in g.get_pkg_params(fd)]
                + [ sd.name+'_SUBJECT' ]
                + ["svc_%s" % p for p in g.get_svc_params(sd)]
                + ["method"]
            )}
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                ${sd.name}_SUBJECT, ${sd.name}_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in ${sd.name}.%s handler:" % mname, e)


class ${sd.name}Client:
    def __init__(
        self, nc,
        % for p in g.get_pkg_params(fd):
        pkg_${p},
        % endfor
        % for p in g.get_svc_params(sd):
        svc_${p},
        % endfor
    ):
        self.nc = nc
        % for p in g.get_pkg_params(fd):
        self.pkg_${p} = pkg_${p}
        % endfor
        % for p in g.get_svc_params(sd):
        self.svc_${p} = svc_${p}
        % endfor
    % for md in sd.method:

    async def ${md.name}(
        self,
        % for p in g.get_mt_params(md):
        ${p},
        % endfor
        % if md.input_type != '.nrpc.Void':
        req,
        % endif
    ):
        subject = PKG_SUBJECT + '.' + \
        % for p in g.get_pkg_params(fd):
self.pkg_${p} + '.' + \
        % endfor
${sd.name}_SUBJECT + '.' + \
        % for p in g.get_svc_params(sd):
self.svc_${p} + '.' + \
        % endfor
'${g.get_mt_subject(md)}'\
        % for p in g.get_mt_params(md):
 + '.' + ${p}\
        % endfor

      % if md.input_type != '.nrpc.Void':
        rawReq = req.SerializeToString()
      % else:
        rawReq = b''
      % endif

      % if md.output_type == '.nrpc.NoReply':
        await self.nc.publish(subject, rawReq)
      % elif g.mt_has_streamed_reply(md):
        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            % if md.output_type == '.nrpc.Void':
            if len(rawRep.data):
                raise ValueError("Received a non-empty response")
            yield None
            % else:
            yield ${g.get_type(md.output_type)}.FromString(rawRep.data)
            % endif
      % else:
        rawRep = await self.nc.timed_request(subject, rawReq, 5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        % if md.output_type == '.nrpc.Void':
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None
        % else:
        return ${g.get_type(md.output_type)}.FromString(rawRep.data)
        % endif
      % endif
    % endfor
% endfor # sd in fd.service
