# -*- coding: utf-8 -*-
from distutils.core import setup

modules = \
['flake8_pie']
entry_points = \
{'flake8.extension': ['PIE = flake8_pie:Flake8PieCheck']}

setup_kwargs = {
    'name': 'flake8-pie',
    'version': '0.6.0',
    'description': 'A flake8 extension that implements misc. lints',
    'long_description': '# flake8-pie [![CircleCI](https://circleci.com/gh/sbdchd/flake8-pie.svg?style=svg)](https://circleci.com/gh/sbdchd/flake8-pie) [![pypi](https://img.shields.io/pypi/v/flake8-pie.svg)](https://pypi.org/project/flake8-pie/)\n\n> A flake8 extension that implements misc. lints\n\nNote: flake8-pie requires Python 3.6 or greater\n\n## lints\n\n- PIE781: You are assigning to a variable and then returning. Instead remove the assignment and return.\n- PIE783: Celery tasks should have explicit names.\n- PIE784: Celery crontab is missing explicit arguments.\n- PIE785: Celery tasks should have expirations.\n\n### PIE781: Assign and Return\n\nBased on Clippy\'s\n[`let_and_return`](https://rust-lang.github.io/rust-clippy/master/index.html#let_and_return)\nand Microsoft\'s TSLint rule\n[`no-unnecessary-local-variable`](https://github.com/Microsoft/tslint-microsoft-contrib).\n\nFor more info on the structure of this lint, see the [accompanying blog\npost](https://steve.dignam.xyz/2018/12/16/creating-a-flake8-lint/).\n\n#### examples\n\n```python\n# error\ndef foo():\n   x = bar()\n   return x\n\n# allowed\ndef foo():\n   x, _ = bar()\n   return x\n```\n\n### PIE783: Celery tasks should have explicit names.\n\nWarn about [Celery](https://pypi.org/project/celery/) task definitions that don\'t have explicit names.\n\nNote: this lint is kind of naive considering any decorator with a `.task()`\nmethod or any decorator called `shared_task()` a Celery decorator.\n\n#### examples\n\n```python\n# error\n@app.task()\ndef foo():\n    pass\n\n# ok\n@app.task(name="app_name.tasks.foo")\ndef foo():\n    pass\n```\n\n### PIE784: Celery crontab is missing explicit arguments.\n\nThe `crontab` class provided by Celery has some default args that are\nsuprising to new users. Specifically, `crontab(hour="0,12")` won\'t run a task\nat midnight and noon, it will run the task at every minute during those two\nhours. This lint makes that call an error, forcing you to write\n`crontab(hour="0, 12", minute="*")`.\n\nAdditionally, the lint is a bit more complex in that it requires you specify\nevery smaller increment than the largest time increment you provide. So if you\nprovide `days_of_week`, then you need to provide `hour`s and `minute`s\nexplicitly.\n\nNote: if you like the default behavior of `crontab()` then you can either\ndisable this lint or pass `"*"` for the `kwarg` value, e.g., `minutes="*"`.\n\nAlso, since this lint is essentially a naive search for calls to a\n`crontab()` function, if you have a function named the same then this will\ncause false positives.\n\n### PIE785: Celery tasks should have expirations.\n\nCelery tasks can bunch up if they don\'t have expirations.\n\nThis enforces specifying expirations in both the celery beat config dict and\nin `.apply_async()` calls.\n\nThe same caveat applies about how this lint is naive.\n\n### PIE786: Use precise exception handlers\n\nBe precise in what exceptions you catch. Bare `except:` handlers, catching `BaseException`, or catching `Exception` can lead to unexpected bugs.\n\n#### examples\n\n```python\n# error\ntry:\n    save_file(name="export.csv")\nexcept:\n    pass\n\n# error\ntry:\n    save_file(name="export.csv")\nexcept BaseException:\n    pass\n\n# error\ntry:\n    save_file(name="export.csv")\nexcept Exception:\n    pass\n\n# error\ntry:\n    save_file(name="export.csv")\nexcept (ValueError, Exception):\n    pass\n\n\n# ok\ntry:\n    save_file(name="export.csv")\nexcept OSError:\n    pass\n```\n\n\n## dev\n\n```shell\n# install dependencies\npoetry install\n\n# install plugin to work with flake8\npoetry run python setup.py install\n\n# test\npoetry run pytest\n# or with watch\npoetry run ptw\n\n# typecheck\npoetry run mypy *.py\n\n# format\npoetry run black .\n\n# lint\npoetry run flake8 .\n```\n\n## uploading a new version to [PyPi](https://pypi.org)\n\n```shell\n# increment `Flake8PieCheck.version` and pyproject.toml `version`\n\n# build new distribution files and upload to pypi\n# Note: this will ask for login credentials\nrm -rf dist && poetry publish --build\n```\n',
    'author': 'Steve Dignam',
    'author_email': 'steve@dignam.xyz',
    'url': 'https://github.com/sbdchd/flake8-pie',
    'py_modules': modules,
    'entry_points': entry_points,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
