# Generated by Django 3.0.11 on 2021-01-24 23:50

import uuid
from decimal import Decimal

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import bpp.models.uczelnia
import bpp.util


class Migration(migrations.Migration):

    dependencies = [
        ("bpp", "0235_auto_20210125_0042"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("raport_slotow", "0003_auto_20200329_1719"),
    ]

    operations = [
        migrations.CreateModel(
            name="RaportSlotowUczelnia",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_on", models.DateTimeField(auto_now_add=True)),
                ("last_updated_on", models.DateTimeField(auto_now=True)),
                ("started_on", models.DateTimeField(blank=True, null=True)),
                ("finished_on", models.DateTimeField(blank=True, null=True)),
                ("finished_successfully", models.BooleanField(default=False)),
                ("traceback", models.TextField(blank=True, null=True)),
                ("od_roku", models.IntegerField(default=bpp.util.year_last_month)),
                (
                    "do_roku",
                    models.IntegerField(
                        default=bpp.models.uczelnia.UczelniaManager.do_roku_default
                    ),
                ),
                (
                    "slot",
                    models.DecimalField(
                        decimal_places=4, default=Decimal("1"), max_digits=7
                    ),
                ),
                (
                    "minimalny_pk",
                    models.DecimalField(decimal_places=2, default=0, max_digits=5),
                ),
                (
                    "dziel_na_jednostki_i_wydzialy",
                    models.BooleanField(
                        default=True, verbose_name="Dziel na jednostki i wydziały"
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-last_updated_on"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="RaportSlotowUczelniaWiersz",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "pkd_aut_sum",
                    models.DecimalField(
                        decimal_places=4,
                        max_digits=8,
                        verbose_name="Suma punktów dla autora",
                    ),
                ),
                ("slot", models.DecimalField(decimal_places=4, max_digits=8)),
                (
                    "autor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="bpp.Autor"
                    ),
                ),
                (
                    "dyscyplina",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="bpp.Dyscyplina_Naukowa",
                    ),
                ),
                (
                    "jednostka",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="bpp.Jednostka"
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="raport_slotow.RaportSlotowUczelnia",
                    ),
                ),
            ],
        ),
    ]
