# Generated by Django 3.0.14 on 2021-08-18 20:39

from django.db import migrations


def _create_idx(fld, table):
    #  create  index foo114 on pbn_api_publication using gin (upper("title") gin_trgm_ops);
    format = ""
    if fld.find("::") >= 0:
        fld, format = fld.split("::")
        format = f"::{format}"

    idx_name = f"{table[:15]}_{fld}_idx"
    create = f'CREATE INDEX {idx_name} ON {table} USING GIN (UPPER("{fld}"{format}) gin_trgm_ops);'
    delete = f"DROP INDEX {idx_name}"
    return create, delete


def _crt(table, *flds):
    for elem in flds:
        yield migrations.RunSQL(*_create_idx(elem, table))


class Migration(migrations.Migration):

    dependencies = [
        ("pbn_api", "0028_gist_idx_publications"),
    ]

    operations = (
        list(
            _crt(
                "pbn_api_institution",
                "name",
                "addressCity",
                "addressStreet",
                "addressPostalCode",
                "polonUid",
                "mongoId",
            )
        )
        + list(
            _crt(
                "pbn_api_journal",
                "title",
                "websiteLink",
                "issn",
                "eissn",
                "mniswId::text",
                "mongoId",
            )
        )
        + list(
            _crt(
                "pbn_api_publisher",
                "publisherName",
                "mniswId::text",
                "mongoId",
            )
        )
        + list(
            _crt(
                "pbn_api_scientist",
                "lastName",
                "name",
                "orcid",
                "mongoId",
            )
        )
    )
