;(function($,window,document,undefined){'use strict';var pluginName="jinplace";var option_list=['type','url','data','loadurl','elementId','object','attribute','okButton','cancelButton','inputClass','activator','textOnly','placeholder','submitFunction'];function JinPlace(element,options){var $el=this.element=$(element);var elementOptions=this.elementOptions($el);var act=elementOptions.activator||element;elementOptions.activator=$(act);var opts=$.extend({},$.fn[pluginName].defaults,options,elementOptions);this.opts=opts;this.bindElement(opts);}
JinPlace.prototype={elementOptions:function($el){var opts={};function upperToHyphenLower(match){return'-'+match.toLowerCase();}
function make_attr_name(value){return"data-"+value.replace(/[A-Z]/g,upperToHyphenLower);}
$.each(option_list,function(index,value){opts[value]=$el.attr(make_attr_name(value));});opts.elementId=$el.attr('id');if(opts.textOnly)
opts.textOnly=opts.textOnly!=='false';return opts;},bindElement:function(opts){opts.activator.off('click.jip').on('click.jip',$.proxy(this.clickHandler,this));var $el=this.element;if($.trim($el.html())==""){$el.html(opts.placeholder);opts.placeholder=$el.html();}},clickHandler:function(ev){ev.preventDefault();ev.stopPropagation();$(ev.currentTarget).off('click.jip').on('click.jip',function(ev){ev.preventDefault();});var self=this,opts=self.opts;var editor=$.extend({},editorBase,$.fn[pluginName].editors[opts.type]);self.origValue=self.element.html();self.fetchData(opts).done(function(data){var field=editor.makeField(self.element,data);if(!editor.inputField)
editor.inputField=field;field.addClass(opts.inputClass);var form=createForm(opts,field,editor.buttonsAllowed);self.element.html(form);form.on("jip:submit submit",function(ev){self.submit(editor,opts);return false;}).on("jip:cancel",function(ev){self.cancel(editor);return false;}).on("keyup",function(ev){if(ev.keyCode==27){self.cancel(editor);}});editor.activate(form,field);var act=editor.blurAction||((!opts.okButton)?'submit':(!opts.cancelButton)?'jip:cancel':undefined);editor.blurEvent(field,form,act);});},fetchData:function(opts){var data;if(opts.data){data=opts.data;}else if(opts.loadurl){data=opts.loadFunction(opts);}else{data=$.trim(this.element.html());}
var placeholderFilter=function(data){if(data==opts.placeholder)
return'';return data;};var when=$.when(data);if(when.pipe){return when.pipe(placeholderFilter);}else{return when.then(placeholderFilter);}},cancel:function(editor){var self=this;self.element.html(self.origValue);editor.finish();self.bindElement(self.opts);},submit:function(editor,opts){var self=this;var rval;var rejected=$.Deferred().reject();try{rval=opts.submitFunction.call(undefined,opts,editor.value());if(rval===undefined)
rval=rejected;}catch(e){rval=rejected;}
$.when(rval).done(function(data){self.onUpdate(editor,opts,data);}).fail(function(){self.cancel(editor);});},onUpdate:function(editor,opts,data){var self=this;self.setContent(data);editor.finish();self.element.trigger('jinplace:done',[data]);self.bindElement(opts);},setContent:function(data){var element=this.element;if(!data){element.html(this.opts.placeholder);return;}
if(this.opts.textOnly){element.text(data);}else{element.html(data);}}};var requestParams=function(opts,value){var params={"id":opts.elementId,"object":opts.object,attribute:opts.attribute};if($.isPlainObject(value)){$.extend(params,value);}else if(value!==undefined){params.value=value;}
return params;};$.fn[pluginName]=function(options){return this.each(function(){if(!$.data(this,"plugin_"+pluginName)){$.data(this,"plugin_"+pluginName,new JinPlace(this,options));}});};$.fn[pluginName].defaults={url:document.location.pathname,type:"input",textOnly:2,placeholder:'[ --- ]',submitFunction:function(opts,value){return $.ajax(opts.url,{type:"post",data:requestParams(opts,value),dataType:'text',headers:{'Cache-Control':'no-cache'}});},loadFunction:function(opts){return $.ajax(opts.loadurl,{data:requestParams(opts)});}};var createForm=function(opts,inputField,buttons){var form=$("<form>").attr("style","display: inline;").attr("action","javascript:void(0);").append(inputField);if(buttons)
addButtons(form,opts);return form;};var addButtons=function(form,opts){var setHandler=function(button,action){form.append(button);button.one('click',function(ev){ev.stopPropagation();form.trigger(action);});};var ok=opts.okButton;if(ok){var $button=$("<input>").attr("type","button").attr("value",ok).addClass('jip-button jip-ok-button');setHandler($button,'submit');}
var cancel=opts.cancelButton;if(cancel){$button=$("<input>").attr("type","button").attr("value",cancel).addClass('jip-button jip-cancel-button');setHandler($button,'jip:cancel');}};var editorBase={makeField:function(element,data){return $("<input>").attr("type","text").val(data);},activate:function(form,field){field.focus();},value:function(){return this.inputField.val();},blurEvent:function(blurElement,cancelElement,action){if(!action||action=='ignore')return;var onBlur=function(ev){var t=setTimeout(function(){blurElement.trigger(action);},300);cancelElement.on('click',function(){clearTimeout(t);});};blurElement.on('blur',onBlur);},finish:function(){}};$.fn[pluginName].editorBase=editorBase;$.fn[pluginName].editors={input:{buttonsAllowed:true},textarea:{buttonsAllowed:true,makeField:function(element,data){return $("<textarea>").css({'min-width':element.width(),'min-height':element.height()}).val(data);},activate:function(form,field){field.focus();if(field.elastic)
field.elastic();}},select:{makeField:function(element,data){var field=$("<select>"),choices=$.parseJSON(data);var selected=false;var elementChoice=null;$.each(choices,function(index,value){var opt=$("<option>").val(value[0]).html(value[1]);if(value[2]){opt.attr("selected","1");selected=true;}
if(value[1]==element.text())
elementChoice=opt;field.append(opt);});if(!selected&&elementChoice)
elementChoice.attr("selected","1");return field;},activate:function(form,field){field.focus();field.on('change',function(){field.trigger('jip:submit');});}}};})(jQuery,window,document);;