# Generated by Django 2.1.7 on 2019-08-24 05:37

from django.db import migrations, models

from bpp import const


def wypelnij_rodzaj_pbn(apps, schema_editor):
    Charakter_Formalny = apps.get_model("bpp", "Charakter_Formalny")
    for cf in Charakter_Formalny.objects.all():
        needs_save = False
        if cf.artykul_pbn:
            cf.rodzaj_pbn = const.RODZAJ_PBN_ARTYKUL
            needs_save = True
        if cf.rozdzial_pbn:
            cf.rodzaj_pbn = const.RODZAJ_PBN_ROZDZIAL
            needs_save = True
        if cf.ksiazka_pbn:
            cf.rodzaj_pbn = const.RODZAJ_PBN_KSIAZKA
            needs_save = True
        if needs_save:
            cf.save()


class Migration(migrations.Migration):
    dependencies = [
        ("bpp", "0173_auto_20190812_1412"),
    ]

    operations = [
        migrations.AddField(
            model_name="charakter_formalny",
            name="rodzaj_pbn",
            field=models.PositiveSmallIntegerField(
                blank=True,
                choices=[
                    (None, "nie eksportuj do PBN"),
                    (1, "artykuł"),
                    (3, "książka"),
                    (2, "rozdział"),
                ],
                default=None,
                help_text="Pole określające, czy wydawnictwa posiadające dany charakter formalny zostaną włączone\n        do eksportu PBN jako artykuły, rozdziały czy książki. ",
                null=True,
                verbose_name="Rodzaj dla PBN",
            ),
        ),
        migrations.RunPython(wypelnij_rodzaj_pbn),
        migrations.RemoveField(
            model_name="charakter_formalny",
            name="artykul_pbn",
        ),
        migrations.RemoveField(
            model_name="charakter_formalny",
            name="ksiazka_pbn",
        ),
        migrations.RemoveField(
            model_name="charakter_formalny",
            name="rozdzial_pbn",
        ),
    ]
