# Generated by Django 2.1.7 on 2019-08-12 12:12

from django.db import migrations, models

from bpp import const


def zmigruj_charaktery(apps, schema_editor):
    Charakter_Formalny = apps.get_model("bpp", "Charakter_Formalny")
    db_alias = schema_editor.connection.alias
    for elem in Charakter_Formalny.objects.using(db_alias).all():
        needs_saving = False
        if elem.nazwa_w_primo == "Rozdział" or elem.rozdzial_pbn:
            elem.charakter_sloty = const.CHARAKTER_SLOTY_ROZDZIAL
            needs_saving = True

        if elem.nazwa_w_primo == "Książka" or elem.ksiazka_pbn:
            elem.charakter_sloty = const.CHARAKTER_SLOTY_KSIAZKA
            needs_saving = True

        if needs_saving:
            elem.save()


class Migration(migrations.Migration):
    dependencies = [
        ("bpp", "0172_auto_20190806_2052"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="wydawca",
            options={"verbose_name": "wydawca", "verbose_name_plural": "wydawcy"},
        ),
        migrations.AddField(
            model_name="charakter_formalny",
            name="charakter_sloty",
            field=models.PositiveSmallIntegerField(
                blank=True,
                choices=[(1, "Książka"), (2, "Rozdział")],
                default=None,
                help_text="Jak potraktować ten charakter przy kalkulacji slotów?",
                null=True,
                verbose_name="Charakter dla slotów",
            ),
        ),
        migrations.RunPython(zmigruj_charaktery, migrations.RunPython.noop),
    ]
