# -*- coding: utf-8 -*-
# Generated by Django 1.11.12 on 2018-11-25 11:02
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0149_ranking_afiliacje'),
    ]

    operations = [
        migrations.AlterField(
            model_name='autor',
            name='orcid',
            field=models.CharField(blank=True, help_text='Open Researcher and Contributor ID, vide http://www.orcid.org', max_length=19, null=True, validators=[django.core.validators.RegexValidator(code='orcid_invalid_format', message='Identyfikator ORCID to 4 grupy po 4 cyfry w każdej, oddzielone myślnikami', regex='^\\d\\d\\d\\d-\\d\\d\\d\\d-\\d\\d\\d\\d-\\d\\d\\d(\\d|X)$')], verbose_name='Identyfikator ORCID'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='bpp.Charakter_Formalny', verbose_name='Charakter nadrzędny'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='wchodzi_do_raportow',
            field=models.BooleanField(db_index=True, default=True, help_text='Jeżeli odznaczone, prace z jednostki nie sumują się w rankingu autorów.', verbose_name='Wchodzi do raportów'),
        ),
    ]
