# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-12 23:31
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0080_auto_20170708_2147'),
    ]

    operations = [
        migrations.CreateModel(
            name='Konferencja',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, db_index=True, null=True)),
                ('adnotacje', models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True)),
                ('nazwa', models.TextField(db_index=True, max_length=512)),
                ('skrocona_nazwa', models.CharField(blank=True, max_length=250, null=True, verbose_name='Skrócona nazwa')),
                ('rozpoczecie', models.DateField(verbose_name='Rozpoczęcie')),
                ('zakonczenie', models.DateField(verbose_name='Zakończenie')),
                ('miasto', models.CharField(max_length=100, verbose_name='Miasto')),
                ('panstwo', models.CharField(max_length=100, verbose_name='Państwo')),
                ('baza_scopus', models.BooleanField(default=False, verbose_name='Indeksowana w SCOPUS?')),
                ('baza_wos', models.BooleanField(default=False, verbose_name='Indeksowana w WOS?')),
                ('baza_inna', models.CharField(blank=True, help_text='Wpisz nazwę innej bazy w której indeksowana jest ta konferencja', max_length=200, null=True, verbose_name='Indeksowana w...')),
            ],
            options={
                'verbose_name': 'konferencja',
                'verbose_name_plural': 'konferencje',
                'ordering': ('-rozpoczecie', 'nazwa'),
            },
        ),
        migrations.AlterUniqueTogether(
            name='konferencja',
            unique_together=set([('nazwa', 'rozpoczecie')]),
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte',
            name='konferencja',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Konferencja'),
        ),
    ]
