# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-08 19:45
from __future__ import unicode_literals

import autoslug.fields
import bpp.fields
from decimal import Decimal
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0077_auto_20170624_0130'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='autor',
            options={'ordering': ['sort'], 'verbose_name': 'autor', 'verbose_name_plural': 'autorzy'},
        ),
        migrations.AlterModelOptions(
            name='charakter_formalny',
            options={'ordering': ['nazwa'], 'verbose_name': 'charakter formalny', 'verbose_name_plural': 'charaktery formalne'},
        ),
        migrations.AlterModelOptions(
            name='funkcja_autora',
            options={'ordering': ['nazwa'], 'verbose_name': 'funkcja w jednostce', 'verbose_name_plural': 'funkcje w jednostkach'},
        ),
        migrations.AlterModelOptions(
            name='jednostka',
            options={'ordering': ['nazwa'], 'verbose_name': 'jednostka', 'verbose_name_plural': 'jednostki'},
        ),
        migrations.AlterModelOptions(
            name='patent',
            options={'verbose_name': 'patent', 'verbose_name_plural': 'patenty'},
        ),
        migrations.AlterModelOptions(
            name='praca_doktorska',
            options={'verbose_name': 'praca doktorska', 'verbose_name_plural': 'prace doktorskie'},
        ),
        migrations.AlterModelOptions(
            name='praca_habilitacyjna',
            options={'verbose_name': 'praca habilitacyjna', 'verbose_name_plural': 'prace habilitacyjne'},
        ),
        migrations.AlterModelOptions(
            name='status_korekty',
            options={'verbose_name': 'status korekty', 'verbose_name_plural': 'statusy korekty'},
        ),
        migrations.AlterModelOptions(
            name='typ_kbn',
            options={'ordering': ['nazwa'], 'verbose_name': 'typ KBN', 'verbose_name_plural': 'typy KBN'},
        ),
        migrations.AlterModelOptions(
            name='uczelnia',
            options={'verbose_name': 'uczelnia', 'verbose_name_plural': 'uczelnie'},
        ),
        migrations.AlterModelOptions(
            name='wydawnictwo_zwarte',
            options={'verbose_name': 'wydawnictwo zwarte', 'verbose_name_plural': 'wydawnictwa zwarte'},
        ),
        migrations.AlterField(
            model_name='autor',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='autor',
            name='aktualny',
            field=models.BooleanField(db_index=True, default=False, help_text='Jeżeli zaznaczone, pole to oznacza,\n    że autor jest aktualnie - na dziś dzień - przypisany do jakiejś jednostki w bazie danych i jego przypisanie\n    do tej jednostki nie zostało zakończone wraz z konkretną datą w \n    przeszłości.', verbose_name='Aktualny?'),
        ),
        migrations.AlterField(
            model_name='autor',
            name='email',
            field=models.EmailField(blank=True, max_length=128, null=True, verbose_name='E-mail'),
        ),
        migrations.AlterField(
            model_name='autor',
            name='pbn_id',
            field=models.IntegerField(blank=True, db_index=True, help_text='Identyfikator w systemie Polskiej Bibliografii Naukowej (PBN)', null=True, unique=True, verbose_name='Identyfikator PBN'),
        ),
        migrations.AlterField(
            model_name='autor',
            name='pesel_md5',
            field=models.CharField(blank=True, db_index=True, help_text='Hash MD5 numeru PESEL', max_length=32, null=True, verbose_name='PESEL MD5'),
        ),
        migrations.AlterField(
            model_name='autor',
            name='poprzednie_nazwiska',
            field=models.CharField(blank=True, db_index=True, help_text='Jeżeli ten\n        autor(-ka) posiada nazwisko panieńskie, pod którym ukazywały\n        się publikacje lub zmieniał nazwisko z innych powodów, wpisz tutaj\n        wszystkie poprzednie nazwiska, oddzielając je przecinkami.', max_length=1024, null=True),
        ),
        migrations.AlterField(
            model_name='autor',
            name='slug',
            field=autoslug.fields.AutoSlugField(editable=False, max_length=1024, populate_from='get_full_name', unique=True),
        ),
        migrations.AlterField(
            model_name='autor',
            name='www',
            field=models.URLField(blank=True, max_length=1024, null=True, verbose_name='WWW'),
        ),
        migrations.AlterField(
            model_name='autor_jednostka',
            name='rozpoczal_prace',
            field=models.DateField(blank=True, db_index=True, null=True, verbose_name='Rozpoczął pracę'),
        ),
        migrations.AlterField(
            model_name='autor_jednostka',
            name='zakonczyl_prace',
            field=models.DateField(blank=True, db_index=True, null=True, verbose_name='Zakończył pracę'),
        ),
        migrations.AlterField(
            model_name='bppuser',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='bppuser',
            name='multiseek_format',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='Ostatnio wybrany format wyświetlania w Multiseeku'),
        ),
        migrations.AlterField(
            model_name='bppuser',
            name='multiseek_order_1',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='Ostatnio wybrane pole sortowania w Multiseeku'),
        ),
        migrations.AlterField(
            model_name='bppuser',
            name='per_page',
            field=models.IntegerField(default=20, verbose_name='Ilość wyświetlanych rekordów na stronie'),
        ),
        migrations.AlterField(
            model_name='bppuser',
            name='username',
            field=models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='artykul_pbn',
            field=models.BooleanField(default=False, help_text='Wydawnictwa ciągłe posiadające\n     ten charakter formalny zostaną włączone do eksportu PBN jako artykuły', verbose_name='Artykuł w PBN'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='charakter_pbn',
            field=models.ForeignKey(blank=True, default=None, help_text='Wartość wybrana w tym polu zostanie użyta jako zawartość tagu <is>\n                                      w plikach eksportu do PBN', null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Charakter_PBN', verbose_name='Charakter PBN'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='ksiazka_pbn',
            field=models.BooleanField(default=False, help_text='Wydawnictwa zwarte posiadające ten\n    charakter formalny zostaną włączone do eksportu PBN jako ksiażki', verbose_name='Książka w PBN'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='nazwa_w_primo',
            field=models.CharField(blank=True, choices=[('', ''), ('Artykuł', 'Artykuł'), ('Książka', 'Książka'), ('Zasób tekstowy', 'Zasób tekstowy'), ('Rozprawa naukowa', 'Rozprawa naukowa'), ('Recenzja', 'Recenzja'), ('Artykuł prasowy', 'Artykuł prasowy'), ('Rozdział', 'Rozdział'), ('Czasopismo', 'Czasopismo'), ('Dane badawcze', 'Dane badawcze'), ('Materiał konferencyjny', 'Materiał konferencyjny'), ('Obraz', 'Obraz'), ('Baza', 'Baza'), ('Zestaw danych statystycznych', 'Zestaw danych statystycznych'), ('Multimedia', 'Multimedia'), ('Inny', 'Inny')], db_index=True, default='', help_text='\n    Nazwa charakteru formalnego w wyszukiwarce Primo, eksponowana przez OAI-PMH. W przypadku,\n    gdy to pole jest puste, prace o danym charakterze formalnym nie będą udostępniane przez\n    protokół OAI-PMH.\n    ', max_length=100, verbose_name='Nazwa w Primo'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='publikacja',
            field=models.BooleanField(default=False, help_text='Jest charakterem dla publikacji'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='rozdzial_pbn',
            field=models.BooleanField(default=False, help_text='Wydawnictwa zwarte posiadające ten\n    charakter formalny zostaną włączone do eksportu PBN jako rozdziały', verbose_name='Rozdział w PBN'),
        ),
        migrations.AlterField(
            model_name='charakter_formalny',
            name='streszczenie',
            field=models.BooleanField(default=False, help_text='Jest charakterem dla streszczeń'),
        ),
        migrations.AlterField(
            model_name='charakter_pbn',
            name='wlasciwy_dla',
            field=models.CharField(choices=[('article', 'Artykuł'), ('book', 'Książka'), ('chapter', 'Rozdział')], max_length=20),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='aktualna',
            field=models.BooleanField(default=False, help_text="Jeżeli dana jednostka wchodzi w struktury wydziału\n    (czyli jej obecność w strukturach wydziału nie została zakończona z określoną datą), to pole to będzie miało\n    wartość 'PRAWDA'."),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='email',
            field=models.EmailField(blank=True, max_length=128, null=True, verbose_name='E-mail'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='pbn_id',
            field=models.IntegerField(blank=True, db_index=True, help_text='Identyfikator w systemie Polskiej Bibliografii Naukowej (PBN)', null=True, unique=True, verbose_name='Identyfikator PBN'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='skrot',
            field=models.CharField(max_length=128, unique=True, verbose_name='Skrót'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='skupia_pracownikow',
            field=models.BooleanField(default=True, help_text="Ta jednostka skupia osoby będące faktycznymi pracownikami uczelni. Odznacz dla jednostek\n         typu 'Studenci', 'Doktoranci', 'Pracownicy emerytowani' itp.", verbose_name='Skupia pracowników'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='slug',
            field=autoslug.fields.AutoSlugField(editable=False, populate_from='nazwa', unique=True),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='wchodzi_do_raportow',
            field=models.BooleanField(db_index=True, default=True, verbose_name='Wchodzi do raportów'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='www',
            field=models.URLField(blank=True, max_length=1024, null=True, verbose_name='WWW'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='wydzial',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Wydzial', verbose_name='Wydział'),
        ),
        migrations.AlterField(
            model_name='jednostka',
            name='zarzadzaj_automatycznie',
            field=models.BooleanField(default=True, help_text='Jednostka ta będzie dowolnie modyfikowana przez procedury importujace dane z zewnętrznych\n        systemów informatycznych', verbose_name='Zarządzaj automatycznie'),
        ),
        migrations.AlterField(
            model_name='jezyk',
            name='skrot_dla_pbn',
            field=models.CharField(blank=True, help_text='\n    Skrót nazwy języka używany w plikach eksportu do PBN.', max_length=10, verbose_name='Skrót dla PBN'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='patent',
            name='dostep_dnia',
            field=models.DateField(blank=True, help_text='Data dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='index_copernicus',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='informacje',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Informacje'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='kc_index_copernicus',
            field=models.DecimalField(blank=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='kc_punkty_kbn',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='opis_bibliograficzny_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='patent',
            name='opis_bibliograficzny_zapisani_autorzy_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='patent',
            name='public_dostep_dnia',
            field=models.DateField(blank=True, help_text='Data wolnego dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='public_www',
            field=models.URLField(blank=True, max_length=2048, null=True, verbose_name='Adres WWW (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='punktacja_wewnetrzna',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punktacja wewnętrzna'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='punkty_kbn',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='rok',
            field=models.IntegerField(db_index=True, help_text='Rok uwzględniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='slowa_kluczowe',
            field=models.TextField(blank=True, null=True, verbose_name='Słowa kluczowe'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='szczegoly',
            field=models.CharField(blank=True, help_text='Np. str. 23-45', max_length=512, null=True, verbose_name='Szczegóły'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='tytul_oryginalny',
            field=models.TextField(db_index=True, verbose_name='Tytuł oryginalny'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='tytul_oryginalny_sort',
            field=models.TextField(db_index=True, default=''),
        ),
        migrations.AlterField(
            model_name='patent',
            name='utworzono',
            field=models.DateTimeField(auto_now_add=True, null=True, verbose_name='Utworzono'),
        ),
        migrations.AlterField(
            model_name='patent',
            name='www',
            field=models.URLField(blank=True, max_length=1024, null=True, verbose_name='Adres WWW (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='patent_autor',
            name='kolejnosc',
            field=models.IntegerField(default=0, verbose_name='Kolejność'),
        ),
        migrations.AlterField(
            model_name='patent_autor',
            name='typ_odpowiedzialnosci',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Typ_Odpowiedzialnosci', verbose_name='Typ odpowiedzialności'),
        ),
        migrations.AlterField(
            model_name='patent_autor',
            name='zatrudniony',
            field=models.BooleanField(default=False, help_text='Pracownik jednostki podanej w afiliacji'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='doi',
            field=bpp.fields.DOIField(blank=True, db_index=True, help_text='Digital Object Identifier (DOI)', max_length=2048, null=True, verbose_name='DOI'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='dostep_dnia',
            field=models.DateField(blank=True, help_text='Data dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='e_isbn',
            field=models.CharField(blank=True, db_index=True, max_length=64, null=True, verbose_name='E-ISBN'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='index_copernicus',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='informacje',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Informacje'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='isbn',
            field=models.CharField(blank=True, db_index=True, max_length=64, null=True, verbose_name='ISBN'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='jezyk',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Jezyk', verbose_name='Język'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='kc_index_copernicus',
            field=models.DecimalField(blank=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='kc_punkty_kbn',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='miejsce_i_rok',
            field=models.CharField(blank=True, help_text='Przykładowo:\n        Warszawa 2012. Wpisz proszę najpierw miejsce potem rok; oddziel\n        spacją.', max_length=256, null=True),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='opis_bibliograficzny_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='opis_bibliograficzny_zapisani_autorzy_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='public_dostep_dnia',
            field=models.DateField(blank=True, help_text='Data wolnego dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='public_www',
            field=models.URLField(blank=True, max_length=2048, null=True, verbose_name='Adres WWW (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='pubmed_id',
            field=models.BigIntegerField(blank=True, help_text='Identyfikator PubMed (PMID)', null=True, verbose_name='PubMed ID'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='punktacja_wewnetrzna',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punktacja wewnętrzna'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='punkty_kbn',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='rok',
            field=models.IntegerField(db_index=True, help_text='Rok uwzględniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='slowa_kluczowe',
            field=models.TextField(blank=True, null=True, verbose_name='Słowa kluczowe'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='szczegoly',
            field=models.CharField(blank=True, help_text='Np. str. 23-45', max_length=512, null=True, verbose_name='Szczegóły'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='typ_kbn',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Typ_KBN', verbose_name='Typ KBN'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='tytul',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Tytuł'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='tytul_oryginalny',
            field=models.TextField(db_index=True, verbose_name='Tytuł oryginalny'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='tytul_oryginalny_sort',
            field=models.TextField(db_index=True, default=''),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='utworzono',
            field=models.DateTimeField(auto_now_add=True, null=True, verbose_name='Utworzono'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='www',
            field=models.URLField(blank=True, max_length=1024, null=True, verbose_name='Adres WWW (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='doi',
            field=bpp.fields.DOIField(blank=True, db_index=True, help_text='Digital Object Identifier (DOI)', max_length=2048, null=True, verbose_name='DOI'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='dostep_dnia',
            field=models.DateField(blank=True, help_text='Data dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='e_isbn',
            field=models.CharField(blank=True, db_index=True, max_length=64, null=True, verbose_name='E-ISBN'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='index_copernicus',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='informacje',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Informacje'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='isbn',
            field=models.CharField(blank=True, db_index=True, max_length=64, null=True, verbose_name='ISBN'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='jezyk',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Jezyk', verbose_name='Język'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='kc_index_copernicus',
            field=models.DecimalField(blank=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='kc_punkty_kbn',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='miejsce_i_rok',
            field=models.CharField(blank=True, help_text='Przykładowo:\n        Warszawa 2012. Wpisz proszę najpierw miejsce potem rok; oddziel\n        spacją.', max_length=256, null=True),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='opis_bibliograficzny_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='opis_bibliograficzny_zapisani_autorzy_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='public_dostep_dnia',
            field=models.DateField(blank=True, help_text='Data wolnego dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='public_www',
            field=models.URLField(blank=True, max_length=2048, null=True, verbose_name='Adres WWW (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='pubmed_id',
            field=models.BigIntegerField(blank=True, help_text='Identyfikator PubMed (PMID)', null=True, verbose_name='PubMed ID'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='punktacja_wewnetrzna',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punktacja wewnętrzna'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='punkty_kbn',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='rok',
            field=models.IntegerField(db_index=True, help_text='Rok uwzględniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='slowa_kluczowe',
            field=models.TextField(blank=True, null=True, verbose_name='Słowa kluczowe'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='szczegoly',
            field=models.CharField(blank=True, help_text='Np. str. 23-45', max_length=512, null=True, verbose_name='Szczegóły'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='typ_kbn',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Typ_KBN', verbose_name='Typ KBN'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='tytul',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Tytuł'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='tytul_oryginalny',
            field=models.TextField(db_index=True, verbose_name='Tytuł oryginalny'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='tytul_oryginalny_sort',
            field=models.TextField(db_index=True, default=''),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='utworzono',
            field=models.DateTimeField(auto_now_add=True, null=True, verbose_name='Utworzono'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='www',
            field=models.URLField(blank=True, max_length=1024, null=True, verbose_name='Adres WWW (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='publikacja_habilitacyjna',
            name='kolejnosc',
            field=models.IntegerField(default=0, verbose_name='Kolejność'),
        ),
        migrations.AlterField(
            model_name='punktacja_zrodla',
            name='index_copernicus',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='punktacja_zrodla',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='punktacja_zrodla',
            name='kc_index_copernicus',
            field=models.DecimalField(blank=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='punktacja_zrodla',
            name='kc_punkty_kbn',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='punktacja_zrodla',
            name='punktacja_wewnetrzna',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punktacja wewnętrzna'),
        ),
        migrations.AlterField(
            model_name='punktacja_zrodla',
            name='punkty_kbn',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='typ_kbn',
            name='artykul_pbn',
            field=models.BooleanField(default=False, help_text='Wydawnictwa ciągłe posiadające\n    ten typ KBN zostaną włączone do eksportu PBN jako artykuły', verbose_name='Artykuł w PBN'),
        ),
        migrations.AlterField(
            model_name='uczelnia',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='uczelnia',
            name='favicon_ico',
            field=models.FileField(blank=True, null=True, upload_to='favicon', verbose_name='Ikona ulubionych (favicon)'),
        ),
        migrations.AlterField(
            model_name='uczelnia',
            name='logo_svg',
            field=models.FileField(blank=True, null=True, upload_to='logo_svg', verbose_name='Logo wektorowe (SVG)'),
        ),
        migrations.AlterField(
            model_name='uczelnia',
            name='logo_www',
            field=models.ImageField(blank=True, help_text='Plik w formacie bitmapowym, np. JPEG lub PNG,\n        w rozdzielczości maks. 100x100', null=True, upload_to='logo', verbose_name='Logo na stronę WWW'),
        ),
        migrations.AlterField(
            model_name='uczelnia',
            name='obca_jednostka',
            field=models.ForeignKey(blank=True, help_text='\n    Jednostka skupiająca autorów nieindeksowanych, nie będących pracownikami uczelni. Procedury importujące\n    dane z zewnętrznych systemów informatycznych będą przypisywać do tej jednostki osoby, które zakończyły\n    pracę na uczelni. ', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='obca_jednostka', to='bpp.Jednostka'),
        ),
        migrations.AlterField(
            model_name='uczelnia',
            name='pbn_id',
            field=models.IntegerField(blank=True, db_index=True, help_text='Identyfikator w systemie Polskiej Bibliografii Naukowej (PBN)', null=True, unique=True, verbose_name='Identyfikator PBN'),
        ),
        migrations.AlterField(
            model_name='uczelnia',
            name='slug',
            field=autoslug.fields.AutoSlugField(editable=False, populate_from='skrot', unique=True),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='charakter_formalny',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Charakter_Formalny', verbose_name='Charakter formalny'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='doi',
            field=bpp.fields.DOIField(blank=True, db_index=True, help_text='Digital Object Identifier (DOI)', max_length=2048, null=True, verbose_name='DOI'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='dostep_dnia',
            field=models.DateField(blank=True, help_text='Data dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='e_issn',
            field=models.CharField(blank=True, max_length=32, null=True, verbose_name='e-ISSN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='index_copernicus',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='informacje',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Informacje'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='issn',
            field=models.CharField(blank=True, max_length=32, null=True, verbose_name='ISSN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='jezyk',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Jezyk', verbose_name='Język'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='kc_index_copernicus',
            field=models.DecimalField(blank=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='kc_punkty_kbn',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='liczba_znakow_wydawniczych',
            field=models.IntegerField(blank=True, db_index=True, null=True, verbose_name='Liczba znaków wydawniczych'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='openaccess_czas_publikacji',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Czas_Udostepnienia_OpenAccess', verbose_name='OpenAccess: czas udostępnienia'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='openaccess_ilosc_miesiecy',
            field=models.PositiveIntegerField(blank=True, help_text='Ilość miesięcy jakie upłynęły od momentu opublikowania do momentu udostępnienia', null=True, verbose_name='OpenAccess: ilość miesięcy'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='openaccess_licencja',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Licencja_OpenAccess', verbose_name='OpenAccess: licencja'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='openaccess_tryb_dostepu',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Tryb_OpenAccess_Wydawnictwo_Ciagle', verbose_name='OpenAccess: tryb dostępu'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='openaccess_wersja_tekstu',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Wersja_Tekstu_OpenAccess', verbose_name='OpenAccess: wersja tekstu'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='opis_bibliograficzny_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='opis_bibliograficzny_zapisani_autorzy_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='ostatnio_zmieniony_dla_pbn',
            field=models.DateTimeField(auto_now_add=True, help_text='Moment ostatniej aktualizacji rekordu dla potrzeb PBN. To pole zmieni się automatycznie, gdy\n        nastąpi zmiana dowolnego z pól za wyjątkiem bloków pól: „punktacja”, „punktacja komisji centralnej”,\n        „adnotacje” oraz pole „status korekty”.', verbose_name='Ostatnio zmieniony (dla PBN)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='public_dostep_dnia',
            field=models.DateField(blank=True, help_text='Data wolnego dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='public_www',
            field=models.URLField(blank=True, max_length=2048, null=True, verbose_name='Adres WWW (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='pubmed_id',
            field=models.BigIntegerField(blank=True, help_text='Identyfikator PubMed (PMID)', null=True, verbose_name='PubMed ID'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='punktacja_wewnetrzna',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punktacja wewnętrzna'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='punkty_kbn',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='rok',
            field=models.IntegerField(db_index=True, help_text='Rok uwzględniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='slowa_kluczowe',
            field=models.TextField(blank=True, null=True, verbose_name='Słowa kluczowe'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='szczegoly',
            field=models.CharField(blank=True, help_text='Np. str. 23-45', max_length=512, null=True, verbose_name='Szczegóły'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='typ_kbn',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Typ_KBN', verbose_name='Typ KBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='tytul',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Tytuł'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='tytul_oryginalny',
            field=models.TextField(db_index=True, verbose_name='Tytuł oryginalny'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='tytul_oryginalny_sort',
            field=models.TextField(db_index=True, default=''),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='utworzono',
            field=models.DateTimeField(auto_now_add=True, null=True, verbose_name='Utworzono'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='www',
            field=models.URLField(blank=True, max_length=1024, null=True, verbose_name='Adres WWW (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='zrodlo',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='bpp.Zrodlo', verbose_name='Źródło'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle_autor',
            name='kolejnosc',
            field=models.IntegerField(default=0, verbose_name='Kolejność'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle_autor',
            name='typ_odpowiedzialnosci',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Typ_Odpowiedzialnosci', verbose_name='Typ odpowiedzialności'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle_autor',
            name='zatrudniony',
            field=models.BooleanField(default=False, help_text='Pracownik jednostki podanej w afiliacji'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='calkowita_liczba_autorow',
            field=models.PositiveIntegerField(blank=True, help_text='Jeżeli dodajesz monografię, wpisz tutaj całkowitą liczbę\n        autorów monografii. Ta informacja zostanie użyta w eksporcie danych do PBN.', null=True),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='charakter_formalny',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Charakter_Formalny', verbose_name='Charakter formalny'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='doi',
            field=bpp.fields.DOIField(blank=True, db_index=True, help_text='Digital Object Identifier (DOI)', max_length=2048, null=True, verbose_name='DOI'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='dostep_dnia',
            field=models.DateField(blank=True, help_text='Data dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='e_isbn',
            field=models.CharField(blank=True, db_index=True, max_length=64, null=True, verbose_name='E-ISBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='index_copernicus',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='informacje',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Informacje'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='isbn',
            field=models.CharField(blank=True, db_index=True, max_length=64, null=True, verbose_name='ISBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='jezyk',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Jezyk', verbose_name='Język'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='kc_index_copernicus',
            field=models.DecimalField(blank=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Index Copernicus'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='kc_punkty_kbn',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=2, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', max_digits=6, null=True, verbose_name='KC: Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='liczba_znakow_wydawniczych',
            field=models.IntegerField(blank=True, db_index=True, null=True, verbose_name='Liczba znaków wydawniczych'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='miejsce_i_rok',
            field=models.CharField(blank=True, help_text='Przykładowo:\n        Warszawa 2012. Wpisz proszę najpierw miejsce potem rok; oddziel\n        spacją.', max_length=256, null=True),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='openaccess_czas_publikacji',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Czas_Udostepnienia_OpenAccess', verbose_name='OpenAccess: czas udostępnienia'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='openaccess_ilosc_miesiecy',
            field=models.PositiveIntegerField(blank=True, help_text='Ilość miesięcy jakie upłynęły od momentu opublikowania do momentu udostępnienia', null=True, verbose_name='OpenAccess: ilość miesięcy'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='openaccess_licencja',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Licencja_OpenAccess', verbose_name='OpenAccess: licencja'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='openaccess_wersja_tekstu',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Wersja_Tekstu_OpenAccess', verbose_name='OpenAccess: wersja tekstu'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='opis_bibliograficzny_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='opis_bibliograficzny_zapisani_autorzy_cache',
            field=models.TextField(default=''),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='ostatnio_zmieniony_dla_pbn',
            field=models.DateTimeField(auto_now_add=True, help_text='Moment ostatniej aktualizacji rekordu dla potrzeb PBN. To pole zmieni się automatycznie, gdy\n        nastąpi zmiana dowolnego z pól za wyjątkiem bloków pól: „punktacja”, „punktacja komisji centralnej”,\n        „adnotacje” oraz pole „status korekty”.', verbose_name='Ostatnio zmieniony (dla PBN)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='public_dostep_dnia',
            field=models.DateField(blank=True, help_text='Data wolnego dostępu do strony WWW.', null=True, verbose_name='Dostęp dnia (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='public_www',
            field=models.URLField(blank=True, max_length=2048, null=True, verbose_name='Adres WWW (wolny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='pubmed_id',
            field=models.BigIntegerField(blank=True, help_text='Identyfikator PubMed (PMID)', null=True, verbose_name='PubMed ID'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='punktacja_wewnetrzna',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punktacja wewnętrzna'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='punkty_kbn',
            field=models.DecimalField(db_index=True, decimal_places=2, default=Decimal('0.00'), max_digits=6, verbose_name='Punkty KBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='rok',
            field=models.IntegerField(db_index=True, help_text='Rok uwzględniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='slowa_kluczowe',
            field=models.TextField(blank=True, null=True, verbose_name='Słowa kluczowe'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='szczegoly',
            field=models.CharField(blank=True, help_text='Np. str. 23-45', max_length=512, null=True, verbose_name='Szczegóły'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='typ_kbn',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Typ_KBN', verbose_name='Typ KBN'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='tytul',
            field=models.TextField(blank=True, db_index=True, null=True, verbose_name='Tytuł'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='tytul_oryginalny',
            field=models.TextField(db_index=True, verbose_name='Tytuł oryginalny'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='tytul_oryginalny_sort',
            field=models.TextField(db_index=True, default=''),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='utworzono',
            field=models.DateTimeField(auto_now_add=True, null=True, verbose_name='Utworzono'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='www',
            field=models.URLField(blank=True, max_length=1024, null=True, verbose_name='Adres WWW (płatny dostęp)'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='wydawnictwo_nadrzedne',
            field=models.ForeignKey(blank=True, help_text='Jeżeli dodajesz rozdział,\n        tu wybierz pracę, w ramach której dany rozdział występuje.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='wydawnictwa_powiazane_set', to='bpp.Wydawnictwo_Zwarte'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte_autor',
            name='kolejnosc',
            field=models.IntegerField(default=0, verbose_name='Kolejność'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte_autor',
            name='typ_odpowiedzialnosci',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Typ_Odpowiedzialnosci', verbose_name='Typ odpowiedzialności'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte_autor',
            name='zatrudniony',
            field=models.BooleanField(default=False, help_text='Pracownik jednostki podanej w afiliacji'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='kolejnosc',
            field=models.IntegerField(default=0, verbose_name='Kolejność'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='nazwa',
            field=models.CharField(help_text='Pełna nazwa wydziału, np. "Wydział Lekarski"', max_length=512, unique=True),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='otwarcie',
            field=models.DateField(blank=True, null=True, verbose_name='Data otwarcia wydziału'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='pbn_id',
            field=models.IntegerField(blank=True, db_index=True, help_text='Identyfikator w systemie Polskiej Bibliografii Naukowej (PBN)', null=True, unique=True, verbose_name='Identyfikator PBN'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='poprzednie_nazwy',
            field=models.CharField(blank=True, default='', max_length=4096, null=True),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='skrot',
            field=models.CharField(help_text='Skrót nazwy wydziału, wersja minimalna, np. "WL"', max_length=4, unique=True, verbose_name='Skrót'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='slug',
            field=autoslug.fields.AutoSlugField(editable=False, max_length=512, populate_from='nazwa', unique=True),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='widoczny',
            field=models.BooleanField(default=True, help_text='Czy wydział ma być widoczny przy przeglądaniu strony dla zakładki "Uczelnia"?'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='zamkniecie',
            field=models.DateField(blank=True, null=True, verbose_name='Data zamknięcia wydziału'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='zarzadzaj_automatycznie',
            field=models.BooleanField(default=True, help_text="Wydział ten będzie dowolnie modyfikowany przez procedury importujace dane z zewnętrznych\n        systemów informatycznych. W przypadku, gdy pole ma ustawioną wartość na 'fałsz', wydział ten może być", verbose_name='Zarządzaj automatycznie'),
        ),
        migrations.AlterField(
            model_name='wydzial',
            name='zezwalaj_na_ranking_autorow',
            field=models.BooleanField(default=True, verbose_name='Zezwalaj na generowanie rankingu autorów dla tego wydziału'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='adnotacje',
            field=models.TextField(blank=True, db_index=True, help_text='Pole do użytku wewnętrznego -\n    wpisane tu informacje nie są wyświetlane na stronach WWW dostępnych\n    dla użytkowników końcowych.', null=True),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='doi',
            field=bpp.fields.DOIField(blank=True, db_index=True, help_text='Digital Object Identifier (DOI)', max_length=2048, null=True, verbose_name='DOI'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='e_issn',
            field=models.CharField(blank=True, max_length=32, null=True, verbose_name='e-ISSN'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='issn',
            field=models.CharField(blank=True, max_length=32, null=True, verbose_name='ISSN'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='openaccess_licencja',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Licencja_OpenAccess', verbose_name='OpenAccess: licencja'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='openaccess_tryb_dostepu',
            field=models.CharField(blank=True, choices=[('FULL', 'pełny'), ('PARTIAL', 'częściowy')], db_index=True, max_length=50, verbose_name='OpenAccess: tryb dostępu'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='poprzednia_nazwa',
            field=models.CharField(blank=True, db_index=True, max_length=1024, null=True, verbose_name='Poprzedni tytuł'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='skrot',
            field=models.CharField(db_index=True, max_length=512, verbose_name='Skrót'),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='slug',
            field=autoslug.fields.AutoSlugField(editable=False, populate_from='nazwa', unique=True),
        ),
        migrations.AlterField(
            model_name='zrodlo',
            name='www',
            field=models.URLField(blank=True, db_index=True, max_length=1024, null=True, verbose_name='WWW'),
        ),
    ]
