# Terralab CLI

[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=DataBiosphere_terra-scientific-pipelines-service-cli&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=DataBiosphere_terra-scientific-pipelines-service-cli)

*PLEASE NOTE: This CLI and service are still in development. This CLI can not yet be used to run imputation as described here.*

## Overview
The Terralab CLI provides a command-line interface with which to interact with the [Terra Scientific Pipelines Service](https://github.com/DataBiosphere/terra-scientific-pipelines-service/blob/main/README.md), or Teaspoons.

Currently, Terralab supports running Genotype Imputation (for public release in early 2025).

Note that in order to use Terralab and Teaspoons, you must have a [Terra](https://app.terra.bio/) account.

User instructions coming soon.


## Installation
You can install the Terralab CLI [from PyPi](https://pypi.org/project/terralab-cli/) using your favorite package management tool. 

For example, run
```bash
pip install terralab-cli
```

## Using the CLI
Once installed, to run the CLI, run the following command:
```bash
terralab COMMAND [ARGS]
```

For example, to list the pipelines you can run using Terralab, run the following command:
```bash
terralab pipelines list
```

[(Internal) WIP documentation for the CLI](https://docs.google.com/document/d/1ovbcHCzdyuC8RjFfkVJZiuDTQ_UAVrglSxSGaZwppoY/edit?tab=t.0#heading=h.jfsr3j3x0zjr).


## Python CLI structure
The CLI code is structured as follows:
```
terra-scientific-pipelines-service-cli
├── terralab
│   └── commands
│   │   └── __init__.py
│   │   └── auth_commands.py
│   │   └── pipelines_commands.py
│   └── logic
│   │   └── __init__.py
│   │   └── auth_logic.py
│   │   └── pipelines_logic.py
│   └── __init__.py
│   └── auth_helper.py
│   └── cli.py
│   └── client.py
│   └── config.py
│   └── teaspoons
├── tests
│   └── commands
│   │   └── test_auth_commands.py
│   │   └── test_pipelines_commands.py
│   └── logic
│   │   └── test_auth_logic.py
│   │   └── test_pipelines_logic.py
│   └── __init__.py
│   └── auth_helper.py
│   └── cli.py
│   └── client.py
│   └── config.py
│   └── terralab
├── .gitignore
├── .terralab-cli-config
├── poetry.lock
├── pyproject.toml
├── README.md
```

In the `terralab` directory, we have the following files and subdirectories:
- `auth_helper.py` contains the code for authenticating with the Terra Scientific Pipelines Service (Terra, via b2c).
- `cli.py` is the entrypoint for the CLI. It configures logging and assembles the CLI sub-modules that are defined in `commands/`.
- `client.py` contains the code for wrapping API calls to the Terra Scientific Pipelines Service.
- `config.py` contains the code for managing the CLI configuration via environment variables.
- `utils.py` contains utility functions that are used across the CLI.
- The `commands` directory contains the CLI sub-modules. This is effectively the controller layer for the CLI.
- The `logic` directory contains the business logic for the CLI, including calling Terra Scientific Pipelines Service APIs via the thin `teaspoons_client`, 
which is autogenerated and published by the [Terra Scientific Pipelines Service repository](https://github.com/DataBiosphere/terra-scientific-pipelines-service).

In the `tests` directory, we have test files that can be run with pytest.


## Development
See [CONTRIBUTING.md](CONTRIBUTING.md).
