#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['nbcourse']

package_data = \
{'': ['*'],
 'nbcourse': ['reveal.js/*',
              'reveal.js/css/*',
              'reveal.js/css/print/*',
              'reveal.js/css/theme/*',
              'reveal.js/css/theme/source/*',
              'reveal.js/css/theme/template/*',
              'reveal.js/js/*',
              'reveal.js/lib/*',
              'reveal.js/lib/css/*',
              'reveal.js/lib/font/*',
              'reveal.js/lib/font/league-gothic/*',
              'reveal.js/lib/font/source-sans-pro/*',
              'reveal.js/lib/js/*',
              'reveal.js/plugin/*',
              'reveal.js/plugin/highlight/*',
              'reveal.js/plugin/markdown/*',
              'reveal.js/plugin/math/*',
              'reveal.js/plugin/multiplex/*',
              'reveal.js/plugin/notes-server/*',
              'reveal.js/plugin/notes/*',
              'reveal.js/plugin/print-pdf/*',
              'reveal.js/plugin/search/*',
              'reveal.js/plugin/zoom-js/*',
              'reveal.js/test/*',
              'reveal.js/test/examples/*',
              'reveal.js/test/examples/assets/*',
              'skeleton/*',
              'skeleton/pages/*',
              'skeleton/theme/*',
              'skeleton/theme/default/*',
              'skeleton/theme/default/css/*',
              'skeleton/theme/default/css/codehilite/*',
              'skeleton/theme/default/img/*',
              'skeleton/theme/default/templates/*']}

install_requires = \
['nbconvert >= 6.0',
 'bs4',
 'IPython',
 'jinja2',
 'jupyter_contrib_nbextensions',
 'latex',
 'markdown',
 'rise',
 'pyyaml',
 'doit >= 0.32.0',
 'python-frontmatter']

extras_require = \
{'test': ['pytest']}

entry_points = \
{'console_scripts': ['nbcourse = nbcourse:main.main']}

setup(name='nbcourse',
      version='0.3.2',
      description='Build a small website to host Jupyter notebooks as course chapters',
      author='Matthieu Boileau',
      author_email='matthieu.boileau@math.unistra.fr',
      url='https://gitlab.math.unistra.fr/boileau/nbcourse',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
     )
