# coding: utf-8

"""
    EXACT - API

    API to interact with the EXACT Server  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401
from exact_sync.v1.api.pagination_base_api import PaginationBaseAPI

# python 2 and python 3 compatibility library
import six
import json
from exact_sync.v1.api_client import ApiClient


class ImageSetsApi(PaginationBaseAPI):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_image_set(self, **kwargs):  # noqa: E501
        """create_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_image_set(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageSet body:
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_image_set_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_image_set_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_image_set_with_http_info(self, **kwargs):  # noqa: E501
        """create_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_image_set_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageSet body:
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_image_set" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/image_sets/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)



    def destroy_image_set(self, id, **kwargs):  # noqa: E501
        """destroy_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_image_set(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_image_set_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_image_set_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_image_set_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_image_set_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_image_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_image_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/image_sets/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_image_sets(self, pagination:bool=True, **kwargs):  # noqa: E501
        """list_image_sets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_image_sets(async_req=True)
        >>> result = thread.get()

        :param bool pagination: active or deactive
        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str id: id
        :param str path: path
        :param str path__contains: path__contains
        :param str name: name
        :param str name__contains: name__contains
        :param str location: location
        :param str location__contains: location__contains
        :param str description: description
        :param str description__contains: description__contains
        :param str time: time
        :param str time__range: time__range
        :param str team: team
        :param str creator: creator
        :param str public: public
        :param str main_annotation_type: main_annotation_type
        :param str set_tags: set_tags
        :param str product: product
        :param str collaboration_type: collaboration_type
        :param str priority: priority
        :param str zip_state: zip_state
        :param str images: images
        :return: ImageSets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True

        if pagination:
            if kwargs.get('async_req'):
                return self.list_image_sets_with_http_info(**kwargs)  # noqa: E501
            else:
                (data) = self.list_image_sets_with_http_info(**kwargs)  # noqa: E501
                return data
        else:
            return self._get_all(self.list_image_sets_with_http_info, **kwargs)


    def list_image_sets_with_http_info(self, **kwargs):  # noqa: E501
        """list_image_sets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_image_sets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str id: id
        :param str path: path
        :param str path__contains: path__contains
        :param str name: name
        :param str name__contains: name__contains
        :param str location: location
        :param str location__contains: location__contains
        :param str description: description
        :param str description__contains: description__contains
        :param str time: time
        :param str time__range: time__range
        :param str team: team
        :param str creator: creator
        :param str public: public
        :param str main_annotation_type: main_annotation_type
        :param str set_tags: set_tags
        :param str product: product
        :param str collaboration_type: collaboration_type
        :param str priority: priority
        :param str zip_state: zip_state
        :param str images: images
        :return: ImageSets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'id', "id__in", 'path', 'path__contains', 'name', 'name__contains', 'name__in', 'location', 'location__contains', 'description', 'description__contains', 'time', 'time__range', 'team', 'creator', 'public', 'main_annotation_type', 'set_tags', 'product', 'collaboration_type', 'priority', 'zip_state', 'images']  # noqa: E501
        all_params.append('omit')
        all_params.append('expand')
        all_params.append('fields')
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_image_sets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'id__in' in params:
            query_params.append(('id__in', params['id__in']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'path__contains' in params:
            query_params.append(('path__contains', params['path__contains']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'name__in' in params:
            query_params.append(('name__in', params['name__in']))  # noqa: E501
        if 'name__contains' in params:
            query_params.append(('name__contains', params['name__contains']))  # noqa: E501
        if 'location' in params:
            query_params.append(('location', params['location']))  # noqa: E501
        if 'location__contains' in params:
            query_params.append(('location__contains', params['location__contains']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501
        if 'description__contains' in params:
            query_params.append(('description__contains', params['description__contains']))  # noqa: E501
        if 'time' in params:
            query_params.append(('time', params['time']))  # noqa: E501
        if 'time__range' in params:
            query_params.append(('time__range', params['time__range']))  # noqa: E501
        if 'team' in params:
            query_params.append(('team', params['team']))  # noqa: E501
        if 'creator' in params:
            query_params.append(('creator', params['creator']))  # noqa: E501
        if 'public' in params:
            query_params.append(('public', params['public']))  # noqa: E501
        if 'main_annotation_type' in params:
            query_params.append(('main_annotation_type', params['main_annotation_type']))  # noqa: E501
        if 'set_tags' in params:
            query_params.append(('set_tags', params['set_tags']))  # noqa: E501
        if 'product' in params:
            query_params.append(('product', params['product']))  # noqa: E501
        if 'collaboration_type' in params:
            query_params.append(('collaboration_type', params['collaboration_type']))  # noqa: E501
        if 'priority' in params:
            query_params.append(('priority', params['priority']))  # noqa: E501
        if 'zip_state' in params:
            query_params.append(('zip_state', params['zip_state']))  # noqa: E501
        if 'images' in params:
            query_params.append(('images', params['images']))  # noqa: E501
        if 'omit' in params:
            query_params.append(('omit', params['omit']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/image_sets/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageSets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_image_set(self, id, **kwargs):  # noqa: E501
        """partial_update_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_image_set(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str name
        :param str description
        :param int creator
        :param bool public
        :param int main_annotation_type
        :param str priority
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_image_set_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_image_set_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_image_set_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_image_set_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str name
        :param str description
        :param int creator
        :param bool public
        :param int main_annotation_type
        :param int priority
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'name', 'description', 'creator', 'public', 'main_annotation_type', 'priority']  
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_image_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_image_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}
        if 'name' in params:
            body_params['name'] = params['name']
        if 'description' in params:
            body_params['description'] = params['description']
        if 'creator' in params:
            body_params['creator'] = params['creator']
        if 'public' in params:
            body_params['public'] = params['public']
        if 'main_annotation_type' in params:
            body_params['main_annotation_type'] = params['main_annotation_type']
        if 'priority' in params:
            body_params['priority'] = params['priority']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/image_sets/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_image_set(self, id, **kwargs):  # noqa: E501
        """retrieve_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_image_set(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str id2: id
        :param str path: path
        :param str path__contains: path__contains
        :param str name: name
        :param str name__contains: name__contains
        :param str location: location
        :param str location__contains: location__contains
        :param str description: description
        :param str description__contains: description__contains
        :param str time: time
        :param str time__range: time__range
        :param str team: team
        :param str creator: creator
        :param str public: public
        :param str main_annotation_type: main_annotation_type
        :param str set_tags: set_tags
        :param str product: product
        :param str collaboration_type: collaboration_type
        :param str priority: priority
        :param str zip_state: zip_state
        :param str images: images
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_image_set_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_image_set_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_image_set_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_image_set_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str id2: id
        :param str path: path
        :param str path__contains: path__contains
        :param str name: name
        :param str name__contains: name__contains
        :param str location: location
        :param str location__contains: location__contains
        :param str description: description
        :param str description__contains: description__contains
        :param str time: time
        :param str time__range: time__range
        :param str team: team
        :param str creator: creator
        :param str public: public
        :param str main_annotation_type: main_annotation_type
        :param str set_tags: set_tags
        :param str product: product
        :param str collaboration_type: collaboration_type
        :param str priority: priority
        :param str zip_state: zip_state
        :param str images: images
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'id2', 'path', 'path__contains', 'name', 'name__contains', 'location', 'location__contains', 'description', 'description__contains', 'time', 'time__range', 'team', 'creator', 'public', 'main_annotation_type', 'set_tags', 'product', 'collaboration_type', 'priority', 'zip_state', 'images']  # noqa: E501
        all_params.append('async_req')
        all_params.append('omit')
        all_params.append('fields')
        all_params.append('expand')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_image_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_image_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'id2' in params:
            query_params.append(('id', params['id2']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'path__contains' in params:
            query_params.append(('path__contains', params['path__contains']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'name__contains' in params:
            query_params.append(('name__contains', params['name__contains']))  # noqa: E501
        if 'location' in params:
            query_params.append(('location', params['location']))  # noqa: E501
        if 'location__contains' in params:
            query_params.append(('location__contains', params['location__contains']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501
        if 'description__contains' in params:
            query_params.append(('description__contains', params['description__contains']))  # noqa: E501
        if 'time' in params:
            query_params.append(('time', params['time']))  # noqa: E501
        if 'time__range' in params:
            query_params.append(('time__range', params['time__range']))  # noqa: E501
        if 'team' in params:
            query_params.append(('team', params['team']))  # noqa: E501
        if 'creator' in params:
            query_params.append(('creator', params['creator']))  # noqa: E501
        if 'public' in params:
            query_params.append(('public', params['public']))  # noqa: E501
        if 'main_annotation_type' in params:
            query_params.append(('main_annotation_type', params['main_annotation_type']))  # noqa: E501
        if 'set_tags' in params:
            query_params.append(('set_tags', params['set_tags']))  # noqa: E501
        if 'product' in params:
            query_params.append(('product', params['product']))  # noqa: E501
        if 'collaboration_type' in params:
            query_params.append(('collaboration_type', params['collaboration_type']))  # noqa: E501
        if 'priority' in params:
            query_params.append(('priority', params['priority']))  # noqa: E501
        if 'zip_state' in params:
            query_params.append(('zip_state', params['zip_state']))  # noqa: E501
        if 'images' in params:
            query_params.append(('images', params['images']))  # noqa: E501
        if 'omit' in params:
            query_params.append(('omit', params['omit']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E50
        if 'expand' in params:
            query_params.append(('expand', params['expand']))  # noqa: E501
            
        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/image_sets/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_image_set(self, id, **kwargs):  # noqa: E501
        """update_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_image_set(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param ImageSet body:
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_image_set_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_image_set_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_image_set_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_image_set  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_image_set_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param ImageSet body:
        :return: ImageSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_image_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_image_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/image_sets/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)



    def list_server(self, **kwargs):  # noqa: E501
        """cache image tiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_coodinates(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_path: (optional) search folder path
        :param str search_pattern: (optional) search pattern to filter the results
        :return: dict
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_server_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_server_with_http_info(**kwargs)  # noqa: E501
            return data


    def list_server_with_http_info(self, **kwargs):  # noqa: E501
        """cache image tiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.convert_coodinates(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_path: (optional) search folder path
        :param str search_pattern: (optional) search pattern to filter the results
        :return: dict
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_path', 'search_pattern']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_images_image" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'search_path' in params:
            query_params.append(('search_path', params['search_path']))
        if 'search_pattern' in params:
            query_params.append(('search_pattern', params['search_pattern']))


        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}


        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        response = self.api_client.call_api(
            f'/api/v1/images/image_sets/list_server/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            #response_type='ImageRegistration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)


        return json.loads(response.data), response