# MIT License
#
# Copyright (c) 2020 Anderson Vitor Bento
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from simublocks.element.block.block import Block 

class System(Block):
    def __init__(self, canvas, type, text, coords, code):
        Block.__init__(self,canvas,text, coords, code)
        self.type = type
        c = self.coords
        self._out_ = canvas.create_arc(self.right_pos(self.coords), start=-90, extent=180, fill="black")
        self._in_ = canvas.create_arc(self.left_pos(self.coords), start=-90, extent=180, fill="black")
        if type == "function":
            self.func = None

    def moveArc(self):
        c = self.coords
        self.canvas.coords(self._out_, self.right_pos(self.coords))
        self.canvas.coords(self._in_, self.left_pos(self.coords))

    def remove(self):
        Block.remove(self)
        self.canvas.delete(self._out_)
        self.canvas.delete(self._in_)