# Generated by Django 4.0.3 on 2022-05-30 20:48

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("structures", "0037_add_billing_notification_types"),
    ]

    operations = [
        migrations.CreateModel(
            name="StarbaseDetail",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("allow_alliance_members", models.BooleanField()),
                ("allow_corporation_members", models.BooleanField()),
                (
                    "anchor_role",
                    models.CharField(
                        choices=[
                            ("AL", "alliance member"),
                            ("CE", "config starbase equipment role"),
                            ("CO", "corporation member"),
                            ("FT", "starbase fuel technician role"),
                        ],
                        max_length=2,
                    ),
                ),
                ("attack_if_at_war", models.BooleanField()),
                ("attack_if_other_security_status_dropping", models.BooleanField()),
                (
                    "attack_security_status_threshold",
                    models.FloatField(default=None, null=True),
                ),
                (
                    "attack_standing_threshold",
                    models.FloatField(default=None, null=True),
                ),
                (
                    "fuel_bay_take_role",
                    models.CharField(
                        choices=[
                            ("AL", "alliance member"),
                            ("CE", "config starbase equipment role"),
                            ("CO", "corporation member"),
                            ("FT", "starbase fuel technician role"),
                        ],
                        max_length=2,
                    ),
                ),
                (
                    "fuel_bay_view_role",
                    models.CharField(
                        choices=[
                            ("AL", "alliance member"),
                            ("CE", "config starbase equipment role"),
                            ("CO", "corporation member"),
                            ("FT", "starbase fuel technician role"),
                        ],
                        max_length=2,
                    ),
                ),
                (
                    "last_modified_at",
                    models.DateTimeField(
                        help_text="When data was modified on the server."
                    ),
                ),
                (
                    "offline_role",
                    models.CharField(
                        choices=[
                            ("AL", "alliance member"),
                            ("CE", "config starbase equipment role"),
                            ("CO", "corporation member"),
                            ("FT", "starbase fuel technician role"),
                        ],
                        max_length=2,
                    ),
                ),
                (
                    "online_role",
                    models.CharField(
                        choices=[
                            ("AL", "alliance member"),
                            ("CE", "config starbase equipment role"),
                            ("CO", "corporation member"),
                            ("FT", "starbase fuel technician role"),
                        ],
                        max_length=2,
                    ),
                ),
                (
                    "unanchor_role",
                    models.CharField(
                        choices=[
                            ("AL", "alliance member"),
                            ("CE", "config starbase equipment role"),
                            ("CO", "corporation member"),
                            ("FT", "starbase fuel technician role"),
                        ],
                        max_length=2,
                    ),
                ),
                ("use_alliance_standings", models.BooleanField()),
                (
                    "structure",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="starbase_detail",
                        to="structures.structure",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="StarbaseDetailFuel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("quantity", models.IntegerField()),
                (
                    "detail",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="fuels",
                        to="structures.starbasedetail",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="structures.evetype",
                    ),
                ),
            ],
        ),
    ]
