# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! JAPAN Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_display_api.configuration import Configuration


class VideoServiceSetting(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'file_size': 'int',
        'file_type': 'VideoServiceFileType',
        'height': 'int',
        'playback_time': 'int',
        'video_ad_format': 'str',
        'video_aspect_ratio': 'str',
        'width': 'int'
    }

    attribute_map = {
        'file_size': 'fileSize',
        'file_type': 'fileType',
        'height': 'height',
        'playback_time': 'playbackTime',
        'video_ad_format': 'videoAdFormat',
        'video_aspect_ratio': 'videoAspectRatio',
        'width': 'width'
    }

    def __init__(self, file_size=None, file_type=None, height=None, playback_time=None, video_ad_format=None, video_aspect_ratio=None, width=None, local_vars_configuration=None):  # noqa: E501
        """VideoServiceSetting - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._file_size = None
        self._file_type = None
        self._height = None
        self._playback_time = None
        self._video_ad_format = None
        self._video_aspect_ratio = None
        self._width = None
        self.discriminator = None

        self.file_size = file_size
        self.file_type = file_type
        self.height = height
        self.playback_time = playback_time
        self.video_ad_format = video_ad_format
        self.video_aspect_ratio = video_aspect_ratio
        self.width = width

    @property
    def file_size(self):
        """Gets the file_size of this VideoServiceSetting.  # noqa: E501

        <div lang=\"ja\">動画のファイルサイズです。</div> <div lang=\"en\">File size of the video.</div>   # noqa: E501

        :return: The file_size of this VideoServiceSetting.  # noqa: E501
        :rtype: int
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size):
        """Sets the file_size of this VideoServiceSetting.

        <div lang=\"ja\">動画のファイルサイズです。</div> <div lang=\"en\">File size of the video.</div>   # noqa: E501

        :param file_size: The file_size of this VideoServiceSetting.  # noqa: E501
        :type: int
        """

        self._file_size = file_size

    @property
    def file_type(self):
        """Gets the file_type of this VideoServiceSetting.  # noqa: E501


        :return: The file_type of this VideoServiceSetting.  # noqa: E501
        :rtype: VideoServiceFileType
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """Sets the file_type of this VideoServiceSetting.


        :param file_type: The file_type of this VideoServiceSetting.  # noqa: E501
        :type: VideoServiceFileType
        """

        self._file_type = file_type

    @property
    def height(self):
        """Gets the height of this VideoServiceSetting.  # noqa: E501

        <div lang=\"ja\">動画の高さ（縦の長さ）です。</div> <div lang=\"en\">Height (vertical length) of the video.</div>   # noqa: E501

        :return: The height of this VideoServiceSetting.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this VideoServiceSetting.

        <div lang=\"ja\">動画の高さ（縦の長さ）です。</div> <div lang=\"en\">Height (vertical length) of the video.</div>   # noqa: E501

        :param height: The height of this VideoServiceSetting.  # noqa: E501
        :type: int
        """

        self._height = height

    @property
    def playback_time(self):
        """Gets the playback_time of this VideoServiceSetting.  # noqa: E501

        <div lang=\"ja\">動画再生時間（秒）です。</div> <div lang=\"en\">Play time (sec) of the video.</div>   # noqa: E501

        :return: The playback_time of this VideoServiceSetting.  # noqa: E501
        :rtype: int
        """
        return self._playback_time

    @playback_time.setter
    def playback_time(self, playback_time):
        """Sets the playback_time of this VideoServiceSetting.

        <div lang=\"ja\">動画再生時間（秒）です。</div> <div lang=\"en\">Play time (sec) of the video.</div>   # noqa: E501

        :param playback_time: The playback_time of this VideoServiceSetting.  # noqa: E501
        :type: int
        """

        self._playback_time = playback_time

    @property
    def video_ad_format(self):
        """Gets the video_ad_format of this VideoServiceSetting.  # noqa: E501

        <div lang=\"ja\">動画広告の種類です。</div> <div lang=\"en\">Ad format type of the video ad.</div>   # noqa: E501

        :return: The video_ad_format of this VideoServiceSetting.  # noqa: E501
        :rtype: str
        """
        return self._video_ad_format

    @video_ad_format.setter
    def video_ad_format(self, video_ad_format):
        """Sets the video_ad_format of this VideoServiceSetting.

        <div lang=\"ja\">動画広告の種類です。</div> <div lang=\"en\">Ad format type of the video ad.</div>   # noqa: E501

        :param video_ad_format: The video_ad_format of this VideoServiceSetting.  # noqa: E501
        :type: str
        """

        self._video_ad_format = video_ad_format

    @property
    def video_aspect_ratio(self):
        """Gets the video_aspect_ratio of this VideoServiceSetting.  # noqa: E501

        <div lang=\"ja\"> 動画アスペクト比の種類です。<br> ※指定可能な値は、DictionaryServiceのgetMediaAdFormatで取得されるDictionaryServiceMediaAdFormatのaspectRatioフィールドをご確認ください。 </div> <div lang=\"en\"> Type of aspect ratio.<br> * Available values can be referred to aspectRatio field of DictionaryServiceMediaAdFormat object obtained by getMediaAdFormat operation of DictionaryService. </div>   # noqa: E501

        :return: The video_aspect_ratio of this VideoServiceSetting.  # noqa: E501
        :rtype: str
        """
        return self._video_aspect_ratio

    @video_aspect_ratio.setter
    def video_aspect_ratio(self, video_aspect_ratio):
        """Sets the video_aspect_ratio of this VideoServiceSetting.

        <div lang=\"ja\"> 動画アスペクト比の種類です。<br> ※指定可能な値は、DictionaryServiceのgetMediaAdFormatで取得されるDictionaryServiceMediaAdFormatのaspectRatioフィールドをご確認ください。 </div> <div lang=\"en\"> Type of aspect ratio.<br> * Available values can be referred to aspectRatio field of DictionaryServiceMediaAdFormat object obtained by getMediaAdFormat operation of DictionaryService. </div>   # noqa: E501

        :param video_aspect_ratio: The video_aspect_ratio of this VideoServiceSetting.  # noqa: E501
        :type: str
        """

        self._video_aspect_ratio = video_aspect_ratio

    @property
    def width(self):
        """Gets the width of this VideoServiceSetting.  # noqa: E501

        <div lang=\"ja\">動画の横幅です。</div> <div lang=\"en\">Width of the video.</div>   # noqa: E501

        :return: The width of this VideoServiceSetting.  # noqa: E501
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this VideoServiceSetting.

        <div lang=\"ja\">動画の横幅です。</div> <div lang=\"en\">Width of the video.</div>   # noqa: E501

        :param width: The width of this VideoServiceSetting.  # noqa: E501
        :type: int
        """

        self._width = width

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoServiceSetting):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoServiceSetting):
            return True

        return self.to_dict() != other.to_dict()
