# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! JAPAN Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_display_api.configuration import Configuration


class Video(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'approval_status': 'VideoServiceApprovalStatus',
        'creation_time': 'str',
        'disapproval_reason_codes': 'list[str]',
        'media_id': 'int',
        'process_status': 'VideoServiceProcessStatus',
        'user_status': 'VideoServiceUserStatus',
        'video_name': 'str',
        'video_setting': 'VideoServiceSetting',
        'video_title': 'str',
        'created_date': 'str'
    }

    attribute_map = {
        'account_id': 'accountId',
        'approval_status': 'approvalStatus',
        'creation_time': 'creationTime',
        'disapproval_reason_codes': 'disapprovalReasonCodes',
        'media_id': 'mediaId',
        'process_status': 'processStatus',
        'user_status': 'userStatus',
        'video_name': 'videoName',
        'video_setting': 'videoSetting',
        'video_title': 'videoTitle',
        'created_date': 'createdDate'
    }

    def __init__(self, account_id=None, approval_status=None, creation_time=None, disapproval_reason_codes=None, media_id=None, process_status=None, user_status=None, video_name=None, video_setting=None, video_title=None, created_date=None, local_vars_configuration=None):  # noqa: E501
        """Video - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._approval_status = None
        self._creation_time = None
        self._disapproval_reason_codes = None
        self._media_id = None
        self._process_status = None
        self._user_status = None
        self._video_name = None
        self._video_setting = None
        self._video_title = None
        self._created_date = None
        self.discriminator = None

        self.account_id = account_id
        self.approval_status = approval_status
        self.creation_time = creation_time
        self.disapproval_reason_codes = disapproval_reason_codes
        self.media_id = media_id
        self.process_status = process_status
        self.user_status = user_status
        self.video_name = video_name
        self.video_setting = video_setting
        self.video_title = video_title
        self.created_date = created_date

    @property
    def account_id(self):
        """Gets the account_id of this Video.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\"> Account ID.<br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :return: The account_id of this Video.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Video.

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\"> Account ID.<br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :param account_id: The account_id of this Video.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def approval_status(self):
        """Gets the approval_status of this Video.  # noqa: E501


        :return: The approval_status of this Video.  # noqa: E501
        :rtype: VideoServiceApprovalStatus
        """
        return self._approval_status

    @approval_status.setter
    def approval_status(self, approval_status):
        """Sets the approval_status of this Video.


        :param approval_status: The approval_status of this Video.  # noqa: E501
        :type: VideoServiceApprovalStatus
        """

        self._approval_status = approval_status

    @property
    def creation_time(self):
        """Gets the creation_time of this Video.  # noqa: E501

        <div lang=\"ja\">動画の入稿日時です。</div> <div lang=\"en\">Time and date when the video was submitted.</div>   # noqa: E501

        :return: The creation_time of this Video.  # noqa: E501
        :rtype: str
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this Video.

        <div lang=\"ja\">動画の入稿日時です。</div> <div lang=\"en\">Time and date when the video was submitted.</div>   # noqa: E501

        :param creation_time: The creation_time of this Video.  # noqa: E501
        :type: str
        """

        self._creation_time = creation_time

    @property
    def disapproval_reason_codes(self):
        """Gets the disapproval_reason_codes of this Video.  # noqa: E501

        <div lang=\"ja\">動画の掲載拒否理由です。</div> <div lang=\"en\">Disapproval reason of the video.</div>   # noqa: E501

        :return: The disapproval_reason_codes of this Video.  # noqa: E501
        :rtype: list[str]
        """
        return self._disapproval_reason_codes

    @disapproval_reason_codes.setter
    def disapproval_reason_codes(self, disapproval_reason_codes):
        """Sets the disapproval_reason_codes of this Video.

        <div lang=\"ja\">動画の掲載拒否理由です。</div> <div lang=\"en\">Disapproval reason of the video.</div>   # noqa: E501

        :param disapproval_reason_codes: The disapproval_reason_codes of this Video.  # noqa: E501
        :type: list[str]
        """

        self._disapproval_reason_codes = disapproval_reason_codes

    @property
    def media_id(self):
        """Gets the media_id of this Video.  # noqa: E501

        <div lang=\"ja\"> メディアIDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\"> Media ID.<br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :return: The media_id of this Video.  # noqa: E501
        :rtype: int
        """
        return self._media_id

    @media_id.setter
    def media_id(self, media_id):
        """Sets the media_id of this Video.

        <div lang=\"ja\"> メディアIDです。<br> このフィールドは、SETおよびREMOVE時に必須となります。 </div> <div lang=\"en\"> Media ID.<br> This field is required in SET and REMOVE operation. </div>   # noqa: E501

        :param media_id: The media_id of this Video.  # noqa: E501
        :type: int
        """

        self._media_id = media_id

    @property
    def process_status(self):
        """Gets the process_status of this Video.  # noqa: E501


        :return: The process_status of this Video.  # noqa: E501
        :rtype: VideoServiceProcessStatus
        """
        return self._process_status

    @process_status.setter
    def process_status(self, process_status):
        """Sets the process_status of this Video.


        :param process_status: The process_status of this Video.  # noqa: E501
        :type: VideoServiceProcessStatus
        """

        self._process_status = process_status

    @property
    def user_status(self):
        """Gets the user_status of this Video.  # noqa: E501


        :return: The user_status of this Video.  # noqa: E501
        :rtype: VideoServiceUserStatus
        """
        return self._user_status

    @user_status.setter
    def user_status(self, user_status):
        """Sets the user_status of this Video.


        :param user_status: The user_status of this Video.  # noqa: E501
        :type: VideoServiceUserStatus
        """

        self._user_status = user_status

    @property
    def video_name(self):
        """Gets the video_name of this Video.  # noqa: E501

        <div lang=\"ja\">動画のファイル名です。</div> <div lang=\"en\">Video file name.</div>   # noqa: E501

        :return: The video_name of this Video.  # noqa: E501
        :rtype: str
        """
        return self._video_name

    @video_name.setter
    def video_name(self, video_name):
        """Sets the video_name of this Video.

        <div lang=\"ja\">動画のファイル名です。</div> <div lang=\"en\">Video file name.</div>   # noqa: E501

        :param video_name: The video_name of this Video.  # noqa: E501
        :type: str
        """

        self._video_name = video_name

    @property
    def video_setting(self):
        """Gets the video_setting of this Video.  # noqa: E501


        :return: The video_setting of this Video.  # noqa: E501
        :rtype: VideoServiceSetting
        """
        return self._video_setting

    @video_setting.setter
    def video_setting(self, video_setting):
        """Sets the video_setting of this Video.


        :param video_setting: The video_setting of this Video.  # noqa: E501
        :type: VideoServiceSetting
        """

        self._video_setting = video_setting

    @property
    def video_title(self):
        """Gets the video_title of this Video.  # noqa: E501

        <div lang=\"ja\"> 動画名です。<br> このフィールドは、SET時に省略可能となります。 </div> <div lang=\"en\"> Video name.<br> This field is optional in SET operation. </div>   # noqa: E501

        :return: The video_title of this Video.  # noqa: E501
        :rtype: str
        """
        return self._video_title

    @video_title.setter
    def video_title(self, video_title):
        """Sets the video_title of this Video.

        <div lang=\"ja\"> 動画名です。<br> このフィールドは、SET時に省略可能となります。 </div> <div lang=\"en\"> Video name.<br> This field is optional in SET operation. </div>   # noqa: E501

        :param video_title: The video_title of this Video.  # noqa: E501
        :type: str
        """

        self._video_title = video_title

    @property
    def created_date(self):
        """Gets the created_date of this Video.  # noqa: E501

        <div lang=\"ja\">動画の作成日です。<br>※フォーマット：yyyyMMdd</div> <div lang=\"en\">Date when the video was made.<br>* Format: yyyyMMdd</div>   # noqa: E501

        :return: The created_date of this Video.  # noqa: E501
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """Sets the created_date of this Video.

        <div lang=\"ja\">動画の作成日です。<br>※フォーマット：yyyyMMdd</div> <div lang=\"en\">Date when the video was made.<br>* Format: yyyyMMdd</div>   # noqa: E501

        :param created_date: The created_date of this Video.  # noqa: E501
        :type: str
        """

        self._created_date = created_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Video):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Video):
            return True

        return self.to_dict() != other.to_dict()
