# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! JAPAN Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_display_api.configuration import Configuration


class GuaranteedSimulation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'guaranteed_simulation_id': 'int',
        'lifetime_budget': 'int',
        'reach': 'int',
        'v_imps': 'int',
        'sov_rate': 'int',
        'slots': 'int',
        'campaign_goal': 'str',
        'start_date': 'str',
        'end_date': 'str',
        'viewable_frequency_cap': 'GuaranteedSimulationServiceViewableFrequencyCap',
        'max_v_imps': 'int',
        'max_reach': 'int',
        'lower_budget_limit': 'int',
        'upper_budget_limit': 'int',
        'reservation_status': 'GuaranteedSimulationServiceReservationStatus',
        'unreservable_reason': 'GuaranteedSimulationServiceUnreservableReason',
        'ad_requirements': 'list[GuaranteedSimulationServiceAdRequirement]',
        'targets': 'list[GuaranteedSimulationServiceAdGroupTarget]',
        'ad_place_type': 'GuaranteedSimulationServiceAdPlaceType',
        'prediction': 'GuaranteedSimulationServicePrediction',
        'ad_category_ids': 'list[int]',
        'package_id': 'int',
        'package_history_id': 'int',
        'action_after_video_ad_tap': 'GuaranteedSimulationServiceActionAfterVideoAdTap',
        'inventory_result': 'list[GuaranteedSimulationServiceInventoryResult]'
    }

    attribute_map = {
        'account_id': 'accountId',
        'guaranteed_simulation_id': 'guaranteedSimulationId',
        'lifetime_budget': 'lifetimeBudget',
        'reach': 'reach',
        'v_imps': 'vImps',
        'sov_rate': 'sovRate',
        'slots': 'slots',
        'campaign_goal': 'campaignGoal',
        'start_date': 'startDate',
        'end_date': 'endDate',
        'viewable_frequency_cap': 'viewableFrequencyCap',
        'max_v_imps': 'maxVImps',
        'max_reach': 'maxReach',
        'lower_budget_limit': 'lowerBudgetLimit',
        'upper_budget_limit': 'upperBudgetLimit',
        'reservation_status': 'reservationStatus',
        'unreservable_reason': 'unreservableReason',
        'ad_requirements': 'adRequirements',
        'targets': 'targets',
        'ad_place_type': 'adPlaceType',
        'prediction': 'prediction',
        'ad_category_ids': 'adCategoryIds',
        'package_id': 'packageId',
        'package_history_id': 'packageHistoryId',
        'action_after_video_ad_tap': 'actionAfterVideoAdTap',
        'inventory_result': 'inventoryResult'
    }

    def __init__(self, account_id=None, guaranteed_simulation_id=None, lifetime_budget=None, reach=None, v_imps=None, sov_rate=None, slots=None, campaign_goal=None, start_date=None, end_date=None, viewable_frequency_cap=None, max_v_imps=None, max_reach=None, lower_budget_limit=None, upper_budget_limit=None, reservation_status=None, unreservable_reason=None, ad_requirements=None, targets=None, ad_place_type=None, prediction=None, ad_category_ids=None, package_id=None, package_history_id=None, action_after_video_ad_tap=None, inventory_result=None, local_vars_configuration=None):  # noqa: E501
        """GuaranteedSimulation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._guaranteed_simulation_id = None
        self._lifetime_budget = None
        self._reach = None
        self._v_imps = None
        self._sov_rate = None
        self._slots = None
        self._campaign_goal = None
        self._start_date = None
        self._end_date = None
        self._viewable_frequency_cap = None
        self._max_v_imps = None
        self._max_reach = None
        self._lower_budget_limit = None
        self._upper_budget_limit = None
        self._reservation_status = None
        self._unreservable_reason = None
        self._ad_requirements = None
        self._targets = None
        self._ad_place_type = None
        self._prediction = None
        self._ad_category_ids = None
        self._package_id = None
        self._package_history_id = None
        self._action_after_video_ad_tap = None
        self._inventory_result = None
        self.discriminator = None

        self.account_id = account_id
        self.guaranteed_simulation_id = guaranteed_simulation_id
        self.lifetime_budget = lifetime_budget
        self.reach = reach
        self.v_imps = v_imps
        self.sov_rate = sov_rate
        self.slots = slots
        self.campaign_goal = campaign_goal
        self.start_date = start_date
        self.end_date = end_date
        self.viewable_frequency_cap = viewable_frequency_cap
        self.max_v_imps = max_v_imps
        self.max_reach = max_reach
        self.lower_budget_limit = lower_budget_limit
        self.upper_budget_limit = upper_budget_limit
        self.reservation_status = reservation_status
        self.unreservable_reason = unreservable_reason
        self.ad_requirements = ad_requirements
        self.targets = targets
        self.ad_place_type = ad_place_type
        self.prediction = prediction
        self.ad_category_ids = ad_category_ids
        self.package_id = package_id
        self.package_history_id = package_history_id
        self.action_after_video_ad_tap = action_after_video_ad_tap
        self.inventory_result = inventory_result

    @property
    def account_id(self):
        """Gets the account_id of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :return: The account_id of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this GuaranteedSimulation.

        <div lang=\"ja\"> アカウントIDです。<br> このフィールドは、リクエストの場合は必須です。 </div> <div lang=\"en\"> Account ID.<br> This field is required in requests. </div>   # noqa: E501

        :param account_id: The account_id of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def guaranteed_simulation_id(self):
        """Gets the guaranteed_simulation_id of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> シミュレーションIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Simulation ID.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The guaranteed_simulation_id of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._guaranteed_simulation_id

    @guaranteed_simulation_id.setter
    def guaranteed_simulation_id(self, guaranteed_simulation_id):
        """Sets the guaranteed_simulation_id of this GuaranteedSimulation.

        <div lang=\"ja\"> シミュレーションIDです。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Simulation ID.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param guaranteed_simulation_id: The guaranteed_simulation_id of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._guaranteed_simulation_id = guaranteed_simulation_id

    @property
    def lifetime_budget(self):
        """Gets the lifetime_budget of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> キャンペーンの通期予算額です。<br> ※この「通期予算」は、キャンペーンの全期間を通じて消費される予算を意味します。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> An amount of campaign's lifetime budget.<br> * \"lifetime budget\" means the total budget that is spent throughout the entire duration of the campaign.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :return: The lifetime_budget of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._lifetime_budget

    @lifetime_budget.setter
    def lifetime_budget(self, lifetime_budget):
        """Sets the lifetime_budget of this GuaranteedSimulation.

        <div lang=\"ja\"> キャンペーンの通期予算額です。<br> ※この「通期予算」は、キャンペーンの全期間を通じて消費される予算を意味します。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> An amount of campaign's lifetime budget.<br> * \"lifetime budget\" means the total budget that is spent throughout the entire duration of the campaign.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :param lifetime_budget: The lifetime_budget of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._lifetime_budget = lifetime_budget

    @property
    def reach(self):
        """Gets the reach of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> リーチ数です。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> Number of reaches.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :return: The reach of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._reach

    @reach.setter
    def reach(self, reach):
        """Sets the reach of this GuaranteedSimulation.

        <div lang=\"ja\"> リーチ数です。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> Number of reaches.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :param reach: The reach of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._reach = reach

    @property
    def v_imps(self):
        """Gets the v_imps of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> ビューアブルインプレッションです。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> Viewable impressions.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :return: The v_imps of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._v_imps

    @v_imps.setter
    def v_imps(self, v_imps):
        """Sets the v_imps of this GuaranteedSimulation.

        <div lang=\"ja\"> ビューアブルインプレッションです。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> Viewable impressions.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :param v_imps: The v_imps of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._v_imps = v_imps

    @property
    def sov_rate(self):
        """Gets the sov_rate of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> SOV（1%〜100%）です。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> SOV (1% to 100%).<br> This field is optional in ADD operation. </div>   # noqa: E501

        :return: The sov_rate of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._sov_rate

    @sov_rate.setter
    def sov_rate(self, sov_rate):
        """Sets the sov_rate of this GuaranteedSimulation.

        <div lang=\"ja\"> SOV（1%〜100%）です。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> SOV (1% to 100%).<br> This field is optional in ADD operation. </div>   # noqa: E501

        :param sov_rate: The sov_rate of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._sov_rate = sov_rate

    @property
    def slots(self):
        """Gets the slots of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 購入枠数です。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> Number of buying slots.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :return: The slots of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._slots

    @slots.setter
    def slots(self, slots):
        """Sets the slots of this GuaranteedSimulation.

        <div lang=\"ja\"> 購入枠数です。<br> ADD時、このフィールドは省略可能となります。<br> ※lifetimeBudget, reach, vImps, slotsは同時に設定することができません。 </div> <div lang=\"en\"> Number of buying slots.<br> This field is optional in ADD operation.<br> *lifetimeBudget, reach, vImps and slots cannot be set at the same time. </div>   # noqa: E501

        :param slots: The slots of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._slots = slots

    @property
    def campaign_goal(self):
        """Gets the campaign_goal of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> キャンペーン目的です。<br> ADD時、このフィールドは必須となります。<br> ※指定可能な値は、AccountAuthorityServiceのGET操作で得られるAccountAuthorityのauthoritiesフィールドをご確認ください。<br> </div> <div lang=\"en\"> Campaign goal.<br> In ADD operation, this field will be required.<br> * Available values can be referred to authorities field of AccountAuthority object obtained by GET operation of AccountAuthorityService.<br> </div>   # noqa: E501

        :return: The campaign_goal of this GuaranteedSimulation.  # noqa: E501
        :rtype: str
        """
        return self._campaign_goal

    @campaign_goal.setter
    def campaign_goal(self, campaign_goal):
        """Sets the campaign_goal of this GuaranteedSimulation.

        <div lang=\"ja\"> キャンペーン目的です。<br> ADD時、このフィールドは必須となります。<br> ※指定可能な値は、AccountAuthorityServiceのGET操作で得られるAccountAuthorityのauthoritiesフィールドをご確認ください。<br> </div> <div lang=\"en\"> Campaign goal.<br> In ADD operation, this field will be required.<br> * Available values can be referred to authorities field of AccountAuthority object obtained by GET operation of AccountAuthorityService.<br> </div>   # noqa: E501

        :param campaign_goal: The campaign_goal of this GuaranteedSimulation.  # noqa: E501
        :type: str
        """

        self._campaign_goal = campaign_goal

    @property
    def start_date(self):
        """Gets the start_date of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 開始日です。<br> ADD時、このフィールドは必須となります。 </div> <div lang=\"en\"> Start date.<br> In ADD operation, this field will be required. </div> Format: yyyyMMdd   # noqa: E501

        :return: The start_date of this GuaranteedSimulation.  # noqa: E501
        :rtype: str
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this GuaranteedSimulation.

        <div lang=\"ja\"> 開始日です。<br> ADD時、このフィールドは必須となります。 </div> <div lang=\"en\"> Start date.<br> In ADD operation, this field will be required. </div> Format: yyyyMMdd   # noqa: E501

        :param start_date: The start_date of this GuaranteedSimulation.  # noqa: E501
        :type: str
        """

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 終了日です。<br> ADD時、このフィールドは必須となります。<br> </div> <div lang=\"en\"> End date.<br> In ADD operation, this field will be required.<br> </div> Format: yyyyMMdd   # noqa: E501

        :return: The end_date of this GuaranteedSimulation.  # noqa: E501
        :rtype: str
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this GuaranteedSimulation.

        <div lang=\"ja\"> 終了日です。<br> ADD時、このフィールドは必須となります。<br> </div> <div lang=\"en\"> End date.<br> In ADD operation, this field will be required.<br> </div> Format: yyyyMMdd   # noqa: E501

        :param end_date: The end_date of this GuaranteedSimulation.  # noqa: E501
        :type: str
        """

        self._end_date = end_date

    @property
    def viewable_frequency_cap(self):
        """Gets the viewable_frequency_cap of this GuaranteedSimulation.  # noqa: E501


        :return: The viewable_frequency_cap of this GuaranteedSimulation.  # noqa: E501
        :rtype: GuaranteedSimulationServiceViewableFrequencyCap
        """
        return self._viewable_frequency_cap

    @viewable_frequency_cap.setter
    def viewable_frequency_cap(self, viewable_frequency_cap):
        """Sets the viewable_frequency_cap of this GuaranteedSimulation.


        :param viewable_frequency_cap: The viewable_frequency_cap of this GuaranteedSimulation.  # noqa: E501
        :type: GuaranteedSimulationServiceViewableFrequencyCap
        """

        self._viewable_frequency_cap = viewable_frequency_cap

    @property
    def max_v_imps(self):
        """Gets the max_v_imps of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 最大ビューアブルインプレッション数です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Maximum number of ad viewable impressions to same user.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The max_v_imps of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._max_v_imps

    @max_v_imps.setter
    def max_v_imps(self, max_v_imps):
        """Sets the max_v_imps of this GuaranteedSimulation.

        <div lang=\"ja\"> 最大ビューアブルインプレッション数です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Maximum number of ad viewable impressions to same user.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param max_v_imps: The max_v_imps of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._max_v_imps = max_v_imps

    @property
    def max_reach(self):
        """Gets the max_reach of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 最大リーチ数です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Maximum number of reaches.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The max_reach of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._max_reach

    @max_reach.setter
    def max_reach(self, max_reach):
        """Sets the max_reach of this GuaranteedSimulation.

        <div lang=\"ja\"> 最大リーチ数です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Maximum number of reaches.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param max_reach: The max_reach of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._max_reach = max_reach

    @property
    def lower_budget_limit(self):
        """Gets the lower_budget_limit of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 予約可能な下限通期予算です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Minimum reservable lifetime budget.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The lower_budget_limit of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._lower_budget_limit

    @lower_budget_limit.setter
    def lower_budget_limit(self, lower_budget_limit):
        """Sets the lower_budget_limit of this GuaranteedSimulation.

        <div lang=\"ja\"> 予約可能な下限通期予算です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Minimum reservable lifetime budget.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param lower_budget_limit: The lower_budget_limit of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._lower_budget_limit = lower_budget_limit

    @property
    def upper_budget_limit(self):
        """Gets the upper_budget_limit of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 予約可能な上限通期予算です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Maximum reservable lifetime budget.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :return: The upper_budget_limit of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._upper_budget_limit

    @upper_budget_limit.setter
    def upper_budget_limit(self, upper_budget_limit):
        """Sets the upper_budget_limit of this GuaranteedSimulation.

        <div lang=\"ja\"> 予約可能な上限通期予算です。<br> このフィールドは、レスポンスの際に返却されますが、リクエストの際には無視されます。 </div> <div lang=\"en\"> Maximum reservable lifetime budget.<br> Although this field will be returned in the response, it will be ignored on input. </div>   # noqa: E501

        :param upper_budget_limit: The upper_budget_limit of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._upper_budget_limit = upper_budget_limit

    @property
    def reservation_status(self):
        """Gets the reservation_status of this GuaranteedSimulation.  # noqa: E501


        :return: The reservation_status of this GuaranteedSimulation.  # noqa: E501
        :rtype: GuaranteedSimulationServiceReservationStatus
        """
        return self._reservation_status

    @reservation_status.setter
    def reservation_status(self, reservation_status):
        """Sets the reservation_status of this GuaranteedSimulation.


        :param reservation_status: The reservation_status of this GuaranteedSimulation.  # noqa: E501
        :type: GuaranteedSimulationServiceReservationStatus
        """

        self._reservation_status = reservation_status

    @property
    def unreservable_reason(self):
        """Gets the unreservable_reason of this GuaranteedSimulation.  # noqa: E501


        :return: The unreservable_reason of this GuaranteedSimulation.  # noqa: E501
        :rtype: GuaranteedSimulationServiceUnreservableReason
        """
        return self._unreservable_reason

    @unreservable_reason.setter
    def unreservable_reason(self, unreservable_reason):
        """Sets the unreservable_reason of this GuaranteedSimulation.


        :param unreservable_reason: The unreservable_reason of this GuaranteedSimulation.  # noqa: E501
        :type: GuaranteedSimulationServiceUnreservableReason
        """

        self._unreservable_reason = unreservable_reason

    @property
    def ad_requirements(self):
        """Gets the ad_requirements of this GuaranteedSimulation.  # noqa: E501


        :return: The ad_requirements of this GuaranteedSimulation.  # noqa: E501
        :rtype: list[GuaranteedSimulationServiceAdRequirement]
        """
        return self._ad_requirements

    @ad_requirements.setter
    def ad_requirements(self, ad_requirements):
        """Sets the ad_requirements of this GuaranteedSimulation.


        :param ad_requirements: The ad_requirements of this GuaranteedSimulation.  # noqa: E501
        :type: list[GuaranteedSimulationServiceAdRequirement]
        """

        self._ad_requirements = ad_requirements

    @property
    def targets(self):
        """Gets the targets of this GuaranteedSimulation.  # noqa: E501


        :return: The targets of this GuaranteedSimulation.  # noqa: E501
        :rtype: list[GuaranteedSimulationServiceAdGroupTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """Sets the targets of this GuaranteedSimulation.


        :param targets: The targets of this GuaranteedSimulation.  # noqa: E501
        :type: list[GuaranteedSimulationServiceAdGroupTarget]
        """

        self._targets = targets

    @property
    def ad_place_type(self):
        """Gets the ad_place_type of this GuaranteedSimulation.  # noqa: E501


        :return: The ad_place_type of this GuaranteedSimulation.  # noqa: E501
        :rtype: GuaranteedSimulationServiceAdPlaceType
        """
        return self._ad_place_type

    @ad_place_type.setter
    def ad_place_type(self, ad_place_type):
        """Sets the ad_place_type of this GuaranteedSimulation.


        :param ad_place_type: The ad_place_type of this GuaranteedSimulation.  # noqa: E501
        :type: GuaranteedSimulationServiceAdPlaceType
        """

        self._ad_place_type = ad_place_type

    @property
    def prediction(self):
        """Gets the prediction of this GuaranteedSimulation.  # noqa: E501


        :return: The prediction of this GuaranteedSimulation.  # noqa: E501
        :rtype: GuaranteedSimulationServicePrediction
        """
        return self._prediction

    @prediction.setter
    def prediction(self, prediction):
        """Sets the prediction of this GuaranteedSimulation.


        :param prediction: The prediction of this GuaranteedSimulation.  # noqa: E501
        :type: GuaranteedSimulationServicePrediction
        """

        self._prediction = prediction

    @property
    def ad_category_ids(self):
        """Gets the ad_category_ids of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 広告カテゴリーIDです。<br> 広告カテゴリーは、配信する広告内容に該当するものを正確に指定して下さい。内容に応じて広告掲載量が変わるため、正確なシミュレーション結果の算出に必要です。<br> 詳細は<a href=\"https://ads-help.yahoo.co.jp/yahooads/guideline/articledetail?lan=ja&aid=50308\" target=\"_blank\">ヘルプ</a>を参照してください。<br> なお、ここで指定した広告カテゴリーと異なる広告が入稿された場合は、入稿した広告内容の修正が必要な旨をメールでご連絡します。<br> ※指定した広告カテゴリーと広告タイプの組み合わせによっては、予約のキャンセルが必要な場合があります。その場合はキャンセル料が発生します。<br> 指定可能な値は、GuaranteedSimulationService/getAdCategoryで取得されるGuaranteedSimulationServiceAdCategoryオブジェクトのadCategoryIdフィールドをご参照ください。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Ad category ID.<br> To get an accurate simulated result, specify the restricted contents correctly. The ad volume depends on the contents.<br> <a href=\"https://ads-help.yahoo.co.jp/yahooads/guideline/articledetail?lan=en&aid=28259\" target=\"_blank\">Learn more</a><br> If you add ads that have a content different from the one you specified, you will receive an email to fix them.<br> You may need to cancel your ad depending on the combination of content and ad type you specified. Pay a cancellation fee in that case.<br> Available values can be referred to adCategoryId field of GuaranteedSimulationServiceAdCategory object obtained by getAdCategory operation of GuaranteedSimulationService.<br> This field is optional in ADD operation. </div>   # noqa: E501

        :return: The ad_category_ids of this GuaranteedSimulation.  # noqa: E501
        :rtype: list[int]
        """
        return self._ad_category_ids

    @ad_category_ids.setter
    def ad_category_ids(self, ad_category_ids):
        """Sets the ad_category_ids of this GuaranteedSimulation.

        <div lang=\"ja\"> 広告カテゴリーIDです。<br> 広告カテゴリーは、配信する広告内容に該当するものを正確に指定して下さい。内容に応じて広告掲載量が変わるため、正確なシミュレーション結果の算出に必要です。<br> 詳細は<a href=\"https://ads-help.yahoo.co.jp/yahooads/guideline/articledetail?lan=ja&aid=50308\" target=\"_blank\">ヘルプ</a>を参照してください。<br> なお、ここで指定した広告カテゴリーと異なる広告が入稿された場合は、入稿した広告内容の修正が必要な旨をメールでご連絡します。<br> ※指定した広告カテゴリーと広告タイプの組み合わせによっては、予約のキャンセルが必要な場合があります。その場合はキャンセル料が発生します。<br> 指定可能な値は、GuaranteedSimulationService/getAdCategoryで取得されるGuaranteedSimulationServiceAdCategoryオブジェクトのadCategoryIdフィールドをご参照ください。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Ad category ID.<br> To get an accurate simulated result, specify the restricted contents correctly. The ad volume depends on the contents.<br> <a href=\"https://ads-help.yahoo.co.jp/yahooads/guideline/articledetail?lan=en&aid=28259\" target=\"_blank\">Learn more</a><br> If you add ads that have a content different from the one you specified, you will receive an email to fix them.<br> You may need to cancel your ad depending on the combination of content and ad type you specified. Pay a cancellation fee in that case.<br> Available values can be referred to adCategoryId field of GuaranteedSimulationServiceAdCategory object obtained by getAdCategory operation of GuaranteedSimulationService.<br> This field is optional in ADD operation. </div>   # noqa: E501

        :param ad_category_ids: The ad_category_ids of this GuaranteedSimulation.  # noqa: E501
        :type: list[int]
        """

        self._ad_category_ids = ad_category_ids

    @property
    def package_id(self):
        """Gets the package_id of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 商品IDです。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Package ID.<br> This field is optional in ADD operation. </div>   # noqa: E501

        :return: The package_id of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._package_id

    @package_id.setter
    def package_id(self, package_id):
        """Sets the package_id of this GuaranteedSimulation.

        <div lang=\"ja\"> 商品IDです。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Package ID.<br> This field is optional in ADD operation. </div>   # noqa: E501

        :param package_id: The package_id of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._package_id = package_id

    @property
    def package_history_id(self):
        """Gets the package_history_id of this GuaranteedSimulation.  # noqa: E501

        <div lang=\"ja\"> 商品履歴IDです。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Package history ID.<br> This field is optional in ADD operation. </div>   # noqa: E501

        :return: The package_history_id of this GuaranteedSimulation.  # noqa: E501
        :rtype: int
        """
        return self._package_history_id

    @package_history_id.setter
    def package_history_id(self, package_history_id):
        """Sets the package_history_id of this GuaranteedSimulation.

        <div lang=\"ja\"> 商品履歴IDです。<br> ADD時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Package history ID.<br> This field is optional in ADD operation. </div>   # noqa: E501

        :param package_history_id: The package_history_id of this GuaranteedSimulation.  # noqa: E501
        :type: int
        """

        self._package_history_id = package_history_id

    @property
    def action_after_video_ad_tap(self):
        """Gets the action_after_video_ad_tap of this GuaranteedSimulation.  # noqa: E501


        :return: The action_after_video_ad_tap of this GuaranteedSimulation.  # noqa: E501
        :rtype: GuaranteedSimulationServiceActionAfterVideoAdTap
        """
        return self._action_after_video_ad_tap

    @action_after_video_ad_tap.setter
    def action_after_video_ad_tap(self, action_after_video_ad_tap):
        """Sets the action_after_video_ad_tap of this GuaranteedSimulation.


        :param action_after_video_ad_tap: The action_after_video_ad_tap of this GuaranteedSimulation.  # noqa: E501
        :type: GuaranteedSimulationServiceActionAfterVideoAdTap
        """

        self._action_after_video_ad_tap = action_after_video_ad_tap

    @property
    def inventory_result(self):
        """Gets the inventory_result of this GuaranteedSimulation.  # noqa: E501


        :return: The inventory_result of this GuaranteedSimulation.  # noqa: E501
        :rtype: list[GuaranteedSimulationServiceInventoryResult]
        """
        return self._inventory_result

    @inventory_result.setter
    def inventory_result(self, inventory_result):
        """Sets the inventory_result of this GuaranteedSimulation.


        :param inventory_result: The inventory_result of this GuaranteedSimulation.  # noqa: E501
        :type: list[GuaranteedSimulationServiceInventoryResult]
        """

        self._inventory_result = inventory_result

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GuaranteedSimulation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GuaranteedSimulation):
            return True

        return self.to_dict() != other.to_dict()
