# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! JAPAN Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_display_api.configuration import Configuration


class FeedDataServiceSelector(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'int',
        'feed_ids': 'list[int]',
        'file_upload_date_range': 'FeedDataServiceFileUploadDateRange',
        'item_list_upload_ids': 'list[int]',
        'number_results': 'int',
        'start_index': 'int',
        'upload_statuses': 'list[FeedDataServiceFileUploadStatus]'
    }

    attribute_map = {
        'account_id': 'accountId',
        'feed_ids': 'feedIds',
        'file_upload_date_range': 'fileUploadDateRange',
        'item_list_upload_ids': 'itemListUploadIds',
        'number_results': 'numberResults',
        'start_index': 'startIndex',
        'upload_statuses': 'uploadStatuses'
    }

    def __init__(self, account_id=None, feed_ids=None, file_upload_date_range=None, item_list_upload_ids=None, number_results=20, start_index=1, upload_statuses=None, local_vars_configuration=None):  # noqa: E501
        """FeedDataServiceSelector - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._feed_ids = None
        self._file_upload_date_range = None
        self._item_list_upload_ids = None
        self._number_results = None
        self._start_index = None
        self._upload_statuses = None
        self.discriminator = None

        self.account_id = account_id
        self.feed_ids = feed_ids
        self.file_upload_date_range = file_upload_date_range
        self.item_list_upload_ids = item_list_upload_ids
        self.number_results = number_results
        self.start_index = start_index
        self.upload_statuses = upload_statuses

    @property
    def account_id(self):
        """Gets the account_id of this FeedDataServiceSelector.  # noqa: E501

        <div lang=\"ja\">アカウントID</div> <div lang=\"en\">Account ID</div>   # noqa: E501

        :return: The account_id of this FeedDataServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this FeedDataServiceSelector.

        <div lang=\"ja\">アカウントID</div> <div lang=\"en\">Account ID</div>   # noqa: E501

        :param account_id: The account_id of this FeedDataServiceSelector.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and account_id is None:  # noqa: E501
            raise ValueError("Invalid value for `account_id`, must not be `None`")  # noqa: E501

        self._account_id = account_id

    @property
    def feed_ids(self):
        """Gets the feed_ids of this FeedDataServiceSelector.  # noqa: E501

        <div lang=\"ja\">フィードID</div> <div lang=\"en\">FeedID</div>   # noqa: E501

        :return: The feed_ids of this FeedDataServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._feed_ids

    @feed_ids.setter
    def feed_ids(self, feed_ids):
        """Sets the feed_ids of this FeedDataServiceSelector.

        <div lang=\"ja\">フィードID</div> <div lang=\"en\">FeedID</div>   # noqa: E501

        :param feed_ids: The feed_ids of this FeedDataServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._feed_ids = feed_ids

    @property
    def file_upload_date_range(self):
        """Gets the file_upload_date_range of this FeedDataServiceSelector.  # noqa: E501


        :return: The file_upload_date_range of this FeedDataServiceSelector.  # noqa: E501
        :rtype: FeedDataServiceFileUploadDateRange
        """
        return self._file_upload_date_range

    @file_upload_date_range.setter
    def file_upload_date_range(self, file_upload_date_range):
        """Sets the file_upload_date_range of this FeedDataServiceSelector.


        :param file_upload_date_range: The file_upload_date_range of this FeedDataServiceSelector.  # noqa: E501
        :type: FeedDataServiceFileUploadDateRange
        """

        self._file_upload_date_range = file_upload_date_range

    @property
    def item_list_upload_ids(self):
        """Gets the item_list_upload_ids of this FeedDataServiceSelector.  # noqa: E501

        <div lang=\"ja\">アップロードした商品情報ID</div> <div lang=\"en\">Uploaded item list ID.</div>   # noqa: E501

        :return: The item_list_upload_ids of this FeedDataServiceSelector.  # noqa: E501
        :rtype: list[int]
        """
        return self._item_list_upload_ids

    @item_list_upload_ids.setter
    def item_list_upload_ids(self, item_list_upload_ids):
        """Sets the item_list_upload_ids of this FeedDataServiceSelector.

        <div lang=\"ja\">アップロードした商品情報ID</div> <div lang=\"en\">Uploaded item list ID.</div>   # noqa: E501

        :param item_list_upload_ids: The item_list_upload_ids of this FeedDataServiceSelector.  # noqa: E501
        :type: list[int]
        """

        self._item_list_upload_ids = item_list_upload_ids

    @property
    def number_results(self):
        """Gets the number_results of this FeedDataServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :return: The number_results of this FeedDataServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._number_results

    @number_results.setter
    def number_results(self, number_results):
        """Sets the number_results of this FeedDataServiceSelector.

        <div lang=\"ja\">ページの最大件数です。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div>   # noqa: E501

        :param number_results: The number_results of this FeedDataServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results > 500):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value less than or equal to `500`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number_results is not None and number_results < 1):  # noqa: E501
            raise ValueError("Invalid value for `number_results`, must be a value greater than or equal to `1`")  # noqa: E501

        self._number_results = number_results

    @property
    def start_index(self):
        """Gets the start_index of this FeedDataServiceSelector.  # noqa: E501

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :return: The start_index of this FeedDataServiceSelector.  # noqa: E501
        :rtype: int
        """
        return self._start_index

    @start_index.setter
    def start_index(self, start_index):
        """Sets the start_index of this FeedDataServiceSelector.

        <div lang=\"ja\">ページの先頭のインデックスです。このフィールドは、1以上を指定する必要があります。</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div>   # noqa: E501

        :param start_index: The start_index of this FeedDataServiceSelector.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                start_index is not None and start_index < 1):  # noqa: E501
            raise ValueError("Invalid value for `start_index`, must be a value greater than or equal to `1`")  # noqa: E501

        self._start_index = start_index

    @property
    def upload_statuses(self):
        """Gets the upload_statuses of this FeedDataServiceSelector.  # noqa: E501


        :return: The upload_statuses of this FeedDataServiceSelector.  # noqa: E501
        :rtype: list[FeedDataServiceFileUploadStatus]
        """
        return self._upload_statuses

    @upload_statuses.setter
    def upload_statuses(self, upload_statuses):
        """Sets the upload_statuses of this FeedDataServiceSelector.


        :param upload_statuses: The upload_statuses of this FeedDataServiceSelector.  # noqa: E501
        :type: list[FeedDataServiceFileUploadStatus]
        """

        self._upload_statuses = upload_statuses

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FeedDataServiceSelector):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FeedDataServiceSelector):
            return True

        return self.to_dict() != other.to_dict()
