# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! JAPAN Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_display_api.configuration import Configuration


class AdGroupAdServiceMobileAd(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'description2': 'str',
        'display_url': 'str',
        'headline': 'str',
        'mobile_carriers': 'list[AdGroupAdServiceCarrierName]',
        'url': 'str'
    }

    attribute_map = {
        'description': 'description',
        'description2': 'description2',
        'display_url': 'displayUrl',
        'headline': 'headline',
        'mobile_carriers': 'mobileCarriers',
        'url': 'url'
    }

    def __init__(self, description=None, description2=None, display_url=None, headline=None, mobile_carriers=None, url=None, local_vars_configuration=None):  # noqa: E501
        """AdGroupAdServiceMobileAd - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._description = None
        self._description2 = None
        self._display_url = None
        self._headline = None
        self._mobile_carriers = None
        self._url = None
        self.discriminator = None

        self.description = description
        self.description2 = description2
        self.display_url = display_url
        self.headline = headline
        self.mobile_carriers = mobile_carriers
        self.url = url

    @property
    def description(self):
        """Gets the description of this AdGroupAdServiceMobileAd.  # noqa: E501

        <div lang=\"ja\"> 説明文（1行目）です。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Description text (line 1).<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :return: The description of this AdGroupAdServiceMobileAd.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AdGroupAdServiceMobileAd.

        <div lang=\"ja\"> 説明文（1行目）です。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Description text (line 1).<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :param description: The description of this AdGroupAdServiceMobileAd.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def description2(self):
        """Gets the description2 of this AdGroupAdServiceMobileAd.  # noqa: E501

        <div lang=\"ja\"> 説明文（2行目）です。<br> ADDおよびSET時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Description text (line 2).<br> This field is optional in ADD and SET operation. </div>   # noqa: E501

        :return: The description2 of this AdGroupAdServiceMobileAd.  # noqa: E501
        :rtype: str
        """
        return self._description2

    @description2.setter
    def description2(self, description2):
        """Sets the description2 of this AdGroupAdServiceMobileAd.

        <div lang=\"ja\"> 説明文（2行目）です。<br> ADDおよびSET時、このフィールドは省略可能となります。 </div> <div lang=\"en\"> Description text (line 2).<br> This field is optional in ADD and SET operation. </div>   # noqa: E501

        :param description2: The description2 of this AdGroupAdServiceMobileAd.  # noqa: E501
        :type: str
        """

        self._description2 = description2

    @property
    def display_url(self):
        """Gets the display_url of this AdGroupAdServiceMobileAd.  # noqa: E501

        <div lang=\"ja\"> 表示URLです。<br> ADDおよびSET時、このフィールドは省略可能となります。<br> ただし、キャンペーン目的「アプリ訴求」の場合は、ADD、SETのどちらも指定できません。キャンペーンで指定したDeviceOsTypeに基づき、以下のいずれかのURLが自動で設定されます。<br> - iOSの場合：itunes.apple.com<br> - Androidの場合：play.google.com </div> <div lang=\"en\"> Display URL.<br> This field is optional in ADD and SET operation.<br> However, not allowed for ADD and SET when a campaign goal is \"app promotion\". Based on DeviceOsType specified on the campaign, any of the following URLs will be automatically set.<br> - For iOS : itunes.apple.com<br> - For Android : play.google.com </div>   # noqa: E501

        :return: The display_url of this AdGroupAdServiceMobileAd.  # noqa: E501
        :rtype: str
        """
        return self._display_url

    @display_url.setter
    def display_url(self, display_url):
        """Sets the display_url of this AdGroupAdServiceMobileAd.

        <div lang=\"ja\"> 表示URLです。<br> ADDおよびSET時、このフィールドは省略可能となります。<br> ただし、キャンペーン目的「アプリ訴求」の場合は、ADD、SETのどちらも指定できません。キャンペーンで指定したDeviceOsTypeに基づき、以下のいずれかのURLが自動で設定されます。<br> - iOSの場合：itunes.apple.com<br> - Androidの場合：play.google.com </div> <div lang=\"en\"> Display URL.<br> This field is optional in ADD and SET operation.<br> However, not allowed for ADD and SET when a campaign goal is \"app promotion\". Based on DeviceOsType specified on the campaign, any of the following URLs will be automatically set.<br> - For iOS : itunes.apple.com<br> - For Android : play.google.com </div>   # noqa: E501

        :param display_url: The display_url of this AdGroupAdServiceMobileAd.  # noqa: E501
        :type: str
        """

        self._display_url = display_url

    @property
    def headline(self):
        """Gets the headline of this AdGroupAdServiceMobileAd.  # noqa: E501

        <div lang=\"ja\"> タイトルです。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Title.<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :return: The headline of this AdGroupAdServiceMobileAd.  # noqa: E501
        :rtype: str
        """
        return self._headline

    @headline.setter
    def headline(self, headline):
        """Sets the headline of this AdGroupAdServiceMobileAd.

        <div lang=\"ja\"> タイトルです。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Title.<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :param headline: The headline of this AdGroupAdServiceMobileAd.  # noqa: E501
        :type: str
        """

        self._headline = headline

    @property
    def mobile_carriers(self):
        """Gets the mobile_carriers of this AdGroupAdServiceMobileAd.  # noqa: E501


        :return: The mobile_carriers of this AdGroupAdServiceMobileAd.  # noqa: E501
        :rtype: list[AdGroupAdServiceCarrierName]
        """
        return self._mobile_carriers

    @mobile_carriers.setter
    def mobile_carriers(self, mobile_carriers):
        """Sets the mobile_carriers of this AdGroupAdServiceMobileAd.


        :param mobile_carriers: The mobile_carriers of this AdGroupAdServiceMobileAd.  # noqa: E501
        :type: list[AdGroupAdServiceCarrierName]
        """

        self._mobile_carriers = mobile_carriers

    @property
    def url(self):
        """Gets the url of this AdGroupAdServiceMobileAd.  # noqa: E501

        <div lang=\"ja\"> リンク先URLです。<br> アプリ訴求キャンペーンで設定可能なリンク先URLについては<a href=\"/reference/ads-display-api/v6/CampaignService/get/\">こちら</a>をご参照ください。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Destination URL.<br> For information about the destination URL that can be set with campaigns for \"app promotion\", refer to <a href=\"/reference/ads-display-api/v6/CampaignService/get/en/\">this page</a>.<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :return: The url of this AdGroupAdServiceMobileAd.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this AdGroupAdServiceMobileAd.

        <div lang=\"ja\"> リンク先URLです。<br> アプリ訴求キャンペーンで設定可能なリンク先URLについては<a href=\"/reference/ads-display-api/v6/CampaignService/get/\">こちら</a>をご参照ください。<br> このフィールドは、ADD時は必須となり、SET時は省略可能となります。 </div> <div lang=\"en\"> Destination URL.<br> For information about the destination URL that can be set with campaigns for \"app promotion\", refer to <a href=\"/reference/ads-display-api/v6/CampaignService/get/en/\">this page</a>.<br> This field is required in ADD operation, and will be optional in SET operation. </div>   # noqa: E501

        :param url: The url of this AdGroupAdServiceMobileAd.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdGroupAdServiceMobileAd):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AdGroupAdServiceMobileAd):
            return True

        return self.to_dict() != other.to_dict()
