# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! JAPAN Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from yahoo_display_api.configuration import Configuration


class AccountManagementServiceClient(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'building': 'str',
        'city': 'str',
        'client_person_name': 'str',
        'company_name': 'str',
        'company_name_kana': 'str',
        'enterprise_type': 'AccountManagementServiceEnterpriseType',
        'enterprise_type_position': 'AccountManagementServiceEnterpriseTypePosition',
        'phone_number': 'str',
        'prefecture_code': 'AccountManagementServicePrefectureCode',
        'street1': 'str',
        'street2': 'str',
        'url': 'str',
        'url_type': 'AccountManagementServiceUrlType',
        'zip': 'str'
    }

    attribute_map = {
        'building': 'building',
        'city': 'city',
        'client_person_name': 'clientPersonName',
        'company_name': 'companyName',
        'company_name_kana': 'companyNameKana',
        'enterprise_type': 'enterpriseType',
        'enterprise_type_position': 'enterpriseTypePosition',
        'phone_number': 'phoneNumber',
        'prefecture_code': 'prefectureCode',
        'street1': 'street1',
        'street2': 'street2',
        'url': 'url',
        'url_type': 'urlType',
        'zip': 'zip'
    }

    def __init__(self, building=None, city=None, client_person_name=None, company_name=None, company_name_kana=None, enterprise_type=None, enterprise_type_position=None, phone_number=None, prefecture_code=None, street1=None, street2=None, url=None, url_type=None, zip=None, local_vars_configuration=None):  # noqa: E501
        """AccountManagementServiceClient - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._building = None
        self._city = None
        self._client_person_name = None
        self._company_name = None
        self._company_name_kana = None
        self._enterprise_type = None
        self._enterprise_type_position = None
        self._phone_number = None
        self._prefecture_code = None
        self._street1 = None
        self._street2 = None
        self._url = None
        self._url_type = None
        self._zip = None
        self.discriminator = None

        self.building = building
        self.city = city
        self.client_person_name = client_person_name
        self.company_name = company_name
        self.company_name_kana = company_name_kana
        self.enterprise_type = enterprise_type
        self.enterprise_type_position = enterprise_type_position
        self.phone_number = phone_number
        self.prefecture_code = prefecture_code
        self.street1 = street1
        self.street2 = street2
        self.url = url
        self.url_type = url_type
        self.zip = zip

    @property
    def building(self):
        """Gets the building of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> ビル名です。<br> このフィールドは、ADD時に省略可能となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Building name.<br> This field is optional in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :return: The building of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._building

    @building.setter
    def building(self, building):
        """Sets the building of this AccountManagementServiceClient.

        <div lang=\"ja\"> ビル名です。<br> このフィールドは、ADD時に省略可能となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Building name.<br> This field is optional in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :param building: The building of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._building = building

    @property
    def city(self):
        """Gets the city of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 市区町村名です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> City name.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :return: The city of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this AccountManagementServiceClient.

        <div lang=\"ja\"> 市区町村名です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> City name.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :param city: The city of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def client_person_name(self):
        """Gets the client_person_name of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 広告主の担当者氏名です。<br> このフィールドは、ADD時に省略可能となり、SET時に無視されます。 </div> <div lang=\"en\"> Client person name.<br> This field is optional in ADD operation, and will be ignored in SET operation. </div>   # noqa: E501

        :return: The client_person_name of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._client_person_name

    @client_person_name.setter
    def client_person_name(self, client_person_name):
        """Sets the client_person_name of this AccountManagementServiceClient.

        <div lang=\"ja\"> 広告主の担当者氏名です。<br> このフィールドは、ADD時に省略可能となり、SET時に無視されます。 </div> <div lang=\"en\"> Client person name.<br> This field is optional in ADD operation, and will be ignored in SET operation. </div>   # noqa: E501

        :param client_person_name: The client_person_name of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._client_person_name = client_person_name

    @property
    def company_name(self):
        """Gets the company_name of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 広告主名です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Company name.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations.</div>   # noqa: E501

        :return: The company_name of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._company_name

    @company_name.setter
    def company_name(self, company_name):
        """Sets the company_name of this AccountManagementServiceClient.

        <div lang=\"ja\"> 広告主名です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Company name.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations.</div>   # noqa: E501

        :param company_name: The company_name of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._company_name = company_name

    @property
    def company_name_kana(self):
        """Gets the company_name_kana of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 広告主名カナです。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Kana characters of company name.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :return: The company_name_kana of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._company_name_kana

    @company_name_kana.setter
    def company_name_kana(self, company_name_kana):
        """Sets the company_name_kana of this AccountManagementServiceClient.

        <div lang=\"ja\"> 広告主名カナです。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Kana characters of company name.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :param company_name_kana: The company_name_kana of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._company_name_kana = company_name_kana

    @property
    def enterprise_type(self):
        """Gets the enterprise_type of this AccountManagementServiceClient.  # noqa: E501


        :return: The enterprise_type of this AccountManagementServiceClient.  # noqa: E501
        :rtype: AccountManagementServiceEnterpriseType
        """
        return self._enterprise_type

    @enterprise_type.setter
    def enterprise_type(self, enterprise_type):
        """Sets the enterprise_type of this AccountManagementServiceClient.


        :param enterprise_type: The enterprise_type of this AccountManagementServiceClient.  # noqa: E501
        :type: AccountManagementServiceEnterpriseType
        """

        self._enterprise_type = enterprise_type

    @property
    def enterprise_type_position(self):
        """Gets the enterprise_type_position of this AccountManagementServiceClient.  # noqa: E501


        :return: The enterprise_type_position of this AccountManagementServiceClient.  # noqa: E501
        :rtype: AccountManagementServiceEnterpriseTypePosition
        """
        return self._enterprise_type_position

    @enterprise_type_position.setter
    def enterprise_type_position(self, enterprise_type_position):
        """Sets the enterprise_type_position of this AccountManagementServiceClient.


        :param enterprise_type_position: The enterprise_type_position of this AccountManagementServiceClient.  # noqa: E501
        :type: AccountManagementServiceEnterpriseTypePosition
        """

        self._enterprise_type_position = enterprise_type_position

    @property
    def phone_number(self):
        """Gets the phone_number of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 電話番号です。<br> ※xxxxx-xxxxx-xxxxx形式です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Phone number.<br> * In xxxxx-xxxxx-xxxxx format.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :return: The phone_number of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this AccountManagementServiceClient.

        <div lang=\"ja\"> 電話番号です。<br> ※xxxxx-xxxxx-xxxxx形式です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Phone number.<br> * In xxxxx-xxxxx-xxxxx format.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :param phone_number: The phone_number of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                phone_number is not None and not re.search(r'^\d{1,5}-\d{1,5}-\d{1,5}$', phone_number)):  # noqa: E501
            raise ValueError(r"Invalid value for `phone_number`, must be a follow pattern or equal to `/^\d{1,5}-\d{1,5}-\d{1,5}$/`")  # noqa: E501

        self._phone_number = phone_number

    @property
    def prefecture_code(self):
        """Gets the prefecture_code of this AccountManagementServiceClient.  # noqa: E501


        :return: The prefecture_code of this AccountManagementServiceClient.  # noqa: E501
        :rtype: AccountManagementServicePrefectureCode
        """
        return self._prefecture_code

    @prefecture_code.setter
    def prefecture_code(self, prefecture_code):
        """Sets the prefecture_code of this AccountManagementServiceClient.


        :param prefecture_code: The prefecture_code of this AccountManagementServiceClient.  # noqa: E501
        :type: AccountManagementServicePrefectureCode
        """

        self._prefecture_code = prefecture_code

    @property
    def street1(self):
        """Gets the street1 of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 町・字名です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Street1.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :return: The street1 of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._street1

    @street1.setter
    def street1(self, street1):
        """Sets the street1 of this AccountManagementServiceClient.

        <div lang=\"ja\"> 町・字名です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Street1.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :param street1: The street1 of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._street1 = street1

    @property
    def street2(self):
        """Gets the street2 of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 丁目・番地・号です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Street2.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :return: The street2 of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._street2

    @street2.setter
    def street2(self, street2):
        """Sets the street2 of this AccountManagementServiceClient.

        <div lang=\"ja\"> 丁目・番地・号です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Street2.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :param street2: The street2 of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._street2 = street2

    @property
    def url(self):
        """Gets the url of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 広告掲載を希望するサイトのURLです。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。 </div> <div lang=\"en\"> Site URL for placing advertisement.<br> This field is required in ADD operation, and will be ignored in SET operation. </div>   # noqa: E501

        :return: The url of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this AccountManagementServiceClient.

        <div lang=\"ja\"> 広告掲載を希望するサイトのURLです。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。 </div> <div lang=\"en\"> Site URL for placing advertisement.<br> This field is required in ADD operation, and will be ignored in SET operation. </div>   # noqa: E501

        :param url: The url of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def url_type(self):
        """Gets the url_type of this AccountManagementServiceClient.  # noqa: E501


        :return: The url_type of this AccountManagementServiceClient.  # noqa: E501
        :rtype: AccountManagementServiceUrlType
        """
        return self._url_type

    @url_type.setter
    def url_type(self, url_type):
        """Sets the url_type of this AccountManagementServiceClient.


        :param url_type: The url_type of this AccountManagementServiceClient.  # noqa: E501
        :type: AccountManagementServiceUrlType
        """

        self._url_type = url_type

    @property
    def zip(self):
        """Gets the zip of this AccountManagementServiceClient.  # noqa: E501

        <div lang=\"ja\"> 郵便番号です。<br> ※xxx-xxxx形式です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Zip code.<br> * In xxx-xxxx format.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :return: The zip of this AccountManagementServiceClient.  # noqa: E501
        :rtype: str
        """
        return self._zip

    @zip.setter
    def zip(self, zip):
        """Sets the zip of this AccountManagementServiceClient.

        <div lang=\"ja\"> 郵便番号です。<br> ※xxx-xxxx形式です。<br> このフィールドは、ADD時に必須となり、SET時に無視されます。<br> ※clientTypeがSELFの場合は、ADD時、SET時ともに無視されます。 </div> <div lang=\"en\"> Zip code.<br> * In xxx-xxxx format.<br> This field is required in ADD operation, and will be ignored in SET operation.<br> * When clientType is \"SELF\", this field will be ignored in ADD and SET operations. </div>   # noqa: E501

        :param zip: The zip of this AccountManagementServiceClient.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                zip is not None and not re.search(r'^\d{3}-\d{4}$', zip)):  # noqa: E501
            raise ValueError(r"Invalid value for `zip`, must be a follow pattern or equal to `/^\d{3}-\d{4}$/`")  # noqa: E501

        self._zip = zip

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountManagementServiceClient):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccountManagementServiceClient):
            return True

        return self.to_dict() != other.to_dict()
