# coding: utf-8

"""
    Yahoo!広告 ディスプレイ広告 API リファレンス / Yahoo! JAPAN Ads Display Ads API Reference

    <div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div> <div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div> <div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div> <div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div> <div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>   # noqa: E501

    The version of the OpenAPI document: v6
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from yahoo_display_api.api_client import ApiClient
from yahoo_display_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RetargetingListServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def retargeting_list_service_add_post(self, **kwargs):  # noqa: E501
        """retargeting_list_service_add_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを作成します。</div> <div lang=\"en\">Create the target list for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_add_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceOperation retargeting_list_service_operation:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RetargetingListServiceMutateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retargeting_list_service_add_post_with_http_info(**kwargs)  # noqa: E501

    def retargeting_list_service_add_post_with_http_info(self, **kwargs):  # noqa: E501
        """retargeting_list_service_add_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを作成します。</div> <div lang=\"en\">Create the target list for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_add_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceOperation retargeting_list_service_operation:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RetargetingListServiceMutateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'retargeting_list_service_operation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retargeting_list_service_add_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'retargeting_list_service_operation' in local_var_params:
            body_params = local_var_params['retargeting_list_service_operation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/RetargetingListService/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RetargetingListServiceMutateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retargeting_list_service_get_post(self, **kwargs):  # noqa: E501
        """retargeting_list_service_get_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを取得します。</div> <div lang=\"en\">Retrieve target list information for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_get_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceSelector retargeting_list_service_selector:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RetargetingListServiceGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retargeting_list_service_get_post_with_http_info(**kwargs)  # noqa: E501

    def retargeting_list_service_get_post_with_http_info(self, **kwargs):  # noqa: E501
        """retargeting_list_service_get_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを取得します。</div> <div lang=\"en\">Retrieve target list information for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_get_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceSelector retargeting_list_service_selector:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RetargetingListServiceGetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'retargeting_list_service_selector'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retargeting_list_service_get_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'retargeting_list_service_selector' in local_var_params:
            body_params = local_var_params['retargeting_list_service_selector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/RetargetingListService/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RetargetingListServiceGetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retargeting_list_service_get_upload_user_list_status_post(self, **kwargs):  # noqa: E501
        """retargeting_list_service_get_upload_user_list_status_post  # noqa: E501

        <div lang=\"ja\">ユーザリストのアップロード状況を取得します。</div> <div lang=\"en\">This acquires the upload status of the user list.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_get_upload_user_list_status_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceUploadUserListStatusSelector retargeting_list_service_upload_user_list_status_selector:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RetargetingListServiceGetUploadUserListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retargeting_list_service_get_upload_user_list_status_post_with_http_info(**kwargs)  # noqa: E501

    def retargeting_list_service_get_upload_user_list_status_post_with_http_info(self, **kwargs):  # noqa: E501
        """retargeting_list_service_get_upload_user_list_status_post  # noqa: E501

        <div lang=\"ja\">ユーザリストのアップロード状況を取得します。</div> <div lang=\"en\">This acquires the upload status of the user list.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_get_upload_user_list_status_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceUploadUserListStatusSelector retargeting_list_service_upload_user_list_status_selector:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RetargetingListServiceGetUploadUserListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'retargeting_list_service_upload_user_list_status_selector'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retargeting_list_service_get_upload_user_list_status_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'retargeting_list_service_upload_user_list_status_selector' in local_var_params:
            body_params = local_var_params['retargeting_list_service_upload_user_list_status_selector']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/RetargetingListService/getUploadUserListStatus', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RetargetingListServiceGetUploadUserListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retargeting_list_service_remove_post(self, **kwargs):  # noqa: E501
        """retargeting_list_service_remove_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを削除します。</div> <div lang=\"en\">Deletes target list for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_remove_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceOperation retargeting_list_service_operation:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RetargetingListServiceMutateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retargeting_list_service_remove_post_with_http_info(**kwargs)  # noqa: E501

    def retargeting_list_service_remove_post_with_http_info(self, **kwargs):  # noqa: E501
        """retargeting_list_service_remove_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを削除します。</div> <div lang=\"en\">Deletes target list for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_remove_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceOperation retargeting_list_service_operation:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RetargetingListServiceMutateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'retargeting_list_service_operation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retargeting_list_service_remove_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'retargeting_list_service_operation' in local_var_params:
            body_params = local_var_params['retargeting_list_service_operation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/RetargetingListService/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RetargetingListServiceMutateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retargeting_list_service_set_post(self, **kwargs):  # noqa: E501
        """retargeting_list_service_set_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを更新します。</div> <div lang=\"en\">Updates target list for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_set_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceOperation retargeting_list_service_operation:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RetargetingListServiceMutateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retargeting_list_service_set_post_with_http_info(**kwargs)  # noqa: E501

    def retargeting_list_service_set_post_with_http_info(self, **kwargs):  # noqa: E501
        """retargeting_list_service_set_post  # noqa: E501

        <div lang=\"ja\">サイトリターゲティングのターゲットリストを更新します。</div> <div lang=\"en\">Updates target list for site retargeting.</div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_set_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param RetargetingListServiceOperation retargeting_list_service_operation:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RetargetingListServiceMutateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'retargeting_list_service_operation'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retargeting_list_service_set_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'retargeting_list_service_operation' in local_var_params:
            body_params = local_var_params['retargeting_list_service_operation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/RetargetingListService/set', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RetargetingListServiceMutateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retargeting_list_service_upload_user_list_post(self, account_id, retargeting_tag_id, target_list_id, upload_type, compress_type, **kwargs):  # noqa: E501
        """retargeting_list_service_upload_user_list_post  # noqa: E501

        <div lang=\"ja\">   カスタムリストのユーザリストファイルをアップロードします。<br/>   アップロードリクエストでは以下を指定します。<br/>   テストアカウントでは利用頂けない機能です。   <ul>     <li>・Content-Type: application/octet-stream（非圧縮形式の場合はtext/plain指定も可能）</li>     <li>・Content-Length: アップロード対象のファイルのバイト数</li>     <li>・Request body: アップロードするユーザーリストのファイル本体</li>   </ul>   Transfer-encoding: chunkedを指定してのアップロードには対応していません。<br/>   また、アップロードするファイルの制限は下記の通りです。   <ul>     <li>・UTF8、BOMなし、正規化形式</li>     <li>・ユーザーIDごとに改行</li>     <li>・改行コードLF</li>     <li>・ファイルサイズ上限1GB(1,073,741,824 byte)</li>   </ul> </div> <div lang=\"en\">   Upload the user list file for the custom list.<br/>   Specify the following in the upload request.<br/>   The action is unavailable for test account.   <ul>     <li>* Content-Type: application/octet-stream (text/plain can also be specified for uncompressed format)</li>     <li>* Content-Length: Number of bytes in the file to be uploaded</li>     <li>* Request body: File body of the user list to upload</li>   </ul>   Uploading with chunked specified for Transfer-encoding is not supported.<br/>   The following is the file upload limit.   <ul>     <li>* UTF8, no BOM, canonicalized form.</li>     <li>* Line break for each user ID</li>     <li>* Line feed code LF</li>     <li>* File size upper limit 1GB(1,073,741,824 byte)</li>   </ul> </div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_upload_user_list_post(account_id, retargeting_tag_id, target_list_id, upload_type, compress_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int account_id: <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>  (required)
        :param str retargeting_tag_id: <div lang=\"ja\">サイトリターゲティングのタグIDです。</div> <div lang=\"en\">Tag ID for site retargeting.</div>  (required)
        :param int target_list_id: <div lang=\"ja\">カスタムオーディエンスのターゲットリストIDです。</div> <div lang=\"en\">Target list ID for the custom audience.</div>  (required)
        :param RetargetingListServiceUploadUserListUploadType upload_type: <div lang=\"ja\">   RetargetingListServiceUploadUserListUploadTypeは、アップロードする方法の種類を表します。<br>   ハッシュ化メールアドレスの詳細については、<a href=\"https://ads-help.yahoo.co.jp/yahooads/display/articledetail?lan=ja&aid=69234\">ヘルプ</a>をご参照ください。 </div> <div lang=\"en\">   RetargetingListServiceUploadUserListUploadType displays kind of upload method.<br>   Refer to <a href=\"https://ads-help.yahoo.co.jp/yahooads/display/articledetail?lan=en&aid=37704\">Help page</a> for more details about hashed Email Address. </div> </div> <dl class=term>   <dt class=\"term__item\"><code>IDFA</dt>   <dd class=\"term__desc\"><span lang=\"ja\">iOS端末用広告識別子です。</span><span lang=\"en\">Ad identifier for iOS devices.</span></dd>   <dt class=\"term__item\"><code>AAID</dt>   <dd class=\"term__desc\"><span lang=\"ja\">Android端末用広告識別子です。</span><span lang=\"en\">Ad identifier for Android devices.</span></dd>   <dt class=\"term__item\"><code>MAIL_ADDRESS</dt>   <dd class=\"term__desc\"><span lang=\"ja\">ハッシュ化メールアドレスです。</span><span lang=\"en\">Hashed email address.</span></dd>   <dt class=\"term__item\"><code>UNKNOWN</dt>   <dd class=\"term__desc\"><span lang=\"ja\">未知の値です。</span><span lang=\"en\">Unknown Value</span></dd> </dl>  (required)
        :param RetargetingListServiceUploadUserListCompressType compress_type: <div lang=\"ja\">RetargetingListServiceUploadUserListCompressTypeは、アップロードするファイルの圧縮形式を表します。</div> <div lang=\"en\">RetargetingListServiceUploadUserListCompressType displays kind of compress type of upload file.</div> <dl class=term>   <dt class=\"term__item\"><code>NONE</dt>   <dd class=\"term__desc\"><span lang=\"ja\">非圧縮形式です。</span><span lang=\"en\">Uncompressed format.</span></dd>   <dt class=\"term__item\"><code>ZIP</dt>   <dd class=\"term__desc\"><span lang=\"ja\">ZIP形式です。</span><span lang=\"en\">ZIP format. </span></dd>   <dt class=\"term__item\"><code>GZIP</dt>   <dd class=\"term__desc\"><span lang=\"ja\">GZIP形式です。</span><span lang=\"en\">GZIP format.</span></dd>   <dt class=\"term__item\"><code>UNKNOWN</dt>   <dd class=\"term__desc\"><span lang=\"ja\">未知の値です。</span><span lang=\"en\">Unknown Value</span></dd> </dl>  (required)
        :param str custom_uid_key: <div lang=\"ja\">   任意のユーザー識別子同期タグで設定した任意のユーザー識別子の名前を入力してください。   ※他社DMPなど外部サービスから連携する場合は、ユーザー識別子提供元の指定に従ってください。 </div> <div lang=\"en\">   Input the any user identifier name set in the any user identifier sync tag.   * When linking from an external service such as DMP of another company, set according to the specifications of the user identifier provider. </div> 
        :param str custom_entity_id: <div lang=\"ja\">   通常は入力不要です。   ※他社DMPなど外部サービスから連携する場合は、ユーザー識別子提供元の指定に従ってください。 </div> <div lang=\"en\">   Input is not required normally.   * When linking from an external service such as DMP of another company, set according to the specifications of the user identifier provider. </div> 
        :param file body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RetargetingListServiceUploadUserListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.retargeting_list_service_upload_user_list_post_with_http_info(account_id, retargeting_tag_id, target_list_id, upload_type, compress_type, **kwargs)  # noqa: E501

    def retargeting_list_service_upload_user_list_post_with_http_info(self, account_id, retargeting_tag_id, target_list_id, upload_type, compress_type, **kwargs):  # noqa: E501
        """retargeting_list_service_upload_user_list_post  # noqa: E501

        <div lang=\"ja\">   カスタムリストのユーザリストファイルをアップロードします。<br/>   アップロードリクエストでは以下を指定します。<br/>   テストアカウントでは利用頂けない機能です。   <ul>     <li>・Content-Type: application/octet-stream（非圧縮形式の場合はtext/plain指定も可能）</li>     <li>・Content-Length: アップロード対象のファイルのバイト数</li>     <li>・Request body: アップロードするユーザーリストのファイル本体</li>   </ul>   Transfer-encoding: chunkedを指定してのアップロードには対応していません。<br/>   また、アップロードするファイルの制限は下記の通りです。   <ul>     <li>・UTF8、BOMなし、正規化形式</li>     <li>・ユーザーIDごとに改行</li>     <li>・改行コードLF</li>     <li>・ファイルサイズ上限1GB(1,073,741,824 byte)</li>   </ul> </div> <div lang=\"en\">   Upload the user list file for the custom list.<br/>   Specify the following in the upload request.<br/>   The action is unavailable for test account.   <ul>     <li>* Content-Type: application/octet-stream (text/plain can also be specified for uncompressed format)</li>     <li>* Content-Length: Number of bytes in the file to be uploaded</li>     <li>* Request body: File body of the user list to upload</li>   </ul>   Uploading with chunked specified for Transfer-encoding is not supported.<br/>   The following is the file upload limit.   <ul>     <li>* UTF8, no BOM, canonicalized form.</li>     <li>* Line break for each user ID</li>     <li>* Line feed code LF</li>     <li>* File size upper limit 1GB(1,073,741,824 byte)</li>   </ul> </div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retargeting_list_service_upload_user_list_post_with_http_info(account_id, retargeting_tag_id, target_list_id, upload_type, compress_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int account_id: <div lang=\"ja\">アカウントIDです。</div> <div lang=\"en\">Account ID.</div>  (required)
        :param str retargeting_tag_id: <div lang=\"ja\">サイトリターゲティングのタグIDです。</div> <div lang=\"en\">Tag ID for site retargeting.</div>  (required)
        :param int target_list_id: <div lang=\"ja\">カスタムオーディエンスのターゲットリストIDです。</div> <div lang=\"en\">Target list ID for the custom audience.</div>  (required)
        :param RetargetingListServiceUploadUserListUploadType upload_type: <div lang=\"ja\">   RetargetingListServiceUploadUserListUploadTypeは、アップロードする方法の種類を表します。<br>   ハッシュ化メールアドレスの詳細については、<a href=\"https://ads-help.yahoo.co.jp/yahooads/display/articledetail?lan=ja&aid=69234\">ヘルプ</a>をご参照ください。 </div> <div lang=\"en\">   RetargetingListServiceUploadUserListUploadType displays kind of upload method.<br>   Refer to <a href=\"https://ads-help.yahoo.co.jp/yahooads/display/articledetail?lan=en&aid=37704\">Help page</a> for more details about hashed Email Address. </div> </div> <dl class=term>   <dt class=\"term__item\"><code>IDFA</dt>   <dd class=\"term__desc\"><span lang=\"ja\">iOS端末用広告識別子です。</span><span lang=\"en\">Ad identifier for iOS devices.</span></dd>   <dt class=\"term__item\"><code>AAID</dt>   <dd class=\"term__desc\"><span lang=\"ja\">Android端末用広告識別子です。</span><span lang=\"en\">Ad identifier for Android devices.</span></dd>   <dt class=\"term__item\"><code>MAIL_ADDRESS</dt>   <dd class=\"term__desc\"><span lang=\"ja\">ハッシュ化メールアドレスです。</span><span lang=\"en\">Hashed email address.</span></dd>   <dt class=\"term__item\"><code>UNKNOWN</dt>   <dd class=\"term__desc\"><span lang=\"ja\">未知の値です。</span><span lang=\"en\">Unknown Value</span></dd> </dl>  (required)
        :param RetargetingListServiceUploadUserListCompressType compress_type: <div lang=\"ja\">RetargetingListServiceUploadUserListCompressTypeは、アップロードするファイルの圧縮形式を表します。</div> <div lang=\"en\">RetargetingListServiceUploadUserListCompressType displays kind of compress type of upload file.</div> <dl class=term>   <dt class=\"term__item\"><code>NONE</dt>   <dd class=\"term__desc\"><span lang=\"ja\">非圧縮形式です。</span><span lang=\"en\">Uncompressed format.</span></dd>   <dt class=\"term__item\"><code>ZIP</dt>   <dd class=\"term__desc\"><span lang=\"ja\">ZIP形式です。</span><span lang=\"en\">ZIP format. </span></dd>   <dt class=\"term__item\"><code>GZIP</dt>   <dd class=\"term__desc\"><span lang=\"ja\">GZIP形式です。</span><span lang=\"en\">GZIP format.</span></dd>   <dt class=\"term__item\"><code>UNKNOWN</dt>   <dd class=\"term__desc\"><span lang=\"ja\">未知の値です。</span><span lang=\"en\">Unknown Value</span></dd> </dl>  (required)
        :param str custom_uid_key: <div lang=\"ja\">   任意のユーザー識別子同期タグで設定した任意のユーザー識別子の名前を入力してください。   ※他社DMPなど外部サービスから連携する場合は、ユーザー識別子提供元の指定に従ってください。 </div> <div lang=\"en\">   Input the any user identifier name set in the any user identifier sync tag.   * When linking from an external service such as DMP of another company, set according to the specifications of the user identifier provider. </div> 
        :param str custom_entity_id: <div lang=\"ja\">   通常は入力不要です。   ※他社DMPなど外部サービスから連携する場合は、ユーザー識別子提供元の指定に従ってください。 </div> <div lang=\"en\">   Input is not required normally.   * When linking from an external service such as DMP of another company, set according to the specifications of the user identifier provider. </div> 
        :param file body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RetargetingListServiceUploadUserListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'account_id',
            'retargeting_tag_id',
            'target_list_id',
            'upload_type',
            'compress_type',
            'custom_uid_key',
            'custom_entity_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retargeting_list_service_upload_user_list_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['account_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `account_id` when calling `retargeting_list_service_upload_user_list_post`")  # noqa: E501
        # verify the required parameter 'retargeting_tag_id' is set
        if self.api_client.client_side_validation and ('retargeting_tag_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['retargeting_tag_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `retargeting_tag_id` when calling `retargeting_list_service_upload_user_list_post`")  # noqa: E501
        # verify the required parameter 'target_list_id' is set
        if self.api_client.client_side_validation and ('target_list_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['target_list_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `target_list_id` when calling `retargeting_list_service_upload_user_list_post`")  # noqa: E501
        # verify the required parameter 'upload_type' is set
        if self.api_client.client_side_validation and ('upload_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['upload_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upload_type` when calling `retargeting_list_service_upload_user_list_post`")  # noqa: E501
        # verify the required parameter 'compress_type' is set
        if self.api_client.client_side_validation and ('compress_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['compress_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `compress_type` when calling `retargeting_list_service_upload_user_list_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'account_id' in local_var_params and local_var_params['account_id'] is not None:  # noqa: E501
            query_params.append(('accountId', local_var_params['account_id']))  # noqa: E501
        if 'retargeting_tag_id' in local_var_params and local_var_params['retargeting_tag_id'] is not None:  # noqa: E501
            query_params.append(('retargetingTagId', local_var_params['retargeting_tag_id']))  # noqa: E501
        if 'target_list_id' in local_var_params and local_var_params['target_list_id'] is not None:  # noqa: E501
            query_params.append(('targetListId', local_var_params['target_list_id']))  # noqa: E501
        if 'upload_type' in local_var_params and local_var_params['upload_type'] is not None:  # noqa: E501
            query_params.append(('uploadType', local_var_params['upload_type']))  # noqa: E501
        if 'compress_type' in local_var_params and local_var_params['compress_type'] is not None:  # noqa: E501
            query_params.append(('compressType', local_var_params['compress_type']))  # noqa: E501
        if 'custom_uid_key' in local_var_params and local_var_params['custom_uid_key'] is not None:  # noqa: E501
            query_params.append(('customUidKey', local_var_params['custom_uid_key']))  # noqa: E501
        if 'custom_entity_id' in local_var_params and local_var_params['custom_entity_id'] is not None:  # noqa: E501
            query_params.append(('customEntityId', local_var_params['custom_entity_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth']  # noqa: E501

        return self.api_client.call_api(
            '/RetargetingListService/uploadUserList', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RetargetingListServiceUploadUserListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
