# openapi-client
<div lang=\"ja\">Yahoo!広告 ディスプレイ広告 APIのWebサービスについて説明します。</div>
<div lang=\"en\">Display Ads API Web Services supported in Yahoo! JAPAN Ads API.</div>
<div><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/design/v6/Route.yaml\">OpenAPI Specification</a></div>
<div lang=\"ja\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/ja\">Best Practice</a></div>
<div lang=\"en\"><a target=\"_blank\" href=\"https://github.com/yahoojp-marketing/ads-display-api-documents/blob/master/bestpractice/en\">Best Practice</a></div>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v6
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import yahoo_display_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import yahoo_display_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import yahoo_display_api
from yahoo_display_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://ads-display.yahooapis.jp/api/v6
# See configuration.py for a list of all supported configuration parameters.
configuration = yahoo_display_api.Configuration(
    host = "https://ads-display.yahooapis.jp/api/v6"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oAuth
configuration = yahoo_display_api.Configuration(
    host = "https://ads-display.yahooapis.jp/api/v6"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with yahoo_display_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = yahoo_display_api.AccountAuthorityServiceApi(api_client)
    account_authority_service_selector = yahoo_display_api.AccountAuthorityServiceSelector() # AccountAuthorityServiceSelector |  (optional)

    try:
        api_response = api_instance.account_authority_service_get_post(account_authority_service_selector=account_authority_service_selector)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccountAuthorityServiceApi->account_authority_service_get_post: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://ads-display.yahooapis.jp/api/v6*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountAuthorityServiceApi* | [**account_authority_service_get_post**](docs/AccountAuthorityServiceApi.md#account_authority_service_get_post) | **POST** /AccountAuthorityService/get | 
*AccountLinkServiceApi* | [**account_link_service_get_post**](docs/AccountLinkServiceApi.md#account_link_service_get_post) | **POST** /AccountLinkService/get | 
*AccountManagementServiceApi* | [**account_management_service_add_post**](docs/AccountManagementServiceApi.md#account_management_service_add_post) | **POST** /AccountManagementService/add | 
*AccountManagementServiceApi* | [**account_management_service_get_post**](docs/AccountManagementServiceApi.md#account_management_service_get_post) | **POST** /AccountManagementService/get | 
*AccountManagementServiceApi* | [**account_management_service_set_post**](docs/AccountManagementServiceApi.md#account_management_service_set_post) | **POST** /AccountManagementService/set | 
*AccountServiceApi* | [**account_service_get_post**](docs/AccountServiceApi.md#account_service_get_post) | **POST** /AccountService/get | 
*AccountServiceApi* | [**account_service_set_post**](docs/AccountServiceApi.md#account_service_set_post) | **POST** /AccountService/set | 
*AccountTrackingUrlServiceApi* | [**account_tracking_url_service_get_post**](docs/AccountTrackingUrlServiceApi.md#account_tracking_url_service_get_post) | **POST** /AccountTrackingUrlService/get | 
*AccountTrackingUrlServiceApi* | [**account_tracking_url_service_set_post**](docs/AccountTrackingUrlServiceApi.md#account_tracking_url_service_set_post) | **POST** /AccountTrackingUrlService/set | 
*AdGroupAdLabelServiceApi* | [**ad_group_ad_label_service_add_post**](docs/AdGroupAdLabelServiceApi.md#ad_group_ad_label_service_add_post) | **POST** /AdGroupAdLabelService/add | 
*AdGroupAdLabelServiceApi* | [**ad_group_ad_label_service_remove_post**](docs/AdGroupAdLabelServiceApi.md#ad_group_ad_label_service_remove_post) | **POST** /AdGroupAdLabelService/remove | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_add_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_add_post) | **POST** /AdGroupAdService/add | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_get_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_get_post) | **POST** /AdGroupAdService/get | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_remove_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_remove_post) | **POST** /AdGroupAdService/remove | 
*AdGroupAdServiceApi* | [**ad_group_ad_service_set_post**](docs/AdGroupAdServiceApi.md#ad_group_ad_service_set_post) | **POST** /AdGroupAdService/set | 
*AdGroupLabelServiceApi* | [**ad_group_label_service_add_post**](docs/AdGroupLabelServiceApi.md#ad_group_label_service_add_post) | **POST** /AdGroupLabelService/add | 
*AdGroupLabelServiceApi* | [**ad_group_label_service_remove_post**](docs/AdGroupLabelServiceApi.md#ad_group_label_service_remove_post) | **POST** /AdGroupLabelService/remove | 
*AdGroupServiceApi* | [**ad_group_service_add_post**](docs/AdGroupServiceApi.md#ad_group_service_add_post) | **POST** /AdGroupService/add | 
*AdGroupServiceApi* | [**ad_group_service_get_post**](docs/AdGroupServiceApi.md#ad_group_service_get_post) | **POST** /AdGroupService/get | 
*AdGroupServiceApi* | [**ad_group_service_remove_post**](docs/AdGroupServiceApi.md#ad_group_service_remove_post) | **POST** /AdGroupService/remove | 
*AdGroupServiceApi* | [**ad_group_service_set_post**](docs/AdGroupServiceApi.md#ad_group_service_set_post) | **POST** /AdGroupService/set | 
*AdGroupTargetServiceApi* | [**ad_group_target_service_add_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_add_post) | **POST** /AdGroupTargetService/add | 
*AdGroupTargetServiceApi* | [**ad_group_target_service_get_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_get_post) | **POST** /AdGroupTargetService/get | 
*AdGroupTargetServiceApi* | [**ad_group_target_service_remove_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_remove_post) | **POST** /AdGroupTargetService/remove | 
*AdGroupTargetServiceApi* | [**ad_group_target_service_replace_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_replace_post) | **POST** /AdGroupTargetService/replace | 
*AdGroupTargetServiceApi* | [**ad_group_target_service_set_post**](docs/AdGroupTargetServiceApi.md#ad_group_target_service_set_post) | **POST** /AdGroupTargetService/set | 
*AuditLogServiceApi* | [**audit_log_service_add_post**](docs/AuditLogServiceApi.md#audit_log_service_add_post) | **POST** /AuditLogService/add | 
*AuditLogServiceApi* | [**audit_log_service_download_post**](docs/AuditLogServiceApi.md#audit_log_service_download_post) | **POST** /AuditLogService/download | 
*AuditLogServiceApi* | [**audit_log_service_get_post**](docs/AuditLogServiceApi.md#audit_log_service_get_post) | **POST** /AuditLogService/get | 
*BalanceServiceApi* | [**balance_service_get_post**](docs/BalanceServiceApi.md#balance_service_get_post) | **POST** /BalanceService/get | 
*BrandLiftServiceApi* | [**brand_lift_service_get_post**](docs/BrandLiftServiceApi.md#brand_lift_service_get_post) | **POST** /BrandLiftService/get | 
*BudgetOrderServiceApi* | [**budget_order_service_get_post**](docs/BudgetOrderServiceApi.md#budget_order_service_get_post) | **POST** /BudgetOrderService/get | 
*BudgetOrderServiceApi* | [**budget_order_service_set_post**](docs/BudgetOrderServiceApi.md#budget_order_service_set_post) | **POST** /BudgetOrderService/set | 
*CampaignLabelServiceApi* | [**campaign_label_service_add_post**](docs/CampaignLabelServiceApi.md#campaign_label_service_add_post) | **POST** /CampaignLabelService/add | 
*CampaignLabelServiceApi* | [**campaign_label_service_remove_post**](docs/CampaignLabelServiceApi.md#campaign_label_service_remove_post) | **POST** /CampaignLabelService/remove | 
*CampaignServiceApi* | [**campaign_service_add_post**](docs/CampaignServiceApi.md#campaign_service_add_post) | **POST** /CampaignService/add | 
*CampaignServiceApi* | [**campaign_service_get_post**](docs/CampaignServiceApi.md#campaign_service_get_post) | **POST** /CampaignService/get | 
*CampaignServiceApi* | [**campaign_service_remove_post**](docs/CampaignServiceApi.md#campaign_service_remove_post) | **POST** /CampaignService/remove | 
*CampaignServiceApi* | [**campaign_service_set_post**](docs/CampaignServiceApi.md#campaign_service_set_post) | **POST** /CampaignService/set | 
*ContentsKeywordIdeaServiceApi* | [**contents_keyword_idea_service_get_post**](docs/ContentsKeywordIdeaServiceApi.md#contents_keyword_idea_service_get_post) | **POST** /ContentsKeywordIdeaService/get | 
*ContentsKeywordListServiceApi* | [**contents_keyword_list_service_add_post**](docs/ContentsKeywordListServiceApi.md#contents_keyword_list_service_add_post) | **POST** /ContentsKeywordListService/add | 
*ContentsKeywordListServiceApi* | [**contents_keyword_list_service_get_post**](docs/ContentsKeywordListServiceApi.md#contents_keyword_list_service_get_post) | **POST** /ContentsKeywordListService/get | 
*ContentsKeywordListServiceApi* | [**contents_keyword_list_service_remove_post**](docs/ContentsKeywordListServiceApi.md#contents_keyword_list_service_remove_post) | **POST** /ContentsKeywordListService/remove | 
*ContentsKeywordListServiceApi* | [**contents_keyword_list_service_set_post**](docs/ContentsKeywordListServiceApi.md#contents_keyword_list_service_set_post) | **POST** /ContentsKeywordListService/set | 
*ConversionGroupServiceApi* | [**conversion_group_service_add_post**](docs/ConversionGroupServiceApi.md#conversion_group_service_add_post) | **POST** /ConversionGroupService/add | 
*ConversionGroupServiceApi* | [**conversion_group_service_get_post**](docs/ConversionGroupServiceApi.md#conversion_group_service_get_post) | **POST** /ConversionGroupService/get | 
*ConversionGroupServiceApi* | [**conversion_group_service_remove_post**](docs/ConversionGroupServiceApi.md#conversion_group_service_remove_post) | **POST** /ConversionGroupService/remove | 
*ConversionGroupServiceApi* | [**conversion_group_service_set_post**](docs/ConversionGroupServiceApi.md#conversion_group_service_set_post) | **POST** /ConversionGroupService/set | 
*ConversionTrackerServiceApi* | [**conversion_tracker_service_add_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_add_post) | **POST** /ConversionTrackerService/add | 
*ConversionTrackerServiceApi* | [**conversion_tracker_service_get_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_get_post) | **POST** /ConversionTrackerService/get | 
*ConversionTrackerServiceApi* | [**conversion_tracker_service_set_post**](docs/ConversionTrackerServiceApi.md#conversion_tracker_service_set_post) | **POST** /ConversionTrackerService/set | 
*DictionaryServiceApi* | [**dictionary_service_get_audience_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_audience_category_post) | **POST** /DictionaryService/getAudienceCategory | 
*DictionaryServiceApi* | [**dictionary_service_get_business_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_business_category_post) | **POST** /DictionaryService/getBusinessCategory | 
*DictionaryServiceApi* | [**dictionary_service_get_disapproval_reason_post**](docs/DictionaryServiceApi.md#dictionary_service_get_disapproval_reason_post) | **POST** /DictionaryService/getDisapprovalReason | 
*DictionaryServiceApi* | [**dictionary_service_get_feed_item_google_product_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_feed_item_google_product_category_post) | **POST** /DictionaryService/getFeedItemGoogleProductCategory | 
*DictionaryServiceApi* | [**dictionary_service_get_geographic_location_post**](docs/DictionaryServiceApi.md#dictionary_service_get_geographic_location_post) | **POST** /DictionaryService/getGeographicLocation | 
*DictionaryServiceApi* | [**dictionary_service_get_media_ad_format_post**](docs/DictionaryServiceApi.md#dictionary_service_get_media_ad_format_post) | **POST** /DictionaryService/getMediaAdFormat | 
*DictionaryServiceApi* | [**dictionary_service_get_os_version_post**](docs/DictionaryServiceApi.md#dictionary_service_get_os_version_post) | **POST** /DictionaryService/getOsVersion | 
*DictionaryServiceApi* | [**dictionary_service_get_site_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_site_category_post) | **POST** /DictionaryService/getSiteCategory | 
*DictionaryServiceApi* | [**dictionary_service_get_station_placement_category_post**](docs/DictionaryServiceApi.md#dictionary_service_get_station_placement_category_post) | **POST** /DictionaryService/getStationPlacementCategory | 
*DictionaryServiceApi* | [**dictionary_service_get_third_party_tracking_domain_post**](docs/DictionaryServiceApi.md#dictionary_service_get_third_party_tracking_domain_post) | **POST** /DictionaryService/getThirdPartyTrackingDomain | 
*FeedDataServiceApi* | [**feed_data_service_download_error_file_post**](docs/FeedDataServiceApi.md#feed_data_service_download_error_file_post) | **POST** /FeedDataService/downloadErrorFile | 
*FeedDataServiceApi* | [**feed_data_service_get_post**](docs/FeedDataServiceApi.md#feed_data_service_get_post) | **POST** /FeedDataService/get | 
*FeedDataServiceApi* | [**feed_data_service_upload_post**](docs/FeedDataServiceApi.md#feed_data_service_upload_post) | **POST** /FeedDataService/upload | 
*FeedFtpRequestServiceApi* | [**feed_ftp_request_service_add_post**](docs/FeedFtpRequestServiceApi.md#feed_ftp_request_service_add_post) | **POST** /FeedFtpRequestService/add | 
*FeedFtpServiceApi* | [**feed_ftp_service_add_post**](docs/FeedFtpServiceApi.md#feed_ftp_service_add_post) | **POST** /FeedFtpService/add | 
*FeedFtpServiceApi* | [**feed_ftp_service_get_post**](docs/FeedFtpServiceApi.md#feed_ftp_service_get_post) | **POST** /FeedFtpService/get | 
*FeedFtpServiceApi* | [**feed_ftp_service_set_post**](docs/FeedFtpServiceApi.md#feed_ftp_service_set_post) | **POST** /FeedFtpService/set | 
*FeedItemServiceApi* | [**feed_item_service_set_post**](docs/FeedItemServiceApi.md#feed_item_service_set_post) | **POST** /FeedItemService/set | 
*FeedServiceApi* | [**feed_service_add_post**](docs/FeedServiceApi.md#feed_service_add_post) | **POST** /FeedService/add | 
*FeedServiceApi* | [**feed_service_download_dis_approval_reason_list_post**](docs/FeedServiceApi.md#feed_service_download_dis_approval_reason_list_post) | **POST** /FeedService/downloadDisApprovalReasonList | 
*FeedServiceApi* | [**feed_service_get_post**](docs/FeedServiceApi.md#feed_service_get_post) | **POST** /FeedService/get | 
*FeedServiceApi* | [**feed_service_remove_post**](docs/FeedServiceApi.md#feed_service_remove_post) | **POST** /FeedService/remove | 
*FeedServiceApi* | [**feed_service_set_post**](docs/FeedServiceApi.md#feed_service_set_post) | **POST** /FeedService/set | 
*FeedSetServiceApi* | [**feed_set_service_add_post**](docs/FeedSetServiceApi.md#feed_set_service_add_post) | **POST** /FeedSetService/add | 
*FeedSetServiceApi* | [**feed_set_service_get_post**](docs/FeedSetServiceApi.md#feed_set_service_get_post) | **POST** /FeedSetService/get | 
*FeedSetServiceApi* | [**feed_set_service_remove_post**](docs/FeedSetServiceApi.md#feed_set_service_remove_post) | **POST** /FeedSetService/remove | 
*GuaranteedAdGroupAdServiceApi* | [**guaranteed_ad_group_ad_service_add_post**](docs/GuaranteedAdGroupAdServiceApi.md#guaranteed_ad_group_ad_service_add_post) | **POST** /GuaranteedAdGroupAdService/add | 
*GuaranteedAdGroupAdServiceApi* | [**guaranteed_ad_group_ad_service_get_post**](docs/GuaranteedAdGroupAdServiceApi.md#guaranteed_ad_group_ad_service_get_post) | **POST** /GuaranteedAdGroupAdService/get | 
*GuaranteedAdGroupAdServiceApi* | [**guaranteed_ad_group_ad_service_set_post**](docs/GuaranteedAdGroupAdServiceApi.md#guaranteed_ad_group_ad_service_set_post) | **POST** /GuaranteedAdGroupAdService/set | 
*GuaranteedAdGroupServiceApi* | [**guaranteed_ad_group_service_add_post**](docs/GuaranteedAdGroupServiceApi.md#guaranteed_ad_group_service_add_post) | **POST** /GuaranteedAdGroupService/add | 
*GuaranteedAdGroupServiceApi* | [**guaranteed_ad_group_service_get_post**](docs/GuaranteedAdGroupServiceApi.md#guaranteed_ad_group_service_get_post) | **POST** /GuaranteedAdGroupService/get | 
*GuaranteedAdGroupServiceApi* | [**guaranteed_ad_group_service_set_post**](docs/GuaranteedAdGroupServiceApi.md#guaranteed_ad_group_service_set_post) | **POST** /GuaranteedAdGroupService/set | 
*GuaranteedCampaignServiceApi* | [**guaranteed_campaign_service_get_post**](docs/GuaranteedCampaignServiceApi.md#guaranteed_campaign_service_get_post) | **POST** /GuaranteedCampaignService/get | 
*GuaranteedCampaignServiceApi* | [**guaranteed_campaign_service_set_post**](docs/GuaranteedCampaignServiceApi.md#guaranteed_campaign_service_set_post) | **POST** /GuaranteedCampaignService/set | 
*GuaranteedInventoryServiceApi* | [**guaranteed_inventory_service_add_post**](docs/GuaranteedInventoryServiceApi.md#guaranteed_inventory_service_add_post) | **POST** /GuaranteedInventoryService/add | 
*GuaranteedInventoryServiceApi* | [**guaranteed_inventory_service_get_post**](docs/GuaranteedInventoryServiceApi.md#guaranteed_inventory_service_get_post) | **POST** /GuaranteedInventoryService/get | 
*GuaranteedPreviewServiceApi* | [**guaranteed_preview_service_get_post**](docs/GuaranteedPreviewServiceApi.md#guaranteed_preview_service_get_post) | **POST** /GuaranteedPreviewService/get | 
*GuaranteedReservationServiceApi* | [**guaranteed_reservation_service_add_post**](docs/GuaranteedReservationServiceApi.md#guaranteed_reservation_service_add_post) | **POST** /GuaranteedReservationService/add | 
*GuaranteedSimulationServiceApi* | [**guaranteed_simulation_service_add_post**](docs/GuaranteedSimulationServiceApi.md#guaranteed_simulation_service_add_post) | **POST** /GuaranteedSimulationService/add | 
*GuaranteedSimulationServiceApi* | [**guaranteed_simulation_service_get_ad_category_post**](docs/GuaranteedSimulationServiceApi.md#guaranteed_simulation_service_get_ad_category_post) | **POST** /GuaranteedSimulationService/getAdCategory | 
*GuaranteedSimulationServiceApi* | [**guaranteed_simulation_service_get_package_post**](docs/GuaranteedSimulationServiceApi.md#guaranteed_simulation_service_get_package_post) | **POST** /GuaranteedSimulationService/getPackage | 
*GuaranteedSimulationServiceApi* | [**guaranteed_simulation_service_get_post**](docs/GuaranteedSimulationServiceApi.md#guaranteed_simulation_service_get_post) | **POST** /GuaranteedSimulationService/get | 
*LabelServiceApi* | [**label_service_add_post**](docs/LabelServiceApi.md#label_service_add_post) | **POST** /LabelService/add | 
*LabelServiceApi* | [**label_service_get_post**](docs/LabelServiceApi.md#label_service_get_post) | **POST** /LabelService/get | 
*LabelServiceApi* | [**label_service_remove_post**](docs/LabelServiceApi.md#label_service_remove_post) | **POST** /LabelService/remove | 
*LabelServiceApi* | [**label_service_set_post**](docs/LabelServiceApi.md#label_service_set_post) | **POST** /LabelService/set | 
*MediaServiceApi* | [**media_service_add_post**](docs/MediaServiceApi.md#media_service_add_post) | **POST** /MediaService/add | 
*MediaServiceApi* | [**media_service_download_post**](docs/MediaServiceApi.md#media_service_download_post) | **POST** /MediaService/download | 
*MediaServiceApi* | [**media_service_get_post**](docs/MediaServiceApi.md#media_service_get_post) | **POST** /MediaService/get | 
*MediaServiceApi* | [**media_service_remove_post**](docs/MediaServiceApi.md#media_service_remove_post) | **POST** /MediaService/remove | 
*MediaServiceApi* | [**media_service_set_post**](docs/MediaServiceApi.md#media_service_set_post) | **POST** /MediaService/set | 
*PlacementUrlIdeaServiceApi* | [**placement_url_idea_service_get_post**](docs/PlacementUrlIdeaServiceApi.md#placement_url_idea_service_get_post) | **POST** /PlacementUrlIdeaService/get | 
*PlacementUrlListServiceApi* | [**placement_url_list_service_add_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_add_post) | **POST** /PlacementUrlListService/add | 
*PlacementUrlListServiceApi* | [**placement_url_list_service_get_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_get_post) | **POST** /PlacementUrlListService/get | 
*PlacementUrlListServiceApi* | [**placement_url_list_service_remove_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_remove_post) | **POST** /PlacementUrlListService/remove | 
*PlacementUrlListServiceApi* | [**placement_url_list_service_set_post**](docs/PlacementUrlListServiceApi.md#placement_url_list_service_set_post) | **POST** /PlacementUrlListService/set | 
*RecommendationServiceApi* | [**recommendation_service_get_post**](docs/RecommendationServiceApi.md#recommendation_service_get_post) | **POST** /RecommendationService/get | 
*ReportDefinitionServiceApi* | [**report_definition_service_add_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_add_post) | **POST** /ReportDefinitionService/add | 
*ReportDefinitionServiceApi* | [**report_definition_service_download_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_download_post) | **POST** /ReportDefinitionService/download | 
*ReportDefinitionServiceApi* | [**report_definition_service_get_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_get_post) | **POST** /ReportDefinitionService/get | 
*ReportDefinitionServiceApi* | [**report_definition_service_get_report_fields_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_get_report_fields_post) | **POST** /ReportDefinitionService/getReportFields | 
*ReportDefinitionServiceApi* | [**report_definition_service_remove_post**](docs/ReportDefinitionServiceApi.md#report_definition_service_remove_post) | **POST** /ReportDefinitionService/remove | 
*RetargetingListServiceApi* | [**retargeting_list_service_add_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_add_post) | **POST** /RetargetingListService/add | 
*RetargetingListServiceApi* | [**retargeting_list_service_get_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_get_post) | **POST** /RetargetingListService/get | 
*RetargetingListServiceApi* | [**retargeting_list_service_get_upload_user_list_status_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_get_upload_user_list_status_post) | **POST** /RetargetingListService/getUploadUserListStatus | 
*RetargetingListServiceApi* | [**retargeting_list_service_remove_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_remove_post) | **POST** /RetargetingListService/remove | 
*RetargetingListServiceApi* | [**retargeting_list_service_set_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_set_post) | **POST** /RetargetingListService/set | 
*RetargetingListServiceApi* | [**retargeting_list_service_upload_user_list_post**](docs/RetargetingListServiceApi.md#retargeting_list_service_upload_user_list_post) | **POST** /RetargetingListService/uploadUserList | 
*RetargetingTagServiceApi* | [**retargeting_tag_service_add_post**](docs/RetargetingTagServiceApi.md#retargeting_tag_service_add_post) | **POST** /RetargetingTagService/add | 
*RetargetingTagServiceApi* | [**retargeting_tag_service_get_post**](docs/RetargetingTagServiceApi.md#retargeting_tag_service_get_post) | **POST** /RetargetingTagService/get | 
*SearchKeywordIdeaServiceApi* | [**search_keyword_idea_service_get_post**](docs/SearchKeywordIdeaServiceApi.md#search_keyword_idea_service_get_post) | **POST** /SearchKeywordIdeaService/get | 
*SearchKeywordListServiceApi* | [**search_keyword_list_service_add_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_add_post) | **POST** /SearchKeywordListService/add | 
*SearchKeywordListServiceApi* | [**search_keyword_list_service_get_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_get_post) | **POST** /SearchKeywordListService/get | 
*SearchKeywordListServiceApi* | [**search_keyword_list_service_remove_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_remove_post) | **POST** /SearchKeywordListService/remove | 
*SearchKeywordListServiceApi* | [**search_keyword_list_service_set_post**](docs/SearchKeywordListServiceApi.md#search_keyword_list_service_set_post) | **POST** /SearchKeywordListService/set | 
*SearchLiftServiceApi* | [**search_lift_service_get_post**](docs/SearchLiftServiceApi.md#search_lift_service_get_post) | **POST** /SearchLiftService/get | 
*StatsServiceApi* | [**stats_service_get_post**](docs/StatsServiceApi.md#stats_service_get_post) | **POST** /StatsService/get | 
*VideoServiceApi* | [**video_service_download_post**](docs/VideoServiceApi.md#video_service_download_post) | **POST** /VideoService/download | 
*VideoServiceApi* | [**video_service_get_post**](docs/VideoServiceApi.md#video_service_get_post) | **POST** /VideoService/get | 
*VideoServiceApi* | [**video_service_remove_post**](docs/VideoServiceApi.md#video_service_remove_post) | **POST** /VideoService/remove | 
*VideoServiceApi* | [**video_service_set_post**](docs/VideoServiceApi.md#video_service_set_post) | **POST** /VideoService/set | 
*VideoServiceApi* | [**video_service_upload_post**](docs/VideoServiceApi.md#video_service_upload_post) | **POST** /VideoService/upload | 


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountAuthority](docs/AccountAuthority.md)
 - [AccountAuthorityServiceGetResponse](docs/AccountAuthorityServiceGetResponse.md)
 - [AccountAuthorityServicePage](docs/AccountAuthorityServicePage.md)
 - [AccountAuthorityServiceSelector](docs/AccountAuthorityServiceSelector.md)
 - [AccountAuthorityServiceValue](docs/AccountAuthorityServiceValue.md)
 - [AccountLink](docs/AccountLink.md)
 - [AccountLinkServiceAccountStatus](docs/AccountLinkServiceAccountStatus.md)
 - [AccountLinkServiceGetResponse](docs/AccountLinkServiceGetResponse.md)
 - [AccountLinkServiceLinkAccessPermission](docs/AccountLinkServiceLinkAccessPermission.md)
 - [AccountLinkServiceOwnerShipType](docs/AccountLinkServiceOwnerShipType.md)
 - [AccountLinkServicePage](docs/AccountLinkServicePage.md)
 - [AccountLinkServiceRetargetingListSharingEnabled](docs/AccountLinkServiceRetargetingListSharingEnabled.md)
 - [AccountLinkServiceSelector](docs/AccountLinkServiceSelector.md)
 - [AccountLinkServiceValue](docs/AccountLinkServiceValue.md)
 - [AccountManagement](docs/AccountManagement.md)
 - [AccountManagementServiceAuthType](docs/AccountManagementServiceAuthType.md)
 - [AccountManagementServiceAutoTaggingEnabled](docs/AccountManagementServiceAutoTaggingEnabled.md)
 - [AccountManagementServiceClient](docs/AccountManagementServiceClient.md)
 - [AccountManagementServiceClientType](docs/AccountManagementServiceClientType.md)
 - [AccountManagementServiceDeliveryStatus](docs/AccountManagementServiceDeliveryStatus.md)
 - [AccountManagementServiceEnterpriseType](docs/AccountManagementServiceEnterpriseType.md)
 - [AccountManagementServiceEnterpriseTypePosition](docs/AccountManagementServiceEnterpriseTypePosition.md)
 - [AccountManagementServiceGetResponse](docs/AccountManagementServiceGetResponse.md)
 - [AccountManagementServiceIncludeTestAccount](docs/AccountManagementServiceIncludeTestAccount.md)
 - [AccountManagementServiceInvoice](docs/AccountManagementServiceInvoice.md)
 - [AccountManagementServiceIsTestAccount](docs/AccountManagementServiceIsTestAccount.md)
 - [AccountManagementServiceMutateResponse](docs/AccountManagementServiceMutateResponse.md)
 - [AccountManagementServiceOperation](docs/AccountManagementServiceOperation.md)
 - [AccountManagementServicePage](docs/AccountManagementServicePage.md)
 - [AccountManagementServicePayment](docs/AccountManagementServicePayment.md)
 - [AccountManagementServicePaymentType](docs/AccountManagementServicePaymentType.md)
 - [AccountManagementServicePrefectureCode](docs/AccountManagementServicePrefectureCode.md)
 - [AccountManagementServiceReturnValue](docs/AccountManagementServiceReturnValue.md)
 - [AccountManagementServiceSelector](docs/AccountManagementServiceSelector.md)
 - [AccountManagementServiceStatus](docs/AccountManagementServiceStatus.md)
 - [AccountManagementServiceUrlType](docs/AccountManagementServiceUrlType.md)
 - [AccountManagementServiceValue](docs/AccountManagementServiceValue.md)
 - [AccountServiceAuthType](docs/AccountServiceAuthType.md)
 - [AccountServiceAutoTaggingEnabled](docs/AccountServiceAutoTaggingEnabled.md)
 - [AccountServiceDeliveryStatus](docs/AccountServiceDeliveryStatus.md)
 - [AccountServiceGetResponse](docs/AccountServiceGetResponse.md)
 - [AccountServiceIncludeManagerAccount](docs/AccountServiceIncludeManagerAccount.md)
 - [AccountServiceIncludeTestAccount](docs/AccountServiceIncludeTestAccount.md)
 - [AccountServiceIsManagerAccount](docs/AccountServiceIsManagerAccount.md)
 - [AccountServiceIsTestAccount](docs/AccountServiceIsTestAccount.md)
 - [AccountServiceMutateResponse](docs/AccountServiceMutateResponse.md)
 - [AccountServiceOperation](docs/AccountServiceOperation.md)
 - [AccountServicePage](docs/AccountServicePage.md)
 - [AccountServiceReturnValue](docs/AccountServiceReturnValue.md)
 - [AccountServiceSelector](docs/AccountServiceSelector.md)
 - [AccountServiceStatus](docs/AccountServiceStatus.md)
 - [AccountServiceType](docs/AccountServiceType.md)
 - [AccountServiceValue](docs/AccountServiceValue.md)
 - [AccountTrackingUrl](docs/AccountTrackingUrl.md)
 - [AccountTrackingUrlServiceGetResponse](docs/AccountTrackingUrlServiceGetResponse.md)
 - [AccountTrackingUrlServiceIsRemoveFlg](docs/AccountTrackingUrlServiceIsRemoveFlg.md)
 - [AccountTrackingUrlServiceMutateResponse](docs/AccountTrackingUrlServiceMutateResponse.md)
 - [AccountTrackingUrlServiceOperation](docs/AccountTrackingUrlServiceOperation.md)
 - [AccountTrackingUrlServicePage](docs/AccountTrackingUrlServicePage.md)
 - [AccountTrackingUrlServiceReturnValue](docs/AccountTrackingUrlServiceReturnValue.md)
 - [AccountTrackingUrlServiceSelector](docs/AccountTrackingUrlServiceSelector.md)
 - [AccountTrackingUrlServiceValue](docs/AccountTrackingUrlServiceValue.md)
 - [AdGroup](docs/AdGroup.md)
 - [AdGroupAd](docs/AdGroupAd.md)
 - [AdGroupAdLabel](docs/AdGroupAdLabel.md)
 - [AdGroupAdLabelServiceMutateResponse](docs/AdGroupAdLabelServiceMutateResponse.md)
 - [AdGroupAdLabelServiceOperation](docs/AdGroupAdLabelServiceOperation.md)
 - [AdGroupAdLabelServiceReturnValue](docs/AdGroupAdLabelServiceReturnValue.md)
 - [AdGroupAdLabelServiceValue](docs/AdGroupAdLabelServiceValue.md)
 - [AdGroupAdServiceAd](docs/AdGroupAdServiceAd.md)
 - [AdGroupAdServiceAdStyle](docs/AdGroupAdServiceAdStyle.md)
 - [AdGroupAdServiceAdType](docs/AdGroupAdServiceAdType.md)
 - [AdGroupAdServiceApprovalStatus](docs/AdGroupAdServiceApprovalStatus.md)
 - [AdGroupAdServiceBannerImageAd](docs/AdGroupAdServiceBannerImageAd.md)
 - [AdGroupAdServiceBannerVideoAd](docs/AdGroupAdServiceBannerVideoAd.md)
 - [AdGroupAdServiceButtonText](docs/AdGroupAdServiceButtonText.md)
 - [AdGroupAdServiceCarousel](docs/AdGroupAdServiceCarousel.md)
 - [AdGroupAdServiceCarouselAd](docs/AdGroupAdServiceCarouselAd.md)
 - [AdGroupAdServiceCarrierName](docs/AdGroupAdServiceCarrierName.md)
 - [AdGroupAdServiceCreatedDateRange](docs/AdGroupAdServiceCreatedDateRange.md)
 - [AdGroupAdServiceCustomParameter](docs/AdGroupAdServiceCustomParameter.md)
 - [AdGroupAdServiceCustomParameters](docs/AdGroupAdServiceCustomParameters.md)
 - [AdGroupAdServiceDisplayUrlLevel](docs/AdGroupAdServiceDisplayUrlLevel.md)
 - [AdGroupAdServiceDynamicAd](docs/AdGroupAdServiceDynamicAd.md)
 - [AdGroupAdServiceGetResponse](docs/AdGroupAdServiceGetResponse.md)
 - [AdGroupAdServiceIsRemoveFlg](docs/AdGroupAdServiceIsRemoveFlg.md)
 - [AdGroupAdServiceLabel](docs/AdGroupAdServiceLabel.md)
 - [AdGroupAdServiceMobileAd](docs/AdGroupAdServiceMobileAd.md)
 - [AdGroupAdServiceMutateResponse](docs/AdGroupAdServiceMutateResponse.md)
 - [AdGroupAdServiceOperation](docs/AdGroupAdServiceOperation.md)
 - [AdGroupAdServicePage](docs/AdGroupAdServicePage.md)
 - [AdGroupAdServicePosAd](docs/AdGroupAdServicePosAd.md)
 - [AdGroupAdServiceResponsiveImageAd](docs/AdGroupAdServiceResponsiveImageAd.md)
 - [AdGroupAdServiceResponsiveVideoAd](docs/AdGroupAdServiceResponsiveVideoAd.md)
 - [AdGroupAdServiceReturnValue](docs/AdGroupAdServiceReturnValue.md)
 - [AdGroupAdServiceSelector](docs/AdGroupAdServiceSelector.md)
 - [AdGroupAdServiceStaticFrameAd](docs/AdGroupAdServiceStaticFrameAd.md)
 - [AdGroupAdServiceTextAd](docs/AdGroupAdServiceTextAd.md)
 - [AdGroupAdServiceUserStatus](docs/AdGroupAdServiceUserStatus.md)
 - [AdGroupAdServiceValue](docs/AdGroupAdServiceValue.md)
 - [AdGroupLabel](docs/AdGroupLabel.md)
 - [AdGroupLabelServiceMutateResponse](docs/AdGroupLabelServiceMutateResponse.md)
 - [AdGroupLabelServiceOperation](docs/AdGroupLabelServiceOperation.md)
 - [AdGroupLabelServiceReturnValue](docs/AdGroupLabelServiceReturnValue.md)
 - [AdGroupLabelServiceValue](docs/AdGroupLabelServiceValue.md)
 - [AdGroupServiceBiddingStrategy](docs/AdGroupServiceBiddingStrategy.md)
 - [AdGroupServiceBiddingValueCpcRange](docs/AdGroupServiceBiddingValueCpcRange.md)
 - [AdGroupServiceCampaignBiddingStrategyType](docs/AdGroupServiceCampaignBiddingStrategyType.md)
 - [AdGroupServiceCreatedDateRange](docs/AdGroupServiceCreatedDateRange.md)
 - [AdGroupServiceCustomParameter](docs/AdGroupServiceCustomParameter.md)
 - [AdGroupServiceCustomParameters](docs/AdGroupServiceCustomParameters.md)
 - [AdGroupServiceDeviceAppType](docs/AdGroupServiceDeviceAppType.md)
 - [AdGroupServiceDeviceOsType](docs/AdGroupServiceDeviceOsType.md)
 - [AdGroupServiceDeviceType](docs/AdGroupServiceDeviceType.md)
 - [AdGroupServiceGetResponse](docs/AdGroupServiceGetResponse.md)
 - [AdGroupServiceIsRemoveFlg](docs/AdGroupServiceIsRemoveFlg.md)
 - [AdGroupServiceLabel](docs/AdGroupServiceLabel.md)
 - [AdGroupServiceMutateResponse](docs/AdGroupServiceMutateResponse.md)
 - [AdGroupServiceOperation](docs/AdGroupServiceOperation.md)
 - [AdGroupServicePage](docs/AdGroupServicePage.md)
 - [AdGroupServiceReturnValue](docs/AdGroupServiceReturnValue.md)
 - [AdGroupServiceSelector](docs/AdGroupServiceSelector.md)
 - [AdGroupServiceUserStatus](docs/AdGroupServiceUserStatus.md)
 - [AdGroupServiceValue](docs/AdGroupServiceValue.md)
 - [AdGroupTarget](docs/AdGroupTarget.md)
 - [AdGroupTargetReturnValue](docs/AdGroupTargetReturnValue.md)
 - [AdGroupTargetServiceAdScheduleTarget](docs/AdGroupTargetServiceAdScheduleTarget.md)
 - [AdGroupTargetServiceAge](docs/AdGroupTargetServiceAge.md)
 - [AdGroupTargetServiceAgeTarget](docs/AdGroupTargetServiceAgeTarget.md)
 - [AdGroupTargetServiceAppTarget](docs/AdGroupTargetServiceAppTarget.md)
 - [AdGroupTargetServiceAudienceCategoryTarget](docs/AdGroupTargetServiceAudienceCategoryTarget.md)
 - [AdGroupTargetServiceContentsTarget](docs/AdGroupTargetServiceContentsTarget.md)
 - [AdGroupTargetServiceDayOfWeek](docs/AdGroupTargetServiceDayOfWeek.md)
 - [AdGroupTargetServiceDeviceAppType](docs/AdGroupTargetServiceDeviceAppType.md)
 - [AdGroupTargetServiceDeviceOsType](docs/AdGroupTargetServiceDeviceOsType.md)
 - [AdGroupTargetServiceDeviceTarget](docs/AdGroupTargetServiceDeviceTarget.md)
 - [AdGroupTargetServiceDeviceType](docs/AdGroupTargetServiceDeviceType.md)
 - [AdGroupTargetServiceEstimateFlg](docs/AdGroupTargetServiceEstimateFlg.md)
 - [AdGroupTargetServiceGender](docs/AdGroupTargetServiceGender.md)
 - [AdGroupTargetServiceGenderTarget](docs/AdGroupTargetServiceGenderTarget.md)
 - [AdGroupTargetServiceGeoTarget](docs/AdGroupTargetServiceGeoTarget.md)
 - [AdGroupTargetServiceGetResponse](docs/AdGroupTargetServiceGetResponse.md)
 - [AdGroupTargetServiceMutateResponse](docs/AdGroupTargetServiceMutateResponse.md)
 - [AdGroupTargetServiceOperation](docs/AdGroupTargetServiceOperation.md)
 - [AdGroupTargetServiceOsTarget](docs/AdGroupTargetServiceOsTarget.md)
 - [AdGroupTargetServiceOsVersionTarget](docs/AdGroupTargetServiceOsVersionTarget.md)
 - [AdGroupTargetServicePage](docs/AdGroupTargetServicePage.md)
 - [AdGroupTargetServicePlacementCategoryDetailTarget](docs/AdGroupTargetServicePlacementCategoryDetailTarget.md)
 - [AdGroupTargetServicePlacementCategoryTarget](docs/AdGroupTargetServicePlacementCategoryTarget.md)
 - [AdGroupTargetServicePlacementCategoryType](docs/AdGroupTargetServicePlacementCategoryType.md)
 - [AdGroupTargetServicePlacementTarget](docs/AdGroupTargetServicePlacementTarget.md)
 - [AdGroupTargetServicePlacementUrlListType](docs/AdGroupTargetServicePlacementUrlListType.md)
 - [AdGroupTargetServicePositionTarget](docs/AdGroupTargetServicePositionTarget.md)
 - [AdGroupTargetServicePositionType](docs/AdGroupTargetServicePositionType.md)
 - [AdGroupTargetServiceSearchTarget](docs/AdGroupTargetServiceSearchTarget.md)
 - [AdGroupTargetServiceSelector](docs/AdGroupTargetServiceSelector.md)
 - [AdGroupTargetServiceSiteCategoryTarget](docs/AdGroupTargetServiceSiteCategoryTarget.md)
 - [AdGroupTargetServiceSiteRetargetingTarget](docs/AdGroupTargetServiceSiteRetargetingTarget.md)
 - [AdGroupTargetServiceTarget](docs/AdGroupTargetServiceTarget.md)
 - [AdGroupTargetServiceTargetListDeliverType](docs/AdGroupTargetServiceTargetListDeliverType.md)
 - [AdGroupTargetServiceTargetType](docs/AdGroupTargetServiceTargetType.md)
 - [AdGroupTargetServiceValue](docs/AdGroupTargetServiceValue.md)
 - [AuditLogServiceDateRange](docs/AuditLogServiceDateRange.md)
 - [AuditLogServiceDownloadSelector](docs/AuditLogServiceDownloadSelector.md)
 - [AuditLogServiceGetResponse](docs/AuditLogServiceGetResponse.md)
 - [AuditLogServiceJob](docs/AuditLogServiceJob.md)
 - [AuditLogServiceJobStatus](docs/AuditLogServiceJobStatus.md)
 - [AuditLogServiceLang](docs/AuditLogServiceLang.md)
 - [AuditLogServiceMutateResponse](docs/AuditLogServiceMutateResponse.md)
 - [AuditLogServiceOperation](docs/AuditLogServiceOperation.md)
 - [AuditLogServicePage](docs/AuditLogServicePage.md)
 - [AuditLogServiceReturnValue](docs/AuditLogServiceReturnValue.md)
 - [AuditLogServiceSelector](docs/AuditLogServiceSelector.md)
 - [AuditLogServiceUpdateSource](docs/AuditLogServiceUpdateSource.md)
 - [AuditLogServiceValue](docs/AuditLogServiceValue.md)
 - [Balance](docs/Balance.md)
 - [BalanceServiceGetResponse](docs/BalanceServiceGetResponse.md)
 - [BalanceServicePage](docs/BalanceServicePage.md)
 - [BalanceServiceSelector](docs/BalanceServiceSelector.md)
 - [BalanceServiceValue](docs/BalanceServiceValue.md)
 - [BrandLift](docs/BrandLift.md)
 - [BrandLiftServiceApprovalStatus](docs/BrandLiftServiceApprovalStatus.md)
 - [BrandLiftServiceGetResponse](docs/BrandLiftServiceGetResponse.md)
 - [BrandLiftServiceGoal](docs/BrandLiftServiceGoal.md)
 - [BrandLiftServicePage](docs/BrandLiftServicePage.md)
 - [BrandLiftServiceQuestion](docs/BrandLiftServiceQuestion.md)
 - [BrandLiftServiceSelector](docs/BrandLiftServiceSelector.md)
 - [BrandLiftServiceValue](docs/BrandLiftServiceValue.md)
 - [BudgetOrder](docs/BudgetOrder.md)
 - [BudgetOrderServiceAccountType](docs/BudgetOrderServiceAccountType.md)
 - [BudgetOrderServiceGetResponse](docs/BudgetOrderServiceGetResponse.md)
 - [BudgetOrderServiceLimitChargeType](docs/BudgetOrderServiceLimitChargeType.md)
 - [BudgetOrderServiceMutateResponse](docs/BudgetOrderServiceMutateResponse.md)
 - [BudgetOrderServiceOperation](docs/BudgetOrderServiceOperation.md)
 - [BudgetOrderServicePage](docs/BudgetOrderServicePage.md)
 - [BudgetOrderServiceReturnValue](docs/BudgetOrderServiceReturnValue.md)
 - [BudgetOrderServiceSelector](docs/BudgetOrderServiceSelector.md)
 - [BudgetOrderServiceValue](docs/BudgetOrderServiceValue.md)
 - [Campaign](docs/Campaign.md)
 - [CampaignLabel](docs/CampaignLabel.md)
 - [CampaignLabelServiceMutateResponse](docs/CampaignLabelServiceMutateResponse.md)
 - [CampaignLabelServiceOperation](docs/CampaignLabelServiceOperation.md)
 - [CampaignLabelServiceReturnValue](docs/CampaignLabelServiceReturnValue.md)
 - [CampaignLabelServiceValue](docs/CampaignLabelServiceValue.md)
 - [CampaignServiceBudget](docs/CampaignServiceBudget.md)
 - [CampaignServiceBudgetAmountRange](docs/CampaignServiceBudgetAmountRange.md)
 - [CampaignServiceCampaignBiddingStrategy](docs/CampaignServiceCampaignBiddingStrategy.md)
 - [CampaignServiceCampaignBiddingStrategyType](docs/CampaignServiceCampaignBiddingStrategyType.md)
 - [CampaignServiceConversionOptimizer](docs/CampaignServiceConversionOptimizer.md)
 - [CampaignServiceConversionOptimizerTrainingStatus](docs/CampaignServiceConversionOptimizerTrainingStatus.md)
 - [CampaignServiceConversionTracker](docs/CampaignServiceConversionTracker.md)
 - [CampaignServiceCreatedDateRange](docs/CampaignServiceCreatedDateRange.md)
 - [CampaignServiceCustomParameter](docs/CampaignServiceCustomParameter.md)
 - [CampaignServiceCustomParameters](docs/CampaignServiceCustomParameters.md)
 - [CampaignServiceDeviceOsType](docs/CampaignServiceDeviceOsType.md)
 - [CampaignServiceFrequencyLevel](docs/CampaignServiceFrequencyLevel.md)
 - [CampaignServiceFrequencyTimeUnit](docs/CampaignServiceFrequencyTimeUnit.md)
 - [CampaignServiceGetResponse](docs/CampaignServiceGetResponse.md)
 - [CampaignServiceIsRemoveFlg](docs/CampaignServiceIsRemoveFlg.md)
 - [CampaignServiceLabel](docs/CampaignServiceLabel.md)
 - [CampaignServiceMutateResponse](docs/CampaignServiceMutateResponse.md)
 - [CampaignServiceOperation](docs/CampaignServiceOperation.md)
 - [CampaignServicePage](docs/CampaignServicePage.md)
 - [CampaignServiceReturnValue](docs/CampaignServiceReturnValue.md)
 - [CampaignServiceSelector](docs/CampaignServiceSelector.md)
 - [CampaignServiceServingStatus](docs/CampaignServiceServingStatus.md)
 - [CampaignServiceUserStatus](docs/CampaignServiceUserStatus.md)
 - [CampaignServiceValue](docs/CampaignServiceValue.md)
 - [CampaignServiceViewableFrequencyCap](docs/CampaignServiceViewableFrequencyCap.md)
 - [ContentsKeywordIdea](docs/ContentsKeywordIdea.md)
 - [ContentsKeywordIdeaServiceGetResponse](docs/ContentsKeywordIdeaServiceGetResponse.md)
 - [ContentsKeywordIdeaServiceKeyword](docs/ContentsKeywordIdeaServiceKeyword.md)
 - [ContentsKeywordIdeaServiceMatchType](docs/ContentsKeywordIdeaServiceMatchType.md)
 - [ContentsKeywordIdeaServicePage](docs/ContentsKeywordIdeaServicePage.md)
 - [ContentsKeywordIdeaServiceSelector](docs/ContentsKeywordIdeaServiceSelector.md)
 - [ContentsKeywordIdeaServiceSortField](docs/ContentsKeywordIdeaServiceSortField.md)
 - [ContentsKeywordIdeaServiceSortType](docs/ContentsKeywordIdeaServiceSortType.md)
 - [ContentsKeywordIdeaServiceValue](docs/ContentsKeywordIdeaServiceValue.md)
 - [ContentsKeywordList](docs/ContentsKeywordList.md)
 - [ContentsKeywordListServiceContentsKeyword](docs/ContentsKeywordListServiceContentsKeyword.md)
 - [ContentsKeywordListServiceGetResponse](docs/ContentsKeywordListServiceGetResponse.md)
 - [ContentsKeywordListServiceIsRemoveFlg](docs/ContentsKeywordListServiceIsRemoveFlg.md)
 - [ContentsKeywordListServiceMutateResponse](docs/ContentsKeywordListServiceMutateResponse.md)
 - [ContentsKeywordListServiceOperation](docs/ContentsKeywordListServiceOperation.md)
 - [ContentsKeywordListServicePage](docs/ContentsKeywordListServicePage.md)
 - [ContentsKeywordListServiceReturnValue](docs/ContentsKeywordListServiceReturnValue.md)
 - [ContentsKeywordListServiceSelector](docs/ContentsKeywordListServiceSelector.md)
 - [ContentsKeywordListServiceValue](docs/ContentsKeywordListServiceValue.md)
 - [ConversionGroup](docs/ConversionGroup.md)
 - [ConversionGroupServiceConversion](docs/ConversionGroupServiceConversion.md)
 - [ConversionGroupServiceGetResponse](docs/ConversionGroupServiceGetResponse.md)
 - [ConversionGroupServiceMutateResponse](docs/ConversionGroupServiceMutateResponse.md)
 - [ConversionGroupServiceOperation](docs/ConversionGroupServiceOperation.md)
 - [ConversionGroupServicePage](docs/ConversionGroupServicePage.md)
 - [ConversionGroupServiceReturnValue](docs/ConversionGroupServiceReturnValue.md)
 - [ConversionGroupServiceSelector](docs/ConversionGroupServiceSelector.md)
 - [ConversionGroupServiceValue](docs/ConversionGroupServiceValue.md)
 - [ConversionTracker](docs/ConversionTracker.md)
 - [ConversionTrackerServiceAppConversion](docs/ConversionTrackerServiceAppConversion.md)
 - [ConversionTrackerServiceAppConversionPlatform](docs/ConversionTrackerServiceAppConversionPlatform.md)
 - [ConversionTrackerServiceAppConversionType](docs/ConversionTrackerServiceAppConversionType.md)
 - [ConversionTrackerServiceCategory](docs/ConversionTrackerServiceCategory.md)
 - [ConversionTrackerServiceCountingType](docs/ConversionTrackerServiceCountingType.md)
 - [ConversionTrackerServiceExcludeFromBidding](docs/ConversionTrackerServiceExcludeFromBidding.md)
 - [ConversionTrackerServiceExcludePreviousConversion](docs/ConversionTrackerServiceExcludePreviousConversion.md)
 - [ConversionTrackerServiceGetResponse](docs/ConversionTrackerServiceGetResponse.md)
 - [ConversionTrackerServiceIsPreviousConversion](docs/ConversionTrackerServiceIsPreviousConversion.md)
 - [ConversionTrackerServiceMutateResponse](docs/ConversionTrackerServiceMutateResponse.md)
 - [ConversionTrackerServiceOperation](docs/ConversionTrackerServiceOperation.md)
 - [ConversionTrackerServicePage](docs/ConversionTrackerServicePage.md)
 - [ConversionTrackerServicePeriod](docs/ConversionTrackerServicePeriod.md)
 - [ConversionTrackerServicePeriodDatetime](docs/ConversionTrackerServicePeriodDatetime.md)
 - [ConversionTrackerServiceReturnValue](docs/ConversionTrackerServiceReturnValue.md)
 - [ConversionTrackerServiceSelector](docs/ConversionTrackerServiceSelector.md)
 - [ConversionTrackerServiceStatsPeriod](docs/ConversionTrackerServiceStatsPeriod.md)
 - [ConversionTrackerServiceStatsPeriodCustomDate](docs/ConversionTrackerServiceStatsPeriodCustomDate.md)
 - [ConversionTrackerServiceStatus](docs/ConversionTrackerServiceStatus.md)
 - [ConversionTrackerServiceType](docs/ConversionTrackerServiceType.md)
 - [ConversionTrackerServiceValue](docs/ConversionTrackerServiceValue.md)
 - [ConversionTrackerServiceWebConversion](docs/ConversionTrackerServiceWebConversion.md)
 - [ConversionTrackerServiceWebConversionSnippet](docs/ConversionTrackerServiceWebConversionSnippet.md)
 - [ConversionTrackerServiceWebConversionSnippetType](docs/ConversionTrackerServiceWebConversionSnippetType.md)
 - [DictionaryServiceAudienceCategory](docs/DictionaryServiceAudienceCategory.md)
 - [DictionaryServiceAudienceCategoryPage](docs/DictionaryServiceAudienceCategoryPage.md)
 - [DictionaryServiceAudienceCategoryValue](docs/DictionaryServiceAudienceCategoryValue.md)
 - [DictionaryServiceBusinessCategory](docs/DictionaryServiceBusinessCategory.md)
 - [DictionaryServiceBusinessCategoryPage](docs/DictionaryServiceBusinessCategoryPage.md)
 - [DictionaryServiceBusinessCategoryValue](docs/DictionaryServiceBusinessCategoryValue.md)
 - [DictionaryServiceCategory](docs/DictionaryServiceCategory.md)
 - [DictionaryServiceCategoryChild](docs/DictionaryServiceCategoryChild.md)
 - [DictionaryServiceCategoryPage](docs/DictionaryServiceCategoryPage.md)
 - [DictionaryServiceCategorySelector](docs/DictionaryServiceCategorySelector.md)
 - [DictionaryServiceCategoryValue](docs/DictionaryServiceCategoryValue.md)
 - [DictionaryServiceDeviceOsType](docs/DictionaryServiceDeviceOsType.md)
 - [DictionaryServiceDisapprovalReason](docs/DictionaryServiceDisapprovalReason.md)
 - [DictionaryServiceDisapprovalReasonPage](docs/DictionaryServiceDisapprovalReasonPage.md)
 - [DictionaryServiceDisapprovalReasonSelector](docs/DictionaryServiceDisapprovalReasonSelector.md)
 - [DictionaryServiceDisapprovalReasonValue](docs/DictionaryServiceDisapprovalReasonValue.md)
 - [DictionaryServiceFeedItemGoogleProductCategory](docs/DictionaryServiceFeedItemGoogleProductCategory.md)
 - [DictionaryServiceFeedItemGoogleProductCategoryPage](docs/DictionaryServiceFeedItemGoogleProductCategoryPage.md)
 - [DictionaryServiceFeedItemGoogleProductCategorySelector](docs/DictionaryServiceFeedItemGoogleProductCategorySelector.md)
 - [DictionaryServiceFeedItemGoogleProductCategoryValue](docs/DictionaryServiceFeedItemGoogleProductCategoryValue.md)
 - [DictionaryServiceGeographicLocation](docs/DictionaryServiceGeographicLocation.md)
 - [DictionaryServiceGeographicLocationPage](docs/DictionaryServiceGeographicLocationPage.md)
 - [DictionaryServiceGeographicLocationSelector](docs/DictionaryServiceGeographicLocationSelector.md)
 - [DictionaryServiceGeographicLocationType](docs/DictionaryServiceGeographicLocationType.md)
 - [DictionaryServiceGeographicLocationValue](docs/DictionaryServiceGeographicLocationValue.md)
 - [DictionaryServiceGetAudienceCategoryResponse](docs/DictionaryServiceGetAudienceCategoryResponse.md)
 - [DictionaryServiceGetBusinessCategoryResponse](docs/DictionaryServiceGetBusinessCategoryResponse.md)
 - [DictionaryServiceGetDisapprovalReasonResponse](docs/DictionaryServiceGetDisapprovalReasonResponse.md)
 - [DictionaryServiceGetFeedItemGoogleProductCategoryResponse](docs/DictionaryServiceGetFeedItemGoogleProductCategoryResponse.md)
 - [DictionaryServiceGetGeographicLocationResponse](docs/DictionaryServiceGetGeographicLocationResponse.md)
 - [DictionaryServiceGetMediaAdFormatResponse](docs/DictionaryServiceGetMediaAdFormatResponse.md)
 - [DictionaryServiceGetOsVersionResponse](docs/DictionaryServiceGetOsVersionResponse.md)
 - [DictionaryServiceGetPlacementCategoryResponse](docs/DictionaryServiceGetPlacementCategoryResponse.md)
 - [DictionaryServiceGetSiteCategoryResponse](docs/DictionaryServiceGetSiteCategoryResponse.md)
 - [DictionaryServiceGetThirdPartyTrackingDomainResponse](docs/DictionaryServiceGetThirdPartyTrackingDomainResponse.md)
 - [DictionaryServiceLang](docs/DictionaryServiceLang.md)
 - [DictionaryServiceMediaAdFormat](docs/DictionaryServiceMediaAdFormat.md)
 - [DictionaryServiceMediaAdFormatPage](docs/DictionaryServiceMediaAdFormatPage.md)
 - [DictionaryServiceMediaAdFormatValue](docs/DictionaryServiceMediaAdFormatValue.md)
 - [DictionaryServiceOsVersion](docs/DictionaryServiceOsVersion.md)
 - [DictionaryServiceOsVersionPage](docs/DictionaryServiceOsVersionPage.md)
 - [DictionaryServiceOsVersionSelector](docs/DictionaryServiceOsVersionSelector.md)
 - [DictionaryServiceOsVersionValue](docs/DictionaryServiceOsVersionValue.md)
 - [DictionaryServicePlacementCategory](docs/DictionaryServicePlacementCategory.md)
 - [DictionaryServicePlacementCategoryList](docs/DictionaryServicePlacementCategoryList.md)
 - [DictionaryServicePlacementCategoryPage](docs/DictionaryServicePlacementCategoryPage.md)
 - [DictionaryServicePlacementCategorySelector](docs/DictionaryServicePlacementCategorySelector.md)
 - [DictionaryServicePlacementCategoryValue](docs/DictionaryServicePlacementCategoryValue.md)
 - [DictionaryServiceThirdPartyTrackingDomain](docs/DictionaryServiceThirdPartyTrackingDomain.md)
 - [DictionaryServiceThirdPartyTrackingDomainPage](docs/DictionaryServiceThirdPartyTrackingDomainPage.md)
 - [DictionaryServiceThirdPartyTrackingDomainValue](docs/DictionaryServiceThirdPartyTrackingDomainValue.md)
 - [Error](docs/Error.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [Feed](docs/Feed.md)
 - [FeedDataServiceDownloadErrorFileSelector](docs/FeedDataServiceDownloadErrorFileSelector.md)
 - [FeedDataServiceFileUploadDateRange](docs/FeedDataServiceFileUploadDateRange.md)
 - [FeedDataServiceFileUploadSrc](docs/FeedDataServiceFileUploadSrc.md)
 - [FeedDataServiceFileUploadStatus](docs/FeedDataServiceFileUploadStatus.md)
 - [FeedDataServiceGetResponse](docs/FeedDataServiceGetResponse.md)
 - [FeedDataServiceItemListUploadType](docs/FeedDataServiceItemListUploadType.md)
 - [FeedDataServicePage](docs/FeedDataServicePage.md)
 - [FeedDataServiceRecord](docs/FeedDataServiceRecord.md)
 - [FeedDataServiceSelector](docs/FeedDataServiceSelector.md)
 - [FeedDataServiceUploadResponse](docs/FeedDataServiceUploadResponse.md)
 - [FeedDataServiceUploadReturnValue](docs/FeedDataServiceUploadReturnValue.md)
 - [FeedDataServiceValue](docs/FeedDataServiceValue.md)
 - [FeedFtp](docs/FeedFtp.md)
 - [FeedFtpRequest](docs/FeedFtpRequest.md)
 - [FeedFtpRequestServiceMutateResponse](docs/FeedFtpRequestServiceMutateResponse.md)
 - [FeedFtpRequestServiceOperation](docs/FeedFtpRequestServiceOperation.md)
 - [FeedFtpRequestServiceReturnValue](docs/FeedFtpRequestServiceReturnValue.md)
 - [FeedFtpRequestServiceValue](docs/FeedFtpRequestServiceValue.md)
 - [FeedFtpServiceActiveStatus](docs/FeedFtpServiceActiveStatus.md)
 - [FeedFtpServiceGetResponse](docs/FeedFtpServiceGetResponse.md)
 - [FeedFtpServiceItemListUploadType](docs/FeedFtpServiceItemListUploadType.md)
 - [FeedFtpServiceMutateResponse](docs/FeedFtpServiceMutateResponse.md)
 - [FeedFtpServiceOperation](docs/FeedFtpServiceOperation.md)
 - [FeedFtpServicePage](docs/FeedFtpServicePage.md)
 - [FeedFtpServiceReturnValue](docs/FeedFtpServiceReturnValue.md)
 - [FeedFtpServiceSchedule](docs/FeedFtpServiceSchedule.md)
 - [FeedFtpServiceScheduleDaily](docs/FeedFtpServiceScheduleDaily.md)
 - [FeedFtpServiceScheduleHourly](docs/FeedFtpServiceScheduleHourly.md)
 - [FeedFtpServiceScheduleType](docs/FeedFtpServiceScheduleType.md)
 - [FeedFtpServiceScheduleWeek](docs/FeedFtpServiceScheduleWeek.md)
 - [FeedFtpServiceScheduleWeekly](docs/FeedFtpServiceScheduleWeekly.md)
 - [FeedFtpServiceSelector](docs/FeedFtpServiceSelector.md)
 - [FeedFtpServiceValue](docs/FeedFtpServiceValue.md)
 - [FeedItem](docs/FeedItem.md)
 - [FeedItemServiceAvailability](docs/FeedItemServiceAvailability.md)
 - [FeedItemServiceIsRemoveFlg](docs/FeedItemServiceIsRemoveFlg.md)
 - [FeedItemServiceMutateResponse](docs/FeedItemServiceMutateResponse.md)
 - [FeedItemServiceOperation](docs/FeedItemServiceOperation.md)
 - [FeedItemServiceReturnValue](docs/FeedItemServiceReturnValue.md)
 - [FeedItemServiceValue](docs/FeedItemServiceValue.md)
 - [FeedServiceControlType](docs/FeedServiceControlType.md)
 - [FeedServiceDownloadDisApprovalReasonListSelector](docs/FeedServiceDownloadDisApprovalReasonListSelector.md)
 - [FeedServiceGetResponse](docs/FeedServiceGetResponse.md)
 - [FeedServiceMutateResponse](docs/FeedServiceMutateResponse.md)
 - [FeedServiceOperation](docs/FeedServiceOperation.md)
 - [FeedServicePage](docs/FeedServicePage.md)
 - [FeedServiceReturnValue](docs/FeedServiceReturnValue.md)
 - [FeedServiceSelector](docs/FeedServiceSelector.md)
 - [FeedServiceSourceType](docs/FeedServiceSourceType.md)
 - [FeedServiceUploadLimit](docs/FeedServiceUploadLimit.md)
 - [FeedServiceValue](docs/FeedServiceValue.md)
 - [FeedSet](docs/FeedSet.md)
 - [FeedSetServiceCompareOperator](docs/FeedSetServiceCompareOperator.md)
 - [FeedSetServiceCondition](docs/FeedSetServiceCondition.md)
 - [FeedSetServiceConditionSet](docs/FeedSetServiceConditionSet.md)
 - [FeedSetServiceConditionType](docs/FeedSetServiceConditionType.md)
 - [FeedSetServiceGetResponse](docs/FeedSetServiceGetResponse.md)
 - [FeedSetServiceMutateResponse](docs/FeedSetServiceMutateResponse.md)
 - [FeedSetServiceOperation](docs/FeedSetServiceOperation.md)
 - [FeedSetServicePage](docs/FeedSetServicePage.md)
 - [FeedSetServiceReturnValue](docs/FeedSetServiceReturnValue.md)
 - [FeedSetServiceSelector](docs/FeedSetServiceSelector.md)
 - [FeedSetServiceValue](docs/FeedSetServiceValue.md)
 - [GuaranteedAdGroup](docs/GuaranteedAdGroup.md)
 - [GuaranteedAdGroupAd](docs/GuaranteedAdGroupAd.md)
 - [GuaranteedAdGroupAdLandingPageStatus](docs/GuaranteedAdGroupAdLandingPageStatus.md)
 - [GuaranteedAdGroupAdServiceAd](docs/GuaranteedAdGroupAdServiceAd.md)
 - [GuaranteedAdGroupAdServiceAdStyle](docs/GuaranteedAdGroupAdServiceAdStyle.md)
 - [GuaranteedAdGroupAdServiceAdType](docs/GuaranteedAdGroupAdServiceAdType.md)
 - [GuaranteedAdGroupAdServiceApprovalStatus](docs/GuaranteedAdGroupAdServiceApprovalStatus.md)
 - [GuaranteedAdGroupAdServiceBannerImageAd](docs/GuaranteedAdGroupAdServiceBannerImageAd.md)
 - [GuaranteedAdGroupAdServiceBannerVideoAd](docs/GuaranteedAdGroupAdServiceBannerVideoAd.md)
 - [GuaranteedAdGroupAdServiceBrandPanelPanorama](docs/GuaranteedAdGroupAdServiceBrandPanelPanorama.md)
 - [GuaranteedAdGroupAdServiceBrandPanelPanoramaVideo](docs/GuaranteedAdGroupAdServiceBrandPanelPanoramaVideo.md)
 - [GuaranteedAdGroupAdServiceBrandPanelQuintie](docs/GuaranteedAdGroupAdServiceBrandPanelQuintie.md)
 - [GuaranteedAdGroupAdServiceBrandPanelQuintieVideo](docs/GuaranteedAdGroupAdServiceBrandPanelQuintieVideo.md)
 - [GuaranteedAdGroupAdServiceCarousel](docs/GuaranteedAdGroupAdServiceCarousel.md)
 - [GuaranteedAdGroupAdServiceCarouselAd](docs/GuaranteedAdGroupAdServiceCarouselAd.md)
 - [GuaranteedAdGroupAdServiceGetResponse](docs/GuaranteedAdGroupAdServiceGetResponse.md)
 - [GuaranteedAdGroupAdServiceInstreamVideoAd](docs/GuaranteedAdGroupAdServiceInstreamVideoAd.md)
 - [GuaranteedAdGroupAdServiceIsRemoveFlg](docs/GuaranteedAdGroupAdServiceIsRemoveFlg.md)
 - [GuaranteedAdGroupAdServiceLabel](docs/GuaranteedAdGroupAdServiceLabel.md)
 - [GuaranteedAdGroupAdServiceMutateResponse](docs/GuaranteedAdGroupAdServiceMutateResponse.md)
 - [GuaranteedAdGroupAdServiceOperation](docs/GuaranteedAdGroupAdServiceOperation.md)
 - [GuaranteedAdGroupAdServicePage](docs/GuaranteedAdGroupAdServicePage.md)
 - [GuaranteedAdGroupAdServiceReturnValue](docs/GuaranteedAdGroupAdServiceReturnValue.md)
 - [GuaranteedAdGroupAdServiceSelector](docs/GuaranteedAdGroupAdServiceSelector.md)
 - [GuaranteedAdGroupAdServiceTopImpactPanorama](docs/GuaranteedAdGroupAdServiceTopImpactPanorama.md)
 - [GuaranteedAdGroupAdServiceTopImpactPanoramaSideSwitchVideo](docs/GuaranteedAdGroupAdServiceTopImpactPanoramaSideSwitchVideo.md)
 - [GuaranteedAdGroupAdServiceTopImpactPanoramaSideVisionVideo](docs/GuaranteedAdGroupAdServiceTopImpactPanoramaSideVisionVideo.md)
 - [GuaranteedAdGroupAdServiceTopImpactPanoramaVideo](docs/GuaranteedAdGroupAdServiceTopImpactPanoramaVideo.md)
 - [GuaranteedAdGroupAdServiceTopImpactPrimeDisplayDouble](docs/GuaranteedAdGroupAdServiceTopImpactPrimeDisplayDouble.md)
 - [GuaranteedAdGroupAdServiceTopImpactPrimeDisplayDoubleVideo](docs/GuaranteedAdGroupAdServiceTopImpactPrimeDisplayDoubleVideo.md)
 - [GuaranteedAdGroupAdServiceTopImpactQuintie](docs/GuaranteedAdGroupAdServiceTopImpactQuintie.md)
 - [GuaranteedAdGroupAdServiceTopImpactQuintieVideo](docs/GuaranteedAdGroupAdServiceTopImpactQuintieVideo.md)
 - [GuaranteedAdGroupAdServiceTopImpactSquare](docs/GuaranteedAdGroupAdServiceTopImpactSquare.md)
 - [GuaranteedAdGroupAdServiceTopImpactSquareSpecial](docs/GuaranteedAdGroupAdServiceTopImpactSquareSpecial.md)
 - [GuaranteedAdGroupAdServiceTopImpactSquareSpecialVideo](docs/GuaranteedAdGroupAdServiceTopImpactSquareSpecialVideo.md)
 - [GuaranteedAdGroupAdServiceTopImpactSquareVideo](docs/GuaranteedAdGroupAdServiceTopImpactSquareVideo.md)
 - [GuaranteedAdGroupAdServiceTopImpactTheaterVideo](docs/GuaranteedAdGroupAdServiceTopImpactTheaterVideo.md)
 - [GuaranteedAdGroupAdServiceUserStatus](docs/GuaranteedAdGroupAdServiceUserStatus.md)
 - [GuaranteedAdGroupAdServiceValue](docs/GuaranteedAdGroupAdServiceValue.md)
 - [GuaranteedAdGroupServiceDeviceAppType](docs/GuaranteedAdGroupServiceDeviceAppType.md)
 - [GuaranteedAdGroupServiceDeviceOsType](docs/GuaranteedAdGroupServiceDeviceOsType.md)
 - [GuaranteedAdGroupServiceDeviceType](docs/GuaranteedAdGroupServiceDeviceType.md)
 - [GuaranteedAdGroupServiceGetResponse](docs/GuaranteedAdGroupServiceGetResponse.md)
 - [GuaranteedAdGroupServiceLabel](docs/GuaranteedAdGroupServiceLabel.md)
 - [GuaranteedAdGroupServiceMutateResponse](docs/GuaranteedAdGroupServiceMutateResponse.md)
 - [GuaranteedAdGroupServiceOperation](docs/GuaranteedAdGroupServiceOperation.md)
 - [GuaranteedAdGroupServicePage](docs/GuaranteedAdGroupServicePage.md)
 - [GuaranteedAdGroupServiceReturnValue](docs/GuaranteedAdGroupServiceReturnValue.md)
 - [GuaranteedAdGroupServiceSelector](docs/GuaranteedAdGroupServiceSelector.md)
 - [GuaranteedAdGroupServiceUserStatus](docs/GuaranteedAdGroupServiceUserStatus.md)
 - [GuaranteedAdGroupServiceValue](docs/GuaranteedAdGroupServiceValue.md)
 - [GuaranteedCampaign](docs/GuaranteedCampaign.md)
 - [GuaranteedCampaignServiceAdCategoryStatus](docs/GuaranteedCampaignServiceAdCategoryStatus.md)
 - [GuaranteedCampaignServiceBrandTracking](docs/GuaranteedCampaignServiceBrandTracking.md)
 - [GuaranteedCampaignServiceCampaignBiddingStrategy](docs/GuaranteedCampaignServiceCampaignBiddingStrategy.md)
 - [GuaranteedCampaignServiceCampaignBiddingStrategyType](docs/GuaranteedCampaignServiceCampaignBiddingStrategyType.md)
 - [GuaranteedCampaignServiceConversionTracker](docs/GuaranteedCampaignServiceConversionTracker.md)
 - [GuaranteedCampaignServiceFrequencyLevel](docs/GuaranteedCampaignServiceFrequencyLevel.md)
 - [GuaranteedCampaignServiceFrequencyTimeUnit](docs/GuaranteedCampaignServiceFrequencyTimeUnit.md)
 - [GuaranteedCampaignServiceGetResponse](docs/GuaranteedCampaignServiceGetResponse.md)
 - [GuaranteedCampaignServiceIsRemoveFlg](docs/GuaranteedCampaignServiceIsRemoveFlg.md)
 - [GuaranteedCampaignServiceLabel](docs/GuaranteedCampaignServiceLabel.md)
 - [GuaranteedCampaignServiceLifetimeBudget](docs/GuaranteedCampaignServiceLifetimeBudget.md)
 - [GuaranteedCampaignServiceMutateResponse](docs/GuaranteedCampaignServiceMutateResponse.md)
 - [GuaranteedCampaignServiceOperation](docs/GuaranteedCampaignServiceOperation.md)
 - [GuaranteedCampaignServicePackage](docs/GuaranteedCampaignServicePackage.md)
 - [GuaranteedCampaignServicePage](docs/GuaranteedCampaignServicePage.md)
 - [GuaranteedCampaignServiceReturnValue](docs/GuaranteedCampaignServiceReturnValue.md)
 - [GuaranteedCampaignServiceSelector](docs/GuaranteedCampaignServiceSelector.md)
 - [GuaranteedCampaignServiceServingStatus](docs/GuaranteedCampaignServiceServingStatus.md)
 - [GuaranteedCampaignServiceUserStatus](docs/GuaranteedCampaignServiceUserStatus.md)
 - [GuaranteedCampaignServiceValue](docs/GuaranteedCampaignServiceValue.md)
 - [GuaranteedCampaignServiceViewableFrequencyCap](docs/GuaranteedCampaignServiceViewableFrequencyCap.md)
 - [GuaranteedInventoryJob](docs/GuaranteedInventoryJob.md)
 - [GuaranteedInventoryServiceActionAfterVideoAdTap](docs/GuaranteedInventoryServiceActionAfterVideoAdTap.md)
 - [GuaranteedInventoryServiceAdGroupTarget](docs/GuaranteedInventoryServiceAdGroupTarget.md)
 - [GuaranteedInventoryServiceAdRequirement](docs/GuaranteedInventoryServiceAdRequirement.md)
 - [GuaranteedInventoryServiceAdScheduleTarget](docs/GuaranteedInventoryServiceAdScheduleTarget.md)
 - [GuaranteedInventoryServiceAdType](docs/GuaranteedInventoryServiceAdType.md)
 - [GuaranteedInventoryServiceAge](docs/GuaranteedInventoryServiceAge.md)
 - [GuaranteedInventoryServiceAgeTarget](docs/GuaranteedInventoryServiceAgeTarget.md)
 - [GuaranteedInventoryServiceAppTarget](docs/GuaranteedInventoryServiceAppTarget.md)
 - [GuaranteedInventoryServiceAudienceCategoryTarget](docs/GuaranteedInventoryServiceAudienceCategoryTarget.md)
 - [GuaranteedInventoryServiceCampaignBiddingStrategyType](docs/GuaranteedInventoryServiceCampaignBiddingStrategyType.md)
 - [GuaranteedInventoryServiceDayOfWeek](docs/GuaranteedInventoryServiceDayOfWeek.md)
 - [GuaranteedInventoryServiceDeviceAppType](docs/GuaranteedInventoryServiceDeviceAppType.md)
 - [GuaranteedInventoryServiceDeviceOsType](docs/GuaranteedInventoryServiceDeviceOsType.md)
 - [GuaranteedInventoryServiceDeviceTarget](docs/GuaranteedInventoryServiceDeviceTarget.md)
 - [GuaranteedInventoryServiceDeviceType](docs/GuaranteedInventoryServiceDeviceType.md)
 - [GuaranteedInventoryServiceFrequencyLevel](docs/GuaranteedInventoryServiceFrequencyLevel.md)
 - [GuaranteedInventoryServiceFrequencyTimeUnit](docs/GuaranteedInventoryServiceFrequencyTimeUnit.md)
 - [GuaranteedInventoryServiceGender](docs/GuaranteedInventoryServiceGender.md)
 - [GuaranteedInventoryServiceGenderTarget](docs/GuaranteedInventoryServiceGenderTarget.md)
 - [GuaranteedInventoryServiceGeoTarget](docs/GuaranteedInventoryServiceGeoTarget.md)
 - [GuaranteedInventoryServiceGetResponse](docs/GuaranteedInventoryServiceGetResponse.md)
 - [GuaranteedInventoryServiceInventory](docs/GuaranteedInventoryServiceInventory.md)
 - [GuaranteedInventoryServiceInventoryDetailStatus](docs/GuaranteedInventoryServiceInventoryDetailStatus.md)
 - [GuaranteedInventoryServiceInventoryJobStatus](docs/GuaranteedInventoryServiceInventoryJobStatus.md)
 - [GuaranteedInventoryServiceInventoryResult](docs/GuaranteedInventoryServiceInventoryResult.md)
 - [GuaranteedInventoryServiceInventoryUnit](docs/GuaranteedInventoryServiceInventoryUnit.md)
 - [GuaranteedInventoryServiceMutateResponse](docs/GuaranteedInventoryServiceMutateResponse.md)
 - [GuaranteedInventoryServiceOperation](docs/GuaranteedInventoryServiceOperation.md)
 - [GuaranteedInventoryServiceOsTarget](docs/GuaranteedInventoryServiceOsTarget.md)
 - [GuaranteedInventoryServicePage](docs/GuaranteedInventoryServicePage.md)
 - [GuaranteedInventoryServicePlacementCategoryDetailTarget](docs/GuaranteedInventoryServicePlacementCategoryDetailTarget.md)
 - [GuaranteedInventoryServicePlacementCategoryTarget](docs/GuaranteedInventoryServicePlacementCategoryTarget.md)
 - [GuaranteedInventoryServicePlacementCategoryType](docs/GuaranteedInventoryServicePlacementCategoryType.md)
 - [GuaranteedInventoryServicePlacementMonopolyFlg](docs/GuaranteedInventoryServicePlacementMonopolyFlg.md)
 - [GuaranteedInventoryServicePositionTarget](docs/GuaranteedInventoryServicePositionTarget.md)
 - [GuaranteedInventoryServicePositionType](docs/GuaranteedInventoryServicePositionType.md)
 - [GuaranteedInventoryServicePredictionResult](docs/GuaranteedInventoryServicePredictionResult.md)
 - [GuaranteedInventoryServicePriceType](docs/GuaranteedInventoryServicePriceType.md)
 - [GuaranteedInventoryServiceReservationStatus](docs/GuaranteedInventoryServiceReservationStatus.md)
 - [GuaranteedInventoryServiceReturnValue](docs/GuaranteedInventoryServiceReturnValue.md)
 - [GuaranteedInventoryServiceSelector](docs/GuaranteedInventoryServiceSelector.md)
 - [GuaranteedInventoryServiceSiteRetargetingTarget](docs/GuaranteedInventoryServiceSiteRetargetingTarget.md)
 - [GuaranteedInventoryServiceTarget](docs/GuaranteedInventoryServiceTarget.md)
 - [GuaranteedInventoryServiceTargetListDeliverType](docs/GuaranteedInventoryServiceTargetListDeliverType.md)
 - [GuaranteedInventoryServiceTargetType](docs/GuaranteedInventoryServiceTargetType.md)
 - [GuaranteedInventoryServiceUnavailableReason](docs/GuaranteedInventoryServiceUnavailableReason.md)
 - [GuaranteedInventoryServiceUnreservableReason](docs/GuaranteedInventoryServiceUnreservableReason.md)
 - [GuaranteedInventoryServiceValue](docs/GuaranteedInventoryServiceValue.md)
 - [GuaranteedInventoryServiceViewableFrequencyCap](docs/GuaranteedInventoryServiceViewableFrequencyCap.md)
 - [GuaranteedPreview](docs/GuaranteedPreview.md)
 - [GuaranteedPreviewServiceAdType](docs/GuaranteedPreviewServiceAdType.md)
 - [GuaranteedPreviewServiceGetResponse](docs/GuaranteedPreviewServiceGetResponse.md)
 - [GuaranteedPreviewServiceMaterial](docs/GuaranteedPreviewServiceMaterial.md)
 - [GuaranteedPreviewServiceMaterialAd](docs/GuaranteedPreviewServiceMaterialAd.md)
 - [GuaranteedPreviewServiceMaterialMedia](docs/GuaranteedPreviewServiceMaterialMedia.md)
 - [GuaranteedPreviewServiceMaterialType](docs/GuaranteedPreviewServiceMaterialType.md)
 - [GuaranteedPreviewServicePage](docs/GuaranteedPreviewServicePage.md)
 - [GuaranteedPreviewServiceSelector](docs/GuaranteedPreviewServiceSelector.md)
 - [GuaranteedPreviewServiceValue](docs/GuaranteedPreviewServiceValue.md)
 - [GuaranteedReservation](docs/GuaranteedReservation.md)
 - [GuaranteedReservationServiceConversionTracker](docs/GuaranteedReservationServiceConversionTracker.md)
 - [GuaranteedReservationServiceMutateResponse](docs/GuaranteedReservationServiceMutateResponse.md)
 - [GuaranteedReservationServiceOperation](docs/GuaranteedReservationServiceOperation.md)
 - [GuaranteedReservationServiceReturnValue](docs/GuaranteedReservationServiceReturnValue.md)
 - [GuaranteedReservationServiceValue](docs/GuaranteedReservationServiceValue.md)
 - [GuaranteedSimulation](docs/GuaranteedSimulation.md)
 - [GuaranteedSimulationServiceActionAfterVideoAdTap](docs/GuaranteedSimulationServiceActionAfterVideoAdTap.md)
 - [GuaranteedSimulationServiceAdCategory](docs/GuaranteedSimulationServiceAdCategory.md)
 - [GuaranteedSimulationServiceAdCategoryPage](docs/GuaranteedSimulationServiceAdCategoryPage.md)
 - [GuaranteedSimulationServiceAdCategoryValue](docs/GuaranteedSimulationServiceAdCategoryValue.md)
 - [GuaranteedSimulationServiceAdGroupTarget](docs/GuaranteedSimulationServiceAdGroupTarget.md)
 - [GuaranteedSimulationServiceAdPlaceType](docs/GuaranteedSimulationServiceAdPlaceType.md)
 - [GuaranteedSimulationServiceAdRequirement](docs/GuaranteedSimulationServiceAdRequirement.md)
 - [GuaranteedSimulationServiceAdScheduleTarget](docs/GuaranteedSimulationServiceAdScheduleTarget.md)
 - [GuaranteedSimulationServiceAdType](docs/GuaranteedSimulationServiceAdType.md)
 - [GuaranteedSimulationServiceAge](docs/GuaranteedSimulationServiceAge.md)
 - [GuaranteedSimulationServiceAgeTarget](docs/GuaranteedSimulationServiceAgeTarget.md)
 - [GuaranteedSimulationServiceAppTarget](docs/GuaranteedSimulationServiceAppTarget.md)
 - [GuaranteedSimulationServiceAudienceCategoryTarget](docs/GuaranteedSimulationServiceAudienceCategoryTarget.md)
 - [GuaranteedSimulationServiceBuyingTerm](docs/GuaranteedSimulationServiceBuyingTerm.md)
 - [GuaranteedSimulationServiceBuyingTermType](docs/GuaranteedSimulationServiceBuyingTermType.md)
 - [GuaranteedSimulationServiceCustomRangeBuyingTerm](docs/GuaranteedSimulationServiceCustomRangeBuyingTerm.md)
 - [GuaranteedSimulationServiceDayOfWeek](docs/GuaranteedSimulationServiceDayOfWeek.md)
 - [GuaranteedSimulationServiceDeviceAppType](docs/GuaranteedSimulationServiceDeviceAppType.md)
 - [GuaranteedSimulationServiceDeviceOsType](docs/GuaranteedSimulationServiceDeviceOsType.md)
 - [GuaranteedSimulationServiceDeviceTarget](docs/GuaranteedSimulationServiceDeviceTarget.md)
 - [GuaranteedSimulationServiceDeviceType](docs/GuaranteedSimulationServiceDeviceType.md)
 - [GuaranteedSimulationServiceDocumentFile](docs/GuaranteedSimulationServiceDocumentFile.md)
 - [GuaranteedSimulationServiceFixedBudgetApplyTermType](docs/GuaranteedSimulationServiceFixedBudgetApplyTermType.md)
 - [GuaranteedSimulationServiceFrequencyLevel](docs/GuaranteedSimulationServiceFrequencyLevel.md)
 - [GuaranteedSimulationServiceFrequencyTimeUnit](docs/GuaranteedSimulationServiceFrequencyTimeUnit.md)
 - [GuaranteedSimulationServiceGender](docs/GuaranteedSimulationServiceGender.md)
 - [GuaranteedSimulationServiceGenderTarget](docs/GuaranteedSimulationServiceGenderTarget.md)
 - [GuaranteedSimulationServiceGeoTarget](docs/GuaranteedSimulationServiceGeoTarget.md)
 - [GuaranteedSimulationServiceGetAdCategoryResponse](docs/GuaranteedSimulationServiceGetAdCategoryResponse.md)
 - [GuaranteedSimulationServiceGetPackageResponse](docs/GuaranteedSimulationServiceGetPackageResponse.md)
 - [GuaranteedSimulationServiceGetResponse](docs/GuaranteedSimulationServiceGetResponse.md)
 - [GuaranteedSimulationServiceInstreamDurationType](docs/GuaranteedSimulationServiceInstreamDurationType.md)
 - [GuaranteedSimulationServiceInventoryResult](docs/GuaranteedSimulationServiceInventoryResult.md)
 - [GuaranteedSimulationServiceMutateResponse](docs/GuaranteedSimulationServiceMutateResponse.md)
 - [GuaranteedSimulationServiceOperation](docs/GuaranteedSimulationServiceOperation.md)
 - [GuaranteedSimulationServiceOsTarget](docs/GuaranteedSimulationServiceOsTarget.md)
 - [GuaranteedSimulationServicePackage](docs/GuaranteedSimulationServicePackage.md)
 - [GuaranteedSimulationServicePackagePage](docs/GuaranteedSimulationServicePackagePage.md)
 - [GuaranteedSimulationServicePackagePermissionType](docs/GuaranteedSimulationServicePackagePermissionType.md)
 - [GuaranteedSimulationServicePackagePermittedAdPlaceTypes](docs/GuaranteedSimulationServicePackagePermittedAdPlaceTypes.md)
 - [GuaranteedSimulationServicePackagePermittedAdScheduleTarget](docs/GuaranteedSimulationServicePackagePermittedAdScheduleTarget.md)
 - [GuaranteedSimulationServicePackagePermittedAgeTarget](docs/GuaranteedSimulationServicePackagePermittedAgeTarget.md)
 - [GuaranteedSimulationServicePackagePermittedAppTarget](docs/GuaranteedSimulationServicePackagePermittedAppTarget.md)
 - [GuaranteedSimulationServicePackagePermittedAudienceCategoryTarget](docs/GuaranteedSimulationServicePackagePermittedAudienceCategoryTarget.md)
 - [GuaranteedSimulationServicePackagePermittedDeviceTarget](docs/GuaranteedSimulationServicePackagePermittedDeviceTarget.md)
 - [GuaranteedSimulationServicePackagePermittedGenderTarget](docs/GuaranteedSimulationServicePackagePermittedGenderTarget.md)
 - [GuaranteedSimulationServicePackagePermittedGeoTarget](docs/GuaranteedSimulationServicePackagePermittedGeoTarget.md)
 - [GuaranteedSimulationServicePackagePermittedOsTarget](docs/GuaranteedSimulationServicePackagePermittedOsTarget.md)
 - [GuaranteedSimulationServicePackagePermittedPlacementCategoryTarget](docs/GuaranteedSimulationServicePackagePermittedPlacementCategoryTarget.md)
 - [GuaranteedSimulationServicePackagePermittedPositionTarget](docs/GuaranteedSimulationServicePackagePermittedPositionTarget.md)
 - [GuaranteedSimulationServicePackagePermittedSiteRetargetingTarget](docs/GuaranteedSimulationServicePackagePermittedSiteRetargetingTarget.md)
 - [GuaranteedSimulationServicePackagePermittedViewableFrequencyCap](docs/GuaranteedSimulationServicePackagePermittedViewableFrequencyCap.md)
 - [GuaranteedSimulationServicePackagePublicLevel](docs/GuaranteedSimulationServicePackagePublicLevel.md)
 - [GuaranteedSimulationServicePackageSelector](docs/GuaranteedSimulationServicePackageSelector.md)
 - [GuaranteedSimulationServicePackageValue](docs/GuaranteedSimulationServicePackageValue.md)
 - [GuaranteedSimulationServicePage](docs/GuaranteedSimulationServicePage.md)
 - [GuaranteedSimulationServicePermittedAdScheduleTarget](docs/GuaranteedSimulationServicePermittedAdScheduleTarget.md)
 - [GuaranteedSimulationServicePermittedAgeTarget](docs/GuaranteedSimulationServicePermittedAgeTarget.md)
 - [GuaranteedSimulationServicePermittedAppTarget](docs/GuaranteedSimulationServicePermittedAppTarget.md)
 - [GuaranteedSimulationServicePermittedAudienceCategoryTarget](docs/GuaranteedSimulationServicePermittedAudienceCategoryTarget.md)
 - [GuaranteedSimulationServicePermittedDeviceTarget](docs/GuaranteedSimulationServicePermittedDeviceTarget.md)
 - [GuaranteedSimulationServicePermittedGenderTarget](docs/GuaranteedSimulationServicePermittedGenderTarget.md)
 - [GuaranteedSimulationServicePermittedGeoTarget](docs/GuaranteedSimulationServicePermittedGeoTarget.md)
 - [GuaranteedSimulationServicePermittedOsTarget](docs/GuaranteedSimulationServicePermittedOsTarget.md)
 - [GuaranteedSimulationServicePermittedPlacementCategoryTarget](docs/GuaranteedSimulationServicePermittedPlacementCategoryTarget.md)
 - [GuaranteedSimulationServicePermittedPositionTarget](docs/GuaranteedSimulationServicePermittedPositionTarget.md)
 - [GuaranteedSimulationServicePermittedSiteRetargetingTarget](docs/GuaranteedSimulationServicePermittedSiteRetargetingTarget.md)
 - [GuaranteedSimulationServicePlacementCategoryDetailTarget](docs/GuaranteedSimulationServicePlacementCategoryDetailTarget.md)
 - [GuaranteedSimulationServicePlacementCategoryTarget](docs/GuaranteedSimulationServicePlacementCategoryTarget.md)
 - [GuaranteedSimulationServicePlacementCategoryType](docs/GuaranteedSimulationServicePlacementCategoryType.md)
 - [GuaranteedSimulationServicePlacementMonopolyFlg](docs/GuaranteedSimulationServicePlacementMonopolyFlg.md)
 - [GuaranteedSimulationServicePositionTarget](docs/GuaranteedSimulationServicePositionTarget.md)
 - [GuaranteedSimulationServicePositionType](docs/GuaranteedSimulationServicePositionType.md)
 - [GuaranteedSimulationServicePrediction](docs/GuaranteedSimulationServicePrediction.md)
 - [GuaranteedSimulationServicePredictionResult](docs/GuaranteedSimulationServicePredictionResult.md)
 - [GuaranteedSimulationServicePriceType](docs/GuaranteedSimulationServicePriceType.md)
 - [GuaranteedSimulationServicePricingPackage](docs/GuaranteedSimulationServicePricingPackage.md)
 - [GuaranteedSimulationServicePromotionalDocument](docs/GuaranteedSimulationServicePromotionalDocument.md)
 - [GuaranteedSimulationServiceRelatedDocument](docs/GuaranteedSimulationServiceRelatedDocument.md)
 - [GuaranteedSimulationServiceReservationStatus](docs/GuaranteedSimulationServiceReservationStatus.md)
 - [GuaranteedSimulationServiceReturnValue](docs/GuaranteedSimulationServiceReturnValue.md)
 - [GuaranteedSimulationServiceSalesDocument](docs/GuaranteedSimulationServiceSalesDocument.md)
 - [GuaranteedSimulationServiceSelector](docs/GuaranteedSimulationServiceSelector.md)
 - [GuaranteedSimulationServiceSingleDayBuyingTerm](docs/GuaranteedSimulationServiceSingleDayBuyingTerm.md)
 - [GuaranteedSimulationServiceSingleTermBuyingTerm](docs/GuaranteedSimulationServiceSingleTermBuyingTerm.md)
 - [GuaranteedSimulationServiceSiteRetargetingTarget](docs/GuaranteedSimulationServiceSiteRetargetingTarget.md)
 - [GuaranteedSimulationServiceSlotsPricingPackage](docs/GuaranteedSimulationServiceSlotsPricingPackage.md)
 - [GuaranteedSimulationServiceTarget](docs/GuaranteedSimulationServiceTarget.md)
 - [GuaranteedSimulationServiceTargetListDeliverType](docs/GuaranteedSimulationServiceTargetListDeliverType.md)
 - [GuaranteedSimulationServiceTargetType](docs/GuaranteedSimulationServiceTargetType.md)
 - [GuaranteedSimulationServiceUnavailableReason](docs/GuaranteedSimulationServiceUnavailableReason.md)
 - [GuaranteedSimulationServiceUnreservableReason](docs/GuaranteedSimulationServiceUnreservableReason.md)
 - [GuaranteedSimulationServiceValue](docs/GuaranteedSimulationServiceValue.md)
 - [GuaranteedSimulationServiceViewableFrequencyCap](docs/GuaranteedSimulationServiceViewableFrequencyCap.md)
 - [GuaranteedSimulationServiceVimpsCustomPricingPackage](docs/GuaranteedSimulationServiceVimpsCustomPricingPackage.md)
 - [GuaranteedSimulationServiceVimpsReachPricingPackage](docs/GuaranteedSimulationServiceVimpsReachPricingPackage.md)
 - [GuaranteedSimulationServiceVimpsSOVPricingPackage](docs/GuaranteedSimulationServiceVimpsSOVPricingPackage.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [Label](docs/Label.md)
 - [LabelServiceGetResponse](docs/LabelServiceGetResponse.md)
 - [LabelServiceMutateResponse](docs/LabelServiceMutateResponse.md)
 - [LabelServiceOperation](docs/LabelServiceOperation.md)
 - [LabelServicePage](docs/LabelServicePage.md)
 - [LabelServiceReturnValue](docs/LabelServiceReturnValue.md)
 - [LabelServiceSelector](docs/LabelServiceSelector.md)
 - [LabelServiceValue](docs/LabelServiceValue.md)
 - [MediaServiceApprovalStatus](docs/MediaServiceApprovalStatus.md)
 - [MediaServiceCampaignBannerFlg](docs/MediaServiceCampaignBannerFlg.md)
 - [MediaServiceCreatedDateRange](docs/MediaServiceCreatedDateRange.md)
 - [MediaServiceDownloadSelector](docs/MediaServiceDownloadSelector.md)
 - [MediaServiceFileType](docs/MediaServiceFileType.md)
 - [MediaServiceGetResponse](docs/MediaServiceGetResponse.md)
 - [MediaServiceImageMedia](docs/MediaServiceImageMedia.md)
 - [MediaServiceLogoFlg](docs/MediaServiceLogoFlg.md)
 - [MediaServiceMutateResponse](docs/MediaServiceMutateResponse.md)
 - [MediaServiceOperation](docs/MediaServiceOperation.md)
 - [MediaServicePage](docs/MediaServicePage.md)
 - [MediaServiceRecord](docs/MediaServiceRecord.md)
 - [MediaServiceReturnValue](docs/MediaServiceReturnValue.md)
 - [MediaServiceRichFormatFlg](docs/MediaServiceRichFormatFlg.md)
 - [MediaServiceSelector](docs/MediaServiceSelector.md)
 - [MediaServiceThumbnailFlg](docs/MediaServiceThumbnailFlg.md)
 - [MediaServiceType](docs/MediaServiceType.md)
 - [MediaServiceUserStatus](docs/MediaServiceUserStatus.md)
 - [MediaServiceValue](docs/MediaServiceValue.md)
 - [PlacementUrlIdea](docs/PlacementUrlIdea.md)
 - [PlacementUrlIdeaServiceAdFormat](docs/PlacementUrlIdeaServiceAdFormat.md)
 - [PlacementUrlIdeaServiceAdFormatConditions](docs/PlacementUrlIdeaServiceAdFormatConditions.md)
 - [PlacementUrlIdeaServiceGetResponse](docs/PlacementUrlIdeaServiceGetResponse.md)
 - [PlacementUrlIdeaServicePage](docs/PlacementUrlIdeaServicePage.md)
 - [PlacementUrlIdeaServiceSelector](docs/PlacementUrlIdeaServiceSelector.md)
 - [PlacementUrlIdeaServiceValue](docs/PlacementUrlIdeaServiceValue.md)
 - [PlacementUrlList](docs/PlacementUrlList.md)
 - [PlacementUrlListServiceGetResponse](docs/PlacementUrlListServiceGetResponse.md)
 - [PlacementUrlListServiceIsRemoveFlg](docs/PlacementUrlListServiceIsRemoveFlg.md)
 - [PlacementUrlListServiceMutateResponse](docs/PlacementUrlListServiceMutateResponse.md)
 - [PlacementUrlListServiceOperation](docs/PlacementUrlListServiceOperation.md)
 - [PlacementUrlListServicePage](docs/PlacementUrlListServicePage.md)
 - [PlacementUrlListServiceReturnValue](docs/PlacementUrlListServiceReturnValue.md)
 - [PlacementUrlListServiceSelector](docs/PlacementUrlListServiceSelector.md)
 - [PlacementUrlListServiceUnknownDomainFlg](docs/PlacementUrlListServiceUnknownDomainFlg.md)
 - [PlacementUrlListServiceUrlActiveFlg](docs/PlacementUrlListServiceUrlActiveFlg.md)
 - [PlacementUrlListServiceUrlList](docs/PlacementUrlListServiceUrlList.md)
 - [PlacementUrlListServiceValue](docs/PlacementUrlListServiceValue.md)
 - [Recommendation](docs/Recommendation.md)
 - [RecommendationServiceCampaignBiddingStrategyToTargetCpa](docs/RecommendationServiceCampaignBiddingStrategyToTargetCpa.md)
 - [RecommendationServiceCampaignBiddingStrategyToTargetCpaCampaign](docs/RecommendationServiceCampaignBiddingStrategyToTargetCpaCampaign.md)
 - [RecommendationServiceCampaignsForAddingAds](docs/RecommendationServiceCampaignsForAddingAds.md)
 - [RecommendationServiceCampaignsForAddingAdsCampaign](docs/RecommendationServiceCampaignsForAddingAdsCampaign.md)
 - [RecommendationServiceDailyBudgetOver](docs/RecommendationServiceDailyBudgetOver.md)
 - [RecommendationServiceDailyBudgetOverCampaign](docs/RecommendationServiceDailyBudgetOverCampaign.md)
 - [RecommendationServiceGetResponse](docs/RecommendationServiceGetResponse.md)
 - [RecommendationServiceImpsShareBudgetLossOver](docs/RecommendationServiceImpsShareBudgetLossOver.md)
 - [RecommendationServiceImpsShareBudgetLossOverCampaign](docs/RecommendationServiceImpsShareBudgetLossOverCampaign.md)
 - [RecommendationServicePage](docs/RecommendationServicePage.md)
 - [RecommendationServiceSearchKeywordIdea](docs/RecommendationServiceSearchKeywordIdea.md)
 - [RecommendationServiceSearchKeywordIdeaSearchKeywordList](docs/RecommendationServiceSearchKeywordIdeaSearchKeywordList.md)
 - [RecommendationServiceSelector](docs/RecommendationServiceSelector.md)
 - [RecommendationServiceType](docs/RecommendationServiceType.md)
 - [RecommendationServiceValue](docs/RecommendationServiceValue.md)
 - [ReportDefinition](docs/ReportDefinition.md)
 - [ReportDefinitionServiceAccount](docs/ReportDefinitionServiceAccount.md)
 - [ReportDefinitionServiceConversionPathAccountSetting](docs/ReportDefinitionServiceConversionPathAccountSetting.md)
 - [ReportDefinitionServiceConversionPathFilter](docs/ReportDefinitionServiceConversionPathFilter.md)
 - [ReportDefinitionServiceConversionPathFilterOperator](docs/ReportDefinitionServiceConversionPathFilterOperator.md)
 - [ReportDefinitionServiceConversionPathFilterType](docs/ReportDefinitionServiceConversionPathFilterType.md)
 - [ReportDefinitionServiceConversionPathReportCondition](docs/ReportDefinitionServiceConversionPathReportCondition.md)
 - [ReportDefinitionServiceCrossCampaignBuying](docs/ReportDefinitionServiceCrossCampaignBuying.md)
 - [ReportDefinitionServiceCrossCampaignBuyingType](docs/ReportDefinitionServiceCrossCampaignBuyingType.md)
 - [ReportDefinitionServiceCrossCampaignGoal](docs/ReportDefinitionServiceCrossCampaignGoal.md)
 - [ReportDefinitionServiceCrossCampaignId](docs/ReportDefinitionServiceCrossCampaignId.md)
 - [ReportDefinitionServiceCrossCampaignReachesReportCondition](docs/ReportDefinitionServiceCrossCampaignReachesReportCondition.md)
 - [ReportDefinitionServiceCrossCampaignType](docs/ReportDefinitionServiceCrossCampaignType.md)
 - [ReportDefinitionServiceDateRange](docs/ReportDefinitionServiceDateRange.md)
 - [ReportDefinitionServiceDownloadSelector](docs/ReportDefinitionServiceDownloadSelector.md)
 - [ReportDefinitionServiceFieldAttribute](docs/ReportDefinitionServiceFieldAttribute.md)
 - [ReportDefinitionServiceFieldValue](docs/ReportDefinitionServiceFieldValue.md)
 - [ReportDefinitionServiceFilter](docs/ReportDefinitionServiceFilter.md)
 - [ReportDefinitionServiceFilterOperator](docs/ReportDefinitionServiceFilterOperator.md)
 - [ReportDefinitionServiceFrequencyRange](docs/ReportDefinitionServiceFrequencyRange.md)
 - [ReportDefinitionServiceGetReportFields](docs/ReportDefinitionServiceGetReportFields.md)
 - [ReportDefinitionServiceGetReportFieldsResponse](docs/ReportDefinitionServiceGetReportFieldsResponse.md)
 - [ReportDefinitionServiceGetResponse](docs/ReportDefinitionServiceGetResponse.md)
 - [ReportDefinitionServiceIncludeViewInteractionFlg](docs/ReportDefinitionServiceIncludeViewInteractionFlg.md)
 - [ReportDefinitionServiceMutateResponse](docs/ReportDefinitionServiceMutateResponse.md)
 - [ReportDefinitionServiceOperation](docs/ReportDefinitionServiceOperation.md)
 - [ReportDefinitionServicePage](docs/ReportDefinitionServicePage.md)
 - [ReportDefinitionServiceProductType](docs/ReportDefinitionServiceProductType.md)
 - [ReportDefinitionServiceReachReportCondition](docs/ReportDefinitionServiceReachReportCondition.md)
 - [ReportDefinitionServiceReportCompressType](docs/ReportDefinitionServiceReportCompressType.md)
 - [ReportDefinitionServiceReportDateRangeType](docs/ReportDefinitionServiceReportDateRangeType.md)
 - [ReportDefinitionServiceReportDecimalPartDisplayType](docs/ReportDefinitionServiceReportDecimalPartDisplayType.md)
 - [ReportDefinitionServiceReportDownloadEncode](docs/ReportDefinitionServiceReportDownloadEncode.md)
 - [ReportDefinitionServiceReportDownloadFormat](docs/ReportDefinitionServiceReportDownloadFormat.md)
 - [ReportDefinitionServiceReportJobStatus](docs/ReportDefinitionServiceReportJobStatus.md)
 - [ReportDefinitionServiceReportLanguage](docs/ReportDefinitionServiceReportLanguage.md)
 - [ReportDefinitionServiceReportSkipColumnHeader](docs/ReportDefinitionServiceReportSkipColumnHeader.md)
 - [ReportDefinitionServiceReportSkipReportSummary](docs/ReportDefinitionServiceReportSkipReportSummary.md)
 - [ReportDefinitionServiceReportSortField](docs/ReportDefinitionServiceReportSortField.md)
 - [ReportDefinitionServiceReportSortType](docs/ReportDefinitionServiceReportSortType.md)
 - [ReportDefinitionServiceReportTypeCondition](docs/ReportDefinitionServiceReportTypeCondition.md)
 - [ReportDefinitionServiceReturnValue](docs/ReportDefinitionServiceReturnValue.md)
 - [ReportDefinitionServiceSelector](docs/ReportDefinitionServiceSelector.md)
 - [ReportDefinitionServiceType](docs/ReportDefinitionServiceType.md)
 - [ReportDefinitionServiceValue](docs/ReportDefinitionServiceValue.md)
 - [RetargetingList](docs/RetargetingList.md)
 - [RetargetingListServiceCombination](docs/RetargetingListServiceCombination.md)
 - [RetargetingListServiceCombinationTargetList](docs/RetargetingListServiceCombinationTargetList.md)
 - [RetargetingListServiceCompareOperator](docs/RetargetingListServiceCompareOperator.md)
 - [RetargetingListServiceCustomAudienceTargetList](docs/RetargetingListServiceCustomAudienceTargetList.md)
 - [RetargetingListServiceDeliveryStatus](docs/RetargetingListServiceDeliveryStatus.md)
 - [RetargetingListServiceGetResponse](docs/RetargetingListServiceGetResponse.md)
 - [RetargetingListServiceGetUploadUserListResponse](docs/RetargetingListServiceGetUploadUserListResponse.md)
 - [RetargetingListServiceIsOpen](docs/RetargetingListServiceIsOpen.md)
 - [RetargetingListServiceIsPreset](docs/RetargetingListServiceIsPreset.md)
 - [RetargetingListServiceIsRemoveFlg](docs/RetargetingListServiceIsRemoveFlg.md)
 - [RetargetingListServiceJobStatus](docs/RetargetingListServiceJobStatus.md)
 - [RetargetingListServiceLogicalOperator](docs/RetargetingListServiceLogicalOperator.md)
 - [RetargetingListServiceMutateResponse](docs/RetargetingListServiceMutateResponse.md)
 - [RetargetingListServiceOperation](docs/RetargetingListServiceOperation.md)
 - [RetargetingListServicePage](docs/RetargetingListServicePage.md)
 - [RetargetingListServiceReturnValue](docs/RetargetingListServiceReturnValue.md)
 - [RetargetingListServiceRule](docs/RetargetingListServiceRule.md)
 - [RetargetingListServiceRuleCondition](docs/RetargetingListServiceRuleCondition.md)
 - [RetargetingListServiceRuleTargetList](docs/RetargetingListServiceRuleTargetList.md)
 - [RetargetingListServiceRuleType](docs/RetargetingListServiceRuleType.md)
 - [RetargetingListServiceSelector](docs/RetargetingListServiceSelector.md)
 - [RetargetingListServiceSharingStatusFilterType](docs/RetargetingListServiceSharingStatusFilterType.md)
 - [RetargetingListServiceSimilarityTargetList](docs/RetargetingListServiceSimilarityTargetList.md)
 - [RetargetingListServiceTargetList](docs/RetargetingListServiceTargetList.md)
 - [RetargetingListServiceTargetListData](docs/RetargetingListServiceTargetListData.md)
 - [RetargetingListServiceTargetListSize](docs/RetargetingListServiceTargetListSize.md)
 - [RetargetingListServiceTargetListSizeReaches](docs/RetargetingListServiceTargetListSizeReaches.md)
 - [RetargetingListServiceTargetListType](docs/RetargetingListServiceTargetListType.md)
 - [RetargetingListServiceUploadUserListCompressType](docs/RetargetingListServiceUploadUserListCompressType.md)
 - [RetargetingListServiceUploadUserListJob](docs/RetargetingListServiceUploadUserListJob.md)
 - [RetargetingListServiceUploadUserListPage](docs/RetargetingListServiceUploadUserListPage.md)
 - [RetargetingListServiceUploadUserListResponse](docs/RetargetingListServiceUploadUserListResponse.md)
 - [RetargetingListServiceUploadUserListReturnValue](docs/RetargetingListServiceUploadUserListReturnValue.md)
 - [RetargetingListServiceUploadUserListStatusSelector](docs/RetargetingListServiceUploadUserListStatusSelector.md)
 - [RetargetingListServiceUploadUserListUploadType](docs/RetargetingListServiceUploadUserListUploadType.md)
 - [RetargetingListServiceUploadUserListValue](docs/RetargetingListServiceUploadUserListValue.md)
 - [RetargetingListServiceValue](docs/RetargetingListServiceValue.md)
 - [RetargetingTag](docs/RetargetingTag.md)
 - [RetargetingTagServiceApprovalStatus](docs/RetargetingTagServiceApprovalStatus.md)
 - [RetargetingTagServiceGetResponse](docs/RetargetingTagServiceGetResponse.md)
 - [RetargetingTagServiceMutateResponse](docs/RetargetingTagServiceMutateResponse.md)
 - [RetargetingTagServiceOperation](docs/RetargetingTagServiceOperation.md)
 - [RetargetingTagServicePage](docs/RetargetingTagServicePage.md)
 - [RetargetingTagServiceReturnValue](docs/RetargetingTagServiceReturnValue.md)
 - [RetargetingTagServiceSelector](docs/RetargetingTagServiceSelector.md)
 - [RetargetingTagServiceValue](docs/RetargetingTagServiceValue.md)
 - [SearchKeywordIdea](docs/SearchKeywordIdea.md)
 - [SearchKeywordIdeaServiceAvailabilityStatus](docs/SearchKeywordIdeaServiceAvailabilityStatus.md)
 - [SearchKeywordIdeaServiceGetResponse](docs/SearchKeywordIdeaServiceGetResponse.md)
 - [SearchKeywordIdeaServiceKeywordFrequency](docs/SearchKeywordIdeaServiceKeywordFrequency.md)
 - [SearchKeywordIdeaServiceKeywordRecency](docs/SearchKeywordIdeaServiceKeywordRecency.md)
 - [SearchKeywordIdeaServiceMatchType](docs/SearchKeywordIdeaServiceMatchType.md)
 - [SearchKeywordIdeaServicePage](docs/SearchKeywordIdeaServicePage.md)
 - [SearchKeywordIdeaServiceSelector](docs/SearchKeywordIdeaServiceSelector.md)
 - [SearchKeywordIdeaServiceSortField](docs/SearchKeywordIdeaServiceSortField.md)
 - [SearchKeywordIdeaServiceSortType](docs/SearchKeywordIdeaServiceSortType.md)
 - [SearchKeywordIdeaServiceValue](docs/SearchKeywordIdeaServiceValue.md)
 - [SearchKeywordList](docs/SearchKeywordList.md)
 - [SearchKeywordListServiceDeliveryStatus](docs/SearchKeywordListServiceDeliveryStatus.md)
 - [SearchKeywordListServiceGetResponse](docs/SearchKeywordListServiceGetResponse.md)
 - [SearchKeywordListServiceIsRemoveFlg](docs/SearchKeywordListServiceIsRemoveFlg.md)
 - [SearchKeywordListServiceKeywordFrequency](docs/SearchKeywordListServiceKeywordFrequency.md)
 - [SearchKeywordListServiceKeywordRecency](docs/SearchKeywordListServiceKeywordRecency.md)
 - [SearchKeywordListServiceMutateResponse](docs/SearchKeywordListServiceMutateResponse.md)
 - [SearchKeywordListServiceOperation](docs/SearchKeywordListServiceOperation.md)
 - [SearchKeywordListServicePage](docs/SearchKeywordListServicePage.md)
 - [SearchKeywordListServiceReturnValue](docs/SearchKeywordListServiceReturnValue.md)
 - [SearchKeywordListServiceSearchKeyword](docs/SearchKeywordListServiceSearchKeyword.md)
 - [SearchKeywordListServiceSelector](docs/SearchKeywordListServiceSelector.md)
 - [SearchKeywordListServiceValue](docs/SearchKeywordListServiceValue.md)
 - [SearchLift](docs/SearchLift.md)
 - [SearchLiftServiceGetResponse](docs/SearchLiftServiceGetResponse.md)
 - [SearchLiftServiceKeyword](docs/SearchLiftServiceKeyword.md)
 - [SearchLiftServiceKeywordCategory](docs/SearchLiftServiceKeywordCategory.md)
 - [SearchLiftServicePage](docs/SearchLiftServicePage.md)
 - [SearchLiftServiceSelector](docs/SearchLiftServiceSelector.md)
 - [SearchLiftServiceValue](docs/SearchLiftServiceValue.md)
 - [Stats](docs/Stats.md)
 - [StatsServiceAdGroupStatsValue](docs/StatsServiceAdGroupStatsValue.md)
 - [StatsServiceAdScheduleTarget](docs/StatsServiceAdScheduleTarget.md)
 - [StatsServiceAdStatsValue](docs/StatsServiceAdStatsValue.md)
 - [StatsServiceAge](docs/StatsServiceAge.md)
 - [StatsServiceAgeTarget](docs/StatsServiceAgeTarget.md)
 - [StatsServiceAppTarget](docs/StatsServiceAppTarget.md)
 - [StatsServiceAudienceCategoryTarget](docs/StatsServiceAudienceCategoryTarget.md)
 - [StatsServiceCampaignStatsValue](docs/StatsServiceCampaignStatsValue.md)
 - [StatsServiceContentsTarget](docs/StatsServiceContentsTarget.md)
 - [StatsServiceDayOfWeek](docs/StatsServiceDayOfWeek.md)
 - [StatsServiceDeviceAppType](docs/StatsServiceDeviceAppType.md)
 - [StatsServiceDeviceOsType](docs/StatsServiceDeviceOsType.md)
 - [StatsServiceDeviceTarget](docs/StatsServiceDeviceTarget.md)
 - [StatsServiceDeviceType](docs/StatsServiceDeviceType.md)
 - [StatsServiceEstimateFlg](docs/StatsServiceEstimateFlg.md)
 - [StatsServiceGender](docs/StatsServiceGender.md)
 - [StatsServiceGenderTarget](docs/StatsServiceGenderTarget.md)
 - [StatsServiceGeoTarget](docs/StatsServiceGeoTarget.md)
 - [StatsServiceGetResponse](docs/StatsServiceGetResponse.md)
 - [StatsServiceImageStatsValue](docs/StatsServiceImageStatsValue.md)
 - [StatsServiceOsTarget](docs/StatsServiceOsTarget.md)
 - [StatsServiceOsVersionTarget](docs/StatsServiceOsVersionTarget.md)
 - [StatsServicePage](docs/StatsServicePage.md)
 - [StatsServicePeriod](docs/StatsServicePeriod.md)
 - [StatsServicePeriodCustomDate](docs/StatsServicePeriodCustomDate.md)
 - [StatsServicePeriodDatetime](docs/StatsServicePeriodDatetime.md)
 - [StatsServicePlacementCategoryDetailTarget](docs/StatsServicePlacementCategoryDetailTarget.md)
 - [StatsServicePlacementCategoryType](docs/StatsServicePlacementCategoryType.md)
 - [StatsServicePlacementTarget](docs/StatsServicePlacementTarget.md)
 - [StatsServicePlacementUrlListType](docs/StatsServicePlacementUrlListType.md)
 - [StatsServiceSearchTarget](docs/StatsServiceSearchTarget.md)
 - [StatsServiceSelector](docs/StatsServiceSelector.md)
 - [StatsServiceSiteCategoryTarget](docs/StatsServiceSiteCategoryTarget.md)
 - [StatsServiceSiteRetargetingTarget](docs/StatsServiceSiteRetargetingTarget.md)
 - [StatsServiceStatsPeriod](docs/StatsServiceStatsPeriod.md)
 - [StatsServiceTarget](docs/StatsServiceTarget.md)
 - [StatsServiceTargetListDeliverType](docs/StatsServiceTargetListDeliverType.md)
 - [StatsServiceTargetSetting](docs/StatsServiceTargetSetting.md)
 - [StatsServiceTargetStatsValue](docs/StatsServiceTargetStatsValue.md)
 - [StatsServiceTargetType](docs/StatsServiceTargetType.md)
 - [StatsServiceType](docs/StatsServiceType.md)
 - [StatsServiceValue](docs/StatsServiceValue.md)
 - [StatsServiceVideoStatsValue](docs/StatsServiceVideoStatsValue.md)
 - [Video](docs/Video.md)
 - [VideoServiceApprovalStatus](docs/VideoServiceApprovalStatus.md)
 - [VideoServiceCreatedDateRange](docs/VideoServiceCreatedDateRange.md)
 - [VideoServiceDownloadSelector](docs/VideoServiceDownloadSelector.md)
 - [VideoServiceFileType](docs/VideoServiceFileType.md)
 - [VideoServiceGetResponse](docs/VideoServiceGetResponse.md)
 - [VideoServiceMutateResponse](docs/VideoServiceMutateResponse.md)
 - [VideoServiceOperation](docs/VideoServiceOperation.md)
 - [VideoServicePage](docs/VideoServicePage.md)
 - [VideoServiceProcessStatus](docs/VideoServiceProcessStatus.md)
 - [VideoServiceQualityType](docs/VideoServiceQualityType.md)
 - [VideoServiceReturnValue](docs/VideoServiceReturnValue.md)
 - [VideoServiceSelector](docs/VideoServiceSelector.md)
 - [VideoServiceSetting](docs/VideoServiceSetting.md)
 - [VideoServiceUploadData](docs/VideoServiceUploadData.md)
 - [VideoServiceUploadResponse](docs/VideoServiceUploadResponse.md)
 - [VideoServiceUploadReturnValue](docs/VideoServiceUploadReturnValue.md)
 - [VideoServiceUploadValue](docs/VideoServiceUploadValue.md)
 - [VideoServiceUserStatus](docs/VideoServiceUserStatus.md)
 - [VideoServiceValue](docs/VideoServiceValue.md)


## Documentation For Authorization


## oAuth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://biz-oauth.yahoo.co.jp/oauth/v1/authorize
- **Scopes**: 
 - **yahooads**: アプリケーションを経由したYahoo!広告の各機能の操作/Operation by each function of Yahoo! JAPAN Ads via applications.


## Author




