"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTask = exports.CfnLocationSMB = exports.CfnLocationS3 = exports.CfnLocationObjectStorage = exports.CfnLocationNFS = exports.CfnLocationHDFS = exports.CfnLocationFSxWindows = exports.CfnLocationFSxOpenZFS = exports.CfnLocationFSxONTAP = exports.CfnLocationFSxLustre = exports.CfnLocationEFS = exports.CfnAgent = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-03-22T18:42:11.926Z","fingerprint":"fi9mK341kgouQKvcVZAyNrpZwXN4jo6989SgM8GxEzg="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAgentProps`
 *
 * @param properties - the TypeScript properties of a `CfnAgentProps`
 *
 * @returns the result of the validation.
 */
function CfnAgentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('activationKey', cdk.validateString)(properties.activationKey));
    errors.collect(cdk.propertyValidator('agentName', cdk.validateString)(properties.agentName));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subnetArns', cdk.listValidator(cdk.validateString))(properties.subnetArns));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcEndpointId', cdk.validateString)(properties.vpcEndpointId));
    return errors.wrap('supplied properties not correct for "CfnAgentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Agent` resource
 *
 * @param properties - the TypeScript properties of a `CfnAgentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Agent` resource.
 */
// @ts-ignore TS6133
function cfnAgentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAgentPropsValidator(properties).assertSuccess();
    return {
        ActivationKey: cdk.stringToCloudFormation(properties.activationKey),
        AgentName: cdk.stringToCloudFormation(properties.agentName),
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        SubnetArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetArns),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VpcEndpointId: cdk.stringToCloudFormation(properties.vpcEndpointId),
    };
}
// @ts-ignore TS6133
function CfnAgentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('activationKey', 'ActivationKey', properties.ActivationKey != null ? cfn_parse.FromCloudFormation.getString(properties.ActivationKey) : undefined);
    ret.addPropertyResult('agentName', 'AgentName', properties.AgentName != null ? cfn_parse.FromCloudFormation.getString(properties.AgentName) : undefined);
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', properties.SecurityGroupArns != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns) : undefined);
    ret.addPropertyResult('subnetArns', 'SubnetArns', properties.SubnetArns != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SubnetArns) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcEndpointId', 'VpcEndpointId', properties.VpcEndpointId != null ? cfn_parse.FromCloudFormation.getString(properties.VpcEndpointId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::Agent`
 *
 * The `AWS::DataSync::Agent` resource specifies an AWS DataSync agent to be deployed and activated on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the AWS Region that you want to activate the agent in. You activate the agent in the AWS Region where your target locations (in Amazon S3, Amazon EFS, or Amazon FSx for Windows File Server) reside. Your tasks are created in this AWS Region .
 *
 * You can activate the agent in a virtual private cloud (VPC) or provide the agent access to a VPC endpoint so that you can run tasks without sending them over the public internet.
 *
 * You can specify an agent to be used for more than one location. If a task uses multiple agents, all of them must have a status of AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
 *
 * For more information, see [Activating an Agent](https://docs.aws.amazon.com/datasync/latest/userguide/activating-agent.html) in the *AWS DataSync User Guide* .
 *
 * Agents are automatically updated by AWS on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
 *
 * @cloudformationResource AWS::DataSync::Agent
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html
 */
class CfnAgent extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::Agent`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnAgent.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnAgentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAgent);
            }
            throw error;
        }
        this.attrAgentArn = cdk.Token.asString(this.getAtt('AgentArn'));
        this.attrEndpointType = cdk.Token.asString(this.getAtt('EndpointType'));
        this.activationKey = props.activationKey;
        this.agentName = props.agentName;
        this.securityGroupArns = props.securityGroupArns;
        this.subnetArns = props.subnetArns;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::Agent", props.tags, { tagPropertyName: 'tags' });
        this.vpcEndpointId = props.vpcEndpointId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAgentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAgent(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAgent.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            activationKey: this.activationKey,
            agentName: this.agentName,
            securityGroupArns: this.securityGroupArns,
            subnetArns: this.subnetArns,
            tags: this.tags.renderTags(),
            vpcEndpointId: this.vpcEndpointId,
        };
    }
    renderProperties(props) {
        return cfnAgentPropsToCloudFormation(props);
    }
}
exports.CfnAgent = CfnAgent;
_a = JSII_RTTI_SYMBOL_1;
CfnAgent[_a] = { fqn: "@aws-cdk/aws-datasync.CfnAgent", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAgent.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::Agent";
/**
 * Determine whether the given properties match those of a `CfnLocationEFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationEFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationEFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessPointArn', cdk.validateString)(properties.accessPointArn));
    errors.collect(cdk.propertyValidator('ec2Config', cdk.requiredValidator)(properties.ec2Config));
    errors.collect(cdk.propertyValidator('ec2Config', CfnLocationEFS_Ec2ConfigPropertyValidator)(properties.ec2Config));
    errors.collect(cdk.propertyValidator('efsFilesystemArn', cdk.validateString)(properties.efsFilesystemArn));
    errors.collect(cdk.propertyValidator('fileSystemAccessRoleArn', cdk.validateString)(properties.fileSystemAccessRoleArn));
    errors.collect(cdk.propertyValidator('inTransitEncryption', cdk.validateString)(properties.inTransitEncryption));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationEFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationEFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationEFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationEFSPropsValidator(properties).assertSuccess();
    return {
        Ec2Config: cfnLocationEFSEc2ConfigPropertyToCloudFormation(properties.ec2Config),
        AccessPointArn: cdk.stringToCloudFormation(properties.accessPointArn),
        EfsFilesystemArn: cdk.stringToCloudFormation(properties.efsFilesystemArn),
        FileSystemAccessRoleArn: cdk.stringToCloudFormation(properties.fileSystemAccessRoleArn),
        InTransitEncryption: cdk.stringToCloudFormation(properties.inTransitEncryption),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationEFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('ec2Config', 'Ec2Config', CfnLocationEFSEc2ConfigPropertyFromCloudFormation(properties.Ec2Config));
    ret.addPropertyResult('accessPointArn', 'AccessPointArn', properties.AccessPointArn != null ? cfn_parse.FromCloudFormation.getString(properties.AccessPointArn) : undefined);
    ret.addPropertyResult('efsFilesystemArn', 'EfsFilesystemArn', properties.EfsFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.EfsFilesystemArn) : undefined);
    ret.addPropertyResult('fileSystemAccessRoleArn', 'FileSystemAccessRoleArn', properties.FileSystemAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.FileSystemAccessRoleArn) : undefined);
    ret.addPropertyResult('inTransitEncryption', 'InTransitEncryption', properties.InTransitEncryption != null ? cfn_parse.FromCloudFormation.getString(properties.InTransitEncryption) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationEFS`
 *
 * The `AWS::DataSync::LocationEFS` resource creates an endpoint for an Amazon EFS file system. AWS DataSync can access this endpoint as a source or destination location.
 *
 * @cloudformationResource AWS::DataSync::LocationEFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html
 */
class CfnLocationEFS extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationEFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationEFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationEFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationEFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'ec2Config', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.ec2Config = props.ec2Config;
        this.accessPointArn = props.accessPointArn;
        this.efsFilesystemArn = props.efsFilesystemArn;
        this.fileSystemAccessRoleArn = props.fileSystemAccessRoleArn;
        this.inTransitEncryption = props.inTransitEncryption;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationEFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationEFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationEFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationEFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            ec2Config: this.ec2Config,
            accessPointArn: this.accessPointArn,
            efsFilesystemArn: this.efsFilesystemArn,
            fileSystemAccessRoleArn: this.fileSystemAccessRoleArn,
            inTransitEncryption: this.inTransitEncryption,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationEFSPropsToCloudFormation(props);
    }
}
exports.CfnLocationEFS = CfnLocationEFS;
_b = JSII_RTTI_SYMBOL_1;
CfnLocationEFS[_b] = { fqn: "@aws-cdk/aws-datasync.CfnLocationEFS", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationEFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationEFS";
/**
 * Determine whether the given properties match those of a `Ec2ConfigProperty`
 *
 * @param properties - the TypeScript properties of a `Ec2ConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationEFS_Ec2ConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subnetArn', cdk.requiredValidator)(properties.subnetArn));
    errors.collect(cdk.propertyValidator('subnetArn', cdk.validateString)(properties.subnetArn));
    return errors.wrap('supplied properties not correct for "Ec2ConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS.Ec2Config` resource
 *
 * @param properties - the TypeScript properties of a `Ec2ConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationEFS.Ec2Config` resource.
 */
// @ts-ignore TS6133
function cfnLocationEFSEc2ConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationEFS_Ec2ConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        SubnetArn: cdk.stringToCloudFormation(properties.subnetArn),
    };
}
// @ts-ignore TS6133
function CfnLocationEFSEc2ConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('subnetArn', 'SubnetArn', cfn_parse.FromCloudFormation.getString(properties.SubnetArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationFSxLustreProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxLustreProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxLustrePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fsxFilesystemArn', cdk.validateString)(properties.fsxFilesystemArn));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxLustreProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxLustre` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxLustreProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxLustre` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxLustrePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxLustrePropsValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        FsxFilesystemArn: cdk.stringToCloudFormation(properties.fsxFilesystemArn),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxLustrePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('fsxFilesystemArn', 'FsxFilesystemArn', properties.FsxFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.FsxFilesystemArn) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxLustre`
 *
 * The `AWS::DataSync::LocationFSxLustre` resource specifies an endpoint for an Amazon FSx for Lustre file system.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxLustre
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxlustre.html
 */
class CfnLocationFSxLustre extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationFSxLustre`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxLustre.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationFSxLustreProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxLustre);
            }
            throw error;
        }
        cdk.requireProperty(props, 'securityGroupArns', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.securityGroupArns = props.securityGroupArns;
        this.fsxFilesystemArn = props.fsxFilesystemArn;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxLustre", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxLustrePropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxLustre(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxLustre.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            securityGroupArns: this.securityGroupArns,
            fsxFilesystemArn: this.fsxFilesystemArn,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxLustrePropsToCloudFormation(props);
    }
}
exports.CfnLocationFSxLustre = CfnLocationFSxLustre;
_c = JSII_RTTI_SYMBOL_1;
CfnLocationFSxLustre[_c] = { fqn: "@aws-cdk/aws-datasync.CfnLocationFSxLustre", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxLustre.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxLustre";
/**
 * Determine whether the given properties match those of a `CfnLocationFSxONTAPProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxONTAPProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAPPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('protocol', CfnLocationFSxONTAP_ProtocolPropertyValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('storageVirtualMachineArn', cdk.requiredValidator)(properties.storageVirtualMachineArn));
    errors.collect(cdk.propertyValidator('storageVirtualMachineArn', cdk.validateString)(properties.storageVirtualMachineArn));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxONTAPProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxONTAPProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAPPropsValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        StorageVirtualMachineArn: cdk.stringToCloudFormation(properties.storageVirtualMachineArn),
        Protocol: cfnLocationFSxONTAPProtocolPropertyToCloudFormation(properties.protocol),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('storageVirtualMachineArn', 'StorageVirtualMachineArn', cfn_parse.FromCloudFormation.getString(properties.StorageVirtualMachineArn));
    ret.addPropertyResult('protocol', 'Protocol', properties.Protocol != null ? CfnLocationFSxONTAPProtocolPropertyFromCloudFormation(properties.Protocol) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxONTAP`
 *
 * The `AWS::DataSync::LocationFSxONTAP` resource creates an endpoint for an Amazon FSx for NetApp ONTAP file system. AWS DataSync can access this endpoint as a source or destination location.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxONTAP
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxontap.html
 */
class CfnLocationFSxONTAP extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationFSxONTAP`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxONTAP.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationFSxONTAPProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxONTAP);
            }
            throw error;
        }
        cdk.requireProperty(props, 'securityGroupArns', this);
        cdk.requireProperty(props, 'storageVirtualMachineArn', this);
        this.attrFsxFilesystemArn = cdk.Token.asString(this.getAtt('FsxFilesystemArn'));
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.securityGroupArns = props.securityGroupArns;
        this.storageVirtualMachineArn = props.storageVirtualMachineArn;
        this.protocol = props.protocol;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxONTAP", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxONTAPPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxONTAP(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxONTAP.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            securityGroupArns: this.securityGroupArns,
            storageVirtualMachineArn: this.storageVirtualMachineArn,
            protocol: this.protocol,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxONTAPPropsToCloudFormation(props);
    }
}
exports.CfnLocationFSxONTAP = CfnLocationFSxONTAP;
_d = JSII_RTTI_SYMBOL_1;
CfnLocationFSxONTAP[_d] = { fqn: "@aws-cdk/aws-datasync.CfnLocationFSxONTAP", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxONTAP.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxONTAP";
/**
 * Determine whether the given properties match those of a `NFSProperty`
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_NFSPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mountOptions', cdk.requiredValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationFSxONTAP_NfsMountOptionsPropertyValidator)(properties.mountOptions));
    return errors.wrap('supplied properties not correct for "NFSProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NFS` resource
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPNFSPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_NFSPropertyValidator(properties).assertSuccess();
    return {
        MountOptions: cfnLocationFSxONTAPNfsMountOptionsPropertyToCloudFormation(properties.mountOptions),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPNFSPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mountOptions', 'MountOptions', CfnLocationFSxONTAPNfsMountOptionsPropertyFromCloudFormation(properties.MountOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NfsMountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `NfsMountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_NfsMountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "NfsMountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NfsMountOptions` resource
 *
 * @param properties - the TypeScript properties of a `NfsMountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.NfsMountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPNfsMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_NfsMountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPNfsMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProtocolProperty`
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_ProtocolPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('nfs', CfnLocationFSxONTAP_NFSPropertyValidator)(properties.nfs));
    errors.collect(cdk.propertyValidator('smb', CfnLocationFSxONTAP_SMBPropertyValidator)(properties.smb));
    return errors.wrap('supplied properties not correct for "ProtocolProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.Protocol` resource
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.Protocol` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPProtocolPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_ProtocolPropertyValidator(properties).assertSuccess();
    return {
        NFS: cfnLocationFSxONTAPNFSPropertyToCloudFormation(properties.nfs),
        SMB: cfnLocationFSxONTAPSMBPropertyToCloudFormation(properties.smb),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPProtocolPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('nfs', 'NFS', properties.NFS != null ? CfnLocationFSxONTAPNFSPropertyFromCloudFormation(properties.NFS) : undefined);
    ret.addPropertyResult('smb', 'SMB', properties.SMB != null ? CfnLocationFSxONTAPSMBPropertyFromCloudFormation(properties.SMB) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SMBProperty`
 *
 * @param properties - the TypeScript properties of a `SMBProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_SMBPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('mountOptions', cdk.requiredValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationFSxONTAP_SmbMountOptionsPropertyValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('password', cdk.requiredValidator)(properties.password));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('user', cdk.requiredValidator)(properties.user));
    errors.collect(cdk.propertyValidator('user', cdk.validateString)(properties.user));
    return errors.wrap('supplied properties not correct for "SMBProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SMB` resource
 *
 * @param properties - the TypeScript properties of a `SMBProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SMB` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPSMBPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_SMBPropertyValidator(properties).assertSuccess();
    return {
        Domain: cdk.stringToCloudFormation(properties.domain),
        MountOptions: cfnLocationFSxONTAPSmbMountOptionsPropertyToCloudFormation(properties.mountOptions),
        Password: cdk.stringToCloudFormation(properties.password),
        User: cdk.stringToCloudFormation(properties.user),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPSMBPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('mountOptions', 'MountOptions', CfnLocationFSxONTAPSmbMountOptionsPropertyFromCloudFormation(properties.MountOptions));
    ret.addPropertyResult('password', 'Password', cfn_parse.FromCloudFormation.getString(properties.Password));
    ret.addPropertyResult('user', 'User', cfn_parse.FromCloudFormation.getString(properties.User));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SmbMountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `SmbMountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxONTAP_SmbMountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "SmbMountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SmbMountOptions` resource
 *
 * @param properties - the TypeScript properties of a `SmbMountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxONTAP.SmbMountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxONTAPSmbMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxONTAP_SmbMountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxONTAPSmbMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationFSxOpenZFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxOpenZFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fsxFilesystemArn', cdk.validateString)(properties.fsxFilesystemArn));
    errors.collect(cdk.propertyValidator('protocol', cdk.requiredValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('protocol', CfnLocationFSxOpenZFS_ProtocolPropertyValidator)(properties.protocol));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxOpenZFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxOpenZFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFSPropsValidator(properties).assertSuccess();
    return {
        Protocol: cfnLocationFSxOpenZFSProtocolPropertyToCloudFormation(properties.protocol),
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        FsxFilesystemArn: cdk.stringToCloudFormation(properties.fsxFilesystemArn),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('protocol', 'Protocol', CfnLocationFSxOpenZFSProtocolPropertyFromCloudFormation(properties.Protocol));
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('fsxFilesystemArn', 'FsxFilesystemArn', properties.FsxFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.FsxFilesystemArn) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxOpenZFS`
 *
 * The `AWS::DataSync::LocationFSxOpenZFS` resource specifies an endpoint for an Amazon FSx for OpenZFS file system.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxOpenZFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxopenzfs.html
 */
class CfnLocationFSxOpenZFS extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationFSxOpenZFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxOpenZFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationFSxOpenZFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxOpenZFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'protocol', this);
        cdk.requireProperty(props, 'securityGroupArns', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.protocol = props.protocol;
        this.securityGroupArns = props.securityGroupArns;
        this.fsxFilesystemArn = props.fsxFilesystemArn;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxOpenZFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxOpenZFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxOpenZFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxOpenZFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            protocol: this.protocol,
            securityGroupArns: this.securityGroupArns,
            fsxFilesystemArn: this.fsxFilesystemArn,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxOpenZFSPropsToCloudFormation(props);
    }
}
exports.CfnLocationFSxOpenZFS = CfnLocationFSxOpenZFS;
_e = JSII_RTTI_SYMBOL_1;
CfnLocationFSxOpenZFS[_e] = { fqn: "@aws-cdk/aws-datasync.CfnLocationFSxOpenZFS", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxOpenZFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxOpenZFS";
/**
 * Determine whether the given properties match those of a `MountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFS_MountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "MountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.MountOptions` resource
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.MountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFS_MountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NFSProperty`
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFS_NFSPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mountOptions', cdk.requiredValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationFSxOpenZFS_MountOptionsPropertyValidator)(properties.mountOptions));
    return errors.wrap('supplied properties not correct for "NFSProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.NFS` resource
 *
 * @param properties - the TypeScript properties of a `NFSProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.NFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSNFSPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFS_NFSPropertyValidator(properties).assertSuccess();
    return {
        MountOptions: cfnLocationFSxOpenZFSMountOptionsPropertyToCloudFormation(properties.mountOptions),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSNFSPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mountOptions', 'MountOptions', CfnLocationFSxOpenZFSMountOptionsPropertyFromCloudFormation(properties.MountOptions));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProtocolProperty`
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxOpenZFS_ProtocolPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('nfs', CfnLocationFSxOpenZFS_NFSPropertyValidator)(properties.nfs));
    return errors.wrap('supplied properties not correct for "ProtocolProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.Protocol` resource
 *
 * @param properties - the TypeScript properties of a `ProtocolProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxOpenZFS.Protocol` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxOpenZFSProtocolPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxOpenZFS_ProtocolPropertyValidator(properties).assertSuccess();
    return {
        NFS: cfnLocationFSxOpenZFSNFSPropertyToCloudFormation(properties.nfs),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxOpenZFSProtocolPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('nfs', 'NFS', properties.NFS != null ? CfnLocationFSxOpenZFSNFSPropertyFromCloudFormation(properties.NFS) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationFSxWindowsProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxWindowsProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationFSxWindowsPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('fsxFilesystemArn', cdk.validateString)(properties.fsxFilesystemArn));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.requiredValidator)(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('securityGroupArns', cdk.listValidator(cdk.validateString))(properties.securityGroupArns));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('user', cdk.requiredValidator)(properties.user));
    errors.collect(cdk.propertyValidator('user', cdk.validateString)(properties.user));
    return errors.wrap('supplied properties not correct for "CfnLocationFSxWindowsProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxWindows` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationFSxWindowsProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationFSxWindows` resource.
 */
// @ts-ignore TS6133
function cfnLocationFSxWindowsPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationFSxWindowsPropsValidator(properties).assertSuccess();
    return {
        SecurityGroupArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupArns),
        User: cdk.stringToCloudFormation(properties.user),
        Domain: cdk.stringToCloudFormation(properties.domain),
        FsxFilesystemArn: cdk.stringToCloudFormation(properties.fsxFilesystemArn),
        Password: cdk.stringToCloudFormation(properties.password),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationFSxWindowsPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupArns', 'SecurityGroupArns', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupArns));
    ret.addPropertyResult('user', 'User', cfn_parse.FromCloudFormation.getString(properties.User));
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('fsxFilesystemArn', 'FsxFilesystemArn', properties.FsxFilesystemArn != null ? cfn_parse.FromCloudFormation.getString(properties.FsxFilesystemArn) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxWindows`
 *
 * The `AWS::DataSync::LocationFSxWindows` resource specifies an endpoint for an Amazon FSx for Windows Server file system.
 *
 * @cloudformationResource AWS::DataSync::LocationFSxWindows
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html
 */
class CfnLocationFSxWindows extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationFSxWindows`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationFSxWindows.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationFSxWindowsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationFSxWindows);
            }
            throw error;
        }
        cdk.requireProperty(props, 'securityGroupArns', this);
        cdk.requireProperty(props, 'user', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.securityGroupArns = props.securityGroupArns;
        this.user = props.user;
        this.domain = props.domain;
        this.fsxFilesystemArn = props.fsxFilesystemArn;
        this.password = props.password;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationFSxWindows", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationFSxWindowsPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationFSxWindows(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationFSxWindows.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            securityGroupArns: this.securityGroupArns,
            user: this.user,
            domain: this.domain,
            fsxFilesystemArn: this.fsxFilesystemArn,
            password: this.password,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationFSxWindowsPropsToCloudFormation(props);
    }
}
exports.CfnLocationFSxWindows = CfnLocationFSxWindows;
_f = JSII_RTTI_SYMBOL_1;
CfnLocationFSxWindows[_f] = { fqn: "@aws-cdk/aws-datasync.CfnLocationFSxWindows", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationFSxWindows.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxWindows";
/**
 * Determine whether the given properties match those of a `CfnLocationHDFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationHDFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationHDFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    errors.collect(cdk.propertyValidator('authenticationType', cdk.requiredValidator)(properties.authenticationType));
    errors.collect(cdk.propertyValidator('authenticationType', cdk.validateString)(properties.authenticationType));
    errors.collect(cdk.propertyValidator('blockSize', cdk.validateNumber)(properties.blockSize));
    errors.collect(cdk.propertyValidator('kerberosKeytab', cdk.validateString)(properties.kerberosKeytab));
    errors.collect(cdk.propertyValidator('kerberosKrb5Conf', cdk.validateString)(properties.kerberosKrb5Conf));
    errors.collect(cdk.propertyValidator('kerberosPrincipal', cdk.validateString)(properties.kerberosPrincipal));
    errors.collect(cdk.propertyValidator('kmsKeyProviderUri', cdk.validateString)(properties.kmsKeyProviderUri));
    errors.collect(cdk.propertyValidator('nameNodes', cdk.requiredValidator)(properties.nameNodes));
    errors.collect(cdk.propertyValidator('nameNodes', cdk.listValidator(CfnLocationHDFS_NameNodePropertyValidator))(properties.nameNodes));
    errors.collect(cdk.propertyValidator('qopConfiguration', CfnLocationHDFS_QopConfigurationPropertyValidator)(properties.qopConfiguration));
    errors.collect(cdk.propertyValidator('replicationFactor', cdk.validateNumber)(properties.replicationFactor));
    errors.collect(cdk.propertyValidator('simpleUser', cdk.validateString)(properties.simpleUser));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationHDFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationHDFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationHDFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationHDFSPropsValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
        AuthenticationType: cdk.stringToCloudFormation(properties.authenticationType),
        NameNodes: cdk.listMapper(cfnLocationHDFSNameNodePropertyToCloudFormation)(properties.nameNodes),
        BlockSize: cdk.numberToCloudFormation(properties.blockSize),
        KerberosKeytab: cdk.stringToCloudFormation(properties.kerberosKeytab),
        KerberosKrb5Conf: cdk.stringToCloudFormation(properties.kerberosKrb5Conf),
        KerberosPrincipal: cdk.stringToCloudFormation(properties.kerberosPrincipal),
        KmsKeyProviderUri: cdk.stringToCloudFormation(properties.kmsKeyProviderUri),
        QopConfiguration: cfnLocationHDFSQopConfigurationPropertyToCloudFormation(properties.qopConfiguration),
        ReplicationFactor: cdk.numberToCloudFormation(properties.replicationFactor),
        SimpleUser: cdk.stringToCloudFormation(properties.simpleUser),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationHDFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addPropertyResult('authenticationType', 'AuthenticationType', cfn_parse.FromCloudFormation.getString(properties.AuthenticationType));
    ret.addPropertyResult('nameNodes', 'NameNodes', cfn_parse.FromCloudFormation.getArray(CfnLocationHDFSNameNodePropertyFromCloudFormation)(properties.NameNodes));
    ret.addPropertyResult('blockSize', 'BlockSize', properties.BlockSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.BlockSize) : undefined);
    ret.addPropertyResult('kerberosKeytab', 'KerberosKeytab', properties.KerberosKeytab != null ? cfn_parse.FromCloudFormation.getString(properties.KerberosKeytab) : undefined);
    ret.addPropertyResult('kerberosKrb5Conf', 'KerberosKrb5Conf', properties.KerberosKrb5Conf != null ? cfn_parse.FromCloudFormation.getString(properties.KerberosKrb5Conf) : undefined);
    ret.addPropertyResult('kerberosPrincipal', 'KerberosPrincipal', properties.KerberosPrincipal != null ? cfn_parse.FromCloudFormation.getString(properties.KerberosPrincipal) : undefined);
    ret.addPropertyResult('kmsKeyProviderUri', 'KmsKeyProviderUri', properties.KmsKeyProviderUri != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyProviderUri) : undefined);
    ret.addPropertyResult('qopConfiguration', 'QopConfiguration', properties.QopConfiguration != null ? CfnLocationHDFSQopConfigurationPropertyFromCloudFormation(properties.QopConfiguration) : undefined);
    ret.addPropertyResult('replicationFactor', 'ReplicationFactor', properties.ReplicationFactor != null ? cfn_parse.FromCloudFormation.getNumber(properties.ReplicationFactor) : undefined);
    ret.addPropertyResult('simpleUser', 'SimpleUser', properties.SimpleUser != null ? cfn_parse.FromCloudFormation.getString(properties.SimpleUser) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationHDFS`
 *
 * The `AWS::DataSync::LocationHDFS` resource specifies an endpoint for a Hadoop Distributed File System (HDFS).
 *
 * @cloudformationResource AWS::DataSync::LocationHDFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationhdfs.html
 */
class CfnLocationHDFS extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationHDFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationHDFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationHDFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationHDFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'agentArns', this);
        cdk.requireProperty(props, 'authenticationType', this);
        cdk.requireProperty(props, 'nameNodes', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.agentArns = props.agentArns;
        this.authenticationType = props.authenticationType;
        this.nameNodes = props.nameNodes;
        this.blockSize = props.blockSize;
        this.kerberosKeytab = props.kerberosKeytab;
        this.kerberosKrb5Conf = props.kerberosKrb5Conf;
        this.kerberosPrincipal = props.kerberosPrincipal;
        this.kmsKeyProviderUri = props.kmsKeyProviderUri;
        this.qopConfiguration = props.qopConfiguration;
        this.replicationFactor = props.replicationFactor;
        this.simpleUser = props.simpleUser;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationHDFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationHDFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationHDFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationHDFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            agentArns: this.agentArns,
            authenticationType: this.authenticationType,
            nameNodes: this.nameNodes,
            blockSize: this.blockSize,
            kerberosKeytab: this.kerberosKeytab,
            kerberosKrb5Conf: this.kerberosKrb5Conf,
            kerberosPrincipal: this.kerberosPrincipal,
            kmsKeyProviderUri: this.kmsKeyProviderUri,
            qopConfiguration: this.qopConfiguration,
            replicationFactor: this.replicationFactor,
            simpleUser: this.simpleUser,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationHDFSPropsToCloudFormation(props);
    }
}
exports.CfnLocationHDFS = CfnLocationHDFS;
_g = JSII_RTTI_SYMBOL_1;
CfnLocationHDFS[_g] = { fqn: "@aws-cdk/aws-datasync.CfnLocationHDFS", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationHDFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationHDFS";
/**
 * Determine whether the given properties match those of a `NameNodeProperty`
 *
 * @param properties - the TypeScript properties of a `NameNodeProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationHDFS_NameNodePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostname', cdk.requiredValidator)(properties.hostname));
    errors.collect(cdk.propertyValidator('hostname', cdk.validateString)(properties.hostname));
    errors.collect(cdk.propertyValidator('port', cdk.requiredValidator)(properties.port));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    return errors.wrap('supplied properties not correct for "NameNodeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.NameNode` resource
 *
 * @param properties - the TypeScript properties of a `NameNodeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.NameNode` resource.
 */
// @ts-ignore TS6133
function cfnLocationHDFSNameNodePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationHDFS_NameNodePropertyValidator(properties).assertSuccess();
    return {
        Hostname: cdk.stringToCloudFormation(properties.hostname),
        Port: cdk.numberToCloudFormation(properties.port),
    };
}
// @ts-ignore TS6133
function CfnLocationHDFSNameNodePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostname', 'Hostname', cfn_parse.FromCloudFormation.getString(properties.Hostname));
    ret.addPropertyResult('port', 'Port', cfn_parse.FromCloudFormation.getNumber(properties.Port));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `QopConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `QopConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationHDFS_QopConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataTransferProtection', cdk.validateString)(properties.dataTransferProtection));
    errors.collect(cdk.propertyValidator('rpcProtection', cdk.validateString)(properties.rpcProtection));
    return errors.wrap('supplied properties not correct for "QopConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.QopConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `QopConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationHDFS.QopConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnLocationHDFSQopConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationHDFS_QopConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DataTransferProtection: cdk.stringToCloudFormation(properties.dataTransferProtection),
        RpcProtection: cdk.stringToCloudFormation(properties.rpcProtection),
    };
}
// @ts-ignore TS6133
function CfnLocationHDFSQopConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataTransferProtection', 'DataTransferProtection', properties.DataTransferProtection != null ? cfn_parse.FromCloudFormation.getString(properties.DataTransferProtection) : undefined);
    ret.addPropertyResult('rpcProtection', 'RpcProtection', properties.RpcProtection != null ? cfn_parse.FromCloudFormation.getString(properties.RpcProtection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationNFSProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationNFSProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationNFSPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationNFS_MountOptionsPropertyValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('onPremConfig', cdk.requiredValidator)(properties.onPremConfig));
    errors.collect(cdk.propertyValidator('onPremConfig', CfnLocationNFS_OnPremConfigPropertyValidator)(properties.onPremConfig));
    errors.collect(cdk.propertyValidator('serverHostname', cdk.validateString)(properties.serverHostname));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationNFSProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationNFSProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS` resource.
 */
// @ts-ignore TS6133
function cfnLocationNFSPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationNFSPropsValidator(properties).assertSuccess();
    return {
        OnPremConfig: cfnLocationNFSOnPremConfigPropertyToCloudFormation(properties.onPremConfig),
        MountOptions: cfnLocationNFSMountOptionsPropertyToCloudFormation(properties.mountOptions),
        ServerHostname: cdk.stringToCloudFormation(properties.serverHostname),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationNFSPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('onPremConfig', 'OnPremConfig', CfnLocationNFSOnPremConfigPropertyFromCloudFormation(properties.OnPremConfig));
    ret.addPropertyResult('mountOptions', 'MountOptions', properties.MountOptions != null ? CfnLocationNFSMountOptionsPropertyFromCloudFormation(properties.MountOptions) : undefined);
    ret.addPropertyResult('serverHostname', 'ServerHostname', properties.ServerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ServerHostname) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationNFS`
 *
 * The `AWS::DataSync::LocationNFS` resource specifies a file system on a Network File System (NFS) server that can be read from or written to.
 *
 * @cloudformationResource AWS::DataSync::LocationNFS
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html
 */
class CfnLocationNFS extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationNFS`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationNFS.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationNFSProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationNFS);
            }
            throw error;
        }
        cdk.requireProperty(props, 'onPremConfig', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.onPremConfig = props.onPremConfig;
        this.mountOptions = props.mountOptions;
        this.serverHostname = props.serverHostname;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationNFS", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationNFSPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationNFS(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationNFS.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            onPremConfig: this.onPremConfig,
            mountOptions: this.mountOptions,
            serverHostname: this.serverHostname,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationNFSPropsToCloudFormation(props);
    }
}
exports.CfnLocationNFS = CfnLocationNFS;
_h = JSII_RTTI_SYMBOL_1;
CfnLocationNFS[_h] = { fqn: "@aws-cdk/aws-datasync.CfnLocationNFS", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationNFS.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationNFS";
/**
 * Determine whether the given properties match those of a `MountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationNFS_MountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "MountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.MountOptions` resource
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.MountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationNFSMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationNFS_MountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationNFSMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OnPremConfigProperty`
 *
 * @param properties - the TypeScript properties of a `OnPremConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationNFS_OnPremConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    return errors.wrap('supplied properties not correct for "OnPremConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.OnPremConfig` resource
 *
 * @param properties - the TypeScript properties of a `OnPremConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationNFS.OnPremConfig` resource.
 */
// @ts-ignore TS6133
function cfnLocationNFSOnPremConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationNFS_OnPremConfigPropertyValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
    };
}
// @ts-ignore TS6133
function CfnLocationNFSOnPremConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationObjectStorageProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationObjectStorageProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationObjectStoragePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessKey', cdk.validateString)(properties.accessKey));
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('secretKey', cdk.validateString)(properties.secretKey));
    errors.collect(cdk.propertyValidator('serverCertificate', cdk.validateString)(properties.serverCertificate));
    errors.collect(cdk.propertyValidator('serverHostname', cdk.validateString)(properties.serverHostname));
    errors.collect(cdk.propertyValidator('serverPort', cdk.validateNumber)(properties.serverPort));
    errors.collect(cdk.propertyValidator('serverProtocol', cdk.validateString)(properties.serverProtocol));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationObjectStorageProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationObjectStorage` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationObjectStorageProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationObjectStorage` resource.
 */
// @ts-ignore TS6133
function cfnLocationObjectStoragePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationObjectStoragePropsValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
        AccessKey: cdk.stringToCloudFormation(properties.accessKey),
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        SecretKey: cdk.stringToCloudFormation(properties.secretKey),
        ServerCertificate: cdk.stringToCloudFormation(properties.serverCertificate),
        ServerHostname: cdk.stringToCloudFormation(properties.serverHostname),
        ServerPort: cdk.numberToCloudFormation(properties.serverPort),
        ServerProtocol: cdk.stringToCloudFormation(properties.serverProtocol),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationObjectStoragePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addPropertyResult('accessKey', 'AccessKey', properties.AccessKey != null ? cfn_parse.FromCloudFormation.getString(properties.AccessKey) : undefined);
    ret.addPropertyResult('bucketName', 'BucketName', properties.BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.BucketName) : undefined);
    ret.addPropertyResult('secretKey', 'SecretKey', properties.SecretKey != null ? cfn_parse.FromCloudFormation.getString(properties.SecretKey) : undefined);
    ret.addPropertyResult('serverCertificate', 'ServerCertificate', properties.ServerCertificate != null ? cfn_parse.FromCloudFormation.getString(properties.ServerCertificate) : undefined);
    ret.addPropertyResult('serverHostname', 'ServerHostname', properties.ServerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ServerHostname) : undefined);
    ret.addPropertyResult('serverPort', 'ServerPort', properties.ServerPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ServerPort) : undefined);
    ret.addPropertyResult('serverProtocol', 'ServerProtocol', properties.ServerProtocol != null ? cfn_parse.FromCloudFormation.getString(properties.ServerProtocol) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationObjectStorage`
 *
 * The `AWS::DataSync::LocationObjectStorage` resource specifies an endpoint for a self-managed object storage bucket. For more information about self-managed object storage locations, see [Creating a Location for Object Storage](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html) .
 *
 * @cloudformationResource AWS::DataSync::LocationObjectStorage
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html
 */
class CfnLocationObjectStorage extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationObjectStorage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationObjectStorage.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationObjectStorageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationObjectStorage);
            }
            throw error;
        }
        cdk.requireProperty(props, 'agentArns', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.agentArns = props.agentArns;
        this.accessKey = props.accessKey;
        this.bucketName = props.bucketName;
        this.secretKey = props.secretKey;
        this.serverCertificate = props.serverCertificate;
        this.serverHostname = props.serverHostname;
        this.serverPort = props.serverPort;
        this.serverProtocol = props.serverProtocol;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationObjectStorage", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationObjectStoragePropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationObjectStorage(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationObjectStorage.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            agentArns: this.agentArns,
            accessKey: this.accessKey,
            bucketName: this.bucketName,
            secretKey: this.secretKey,
            serverCertificate: this.serverCertificate,
            serverHostname: this.serverHostname,
            serverPort: this.serverPort,
            serverProtocol: this.serverProtocol,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationObjectStoragePropsToCloudFormation(props);
    }
}
exports.CfnLocationObjectStorage = CfnLocationObjectStorage;
_j = JSII_RTTI_SYMBOL_1;
CfnLocationObjectStorage[_j] = { fqn: "@aws-cdk/aws-datasync.CfnLocationObjectStorage", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationObjectStorage.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationObjectStorage";
/**
 * Determine whether the given properties match those of a `CfnLocationS3Props`
 *
 * @param properties - the TypeScript properties of a `CfnLocationS3Props`
 *
 * @returns the result of the validation.
 */
function CfnLocationS3PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3BucketArn', cdk.validateString)(properties.s3BucketArn));
    errors.collect(cdk.propertyValidator('s3Config', cdk.requiredValidator)(properties.s3Config));
    errors.collect(cdk.propertyValidator('s3Config', CfnLocationS3_S3ConfigPropertyValidator)(properties.s3Config));
    errors.collect(cdk.propertyValidator('s3StorageClass', cdk.validateString)(properties.s3StorageClass));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnLocationS3Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationS3` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationS3Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationS3` resource.
 */
// @ts-ignore TS6133
function cfnLocationS3PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationS3PropsValidator(properties).assertSuccess();
    return {
        S3Config: cfnLocationS3S3ConfigPropertyToCloudFormation(properties.s3Config),
        S3BucketArn: cdk.stringToCloudFormation(properties.s3BucketArn),
        S3StorageClass: cdk.stringToCloudFormation(properties.s3StorageClass),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationS3PropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Config', 'S3Config', CfnLocationS3S3ConfigPropertyFromCloudFormation(properties.S3Config));
    ret.addPropertyResult('s3BucketArn', 'S3BucketArn', properties.S3BucketArn != null ? cfn_parse.FromCloudFormation.getString(properties.S3BucketArn) : undefined);
    ret.addPropertyResult('s3StorageClass', 'S3StorageClass', properties.S3StorageClass != null ? cfn_parse.FromCloudFormation.getString(properties.S3StorageClass) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationS3`
 *
 * The `AWS::DataSync::LocationS3` resource specifies an endpoint for an Amazon S3 bucket.
 *
 * For more information, see [Create an Amazon S3 location](https://docs.aws.amazon.com/datasync/latest/userguide/create-locations-cli.html#create-location-s3-cli) in the *AWS DataSync User Guide* .
 *
 * @cloudformationResource AWS::DataSync::LocationS3
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html
 */
class CfnLocationS3 extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationS3`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationS3.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationS3Props(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationS3);
            }
            throw error;
        }
        cdk.requireProperty(props, 's3Config', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.s3Config = props.s3Config;
        this.s3BucketArn = props.s3BucketArn;
        this.s3StorageClass = props.s3StorageClass;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationS3", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationS3PropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationS3(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationS3.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            s3Config: this.s3Config,
            s3BucketArn: this.s3BucketArn,
            s3StorageClass: this.s3StorageClass,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationS3PropsToCloudFormation(props);
    }
}
exports.CfnLocationS3 = CfnLocationS3;
_k = JSII_RTTI_SYMBOL_1;
CfnLocationS3[_k] = { fqn: "@aws-cdk/aws-datasync.CfnLocationS3", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationS3.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationS3";
/**
 * Determine whether the given properties match those of a `S3ConfigProperty`
 *
 * @param properties - the TypeScript properties of a `S3ConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationS3_S3ConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucketAccessRoleArn', cdk.requiredValidator)(properties.bucketAccessRoleArn));
    errors.collect(cdk.propertyValidator('bucketAccessRoleArn', cdk.validateString)(properties.bucketAccessRoleArn));
    return errors.wrap('supplied properties not correct for "S3ConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationS3.S3Config` resource
 *
 * @param properties - the TypeScript properties of a `S3ConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationS3.S3Config` resource.
 */
// @ts-ignore TS6133
function cfnLocationS3S3ConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationS3_S3ConfigPropertyValidator(properties).assertSuccess();
    return {
        BucketAccessRoleArn: cdk.stringToCloudFormation(properties.bucketAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnLocationS3S3ConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucketAccessRoleArn', 'BucketAccessRoleArn', cfn_parse.FromCloudFormation.getString(properties.BucketAccessRoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnLocationSMBProps`
 *
 * @param properties - the TypeScript properties of a `CfnLocationSMBProps`
 *
 * @returns the result of the validation.
 */
function CfnLocationSMBPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('agentArns', cdk.requiredValidator)(properties.agentArns));
    errors.collect(cdk.propertyValidator('agentArns', cdk.listValidator(cdk.validateString))(properties.agentArns));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('mountOptions', CfnLocationSMB_MountOptionsPropertyValidator)(properties.mountOptions));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('serverHostname', cdk.validateString)(properties.serverHostname));
    errors.collect(cdk.propertyValidator('subdirectory', cdk.validateString)(properties.subdirectory));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('user', cdk.requiredValidator)(properties.user));
    errors.collect(cdk.propertyValidator('user', cdk.validateString)(properties.user));
    return errors.wrap('supplied properties not correct for "CfnLocationSMBProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB` resource
 *
 * @param properties - the TypeScript properties of a `CfnLocationSMBProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB` resource.
 */
// @ts-ignore TS6133
function cfnLocationSMBPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationSMBPropsValidator(properties).assertSuccess();
    return {
        AgentArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.agentArns),
        User: cdk.stringToCloudFormation(properties.user),
        Domain: cdk.stringToCloudFormation(properties.domain),
        MountOptions: cfnLocationSMBMountOptionsPropertyToCloudFormation(properties.mountOptions),
        Password: cdk.stringToCloudFormation(properties.password),
        ServerHostname: cdk.stringToCloudFormation(properties.serverHostname),
        Subdirectory: cdk.stringToCloudFormation(properties.subdirectory),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnLocationSMBPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('agentArns', 'AgentArns', cfn_parse.FromCloudFormation.getStringArray(properties.AgentArns));
    ret.addPropertyResult('user', 'User', cfn_parse.FromCloudFormation.getString(properties.User));
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('mountOptions', 'MountOptions', properties.MountOptions != null ? CfnLocationSMBMountOptionsPropertyFromCloudFormation(properties.MountOptions) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('serverHostname', 'ServerHostname', properties.ServerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ServerHostname) : undefined);
    ret.addPropertyResult('subdirectory', 'Subdirectory', properties.Subdirectory != null ? cfn_parse.FromCloudFormation.getString(properties.Subdirectory) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::LocationSMB`
 *
 * The `AWS::DataSync::LocationSMB` resource specifies a Server Message Block (SMB) location.
 *
 * @cloudformationResource AWS::DataSync::LocationSMB
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html
 */
class CfnLocationSMB extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::LocationSMB`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnLocationSMB.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnLocationSMBProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnLocationSMB);
            }
            throw error;
        }
        cdk.requireProperty(props, 'agentArns', this);
        cdk.requireProperty(props, 'user', this);
        this.attrLocationArn = cdk.Token.asString(this.getAtt('LocationArn'));
        this.attrLocationUri = cdk.Token.asString(this.getAtt('LocationUri'));
        this.agentArns = props.agentArns;
        this.user = props.user;
        this.domain = props.domain;
        this.mountOptions = props.mountOptions;
        this.password = props.password;
        this.serverHostname = props.serverHostname;
        this.subdirectory = props.subdirectory;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::LocationSMB", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnLocationSMBPropsFromCloudFormation(resourceProperties);
        const ret = new CfnLocationSMB(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnLocationSMB.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            agentArns: this.agentArns,
            user: this.user,
            domain: this.domain,
            mountOptions: this.mountOptions,
            password: this.password,
            serverHostname: this.serverHostname,
            subdirectory: this.subdirectory,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnLocationSMBPropsToCloudFormation(props);
    }
}
exports.CfnLocationSMB = CfnLocationSMB;
_l = JSII_RTTI_SYMBOL_1;
CfnLocationSMB[_l] = { fqn: "@aws-cdk/aws-datasync.CfnLocationSMB", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnLocationSMB.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationSMB";
/**
 * Determine whether the given properties match those of a `MountOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnLocationSMB_MountOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "MountOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB.MountOptions` resource
 *
 * @param properties - the TypeScript properties of a `MountOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::LocationSMB.MountOptions` resource.
 */
// @ts-ignore TS6133
function cfnLocationSMBMountOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnLocationSMB_MountOptionsPropertyValidator(properties).assertSuccess();
    return {
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnLocationSMBMountOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnTaskProps`
 *
 * @param properties - the TypeScript properties of a `CfnTaskProps`
 *
 * @returns the result of the validation.
 */
function CfnTaskPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogGroupArn', cdk.validateString)(properties.cloudWatchLogGroupArn));
    errors.collect(cdk.propertyValidator('destinationLocationArn', cdk.requiredValidator)(properties.destinationLocationArn));
    errors.collect(cdk.propertyValidator('destinationLocationArn', cdk.validateString)(properties.destinationLocationArn));
    errors.collect(cdk.propertyValidator('excludes', cdk.listValidator(CfnTask_FilterRulePropertyValidator))(properties.excludes));
    errors.collect(cdk.propertyValidator('includes', cdk.listValidator(CfnTask_FilterRulePropertyValidator))(properties.includes));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('options', CfnTask_OptionsPropertyValidator)(properties.options));
    errors.collect(cdk.propertyValidator('schedule', CfnTask_TaskSchedulePropertyValidator)(properties.schedule));
    errors.collect(cdk.propertyValidator('sourceLocationArn', cdk.requiredValidator)(properties.sourceLocationArn));
    errors.collect(cdk.propertyValidator('sourceLocationArn', cdk.validateString)(properties.sourceLocationArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnTaskProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task` resource
 *
 * @param properties - the TypeScript properties of a `CfnTaskProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task` resource.
 */
// @ts-ignore TS6133
function cfnTaskPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskPropsValidator(properties).assertSuccess();
    return {
        DestinationLocationArn: cdk.stringToCloudFormation(properties.destinationLocationArn),
        SourceLocationArn: cdk.stringToCloudFormation(properties.sourceLocationArn),
        CloudWatchLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogGroupArn),
        Excludes: cdk.listMapper(cfnTaskFilterRulePropertyToCloudFormation)(properties.excludes),
        Includes: cdk.listMapper(cfnTaskFilterRulePropertyToCloudFormation)(properties.includes),
        Name: cdk.stringToCloudFormation(properties.name),
        Options: cfnTaskOptionsPropertyToCloudFormation(properties.options),
        Schedule: cfnTaskTaskSchedulePropertyToCloudFormation(properties.schedule),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnTaskPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('destinationLocationArn', 'DestinationLocationArn', cfn_parse.FromCloudFormation.getString(properties.DestinationLocationArn));
    ret.addPropertyResult('sourceLocationArn', 'SourceLocationArn', cfn_parse.FromCloudFormation.getString(properties.SourceLocationArn));
    ret.addPropertyResult('cloudWatchLogGroupArn', 'CloudWatchLogGroupArn', properties.CloudWatchLogGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogGroupArn) : undefined);
    ret.addPropertyResult('excludes', 'Excludes', properties.Excludes != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskFilterRulePropertyFromCloudFormation)(properties.Excludes) : undefined);
    ret.addPropertyResult('includes', 'Includes', properties.Includes != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskFilterRulePropertyFromCloudFormation)(properties.Includes) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('options', 'Options', properties.Options != null ? CfnTaskOptionsPropertyFromCloudFormation(properties.Options) : undefined);
    ret.addPropertyResult('schedule', 'Schedule', properties.Schedule != null ? CfnTaskTaskSchedulePropertyFromCloudFormation(properties.Schedule) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DataSync::Task`
 *
 * The `AWS::DataSync::Task` resource specifies a task. A task is a set of two locations (source and destination) and a set of `Options` that you use to control the behavior of a task. If you don't specify `Options` when you create a task, AWS DataSync populates them with service defaults.
 *
 * @cloudformationResource AWS::DataSync::Task
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html
 */
class CfnTask extends cdk.CfnResource {
    /**
     * Create a new `AWS::DataSync::Task`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTask.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_datasync_CfnTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnTask);
            }
            throw error;
        }
        cdk.requireProperty(props, 'destinationLocationArn', this);
        cdk.requireProperty(props, 'sourceLocationArn', this);
        this.attrDestinationNetworkInterfaceArns = cdk.Token.asList(this.getAtt('DestinationNetworkInterfaceArns'));
        this.attrSourceNetworkInterfaceArns = cdk.Token.asList(this.getAtt('SourceNetworkInterfaceArns'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
        this.attrTaskArn = cdk.Token.asString(this.getAtt('TaskArn'));
        this.destinationLocationArn = props.destinationLocationArn;
        this.sourceLocationArn = props.sourceLocationArn;
        this.cloudWatchLogGroupArn = props.cloudWatchLogGroupArn;
        this.excludes = props.excludes;
        this.includes = props.includes;
        this.name = props.name;
        this.options = props.options;
        this.schedule = props.schedule;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DataSync::Task", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTaskPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTask(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTask.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            destinationLocationArn: this.destinationLocationArn,
            sourceLocationArn: this.sourceLocationArn,
            cloudWatchLogGroupArn: this.cloudWatchLogGroupArn,
            excludes: this.excludes,
            includes: this.includes,
            name: this.name,
            options: this.options,
            schedule: this.schedule,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnTaskPropsToCloudFormation(props);
    }
}
exports.CfnTask = CfnTask;
_m = JSII_RTTI_SYMBOL_1;
CfnTask[_m] = { fqn: "@aws-cdk/aws-datasync.CfnTask", version: "1.198.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTask.CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::Task";
/**
 * Determine whether the given properties match those of a `FilterRuleProperty`
 *
 * @param properties - the TypeScript properties of a `FilterRuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnTask_FilterRulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('filterType', cdk.validateString)(properties.filterType));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "FilterRuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task.FilterRule` resource
 *
 * @param properties - the TypeScript properties of a `FilterRuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task.FilterRule` resource.
 */
// @ts-ignore TS6133
function cfnTaskFilterRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTask_FilterRulePropertyValidator(properties).assertSuccess();
    return {
        FilterType: cdk.stringToCloudFormation(properties.filterType),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnTaskFilterRulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('filterType', 'FilterType', properties.FilterType != null ? cfn_parse.FromCloudFormation.getString(properties.FilterType) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OptionsProperty`
 *
 * @param properties - the TypeScript properties of a `OptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnTask_OptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('atime', cdk.validateString)(properties.atime));
    errors.collect(cdk.propertyValidator('bytesPerSecond', cdk.validateNumber)(properties.bytesPerSecond));
    errors.collect(cdk.propertyValidator('gid', cdk.validateString)(properties.gid));
    errors.collect(cdk.propertyValidator('logLevel', cdk.validateString)(properties.logLevel));
    errors.collect(cdk.propertyValidator('mtime', cdk.validateString)(properties.mtime));
    errors.collect(cdk.propertyValidator('objectTags', cdk.validateString)(properties.objectTags));
    errors.collect(cdk.propertyValidator('overwriteMode', cdk.validateString)(properties.overwriteMode));
    errors.collect(cdk.propertyValidator('posixPermissions', cdk.validateString)(properties.posixPermissions));
    errors.collect(cdk.propertyValidator('preserveDeletedFiles', cdk.validateString)(properties.preserveDeletedFiles));
    errors.collect(cdk.propertyValidator('preserveDevices', cdk.validateString)(properties.preserveDevices));
    errors.collect(cdk.propertyValidator('securityDescriptorCopyFlags', cdk.validateString)(properties.securityDescriptorCopyFlags));
    errors.collect(cdk.propertyValidator('taskQueueing', cdk.validateString)(properties.taskQueueing));
    errors.collect(cdk.propertyValidator('transferMode', cdk.validateString)(properties.transferMode));
    errors.collect(cdk.propertyValidator('uid', cdk.validateString)(properties.uid));
    errors.collect(cdk.propertyValidator('verifyMode', cdk.validateString)(properties.verifyMode));
    return errors.wrap('supplied properties not correct for "OptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task.Options` resource
 *
 * @param properties - the TypeScript properties of a `OptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task.Options` resource.
 */
// @ts-ignore TS6133
function cfnTaskOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTask_OptionsPropertyValidator(properties).assertSuccess();
    return {
        Atime: cdk.stringToCloudFormation(properties.atime),
        BytesPerSecond: cdk.numberToCloudFormation(properties.bytesPerSecond),
        Gid: cdk.stringToCloudFormation(properties.gid),
        LogLevel: cdk.stringToCloudFormation(properties.logLevel),
        Mtime: cdk.stringToCloudFormation(properties.mtime),
        ObjectTags: cdk.stringToCloudFormation(properties.objectTags),
        OverwriteMode: cdk.stringToCloudFormation(properties.overwriteMode),
        PosixPermissions: cdk.stringToCloudFormation(properties.posixPermissions),
        PreserveDeletedFiles: cdk.stringToCloudFormation(properties.preserveDeletedFiles),
        PreserveDevices: cdk.stringToCloudFormation(properties.preserveDevices),
        SecurityDescriptorCopyFlags: cdk.stringToCloudFormation(properties.securityDescriptorCopyFlags),
        TaskQueueing: cdk.stringToCloudFormation(properties.taskQueueing),
        TransferMode: cdk.stringToCloudFormation(properties.transferMode),
        Uid: cdk.stringToCloudFormation(properties.uid),
        VerifyMode: cdk.stringToCloudFormation(properties.verifyMode),
    };
}
// @ts-ignore TS6133
function CfnTaskOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('atime', 'Atime', properties.Atime != null ? cfn_parse.FromCloudFormation.getString(properties.Atime) : undefined);
    ret.addPropertyResult('bytesPerSecond', 'BytesPerSecond', properties.BytesPerSecond != null ? cfn_parse.FromCloudFormation.getNumber(properties.BytesPerSecond) : undefined);
    ret.addPropertyResult('gid', 'Gid', properties.Gid != null ? cfn_parse.FromCloudFormation.getString(properties.Gid) : undefined);
    ret.addPropertyResult('logLevel', 'LogLevel', properties.LogLevel != null ? cfn_parse.FromCloudFormation.getString(properties.LogLevel) : undefined);
    ret.addPropertyResult('mtime', 'Mtime', properties.Mtime != null ? cfn_parse.FromCloudFormation.getString(properties.Mtime) : undefined);
    ret.addPropertyResult('objectTags', 'ObjectTags', properties.ObjectTags != null ? cfn_parse.FromCloudFormation.getString(properties.ObjectTags) : undefined);
    ret.addPropertyResult('overwriteMode', 'OverwriteMode', properties.OverwriteMode != null ? cfn_parse.FromCloudFormation.getString(properties.OverwriteMode) : undefined);
    ret.addPropertyResult('posixPermissions', 'PosixPermissions', properties.PosixPermissions != null ? cfn_parse.FromCloudFormation.getString(properties.PosixPermissions) : undefined);
    ret.addPropertyResult('preserveDeletedFiles', 'PreserveDeletedFiles', properties.PreserveDeletedFiles != null ? cfn_parse.FromCloudFormation.getString(properties.PreserveDeletedFiles) : undefined);
    ret.addPropertyResult('preserveDevices', 'PreserveDevices', properties.PreserveDevices != null ? cfn_parse.FromCloudFormation.getString(properties.PreserveDevices) : undefined);
    ret.addPropertyResult('securityDescriptorCopyFlags', 'SecurityDescriptorCopyFlags', properties.SecurityDescriptorCopyFlags != null ? cfn_parse.FromCloudFormation.getString(properties.SecurityDescriptorCopyFlags) : undefined);
    ret.addPropertyResult('taskQueueing', 'TaskQueueing', properties.TaskQueueing != null ? cfn_parse.FromCloudFormation.getString(properties.TaskQueueing) : undefined);
    ret.addPropertyResult('transferMode', 'TransferMode', properties.TransferMode != null ? cfn_parse.FromCloudFormation.getString(properties.TransferMode) : undefined);
    ret.addPropertyResult('uid', 'Uid', properties.Uid != null ? cfn_parse.FromCloudFormation.getString(properties.Uid) : undefined);
    ret.addPropertyResult('verifyMode', 'VerifyMode', properties.VerifyMode != null ? cfn_parse.FromCloudFormation.getString(properties.VerifyMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TaskScheduleProperty`
 *
 * @param properties - the TypeScript properties of a `TaskScheduleProperty`
 *
 * @returns the result of the validation.
 */
function CfnTask_TaskSchedulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.requiredValidator)(properties.scheduleExpression));
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.validateString)(properties.scheduleExpression));
    return errors.wrap('supplied properties not correct for "TaskScheduleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DataSync::Task.TaskSchedule` resource
 *
 * @param properties - the TypeScript properties of a `TaskScheduleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DataSync::Task.TaskSchedule` resource.
 */
// @ts-ignore TS6133
function cfnTaskTaskSchedulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTask_TaskSchedulePropertyValidator(properties).assertSuccess();
    return {
        ScheduleExpression: cdk.stringToCloudFormation(properties.scheduleExpression),
    };
}
// @ts-ignore TS6133
function CfnTaskTaskSchedulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('scheduleExpression', 'ScheduleExpression', cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YXN5bmMuZ2VuZXJhdGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZGF0YXN5bmMuZ2VuZXJhdGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLCtFQUErRTtBQUMvRSwrREFBK0Q7QUFDL0QsOEZBQThGO0FBQzlGLHNIQUFzSDtBQUV0SCw0QkFBNEIsQ0FBQyxpRUFBaUU7QUFFOUYscUNBQXFDO0FBQ3JDLGdFQUFnRTtBQW1FaEU7Ozs7OztHQU1HO0FBQ0gsU0FBUyxzQkFBc0IsQ0FBQyxVQUFlO0lBQzNDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2xILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHFEQUFxRCxDQUFDLENBQUM7QUFDOUUsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDZCQUE2QixDQUFDLFVBQWU7SUFDbEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ25ELE9BQU87UUFDSCxhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDbkUsU0FBUyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNELGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNGLFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0UsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRSxhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7S0FDdEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrQkFBK0IsQ0FBQyxVQUFlO0lBQ3BELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWlCLENBQUM7SUFDNUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxlQUFlLEVBQUUsVUFBVSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxVQUFVLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM5TCxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2xLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLGVBQWUsRUFBRSxVQUFVLENBQUMsYUFBYSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pLLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FpQkc7QUFDSCxNQUFhLFFBQVMsU0FBUSxHQUFHLENBQUMsV0FBVztJQTJGekM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxRQUF1QixFQUFFO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFFBQVEsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQW5HMUUsUUFBUTs7OztRQW9HYixJQUFJLENBQUMsWUFBWSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztRQUNoRSxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO1FBRXhFLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBQ3RILElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztLQUM1QztJQXZHRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcsK0JBQStCLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN4RSxNQUFNLEdBQUcsR0FBRyxJQUFJLFFBQVEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN2RCxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUF3RkQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxRQUFRLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUN2RixTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDNUIsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1NBQ3BDLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sNkJBQTZCLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDL0M7O0FBdklMLDRCQXdJQzs7O0FBdklHOztHQUVHO0FBQ29CLCtCQUFzQixHQUFHLHNCQUFzQixDQUFDO0FBc00zRTs7Ozs7O0dBTUc7QUFDSCxTQUFTLDRCQUE0QixDQUFDLFVBQWU7SUFDakQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLHlDQUF5QyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDcEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDekgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsMkRBQTJELENBQUMsQ0FBQztBQUNwRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsbUNBQW1DLENBQUMsVUFBZTtJQUN4RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsNEJBQTRCLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekQsT0FBTztRQUNILFNBQVMsRUFBRSwrQ0FBK0MsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQ2hGLGNBQWMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUNyRSxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3pFLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUM7UUFDdkYsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUMvRSxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHFDQUFxQyxDQUFDLFVBQWU7SUFDMUQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBdUIsQ0FBQztJQUNsRixHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxpREFBaUQsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUN6SCxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLEVBQUUsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLHlCQUF5QixFQUFFLFVBQVUsQ0FBQyx1QkFBdUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pOLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSxVQUFVLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBYSxjQUFlLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUEwRi9DOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDcEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsY0FBYyxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBbEdoRixjQUFjOzs7O1FBbUduQixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDOUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFDdEUsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFFdEUsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsdUJBQXVCLENBQUM7UUFDN0QsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQy9IO0lBeEdEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyxxQ0FBcUMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzlFLE1BQU0sR0FBRyxHQUFHLElBQUksY0FBYyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzdELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQXlGRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLGNBQWMsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQzdGLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QjtZQUNyRCxtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7U0FDL0IsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyxtQ0FBbUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNyRDs7QUF6SUwsd0NBMElDOzs7QUF6SUc7O0dBRUc7QUFDb0IscUNBQXNCLEdBQUcsNEJBQTRCLENBQUM7QUF3S2pGOzs7Ozs7R0FNRztBQUNILFNBQVMseUNBQXlDLENBQUMsVUFBZTtJQUM5RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHlEQUF5RCxDQUFDLENBQUM7QUFDbEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLCtDQUErQyxDQUFDLFVBQWU7SUFDcEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHlDQUF5QyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3RFLE9BQU87UUFDSCxpQkFBaUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRixTQUFTLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7S0FDOUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxpREFBaUQsQ0FBQyxVQUFlO0lBQ3RFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFvQyxDQUFDO0lBQy9GLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDM0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM5RyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBNkNEOzs7Ozs7R0FNRztBQUNILFNBQVMsa0NBQWtDLENBQUMsVUFBZTtJQUN2RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUVBQWlFLENBQUMsQ0FBQztBQUMxRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMseUNBQXlDLENBQUMsVUFBZTtJQUM5RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsa0NBQWtDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDL0QsT0FBTztRQUNILGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNGLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekUsWUFBWSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pFLElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywyQ0FBMkMsQ0FBQyxVQUFlO0lBQ2hFLFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQTZCLENBQUM7SUFDeEYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUMzSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEsb0JBQXFCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFxRXJEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0M7UUFDMUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsb0JBQW9CLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0E3RXRGLG9CQUFvQjs7OztRQThFekIsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdEQsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFDdEUsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFFdEUsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxrQ0FBa0MsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDckk7SUFoRkQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLDJDQUEyQyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDcEYsTUFBTSxHQUFHLEdBQUcsSUFBSSxvQkFBb0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNuRSxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUFpRUQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxvQkFBb0IsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ25HLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtTQUMvQixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLHlDQUF5QyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzNEOztBQTlHTCxvREErR0M7OztBQTlHRzs7R0FFRztBQUNvQiwyQ0FBc0IsR0FBRyxrQ0FBa0MsQ0FBQztBQW9LdkY7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpQ0FBaUMsQ0FBQyxVQUFlO0lBQ3RELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsNkNBQTZDLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUN0SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO0lBQzlILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDBCQUEwQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO0lBQzNILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGdFQUFnRSxDQUFDLENBQUM7QUFDekYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHdDQUF3QyxDQUFDLFVBQWU7SUFDN0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGlDQUFpQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzlELE9BQU87UUFDSCxpQkFBaUIsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRix3QkFBd0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDO1FBQ3pGLFFBQVEsRUFBRSxtREFBbUQsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ2xGLFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxJQUFJLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ3BFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsMENBQTBDLENBQUMsVUFBZTtJQUMvRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUE0QixDQUFDO0lBQ3ZGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDM0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLDBCQUEwQixFQUFFLDBCQUEwQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQztJQUMzSixHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMscURBQXFELENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNwSyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSxVQUFVLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBYSxtQkFBb0IsU0FBUSxHQUFHLENBQUMsV0FBVztJQXVGcEQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUErQjtRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxtQkFBbUIsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQS9GckYsbUJBQW1COzs7O1FBZ0d4QixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxtQkFBbUIsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUN0RCxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSwwQkFBMEIsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM3RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7UUFDaEYsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFDdEUsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFFdEUsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDLHdCQUF3QixDQUFDO1FBQy9ELElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsaUNBQWlDLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQ3BJO0lBckdEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRywwQ0FBMEMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ25GLE1BQU0sR0FBRyxHQUFHLElBQUksbUJBQW1CLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEUsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBc0ZEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsbUJBQW1CLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNsRyxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6Qyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsd0JBQXdCO1lBQ3ZELFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1NBQy9CLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sd0NBQXdDLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDMUQ7O0FBcElMLGtEQXFJQzs7O0FBcElHOztHQUVHO0FBQ29CLDBDQUFzQixHQUFHLGlDQUFpQyxDQUFDO0FBc0p0Rjs7Ozs7O0dBTUc7QUFDSCxTQUFTLHdDQUF3QyxDQUFDLFVBQWU7SUFDN0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUN0RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsb0RBQW9ELENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNySSxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsbURBQW1ELENBQUMsQ0FBQztBQUM1RSxDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsOENBQThDLENBQUMsVUFBZTtJQUNuRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsd0NBQXdDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDckUsT0FBTztRQUNILFlBQVksRUFBRSwwREFBMEQsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO0tBQ3BHLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsZ0RBQWdELENBQUMsVUFBZTtJQUNyRSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBbUMsQ0FBQztJQUM5RixHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSw0REFBNEQsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUM3SSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBOEJEOzs7Ozs7R0FNRztBQUNILFNBQVMsb0RBQW9ELENBQUMsVUFBZTtJQUN6RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsK0RBQStELENBQUMsQ0FBQztBQUN4RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMERBQTBELENBQUMsVUFBZTtJQUMvRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsb0RBQW9ELENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDakYsT0FBTztRQUNILE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztLQUMxRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDREQUE0RCxDQUFDLFVBQWU7SUFDakYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQStDLENBQUM7SUFDMUcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBMkJEOzs7Ozs7R0FNRztBQUNILFNBQVMsNkNBQTZDLENBQUMsVUFBZTtJQUNsRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLHdDQUF3QyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDdkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLHdDQUF3QyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDdkcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHdEQUF3RCxDQUFDLENBQUM7QUFDakYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLG1EQUFtRCxDQUFDLFVBQWU7SUFDeEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDZDQUE2QyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzFFLE9BQU87UUFDSCxHQUFHLEVBQUUsOENBQThDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUNuRSxHQUFHLEVBQUUsOENBQThDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztLQUN0RSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHFEQUFxRCxDQUFDLFVBQWU7SUFDMUUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXdDLENBQUM7SUFDbkcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLGdEQUFnRCxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDM0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsVUFBVSxDQUFDLEdBQUcsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLGdEQUFnRCxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDM0ksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQWlERDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHdDQUF3QyxDQUFDLFVBQWU7SUFDN0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDdkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxvREFBb0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ3JJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM5RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxtREFBbUQsQ0FBQyxDQUFDO0FBQzVFLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw4Q0FBOEMsQ0FBQyxVQUFlO0lBQ25FLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx3Q0FBd0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNyRSxPQUFPO1FBQ0gsTUFBTSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1FBQ3JELFlBQVksRUFBRSwwREFBMEQsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pHLFFBQVEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN6RCxJQUFJLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxnREFBZ0QsQ0FBQyxVQUFlO0lBQ3JFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFtQyxDQUFDO0lBQzlGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsUUFBUSxFQUFFLFVBQVUsQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsNERBQTRELENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDN0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxVQUFVLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQy9GLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFpQ0Q7Ozs7OztHQU1HO0FBQ0gsU0FBUyxvREFBb0QsQ0FBQyxVQUFlO0lBQ3pFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywrREFBK0QsQ0FBQyxDQUFDO0FBQ3hGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywwREFBMEQsQ0FBQyxVQUFlO0lBQy9FLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxvREFBb0QsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNqRixPQUFPO1FBQ0gsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO0tBQzFELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsNERBQTRELENBQUMsVUFBZTtJQUNqRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBK0MsQ0FBQztJQUMxRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFvREQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxtQ0FBbUMsQ0FBQyxVQUFlO0lBQ3hELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLCtDQUErQyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDeEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsa0VBQWtFLENBQUMsQ0FBQztBQUMzRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMENBQTBDLENBQUMsVUFBZTtJQUMvRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsbUNBQW1DLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDaEUsT0FBTztRQUNILFFBQVEsRUFBRSxxREFBcUQsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3BGLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNGLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekUsWUFBWSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pFLElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw0Q0FBNEMsQ0FBQyxVQUFlO0lBQ2pFLFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQThCLENBQUM7SUFDekYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxVQUFVLEVBQUUsdURBQXVELENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDNUgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUMzSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEscUJBQXNCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUE0RXREOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBaUM7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUscUJBQXFCLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0FwRnZGLHFCQUFxQjs7OztRQXFGMUIsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzdDLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLG1CQUFtQixFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7UUFDL0MsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLG1DQUFtQyxFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsRUFBRSxlQUFlLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUN0STtJQXpGRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcsNENBQTRDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUNyRixNQUFNLEdBQUcsR0FBRyxJQUFJLHFCQUFxQixDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3BFLEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsRUFBRztZQUMzRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsa0JBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDN0QsT0FBTyxHQUFHLENBQUM7S0FDZDtJQTBFRDs7Ozs7T0FLRztJQUNJLE9BQU8sQ0FBQyxTQUE0QjtRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLHFCQUFxQixDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDcEcsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtTQUMvQixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLDBDQUEwQyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzVEOztBQXhITCxzREF5SEM7OztBQXhIRzs7R0FFRztBQUNvQiw0Q0FBc0IsR0FBRyxtQ0FBbUMsQ0FBQztBQWdKeEY7Ozs7OztHQU1HO0FBQ0gsU0FBUyxtREFBbUQsQ0FBQyxVQUFlO0lBQ3hFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyw0REFBNEQsQ0FBQyxDQUFDO0FBQ3JGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx5REFBeUQsQ0FBQyxVQUFlO0lBQzlFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxtREFBbUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNoRixPQUFPO1FBQ0gsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO0tBQzFELENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsMkRBQTJELENBQUMsVUFBZTtJQUNoRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBOEMsQ0FBQztJQUN6RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFxQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUywwQ0FBMEMsQ0FBQyxVQUFlO0lBQy9ELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLG1EQUFtRCxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDcEksT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG1EQUFtRCxDQUFDLENBQUM7QUFDNUUsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdEQUFnRCxDQUFDLFVBQWU7SUFDckUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDBDQUEwQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3ZFLE9BQU87UUFDSCxZQUFZLEVBQUUseURBQXlELENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztLQUNuRyxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLGtEQUFrRCxDQUFDLFVBQWU7SUFDdkUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXFDLENBQUM7SUFDaEcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsMkRBQTJELENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDNUksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXFCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLCtDQUErQyxDQUFDLFVBQWU7SUFDcEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSwwQ0FBMEMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3REFBd0QsQ0FBQyxDQUFDO0FBQ2pGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxxREFBcUQsQ0FBQyxVQUFlO0lBQzFFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwrQ0FBK0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM1RSxPQUFPO1FBQ0gsR0FBRyxFQUFFLGdEQUFnRCxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDeEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx1REFBdUQsQ0FBQyxVQUFlO0lBQzVFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUEwQyxDQUFDO0lBQ3JHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxrREFBa0QsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdJLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFvRUQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxtQ0FBbUMsQ0FBQyxVQUFlO0lBQ3hELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3ZGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQzNHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsa0VBQWtFLENBQUMsQ0FBQztBQUMzRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMENBQTBDLENBQUMsVUFBZTtJQUMvRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsbUNBQW1DLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDaEUsT0FBTztRQUNILGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNGLElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRCxNQUFNLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDckQsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RSxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsWUFBWSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pFLElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw0Q0FBNEMsQ0FBQyxVQUFlO0lBQ2pFLFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQThCLENBQUM7SUFDekYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUMzSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQy9GLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsUUFBUSxFQUFFLFVBQVUsQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0ksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckosR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEscUJBQXNCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUE0RnREOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBaUM7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUscUJBQXFCLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0FwR3ZGLHFCQUFxQjs7OztRQXFHMUIsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdEQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3pDLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7UUFDakQsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsbUNBQW1DLEVBQUUsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLGVBQWUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQ3RJO0lBM0dEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyw0Q0FBNEMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3JGLE1BQU0sR0FBRyxHQUFHLElBQUkscUJBQXFCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDcEUsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBNEZEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUscUJBQXFCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNwRyxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDZixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07WUFDbkIsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtTQUMvQixDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLDBDQUEwQyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzVEOztBQTVJTCxzREE2SUM7OztBQTVJRzs7R0FFRztBQUNvQiw0Q0FBc0IsR0FBRyxtQ0FBbUMsQ0FBQztBQXFQeEY7Ozs7OztHQU1HO0FBQ0gsU0FBUyw2QkFBNkIsQ0FBQyxVQUFlO0lBQ2xELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUNsSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMvRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMseUNBQXlDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ3ZJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGlEQUFpRCxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMxSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUM3RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDREQUE0RCxDQUFDLENBQUM7QUFDckYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLG9DQUFvQyxDQUFDLFVBQWU7SUFDekQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDZCQUE2QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzFELE9BQU87UUFDSCxTQUFTLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNFLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7UUFDN0UsU0FBUyxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsK0NBQStDLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQ2hHLFNBQVMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCxjQUFjLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RSxpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNFLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDM0UsZ0JBQWdCLEVBQUUsdURBQXVELENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQ3RHLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDM0UsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxJQUFJLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ3BFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsc0NBQXNDLENBQUMsVUFBZTtJQUMzRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUF3QixDQUFDO0lBQ25GLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDbkgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUN6SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLGlEQUFpRCxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEssR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsVUFBVSxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SixHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLEVBQUUsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxVQUFVLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TCxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMseURBQXlELENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3hNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxtQkFBbUIsRUFBRSxVQUFVLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6TCxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckssR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBZ0IsQ0FBQyxDQUFDO0lBQ25MLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7O0dBU0c7QUFDSCxNQUFhLGVBQWdCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFvSWhEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBMkI7UUFDckUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsZUFBZSxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBNUlqRixlQUFlOzs7O1FBNklwQixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDOUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdkQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzlDLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7UUFDL0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7UUFDL0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLDZCQUE2QixFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsRUFBRSxlQUFlLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUNoSTtJQTFKRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcsc0NBQXNDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUMvRSxNQUFNLEdBQUcsR0FBRyxJQUFJLGVBQWUsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM5RCxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUEySUQ7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxlQUFlLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUM5RixTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1NBQy9CLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sb0NBQW9DLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDdEQ7O0FBak1MLDBDQWtNQzs7O0FBak1HOztHQUVHO0FBQ29CLHNDQUFzQixHQUFHLDZCQUE2QixDQUFDO0FBeU5sRjs7Ozs7O0dBTUc7QUFDSCxTQUFTLHlDQUF5QyxDQUFDLFVBQWU7SUFDOUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM5RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUN0RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3REFBd0QsQ0FBQyxDQUFDO0FBQ2pGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywrQ0FBK0MsQ0FBQyxVQUFlO0lBQ3BFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx5Q0FBeUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN0RSxPQUFPO1FBQ0gsUUFBUSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3pELElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLGlEQUFpRCxDQUFDLFVBQWU7SUFDdEUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQW9DLENBQUM7SUFDL0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxVQUFVLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQy9GLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxpREFBaUQsQ0FBQyxVQUFlO0lBQ3RFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUN2SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxnRUFBZ0UsQ0FBQyxDQUFDO0FBQ3pGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx1REFBdUQsQ0FBQyxVQUFlO0lBQzVFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxpREFBaUQsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM5RSxPQUFPO1FBQ0gsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQztRQUNyRixhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7S0FDdEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyx5REFBeUQsQ0FBQyxVQUFlO0lBQzlFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUE0QyxDQUFDO0lBQ3ZHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSx3QkFBd0IsRUFBRSxVQUFVLENBQUMsc0JBQXNCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3TSxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLGVBQWUsRUFBRSxVQUFVLENBQUMsYUFBYSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pLLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUE4REQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyw0QkFBNEIsQ0FBQyxVQUFlO0lBQ2pELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsNENBQTRDLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUM3SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLDRDQUE0QyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDN0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLG1DQUFtQyxDQUFDLFVBQWU7SUFDeEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDRCQUE0QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pELE9BQU87UUFDSCxZQUFZLEVBQUUsa0RBQWtELENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUN6RixZQUFZLEVBQUUsa0RBQWtELENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUN6RixjQUFjLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDckUsWUFBWSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pFLElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxxQ0FBcUMsQ0FBQyxVQUFlO0lBQzFELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXVCLENBQUM7SUFDbEYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsb0RBQW9ELENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDckksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLG9EQUFvRCxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0ssR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEsY0FBZSxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBc0YvQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLGNBQWMsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQTlGaEYsY0FBYzs7OztRQStGbkIsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ2pELElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSw0QkFBNEIsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDL0g7SUFsR0Q7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLHFDQUFxQyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDOUUsTUFBTSxHQUFHLEdBQUcsSUFBSSxjQUFjLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDN0QsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBbUZEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsY0FBYyxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDN0YsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7U0FDL0IsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyxtQ0FBbUMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNyRDs7QUFqSUwsd0NBa0lDOzs7QUFqSUc7O0dBRUc7QUFDb0IscUNBQXNCLEdBQUcsNEJBQTRCLENBQUM7QUE0SmpGOzs7Ozs7R0FNRztBQUNILFNBQVMsNENBQTRDLENBQUMsVUFBZTtJQUNqRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUN6RixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsNERBQTRELENBQUMsQ0FBQztBQUNyRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsa0RBQWtELENBQUMsVUFBZTtJQUN2RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsNENBQTRDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekUsT0FBTztRQUNILE9BQU8sRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztLQUMxRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLG9EQUFvRCxDQUFDLFVBQWU7SUFDekUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXVDLENBQUM7SUFDbEcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsVUFBVSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqSixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBcUJEOzs7Ozs7R0FNRztBQUNILFNBQVMsNENBQTRDLENBQUMsVUFBZTtJQUNqRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyw0REFBNEQsQ0FBQyxDQUFDO0FBQ3JGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxrREFBa0QsQ0FBQyxVQUFlO0lBQ3ZFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCw0Q0FBNEMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN6RSxPQUFPO1FBQ0gsU0FBUyxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztLQUM5RSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLG9EQUFvRCxDQUFDLFVBQWU7SUFDekUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQXVDLENBQUM7SUFDbEcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNuSCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBcUZEOzs7Ozs7R0FNRztBQUNILFNBQVMsc0NBQXNDLENBQUMsVUFBZTtJQUMzRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxxRUFBcUUsQ0FBQyxDQUFDO0FBQzlGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxzQ0FBc0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNuRSxPQUFPO1FBQ0gsU0FBUyxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRSxTQUFTLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDM0QsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELFNBQVMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzRCxpQkFBaUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO1FBQzNFLGNBQWMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUNyRSxVQUFVLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0QsY0FBYyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3JFLFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxJQUFJLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ3BFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsK0NBQStDLENBQUMsVUFBZTtJQUNwRSxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFpQyxDQUFDO0lBQzVGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDbkgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsVUFBVSxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SixHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFVBQVUsQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekosR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFVBQVUsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0ssR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFnQixDQUFDLENBQUM7SUFDbkwsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEsd0JBQXlCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUE2R3pEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBb0M7UUFDOUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsd0JBQXdCLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0FySDFGLHdCQUF3Qjs7OztRQXNIN0IsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzlDLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxzQ0FBc0MsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDekk7SUE5SEQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLCtDQUErQyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDeEYsTUFBTSxHQUFHLEdBQUcsSUFBSSx3QkFBd0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN2RSxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUErR0Q7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSx3QkFBd0IsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3ZHLFNBQVMsQ0FBQyxZQUFZLENBQUMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzlFO0lBRUQsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1NBQy9CLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sNkNBQTZDLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDL0Q7O0FBbEtMLDREQW1LQzs7O0FBbEtHOztHQUVHO0FBQ29CLCtDQUFzQixHQUFHLHNDQUFzQyxDQUFDO0FBbU4zRjs7Ozs7O0dBTUc7QUFDSCxTQUFTLDJCQUEyQixDQUFDLFVBQWU7SUFDaEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzlGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSx1Q0FBdUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQ2hILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywwREFBMEQsQ0FBQyxDQUFDO0FBQ25GLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxrQ0FBa0MsQ0FBQyxVQUFlO0lBQ3ZELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCwyQkFBMkIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN4RCxPQUFPO1FBQ0gsUUFBUSxFQUFFLDZDQUE2QyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDNUUsV0FBVyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQy9ELGNBQWMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUNyRSxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLG9DQUFvQyxDQUFDLFVBQWU7SUFDekQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBc0IsQ0FBQztJQUNqRixHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSwrQ0FBK0MsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUNwSCxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxVQUFVLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckssR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBZ0IsQ0FBQyxDQUFDO0lBQ25MLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7Ozs7R0FXRztBQUNILE1BQWEsYUFBYyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBNEU5Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLGFBQWEsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQXBGL0UsYUFBYTs7OztRQXFGbEIsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzdDLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSwyQkFBMkIsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDOUg7SUF4RkQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLG9DQUFvQyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDN0UsTUFBTSxHQUFHLEdBQUcsSUFBSSxhQUFhLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDNUQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBeUVEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsYUFBYSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDNUYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7U0FDL0IsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyxrQ0FBa0MsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNwRDs7QUF2SEwsc0NBd0hDOzs7QUF2SEc7O0dBRUc7QUFDb0Isb0NBQXNCLEdBQUcsMkJBQTJCLENBQUM7QUEySWhGOzs7Ozs7R0FNRztBQUNILFNBQVMsdUNBQXVDLENBQUMsVUFBZTtJQUM1RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNwSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNqSCxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsd0RBQXdELENBQUMsQ0FBQztBQUNqRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNkNBQTZDLENBQUMsVUFBZTtJQUNsRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsdUNBQXVDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDcEUsT0FBTztRQUNILG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7S0FDbEYsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUywrQ0FBK0MsQ0FBQyxVQUFlO0lBQ3BFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFrQyxDQUFDO0lBQzdGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDNUksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQStFRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLDRCQUE0QixDQUFDLFVBQWU7SUFDakQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUNoSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3ZGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSw0Q0FBNEMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQzdILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLG1DQUFtQyxDQUFDLFVBQWU7SUFDeEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDRCQUE0QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pELE9BQU87UUFDSCxTQUFTLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQzNFLElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRCxNQUFNLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDckQsWUFBWSxFQUFFLGtEQUFrRCxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDekYsUUFBUSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3pELGNBQWMsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUNyRSxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHFDQUFxQyxDQUFDLFVBQWU7SUFDMUQsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBdUIsQ0FBQztJQUNsRixHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLFdBQVcsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ25ILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxRQUFRLEVBQUUsVUFBVSxDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSxVQUFVLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsb0RBQW9ELENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxVQUFVLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsY0FBYyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckssR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBZ0IsQ0FBQyxDQUFDO0lBQ25MLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUFFRDs7Ozs7Ozs7O0dBU0c7QUFDSCxNQUFhLGNBQWUsU0FBUSxHQUFHLENBQUMsV0FBVztJQXVHL0M7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxjQUFjLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0EvR2hGLGNBQWM7Ozs7UUFnSG5CLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM5QyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekMsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFDdEUsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7UUFFdEUsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7UUFDM0IsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsRUFBRSxlQUFlLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUMvSDtJQXZIRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBb0IsRUFBRSxFQUFVLEVBQUUsa0JBQXVCLEVBQUUsT0FBNEM7UUFDckksa0JBQWtCLEdBQUcsa0JBQWtCLElBQUksRUFBRSxDQUFDO1FBQzlDLE1BQU0sa0JBQWtCLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDcEYsTUFBTSxXQUFXLEdBQUcscUNBQXFDLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUM5RSxNQUFNLEdBQUcsR0FBRyxJQUFJLGNBQWMsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM3RCxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUF3R0Q7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7UUFDdkMsU0FBUyxDQUFDLFlBQVksQ0FBQyw2QkFBNkIsRUFBRSxjQUFjLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUM3RixTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNuQixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1NBQy9CLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sbUNBQW1DLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDckQ7O0FBekpMLHdDQTBKQzs7O0FBekpHOztHQUVHO0FBQ29CLHFDQUFzQixHQUFHLDRCQUE0QixDQUFDO0FBdUxqRjs7Ozs7O0dBTUc7QUFDSCxTQUFTLDRDQUE0QyxDQUFDLFVBQWU7SUFDakUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDREQUE0RCxDQUFDLENBQUM7QUFDckYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGtEQUFrRCxDQUFDLFVBQWU7SUFDdkUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELDRDQUE0QyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pFLE9BQU87UUFDSCxPQUFPLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7S0FDMUQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxvREFBb0QsQ0FBQyxVQUFlO0lBQ3pFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUF1QyxDQUFDO0lBQ2xHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakosR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQW9GRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLHFCQUFxQixDQUFDLFVBQWU7SUFDMUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDO0lBQ3JILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHdCQUF3QixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUM7SUFDMUgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUM7SUFDdkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsbUNBQW1DLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQy9ILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLG1DQUFtQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMvSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxnQ0FBZ0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxxQ0FBcUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzlHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDN0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLG9EQUFvRCxDQUFDLENBQUM7QUFDN0UsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDRCQUE0QixDQUFDLFVBQWU7SUFDakQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHFCQUFxQixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2xELE9BQU87UUFDSCxzQkFBc0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDO1FBQ3JGLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDM0UscUJBQXFCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUNuRixRQUFRLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyx5Q0FBeUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDeEYsUUFBUSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMseUNBQXlDLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3hGLElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUNqRCxPQUFPLEVBQUUsc0NBQXNDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUNuRSxRQUFRLEVBQUUsMkNBQTJDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUMxRSxJQUFJLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO0tBQ3BFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsOEJBQThCLENBQUMsVUFBZTtJQUNuRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFnQixDQUFDO0lBQzNFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSx3QkFBd0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUM7SUFDckosR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLG1CQUFtQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUN0SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsdUJBQXVCLEVBQUUsVUFBVSxDQUFDLHFCQUFxQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDek0sR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxVQUFVLEVBQUUsVUFBVSxDQUFDLFFBQVEsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsMkNBQTJDLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pNLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLDJDQUEyQyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyx3Q0FBd0MsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ25KLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyw2Q0FBNkMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7OztHQVNHO0FBQ0gsTUFBYSxPQUFRLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUF3SHhDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7UUFDN0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBaEl6RSxPQUFPOzs7O1FBaUlaLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLHdCQUF3QixFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzNELEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLG1CQUFtQixFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxtQ0FBbUMsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGlDQUFpQyxDQUFDLENBQUMsQ0FBQztRQUM1RyxJQUFJLENBQUMsOEJBQThCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDLENBQUM7UUFDbEcsSUFBSSxDQUFDLFVBQVUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7UUFDNUQsSUFBSSxDQUFDLFdBQVcsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7UUFFOUQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztRQUMzRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7UUFDekQsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxxQkFBcUIsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDeEg7SUEzSUQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLDhCQUE4QixDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDdkUsTUFBTSxHQUFHLEdBQUcsSUFBSSxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdEQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBNEhEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCO1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsT0FBTyxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDdEYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILHNCQUFzQixFQUFFLElBQUksQ0FBQyxzQkFBc0I7WUFDbkQsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN6QyxxQkFBcUIsRUFBRSxJQUFJLENBQUMscUJBQXFCO1lBQ2pELFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7U0FDL0IsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyw0QkFBNEIsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUM5Qzs7QUE5S0wsMEJBK0tDOzs7QUE5S0c7O0dBRUc7QUFDb0IsOEJBQXNCLEdBQUcscUJBQXFCLENBQUM7QUFzTTFFOzs7Ozs7R0FNRztBQUNILFNBQVMsbUNBQW1DLENBQUMsVUFBZTtJQUN4RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3JGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQywwREFBMEQsQ0FBQyxDQUFDO0FBQ25GLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx5Q0FBeUMsQ0FBQyxVQUFlO0lBQzlELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxtQ0FBbUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNoRSxPQUFPO1FBQ0gsVUFBVSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzdELEtBQUssRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztLQUN0RCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDJDQUEyQyxDQUFDLFVBQWU7SUFDaEUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQThCLENBQUM7SUFDekYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SixHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLE9BQU8sRUFBRSxVQUFVLENBQUMsS0FBSyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3pJLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUE4TUQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxnQ0FBZ0MsQ0FBQyxVQUFlO0lBQ3JELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDZCQUE2QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDO0lBQ2pJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHVEQUF1RCxDQUFDLENBQUM7QUFDaEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHNDQUFzQyxDQUFDLFVBQWU7SUFDM0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzdELE9BQU87UUFDSCxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7UUFDbkQsY0FBYyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3JFLEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsS0FBSyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDO1FBQ25ELFVBQVUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM3RCxhQUFhLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDbkUsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RSxvQkFBb0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pGLGVBQWUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUN2RSwyQkFBMkIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDO1FBQy9GLFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSxZQUFZLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDakUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQy9DLFVBQVUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztLQUNoRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLHdDQUF3QyxDQUFDLFVBQWU7SUFDN0QsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQTJCLENBQUM7SUFDdEYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsVUFBVSxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsZ0JBQWdCLEVBQUUsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxVQUFVLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pJLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckosR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsVUFBVSxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLFVBQVUsQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDekssR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsRUFBRSxVQUFVLENBQUMsb0JBQW9CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTSxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsaUJBQWlCLEVBQUUsVUFBVSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNqTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsNkJBQTZCLEVBQUUsVUFBVSxDQUFDLDJCQUEyQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsMkJBQTJCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDak8sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsVUFBVSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNySyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLGNBQWMsRUFBRSxVQUFVLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3JLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFVBQVUsQ0FBQyxHQUFHLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakksR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3SixHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBcUJEOzs7Ozs7R0FNRztBQUNILFNBQVMscUNBQXFDLENBQUMsVUFBZTtJQUMxRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUNsSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMvRyxPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsNERBQTRELENBQUMsQ0FBQztBQUNyRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMkNBQTJDLENBQUMsVUFBZTtJQUNoRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQscUNBQXFDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbEUsT0FBTztRQUNILGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUM7S0FDaEYsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFnQyxDQUFDO0lBQzNGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxvQkFBb0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDekksR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDEyLTIwMjMgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuLy8gU2VlOiBkb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLXJlc291cmNlLXNwZWNpZmljYXRpb24uaHRtbFxuLy8gQGNmbjJ0czptZXRhQCB7XCJnZW5lcmF0ZWRcIjpcIjIwMjMtMDMtMjJUMTg6NDI6MTEuOTI2WlwiLFwiZmluZ2VycHJpbnRcIjpcImZpOW1LMzQxa2dvdVFLdmNWWkF5TnJwWndYTjRqbzY5ODlTZ004R3hFemc9XCJ9XG5cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4gKi8gLy8gVGhpcyBpcyBnZW5lcmF0ZWQgY29kZSAtIGxpbmUgbGVuZ3RocyBhcmUgZGlmZmljdWx0IHRvIGNvbnRyb2xcblxuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY2ZuX3BhcnNlIGZyb20gJ0Bhd3MtY2RrL2NvcmUvbGliL2hlbHBlcnMtaW50ZXJuYWwnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkFnZW50YFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1hZ2VudC5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuQWdlbnRQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBZb3VyIGFnZW50IGFjdGl2YXRpb24ga2V5LiBZb3UgY2FuIGdldCB0aGUgYWN0aXZhdGlvbiBrZXkgZWl0aGVyIGJ5IHNlbmRpbmcgYW4gSFRUUCBHRVQgcmVxdWVzdCB3aXRoIHJlZGlyZWN0cyB0aGF0IGVuYWJsZSB5b3UgdG8gZ2V0IHRoZSBhZ2VudCBJUCBhZGRyZXNzIChwb3J0IDgwKS4gQWx0ZXJuYXRpdmVseSwgeW91IGNhbiBnZXQgaXQgZnJvbSB0aGUgRGF0YVN5bmMgY29uc29sZS5cbiAgICAgKlxuICAgICAqIFRoZSByZWRpcmVjdCBVUkwgcmV0dXJuZWQgaW4gdGhlIHJlc3BvbnNlIHByb3ZpZGVzIHlvdSB0aGUgYWN0aXZhdGlvbiBrZXkgZm9yIHlvdXIgYWdlbnQgaW4gdGhlIHF1ZXJ5IHN0cmluZyBwYXJhbWV0ZXIgYGFjdGl2YXRpb25LZXlgIC4gSXQgbWlnaHQgYWxzbyBpbmNsdWRlIG90aGVyIGFjdGl2YXRpb24tcmVsYXRlZCBwYXJhbWV0ZXJzOyBob3dldmVyLCB0aGVzZSBhcmUgbWVyZWx5IGRlZmF1bHRzLiBUaGUgYXJndW1lbnRzIHlvdSBwYXNzIHRvIHRoaXMgQVBJIGNhbGwgZGV0ZXJtaW5lIHRoZSBhY3R1YWwgY29uZmlndXJhdGlvbiBvZiB5b3VyIGFnZW50LlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ3JlYXRpbmcgYW5kIGFjdGl2YXRpbmcgYW4gYWdlbnRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2FjdGl2YXRpbmctYWdlbnQuaHRtbCkgaW4gdGhlICpBV1MgRGF0YVN5bmMgVXNlciBHdWlkZS4qXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1hZ2VudC5odG1sI2Nmbi1kYXRhc3luYy1hZ2VudC1hY3RpdmF0aW9ua2V5XG4gICAgICovXG4gICAgcmVhZG9ubHkgYWN0aXZhdGlvbktleT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIHlvdSBjb25maWd1cmVkIGZvciB5b3VyIGFnZW50LiBUaGlzIHZhbHVlIGlzIGEgdGV4dCByZWZlcmVuY2UgdGhhdCBpcyB1c2VkIHRvIGlkZW50aWZ5IHRoZSBhZ2VudCBpbiB0aGUgY29uc29sZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWFnZW50Lmh0bWwjY2ZuLWRhdGFzeW5jLWFnZW50LWFnZW50bmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFnZW50TmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZXMgKEFSTnMpIG9mIHRoZSBzZWN1cml0eSBncm91cHMgdXNlZCB0byBwcm90ZWN0IHlvdXIgZGF0YSB0cmFuc2ZlciB0YXNrIHN1Ym5ldHMuIFNlZSBbU2VjdXJpdHlHcm91cEFybnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL0FQSV9FYzJDb25maWcuaHRtbCNEYXRhU3luYy1UeXBlLUVjMkNvbmZpZy1TZWN1cml0eUdyb3VwQXJucykgLlxuICAgICAqXG4gICAgICogKlBhdHRlcm4qIDogYF5hcm46KGF3c3xhd3MtY258YXdzLXVzLWdvdnxhd3MtaXNvfGF3cy1pc28tYik6ZWMyOlthLXpcXC0wLTldKjpbMC05XXsxMn06c2VjdXJpdHktZ3JvdXAvLiokYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtYWdlbnQuaHRtbCNjZm4tZGF0YXN5bmMtYWdlbnQtc2VjdXJpdHlncm91cGFybnNcbiAgICAgKi9cbiAgICByZWFkb25seSBzZWN1cml0eUdyb3VwQXJucz86IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOcykgb2YgdGhlIHN1Ym5ldHMgaW4gd2hpY2ggRGF0YVN5bmMgd2lsbCBjcmVhdGUgZWxhc3RpYyBuZXR3b3JrIGludGVyZmFjZXMgZm9yIGVhY2ggZGF0YSB0cmFuc2ZlciB0YXNrLiBUaGUgYWdlbnQgdGhhdCBydW5zIGEgdGFzayBtdXN0IGJlIHByaXZhdGUuIFdoZW4geW91IHN0YXJ0IGEgdGFzayB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBhbiBhZ2VudCBjcmVhdGVkIGluIGEgVlBDLCBvciBvbmUgdGhhdCBoYXMgYWNjZXNzIHRvIGFuIElQIGFkZHJlc3MgaW4gYSBWUEMsIHRoZW4gdGhlIHRhc2sgaXMgYWxzbyBwcml2YXRlLiBJbiB0aGlzIGNhc2UsIERhdGFTeW5jIGNyZWF0ZXMgZm91ciBuZXR3b3JrIGludGVyZmFjZXMgZm9yIGVhY2ggdGFzayBpbiB5b3VyIHN1Ym5ldC4gRm9yIGEgZGF0YSB0cmFuc2ZlciB0byB3b3JrLCB0aGUgYWdlbnQgbXVzdCBiZSBhYmxlIHRvIHJvdXRlIHRvIGFsbCB0aGVzZSBmb3VyIG5ldHdvcmsgaW50ZXJmYWNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWFnZW50Lmh0bWwjY2ZuLWRhdGFzeW5jLWFnZW50LXN1Ym5ldGFybnNcbiAgICAgKi9cbiAgICByZWFkb25seSBzdWJuZXRBcm5zPzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUga2V5LXZhbHVlIHBhaXIgdGhhdCByZXByZXNlbnRzIHRoZSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhc3NvY2lhdGUgd2l0aCB0aGUgYWdlbnQuIFRoZSB2YWx1ZSBjYW4gYmUgYW4gZW1wdHkgc3RyaW5nLiBUaGlzIHZhbHVlIGhlbHBzIHlvdSBtYW5hZ2UsIGZpbHRlciwgYW5kIHNlYXJjaCBmb3IgeW91ciBhZ2VudHMuXG4gICAgICpcbiAgICAgKiA+IFZhbGlkIGNoYXJhY3RlcnMgZm9yIGtleSBhbmQgdmFsdWUgYXJlIGxldHRlcnMsIHNwYWNlcywgYW5kIG51bWJlcnMgcmVwcmVzZW50YWJsZSBpbiBVVEYtOCBmb3JtYXQsIGFuZCB0aGUgZm9sbG93aW5nIHNwZWNpYWwgY2hhcmFjdGVyczogKyAtID0gLiBfIDogLyBALlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtYWdlbnQuaHRtbCNjZm4tZGF0YXN5bmMtYWdlbnQtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgSUQgb2YgdGhlIHZpcnR1YWwgcHJpdmF0ZSBjbG91ZCAoVlBDKSBlbmRwb2ludCB0aGF0IHRoZSBhZ2VudCBoYXMgYWNjZXNzIHRvLiBUaGlzIGlzIHRoZSBjbGllbnQtc2lkZSBWUEMgZW5kcG9pbnQsIHBvd2VyZWQgYnkgQVdTIFByaXZhdGVMaW5rIC4gSWYgeW91IGRvbid0IGhhdmUgYW4gQVdTIFByaXZhdGVMaW5rIFZQQyBlbmRwb2ludCwgc2VlIFtBV1MgUHJpdmF0ZUxpbmsgYW5kIFZQQyBlbmRwb2ludHNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS8vdnBjL2xhdGVzdC91c2VyZ3VpZGUvZW5kcG9pbnQtc2VydmljZXMtb3ZlcnZpZXcuaHRtbCkgaW4gdGhlICpBbWF6b24gVlBDIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IGFjdGl2YXRpbmcgeW91ciBhZ2VudCBpbiBhIHByaXZhdGUgbmV0d29yayBiYXNlZCBvbiBhIFZQQywgc2VlIFtVc2luZyBBV1MgRGF0YVN5bmMgaW4gYSBWaXJ0dWFsIFByaXZhdGUgQ2xvdWRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2RhdGFzeW5jLWluLXZwYy5odG1sKSBpbiB0aGUgKkFXUyBEYXRhU3luYyBVc2VyIEd1aWRlLipcbiAgICAgKlxuICAgICAqIEEgVlBDIGVuZHBvaW50IElEIGxvb2tzIGxpa2UgdGhpczogYHZwY2UtMDEyMzRkNWFmZjY3ODkwZTFgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWFnZW50Lmh0bWwjY2ZuLWRhdGFzeW5jLWFnZW50LXZwY2VuZHBvaW50aWRcbiAgICAgKi9cbiAgICByZWFkb25seSB2cGNFbmRwb2ludElkPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbkFnZW50UHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkFnZW50UHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuQWdlbnRQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2FjdGl2YXRpb25LZXknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYWN0aXZhdGlvbktleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWdlbnROYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmFnZW50TmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlHcm91cEFybnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJuZXRBcm5zJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5zdWJuZXRBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd2cGNFbmRwb2ludElkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZwY0VuZHBvaW50SWQpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuQWdlbnRQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkFnZW50YCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5BZ2VudFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6QWdlbnRgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuQWdlbnRQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuQWdlbnRQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQWN0aXZhdGlvbktleTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5hY3RpdmF0aW9uS2V5KSxcbiAgICAgICAgQWdlbnROYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmFnZW50TmFtZSksXG4gICAgICAgIFNlY3VyaXR5R3JvdXBBcm5zOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5zZWN1cml0eUdyb3VwQXJucyksXG4gICAgICAgIFN1Ym5ldEFybnM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnN1Ym5ldEFybnMpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICAgICAgVnBjRW5kcG9pbnRJZDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy52cGNFbmRwb2ludElkKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuQWdlbnRQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkFnZW50UHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkFnZW50UHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhY3RpdmF0aW9uS2V5JywgJ0FjdGl2YXRpb25LZXknLCBwcm9wZXJ0aWVzLkFjdGl2YXRpb25LZXkgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQWN0aXZhdGlvbktleSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWdlbnROYW1lJywgJ0FnZW50TmFtZScsIHByb3BlcnRpZXMuQWdlbnROYW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkFnZW50TmFtZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2VjdXJpdHlHcm91cEFybnMnLCAnU2VjdXJpdHlHcm91cEFybnMnLCBwcm9wZXJ0aWVzLlNlY3VyaXR5R3JvdXBBcm5zICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuU2VjdXJpdHlHcm91cEFybnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N1Ym5ldEFybnMnLCAnU3VibmV0QXJucycsIHByb3BlcnRpZXMuU3VibmV0QXJucyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLlN1Ym5ldEFybnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndnBjRW5kcG9pbnRJZCcsICdWcGNFbmRwb2ludElkJywgcHJvcGVydGllcy5WcGNFbmRwb2ludElkICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZwY0VuZHBvaW50SWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkRhdGFTeW5jOjpBZ2VudGBcbiAqXG4gKiBUaGUgYEFXUzo6RGF0YVN5bmM6OkFnZW50YCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gQVdTIERhdGFTeW5jIGFnZW50IHRvIGJlIGRlcGxveWVkIGFuZCBhY3RpdmF0ZWQgb24geW91ciBob3N0LiBUaGUgYWN0aXZhdGlvbiBwcm9jZXNzIGFzc29jaWF0ZXMgeW91ciBhZ2VudCB3aXRoIHlvdXIgYWNjb3VudC4gSW4gdGhlIGFjdGl2YXRpb24gcHJvY2VzcywgeW91IHNwZWNpZnkgaW5mb3JtYXRpb24gc3VjaCBhcyB0aGUgQVdTIFJlZ2lvbiB0aGF0IHlvdSB3YW50IHRvIGFjdGl2YXRlIHRoZSBhZ2VudCBpbi4gWW91IGFjdGl2YXRlIHRoZSBhZ2VudCBpbiB0aGUgQVdTIFJlZ2lvbiB3aGVyZSB5b3VyIHRhcmdldCBsb2NhdGlvbnMgKGluIEFtYXpvbiBTMywgQW1hem9uIEVGUywgb3IgQW1hem9uIEZTeCBmb3IgV2luZG93cyBGaWxlIFNlcnZlcikgcmVzaWRlLiBZb3VyIHRhc2tzIGFyZSBjcmVhdGVkIGluIHRoaXMgQVdTIFJlZ2lvbiAuXG4gKlxuICogWW91IGNhbiBhY3RpdmF0ZSB0aGUgYWdlbnQgaW4gYSB2aXJ0dWFsIHByaXZhdGUgY2xvdWQgKFZQQykgb3IgcHJvdmlkZSB0aGUgYWdlbnQgYWNjZXNzIHRvIGEgVlBDIGVuZHBvaW50IHNvIHRoYXQgeW91IGNhbiBydW4gdGFza3Mgd2l0aG91dCBzZW5kaW5nIHRoZW0gb3ZlciB0aGUgcHVibGljIGludGVybmV0LlxuICpcbiAqIFlvdSBjYW4gc3BlY2lmeSBhbiBhZ2VudCB0byBiZSB1c2VkIGZvciBtb3JlIHRoYW4gb25lIGxvY2F0aW9uLiBJZiBhIHRhc2sgdXNlcyBtdWx0aXBsZSBhZ2VudHMsIGFsbCBvZiB0aGVtIG11c3QgaGF2ZSBhIHN0YXR1cyBvZiBBVkFJTEFCTEUgZm9yIHRoZSB0YXNrIHRvIHJ1bi4gSWYgeW91IHVzZSBtdWx0aXBsZSBhZ2VudHMgZm9yIGEgc291cmNlIGxvY2F0aW9uLCB0aGUgc3RhdHVzIG9mIGFsbCB0aGUgYWdlbnRzIG11c3QgYmUgQVZBSUxBQkxFIGZvciB0aGUgdGFzayB0byBydW4uXG4gKlxuICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQWN0aXZhdGluZyBhbiBBZ2VudF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvYWN0aXZhdGluZy1hZ2VudC5odG1sKSBpbiB0aGUgKkFXUyBEYXRhU3luYyBVc2VyIEd1aWRlKiAuXG4gKlxuICogQWdlbnRzIGFyZSBhdXRvbWF0aWNhbGx5IHVwZGF0ZWQgYnkgQVdTIG9uIGEgcmVndWxhciBiYXNpcywgdXNpbmcgYSBtZWNoYW5pc20gdGhhdCBlbnN1cmVzIG1pbmltYWwgaW50ZXJydXB0aW9uIHRvIHlvdXIgdGFza3MuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6QWdlbnRcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1hZ2VudC5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5BZ2VudCBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpBZ2VudFwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuQWdlbnQge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkFnZW50UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkFnZW50KHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgYWdlbnQuIFVzZSB0aGUgYExpc3RBZ2VudHNgIG9wZXJhdGlvbiB0byByZXR1cm4gYSBsaXN0IG9mIGFnZW50cyBmb3IgeW91ciBhY2NvdW50IGFuZCBBV1MgUmVnaW9uIC5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQWdlbnRBcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFnZW50QXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdHlwZSBvZiBlbmRwb2ludCB0aGF0IHlvdXIgYWdlbnQgaXMgY29ubmVjdGVkIHRvLiBJZiB0aGUgZW5kcG9pbnQgaXMgYSBWUEMgZW5kcG9pbnQsIHRoZSBhZ2VudCBpcyBub3QgYWNjZXNzaWJsZSBvdmVyIHRoZSBwdWJsaWMgaW50ZXJuZXQuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEVuZHBvaW50VHlwZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRW5kcG9pbnRUeXBlOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBZb3VyIGFnZW50IGFjdGl2YXRpb24ga2V5LiBZb3UgY2FuIGdldCB0aGUgYWN0aXZhdGlvbiBrZXkgZWl0aGVyIGJ5IHNlbmRpbmcgYW4gSFRUUCBHRVQgcmVxdWVzdCB3aXRoIHJlZGlyZWN0cyB0aGF0IGVuYWJsZSB5b3UgdG8gZ2V0IHRoZSBhZ2VudCBJUCBhZGRyZXNzIChwb3J0IDgwKS4gQWx0ZXJuYXRpdmVseSwgeW91IGNhbiBnZXQgaXQgZnJvbSB0aGUgRGF0YVN5bmMgY29uc29sZS5cbiAgICAgKlxuICAgICAqIFRoZSByZWRpcmVjdCBVUkwgcmV0dXJuZWQgaW4gdGhlIHJlc3BvbnNlIHByb3ZpZGVzIHlvdSB0aGUgYWN0aXZhdGlvbiBrZXkgZm9yIHlvdXIgYWdlbnQgaW4gdGhlIHF1ZXJ5IHN0cmluZyBwYXJhbWV0ZXIgYGFjdGl2YXRpb25LZXlgIC4gSXQgbWlnaHQgYWxzbyBpbmNsdWRlIG90aGVyIGFjdGl2YXRpb24tcmVsYXRlZCBwYXJhbWV0ZXJzOyBob3dldmVyLCB0aGVzZSBhcmUgbWVyZWx5IGRlZmF1bHRzLiBUaGUgYXJndW1lbnRzIHlvdSBwYXNzIHRvIHRoaXMgQVBJIGNhbGwgZGV0ZXJtaW5lIHRoZSBhY3R1YWwgY29uZmlndXJhdGlvbiBvZiB5b3VyIGFnZW50LlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ3JlYXRpbmcgYW5kIGFjdGl2YXRpbmcgYW4gYWdlbnRdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2FjdGl2YXRpbmctYWdlbnQuaHRtbCkgaW4gdGhlICpBV1MgRGF0YVN5bmMgVXNlciBHdWlkZS4qXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1hZ2VudC5odG1sI2Nmbi1kYXRhc3luYy1hZ2VudC1hY3RpdmF0aW9ua2V5XG4gICAgICovXG4gICAgcHVibGljIGFjdGl2YXRpb25LZXk6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIHlvdSBjb25maWd1cmVkIGZvciB5b3VyIGFnZW50LiBUaGlzIHZhbHVlIGlzIGEgdGV4dCByZWZlcmVuY2UgdGhhdCBpcyB1c2VkIHRvIGlkZW50aWZ5IHRoZSBhZ2VudCBpbiB0aGUgY29uc29sZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWFnZW50Lmh0bWwjY2ZuLWRhdGFzeW5jLWFnZW50LWFnZW50bmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBhZ2VudE5hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZXMgKEFSTnMpIG9mIHRoZSBzZWN1cml0eSBncm91cHMgdXNlZCB0byBwcm90ZWN0IHlvdXIgZGF0YSB0cmFuc2ZlciB0YXNrIHN1Ym5ldHMuIFNlZSBbU2VjdXJpdHlHcm91cEFybnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL0FQSV9FYzJDb25maWcuaHRtbCNEYXRhU3luYy1UeXBlLUVjMkNvbmZpZy1TZWN1cml0eUdyb3VwQXJucykgLlxuICAgICAqXG4gICAgICogKlBhdHRlcm4qIDogYF5hcm46KGF3c3xhd3MtY258YXdzLXVzLWdvdnxhd3MtaXNvfGF3cy1pc28tYik6ZWMyOlthLXpcXC0wLTldKjpbMC05XXsxMn06c2VjdXJpdHktZ3JvdXAvLiokYFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtYWdlbnQuaHRtbCNjZm4tZGF0YXN5bmMtYWdlbnQtc2VjdXJpdHlncm91cGFybnNcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VjdXJpdHlHcm91cEFybnM6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOcykgb2YgdGhlIHN1Ym5ldHMgaW4gd2hpY2ggRGF0YVN5bmMgd2lsbCBjcmVhdGUgZWxhc3RpYyBuZXR3b3JrIGludGVyZmFjZXMgZm9yIGVhY2ggZGF0YSB0cmFuc2ZlciB0YXNrLiBUaGUgYWdlbnQgdGhhdCBydW5zIGEgdGFzayBtdXN0IGJlIHByaXZhdGUuIFdoZW4geW91IHN0YXJ0IGEgdGFzayB0aGF0IGlzIGFzc29jaWF0ZWQgd2l0aCBhbiBhZ2VudCBjcmVhdGVkIGluIGEgVlBDLCBvciBvbmUgdGhhdCBoYXMgYWNjZXNzIHRvIGFuIElQIGFkZHJlc3MgaW4gYSBWUEMsIHRoZW4gdGhlIHRhc2sgaXMgYWxzbyBwcml2YXRlLiBJbiB0aGlzIGNhc2UsIERhdGFTeW5jIGNyZWF0ZXMgZm91ciBuZXR3b3JrIGludGVyZmFjZXMgZm9yIGVhY2ggdGFzayBpbiB5b3VyIHN1Ym5ldC4gRm9yIGEgZGF0YSB0cmFuc2ZlciB0byB3b3JrLCB0aGUgYWdlbnQgbXVzdCBiZSBhYmxlIHRvIHJvdXRlIHRvIGFsbCB0aGVzZSBmb3VyIG5ldHdvcmsgaW50ZXJmYWNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWFnZW50Lmh0bWwjY2ZuLWRhdGFzeW5jLWFnZW50LXN1Ym5ldGFybnNcbiAgICAgKi9cbiAgICBwdWJsaWMgc3VibmV0QXJuczogc3RyaW5nW10gfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUga2V5LXZhbHVlIHBhaXIgdGhhdCByZXByZXNlbnRzIHRoZSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhc3NvY2lhdGUgd2l0aCB0aGUgYWdlbnQuIFRoZSB2YWx1ZSBjYW4gYmUgYW4gZW1wdHkgc3RyaW5nLiBUaGlzIHZhbHVlIGhlbHBzIHlvdSBtYW5hZ2UsIGZpbHRlciwgYW5kIHNlYXJjaCBmb3IgeW91ciBhZ2VudHMuXG4gICAgICpcbiAgICAgKiA+IFZhbGlkIGNoYXJhY3RlcnMgZm9yIGtleSBhbmQgdmFsdWUgYXJlIGxldHRlcnMsIHNwYWNlcywgYW5kIG51bWJlcnMgcmVwcmVzZW50YWJsZSBpbiBVVEYtOCBmb3JtYXQsIGFuZCB0aGUgZm9sbG93aW5nIHNwZWNpYWwgY2hhcmFjdGVyczogKyAtID0gLiBfIDogLyBALlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtYWdlbnQuaHRtbCNjZm4tZGF0YXN5bmMtYWdlbnQtdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB0YWdzOiBjZGsuVGFnTWFuYWdlcjtcblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiB0aGUgdmlydHVhbCBwcml2YXRlIGNsb3VkIChWUEMpIGVuZHBvaW50IHRoYXQgdGhlIGFnZW50IGhhcyBhY2Nlc3MgdG8uIFRoaXMgaXMgdGhlIGNsaWVudC1zaWRlIFZQQyBlbmRwb2ludCwgcG93ZXJlZCBieSBBV1MgUHJpdmF0ZUxpbmsgLiBJZiB5b3UgZG9uJ3QgaGF2ZSBhbiBBV1MgUHJpdmF0ZUxpbmsgVlBDIGVuZHBvaW50LCBzZWUgW0FXUyBQcml2YXRlTGluayBhbmQgVlBDIGVuZHBvaW50c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tLy92cGMvbGF0ZXN0L3VzZXJndWlkZS9lbmRwb2ludC1zZXJ2aWNlcy1vdmVydmlldy5odG1sKSBpbiB0aGUgKkFtYXpvbiBWUEMgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgYWN0aXZhdGluZyB5b3VyIGFnZW50IGluIGEgcHJpdmF0ZSBuZXR3b3JrIGJhc2VkIG9uIGEgVlBDLCBzZWUgW1VzaW5nIEFXUyBEYXRhU3luYyBpbiBhIFZpcnR1YWwgUHJpdmF0ZSBDbG91ZF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvZGF0YXN5bmMtaW4tdnBjLmh0bWwpIGluIHRoZSAqQVdTIERhdGFTeW5jIFVzZXIgR3VpZGUuKlxuICAgICAqXG4gICAgICogQSBWUEMgZW5kcG9pbnQgSUQgbG9va3MgbGlrZSB0aGlzOiBgdnBjZS0wMTIzNGQ1YWZmNjc4OTBlMWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtYWdlbnQuaHRtbCNjZm4tZGF0YXN5bmMtYWdlbnQtdnBjZW5kcG9pbnRpZFxuICAgICAqL1xuICAgIHB1YmxpYyB2cGNFbmRwb2ludElkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6RGF0YVN5bmM6OkFnZW50YC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5BZ2VudFByb3BzID0ge30pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbkFnZW50LkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICB0aGlzLmF0dHJBZ2VudEFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnQWdlbnRBcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0ckVuZHBvaW50VHlwZSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnRW5kcG9pbnRUeXBlJykpO1xuXG4gICAgICAgIHRoaXMuYWN0aXZhdGlvbktleSA9IHByb3BzLmFjdGl2YXRpb25LZXk7XG4gICAgICAgIHRoaXMuYWdlbnROYW1lID0gcHJvcHMuYWdlbnROYW1lO1xuICAgICAgICB0aGlzLnNlY3VyaXR5R3JvdXBBcm5zID0gcHJvcHMuc2VjdXJpdHlHcm91cEFybnM7XG4gICAgICAgIHRoaXMuc3VibmV0QXJucyA9IHByb3BzLnN1Ym5ldEFybnM7XG4gICAgICAgIHRoaXMudGFncyA9IG5ldyBjZGsuVGFnTWFuYWdlcihjZGsuVGFnVHlwZS5TVEFOREFSRCwgXCJBV1M6OkRhdGFTeW5jOjpBZ2VudFwiLCBwcm9wcy50YWdzLCB7IHRhZ1Byb3BlcnR5TmFtZTogJ3RhZ3MnIH0pO1xuICAgICAgICB0aGlzLnZwY0VuZHBvaW50SWQgPSBwcm9wcy52cGNFbmRwb2ludElkO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuQWdlbnQuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFjdGl2YXRpb25LZXk6IHRoaXMuYWN0aXZhdGlvbktleSxcbiAgICAgICAgICAgIGFnZW50TmFtZTogdGhpcy5hZ2VudE5hbWUsXG4gICAgICAgICAgICBzZWN1cml0eUdyb3VwQXJuczogdGhpcy5zZWN1cml0eUdyb3VwQXJucyxcbiAgICAgICAgICAgIHN1Ym5ldEFybnM6IHRoaXMuc3VibmV0QXJucyxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgICAgICB2cGNFbmRwb2ludElkOiB0aGlzLnZwY0VuZHBvaW50SWQsXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuQWdlbnRQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5Mb2NhdGlvbkVGU2BcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25lZnMuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkxvY2F0aW9uRUZTUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBzdWJuZXQgYW5kIHNlY3VyaXR5IGdyb3VwcyBEYXRhU3luYyB1c2VzIHRvIGFjY2VzcyB5b3VyIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmVmcy1lYzJjb25maWdcbiAgICAgKi9cbiAgICByZWFkb25seSBlYzJDb25maWc6IENmbkxvY2F0aW9uRUZTLkVjMkNvbmZpZ1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgYWNjZXNzIHBvaW50IHRoYXQgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgdGhlIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmVmcy1hY2Nlc3Nwb2ludGFyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFjY2Vzc1BvaW50QXJuPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBBUk4gZm9yIHRoZSBBbWF6b24gRUZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25lZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25lZnMtZWZzZmlsZXN5c3RlbWFyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVmc0ZpbGVzeXN0ZW1Bcm4/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYW4gQVdTIElkZW50aXR5IGFuZCBBY2Nlc3MgTWFuYWdlbWVudCAoSUFNKSByb2xlIHRoYXQgRGF0YVN5bmMgYXNzdW1lcyB3aGVuIG1vdW50aW5nIHRoZSBBbWF6b24gRUZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25lZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25lZnMtZmlsZXN5c3RlbWFjY2Vzc3JvbGVhcm5cbiAgICAgKi9cbiAgICByZWFkb25seSBmaWxlU3lzdGVtQWNjZXNzUm9sZUFybj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB3aGV0aGVyIHlvdSB3YW50IERhdGFTeW5jIHRvIHVzZSBUcmFuc3BvcnQgTGF5ZXIgU2VjdXJpdHkgKFRMUykgMS4yIGVuY3J5cHRpb24gd2hlbiBpdCBjb3BpZXMgZGF0YSB0byBvciBmcm9tIHRoZSBBbWF6b24gRUZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogSWYgeW91IHNwZWNpZnkgYW4gYWNjZXNzIHBvaW50IHVzaW5nIGBBY2Nlc3NQb2ludEFybmAgb3IgYW4gSUFNIHJvbGUgdXNpbmcgYEZpbGVTeXN0ZW1BY2Nlc3NSb2xlQXJuYCAsIHlvdSBtdXN0IHNldCB0aGlzIHBhcmFtZXRlciB0byBgVExTMV8yYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmVmcy1pbnRyYW5zaXRlbmNyeXB0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5UcmFuc2l0RW5jcnlwdGlvbj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBhIG1vdW50IHBhdGggZm9yIHlvdXIgQW1hem9uIEVGUyBmaWxlIHN5c3RlbS4gVGhpcyBpcyB3aGVyZSBEYXRhU3luYyByZWFkcyBvciB3cml0ZXMgZGF0YSAoZGVwZW5kaW5nIG9uIGlmIHRoaXMgaXMgYSBzb3VyY2Ugb3IgZGVzdGluYXRpb24gbG9jYXRpb24pLiBCeSBkZWZhdWx0LCBEYXRhU3luYyB1c2VzIHRoZSByb290IGRpcmVjdG9yeSwgYnV0IHlvdSBjYW4gYWxzbyBpbmNsdWRlIHN1YmRpcmVjdG9yaWVzLlxuICAgICAqXG4gICAgICogPiBZb3UgbXVzdCBzcGVjaWZ5IGEgdmFsdWUgd2l0aCBmb3J3YXJkIHNsYXNoZXMgKGZvciBleGFtcGxlLCBgL3BhdGgvdG8vZm9sZGVyYCApLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25lZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25lZnMtc3ViZGlyZWN0b3J5XG4gICAgICovXG4gICAgcmVhZG9ubHkgc3ViZGlyZWN0b3J5Pzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBrZXktdmFsdWUgcGFpciB0aGF0IHJlcHJlc2VudHMgYSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIHJlc291cmNlLiBUaGUgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IHN0cmluZy4gVGhpcyB2YWx1ZSBoZWxwcyB5b3UgbWFuYWdlLCBmaWx0ZXIsIGFuZCBzZWFyY2ggZm9yIHlvdXIgcmVzb3VyY2VzLiBXZSByZWNvbW1lbmQgdGhhdCB5b3UgY3JlYXRlIGEgbmFtZSB0YWcgZm9yIHlvdXIgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmVmcy10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IGNkay5DZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5Mb2NhdGlvbkVGU1Byb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvbkVGU1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uRUZTUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhY2Nlc3NQb2ludEFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hY2Nlc3NQb2ludEFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZWMyQ29uZmlnJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmVjMkNvbmZpZykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZWMyQ29uZmlnJywgQ2ZuTG9jYXRpb25FRlNfRWMyQ29uZmlnUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMuZWMyQ29uZmlnKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdlZnNGaWxlc3lzdGVtQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmVmc0ZpbGVzeXN0ZW1Bcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ZpbGVTeXN0ZW1BY2Nlc3NSb2xlQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmZpbGVTeXN0ZW1BY2Nlc3NSb2xlQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdpblRyYW5zaXRFbmNyeXB0aW9uJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmluVHJhbnNpdEVuY3J5cHRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N1YmRpcmVjdG9yeScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zdWJkaXJlY3RvcnkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuTG9jYXRpb25FRlNQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRUZTYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvbkVGU1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25FRlNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25FRlNQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25FRlNQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRWMyQ29uZmlnOiBjZm5Mb2NhdGlvbkVGU0VjMkNvbmZpZ1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmVjMkNvbmZpZyksXG4gICAgICAgIEFjY2Vzc1BvaW50QXJuOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmFjY2Vzc1BvaW50QXJuKSxcbiAgICAgICAgRWZzRmlsZXN5c3RlbUFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5lZnNGaWxlc3lzdGVtQXJuKSxcbiAgICAgICAgRmlsZVN5c3RlbUFjY2Vzc1JvbGVBcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZmlsZVN5c3RlbUFjY2Vzc1JvbGVBcm4pLFxuICAgICAgICBJblRyYW5zaXRFbmNyeXB0aW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmluVHJhbnNpdEVuY3J5cHRpb24pLFxuICAgICAgICBTdWJkaXJlY3Rvcnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uRUZTUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvbkVGU1Byb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbkVGU1Byb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZWMyQ29uZmlnJywgJ0VjMkNvbmZpZycsIENmbkxvY2F0aW9uRUZTRWMyQ29uZmlnUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5FYzJDb25maWcpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2FjY2Vzc1BvaW50QXJuJywgJ0FjY2Vzc1BvaW50QXJuJywgcHJvcGVydGllcy5BY2Nlc3NQb2ludEFybiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5BY2Nlc3NQb2ludEFybikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZWZzRmlsZXN5c3RlbUFybicsICdFZnNGaWxlc3lzdGVtQXJuJywgcHJvcGVydGllcy5FZnNGaWxlc3lzdGVtQXJuICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkVmc0ZpbGVzeXN0ZW1Bcm4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2ZpbGVTeXN0ZW1BY2Nlc3NSb2xlQXJuJywgJ0ZpbGVTeXN0ZW1BY2Nlc3NSb2xlQXJuJywgcHJvcGVydGllcy5GaWxlU3lzdGVtQWNjZXNzUm9sZUFybiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5GaWxlU3lzdGVtQWNjZXNzUm9sZUFybikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnaW5UcmFuc2l0RW5jcnlwdGlvbicsICdJblRyYW5zaXRFbmNyeXB0aW9uJywgcHJvcGVydGllcy5JblRyYW5zaXRFbmNyeXB0aW9uICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkluVHJhbnNpdEVuY3J5cHRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N1YmRpcmVjdG9yeScsICdTdWJkaXJlY3RvcnknLCBwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TdWJkaXJlY3RvcnkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRUZTYFxuICpcbiAqIFRoZSBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25FRlNgIHJlc291cmNlIGNyZWF0ZXMgYW4gZW5kcG9pbnQgZm9yIGFuIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0uIEFXUyBEYXRhU3luYyBjYW4gYWNjZXNzIHRoaXMgZW5kcG9pbnQgYXMgYSBzb3VyY2Ugb3IgZGVzdGluYXRpb24gbG9jYXRpb24uXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25FRlNcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5Mb2NhdGlvbkVGUyBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkVGU1wiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTG9jYXRpb25FRlMge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkxvY2F0aW9uRUZTUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkxvY2F0aW9uRUZTKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgQW1hem9uIEVGUyBmaWxlIHN5c3RlbS5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgTG9jYXRpb25Bcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxvY2F0aW9uQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgVVJJIG9mIHRoZSBBbWF6b24gRUZTIGZpbGUgc3lzdGVtLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBMb2NhdGlvblVyaVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTG9jYXRpb25Vcmk6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgc3VibmV0IGFuZCBzZWN1cml0eSBncm91cHMgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBBbWF6b24gRUZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25lZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25lZnMtZWMyY29uZmlnXG4gICAgICovXG4gICAgcHVibGljIGVjMkNvbmZpZzogQ2ZuTG9jYXRpb25FRlMuRWMyQ29uZmlnUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBhY2Nlc3MgcG9pbnQgdGhhdCBEYXRhU3luYyB1c2VzIHRvIGFjY2VzcyB0aGUgQW1hem9uIEVGUyBmaWxlIHN5c3RlbS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZWZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZWZzLWFjY2Vzc3BvaW50YXJuXG4gICAgICovXG4gICAgcHVibGljIGFjY2Vzc1BvaW50QXJuOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIEFSTiBmb3IgdGhlIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmVmcy1lZnNmaWxlc3lzdGVtYXJuXG4gICAgICovXG4gICAgcHVibGljIGVmc0ZpbGVzeXN0ZW1Bcm46IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBhbiBBV1MgSWRlbnRpdHkgYW5kIEFjY2VzcyBNYW5hZ2VtZW50IChJQU0pIHJvbGUgdGhhdCBEYXRhU3luYyBhc3N1bWVzIHdoZW4gbW91bnRpbmcgdGhlIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmVmcy1maWxlc3lzdGVtYWNjZXNzcm9sZWFyblxuICAgICAqL1xuICAgIHB1YmxpYyBmaWxlU3lzdGVtQWNjZXNzUm9sZUFybjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHdoZXRoZXIgeW91IHdhbnQgRGF0YVN5bmMgdG8gdXNlIFRyYW5zcG9ydCBMYXllciBTZWN1cml0eSAoVExTKSAxLjIgZW5jcnlwdGlvbiB3aGVuIGl0IGNvcGllcyBkYXRhIHRvIG9yIGZyb20gdGhlIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBJZiB5b3Ugc3BlY2lmeSBhbiBhY2Nlc3MgcG9pbnQgdXNpbmcgYEFjY2Vzc1BvaW50QXJuYCBvciBhbiBJQU0gcm9sZSB1c2luZyBgRmlsZVN5c3RlbUFjY2Vzc1JvbGVBcm5gICwgeW91IG11c3Qgc2V0IHRoaXMgcGFyYW1ldGVyIHRvIGBUTFMxXzJgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZWZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZWZzLWludHJhbnNpdGVuY3J5cHRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgaW5UcmFuc2l0RW5jcnlwdGlvbjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIGEgbW91bnQgcGF0aCBmb3IgeW91ciBBbWF6b24gRUZTIGZpbGUgc3lzdGVtLiBUaGlzIGlzIHdoZXJlIERhdGFTeW5jIHJlYWRzIG9yIHdyaXRlcyBkYXRhIChkZXBlbmRpbmcgb24gaWYgdGhpcyBpcyBhIHNvdXJjZSBvciBkZXN0aW5hdGlvbiBsb2NhdGlvbikuIEJ5IGRlZmF1bHQsIERhdGFTeW5jIHVzZXMgdGhlIHJvb3QgZGlyZWN0b3J5LCBidXQgeW91IGNhbiBhbHNvIGluY2x1ZGUgc3ViZGlyZWN0b3JpZXMuXG4gICAgICpcbiAgICAgKiA+IFlvdSBtdXN0IHNwZWNpZnkgYSB2YWx1ZSB3aXRoIGZvcndhcmQgc2xhc2hlcyAoZm9yIGV4YW1wbGUsIGAvcGF0aC90by9mb2xkZXJgICkuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmVmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmVmcy1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICBwdWJsaWMgc3ViZGlyZWN0b3J5OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIGtleS12YWx1ZSBwYWlyIHRoYXQgcmVwcmVzZW50cyBhIHRhZyB0aGF0IHlvdSB3YW50IHRvIGFkZCB0byB0aGUgcmVzb3VyY2UuIFRoZSB2YWx1ZSBjYW4gYmUgYW4gZW1wdHkgc3RyaW5nLiBUaGlzIHZhbHVlIGhlbHBzIHlvdSBtYW5hZ2UsIGZpbHRlciwgYW5kIHNlYXJjaCBmb3IgeW91ciByZXNvdXJjZXMuIFdlIHJlY29tbWVuZCB0aGF0IHlvdSBjcmVhdGUgYSBuYW1lIHRhZyBmb3IgeW91ciBsb2NhdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZWZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZWZzLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRUZTYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5Mb2NhdGlvbkVGU1Byb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5Mb2NhdGlvbkVGUy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ2VjMkNvbmZpZycsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvbkFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25Bcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0ckxvY2F0aW9uVXJpID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdMb2NhdGlvblVyaScpKTtcblxuICAgICAgICB0aGlzLmVjMkNvbmZpZyA9IHByb3BzLmVjMkNvbmZpZztcbiAgICAgICAgdGhpcy5hY2Nlc3NQb2ludEFybiA9IHByb3BzLmFjY2Vzc1BvaW50QXJuO1xuICAgICAgICB0aGlzLmVmc0ZpbGVzeXN0ZW1Bcm4gPSBwcm9wcy5lZnNGaWxlc3lzdGVtQXJuO1xuICAgICAgICB0aGlzLmZpbGVTeXN0ZW1BY2Nlc3NSb2xlQXJuID0gcHJvcHMuZmlsZVN5c3RlbUFjY2Vzc1JvbGVBcm47XG4gICAgICAgIHRoaXMuaW5UcmFuc2l0RW5jcnlwdGlvbiA9IHByb3BzLmluVHJhbnNpdEVuY3J5cHRpb247XG4gICAgICAgIHRoaXMuc3ViZGlyZWN0b3J5ID0gcHJvcHMuc3ViZGlyZWN0b3J5O1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25FRlNcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkxvY2F0aW9uRUZTLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBlYzJDb25maWc6IHRoaXMuZWMyQ29uZmlnLFxuICAgICAgICAgICAgYWNjZXNzUG9pbnRBcm46IHRoaXMuYWNjZXNzUG9pbnRBcm4sXG4gICAgICAgICAgICBlZnNGaWxlc3lzdGVtQXJuOiB0aGlzLmVmc0ZpbGVzeXN0ZW1Bcm4sXG4gICAgICAgICAgICBmaWxlU3lzdGVtQWNjZXNzUm9sZUFybjogdGhpcy5maWxlU3lzdGVtQWNjZXNzUm9sZUFybixcbiAgICAgICAgICAgIGluVHJhbnNpdEVuY3J5cHRpb246IHRoaXMuaW5UcmFuc2l0RW5jcnlwdGlvbixcbiAgICAgICAgICAgIHN1YmRpcmVjdG9yeTogdGhpcy5zdWJkaXJlY3RvcnksXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkxvY2F0aW9uRUZTUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuTG9jYXRpb25FRlMge1xuICAgIC8qKlxuICAgICAqIFRoZSBzdWJuZXQgYW5kIHNlY3VyaXR5IGdyb3VwcyB0aGF0IEFXUyBEYXRhU3luYyB1c2VzIHRvIGFjY2VzcyB5b3VyIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmVmcy1lYzJjb25maWcuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgRWMyQ29uZmlnUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogU3BlY2lmaWVzIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZXMgKEFSTnMpIG9mIHRoZSBzZWN1cml0eSBncm91cHMgYXNzb2NpYXRlZCB3aXRoIGFuIEFtYXpvbiBFRlMgZmlsZSBzeXN0ZW0ncyBtb3VudCB0YXJnZXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25lZnMtZWMyY29uZmlnLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZWZzLWVjMmNvbmZpZy1zZWN1cml0eWdyb3VwYXJuc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgc2VjdXJpdHlHcm91cEFybnM6IHN0cmluZ1tdO1xuICAgICAgICAvKipcbiAgICAgICAgICogU3BlY2lmaWVzIHRoZSBBUk4gb2YgYSBzdWJuZXQgd2hlcmUgRGF0YVN5bmMgY3JlYXRlcyB0aGUgW25ldHdvcmsgaW50ZXJmYWNlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvZGF0YXN5bmMtbmV0d29yay5odG1sI3JlcXVpcmVkLW5ldHdvcmstaW50ZXJmYWNlcykgZm9yIG1hbmFnaW5nIHRyYWZmaWMgZHVyaW5nIHlvdXIgdHJhbnNmZXIuXG4gICAgICAgICAqXG4gICAgICAgICAqIFRoZSBzdWJuZXQgbXVzdCBiZSBsb2NhdGVkOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIEluIHRoZSBzYW1lIHZpcnR1YWwgcHJpdmF0ZSBjbG91ZCAoVlBDKSBhcyB0aGUgQW1hem9uIEVGUyBmaWxlIHN5c3RlbS5cbiAgICAgICAgICogLSBJbiB0aGUgc2FtZSBBdmFpbGFiaWxpdHkgWm9uZSBhcyBhdCBsZWFzdCBvbmUgbW91bnQgdGFyZ2V0IGZvciB0aGUgQW1hem9uIEVGUyBmaWxlIHN5c3RlbS5cbiAgICAgICAgICpcbiAgICAgICAgICogPiBZb3UgZG9uJ3QgbmVlZCB0byBzcGVjaWZ5IGEgc3VibmV0IHRoYXQgaW5jbHVkZXMgYSBmaWxlIHN5c3RlbSBtb3VudCB0YXJnZXQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25lZnMtZWMyY29uZmlnLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZWZzLWVjMmNvbmZpZy1zdWJuZXRhcm5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHN1Ym5ldEFybjogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBFYzJDb25maWdQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRWMyQ29uZmlnUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25FRlNfRWMyQ29uZmlnUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwQXJucycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zZWN1cml0eUdyb3VwQXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlHcm91cEFybnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJuZXRBcm4nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuc3VibmV0QXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJuZXRBcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3VibmV0QXJuKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkVjMkNvbmZpZ1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25FRlMuRWMyQ29uZmlnYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBFYzJDb25maWdQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRUZTLkVjMkNvbmZpZ2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Mb2NhdGlvbkVGU0VjMkNvbmZpZ1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Mb2NhdGlvbkVGU19FYzJDb25maWdQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgU2VjdXJpdHlHcm91cEFybnM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBBcm5zKSxcbiAgICAgICAgU3VibmV0QXJuOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnN1Ym5ldEFybiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uRUZTRWMyQ29uZmlnUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvbkVGUy5FYzJDb25maWdQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbkVGUy5FYzJDb25maWdQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NlY3VyaXR5R3JvdXBBcm5zJywgJ1NlY3VyaXR5R3JvdXBBcm5zJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLlNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzdWJuZXRBcm4nLCAnU3VibmV0QXJuJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TdWJuZXRBcm4pKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5Mb2NhdGlvbkZTeEx1c3RyZWBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hsdXN0cmUuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkxvY2F0aW9uRlN4THVzdHJlUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFSTnMgb2YgdGhlIHNlY3VyaXR5IGdyb3VwcyB0aGF0IGFyZSB1c2VkIHRvIGNvbmZpZ3VyZSB0aGUgRlN4IGZvciBMdXN0cmUgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiAqUGF0dGVybiogOiBgXmFybjooYXdzfGF3cy1jbnxhd3MtdXMtZ292fGF3cy1pc298YXdzLWlzby1iKTplYzI6W2EtelxcLTAtOV0qOlswLTldezEyfTpzZWN1cml0eS1ncm91cC8uKiRgXG4gICAgICpcbiAgICAgKiAqTGVuZ3RoIGNvbnN0cmFpbnRzKiA6IE1heGltdW0gbGVuZ3RoIG9mIDEyOC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4bHVzdHJlLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4bHVzdHJlLXNlY3VyaXR5Z3JvdXBhcm5zXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VjdXJpdHlHcm91cEFybnM6IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIGZvciB0aGUgRlN4IGZvciBMdXN0cmUgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS1mc3hmaWxlc3lzdGVtYXJuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZnN4RmlsZXN5c3RlbUFybj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgc3ViZGlyZWN0b3J5IGluIHRoZSBsb2NhdGlvbidzIHBhdGguIFRoaXMgc3ViZGlyZWN0b3J5IGluIHRoZSBGU3ggZm9yIEx1c3RyZSBmaWxlIHN5c3RlbSBpcyB1c2VkIHRvIHJlYWQgZGF0YSBmcm9tIHRoZSBGU3ggZm9yIEx1c3RyZSBzb3VyY2UgbG9jYXRpb24gb3Igd3JpdGUgZGF0YSB0byB0aGUgRlN4IGZvciBMdXN0cmUgZGVzdGluYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICByZWFkb25seSBzdWJkaXJlY3Rvcnk/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUga2V5LXZhbHVlIHBhaXIgdGhhdCByZXByZXNlbnRzIGEgdGFnIHRoYXQgeW91IHdhbnQgdG8gYWRkIHRvIHRoZSByZXNvdXJjZS4gVGhlIHZhbHVlIGNhbiBiZSBhbiBlbXB0eSBzdHJpbmcuIFRoaXMgdmFsdWUgaGVscHMgeW91IG1hbmFnZSwgZmlsdGVyLCBhbmQgc2VhcmNoIGZvciB5b3VyIHJlc291cmNlcy4gV2UgcmVjb21tZW5kIHRoYXQgeW91IGNyZWF0ZSBhIG5hbWUgdGFnIGZvciB5b3VyIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hsdXN0cmUuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hsdXN0cmUtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuTG9jYXRpb25GU3hMdXN0cmVQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTG9jYXRpb25GU3hMdXN0cmVQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Mb2NhdGlvbkZTeEx1c3RyZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZnN4RmlsZXN5c3RlbUFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5mc3hGaWxlc3lzdGVtQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwQXJucycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zZWN1cml0eUdyb3VwQXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlHcm91cEFybnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJkaXJlY3RvcnknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkxvY2F0aW9uRlN4THVzdHJlUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeEx1c3RyZWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTG9jYXRpb25GU3hMdXN0cmVQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4THVzdHJlYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uRlN4THVzdHJlUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkxvY2F0aW9uRlN4THVzdHJlUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIFNlY3VyaXR5R3JvdXBBcm5zOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5zZWN1cml0eUdyb3VwQXJucyksXG4gICAgICAgIEZzeEZpbGVzeXN0ZW1Bcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZnN4RmlsZXN5c3RlbUFybiksXG4gICAgICAgIFN1YmRpcmVjdG9yeTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zdWJkaXJlY3RvcnkpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hMdXN0cmVQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxvY2F0aW9uRlN4THVzdHJlUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uRlN4THVzdHJlUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZWN1cml0eUdyb3VwQXJucycsICdTZWN1cml0eUdyb3VwQXJucycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5TZWN1cml0eUdyb3VwQXJucykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZnN4RmlsZXN5c3RlbUFybicsICdGc3hGaWxlc3lzdGVtQXJuJywgcHJvcGVydGllcy5Gc3hGaWxlc3lzdGVtQXJuICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkZzeEZpbGVzeXN0ZW1Bcm4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N1YmRpcmVjdG9yeScsICdTdWJkaXJlY3RvcnknLCBwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TdWJkaXJlY3RvcnkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4THVzdHJlYFxuICpcbiAqIFRoZSBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hMdXN0cmVgIHJlc291cmNlIHNwZWNpZmllcyBhbiBlbmRwb2ludCBmb3IgYW4gQW1hem9uIEZTeCBmb3IgTHVzdHJlIGZpbGUgc3lzdGVtLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4THVzdHJlXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hsdXN0cmUuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuTG9jYXRpb25GU3hMdXN0cmUgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hMdXN0cmVcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkxvY2F0aW9uRlN4THVzdHJlIHtcbiAgICAgICAgcmVzb3VyY2VBdHRyaWJ1dGVzID0gcmVzb3VyY2VBdHRyaWJ1dGVzIHx8IHt9O1xuICAgICAgICBjb25zdCByZXNvdXJjZVByb3BlcnRpZXMgPSBvcHRpb25zLnBhcnNlci5wYXJzZVZhbHVlKHJlc291cmNlQXR0cmlidXRlcy5Qcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcHJvcHNSZXN1bHQgPSBDZm5Mb2NhdGlvbkZTeEx1c3RyZVByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5Mb2NhdGlvbkZTeEx1c3RyZShzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQVJOIG9mIHRoZSBzcGVjaWZpZWQgRlN4IGZvciBMdXN0cmUgZmlsZSBzeXN0ZW0gbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvbkFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIFVSSSBvZiB0aGUgc3BlY2lmaWVkIEZTeCBmb3IgTHVzdHJlIGZpbGUgc3lzdGVtIGxvY2F0aW9uLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBMb2NhdGlvblVyaVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTG9jYXRpb25Vcmk6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBBUk5zIG9mIHRoZSBzZWN1cml0eSBncm91cHMgdGhhdCBhcmUgdXNlZCB0byBjb25maWd1cmUgdGhlIEZTeCBmb3IgTHVzdHJlIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogKlBhdHRlcm4qIDogYF5hcm46KGF3c3xhd3MtY258YXdzLXVzLWdvdnxhd3MtaXNvfGF3cy1pc28tYik6ZWMyOlthLXpcXC0wLTldKjpbMC05XXsxMn06c2VjdXJpdHktZ3JvdXAvLiokYFxuICAgICAqXG4gICAgICogKkxlbmd0aCBjb25zdHJhaW50cyogOiBNYXhpbXVtIGxlbmd0aCBvZiAxMjguXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS1zZWN1cml0eWdyb3VwYXJuc1xuICAgICAqL1xuICAgIHB1YmxpYyBzZWN1cml0eUdyb3VwQXJuczogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgZm9yIHRoZSBGU3ggZm9yIEx1c3RyZSBmaWxlIHN5c3RlbS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4bHVzdHJlLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4bHVzdHJlLWZzeGZpbGVzeXN0ZW1hcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgZnN4RmlsZXN5c3RlbUFybjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBzdWJkaXJlY3RvcnkgaW4gdGhlIGxvY2F0aW9uJ3MgcGF0aC4gVGhpcyBzdWJkaXJlY3RvcnkgaW4gdGhlIEZTeCBmb3IgTHVzdHJlIGZpbGUgc3lzdGVtIGlzIHVzZWQgdG8gcmVhZCBkYXRhIGZyb20gdGhlIEZTeCBmb3IgTHVzdHJlIHNvdXJjZSBsb2NhdGlvbiBvciB3cml0ZSBkYXRhIHRvIHRoZSBGU3ggZm9yIEx1c3RyZSBkZXN0aW5hdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4bHVzdHJlLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4bHVzdHJlLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHB1YmxpYyBzdWJkaXJlY3Rvcnk6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBrZXktdmFsdWUgcGFpciB0aGF0IHJlcHJlc2VudHMgYSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIHJlc291cmNlLiBUaGUgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IHN0cmluZy4gVGhpcyB2YWx1ZSBoZWxwcyB5b3UgbWFuYWdlLCBmaWx0ZXIsIGFuZCBzZWFyY2ggZm9yIHlvdXIgcmVzb3VyY2VzLiBXZSByZWNvbW1lbmQgdGhhdCB5b3UgY3JlYXRlIGEgbmFtZSB0YWcgZm9yIHlvdXIgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeGx1c3RyZS10YWdzXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHRhZ3M6IGNkay5UYWdNYW5hZ2VyO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeEx1c3RyZWAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuTG9jYXRpb25GU3hMdXN0cmVQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuTG9jYXRpb25GU3hMdXN0cmUuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdzZWN1cml0eUdyb3VwQXJucycsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvbkFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25Bcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0ckxvY2F0aW9uVXJpID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdMb2NhdGlvblVyaScpKTtcblxuICAgICAgICB0aGlzLnNlY3VyaXR5R3JvdXBBcm5zID0gcHJvcHMuc2VjdXJpdHlHcm91cEFybnM7XG4gICAgICAgIHRoaXMuZnN4RmlsZXN5c3RlbUFybiA9IHByb3BzLmZzeEZpbGVzeXN0ZW1Bcm47XG4gICAgICAgIHRoaXMuc3ViZGlyZWN0b3J5ID0gcHJvcHMuc3ViZGlyZWN0b3J5O1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hMdXN0cmVcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkxvY2F0aW9uRlN4THVzdHJlLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBzZWN1cml0eUdyb3VwQXJuczogdGhpcy5zZWN1cml0eUdyb3VwQXJucyxcbiAgICAgICAgICAgIGZzeEZpbGVzeXN0ZW1Bcm46IHRoaXMuZnN4RmlsZXN5c3RlbUFybixcbiAgICAgICAgICAgIHN1YmRpcmVjdG9yeTogdGhpcy5zdWJkaXJlY3RvcnksXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkxvY2F0aW9uRlN4THVzdHJlUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuTG9jYXRpb25GU3hPTlRBUGBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuTG9jYXRpb25GU3hPTlRBUFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgQW1hem9uIFJlc291cmNlIE5hbWVzIChBUk5zKSBvZiB0aGUgc2VjdXJpdHkgZ3JvdXBzIHRoYXQgRGF0YVN5bmMgY2FuIHVzZSB0byBhY2Nlc3MgeW91ciBGU3ggZm9yIE9OVEFQIGZpbGUgc3lzdGVtLiBZb3UgbXVzdCBjb25maWd1cmUgdGhlIHNlY3VyaXR5IGdyb3VwcyB0byBhbGxvdyBvdXRib3VuZCB0cmFmZmljIG9uIHRoZSBmb2xsb3dpbmcgcG9ydHMgKGRlcGVuZGluZyBvbiB0aGUgcHJvdG9jb2wgdGhhdCB5b3UncmUgdXNpbmcpOlxuICAgICAqXG4gICAgICogLSAqTmV0d29yayBGaWxlIFN5c3RlbSAoTkZTKSogOiBUQ1AgcG9ydHMgMTExLCA2MzUsIGFuZCAyMDQ5XG4gICAgICogLSAqU2VydmVyIE1lc3NhZ2UgQmxvY2sgKFNNQikqIDogVENQIHBvcnQgNDQ1XG4gICAgICpcbiAgICAgKiBZb3VyIGZpbGUgc3lzdGVtJ3Mgc2VjdXJpdHkgZ3JvdXBzIG11c3QgYWxzbyBhbGxvdyBpbmJvdW5kIHRyYWZmaWMgb24gdGhlIHNhbWUgcG9ydC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1zZWN1cml0eWdyb3VwYXJuc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBBcm5zOiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgQVJOIG9mIHRoZSBzdG9yYWdlIHZpcnR1YWwgbWFjaGluZSAoU1ZNKSBpbiB5b3VyIGZpbGUgc3lzdGVtIHdoZXJlIHlvdSB3YW50IHRvIGNvcHkgZGF0YSB0byBvciBmcm9tLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXN0b3JhZ2V2aXJ0dWFsbWFjaGluZWFyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBkYXRhIHRyYW5zZmVyIHByb3RvY29sIHRoYXQgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBBbWF6b24gRlN4IGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXByb3RvY29sXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJvdG9jb2w/OiBDZm5Mb2NhdGlvbkZTeE9OVEFQLlByb3RvY29sUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBwYXRoIHRvIHRoZSBmaWxlIHNoYXJlIGluIHRoZSBTVk0gd2hlcmUgeW91J2xsIGNvcHkgeW91ciBkYXRhLlxuICAgICAqXG4gICAgICogWW91IGNhbiBzcGVjaWZ5IGEganVuY3Rpb24gcGF0aCAoYWxzbyBrbm93biBhcyBhIG1vdW50IHBvaW50KSwgcXRyZWUgcGF0aCAoZm9yIE5GUyBmaWxlIHNoYXJlcyksIG9yIHNoYXJlIG5hbWUgKGZvciBTTUIgZmlsZSBzaGFyZXMpLiBGb3IgZXhhbXBsZSwgeW91ciBtb3VudCBwYXRoIG1pZ2h0IGJlIGAvdm9sMWAgLCBgL3ZvbDEvdHJlZTFgICwgb3IgYC9zaGFyZTFgIC5cbiAgICAgKlxuICAgICAqID4gRG9uJ3Qgc3BlY2lmeSBhIGp1bmN0aW9uIHBhdGggaW4gdGhlIFNWTSdzIHJvb3Qgdm9sdW1lLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtNYW5hZ2luZyBGU3ggZm9yIE9OVEFQIHN0b3JhZ2UgdmlydHVhbCBtYWNoaW5lc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ZzeC9sYXRlc3QvT05UQVBHdWlkZS9tYW5hZ2luZy1zdm1zLmh0bWwpIGluIHRoZSAqQW1hem9uIEZTeCBmb3IgTmV0QXBwIE9OVEFQIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICByZWFkb25seSBzdWJkaXJlY3Rvcnk/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgbGFiZWxzIHRoYXQgaGVscCB5b3UgY2F0ZWdvcml6ZSwgZmlsdGVyLCBhbmQgc2VhcmNoIGZvciB5b3VyIEFXUyByZXNvdXJjZXMuIFdlIHJlY29tbWVuZCBjcmVhdGluZyBhdCBsZWFzdCBhIG5hbWUgdGFnIGZvciB5b3VyIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbkxvY2F0aW9uRlN4T05UQVBQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTG9jYXRpb25GU3hPTlRBUFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T05UQVBQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Byb3RvY29sJywgQ2ZuTG9jYXRpb25GU3hPTlRBUF9Qcm90b2NvbFByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnByb3RvY29sKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwQXJucycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zZWN1cml0eUdyb3VwQXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlHcm91cEFybnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdG9yYWdlVmlydHVhbE1hY2hpbmVBcm4nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuc3RvcmFnZVZpcnR1YWxNYWNoaW5lQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdG9yYWdlVmlydHVhbE1hY2hpbmVBcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3RvcmFnZVZpcnR1YWxNYWNoaW5lQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJkaXJlY3RvcnknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkxvY2F0aW9uRlN4T05UQVBQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVBgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkxvY2F0aW9uRlN4T05UQVBQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVBgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25GU3hPTlRBUFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Mb2NhdGlvbkZTeE9OVEFQUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIFNlY3VyaXR5R3JvdXBBcm5zOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5zZWN1cml0eUdyb3VwQXJucyksXG4gICAgICAgIFN0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zdG9yYWdlVmlydHVhbE1hY2hpbmVBcm4pLFxuICAgICAgICBQcm90b2NvbDogY2ZuTG9jYXRpb25GU3hPTlRBUFByb3RvY29sUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJvdG9jb2wpLFxuICAgICAgICBTdWJkaXJlY3Rvcnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T05UQVBQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxvY2F0aW9uRlN4T05UQVBQcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuTG9jYXRpb25GU3hPTlRBUFByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2VjdXJpdHlHcm91cEFybnMnLCAnU2VjdXJpdHlHcm91cEFybnMnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuU2VjdXJpdHlHcm91cEFybnMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybicsICdTdG9yYWdlVmlydHVhbE1hY2hpbmVBcm4nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlN0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybikpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncHJvdG9jb2wnLCAnUHJvdG9jb2wnLCBwcm9wZXJ0aWVzLlByb3RvY29sICE9IG51bGwgPyBDZm5Mb2NhdGlvbkZTeE9OVEFQUHJvdG9jb2xQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlByb3RvY29sKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzdWJkaXJlY3RvcnknLCAnU3ViZGlyZWN0b3J5JywgcHJvcGVydGllcy5TdWJkaXJlY3RvcnkgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU3ViZGlyZWN0b3J5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRDZm5UYWcpKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeE9OVEFQYFxuICpcbiAqIFRoZSBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPTlRBUGAgcmVzb3VyY2UgY3JlYXRlcyBhbiBlbmRwb2ludCBmb3IgYW4gQW1hem9uIEZTeCBmb3IgTmV0QXBwIE9OVEFQIGZpbGUgc3lzdGVtLiBBV1MgRGF0YVN5bmMgY2FuIGFjY2VzcyB0aGlzIGVuZHBvaW50IGFzIGEgc291cmNlIG9yIGRlc3RpbmF0aW9uIGxvY2F0aW9uLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVBcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkxvY2F0aW9uRlN4T05UQVAgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPTlRBUFwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTG9jYXRpb25GU3hPTlRBUCB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTG9jYXRpb25GU3hPTlRBUFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5Mb2NhdGlvbkZTeE9OVEFQKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBBUk4gb2YgdGhlIEZTeCBmb3IgT05UQVAgZmlsZSBzeXN0ZW0gaW4gdGhlIHNwZWNpZmllZCBsb2NhdGlvbi5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgRnN4RmlsZXN5c3RlbUFyblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRnN4RmlsZXN5c3RlbUFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFSTiBvZiB0aGUgc3BlY2lmaWVkIGxvY2F0aW9uLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBMb2NhdGlvbkFyblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTG9jYXRpb25Bcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBVUkkgb2YgdGhlIHNwZWNpZmllZCBsb2NhdGlvbi5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgTG9jYXRpb25VcmlcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxvY2F0aW9uVXJpOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOcykgb2YgdGhlIHNlY3VyaXR5IGdyb3VwcyB0aGF0IERhdGFTeW5jIGNhbiB1c2UgdG8gYWNjZXNzIHlvdXIgRlN4IGZvciBPTlRBUCBmaWxlIHN5c3RlbS4gWW91IG11c3QgY29uZmlndXJlIHRoZSBzZWN1cml0eSBncm91cHMgdG8gYWxsb3cgb3V0Ym91bmQgdHJhZmZpYyBvbiB0aGUgZm9sbG93aW5nIHBvcnRzIChkZXBlbmRpbmcgb24gdGhlIHByb3RvY29sIHRoYXQgeW91J3JlIHVzaW5nKTpcbiAgICAgKlxuICAgICAqIC0gKk5ldHdvcmsgRmlsZSBTeXN0ZW0gKE5GUykqIDogVENQIHBvcnRzIDExMSwgNjM1LCBhbmQgMjA0OVxuICAgICAqIC0gKlNlcnZlciBNZXNzYWdlIEJsb2NrIChTTUIpKiA6IFRDUCBwb3J0IDQ0NVxuICAgICAqXG4gICAgICogWW91ciBmaWxlIHN5c3RlbSdzIHNlY3VyaXR5IGdyb3VwcyBtdXN0IGFsc28gYWxsb3cgaW5ib3VuZCB0cmFmZmljIG9uIHRoZSBzYW1lIHBvcnQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc2VjdXJpdHlncm91cGFybnNcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VjdXJpdHlHcm91cEFybnM6IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBBUk4gb2YgdGhlIHN0b3JhZ2UgdmlydHVhbCBtYWNoaW5lIChTVk0pIGluIHlvdXIgZmlsZSBzeXN0ZW0gd2hlcmUgeW91IHdhbnQgdG8gY29weSBkYXRhIHRvIG9yIGZyb20uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc3RvcmFnZXZpcnR1YWxtYWNoaW5lYXJuXG4gICAgICovXG4gICAgcHVibGljIHN0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBkYXRhIHRyYW5zZmVyIHByb3RvY29sIHRoYXQgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBBbWF6b24gRlN4IGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXByb3RvY29sXG4gICAgICovXG4gICAgcHVibGljIHByb3RvY29sOiBDZm5Mb2NhdGlvbkZTeE9OVEFQLlByb3RvY29sUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBwYXRoIHRvIHRoZSBmaWxlIHNoYXJlIGluIHRoZSBTVk0gd2hlcmUgeW91J2xsIGNvcHkgeW91ciBkYXRhLlxuICAgICAqXG4gICAgICogWW91IGNhbiBzcGVjaWZ5IGEganVuY3Rpb24gcGF0aCAoYWxzbyBrbm93biBhcyBhIG1vdW50IHBvaW50KSwgcXRyZWUgcGF0aCAoZm9yIE5GUyBmaWxlIHNoYXJlcyksIG9yIHNoYXJlIG5hbWUgKGZvciBTTUIgZmlsZSBzaGFyZXMpLiBGb3IgZXhhbXBsZSwgeW91ciBtb3VudCBwYXRoIG1pZ2h0IGJlIGAvdm9sMWAgLCBgL3ZvbDEvdHJlZTFgICwgb3IgYC9zaGFyZTFgIC5cbiAgICAgKlxuICAgICAqID4gRG9uJ3Qgc3BlY2lmeSBhIGp1bmN0aW9uIHBhdGggaW4gdGhlIFNWTSdzIHJvb3Qgdm9sdW1lLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtNYW5hZ2luZyBGU3ggZm9yIE9OVEFQIHN0b3JhZ2UgdmlydHVhbCBtYWNoaW5lc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ZzeC9sYXRlc3QvT05UQVBHdWlkZS9tYW5hZ2luZy1zdm1zLmh0bWwpIGluIHRoZSAqQW1hem9uIEZTeCBmb3IgTmV0QXBwIE9OVEFQIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICBwdWJsaWMgc3ViZGlyZWN0b3J5OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgbGFiZWxzIHRoYXQgaGVscCB5b3UgY2F0ZWdvcml6ZSwgZmlsdGVyLCBhbmQgc2VhcmNoIGZvciB5b3VyIEFXUyByZXNvdXJjZXMuIFdlIHJlY29tbWVuZCBjcmVhdGluZyBhdCBsZWFzdCBhIG5hbWUgdGFnIGZvciB5b3VyIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVBgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkxvY2F0aW9uRlN4T05UQVBQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuTG9jYXRpb25GU3hPTlRBUC5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3NlY3VyaXR5R3JvdXBBcm5zJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdzdG9yYWdlVmlydHVhbE1hY2hpbmVBcm4nLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyRnN4RmlsZXN5c3RlbUFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnRnN4RmlsZXN5c3RlbUFybicpKTtcbiAgICAgICAgdGhpcy5hdHRyTG9jYXRpb25Bcm4gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0xvY2F0aW9uQXJuJykpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvblVyaSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25VcmknKSk7XG5cbiAgICAgICAgdGhpcy5zZWN1cml0eUdyb3VwQXJucyA9IHByb3BzLnNlY3VyaXR5R3JvdXBBcm5zO1xuICAgICAgICB0aGlzLnN0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybiA9IHByb3BzLnN0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybjtcbiAgICAgICAgdGhpcy5wcm90b2NvbCA9IHByb3BzLnByb3RvY29sO1xuICAgICAgICB0aGlzLnN1YmRpcmVjdG9yeSA9IHByb3BzLnN1YmRpcmVjdG9yeTtcbiAgICAgICAgdGhpcy50YWdzID0gbmV3IGNkay5UYWdNYW5hZ2VyKGNkay5UYWdUeXBlLlNUQU5EQVJELCBcIkFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVBcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkxvY2F0aW9uRlN4T05UQVAuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHNlY3VyaXR5R3JvdXBBcm5zOiB0aGlzLnNlY3VyaXR5R3JvdXBBcm5zLFxuICAgICAgICAgICAgc3RvcmFnZVZpcnR1YWxNYWNoaW5lQXJuOiB0aGlzLnN0b3JhZ2VWaXJ0dWFsTWFjaGluZUFybixcbiAgICAgICAgICAgIHByb3RvY29sOiB0aGlzLnByb3RvY29sLFxuICAgICAgICAgICAgc3ViZGlyZWN0b3J5OiB0aGlzLnN1YmRpcmVjdG9yeSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuTG9jYXRpb25GU3hPTlRBUFByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkxvY2F0aW9uRlN4T05UQVAge1xuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgTmV0d29yayBGaWxlIFN5c3RlbSAoTkZTKSBwcm90b2NvbCBjb25maWd1cmF0aW9uIHRoYXQgQVdTIERhdGFTeW5jIHVzZXMgdG8gYWNjZXNzIGEgc3RvcmFnZSB2aXJ0dWFsIG1hY2hpbmUgKFNWTSkgb24geW91ciBBbWF6b24gRlN4IGZvciBOZXRBcHAgT05UQVAgZmlsZSBzeXN0ZW0uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0FjY2Vzc2luZyBGU3ggZm9yIE9OVEFQIGZpbGUgc3lzdGVtc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLW9udGFwLWxvY2F0aW9uLmh0bWwjY3JlYXRlLW9udGFwLWxvY2F0aW9uLWFjY2VzcykgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1uZnMuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgTkZTUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogU3BlY2lmaWVzIGhvdyBEYXRhU3luYyBjYW4gYWNjZXNzIGEgbG9jYXRpb24gdXNpbmcgdGhlIE5GUyBwcm90b2NvbC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLW5mcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLW5mcy1tb3VudG9wdGlvbnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1vdW50T3B0aW9uczogQ2ZuTG9jYXRpb25GU3hPTlRBUC5OZnNNb3VudE9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTkZTUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE5GU1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T05UQVBfTkZTUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtb3VudE9wdGlvbnMnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubW91bnRPcHRpb25zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtb3VudE9wdGlvbnMnLCBDZm5Mb2NhdGlvbkZTeE9OVEFQX05mc01vdW50T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1vdW50T3B0aW9ucykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJORlNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVAuTkZTYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBORlNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVAuTkZTYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uRlN4T05UQVBORlNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25GU3hPTlRBUF9ORlNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTW91bnRPcHRpb25zOiBjZm5Mb2NhdGlvbkZTeE9OVEFQTmZzTW91bnRPcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubW91bnRPcHRpb25zKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPTlRBUE5GU1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25GU3hPTlRBUC5ORlNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbkZTeE9OVEFQLk5GU1Byb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbW91bnRPcHRpb25zJywgJ01vdW50T3B0aW9ucycsIENmbkxvY2F0aW9uRlN4T05UQVBOZnNNb3VudE9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk1vdW50T3B0aW9ucykpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkxvY2F0aW9uRlN4T05UQVAge1xuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBob3cgRGF0YVN5bmMgY2FuIGFjY2VzcyBhIGxvY2F0aW9uIHVzaW5nIHRoZSBORlMgcHJvdG9jb2wuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLW5mc21vdW50b3B0aW9ucy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBOZnNNb3VudE9wdGlvbnNQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBTcGVjaWZpZXMgdGhlIE5GUyB2ZXJzaW9uIHRoYXQgeW91IHdhbnQgRGF0YVN5bmMgdG8gdXNlIHdoZW4gbW91bnRpbmcgeW91ciBORlMgc2hhcmUuIElmIHRoZSBzZXJ2ZXIgcmVmdXNlcyB0byB1c2UgdGhlIHZlcnNpb24gc3BlY2lmaWVkLCB0aGUgdGFzayBmYWlscy5cbiAgICAgICAgICpcbiAgICAgICAgICogWW91IGNhbiBzcGVjaWZ5IHRoZSBmb2xsb3dpbmcgb3B0aW9uczpcbiAgICAgICAgICpcbiAgICAgICAgICogLSBgQVVUT01BVElDYCAoZGVmYXVsdCk6IERhdGFTeW5jIGNob29zZXMgTkZTIHZlcnNpb24gNC4xLlxuICAgICAgICAgKiAtIGBORlMzYCA6IFN0YXRlbGVzcyBwcm90b2NvbCB2ZXJzaW9uIHRoYXQgYWxsb3dzIGZvciBhc3luY2hyb25vdXMgd3JpdGVzIG9uIHRoZSBzZXJ2ZXIuXG4gICAgICAgICAqIC0gYE5GU3Y0XzBgIDogU3RhdGVmdWwsIGZpcmV3YWxsLWZyaWVuZGx5IHByb3RvY29sIHZlcnNpb24gdGhhdCBzdXBwb3J0cyBkZWxlZ2F0aW9ucyBhbmQgcHNldWRvIGZpbGUgc3lzdGVtcy5cbiAgICAgICAgICogLSBgTkZTdjRfMWAgOiBTdGF0ZWZ1bCBwcm90b2NvbCB2ZXJzaW9uIHRoYXQgc3VwcG9ydHMgc2Vzc2lvbnMsIGRpcmVjdG9yeSBkZWxlZ2F0aW9ucywgYW5kIHBhcmFsbGVsIGRhdGEgcHJvY2Vzc2luZy4gTkZTIHZlcnNpb24gNC4xIGFsc28gaW5jbHVkZXMgYWxsIGZlYXR1cmVzIGF2YWlsYWJsZSBpbiB2ZXJzaW9uIDQuMC5cbiAgICAgICAgICpcbiAgICAgICAgICogPiBEYXRhU3luYyBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBORlMgdmVyc2lvbiAzIHdpdGggQW1hem9uIEZTeCBmb3IgTmV0QXBwIE9OVEFQIGxvY2F0aW9ucy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLW5mc21vdW50b3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLW5mc21vdW50b3B0aW9ucy12ZXJzaW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB2ZXJzaW9uPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBOZnNNb3VudE9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTmZzTW91bnRPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPTlRBUF9OZnNNb3VudE9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZlcnNpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudmVyc2lvbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJOZnNNb3VudE9wdGlvbnNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVAuTmZzTW91bnRPcHRpb25zYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBOZnNNb3VudE9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVAuTmZzTW91bnRPcHRpb25zYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uRlN4T05UQVBOZnNNb3VudE9wdGlvbnNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25GU3hPTlRBUF9OZnNNb3VudE9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgVmVyc2lvbjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy52ZXJzaW9uKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPTlRBUE5mc01vdW50T3B0aW9uc1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25GU3hPTlRBUC5OZnNNb3VudE9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbkZTeE9OVEFQLk5mc01vdW50T3B0aW9uc1Byb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndmVyc2lvbicsICdWZXJzaW9uJywgcHJvcGVydGllcy5WZXJzaW9uICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZlcnNpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Mb2NhdGlvbkZTeE9OVEFQIHtcbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIGRhdGEgdHJhbnNmZXIgcHJvdG9jb2wgdGhhdCBBV1MgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBBbWF6b24gRlN4IGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1wcm90b2NvbC5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBQcm90b2NvbFByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNwZWNpZmllcyB0aGUgTmV0d29yayBGaWxlIFN5c3RlbSAoTkZTKSBwcm90b2NvbCBjb25maWd1cmF0aW9uIHRoYXQgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBGU3ggZm9yIE9OVEFQIGZpbGUgc3lzdGVtJ3Mgc3RvcmFnZSB2aXJ0dWFsIG1hY2hpbmUgKFNWTSkuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1wcm90b2NvbC5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXByb3RvY29sLW5mc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbmZzPzogQ2ZuTG9jYXRpb25GU3hPTlRBUC5ORlNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNwZWNpZmllcyB0aGUgU2VydmVyIE1lc3NhZ2UgQmxvY2sgKFNNQikgcHJvdG9jb2wgY29uZmlndXJhdGlvbiB0aGF0IERhdGFTeW5jIHVzZXMgdG8gYWNjZXNzIHlvdXIgRlN4IGZvciBPTlRBUCBmaWxlIHN5c3RlbSdzIFNWTS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXByb3RvY29sLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtcHJvdG9jb2wtc21iXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzbWI/OiBDZm5Mb2NhdGlvbkZTeE9OVEFQLlNNQlByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQcm90b2NvbFByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQcm90b2NvbFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T05UQVBfUHJvdG9jb2xQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ25mcycsIENmbkxvY2F0aW9uRlN4T05UQVBfTkZTUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubmZzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzbWInLCBDZm5Mb2NhdGlvbkZTeE9OVEFQX1NNQlByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnNtYikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJQcm90b2NvbFByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPTlRBUC5Qcm90b2NvbGAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUHJvdG9jb2xQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVAuUHJvdG9jb2xgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25GU3hPTlRBUFByb3RvY29sUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkxvY2F0aW9uRlN4T05UQVBfUHJvdG9jb2xQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgTkZTOiBjZm5Mb2NhdGlvbkZTeE9OVEFQTkZTUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubmZzKSxcbiAgICAgICAgU01COiBjZm5Mb2NhdGlvbkZTeE9OVEFQU01CUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc21iKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPTlRBUFByb3RvY29sUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvbkZTeE9OVEFQLlByb3RvY29sUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuTG9jYXRpb25GU3hPTlRBUC5Qcm90b2NvbFByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmZzJywgJ05GUycsIHByb3BlcnRpZXMuTkZTICE9IG51bGwgPyBDZm5Mb2NhdGlvbkZTeE9OVEFQTkZTUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5ORlMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NtYicsICdTTUInLCBwcm9wZXJ0aWVzLlNNQiAhPSBudWxsID8gQ2ZuTG9jYXRpb25GU3hPTlRBUFNNQlByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuU01CKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuTG9jYXRpb25GU3hPTlRBUCB7XG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBTZXJ2ZXIgTWVzc2FnZSBCbG9jayAoU01CKSBwcm90b2NvbCBjb25maWd1cmF0aW9uIHRoYXQgQVdTIERhdGFTeW5jIHVzZXMgdG8gYWNjZXNzIGEgc3RvcmFnZSB2aXJ0dWFsIG1hY2hpbmUgKFNWTSkgb24geW91ciBBbWF6b24gRlN4IGZvciBOZXRBcHAgT05UQVAgZmlsZSBzeXN0ZW0uIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0FjY2Vzc2luZyBGU3ggZm9yIE9OVEFQIGZpbGUgc3lzdGVtc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLW9udGFwLWxvY2F0aW9uLmh0bWwjY3JlYXRlLW9udGFwLWxvY2F0aW9uLWFjY2VzcykgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1zbWIuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgU01CUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogU3BlY2lmaWVzIHRoZSBmdWxseSBxdWFsaWZpZWQgZG9tYWluIG5hbWUgKEZRRE4pIG9mIHRoZSBNaWNyb3NvZnQgQWN0aXZlIERpcmVjdG9yeSB0aGF0IHlvdXIgc3RvcmFnZSB2aXJ0dWFsIG1hY2hpbmUgKFNWTSkgYmVsb25ncyB0by5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXNtYi5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9udGFwLXNtYi1kb21haW5cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGRvbWFpbj86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNwZWNpZmllcyBob3cgRGF0YVN5bmMgY2FuIGFjY2VzcyBhIGxvY2F0aW9uIHVzaW5nIHRoZSBTTUIgcHJvdG9jb2wuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1zbWIuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvbnRhcC1zbWItbW91bnRvcHRpb25zXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtb3VudE9wdGlvbnM6IENmbkxvY2F0aW9uRlN4T05UQVAuU21iTW91bnRPcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBTcGVjaWZpZXMgdGhlIHBhc3N3b3JkIG9mIGEgdXNlciB3aG8gaGFzIHBlcm1pc3Npb24gdG8gYWNjZXNzIHlvdXIgU1ZNLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc21iLXBhc3N3b3JkXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwYXNzd29yZDogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogU3BlY2lmaWVzIGEgdXNlciBuYW1lIHRoYXQgY2FuIG1vdW50IHRoZSBsb2NhdGlvbiBhbmQgYWNjZXNzIHRoZSBmaWxlcywgZm9sZGVycywgYW5kIG1ldGFkYXRhIHRoYXQgeW91IG5lZWQgaW4gdGhlIFNWTS5cbiAgICAgICAgICpcbiAgICAgICAgICogSWYgeW91IHByb3ZpZGUgYSB1c2VyIGluIHlvdXIgQWN0aXZlIERpcmVjdG9yeSwgbm90ZSB0aGUgZm9sbG93aW5nOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIElmIHlvdSdyZSB1c2luZyBBV1MgRGlyZWN0b3J5IFNlcnZpY2UgZm9yIE1pY3Jvc29mdCBBY3RpdmUgRGlyZWN0b3J5ICwgdGhlIHVzZXIgbXVzdCBiZSBhIG1lbWJlciBvZiB0aGUgQVdTIERlbGVnYXRlZCBGU3ggQWRtaW5pc3RyYXRvcnMgZ3JvdXAuXG4gICAgICAgICAqIC0gSWYgeW91J3JlIHVzaW5nIGEgc2VsZi1tYW5hZ2VkIEFjdGl2ZSBEaXJlY3RvcnksIHRoZSB1c2VyIG11c3QgYmUgYSBtZW1iZXIgb2YgZWl0aGVyIHRoZSBEb21haW4gQWRtaW5zIGdyb3VwIG9yIGEgY3VzdG9tIGdyb3VwIHRoYXQgeW91IHNwZWNpZmllZCBmb3IgZmlsZSBzeXN0ZW0gYWRtaW5pc3RyYXRpb24gd2hlbiB5b3UgY3JlYXRlZCB5b3VyIGZpbGUgc3lzdGVtLlxuICAgICAgICAgKlxuICAgICAgICAgKiBNYWtlIHN1cmUgdGhhdCB0aGUgdXNlciBoYXMgdGhlIHBlcm1pc3Npb25zIGl0IG5lZWRzIHRvIGNvcHkgdGhlIGRhdGEgeW91IHdhbnQ6XG4gICAgICAgICAqXG4gICAgICAgICAqIC0gYFNFX1RDQl9OQU1FYCA6IFJlcXVpcmVkIHRvIHNldCBvYmplY3Qgb3duZXJzaGlwIGFuZCBmaWxlIG1ldGFkYXRhLiBXaXRoIHRoaXMgcHJpdmlsZWdlLCB5b3UgYWxzbyBjYW4gY29weSBOVEZTIGRpc2NyZXRpb25hcnkgYWNjZXNzIGxpc3RzIChEQUNMcykuXG4gICAgICAgICAqIC0gYFNFX1NFQ1VSSVRZX05BTUVgIDogTWF5IGJlIG5lZWRlZCB0byBjb3B5IE5URlMgc3lzdGVtIGFjY2VzcyBjb250cm9sIGxpc3RzIChTQUNMcykuIFRoaXMgb3BlcmF0aW9uIHNwZWNpZmljYWxseSByZXF1aXJlcyB0aGUgV2luZG93cyBwcml2aWxlZ2UsIHdoaWNoIGlzIGdyYW50ZWQgdG8gbWVtYmVycyBvZiB0aGUgRG9tYWluIEFkbWlucyBncm91cC4gSWYgeW91IGNvbmZpZ3VyZSB5b3VyIHRhc2sgdG8gY29weSBTQUNMcywgbWFrZSBzdXJlIHRoYXQgdGhlIHVzZXIgaGFzIHRoZSByZXF1aXJlZCBwcml2aWxlZ2VzLiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgY29weWluZyBTQUNMcywgc2VlIFtPd25lcnNoaXAgYW5kIHBlcm1pc3Npb25zLXJlbGF0ZWQgb3B0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLXRhc2suaHRtbCNjb25maWd1cmUtb3duZXJzaGlwLWFuZC1wZXJtaXNzaW9ucykgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc21iLXVzZXJcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHVzZXI6IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgU01CUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFNNQlByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T05UQVBfU01CUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkb21haW4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZG9tYWluKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtb3VudE9wdGlvbnMnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubW91bnRPcHRpb25zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtb3VudE9wdGlvbnMnLCBDZm5Mb2NhdGlvbkZTeE9OVEFQX1NtYk1vdW50T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1vdW50T3B0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncGFzc3dvcmQnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucGFzc3dvcmQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Bhc3N3b3JkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnBhc3N3b3JkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd1c2VyJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnVzZXIpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3VzZXInLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudXNlcikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJTTUJQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVAuU01CYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBTTUJQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T05UQVAuU01CYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uRlN4T05UQVBTTUJQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25GU3hPTlRBUF9TTUJQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRG9tYWluOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRvbWFpbiksXG4gICAgICAgIE1vdW50T3B0aW9uczogY2ZuTG9jYXRpb25GU3hPTlRBUFNtYk1vdW50T3B0aW9uc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1vdW50T3B0aW9ucyksXG4gICAgICAgIFBhc3N3b3JkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBhc3N3b3JkKSxcbiAgICAgICAgVXNlcjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy51c2VyKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPTlRBUFNNQlByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25GU3hPTlRBUC5TTUJQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbkZTeE9OVEFQLlNNQlByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZG9tYWluJywgJ0RvbWFpbicsIHByb3BlcnRpZXMuRG9tYWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRvbWFpbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbW91bnRPcHRpb25zJywgJ01vdW50T3B0aW9ucycsIENmbkxvY2F0aW9uRlN4T05UQVBTbWJNb3VudE9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk1vdW50T3B0aW9ucykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncGFzc3dvcmQnLCAnUGFzc3dvcmQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlBhc3N3b3JkKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd1c2VyJywgJ1VzZXInLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlVzZXIpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Mb2NhdGlvbkZTeE9OVEFQIHtcbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIHZlcnNpb24gb2YgdGhlIFNlcnZlciBNZXNzYWdlIEJsb2NrIChTTUIpIHByb3RvY29sIHRoYXQgQVdTIERhdGFTeW5jIHVzZXMgdG8gYWNjZXNzIGFuIFNNQiBmaWxlIHNlcnZlci5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc21ibW91bnRvcHRpb25zLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFNtYk1vdW50T3B0aW9uc1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEJ5IGRlZmF1bHQsIERhdGFTeW5jIGF1dG9tYXRpY2FsbHkgY2hvb3NlcyBhbiBTTUIgcHJvdG9jb2wgdmVyc2lvbiBiYXNlZCBvbiBuZWdvdGlhdGlvbiB3aXRoIHlvdXIgU01CIGZpbGUgc2VydmVyLiBZb3UgYWxzbyBjYW4gY29uZmlndXJlIERhdGFTeW5jIHRvIHVzZSBhIHNwZWNpZmljIFNNQiB2ZXJzaW9uLCBidXQgd2UgcmVjb21tZW5kIGRvaW5nIHRoaXMgb25seSBpZiBEYXRhU3luYyBoYXMgdHJvdWJsZSBuZWdvdGlhdGluZyB3aXRoIHRoZSBTTUIgZmlsZSBzZXJ2ZXIgYXV0b21hdGljYWxseS5cbiAgICAgICAgICpcbiAgICAgICAgICogVGhlc2UgYXJlIHRoZSBmb2xsb3dpbmcgb3B0aW9ucyBmb3IgY29uZmlndXJpbmcgdGhlIFNNQiB2ZXJzaW9uOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIGBBVVRPTUFUSUNgIChkZWZhdWx0KTogRGF0YVN5bmMgYW5kIHRoZSBTTUIgZmlsZSBzZXJ2ZXIgbmVnb3RpYXRlIHRoZSBoaWdoZXN0IHZlcnNpb24gb2YgU01CIHRoYXQgdGhleSBtdXR1YWxseSBzdXBwb3J0IGJldHdlZW4gMi4xIGFuZCAzLjEuMS5cbiAgICAgICAgICpcbiAgICAgICAgICogVGhpcyBpcyB0aGUgcmVjb21tZW5kZWQgb3B0aW9uLiBJZiB5b3UgaW5zdGVhZCBjaG9vc2UgYSBzcGVjaWZpYyB2ZXJzaW9uIHRoYXQgeW91ciBmaWxlIHNlcnZlciBkb2Vzbid0IHN1cHBvcnQsIHlvdSBtYXkgZ2V0IGFuIGBPcGVyYXRpb24gTm90IFN1cHBvcnRlZGAgZXJyb3IuXG4gICAgICAgICAqIC0gYFNNQjNgIDogUmVzdHJpY3RzIHRoZSBwcm90b2NvbCBuZWdvdGlhdGlvbiB0byBvbmx5IFNNQiB2ZXJzaW9uIDMuMC4yLlxuICAgICAgICAgKiAtIGBTTUIyYCA6IFJlc3RyaWN0cyB0aGUgcHJvdG9jb2wgbmVnb3RpYXRpb24gdG8gb25seSBTTUIgdmVyc2lvbiAyLjEuXG4gICAgICAgICAqIC0gYFNNQjJfMGAgOiBSZXN0cmljdHMgdGhlIHByb3RvY29sIG5lZ290aWF0aW9uIHRvIG9ubHkgU01CIHZlcnNpb24gMi4wLlxuICAgICAgICAgKiAtIGBTTUIxYCA6IFJlc3RyaWN0cyB0aGUgcHJvdG9jb2wgbmVnb3RpYXRpb24gdG8gb25seSBTTUIgdmVyc2lvbiAxLjAuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gVGhlIGBTTUIxYCBvcHRpb24gaXNuJ3QgYXZhaWxhYmxlIHdoZW4gW2NyZWF0aW5nIGFuIEFtYXpvbiBGU3ggZm9yIE5ldEFwcCBPTlRBUCBsb2NhdGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvQVBJX0NyZWF0ZUxvY2F0aW9uRnN4T250YXAuaHRtbCkgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc21ibW91bnRvcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b250YXAtc21ibW91bnRvcHRpb25zLXZlcnNpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZlcnNpb24/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFNtYk1vdW50T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBTbWJNb3VudE9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Mb2NhdGlvbkZTeE9OVEFQX1NtYk1vdW50T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmVyc2lvbicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52ZXJzaW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlNtYk1vdW50T3B0aW9uc1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPTlRBUC5TbWJNb3VudE9wdGlvbnNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFNtYk1vdW50T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPTlRBUC5TbWJNb3VudE9wdGlvbnNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25GU3hPTlRBUFNtYk1vdW50T3B0aW9uc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Mb2NhdGlvbkZTeE9OVEFQX1NtYk1vdW50T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBWZXJzaW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZlcnNpb24pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Mb2NhdGlvbkZTeE9OVEFQU21iTW91bnRPcHRpb25zUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvbkZTeE9OVEFQLlNtYk1vdW50T3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uRlN4T05UQVAuU21iTW91bnRPcHRpb25zUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2ZXJzaW9uJywgJ1ZlcnNpb24nLCBwcm9wZXJ0aWVzLlZlcnNpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVmVyc2lvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkxvY2F0aW9uRlN4T3BlblpGU2BcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdHlwZSBvZiBwcm90b2NvbCB0aGF0IEFXUyBEYXRhU3luYyB1c2VzIHRvIGFjY2VzcyB5b3VyIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy1wcm90b2NvbFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByb3RvY29sOiBDZm5Mb2NhdGlvbkZTeE9wZW5aRlMuUHJvdG9jb2xQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBUk5zIG9mIHRoZSBzZWN1cml0eSBncm91cHMgdGhhdCBhcmUgdXNlZCB0byBjb25maWd1cmUgdGhlIEZTeCBmb3IgT3BlblpGUyBmaWxlIHN5c3RlbS5cbiAgICAgKlxuICAgICAqICpQYXR0ZXJuKiA6IGBeYXJuOihhd3N8YXdzLWNufGF3cy11cy1nb3Z8YXdzLWlzb3xhd3MtaXNvLWIpOmVjMjpbYS16XFwtMC05XSo6WzAtOV17MTJ9OnNlY3VyaXR5LWdyb3VwLy4qJGBcbiAgICAgKlxuICAgICAqICpMZW5ndGggY29uc3RyYWludHMqIDogTWF4aW11bSBsZW5ndGggb2YgMTI4LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy1zZWN1cml0eWdyb3VwYXJuc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBBcm5zOiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgRlN4IGZvciBPcGVuWkZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy1mc3hmaWxlc3lzdGVtYXJuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZnN4RmlsZXN5c3RlbUFybj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgc3ViZGlyZWN0b3J5IGluIHRoZSBsb2NhdGlvbidzIHBhdGggdGhhdCBtdXN0IGJlZ2luIHdpdGggYC9mc3hgIC4gRGF0YVN5bmMgdXNlcyB0aGlzIHN1YmRpcmVjdG9yeSB0byByZWFkIG9yIHdyaXRlIGRhdGEgKGRlcGVuZGluZyBvbiB3aGV0aGVyIHRoZSBmaWxlIHN5c3RlbSBpcyBhIHNvdXJjZSBvciBkZXN0aW5hdGlvbiBsb2NhdGlvbikuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN1YmRpcmVjdG9yeT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBrZXktdmFsdWUgcGFpciB0aGF0IHJlcHJlc2VudHMgYSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIHJlc291cmNlLiBUaGUgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IHN0cmluZy4gVGhpcyB2YWx1ZSBoZWxwcyB5b3UgbWFuYWdlLCBmaWx0ZXIsIGFuZCBzZWFyY2ggZm9yIHlvdXIgcmVzb3VyY2VzLiBXZSByZWNvbW1lbmQgdGhhdCB5b3UgY3JlYXRlIGEgbmFtZSB0YWcgZm9yIHlvdXIgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbkxvY2F0aW9uRlN4T3BlblpGU1Byb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ZzeEZpbGVzeXN0ZW1Bcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZnN4RmlsZXN5c3RlbUFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJvdG9jb2wnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJvdG9jb2wpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Byb3RvY29sJywgQ2ZuTG9jYXRpb25GU3hPcGVuWkZTX1Byb3RvY29sUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMucHJvdG9jb2wpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlY3VyaXR5R3JvdXBBcm5zJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwQXJucycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cEFybnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N1YmRpcmVjdG9yeScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zdWJkaXJlY3RvcnkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuTG9jYXRpb25GU3hPcGVuWkZTUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeE9wZW5aRlNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkxvY2F0aW9uRlN4T3BlblpGU1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPcGVuWkZTYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uRlN4T3BlblpGU1Byb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgUHJvdG9jb2w6IGNmbkxvY2F0aW9uRlN4T3BlblpGU1Byb3RvY29sUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucHJvdG9jb2wpLFxuICAgICAgICBTZWN1cml0eUdyb3VwQXJuczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cEFybnMpLFxuICAgICAgICBGc3hGaWxlc3lzdGVtQXJuOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmZzeEZpbGVzeXN0ZW1Bcm4pLFxuICAgICAgICBTdWJkaXJlY3Rvcnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T3BlblpGU1Byb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25GU3hPcGVuWkZTUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uRlN4T3BlblpGU1Byb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncHJvdG9jb2wnLCAnUHJvdG9jb2wnLCBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNQcm90b2NvbFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuUHJvdG9jb2wpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NlY3VyaXR5R3JvdXBBcm5zJywgJ1NlY3VyaXR5R3JvdXBBcm5zJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmdBcnJheShwcm9wZXJ0aWVzLlNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdmc3hGaWxlc3lzdGVtQXJuJywgJ0ZzeEZpbGVzeXN0ZW1Bcm4nLCBwcm9wZXJ0aWVzLkZzeEZpbGVzeXN0ZW1Bcm4gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRnN4RmlsZXN5c3RlbUFybikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3ViZGlyZWN0b3J5JywgJ1N1YmRpcmVjdG9yeScsIHByb3BlcnRpZXMuU3ViZGlyZWN0b3J5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFncycsICdUYWdzJywgcHJvcGVydGllcy5UYWdzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Q2ZuVGFnKShwcm9wZXJ0aWVzLlRhZ3MpIDogdW5kZWZpbmVkIGFzIGFueSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPcGVuWkZTYFxuICpcbiAqIFRoZSBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPcGVuWkZTYCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gZW5kcG9pbnQgZm9yIGFuIEFtYXpvbiBGU3ggZm9yIE9wZW5aRlMgZmlsZSBzeXN0ZW0uXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPcGVuWkZTXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkxvY2F0aW9uRlN4T3BlblpGUyBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeE9wZW5aRlNcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkxvY2F0aW9uRlN4T3BlblpGUyB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTG9jYXRpb25GU3hPcGVuWkZTUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkxvY2F0aW9uRlN4T3BlblpGUyhzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQVJOIG9mIHRoZSBzcGVjaWZpZWQgRlN4IGZvciBPcGVuWkZTIGZpbGUgc3lzdGVtIGxvY2F0aW9uLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBMb2NhdGlvbkFyblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTG9jYXRpb25Bcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBVUkkgb2YgdGhlIHNwZWNpZmllZCBGU3ggZm9yIE9wZW5aRlMgZmlsZSBzeXN0ZW0gbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uVXJpXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvblVyaTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHR5cGUgb2YgcHJvdG9jb2wgdGhhdCBBV1MgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBmaWxlIHN5c3RlbS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMtcHJvdG9jb2xcbiAgICAgKi9cbiAgICBwdWJsaWMgcHJvdG9jb2w6IENmbkxvY2F0aW9uRlN4T3BlblpGUy5Qcm90b2NvbFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFSTnMgb2YgdGhlIHNlY3VyaXR5IGdyb3VwcyB0aGF0IGFyZSB1c2VkIHRvIGNvbmZpZ3VyZSB0aGUgRlN4IGZvciBPcGVuWkZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogKlBhdHRlcm4qIDogYF5hcm46KGF3c3xhd3MtY258YXdzLXVzLWdvdnxhd3MtaXNvfGF3cy1pc28tYik6ZWMyOlthLXpcXC0wLTldKjpbMC05XXsxMn06c2VjdXJpdHktZ3JvdXAvLiokYFxuICAgICAqXG4gICAgICogKkxlbmd0aCBjb25zdHJhaW50cyogOiBNYXhpbXVtIGxlbmd0aCBvZiAxMjguXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLXNlY3VyaXR5Z3JvdXBhcm5zXG4gICAgICovXG4gICAgcHVibGljIHNlY3VyaXR5R3JvdXBBcm5zOiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgRlN4IGZvciBPcGVuWkZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy1mc3hmaWxlc3lzdGVtYXJuXG4gICAgICovXG4gICAgcHVibGljIGZzeEZpbGVzeXN0ZW1Bcm46IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgc3ViZGlyZWN0b3J5IGluIHRoZSBsb2NhdGlvbidzIHBhdGggdGhhdCBtdXN0IGJlZ2luIHdpdGggYC9mc3hgIC4gRGF0YVN5bmMgdXNlcyB0aGlzIHN1YmRpcmVjdG9yeSB0byByZWFkIG9yIHdyaXRlIGRhdGEgKGRlcGVuZGluZyBvbiB3aGV0aGVyIHRoZSBmaWxlIHN5c3RlbSBpcyBhIHNvdXJjZSBvciBkZXN0aW5hdGlvbiBsb2NhdGlvbikuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHB1YmxpYyBzdWJkaXJlY3Rvcnk6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBrZXktdmFsdWUgcGFpciB0aGF0IHJlcHJlc2VudHMgYSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIHJlc291cmNlLiBUaGUgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IHN0cmluZy4gVGhpcyB2YWx1ZSBoZWxwcyB5b3UgbWFuYWdlLCBmaWx0ZXIsIGFuZCBzZWFyY2ggZm9yIHlvdXIgcmVzb3VyY2VzLiBXZSByZWNvbW1lbmQgdGhhdCB5b3UgY3JlYXRlIGEgbmFtZSB0YWcgZm9yIHlvdXIgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T3BlblpGU2AuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuTG9jYXRpb25GU3hPcGVuWkZTUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbkxvY2F0aW9uRlN4T3BlblpGUy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3Byb3RvY29sJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdzZWN1cml0eUdyb3VwQXJucycsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvbkFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25Bcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0ckxvY2F0aW9uVXJpID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdMb2NhdGlvblVyaScpKTtcblxuICAgICAgICB0aGlzLnByb3RvY29sID0gcHJvcHMucHJvdG9jb2w7XG4gICAgICAgIHRoaXMuc2VjdXJpdHlHcm91cEFybnMgPSBwcm9wcy5zZWN1cml0eUdyb3VwQXJucztcbiAgICAgICAgdGhpcy5mc3hGaWxlc3lzdGVtQXJuID0gcHJvcHMuZnN4RmlsZXN5c3RlbUFybjtcbiAgICAgICAgdGhpcy5zdWJkaXJlY3RvcnkgPSBwcm9wcy5zdWJkaXJlY3Rvcnk7XG4gICAgICAgIHRoaXMudGFncyA9IG5ldyBjZGsuVGFnTWFuYWdlcihjZGsuVGFnVHlwZS5TVEFOREFSRCwgXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeE9wZW5aRlNcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkxvY2F0aW9uRlN4T3BlblpGUy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgcHJvdG9jb2w6IHRoaXMucHJvdG9jb2wsXG4gICAgICAgICAgICBzZWN1cml0eUdyb3VwQXJuczogdGhpcy5zZWN1cml0eUdyb3VwQXJucyxcbiAgICAgICAgICAgIGZzeEZpbGVzeXN0ZW1Bcm46IHRoaXMuZnN4RmlsZXN5c3RlbUFybixcbiAgICAgICAgICAgIHN1YmRpcmVjdG9yeTogdGhpcy5zdWJkaXJlY3RvcnksXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkxvY2F0aW9uRlN4T3BlblpGU1Byb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkxvY2F0aW9uRlN4T3BlblpGUyB7XG4gICAgLyoqXG4gICAgICogUmVwcmVzZW50cyB0aGUgbW91bnQgb3B0aW9ucyB0aGF0IGFyZSBhdmFpbGFibGUgZm9yIERhdGFTeW5jIHRvIGFjY2VzcyBhIE5ldHdvcmsgRmlsZSBTeXN0ZW0gKE5GUykgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMtbW91bnRvcHRpb25zLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIE1vdW50T3B0aW9uc1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBzcGVjaWZpYyBORlMgdmVyc2lvbiB0aGF0IHlvdSB3YW50IERhdGFTeW5jIHRvIHVzZSB0byBtb3VudCB5b3VyIE5GUyBzaGFyZS4gSWYgdGhlIHNlcnZlciByZWZ1c2VzIHRvIHVzZSB0aGUgdmVyc2lvbiBzcGVjaWZpZWQsIHRoZSBzeW5jIHdpbGwgZmFpbC4gSWYgeW91IGRvbid0IHNwZWNpZnkgYSB2ZXJzaW9uLCBEYXRhU3luYyBkZWZhdWx0cyB0byBgQVVUT01BVElDYCAuIFRoYXQgaXMsIERhdGFTeW5jIGF1dG9tYXRpY2FsbHkgc2VsZWN0cyBhIHZlcnNpb24gYmFzZWQgb24gbmVnb3RpYXRpb24gd2l0aCB0aGUgTkZTIHNlcnZlci5cbiAgICAgICAgICpcbiAgICAgICAgICogWW91IGNhbiBzcGVjaWZ5IHRoZSBmb2xsb3dpbmcgTkZTIHZlcnNpb25zOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtICpbTkZTdjNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9odHRwczovL3Rvb2xzLmlldGYub3JnL2h0bWwvcmZjMTgxMykqIDogU3RhdGVsZXNzIHByb3RvY29sIHZlcnNpb24gdGhhdCBhbGxvd3MgZm9yIGFzeW5jaHJvbm91cyB3cml0ZXMgb24gdGhlIHNlcnZlci5cbiAgICAgICAgICogLSAqW05GU3Y0LjBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9odHRwczovL3Rvb2xzLmlldGYub3JnL2h0bWwvcmZjMzUzMCkqIDogU3RhdGVmdWwsIGZpcmV3YWxsLWZyaWVuZGx5IHByb3RvY29sIHZlcnNpb24gdGhhdCBzdXBwb3J0cyBkZWxlZ2F0aW9ucyBhbmQgcHNldWRvIGZpbGUgc3lzdGVtcy5cbiAgICAgICAgICogLSAqW05GU3Y0LjFdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9odHRwczovL3Rvb2xzLmlldGYub3JnL2h0bWwvcmZjNTY2MSkqIDogU3RhdGVmdWwgcHJvdG9jb2wgdmVyc2lvbiB0aGF0IHN1cHBvcnRzIHNlc3Npb25zLCBkaXJlY3RvcnkgZGVsZWdhdGlvbnMsIGFuZCBwYXJhbGxlbCBkYXRhIHByb2Nlc3NpbmcuIFZlcnNpb24gNC4xIGFsc28gaW5jbHVkZXMgYWxsIGZlYXR1cmVzIGF2YWlsYWJsZSBpbiB2ZXJzaW9uIDQuMC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMtbW91bnRvcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy1tb3VudG9wdGlvbnMtdmVyc2lvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTW91bnRPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1vdW50T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T3BlblpGU19Nb3VudE9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZlcnNpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudmVyc2lvbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJNb3VudE9wdGlvbnNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T3BlblpGUy5Nb3VudE9wdGlvbnNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1vdW50T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPcGVuWkZTLk1vdW50T3B0aW9uc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Mb2NhdGlvbkZTeE9wZW5aRlNNb3VudE9wdGlvbnNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25GU3hPcGVuWkZTX01vdW50T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBWZXJzaW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZlcnNpb24pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNNb3VudE9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxvY2F0aW9uRlN4T3BlblpGUy5Nb3VudE9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbkZTeE9wZW5aRlMuTW91bnRPcHRpb25zUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2ZXJzaW9uJywgJ1ZlcnNpb24nLCBwcm9wZXJ0aWVzLlZlcnNpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVmVyc2lvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkxvY2F0aW9uRlN4T3BlblpGUyB7XG4gICAgLyoqXG4gICAgICogUmVwcmVzZW50cyB0aGUgTmV0d29yayBGaWxlIFN5c3RlbSAoTkZTKSBwcm90b2NvbCB0aGF0IEFXUyBEYXRhU3luYyB1c2VzIHRvIGFjY2VzcyB5b3VyIEFtYXpvbiBGU3ggZm9yIE9wZW5aRlMgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMtbmZzLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIE5GU1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFJlcHJlc2VudHMgdGhlIG1vdW50IG9wdGlvbnMgdGhhdCBhcmUgYXZhaWxhYmxlIGZvciBEYXRhU3luYyB0byBhY2Nlc3MgYW4gTkZTIGxvY2F0aW9uLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy1uZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLW5mcy1tb3VudG9wdGlvbnNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG1vdW50T3B0aW9uczogQ2ZuTG9jYXRpb25GU3hPcGVuWkZTLk1vdW50T3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBORlNQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTkZTUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPcGVuWkZTX05GU1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbW91bnRPcHRpb25zJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1vdW50T3B0aW9ucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbW91bnRPcHRpb25zJywgQ2ZuTG9jYXRpb25GU3hPcGVuWkZTX01vdW50T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1vdW50T3B0aW9ucykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJORlNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4T3BlblpGUy5ORlNgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE5GU1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hPcGVuWkZTLk5GU2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Mb2NhdGlvbkZTeE9wZW5aRlNORlNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25GU3hPcGVuWkZTX05GU1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBNb3VudE9wdGlvbnM6IGNmbkxvY2F0aW9uRlN4T3BlblpGU01vdW50T3B0aW9uc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1vdW50T3B0aW9ucyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4T3BlblpGU05GU1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25GU3hPcGVuWkZTLk5GU1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uRlN4T3BlblpGUy5ORlNQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21vdW50T3B0aW9ucycsICdNb3VudE9wdGlvbnMnLCBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNNb3VudE9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk1vdW50T3B0aW9ucykpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkxvY2F0aW9uRlN4T3BlblpGUyB7XG4gICAgLyoqXG4gICAgICogUmVwcmVzZW50cyB0aGUgcHJvdG9jb2wgdGhhdCBBV1MgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBBbWF6b24gRlN4IGZvciBPcGVuWkZTIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25mc3hvcGVuemZzLXByb3RvY29sLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFByb3RvY29sUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogUmVwcmVzZW50cyB0aGUgTmV0d29yayBGaWxlIFN5c3RlbSAoTkZTKSBwcm90b2NvbCB0aGF0IERhdGFTeW5jIHVzZXMgdG8gYWNjZXNzIHlvdXIgRlN4IGZvciBPcGVuWkZTIGZpbGUgc3lzdGVtLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uZnN4b3Blbnpmcy1wcm90b2NvbC5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeG9wZW56ZnMtcHJvdG9jb2wtbmZzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBuZnM/OiBDZm5Mb2NhdGlvbkZTeE9wZW5aRlMuTkZTUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFByb3RvY29sUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByb3RvY29sUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPcGVuWkZTX1Byb3RvY29sUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduZnMnLCBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNfTkZTUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMubmZzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlByb3RvY29sUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeE9wZW5aRlMuUHJvdG9jb2xgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFByb3RvY29sUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeE9wZW5aRlMuUHJvdG9jb2xgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25GU3hPcGVuWkZTUHJvdG9jb2xQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25GU3hPcGVuWkZTX1Byb3RvY29sUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE5GUzogY2ZuTG9jYXRpb25GU3hPcGVuWkZTTkZTUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubmZzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hPcGVuWkZTUHJvdG9jb2xQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxvY2F0aW9uRlN4T3BlblpGUy5Qcm90b2NvbFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uRlN4T3BlblpGUy5Qcm90b2NvbFByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmZzJywgJ05GUycsIHByb3BlcnRpZXMuTkZTICE9IG51bGwgPyBDZm5Mb2NhdGlvbkZTeE9wZW5aRlNORlNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk5GUykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkxvY2F0aW9uRlN4V2luZG93c2BcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5Mb2NhdGlvbkZTeFdpbmRvd3NQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWVzIChBUk5zKSBvZiB0aGUgc2VjdXJpdHkgZ3JvdXBzIHRoYXQgYXJlIHVzZWQgdG8gY29uZmlndXJlIHRoZSBGU3ggZm9yIFdpbmRvd3MgRmlsZSBTZXJ2ZXIgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiAqUGF0dGVybiogOiBgXmFybjooYXdzfGF3cy1jbnxhd3MtdXMtZ292fGF3cy1pc298YXdzLWlzby1iKTplYzI6W2EtelxcLTAtOV0qOlswLTldezEyfTpzZWN1cml0eS1ncm91cC8uKiRgXG4gICAgICpcbiAgICAgKiAqTGVuZ3RoIGNvbnN0cmFpbnRzKiA6IE1heGltdW0gbGVuZ3RoIG9mIDEyOC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3Mtc2VjdXJpdHlncm91cGFybnNcbiAgICAgKi9cbiAgICByZWFkb25seSBzZWN1cml0eUdyb3VwQXJuczogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdXNlciB3aG8gaGFzIHRoZSBwZXJtaXNzaW9ucyB0byBhY2Nlc3MgZmlsZXMgYW5kIGZvbGRlcnMgaW4gdGhlIEZTeCBmb3IgV2luZG93cyBGaWxlIFNlcnZlciBmaWxlIHN5c3RlbS5cbiAgICAgKlxuICAgICAqIEZvciBpbmZvcm1hdGlvbiBhYm91dCBjaG9vc2luZyBhIHVzZXIgbmFtZSB0aGF0IGVuc3VyZXMgc3VmZmljaWVudCBwZXJtaXNzaW9ucyB0byBmaWxlcywgZm9sZGVycywgYW5kIG1ldGFkYXRhLCBzZWUgW3VzZXJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2NyZWF0ZS1mc3gtbG9jYXRpb24uaHRtbCNGU3hXdXNlcikgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy11c2VyXG4gICAgICovXG4gICAgcmVhZG9ubHkgdXNlcjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBuYW1lIG9mIHRoZSBXaW5kb3dzIGRvbWFpbiB0aGF0IHRoZSBGU3ggZm9yIFdpbmRvd3MgRmlsZSBTZXJ2ZXIgYmVsb25ncyB0by5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MtZG9tYWluXG4gICAgICovXG4gICAgcmVhZG9ubHkgZG9tYWluPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBmb3IgdGhlIEZTeCBmb3IgV2luZG93cyBGaWxlIFNlcnZlciBmaWxlIHN5c3RlbS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MtZnN4ZmlsZXN5c3RlbWFyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGZzeEZpbGVzeXN0ZW1Bcm4/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIHBhc3N3b3JkIG9mIHRoZSB1c2VyIHdobyBoYXMgdGhlIHBlcm1pc3Npb25zIHRvIGFjY2VzcyBmaWxlcyBhbmQgZm9sZGVycyBpbiB0aGUgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLXBhc3N3b3JkXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGFzc3dvcmQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBtb3VudCBwYXRoIGZvciB5b3VyIGZpbGUgc3lzdGVtIHVzaW5nIGZvcndhcmQgc2xhc2hlcy4gVGhpcyBpcyB3aGVyZSBEYXRhU3luYyByZWFkcyBvciB3cml0ZXMgZGF0YSAoZGVwZW5kaW5nIG9uIGlmIHRoaXMgaXMgYSBzb3VyY2Ugb3IgZGVzdGluYXRpb24gbG9jYXRpb24pLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICByZWFkb25seSBzdWJkaXJlY3Rvcnk/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgbGFiZWxzIHRoYXQgaGVscCB5b3UgY2F0ZWdvcml6ZSwgZmlsdGVyLCBhbmQgc2VhcmNoIGZvciB5b3VyIEFXUyByZXNvdXJjZXMuIFdlIHJlY29tbWVuZCBjcmVhdGluZyBhdCBsZWFzdCBhIG5hbWUgdGFnIGZvciB5b3VyIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IGNkay5DZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5Mb2NhdGlvbkZTeFdpbmRvd3NQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTG9jYXRpb25GU3hXaW5kb3dzUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25GU3hXaW5kb3dzUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkb21haW4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZG9tYWluKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdmc3hGaWxlc3lzdGVtQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmZzeEZpbGVzeXN0ZW1Bcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Bhc3N3b3JkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnBhc3N3b3JkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwQXJucycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zZWN1cml0eUdyb3VwQXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlHcm91cEFybnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJkaXJlY3RvcnknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd1c2VyJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnVzZXIpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3VzZXInLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudXNlcikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5Mb2NhdGlvbkZTeFdpbmRvd3NQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4V2luZG93c2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTG9jYXRpb25GU3hXaW5kb3dzUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeFdpbmRvd3NgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25GU3hXaW5kb3dzUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkxvY2F0aW9uRlN4V2luZG93c1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBTZWN1cml0eUdyb3VwQXJuczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cEFybnMpLFxuICAgICAgICBVc2VyOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnVzZXIpLFxuICAgICAgICBEb21haW46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZG9tYWluKSxcbiAgICAgICAgRnN4RmlsZXN5c3RlbUFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5mc3hGaWxlc3lzdGVtQXJuKSxcbiAgICAgICAgUGFzc3dvcmQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucGFzc3dvcmQpLFxuICAgICAgICBTdWJkaXJlY3Rvcnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uRlN4V2luZG93c1Byb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25GU3hXaW5kb3dzUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uRlN4V2luZG93c1Byb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2VjdXJpdHlHcm91cEFybnMnLCAnU2VjdXJpdHlHcm91cEFybnMnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuU2VjdXJpdHlHcm91cEFybnMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3VzZXInLCAnVXNlcicsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVXNlcikpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZG9tYWluJywgJ0RvbWFpbicsIHByb3BlcnRpZXMuRG9tYWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRvbWFpbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZnN4RmlsZXN5c3RlbUFybicsICdGc3hGaWxlc3lzdGVtQXJuJywgcHJvcGVydGllcy5Gc3hGaWxlc3lzdGVtQXJuICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkZzeEZpbGVzeXN0ZW1Bcm4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Bhc3N3b3JkJywgJ1Bhc3N3b3JkJywgcHJvcGVydGllcy5QYXNzd29yZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5QYXNzd29yZCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3ViZGlyZWN0b3J5JywgJ1N1YmRpcmVjdG9yeScsIHByb3BlcnRpZXMuU3ViZGlyZWN0b3J5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFncycsICdUYWdzJywgcHJvcGVydGllcy5UYWdzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Q2ZuVGFnKShwcm9wZXJ0aWVzLlRhZ3MpIDogdW5kZWZpbmVkIGFzIGFueSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hXaW5kb3dzYFxuICpcbiAqIFRoZSBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hXaW5kb3dzYCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gZW5kcG9pbnQgZm9yIGFuIEFtYXpvbiBGU3ggZm9yIFdpbmRvd3MgU2VydmVyIGZpbGUgc3lzdGVtLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uRlN4V2luZG93c1xuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5Mb2NhdGlvbkZTeFdpbmRvd3MgZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2UgaW1wbGVtZW50cyBjZGsuSUluc3BlY3RhYmxlIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hXaW5kb3dzXCI7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5Mb2NhdGlvbkZTeFdpbmRvd3Mge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkxvY2F0aW9uRlN4V2luZG93c1Byb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5Mb2NhdGlvbkZTeFdpbmRvd3Moc2NvcGUsIGlkLCBwcm9wc1Jlc3VsdC52YWx1ZSk7XG4gICAgICAgIGZvciAoY29uc3QgW3Byb3BLZXksIHByb3BWYWxdIG9mIE9iamVjdC5lbnRyaWVzKHByb3BzUmVzdWx0LmV4dHJhUHJvcGVydGllcykpICB7XG4gICAgICAgICAgICByZXQuYWRkUHJvcGVydHlPdmVycmlkZShwcm9wS2V5LCBwcm9wVmFsKTtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogVGhlIEFSTiBvZiB0aGUgc3BlY2lmaWVkIEZTeCBmb3IgV2luZG93cyBTZXJ2ZXIgZmlsZSBzeXN0ZW0gbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvbkFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIFVSSSBvZiB0aGUgc3BlY2lmaWVkIEZTeCBmb3IgV2luZG93cyBTZXJ2ZXIgZmlsZSBzeXN0ZW0gbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uVXJpXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvblVyaTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOcykgb2YgdGhlIHNlY3VyaXR5IGdyb3VwcyB0aGF0IGFyZSB1c2VkIHRvIGNvbmZpZ3VyZSB0aGUgRlN4IGZvciBXaW5kb3dzIEZpbGUgU2VydmVyIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogKlBhdHRlcm4qIDogYF5hcm46KGF3c3xhd3MtY258YXdzLXVzLWdvdnxhd3MtaXNvfGF3cy1pc28tYik6ZWMyOlthLXpcXC0wLTldKjpbMC05XXsxMn06c2VjdXJpdHktZ3JvdXAvLiokYFxuICAgICAqXG4gICAgICogKkxlbmd0aCBjb25zdHJhaW50cyogOiBNYXhpbXVtIGxlbmd0aCBvZiAxMjguXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLXNlY3VyaXR5Z3JvdXBhcm5zXG4gICAgICovXG4gICAgcHVibGljIHNlY3VyaXR5R3JvdXBBcm5zOiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIFRoZSB1c2VyIHdobyBoYXMgdGhlIHBlcm1pc3Npb25zIHRvIGFjY2VzcyBmaWxlcyBhbmQgZm9sZGVycyBpbiB0aGUgRlN4IGZvciBXaW5kb3dzIEZpbGUgU2VydmVyIGZpbGUgc3lzdGVtLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IGNob29zaW5nIGEgdXNlciBuYW1lIHRoYXQgZW5zdXJlcyBzdWZmaWNpZW50IHBlcm1pc3Npb25zIHRvIGZpbGVzLCBmb2xkZXJzLCBhbmQgbWV0YWRhdGEsIHNlZSBbdXNlcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLWZzeC1sb2NhdGlvbi5odG1sI0ZTeFd1c2VyKSAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLXVzZXJcbiAgICAgKi9cbiAgICBwdWJsaWMgdXNlcjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBuYW1lIG9mIHRoZSBXaW5kb3dzIGRvbWFpbiB0aGF0IHRoZSBGU3ggZm9yIFdpbmRvd3MgRmlsZSBTZXJ2ZXIgYmVsb25ncyB0by5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MtZG9tYWluXG4gICAgICovXG4gICAgcHVibGljIGRvbWFpbjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBmb3IgdGhlIEZTeCBmb3IgV2luZG93cyBGaWxlIFNlcnZlciBmaWxlIHN5c3RlbS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MtZnN4ZmlsZXN5c3RlbWFyblxuICAgICAqL1xuICAgIHB1YmxpYyBmc3hGaWxlc3lzdGVtQXJuOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIHBhc3N3b3JkIG9mIHRoZSB1c2VyIHdobyBoYXMgdGhlIHBlcm1pc3Npb25zIHRvIGFjY2VzcyBmaWxlcyBhbmQgZm9sZGVycyBpbiB0aGUgZmlsZSBzeXN0ZW0uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmZzeHdpbmRvd3MuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLXBhc3N3b3JkXG4gICAgICovXG4gICAgcHVibGljIHBhc3N3b3JkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBtb3VudCBwYXRoIGZvciB5b3VyIGZpbGUgc3lzdGVtIHVzaW5nIGZvcndhcmQgc2xhc2hlcy4gVGhpcyBpcyB3aGVyZSBEYXRhU3luYyByZWFkcyBvciB3cml0ZXMgZGF0YSAoZGVwZW5kaW5nIG9uIGlmIHRoaXMgaXMgYSBzb3VyY2Ugb3IgZGVzdGluYXRpb24gbG9jYXRpb24pLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICBwdWJsaWMgc3ViZGlyZWN0b3J5OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgbGFiZWxzIHRoYXQgaGVscCB5b3UgY2F0ZWdvcml6ZSwgZmlsdGVyLCBhbmQgc2VhcmNoIGZvciB5b3VyIEFXUyByZXNvdXJjZXMuIFdlIHJlY29tbWVuZCBjcmVhdGluZyBhdCBsZWFzdCBhIG5hbWUgdGFnIGZvciB5b3VyIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25mc3h3aW5kb3dzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uZnN4d2luZG93cy10YWdzXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHRhZ3M6IGNkay5UYWdNYW5hZ2VyO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkZTeFdpbmRvd3NgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkxvY2F0aW9uRlN4V2luZG93c1Byb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5Mb2NhdGlvbkZTeFdpbmRvd3MuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdzZWN1cml0eUdyb3VwQXJucycsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAndXNlcicsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvbkFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25Bcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0ckxvY2F0aW9uVXJpID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdMb2NhdGlvblVyaScpKTtcblxuICAgICAgICB0aGlzLnNlY3VyaXR5R3JvdXBBcm5zID0gcHJvcHMuc2VjdXJpdHlHcm91cEFybnM7XG4gICAgICAgIHRoaXMudXNlciA9IHByb3BzLnVzZXI7XG4gICAgICAgIHRoaXMuZG9tYWluID0gcHJvcHMuZG9tYWluO1xuICAgICAgICB0aGlzLmZzeEZpbGVzeXN0ZW1Bcm4gPSBwcm9wcy5mc3hGaWxlc3lzdGVtQXJuO1xuICAgICAgICB0aGlzLnBhc3N3b3JkID0gcHJvcHMucGFzc3dvcmQ7XG4gICAgICAgIHRoaXMuc3ViZGlyZWN0b3J5ID0gcHJvcHMuc3ViZGlyZWN0b3J5O1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25GU3hXaW5kb3dzXCIsIHByb3BzLnRhZ3MsIHsgdGFnUHJvcGVydHlOYW1lOiAndGFncycgfSk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5Mb2NhdGlvbkZTeFdpbmRvd3MuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHNlY3VyaXR5R3JvdXBBcm5zOiB0aGlzLnNlY3VyaXR5R3JvdXBBcm5zLFxuICAgICAgICAgICAgdXNlcjogdGhpcy51c2VyLFxuICAgICAgICAgICAgZG9tYWluOiB0aGlzLmRvbWFpbixcbiAgICAgICAgICAgIGZzeEZpbGVzeXN0ZW1Bcm46IHRoaXMuZnN4RmlsZXN5c3RlbUFybixcbiAgICAgICAgICAgIHBhc3N3b3JkOiB0aGlzLnBhc3N3b3JkLFxuICAgICAgICAgICAgc3ViZGlyZWN0b3J5OiB0aGlzLnN1YmRpcmVjdG9yeSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuTG9jYXRpb25GU3hXaW5kb3dzUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuTG9jYXRpb25IREZTYFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkxvY2F0aW9uSERGU1Byb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZXMgKEFSTnMpIG9mIHRoZSBhZ2VudHMgdGhhdCBhcmUgdXNlZCB0byBjb25uZWN0IHRvIHRoZSBIREZTIGNsdXN0ZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLWFnZW50YXJuc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGFnZW50QXJuczogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25IREZTLkF1dGhlbnRpY2F0aW9uVHlwZWBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtYXV0aGVudGljYXRpb250eXBlXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXV0aGVudGljYXRpb25UeXBlOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgTmFtZU5vZGUgdGhhdCBtYW5hZ2VzIHRoZSBIREZTIG5hbWVzcGFjZS4gVGhlIE5hbWVOb2RlIHBlcmZvcm1zIG9wZXJhdGlvbnMgc3VjaCBhcyBvcGVuaW5nLCBjbG9zaW5nLCBhbmQgcmVuYW1pbmcgZmlsZXMgYW5kIGRpcmVjdG9yaWVzLiBUaGUgTmFtZU5vZGUgY29udGFpbnMgdGhlIGluZm9ybWF0aW9uIHRvIG1hcCBibG9ja3Mgb2YgZGF0YSB0byB0aGUgRGF0YU5vZGVzLiBZb3UgY2FuIHVzZSBvbmx5IG9uZSBOYW1lTm9kZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtbmFtZW5vZGVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZU5vZGVzOiBBcnJheTxDZm5Mb2NhdGlvbkhERlMuTmFtZU5vZGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgc2l6ZSBvZiBkYXRhIGJsb2NrcyB0byB3cml0ZSBpbnRvIHRoZSBIREZTIGNsdXN0ZXIuIFRoZSBibG9jayBzaXplIG11c3QgYmUgYSBtdWx0aXBsZSBvZiA1MTIgYnl0ZXMuIFRoZSBkZWZhdWx0IGJsb2NrIHNpemUgaXMgMTI4IG1lYmlieXRlcyAoTWlCKS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtYmxvY2tzaXplXG4gICAgICovXG4gICAgcmVhZG9ubHkgYmxvY2tTaXplPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEtlcmJlcm9zIGtleSB0YWJsZSAoa2V5dGFiKSB0aGF0IGNvbnRhaW5zIG1hcHBpbmdzIGJldHdlZW4gdGhlIGRlZmluZWQgS2VyYmVyb3MgcHJpbmNpcGFsIGFuZCB0aGUgZW5jcnlwdGVkIGtleXMuIFByb3ZpZGUgdGhlIGJhc2U2NC1lbmNvZGVkIGZpbGUgdGV4dC4gSWYgYEtFUkJFUk9TYCBpcyBzcGVjaWZpZWQgZm9yIGBBdXRoVHlwZWAgLCB0aGlzIHZhbHVlIGlzIHJlcXVpcmVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1rZXJiZXJvc2tleXRhYlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGtlcmJlcm9zS2V5dGFiPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGBrcmI1LmNvbmZgIGZpbGUgdGhhdCBjb250YWlucyB0aGUgS2VyYmVyb3MgY29uZmlndXJhdGlvbiBpbmZvcm1hdGlvbi4gWW91IGNhbiBsb2FkIHRoZSBga3JiNS5jb25mYCBieSBwcm92aWRpbmcgYSBzdHJpbmcgb2YgdGhlIGZpbGUncyBjb250ZW50cyBvciBhbiBBbWF6b24gUzMgcHJlc2lnbmVkIFVSTCBvZiB0aGUgZmlsZS4gSWYgYEtFUkJFUk9TYCBpcyBzcGVjaWZpZWQgZm9yIGBBdXRoVHlwZWAgLCB0aGlzIHZhbHVlIGlzIHJlcXVpcmVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1rZXJiZXJvc2tyYjVjb25mXG4gICAgICovXG4gICAgcmVhZG9ubHkga2VyYmVyb3NLcmI1Q29uZj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBLZXJiZXJvcyBwcmluY2lwYWwgd2l0aCBhY2Nlc3MgdG8gdGhlIGZpbGVzIGFuZCBmb2xkZXJzIG9uIHRoZSBIREZTIGNsdXN0ZXIuXG4gICAgICpcbiAgICAgKiA+IElmIGBLRVJCRVJPU2AgaXMgc3BlY2lmaWVkIGZvciBgQXV0aGVudGljYXRpb25UeXBlYCAsIHRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1rZXJiZXJvc3ByaW5jaXBhbFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGtlcmJlcm9zUHJpbmNpcGFsPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIFVSSSBvZiB0aGUgSERGUyBjbHVzdGVyJ3MgS2V5IE1hbmFnZW1lbnQgU2VydmVyIChLTVMpLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1rbXNrZXlwcm92aWRlcnVyaVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGttc0tleVByb3ZpZGVyVXJpPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIFF1YWxpdHkgb2YgUHJvdGVjdGlvbiAoUU9QKSBjb25maWd1cmF0aW9uIHNwZWNpZmllcyB0aGUgUmVtb3RlIFByb2NlZHVyZSBDYWxsIChSUEMpIGFuZCBkYXRhIHRyYW5zZmVyIHByb3RlY3Rpb24gc2V0dGluZ3MgY29uZmlndXJlZCBvbiB0aGUgSGFkb29wIERpc3RyaWJ1dGVkIEZpbGUgU3lzdGVtIChIREZTKSBjbHVzdGVyLiBJZiBgUW9wQ29uZmlndXJhdGlvbmAgaXNuJ3Qgc3BlY2lmaWVkLCBgUnBjUHJvdGVjdGlvbmAgYW5kIGBEYXRhVHJhbnNmZXJQcm90ZWN0aW9uYCBkZWZhdWx0IHRvIGBQUklWQUNZYCAuIElmIHlvdSBzZXQgYFJwY1Byb3RlY3Rpb25gIG9yIGBEYXRhVHJhbnNmZXJQcm90ZWN0aW9uYCAsIHRoZSBvdGhlciBwYXJhbWV0ZXIgYXNzdW1lcyB0aGUgc2FtZSB2YWx1ZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtcW9wY29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHFvcENvbmZpZ3VyYXRpb24/OiBDZm5Mb2NhdGlvbkhERlMuUW9wQ29uZmlndXJhdGlvblByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG51bWJlciBvZiBEYXRhTm9kZXMgdG8gcmVwbGljYXRlIHRoZSBkYXRhIHRvIHdoZW4gd3JpdGluZyB0byB0aGUgSERGUyBjbHVzdGVyLiBCeSBkZWZhdWx0LCBkYXRhIGlzIHJlcGxpY2F0ZWQgdG8gdGhyZWUgRGF0YU5vZGVzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1yZXBsaWNhdGlvbmZhY3RvclxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlcGxpY2F0aW9uRmFjdG9yPzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHVzZXIgbmFtZSB1c2VkIHRvIGlkZW50aWZ5IHRoZSBjbGllbnQgb24gdGhlIGhvc3Qgb3BlcmF0aW5nIHN5c3RlbS5cbiAgICAgKlxuICAgICAqID4gSWYgYFNJTVBMRWAgaXMgc3BlY2lmaWVkIGZvciBgQXV0aGVudGljYXRpb25UeXBlYCAsIHRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1zaW1wbGV1c2VyXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2ltcGxlVXNlcj86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgc3ViZGlyZWN0b3J5IGluIHRoZSBIREZTIGNsdXN0ZXIuIFRoaXMgc3ViZGlyZWN0b3J5IGlzIHVzZWQgdG8gcmVhZCBkYXRhIGZyb20gb3Igd3JpdGUgZGF0YSB0byB0aGUgSERGUyBjbHVzdGVyLiBJZiB0aGUgc3ViZGlyZWN0b3J5IGlzbid0IHNwZWNpZmllZCwgaXQgd2lsbCBkZWZhdWx0IHRvIGAvYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN1YmRpcmVjdG9yeT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBrZXktdmFsdWUgcGFpciB0aGF0IHJlcHJlc2VudHMgdGhlIHRhZyB0aGF0IHlvdSB3YW50IHRvIGFkZCB0byB0aGUgbG9jYXRpb24uIFRoZSB2YWx1ZSBjYW4gYmUgYW4gZW1wdHkgc3RyaW5nLiBXZSByZWNvbW1lbmQgdXNpbmcgdGFncyB0byBuYW1lIHlvdXIgcmVzb3VyY2VzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IGNkay5DZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5Mb2NhdGlvbkhERlNQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuTG9jYXRpb25IREZTUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25IREZTUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhZ2VudEFybnMnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYWdlbnRBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhZ2VudEFybnMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLmFnZW50QXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYXV0aGVudGljYXRpb25UeXBlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmF1dGhlbnRpY2F0aW9uVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYXV0aGVudGljYXRpb25UeXBlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmF1dGhlbnRpY2F0aW9uVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYmxvY2tTaXplJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmJsb2NrU2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2VyYmVyb3NLZXl0YWInLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2VyYmVyb3NLZXl0YWIpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2tlcmJlcm9zS3JiNUNvbmYnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2VyYmVyb3NLcmI1Q29uZikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2VyYmVyb3NQcmluY2lwYWwnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2VyYmVyb3NQcmluY2lwYWwpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ttc0tleVByb3ZpZGVyVXJpJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmttc0tleVByb3ZpZGVyVXJpKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lTm9kZXMnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZU5vZGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lTm9kZXMnLCBjZGsubGlzdFZhbGlkYXRvcihDZm5Mb2NhdGlvbkhERlNfTmFtZU5vZGVQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMubmFtZU5vZGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdxb3BDb25maWd1cmF0aW9uJywgQ2ZuTG9jYXRpb25IREZTX1FvcENvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5xb3BDb25maWd1cmF0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZXBsaWNhdGlvbkZhY3RvcicsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5yZXBsaWNhdGlvbkZhY3RvcikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2ltcGxlVXNlcicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zaW1wbGVVc2VyKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJkaXJlY3RvcnknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkxvY2F0aW9uSERGU1Byb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25IREZTYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvbkhERlNQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uSERGU2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Mb2NhdGlvbkhERlNQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25IREZTUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEFnZW50QXJuczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWdlbnRBcm5zKSxcbiAgICAgICAgQXV0aGVudGljYXRpb25UeXBlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmF1dGhlbnRpY2F0aW9uVHlwZSksXG4gICAgICAgIE5hbWVOb2RlczogY2RrLmxpc3RNYXBwZXIoY2ZuTG9jYXRpb25IREZTTmFtZU5vZGVQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMubmFtZU5vZGVzKSxcbiAgICAgICAgQmxvY2tTaXplOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmJsb2NrU2l6ZSksXG4gICAgICAgIEtlcmJlcm9zS2V5dGFiOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtlcmJlcm9zS2V5dGFiKSxcbiAgICAgICAgS2VyYmVyb3NLcmI1Q29uZjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5rZXJiZXJvc0tyYjVDb25mKSxcbiAgICAgICAgS2VyYmVyb3NQcmluY2lwYWw6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2VyYmVyb3NQcmluY2lwYWwpLFxuICAgICAgICBLbXNLZXlQcm92aWRlclVyaTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5rbXNLZXlQcm92aWRlclVyaSksXG4gICAgICAgIFFvcENvbmZpZ3VyYXRpb246IGNmbkxvY2F0aW9uSERGU1FvcENvbmZpZ3VyYXRpb25Qcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5xb3BDb25maWd1cmF0aW9uKSxcbiAgICAgICAgUmVwbGljYXRpb25GYWN0b3I6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVwbGljYXRpb25GYWN0b3IpLFxuICAgICAgICBTaW1wbGVVc2VyOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNpbXBsZVVzZXIpLFxuICAgICAgICBTdWJkaXJlY3Rvcnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uSERGU1Byb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25IREZTUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uSERGU1Byb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWdlbnRBcm5zJywgJ0FnZW50QXJucycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BZ2VudEFybnMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2F1dGhlbnRpY2F0aW9uVHlwZScsICdBdXRoZW50aWNhdGlvblR5cGUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkF1dGhlbnRpY2F0aW9uVHlwZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmFtZU5vZGVzJywgJ05hbWVOb2RlcycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuTG9jYXRpb25IREZTTmFtZU5vZGVQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5OYW1lTm9kZXMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2Jsb2NrU2l6ZScsICdCbG9ja1NpemUnLCBwcm9wZXJ0aWVzLkJsb2NrU2l6ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5CbG9ja1NpemUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2tlcmJlcm9zS2V5dGFiJywgJ0tlcmJlcm9zS2V5dGFiJywgcHJvcGVydGllcy5LZXJiZXJvc0tleXRhYiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXJiZXJvc0tleXRhYikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna2VyYmVyb3NLcmI1Q29uZicsICdLZXJiZXJvc0tyYjVDb25mJywgcHJvcGVydGllcy5LZXJiZXJvc0tyYjVDb25mICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLktlcmJlcm9zS3JiNUNvbmYpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2tlcmJlcm9zUHJpbmNpcGFsJywgJ0tlcmJlcm9zUHJpbmNpcGFsJywgcHJvcGVydGllcy5LZXJiZXJvc1ByaW5jaXBhbCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXJiZXJvc1ByaW5jaXBhbCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna21zS2V5UHJvdmlkZXJVcmknLCAnS21zS2V5UHJvdmlkZXJVcmknLCBwcm9wZXJ0aWVzLkttc0tleVByb3ZpZGVyVXJpICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkttc0tleVByb3ZpZGVyVXJpKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdxb3BDb25maWd1cmF0aW9uJywgJ1FvcENvbmZpZ3VyYXRpb24nLCBwcm9wZXJ0aWVzLlFvcENvbmZpZ3VyYXRpb24gIT0gbnVsbCA/IENmbkxvY2F0aW9uSERGU1FvcENvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLlFvcENvbmZpZ3VyYXRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3JlcGxpY2F0aW9uRmFjdG9yJywgJ1JlcGxpY2F0aW9uRmFjdG9yJywgcHJvcGVydGllcy5SZXBsaWNhdGlvbkZhY3RvciAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5SZXBsaWNhdGlvbkZhY3RvcikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2ltcGxlVXNlcicsICdTaW1wbGVVc2VyJywgcHJvcGVydGllcy5TaW1wbGVVc2VyICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlNpbXBsZVVzZXIpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N1YmRpcmVjdG9yeScsICdTdWJkaXJlY3RvcnknLCBwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TdWJkaXJlY3RvcnkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uSERGU2BcbiAqXG4gKiBUaGUgYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uSERGU2AgcmVzb3VyY2Ugc3BlY2lmaWVzIGFuIGVuZHBvaW50IGZvciBhIEhhZG9vcCBEaXN0cmlidXRlZCBGaWxlIFN5c3RlbSAoSERGUykuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25IREZTXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkxvY2F0aW9uSERGUyBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkhERlNcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkxvY2F0aW9uSERGUyB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTG9jYXRpb25IREZTUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkxvY2F0aW9uSERGUyhzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIEhERlMgY2x1c3RlciBsb2NhdGlvbiB0byBkZXNjcmliZS5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgTG9jYXRpb25Bcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxvY2F0aW9uQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgVVJJIG9mIHRoZSBIREZTIGNsdXN0ZXIgbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uVXJpXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvblVyaTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOcykgb2YgdGhlIGFnZW50cyB0aGF0IGFyZSB1c2VkIHRvIGNvbm5lY3QgdG8gdGhlIEhERlMgY2x1c3Rlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtYWdlbnRhcm5zXG4gICAgICovXG4gICAgcHVibGljIGFnZW50QXJuczogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25IREZTLkF1dGhlbnRpY2F0aW9uVHlwZWBcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtYXV0aGVudGljYXRpb250eXBlXG4gICAgICovXG4gICAgcHVibGljIGF1dGhlbnRpY2F0aW9uVHlwZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIE5hbWVOb2RlIHRoYXQgbWFuYWdlcyB0aGUgSERGUyBuYW1lc3BhY2UuIFRoZSBOYW1lTm9kZSBwZXJmb3JtcyBvcGVyYXRpb25zIHN1Y2ggYXMgb3BlbmluZywgY2xvc2luZywgYW5kIHJlbmFtaW5nIGZpbGVzIGFuZCBkaXJlY3Rvcmllcy4gVGhlIE5hbWVOb2RlIGNvbnRhaW5zIHRoZSBpbmZvcm1hdGlvbiB0byBtYXAgYmxvY2tzIG9mIGRhdGEgdG8gdGhlIERhdGFOb2Rlcy4gWW91IGNhbiB1c2Ugb25seSBvbmUgTmFtZU5vZGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLW5hbWVub2Rlc1xuICAgICAqL1xuICAgIHB1YmxpYyBuYW1lTm9kZXM6IEFycmF5PENmbkxvY2F0aW9uSERGUy5OYW1lTm9kZVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBzaXplIG9mIGRhdGEgYmxvY2tzIHRvIHdyaXRlIGludG8gdGhlIEhERlMgY2x1c3Rlci4gVGhlIGJsb2NrIHNpemUgbXVzdCBiZSBhIG11bHRpcGxlIG9mIDUxMiBieXRlcy4gVGhlIGRlZmF1bHQgYmxvY2sgc2l6ZSBpcyAxMjggbWViaWJ5dGVzIChNaUIpLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1ibG9ja3NpemVcbiAgICAgKi9cbiAgICBwdWJsaWMgYmxvY2tTaXplOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgS2VyYmVyb3Mga2V5IHRhYmxlIChrZXl0YWIpIHRoYXQgY29udGFpbnMgbWFwcGluZ3MgYmV0d2VlbiB0aGUgZGVmaW5lZCBLZXJiZXJvcyBwcmluY2lwYWwgYW5kIHRoZSBlbmNyeXB0ZWQga2V5cy4gUHJvdmlkZSB0aGUgYmFzZTY0LWVuY29kZWQgZmlsZSB0ZXh0LiBJZiBgS0VSQkVST1NgIGlzIHNwZWNpZmllZCBmb3IgYEF1dGhUeXBlYCAsIHRoaXMgdmFsdWUgaXMgcmVxdWlyZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLWtlcmJlcm9za2V5dGFiXG4gICAgICovXG4gICAgcHVibGljIGtlcmJlcm9zS2V5dGFiOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYGtyYjUuY29uZmAgZmlsZSB0aGF0IGNvbnRhaW5zIHRoZSBLZXJiZXJvcyBjb25maWd1cmF0aW9uIGluZm9ybWF0aW9uLiBZb3UgY2FuIGxvYWQgdGhlIGBrcmI1LmNvbmZgIGJ5IHByb3ZpZGluZyBhIHN0cmluZyBvZiB0aGUgZmlsZSdzIGNvbnRlbnRzIG9yIGFuIEFtYXpvbiBTMyBwcmVzaWduZWQgVVJMIG9mIHRoZSBmaWxlLiBJZiBgS0VSQkVST1NgIGlzIHNwZWNpZmllZCBmb3IgYEF1dGhUeXBlYCAsIHRoaXMgdmFsdWUgaXMgcmVxdWlyZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLWtlcmJlcm9za3JiNWNvbmZcbiAgICAgKi9cbiAgICBwdWJsaWMga2VyYmVyb3NLcmI1Q29uZjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEtlcmJlcm9zIHByaW5jaXBhbCB3aXRoIGFjY2VzcyB0byB0aGUgZmlsZXMgYW5kIGZvbGRlcnMgb24gdGhlIEhERlMgY2x1c3Rlci5cbiAgICAgKlxuICAgICAqID4gSWYgYEtFUkJFUk9TYCBpcyBzcGVjaWZpZWQgZm9yIGBBdXRoZW50aWNhdGlvblR5cGVgICwgdGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLWtlcmJlcm9zcHJpbmNpcGFsXG4gICAgICovXG4gICAgcHVibGljIGtlcmJlcm9zUHJpbmNpcGFsOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgVVJJIG9mIHRoZSBIREZTIGNsdXN0ZXIncyBLZXkgTWFuYWdlbWVudCBTZXJ2ZXIgKEtNUykuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLWttc2tleXByb3ZpZGVydXJpXG4gICAgICovXG4gICAgcHVibGljIGttc0tleVByb3ZpZGVyVXJpOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgUXVhbGl0eSBvZiBQcm90ZWN0aW9uIChRT1ApIGNvbmZpZ3VyYXRpb24gc3BlY2lmaWVzIHRoZSBSZW1vdGUgUHJvY2VkdXJlIENhbGwgKFJQQykgYW5kIGRhdGEgdHJhbnNmZXIgcHJvdGVjdGlvbiBzZXR0aW5ncyBjb25maWd1cmVkIG9uIHRoZSBIYWRvb3AgRGlzdHJpYnV0ZWQgRmlsZSBTeXN0ZW0gKEhERlMpIGNsdXN0ZXIuIElmIGBRb3BDb25maWd1cmF0aW9uYCBpc24ndCBzcGVjaWZpZWQsIGBScGNQcm90ZWN0aW9uYCBhbmQgYERhdGFUcmFuc2ZlclByb3RlY3Rpb25gIGRlZmF1bHQgdG8gYFBSSVZBQ1lgIC4gSWYgeW91IHNldCBgUnBjUHJvdGVjdGlvbmAgb3IgYERhdGFUcmFuc2ZlclByb3RlY3Rpb25gICwgdGhlIG90aGVyIHBhcmFtZXRlciBhc3N1bWVzIHRoZSBzYW1lIHZhbHVlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25oZGZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1xb3Bjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcHVibGljIHFvcENvbmZpZ3VyYXRpb246IENmbkxvY2F0aW9uSERGUy5Rb3BDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbnVtYmVyIG9mIERhdGFOb2RlcyB0byByZXBsaWNhdGUgdGhlIGRhdGEgdG8gd2hlbiB3cml0aW5nIHRvIHRoZSBIREZTIGNsdXN0ZXIuIEJ5IGRlZmF1bHQsIGRhdGEgaXMgcmVwbGljYXRlZCB0byB0aHJlZSBEYXRhTm9kZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLXJlcGxpY2F0aW9uZmFjdG9yXG4gICAgICovXG4gICAgcHVibGljIHJlcGxpY2F0aW9uRmFjdG9yOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgdXNlciBuYW1lIHVzZWQgdG8gaWRlbnRpZnkgdGhlIGNsaWVudCBvbiB0aGUgaG9zdCBvcGVyYXRpbmcgc3lzdGVtLlxuICAgICAqXG4gICAgICogPiBJZiBgU0lNUExFYCBpcyBzcGVjaWZpZWQgZm9yIGBBdXRoZW50aWNhdGlvblR5cGVgICwgdGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLXNpbXBsZXVzZXJcbiAgICAgKi9cbiAgICBwdWJsaWMgc2ltcGxlVXNlcjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBzdWJkaXJlY3RvcnkgaW4gdGhlIEhERlMgY2x1c3Rlci4gVGhpcyBzdWJkaXJlY3RvcnkgaXMgdXNlZCB0byByZWFkIGRhdGEgZnJvbSBvciB3cml0ZSBkYXRhIHRvIHRoZSBIREZTIGNsdXN0ZXIuIElmIHRoZSBzdWJkaXJlY3RvcnkgaXNuJ3Qgc3BlY2lmaWVkLCBpdCB3aWxsIGRlZmF1bHQgdG8gYC9gIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtc3ViZGlyZWN0b3J5XG4gICAgICovXG4gICAgcHVibGljIHN1YmRpcmVjdG9yeTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGtleS12YWx1ZSBwYWlyIHRoYXQgcmVwcmVzZW50cyB0aGUgdGFnIHRoYXQgeW91IHdhbnQgdG8gYWRkIHRvIHRoZSBsb2NhdGlvbi4gVGhlIHZhbHVlIGNhbiBiZSBhbiBlbXB0eSBzdHJpbmcuIFdlIHJlY29tbWVuZCB1c2luZyB0YWdzIHRvIG5hbWUgeW91ciByZXNvdXJjZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbmhkZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uSERGU2AuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuTG9jYXRpb25IREZTUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmbkxvY2F0aW9uSERGUy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ2FnZW50QXJucycsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnYXV0aGVudGljYXRpb25UeXBlJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICduYW1lTm9kZXMnLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyTG9jYXRpb25Bcm4gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0xvY2F0aW9uQXJuJykpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvblVyaSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25VcmknKSk7XG5cbiAgICAgICAgdGhpcy5hZ2VudEFybnMgPSBwcm9wcy5hZ2VudEFybnM7XG4gICAgICAgIHRoaXMuYXV0aGVudGljYXRpb25UeXBlID0gcHJvcHMuYXV0aGVudGljYXRpb25UeXBlO1xuICAgICAgICB0aGlzLm5hbWVOb2RlcyA9IHByb3BzLm5hbWVOb2RlcztcbiAgICAgICAgdGhpcy5ibG9ja1NpemUgPSBwcm9wcy5ibG9ja1NpemU7XG4gICAgICAgIHRoaXMua2VyYmVyb3NLZXl0YWIgPSBwcm9wcy5rZXJiZXJvc0tleXRhYjtcbiAgICAgICAgdGhpcy5rZXJiZXJvc0tyYjVDb25mID0gcHJvcHMua2VyYmVyb3NLcmI1Q29uZjtcbiAgICAgICAgdGhpcy5rZXJiZXJvc1ByaW5jaXBhbCA9IHByb3BzLmtlcmJlcm9zUHJpbmNpcGFsO1xuICAgICAgICB0aGlzLmttc0tleVByb3ZpZGVyVXJpID0gcHJvcHMua21zS2V5UHJvdmlkZXJVcmk7XG4gICAgICAgIHRoaXMucW9wQ29uZmlndXJhdGlvbiA9IHByb3BzLnFvcENvbmZpZ3VyYXRpb247XG4gICAgICAgIHRoaXMucmVwbGljYXRpb25GYWN0b3IgPSBwcm9wcy5yZXBsaWNhdGlvbkZhY3RvcjtcbiAgICAgICAgdGhpcy5zaW1wbGVVc2VyID0gcHJvcHMuc2ltcGxlVXNlcjtcbiAgICAgICAgdGhpcy5zdWJkaXJlY3RvcnkgPSBwcm9wcy5zdWJkaXJlY3Rvcnk7XG4gICAgICAgIHRoaXMudGFncyA9IG5ldyBjZGsuVGFnTWFuYWdlcihjZGsuVGFnVHlwZS5TVEFOREFSRCwgXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkhERlNcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkxvY2F0aW9uSERGUy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgYWdlbnRBcm5zOiB0aGlzLmFnZW50QXJucyxcbiAgICAgICAgICAgIGF1dGhlbnRpY2F0aW9uVHlwZTogdGhpcy5hdXRoZW50aWNhdGlvblR5cGUsXG4gICAgICAgICAgICBuYW1lTm9kZXM6IHRoaXMubmFtZU5vZGVzLFxuICAgICAgICAgICAgYmxvY2tTaXplOiB0aGlzLmJsb2NrU2l6ZSxcbiAgICAgICAgICAgIGtlcmJlcm9zS2V5dGFiOiB0aGlzLmtlcmJlcm9zS2V5dGFiLFxuICAgICAgICAgICAga2VyYmVyb3NLcmI1Q29uZjogdGhpcy5rZXJiZXJvc0tyYjVDb25mLFxuICAgICAgICAgICAga2VyYmVyb3NQcmluY2lwYWw6IHRoaXMua2VyYmVyb3NQcmluY2lwYWwsXG4gICAgICAgICAgICBrbXNLZXlQcm92aWRlclVyaTogdGhpcy5rbXNLZXlQcm92aWRlclVyaSxcbiAgICAgICAgICAgIHFvcENvbmZpZ3VyYXRpb246IHRoaXMucW9wQ29uZmlndXJhdGlvbixcbiAgICAgICAgICAgIHJlcGxpY2F0aW9uRmFjdG9yOiB0aGlzLnJlcGxpY2F0aW9uRmFjdG9yLFxuICAgICAgICAgICAgc2ltcGxlVXNlcjogdGhpcy5zaW1wbGVVc2VyLFxuICAgICAgICAgICAgc3ViZGlyZWN0b3J5OiB0aGlzLnN1YmRpcmVjdG9yeSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuTG9jYXRpb25IREZTUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuTG9jYXRpb25IREZTIHtcbiAgICAvKipcbiAgICAgKiBUaGUgTmFtZU5vZGUgb2YgdGhlIEhhZG9vcCBEaXN0cmlidXRlZCBGaWxlIFN5c3RlbSAoSERGUykuIFRoZSBOYW1lTm9kZSBtYW5hZ2VzIHRoZSBmaWxlIHN5c3RlbSdzIG5hbWVzcGFjZSBhbmQgcGVyZm9ybXMgb3BlcmF0aW9ucyBzdWNoIGFzIG9wZW5pbmcsIGNsb3NpbmcsIGFuZCByZW5hbWluZyBmaWxlcyBhbmQgZGlyZWN0b3JpZXMuIFRoZSBOYW1lTm9kZSBhbHNvIGNvbnRhaW5zIHRoZSBpbmZvcm1hdGlvbiB0byBtYXAgYmxvY2tzIG9mIGRhdGEgdG8gdGhlIERhdGFOb2Rlcy5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1uYW1lbm9kZS5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBOYW1lTm9kZVByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBob3N0bmFtZSBvZiB0aGUgTmFtZU5vZGUgaW4gdGhlIEhERlMgY2x1c3Rlci4gVGhpcyB2YWx1ZSBpcyB0aGUgSVAgYWRkcmVzcyBvciBEb21haW4gTmFtZSBTZXJ2aWNlIChETlMpIG5hbWUgb2YgdGhlIE5hbWVOb2RlLiBBbiBhZ2VudCB0aGF0J3MgaW5zdGFsbGVkIG9uLXByZW1pc2VzIHVzZXMgdGhpcyBob3N0bmFtZSB0byBjb21tdW5pY2F0ZSB3aXRoIHRoZSBOYW1lTm9kZSBpbiB0aGUgbmV0d29yay5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmhkZnMtbmFtZW5vZGUuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLW5hbWVub2RlLWhvc3RuYW1lXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBob3N0bmFtZTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHBvcnQgdGhhdCB0aGUgTmFtZU5vZGUgdXNlcyB0byBsaXN0ZW4gdG8gY2xpZW50IHJlcXVlc3RzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uaGRmcy1uYW1lbm9kZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbmhkZnMtbmFtZW5vZGUtcG9ydFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcG9ydDogbnVtYmVyO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBOYW1lTm9kZVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBOYW1lTm9kZVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uSERGU19OYW1lTm9kZVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignaG9zdG5hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuaG9zdG5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2hvc3RuYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmhvc3RuYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwb3J0JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnBvcnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3BvcnQnLCBjZGsudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMucG9ydCkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJOYW1lTm9kZVByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25IREZTLk5hbWVOb2RlYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBOYW1lTm9kZVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25IREZTLk5hbWVOb2RlYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uSERGU05hbWVOb2RlUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkxvY2F0aW9uSERGU19OYW1lTm9kZVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBIb3N0bmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5ob3N0bmFtZSksXG4gICAgICAgIFBvcnQ6IGNkay5udW1iZXJUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucG9ydCksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uSERGU05hbWVOb2RlUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvbkhERlMuTmFtZU5vZGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbkhERlMuTmFtZU5vZGVQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2hvc3RuYW1lJywgJ0hvc3RuYW1lJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Ib3N0bmFtZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncG9ydCcsICdQb3J0JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5Qb3J0KSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuTG9jYXRpb25IREZTIHtcbiAgICAvKipcbiAgICAgKiBUaGUgUXVhbGl0eSBvZiBQcm90ZWN0aW9uIChRT1ApIGNvbmZpZ3VyYXRpb24gc3BlY2lmaWVzIHRoZSBSZW1vdGUgUHJvY2VkdXJlIENhbGwgKFJQQykgYW5kIGRhdGEgdHJhbnNmZXIgcHJpdmFjeSBzZXR0aW5ncyBjb25maWd1cmVkIG9uIHRoZSBIYWRvb3AgRGlzdHJpYnV0ZWQgRmlsZSBTeXN0ZW0gKEhERlMpIGNsdXN0ZXIuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbmhkZnMtcW9wY29uZmlndXJhdGlvbi5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBRb3BDb25maWd1cmF0aW9uUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIGRhdGEgdHJhbnNmZXIgcHJvdGVjdGlvbiBzZXR0aW5nIGNvbmZpZ3VyZWQgb24gdGhlIEhERlMgY2x1c3Rlci4gVGhpcyBzZXR0aW5nIGNvcnJlc3BvbmRzIHRvIHlvdXIgYGRmcy5kYXRhLnRyYW5zZmVyLnByb3RlY3Rpb25gIHNldHRpbmcgaW4gdGhlIGBoZGZzLXNpdGUueG1sYCBmaWxlIG9uIHlvdXIgSGFkb29wIGNsdXN0ZXIuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25oZGZzLXFvcGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLXFvcGNvbmZpZ3VyYXRpb24tZGF0YXRyYW5zZmVycHJvdGVjdGlvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgZGF0YVRyYW5zZmVyUHJvdGVjdGlvbj86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSBSZW1vdGUgUHJvY2VkdXJlIENhbGwgKFJQQykgcHJvdGVjdGlvbiBzZXR0aW5nIGNvbmZpZ3VyZWQgb24gdGhlIEhERlMgY2x1c3Rlci4gVGhpcyBzZXR0aW5nIGNvcnJlc3BvbmRzIHRvIHlvdXIgYGhhZG9vcC5ycGMucHJvdGVjdGlvbmAgc2V0dGluZyBpbiB5b3VyIGBjb3JlLXNpdGUueG1sYCBmaWxlIG9uIHlvdXIgSGFkb29wIGNsdXN0ZXIuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25oZGZzLXFvcGNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25oZGZzLXFvcGNvbmZpZ3VyYXRpb24tcnBjcHJvdGVjdGlvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcnBjUHJvdGVjdGlvbj86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUW9wQ29uZmlndXJhdGlvblByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBRb3BDb25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25IREZTX1FvcENvbmZpZ3VyYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RhdGFUcmFuc2ZlclByb3RlY3Rpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGF0YVRyYW5zZmVyUHJvdGVjdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncnBjUHJvdGVjdGlvbicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5ycGNQcm90ZWN0aW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlFvcENvbmZpZ3VyYXRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uSERGUy5Rb3BDb25maWd1cmF0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBRb3BDb25maWd1cmF0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbkhERlMuUW9wQ29uZmlndXJhdGlvbmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Mb2NhdGlvbkhERlNRb3BDb25maWd1cmF0aW9uUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkxvY2F0aW9uSERGU19Rb3BDb25maWd1cmF0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIERhdGFUcmFuc2ZlclByb3RlY3Rpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGF0YVRyYW5zZmVyUHJvdGVjdGlvbiksXG4gICAgICAgIFJwY1Byb3RlY3Rpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucnBjUHJvdGVjdGlvbiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uSERGU1FvcENvbmZpZ3VyYXRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxvY2F0aW9uSERGUy5Rb3BDb25maWd1cmF0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuTG9jYXRpb25IREZTLlFvcENvbmZpZ3VyYXRpb25Qcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RhdGFUcmFuc2ZlclByb3RlY3Rpb24nLCAnRGF0YVRyYW5zZmVyUHJvdGVjdGlvbicsIHByb3BlcnRpZXMuRGF0YVRyYW5zZmVyUHJvdGVjdGlvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5EYXRhVHJhbnNmZXJQcm90ZWN0aW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdycGNQcm90ZWN0aW9uJywgJ1JwY1Byb3RlY3Rpb24nLCBwcm9wZXJ0aWVzLlJwY1Byb3RlY3Rpb24gIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUnBjUHJvdGVjdGlvbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkxvY2F0aW9uTkZTYFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm5mcy5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuTG9jYXRpb25ORlNQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBDb250YWlucyBhIGxpc3Qgb2YgQW1hem9uIFJlc291cmNlIE5hbWVzIChBUk5zKSBvZiBhZ2VudHMgdGhhdCBhcmUgdXNlZCB0byBjb25uZWN0IHRvIGFuIE5GUyBzZXJ2ZXIuXG4gICAgICpcbiAgICAgKiBJZiB5b3UgYXJlIGNvcHlpbmcgZGF0YSB0byBvciBmcm9tIHlvdXIgQVdTIFNub3djb25lIGRldmljZSwgc2VlIFtORlMgU2VydmVyIG9uIEFXUyBTbm93Y29uZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLW5mcy1sb2NhdGlvbi5odG1sI25mcy1vbi1zbm93Y29uZSkgZm9yIG1vcmUgaW5mb3JtYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm5mcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm5mcy1vbnByZW1jb25maWdcbiAgICAgKi9cbiAgICByZWFkb25seSBvblByZW1Db25maWc6IENmbkxvY2F0aW9uTkZTLk9uUHJlbUNvbmZpZ1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIE5GUyBtb3VudCBvcHRpb25zIHRoYXQgRGF0YVN5bmMgY2FuIHVzZSB0byBtb3VudCB5b3VyIE5GUyBzaGFyZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ubmZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9ubmZzLW1vdW50b3B0aW9uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IG1vdW50T3B0aW9ucz86IENmbkxvY2F0aW9uTkZTLk1vdW50T3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIE5GUyBzZXJ2ZXIuIFRoaXMgdmFsdWUgaXMgdGhlIElQIGFkZHJlc3Mgb3IgRG9tYWluIE5hbWUgU2VydmljZSAoRE5TKSBuYW1lIG9mIHRoZSBORlMgc2VydmVyLiBBbiBhZ2VudCB0aGF0IGlzIGluc3RhbGxlZCBvbi1wcmVtaXNlcyB1c2VzIHRoaXMgaG9zdG5hbWUgdG8gbW91bnQgdGhlIE5GUyBzZXJ2ZXIgaW4gYSBuZXR3b3JrLlxuICAgICAqXG4gICAgICogSWYgeW91IGFyZSBjb3B5aW5nIGRhdGEgdG8gb3IgZnJvbSB5b3VyIEFXUyBTbm93Y29uZSBkZXZpY2UsIHNlZSBbTkZTIFNlcnZlciBvbiBBV1MgU25vd2NvbmVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2NyZWF0ZS1uZnMtbG9jYXRpb24uaHRtbCNuZnMtb24tc25vd2NvbmUpIGZvciBtb3JlIGluZm9ybWF0aW9uLlxuICAgICAqXG4gICAgICogPiBUaGlzIG5hbWUgbXVzdCBlaXRoZXIgYmUgRE5TLWNvbXBsaWFudCBvciBtdXN0IGJlIGFuIElQIHZlcnNpb24gNCAoSVB2NCkgYWRkcmVzcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ubmZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9ubmZzLXNlcnZlcmhvc3RuYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmVySG9zdG5hbWU/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgc3ViZGlyZWN0b3J5IGluIHRoZSBORlMgZmlsZSBzeXN0ZW0gdGhhdCBpcyB1c2VkIHRvIHJlYWQgZGF0YSBmcm9tIHRoZSBORlMgc291cmNlIGxvY2F0aW9uIG9yIHdyaXRlIGRhdGEgdG8gdGhlIE5GUyBkZXN0aW5hdGlvbi4gVGhlIE5GUyBwYXRoIHNob3VsZCBiZSBhIHBhdGggdGhhdCdzIGV4cG9ydGVkIGJ5IHRoZSBORlMgc2VydmVyLCBvciBhIHN1YmRpcmVjdG9yeSBvZiB0aGF0IHBhdGguIFRoZSBwYXRoIHNob3VsZCBiZSBzdWNoIHRoYXQgaXQgY2FuIGJlIG1vdW50ZWQgYnkgb3RoZXIgTkZTIGNsaWVudHMgaW4geW91ciBuZXR3b3JrLlxuICAgICAqXG4gICAgICogVG8gc2VlIGFsbCB0aGUgcGF0aHMgZXhwb3J0ZWQgYnkgeW91ciBORlMgc2VydmVyLCBydW4gXCIgYHNob3dtb3VudCAtZSBuZnMtc2VydmVyLW5hbWVgIFwiIGZyb20gYW4gTkZTIGNsaWVudCB0aGF0IGhhcyBhY2Nlc3MgdG8geW91ciBzZXJ2ZXIuIFlvdSBjYW4gc3BlY2lmeSBhbnkgZGlyZWN0b3J5IHRoYXQgYXBwZWFycyBpbiB0aGUgcmVzdWx0cywgYW5kIGFueSBzdWJkaXJlY3Rvcnkgb2YgdGhhdCBkaXJlY3RvcnkuIEVuc3VyZSB0aGF0IHRoZSBORlMgZXhwb3J0IGlzIGFjY2Vzc2libGUgd2l0aG91dCBLZXJiZXJvcyBhdXRoZW50aWNhdGlvbi5cbiAgICAgKlxuICAgICAqIFRvIHRyYW5zZmVyIGFsbCB0aGUgZGF0YSBpbiB0aGUgZm9sZGVyIHlvdSBzcGVjaWZpZWQsIERhdGFTeW5jIG5lZWRzIHRvIGhhdmUgcGVybWlzc2lvbnMgdG8gcmVhZCBhbGwgdGhlIGRhdGEuIFRvIGVuc3VyZSB0aGlzLCBlaXRoZXIgY29uZmlndXJlIHRoZSBORlMgZXhwb3J0IHdpdGggYG5vX3Jvb3Rfc3F1YXNoLGAgb3IgZW5zdXJlIHRoYXQgdGhlIHBlcm1pc3Npb25zIGZvciBhbGwgb2YgdGhlIGZpbGVzIHRoYXQgeW91IHdhbnQgRGF0YVN5bmMgYWxsb3cgcmVhZCBhY2Nlc3MgZm9yIGFsbCB1c2Vycy4gRG9pbmcgZWl0aGVyIGVuYWJsZXMgdGhlIGFnZW50IHRvIHJlYWQgdGhlIGZpbGVzLiBGb3IgdGhlIGFnZW50IHRvIGFjY2VzcyBkaXJlY3RvcmllcywgeW91IG11c3QgYWRkaXRpb25hbGx5IGVuYWJsZSBhbGwgZXhlY3V0ZSBhY2Nlc3MuXG4gICAgICpcbiAgICAgKiBJZiB5b3UgYXJlIGNvcHlpbmcgZGF0YSB0byBvciBmcm9tIHlvdXIgQVdTIFNub3djb25lIGRldmljZSwgc2VlIFtORlMgU2VydmVyIG9uIEFXUyBTbm93Y29uZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLW5mcy1sb2NhdGlvbi5odG1sI25mcy1vbi1zbm93Y29uZSkgZm9yIG1vcmUgaW5mb3JtYXRpb24uXG4gICAgICpcbiAgICAgKiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgTkZTIGV4cG9ydCBjb25maWd1cmF0aW9uLCBzZWUgWzE4LjcuIFRoZSAvZXRjL2V4cG9ydHMgQ29uZmlndXJhdGlvbiBGaWxlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaHR0cDovL3dlYi5taXQuZWR1L3JoZWwtZG9jLzUvUkhFTC01LW1hbnVhbC9EZXBsb3ltZW50X0d1aWRlLWVuLVVTL3MxLW5mcy1zZXJ2ZXItY29uZmlnLWV4cG9ydHMuaHRtbCkgaW4gdGhlIFJlZCBIYXQgRW50ZXJwcmlzZSBMaW51eCBkb2N1bWVudGF0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25uZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25uZnMtc3ViZGlyZWN0b3J5XG4gICAgICovXG4gICAgcmVhZG9ubHkgc3ViZGlyZWN0b3J5Pzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGtleS12YWx1ZSBwYWlyIHRoYXQgcmVwcmVzZW50cyB0aGUgdGFnIHRoYXQgeW91IHdhbnQgdG8gYWRkIHRvIHRoZSBsb2NhdGlvbi4gVGhlIHZhbHVlIGNhbiBiZSBhbiBlbXB0eSBzdHJpbmcuIFdlIHJlY29tbWVuZCB1c2luZyB0YWdzIHRvIG5hbWUgeW91ciByZXNvdXJjZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm5mcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm5mcy10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IGNkay5DZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5Mb2NhdGlvbk5GU1Byb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvbk5GU1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uTkZTUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtb3VudE9wdGlvbnMnLCBDZm5Mb2NhdGlvbk5GU19Nb3VudE9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5tb3VudE9wdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ29uUHJlbUNvbmZpZycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5vblByZW1Db25maWcpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ29uUHJlbUNvbmZpZycsIENmbkxvY2F0aW9uTkZTX09uUHJlbUNvbmZpZ1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLm9uUHJlbUNvbmZpZykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VydmVySG9zdG5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2VydmVySG9zdG5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3N1YmRpcmVjdG9yeScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zdWJkaXJlY3RvcnkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuTG9jYXRpb25ORlNQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uTkZTYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvbk5GU1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25ORlNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25ORlNQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25ORlNQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgT25QcmVtQ29uZmlnOiBjZm5Mb2NhdGlvbk5GU09uUHJlbUNvbmZpZ1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm9uUHJlbUNvbmZpZyksXG4gICAgICAgIE1vdW50T3B0aW9uczogY2ZuTG9jYXRpb25ORlNNb3VudE9wdGlvbnNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tb3VudE9wdGlvbnMpLFxuICAgICAgICBTZXJ2ZXJIb3N0bmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zZXJ2ZXJIb3N0bmFtZSksXG4gICAgICAgIFN1YmRpcmVjdG9yeTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zdWJkaXJlY3RvcnkpLFxuICAgICAgICBUYWdzOiBjZGsubGlzdE1hcHBlcihjZGsuY2ZuVGFnVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25ORlNQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxvY2F0aW9uTkZTUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uTkZTUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdvblByZW1Db25maWcnLCAnT25QcmVtQ29uZmlnJywgQ2ZuTG9jYXRpb25ORlNPblByZW1Db25maWdQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk9uUHJlbUNvbmZpZykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbW91bnRPcHRpb25zJywgJ01vdW50T3B0aW9ucycsIHByb3BlcnRpZXMuTW91bnRPcHRpb25zICE9IG51bGwgPyBDZm5Mb2NhdGlvbk5GU01vdW50T3B0aW9uc1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTW91bnRPcHRpb25zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZXJ2ZXJIb3N0bmFtZScsICdTZXJ2ZXJIb3N0bmFtZScsIHByb3BlcnRpZXMuU2VydmVySG9zdG5hbWUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU2VydmVySG9zdG5hbWUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N1YmRpcmVjdG9yeScsICdTdWJkaXJlY3RvcnknLCBwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TdWJkaXJlY3RvcnkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uTkZTYFxuICpcbiAqIFRoZSBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25ORlNgIHJlc291cmNlIHNwZWNpZmllcyBhIGZpbGUgc3lzdGVtIG9uIGEgTmV0d29yayBGaWxlIFN5c3RlbSAoTkZTKSBzZXJ2ZXIgdGhhdCBjYW4gYmUgcmVhZCBmcm9tIG9yIHdyaXR0ZW4gdG8uXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25ORlNcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm5mcy5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5Mb2NhdGlvbk5GUyBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbk5GU1wiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTG9jYXRpb25ORlMge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkxvY2F0aW9uTkZTUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkxvY2F0aW9uTkZTKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgc3BlY2lmaWVkIHNvdXJjZSBORlMgZmlsZSBzeXN0ZW0gbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvbkFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIFVSSSBvZiB0aGUgc3BlY2lmaWVkIHNvdXJjZSBORlMgbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uVXJpXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvblVyaTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQ29udGFpbnMgYSBsaXN0IG9mIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOcykgb2YgYWdlbnRzIHRoYXQgYXJlIHVzZWQgdG8gY29ubmVjdCB0byBhbiBORlMgc2VydmVyLlxuICAgICAqXG4gICAgICogSWYgeW91IGFyZSBjb3B5aW5nIGRhdGEgdG8gb3IgZnJvbSB5b3VyIEFXUyBTbm93Y29uZSBkZXZpY2UsIHNlZSBbTkZTIFNlcnZlciBvbiBBV1MgU25vd2NvbmVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2NyZWF0ZS1uZnMtbG9jYXRpb24uaHRtbCNuZnMtb24tc25vd2NvbmUpIGZvciBtb3JlIGluZm9ybWF0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25uZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25uZnMtb25wcmVtY29uZmlnXG4gICAgICovXG4gICAgcHVibGljIG9uUHJlbUNvbmZpZzogQ2ZuTG9jYXRpb25ORlMuT25QcmVtQ29uZmlnUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgTkZTIG1vdW50IG9wdGlvbnMgdGhhdCBEYXRhU3luYyBjYW4gdXNlIHRvIG1vdW50IHlvdXIgTkZTIHNoYXJlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25uZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25uZnMtbW91bnRvcHRpb25zXG4gICAgICovXG4gICAgcHVibGljIG1vdW50T3B0aW9uczogQ2ZuTG9jYXRpb25ORlMuTW91bnRPcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgTkZTIHNlcnZlci4gVGhpcyB2YWx1ZSBpcyB0aGUgSVAgYWRkcmVzcyBvciBEb21haW4gTmFtZSBTZXJ2aWNlIChETlMpIG5hbWUgb2YgdGhlIE5GUyBzZXJ2ZXIuIEFuIGFnZW50IHRoYXQgaXMgaW5zdGFsbGVkIG9uLXByZW1pc2VzIHVzZXMgdGhpcyBob3N0bmFtZSB0byBtb3VudCB0aGUgTkZTIHNlcnZlciBpbiBhIG5ldHdvcmsuXG4gICAgICpcbiAgICAgKiBJZiB5b3UgYXJlIGNvcHlpbmcgZGF0YSB0byBvciBmcm9tIHlvdXIgQVdTIFNub3djb25lIGRldmljZSwgc2VlIFtORlMgU2VydmVyIG9uIEFXUyBTbm93Y29uZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLW5mcy1sb2NhdGlvbi5odG1sI25mcy1vbi1zbm93Y29uZSkgZm9yIG1vcmUgaW5mb3JtYXRpb24uXG4gICAgICpcbiAgICAgKiA+IFRoaXMgbmFtZSBtdXN0IGVpdGhlciBiZSBETlMtY29tcGxpYW50IG9yIG11c3QgYmUgYW4gSVAgdmVyc2lvbiA0IChJUHY0KSBhZGRyZXNzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25uZnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25uZnMtc2VydmVyaG9zdG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VydmVySG9zdG5hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBzdWJkaXJlY3RvcnkgaW4gdGhlIE5GUyBmaWxlIHN5c3RlbSB0aGF0IGlzIHVzZWQgdG8gcmVhZCBkYXRhIGZyb20gdGhlIE5GUyBzb3VyY2UgbG9jYXRpb24gb3Igd3JpdGUgZGF0YSB0byB0aGUgTkZTIGRlc3RpbmF0aW9uLiBUaGUgTkZTIHBhdGggc2hvdWxkIGJlIGEgcGF0aCB0aGF0J3MgZXhwb3J0ZWQgYnkgdGhlIE5GUyBzZXJ2ZXIsIG9yIGEgc3ViZGlyZWN0b3J5IG9mIHRoYXQgcGF0aC4gVGhlIHBhdGggc2hvdWxkIGJlIHN1Y2ggdGhhdCBpdCBjYW4gYmUgbW91bnRlZCBieSBvdGhlciBORlMgY2xpZW50cyBpbiB5b3VyIG5ldHdvcmsuXG4gICAgICpcbiAgICAgKiBUbyBzZWUgYWxsIHRoZSBwYXRocyBleHBvcnRlZCBieSB5b3VyIE5GUyBzZXJ2ZXIsIHJ1biBcIiBgc2hvd21vdW50IC1lIG5mcy1zZXJ2ZXItbmFtZWAgXCIgZnJvbSBhbiBORlMgY2xpZW50IHRoYXQgaGFzIGFjY2VzcyB0byB5b3VyIHNlcnZlci4gWW91IGNhbiBzcGVjaWZ5IGFueSBkaXJlY3RvcnkgdGhhdCBhcHBlYXJzIGluIHRoZSByZXN1bHRzLCBhbmQgYW55IHN1YmRpcmVjdG9yeSBvZiB0aGF0IGRpcmVjdG9yeS4gRW5zdXJlIHRoYXQgdGhlIE5GUyBleHBvcnQgaXMgYWNjZXNzaWJsZSB3aXRob3V0IEtlcmJlcm9zIGF1dGhlbnRpY2F0aW9uLlxuICAgICAqXG4gICAgICogVG8gdHJhbnNmZXIgYWxsIHRoZSBkYXRhIGluIHRoZSBmb2xkZXIgeW91IHNwZWNpZmllZCwgRGF0YVN5bmMgbmVlZHMgdG8gaGF2ZSBwZXJtaXNzaW9ucyB0byByZWFkIGFsbCB0aGUgZGF0YS4gVG8gZW5zdXJlIHRoaXMsIGVpdGhlciBjb25maWd1cmUgdGhlIE5GUyBleHBvcnQgd2l0aCBgbm9fcm9vdF9zcXVhc2gsYCBvciBlbnN1cmUgdGhhdCB0aGUgcGVybWlzc2lvbnMgZm9yIGFsbCBvZiB0aGUgZmlsZXMgdGhhdCB5b3Ugd2FudCBEYXRhU3luYyBhbGxvdyByZWFkIGFjY2VzcyBmb3IgYWxsIHVzZXJzLiBEb2luZyBlaXRoZXIgZW5hYmxlcyB0aGUgYWdlbnQgdG8gcmVhZCB0aGUgZmlsZXMuIEZvciB0aGUgYWdlbnQgdG8gYWNjZXNzIGRpcmVjdG9yaWVzLCB5b3UgbXVzdCBhZGRpdGlvbmFsbHkgZW5hYmxlIGFsbCBleGVjdXRlIGFjY2Vzcy5cbiAgICAgKlxuICAgICAqIElmIHlvdSBhcmUgY29weWluZyBkYXRhIHRvIG9yIGZyb20geW91ciBBV1MgU25vd2NvbmUgZGV2aWNlLCBzZWUgW05GUyBTZXJ2ZXIgb24gQVdTIFNub3djb25lXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9jcmVhdGUtbmZzLWxvY2F0aW9uLmh0bWwjbmZzLW9uLXNub3djb25lKSBmb3IgbW9yZSBpbmZvcm1hdGlvbi5cbiAgICAgKlxuICAgICAqIEZvciBpbmZvcm1hdGlvbiBhYm91dCBORlMgZXhwb3J0IGNvbmZpZ3VyYXRpb24sIHNlZSBbMTguNy4gVGhlIC9ldGMvZXhwb3J0cyBDb25maWd1cmF0aW9uIEZpbGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9odHRwOi8vd2ViLm1pdC5lZHUvcmhlbC1kb2MvNS9SSEVMLTUtbWFudWFsL0RlcGxveW1lbnRfR3VpZGUtZW4tVVMvczEtbmZzLXNlcnZlci1jb25maWctZXhwb3J0cy5odG1sKSBpbiB0aGUgUmVkIEhhdCBFbnRlcnByaXNlIExpbnV4IGRvY3VtZW50YXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm5mcy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm5mcy1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICBwdWJsaWMgc3ViZGlyZWN0b3J5OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUga2V5LXZhbHVlIHBhaXIgdGhhdCByZXByZXNlbnRzIHRoZSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIGxvY2F0aW9uLiBUaGUgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IHN0cmluZy4gV2UgcmVjb21tZW5kIHVzaW5nIHRhZ3MgdG8gbmFtZSB5b3VyIHJlc291cmNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ubmZzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9ubmZzLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uTkZTYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5Mb2NhdGlvbk5GU1Byb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5Mb2NhdGlvbk5GUy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ29uUHJlbUNvbmZpZycsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvbkFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25Bcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0ckxvY2F0aW9uVXJpID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdMb2NhdGlvblVyaScpKTtcblxuICAgICAgICB0aGlzLm9uUHJlbUNvbmZpZyA9IHByb3BzLm9uUHJlbUNvbmZpZztcbiAgICAgICAgdGhpcy5tb3VudE9wdGlvbnMgPSBwcm9wcy5tb3VudE9wdGlvbnM7XG4gICAgICAgIHRoaXMuc2VydmVySG9zdG5hbWUgPSBwcm9wcy5zZXJ2ZXJIb3N0bmFtZTtcbiAgICAgICAgdGhpcy5zdWJkaXJlY3RvcnkgPSBwcm9wcy5zdWJkaXJlY3Rvcnk7XG4gICAgICAgIHRoaXMudGFncyA9IG5ldyBjZGsuVGFnTWFuYWdlcihjZGsuVGFnVHlwZS5TVEFOREFSRCwgXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbk5GU1wiLCBwcm9wcy50YWdzLCB7IHRhZ1Byb3BlcnR5TmFtZTogJ3RhZ3MnIH0pO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuTG9jYXRpb25ORlMuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG9uUHJlbUNvbmZpZzogdGhpcy5vblByZW1Db25maWcsXG4gICAgICAgICAgICBtb3VudE9wdGlvbnM6IHRoaXMubW91bnRPcHRpb25zLFxuICAgICAgICAgICAgc2VydmVySG9zdG5hbWU6IHRoaXMuc2VydmVySG9zdG5hbWUsXG4gICAgICAgICAgICBzdWJkaXJlY3Rvcnk6IHRoaXMuc3ViZGlyZWN0b3J5LFxuICAgICAgICAgICAgdGFnczogdGhpcy50YWdzLnJlbmRlclRhZ3MoKSxcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5Mb2NhdGlvbk5GU1Byb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkxvY2F0aW9uTkZTIHtcbiAgICAvKipcbiAgICAgKiBUaGUgTkZTIG1vdW50IG9wdGlvbnMgdGhhdCBEYXRhU3luYyBjYW4gdXNlIHRvIG1vdW50IHlvdXIgTkZTIHNoYXJlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25uZnMtbW91bnRvcHRpb25zLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIE1vdW50T3B0aW9uc1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNwZWNpZmllcyB0aGUgTkZTIHZlcnNpb24gdGhhdCB5b3Ugd2FudCBEYXRhU3luYyB0byB1c2Ugd2hlbiBtb3VudGluZyB5b3VyIE5GUyBzaGFyZS4gSWYgdGhlIHNlcnZlciByZWZ1c2VzIHRvIHVzZSB0aGUgdmVyc2lvbiBzcGVjaWZpZWQsIHRoZSB0YXNrIGZhaWxzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBZb3UgY2FuIHNwZWNpZnkgdGhlIGZvbGxvd2luZyBvcHRpb25zOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIGBBVVRPTUFUSUNgIChkZWZhdWx0KTogRGF0YVN5bmMgY2hvb3NlcyBORlMgdmVyc2lvbiA0LjEuXG4gICAgICAgICAqIC0gYE5GUzNgIDogU3RhdGVsZXNzIHByb3RvY29sIHZlcnNpb24gdGhhdCBhbGxvd3MgZm9yIGFzeW5jaHJvbm91cyB3cml0ZXMgb24gdGhlIHNlcnZlci5cbiAgICAgICAgICogLSBgTkZTdjRfMGAgOiBTdGF0ZWZ1bCwgZmlyZXdhbGwtZnJpZW5kbHkgcHJvdG9jb2wgdmVyc2lvbiB0aGF0IHN1cHBvcnRzIGRlbGVnYXRpb25zIGFuZCBwc2V1ZG8gZmlsZSBzeXN0ZW1zLlxuICAgICAgICAgKiAtIGBORlN2NF8xYCA6IFN0YXRlZnVsIHByb3RvY29sIHZlcnNpb24gdGhhdCBzdXBwb3J0cyBzZXNzaW9ucywgZGlyZWN0b3J5IGRlbGVnYXRpb25zLCBhbmQgcGFyYWxsZWwgZGF0YSBwcm9jZXNzaW5nLiBORlMgdmVyc2lvbiA0LjEgYWxzbyBpbmNsdWRlcyBhbGwgZmVhdHVyZXMgYXZhaWxhYmxlIGluIHZlcnNpb24gNC4wLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IERhdGFTeW5jIGN1cnJlbnRseSBvbmx5IHN1cHBvcnRzIE5GUyB2ZXJzaW9uIDMgd2l0aCBBbWF6b24gRlN4IGZvciBOZXRBcHAgT05UQVAgbG9jYXRpb25zLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9ubmZzLW1vdW50b3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm5mcy1tb3VudG9wdGlvbnMtdmVyc2lvblxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgTW91bnRPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE1vdW50T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uTkZTX01vdW50T3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmVyc2lvbicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52ZXJzaW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIk1vdW50T3B0aW9uc1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25ORlMuTW91bnRPcHRpb25zYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBNb3VudE9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uTkZTLk1vdW50T3B0aW9uc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Mb2NhdGlvbk5GU01vdW50T3B0aW9uc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Mb2NhdGlvbk5GU19Nb3VudE9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgVmVyc2lvbjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy52ZXJzaW9uKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25ORlNNb3VudE9wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmbkxvY2F0aW9uTkZTLk1vdW50T3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uTkZTLk1vdW50T3B0aW9uc1Byb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndmVyc2lvbicsICdWZXJzaW9uJywgcHJvcGVydGllcy5WZXJzaW9uICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZlcnNpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Mb2NhdGlvbk5GUyB7XG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIEFtYXpvbiBSZXNvdXJjZSBOYW1lcyAoQVJOcykgb2YgYWdlbnRzIHRvIHVzZSBmb3IgYSBOZXR3b3JrIEZpbGUgU3lzdGVtIChORlMpIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtbG9jYXRpb25uZnMtb25wcmVtY29uZmlnLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIE9uUHJlbUNvbmZpZ1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEFSTnMgb2YgdGhlIGFnZW50cyB0byB1c2UgZm9yIGFuIE5GUyBsb2NhdGlvbi5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbm5mcy1vbnByZW1jb25maWcuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25uZnMtb25wcmVtY29uZmlnLWFnZW50YXJuc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgYWdlbnRBcm5zOiBzdHJpbmdbXTtcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgT25QcmVtQ29uZmlnUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE9uUHJlbUNvbmZpZ1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uTkZTX09uUHJlbUNvbmZpZ1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWdlbnRBcm5zJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmFnZW50QXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWdlbnRBcm5zJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5hZ2VudEFybnMpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiT25QcmVtQ29uZmlnUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbk5GUy5PblByZW1Db25maWdgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE9uUHJlbUNvbmZpZ1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25ORlMuT25QcmVtQ29uZmlnYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uTkZTT25QcmVtQ29uZmlnUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmbkxvY2F0aW9uTkZTX09uUHJlbUNvbmZpZ1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBBZ2VudEFybnM6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLmFnZW50QXJucyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uTkZTT25QcmVtQ29uZmlnUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvbk5GUy5PblByZW1Db25maWdQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvbk5GUy5PblByZW1Db25maWdQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2FnZW50QXJucycsICdBZ2VudEFybnMnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZ0FycmF5KHByb3BlcnRpZXMuQWdlbnRBcm5zKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuTG9jYXRpb25PYmplY3RTdG9yYWdlYFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgQW1hem9uIFJlc291cmNlIE5hbWVzIChBUk5zKSBvZiB0aGUgRGF0YVN5bmMgYWdlbnRzIHRoYXQgY2FuIHNlY3VyZWx5IGNvbm5lY3Qgd2l0aCB5b3VyIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS1hZ2VudGFybnNcbiAgICAgKi9cbiAgICByZWFkb25seSBhZ2VudEFybnM6IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBhY2Nlc3Mga2V5IChmb3IgZXhhbXBsZSwgYSB1c2VyIG5hbWUpIGlmIGNyZWRlbnRpYWxzIGFyZSByZXF1aXJlZCB0byBhdXRoZW50aWNhdGUgd2l0aCB0aGUgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS1hY2Nlc3NrZXlcbiAgICAgKi9cbiAgICByZWFkb25seSBhY2Nlc3NLZXk/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIG5hbWUgb2YgdGhlIG9iamVjdCBzdG9yYWdlIGJ1Y2tldCBpbnZvbHZlZCBpbiB0aGUgdHJhbnNmZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLWJ1Y2tldG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBidWNrZXROYW1lPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBzZWNyZXQga2V5IChmb3IgZXhhbXBsZSwgYSBwYXNzd29yZCkgaWYgY3JlZGVudGlhbHMgYXJlIHJlcXVpcmVkIHRvIGF1dGhlbnRpY2F0ZSB3aXRoIHRoZSBvYmplY3Qgc3RvcmFnZSBzZXJ2ZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXNlY3JldGtleVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3JldEtleT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBhIGNlcnRpZmljYXRlIHRvIGF1dGhlbnRpY2F0ZSB3aXRoIGFuIG9iamVjdCBzdG9yYWdlIHN5c3RlbSB0aGF0IHVzZXMgYSBwcml2YXRlIG9yIHNlbGYtc2lnbmVkIGNlcnRpZmljYXRlIGF1dGhvcml0eSAoQ0EpLiBZb3UgbXVzdCBzcGVjaWZ5IGEgQmFzZTY0LWVuY29kZWQgYC5wZW1gIGZpbGUgKGZvciBleGFtcGxlLCBgZmlsZTovLy9ob21lL3VzZXIvLnNzaC9zdG9yYWdlX3N5c19jZXJ0aWZpY2F0ZS5wZW1gICkuIFRoZSBjZXJ0aWZpY2F0ZSBjYW4gYmUgdXAgdG8gMzI3NjggYnl0ZXMgKGJlZm9yZSBCYXNlNjQgZW5jb2RpbmcpLlxuICAgICAqXG4gICAgICogVG8gdXNlIHRoaXMgcGFyYW1ldGVyLCBjb25maWd1cmUgYFNlcnZlclByb3RvY29sYCB0byBgSFRUUFNgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2Utc2VydmVyY2VydGlmaWNhdGVcbiAgICAgKi9cbiAgICByZWFkb25seSBzZXJ2ZXJDZXJ0aWZpY2F0ZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgZG9tYWluIG5hbWUgb3IgSVAgYWRkcmVzcyBvZiB0aGUgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyLiBBIERhdGFTeW5jIGFnZW50IHVzZXMgdGhpcyBob3N0bmFtZSB0byBtb3VudCB0aGUgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyIGluIGEgbmV0d29yay5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2Utc2VydmVyaG9zdG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBzZXJ2ZXJIb3N0bmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgcG9ydCB0aGF0IHlvdXIgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyIGFjY2VwdHMgaW5ib3VuZCBuZXR3b3JrIHRyYWZmaWMgb24gKGZvciBleGFtcGxlLCBwb3J0IDQ0MykuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXNlcnZlcnBvcnRcbiAgICAgKi9cbiAgICByZWFkb25seSBzZXJ2ZXJQb3J0PzogbnVtYmVyO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBwcm90b2NvbCB0aGF0IHlvdXIgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyIHVzZXMgdG8gY29tbXVuaWNhdGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXNlcnZlcnByb3RvY29sXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmVyUHJvdG9jb2w/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIG9iamVjdCBwcmVmaXggZm9yIHlvdXIgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyLiBJZiB0aGlzIGlzIGEgc291cmNlIGxvY2F0aW9uLCBEYXRhU3luYyBvbmx5IGNvcGllcyBvYmplY3RzIHdpdGggdGhpcyBwcmVmaXguIElmIHRoaXMgaXMgYSBkZXN0aW5hdGlvbiBsb2NhdGlvbiwgRGF0YVN5bmMgd3JpdGVzIGFsbCBvYmplY3RzIHdpdGggdGhpcyBwcmVmaXguXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN1YmRpcmVjdG9yeT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUga2V5LXZhbHVlIHBhaXIgdGhhdCByZXByZXNlbnRzIGEgdGFnIHRoYXQgeW91IHdhbnQgdG8gYWRkIHRvIHRoZSByZXNvdXJjZS4gVGFncyBjYW4gaGVscCB5b3UgbWFuYWdlLCBmaWx0ZXIsIGFuZCBzZWFyY2ggZm9yIHlvdXIgcmVzb3VyY2VzLiBXZSByZWNvbW1lbmQgY3JlYXRpbmcgYSBuYW1lIHRhZyBmb3IgeW91ciBsb2NhdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UtdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuTG9jYXRpb25PYmplY3RTdG9yYWdlUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWNjZXNzS2V5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmFjY2Vzc0tleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWdlbnRBcm5zJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmFnZW50QXJucykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYWdlbnRBcm5zJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5hZ2VudEFybnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2J1Y2tldE5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYnVja2V0TmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjcmV0S2V5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNlY3JldEtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VydmVyQ2VydGlmaWNhdGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2VydmVyQ2VydGlmaWNhdGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlcnZlckhvc3RuYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNlcnZlckhvc3RuYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZXJ2ZXJQb3J0JywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnNlcnZlclBvcnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlcnZlclByb3RvY29sJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNlcnZlclByb3RvY29sKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzdWJkaXJlY3RvcnknLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0YWdzJywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlQ2ZuVGFnKSkocHJvcGVydGllcy50YWdzKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkNmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZVByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25PYmplY3RTdG9yYWdlYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvbk9iamVjdFN0b3JhZ2VQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uT2JqZWN0U3RvcmFnZWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Mb2NhdGlvbk9iamVjdFN0b3JhZ2VQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25PYmplY3RTdG9yYWdlUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEFnZW50QXJuczogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWdlbnRBcm5zKSxcbiAgICAgICAgQWNjZXNzS2V5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmFjY2Vzc0tleSksXG4gICAgICAgIEJ1Y2tldE5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYnVja2V0TmFtZSksXG4gICAgICAgIFNlY3JldEtleTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zZWNyZXRLZXkpLFxuICAgICAgICBTZXJ2ZXJDZXJ0aWZpY2F0ZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zZXJ2ZXJDZXJ0aWZpY2F0ZSksXG4gICAgICAgIFNlcnZlckhvc3RuYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNlcnZlckhvc3RuYW1lKSxcbiAgICAgICAgU2VydmVyUG9ydDogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zZXJ2ZXJQb3J0KSxcbiAgICAgICAgU2VydmVyUHJvdG9jb2w6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2VydmVyUHJvdG9jb2wpLFxuICAgICAgICBTdWJkaXJlY3Rvcnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZVByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25PYmplY3RTdG9yYWdlUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZVByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWdlbnRBcm5zJywgJ0FnZW50QXJucycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BZ2VudEFybnMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2FjY2Vzc0tleScsICdBY2Nlc3NLZXknLCBwcm9wZXJ0aWVzLkFjY2Vzc0tleSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5BY2Nlc3NLZXkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2J1Y2tldE5hbWUnLCAnQnVja2V0TmFtZScsIHByb3BlcnRpZXMuQnVja2V0TmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5CdWNrZXROYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZWNyZXRLZXknLCAnU2VjcmV0S2V5JywgcHJvcGVydGllcy5TZWNyZXRLZXkgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU2VjcmV0S2V5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZXJ2ZXJDZXJ0aWZpY2F0ZScsICdTZXJ2ZXJDZXJ0aWZpY2F0ZScsIHByb3BlcnRpZXMuU2VydmVyQ2VydGlmaWNhdGUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU2VydmVyQ2VydGlmaWNhdGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NlcnZlckhvc3RuYW1lJywgJ1NlcnZlckhvc3RuYW1lJywgcHJvcGVydGllcy5TZXJ2ZXJIb3N0bmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TZXJ2ZXJIb3N0bmFtZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2VydmVyUG9ydCcsICdTZXJ2ZXJQb3J0JywgcHJvcGVydGllcy5TZXJ2ZXJQb3J0ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldE51bWJlcihwcm9wZXJ0aWVzLlNlcnZlclBvcnQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NlcnZlclByb3RvY29sJywgJ1NlcnZlclByb3RvY29sJywgcHJvcGVydGllcy5TZXJ2ZXJQcm90b2NvbCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TZXJ2ZXJQcm90b2NvbCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3ViZGlyZWN0b3J5JywgJ1N1YmRpcmVjdG9yeScsIHByb3BlcnRpZXMuU3ViZGlyZWN0b3J5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFncycsICdUYWdzJywgcHJvcGVydGllcy5UYWdzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Q2ZuVGFnKShwcm9wZXJ0aWVzLlRhZ3MpIDogdW5kZWZpbmVkIGFzIGFueSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25PYmplY3RTdG9yYWdlYFxuICpcbiAqIFRoZSBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25PYmplY3RTdG9yYWdlYCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gZW5kcG9pbnQgZm9yIGEgc2VsZi1tYW5hZ2VkIG9iamVjdCBzdG9yYWdlIGJ1Y2tldC4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgc2VsZi1tYW5hZ2VkIG9iamVjdCBzdG9yYWdlIGxvY2F0aW9ucywgc2VlIFtDcmVhdGluZyBhIExvY2F0aW9uIGZvciBPYmplY3QgU3RvcmFnZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLW9iamVjdC1sb2NhdGlvbi5odG1sKSAuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25PYmplY3RTdG9yYWdlXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZSBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvbk9iamVjdFN0b3JhZ2VcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZSB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTG9jYXRpb25PYmplY3RTdG9yYWdlUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZShzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIHNwZWNpZmllZCBvYmplY3Qgc3RvcmFnZSBsb2NhdGlvbi5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgTG9jYXRpb25Bcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxvY2F0aW9uQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgVVJJIG9mIHRoZSBzcGVjaWZpZWQgb2JqZWN0IHN0b3JhZ2UgbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uVXJpXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvblVyaTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZXMgKEFSTnMpIG9mIHRoZSBEYXRhU3luYyBhZ2VudHMgdGhhdCBjYW4gc2VjdXJlbHkgY29ubmVjdCB3aXRoIHlvdXIgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLWFnZW50YXJuc1xuICAgICAqL1xuICAgIHB1YmxpYyBhZ2VudEFybnM6IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBhY2Nlc3Mga2V5IChmb3IgZXhhbXBsZSwgYSB1c2VyIG5hbWUpIGlmIGNyZWRlbnRpYWxzIGFyZSByZXF1aXJlZCB0byBhdXRoZW50aWNhdGUgd2l0aCB0aGUgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS1hY2Nlc3NrZXlcbiAgICAgKi9cbiAgICBwdWJsaWMgYWNjZXNzS2V5OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIG5hbWUgb2YgdGhlIG9iamVjdCBzdG9yYWdlIGJ1Y2tldCBpbnZvbHZlZCBpbiB0aGUgdHJhbnNmZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLWJ1Y2tldG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgYnVja2V0TmFtZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBzZWNyZXQga2V5IChmb3IgZXhhbXBsZSwgYSBwYXNzd29yZCkgaWYgY3JlZGVudGlhbHMgYXJlIHJlcXVpcmVkIHRvIGF1dGhlbnRpY2F0ZSB3aXRoIHRoZSBvYmplY3Qgc3RvcmFnZSBzZXJ2ZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXNlY3JldGtleVxuICAgICAqL1xuICAgIHB1YmxpYyBzZWNyZXRLZXk6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBhIGNlcnRpZmljYXRlIHRvIGF1dGhlbnRpY2F0ZSB3aXRoIGFuIG9iamVjdCBzdG9yYWdlIHN5c3RlbSB0aGF0IHVzZXMgYSBwcml2YXRlIG9yIHNlbGYtc2lnbmVkIGNlcnRpZmljYXRlIGF1dGhvcml0eSAoQ0EpLiBZb3UgbXVzdCBzcGVjaWZ5IGEgQmFzZTY0LWVuY29kZWQgYC5wZW1gIGZpbGUgKGZvciBleGFtcGxlLCBgZmlsZTovLy9ob21lL3VzZXIvLnNzaC9zdG9yYWdlX3N5c19jZXJ0aWZpY2F0ZS5wZW1gICkuIFRoZSBjZXJ0aWZpY2F0ZSBjYW4gYmUgdXAgdG8gMzI3NjggYnl0ZXMgKGJlZm9yZSBCYXNlNjQgZW5jb2RpbmcpLlxuICAgICAqXG4gICAgICogVG8gdXNlIHRoaXMgcGFyYW1ldGVyLCBjb25maWd1cmUgYFNlcnZlclByb3RvY29sYCB0byBgSFRUUFNgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2Utc2VydmVyY2VydGlmaWNhdGVcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VydmVyQ2VydGlmaWNhdGU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgZG9tYWluIG5hbWUgb3IgSVAgYWRkcmVzcyBvZiB0aGUgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyLiBBIERhdGFTeW5jIGFnZW50IHVzZXMgdGhpcyBob3N0bmFtZSB0byBtb3VudCB0aGUgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyIGluIGEgbmV0d29yay5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2Utc2VydmVyaG9zdG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VydmVySG9zdG5hbWU6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgcG9ydCB0aGF0IHlvdXIgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyIGFjY2VwdHMgaW5ib3VuZCBuZXR3b3JrIHRyYWZmaWMgb24gKGZvciBleGFtcGxlLCBwb3J0IDQ0MykuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXNlcnZlcnBvcnRcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VydmVyUG9ydDogbnVtYmVyIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBwcm90b2NvbCB0aGF0IHlvdXIgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyIHVzZXMgdG8gY29tbXVuaWNhdGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXNlcnZlcnByb3RvY29sXG4gICAgICovXG4gICAgcHVibGljIHNlcnZlclByb3RvY29sOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIG9iamVjdCBwcmVmaXggZm9yIHlvdXIgb2JqZWN0IHN0b3JhZ2Ugc2VydmVyLiBJZiB0aGlzIGlzIGEgc291cmNlIGxvY2F0aW9uLCBEYXRhU3luYyBvbmx5IGNvcGllcyBvYmplY3RzIHdpdGggdGhpcyBwcmVmaXguIElmIHRoaXMgaXMgYSBkZXN0aW5hdGlvbiBsb2NhdGlvbiwgRGF0YVN5bmMgd3JpdGVzIGFsbCBvYmplY3RzIHdpdGggdGhpcyBwcmVmaXguXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25vYmplY3RzdG9yYWdlLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHB1YmxpYyBzdWJkaXJlY3Rvcnk6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUga2V5LXZhbHVlIHBhaXIgdGhhdCByZXByZXNlbnRzIGEgdGFnIHRoYXQgeW91IHdhbnQgdG8gYWRkIHRvIHRoZSByZXNvdXJjZS4gVGFncyBjYW4gaGVscCB5b3UgbWFuYWdlLCBmaWx0ZXIsIGFuZCBzZWFyY2ggZm9yIHlvdXIgcmVzb3VyY2VzLiBXZSByZWNvbW1lbmQgY3JlYXRpbmcgYSBuYW1lIHRhZyBmb3IgeW91ciBsb2NhdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9ub2JqZWN0c3RvcmFnZS5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbm9iamVjdHN0b3JhZ2UtdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB0YWdzOiBjZGsuVGFnTWFuYWdlcjtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25PYmplY3RTdG9yYWdlYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5Mb2NhdGlvbk9iamVjdFN0b3JhZ2VQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuTG9jYXRpb25PYmplY3RTdG9yYWdlLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnYWdlbnRBcm5zJywgdGhpcyk7XG4gICAgICAgIHRoaXMuYXR0ckxvY2F0aW9uQXJuID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdMb2NhdGlvbkFybicpKTtcbiAgICAgICAgdGhpcy5hdHRyTG9jYXRpb25VcmkgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0xvY2F0aW9uVXJpJykpO1xuXG4gICAgICAgIHRoaXMuYWdlbnRBcm5zID0gcHJvcHMuYWdlbnRBcm5zO1xuICAgICAgICB0aGlzLmFjY2Vzc0tleSA9IHByb3BzLmFjY2Vzc0tleTtcbiAgICAgICAgdGhpcy5idWNrZXROYW1lID0gcHJvcHMuYnVja2V0TmFtZTtcbiAgICAgICAgdGhpcy5zZWNyZXRLZXkgPSBwcm9wcy5zZWNyZXRLZXk7XG4gICAgICAgIHRoaXMuc2VydmVyQ2VydGlmaWNhdGUgPSBwcm9wcy5zZXJ2ZXJDZXJ0aWZpY2F0ZTtcbiAgICAgICAgdGhpcy5zZXJ2ZXJIb3N0bmFtZSA9IHByb3BzLnNlcnZlckhvc3RuYW1lO1xuICAgICAgICB0aGlzLnNlcnZlclBvcnQgPSBwcm9wcy5zZXJ2ZXJQb3J0O1xuICAgICAgICB0aGlzLnNlcnZlclByb3RvY29sID0gcHJvcHMuc2VydmVyUHJvdG9jb2w7XG4gICAgICAgIHRoaXMuc3ViZGlyZWN0b3J5ID0gcHJvcHMuc3ViZGlyZWN0b3J5O1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25PYmplY3RTdG9yYWdlXCIsIHByb3BzLnRhZ3MsIHsgdGFnUHJvcGVydHlOYW1lOiAndGFncycgfSk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5Mb2NhdGlvbk9iamVjdFN0b3JhZ2UuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFnZW50QXJuczogdGhpcy5hZ2VudEFybnMsXG4gICAgICAgICAgICBhY2Nlc3NLZXk6IHRoaXMuYWNjZXNzS2V5LFxuICAgICAgICAgICAgYnVja2V0TmFtZTogdGhpcy5idWNrZXROYW1lLFxuICAgICAgICAgICAgc2VjcmV0S2V5OiB0aGlzLnNlY3JldEtleSxcbiAgICAgICAgICAgIHNlcnZlckNlcnRpZmljYXRlOiB0aGlzLnNlcnZlckNlcnRpZmljYXRlLFxuICAgICAgICAgICAgc2VydmVySG9zdG5hbWU6IHRoaXMuc2VydmVySG9zdG5hbWUsXG4gICAgICAgICAgICBzZXJ2ZXJQb3J0OiB0aGlzLnNlcnZlclBvcnQsXG4gICAgICAgICAgICBzZXJ2ZXJQcm90b2NvbDogdGhpcy5zZXJ2ZXJQcm90b2NvbCxcbiAgICAgICAgICAgIHN1YmRpcmVjdG9yeTogdGhpcy5zdWJkaXJlY3RvcnksXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MucmVuZGVyVGFncygpLFxuICAgICAgICB9O1xuICAgIH1cblxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIGNmbkxvY2F0aW9uT2JqZWN0U3RvcmFnZVByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkxvY2F0aW9uUzNgXG4gKlxuICogQHN0cnVjdFxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uczMuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkxvY2F0aW9uUzNQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIEFXUyBJZGVudGl0eSBhbmQgQWNjZXNzIE1hbmFnZW1lbnQgKElBTSkgcm9sZSB0aGF0IGlzIHVzZWQgdG8gYWNjZXNzIGFuIEFtYXpvbiBTMyBidWNrZXQuXG4gICAgICpcbiAgICAgKiBGb3IgZGV0YWlsZWQgaW5mb3JtYXRpb24gYWJvdXQgdXNpbmcgc3VjaCBhIHJvbGUsIHNlZSBbQ3JlYXRpbmcgYSBMb2NhdGlvbiBmb3IgQW1hem9uIFMzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS93b3JraW5nLXdpdGgtbG9jYXRpb25zLmh0bWwjY3JlYXRlLXMzLWxvY2F0aW9uKSBpbiB0aGUgKkFXUyBEYXRhU3luYyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbnMzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uczMtczNjb25maWdcbiAgICAgKi9cbiAgICByZWFkb25seSBzM0NvbmZpZzogQ2ZuTG9jYXRpb25TMy5TM0NvbmZpZ1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFSTiBvZiB0aGUgQW1hem9uIFMzIGJ1Y2tldC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uczMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zMy1zM2J1Y2tldGFyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHMzQnVja2V0QXJuPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBTMyBzdG9yYWdlIGNsYXNzIHRoYXQgeW91IHdhbnQgdG8gc3RvcmUgeW91ciBmaWxlcyBpbiB3aGVuIHRoaXMgbG9jYXRpb24gaXMgdXNlZCBhcyBhIHRhc2sgZGVzdGluYXRpb24uIEZvciBidWNrZXRzIGluIEFXUyBSZWdpb25zICwgdGhlIHN0b3JhZ2UgY2xhc3MgZGVmYXVsdHMgdG8gUzMgU3RhbmRhcmQuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBTMyBzdG9yYWdlIGNsYXNzZXMsIHNlZSBbQW1hem9uIFMzIFN0b3JhZ2UgQ2xhc3Nlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3MzL3N0b3JhZ2UtY2xhc3Nlcy8pIC4gU29tZSBzdG9yYWdlIGNsYXNzZXMgaGF2ZSBiZWhhdmlvcnMgdGhhdCBjYW4gYWZmZWN0IHlvdXIgUzMgc3RvcmFnZSBjb3N0cy4gRm9yIGRldGFpbGVkIGluZm9ybWF0aW9uLCBzZWUgW0NvbnNpZGVyYXRpb25zIFdoZW4gV29ya2luZyB3aXRoIEFtYXpvbiBTMyBTdG9yYWdlIENsYXNzZXMgaW4gRGF0YVN5bmNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2NyZWF0ZS1zMy1sb2NhdGlvbi5odG1sI3VzaW5nLXN0b3JhZ2UtY2xhc3NlcykgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zMy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnMzLXMzc3RvcmFnZWNsYXNzXG4gICAgICovXG4gICAgcmVhZG9ubHkgczNTdG9yYWdlQ2xhc3M/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIHN1YmRpcmVjdG9yeSBpbiB0aGUgQW1hem9uIFMzIGJ1Y2tldC4gVGhpcyBzdWJkaXJlY3RvcnkgaW4gQW1hem9uIFMzIGlzIHVzZWQgdG8gcmVhZCBkYXRhIGZyb20gdGhlIFMzIHNvdXJjZSBsb2NhdGlvbiBvciB3cml0ZSBkYXRhIHRvIHRoZSBTMyBkZXN0aW5hdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uczMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zMy1zdWJkaXJlY3RvcnlcbiAgICAgKi9cbiAgICByZWFkb25seSBzdWJkaXJlY3Rvcnk/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUga2V5LXZhbHVlIHBhaXIgdGhhdCByZXByZXNlbnRzIHRoZSB0YWcgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIGxvY2F0aW9uLiBUaGUgdmFsdWUgY2FuIGJlIGFuIGVtcHR5IHN0cmluZy4gV2UgcmVjb21tZW5kIHVzaW5nIHRhZ3MgdG8gbmFtZSB5b3VyIHJlc291cmNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uczMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zMy10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IGNkay5DZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5Mb2NhdGlvblMzUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkxvY2F0aW9uUzNQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Mb2NhdGlvblMzUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzM0J1Y2tldEFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zM0J1Y2tldEFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignczNDb25maWcnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuczNDb25maWcpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3MzQ29uZmlnJywgQ2ZuTG9jYXRpb25TM19TM0NvbmZpZ1Byb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnMzQ29uZmlnKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzM1N0b3JhZ2VDbGFzcycsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zM1N0b3JhZ2VDbGFzcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc3ViZGlyZWN0b3J5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnN1YmRpcmVjdG9yeSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZUNmblRhZykpKHByb3BlcnRpZXMudGFncykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5Mb2NhdGlvblMzUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblMzYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvblMzUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblMzYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uUzNQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25TM1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBTM0NvbmZpZzogY2ZuTG9jYXRpb25TM1MzQ29uZmlnUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuczNDb25maWcpLFxuICAgICAgICBTM0J1Y2tldEFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zM0J1Y2tldEFybiksXG4gICAgICAgIFMzU3RvcmFnZUNsYXNzOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnMzU3RvcmFnZUNsYXNzKSxcbiAgICAgICAgU3ViZGlyZWN0b3J5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnN1YmRpcmVjdG9yeSksXG4gICAgICAgIFRhZ3M6IGNkay5saXN0TWFwcGVyKGNkay5jZm5UYWdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLnRhZ3MpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Mb2NhdGlvblMzUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvblMzUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uUzNQcm9wcz4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3MzQ29uZmlnJywgJ1MzQ29uZmlnJywgQ2ZuTG9jYXRpb25TM1MzQ29uZmlnUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5TM0NvbmZpZykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnczNCdWNrZXRBcm4nLCAnUzNCdWNrZXRBcm4nLCBwcm9wZXJ0aWVzLlMzQnVja2V0QXJuICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlMzQnVja2V0QXJuKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzM1N0b3JhZ2VDbGFzcycsICdTM1N0b3JhZ2VDbGFzcycsIHByb3BlcnRpZXMuUzNTdG9yYWdlQ2xhc3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUzNTdG9yYWdlQ2xhc3MpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3N1YmRpcmVjdG9yeScsICdTdWJkaXJlY3RvcnknLCBwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TdWJkaXJlY3RvcnkpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uUzNgXG4gKlxuICogVGhlIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblMzYCByZXNvdXJjZSBzcGVjaWZpZXMgYW4gZW5kcG9pbnQgZm9yIGFuIEFtYXpvbiBTMyBidWNrZXQuXG4gKlxuICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbQ3JlYXRlIGFuIEFtYXpvbiBTMyBsb2NhdGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLWxvY2F0aW9ucy1jbGkuaHRtbCNjcmVhdGUtbG9jYXRpb24tczMtY2xpKSBpbiB0aGUgKkFXUyBEYXRhU3luYyBVc2VyIEd1aWRlKiAuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25TM1xuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uczMuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuTG9jYXRpb25TMyBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblMzXCI7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5Mb2NhdGlvblMzIHtcbiAgICAgICAgcmVzb3VyY2VBdHRyaWJ1dGVzID0gcmVzb3VyY2VBdHRyaWJ1dGVzIHx8IHt9O1xuICAgICAgICBjb25zdCByZXNvdXJjZVByb3BlcnRpZXMgPSBvcHRpb25zLnBhcnNlci5wYXJzZVZhbHVlKHJlc291cmNlQXR0cmlidXRlcy5Qcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcHJvcHNSZXN1bHQgPSBDZm5Mb2NhdGlvblMzUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkxvY2F0aW9uUzMoc2NvcGUsIGlkLCBwcm9wc1Jlc3VsdC52YWx1ZSk7XG4gICAgICAgIGZvciAoY29uc3QgW3Byb3BLZXksIHByb3BWYWxdIG9mIE9iamVjdC5lbnRyaWVzKHByb3BzUmVzdWx0LmV4dHJhUHJvcGVydGllcykpICB7XG4gICAgICAgICAgICByZXQuYWRkUHJvcGVydHlPdmVycmlkZShwcm9wS2V5LCBwcm9wVmFsKTtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBzcGVjaWZpZWQgQW1hem9uIFMzIGxvY2F0aW9uLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBMb2NhdGlvbkFyblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTG9jYXRpb25Bcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBVUkkgb2YgdGhlIHNwZWNpZmllZCBBbWF6b24gUzMgbG9jYXRpb24uXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIExvY2F0aW9uVXJpXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJMb2NhdGlvblVyaTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBBV1MgSWRlbnRpdHkgYW5kIEFjY2VzcyBNYW5hZ2VtZW50IChJQU0pIHJvbGUgdGhhdCBpcyB1c2VkIHRvIGFjY2VzcyBhbiBBbWF6b24gUzMgYnVja2V0LlxuICAgICAqXG4gICAgICogRm9yIGRldGFpbGVkIGluZm9ybWF0aW9uIGFib3V0IHVzaW5nIHN1Y2ggYSByb2xlLCBzZWUgW0NyZWF0aW5nIGEgTG9jYXRpb24gZm9yIEFtYXpvbiBTM10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvd29ya2luZy13aXRoLWxvY2F0aW9ucy5odG1sI2NyZWF0ZS1zMy1sb2NhdGlvbikgaW4gdGhlICpBV1MgRGF0YVN5bmMgVXNlciBHdWlkZSogLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zMy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnMzLXMzY29uZmlnXG4gICAgICovXG4gICAgcHVibGljIHMzQ29uZmlnOiBDZm5Mb2NhdGlvblMzLlMzQ29uZmlnUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQVJOIG9mIHRoZSBBbWF6b24gUzMgYnVja2V0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zMy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnMzLXMzYnVja2V0YXJuXG4gICAgICovXG4gICAgcHVibGljIHMzQnVja2V0QXJuOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFMzIHN0b3JhZ2UgY2xhc3MgdGhhdCB5b3Ugd2FudCB0byBzdG9yZSB5b3VyIGZpbGVzIGluIHdoZW4gdGhpcyBsb2NhdGlvbiBpcyB1c2VkIGFzIGEgdGFzayBkZXN0aW5hdGlvbi4gRm9yIGJ1Y2tldHMgaW4gQVdTIFJlZ2lvbnMgLCB0aGUgc3RvcmFnZSBjbGFzcyBkZWZhdWx0cyB0byBTMyBTdGFuZGFyZC5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IFMzIHN0b3JhZ2UgY2xhc3Nlcywgc2VlIFtBbWF6b24gUzMgU3RvcmFnZSBDbGFzc2VzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vczMvc3RvcmFnZS1jbGFzc2VzLykgLiBTb21lIHN0b3JhZ2UgY2xhc3NlcyBoYXZlIGJlaGF2aW9ycyB0aGF0IGNhbiBhZmZlY3QgeW91ciBTMyBzdG9yYWdlIGNvc3RzLiBGb3IgZGV0YWlsZWQgaW5mb3JtYXRpb24sIHNlZSBbQ29uc2lkZXJhdGlvbnMgV2hlbiBXb3JraW5nIHdpdGggQW1hem9uIFMzIFN0b3JhZ2UgQ2xhc3NlcyBpbiBEYXRhU3luY10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLXMzLWxvY2F0aW9uLmh0bWwjdXNpbmctc3RvcmFnZS1jbGFzc2VzKSAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbnMzLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uczMtczNzdG9yYWdlY2xhc3NcbiAgICAgKi9cbiAgICBwdWJsaWMgczNTdG9yYWdlQ2xhc3M6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEEgc3ViZGlyZWN0b3J5IGluIHRoZSBBbWF6b24gUzMgYnVja2V0LiBUaGlzIHN1YmRpcmVjdG9yeSBpbiBBbWF6b24gUzMgaXMgdXNlZCB0byByZWFkIGRhdGEgZnJvbSB0aGUgUzMgc291cmNlIGxvY2F0aW9uIG9yIHdyaXRlIGRhdGEgdG8gdGhlIFMzIGRlc3RpbmF0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zMy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnMzLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHB1YmxpYyBzdWJkaXJlY3Rvcnk6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBrZXktdmFsdWUgcGFpciB0aGF0IHJlcHJlc2VudHMgdGhlIHRhZyB0aGF0IHlvdSB3YW50IHRvIGFkZCB0byB0aGUgbG9jYXRpb24uIFRoZSB2YWx1ZSBjYW4gYmUgYW4gZW1wdHkgc3RyaW5nLiBXZSByZWNvbW1lbmQgdXNpbmcgdGFncyB0byBuYW1lIHlvdXIgcmVzb3VyY2VzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zMy5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnMzLXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgdGFnczogY2RrLlRhZ01hbmFnZXI7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uUzNgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkxvY2F0aW9uUzNQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuTG9jYXRpb25TMy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3MzQ29uZmlnJywgdGhpcyk7XG4gICAgICAgIHRoaXMuYXR0ckxvY2F0aW9uQXJuID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdMb2NhdGlvbkFybicpKTtcbiAgICAgICAgdGhpcy5hdHRyTG9jYXRpb25VcmkgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0xvY2F0aW9uVXJpJykpO1xuXG4gICAgICAgIHRoaXMuczNDb25maWcgPSBwcm9wcy5zM0NvbmZpZztcbiAgICAgICAgdGhpcy5zM0J1Y2tldEFybiA9IHByb3BzLnMzQnVja2V0QXJuO1xuICAgICAgICB0aGlzLnMzU3RvcmFnZUNsYXNzID0gcHJvcHMuczNTdG9yYWdlQ2xhc3M7XG4gICAgICAgIHRoaXMuc3ViZGlyZWN0b3J5ID0gcHJvcHMuc3ViZGlyZWN0b3J5O1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25TM1wiLCBwcm9wcy50YWdzLCB7IHRhZ1Byb3BlcnR5TmFtZTogJ3RhZ3MnIH0pO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuTG9jYXRpb25TMy5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgczNDb25maWc6IHRoaXMuczNDb25maWcsXG4gICAgICAgICAgICBzM0J1Y2tldEFybjogdGhpcy5zM0J1Y2tldEFybixcbiAgICAgICAgICAgIHMzU3RvcmFnZUNsYXNzOiB0aGlzLnMzU3RvcmFnZUNsYXNzLFxuICAgICAgICAgICAgc3ViZGlyZWN0b3J5OiB0aGlzLnN1YmRpcmVjdG9yeSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuTG9jYXRpb25TM1Byb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmbkxvY2F0aW9uUzMge1xuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgQVdTIElkZW50aXR5IGFuZCBBY2Nlc3MgTWFuYWdlbWVudCAoSUFNKSByb2xlIHVzZWQgdG8gYWNjZXNzIGFuIEFtYXpvbiBTMyBidWNrZXQuXG4gICAgICpcbiAgICAgKiBGb3IgZGV0YWlsZWQgaW5mb3JtYXRpb24gYWJvdXQgdXNpbmcgc3VjaCBhIHJvbGUsIHNlZSBbQ3JlYXRpbmcgYSBMb2NhdGlvbiBmb3IgQW1hem9uIFMzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS93b3JraW5nLXdpdGgtbG9jYXRpb25zLmh0bWwjY3JlYXRlLXMzLWxvY2F0aW9uKSBpbiB0aGUgKkFXUyBEYXRhU3luYyBVc2VyIEd1aWRlKiAuXG4gICAgICpcbiAgICAgKiBAc3RydWN0XG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbnMzLXMzY29uZmlnLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFMzQ29uZmlnUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIEFSTiBvZiB0aGUgSUFNIHJvbGUgZm9yIGFjY2Vzc2luZyB0aGUgUzMgYnVja2V0LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uczMtczNjb25maWcuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zMy1zM2NvbmZpZy1idWNrZXRhY2Nlc3Nyb2xlYXJuXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBidWNrZXRBY2Nlc3NSb2xlQXJuOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFMzQ29uZmlnUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFMzQ29uZmlnUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25TM19TM0NvbmZpZ1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignYnVja2V0QWNjZXNzUm9sZUFybicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5idWNrZXRBY2Nlc3NSb2xlQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdidWNrZXRBY2Nlc3NSb2xlQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmJ1Y2tldEFjY2Vzc1JvbGVBcm4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUzNDb25maWdQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uUzMuUzNDb25maWdgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFMzQ29uZmlnUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblMzLlMzQ29uZmlnYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbkxvY2F0aW9uUzNTM0NvbmZpZ1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Mb2NhdGlvblMzX1MzQ29uZmlnUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEJ1Y2tldEFjY2Vzc1JvbGVBcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYnVja2V0QWNjZXNzUm9sZUFybiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uUzNTM0NvbmZpZ1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTG9jYXRpb25TMy5TM0NvbmZpZ1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkxvY2F0aW9uUzMuUzNDb25maWdQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2J1Y2tldEFjY2Vzc1JvbGVBcm4nLCAnQnVja2V0QWNjZXNzUm9sZUFybicsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuQnVja2V0QWNjZXNzUm9sZUFybikpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkxvY2F0aW9uU01CYFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbnNtYi5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuTG9jYXRpb25TTUJQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWVzIChBUk5zKSBvZiBhZ2VudHMgdG8gdXNlIGZvciBhIFNlcnZlciBNZXNzYWdlIEJsb2NrIChTTUIpIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zbWIuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zbWItYWdlbnRhcm5zXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWdlbnRBcm5zOiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIFRoZSB1c2VyIHdobyBjYW4gbW91bnQgdGhlIHNoYXJlIGFuZCBoYXMgdGhlIHBlcm1pc3Npb25zIHRvIGFjY2VzcyBmaWxlcyBhbmQgZm9sZGVycyBpbiB0aGUgU01CIHNoYXJlLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IGNob29zaW5nIGEgdXNlciBuYW1lIHRoYXQgZW5zdXJlcyBzdWZmaWNpZW50IHBlcm1pc3Npb25zIHRvIGZpbGVzLCBmb2xkZXJzLCBhbmQgbWV0YWRhdGEsIHNlZSBbdXNlcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLXNtYi1sb2NhdGlvbi5odG1sI1NNQnVzZXIpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLXVzZXJcbiAgICAgKi9cbiAgICByZWFkb25seSB1c2VyOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIFdpbmRvd3MgZG9tYWluIG5hbWUgdGhhdCB5b3VyIFNNQiBmaWxlIHNlcnZlciBiZWxvbmdzIHRvLlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbcmVxdWlyZWQgcGVybWlzc2lvbnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL2NyZWF0ZS1zbWItbG9jYXRpb24uaHRtbCNjb25maWd1cmluZy1zbWItcGVybWlzc2lvbnMpIGZvciBTTUIgbG9jYXRpb25zLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zbWIuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zbWItZG9tYWluXG4gICAgICovXG4gICAgcmVhZG9ubHkgZG9tYWluPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSB2ZXJzaW9uIG9mIHRoZSBTTUIgcHJvdG9jb2wgdGhhdCBEYXRhU3luYyB1c2VzIHRvIGFjY2VzcyB5b3VyIFNNQiBmaWxlIHNlcnZlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLW1vdW50b3B0aW9uc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IG1vdW50T3B0aW9ucz86IENmbkxvY2F0aW9uU01CLk1vdW50T3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHBhc3N3b3JkIG9mIHRoZSB1c2VyIHdobyBjYW4gbW91bnQgdGhlIHNoYXJlIGFuZCBoYXMgdGhlIHBlcm1pc3Npb25zIHRvIGFjY2VzcyBmaWxlcyBhbmQgZm9sZGVycyBpbiB0aGUgU01CIHNoYXJlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zbWIuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zbWItcGFzc3dvcmRcbiAgICAgKi9cbiAgICByZWFkb25seSBwYXNzd29yZD86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgRG9tYWluIE5hbWUgU2VydmljZSAoRE5TKSBuYW1lIG9yIElQIGFkZHJlc3Mgb2YgdGhlIFNNQiBmaWxlIHNlcnZlciB0aGF0IHlvdXIgRGF0YVN5bmMgYWdlbnQgd2lsbCBtb3VudC5cbiAgICAgKlxuICAgICAqID4gWW91IGNhbid0IHNwZWNpZnkgYW4gSVAgdmVyc2lvbiA2IChJUHY2KSBhZGRyZXNzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zbWIuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zbWItc2VydmVyaG9zdG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBzZXJ2ZXJIb3N0bmFtZT86IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBzdWJkaXJlY3RvcnkgaW4gdGhlIFNNQiBmaWxlIHN5c3RlbSB0aGF0IGlzIHVzZWQgdG8gcmVhZCBkYXRhIGZyb20gdGhlIFNNQiBzb3VyY2UgbG9jYXRpb24gb3Igd3JpdGUgZGF0YSB0byB0aGUgU01CIGRlc3RpbmF0aW9uLiBUaGUgU01CIHBhdGggc2hvdWxkIGJlIGEgcGF0aCB0aGF0J3MgZXhwb3J0ZWQgYnkgdGhlIFNNQiBzZXJ2ZXIsIG9yIGEgc3ViZGlyZWN0b3J5IG9mIHRoYXQgcGF0aC4gVGhlIHBhdGggc2hvdWxkIGJlIHN1Y2ggdGhhdCBpdCBjYW4gYmUgbW91bnRlZCBieSBvdGhlciBTTUIgY2xpZW50cyBpbiB5b3VyIG5ldHdvcmsuXG4gICAgICpcbiAgICAgKiA+IGBTdWJkaXJlY3RvcnlgIG11c3QgYmUgc3BlY2lmaWVkIHdpdGggZm9yd2FyZCBzbGFzaGVzLiBGb3IgZXhhbXBsZSwgYC9wYXRoL3RvL2ZvbGRlcmAgLlxuICAgICAqXG4gICAgICogVG8gdHJhbnNmZXIgYWxsIHRoZSBkYXRhIGluIHRoZSBmb2xkZXIgeW91IHNwZWNpZmllZCwgRGF0YVN5bmMgbXVzdCBoYXZlIHBlcm1pc3Npb25zIHRvIG1vdW50IHRoZSBTTUIgc2hhcmUsIGFzIHdlbGwgYXMgdG8gYWNjZXNzIGFsbCB0aGUgZGF0YSBpbiB0aGF0IHNoYXJlLiBUbyBlbnN1cmUgdGhpcywgZWl0aGVyIG1ha2Ugc3VyZSB0aGF0IHRoZSB1c2VyIG5hbWUgYW5kIHBhc3N3b3JkIHNwZWNpZmllZCBiZWxvbmdzIHRvIHRoZSB1c2VyIHdobyBjYW4gbW91bnQgdGhlIHNoYXJlLCBhbmQgd2hvIGhhcyB0aGUgYXBwcm9wcmlhdGUgcGVybWlzc2lvbnMgZm9yIGFsbCBvZiB0aGUgZmlsZXMgYW5kIGRpcmVjdG9yaWVzIHRoYXQgeW91IHdhbnQgRGF0YVN5bmMgdG8gYWNjZXNzLCBvciB1c2UgY3JlZGVudGlhbHMgb2YgYSBtZW1iZXIgb2YgdGhlIEJhY2t1cCBPcGVyYXRvcnMgZ3JvdXAgdG8gbW91bnQgdGhlIHNoYXJlLiBEb2luZyBlaXRoZXIgb25lIGVuYWJsZXMgdGhlIGFnZW50IHRvIGFjY2VzcyB0aGUgZGF0YS4gRm9yIHRoZSBhZ2VudCB0byBhY2Nlc3MgZGlyZWN0b3JpZXMsIHlvdSBtdXN0IGFkZGl0aW9uYWxseSBlbmFibGUgYWxsIGV4ZWN1dGUgYWNjZXNzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtbG9jYXRpb25zbWIuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zbWItc3ViZGlyZWN0b3J5XG4gICAgICovXG4gICAgcmVhZG9ubHkgc3ViZGlyZWN0b3J5Pzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIGxhYmVscyB0aGF0IGhlbHAgeW91IGNhdGVnb3JpemUsIGZpbHRlciwgYW5kIHNlYXJjaCBmb3IgeW91ciBBV1MgcmVzb3VyY2VzLiBXZSByZWNvbW1lbmQgY3JlYXRpbmcgYXQgbGVhc3QgYSBuYW1lIHRhZyBmb3IgeW91ciBsb2NhdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogY2RrLkNmblRhZ1tdO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmbkxvY2F0aW9uU01CUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkxvY2F0aW9uU01CUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTG9jYXRpb25TTUJQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2FnZW50QXJucycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5hZ2VudEFybnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2FnZW50QXJucycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuYWdlbnRBcm5zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkb21haW4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZG9tYWluKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtb3VudE9wdGlvbnMnLCBDZm5Mb2NhdGlvblNNQl9Nb3VudE9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5tb3VudE9wdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Bhc3N3b3JkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnBhc3N3b3JkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzZXJ2ZXJIb3N0bmFtZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zZXJ2ZXJIb3N0bmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc3ViZGlyZWN0b3J5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnN1YmRpcmVjdG9yeSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZUNmblRhZykpKHByb3BlcnRpZXMudGFncykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndXNlcicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy51c2VyKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd1c2VyJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnVzZXIpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuTG9jYXRpb25TTUJQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uU01CYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Mb2NhdGlvblNNQlByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25TTUJgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25TTUJQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25TTUJQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQWdlbnRBcm5zOiBjZGsubGlzdE1hcHBlcihjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5hZ2VudEFybnMpLFxuICAgICAgICBVc2VyOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnVzZXIpLFxuICAgICAgICBEb21haW46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZG9tYWluKSxcbiAgICAgICAgTW91bnRPcHRpb25zOiBjZm5Mb2NhdGlvblNNQk1vdW50T3B0aW9uc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1vdW50T3B0aW9ucyksXG4gICAgICAgIFBhc3N3b3JkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBhc3N3b3JkKSxcbiAgICAgICAgU2VydmVySG9zdG5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2VydmVySG9zdG5hbWUpLFxuICAgICAgICBTdWJkaXJlY3Rvcnk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc3ViZGlyZWN0b3J5KSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uU01CUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvblNNQlByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvblNNQlByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYWdlbnRBcm5zJywgJ0FnZW50QXJucycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BZ2VudEFybnMpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3VzZXInLCAnVXNlcicsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVXNlcikpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZG9tYWluJywgJ0RvbWFpbicsIHByb3BlcnRpZXMuRG9tYWluICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkRvbWFpbikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbW91bnRPcHRpb25zJywgJ01vdW50T3B0aW9ucycsIHByb3BlcnRpZXMuTW91bnRPcHRpb25zICE9IG51bGwgPyBDZm5Mb2NhdGlvblNNQk1vdW50T3B0aW9uc1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTW91bnRPcHRpb25zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwYXNzd29yZCcsICdQYXNzd29yZCcsIHByb3BlcnRpZXMuUGFzc3dvcmQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUGFzc3dvcmQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NlcnZlckhvc3RuYW1lJywgJ1NlcnZlckhvc3RuYW1lJywgcHJvcGVydGllcy5TZXJ2ZXJIb3N0bmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TZXJ2ZXJIb3N0bmFtZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc3ViZGlyZWN0b3J5JywgJ1N1YmRpcmVjdG9yeScsIHByb3BlcnRpZXMuU3ViZGlyZWN0b3J5ICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlN1YmRpcmVjdG9yeSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGFncycsICdUYWdzJywgcHJvcGVydGllcy5UYWdzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Q2ZuVGFnKShwcm9wZXJ0aWVzLlRhZ3MpIDogdW5kZWZpbmVkIGFzIGFueSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25TTUJgXG4gKlxuICogVGhlIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblNNQmAgcmVzb3VyY2Ugc3BlY2lmaWVzIGEgU2VydmVyIE1lc3NhZ2UgQmxvY2sgKFNNQikgbG9jYXRpb24uXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpEYXRhU3luYzo6TG9jYXRpb25TTUJcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbnNtYi5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5Mb2NhdGlvblNNQiBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblNNQlwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTG9jYXRpb25TTUIge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkxvY2F0aW9uU01CUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmbkxvY2F0aW9uU01CKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgc3BlY2lmaWVkIFNNQiBmaWxlIHN5c3RlbS5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgTG9jYXRpb25Bcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxvY2F0aW9uQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgVVJJIG9mIHRoZSBzcGVjaWZpZWQgU01CIGxvY2F0aW9uLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBMb2NhdGlvblVyaVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTG9jYXRpb25Vcmk6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZXMgKEFSTnMpIG9mIGFnZW50cyB0byB1c2UgZm9yIGEgU2VydmVyIE1lc3NhZ2UgQmxvY2sgKFNNQikgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbnNtYi5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnNtYi1hZ2VudGFybnNcbiAgICAgKi9cbiAgICBwdWJsaWMgYWdlbnRBcm5zOiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIFRoZSB1c2VyIHdobyBjYW4gbW91bnQgdGhlIHNoYXJlIGFuZCBoYXMgdGhlIHBlcm1pc3Npb25zIHRvIGFjY2VzcyBmaWxlcyBhbmQgZm9sZGVycyBpbiB0aGUgU01CIHNoYXJlLlxuICAgICAqXG4gICAgICogRm9yIGluZm9ybWF0aW9uIGFib3V0IGNob29zaW5nIGEgdXNlciBuYW1lIHRoYXQgZW5zdXJlcyBzdWZmaWNpZW50IHBlcm1pc3Npb25zIHRvIGZpbGVzLCBmb2xkZXJzLCBhbmQgbWV0YWRhdGEsIHNlZSBbdXNlcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLXNtYi1sb2NhdGlvbi5odG1sI1NNQnVzZXIpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLXVzZXJcbiAgICAgKi9cbiAgICBwdWJsaWMgdXNlcjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBXaW5kb3dzIGRvbWFpbiBuYW1lIHRoYXQgeW91ciBTTUIgZmlsZSBzZXJ2ZXIgYmVsb25ncyB0by5cbiAgICAgKlxuICAgICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW3JlcXVpcmVkIHBlcm1pc3Npb25zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9jcmVhdGUtc21iLWxvY2F0aW9uLmh0bWwjY29uZmlndXJpbmctc21iLXBlcm1pc3Npb25zKSBmb3IgU01CIGxvY2F0aW9ucy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLWRvbWFpblxuICAgICAqL1xuICAgIHB1YmxpYyBkb21haW46IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgdmVyc2lvbiBvZiB0aGUgU01CIHByb3RvY29sIHRoYXQgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBTTUIgZmlsZSBzZXJ2ZXIuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbnNtYi5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnNtYi1tb3VudG9wdGlvbnNcbiAgICAgKi9cbiAgICBwdWJsaWMgbW91bnRPcHRpb25zOiBDZm5Mb2NhdGlvblNNQi5Nb3VudE9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBwYXNzd29yZCBvZiB0aGUgdXNlciB3aG8gY2FuIG1vdW50IHRoZSBzaGFyZSBhbmQgaGFzIHRoZSBwZXJtaXNzaW9ucyB0byBhY2Nlc3MgZmlsZXMgYW5kIGZvbGRlcnMgaW4gdGhlIFNNQiBzaGFyZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLXBhc3N3b3JkXG4gICAgICovXG4gICAgcHVibGljIHBhc3N3b3JkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIERvbWFpbiBOYW1lIFNlcnZpY2UgKEROUykgbmFtZSBvciBJUCBhZGRyZXNzIG9mIHRoZSBTTUIgZmlsZSBzZXJ2ZXIgdGhhdCB5b3VyIERhdGFTeW5jIGFnZW50IHdpbGwgbW91bnQuXG4gICAgICpcbiAgICAgKiA+IFlvdSBjYW4ndCBzcGVjaWZ5IGFuIElQIHZlcnNpb24gNiAoSVB2NikgYWRkcmVzcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLXNlcnZlcmhvc3RuYW1lXG4gICAgICovXG4gICAgcHVibGljIHNlcnZlckhvc3RuYW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgc3ViZGlyZWN0b3J5IGluIHRoZSBTTUIgZmlsZSBzeXN0ZW0gdGhhdCBpcyB1c2VkIHRvIHJlYWQgZGF0YSBmcm9tIHRoZSBTTUIgc291cmNlIGxvY2F0aW9uIG9yIHdyaXRlIGRhdGEgdG8gdGhlIFNNQiBkZXN0aW5hdGlvbi4gVGhlIFNNQiBwYXRoIHNob3VsZCBiZSBhIHBhdGggdGhhdCdzIGV4cG9ydGVkIGJ5IHRoZSBTTUIgc2VydmVyLCBvciBhIHN1YmRpcmVjdG9yeSBvZiB0aGF0IHBhdGguIFRoZSBwYXRoIHNob3VsZCBiZSBzdWNoIHRoYXQgaXQgY2FuIGJlIG1vdW50ZWQgYnkgb3RoZXIgU01CIGNsaWVudHMgaW4geW91ciBuZXR3b3JrLlxuICAgICAqXG4gICAgICogPiBgU3ViZGlyZWN0b3J5YCBtdXN0IGJlIHNwZWNpZmllZCB3aXRoIGZvcndhcmQgc2xhc2hlcy4gRm9yIGV4YW1wbGUsIGAvcGF0aC90by9mb2xkZXJgIC5cbiAgICAgKlxuICAgICAqIFRvIHRyYW5zZmVyIGFsbCB0aGUgZGF0YSBpbiB0aGUgZm9sZGVyIHlvdSBzcGVjaWZpZWQsIERhdGFTeW5jIG11c3QgaGF2ZSBwZXJtaXNzaW9ucyB0byBtb3VudCB0aGUgU01CIHNoYXJlLCBhcyB3ZWxsIGFzIHRvIGFjY2VzcyBhbGwgdGhlIGRhdGEgaW4gdGhhdCBzaGFyZS4gVG8gZW5zdXJlIHRoaXMsIGVpdGhlciBtYWtlIHN1cmUgdGhhdCB0aGUgdXNlciBuYW1lIGFuZCBwYXNzd29yZCBzcGVjaWZpZWQgYmVsb25ncyB0byB0aGUgdXNlciB3aG8gY2FuIG1vdW50IHRoZSBzaGFyZSwgYW5kIHdobyBoYXMgdGhlIGFwcHJvcHJpYXRlIHBlcm1pc3Npb25zIGZvciBhbGwgb2YgdGhlIGZpbGVzIGFuZCBkaXJlY3RvcmllcyB0aGF0IHlvdSB3YW50IERhdGFTeW5jIHRvIGFjY2Vzcywgb3IgdXNlIGNyZWRlbnRpYWxzIG9mIGEgbWVtYmVyIG9mIHRoZSBCYWNrdXAgT3BlcmF0b3JzIGdyb3VwIHRvIG1vdW50IHRoZSBzaGFyZS4gRG9pbmcgZWl0aGVyIG9uZSBlbmFibGVzIHRoZSBhZ2VudCB0byBhY2Nlc3MgdGhlIGRhdGEuIEZvciB0aGUgYWdlbnQgdG8gYWNjZXNzIGRpcmVjdG9yaWVzLCB5b3UgbXVzdCBhZGRpdGlvbmFsbHkgZW5hYmxlIGFsbCBleGVjdXRlIGFjY2Vzcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLWxvY2F0aW9uc21iLmh0bWwjY2ZuLWRhdGFzeW5jLWxvY2F0aW9uc21iLXN1YmRpcmVjdG9yeVxuICAgICAqL1xuICAgIHB1YmxpYyBzdWJkaXJlY3Rvcnk6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBsYWJlbHMgdGhhdCBoZWxwIHlvdSBjYXRlZ29yaXplLCBmaWx0ZXIsIGFuZCBzZWFyY2ggZm9yIHlvdXIgQVdTIHJlc291cmNlcy4gV2UgcmVjb21tZW5kIGNyZWF0aW5nIGF0IGxlYXN0IGEgbmFtZSB0YWcgZm9yIHlvdXIgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy1sb2NhdGlvbnNtYi5odG1sI2Nmbi1kYXRhc3luYy1sb2NhdGlvbnNtYi10YWdzXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHRhZ3M6IGNkay5UYWdNYW5hZ2VyO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblNNQmAuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2ZuTG9jYXRpb25TTUJQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuTG9jYXRpb25TTUIuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdhZ2VudEFybnMnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3VzZXInLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyTG9jYXRpb25Bcm4gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0xvY2F0aW9uQXJuJykpO1xuICAgICAgICB0aGlzLmF0dHJMb2NhdGlvblVyaSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnTG9jYXRpb25VcmknKSk7XG5cbiAgICAgICAgdGhpcy5hZ2VudEFybnMgPSBwcm9wcy5hZ2VudEFybnM7XG4gICAgICAgIHRoaXMudXNlciA9IHByb3BzLnVzZXI7XG4gICAgICAgIHRoaXMuZG9tYWluID0gcHJvcHMuZG9tYWluO1xuICAgICAgICB0aGlzLm1vdW50T3B0aW9ucyA9IHByb3BzLm1vdW50T3B0aW9ucztcbiAgICAgICAgdGhpcy5wYXNzd29yZCA9IHByb3BzLnBhc3N3b3JkO1xuICAgICAgICB0aGlzLnNlcnZlckhvc3RuYW1lID0gcHJvcHMuc2VydmVySG9zdG5hbWU7XG4gICAgICAgIHRoaXMuc3ViZGlyZWN0b3J5ID0gcHJvcHMuc3ViZGlyZWN0b3J5O1xuICAgICAgICB0aGlzLnRhZ3MgPSBuZXcgY2RrLlRhZ01hbmFnZXIoY2RrLlRhZ1R5cGUuU1RBTkRBUkQsIFwiQVdTOjpEYXRhU3luYzo6TG9jYXRpb25TTUJcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmbkxvY2F0aW9uU01CLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUpO1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjpwcm9wc1wiLCB0aGlzLmNmblByb3BlcnRpZXMpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBnZXQgY2ZuUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBhZ2VudEFybnM6IHRoaXMuYWdlbnRBcm5zLFxuICAgICAgICAgICAgdXNlcjogdGhpcy51c2VyLFxuICAgICAgICAgICAgZG9tYWluOiB0aGlzLmRvbWFpbixcbiAgICAgICAgICAgIG1vdW50T3B0aW9uczogdGhpcy5tb3VudE9wdGlvbnMsXG4gICAgICAgICAgICBwYXNzd29yZDogdGhpcy5wYXNzd29yZCxcbiAgICAgICAgICAgIHNlcnZlckhvc3RuYW1lOiB0aGlzLnNlcnZlckhvc3RuYW1lLFxuICAgICAgICAgICAgc3ViZGlyZWN0b3J5OiB0aGlzLnN1YmRpcmVjdG9yeSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuTG9jYXRpb25TTUJQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Mb2NhdGlvblNNQiB7XG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSB2ZXJzaW9uIG9mIHRoZSBTTUIgcHJvdG9jb2wgdGhhdCBEYXRhU3luYyB1c2VzIHRvIGFjY2VzcyB5b3VyIFNNQiBmaWxlIHNlcnZlci5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLWxvY2F0aW9uc21iLW1vdW50b3B0aW9ucy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBNb3VudE9wdGlvbnNQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBCeSBkZWZhdWx0LCBEYXRhU3luYyBhdXRvbWF0aWNhbGx5IGNob29zZXMgYW4gU01CIHByb3RvY29sIHZlcnNpb24gYmFzZWQgb24gbmVnb3RpYXRpb24gd2l0aCB5b3VyIFNNQiBmaWxlIHNlcnZlci4gWW91IGFsc28gY2FuIGNvbmZpZ3VyZSBEYXRhU3luYyB0byB1c2UgYSBzcGVjaWZpYyBTTUIgdmVyc2lvbiwgYnV0IHdlIHJlY29tbWVuZCBkb2luZyB0aGlzIG9ubHkgaWYgRGF0YVN5bmMgaGFzIHRyb3VibGUgbmVnb3RpYXRpbmcgd2l0aCB0aGUgU01CIGZpbGUgc2VydmVyIGF1dG9tYXRpY2FsbHkuXG4gICAgICAgICAqXG4gICAgICAgICAqIFRoZXNlIGFyZSB0aGUgZm9sbG93aW5nIG9wdGlvbnMgZm9yIGNvbmZpZ3VyaW5nIHRoZSBTTUIgdmVyc2lvbjpcbiAgICAgICAgICpcbiAgICAgICAgICogLSBgQVVUT01BVElDYCAoZGVmYXVsdCk6IERhdGFTeW5jIGFuZCB0aGUgU01CIGZpbGUgc2VydmVyIG5lZ290aWF0ZSB0aGUgaGlnaGVzdCB2ZXJzaW9uIG9mIFNNQiB0aGF0IHRoZXkgbXV0dWFsbHkgc3VwcG9ydCBiZXR3ZWVuIDIuMSBhbmQgMy4xLjEuXG4gICAgICAgICAqXG4gICAgICAgICAqIFRoaXMgaXMgdGhlIHJlY29tbWVuZGVkIG9wdGlvbi4gSWYgeW91IGluc3RlYWQgY2hvb3NlIGEgc3BlY2lmaWMgdmVyc2lvbiB0aGF0IHlvdXIgZmlsZSBzZXJ2ZXIgZG9lc24ndCBzdXBwb3J0LCB5b3UgbWF5IGdldCBhbiBgT3BlcmF0aW9uIE5vdCBTdXBwb3J0ZWRgIGVycm9yLlxuICAgICAgICAgKiAtIGBTTUIzYCA6IFJlc3RyaWN0cyB0aGUgcHJvdG9jb2wgbmVnb3RpYXRpb24gdG8gb25seSBTTUIgdmVyc2lvbiAzLjAuMi5cbiAgICAgICAgICogLSBgU01CMmAgOiBSZXN0cmljdHMgdGhlIHByb3RvY29sIG5lZ290aWF0aW9uIHRvIG9ubHkgU01CIHZlcnNpb24gMi4xLlxuICAgICAgICAgKiAtIGBTTUIyXzBgIDogUmVzdHJpY3RzIHRoZSBwcm90b2NvbCBuZWdvdGlhdGlvbiB0byBvbmx5IFNNQiB2ZXJzaW9uIDIuMC5cbiAgICAgICAgICogLSBgU01CMWAgOiBSZXN0cmljdHMgdGhlIHByb3RvY29sIG5lZ290aWF0aW9uIHRvIG9ubHkgU01CIHZlcnNpb24gMS4wLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IFRoZSBgU01CMWAgb3B0aW9uIGlzbid0IGF2YWlsYWJsZSB3aGVuIFtjcmVhdGluZyBhbiBBbWF6b24gRlN4IGZvciBOZXRBcHAgT05UQVAgbG9jYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL0FQSV9DcmVhdGVMb2NhdGlvbkZzeE9udGFwLmh0bWwpIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy1sb2NhdGlvbnNtYi1tb3VudG9wdGlvbnMuaHRtbCNjZm4tZGF0YXN5bmMtbG9jYXRpb25zbWItbW91bnRvcHRpb25zLXZlcnNpb25cbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZlcnNpb24/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYE1vdW50T3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBNb3VudE9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Mb2NhdGlvblNNQl9Nb3VudE9wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZlcnNpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudmVyc2lvbikpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJNb3VudE9wdGlvbnNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OkxvY2F0aW9uU01CLk1vdW50T3B0aW9uc2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTW91bnRPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpMb2NhdGlvblNNQi5Nb3VudE9wdGlvbnNgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuTG9jYXRpb25TTUJNb3VudE9wdGlvbnNQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTG9jYXRpb25TTUJfTW91bnRPcHRpb25zUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIFZlcnNpb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmVyc2lvbiksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkxvY2F0aW9uU01CTW91bnRPcHRpb25zUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Mb2NhdGlvblNNQi5Nb3VudE9wdGlvbnNQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Mb2NhdGlvblNNQi5Nb3VudE9wdGlvbnNQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ZlcnNpb24nLCAnVmVyc2lvbicsIHByb3BlcnRpZXMuVmVyc2lvbiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WZXJzaW9uKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuVGFza2BcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuVGFza1Byb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiBhbiBBV1Mgc3RvcmFnZSByZXNvdXJjZSdzIGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sI2Nmbi1kYXRhc3luYy10YXNrLWRlc3RpbmF0aW9ubG9jYXRpb25hcm5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZXN0aW5hdGlvbkxvY2F0aW9uQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIHNvdXJjZSBsb2NhdGlvbiBmb3IgdGhlIHRhc2suXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy10YXNrLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stc291cmNlbG9jYXRpb25hcm5cbiAgICAgKi9cbiAgICByZWFkb25seSBzb3VyY2VMb2NhdGlvbkFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBBbWF6b24gQ2xvdWRXYXRjaCBsb2cgZ3JvdXAgdGhhdCBpcyB1c2VkIHRvIG1vbml0b3IgYW5kIGxvZyBldmVudHMgaW4gdGhlIHRhc2suXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBob3cgdG8gdXNlIENsb3VkV2F0Y2ggTG9ncyB3aXRoIERhdGFTeW5jLCBzZWUgW01vbml0b3JpbmcgWW91ciBUYXNrXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9tb25pdG9yLWRhdGFzeW5jLmh0bWwjY2xvdWR3YXRjaGxvZ3MpIGluIHRoZSAqQVdTIERhdGFTeW5jIFVzZXIgR3VpZGUuKlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgdGhlc2UgZ3JvdXBzLCBzZWUgW1dvcmtpbmcgd2l0aCBMb2cgR3JvdXBzIGFuZCBMb2cgU3RyZWFtc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvbkNsb3VkV2F0Y2gvbGF0ZXN0L2xvZ3MvV29ya2luZy13aXRoLWxvZy1ncm91cHMtYW5kLXN0cmVhbXMuaHRtbCkgaW4gdGhlICpBbWF6b24gQ2xvdWRXYXRjaCBMb2dzIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1jbG91ZHdhdGNobG9nZ3JvdXBhcm5cbiAgICAgKi9cbiAgICByZWFkb25seSBjbG91ZFdhdGNoTG9nR3JvdXBBcm4/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBsaXN0IG9mIGZpbHRlciBydWxlcyB0aGF0IGV4Y2x1ZGUgc3BlY2lmaWMgZGF0YSBkdXJpbmcgeW91ciB0cmFuc2Zlci4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYW5kIGV4YW1wbGVzLCBzZWUgW0ZpbHRlcmluZyBkYXRhIHRyYW5zZmVycmVkIGJ5IERhdGFTeW5jXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9maWx0ZXJpbmcuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sI2Nmbi1kYXRhc3luYy10YXNrLWV4Y2x1ZGVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgZXhjbHVkZXM/OiBBcnJheTxDZm5UYXNrLkZpbHRlclJ1bGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBsaXN0IG9mIGZpbHRlciBydWxlcyB0aGF0IGluY2x1ZGUgc3BlY2lmaWMgZGF0YSBkdXJpbmcgeW91ciB0cmFuc2Zlci4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYW5kIGV4YW1wbGVzLCBzZWUgW0ZpbHRlcmluZyBkYXRhIHRyYW5zZmVycmVkIGJ5IERhdGFTeW5jXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9maWx0ZXJpbmcuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sI2Nmbi1kYXRhc3luYy10YXNrLWluY2x1ZGVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5jbHVkZXM/OiBBcnJheTxDZm5UYXNrLkZpbHRlclJ1bGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiBhIHRhc2suIFRoaXMgdmFsdWUgaXMgYSB0ZXh0IHJlZmVyZW5jZSB0aGF0IGlzIHVzZWQgdG8gaWRlbnRpZnkgdGhlIHRhc2sgaW4gdGhlIGNvbnNvbGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy10YXNrLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIGNvbmZpZ3VyYXRpb24gb3B0aW9ucyBmb3IgYSB0YXNrLiBTb21lIG9wdGlvbnMgaW5jbHVkZSBwcmVzZXJ2aW5nIGZpbGUgb3Igb2JqZWN0IG1ldGFkYXRhIGFuZCB2ZXJpZnlpbmcgZGF0YSBpbnRlZ3JpdHkuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIGFsc28gb3ZlcnJpZGUgdGhlc2Ugb3B0aW9ucyBiZWZvcmUgc3RhcnRpbmcgYW4gaW5kaXZpZHVhbCBydW4gb2YgYSB0YXNrIChhbHNvIGtub3duIGFzIGEgKnRhc2sgZXhlY3V0aW9uKiApLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTdGFydFRhc2tFeGVjdXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL0FQSV9TdGFydFRhc2tFeGVjdXRpb24uaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnNcbiAgICAgKi9cbiAgICByZWFkb25seSBvcHRpb25zPzogQ2ZuVGFzay5PcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBzY2hlZHVsZSB1c2VkIHRvIHBlcmlvZGljYWxseSB0cmFuc2ZlciBmaWxlcyBmcm9tIGEgc291cmNlIHRvIGEgZGVzdGluYXRpb24gbG9jYXRpb24uIFRoZSBzY2hlZHVsZSBzaG91bGQgYmUgc3BlY2lmaWVkIGluIFVUQyB0aW1lLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTY2hlZHVsaW5nIHlvdXIgdGFza10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvdGFzay1zY2hlZHVsaW5nLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1zY2hlZHVsZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNjaGVkdWxlPzogQ2ZuVGFzay5UYXNrU2NoZWR1bGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgdGFncyB0aGF0IHlvdSB3YW50IHRvIGFwcGx5IHRvIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSByZXByZXNlbnRpbmcgdGhlIHRhc2suXG4gICAgICpcbiAgICAgKiAqVGFncyogYXJlIGtleS12YWx1ZSBwYWlycyB0aGF0IGhlbHAgeW91IG1hbmFnZSwgZmlsdGVyLCBhbmQgc2VhcmNoIGZvciB5b3VyIERhdGFTeW5jIHJlc291cmNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay10YWdzXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IGNkay5DZm5UYWdbXTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBDZm5UYXNrUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblRhc2tQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5UYXNrUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdjbG91ZFdhdGNoTG9nR3JvdXBBcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuY2xvdWRXYXRjaExvZ0dyb3VwQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkZXN0aW5hdGlvbkxvY2F0aW9uQXJuJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uTG9jYXRpb25Bcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc3RpbmF0aW9uTG9jYXRpb25Bcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVzdGluYXRpb25Mb2NhdGlvbkFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZXhjbHVkZXMnLCBjZGsubGlzdFZhbGlkYXRvcihDZm5UYXNrX0ZpbHRlclJ1bGVQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMuZXhjbHVkZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luY2x1ZGVzJywgY2RrLmxpc3RWYWxpZGF0b3IoQ2ZuVGFza19GaWx0ZXJSdWxlUHJvcGVydHlWYWxpZGF0b3IpKShwcm9wZXJ0aWVzLmluY2x1ZGVzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ29wdGlvbnMnLCBDZm5UYXNrX09wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5vcHRpb25zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzY2hlZHVsZScsIENmblRhc2tfVGFza1NjaGVkdWxlUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMuc2NoZWR1bGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NvdXJjZUxvY2F0aW9uQXJuJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnNvdXJjZUxvY2F0aW9uQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzb3VyY2VMb2NhdGlvbkFybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zb3VyY2VMb2NhdGlvbkFybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZUNmblRhZykpKHByb3BlcnRpZXMudGFncykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5UYXNrUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpUYXNrYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5UYXNrUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpUYXNrYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblRhc2tQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuVGFza1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBEZXN0aW5hdGlvbkxvY2F0aW9uQXJuOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uTG9jYXRpb25Bcm4pLFxuICAgICAgICBTb3VyY2VMb2NhdGlvbkFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zb3VyY2VMb2NhdGlvbkFybiksXG4gICAgICAgIENsb3VkV2F0Y2hMb2dHcm91cEFybjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5jbG91ZFdhdGNoTG9nR3JvdXBBcm4pLFxuICAgICAgICBFeGNsdWRlczogY2RrLmxpc3RNYXBwZXIoY2ZuVGFza0ZpbHRlclJ1bGVQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuZXhjbHVkZXMpLFxuICAgICAgICBJbmNsdWRlczogY2RrLmxpc3RNYXBwZXIoY2ZuVGFza0ZpbHRlclJ1bGVQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuaW5jbHVkZXMpLFxuICAgICAgICBOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm5hbWUpLFxuICAgICAgICBPcHRpb25zOiBjZm5UYXNrT3B0aW9uc1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm9wdGlvbnMpLFxuICAgICAgICBTY2hlZHVsZTogY2ZuVGFza1Rhc2tTY2hlZHVsZVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNjaGVkdWxlKSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblRhc2tQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblRhc2tQcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuVGFza1Byb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGVzdGluYXRpb25Mb2NhdGlvbkFybicsICdEZXN0aW5hdGlvbkxvY2F0aW9uQXJuJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5EZXN0aW5hdGlvbkxvY2F0aW9uQXJuKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzb3VyY2VMb2NhdGlvbkFybicsICdTb3VyY2VMb2NhdGlvbkFybicsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU291cmNlTG9jYXRpb25Bcm4pKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2Nsb3VkV2F0Y2hMb2dHcm91cEFybicsICdDbG91ZFdhdGNoTG9nR3JvdXBBcm4nLCBwcm9wZXJ0aWVzLkNsb3VkV2F0Y2hMb2dHcm91cEFybiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5DbG91ZFdhdGNoTG9nR3JvdXBBcm4pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2V4Y2x1ZGVzJywgJ0V4Y2x1ZGVzJywgcHJvcGVydGllcy5FeGNsdWRlcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShDZm5UYXNrRmlsdGVyUnVsZVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLkV4Y2x1ZGVzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdpbmNsdWRlcycsICdJbmNsdWRlcycsIHByb3BlcnRpZXMuSW5jbHVkZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuVGFza0ZpbHRlclJ1bGVQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy5JbmNsdWRlcykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbmFtZScsICdOYW1lJywgcHJvcGVydGllcy5OYW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk5hbWUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ29wdGlvbnMnLCAnT3B0aW9ucycsIHByb3BlcnRpZXMuT3B0aW9ucyAhPSBudWxsID8gQ2ZuVGFza09wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLk9wdGlvbnMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NjaGVkdWxlJywgJ1NjaGVkdWxlJywgcHJvcGVydGllcy5TY2hlZHVsZSAhPSBudWxsID8gQ2ZuVGFza1Rhc2tTY2hlZHVsZVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuU2NoZWR1bGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RhZ3MnLCAnVGFncycsIHByb3BlcnRpZXMuVGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBcnJheShjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldENmblRhZykocHJvcGVydGllcy5UYWdzKSA6IHVuZGVmaW5lZCBhcyBhbnkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6RGF0YVN5bmM6OlRhc2tgXG4gKlxuICogVGhlIGBBV1M6OkRhdGFTeW5jOjpUYXNrYCByZXNvdXJjZSBzcGVjaWZpZXMgYSB0YXNrLiBBIHRhc2sgaXMgYSBzZXQgb2YgdHdvIGxvY2F0aW9ucyAoc291cmNlIGFuZCBkZXN0aW5hdGlvbikgYW5kIGEgc2V0IG9mIGBPcHRpb25zYCB0aGF0IHlvdSB1c2UgdG8gY29udHJvbCB0aGUgYmVoYXZpb3Igb2YgYSB0YXNrLiBJZiB5b3UgZG9uJ3Qgc3BlY2lmeSBgT3B0aW9uc2Agd2hlbiB5b3UgY3JlYXRlIGEgdGFzaywgQVdTIERhdGFTeW5jIHBvcHVsYXRlcyB0aGVtIHdpdGggc2VydmljZSBkZWZhdWx0cy5cbiAqXG4gKiBAY2xvdWRmb3JtYXRpb25SZXNvdXJjZSBBV1M6OkRhdGFTeW5jOjpUYXNrXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5UYXNrIGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6RGF0YVN5bmM6OlRhc2tcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmblRhc2sge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmblRhc2tQcm9wc0Zyb21DbG91ZEZvcm1hdGlvbihyZXNvdXJjZVByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCByZXQgPSBuZXcgQ2ZuVGFzayhzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQVJOcyBvZiB0aGUgZGVzdGluYXRpb24gZWxhc3RpYyBuZXR3b3JrIGludGVyZmFjZXMgKEVOSXMpIHRoYXQgd2VyZSBjcmVhdGVkIGZvciB5b3VyIHN1Ym5ldC5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgRGVzdGluYXRpb25OZXR3b3JrSW50ZXJmYWNlQXJuc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRGVzdGluYXRpb25OZXR3b3JrSW50ZXJmYWNlQXJuczogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQVJOcyBvZiB0aGUgc291cmNlIEVOSXMgdGhhdCB3ZXJlIGNyZWF0ZWQgZm9yIHlvdXIgc3VibmV0LlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBTb3VyY2VOZXR3b3JrSW50ZXJmYWNlQXJuc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU291cmNlTmV0d29ya0ludGVyZmFjZUFybnM6IHN0cmluZ1tdO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHN0YXR1cyBvZiB0aGUgdGFzayB0aGF0IHdhcyBkZXNjcmliZWQuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIFN0YXR1c1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU3RhdHVzOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQVJOIG9mIHRoZSB0YXNrLlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBUYXNrQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJUYXNrQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgYW4gQVdTIHN0b3JhZ2UgcmVzb3VyY2UncyBsb2NhdGlvbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1kZXN0aW5hdGlvbmxvY2F0aW9uYXJuXG4gICAgICovXG4gICAgcHVibGljIGRlc3RpbmF0aW9uTG9jYXRpb25Bcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgc291cmNlIGxvY2F0aW9uIGZvciB0aGUgdGFzay5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1zb3VyY2Vsb2NhdGlvbmFyblxuICAgICAqL1xuICAgIHB1YmxpYyBzb3VyY2VMb2NhdGlvbkFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBBbWF6b24gQ2xvdWRXYXRjaCBsb2cgZ3JvdXAgdGhhdCBpcyB1c2VkIHRvIG1vbml0b3IgYW5kIGxvZyBldmVudHMgaW4gdGhlIHRhc2suXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBob3cgdG8gdXNlIENsb3VkV2F0Y2ggTG9ncyB3aXRoIERhdGFTeW5jLCBzZWUgW01vbml0b3JpbmcgWW91ciBUYXNrXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9tb25pdG9yLWRhdGFzeW5jLmh0bWwjY2xvdWR3YXRjaGxvZ3MpIGluIHRoZSAqQVdTIERhdGFTeW5jIFVzZXIgR3VpZGUuKlxuICAgICAqXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgdGhlc2UgZ3JvdXBzLCBzZWUgW1dvcmtpbmcgd2l0aCBMb2cgR3JvdXBzIGFuZCBMb2cgU3RyZWFtc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvbkNsb3VkV2F0Y2gvbGF0ZXN0L2xvZ3MvV29ya2luZy13aXRoLWxvZy1ncm91cHMtYW5kLXN0cmVhbXMuaHRtbCkgaW4gdGhlICpBbWF6b24gQ2xvdWRXYXRjaCBMb2dzIFVzZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1jbG91ZHdhdGNobG9nZ3JvdXBhcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgY2xvdWRXYXRjaExvZ0dyb3VwQXJuOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBsaXN0IG9mIGZpbHRlciBydWxlcyB0aGF0IGV4Y2x1ZGUgc3BlY2lmaWMgZGF0YSBkdXJpbmcgeW91ciB0cmFuc2Zlci4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYW5kIGV4YW1wbGVzLCBzZWUgW0ZpbHRlcmluZyBkYXRhIHRyYW5zZmVycmVkIGJ5IERhdGFTeW5jXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9maWx0ZXJpbmcuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sI2Nmbi1kYXRhc3luYy10YXNrLWV4Y2x1ZGVzXG4gICAgICovXG4gICAgcHVibGljIGV4Y2x1ZGVzOiBBcnJheTxDZm5UYXNrLkZpbHRlclJ1bGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBsaXN0IG9mIGZpbHRlciBydWxlcyB0aGF0IGluY2x1ZGUgc3BlY2lmaWMgZGF0YSBkdXJpbmcgeW91ciB0cmFuc2Zlci4gRm9yIG1vcmUgaW5mb3JtYXRpb24gYW5kIGV4YW1wbGVzLCBzZWUgW0ZpbHRlcmluZyBkYXRhIHRyYW5zZmVycmVkIGJ5IERhdGFTeW5jXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9maWx0ZXJpbmcuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sI2Nmbi1kYXRhc3luYy10YXNrLWluY2x1ZGVzXG4gICAgICovXG4gICAgcHVibGljIGluY2x1ZGVzOiBBcnJheTxDZm5UYXNrLkZpbHRlclJ1bGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiBhIHRhc2suIFRoaXMgdmFsdWUgaXMgYSB0ZXh0IHJlZmVyZW5jZSB0aGF0IGlzIHVzZWQgdG8gaWRlbnRpZnkgdGhlIHRhc2sgaW4gdGhlIGNvbnNvbGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kYXRhc3luYy10YXNrLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBuYW1lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIGNvbmZpZ3VyYXRpb24gb3B0aW9ucyBmb3IgYSB0YXNrLiBTb21lIG9wdGlvbnMgaW5jbHVkZSBwcmVzZXJ2aW5nIGZpbGUgb3Igb2JqZWN0IG1ldGFkYXRhIGFuZCB2ZXJpZnlpbmcgZGF0YSBpbnRlZ3JpdHkuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIGFsc28gb3ZlcnJpZGUgdGhlc2Ugb3B0aW9ucyBiZWZvcmUgc3RhcnRpbmcgYW4gaW5kaXZpZHVhbCBydW4gb2YgYSB0YXNrIChhbHNvIGtub3duIGFzIGEgKnRhc2sgZXhlY3V0aW9uKiApLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTdGFydFRhc2tFeGVjdXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL0FQSV9TdGFydFRhc2tFeGVjdXRpb24uaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZGF0YXN5bmMtdGFzay5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnNcbiAgICAgKi9cbiAgICBwdWJsaWMgb3B0aW9uczogQ2ZuVGFzay5PcHRpb25zUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgYSBzY2hlZHVsZSB1c2VkIHRvIHBlcmlvZGljYWxseSB0cmFuc2ZlciBmaWxlcyBmcm9tIGEgc291cmNlIHRvIGEgZGVzdGluYXRpb24gbG9jYXRpb24uIFRoZSBzY2hlZHVsZSBzaG91bGQgYmUgc3BlY2lmaWVkIGluIFVUQyB0aW1lLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTY2hlZHVsaW5nIHlvdXIgdGFza10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvdGFzay1zY2hlZHVsaW5nLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1zY2hlZHVsZVxuICAgICAqL1xuICAgIHB1YmxpYyBzY2hlZHVsZTogQ2ZuVGFzay5UYXNrU2NoZWR1bGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgdGFncyB0aGF0IHlvdSB3YW50IHRvIGFwcGx5IHRvIHRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSByZXByZXNlbnRpbmcgdGhlIHRhc2suXG4gICAgICpcbiAgICAgKiAqVGFncyogYXJlIGtleS12YWx1ZSBwYWlycyB0aGF0IGhlbHAgeW91IG1hbmFnZSwgZmlsdGVyLCBhbmQgc2VhcmNoIGZvciB5b3VyIERhdGFTeW5jIHJlc291cmNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWRhdGFzeW5jLXRhc2suaHRtbCNjZm4tZGF0YXN5bmMtdGFzay10YWdzXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHRhZ3M6IGNkay5UYWdNYW5hZ2VyO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkRhdGFTeW5jOjpUYXNrYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5UYXNrUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmblRhc2suQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdkZXN0aW5hdGlvbkxvY2F0aW9uQXJuJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdzb3VyY2VMb2NhdGlvbkFybicsIHRoaXMpO1xuICAgICAgICB0aGlzLmF0dHJEZXN0aW5hdGlvbk5ldHdvcmtJbnRlcmZhY2VBcm5zID0gY2RrLlRva2VuLmFzTGlzdCh0aGlzLmdldEF0dCgnRGVzdGluYXRpb25OZXR3b3JrSW50ZXJmYWNlQXJucycpKTtcbiAgICAgICAgdGhpcy5hdHRyU291cmNlTmV0d29ya0ludGVyZmFjZUFybnMgPSBjZGsuVG9rZW4uYXNMaXN0KHRoaXMuZ2V0QXR0KCdTb3VyY2VOZXR3b3JrSW50ZXJmYWNlQXJucycpKTtcbiAgICAgICAgdGhpcy5hdHRyU3RhdHVzID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdTdGF0dXMnKSk7XG4gICAgICAgIHRoaXMuYXR0clRhc2tBcm4gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ1Rhc2tBcm4nKSk7XG5cbiAgICAgICAgdGhpcy5kZXN0aW5hdGlvbkxvY2F0aW9uQXJuID0gcHJvcHMuZGVzdGluYXRpb25Mb2NhdGlvbkFybjtcbiAgICAgICAgdGhpcy5zb3VyY2VMb2NhdGlvbkFybiA9IHByb3BzLnNvdXJjZUxvY2F0aW9uQXJuO1xuICAgICAgICB0aGlzLmNsb3VkV2F0Y2hMb2dHcm91cEFybiA9IHByb3BzLmNsb3VkV2F0Y2hMb2dHcm91cEFybjtcbiAgICAgICAgdGhpcy5leGNsdWRlcyA9IHByb3BzLmV4Y2x1ZGVzO1xuICAgICAgICB0aGlzLmluY2x1ZGVzID0gcHJvcHMuaW5jbHVkZXM7XG4gICAgICAgIHRoaXMubmFtZSA9IHByb3BzLm5hbWU7XG4gICAgICAgIHRoaXMub3B0aW9ucyA9IHByb3BzLm9wdGlvbnM7XG4gICAgICAgIHRoaXMuc2NoZWR1bGUgPSBwcm9wcy5zY2hlZHVsZTtcbiAgICAgICAgdGhpcy50YWdzID0gbmV3IGNkay5UYWdNYW5hZ2VyKGNkay5UYWdUeXBlLlNUQU5EQVJELCBcIkFXUzo6RGF0YVN5bmM6OlRhc2tcIiwgcHJvcHMudGFncywgeyB0YWdQcm9wZXJ0eU5hbWU6ICd0YWdzJyB9KTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmblRhc2suQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGRlc3RpbmF0aW9uTG9jYXRpb25Bcm46IHRoaXMuZGVzdGluYXRpb25Mb2NhdGlvbkFybixcbiAgICAgICAgICAgIHNvdXJjZUxvY2F0aW9uQXJuOiB0aGlzLnNvdXJjZUxvY2F0aW9uQXJuLFxuICAgICAgICAgICAgY2xvdWRXYXRjaExvZ0dyb3VwQXJuOiB0aGlzLmNsb3VkV2F0Y2hMb2dHcm91cEFybixcbiAgICAgICAgICAgIGV4Y2x1ZGVzOiB0aGlzLmV4Y2x1ZGVzLFxuICAgICAgICAgICAgaW5jbHVkZXM6IHRoaXMuaW5jbHVkZXMsXG4gICAgICAgICAgICBuYW1lOiB0aGlzLm5hbWUsXG4gICAgICAgICAgICBvcHRpb25zOiB0aGlzLm9wdGlvbnMsXG4gICAgICAgICAgICBzY2hlZHVsZTogdGhpcy5zY2hlZHVsZSxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuVGFza1Byb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblRhc2sge1xuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB3aGljaCBmaWxlcywgZm9sZGVycywgYW5kIG9iamVjdHMgdG8gaW5jbHVkZSBvciBleGNsdWRlIHdoZW4gdHJhbnNmZXJyaW5nIGZpbGVzIGZyb20gc291cmNlIHRvIGRlc3RpbmF0aW9uLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1maWx0ZXJydWxlLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIEZpbHRlclJ1bGVQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgdHlwZSBvZiBmaWx0ZXIgcnVsZSB0byBhcHBseS4gQVdTIERhdGFTeW5jIG9ubHkgc3VwcG9ydHMgdGhlIFNJTVBMRV9QQVRURVJOIHJ1bGUgdHlwZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy10YXNrLWZpbHRlcnJ1bGUuaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1maWx0ZXJydWxlLWZpbHRlcnR5cGVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGZpbHRlclR5cGU/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBIHNpbmdsZSBmaWx0ZXIgc3RyaW5nIHRoYXQgY29uc2lzdHMgb2YgdGhlIHBhdHRlcm5zIHRvIGluY2x1ZGUgb3IgZXhjbHVkZS4gVGhlIHBhdHRlcm5zIGFyZSBkZWxpbWl0ZWQgYnkgXCJ8XCIgKHRoYXQgaXMsIGEgcGlwZSksIGZvciBleGFtcGxlOiBgL2ZvbGRlcjF8L2ZvbGRlcjJgXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1maWx0ZXJydWxlLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stZmlsdGVycnVsZS12YWx1ZVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdmFsdWU/OiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYEZpbHRlclJ1bGVQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgRmlsdGVyUnVsZVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblRhc2tfRmlsdGVyUnVsZVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZmlsdGVyVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5maWx0ZXJUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd2YWx1ZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52YWx1ZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJGaWx0ZXJSdWxlUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkRhdGFTeW5jOjpUYXNrLkZpbHRlclJ1bGVgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEZpbHRlclJ1bGVQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OlRhc2suRmlsdGVyUnVsZWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5UYXNrRmlsdGVyUnVsZVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5UYXNrX0ZpbHRlclJ1bGVQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRmlsdGVyVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5maWx0ZXJUeXBlKSxcbiAgICAgICAgVmFsdWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmFsdWUpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5UYXNrRmlsdGVyUnVsZVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuVGFzay5GaWx0ZXJSdWxlUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuVGFzay5GaWx0ZXJSdWxlUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdmaWx0ZXJUeXBlJywgJ0ZpbHRlclR5cGUnLCBwcm9wZXJ0aWVzLkZpbHRlclR5cGUgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRmlsdGVyVHlwZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndmFsdWUnLCAnVmFsdWUnLCBwcm9wZXJ0aWVzLlZhbHVlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlZhbHVlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuVGFzayB7XG4gICAgLyoqXG4gICAgICogUmVwcmVzZW50cyB0aGUgb3B0aW9ucyB0aGF0IGFyZSBhdmFpbGFibGUgdG8gY29udHJvbCB0aGUgYmVoYXZpb3Igb2YgYSBbU3RhcnRUYXNrRXhlY3V0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9BUElfU3RhcnRUYXNrRXhlY3V0aW9uLmh0bWwpIG9wZXJhdGlvbi4gVGhpcyBiZWhhdmlvciBpbmNsdWRlcyBwcmVzZXJ2aW5nIG1ldGFkYXRhLCBzdWNoIGFzIHVzZXIgSUQgKFVJRCksIGdyb3VwIElEIChHSUQpLCBhbmQgZmlsZSBwZXJtaXNzaW9uczsgb3ZlcndyaXRpbmcgZmlsZXMgaW4gdGhlIGRlc3RpbmF0aW9uOyBkYXRhIGludGVncml0eSB2ZXJpZmljYXRpb247IGFuZCBzbyBvbi5cbiAgICAgKlxuICAgICAqIEEgdGFzayBoYXMgYSBzZXQgb2YgZGVmYXVsdCBvcHRpb25zIGFzc29jaWF0ZWQgd2l0aCBpdC4gSWYgeW91IGRvbid0IHNwZWNpZnkgYW4gb3B0aW9uIGluIFtTdGFydFRhc2tFeGVjdXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL0FQSV9TdGFydFRhc2tFeGVjdXRpb24uaHRtbCkgLCB0aGUgZGVmYXVsdCB2YWx1ZSBpcyB1c2VkLiBZb3UgY2FuIG92ZXJyaWRlIHRoZSBkZWZhdWx0IG9wdGlvbnMgb24gZWFjaCB0YXNrIGV4ZWN1dGlvbiBieSBzcGVjaWZ5aW5nIGFuIG92ZXJyaWRpbmcgYE9wdGlvbnNgIHZhbHVlIHRvIFtTdGFydFRhc2tFeGVjdXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL0FQSV9TdGFydFRhc2tFeGVjdXRpb24uaHRtbCkgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1vcHRpb25zLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIE9wdGlvbnNQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBIGZpbGUgbWV0YWRhdGEgdmFsdWUgdGhhdCBzaG93cyB0aGUgbGFzdCB0aW1lIHRoYXQgYSBmaWxlIHdhcyBhY2Nlc3NlZCAodGhhdCBpcywgd2hlbiB0aGUgZmlsZSB3YXMgcmVhZCBvciB3cml0dGVuIHRvKS4gSWYgeW91IHNldCBgQXRpbWVgIHRvIGBCRVNUX0VGRk9SVGAgLCBBV1MgRGF0YVN5bmMgYXR0ZW1wdHMgdG8gcHJlc2VydmUgdGhlIG9yaWdpbmFsIGBBdGltZWAgYXR0cmlidXRlIG9uIGFsbCBzb3VyY2UgZmlsZXMgKHRoYXQgaXMsIHRoZSB2ZXJzaW9uIGJlZm9yZSB0aGUgUFJFUEFSSU5HIHBoYXNlKS4gSG93ZXZlciwgYEF0aW1lYCAncyBiZWhhdmlvciBpcyBub3QgZnVsbHkgc3RhbmRhcmQgYWNyb3NzIHBsYXRmb3Jtcywgc28gQVdTIERhdGFTeW5jIGNhbiBvbmx5IGRvIHRoaXMgb24gYSBiZXN0LWVmZm9ydCBiYXNpcy5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdCB2YWx1ZTogYEJFU1RfRUZGT1JUYFxuICAgICAgICAgKlxuICAgICAgICAgKiBgQkVTVF9FRkZPUlRgIDogQXR0ZW1wdCB0byBwcmVzZXJ2ZSB0aGUgcGVyLWZpbGUgYEF0aW1lYCB2YWx1ZSAocmVjb21tZW5kZWQpLlxuICAgICAgICAgKlxuICAgICAgICAgKiBgTk9ORWAgOiBJZ25vcmUgYEF0aW1lYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gSWYgYEF0aW1lYCBpcyBzZXQgdG8gYEJFU1RfRUZGT1JUYCAsIGBNdGltZWAgbXVzdCBiZSBzZXQgdG8gYFBSRVNFUlZFYCAuXG4gICAgICAgICAqID5cbiAgICAgICAgICogPiBJZiBgQXRpbWVgIGlzIHNldCB0byBgTk9ORWAgLCBgTXRpbWVgIG11c3QgYWxzbyBiZSBgTk9ORWAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLXRhc2stb3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnMtYXRpbWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGF0aW1lPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSB2YWx1ZSB0aGF0IGxpbWl0cyB0aGUgYmFuZHdpZHRoIHVzZWQgYnkgQVdTIERhdGFTeW5jIC4gRm9yIGV4YW1wbGUsIGlmIHlvdSB3YW50IEFXUyBEYXRhU3luYyB0byB1c2UgYSBtYXhpbXVtIG9mIDEgTUIsIHNldCB0aGlzIHZhbHVlIHRvIGAxMDQ4NTc2YCAoPTEwMjQqMTAyNCkuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1vcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stb3B0aW9ucy1ieXRlc3BlcnNlY29uZFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgYnl0ZXNQZXJTZWNvbmQ/OiBudW1iZXI7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgZ3JvdXAgSUQgKEdJRCkgb2YgdGhlIGZpbGUncyBvd25lcnMuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQgdmFsdWU6IGBJTlRfVkFMVUVgXG4gICAgICAgICAqXG4gICAgICAgICAqIGBJTlRfVkFMVUVgIDogUHJlc2VydmUgdGhlIGludGVnZXIgdmFsdWUgb2YgdGhlIHVzZXIgSUQgKFVJRCkgYW5kIGdyb3VwIElEIChHSUQpIChyZWNvbW1lbmRlZCkuXG4gICAgICAgICAqXG4gICAgICAgICAqIGBOQU1FYCA6IEN1cnJlbnRseSBub3Qgc3VwcG9ydGVkLlxuICAgICAgICAgKlxuICAgICAgICAgKiBgTk9ORWAgOiBJZ25vcmUgdGhlIFVJRCBhbmQgR0lELlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLXRhc2stb3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnMtZ2lkXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBnaWQ/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBTcGVjaWZpZXMgdGhlIHR5cGUgb2YgbG9ncyB0aGF0IERhdGFTeW5jIHB1Ymxpc2hlcyB0byBhIEFtYXpvbiBDbG91ZFdhdGNoIExvZ3MgbG9nIGdyb3VwLiBUbyBzcGVjaWZ5IHRoZSBsb2cgZ3JvdXAsIHNlZSBbQ2xvdWRXYXRjaExvZ0dyb3VwQXJuXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9BUElfQ3JlYXRlVGFzay5odG1sI0RhdGFTeW5jLUNyZWF0ZVRhc2stcmVxdWVzdC1DbG91ZFdhdGNoTG9nR3JvdXBBcm4pIC5cbiAgICAgICAgICpcbiAgICAgICAgICogSWYgeW91IHNldCBgTG9nTGV2ZWxgIHRvIGBPRkZgICwgbm8gbG9ncyBhcmUgcHVibGlzaGVkLiBgQkFTSUNgIHB1Ymxpc2hlcyBsb2dzIG9uIGVycm9ycyBmb3IgaW5kaXZpZHVhbCBmaWxlcyB0cmFuc2ZlcnJlZC4gYFRSQU5TRkVSYCBwdWJsaXNoZXMgbG9ncyBmb3IgZXZlcnkgZmlsZSBvciBvYmplY3QgdGhhdCBpcyB0cmFuc2ZlcnJlZCBhbmQgaW50ZWdyaXR5IGNoZWNrZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1vcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stb3B0aW9ucy1sb2dsZXZlbFxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbG9nTGV2ZWw/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBBIHZhbHVlIHRoYXQgaW5kaWNhdGVzIHRoZSBsYXN0IHRpbWUgdGhhdCBhIGZpbGUgd2FzIG1vZGlmaWVkICh0aGF0IGlzLCBhIGZpbGUgd2FzIHdyaXR0ZW4gdG8pIGJlZm9yZSB0aGUgUFJFUEFSSU5HIHBoYXNlLiBUaGlzIG9wdGlvbiBpcyByZXF1aXJlZCBmb3IgY2FzZXMgd2hlbiB5b3UgbmVlZCB0byBydW4gdGhlIHNhbWUgdGFzayBtb3JlIHRoYW4gb25lIHRpbWUuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQgdmFsdWU6IGBQUkVTRVJWRWBcbiAgICAgICAgICpcbiAgICAgICAgICogYFBSRVNFUlZFYCA6IFByZXNlcnZlIG9yaWdpbmFsIGBNdGltZWAgKHJlY29tbWVuZGVkKVxuICAgICAgICAgKlxuICAgICAgICAgKiBgTk9ORWAgOiBJZ25vcmUgYE10aW1lYCAuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gSWYgYE10aW1lYCBpcyBzZXQgdG8gYFBSRVNFUlZFYCAsIGBBdGltZWAgbXVzdCBiZSBzZXQgdG8gYEJFU1RfRUZGT1JUYCAuXG4gICAgICAgICAqID5cbiAgICAgICAgICogPiBJZiBgTXRpbWVgIGlzIHNldCB0byBgTk9ORWAgLCBgQXRpbWVgIG11c3QgYWxzbyBiZSBzZXQgdG8gYE5PTkVgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy10YXNrLW9wdGlvbnMuaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1vcHRpb25zLW10aW1lXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtdGltZT86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFNwZWNpZmllcyB3aGV0aGVyIG9iamVjdCB0YWdzIGFyZSBwcmVzZXJ2ZWQgd2hlbiB0cmFuc2ZlcnJpbmcgYmV0d2VlbiBvYmplY3Qgc3RvcmFnZSBzeXN0ZW1zLiBJZiB5b3Ugd2FudCB5b3VyIERhdGFTeW5jIHRhc2sgdG8gaWdub3JlIG9iamVjdCB0YWdzLCBzcGVjaWZ5IHRoZSBgTk9ORWAgdmFsdWUuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQgVmFsdWU6IGBQUkVTRVJWRWBcbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy10YXNrLW9wdGlvbnMuaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1vcHRpb25zLW9iamVjdHRhZ3NcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IG9iamVjdFRhZ3M/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBTcGVjaWZpZXMgd2hldGhlciBkYXRhIGF0IHRoZSBkZXN0aW5hdGlvbiBsb2NhdGlvbiBzaG91bGQgYmUgb3ZlcndyaXR0ZW4gb3IgcHJlc2VydmVkLiBJZiBzZXQgdG8gYE5FVkVSYCAsIGEgZGVzdGluYXRpb24gZmlsZSBmb3IgZXhhbXBsZSB3aWxsIG5vdCBiZSByZXBsYWNlZCBieSBhIHNvdXJjZSBmaWxlIChldmVuIGlmIHRoZSBkZXN0aW5hdGlvbiBmaWxlIGRpZmZlcnMgZnJvbSB0aGUgc291cmNlIGZpbGUpLiBJZiB5b3UgbW9kaWZ5IGZpbGVzIGluIHRoZSBkZXN0aW5hdGlvbiBhbmQgeW91IHN5bmMgdGhlIGZpbGVzLCB5b3UgY2FuIHVzZSB0aGlzIHZhbHVlIHRvIHByb3RlY3QgYWdhaW5zdCBvdmVyd3JpdGluZyB0aG9zZSBjaGFuZ2VzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBTb21lIHN0b3JhZ2UgY2xhc3NlcyBoYXZlIHNwZWNpZmljIGJlaGF2aW9ycyB0aGF0IGNhbiBhZmZlY3QgeW91ciBBbWF6b24gUzMgc3RvcmFnZSBjb3N0LiBGb3IgZGV0YWlsZWQgaW5mb3JtYXRpb24sIHNlZSBbQ29uc2lkZXJhdGlvbnMgd2hlbiB3b3JraW5nIHdpdGggQW1hem9uIFMzIHN0b3JhZ2UgY2xhc3NlcyBpbiBEYXRhU3luY10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLXMzLWxvY2F0aW9uLmh0bWwjdXNpbmctc3RvcmFnZS1jbGFzc2VzKSAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1vcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stb3B0aW9ucy1vdmVyd3JpdGVtb2RlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBvdmVyd3JpdGVNb2RlPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSB2YWx1ZSB0aGF0IGRldGVybWluZXMgd2hpY2ggdXNlcnMgb3IgZ3JvdXBzIGNhbiBhY2Nlc3MgYSBmaWxlIGZvciBhIHNwZWNpZmljIHB1cnBvc2UsIHN1Y2ggYXMgcmVhZGluZywgd3JpdGluZywgb3IgZXhlY3V0aW9uIG9mIHRoZSBmaWxlLiBUaGlzIG9wdGlvbiBzaG91bGQgYmUgc2V0IG9ubHkgZm9yIE5ldHdvcmsgRmlsZSBTeXN0ZW0gKE5GUyksIEFtYXpvbiBFRlMsIGFuZCBBbWF6b24gUzMgbG9jYXRpb25zLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCB3aGF0IG1ldGFkYXRhIGlzIGNvcGllZCBieSBEYXRhU3luYywgc2VlIFtNZXRhZGF0YSBDb3BpZWQgYnkgRGF0YVN5bmNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kYXRhc3luYy9sYXRlc3QvdXNlcmd1aWRlL3NwZWNpYWwtZmlsZXMuaHRtbCNtZXRhZGF0YS1jb3BpZWQpIC5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdCB2YWx1ZTogYFBSRVNFUlZFYFxuICAgICAgICAgKlxuICAgICAgICAgKiBgUFJFU0VSVkVgIDogUHJlc2VydmUgUE9TSVgtc3R5bGUgcGVybWlzc2lvbnMgKHJlY29tbWVuZGVkKS5cbiAgICAgICAgICpcbiAgICAgICAgICogYE5PTkVgIDogSWdub3JlIHBlcm1pc3Npb25zLlxuICAgICAgICAgKlxuICAgICAgICAgKiA+IEFXUyBEYXRhU3luYyBjYW4gcHJlc2VydmUgZXh0YW50IHBlcm1pc3Npb25zIG9mIGEgc291cmNlIGxvY2F0aW9uLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLXRhc2stb3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnMtcG9zaXhwZXJtaXNzaW9uc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcG9zaXhQZXJtaXNzaW9ucz86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgdmFsdWUgdGhhdCBzcGVjaWZpZXMgd2hldGhlciBmaWxlcyBpbiB0aGUgZGVzdGluYXRpb24gdGhhdCBkb24ndCBleGlzdCBpbiB0aGUgc291cmNlIGZpbGUgc3lzdGVtIGFyZSBwcmVzZXJ2ZWQuIFRoaXMgb3B0aW9uIGNhbiBhZmZlY3QgeW91ciBzdG9yYWdlIGNvc3RzLiBJZiB5b3VyIHRhc2sgZGVsZXRlcyBvYmplY3RzLCB5b3UgbWlnaHQgaW5jdXIgbWluaW11bSBzdG9yYWdlIGR1cmF0aW9uIGNoYXJnZXMgZm9yIGNlcnRhaW4gc3RvcmFnZSBjbGFzc2VzLiBGb3IgZGV0YWlsZWQgaW5mb3JtYXRpb24sIHNlZSBbQ29uc2lkZXJhdGlvbnMgd2hlbiB3b3JraW5nIHdpdGggQW1hem9uIFMzIHN0b3JhZ2UgY2xhc3NlcyBpbiBEYXRhU3luY10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLXMzLWxvY2F0aW9uLmh0bWwjdXNpbmctc3RvcmFnZS1jbGFzc2VzKSBpbiB0aGUgKkFXUyBEYXRhU3luYyBVc2VyIEd1aWRlKiAuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQgdmFsdWU6IGBQUkVTRVJWRWBcbiAgICAgICAgICpcbiAgICAgICAgICogYFBSRVNFUlZFYCA6IElnbm9yZSBkZXN0aW5hdGlvbiBmaWxlcyB0aGF0IGFyZW4ndCBwcmVzZW50IGluIHRoZSBzb3VyY2UgKHJlY29tbWVuZGVkKS5cbiAgICAgICAgICpcbiAgICAgICAgICogYFJFTU9WRWAgOiBEZWxldGUgZGVzdGluYXRpb24gZmlsZXMgdGhhdCBhcmVuJ3QgcHJlc2VudCBpbiB0aGUgc291cmNlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLXRhc2stb3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnMtcHJlc2VydmVkZWxldGVkZmlsZXNcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHByZXNlcnZlRGVsZXRlZEZpbGVzPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSB2YWx1ZSB0aGF0IGRldGVybWluZXMgd2hldGhlciBBV1MgRGF0YVN5bmMgc2hvdWxkIHByZXNlcnZlIHRoZSBtZXRhZGF0YSBvZiBibG9jayBhbmQgY2hhcmFjdGVyIGRldmljZXMgaW4gdGhlIHNvdXJjZSBmaWxlIHN5c3RlbSwgYW5kIHJlLWNyZWF0ZSB0aGUgZmlsZXMgd2l0aCB0aGF0IGRldmljZSBuYW1lIGFuZCBtZXRhZGF0YSBvbiB0aGUgZGVzdGluYXRpb24uIERhdGFTeW5jIGRvZXMgbm90IGNvcHkgdGhlIGNvbnRlbnRzIG9mIHN1Y2ggZGV2aWNlcywgb25seSB0aGUgbmFtZSBhbmQgbWV0YWRhdGEuXG4gICAgICAgICAqXG4gICAgICAgICAqID4gQVdTIERhdGFTeW5jIGNhbid0IHN5bmMgdGhlIGFjdHVhbCBjb250ZW50cyBvZiBzdWNoIGRldmljZXMsIGJlY2F1c2UgdGhleSBhcmUgbm9udGVybWluYWwgYW5kIGRvbid0IHJldHVybiBhbiBlbmQtb2YtZmlsZSAoRU9GKSBtYXJrZXIuXG4gICAgICAgICAqXG4gICAgICAgICAqIERlZmF1bHQgdmFsdWU6IGBOT05FYFxuICAgICAgICAgKlxuICAgICAgICAgKiBgTk9ORWAgOiBJZ25vcmUgc3BlY2lhbCBkZXZpY2VzIChyZWNvbW1lbmRlZCkuXG4gICAgICAgICAqXG4gICAgICAgICAqIGBQUkVTRVJWRWAgOiBQcmVzZXJ2ZSBjaGFyYWN0ZXIgYW5kIGJsb2NrIGRldmljZSBtZXRhZGF0YS4gVGhpcyBvcHRpb24gaXNuJ3QgY3VycmVudGx5IHN1cHBvcnRlZCBmb3IgQW1hem9uIEVGUy5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1kYXRhc3luYy10YXNrLW9wdGlvbnMuaHRtbCNjZm4tZGF0YXN5bmMtdGFzay1vcHRpb25zLXByZXNlcnZlZGV2aWNlc1xuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgcHJlc2VydmVEZXZpY2VzPzogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogQSB2YWx1ZSB0aGF0IGRldGVybWluZXMgd2hpY2ggY29tcG9uZW50cyBvZiB0aGUgU01CIHNlY3VyaXR5IGRlc2NyaXB0b3IgYXJlIGNvcGllZCBmcm9tIHNvdXJjZSB0byBkZXN0aW5hdGlvbiBvYmplY3RzLlxuICAgICAgICAgKlxuICAgICAgICAgKiBUaGlzIHZhbHVlIGlzIG9ubHkgdXNlZCBmb3IgdHJhbnNmZXJzIGJldHdlZW4gU01CIGFuZCBBbWF6b24gRlN4IGZvciBXaW5kb3dzIEZpbGUgU2VydmVyIGxvY2F0aW9ucywgb3IgYmV0d2VlbiB0d28gQW1hem9uIEZTeCBmb3IgV2luZG93cyBGaWxlIFNlcnZlciBsb2NhdGlvbnMuIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IGhvdyBEYXRhU3luYyBoYW5kbGVzIG1ldGFkYXRhLCBzZWUgW0hvdyBEYXRhU3luYyBIYW5kbGVzIE1ldGFkYXRhIGFuZCBTcGVjaWFsIEZpbGVzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9zcGVjaWFsLWZpbGVzLmh0bWwpIC5cbiAgICAgICAgICpcbiAgICAgICAgICogRGVmYXVsdCB2YWx1ZTogYE9XTkVSX0RBQ0xgXG4gICAgICAgICAqXG4gICAgICAgICAqIGBPV05FUl9EQUNMYCA6IEZvciBlYWNoIGNvcGllZCBvYmplY3QsIERhdGFTeW5jIGNvcGllcyB0aGUgZm9sbG93aW5nIG1ldGFkYXRhOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIE9iamVjdCBvd25lci5cbiAgICAgICAgICogLSBOVEZTIGRpc2NyZXRpb25hcnkgYWNjZXNzIGNvbnRyb2wgbGlzdHMgKERBQ0xzKSwgd2hpY2ggZGV0ZXJtaW5lIHdoZXRoZXIgdG8gZ3JhbnQgYWNjZXNzIHRvIGFuIG9iamVjdC5cbiAgICAgICAgICpcbiAgICAgICAgICogV2hlbiB5b3UgdXNlIG9wdGlvbiwgRGF0YVN5bmMgZG9lcyBOT1QgY29weSB0aGUgTlRGUyBzeXN0ZW0gYWNjZXNzIGNvbnRyb2wgbGlzdHMgKFNBQ0xzKSwgd2hpY2ggYXJlIHVzZWQgYnkgYWRtaW5pc3RyYXRvcnMgdG8gbG9nIGF0dGVtcHRzIHRvIGFjY2VzcyBhIHNlY3VyZWQgb2JqZWN0LlxuICAgICAgICAgKlxuICAgICAgICAgKiBgT1dORVJfREFDTF9TQUNMYCA6IEZvciBlYWNoIGNvcGllZCBvYmplY3QsIERhdGFTeW5jIGNvcGllcyB0aGUgZm9sbG93aW5nIG1ldGFkYXRhOlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIE9iamVjdCBvd25lci5cbiAgICAgICAgICogLSBOVEZTIGRpc2NyZXRpb25hcnkgYWNjZXNzIGNvbnRyb2wgbGlzdHMgKERBQ0xzKSwgd2hpY2ggZGV0ZXJtaW5lIHdoZXRoZXIgdG8gZ3JhbnQgYWNjZXNzIHRvIGFuIG9iamVjdC5cbiAgICAgICAgICogLSBOVEZTIHN5c3RlbSBhY2Nlc3MgY29udHJvbCBsaXN0cyAoU0FDTHMpLCB3aGljaCBhcmUgdXNlZCBieSBhZG1pbmlzdHJhdG9ycyB0byBsb2cgYXR0ZW1wdHMgdG8gYWNjZXNzIGEgc2VjdXJlZCBvYmplY3QuXG4gICAgICAgICAqXG4gICAgICAgICAqIENvcHlpbmcgU0FDTHMgcmVxdWlyZXMgZ3JhbnRpbmcgYWRkaXRpb25hbCBwZXJtaXNzaW9ucyB0byB0aGUgV2luZG93cyB1c2VyIHRoYXQgRGF0YVN5bmMgdXNlcyB0byBhY2Nlc3MgeW91ciBTTUIgbG9jYXRpb24uIEZvciBpbmZvcm1hdGlvbiBhYm91dCBjaG9vc2luZyBhIHVzZXIgdGhhdCBlbnN1cmVzIHN1ZmZpY2llbnQgcGVybWlzc2lvbnMgdG8gZmlsZXMsIGZvbGRlcnMsIGFuZCBtZXRhZGF0YSwgc2VlIFt1c2VyXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9jcmVhdGUtc21iLWxvY2F0aW9uLmh0bWwjU01CdXNlcikgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBgTk9ORWAgOiBOb25lIG9mIHRoZSBTTUIgc2VjdXJpdHkgZGVzY3JpcHRvciBjb21wb25lbnRzIGFyZSBjb3BpZWQuIERlc3RpbmF0aW9uIG9iamVjdHMgYXJlIG93bmVkIGJ5IHRoZSB1c2VyIHRoYXQgd2FzIHByb3ZpZGVkIGZvciBhY2Nlc3NpbmcgdGhlIGRlc3RpbmF0aW9uIGxvY2F0aW9uLiBEQUNMcyBhbmQgU0FDTHMgYXJlIHNldCBiYXNlZCBvbiB0aGUgZGVzdGluYXRpb24gc2VydmVy4oCZcyBjb25maWd1cmF0aW9uLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLXRhc2stb3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnMtc2VjdXJpdHlkZXNjcmlwdG9yY29weWZsYWdzXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzZWN1cml0eURlc2NyaXB0b3JDb3B5RmxhZ3M/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0YXNrcyBzaG91bGQgYmUgcXVldWVkIGJlZm9yZSBleGVjdXRpbmcgdGhlIHRhc2tzLiBUaGUgZGVmYXVsdCBpcyBgRU5BQkxFRGAgLCB3aGljaCBtZWFucyB0aGUgdGFza3Mgd2lsbCBiZSBxdWV1ZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIElmIHlvdSB1c2UgdGhlIHNhbWUgYWdlbnQgdG8gcnVuIG11bHRpcGxlIHRhc2tzLCB5b3UgY2FuIGVuYWJsZSB0aGUgdGFza3MgdG8gcnVuIGluIHNlcmllcy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbUXVldWVpbmcgdGFzayBleGVjdXRpb25zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZGF0YXN5bmMvbGF0ZXN0L3VzZXJndWlkZS9ydW4tdGFzay5odG1sI3F1ZXVlLXRhc2stZXhlY3V0aW9uKSAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1vcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stb3B0aW9ucy10YXNrcXVldWVpbmdcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHRhc2tRdWV1ZWluZz86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgdmFsdWUgdGhhdCBkZXRlcm1pbmVzIHdoZXRoZXIgRGF0YVN5bmMgdHJhbnNmZXJzIG9ubHkgdGhlIGRhdGEgYW5kIG1ldGFkYXRhIHRoYXQgZGlmZmVyIGJldHdlZW4gdGhlIHNvdXJjZSBhbmQgdGhlIGRlc3RpbmF0aW9uIGxvY2F0aW9uLCBvciB3aGV0aGVyIERhdGFTeW5jIHRyYW5zZmVycyBhbGwgdGhlIGNvbnRlbnQgZnJvbSB0aGUgc291cmNlLCB3aXRob3V0IGNvbXBhcmluZyBpdCB0byB0aGUgZGVzdGluYXRpb24gbG9jYXRpb24uXG4gICAgICAgICAqXG4gICAgICAgICAqIGBDSEFOR0VEYCA6IERhdGFTeW5jIGNvcGllcyBvbmx5IGRhdGEgb3IgbWV0YWRhdGEgdGhhdCBpcyBuZXcgb3IgZGlmZmVyZW50IGZyb20gdGhlIHNvdXJjZSBsb2NhdGlvbiB0byB0aGUgZGVzdGluYXRpb24gbG9jYXRpb24uXG4gICAgICAgICAqXG4gICAgICAgICAqIGBBTExgIDogRGF0YVN5bmMgY29waWVzIGFsbCBzb3VyY2UgbG9jYXRpb24gY29udGVudCB0byB0aGUgZGVzdGluYXRpb24sIHdpdGhvdXQgY29tcGFyaW5nIGl0IHRvIGV4aXN0aW5nIGNvbnRlbnQgb24gdGhlIGRlc3RpbmF0aW9uLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLXRhc2stb3B0aW9ucy5odG1sI2Nmbi1kYXRhc3luYy10YXNrLW9wdGlvbnMtdHJhbnNmZXJtb2RlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB0cmFuc2Zlck1vZGU/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgdXNlciBJRCAoVUlEKSBvZiB0aGUgZmlsZSdzIG93bmVyLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0IHZhbHVlOiBgSU5UX1ZBTFVFYFxuICAgICAgICAgKlxuICAgICAgICAgKiBgSU5UX1ZBTFVFYCA6IFByZXNlcnZlIHRoZSBpbnRlZ2VyIHZhbHVlIG9mIHRoZSBVSUQgYW5kIGdyb3VwIElEIChHSUQpIChyZWNvbW1lbmRlZCkuXG4gICAgICAgICAqXG4gICAgICAgICAqIGBOQU1FYCA6IEN1cnJlbnRseSBub3Qgc3VwcG9ydGVkXG4gICAgICAgICAqXG4gICAgICAgICAqIGBOT05FYCA6IElnbm9yZSB0aGUgVUlEIGFuZCBHSUQuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1vcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stb3B0aW9ucy11aWRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHVpZD86IHN0cmluZztcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgdmFsdWUgdGhhdCBkZXRlcm1pbmVzIHdoZXRoZXIgYSBkYXRhIGludGVncml0eSB2ZXJpZmljYXRpb24gaXMgcGVyZm9ybWVkIGF0IHRoZSBlbmQgb2YgYSB0YXNrIGV4ZWN1dGlvbiBhZnRlciBhbGwgZGF0YSBhbmQgbWV0YWRhdGEgaGF2ZSBiZWVuIHRyYW5zZmVycmVkLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDb25maWd1cmUgdGFzayBzZXR0aW5nc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2RhdGFzeW5jL2xhdGVzdC91c2VyZ3VpZGUvY3JlYXRlLXRhc2suaHRtbCkgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBEZWZhdWx0IHZhbHVlOiBgUE9JTlRfSU5fVElNRV9DT05TSVNURU5UYFxuICAgICAgICAgKlxuICAgICAgICAgKiBgT05MWV9GSUxFU19UUkFOU0ZFUlJFRGAgKHJlY29tbWVuZGVkKTogUGVyZm9ybSB2ZXJpZmljYXRpb24gb25seSBvbiBmaWxlcyB0aGF0IHdlcmUgdHJhbnNmZXJyZWQuXG4gICAgICAgICAqXG4gICAgICAgICAqIGBQT0lOVF9JTl9USU1FX0NPTlNJU1RFTlRgIDogU2NhbiB0aGUgZW50aXJlIHNvdXJjZSBhbmQgZW50aXJlIGRlc3RpbmF0aW9uIGF0IHRoZSBlbmQgb2YgdGhlIHRyYW5zZmVyIHRvIHZlcmlmeSB0aGF0IHRoZSBzb3VyY2UgYW5kIGRlc3RpbmF0aW9uIGFyZSBmdWxseSBzeW5jaHJvbml6ZWQuIFRoaXMgb3B0aW9uIGlzbid0IHN1cHBvcnRlZCB3aGVuIHRyYW5zZmVycmluZyB0byBTMyBHbGFjaWVyIG9yIFMzIEdsYWNpZXIgRGVlcCBBcmNoaXZlIHN0b3JhZ2UgY2xhc3Nlcy5cbiAgICAgICAgICpcbiAgICAgICAgICogYE5PTkVgIDogTm8gYWRkaXRpb25hbCB2ZXJpZmljYXRpb24gaXMgZG9uZSBhdCB0aGUgZW5kIG9mIHRoZSB0cmFuc2ZlciwgYnV0IGFsbCBkYXRhIHRyYW5zbWlzc2lvbnMgYXJlIGludGVncml0eS1jaGVja2VkIHdpdGggY2hlY2tzdW0gdmVyaWZpY2F0aW9uIGR1cmluZyB0aGUgdHJhbnNmZXIuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay1vcHRpb25zLmh0bWwjY2ZuLWRhdGFzeW5jLXRhc2stb3B0aW9ucy12ZXJpZnltb2RlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB2ZXJpZnlNb2RlPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBPcHRpb25zUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE9wdGlvbnNQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5UYXNrX09wdGlvbnNQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2F0aW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmF0aW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdieXRlc1BlclNlY29uZCcsIGNkay52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5ieXRlc1BlclNlY29uZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZ2lkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmdpZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbG9nTGV2ZWwnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubG9nTGV2ZWwpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ210aW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm10aW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdvYmplY3RUYWdzJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm9iamVjdFRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ292ZXJ3cml0ZU1vZGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMub3ZlcndyaXRlTW9kZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncG9zaXhQZXJtaXNzaW9ucycsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wb3NpeFBlcm1pc3Npb25zKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVzZXJ2ZURlbGV0ZWRGaWxlcycsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wcmVzZXJ2ZURlbGV0ZWRGaWxlcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncHJlc2VydmVEZXZpY2VzJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnByZXNlcnZlRGV2aWNlcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlEZXNjcmlwdG9yQ29weUZsYWdzJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNlY3VyaXR5RGVzY3JpcHRvckNvcHlGbGFncykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFza1F1ZXVlaW5nJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnRhc2tRdWV1ZWluZykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndHJhbnNmZXJNb2RlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnRyYW5zZmVyTW9kZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndWlkJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnVpZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmVyaWZ5TW9kZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52ZXJpZnlNb2RlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIk9wdGlvbnNQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6RGF0YVN5bmM6OlRhc2suT3B0aW9uc2AgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgT3B0aW9uc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6VGFzay5PcHRpb25zYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblRhc2tPcHRpb25zUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblRhc2tfT3B0aW9uc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBBdGltZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5hdGltZSksXG4gICAgICAgIEJ5dGVzUGVyU2Vjb25kOiBjZGsubnVtYmVyVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmJ5dGVzUGVyU2Vjb25kKSxcbiAgICAgICAgR2lkOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmdpZCksXG4gICAgICAgIExvZ0xldmVsOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmxvZ0xldmVsKSxcbiAgICAgICAgTXRpbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubXRpbWUpLFxuICAgICAgICBPYmplY3RUYWdzOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm9iamVjdFRhZ3MpLFxuICAgICAgICBPdmVyd3JpdGVNb2RlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm92ZXJ3cml0ZU1vZGUpLFxuICAgICAgICBQb3NpeFBlcm1pc3Npb25zOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBvc2l4UGVybWlzc2lvbnMpLFxuICAgICAgICBQcmVzZXJ2ZURlbGV0ZWRGaWxlczogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wcmVzZXJ2ZURlbGV0ZWRGaWxlcyksXG4gICAgICAgIFByZXNlcnZlRGV2aWNlczogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5wcmVzZXJ2ZURldmljZXMpLFxuICAgICAgICBTZWN1cml0eURlc2NyaXB0b3JDb3B5RmxhZ3M6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2VjdXJpdHlEZXNjcmlwdG9yQ29weUZsYWdzKSxcbiAgICAgICAgVGFza1F1ZXVlaW5nOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnRhc2tRdWV1ZWluZyksXG4gICAgICAgIFRyYW5zZmVyTW9kZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50cmFuc2Zlck1vZGUpLFxuICAgICAgICBVaWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudWlkKSxcbiAgICAgICAgVmVyaWZ5TW9kZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy52ZXJpZnlNb2RlKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuVGFza09wdGlvbnNQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblRhc2suT3B0aW9uc1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblRhc2suT3B0aW9uc1Byb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnYXRpbWUnLCAnQXRpbWUnLCBwcm9wZXJ0aWVzLkF0aW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLkF0aW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdieXRlc1BlclNlY29uZCcsICdCeXRlc1BlclNlY29uZCcsIHByb3BlcnRpZXMuQnl0ZXNQZXJTZWNvbmQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0TnVtYmVyKHByb3BlcnRpZXMuQnl0ZXNQZXJTZWNvbmQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2dpZCcsICdHaWQnLCBwcm9wZXJ0aWVzLkdpZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5HaWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2xvZ0xldmVsJywgJ0xvZ0xldmVsJywgcHJvcGVydGllcy5Mb2dMZXZlbCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Mb2dMZXZlbCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbXRpbWUnLCAnTXRpbWUnLCBwcm9wZXJ0aWVzLk10aW1lICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk10aW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdvYmplY3RUYWdzJywgJ09iamVjdFRhZ3MnLCBwcm9wZXJ0aWVzLk9iamVjdFRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuT2JqZWN0VGFncykgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnb3ZlcndyaXRlTW9kZScsICdPdmVyd3JpdGVNb2RlJywgcHJvcGVydGllcy5PdmVyd3JpdGVNb2RlICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLk92ZXJ3cml0ZU1vZGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Bvc2l4UGVybWlzc2lvbnMnLCAnUG9zaXhQZXJtaXNzaW9ucycsIHByb3BlcnRpZXMuUG9zaXhQZXJtaXNzaW9ucyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Qb3NpeFBlcm1pc3Npb25zKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwcmVzZXJ2ZURlbGV0ZWRGaWxlcycsICdQcmVzZXJ2ZURlbGV0ZWRGaWxlcycsIHByb3BlcnRpZXMuUHJlc2VydmVEZWxldGVkRmlsZXMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUHJlc2VydmVEZWxldGVkRmlsZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ByZXNlcnZlRGV2aWNlcycsICdQcmVzZXJ2ZURldmljZXMnLCBwcm9wZXJ0aWVzLlByZXNlcnZlRGV2aWNlcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5QcmVzZXJ2ZURldmljZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3NlY3VyaXR5RGVzY3JpcHRvckNvcHlGbGFncycsICdTZWN1cml0eURlc2NyaXB0b3JDb3B5RmxhZ3MnLCBwcm9wZXJ0aWVzLlNlY3VyaXR5RGVzY3JpcHRvckNvcHlGbGFncyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TZWN1cml0eURlc2NyaXB0b3JDb3B5RmxhZ3MpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Rhc2tRdWV1ZWluZycsICdUYXNrUXVldWVpbmcnLCBwcm9wZXJ0aWVzLlRhc2tRdWV1ZWluZyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5UYXNrUXVldWVpbmcpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3RyYW5zZmVyTW9kZScsICdUcmFuc2Zlck1vZGUnLCBwcm9wZXJ0aWVzLlRyYW5zZmVyTW9kZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5UcmFuc2Zlck1vZGUpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3VpZCcsICdVaWQnLCBwcm9wZXJ0aWVzLlVpZCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5VaWQpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ZlcmlmeU1vZGUnLCAnVmVyaWZ5TW9kZScsIHByb3BlcnRpZXMuVmVyaWZ5TW9kZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WZXJpZnlNb2RlKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuVGFzayB7XG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBzY2hlZHVsZSB5b3Ugd2FudCB5b3VyIHRhc2sgdG8gdXNlIGZvciByZXBlYXRlZCBleGVjdXRpb25zLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtTY2hlZHVsZSBFeHByZXNzaW9ucyBmb3IgUnVsZXNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BbWF6b25DbG91ZFdhdGNoL2xhdGVzdC9ldmVudHMvU2NoZWR1bGVkRXZlbnRzLmh0bWwpIC5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWRhdGFzeW5jLXRhc2stdGFza3NjaGVkdWxlLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFRhc2tTY2hlZHVsZVByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEEgY3JvbiBleHByZXNzaW9uIHRoYXQgc3BlY2lmaWVzIHdoZW4gQVdTIERhdGFTeW5jIGluaXRpYXRlcyBhIHNjaGVkdWxlZCB0cmFuc2ZlciBmcm9tIGEgc291cmNlIHRvIGEgZGVzdGluYXRpb24gbG9jYXRpb24uXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZGF0YXN5bmMtdGFzay10YXNrc2NoZWR1bGUuaHRtbCNjZm4tZGF0YXN5bmMtdGFzay10YXNrc2NoZWR1bGUtc2NoZWR1bGVleHByZXNzaW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBzY2hlZHVsZUV4cHJlc3Npb246IHN0cmluZztcbiAgICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgVGFza1NjaGVkdWxlUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhc2tTY2hlZHVsZVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblRhc2tfVGFza1NjaGVkdWxlUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzY2hlZHVsZUV4cHJlc3Npb24nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuc2NoZWR1bGVFeHByZXNzaW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzY2hlZHVsZUV4cHJlc3Npb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2NoZWR1bGVFeHByZXNzaW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlRhc2tTY2hlZHVsZVByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6VGFzay5UYXNrU2NoZWR1bGVgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFRhc2tTY2hlZHVsZVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpEYXRhU3luYzo6VGFzay5UYXNrU2NoZWR1bGVgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuVGFza1Rhc2tTY2hlZHVsZVByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5UYXNrX1Rhc2tTY2hlZHVsZVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBTY2hlZHVsZUV4cHJlc3Npb246IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2NoZWR1bGVFeHByZXNzaW9uKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuVGFza1Rhc2tTY2hlZHVsZVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuVGFzay5UYXNrU2NoZWR1bGVQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5UYXNrLlRhc2tTY2hlZHVsZVByb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2NoZWR1bGVFeHByZXNzaW9uJywgJ1NjaGVkdWxlRXhwcmVzc2lvbicsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU2NoZWR1bGVFeHByZXNzaW9uKSk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG4iXX0=