#!/usr/bin/env python3

from setuptools import setup, find_packages

with open("README.md", "r") as f:
    long_description = f.read()

setup(
    name="pyhOn",
    version="0.5.0",
    author="Andre Basche",
    description="Control hOn devices with python",
    long_description=long_description,
    long_description_content_type='text/markdown',
    project_urls={
        "GitHub": "https://github.com/Andre0512/pyhOn",
        "PyPI": "https://pypi.org/project/pyhOn",
    },
    license="MIT",
    platforms="any",
    packages=find_packages(),
    include_package_data=True,
    python_requires=">=3.10",
    install_requires=["aiohttp"],
    classifiers=[
        "Development Status :: 4 - Beta",
        "Environment :: Console",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    entry_points={
        'console_scripts': [
            'pyhOn = pyhon.__main__:start',
        ]
    }
)
